/* eslint-disable */
var MARKDOWN_TOC_DATA = [
  {
    "gid": 1,
    "name": "intro",
    "label": "Introduction",
    "children": [
      {
        "cid": 1,
        "sid": "1introduce",
        "name": "1introduce",
        "label": "시작하기",
        "data": {
          "body": "좌측 검색창을 통해 각 함수,프로퍼티를 쉽게 검색할 수 있습니다. <video poster=\"../../assets/imgs/manual.png\" id=\"videoClip\" loop autoplay controls> <source src=\"../../assets/imgs/IBSheet8Manual.mp4\" type=\"video/mp4\"> Sorry, your browser doesn't support embedded videos. </video> [<span style='color:orange;font-weight:700'>상단</span> : 함수/이벤트 명 검색 , <span style='color:orange;font-weight:700'>하단</span> : 컨텐츠 전체 검색] <hr> <div style=\"margin-top:10px;width:90vw;display:flex;flex-direction:row;justify-content:space-between\"> <div> <h3 style=\"\">기본 기능</h3> <ul> <li><a href=\"https://portal.ibsheet.com/support/solutions/articles/72000639119-ibsheet-%ED%99%94%EB%A9%B4%EC%97%90-%EA%B7%B8%EB%A6%AC%EA%B8%B0\" target=\"_blank\">시작하기</a></li> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/intro/files.html')\">파일 구성</a></li> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/start/basic-structure.html')\">초기화 객체 기본 구조</a></li> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/dataStructure/1data-structure.html')\">조회/저장 데이터 구조</a></li> </ul> </div> <div> <h3>행/열 기능</h3> <ul> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/start/row.html')\">행 구조</a></li> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/start/col.html')\">열 구조</a></li> </ul> </div> <div> <h3>기타 기능</h3> <ul> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/appx/ibsheet7-migration.html')\">ibsheet7 마이그레이션</a></li> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/appx/spa-react.html')\">react 기반 개발</a></li> <li><a href=\"#\" onclick=\"window.event.preventDefault();window.event.stopPropagation();gotoByURL('docs/appx/spa-vue.html')\">vue 기반 개발</a></li> </ul> </div> </div>"
        },
        "url": "docs/intro/1introduce.html"
      },
      {
        "cid": 2,
        "sid": "feature",
        "name": "feature",
        "label": "제품의 특징",
        "data": {
          "body": "`IBSheet 8`은 순수 javascript 기반의 **데이터 그리드 컨트롤 컴포넌트**로 사용자 PC에 어떠한 설치 없이 `HTML, javascript, CSS`만을 이용하여 윈도우 어플리케이션에서 볼 수 있는 데이터 그리드의 다양한 기능을 제공합니다. ## 주요한 제품의 기능 ### 데이터 조회 기능 ajax 통신으로 통해 서버로부터 가져온 JSON 데이터를 파싱하여 클라이언트 화면에 로딩 합니다. 데이터를 로딩하는 방법에 따라 `lazyload, fastload` 등 다양한 형식으로 데이터 렌더링 기능을 제공합니다. ### *소팅 기능* 헤더 셀을 클릭하거나 제공되는 API를 통해 단일열 뿐 아니라 여러개 열에 대해 동시에 소팅하실 수 있습니다. 또한 열이나 각 셀의 데이터에 따라 숫자형식의 소팅, 문자형식의 소팅, 소팅 제외 등을 설정하실 수 있습니다. ![다중열소트](/assets/imgs/sort.png \"여러개 열에 대한 소팅\") [**여러개 열에 대한 소팅 예**] ### *틀고정 및 행고정 기능* 그리드의 좌/우측에 원하는 열만큼을 고정하여 볼 수 있는 기능을 제공합니다. 또한 데이터 상단 혹은 하단에 일부 행을 고정하여 원하는 데이터를 설정하여 사용하실 수도 있습니다. ![틀고정기능](/assets/imgs/section.png \"좌우측 틀고정 기능\") [**좌/우측 열에 대한 틀고정 예**] ### *필터링 기능* 헤더 아래 필터행을 통해 사용자가 조회 된 데이터 중에 찾고자 하는 내용을 필터링 하여 볼 수 있는 기능을 제공합니다. 한 셀 안에서 and나 or 조건을 통해 필터링 하거나 여러개 열간에 and나 or 조건을 통해 필터링 하실 수 있습니다. ![필터기능](/assets/imgs/filter.png \"필터행을 통한 필터링\") [**필터행을 통한 필터링 예**] ### *다양한 데이터 유형 및 유효성검사 기능* 그리드 내에 날짜 열이나, 숫자 입력 열, 마스킹 기능 등을 통해 다양한 데이터 입력 및 유효성 체크가 가능합니다. 또한 Html 형식의 셀을 통해 셀 안에 원하시는 `Html` 구문을 표현하실 수도 있습니다. ### *상태 관리 및 저장 기능* 조회된 데이터 내에서 사용자가 수정한 행이나 셀에 대한 정보를 관리하여, 최종 저장시 수정된 데이터만 서버측으로 전송하는 기능을 제공합니다. 신규로 추가되거나 수정된 데이터, 삭제될 데이터 행에 대에서는 각기 다른 배경색으로 표시되어 사용자의 시인성을 높였습니다. ### *합계 및 Formula 기능* 열 전체 데이터의 합계를 합계행에 표시하거나, 열에 다른 열간의 계산로직을 설정함으로써 열 내에 다양한 계산값이나 기능을 설정할 수 있습니다. ### *다양한 import/export 기능* `엑셀, text, pdf` 등의 파일형식으로 데이터를 다운로드 하거나, `엑셀, csv, text` 파일을 업로드 하는 기능을 제공합니다. ### *그룹핑 기능* 사용자가 드래그를 통해 조회된 데이터를 그룹지어 보거나, 그룹된 데이터 내에서 소계 등의 계산 결과를 확인 하실 수 있습니다. ![그룹기능](/assets/imgs/groupRow.png \"그룹핑 기능\") [**특정 열을 기준으로 그룹핑 예**] ### *트리 기능* 그리드 내에 특정 열을 트리로 지정함으로써 데이터 간에 상하위 관계를 표현할 수 있습니다. 트리로 구성된 데이터는 부모/자식 간의 관계에 대한 여러가지 API를 사용하실 수 있습니다. ![트리사용](/assets/imgs/tree.png \"트리사용\") [**트리사용 예**] ### *피벗 기능* 피벗 다이얼로그를 통해 사용자가 피벗팅 할 데이터를 구성하고, 계산 결과를 확인하실 수 있습니다. ### *자동 머지 기능* 헤더 영역이나 데이터 영역 내에서 인접한 셀간에 같은 값을 갖을때 자동으로 병합하는 기능을 제공합니다. 또한 셀의 내용과 무관하게 특정 영역을 병합하여 보여주는 것도 가능합니다. ![머지 기능](/assets/imgs/dataMerge3.png \"머지 기능\") [**입력된 글자를 기준으로 자동 셀 병합**] ### *열의 너비, 위치 변경 기능* 사용자가 헤더 셀에서 Drag & Drop을 통해 열의 너비를 변경하거나 열의 위치를 수정하실 수 있습니다. 또한 이렇게 변경된 시트의 정보(열의 위치, 너비, 보임여부)는 사용자 브라우저에 저장되어 추후 해당화면에 다시 접속시 기존에 설정한 모습대로 보여지게 하실 수도 있습니다. ![열이동](/assets/imgs/colDragMove.png \"열이동\") [**드래그를 통한 열 위치 이동**] ### *페이징 조회 기능* 대량의 데이터가 조회되었을때 페이지 단위로 나눠서 보여주는 기능을 제공합니다. 페이징 조회 기능 사용시에는 시트 하단에 페이지네이션을 이용하여 원하는 페이지로 이동하실 수 있습니다. ### *선택 영역에 대한 copy & paste 기능* 그리드 내에서 드래그시 원하는 영역을 선택할 수 있고, 이를 `ctrl+c`를 통해 클립보드로 복사하거나 클립보드의 내용을 그리드 내부에 `ctrl+v`를 통해 붙여넣기 하는 기능을 제공합니다. ### *프린팅 기능* 그리드의 내용과 더불어 타이틀이나, 조회 조건등의 내용을 같이 인쇄하는 기능을 제공합니다. 인쇄시 각 페이지에서 그리드의 타이틀(그리드 상단의 타이틀(페이지 타이틀 설정 가능) 및 헤더 타이틀)이 반복적으로 보여지는 등의 기능을 제공합니다. ### *자동완성기능* 특정 열에 입력가능한 데이터 집합을 설정해 두고, 사용자가 입력하는 글자에 따라 가능한 경우의 문자열이 보여지게끔 하는 기능을 제공합니다. ![자동완성기능](/assets/imgs/suggest.gif \"자동완성기능\") [**자동완성기능 예**] ### *Drag & Drop 기능* 행이나 셀을 Drag하여 다른 시트에 복사하거나 이동하실 수 있습니다. ![드래그드롭](/assets/imgs/drag1.png \"드래그드롭\") [**시트간 행이동**] ### *힌트 및 풍선 도움말 기능* 열의 너비가 부족하여 셀안의 모든 내용이 보여지지 않을 때, 마우스커서가 올라간 셀에 한하여 풍선 도움말을 표시하거나 셀의 크기를 임시적으로 늘려 보여주는 기능을 제공합니다. ![힌트기능](/assets/imgs/hint1.png \"힌트기능\") [**힌트기능 예**] ### *컨텍스트 메뉴 기능* 시트 내에서 마우스 우측버튼 클릭시 다양한 기능의 컨텍스트 메뉴를 구성하여 사용하실 수 있습니다. ![컨텍스트메뉴기능](/assets/imgs/menuIcon.png \"컨텍스트메뉴기능\") [**컨텍스트 메뉴 기능 예**]"
        },
        "url": "docs/intro/feature.html"
      },
      {
        "cid": 3,
        "sid": "files",
        "name": "files",
        "label": "파일 구성",
        "data": {
          "body": "## ibsheet8 제품은 다음과 같은 파일,폴더로 구성되어 있습니다. ``` ibsheet 최상위 폴더 ├─ ibsheet.js // ibsheet 코어파일 (기본) ├─ ibleaders.js // 라이선스 파일 (기본) │ ├─ css // CSS 폴더 │ ├─ default/main.css // 기본 테마 css 파일 (기본) │ ├─ meterial/main.css // meterial 테마 css 파일 │ ├─ simple/main.css // simple 테마 css 파일 │ ├─ mint/main.css // mint 테마 css 파일 │ └─ grace/main.css // grace 테마 css 파일 │ ├─ loacle // 다국어 메세지 폴더 │ ├─ ko.js // 한국어 메세지 파일 (기본) │ └─ en.js // 영어 메세지 파일 │ ├─ fonts // ibsheet가 사용하는 폰트(.ttf, .otf)를 담고 있는 폴더 │ └─ plugins // 별도 기능 추가 폴더 ├─ ibsheet-common.js // 공통 기능 설정을 위한 상수 및 함수를 정의한 파일 ├─ ibsheet-dialog.js // 찾기, 다운로드, 편집 등 각종 다이얼로그 기능을 정의한 파일 └─ ibsheet-excel.js // 파일 import/export 기능과 관련된 함수가 정의된 파일 ``` ## 각 파일의 기능은 아래와 같습니다. ### *ibleaders.js* `제품 라이선스`를 담고 있는 파일로 내용은 다음과 같습니다. ```javascript var ibleaders = ibleaders || {}; ibleaders.license = \"W2FtSztPKCBzbD8emM5ZzV7fAQnTXcJYS4gLHA0bXp0PTx1EGsBbEA6NicldTx+aXx0MG0IbRZ8HD1uL3srbz=\"; ``` ### *ibsheet.js* 제품의 코어 파일로 안의 내용은 **`절대 수정하시면 안됩니다`.** 파일 상단에 제품에 대한 버전 정보가 있습니다. ### *css(folder)* 시트에서 사용하는 css파일(`/css/default/main.css`)이 해당 폴더에 들어있습니다. **`css 폴더 구조 변경 안됩니다`.** ibsheet.js 와 같은 경로에 css 폴더가 존재 해야 합니다. <!-- ### *css/compatible(folder)* - IE9 이하 브라우저 전용 css 시트에서 보여지는 아이콘(달력이나 체크박스 등)은 기본적으로 base64 이미지(문자화 된 SVG 이미지 스트링)를 사용하지만 `gif` 파일을 이용하는 경우 이미지 아이콘과 css 파일(`/css/compatible/light/main.css`)이 해당 폴더에 들어있습니다. --> ### *locale(folder)* 시트 내부에서 사용하는 여러가지 상수와 시트 사용자가 보게 되는 메세지가 정의 되어 있습니다. * 한글: `/locale/ko.js` * 영문: `/locale/en.js` ### *fonts(folder)* 시트에서 사용하는 폰트파일(`.ttf, .otf`)이 들어있습니다. --- ### *plugins(folder)* 선택적으로 필요한 기능을 추가할 수 있는 js 파일들이 들어 있습니다. |파일명|Description| |-----|-----| |`ibsheet-common.js`|모든 화면 시트에 공통으로 적용하고 싶은 기능에 대한 설정이나 열의 기능일 미리 정의해 둔 Preset 변수를 담고 있습니다. 사용자는 이를 알맞게 수정하여 사용할 수 있습니다.| |`ibsheet-excel.js`|엑셀다운로드/업로드,텍스트 다운로드/업로드와 관련된 기능이 포함되어있는 javascript 파일입니다. `down2Excel()`, `loadExcel()`함수를 사용하시려면 이 파일이 항상 `ibsheet.js` 파일 이후에 include 되어야 합니다. 도움말 `Method` >> `Excel Plugin` 함수 호출시 필요 합니다. ![ibsheet-excel](/assets/imgs/ibsheet-excel.png \"ibsheet-excel\")| |`ibsheet-dialog.js`|찾기 다이얼로그(ctrl+shift+f), 상세보기 다이얼로그, 피벗 다이얼로그 등 시트에서 사용 가능한 다양한 다이얼로그에 대한 플러그인을 담고 있습니다. 사용자는 이를 알맞게 수정하여 사용할 수 있습니다. 도움말 `Method` >> `Dialog Plugin` 함수 호출시 필요 합니다. ![ibsheet-dialog](/assets/imgs/ibsheet-dialog.png \"ibsheet-dialog\")|"
        },
        "url": "docs/intro/files.html"
      }
    ]
  },
  {
    "gid": 2,
    "name": "start",
    "label": "Getting Started",
    "children": [
      {
        "cid": 6,
        "sid": "quick-start",
        "name": "quick-start",
        "label": "Quick Start",
        "data": {
          "body": "## ibsheet 파일 구성 `IBSheet8`을 사용하기 위해서 다음 4~7가지 파일을 추가합니다. ```html <!----- ibsheet 기본 모듈 -----> <!-- 디자인 css --> <link rel=\"stylesheet\" type=\"text/css\" href=\"ibsheet/css/default/main.css\"> <!-- 시트 코어 파일 --> <script src=\"ibsheet/ibsheet.js\"></script> <!-- 라이선스 파일 --> <script src=\"ibsheet/ibleaders.js\"></script> <!-- 메세지 파일 ko.js 나 en.js 중 하나 추가 --> <script src=\"ibsheet/locale/ko.js\"></script> <!----- ibsheet 선택 모듈 -----> <!-- 엑셀 다운/업로드 관련 모듈 --> <script src=\"ibsheet/plugins/ibsheet-excel.js\"></script> <!-- 찾기,상세보기 등 다이얼로그 관련 모듈 --> <script src=\"ibsheet/plugins/ibsheet-dialog.js\"></script> <!-- 공통 속성 관련 모듈 --> <script src=\"ibsheet/plugins/ibsheet-common.js\"></script> ``` ## 시트 생성 이 후 열의 개수와 기능, 헤더 타이틀과 같은 정보를 설정하고 **[IBSheet.create()](/docs/static/create)** 함수를 통해 객체를 생성합니다. *초기 생성시 **시트의 너비, 높이**는 el 속성에서 정의하는 **div객체의 너비, 높이**를 따르며, <mark>*해당 div에 너비, 높이가 **없는 경우*** 너비는 **100%**, 높이는 **800px**를 기본값으로 갖습니다.</mark>* [자바스크립트 구문] ```javascript function initSheet() { //시트의 초기화 속성 설정 var OPT = { //각 열에 대한 정의 (열의 이름, 유형(Type), 포맷(Format)등을 설정) //열의 \"Type\"과 \"Name\" 속성은 반드시 설정되어야 합니다. Cols:[ {Header: \"컬럼1\", Name: \"colName1\", Type: \"Text\"}, {Header: \"컬럼2\", Name: \"colName2\", Type: \"Text\", Align: \"center\"} ] }; //초기 데이터 설정 var DATA = []; IBSheet.create({ id: \"sheet\", // 시트 객체 ID el: \"sheetDiv\", // 시트를 생성할 DIV객체 ID options: OPT, // 초기화 구문 변수 data: DATA // 초기 로딩 데이터 }); } ``` [HTML 구문 - 시트 높이 고정] ```html <body onload=\"initSheet()\"> <div class=\"btnCls\"> <button type=\"button\" class=\"mainBtnB\">조회</button> <button type=\"button\" class=\"mainBtnB\">신규</button> </div> <hr> <!-- 시트가 될 DIV 객체 --> <div id=\"sheetDiv\" style=\"width:100%; height:500px;\"></div> </body> ``` [HTML 구문 - 시트 부모 요소 높이 고정] ```html <body onload=\"initSheet()\"> <div class=\"btnCls\"> <button type=\"button\" class=\"mainBtnB\">조회</button> <button type=\"button\" class=\"mainBtnB\">신규</button> </div> <hr> <!-- 시트의 부모 요소 --> <div style=\"width:100%; height:600px;\"> <!-- 시트가 될 DIV 객체 --> <div id=\"sheetDiv\" style=\"width:100%; height:100%;\"></div> </div> </body> ``` **시트의 높이를 100% 등 상대값으로 생성할 경우 부모 요소의 높이가 고정되어 있어야합니다.** <mark>**시트의 높이는 고정된 행(헤더,필터,합계 행등)이 모두 보여질 정도로 설정 되어야 합니다.** 이는 보통 150~200px 정도이며 이보다 작게 설정한 경우에는 시트가 생성되지 않을 수 있습니다.</mark> *`options` 와 `data` 는 [시트객체구조](/docs/start/basic-structure)를 참고하세요.* ![시트생성](/assets/imgs/quickStart1.png \"시트 간단 생성\") [그림 1] 생성된 ibsheet ## 시트 초기화 및 열 설정 [IBSheet.create()](/docs/static/create) 함수의 `options`를 통해 시트의 헤더, 행, 열 등에 대한 자세한 부분을 설정할 수 있습니다. ```javascript var OPT = { //각 열에 대한 정의 (열의 이름, 유형(Type), 포맷(Format)등을 설정) Cols:[ { Header: \"이름\", Name: \"sa_nm\", Type: \"Text\" }, { Header: \"사원번호\", Name: \"sa_id\", Type: \"Text\", Align: \"center\" }, { Header: \"부서\", Name: \"sa_dept\", Type: \"Enum\", Enum: \"|경영지원|총무|인사|설계|시공1|시공2\", EnumKeys: \"|01|02|03|04|05|06\" }, { Header: \"직급\", Name: \"sa_position\", Type: \"Enum\", Enum: \"|대표|상무|이사|부장|차장|과장|대리|사원\", EnumKeys: \"|A1|A2|A3|B0|B1|C4|C5|C6\" }, { Header: \"입사일\", Name: \"sa_enterdate\", Type: \"Date\", Width:100, Format: \"yyyy/MM/dd\", }, { Header: \"비고\", Name: \"sa_desc\", Type: \"Lines\" } ] }; ``` ![시트생성2](/assets/imgs/quickStart2.png \"시트생성2\") [그림 2] 열 설정이 적용된 `ibsheet` 두 줄 이상의 헤더를 생성하거나 헤더 안에 셀간 병합을 설정하는 방법은 [(col)Header](/docs/props/col/header)속성을 참고해 주세요. [IBSheet.create](/docs/static/create)의 data를 설정하면 시트를 생성하는 것과 동시에 데이터를 로딩할 수 있습니다. ```javascript var DATA = [ {\"sa_nm\": \"홍길동\", \"sa_id\": \"9821450\", \"sa_dept\": \"04\", \"sa_position\": \"B0\", \"sa_enterdate\": \"19980305\", \"sa_desc\": \"\"}, {\"sa_nm\": \"김한국\", \"sa_id\": \"9510427\", \"sa_dept\": \"01\", \"sa_position\": \"A3\", \"sa_enterdate\": \"19890317\", \"sa_desc\": \"\"} ]; ``` ![시트생성3](/assets/imgs/quickStart3.png \"시트생성3\") [그림 3] 데이터가 로드된 `ibsheet` 사용자 입력에 의한 조회가 필요하면 시트를 생성 후, [loadSearchData()](/docs/funcs/core/load-search-data) 나 [doSearch()](/docs/funcs/core/do-search) API 를 이용하면 됩니다. <div class='notice'> ### 주의 시트 생성 함수 [IBSheet.create()](/docs/static/create)는 비동기 형식으로 동작함으로 생성 직후에 시트의 기능 함수를 호출시 오류가 발생할 수 있습니다. ```javascript //시트 생성 함수 IBSheet.create({ ... }); //비동기적으로 생성됨으로 \"sheet\"객체가 생성되었는지 알 수 없다. sheet.showFilterRow(); //onRenderFirstFinish 이벤트에서 호출하거나 options.Cfg.ShowFilter: true로 설정하면 시트 생성과 동시에 필터행이 보여집니다. ``` 따라서 시트 생성 후 필요한 함수를 호출하시려면 [onRenderFirstFinish](/docs/events/on-render-first-finish) 이벤트에 로직을 구성하셔야 합니다. </div> ## 각종 기능 사용의 예 [아이비시트 메소드 사용법](/docs/funcs/method) ### **행추가** [addRow()](/docs/funcs/core/add-row) 함수를 통해 신규 행을 추가할 수 있습니다. ```javascript //선택행 행 위로 새로운 행을 추가합니다. sheet.addRow(sheet.getFocusedRow(), 1); ``` ### **데이터 로드** [loadSearchData()](/docs/funcs/core/load-search-data) 함수를 통해 데이터를 로딩할 수 있습니다. ```javascript //jquery를 이용한 ajax 통신 $.ajax({ url: \"./data.jsp\", param: \"edate=19950101&position=C1\", success: function (rtnData) { //서버에서 가져온 json데이터를 로딩 sheet.loadSearchData(rtnData); } }); ``` [doSearch()](/docs/funcs/core/do-search) 함수를 통해 url에서 데이터를 로딩할 수 있습니다. 조회된 데이터라 로딩 완료 후 ```javascript //ajax 통신 및 데이터 로드 sheet.doSearch(\"/ex/getPetaData.do\", \"edate=19950101&position=C1\"); ``` 위 [loadSearchData()](/docs/funcs/core/load-search-data)와 [doSearch()](/docs/funcs/core/do-search) 함수는 모두 비동기 형식으로 동작합니다. ### **수정된 데이터 추출** [getSaveJson()](/docs/funcs/core/get-save-json), [getSaveString()](/docs/funcs/core/get-save-string) 함수를 통해 시트에서 수정된 데이터(혹은 전체 데이터)를 json형식이나 querystring 형식으로 추출할 수 있습니다. ([getChangedData()](/docs/funcs/core/get-changed-data)는 수정된 데이터를 셀단위로 추출하고, [getSaveJson()](/docs/funcs/core/get-save-json), [getSaveString()](/docs/funcs/core/get-save-string)은 행단위로 추출합니다.) ```javascript var chgData = sheet.getSaveJson(); ``` return 값 ```js { \"data\":[ // 삭제 데이터 {\"id\":\"AR2\",\"SEQ\":2,\"sStatus\":\"D\",\"DCheck\":\"1\",\"sNation\":\"한국\", ... \"STATUS\":\"Deleted\"}, // 신규 데이터 {\"id\":\"AR51\",\"SEQ\":4,\"sStatus\":\"I\",\"DCheck\":\"0\",\"sNation\":\"미국\", ... \"STATUS\":\"Added\"}, // 수정 데이터 {\"id\":\"AR5\",\"SEQ\":6,\"sStatus\":\"U\",\"DCheck\":\"0\",\"sNation\":\"한국\", ... \"STATUS\":\"Changed\"} ] } ``` 시트의 수정 여부는 [hasChangedData()](/docs/funcs/core/has-changed-data)를 통해 확인할 수 있습니다. 특정 상태의 행만 추출하는 경우, 가령 신규 입력된 행만 추출해야 한다면 [getRowsByStatus('Added')](/docs/funcs/core/get-rows-by-status)함수를 이용하시면 편리합니다. ### **행삭제** [deleteRow()](/docs/funcs/core/delete-row) 함수로 특정 행의 상태를 `Deleted`로 변경 할 수 있습니다. [removeRow()](/docs/funcs/core/remove-row) 함수로 특정 행을 즉시 삭제할 수 있습니다. [removeAll()](/docs/funcs/core/remove-all) 함수로 모든 데이터 행을 삭제할 수 있습니다. ```javascript //첫번째 행 객체 추출 var row = sheet.getFirstRow(); //첫번째 행을 즉시 삭제한다. sheet.removeRow(row); ``` ### **상태 클리어** [acceptChangedData](/docs/funcs/core/accept-changed-data) 함수를 통해 저장 작업이 완료된 후 시트의 상태를 클리어 할 수 있습니다. 위 함수를 호출하면 수정(Changed),입력(Added)인 행은 조회 상태로 변경되고, 삭제(Deleted)인 행은 삭제 됩니다. ### **셀 값의 확인/변경** [getValue](/docs/funcs/core/get-value),[setValue](/docs/funcs/core/set-value) 함수를 통해 셀의 값을 확인하거나 변경하실 수 있습니다. ```javascript // 셀의 값 READ var cls = sheet.getValue( sheet.getFirstRow(), \"CLS\" ); //첫번째 데이터 행에 \"CLS\" 컬럼의 값을 얻음. // 셀의 값 WRITE sheet.setValue( sheet.getRowByIndex(100), \"DESC\", \"임계값 근접 경고!\" ); //100번째 행의 \"DESC\" 값을 변경. ``` ### **글자색,배경색 설정** [setAttribute()](/docs/funcs/core/set-attribute) 함수를 통해 특정 셀의 속성을 변경 할 수 있습니다. ```javascript // AMT 컬럼의 배경색을 FF0000로 변경 sheet.setAttribute(null, \"AMT\", \"Color\", \"#FF0000\" ); // 마지막행의 글자색을 0000FF로 변경 sheet.setAttribute( sheet.getLastRow(), null, \"TextColor\", \"#0000FF\" ); // 특정 셀의 폰트를 Bold로 변경 sheet.setAttribute( sheet.getFocusedRow(), \"ETC\", \"TextStyle\", 1 ); ``` 여러개의 디자인 속성을 한꺼번에 변경해야 하는 경우에는 [setCellStyle()](/docs/funcs/core/set-cell-style) 함수를 사용합니다. ```javascript var row = sheet.getFirstRow(); sheet.setCellStyle({row: row, col: \"sa_nm\", attr: {TextColor:\"red\", Color: \"#00FF00\"}, render: 1}); ``` ## 이벤트 사용 [아이비시트 이벤트 사용법](/docs/events/event) ### 데이터 수정시 이벤트 사용 예 ```javascript //객체 생성시 이벤트 선언 options.Events = { onAfterChange:function (evtParam) { if (evtParam.col == \"AMT\" && evtParam.val == 3000) { evtParam.sheet.showMessage(\"I Love You 3000\"); } } }; ``` ### 더블 클릭 이벤트 bind 예 (권장하지 않음) ```javascript //시트객체 생성 이후 이벤트 바인딩 sheet.bind(\"onDblClick\" , function(evtParam) { var row = evtParam.row; var col = evtParam.col; //편집불가능한 셀 더블클릭시 상세 다이얼로그 open if (!sheet.getAttribute(row, col, \"Edit\")) { evtParam.sheet.showEditDialog(row); } }); ```",
          "see": [
            {
              "label": "시트 객체 구조 getting started",
              "url": "/docs/start/basic-structure"
            },
            {
              "label": "Header col",
              "url": "/docs/props/col/header"
            },
            {
              "label": "method 사용법 기초 method",
              "url": "/docs/funcs/method"
            },
            {
              "label": "event 사용법 기초 event",
              "url": "/docs/events/event"
            },
            {
              "label": "onRenderFirstFinish event",
              "url": "/docs/events/on-render-first-finish"
            },
            {
              "label": "create static",
              "url": "/docs/static/create"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
        },
        "url": "docs/start/quick-start.html"
      },
      {
        "cid": 7,
        "sid": "row",
        "name": "row",
        "label": "행(Row) 구조에 대한 이해",
        "data": {
          "body": "> `ibsheet`를 가로로 나누어보면 크게 `헤더`와 `바디`, `푸터`로 나누어 집니다. > 헤더는 데이터 영역 상단에 고정되어 보여지는 부분으로 헤더행과 필터 등이 헤더 영역에 속합니다. > 바디는 스크롤에 의해 보여지는 데이터 영역이고, 푸터는 합계행과 같이 바디 영역 하단에서 스크롤 여부와 상관없이 항상 보여지는 부분을 의미합니다. --- ## 헤더 영역 ### *헤더행* 시트 생성시 `options.Cols.Header`를 통해 설정한 값들이 헤더에 들어가게 됩니다. 헤더 셀은 클릭시 소팅이 되거나 드래그를 통해 열의 위치이동, 컬럼의 사이즈 조절 등의 역할을 수행합니다. ```javascript var options = { \"Cols\": [ { Header: [ { // 열의 헤더 설정 개별 셀 설정 \"Value\": \"부서정보\", \"Color\": \"#085820\", \"Span\": 2 }, \"부서명\" ], \"Name\": \"deptName\", \"Type\": \"Text\", \"Size\": 100 }, { Header: [\"\", \"부서코드\"], \"Name\": \"deptCd\", \"Type\": \"Text\", \"Width\": 100 }, { Header: [ { \"Value\": \"2014 년 실적\", \"Color\": \"#6699FF\", \"Span\": 4 }, \"1분기\" ], \"Name\": \"qt1\", \"Type\": \"Int\", \"Width\": 100 }, { Header: [\"\", \"2분기\"], \"Name\": \"qt2\", \"Type\": \"Int\", \"Width\": 100 }, { Header: [\"\", \"3분기\"], \"Name\": \"qt3\", \"Type\": \"Int\", \"Width\": 100 }, { Header: [\"\", \"4분기\"], \"Name\": \"qt4\", \"Type\": \"Int\", \"Width\": 100 } ] }; ``` ![해더행](/assets/imgs/header1.png \"헤더행\") [생성된 헤더행] ### *필터행* (`cfg`) [ShowFilter](/docs/props/cfg/show-filter)나 sheet.[showFilterRow()](/docs/funcs/core/show-filter-row)함수를 통해 생성되는 필터행도 헤더부에 위치하게 됩니다. ```javascript sheet.showFilterRow(); ``` ![필터행](/assets/imgs/header2.png \"필터행\") [필터행] ### *커스텀 행(Head)* 헤더행 아래(필터행이 있으면 필터행 아래)에 세로 스크롤 여부와 상관없이 항상 보여지는 행을 원하는 개수만큼 만드실 수 있습니다. 커스텀 헤더행은 `options.Head` 속성을 통해 설정합니다. `컬럼Name : {\"Type\":\"Text\", \"Value\":\"Test\"}` 와 같이 커스텀 헤더행의 컬럼 속성을 부여하고 생성할 수 있습니다. ```javascript options = { Head: [ { \"id\": \"myHeadRow1\", // 커스텀 헤더행 Row 객체의 ID를 의미합니다. Def 에 id 로 선언하여 // 커스텀 헤더행의 속성을 공통으로 사용할 수 있습니다. \"Spanned\": 1, // 커스텀 헤더행 Span 병합 가능 설정 \"deptName\": { \"Type\": \"Text\", \"Value\": \"미수금 포함 여부\", \"Span\": 2, \"Color\": \"#EDEDED\", \"Align\": \"center\", \"TextStyle\": 1 }, // 커스텀 헤더행에서 deptName 컬럼의 Type, Value, Span, Color, Align, TextStyle 속성을 설정합니다. \"qt1\": {\"Type\": \"Bool\"}, \"qt2\": {\"Type\": \"Bool\"}, \"qt3\": {\"Type\": \"Bool\"}, \"qt4\": {\"Type\": \"Bool\"} } ] } ``` 아래의 이미지는 위의 설정을 통해 생성되는 커스텀행(Head) 예시 이미지 입니다. ![커스텀해더행](/assets/imgs/header3.png \"커스텀헤더행\") [커스텀헤더행] --- ## 바디 영역 바디는 [doSearch()](/docs/funcs/core/do-search), [loadSearchData()](/docs/funcs/core/load-search-data)함수를 통해서 조회 된 데이터나 [addRow()](/docs/funcs/core/add-row)함수를 통해 추가된 데이터가 보여지는 영역입니다. ![바디 영역](/assets/imgs/body.png \"바디 영역\") [**바디 영역**] --- ## 푸터 영역 ### *합계 행* 열 생성시 (`col`) [FormulaRow](/docs/props/col/formula-row) 속성을 설정하면 시트 하단에 고정된 합계행이 만들어져 합계값을 보여 줍니다. 합계행의 위치는 상단으로 올릴 수 도 있으나 기본적으로 생성되는 합계행은 푸터 영역에 위치하게 됩니다. ```javascript var options = { \"Cols\": [ ... }, { \"Header\": [ { \"Value\": \"2014 년 실적\", \"Color\": \"#6699FF\", \"Span\": 4 }, \"1분기\" ], \"Name\": \"qt1\", \"Type\": \"Int\", \"Width\": 100, FormulaRow: \"Sum\" }, { \"Header\": [\"\", \"2분기\"], \"Name\": \"qt2\", \"Type\": \"Int\", \"Width\": 100, FormulaRow: \"Avg\" }, { ... ] } ``` ![합계행](/assets/imgs/formulaRow.png \"합계행\") [합계행] ### *커스텀 행(Foot)* 헤더 영역과 마찬가지로 푸터 영역에도 커스텀행을 추가할 수 있습니다. 커스텀 푸터행은 `options.Foot` 속성을 통해 설정합니다. `컬럼Name : {\"Type\":\"Text\", \"Value\":\"Test\"}` 와 같이 커스텀 푸터행의 컬럼 속성을 부여하고 생성할 수 있습니다. ```javascript options = { Foot: [ //커스텀행(Foot) 영역 설정 { \"id\": \"MyFootRow1\", // 커스텀 푸터행 Row 객체의 ID를 의미합니다. Def 에 id 로 선언하여 // 커스텀 푸터행의 속성을 공통으로 사용할 수 있습니다. \"Spanned\" 1, // 커스텀 푸터행의 Span 병합 가능 설정 \"Color\": \"#666666\", \"TextColor\": \"#FFFFFF\", \"deptName\": {\"Value\": \"2015년 자료\", \"TextColor\": \"#FFBBBB\", \"Span\": 5}, // 커스텀 푸터행에서 deptName 컬럼의 Value, TextColor, Span 속성을 설정합니다. \"qt4\": {\"Type\": \"Int\", \"Format\": \"#,###\", \"Value\": 1248423} } ] } ``` 아래의 이미지는 위의 설정을 통해 생성되는 커스텀행(Foot) 예시 이미지 입니다. ![푸터행](/assets/imgs/foot.png \"푸터행\") [푸터행] --- ## 기타 ### *솔리드 행* 헤더나 푸터 영역 주변에 임의의 행을 추가할 수 있습니다. 이렇게 추가된 행은 시트 내 열과 무관하게 기능과 크기를 갖을 수 있습니다. 보다 자세한 내용은 (appendix) [Soild](/docs/appx/solid)을 참고하세요. ### *행의 ID* 모든 행은 고유한 `ID`를 갖고 있습니다. 데이터 행은 순서대로 `AR1, AR2, AR3...` 식의 `ID`를 갖습니다. **헤더 행은 헤더가 한줄 일 때는 Header 라는 이름을 갖고 2번째 헤더행부터는 `HR1,HR2...` 식으로 `ID`를 갖습니다.** 헤더 영역나 푸터 영역에 커스텀하게 생성한 행 또는 솔리드 행은, 만드실 때 부여한 id속성 값이 고유한 ID가 됩니다. (푸터 행을 만들때 별도의 id를 지정하지 않으면 `FR1,FR2..` 식의 `ID`를 갖습니다.) **이외에 필터행은 `Filter`, 합계행은 `FormulaRow` 라는 ID를 갖고 있습니다.** 이러한 ID를 이용하여 행에 대한 값을 변경하거나 내용을 확인하실 수 있습니다. ```javascript //example1 헤더행의 타이틀를 수정 var hrow = sheet.getRowById(\"Header\"); //헤더행 객체 얻기 hrow[\"colName\"] = \"수정할 헤더명\"; sheet.refreshCell(hrow, \"colName\"); //example2 일반행에 기능 설정하기 var trow = sheet.getRowById(\"AR34\"); //AR34번 행을 얻음 trow[\"CanEdit\"] = 0; //행에대한 편집 불가 설정 trow[\"CanFocus\"] = 0; //행 포커스 불가 설정 sheet.refreshRow(trow); ``` ### *Def를 통한 행 공통 설정* 시트 생성시 행/열에 대한 공통기능을 설정하는 `Def`를 통해서 커스텀행에 대한 디자인과 기능을 설정할 수 있습니다. ```javascript var options = { Def: { \"Col\": {}, //전체 열에 대한 공통 설정 \"Row\": {}, //전체 데이터 행에 대한 공통 설정 \"Header\": {}, //헤더행에 대한 공통 설정 myCustomRow2: { //임의의 커스텀 행에대한 공통 기능 설정 \"Color\": \"#555555\", \"TextColor\": \"#FFFFFF\", \"CanFocus\": 0, \"Tip\": \"커스텀 행입니다.\" } } }; ``` 위와 같이 만들어진 \"myCustomRow2\"는 아래와 같은 방식으로 커스텀행에 적용하실 수 있습니다. ```javascript options = { Head:[ { //커스텀 헤더행 Def: \"myCustomRow2\", //Def에서 정의한 공통을 적용함 id: \"headRow1\", \"colName1\": {\"Type\": \"Text\", \"Align\": \"Right\", \"Value\": \"상태\"}, \"colName2\": {\"Type\": \"Text\", \"Align\": \"Left\", \"Value\": \"작업완료\"} } ] }; ```",
          "see": [
            {
              "label": "ShowFilter cfg",
              "url": "/docs/props/cfg/show-filter"
            },
            {
              "label": "FormulaRow col",
              "url": "/docs/props/col/formula-row"
            },
            {
              "label": "addRow method",
              "url": "/docs/funcs/core/add-row"
            },
            {
              "label": "doSearch method",
              "url": "/docs/funcs/core/do-search"
            },
            {
              "label": "loadSearchData method",
              "url": "/docs/funcs/core/load-search-data"
            },
            {
              "label": "showFilterRow method",
              "url": "/docs/funcs/core/show-filter-row"
            },
            {
              "label": "행 객체 appendix",
              "url": "/docs/appx/row-object"
            },
            {
              "label": "Soild appendix",
              "url": "/docs/appx/solid"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
        },
        "url": "docs/start/row.html"
      },
      {
        "cid": 5,
        "sid": "col",
        "name": "col",
        "label": "열(Col) 구조에 대한 이해",
        "data": {
          "body": "> 시트를 세로로 나누면 `Left`, `Center`, `Right` 영역(Section)으로 나누어 집니다. > 각각의 영역은 고유하게 스크롤을 갖을 수 있고 각 영역 간에 이동도 가능합니다. ## 열 생성 시트 생성시 `LeftCols, Cols, RightCols` 에 각 열에 대한 기능을 정의하면 원하는 개수만큼 열을 생성할 수 있습니다. 단, **SEQ 열은 항상 자동으로 생성되며 별도로 Name: \"SEQ\" 인 열을 설정하지 않으면 LeftCols에 Hidden 상태로 생성됩니다.** [sheet.showCol('SEQ');](/docs/funcs/core/show-col) 로 숨겨진 `SEQ 열`을 확인 할 수 있습니다. 빈번하게 사용될 것 같은 열의 기능은 [Extend](/docs/props/col/extend)를 통해 여러개 열에 동일하게 적용하실 수 있습니다. ```javascript var options = { \"Cfg\": { //전역 기능 설정(cfg property) \"LeftCanResize\": 1, \"LeftWidth\": 100, \"RightCanResize\": 1, \"RightWidth\": 100 }, LeftCols: [ //왼쪽영역(LeftSection) 고정 열 설정 (col property) {\"Header\": \"NO\", \"Type\": \"Int\", \"Name\": \"SEQ\", \"Width\": 50}, {\"Header\": \"선택\", \"Type\": \"Bool\", \"CanEdit\": 1,\"Name\": \"chk\", \"Width\": 50}, {\"Header\": \"년도\", \"Name\": \"Year\", \"Type\": \"Text\", \"Align\": \"Center\", \"Width\": 70} ], Cols: [ //가운데 영역 {\"Header\": \"매출\", \"Name\": \"revenue\", \"Type\": \"Int\", \"Width\": 120, \"Format\": \"#,### 백만원\"}, {\"Header\": \"매출원가\", \"Name\": \"revenueOrg\", \"Type\": \"Int\", \"Width\": 120, \"Format\": \"#,### 백만원\"}, {\"Header\": \"판매관리비\", \"Name\": \"salesMgr\", \"Type\": \"Int\", \"Width\": 120, \"Format\": \"#,### 백만원\"}, {\"Header\": \"영업이익\", \"Name\": \"oprIncome\", \"Type\": \"Int\", \"Width\": 120, \"Format\": \"#,### 백만원\", Formula: \"revenue-revenueOrg-salesMgr\", Color: \"#DEDEDE\"} ], RightCols: [ //오른쪽영역(RightSection) 고정 열 설정 (col property) {\"Header\": \"금융손실\", \"Name\": \"finloss\", \"Type\": \"Int\", \"Width\": 120, \"Format\": \"#,### 백만원\"}, {\"Header\": \"법인세\", \"Name\": \"corpTax\", \"Type\": \"Int\", \"Width\": 120, \"Format\": \"#,### 백만원\"}, {\"Header\": \"순이익\", \"Name\": \"INCOME\", \"Type\": \"Int\", \"Width\": 120, \"Format\": \"#,### 백만원\", Formula: \"oprIncome-finloss-corpTax\", Color: \"#DEDEDE\"} ] }; ``` ![섹션](/assets/imgs/section2.png \"section\") [`좌측,가운데,우측 영역`] 각 영역에 대한 너비는 `Cfg`에서 [LeftWidth](/docs/props/cfg/left-width), [RightWidth](/docs/props/cfg/right-width)를 통해 설정하게 됩니다. 다만, 시트의 너비가 충분히 커서 가로스크롤바가 필요 없는 경우에는 위 설정은 무시됩니다. 영역과 영역사이는 원래 붙어 있으며, 사용자가 직접 영역의 크기를 조절할 수 있게 하려면 `Cfg`에서 [LeftCanResize](/docs/props/cfg/left-can-resize), [RightCanResize](/docs/props/cfg/right-can-resize)을 설정하시면 됩니다. ## 열 기능 변경 이미 생성된 열에 대해서 설정을 확인하거나 기능을 수정하거나 추가할 수 있습니다. ```javascript var col = sheet.Cols[\"finloss\"]; //Name이 finloss인 열 객체 얻기 // 열에 설정된 색상 확인 console.log(col[\"Color\"]); // 열에 속성 변경 col[\"TextColor\"] = \"#FF0000\"; //열에 색상 정의 col[\"CanSelect\"] = 0; //열에 대한 선택 불가(드래그시 선택이 안됨) sheet.rerender(); //변경내용 반영 ``` 다만 위와 같이 직접 열에 속성에 직접 접근하여 속성값을 변경하는 경우 시트내에서 이를 감지하지 못하여 예상치 못한 문제가 발생할 수 있으므로 가급적 [getAttribute](/docs/funcs/core/get-attribute)나 [setAttribute](/docs/funcs/core/set-attribute) 함수를 사용하실 것을 권해드립니다. ## 빈번하게 사용되는 열 유형에 대해서 **Extend** 기능 활용 프로젝트에서 자주 사용될 것 같은 기능을 갖은 열, 가령 \"yyyy-MM-dd\" 형식의 Date열이나 \"$ 12.33\"와 같은 통화 형식의 Float열을 공통으로 정의해 두고 각 화면에서는 미리 정의해둔 설정을 불러다 사용하실 수 있습니다. [`ibsheet-common.js` 파일에 공통기능을 정의한 IB_Preset 이 있습니다.] ```javascript var IB_Preset = { \"YMD\": {Type: \"Date\", Width: 110, Align: \"Center\", Format: \"yyyy-MM-dd\", DataFormat: \"yyyyMMdd\", EditFormat: \"yyyyMMdd\"}, \"YM\": {Type: \"Date\", Width: 90, Align: \"Center\", Format: \"yyyy-MM\", DataFormat: \"yyyyMM\", EditFormat: \"yyyyMM\"}, \"USD\":{Type: \"Float\", Width: 100, Format: \"$ #,###.##\"}, .... }; ``` [각 페이지에서 시트 초기화 구문] ```javascript var options = { Cols:[ ///Extend를 통해 미리 정의한 Type,Format 등의 설정을 적용 {Header: \"국외수입\", Name: \"Income\", Extend: IB_Preset.USD}, {Header: \"취득일\", Name: \"ICDate\", Extend: IB_Preset.YMD} ] } ```",
          "see": [
            {
              "label": "LeftWidth cfg",
              "url": "/docs/props/cfg/left-width"
            },
            {
              "label": "RightWidth cfg",
              "url": "/docs/props/cfg/right-width"
            },
            {
              "label": "LeftCanResize cfg",
              "url": "/docs/props/cfg/left-can-resize"
            },
            {
              "label": "RightCanResize cfg",
              "url": "/docs/props/cfg/right-can-resize"
            },
            {
              "label": "Extend col",
              "url": "/docs/props/col/extend"
            },
            {
              "label": "showCol method",
              "url": "/docs/funcs/core/show-col"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
        },
        "url": "docs/start/col.html"
      },
      {
        "cid": 4,
        "sid": "basic-structure",
        "name": "basic-structure",
        "label": "시트 객체 기본 구조",
        "data": {
          "body": "***시트 객체 초기화(options)*** ## 초기화 구문 구조 ``` options.(ROOT) ├── Cfg:{} // 시트 전역 기능 설정 │ ├── LeftCols:[] // 왼쪽 고정 영역 열 설정 ├── Cols:[] // 기본열 설정(가운데 영역) ├── RightCols:[] // 우측 고정 영역 열 설정 │ └── Events:{} // 이벤트 선언 ``` 시트설정 예) ```javascript var OPT = { \"Cfg\": { // 전역 기능 설정(cfg property) \"CanEdit\": 0, }, \"LeftCols\": [ // 왼쪽영역(LeftSection) 고정 열 설정 (col property) { \"Header\": \"NO\", \"Type\": \"Int\", \"Name\": \"SEQ\", \"Width\": 50 }, { \"Header\": \"선택\", \"Type\": \"Bool\", \"CanEdit\": 1, \"Name\": \"CHK\"} ], \"Cols\": [ // 기본 열 설정(가운데영역) (col property) { \"Header\": \"부서명\", \"Name\": \"deptName\", \"Type\": \"Text\", \"Size\": 30 }, { \"Header\": \"1분기\", \"Name\": \"qt1\", \"Type\": \"Int\", \"Width\": 100, \"Format\": \"#,##0 만원\", \"FormulaRow\": \"Avg\" }, { \"Header\": \"2분기\", \"Name\": \"qt2\", \"Type\": \"Int\", \"Width\": 100, \"Format\": \"#,##0 만원\", \"FormulaRow\": \"Avg\", \"Color\": \"#EDEDED\" }, { \"Header\": \"3분기\", \"Name\": \"qt3\", \"Type\": \"Int\", \"Width\": 100, \"Format\": \"#,##0 만원\", \"FormulaRow\": \"Avg\" }, { \"Header\": \"4분기\", \"Name\": \"qt4\", \"Type\": \"Int\", \"Width\": 100, \"Format\": \"#,##0 만원\", \"FormulaRow\": \"Avg\", \"Color\": \"#EDEDED\"} ], \"RightCols\": [], // 오른쪽 영역(RightSection) \"Events\":{ // 이벤트 설정 \"onBeforeChange\":function (evt) { ... } } }; ``` ## 조회 데이터 구조 ```js var DATA = [ {\"deptName\": \"국내영업 1팀\", \"qt1\": 15030, \"qt2\": 21102, \"qt3\": 20308, \"qt4\": 23041}, {\"deptName\": \"국내영업 2팀\", \"qt1\": 25100, \"qt2\": 42460, \"qt3\": 38740, \"qt4\": 54765}, {\"deptName\": \"국내영업 3팀\", \"qt1\": 11474, \"qt2\": 19671, \"qt3\": 24746, \"qt4\": 20754}, {\"deptName\": \"해외 영업팀\", \"qt1\": 24146, \"qt2\": 24654, \"qt3\": 24164, \"qt4\": 48121} ] ``` ## 시트 생성 구문 ```js IBSheet.create({ \"id\": \"mySheet\", // 시트객체 이름 (SPA에서는 사용 X) \"el\": document.querySelector(\"div.part1 .gridarea\"), // 시트를 생성할 html element \"options\": OPT, // 초기화 구문 \"data\": DATA //초기 데이터 }); ``` ![로드된 시트 이미지](/assets/imgs/basicStructure.png \"로드된 시트 이미지\") [로드된 시트 이미지]",
          "see": [
            {
              "label": "상세 구조",
              "url": "/docs/appx/init-structure"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
        },
        "url": "docs/start/basic-structure.html"
      }
    ]
  },
  {
    "gid": 3,
    "label": "Properties",
    "name": "props",
    "children": [
      {
        "gid": 1,
        "name": "props-cfg",
        "label": "Cfg",
        "children": [
          {
            "cid": 8,
            "sid": "accept-pivot-cols",
            "name": "accept-pivot-cols",
            "label": "AcceptPivotCols",
            "data": {
              "body": "> 피벗 시트에서 기준 열의 값으로 사용될 수 있는 열을 설정합니다. > `\",\"`로 연결하여 복수 개의 열 이름을 지정할 수 있습니다. ### Type `string` ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 AcceptPivotCols: \"sDept,sTeam,sPosition,sName,sGender,sAgeRange,sAddr,sAge,sPeriod\" }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "PivotFunc cfg",
                  "url": "./pivot-func"
                },
                {
                  "label": "AcceptPivotRows cfg",
                  "url": "./accept-pivot-rows"
                },
                {
                  "label": "AcceptPivotData cfg",
                  "url": "./accept-pivot-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/accept-pivot-cols.html"
          },
          {
            "cid": 9,
            "sid": "accept-pivot-data",
            "name": "accept-pivot-data",
            "label": "AcceptPivotData",
            "data": {
              "body": "> 피벗 시트에서 데이터의 값으로 사용될 수 있는 열을 설정합니다. > `\",\"`로 연결하여 복수 개의 열 이름을 지정할 수 있습니다. ### Type `string` ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 AcceptPivotData: \"sAge,sPeriod,sSalary,sBonus\" }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "PivotFunc cfg",
                  "url": "./pivot-func"
                },
                {
                  "label": "AcceptPivotCols cfg",
                  "url": "./accept-pivot-cols"
                },
                {
                  "label": "AcceptPivotRows cfg",
                  "url": "./accept-pivot-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/accept-pivot-data.html"
          },
          {
            "cid": 10,
            "sid": "accept-pivot-rows",
            "name": "accept-pivot-rows",
            "label": "AcceptPivotRows",
            "data": {
              "body": "> 피벗 시트에서 기준 행의 값으로 사용될 수 있는 열을 설정합니다. > `\",\"`로 연결하여 복수 개의 열 이름을 지정할 수 있습니다. ### Type `string` ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 AcceptPivotRows: \"sDept,sTeam,sPosition,sName,sGender,sAgeRange,sAddr,sAge,sPeriod\" }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "PivotFunc cfg",
                  "url": "./pivot-func"
                },
                {
                  "label": "AcceptPivotCols cfg",
                  "url": "./accept-pivot-cols"
                },
                {
                  "label": "AcceptPivotData cfg",
                  "url": "./accept-pivot-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/accept-pivot-rows.html"
          },
          {
            "cid": 11,
            "sid": "alternate-count",
            "name": "alternate-count",
            "label": "AlternateCount",
            "data": {
              "body": "> [Alternate](./alternate) 로 설정된 행 간격에 `AlternateCount` 정의한 개수만큼 [AlternateColor](/docs/props/row/alternate-color) 배경색를 적용합니다. > 예를 들어 `Alternate: 5` 이고, `AlternateCount: 2` 인 경우 5개 행 간격으로 마지막 2개 행에만 하이라이트를 적용합니다. ### ![AlternateCount](/assets/imgs/alternateCount.png \"AlternateCount\") [`Alternate: 5, AlternateCount: 2` 로 설정한 경우] ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|`alternate` 설정된 행 간격마다 하이라이트가 적용될 마지막 행수 (`default: 1`)| ### Example ```javascript options[\"Cfg\"] = { Alternate:5, AlternateCount:2 }; ```",
              "see": [
                {
                  "label": "AlternateColor row",
                  "url": "/docs/props/row/alternate-color"
                },
                {
                  "label": "Alternate cfg",
                  "url": "./alternate"
                },
                {
                  "label": "AlternateStart cfg",
                  "url": "./alternate-start"
                },
                {
                  "label": "AlternateType cfg",
                  "url": "./alternate-type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/alternate-count.html"
          },
          {
            "cid": 12,
            "sid": "alternate-start",
            "name": "alternate-start",
            "label": "AlternateStart",
            "data": {
              "body": "> [Alternate cfg](./alternate) 에 설정한 행 간격에 [AlternateColor](/docs/props/row/alternate-color)를 적용할 행의 시작 위치를 설정합니다. > `0`은 간격의 첫번째 행을 의미합니다. > 예를 들어 [Alternate](./alternate): 5 이고, [AlternateCount](./alternate-count): 2, AlternateStart: 0 로 설정한 경우 > 화면에는 5개 행 간격으로 맨위의 2개 행에만 `AlternateColor`를 표시합니다. ### ![AlternateStart](/assets/imgs/alternateCount.png \"AlternateStart\") [`Alternate: 5, AlternateCount: 2` 로 설정한 경우] ![AlternateStart](/assets/imgs/alternateStart.png \"AlternateStart\") [`Alternate: 5, AlternateCount: 2, AlternateStart: 0` 로 설정한 경우] ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|[Alternate](./alternate) 설정된 행 간격마다 하이라이트가 시작될 행 위치 (`default : (cfg)Alternate - (cfg)AlternateCount`)| ### Example ```javascript options[\"Cfg\"] = { Alternate:5, AlternateCount:2, AlternateStart:0 }; ```",
              "see": [
                {
                  "label": "Alternate cfg",
                  "url": "./alternate"
                },
                {
                  "label": "AlternateCount cfg",
                  "url": "./alternate-count"
                },
                {
                  "label": "AlternateType cfg",
                  "url": "./alternate-type"
                },
                {
                  "label": "AlternateColor row",
                  "url": "/docs/props/row/alternate-color"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/alternate-start.html"
          },
          {
            "cid": 13,
            "sid": "alternate-type",
            "name": "alternate-type",
            "label": "AlternateType",
            "data": {
              "body": "> 트리로 구성된 시트에서 자식행들도 [Alternate](./alternate) 계산에 포함될지 여부를 설정합니다. > 해당 속성을 `1`로 설정한 경우, 트리를 펼치고 접을 때마다 자식행들에 대한 컬러 계산이 이루어지면서 시트가 느려질 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|트리 시트의 자식행을 포함하지 않고 하이라이트 표시 (`default`)| |`1`|트리 시트의 자식행을 포함해 재계산하여 하이라이트 표시 | ### Example ```javascript options.Cfg = { \"Alternate\": 2, // 짝수행에 하이라이트 표시 \"AlternateType\": 1 // 트리시트에서 자식행도 Alternate 에 포함하여 하이라이트 처리 }; ```",
              "see": [
                {
                  "label": "Alternate cfg",
                  "url": "./alternate"
                },
                {
                  "label": "AlternateColor row",
                  "url": "/docs/props/row/alternate-color"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/alternate-type.html"
          },
          {
            "cid": 14,
            "sid": "alternate",
            "name": "alternate",
            "label": "Alternate",
            "data": {
              "body": "> 홀수, 짝수 행에 대하여 번갈아 가며 배경색을 다르게 설정하여 가독성을 높일수 있는 기능입니다. > 옵션 값이 `3` 이상인 경우 (Cfg)[AlternateStart](./alternate-start) 와 (cfg)[AlternateCount](./alternate-count) 에 따라 하이라이트 적용을 변경할 수 있습니다. > 하이라이트 색상은 css 파일의 `.IBColorAlternate` 색상을 기본값으로 가지며, (Row)[AlternateColor](/docs/props/row/alternate-color) 를 설정한 경우 해당 색상을 따르게 됩니다. ### ![Alternate0](/assets/imgs/alternate0.png \"Alternate0\") [`Alternate: 0` 의 경우] ![Alternate2](/assets/imgs/alternate2.png \"Alternate0\") [`Alternate: 2` 의 경우] ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|하이라이트 기능 사용 안함 (css 파일의 `.IBColorDefault` 색상) (`default`)| |`1`|모든 데이터행에 하이라이트 사용 (css 파일의 `.IBColorAlternate` 색상)| |`2`|**짝수행에 하이라이트 사용** (css 파일의 `.IBColorDefault, .IBColorAlternate` 색상이 반복적으로 표시)| |`3`|3개 행 마다 마지막 행에 하이라이트 사용 | |`N`|N개 행 마다 마지막 행에 하이라이트 사용 | ### Example ```javascript options = { Cfg:{ Alternate: 2, // 홀/짝수행 색상을 css 의 .IBColorDefault 색상과 (Row)AlternateColor 색상으로 처리 }, Def:{ Row:{ AlternateColor: \"FFFF00\" // 하이라이트 색상을 노란색으로 설정 } } }; ```",
              "see": [
                {
                  "label": "AlternateColor row",
                  "url": "/docs/props/row/alternate-color"
                },
                {
                  "label": "AlternateCount cfg",
                  "url": "./alternate-count"
                },
                {
                  "label": "AlternateStart cfg",
                  "url": "./alternate-start"
                },
                {
                  "label": "AlternateType cfg",
                  "url": "./alternate-type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/alternate.html"
          },
          {
            "cid": 15,
            "sid": "auto-calendar",
            "name": "auto-calendar",
            "label": "AutoCalendar",
            "data": {
              "body": "> 모든 [Type](/docs/appx/type)이 `Date`인 셀에 대해 사용자가 편집모드로 들어갈때 달력을 띄울지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|편집시 달력을 띄움| ### Example ```javascript //모든 Date 타입 열에 대해서 편집시 자동으로 달력을 오픈한다. options.Cfg = { AutoCalendar: true }; ```",
              "see": [
                {
                  "label": "AutoCalendar col",
                  "url": "/docs/props/col/auto-calendar"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/auto-calendar.html"
          },
          {
            "cid": 16,
            "sid": "auto-close-dialog-timeout",
            "name": "auto-close-dialog-timeout",
            "label": "AutoCloseDialogTimeout",
            "data": {
              "body": "> `(Cfg) AutoCloseDialog`를 설정하여 다이얼로그를 자동으로 닫을 경우, 다이얼로그가 자동으로 닫히는 딜레이 시간을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|다이얼로그가 자동으로 닫히는 시간을 설정합니다.| ### Example ```javascript options = { \"Cfg\":{ \"AutoCloseDialogTimeout\": 1000, // 1초 후 다이얼로그가 자동으로 닫히도록 설정 } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.24|기능 추가|"
            },
            "url": "docs/props/cfg/auto-close-dialog-timeout.html"
          },
          {
            "cid": 17,
            "sid": "auto-close-dialog",
            "name": "auto-close-dialog",
            "label": "AutoCloseDialog",
            "data": {
              "body": "> 달력, 컨텍스트 메뉴 등 내부적으로 사용하는 다이얼로그에서 마우스가 벗어날 때, 다이얼로그를 자동으로 닫을지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|다이얼로그를 자동으로 닫지 않습니다. (`default`)| |`true`|다이얼로그를 자동으로 닫습니다.| ### Example ```javascript options = { \"Cfg\":{ \"AutoCloseDialog\": true, // 달력, 컨텍스트 메뉴 등 내부적으로 사용하는 다이얼로그에서 마우스가 벗어날 때 달력을 자동으로 닫습니다. } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.24|기능 추가|"
            },
            "url": "docs/props/cfg/auto-close-dialog.html"
          },
          {
            "cid": 18,
            "sid": "auto-excel-mode",
            "name": "auto-excel-mode",
            "label": "AutoExcelMode",
            "data": {
              "body": "> down2Excel(),loadExcel() 함수를 이용하여 엑셀 다운/업로드를 할 때, 서버모듈을 이용할지 클라이언트 모듈을 이용할지 정할 수 있는 모드 입니다. > 따로 설정하지 않으면 서버모듈을 기준으로 사용됩니다. > `AutoExcelMode`를 `1`로 설정시 서버모듈([down2Excel](/docs/funcs/excel/down-to-excel), [loadExcel](/docs/funcs/excel/load-excel)) 과 동일합니다. > `AutoExcelMode`를 `2`로 설정시 클라이언트 모듈([exportData](/docs/funcs/core/export-data), [importData](/docs/funcs/core/import-data))과 동일합니다. 클라이언트 모듈만을 사용하고 싶은 경우는 따로 설정하지 않고 ([exportData](/docs/funcs/core/export-data), [importData](/docs/funcs/core/import-data))를 사용하셔도 됩니다. > `AutoExcelMode`를 `3`으로 설정하면 브라우저의 성능에 따라 서버모듈([down2Excel](/docs/funcs/excel/down-to-excel), [loadExcel](/docs/funcs/excel/load-excel))과 클라이언트 모듈([exportData](/docs/funcs/core/export-data), [importData](/docs/funcs/core/import-data))에 대해 **자동분기점**이 형성된다. ### Type `number` ### Options |Value|Description| |-----|-----| |`1`|서버모듈을 (`down2Excel, loadExcel`) 사용합니다. (`default`)| |`2`|클라이언트 모듈을 (`exportData, importData`) 사용합니다. **(IE10이상에서만 사용 가능)** | |`3`|브라우저의 성능에 따라 서버모듈, 클라이언트 모듈로 **자동분기점**을 형성한다. 하위 브라우저(IE9 이하)의 경우: `서버모듈`, 상위 브라우저의 경우: `클라이언트 모듈`.| ### Example ```javascript options.Cfg = { // 서버모듈을 사용 AutoExcelMode: 1 }; // AutoExcelMode: 1, 서버모듈 엑셀 다운 sheet.down2Excel({fileName: \"Excel.xlsx\"}); options.Cfg = { // 클라이언트 모듈 사용 AutoExcelMode: 2 }; // 상위 브라우저(IE10이상), AutoExcelMode: 2, 클라이언트 업로드 sheet.loadExcel(); // sheet.importData()와 같음. options.Cfg = { // 클라이언트 모듈, 서버모듈 자동 분기점. AutoExcelMode: 3 }; // 상위 브라우저(IE10이상), AutoExcelMode: 3, 클라이언트 엑셀 다운 sheet.down2Excel({fileName: \"Excel.xlsx\"}); ```",
              "see": [
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                },
                {
                  "label": "exportData method",
                  "url": "/docs/funcs/core/export-data"
                },
                {
                  "label": "importData method",
                  "url": "/docs/funcs/core/import-data"
                },
                {
                  "label": "loadExcel method",
                  "url": "/docs/funcs/excel/load-excel"
                }
              ],
              "since": "|product|version|desc||---|---|---||excel|8.0.0.4|기능 추가||excel|8.0.0.5|명칭 변경 `ExportMode => AutoExcelMode`|"
            },
            "url": "docs/props/cfg/auto-excel-mode.html"
          },
          {
            "cid": 19,
            "sid": "auto-row-height",
            "name": "auto-row-height",
            "label": "AutoRowHeight",
            "data": {
              "body": "> [SearchMode:0](/docs/props/cfg/search-mode) 인 시트에서 자동 줄넘김이 되어 행의 높이가 각각 다르게 표현 되는 시트가 동작이 되도록 설정하는 옵션입니다. > 컬럼 타입 `Lines`, `Html`, `Img`, `Button` 또는 컬럼 속성 [Wrap](/docs/props/col/wrap), [HtmlPrefix](/docs/props/col/html-prefix), [HtmlPostfix](/docs/props/col/html-postfix), [TextSize](/docs/props/col/text-size), `HtmlPrefixFormula`, `HtmlPostfixFormula`, `TextSizeFormula`, [SignFontStyle](/docs/props/col/sign-font-style)중 `TextSize`속성을 사용한 컬럼이 있을 경우에만 사용이 가능합니다. > **<mark>주의</mark> : 한번 `AutoRowHeight: false` 의 조건으로 생성된 시트에 대해서 `AutoRowHeight: true` 의 조건에 맞게 설정을 변경한 뒤 다시 [rerender](/docs/funcs/core/rerender) 동작을 하더라도 `AutoRowHeight` 옵션 값은 변하지 않습니다. 소스 상 동적으로 해당 속성을 변경하는 경우 시트 내부적으로 충돌이 일어날 수 있습니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|행 높이 자동 맞춤 기능 사용 안함 (`default`)| |`1(true)`|SearchMode:0 모드에서 행 높이 자동 맞춤 기능 사용 (사용 조건에 맞지 않을 경우 `false` 로 변경되어 시트 생성)| ### Example ```javascript options.Cfg{ //SearchMode:0 시트에서 자동 행 높이 기능 사용 SearchMode: 0, AutoRowHeight: true ... }; ``` ### Try it - [True](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/AutoRowHeight-true/)",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                },
                {
                  "label": "Wrap col",
                  "url": "/docs/props/col/wrap"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.27|기능 추가||core|8.3.0.19|`SignFontStyle`속성 중 `TextSize` 대응 추가|"
            },
            "url": "docs/props/cfg/auto-row-height.html"
          },
          {
            "cid": 20,
            "sid": "auto-select-Ym",
            "name": "auto-select-Ym",
            "label": "AutoSelectYm",
            "data": {
              "body": "> 년월 달력일 경우, `AutoSelectYm`을 `1`로 설정 시, 년월 달력에 확인버튼은 사라지고 월 클릭으로 값을 입력 할 수 있다. > `AutoSelectYm`을 `2`로 설정 시, 확인버튼이 사라지지 않고 월 클릭으로 값을 입력 할 수 있다. ### [`AutoSelectYm: 0 또는 2` 설정시] ![다운로드](/assets/imgs/autoselectNon.png) [`AutoSelectYm: 1` 설정시] ![다운로드](/assets/imgs/AutoSelectYm.png) ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|확인버튼으로 값을 입력 할 수 있음. (`default`)| |`1`|확인버튼이 사라지고 월 클릭으로 값을 입력 할 수 있음. | |`2`|확인버튼이 있으며, 월 클릭으로 값을 입력 할 수 있음. | ### Example ```javascript options.Cfg = { // 확인버튼 사라지고 월 클릭으로 값 입력 \"AutoSelectYm\": 1 }; ```",
              "see": [
                {
                  "label": "CalendarButtons col",
                  "url": "/docs/props/col/calendar-buttons"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가||core|8.0.0.19|2 동작 추가|"
            },
            "url": "docs/props/cfg/auto-select-Ym.html"
          },
          {
            "cid": 21,
            "sid": "auto-select-firstenum",
            "name": "auto-select-firstenum",
            "label": "AutoSelectFirstEnum",
            "data": {
              "body": "> `Enum` 컬럼 아이템의 첫번째 값이 선택 되도록 설정 합니다. > 행 추가, setAttribute 함수로 Enum/EnumKeys 설정시에 동작 합니다. > 단 Enum/EnumKeys를 동시에 설정 할 경우 `EnumKeys`를 먼저 설정해야 getValue시 첫번째 아이템의 값으로 읽을 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|Enum 아이템의 첫번째 값이 선택 되도록 설정| ### Example ```javascript options.Cfg = { AutoSelectFirstEnum : 1(true) }; sheet.setAttribute(sheet.getFocusedRow(), \"ComboData\", \"EnumKeys\", \"|101|102\"); sheet.setAttribute(sheet.getFocusedRow(), \"ComboData\", \"Enum\", \"|진행중|완료\"); ```",
              "see": [
                {
                  "label": "addRow",
                  "url": "/docs/funcs/core/add-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.5|기능 추가|"
            },
            "url": "docs/props/cfg/auto-select-firstenum.html"
          },
          {
            "cid": 22,
            "sid": "border-cursors",
            "name": "border-cursors",
            "label": "BorderCursors",
            "data": {
              "body": "> (cfg)[Hover](./hover) : 2 로 행단위 `Hover`를 설정시 호버되는 행의 `Border` 가 보일지 여부를 설정합니다.(`Hover:0/1` 일 때는 동작안함) ### ![borderCursors](/assets/imgs/borderCursors1.png \"borderCursors\") [`borderCursors : 1` 인 경우] ![borderCursors](/assets/imgs/borderCursors0.png \"borderCursors\") [`borderCursors : 0` 인 경우] ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|`Hover` 된 행과 셀의 `Border` 표시 안함| |`1(true)`|`Hover` 된 행과 셀의 `Border` 표시 (`default`) | ### Example ```javascript options.Cfg = { \"Hover\": 2, // 행단위 Hover 동작 \"BorderCursors\": true, // Hover 행과 셀의 Border 표시 }; ```",
              "see": [
                {
                  "label": "Hover cfg",
                  "url": "./hover"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/border-cursors.html"
          },
          {
            "cid": 23,
            "sid": "calc-merge-mode",
            "name": "calc-merge-mode",
            "label": "CalcMergeMode",
            "data": {
              "body": "> [makeSubTotal](/docs/funcs/core/make-sub-total) 혹은 [FormulaRow](/docs/props/col/formula-row) 사용시 머지된 셀을 각각 병합된 하나의 데이터로 계산하도록 기능입니다. > ~~주의 : SearchMode:0 모드에서 사용시 소계 값에 오류가 있을 수 있습니다~~ (8.0.0.8 버전에서 개선) > 사용자 입력에 의해 셀 값을 변경하거나 [setValue](/docs/)로 셀 값 변경 시 [SearchMode](/docs/props/cfg/search-mode)에 따라 [MergeCellsMatch](/docs/props/cfg/merge-cells-match) 혹은 [EditAutoMerge](/docs/props/cfg/edit-auto-merge) 를 반드시 설정해주어야 합니다. > 1. `SearchMode:0/3`: `MergeCellsMatch:1`설정 시 값 편집 시에도 정확한 값 계산 가능 > 2. `SearchMode:1/2`: `EditAutoMerge:1` 혹은 `MergeCellsMatch:1`설정 시 값 편집 시에도 정확한 값 계산 가능 ### [CalcMergeMode: 0 설정시] ![다운로드](/assets/imgs/nonCalcMergeMode.png) [CalcMergeMode: 1 설정시] ![다운로드](/assets/imgs/CalcMergeMode.png) ### Type `number` ### Options |Value|Description| |-----|------| |`0`|소계, FormulaRow사용 시 머지가 된 셀도 Row별 값 계산 (`default`)| |`1`|소계 계산시 머지된 셀을 하나의 값으로 계산([makeSubTotal](/docs/funcs/core/make-sub-total)만 적용)| |`2`|FormulaRow계산 시 머지된 셀을 하나의 값으로 계산 ([FormulaRow](/docs/props/col/formula-row)만 적용)| |`3`|FormulaRow와 소계 계산시 머지가 된 셀을 하나의 값으로 계산(둘다 적용)| ### Example ```javascript options.Cfg = {CalcMergeMode: 1}; sheet.makeSubTotal({...}); ```",
              "see": [
                {
                  "label": "makeSubTotal method",
                  "url": "/docs/funcs/core/make-sub-total"
                },
                {
                  "label": "FormulaRow col",
                  "url": "/docs/props/col/formula-row"
                },
                {
                  "label": "SearchMode",
                  "url": "/docs/props/cfg/search-mode"
                },
                {
                  "label": "EditAutoMerge",
                  "url": "/docs/props/cfg/edit-auto-merge"
                },
                {
                  "label": "MergeCellsMatch",
                  "url": "/docs/props/cfg/merge-cells-match"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가||core|8.0.0.8|SearchMode:0에서 동작하게 수정||core|8.0.0.11|CalcMergeMode: 2/3 추가|"
            },
            "url": "docs/props/cfg/calc-merge-mode.html"
          },
          {
            "cid": 24,
            "sid": "can-col-move",
            "name": "can-col-move",
            "label": "CanColMove",
            "data": {
              "body": "> 사용자가 시트의 헤더셀을 드래그하여 열의 위치를 변경하는 기능을 허용할지 여부를 설정합니다. > 열 이동시 헤더 열과 데이터 열이 같이 이동됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|열 이동 불가능| |`1`|열 이동 가능 (`default`)| |`2`|헤더가 2줄 이상일 때 부모 헤더가 열병합 되어있는 경우 병합된 영역 안에서만 이동 가능| ### Example ```javascript options.Cfg = { \"CanColMove\":0 // 사용자 열 순서 변경 불가 }; ``` ### Try it - [Set to 2](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/CanColMove-2/)",
              "see": [
                {
                  "label": "CanMove col",
                  "url": "/docs/props/col/can-move"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.2.0.12|`CanColMove: 2` 기능 추가|"
            },
            "url": "docs/props/cfg/can-col-move.html"
          },
          {
            "cid": 25,
            "sid": "can-col-resize",
            "name": "can-col-resize",
            "label": "CanColResize",
            "data": {
              "body": "> 마우스를 통한 열 너비 조정의 가능여부를 설정할 수 있습니다. > 기본값은 `1(true)` 로 헤더 영역의 열과 열 사이에서 마우스를 이용하여 너비조절을 할 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열 너비 조정 불가능| |`1(true)`|열 너비 조정 가능 (`default`)| ### Example ```javascript options.Cfg = { \"CanColResize\": true // 열 너비 조정 불허 }; ``` ### Try it - [True by default](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/CanColResize-true/)",
              "see": [
                {
                  "label": "CanResize col",
                  "url": "/docs/props/col/can-resize"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/can-col-resize.html"
          },
          {
            "cid": 26,
            "sid": "can-drag",
            "name": "can-drag",
            "label": "CanDrag",
            "data": {
              "body": "> 마우스 드래그로 행을 이동할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|마우스 드래그를 통한 행 이동 불가 (`default`)| |`1(true)`|마우스 드래그를 통한 행 이동 가능| ### Example ```javascript options.Cfg = { \"CanDrag\": true //마우스 드래그를 통한 행 이동 설정 }; ``` ### Try it - [True](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/CanDrag-true/)",
              "see": [
                {
                  "label": "CanDrag row",
                  "url": "/docs/props/row/can-drag"
                },
                {
                  "label": "DragCell cfg",
                  "url": "./drag-cell"
                },
                {
                  "label": "DragObject cfg",
                  "url": "./drag-object"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/can-drag.html"
          },
          {
            "cid": 27,
            "sid": "can-edit",
            "name": "can-edit",
            "label": "CanEdit",
            "data": {
              "body": "> 전체적인 시트의 편집 가능여부를 설정합니다. > 전체 편집이 가능한 경우에만 셀별 편집 가능여부 설정이 동작합니다. > 필터, 그룹행의 경우 해당 속성의 영향을 **받지 않습니다**. > `CanEdit: 4`를 제외하고는 편집불가 모드 사용시 `Enum` 컬럼의 아이콘과 `Date` 타입 컬럼의 달력 아이콘을 표현하지 않습니다. > `Cfg`를 이용하여 편집불가 사용시에는 우선순위가 가장 높아짐으로, `Cell, Row, Col`에 `CanEdit: 0`은 먹히지 않습니다. > `Button` 타입의 버튼 클릭 시 동작, `File` 타입의 아이콘 표시 여부에 대해서는 해당 속성의 영향을 **`받지 않습니다`**. ([Disabled col](/docs/props/col/disabled) 통하여 제어 가능.) ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|전체 편집 불가능| |`1`|전체 편집 가능 (`default`)| |`3`|전체 편집 불가능(편집 가능 불가능에 대한 배경색을 표시하지 않음) [ColorState (cfg)](/docs/props/cfg/color-state)와 관계없이 배경색을 표현하지 않음. |`4`|전체 편집 불가능 + 배경색 표현안함 + 아이콘 표시| ### Example ```javascript options.Cfg = { \"CanEdit\":0 }; ```",
              "see": [
                {
                  "label": "ColorState cfg",
                  "url": "/docs/props/cfg/color-state"
                },
                {
                  "label": "CanEdit row",
                  "url": "/docs/props/row/can-edit"
                },
                {
                  "label": "CanEdit col",
                  "url": "/docs/props/col/can-edit"
                },
                {
                  "label": "CanEdit cell",
                  "url": "/docs/props/cell/can-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.12|`CanEdit: 4` 추가|"
            },
            "url": "docs/props/cfg/can-edit.html"
          },
          {
            "cid": 28,
            "sid": "can-select",
            "name": "can-select",
            "label": "CanSelect",
            "data": {
              "body": "> 행 또는 셀 선택이 가능한지에 대한 여부를 설정합니다. > 셀에 포커스를 주는 것과 셀 선택을 하는 것은 다르게 동작이 가능합니다. > 포커스가 있는 행 또는 셀 과 다르게 다른 영역의 셀과 행들을 선택할 수 있으며, 이 때는 `CanSelect` 속성에 따라 동작합니다. > 기본적으로 행를 선택하되 셀과 열을 선택하지 않을 때 `SelectingCells: 0` 을 설정할 수 있습니다. > 기본값은 `1(true)` 입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|행 또는 셀 선택 불가| |`1(true)`|행 또는 셀 선택 가능 (`default`)| ### Example ```javascript options.Cfg = { \"CanSelect\": true, // 시트 선택 가능 \"SelectingCells\": 0, // 개별 셀 선택 불가능 }; ```",
              "see": [
                {
                  "label": "SelectingCells cfg",
                  "url": "./selecting-cells"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/can-select.html"
          },
          {
            "cid": 29,
            "sid": "can-sort",
            "name": "can-sort",
            "label": "CanSort",
            "data": {
              "body": "> 헤더 클릭을 통한 열 정렬(`Sort`) 기능의 허용 여부를 설정합니다. > [SortIcons cfg](./sort-icons) 설정에 따라 헤더 정렬 아이콘을 숨길 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|정렬 기능 사용 안함| |`1(true)`|정렬 기능 사용 (`default`)| ### Example ```javascript options.Cfg = { CanSort: false, // 정렬 기능 사용 안함 }; ``` ### Try it - [True by default](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/CanSort-true/)",
              "see": [
                {
                  "label": "SortIcons cfg",
                  "url": "./sort-icons"
                },
                {
                  "label": "CanSort row",
                  "url": "/docs/props/row/can-sort"
                },
                {
                  "label": "CanSort col",
                  "url": "/docs/props/col/can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/can-sort.html"
          },
          {
            "cid": 30,
            "sid": "center-message",
            "name": "center-message",
            "label": "CenterMessage",
            "data": {
              "body": "> 시트에서 발생하는 메세지(div layer)를 시트의 위치와 무관하게 화면 한가운데 표시합니다. > 해당 속성을 설정하지 않는 경우, 시트 객체의 가운데에 메세지가 표시됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|시트객체의 가운데에 메세지를 표시 (`default`)| |`1(true)`|현재 보여지는 화면의 가운데에 메세지를 표시| ### Example ```javascript options = { \"Cfg\":{ \"CenterMessage\": true, // 시트의 메세지를 화면 중앙에 표시 } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.1|기능 추가|"
            },
            "url": "docs/props/cfg/center-message.html"
          },
          {
            "cid": 31,
            "sid": "clear-filter-off",
            "name": "clear-filter-off",
            "label": "ClearFilterOff",
            "data": {
              "body": "> 필터행의 연산자 중 사용안함(X) 선택시 필터 셀 값을 삭제할지 여부를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|필터 사용안함(x) 선택시 필터셀의 값을 유지 (`default`)| |`1`|필터 사용안함(x) 선택시 필터셀의 값을 삭제| ### Example ```javascript options = { \"Cfg\":{ \"ClearFilterOff\":1, // 필터 사용안함(x) 선택시 필터셀 값 삭제 } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/clear-filter-off.html"
          },
          {
            "cid": 32,
            "sid": "click-pivot-filter",
            "name": "click-pivot-filter",
            "label": "ClickPivotFilter",
            "data": {
              "body": "> 피벗 시트에서 피벗 데이터를 클릭할 경우 원본 시트에서 해당 피벗 데이터의 행들을 필터링하여 보여줍니다. > 필터된 시트에서 원본 시트를 보고 싶은 경우 [clearFilter](/docs/funcs/core/clear-filter) 해야합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|피벗 시트 클릭 필터 기능 사용 안함 (`default`)| |`1(true)`|피벗 시트 클릭 필터 기능 사용| ### Example ```javascript options = { \"Cfg\":{ \"ClickPivotFilter\": 1, // 피벗 시트 클릭 필터 기능 사용 } }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "makePivotTable method",
                  "url": "/docs/funcs/core/make-pivot-table"
                },
                {
                  "label": "switchPivotSheet method",
                  "url": "/docs/funcs/core/switch-pivot-sheet"
                },
                {
                  "label": "clearFilter method",
                  "url": "/docs/funcs/core/clear-filter"
                },
                {
                  "label": "setFilter method",
                  "url": "/docs/funcs/core/set-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.20|기능 추가|"
            },
            "url": "docs/props/cfg/click-pivot-filter.html"
          },
          {
            "cid": 33,
            "sid": "color-state",
            "name": "color-state",
            "label": "ColorState",
            "data": {
              "body": "> 편집가능 여부, 입력/수정/삭제 상태 등과 관련하여 자동으로 표현되는 시트 데이터 영역의 배경색과 관련하여 사용여부를 설정합니다. > 0으로 설정시 시트내에 상태나, 편집여부등에 따라 표현되는 배경색이 모두 제거되고, 설정값에 따라서 해당 기능에 대한 배경색이 표현됩니다. > bit 연산 형태로 속성을 설정합니다. 가령 값으로 5를 설정시 1번옵션 + 4번 옵션에 대해 배경색을 표현하게 됩니다. > 기본값(`default`)은 **`63`** 입니다. ### Type `number` ### Options |Value|Description|Class| |-----|-----|---| |`0`|상태에 따른 배경색 표현 안함.|| |`1`|수정된 **셀** 에 대한 배경색 표현|`.IBColorChangedCell`| |`2`|입력/수정/삭제된 **행** 에 대한 배경색 표현|`.IBColorAdded`,`.IBColorChanged`,`.IBColorDeleted`| |`4`|추가/삭제 된 **열** 에 대한 배경색 표현|`.IBColorAdded`,`.IBColorDeleted`| |`8`|셀의 `CanEdit`, `CanFocus` 속성이 `false`인 경우에 대한 배경색 표현|`.IBColorReadOnly`,`.IBColorNoFocus`| |`16`|셀의 값을 직접 수정이 불가능한 `Formula`(셀의 값을 계산하는 `Formula`)가 설정된 경우에 대한 배경색 표현|`.IBColorReadOnly`| |`32`|오류가 있는 셀에 대한 배경색 표현|`.IBColorError`| ### Example ```javascript options.Cfg = { \"ColorState\": 7 // 편집할 수 없는 셀의 배경색을 표현하지 않음 }; ```",
              "see": [
                {
                  "label": "CanEdit cell",
                  "url": "/docs/props/cell/can-focus"
                },
                {
                  "label": "CanFocus cell",
                  "url": "/docs/props/cell/can-focus"
                },
                {
                  "label": "Error cell",
                  "url": "/docs/props/cell/error"
                },
                {
                  "label": "Added row",
                  "url": "/docs/props/row/added"
                },
                {
                  "label": "Changed row",
                  "url": "/docs/props/row/changed"
                },
                {
                  "label": "Deleted row",
                  "url": "/docs/props/row/deleted"
                },
                {
                  "label": "CanEdit row",
                  "url": "/docs/props/row/can-focus"
                },
                {
                  "label": "CanFocus row",
                  "url": "/docs/props/row/can-focus"
                },
                {
                  "label": "CanFocus col",
                  "url": "/docs/props/col/can-focus"
                },
                {
                  "label": "CanEdit col",
                  "url": "/docs/props/col/can-focus"
                },
                {
                  "label": "CanEdit cfg",
                  "url": "/docs/props/cfg/can-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/color-state.html"
          },
          {
            "cid": 34,
            "sid": "controls-tag",
            "name": "controls-tag",
            "label": "ControlsTag",
            "data": {
              "body": "> 시트 내 팝업 메뉴, 툴팁, 메시지, 힌트를 띄울 위치를 설정하기 위한 부모 태그를 지정하는 옵션입니다. > > 해당 옵션을 설정하지 않을 경우 부모 태그는 `document.body` 내부에 자동적으로 생성됩니다. > > SalesForce의 Lightening Web Component나 ShadowDOM 환경처럼 `document.body` 전체를 시트의 기준 영역으로 설정하지 않고 페이지 내 특정 컴포넌트 영역을 시트 기준 영역으로 잡아야 할 경우, 해당 컴포넌트 내에 별도로 div를 만들어 해당 div를 `(Cfg) ControlsTag`로 설정해야 합니다. > > 주의사항 > * `ControlsTag`는 시트를 처음 생성할 때 설정해야 하며, 이후에는 동적으로 변경할 수 없습니다. > * `ControlsTag`는 반드시 시트의 DIV와 동일한 컴포넌트 영역에 있어야 하며, 시트의 DIV가 생성되는 컴포넌트보다 상위 컴포넌트에 생성되어서는 안됩니다. > * `ControlsTag`는 반드시 `position:absolute;left:0px;top:0px;` 스타일이 적용되어 생성되어야 합니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|시트 내 팝업 메뉴, 툴팁, 메시지, 힌트를 띄울 위치를 설정하기 위한 부모 태그| ### Example ```javascript <template> <lightning-card> <div> <div class=\"IBControls\" style=\"position:absolute;left:0px;top:0px;\" lwc:dom=\"manual\"></div> <!-- LWC 환경의 컴포넌트 내부에서 ControlsTag 역할을 맡을 태그를 생성 --> <div class=\"sheetDiv\" style=\"width: 100%; height: 400px;\" lwc:dom=\"manual\"></div> </div> </lightning-card> </template> ... options.Cfg = { ControlsTag: this.template.querySelector(\".IBControls\") // 시트 내 팝업 메뉴, 툴팁, 메시지, 힌트를 띄울 위치를 설정하기 위한 부모 태그 설정 }; ```",
              "see": [
                {
                  "label": "DialogsArea cfg",
                  "url": "/docs/props/cfg/dialogs-area"
                },
                {
                  "label": "IBSheet.QuerySelector static",
                  "url": "/docs/static/query-selector"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/controls-tag.html"
          },
          {
            "cid": 35,
            "sid": "copy-cols",
            "name": "copy-cols",
            "label": "CopyCols",
            "data": {
              "body": "> 복사하여 붙여넣기에 사용할 열을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|포커스된 열만 붙여넣기에 사용| |`1`|모든 표시열을 붙여넣기에 사용 (`SelectingCells : 0` 인 경우 해당 값이 `default`로 설정됩니다.)| |`2`|모든 열을 붙여넣기에 사용(숨겨진 컬럼도 포함)| |`3`|포커스된 행에 대해서만 포커스된 셀 범위 또는 모든 표시 열(`default`)| ### Example ```javascript options = { \"Cfg\":{ \"CopyCols\": 1, // 모든 표시열을 붙여넣기에 사용 } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.20|기능 추가|"
            },
            "url": "docs/props/cfg/copy-cols.html"
          },
          {
            "cid": 36,
            "sid": "copy-edit",
            "name": "copy-edit",
            "label": "CopyEdit",
            "data": {
              "body": "> `ctrl+c`를 통해 선택된 셀의 값을 `clipboard`로 복사시 마스크가 포함된 문자([Format](/docs/props/col/format))로 복사할지, 편집시 사용되는 포맷([EditFormat](/docs/props/col/edit-format)) 복사할지를 설정합니다. > `ctrl+v`를 통해 값을 붙여넣기 하는 경우에는, [EditFormat](/docs/props/col/edit-format)이 적용된 셀값을 복사하는 것이 적합합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|`Format`이 적용된 셀값을 복사, `CustomFormat`이 설정되어 있다면 `CustomFormat`을 우선 적용하여 적용된 셀값을 복사| |`1`|`EditFormat`이 적용된 셀값을 복사 (`default`)| ### Example ```javascript options = { \"Cfg\":{ \"CopyEdit\": 0, // Format 이 적용된 셀값으로 복사 } }; ```",
              "see": [
                {
                  "label": "Format col",
                  "url": "/docs/props/col/format"
                },
                {
                  "label": "CustomFormat col",
                  "url": "/docs/props/col/custom-format"
                },
                {
                  "label": "EditFormat col",
                  "url": "/docs/props/col/edit-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/copy-edit.html"
          },
          {
            "cid": 37,
            "sid": "copy-paste-hidden",
            "name": "copy-paste-hidden",
            "label": "CopyPasteHidden",
            "data": {
              "body": "> 숨긴 행/열에 붙여넣기 가능여부를 설정합니다. (비트연산으로 제공합니다) ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|숨김 처리된 행, 열은 붙여넣기가 불가능 (`default`)| |`1`|숨김 처리된 열은 붙여넣기가 가능, 숨긴 처리된 행은 불가능| |`2`|숨김 처리된 행은 붙여넣기가 가능, 숨긴 처리된 열은 불가능| ### Example ```javascript options = { \"Cfg\":{ \"CopyPasteHidden\":3, // 숨김 처리된 행, 열에 붙여넣기 기능 사용 } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/copy-paste-hidden.html"
          },
          {
            "cid": 38,
            "sid": "ctrl-arange",
            "name": "ctrl-arange",
            "label": "CtrlARange",
            "data": {
              "body": "> `Ctrl + A` 를 사용하여 선택복사시 영역을 헤더에서 풋까지 보도록 하는 기능입니다. > 기능 사용시 `CanSelect` 의 유무를 보기 때문에 `Def.Header, Def.Foot` 에 `CanSelect: 1` 을 설정하면 됩니다. > 예를 들어 `Header` 에만 `CanSelect: 1` 로 설정하고 `Foot` 에 `CanSelect: 0` 으로 설정시에 `Foot` 은 선택복사가 되지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|선택 복사시 데이터 영역만 봄. (`default`)| |`1(true)`|선택 복사시 헤더부터 풋영역까지 보도록 함.| ### Example ```javascript options.Def = { Header: { CanSelect: true }, Foot: { CanSelect: true }, }; options.Cfg = { CtrlARange: true // Ctrl + A 의 선택복사 영역을 헤더부터 풋 까지 보게 합니다. }; ```",
              "see": [
                {
                  "label": "CanSelect row",
                  "url": "/docs/props/row/can-select"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.23|기능 추가|"
            },
            "url": "docs/props/cfg/ctrl-arange.html"
          },
          {
            "cid": 39,
            "sid": "custom-scroll",
            "name": "custom-scroll",
            "label": "CustomScroll",
            "data": {
              "body": "> 시트에서 사용될 스크롤바의 타입을 설정합니다. > 시트 섹션별 생성되는 가로 스크롤이나 전체 시트에 생성되는 가로/세로 스크롤바에 해당합니다. > 행과 열 수가 많은 시트에서는 `CustomScroll` 설정시 속도저하를 일으킬 수 있습니다. > `SearchMode:2 (LazyLoad)`의 경우 조회데이터수가 5만건 이상일때 IE 브라우저에서의 스크롤 설정 한계로 인하여 반드시 커스텀 스크롤을 0 이외의 값으로 설정해야 합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|브라우저 스크롤바 사용 (`default`) ![CustomScroll0](/assets/imgs/customScroll0.png \"CustomScroll0\") (by Chrome)| |`1`|평범한 스타일의 스크롤바 사용 ![CustomScroll1](/assets/imgs/customScroll1.png \"CustomScroll1\") (by Chrome)| |`2`|큰 스타일의 스크롤바 사용 ![CustomScroll2](/assets/imgs/customScroll2.png \"CustomScroll2\") (by Chrome)| |`3`|작은 스타일의 스크롤바 사용 ![CustomScroll3](/assets/imgs/customScroll3.png \"CustomScroll3\") (by Chrome)| ### Example ```javascript options.Cfg = { CustomScroll: 3 // 작은 스타일의 스크롤바 설정 }; ``` ### Try it - [0 by default](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/CustomScroll/)",
              "see": [
                {
                  "label": "TouchScroll cfg",
                  "url": "./touch-scroll"
                },
                {
                  "label": "CustomThumbMinSize cfg",
                  "url": "./custom-thumb-min-size"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/custom-scroll.html"
          },
          {
            "cid": 40,
            "sid": "custom-thumb-min-size",
            "name": "custom-thumb-min-size",
            "label": "CustomThumbMinSize",
            "data": {
              "body": "> [CustomScroll](./custom-scroll) 옵션을 통해 시트의 스크롤을 브라우져의 기본스크롤이 아닌 이미지 형태를 사용할 때, Thumb 의 최소 크기를 설정합니다. > 스크롤 바 내에서 현재 위치를 표시하는 thumb는 조회데이터 양이 많아지면 크기가 유동적으로 줄어들게 되는데, 해당 속성을 통해 최소한의 크기를 pixel단위로 지정하면 이 이하로 줄어드는 것을 방지합니다. > 해당 옵션은 가로와 세로 스크롤 바 모두 적용됩니다. ### ![CustomThumbMinSize](/assets/imgs/scrollthumb.png \"CustomThumbMinSize\") ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|스크롤바 thumb의 최소 크기 설정| ### Example ```javascript options.Cfg = { CustomScroll:1, CustomThumbMinSize:150, //150 pixel 보다 줄어들지 않게 한다. }; ```",
              "see": [
                {
                  "label": "TouchScroll cfg",
                  "url": "./touch-scroll"
                },
                {
                  "label": "CustomScroll cfg",
                  "url": "./custom-scroll"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.2|기능 추가|"
            },
            "url": "docs/props/cfg/custom-thumb-min-size.html"
          },
          {
            "cid": 41,
            "sid": "data-auto-trim",
            "name": "data-auto-trim",
            "label": "DataAutoTrim",
            "data": {
              "body": "> 조회 시 데이터의 공백 트림 여부를 설정합니다. > 이 속성을 `1(true)`로 설정한다면 조회, 데이터 입력, `setValue` 시 데이터에 있는 공백을 자동으로 트림합니다. > **<mark>주의</mark> : 해당 옵션 사용시 조회 성능에 영향을 줄 수 있습니다. 특히, `SearchMode:0 (FastLoad)` 또는 `SearchMode:3 (ScrollApend)` 모드를 제외한 조회 모드에는 데이터 양에 따라 조회 성능에 더 많은 영향을 줄 수 있습니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|조회 시 데이터 트림 안함 (`default`)| |`1(true)`|조회 시 데이터 트림| ### Example ```javascript // 조회 시 모든 데이터를 Trim 한다 options.Cfg = { DataAutoTrim: true }; ```",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가||core|8.0.0.19|데이터 입력, `setValue` 시에도 공백처리 되도록 추가|"
            },
            "url": "docs/props/cfg/data-auto-trim.html"
          },
          {
            "cid": 42,
            "sid": "data-merge",
            "name": "data-merge",
            "label": "DataMerge",
            "data": {
              "body": "> 시트 생성 시 데이터 영역에서 셀 값을 기준으로 병합할지 여부 및 병합 종류를 설정합니다. > 시트 생성 후 setAutoMerge메소드를 이용하여 데이터 영역의 병합을 동적으로 변경할 수도 있습니다. > DataMerge가 설정된 시트에서 [setValue](/docs/funcs/core/set-value) 메소드를 사용할 때 해당 메소드에 render 인자를 0으로 주면 데이터 영역에서 머지가 적용되지 않습니다. 화면에 머지를 적용하고 싶은 경우 [rerender](/docs/funcs/core/rerender) 메소드를 호출해야합니다. > [Span](/docs/props/cell/span)과 [RowSpan](/docs/props/cell/row-span)보다 우선 적용됩니다. > **특정 컬럼만 상하 병합에서 제외하고자 하실때는 해당 컬럼 생성시 [ColMerge](/docs/props/col/col-merge) 속성값을 0(false)로 설정하시면 됩니다.** > **유사하게 특정 컬럼만 좌우 병합에서 제외하고 자 하실때는 해당 컬럼 생성시 [RowMerge](/docs/props/row/row-merge) 속성값을 0(false)로 설정하시면 됩니다.** > **<mark>주의</mark> : 소계([makeSubTotal (method)](/docs/funcs/core/make-sub-total))사용 시 해당 옵션에 설정한 값은 무시되고 `DataMerge: 1` 로 동작합니다.** > 트리에서 해당 기능을 사용시에는 `DataMerge: 1` 기능만을 지원하고 머지에 관련되서는 다른 기능은 지원하지 않습니다. 사용시에는 같은 레벨에 한해서 자동머지가 일어납니다. ### Type `number` ### Options |Value|Description| | |-----|-----|----| |`0`|병합 안함 (`default`) |병합을 하지 않습니다. ![option0](/assets/imgs/dataMerge0.png \"option0\")| |`1`|열 기준 병합|각 열에 대해 이전 혹은 다음 행의 값이 같은 경우 행들을 병합합니다. ![option1](/assets/imgs/dataMerge1.png \"option1\")| |`2`|행 기준 병합|각 행에 대해 이전 혹은 다음 열의 값이 같은 경우 열들을 병합합니다. ![option2](/assets/imgs/dataMerge2.png \"option2\")| |`3`|열 우선 병합|열 기준 병합(a)를 수행한 후 병합되지 않은 셀들에 행 기준 병합(b)를 실행합니다. ![option3](/assets/imgs/dataMerge3.png \"option3\")| |`4`|행 우선 병합|행 기준 병합(b)를 수행한 후 병합되지 않은 셀들에 열 기준 병합(a)를 실행합니다. ![option4](/assets/imgs/dataMerge4.png \"option4\")| |`5`|열 우선 사방 병합|열 기준 병합을 수행하면서 이웃한 열에 대해서도 값이 같으면 열끼리도 병합합니다. ![option5](/assets/imgs/dataMerge5.png \"option5\")| |`6`|행 우선 사방 병합|행 기준 병합을 수행하면서 이웃한 행에 대해서도 값이 같으면 행끼리도 병합합니다. ![option6](/assets/imgs/dataMerge6.png \"option6\")| ### Example ```javascript options = { \"Cfg\" :{ \"DataMerge\":1, // 시트 생성 시 데이터 영역의 셀을 열 기준으로 병합합니다. } }; ``` ### Try it - [0 by default with setAutoMerge](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/Merge/)",
              "see": [
                {
                  "label": "Span cell",
                  "url": "/docs/props/cell/span"
                },
                {
                  "label": "RowSpan cell",
                  "url": "/docs/props/cell/row-span"
                },
                {
                  "label": "ColMerge col",
                  "url": "/docs/props/col/col-merge"
                },
                {
                  "label": "RowMerge row",
                  "url": "/docs/props/row/row-merge"
                },
                {
                  "label": "HeaderMerge cfg",
                  "url": "./header-merge"
                },
                {
                  "label": "PrevColumnMerge cfg",
                  "url": "./prev-column-merge"
                },
                {
                  "label": "setAutoMerge method",
                  "url": "/docs/funcs/core/set-auto-merge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.8|트리에 대한 `DataMerge`기능 추가 (`mode:1 말고는 사용 불가`)|"
            },
            "url": "docs/props/cfg/data-merge.html"
          },
          {
            "cid": 43,
            "sid": "date-strict-mode",
            "name": "date-strict-mode",
            "label": "DateStrictMode",
            "data": {
              "body": "> 조회시 날짜 타입에 `DataFormat`이 설정된 경우 설정된 포맷과 길이가 일치하지 않거나 잘못된 날짜가 조회되는 경우 공백으로 처리합니다. > `DataFormat`을 \"yyyyMMdd\" 로 설정한 후 \"88\" 이라는 값이 조회되는 경우 해당 셀 값은 공백으로 처리됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|정밀검사하지 않음 (`default`)| |`1(true)`|`DataFormat`에 설정된 포맷에 대한 정밀 검사| ### Example ```javascript //잘못된 날짜 데이터 조회시 공백처리 합니다. options.Cfg = { DateStrictMode: 1 }; options.Cols = [ ... // DateStrictMode를 사용하기 위해선 DataFormat이 설정되어야 합니다. {Type: \"Date\", Format: \"yyyy.MM.dd\", DataFormat: \"yyyyMMdd\", Name: \"enterDate\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "DataFormat col",
                  "url": "/docs/props/col/data-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.12|기능 추가|"
            },
            "url": "docs/props/cfg/date-strict-mode.html"
          },
          {
            "cid": 44,
            "sid": "debounce-render",
            "name": "debounce-render",
            "label": "DebounceRender",
            "data": {
              "body": "> `rerender`, `renderBody` 호출시 debounce를 걸어 호출합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| | `0` | `rerender`, `renderBody` 호출시 debounce를 걸지 않습니다. (`default`)| | `1` | `rerender`, `renderBody` 호출시 debounce를 걸어 호출합니다. | ### Example ```javascript options = { Cfg :{ DebounceRender: 1, // `rerender`, `renderBody` 호출시 debounce를 걸어 호출합니다. ... } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.38|기능 추가|"
            },
            "url": "docs/props/cfg/debounce-render.html"
          },
          {
            "cid": 45,
            "sid": "decimal-adjust",
            "name": "decimal-adjust",
            "label": "DecimalAdjust",
            "data": {
              "body": "> Int, Float 타입 컬럼 데이터의 근사값 처리방식을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`round`|근사값을 반올림으로 처리합니다. (`default`)| |`floor`|근사값을 내림으로 처리합니다.| |`ceil`|근사값을 올림으로 처리합니다.| ### Example ```javascript options.Cols = [ ... {Type: \"Int\", Name: \"Pvt_TSum\", DecimalAdjust: \"floor\", ...}, // 근사값 처리 방식을 내림으로 설정 ... ]; ``` ### Try it - [\"round\" by default](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/DecimalAdjust-round/) ### Since |product|version|desc| |---|---|---| |core|8.0.0.11|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|8.0.0.11|기능 추가|"
            },
            "url": "docs/props/cfg/decimal-adjust.html"
          },
          {
            "cid": 46,
            "sid": "dialogs-area",
            "name": "dialogs-area",
            "label": "DialogsArea",
            "data": {
              "body": "> 시트 내 다이얼로그의 위치를 설정하기 위한 영역을 지정합니다. > > SalesForce의 Lightening Web Component나 ShadowDOM 환경처럼 `document.body` 전체를 다이얼로그의 기준 영역으로 설정하지 않고 페이지 내 특정 컴포넌트 영역을 다이얼로그의 기준 영역으로 잡아야 할 경우, 해당 컴포넌트의 body에 해당하는 영역을 `(Cfg) DialogsArea`로 설정해주시면 됩니다. > > 더불어 `DialogsArea`는 반드시 시트의 DIV와 동일한 컴포넌트 영역에 있어야 하며, 시트의 DIV가 생성되는 컴포넌트보다 상위 컴포넌트에 생성되어서는 안됩니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|시트 내 다이얼로그의 위치를 설정하기 위한 영역| ### Example ```javascript <template> <lightning-card> <!-- LWC 컴포넌트에서 Body에 해당하는 영역 --> <div> <div class=\"IBControls\" lwc:dom=\"manual\"></div> <div class=\"sheetDiv\" style=\"width: 100%; height: 400px;\" lwc:dom=\"manual\"></div> </div> </lightning-card> </template> ... options.Cfg = { DialogsArea: this.template.firstChild, // lightning-card 태그를 시트 내 다이얼로그의 위치를 설정하기 위한 영역으로 지정 }; ```",
              "see": [
                {
                  "label": "ControlsTag cfg",
                  "url": "/docs/props/cfg/controls-tag"
                },
                {
                  "label": "IBSheet.QuerySelector static",
                  "url": "/docs/static/query-selector"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/dialogs-area.html"
          },
          {
            "cid": 47,
            "sid": "disable-keyword",
            "name": "disable-keyword",
            "label": "DisableKeyWord",
            "data": {
              "body": "> 필터행에서 예약어로 설정되어 있는 `;(or)` 나 `,(and)` 의 사용여부를 설정합니다. > 해당 기능을 `1(true)` 설정시 예약어 기능이 사용되지 않습니다. 해당 기능을 사용하면 필터행에 입력된 문자열 그대로 필터링 하게 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|예약어 기능 사용 (`default`)| |`1(true)`|예약어 기능 사용하지 않음| ### Example ```javascript // 필터행에서 예약어 `;` , `,` 를 사용하지 않도록 처리합니다. options.Cfg = { DisableKeyWord: 1 }; ```",
              "see": [
                {
                  "label": "필터링 기능",
                  "url": "/docs/userGuide/filter"
                },
                {
                  "label": "showFilterRow",
                  "url": "/docs/funcs/core/show-filter-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.53|기능 추가|"
            },
            "url": "docs/props/cfg/disable-keyword.html"
          },
          {
            "cid": 48,
            "sid": "down-to-excel-config",
            "name": "down-to-excel-config",
            "label": "Down2ExcelConfig",
            "data": {
              "body": "> [down2Excel](/docs/funcs/excel/down-to-excel) 함수 호출시 들어가는 인자를 공통으로 설정합니다. > [CommontOptions (static)](/docs/static/common-options)에 Cfg속성에 설정하시면 모든 화면에서 [down2Excel](/docs/funcs/excel/down-to-excel) 함수 호출시 기본적인 속성을 설정하실 수 있습니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|[down2Excel](/docs/funcs/excel/down-to-excel) 함수에 들어가는 인자와 동일(각 화면에서 동일한 속성을 설정시 화면에서 설정한 값이 반영됩니다.)| ### Example ```javascript options.Cfg = { // 모든 화면에서 엑셀 다운로드시 기본 속성을 설정 Down2ExcelConfig: { \"sheetDesign\":0, \"merge\":1 } }; ```",
              "see": [
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                },
                {
                  "label": "CommontOptions static",
                  "url": "/docs/static/common-options"
                }
              ],
              "since": "|product|version|desc||---|---|---||excel|0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/down-to-excel-config.html"
          },
          {
            "cid": 49,
            "sid": "down-to-text-config",
            "name": "down-to-text-config",
            "label": "Down2TextConfig",
            "data": {
              "body": "> [down2Text](/docs/funcs/excel/down-to-text) 함수 호출시 들어가는 인자를 공통으로 설정합니다. > [CommontOptions (static)](/docs/static/common-options)에 Cfg속성에 설정하시면 모든 화면에서 [down2Text](/docs/funcs/excel/down-to-text) 함수 호출시 기본적인 속성을 설정하실 수 있습니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|[down2Text](/docs/funcs/excel/down-to-text) 함수에 들어가는 인자와 동일(각 화면에서 동일한 속성을 설정시 화면에서 설정한 값이 반영됩니다.)| ### Example ```javascript options.Cfg = { // 모든 화면에서 텍스트 다운로드시 기본 속성을 설정 \"Down2TextConfig\":{ \"downHeader\": 0, \"downSum\": 0 } }; ```",
              "see": [
                {
                  "label": "down2Text method",
                  "url": "/docs/funcs/excel/down-to-text"
                },
                {
                  "label": "CommontOptions static",
                  "url": "/docs/static/common-options"
                }
              ],
              "since": "|product|version|desc||---|---|---||excel|0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/down-to-text-config.html"
          },
          {
            "cid": 50,
            "sid": "drag-cell",
            "name": "drag-cell",
            "label": "DragCell",
            "data": {
              "body": "> 드래그 시 셀 단위 드래그 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|행 단위 드래깅 (`default`)| |`1(true)`|셀 단위 드래깅| ### Example ```javascript options.Cfg = { \"CanDrag\": true, // 마우스 드래그를 통한 이동 설정 \"DragCell\": true // 셀 단위 드래그 설정 }; ```",
              "see": [
                {
                  "label": "CanDrag cfg",
                  "url": "/docs/props/cfg/can-drag"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.27|기능 추가|"
            },
            "url": "docs/props/cfg/drag-cell.html"
          },
          {
            "cid": 51,
            "sid": "drag-copy",
            "name": "drag-copy",
            "label": "DragCopy",
            "data": {
              "body": "> 두 개의 시트 사이에서 행 이동시 원본 시트의 행 상태를 변경할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|드래그 이동시 원본 시트의 행이 `Deleted` 상태로 변경됨 (`default`)| |`1(true)`|드래그 이동시 원본 시트의 행은 변화없음| ### Example ```javascript options.Cfg = { \"DragCopy\": true //마우스 드래그를 통한 행 이동시 원본시트의 상태변화 없음 }; ```",
              "see": [
                {
                  "label": "CanDrag cfg",
                  "url": "/docs/props/cfg/can-drag"
                },
                {
                  "label": "CanDrag row",
                  "url": "/docs/props/row/can-drag"
                },
                {
                  "label": "onEndDrag event",
                  "url": "/docs/events/on-end-drag"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/drag-copy.html"
          },
          {
            "cid": 52,
            "sid": "drag-fill",
            "name": "drag-fill",
            "label": "DragFill",
            "data": {
              "body": "> 포커스 된 셀 오른쪽 하단을 드래그 시 채우기 동작 활성화 여부를 설정합니다. > <!-- `[비공개]` shift + 드래그 액션을 공유합니다.--> ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|드래그 채우기 동작 비활성 (`default`)| |`1(true)`|드래그 채우기 동작 활성| ### Example ```javascript options.Cfg = { \"DragFill\": true // 채우기 동작 활성화 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.24|기능 추가|"
            },
            "url": "docs/props/cfg/drag-fill.html"
          },
          {
            "cid": 53,
            "sid": "drag-merge",
            "name": "drag-merge",
            "label": "DragMerge",
            "data": {
              "body": "> 병합된 셀을 드래그 시, 첫번째 행과 전체 행의 대상 여부를 선택합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|드래그 한 셀에 병합된 영역 중 첫번째 행만 (`default`)| |`1(true)`|드래그 한 셀에 병합된 영역의 전체 행| ### Example ```javascript options.Cfg = { \"DragMerge\": true }; ```",
              "see": [
                {
                  "label": "CanDrag cfg",
                  "url": "./can-drag"
                },
                {
                  "label": "DragObject cfg",
                  "url": "./drag-object"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.26|기능 추가|"
            },
            "url": "docs/props/cfg/drag-merge.html"
          },
          {
            "cid": 54,
            "sid": "drag-object",
            "name": "drag-object",
            "label": "DragObject",
            "data": {
              "body": "> 행을 드래그할 때 마우스에 보여질 대상을 선택합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|아무것도 보이지 않음| |`1`|행 DOM 객체 (`default`)| |`2`|행의 개수를 담고 있는 메시지| ### Example ```javascript options.Cfg = { DragObject: 2 }; ```",
              "see": [
                {
                  "label": "CanDrag cfg",
                  "url": "./can-drag"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/drag-object.html"
          },
          {
            "cid": 55,
            "sid": "edit-auto-merge",
            "name": "edit-auto-merge",
            "label": "EditAutoMerge",
            "data": {
              "body": "> (cfg)[DataMerge](./data-merge) 또는 (cfg)[HeaderMerge](./header-merge) 설정하여 값 기준 병합 옵션을 사용 시 편집(셀 값 변경, 행 추가 등)할 때 자동으로 셀 병합할지 여부를 설정합니다. > 이 속성을 true로 설정시, 각 셀의 편집 시 매번 병합로직이 수행됨으로 시트가 느려질 수 있습니다. > <mark>이 기능은 SearchMode:0(FastLoad)에서는 동작하지 않습니다.</mark> ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|병합을 하지 않습니다. (`default`)| |`1(true)`|병합을 실행합니다.| ### Example ```javascript options = { Cfg :{ EditAutoMerge: false, // 값 편집시 병합하지 않음. } }; ```",
              "see": [
                {
                  "label": "DataMerge cfg",
                  "url": "./data-merge"
                },
                {
                  "label": "HeaderMerge cfg",
                  "url": "./header-merge"
                },
                {
                  "label": "addRow method",
                  "url": "/docs/funcs/core/add-row"
                },
                {
                  "label": "addRows method",
                  "url": "/docs/funcs/core/add-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.5|행 추가 시 셀 병합이 되도록 수정|"
            },
            "url": "docs/props/cfg/edit-auto-merge.html"
          },
          {
            "cid": 56,
            "sid": "edit-errors-message-time",
            "name": "edit-errors-message-time",
            "label": "EditErrorsMessageTime",
            "data": {
              "body": "> 시트를 조작 및 편집할때 발생하는 오류 메시지의 지속시간(보여지는 시간)을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|메시지 지속시간 (`default: 1000, 밀리초 단위(ms)`)| ### Example ```javascript options.Cfg = { EditErrorsMessageTime: 1500, // 메세지 오류 메시지를 1500ms 동안 보여지게 설정 ... }; ```",
              "see": [
                {
                  "label": "showMessageTime method",
                  "url": "/docs/funcs/core/show-message-time"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/edit-errors-message-time.html"
          },
          {
            "cid": 57,
            "sid": "edit-mask-func",
            "name": "edit-mask-func",
            "label": "EditMaskFunc",
            "data": {
              "body": "> 시트 내 특정 열에 해당하는 셀 편집시 사용될 외부 마스킹 라이브러리를 연동시킵니다. > 마스킹을 추가하는 속성과 마스킹을 제거하는 속성(실제 셀에 넣어지는 값은 마스킹이 제거된 값이 필요합니다)을 쌍으로 함께 추가해야합니다. > > 대상 열이름을 키로, 외부 마스킹 라이브러리를 연동시키는 마스킹용 콜백함수(파라미터는 1개)를 값으로 받습니다. > 대상 열이름과 \"Resolve\"의 조합을 키로, 마스킹 제거 콜백함수(파라미터는 1개)를 값으로 받습니다. 해당 콜백함수는 <b>반드시 마스킹이 제거된 값을 리턴</b>해야합니다. > ex) {\"열이름\" : func1, \"열이름Resolve\" : func2, \"열이름2\" : func3, \"열이름2Resolve\": func4 } ### ![EditMaskFunc사용예](/assets/imgs/editMaskFunc.png) 아래는 Cleave나 jquery.inputmask 라이브러리를 이용하여 날짜 입력시 마스크를 적용해 본 예제입니다. ### Type `object` ### Example ```javascript var cleave; options.Cfg = { EditMaskFunc: { \"sDate_yyyyMMdd\": function(input) { // 외부 Cleave 라이브러리를 \"sDate_yyyyMMdd\"에 연동 cleave = new Cleave(input, { date: true, delimiter: '-', datePattern: ['Y', 'm', 'd'] }); }, \"sDate_yyyyMMResolve\": function(input) { // \"sDate_yyyyMMdd\"에 연동된 라이브러리에서 마스킹이 제거된 값을 리턴합니다. return cleave.getRawValue(); }, \"sDate_yyyyMM\": function(input) { // 외부 jquery.inputmask 라이브러리를 \"sDate_yyyyMM\"에 연동 $(input).inputmask(\"9999/99\"); }, \"sDate_yyyyMMResolve\": function(input) { // \"sDate_yyyyMM\"에 연동된 라이브러리에서 마스킹이 제거된 값을 리턴합니다. return $(input)[0].inputmask.unmaskedvalue(); } } }; ``` ### Try it - [Demo of EditMaskFunc](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/EditMaskFunc/)",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/edit-mask-func.html"
          },
          {
            "cid": 58,
            "sid": "edit-select",
            "name": "edit-select",
            "label": "EditSelect",
            "data": {
              "body": "> 편집 될 때 `input` 의 값이 선택될지 여부를 설정할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|편집 시 선택안 함| |`1`|마우스로 편집 모드로 들어갈 시 선택함| |`2`|키보드 키로 편집 모드에 들어갈 시 선택함| |`7`|편집 모드로 들어갈 시 항상 선택(`default`)| ### Example ```javascript options.Cfg :{ EditSelect: 0 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/edit-select.html"
          },
          {
            "cid": 59,
            "sid": "editarrowbehavior",
            "name": "editarrowbehavior",
            "label": "EditArrowBehavior",
            "data": {
              "body": "> 편집 중 키보드 좌/우 방향키로 셀 이동을 할 수 있도록 설정 합니다. > 커서가 편집 중인 텍스트의 좌/우 끝에 도달 했을 때 이동합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|기능 사용 안함 (`default`)| |`1`|편집 불가 컬럼은 건너뛰고 좌/우 셀로 이동합니다.| |`2`|편집 불가 컬럼인 경우에는 포커스 이동 후 편집 모드가 종료 되며 좌/우 셀로 이동합니다.| ### Example ```javascript options.Cfg = { EditArrowBehavior: 2 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.97|기능 추가|"
            },
            "url": "docs/props/cfg/editarrowbehavior.html"
          },
          {
            "cid": 60,
            "sid": "enter-mode",
            "name": "enter-mode",
            "label": "EnterMode",
            "data": {
              "body": "> `Enter` 키를 눌렀을때 셀 편집을 동작시키거나, 아래 방향키(down)나 우측 방향키(또는 Tab 키)와 같이 포커스가 이동하도록 설정할 수 있습니다. > 이동시 `EnterMode` 에 따라 편집 가능한 다음 셀로 이동합니다. > 편집이 불가능한 셀에서는 포커스만 이동합니다. > `EnterMode`는 `object`로 사용하여 `option` 기능을 사용할 수 있습니다. (`option` 기능은 비트연산으로 제공합니다.) ### Type `number | object` ### Options |Name|Type|Description| |-----|-----|-----| |mode|`number`|`0`: `Enter` 키를 누르면 `값 편집(edit) 시작`, (편집 상태) `Enter` 키를 누르면 `편집 종료` (`default`) `1`:`Enter` 키를 누르면 `아래 셀(down) 이동`, 마지막 셀에서 첫 행, 첫 열으로 이동 `2`:`Enter` 키를 누르면 `아래 셀(down) 이동`, 각 열의 마지막 셀에서 행 추가 후 이동 `3`:`Enter` 키를 누르면 `오른쪽 셀(tab) 이동`, 마지막 셀에서 첫 행, 첫 열으로 이동 `4`:`Enter` 키를 누르면 `오른쪽 셀(tab) 이동`, 마지막 셀에서 행 추가 후 첫 열으로 이동 `5`:`Enter` 키를 누르면 `아래 셀(down) 이동`, 마지막 셀에서 포커스 유지 `6`:`Enter` 키를 누르면 `오른쪽 셀(tab) 이동`, 마지막 셀에서 포커스 유지| |option|`number`|`0`:`CanFocus: 0`인 셀을 제외한 모든 셀을 포커스 이동에 포함. (`default`) `1`:`CanEdit: 0` 를 `EnterMode` 포커스 이동에 포함하지 않음.| ### Example ```javascript options.Cfg = { EnterMode: 3 // Enter 키를 누르면 값 편집 시작, 편집 상태에서 Enter키를 누르면 편집 종료 후 오른쪽 셀 이동 ... }; // EnterMode 가 3번이면서 추가적인 option으로 CanEdit: 0 을 확인하고 뛰어 넘어 이동함. options.Cfg = { EnterMode: { mode: 3, option: 1 } } ``` ### Try it - [0 by default with setEnterMode](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/EnterMode/)",
              "see": [
                {
                  "label": "ForceEnterEdit cfg",
                  "url": "./force-enter-edit"
                },
                {
                  "label": "AcceptEnters col",
                  "url": "/docs/props/col/accept-enters"
                },
                {
                  "label": "AcceptEnters cell",
                  "url": "/docs/props/cell/accept-enters"
                },
                {
                  "label": "setEnterMode method",
                  "url": "/docs/funcs/core/set-enter-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.7|5, 6 기능 추가, `EnterMode` 사용시 편집 불가능한 셀로도 이동할 수 있도록 수정||core|8.0.0.14|option 기능 추가 (비트 연산으로 제공)|"
            },
            "url": "docs/props/cfg/enter-mode.html"
          },
          {
            "cid": 61,
            "sid": "enum-open-mode",
            "name": "enum-open-mode",
            "label": "EnumOpenMode",
            "data": {
              "body": "> 포커스 이동 간에 Enum목록 열기 방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |0(false)|포커스 시 Enum 리스트 목록을 표시하지 않음| |1(true)|포커스 시 Enum 리스트 목록을 표시 (`default`)| ### Example ```javascript options.Cfg = { EnumOpenMode: false // 포커스 시 Enum 리스트 목록을 표시하지 않음 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.11|기능 추가|"
            },
            "url": "docs/props/cfg/enum-open-mode.html"
          },
          {
            "cid": 62,
            "sid": "exact-check",
            "name": "exact-check",
            "label": "ExactCheck",
            "data": {
              "body": "> `Bool`, `Radio` 타입 컬럼에서 정확한 체크박스나 라디오 버튼이 아닌 셀의 빈 공간을 클릭할 때 체크/언체크가 되지 않도록 설정합니다. > [`HeaderCheck`](/docs/props/cfg/header-check) 사용하여 표시되는 헤더 체크박스에도 적용이 됩니다. > **<mark>주의</mark> : 해당 속성과 관계없이 `Enum`이 설정된 `Radio` 컬럼에서는 라디오 버튼 옆 텍스트를 클릭해도 체크가 됩니다.** > 헤더 체크박스 사용 시, `\"Header\": {\"Value\": \"\", \"IconAlign\": \"Center\"}`과 같이 헤더 체크박스 아이콘이 셀 가운데로 출력 되도록 설정하셔야 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|셀 클릭으로 체크박스 클릭 (`default`)| |`1(true)`|셀 클릭으로 체크박스 클릭 안됨| ### Example ```javascript options.Cfg = { ExactCheck: true // 체크박스 클릭에만 체크/언체크가 동작 }; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.19|기능 추가||core|8.1.0.6|헤더 체크 기능 적용|"
            },
            "url": "docs/props/cfg/exact-check.html"
          },
          {
            "cid": 63,
            "sid": "exclude-add-del-status",
            "name": "exclude-add-del-status",
            "label": "ExcludeAddDelStatus",
            "data": {
              "body": "> 행 추출 함수 사용시 상태가 `Added` 이면서 `Deleted` 인 행의 추출 제외 여부를 설정합니다. <br /> > 기본 동작은 `0(사용 안함, 추출됨)` 이고 `1(사용, 추출 제외)` 로 설정시 해당 상태인 행이 추출되지 않습니다. <br /> > 저장 관련 데이터 추출 함수 (`getSaveJson`, `getSaveString`, `doSave`) 호출에 적용 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| | `0 (false)` | 행 상태가 `Added:1, Deleted:1` 인 행 추출 됨 (`default`) | | `1 (true)` | 행 상태가 `Added:1, Deleted:1` 인 행은 추출 제외됨| ### Examples ```js options = { Cfg:{ ExcludeAddDelStatus: 1 // Added:1, Deleted:1 인 행 추출 제외 } }; ```",
              "see": [
                {
                  "label": "Deleted row",
                  "url": "../../props/row/deleted"
                },
                {
                  "label": "Added row",
                  "url": "../../props/row/added"
                },
                {
                  "label": "getSaveJson",
                  "url": "../../funcs/core/get-save-json"
                },
                {
                  "label": "getSaveString",
                  "url": "../../funcs/core/get-save-string"
                },
                {
                  "label": "doSave",
                  "url": "../../funcs/core/do-save"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.38|기능 추가|"
            },
            "url": "docs/props/cfg/exclude-add-del-status.html"
          },
          {
            "cid": 64,
            "sid": "exclude-mode",
            "name": "exclude-mode",
            "label": "ExcludeMode",
            "data": {
              "body": "> `Ctrl + x` 사용시 동작을 정의합니다. 비트 연산으로 동작합니다. > 기본 동작은 **데이터 복사 + 행 Deleted:1 추가 (`Value:3`)** 입니다. > `Value:1`을 설정하지 않을 경우 데이터가 복사되지 않으므로 설정을 권장합니다. ### Type `number` ### Options |Value|Description| |-----|-----| | `1` | 데이터 클립보드 복사 | | `2` | 행 상태 `Deleted:1` 변경| | `4` | 셀 데이터 삭제 | ### Examples ```js options = { Cfg:{ ExcludeMode: 5 // 데이터 복사 및 셀 데이터 삭제 } }; ```",
              "see": [
                {
                  "label": "Deleted row",
                  "url": "../../props/row/deleted"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.22|기능 추가|"
            },
            "url": "docs/props/cfg/exclude-mode.html"
          },
          {
            "cid": 65,
            "sid": "export-data-config",
            "name": "export-data-config",
            "label": "ExportDataConfig",
            "data": {
              "body": "> [exportData](/docs/funcs/core/export-data) 함수 호출시 들어가는 인자를 공통으로 설정합니다. > [CommontOptions (static)](/docs/static/common-options)에 Cfg속성에 설정하시면 모든 화면에서 [exportData](/docs/funcs/core/export-data) 함수 호출시 기본적인 속성을 설정하실 수 있습니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|[exportData](/docs/funcs/core/export-data) 함수에 들어가는 인자와 동일(각 화면에서 동일한 속성을 설정시 화면에서 설정한 값이 반영됩니다.)| ### Example ```javascript options.Cfg = { // 모든 화면에서 엑셀 다운로드시 기본 속성을 설정 ExportDataConfig: { \"sheetDesign\":0, \"merge\":1 } }; ```",
              "see": [
                {
                  "label": "exportData method",
                  "url": "/docs/funcs/core/export-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.26|기능 추가|"
            },
            "url": "docs/props/cfg/export-data-config.html"
          },
          {
            "cid": 66,
            "sid": "export",
            "name": "export",
            "label": "Export",
            "data": {
              "body": "> `IBSheet`는 [down2Excel()](/docs/funcs/excel/down-to-excel)나 [down2Text()](/docs/funcs/excel/down-to-text)등 과 같은 함수를 통해서 데이터를 `xlsx, txt` 파일로 export 하거나 import 할 수 있습니다. > 이러한 작업은 해당 함수 호출시 시트의 내용을 서버 측으로 전달하고, 서버에서는 제품과 같이 제공되는 `jsp(혹은 aspx)`파일에서 전달된 내용을 파싱하여 파일을 클라이언트 측으로 리턴하거나, 파일의 내용을 시트에 로드시키게 됩니다. > 따라서 위와 같은 함수를 사용하기 위해서는 서버측 `jsp모듈(혹은 aspx)`에 대한 `Url`을 이 속성을 통해 명시해 주어야 합니다. > `Url` 속성만 필수적으로 설정해야 하고 그 외 속성은 선택 가능합니다. ### Type `object` ### Info |Name|Type|Description| |---------|----|-----------| |Url|`string`|서버모듈 `jsp(Down2Excel.jsp,LoadExcel.jsp 등)` 파일에 대한 경로 (`필수`) `Url`을 통해 `Down2Excel.jsp` 파일이 위치한 디렉토리를 지정하면 해당 URL위에 `Down2Excel.jsp`를 호출합니다.| |Down2ExcelUrl|`string`|[down2Excel](/docs/funcs/excel/down-to-excel) 함수 호출시 연결할 `URL`을 강제 지정 이 속성이 설정되면 위에 `Url` 속성은 무시되고, 이 속성으로 지정한 `URL`이 호출됩니다.| |LoadExcelUrl|`string`|[loadExcel](/docs/funcs/excel/load-excel) 함수 호출시 연결할 `URL`을 강제 지정 이 속성이 설정되면 위에 `Url` 속성은 무시되고, 이 속성으로 지정한 `URL`이 호출됩니다.| |DirectLoadExcelUrl|`string`|[directLoadExcel](/docs/funcs/excel/direct-load-excel) 함수 호출시 연결할 `URL`을 강제 지정 이 속성이 설정되면 위에 `Url` 속성은 무시되고, 이 속성으로 지정한 `URL`이 호출됩니다.| |Down2TextUrl|`string`|[down2Text](/docs/funcs/excel/down-to-text) 함수 호출시 연결할 `URL`을 강제 지정 이 속성이 설정되면 위에 `Url` 속성은 무시되고, 이 속성으로 지정한 `URL`이 호출됩니다.| |LoadTextUrl|`string`|[loadText](/docs/funcs/excel/load-text) 함수 호출시 연결할 `URL`을 강제 지정 이 속성이 설정되면 위에 `Url` 속성은 무시되고, 이 속성으로 지정한 `URL`이 호출됩니다.| |Down2PdfUrl|`string`|[down2Pdf](/docs/funcs/excel/down-to-pdf) 함수 호출시 연결할 `URL`을 강제 지정 이 속성이 설정되면 위에 `Url` 속성은 무시되고, 이 속성으로 지정한 `URL`이 호출됩니다.| |down2HwpxUrl|`string`|[down2Hwpx](/docs/funcs/excel/down-to-hwpx) 함수 호출시 연결할 `URL`을 강제 지정 이 속성이 설정되면 위에 `Url` 속성은 무시되고, 이 속성으로 지정한 `URL`이 호출됩니다.| |Ext|`string`|`Url` 경로를 설정 시 서버 파일의 확장자를 지정합니다. ex) `\"aspx\"` or `\"jsp\"` (`default: \"jsp\"`)| |FilePath|`string`|[File](/docs/appx/file-type-upload)타입 사용 시 조회 데이터의 파일 저장 경로를 설정 할 수 있습니다. 우선 순위는 [Path](/docs/props/cell/path)> `FilePath` 입니다.| ### Example ```javascript options.Cfg.Export = { Url: '/IBSheet/jsp/', // 시트 데이터를 엑셀로 다운로드 하기 위해 보내질 서버모듈 경로 FilePath: '/IBSheet/file/' // 파일 타입 컬럼 저장 경로 }; //Down2Excel 함수를 호출하는 경우 실제 호출되는 URL은 \"/IBSheet/jsp/Down2Excel.jsp\" 가 호출됩니다. ```",
              "see": [
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                },
                {
                  "label": "loadExcel method",
                  "url": "/docs/funcs/excel/load-excel"
                },
                {
                  "label": "down2Text method",
                  "url": "/docs/funcs/excel/down-to-text"
                },
                {
                  "label": "loadText method",
                  "url": "/docs/funcs/excel/load-text"
                },
                {
                  "label": "directDown2Excel method",
                  "url": "/docs/funcs/excel/direct-down-to-excel"
                },
                {
                  "label": "directLoadExcel method",
                  "url": "/docs/funcs/excel/direct-load-excel"
                },
                {
                  "label": "down2Hwpx method",
                  "url": "/docs/funcs/excel/down-to-hwpx"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||excel|0.0.11|`Ext` 기능 추가||excel|8.1.0.85|`down2Hwpx` 기능 추가|"
            },
            "url": "docs/props/cfg/export.html"
          },
          {
            "cid": 67,
            "sid": "filter-count",
            "name": "filter-count",
            "label": "FilterCount",
            "data": {
              "body": "> 필터 기능 사용시 제공되는 읽기 전용 옵션으로, 시트에서 필터링되어 화면에 보이는 데이터행의 개수를 반환합니다. > `Search`행에서 `Filter` 옵션 사용시에도 적용됩니다. ### Type `number` ### Example ```javascript // alert문에 사용 시 alert(sheet.FilterCount + \"개 사용 가능합니다\"); // Search행 설정할 때 사용 시 options.Solid = [{ Kind: \"Search\", // Kind : 커스텀 행의 Kind를 지정합니다.{가능한 행 종류 : Header, Filter, Search, Group, Space, Data} Space: 1, // Space : 커스텀 Row가 위치할 곳을 설정합니다 {-1: 테이블 상단 영역, 0: Head 영역, 1: Body와 Head 사이, 2: Body와 Foot 사이 빈공간, 3: Foot 바로 위, 4: Foot 아래 툴바위치, 5:하단 테이블 밖} Cells: \"Expression,Sep1,Counts,Filter,Select,Mark,FindPrev,Find,Clear,Sep2\", // 커스텀 행 내에 Cell들을 생성하고 id를 부여함. Defs, Case, Type, Cols, List, Search, Actions, Expression, Filter, Select, Mark, Find, FindPrev, Clear, Help는 내장 설정 예약어 Expression: { // 검색하기 위한 expression 설정 Action: \"Last\", // expression 셀 내용이 변경되었을때 취할 동작에 대한 설정, Last로 설정시 사용자가 직전에 했던 동작을 실행합니다(필터를 이전에 사용했다면 필터를 사용). NoColor: 0, // 셀이 css style의 컬러(Color, Background)를 가질지 여부 CanFocus: 1, Left: \"5\", // 셀 좌측에 지정한 px 만큼의 빈 공간 생성 MinWidth: \"90\", // 최소 너비 px 단위 EmptyValue: \"<s>검색어를 입력해 주세요</s>\" // input의 placeholder 속성과 동일한 기능으로 Value가 없을 경우 지정된 값을 노출합니다 }, Sep1: { Width: \"10\",Type: \"Html\" }, Counts: { Width: \"50\", CanFocus:0,Type: \"html\", Formula: \"(Sheet.SearchCount ? Sheet.SearchCount : (Sheet.FilterCount ? Sheet.FilterCount : count(7))) +'개'\" }, // filter, select 등의 버튼 클릭시 화면에 보이는 행의 개수를 세어 셀 값으로 사용. Filter: { ButtonText: \"필터\" }, Select: { ButtonText: \"선택\" }, Mark: { ButtonText: \"마킹\" }, FindPrev:{ ButtonText: \"(위로)찾기\", Width: \"70\" }, Find: { ButtonText: \"(아래로)찾기\", Width: \"70\" }, Clear: { ButtonText: \"클리어\", Width: \"50\" }, Sep2: { Width: \"5\", Type: \"Html\" } }] ```",
              "see": [
                {
                  "label": "SearchCount cfg",
                  "url": "./search-count"
                },
                {
                  "label": "Solid appendix",
                  "url": "/docs/appx/solid"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/filter-count.html"
          },
          {
            "cid": 68,
            "sid": "filter-defaults-icon-left",
            "name": "filter-defaults-icon-left",
            "label": "FilterDefaultsIconLeft",
            "data": {
              "body": "> 필터 행에서 [Defaults](/docs/props/col/defaults) 를 사용할 때 필터링 시 생성되는 필터 메뉴의 체크 박스 아이콘을 왼쪽에 위치시킬지 여부를 설정합니다 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|필터 체크 박스를 오른쪽에 위치 (`default`)| |`1(true)`|필터 체크 박스를 왼쪽에 위치| ### Example ```javascript options.Cfg = { FilterDefaultsIconLeft: true }; ```",
              "see": [
                {
                  "label": "Defaults col",
                  "url": "/docs/props/col/defaults"
                },
                {
                  "label": "FilterEnumIconLeft cfg",
                  "url": "./filter-enum-icon-left"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/props/cfg/filter-defaults-icon-left.html"
          },
          {
            "cid": 69,
            "sid": "filter-defaults-max-width",
            "name": "filter-defaults-max-width",
            "label": "FilterDefaultsMaxWidth",
            "data": {
              "body": "> 필터 행에서 [Defaults](/docs/props/col/defaults) 를 사용할 때 생성되는 필터 메뉴의 `MaxWidth` 를 설정합니다. <br /> > 생성될 필터 메뉴의 width 가 설정하는 값보다 작은 경우에는 기존의 생성될 width 가 우선되고, 설정하는 값보다 큰 경우에 필터 메뉴의 너비 축소 및 가로 스크롤이 생성됩니다. <br /> ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|필터의 Defaults 메뉴의 Maxwidth| ### Example ```javascript options.Cfg = { FilterDefaultsMaxWidth: 500 }; ```",
              "see": [
                {
                  "label": "Defaults col",
                  "url": "/docs/props/col/defaults"
                },
                {
                  "label": "FilterEnumIconLeft cfg",
                  "url": "./filter-enum-icon-left"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.34|기능 추가|"
            },
            "url": "docs/props/cfg/filter-defaults-max-width.html"
          },
          {
            "cid": 70,
            "sid": "filter-enum-icon-left",
            "name": "filter-enum-icon-left",
            "label": "FilterEnumIconLeft",
            "data": {
              "body": "> `Enum` 타입에 대한 필터링 시 생성되는 필터 메뉴의 체크 박스 아이콘을 왼쪽에 위치시킬지 여부를 설정합니다 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`| `Enum` 타입의 필터 체크 박스를 오른쪽에 위치 (`default`)| |`1(true)`| `Enum` 타입의 필터 체크 박스를 왼쪽에 위치| ### Example ```javascript options.Cfg = { FilterEnumIconLeft: true }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.6|기능 추가|"
            },
            "url": "docs/props/cfg/filter-enum-icon-left.html"
          },
          {
            "cid": 71,
            "sid": "filter-ignore-empty",
            "name": "filter-ignore-empty",
            "label": "FilterIgnoreEmpty",
            "data": {
              "body": "> 필터 연산자에 의해 빈 값을 가지는 셀이 무시될지 여부를 설정합니다. > 이 설정은 빈 문자열 찾거나 비교할 때는 적용되지 않습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|사용하지 않음 (`default`)| |`1`|[Type](/docs/appx/type)이 `Int`나 `Float`일 때, <, <=, >, >= 중 한 가지 연산자로 필터링 수행시 빈 값을 보여주지 않습니다.| |`4`|[Type](/docs/appx/type)이 `Text`나 `Lines`일 때, 포함하지 않음, 시작하지 않음, 끝나지 않음 연산자 중 한 가지 연산자로 필터링 수행시 빈 문자열을 가진 셀을 보여주지 않습니다.| |`8`|[Type](/docs/appx/type)이 `Int`나 `Float` 일 때 같지 않음 연산자로 필터링 수행시 빈 값을 보여주지 않습니다. | |`16`|[Type](/docs/appx/type)이 `Text`나 `Lines`일 때, 같지 않음 연산자로 필터링 수행시 빈 문자열을 가진 셀을 보여주지 않습니다. | ### Example ```javascript options = { Cfg :{ FilterIgnoreEmpty: 8, // Type이 `Int`나 `Float`일 때 같지 않음 연산자로 필터링 수행시 빈 값을 보여주지 않습니다. } }; ```",
              "see": [
                {
                  "label": "appendix](/docs/appx/type)"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/filter-ignore-empty.html"
          },
          {
            "cid": 72,
            "sid": "filter-value-list",
            "name": "filter-value-list",
            "label": "FilterValueList",
            "data": {
              "body": "> 필터행의 특정셀에 값 목록이 있을때 처리하는 방법을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|필터 값이 빈값일때 빈값 그대로 보여줌 (`default`) | |`1`|`Button: \"Defaults\"`, `Defaults`를 `*Row`로 설정할 경우 필터 값이 빈값일때 메시지 파일에 `Lang.Text.FilterEmptyValue`에 정의된 문자열로 표시 | |`2`|`Enum` 타입일 경우 필터 값이 빈값일때 메시지 파일에 `Lang.Text.FilterEmptyValue`에 정의된 문자열로 표시 | |`3`|`1번 설정`과 `2번 설정`을 동시에 적용 | ### Example ```javascript options.Cfg = { FilterValueList: 1 ... }; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "Button col",
                  "url": "/docs/props/col/button"
                },
                {
                  "label": "Defaults col",
                  "url": "/docs/props/col/defaults"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/filter-value-list.html"
          },
          {
            "cid": 73,
            "sid": "fit-width",
            "name": "fit-width",
            "label": "FitWidth",
            "data": {
              "body": "> 마지막 컬럼 뒤에 더미 컬럼을 두어 세로 스크롤바를 우측 끝에 붙게 합니다. ### [`FitWidth: false` 설정시] ![FitWidth: false](/assets/imgs/fitWidth0.png \"FitWidth: false\") [`FitWidth: true` 설정시] ![FitWidth: true](/assets/imgs/fitWidth1.png \"FitWidth: true\") ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|기능 사용| ### Example ```javascript options.Cfg = { FitWidth: true //더미 헤더를 추가하여 스크롤바를 우측 끝에 붙인다. }; ``` ### Try it - [True](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/FitWidth-true/)",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/fit-width.html"
          },
          {
            "cid": 74,
            "sid": "fix-prev-column-merge",
            "name": "fix-prev-column-merge",
            "label": "FixPrevColumnMerge",
            "data": {
              "body": "> 행 병합(위아래로 병합)시 각 열의 기준 열의 병합 된 범위를 기준으로 병합하는 기능입니다. > 기준 열 보다 `Index`가 큰 열에 대해서만 적용됩니다. > (cfg)[DataMerge](/docs/props/cfg/data-merge)와 (cfg)[HeaderMerge](/docs/props/cfg/header-merge) 옵션이 설정되어 있어야 정상적으로 동작합니다. > [PrevColumnMerge](/docs/props/cfg/prev-column-merge)가 선언되어 있어도, 해당 속성이 우선으로 적용됩니다. > 시트 생성 후 [setAutoMerge](/docs/funcs/core/set-auto-merge)메소드를 이용하여 병합을 동적으로 변경할 수 있습니다. ### **`정책사업` 컬럼으로 설정한 경우, 앞 컬럼과 관계 없이 기준 컬럼 병합 범위를 기준으로 병합** ![prevColumnMergeMode:0](/assets/imgs/fixprevColumnMerge1.png) ![prevColumnMergeMode:0](/assets/imgs/fixprevColumnMerge2.png) ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|행 병합 시 기준으로 설정할 열의 이름| ### Example ```javascript options = { Cfg: { FixPrevColumnMerge : 'sPolicy', // 시트 생성 시 앞 열 기준으로 셀 병합할지 여부를 설정합니다. ... } }; ```",
              "see": [
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/header-merge"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "PrevColumnMerge method",
                  "url": "/docs/props/cfg/prev-column-merge"
                },
                {
                  "label": "ColMerge col",
                  "url": "/docs/props/col/col-merge"
                },
                {
                  "label": "setAutoMerge method",
                  "url": "/docs/funcs/core/set-auto-merge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.15|기능 추가|"
            },
            "url": "docs/props/cfg/fix-prev-column-merge.html"
          },
          {
            "cid": 75,
            "sid": "float-calc-mode",
            "name": "float-calc-mode",
            "label": "FloatCalcMode",
            "data": {
              "body": "> `Float` Type 인 컬럼에서 계산 시 (col)[Format](/docs/props/col/format)과 설정한 소수점 길이보다 짧게 출력되거나 예상했던 결과값보다 소수점 자릿수가 길게 출력되는 경우 보정치 값을 변경하도록 설정합니다. 소수점 계산의 보정치는 JavaScript의 `부동 소수점` 연산 문제로 인하여 `1e5` 즉, 1 * 10의 5승인 `100000`을 기본 값으로 설정하여 계산합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`| 보정치 값을 `1e5`으로 설정하여 계산 (`default`)| |`1(true)`|(col)[Format](/docs/props/col/format)에 설정된 소수점 길이에 맞춰 계산 시 보정치 값을 조정하여 계산| ### Example ```javascript options.Cfg :{ FloatCalcMode: true }; ```",
              "see": [
                {
                  "label": "Format Col",
                  "url": "../col/format"
                },
                {
                  "label": "Format Cell",
                  "url": "../cell/format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.47|기능 추가|"
            },
            "url": "docs/props/cfg/float-calc-mode.html"
          },
          {
            "cid": 76,
            "sid": "focus-mode",
            "name": "focus-mode",
            "label": "EditTabMode",
            "data": {
              "body": "> 편집 상태인 셀에서 `tab / shift + tab` 키 이동시 동작을 설정한다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`| `CanEdit:0,3,4`, `CanFocus:0,2`가 설정되지 않은 셀로 편집을 유지하면서 tab 이동한다. (`default`)| |`1(true)`|`CanEdit`, `CanFocus`유무와 상관없이 tab 이동한다. 편집이 가능한 컬럼은 편집을 유지하면서 이동하고 편집이 불가한 컬럼에 foucs시 편집을 종료한다.| ### Example ```javascript options.Cfg :{ EditTabMode: 1 }; ```",
              "see": [
                {
                  "label": "CanEdit Cfg",
                  "url": "./can-edit"
                },
                {
                  "label": "CanEdit Row",
                  "url": "../row/can-edit"
                },
                {
                  "label": "CanEdit Col",
                  "url": "../col/can-edit"
                },
                {
                  "label": "CanEdit Cell",
                  "url": "../cell/can-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.53|기능 추가|"
            },
            "url": "docs/props/cfg/focus-mode.html"
          },
          {
            "cid": 77,
            "sid": "focus-whole-row",
            "name": "focus-whole-row",
            "label": "FocusWholeRow",
            "data": {
              "body": "> 시트 셀 선택시 포커스를 해당 셀에만 처리할지 해당 행 전체에 처리할지를 설정합니다. > `제약사항` 해당 기능 사용시 `Lines` 타입 컬럼은 편집 불가 `(CanEdit:0)` 로 설정됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|시트 셀 단위로 포커스 처리 (`default`)| |`1(true)`|시트 행 단위로 포커스 처리| ### Example ```javascript options.Cfg = { FocusWholeRow: true // 행단위로 포커스 처리 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/focus-whole-row.html"
          },
          {
            "cid": 78,
            "sid": "focused-col",
            "name": "focused-col",
            "label": "FocusedCol",
            "data": {
              "body": "> 시트를 생성하거나 `reload` 할 때 포커스를 줄 열이름(`ColName`)을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|포커스를 줄 열이름| ### Example ```javascript options.Cfg = { FocusedRow: \"AR5\", // 데이터 다섯번째 행에 포커스 처리 FocusedCol: \"sawonName\" // 포커스된 행의 \"sawonName\" 열에 포커스 처리 }; ```",
              "see": [
                {
                  "label": "FocusedRow cfg",
                  "url": "./focused-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/focused-col.html"
          },
          {
            "cid": 79,
            "sid": "focused-row",
            "name": "focused-row",
            "label": "FocusedRow",
            "data": {
              "body": "> 시트를 생성하거나 `reload` 할 때 포커스 시킬 행의 `ID`를 설정합니다. > 데이터행 : `AR1, AR2 (AutoRow :AR + index)` , 솔리드행 : `SR1, SR2 (SolidRow: SR+index)`, 그룹행 : `GR1, GR2 (GroupRow: GR+index)`... > ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|RowID [ 데이터행: `AR1(AutoRow +index)` ]| ### Example ```javascript options.Cfg = { FocusedRow: \"AR1\", // 데이터 첫번째 행에 포커스 처리 FocusedCol: \"seq\" // 포커스된 행의 \"seq\" 열에 포커스 처리 }; ```",
              "see": [
                {
                  "label": "FocusedCol cfg",
                  "url": "./focused-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/focused-row.html"
          },
          {
            "cid": 80,
            "sid": "force-enter-edit",
            "name": "force-enter-edit",
            "label": "ForceEnterEdit",
            "data": {
              "body": "> [EnterMode](/docs/props/cfg/enter-mode)의 `mode`값이 `0`이 아닌 경우 포커스 상태에서 편집 상태가 되고 이후의 동작이 되도록 설정하는 옵션입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|`EnterMode`의 기본 동작 수행| |`1(true)`|포커스 상태에서는 편집 상태로 바뀐 후 `EnterMode`의 기본 동작 수행 (`default`)| ### Example ```javascript options.Cfg{ // enter 키 이동시 편집 상태일때는 편집을 종료하고 우측 셀로 이동 (포커스 상태일 때는 우측 셀로 바로 이동) EnterMode: 3, ForceEnterEdit: false ... }; ```",
              "see": [
                {
                  "label": "EnterMode cfg",
                  "url": "/docs/props/cfg/enter-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/force-enter-edit.html"
          },
          {
            "cid": 81,
            "sid": "formula-range",
            "name": "formula-range",
            "label": "FormulaRange",
            "data": {
              "body": "> 컬럼의 포뮬러 동작시 영역을 헤더에서 풋까지 보도록 하는 기능입니다. > 기능 사용시 `CanFormula` 의 유무를 확인함. > 헤더의 경우, `Def.Row.CalcOrder` 내용을 보지 않으며, `Def.Header.CalcOrder` 에 따로 설정해주어야 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|데이터 영역까지 포뮬러 동작함. (`default`)| |`1(true)`|전체 영역에 포뮬러 동작함.| ### Example ```javascript options.Def: { \"Row\": { \"CanFormula\": 1, \"CalcOrder\": \"AAAButton\" }, \"Filter\": { CanFormula: 0 // 필터에는 포뮬러 동작 x }, \"Foot\": { CanFormula: 0 // 풋에는 포뮬러 동작 x }, Header: { CanFormula: 1, CalcOrder: \"AAAButton\" // 헤더에서 포뮬러를 사용하기 위해서 설정 필요. } }, options.Cfg = { Cfg.FormulaRange = true // 컬럼의 포뮬러 동작을 전체영역에 볼 수 있도록 함. }; ```",
              "see": [
                {
                  "label": "CanFormula row",
                  "url": "/docs/props/row/can-formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.23|기능 추가|"
            },
            "url": "docs/props/cfg/formula-range.html"
          },
          {
            "cid": 82,
            "sid": "formula-row-no-filtered",
            "name": "formula-row-no-filtered",
            "label": "FormulaRowNoFiltered",
            "data": {
              "body": "> 필터링되어 보이지 않는 로우를 합계 행 계산에 제외할 지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|계산에 포함시킨다. (`default`)| |`1(true)`|계산에 포함시키지 않는다.| ### Example ```javascript options.Cfg = { FormulaRowNoFiltered: true // 필터링되어 안보이는 로우를 합계 계산에서 제외합니다. }; ```",
              "see": [
                {
                  "label": "ShowFilter cfg",
                  "url": "./show-filter"
                },
                {
                  "label": "showFilterRow method",
                  "url": "/docs/funcs/core/show-filter-row"
                },
                {
                  "label": "FormulaRow col",
                  "url": "/docs/props/col/formula-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.6|기능 추가|"
            },
            "url": "docs/props/cfg/formula-row-no-filtered.html"
          },
          {
            "cid": 83,
            "sid": "get-by-data-format",
            "name": "get-by-data-format",
            "label": "GetByDataFormat",
            "data": {
              "body": "> [getValue](/docs/funcs/core/get-value) 메소드 실행 시 셀의 타입이 `Date`인 경우 셀에 설정된 `DataFormat` 형식에 맞게 값을 반환합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|해당 셀의 값을 반환합니다.(`Date` 타입의 경우 타임스탬프 형식)| |`1(true)`|`DataFormat`의 형식에 맞게 값을 반환합니다. (`default`)| ### Example ```javascript // 모든 Date 타입 열에 대해서 getValue시 DateFormat에 맞는 값을 반환합니다. options.Cfg = { GetByDataFormat: true }; ```",
              "see": [
                {
                  "label": "getValue method",
                  "url": "/docs/funcs/core/get-value"
                },
                {
                  "label": "setValue method",
                  "url": "/docs/funcs/core/set-value"
                },
                {
                  "label": "DataFormat col",
                  "url": "/docs/props/col/data-format"
                },
                {
                  "label": "DataFormat cell",
                  "url": "/docs/props/cell/data-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.1|기능 추가|"
            },
            "url": "docs/props/cfg/get-by-data-format.html"
          },
          {
            "cid": 84,
            "sid": "get-col-with-hide",
            "name": "get-col-with-hide",
            "label": "GetColWithHide",
            "data": {
              "body": "> `getColIndex, getColByIndex, getFirstCol, getLastCol, getNextCol, getPrevCol` 해당 API들은 기본 기능이 보여지는 열을 기준으로 동작합니다. > 해당 기능을 `true`로 설정시, 위의 `API`들은 `Col.Visible` 관계없이 동작합니다. > 우선 순위는 `includeHideCol` > `GetColWithHide` 임으로, `GetColWithHide`를 `true`로 설정 하여도 `includeHideCol`을 `false`로 설정시에는 보여지는 열을 기준으로 동작하게 할 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|`getColIndex, getColByIndex, getFirstCol, getLastCol, getNextCol, getPrevCol`- `Col.Visible` 상관없이 동작.| ### Example ```javascript //getColIndex, getColByIndex, getFirstCol, getLastCol, getNextCol, getPrevCol 해당 API들의 기능을 Visible 관계 없이 동작하도록 합니다. options.Cfg = { GetColWithHide: true }; ```",
              "see": [
                {
                  "label": "getColIndex method",
                  "url": "/docs/funcs/core/get-col-index"
                },
                {
                  "label": "getColByIndex method",
                  "url": "/docs/funcs/core/get-col-by-index"
                },
                {
                  "label": "getFirstCol method",
                  "url": "/docs/funcs/core/get-first-col"
                },
                {
                  "label": "getLastCol method",
                  "url": "/docs/funcs/core/get-last-col"
                },
                {
                  "label": "getNextCol method",
                  "url": "/docs/funcs/core/get-next-col"
                },
                {
                  "label": "getPrevCol method",
                  "url": "/docs/funcs/core/get-prev-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.11|기능 추가|"
            },
            "url": "docs/props/cfg/get-col-with-hide.html"
          },
          {
            "cid": 85,
            "sid": "group-format",
            "name": "group-format",
            "label": "GroupFormat",
            "data": {
              "body": "> 그룹핑 시 생성된 그룹 트리가 있는 열에 그룹에 속하는 데이터 행의 개수 와 그 표시 형식을 설정합니다. > `{%s}` 는 그룹이 되는 기준 값, `{%c}` 는 그룹핑 된 데이터의 개수를 설정합니다. > `{%vc}` 는 그룹핑 된 데이터 중 감춰진 행을 제외한 행의 개수 ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|그룹 표시 형식 설정 String ex) `<span style='color: black'>{%s}</span> \\ <span style='color: gray'>({%c}건)</span>`| ### Example ```javascript options.Cfg = { Group: \"gender,age\", // 시트 로딩시 colName 이 성별, 나이인 열으로 그룹핑 GroupMain: \"Name\", // 시트 트리를 colName 이 이름 인 열에 표시 GroupFormat:\" <span style='color:red'>{%s}</span> <span style='color:blue'>({%c}건)</span>\" //그룹핑 열이름은 빨강색, 건수는 파란색으로 표시 }; option.Solid = [{ Kind: \"Group\", // 커스텀 행의 Kind 를 Group 으로 설정 Space: -1 // 커스텀 행의 위치를 설정 (-1: 테이블 상단) }]; ``` ### Try it - [Demo of GroupFormat](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/Group/)",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "./group"
                },
                {
                  "label": "getGroupRows method",
                  "url": "/docs/funcs/core/get-group-rows"
                },
                {
                  "label": "Kind appendix",
                  "url": "/docs/appx/kind"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.27|{%vc} 기능 추가|"
            },
            "url": "docs/props/cfg/group-format.html"
          },
          {
            "cid": 86,
            "sid": "group-main",
            "name": "group-main",
            "label": "GroupMain",
            "data": {
              "body": "> 그룹핑이 되었을때 그룹 트리를 보여줄 열을 설정합니다. > `GroupMain` 을 설정하지 않는 경우, 자동으로 그룹핑이 표시될 기준 열이 지정됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`colName`|그룹핑 트리가 표시될 열이름| ### Example ```javascript options.Cfg = { Group: \"gender,age\", // 시트 로딩시 열이름이 gender, age인 열으로 그룹핑 GroupMain: \"Name\" // 시트 트리를 열이름이 Name 인 열에 표시 }; option.Solid = [{ Kind: \"Group\", // 커스텀 행의 Kind 를 Group 으로 설정 Space: -1 // 커스텀 행의 위치를 설정 (-1: 테이블 상단) }]; ``` ### Try it - [Demo of GroupMain](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/Group/)",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "./group"
                },
                {
                  "label": "Kind appendix",
                  "url": "/docs/appx/kind"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/group-main.html"
          },
          {
            "cid": 87,
            "sid": "group-sort-main",
            "name": "group-sort-main",
            "label": "GroupSortMain",
            "data": {
              "body": "> 그룹핑 사용시 그룹 열에 대해서 오름차순/내림차순 정렬 여부를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`1`|오름차순 정렬 (`default`)| |`2`|내림차순 정렬| ### Example ```javascript options.Cfg = { \"GroupSortMain\": 2 //그룹핑 되는 열에 대해 내림차순으로 정렬한다. }; ```",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "./group"
                },
                {
                  "label": "GroupMain cfg",
                  "url": "./group-main"
                },
                {
                  "label": "Solid appendix",
                  "url": "/docs/appx/solid"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/group-sort-main.html"
          },
          {
            "cid": 88,
            "sid": "group-sort",
            "name": "group-sort",
            "label": "GroupSort",
            "data": {
              "body": "> 그룹핑시 기준컬럼에 대한 정렬 처리 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |0|Sort 처리 없이 현재 상태로 그룹핑| |1|Sort 처리 후 그룹핑 (`default`)| ### Example ```javascript options.Cfg = { \"GroupSort\": 0 // 정렬 처리 하지 않고 현재 상태로 그룹핑 }; ```",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "./group"
                },
                {
                  "label": "GroupMain cfg",
                  "url": "./group-main"
                },
                {
                  "label": "GroupSortMain",
                  "url": "./group-sort-main"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.35|기능 추가|"
            },
            "url": "docs/props/cfg/group-sort.html"
          },
          {
            "cid": 89,
            "sid": "group-tree",
            "name": "group-tree",
            "label": "GroupTree",
            "data": {
              "body": "> 그룹핑 시 각 그룹 기준 컬럼에서 트리 노드를 사용합니다. > 옵션에 따라 트리 아이콘, [CanEdit](./can-edit)여부를 다르게 설정할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|사용 안함 (`default`)| |`1`|편집 불가([CanEdit: 0](./can-edit)), 트리 아이콘이 왼쪽에 위치| |`2`|편집 불가([CanEdit: 0](./can-edit)), 트리 아이콘이 오른쪽에 위치| |`3`|편집 가능([CanEdit: 1](./can-edit)), 트리 아이콘이 왼쪽에 위치| |`4`|편집 가능([CanEdit: 1](./can-edit)), 트리 아이콘이 오른쪽에 위치| ### Example ```javascript options.Cfg = { Group: \"gender,age\", // 시트 로딩시 colName 이 성별, 나이인 열으로 그룹핑 GroupTree: 3, // 성별, 나이 컬럼에 각각 접힘/펼침 트리 노드 생성 }; ```",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "./group"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.21|기능 추가|"
            },
            "url": "docs/props/cfg/group-tree.html"
          },
          {
            "cid": 90,
            "sid": "group",
            "name": "group",
            "label": "Group",
            "data": {
              "body": "> 시트 로딩시 그룹핑 하고자 하는 열의 `ColName` 을 \",\" 구분자을 넣어 문자열로 설정합니다. > `Solid Row 의 Kind: \"Group\"` 를 설정하면 그룹핑한 열의 헤더text 가 그룹행에 표시되며, 사용자가 마우스 드롭 다운으로 통해 다른 열을 그룹핑에 추가하거나 기존 그룹핑 열을 변경 할 수 있습니다. > `Solid Row 의 Kind: \"Group\"` 를 설정하지 않는 경우 시트 로딩시 `Group` 에 설정된 열 그룹핑 기능이 반영되나, 사용자가 변경 작업을 할 수 없습니다. > `Group` 설정시 이름들은 반드시 띄어쓰기 없이 서로 붙여 작성해주셔야 됩니다. 이름들 간에 띄어쓰기가 되어 있는 경우 `Group` 동작이 정상적으로 이뤄지지 않습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`colName`|그룹핑할 열이름을 \",\" 로 연결한 문자열| ### Example ```javascript options.Cfg = { Group:\"gender,age\" // 시트 로딩시 열이름이 성별, 나이인 열으로 그룹핑 }; option.Solid = [{ Kind: \"Group\", // 커스텀 행 Kind 를 Group 으로 설정 Space: -1 // 커스텀 행의 위치를 설정 (-1: 테이블 상단) }]; ``` ### Try it - [Demo of Group](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/Group/)",
              "see": [
                {
                  "label": "Kind appendix",
                  "url": "/docs/appx/kind"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/group.html"
          },
          {
            "cid": 91,
            "sid": "header-check-mode",
            "name": "header-check-mode",
            "label": "HeaderCheckMode",
            "data": {
              "body": "> 헤더 체크 박스(`HeaderCheck (cfg, col)`)가 활성화된 시트에서 `Bool` 타입인 열의 헤더 체크 박스를 클릭 시 해당 열의 셀이 체크 될 대상이 되는 행을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| | `0` | 시트의 모든 행 (`default`)| | `1` | 시트에 보이는 행 | ### Example ```javascript options = { Cfg :{ HeaderCheck: 1, // Type이 Bool인 열의 헤더에 체크박스를 생성합니다. HeaderCheckMode: 1, // 시트에 보이는 행에 대해 체크합니다(필터링되거나, 행이 Visible 0일 때 체크가 되지 않습니다) ... } }; ```",
              "see": [
                {
                  "label": "HeaderCheck col",
                  "url": "/docs/props/col/header-check"
                },
                {
                  "label": "HeaderCheck cfg",
                  "url": "./header-check"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/header-check-mode.html"
          },
          {
            "cid": 92,
            "sid": "header-check-page-only",
            "name": "header-check-page-only",
            "label": "HeaderCheckPageOnly",
            "data": {
              "body": "> `(Cfg) SearchMode: 1`에서 `(Cfg) HeaderCheck` 옵션을 사용하여 전체 체크를 할 때, 전체 페이지를 체크하지 않고 현재 보여지는 페이지만 체크합니다. ### Type `number` ### Options |Value|Description| |-----|-----| | `0` | 전체 체크 버튼 클릭시 전체 페이지를 체크 (`default`)| | `1` | 전체 체크 버튼 클릭시 현재 보여지는 페이지만 체크 | ### Example ```javascript options = { Cfg :{ HeaderCheckPageOnly: 1, // `(Cfg) SearchMode: 1`에서 `(Cfg) HeaderCheck` 옵션을 사용하여 전체 체크를 할 때, 전체 페이지를 체크하지 않고 현재 보여지는 페이지만 체크합니다. ... } }; ```",
              "see": [
                {
                  "label": "HeaderCheck col",
                  "url": "/docs/props/col/header-check"
                },
                {
                  "label": "HeaderCheckMode cfg",
                  "url": "./header-check-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.26|기능 추가|"
            },
            "url": "docs/props/cfg/header-check-page-only.html"
          },
          {
            "cid": 93,
            "sid": "header-check",
            "name": "header-check",
            "label": "HeaderCheck",
            "data": {
              "body": "> 시트 생성 시 타입이 `Bool`인 모든 열들의 헤더에 체크 박스를 생성합니다. > 헤더 셀의 체크 박스를 클릭 시 해당 열의 체크박스를 모두 **체크** 또는 **체크해제** 합니다. > 특정 열에만 적용하고자 하실 때는[(Col)HeaderCheck](/docs/props/col/header-check)를 참고하세요. ### Type `number` ### Options |Value|Description| |-----|-----| | `0` | 체크 박스 생성 안함 (`default`)| | `1` | 체크 박스 생성| ### Example ```javascript options = { Cfg :{ HeaderCheck: 1, // Type이 Bool인 모든 열의 헤더에 체크박스를 생성합니다. ... } }; ```",
              "see": [
                {
                  "label": "HeaderCheck col",
                  "url": "/docs/props/col/header-check"
                },
                {
                  "label": "HeaderCheckMode cfg",
                  "url": "./header-check-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/header-check.html"
          },
          {
            "cid": 94,
            "sid": "header-merge",
            "name": "header-merge",
            "label": "HeaderMerge",
            "data": {
              "body": "> 시트 생성 시 헤더 영역에서 셀 값을 기준으로 병합할지 여부 및 병합 종류를 설정합니다. > 옵션에 대한 설명은 [DataMerge](./data-merge)와 동일합니다. > 시트 생성 후 [setAutoMerge](/docs/funcs/core/set-auto-merge)메소드를 이용하여 헤더 영역의 병합을 동적으로 변경할 수 있습니다. > [Span cell](/docs/props/cell/span)과 [RowSpan cell](/docs/props/cell/row-span)보다 우선 적용됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| | `0` | 병합 안함 (`default`)| | `1` | 열 기준 병합| | `2` | 행 기준 병합| | `3` | 열 우선 병합| | `4` | 행 우선 병합| | `5` | 열 우선 사방 병합| | `6` | 행 우선 사방 병합| ### Example ```javascript options = { Cfg :{ HeaderMerge: 0, // 시트 생성 시 헤더 영역의 셀 병합을 진행하지 않습니다. } }; ``` ### Try it - [0 by default with setAutoMerge](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/Merge/)",
              "see": [
                {
                  "label": "Span cell",
                  "url": "/docs/props/cell/span"
                },
                {
                  "label": "RowSpan cell",
                  "url": "/docs/props/cell/row-span"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "./data-merge"
                },
                {
                  "label": "PrevColumnMerge cfg",
                  "url": "./prev-column-merge"
                },
                {
                  "label": "setAutoMerge method",
                  "url": "/docs/funcs/core/set-auto-merge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/header-merge.html"
          },
          {
            "cid": 95,
            "sid": "header-sort-action-mode",
            "name": "header-sort-action-mode",
            "label": "HeaderSortActionMode",
            "data": {
              "body": "> 헤더 클릭/Ctrl 클릭 시 어떻게 소팅할지 결정합니다.</br> > 옵션에 따라 단일 열에 대한 소팅과 다중 열에 대한 소팅이 실행됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| | `0(false)` | 클릭 시 다중 소팅을 사용하며, Ctrl 클릭 시 단일 소팅을 사용합니다. (`default`)| | `1(true)` | 클릭 시 단일 소팅을 사용하며, Ctrl 클릭 시 다중 소팅을 사용합니다.| ### Example ```javascript options.Cfg = { HeaderSortActionMode: true, ... }; ```",
              "see": [
                {
                  "label": "MaxSort cfg",
                  "url": "/docs/props/cfg/max-sort"
                },
                {
                  "label": "HeaderSortMode cfg",
                  "url": "/docs/props/cfg/header-sort-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/props/cfg/header-sort-action-mode.html"
          },
          {
            "cid": 96,
            "sid": "header-sort-mode",
            "name": "header-sort-mode",
            "label": "HeaderSortMode",
            "data": {
              "body": "> 헤더를 클릭시 소팅하는 순서를 변경합니다. > 별다른 설정이 없는 경우 시트는 [MaxSort](/docs/props/cfg/max-sort) 설정에 따라 클릭하는 헤더의 순서대로, 대분류, 중분류, 소분류로 소팅을 합니다. > 가령 `MaxSort:3` 이고 A, B, C 컬럼의 헤더를 순서대로 클릭하였다면 **대분류:A, 중분류:B, 소분류:C**의 순서대로 소팅이 이루어지고 이렇게 3개 컬럼이 결정되고 난 이후에는 다른 컬럼은 클릭하여도 소팅이 되지 않습니다. > > **그런데 이러한 방식 대신에 마지막으로 클릭한 컬럼을 대분류로 하고, 소팅 컬럼이 결정된 이후에 새롭게 클릭하는 헤더를 계속적으로 대분류로 변경하여 소팅하고자 하실때는 이 속성을 1로 설정하시면 됩니다.** > > 만약 기존에 소팅된 내용을 clear하려면 **shift+헤더클릭** 하시면 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| | `0` | 클릭한 순서대로 대분류/중분류/소분류가 되며, `MaxSort`에서 지정한 갯수까지만 소팅하고 `MaxSort` 초과의 컬럼은 소팅이 되지 않음. (`default`) | | `1` | 클릭한 순서의 역순으로 대분류/중분류/소분류가 되며, 마지막으로 클릭하는 헤더가 대분류가 되고 기존의 소분류였던 컬럼은 소팅 취소됨.| | `2` | 클릭한 헤더의 소팅 아이콘만 변경되고 실제 소팅이 되지 않음.| | `3` | 클릭한 헤더의 소팅 아이콘만 변경되고 실제 소팅이 되지 않음. 추가적으로 [doSort](/docs/funcs/core/do-sort) 이용한 정렬에도 아이콘만 변경되고 실제 소팅이 되지 않음.| | `4` | 클릭한 순서대로 대분류/중분류/소분류가 되며, 마지막으로 클릭하는 헤더가 소분류가 되고 기존의 대분류였던 컬럼은 소팅 취소됨. | ### Example ```javascript options = { Cfg :{ HeaderSortMode: 1, ... } }; ```",
              "see": [
                {
                  "label": "MaxSort cfg",
                  "url": "/docs/props/cfg/max-sort"
                },
                {
                  "label": "HeaderSortActionMode cfg",
                  "url": "/docs/props/cfg/header-sort-action-mode"
                },
                {
                  "label": "UseHeaderSortCancel cfg",
                  "url": "/docs/props/cfg/use-header-sort-cancel"
                },
                {
                  "label": "doSort method",
                  "url": "/docs/funcs/core/do-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.4|기능 추가||core|8.0.0.8|`HeaderSortMode: 2,3` 추가||core|8.3.0.43|`HeaderSortMode: 4` 추가|"
            },
            "url": "docs/props/cfg/header-sort-mode.html"
          },
          {
            "cid": 97,
            "sid": "highlight-after-sort",
            "name": "highlight-after-sort",
            "label": "HighlightAfterSort",
            "data": {
              "body": "> 정렬 동작 이후 포커스 처리 동작을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|포커스 클리어 및 세로스크롤 위치를 유지합니다. | |`1`|정렬 동작 이전 포커스 행 유지 및 해당 셀의 위치로 세로스크롤을 이동합니다. (`default`)| |`2`|정렬 동작 이전 포커스 행 유지 및 가로스크롤 및 세로스크롤 위치를 최상단으로 초기화 합니다. | |`3`|정렬 동작 이후에도 항상 첫번째 행에 포커스 이동 및 세로스크롤 위치를 해당 셀 위치로 이동 합니다.| |`4`|포커스 행 위치에 포커스 유지, 만약 25행을 포커스하고 정렬을 하면 항상 25 번째 행에 포커스가 유지됩니다. (세로스크롤 위치 유지합니다.)| ### Example ```javascript options.Cfg = { HighlightAfterSort: 2 // 정렬이 동작되면 이전 포커스 행을 유지하고 세로스크롤 위치는 최상단으로 초기화. }; ```",
              "see": [
                {
                  "label": "doSort method",
                  "url": "/docs/funcs/core/do-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.63|기능 추가|"
            },
            "url": "docs/props/cfg/highlight-after-sort.html"
          },
          {
            "cid": 98,
            "sid": "hint-max-width",
            "name": "hint-max-width",
            "label": "HintMaxWidth",
            "data": {
              "body": "> 힌트의 최대 너비(`MaxWidth`)을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|힌트의 최대 너비| ### Example ```javascript options.Cfg = { HintMaxWidth: 500 // 힌트의 최대 너비를 500으로 설정 }; ```",
              "see": [
                {
                  "label": "ShowHint row",
                  "url": "/docs/props/row/show-hint"
                },
                {
                  "label": "ShowHint col",
                  "url": "/docs/props/col/show-hint"
                },
                {
                  "label": "ShowHint cell",
                  "url": "/docs/props/cell/show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.47|기능 추가|"
            },
            "url": "docs/props/cfg/hint-max-width.html"
          },
          {
            "cid": 99,
            "sid": "hover-scope",
            "name": "hover-scope",
            "label": "HoverScope",
            "data": {
              "body": "> 시트내의 행 또는 셀에 마우스 커서가 위치 했을때 `Hover` 동작이 수행되는 영역을 제한합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|헤더/데이터 영역에 `Hover` 동작 (`default`)| |`1`|헤더 영역에 `Hover` 동작하지 않음| ### Example ```javascript options.Cfg = { HoverScope: 1, // 헤더 영역에 Hover 동작하지 않음 }; ```",
              "see": [
                {
                  "label": "Hover cfg",
                  "url": "./hover"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.9|기능 추가|"
            },
            "url": "docs/props/cfg/hover-scope.html"
          },
          {
            "cid": 100,
            "sid": "hover",
            "name": "hover",
            "label": "Hover",
            "data": {
              "body": "> 시트내의 행 또는 셀에 마우스 커서가 위치 했을때 `Hover` 동작 모드를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|`Hover` 동작 안함 | |`1`|셀단위 `Hover`| |`2`|행단위 `Hover` (`default`) | |`3`|행단위, 열단위 `Hover` ([MultiRecord](./multi-record)에서는 열단위 `Hover` 동작 안함) | ### Example ```javascript options.Cfg = { Hover: \"1\", // 셀단위 Hover 동작처리 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.3.0.47|`3` 옵션 추가|"
            },
            "url": "docs/props/cfg/hover.html"
          },
          {
            "cid": 101,
            "sid": "ignore-focused",
            "name": "ignore-focused",
            "label": "IgnoreFocused",
            "data": {
              "body": "> 시트는 데이터 조회 후 포커스를 보여지는 첫번째 행 첫번째 열에 위치시킵니다. > 해당 속성을 `1(true)`로 설정하면 조회 후 시트가 포커스를 갖고 오지 않게 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|조회 후 포커스를 첫 번째 행, 열로 가져옴 (`default`)| |`1(true)`|조회 후 포커스를 가져오지 않음| ### Example ```javascript options.Cfg = { IgnoreFocused: true, // 조회 후 포커스를 가져오지 않게 한다. }; ```",
              "see": [
                {
                  "label": "Focus method",
                  "url": "/docs/funcs/core/focus"
                },
                {
                  "label": "onFocus event",
                  "url": "/docs/events/on-focus"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/ignore-focused.html"
          },
          {
            "cid": 102,
            "sid": "ignore-header-col-merge",
            "name": "ignore-header-col-merge",
            "label": "IgnoreHeaderColMerge",
            "data": {
              "body": "> `ColMerge` 속성을 헤더 영역에도 적용할지 여부를 결정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`| ColMerge 속성을 헤더 영역에도 적용합니다. | |`1(true)`| ColMerge 속성을 헤더 영역에 적용하지 않습니다. (`default`)| ### Example ```javascript options.Cfg = { IgnoreHeaderColMerge: false, // ColMerge 속성을 헤더 영역에도 적용합니다. }; ```",
              "see": [
                {
                  "label": "ColMerge col",
                  "url": "/docs/props/col/col-merge"
                },
                {
                  "label": "ColMerge cell",
                  "url": "/docs/props/cell/col-merge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/ignore-header-col-merge.html"
          },
          {
            "cid": 103,
            "sid": "in-edit-mode",
            "name": "in-edit-mode",
            "label": "InEditMode",
            "data": {
              "body": "> 시트의 편집 시점을 설정합니다. > 일반적으로 편집하고자 하는 셀을 더블클릭하거나, 해당 셀에 포커스가 있는 상태에서 F2 혹은 Enter 키 입력시 편집이 시작됩니다. > 편집 상태에서 Esc 키 입력시 편집상태가 종료됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|- 이미 포커스된 셀을 클릭할 때 - Enter나 F2 키를 입력할 때 - 포커스 되지 않은 셀을 더블 클릭할 때 | |`1`|- 셀을 클릭시 - 포커스 상태에서 Enter나 F2 키 입력시| |`2`|- 이미 포커스된 셀을 클릭할 때 - Enter나 F2 키를 입력할 때 - 포커스 되지 않은 셀을 더블 클릭할 때 - 포커스 상태에서 입력할 때 (`default`)| |`3`|- 이미 포커스된 셀을 더블 클릭할 때 - Enter나 F2 키를 입력할 때 - 포커스 상태에서 입력할 때 | ### Example ```javascript options.Cfg = { InEditMode: 1, //클릭시 즉시 편집상태로 전환 ... }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/in-edit-mode.html"
          },
          {
            "cid": 104,
            "sid": "include-del-row",
            "name": "include-del-row",
            "label": "IncludeDelRow",
            "data": {
              "body": "> 소계/누계([makeSubTotal](/docs/funcs/core/make-sub-total)) / 합계([FormulaRow](/docs/props/col/formula-row))에 삭제 상태 행 ([Deleted](/docs/props/row/deleted): 1) 을 계산에 포함할지 여부를 설정합니다. > bit 연산 형태로 속성을 설정합니다. 3으로 설정시 1번옵션 + 2번옵션 대해 설정하게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|삭제행 계산에 포함하지 않음. (`default`)| |`1`|소계/누계 계산에 삭제행을 포함하여 계산| |`2`|합계 계산에 삭제행을 포함하여 계산| ### Example ```javascript options.Cfg = { ... \"IncludeDelRow\": 3 // 소계/누계, 합계 계산 모두 삭제행을 포함하여 계산 ... }; ```",
              "see": [
                {
                  "label": "makeSubTotal method",
                  "url": "/docs/funcs/core/make-sub-total"
                },
                {
                  "label": "FormulaRow col",
                  "url": "/docs/props/col/formula-row"
                },
                {
                  "label": "Deleted row",
                  "url": "/docs/props/row/deleted"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.11|기능 추가|"
            },
            "url": "docs/props/cfg/include-del-row.html"
          },
          {
            "cid": 105,
            "sid": "info-row-config",
            "name": "info-row-config",
            "label": "InfoRowConfig",
            "data": {
              "body": "> 시트 상단 혹은 하단에 별도의 행을 통해 조회된 데이터의 개수나 페이지 네비게이션을 설정합니다. > 건수정보표시행에 임의의 문자나 숫자를 추가적으로 설정 하는 것도 가능합니다. > `Layout`에 셀에 대한 속성 및 타입을 설정 할 수 있습니다. ### Type `object` ### Options |Value|Type|Description| |----------|-----|---| |Visible|`boolean`|정보 행을 화면에 표시할지 여부 `0(false)`:정보 행 화면에 표시 안함 (`SearchMode : 0,2,3 default`) `1(true)`:정보 행 화면에 표시 (`SearchMode : 1,4,5 default`)| |Layout|`array`\\[`string`\\|`object`\\]|페이징, 건수 정보 표시, 선택 영역 합계/평균 표시, 상태 정보 표시, 사용자 정의 영역의 Layout을 설정합니다. **참고** : `Paging,Paging2` 는 `SearchMode:1,4,5` 에서 동작 합니다.<ul><li>**Paging** : 페이지 네비게이션 활성화(예약어), 천단위로 ',' 찍힘. ex) `1/1,000` ![Paging](/assets/imgs/Paging.png \"Paging\")</li><li>**Paging2**: 숫자형 페이지 네비게이션 활성화(예약어), `주의`: Paging과 동시 사용 X ![Paging2](/assets/imgs/paging2.png \"Paging2\")</li><li>**Count**: 건수 정보 표시(예약어) ![Count](/assets/imgs/Count.png \"Count\")</li><li>**SummaryLabel** : 선택 영역에 대한 합계/평균 정보 표시 ![Paging](/assets/imgs/summaryLabel.png \"Paging\")</li><li>**StatusLabel** : 데이터 편집, 데이터 조회, 행이동, 필터링, 정렬, 컬럼이동, 파일 업로드/제거 내용 표시 ![status](/assets/imgs/statusLabel.png \"status\")</li><li>**사용자 영역 문자열** : 표시하려는 문자열 \\<Span\\>\\<Div\\>와 같은 태그 사용가능</li></ul> (`default: [\"Paging\",\"Count\"]`) ex:) **[\"Paging\",{Value:\"\\<div style='background-color:#FFFFAA'>1234\\</div>\",Color:\"#FFDDFF\"},\"가나다\",\"Count\"]** 위와 같이 설정시 다음과 같이 표현됩니다. ![InfoRow](/assets/imgs/infoRow0.png \"\")| |ViewCount|`number`|Layout의 Paging2 설정시 `PageLength`를 변경하는 selectBox 표시 여부를 결정합니다. `0`:표시안함 (`default`), `1`:표시 ![ViewCount](/assets/imgs/viewCount.png \"ViewCount\")| |ViewFormat|`string`|Layout의 Paging2 설정 후 `ViewCount:1` 설정시 `ViewCount`의 selectBox 옵션을 설정합니다. \"\\|\" 를 구분자로 구분하며 \"10\\|20\\|30\\|40\\|50\" 과 같이 설정합니다. ViewFormat을 설정하지 않으면 selectBox 기본 옵션값은 \"10\\|20\\|30\\|50\\|100\"입니다. 시트의 `PageLength`가 옵션에 포함되어 선택 됩니다.(PageLength가 ViewFormat 문자열에 포함되어 있지 않는 경우 자동 추가 후 선택) |Paging2Count|`number`|Layout의 Paging2 설정시 페이지 네비게이션에 보여지는 숫자의 개수를 설정합니다. (`default: 5, max: 10`)| |Space|`string`|정보 행의 위치 (\"Top\": 상단, \"Bottom\":하단) (`default: \"Bottom\"`)| |Format|`string`|위 `Layout` 에서 `Count`로 설정한 셀(건수정보)에 들어갈 예약어 조합 `default: [BOTTOMDATAROW / TOTALROWS]` <ul><li>TOTALROWS: (서버페이징) 전체 데이터 개수</li><li>ROWCOUNT: 조회된 데이터 개수</li><li>VISIBLECOUNT: 보이는 데이터 개수</li><li>ADDROWS: 추가된 데이터 개수</li><li>CHANGEROWS: 변경된 데이터 개수</li><li>DELETEROWS: 삭제된 데이터 개수</li><li>BOTTOMDATAROW: 현재 가장 마지막에 보이는 행의 번호</li></ul>| ![InfoRowConfig](/assets/imgs/infoRow1.png \"InfoRowConfig\") ### Example ```javascript // Html options.Cfg = { InfoRowConfig: { \"Visible\": true, \"Layout\": [ \"Paging\", // 예약어 페이지네이션 {Value:\"2024/01/05일 마감 예정입니다.\", TextColor:\"#FF0000\"}, // 임의의 셀 \"Count\" // 예약어 건수정보 ], \"Space\": \"Bottom\", // InfoRow 상/하 위치 \"Format\": \"CHANGEROWS개 행이 수정되었습니다.\" // 건수정보 포멧 } }; // Layout의 Paging2 는 아래와 같이 설정합니다. options.Cfg = { InfoRowConfig: { \"Visible\": true, \"Layout\": [ \"Paging2\", // 예약어 페이지네이션 {Value:\"2024/01/05일 마감 예정입니다.\", TextColor:\"#FF0000\"}, // 임의의 셀 \"관리자 홍길동\", // 임의의 셀2 \"Count\" // 예약어 건수정보 ], \"ViewCount\": 1, // selectBox 표시 \"ViewFormat\": \"10|20|30|40|50\", // selectBox option 구성 \"Paging2Count\": 8, // 페이지 네비게이션에 표시되는 페이지 number 개수 \"Space\": \"Bottom\" // InfoRow 상/하 위치 } }; // InfoRow에 버튼 셀 생성하기 options.Cfg = { InfoRowConfig: { \"Visible\": true, \"Layout\": [ // 버튼 셀 정보 설정 {Value:\"확인\", Type:\"Button\",TextColor:\"#FFFFFF\", Color:\"#53629E\", RelWidth:0, Width: 100, OnClick: function(){alert(\"확인\");}}, \"Count\" ], \"Space\": \"Top\" } }; ``` ### Try it - [Demo of InfoRowConfig](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/InfoRowConfig/)",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                },
                {
                  "label": "SelectionSummary cfg",
                  "url": "/docs/props/cfg/selection-summary"
                },
                {
                  "label": "setInfoRow method",
                  "url": "/docs/funcs/core/set-info-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.5|InfoRow에 Layout.Cells(개별 셀 속성 설정) 기능 추가||core|8.1.0.96|StatusLabel 추가||core|8.1.0.97|Paging2,ViewCount,ViewFormat,Paging2Count 추가|"
            },
            "url": "docs/props/cfg/info-row-config.html"
          },
          {
            "cid": 106,
            "sid": "init-pivot-cols",
            "name": "init-pivot-cols",
            "label": "InitPivotCols",
            "data": {
              "body": "> 피벗 시트에서 기준 열의 값으로 사용할 열(들)을 설정합니다. > `\",\"`로 연결하여 복수 개의 열 이름을 지정할 수 있습니다. ### Type `string` ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 InitPivotCols: \"sTeam,sPosition\" // 가로 기준 컬럼 설정 }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "PivotFunc cfg",
                  "url": "./pivot-func"
                },
                {
                  "label": "InitPivotRows cfg",
                  "url": "./init-pivot-rows"
                },
                {
                  "label": "InitPivotData cfg",
                  "url": "./init-pivot-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.6|기능 추가||dialog|8.0.0.4|기능 추가|"
            },
            "url": "docs/props/cfg/init-pivot-cols.html"
          },
          {
            "cid": 107,
            "sid": "init-pivot-data",
            "name": "init-pivot-data",
            "label": "InitPivotData",
            "data": {
              "body": "> 피벗 시트에서 데이터의 값으로 사용할 열(들)을 설정합니다. > `\",\"`로 연결하여 복수 개의 열 이름을 지정할 수 있습니다. ### Type `string` ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 InitPivotData: \"sSalary,sBonus\" // 값 계산할 컬럼 설정 }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "PivotFunc cfg",
                  "url": "./pivot-func"
                },
                {
                  "label": "InitPivotCols cfg",
                  "url": "./init-pivot-cols"
                },
                {
                  "label": "InitPivotRows cfg",
                  "url": "./init-pivot-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.6|기능 추가||dialog|8.0.0.4|기능 추가|"
            },
            "url": "docs/props/cfg/init-pivot-data.html"
          },
          {
            "cid": 108,
            "sid": "init-pivot-rows",
            "name": "init-pivot-rows",
            "label": "InitPivotRows",
            "data": {
              "body": "> 피벗 시트에서 기준 행의 값으로 사용할 열(들)을 설정합니다. > `\",\"`로 연결하여 복수 개의 열 이름을 지정할 수 있습니다. ### Type `string` ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 InitPivotRows: \"sDept\" // 세로 기준 컬럼 설정 }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "PivotFunc cfg",
                  "url": "./pivot-func"
                },
                {
                  "label": "InitPivotCols cfg",
                  "url": "./init-pivot-cols"
                },
                {
                  "label": "InitPivotData cfg",
                  "url": "./init-pivot-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.6|기능 추가||dialog|8.0.0.4|기능 추가|"
            },
            "url": "docs/props/cfg/init-pivot-rows.html"
          },
          {
            "cid": 109,
            "sid": "left-width",
            "name": "left-width",
            "label": "LeftWidth",
            "data": {
              "body": "> 왼쪽 고정 열 섹션의 최대 너비를 설정합니다. > 왼쪽 고정 열 섹션의 열들이 설정된 너비보다 큰 경우 스크롤바가 생성됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|왼쪽 섹션의 총 너비| ### Example ```javascript options = { LeftCols:[ { //열 헤더 설정 Header: { Value: \"No\" // 헤더행의 SEQ 열에 해당하는 셀에 표시될 title 값 }, Name: \"SEQ\", // 행의 순서를 보여주는 열으로, 자동으로 순번이 시트에서 생성됩니다. }, { // 열 헤더 설정 Header: { Value: \"회사명3\" // 헤더행의 sCorp 열에 해당하는 셀에 표시될 title 값 }, Name: \"sCorp\", // colName 열이름을 설정 (Data와 Matching) Type: \"Text\" // 열 타입 } ], Cfg :{ LeftWidth:150 // 왼쪽 고정 열 섹션의 최대 너비 설정 } }; ```",
              "see": [
                {
                  "label": "LeftWidth cfg",
                  "url": "./left-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/left-width.html"
          },
          {
            "cid": 110,
            "sid": "level-mark",
            "name": "level-mark",
            "label": "LevelMark",
            "data": {
              "body": "> 트리구조에서 [exportData](/docs/funcs/core/export-data), [down2Excel](/docs/funcs/excel/down-to-excel)를 사용하여 엑셀 다운 시 나타내고 싶은 트리구분자를 지정할 수 있다. > 기본적으로 트리구조를 엑셀, 텍스트 다운시 트리 구분자를 지원해주고 있다. > 트리구분자를 사용하고 싶지 않으면 `LevelMark: \"\"` 로 지정하면 트리구조에서 구분자를 사용하지 않을 수 있다. ### Type `string` ### Example ```javascript options.Cfg = { LevelMark: \"#\" // 트리구분자 변경. }; options.Cfg = { LevelMark: \"\" // 트리구분자를 사용하지 않음. }; ```",
              "see": [
                {
                  "label": "exportData method",
                  "url": "/docs/funcs/core/export-data"
                },
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.6|기능 추가||excel, servermodule|1.1.11, 1.1.35|down2Excel 적용|"
            },
            "url": "docs/props/cfg/level-mark.html"
          },
          {
            "cid": 111,
            "sid": "load-excel-config",
            "name": "load-excel-config",
            "label": "LoadExcelConfig",
            "data": {
              "body": "> [loadExcel](/docs/funcs/excel/load-excel) 함수 호출시 들어가는 인자를 공통으로 설정합니다. > [CommontOptions (static)](/docs/static/common-options)에 Cfg속성에 설정하시면 모든 화면에서 [loadExcel](/docs/funcs/excel/load-excel) 함수 호출시 기본적인 속성을 설정하실 수 있습니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|[loadExcel](/docs/funcs/excel/load-excel) 함수에 들어가는 인자와 동일(각 화면에서 동일한 속성을 설정시 화면에서 설정한 값이 반영됩니다.)| ### Example ```javascript options.Cfg = { // 모든 화면에서 엑셀 업로드시 기본 속성을 설정 LoadExcelConfig: { \"append\": 1, \"mode\": \"HeaderSkip\" } }; ```",
              "see": [
                {
                  "label": "loadExcel method",
                  "url": "/docs/funcs/excel/load-excel"
                },
                {
                  "label": "CommontOptions static",
                  "url": "/docs/static/common-options"
                }
              ],
              "since": "|product|version|desc||---|---|---||excel|0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/load-excel-config.html"
          },
          {
            "cid": 112,
            "sid": "load-text-config",
            "name": "load-text-config",
            "label": "LoadTextConfig",
            "data": {
              "body": "> [loadText](/docs/funcs/excel/load-text) 함수 호출시 들어가는 인자를 공통으로 설정합니다. > [CommontOptions (static)](/docs/static/common-options)에 Cfg속성에 설정하시면 모든 화면에서 [loadText](/docs/funcs/excel/load-text) 함수 호출시 기본적인 속성을 설정하실 수 있습니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|[loadText](/docs/funcs/excel/load-text) 함수에 들어가는 인자와 동일(각 화면에서 동일한 속성을 설정시 화면에서 설정한 값이 반영됩니다.)| ### Example ```javascript options.Cfg = { // 모든 화면에서 텍스트 업로드시 기본 속성을 설정 LoadTextConfig: { \"append\": 1 } }; ```",
              "see": [
                {
                  "label": "loadText method",
                  "url": "/docs/funcs/excel/load-text"
                },
                {
                  "label": "CommontOptions static",
                  "url": "/docs/static/common-options"
                }
              ],
              "since": "|product|version|desc||---|---|---||excel|0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/load-text-config.html"
          },
          {
            "cid": 113,
            "sid": "main-col",
            "name": "main-col",
            "label": "MainCol",
            "data": {
              "body": "> 트리기능 사용시 트리를 보여줄 열을 설정합니다. > 지정한 열에서 트리의 접힘/펼침 아이콘이 보여지게 됩니다. > 반드시 하나의 열만 트리가 될 수 있습니다. > 트리를 사용시에는 조회 데이터도 트리에 맞춰서 구성되어야 합니다. (7장 [데이터구조](/docs/appx/data-structure)를 참고) ### Type `string` ### Options |Value|Description| |-----|-----| |`colName`|트리가 표시될 열이름| ### Example ```javascript options.Cfg = { MainCol: \"Emp_name\" // 시트 트리를 열이름이 \"Emp_name\"인 열에 표시 }; ``` ### Try it - [Demo of MainCol](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/MainCol/)",
              "see": [
                {
                  "label": "데이터 규격 appendix",
                  "url": "/docs/appx/data-structure"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/main-col.html"
          },
          {
            "cid": 114,
            "sid": "markup-tag-delimiter",
            "name": "markup-tag-delimiter",
            "label": "MarkupTagDelimiter",
            "data": {
              "body": "> [down2Excel](/docs/funcs/excel/down-to-excel)이나 [loadExcel](/docs/funcs/excel/load-excel) 처럼 `import/export` 함수 사용시 서버로 전송되는 전문의 구분자를 변경합니다. > 서버로 전송되는 전문은 `xml 과 유사한 구조`로 < 나 > 같은 기호를 이용하여 전문을 구성하게 되는데, 일부 서버에서 이러한 `html tag`를 필터링하여 다른 문자로 치환하는 경우 `ibsheet`의 서버 모듈에서 해석하지 못해 오류가 발생하곤 합니다. > 따라서 이러한 경우 <,>와 같은 테그가 아닌 다른 문자를 지정하여 서버로 전송할 수 있습니다. > 구분자는 4개가 있으며 이 속성을 통해 구분자를 변경시 서버사이드에서도 이 함수를 통해 동일한 구분자를 설정해야 합니다. ### Type `array` ### Options 기본 구분자 번호|기호 ---|--- 1|< 2|> 3|< 4|/> ### Example ```javascript options.Cfg = { MarkupTagDelimiter: [\"┼\",\"╫\",\"╬\",\"╪\"] }; ``` 서버측 설정 ```java down = new IBSheetDown(); //==================================================================================================== // [ 사용자 환경 설정 #1 ] //==================================================================================================== // 엑셀 전문의 MarkupTag Delimiter 사용자 정의 시 설정하세요. // 설정 값은 IBSheet8 환경설정(ibsheet.cfg)의 MarkupTagDelimiter 설정 값과 동일해야 합니다. //==================================================================================================== down.setMarkupTagDelimiter(\"┼\",\"╫\",\"╬\",\"╪\"); ```",
              "see": [
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                },
                {
                  "label": "loadExcel method",
                  "url": "/docs/funcs/excel/load-excel"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/markup-tag-delimiter.html"
          },
          {
            "cid": 115,
            "sid": "max-pages",
            "name": "max-pages",
            "label": "MaxPages",
            "data": {
              "body": "> `SearchMode: 2` 인 경우, 시트가 한 번에 갖고 있는 페이지 수를 설정합니다. > 페이지 수가 클수록 많은 DOM을 갖게 됨으로 무거워 질 수 있습니다. > 페이지 수가 너무 적으면 스크롤을 움직일 때 마다 빈번하게 데이터 로딩이 일어날 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|갖고있는 페이지 수 (`default: 1`)| ### Example ```javascript options.Cfg ={ MaxPages: 5, //5개 페이지만 갖고 있음 }; ```",
              "see": [
                {
                  "label": "PageLength cfg",
                  "url": "/docs/props/cfg/page-length"
                },
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                },
                {
                  "label": "updateClientPaging method",
                  "url": "/docs/funcs/core/update-client-paging"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/max-pages.html"
          },
          {
            "cid": 116,
            "sid": "max-sort",
            "name": "max-sort",
            "label": "MaxSort",
            "data": {
              "body": "> 헤더 클릭을 이용한 연계 소팅의 최대 개수를 설정합니다. > 화면에 보이는 열만 사용할 수 있으며, 3개 이후부터는 성능이 느려질 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|연계 정렬 가능 열 수 (`default: 3`)| ### Example ```javascript options.Cfg = { MaxSort: 2, // 최대 2개 열만 연계 소팅을 처리함. }; ```",
              "see": [
                {
                  "label": "CanSort cfg",
                  "url": "./can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/max-sort.html"
          },
          {
            "cid": 117,
            "sid": "max-v-scroll",
            "name": "max-v-scroll",
            "label": "MaxVScroll",
            "data": {
              "body": "> `NoVScroll` 을 사용하면서 해당 높이부터는 스크롤을 만들고 싶은 경우, 사용하는 기능으로써 해당 기능을 사용하면 스크롤이 생기는 높이를 지정할 수 있습니다. > > `주의` 해당 옵션은 시트 생성 시 시트가 생성된 Dom el의 높이를 변경하기 때문에 생성 이후 해당 옵션을 변경할 경우, 시트가 그려진 요소의 높이를 다시 설정해야 합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|스크롤이 생기는 최대 높이| ### Example ```javascript options = { Cfg:{ NoVScroll: 1, MaxVScroll: 500 } }; ```",
              "see": [
                {
                  "label": "NoVScroll cfg",
                  "url": "./no-v-scroll"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.23|기능 추가|"
            },
            "url": "docs/props/cfg/max-v-scroll.html"
          },
          {
            "cid": 118,
            "sid": "memo-id",
            "name": "memo-id",
            "label": "MemoId",
            "data": {
              "body": "> 시트에 메모기능을 사용하기 위해 필요한 고유한 id 값을 설정합니다. > 메모기능은 시트의 헤더 셀에 설정 가능합니다. > 메모기능이 설정된 헤더 셀에는 왼쪽 위에 빨간색 삼각형이 표시됩니다. > 메모기능이 설정된 헤더 셀에 마우스를 올렸을 경우 툴팁 형태로 메모값이 보여집니다. > 메모 값 설정을 위해서는 [showMemoDialog method](/docs/funcs/core/show-memo-dialog)를 통하여 셋팅 가능합니다. > 메모 데이터는 브라우저의 localStorage에 관리됩니다. ![MemoId](/assets/imgs/memoId0.png) ![MemoId](/assets/imgs/memoId1.png) ### Type `string` ### Example ```javascript options.Cfg = { MemoId: \"sheet1Memo\" // 메모기능을 사용하기 위한 시트의 메모 id 값 설정 }; ```",
              "see": [
                {
                  "label": "showMemoDialog method",
                  "url": "/docs/funcs/core/show-memo-dialog"
                },
                {
                  "label": "removeMemo method",
                  "url": "/docs/funcs/core/remove-memo"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.19|기능 추가|"
            },
            "url": "docs/props/cfg/memo-id.html"
          },
          {
            "cid": 119,
            "sid": "menu-buttons",
            "name": "menu-buttons",
            "label": "MenuButtons",
            "data": {
              "body": "> 기존의 아무설정 없이 [Enum](/docs/props/col/enum) 타입의 셀([Defaults](/docs/props/col/defaults) 포함)에서 `Menu.Buttons`의 순서는 `Clear, Ok` 순서로만 만들어지고 있다. > [Enum](/docs/props/col/enum) 타입의 셀([Defaults](/docs/props/col/defaults) 포함)에서 [Menu](/docs/appx/menu) 하단의 `Buttons`의 순서를 변경할 수 있다. > `Type`은 배열형태로 지원한다. ### Type `array` ### Example ```javascript options.Cfg = { MenuButtons: [\"Ok\", \"Clear\"], // 버튼의 순서를 Ok, Clear 순으로 변경한다. ... }; options.Col = [ { Header: '콤보(Enum)', Type: 'Enum', Name: 'ComboData', Width: 100, Align: 'Right', Enum: '|대기|진행중|완료', EnumKeys: '|01|02|03', Range: true, } ] ```",
              "see": [
                {
                  "label": "Defaults col",
                  "url": "/docs/props/col/defaults"
                },
                {
                  "label": "Enum col",
                  "url": "/docs/props/col/enum"
                },
                {
                  "label": "Range col",
                  "url": "/docs/props/col/range"
                },
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/props/cfg/menu-buttons.html"
          },
          {
            "cid": 120,
            "sid": "menu-h-separator",
            "name": "menu-h-separator",
            "label": "MenuHSeparator",
            "data": {
              "body": "> [Menu](/docs/props/col/menu) 사용시 아이템 구분자를 지정할 수 있습니다. > 더불어 `-`와 `-*`는 기본적으로 [EnumKeys](/docs/props/col/enum-keys) 옵션에 설정했을 때 구분자가 생성되는 예약어로 작동하는데, 만약 `-`, 혹은 `-*` 예약어를 [EnumKeys](/docs/props/col/enum-keys)에 직접 데이터로 넣고 싶으시다면 해당 옵션을 이용해 `-`, `-*` 이외의 문자열을 지정해주시면 됩니다. ![MenuHSeparator](/assets/imgs/MenuHSeparator.png \"여MenuHSeparator 기능\") ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|메뉴 아이템 구분자로 지정할 예약어| ### Example ```javascript options.Cfg = { MenuHSeparator : '!', // 메뉴 아이템 구분자로 지정할 예약어 --------를 표시할 구분자를 !로 변경 }; options.Cols = [ { Type: 'Enum', \"Enum\": \"|대기|-|진행중|완료\",\"EnumKeys\": \"|01|-|02|03|04\", Name: 'char' ... }, // '-'와 같은 구분자 예약어도 데이터로 사용가능 { Type: \"Text\", Menu: \"|진행|반려|전결|보류\", Name: \"procs\" ... } ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "/docs/props/col/enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "/docs/props/col/enum-keys"
                },
                {
                  "label": "Menu col",
                  "url": "/docs/props/col/menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/props/cfg/menu-h-separator.html"
          },
          {
            "cid": 121,
            "sid": "menu-max-height",
            "name": "menu-max-height",
            "label": "MenuMaxHeight",
            "data": {
              "body": "> `(Col, Cell)Type`이 `Enum`인 열에서 열리는 메뉴의 최대 높이를 지정합니다. > `Suggest`로 열리는 메뉴에도 적용됩니다. ### Type `string` ### Example ```javascript options.Cfg = { MenuMaxHeight: 400 }; ```",
              "see": [
                {
                  "label": "Type col",
                  "url": "/docs/props/col/type"
                },
                {
                  "label": "Type cell",
                  "url": "/docs/props/cell/type"
                },
                {
                  "label": "Suggest col",
                  "url": "/docs/props/col/suggest"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/menu-max-height.html"
          },
          {
            "cid": 122,
            "sid": "menu",
            "name": "menu",
            "label": "Menu",
            "data": {
              "body": "> 마우스 우측 버튼 클릭 시 보여질 컨텍스트 메뉴를 설정합니다. > `InfoRow`를 제외한 시트의 다른행들에서 표시됩니다. ### Type mixed( `object` \\| `string` ) ### Options |Value|Description| |-----|-----| |`string`|첫글자를 구분자로 한 컨텍스트 메뉴스트링 지정 (ex: @저장@임시저장@취소 or *상신*취소) | |`object`|[Menu Object 설정 링크 참고](/docs/appx/menu) ### Example ```javascript // 문자열로 설정하는 경우 options.Cfg = { Menu: \"|행추가|행숨기기|행삭제\" }; // object로 설정하는 경우 options.Cfg = { Menu: { Items: [ { Name: \"Excel\", Value: \"xls\" }, { Name: \"text\", Value: \"txt\" }, { Name: \"pdf\", Value: \"pdf\" }, ], OnSave: function (item, data) { switch(item.Value){ case 'xls': try{ this.Sheet.down2Excel({FileName:\"test.xlsx\",SheetDesign:1}); }catch(e){ if(e.message.indexOf(\"down2Excel is not a function\")>-1){ console.log(\"%c 경고\",\"color:#FF0000\",\" : ibsheet-excel.js 파일이 필요합니다.\"); } } break; case 'txt': try{ this.Sheet.down2Text(); }catch(e){ if(e.message.indexOf(\"down2Text is not a function\")>-1){ console.log(\"%c 경고\",\"color:#FF0000\",\" : ibsheet-excel.js 파일이 필요합니다.\"); } } break; case 'pdf': try{ this.Sheet.down2Pdf(); }catch(e){ if(e.message.indexOf(\"down2Pdf is not a function\")>-1){ console.log(\"%c 경고\",\"color:#FF0000\",\" : ibsheet-excel.js 파일이 필요합니다.\"); } } break; } }; } }; ```",
              "see": [
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                },
                {
                  "label": "MenuHSeparator cfg",
                  "url": "/docs/props/cfg/menu-h-separator"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/menu.html"
          },
          {
            "cid": 123,
            "sid": "merge-cells-match",
            "name": "merge-cells-match",
            "label": "MergeCellsMatch",
            "data": {
              "body": "> 머지된 데이터 수정시 전체 머지 영역의 데이터를 수정합니다. > [setValue](/docs/funcs/core/set-value)를 통한 값 변경 시에도 적용됩니다. > [onBeforeChange](/docs/events/on-before-change), [onAfterChange](/docs/events/on-after-change)는 값이 변경된 전체 셀 마다 발생합니다. > 해당 기능은 자동 머지([DataMerge](/docs/props/cfg/data-merge))를 이용한 머지 영역에서만 동작됩니다. > `주의` 복사붙여넣기(ctrl+c/ctrl+v) 를 통해 데이터를 수정할 때에는 셀 단위로 사용해야 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|머지된 셀 수정시 첫번째 셀의 값만 변경 (`default`)| |`1(true)`|머지된 셀 수정시 전체 머지 영역의 값 변경| ### Example ```javascript options.Cfg = { MergeCellsMatch: true }; ```",
              "see": [
                {
                  "label": "DataMerge Cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "setValue Method",
                  "url": "/docs/funcs/core/set-value"
                },
                {
                  "label": "onBeforeChange Event",
                  "url": "/docs/events/on-before-change"
                },
                {
                  "label": "onAfterChange Event",
                  "url": "/docs/events/on-after-change"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가||core|8.1.0.49|복사붙여넣기를 통한 값 변경에도 기능 적용|"
            },
            "url": "docs/props/cfg/merge-cells-match.html"
          },
          {
            "cid": 124,
            "sid": "merge-height-adjust",
            "name": "merge-height-adjust",
            "label": "MergeHeightAdjust",
            "data": {
              "body": "> [HtmlPrefix](/docs/props/col/html-prefix)나 [HtmlPostfix](/docs/props/col/html-postfix)와 같이 Cell의 높이에 영향을 주는 기능을 사용할 경우, 병합 영역 또는 시트의 레이아웃 깨짐 현상이 발생 시, 병합 영역의 높이를 조정합니다. > 이 속성을 true로 설정 시, 시트 내의 병합 정보를 확인하여 수행됨으로써, 병합 정보 수에 따라 시트가 느려질 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|병합된 행의 높이 보정 안함 (`default`)| |`1(true)`|병합된 행의 높이 보정| ### Example ```javascript options.Cfg = { MergeHeightAdjust: 1 // 병합된 영역의 높이 보정 }; ```",
              "see": [
                {
                  "label": "HtmlPrefix row",
                  "url": "/docs/props/row/html-prefix"
                },
                {
                  "label": "HtmlPrefix col",
                  "url": "/docs/props/col/html-prefix"
                },
                {
                  "label": "HtmlPrefix cell",
                  "url": "/docs/props/cell/html-prefix"
                },
                {
                  "label": "HtmlPostfix row",
                  "url": "/docs/props/row/html-postfix"
                },
                {
                  "label": "HtmlPostfix col",
                  "url": "/docs/props/col/html-postfix"
                },
                {
                  "label": "HtmlPostfix cell",
                  "url": "/docs/props/cell/html-postfix"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.3|기능 추가|"
            },
            "url": "docs/props/cfg/merge-height-adjust.html"
          },
          {
            "cid": 125,
            "sid": "merge-visible-dom",
            "name": "merge-visible-dom",
            "label": "MergeVisibleDom",
            "data": {
              "body": "> [SearchMode](/docs/props/cfg/search-mode):0 에서 보이는 영역만 머지할지에 대한 여부를 설정합니다. > [MergeCellsMatch Cfg](/docs/props/cfg/merge-cells-match) 와 함께 사용시 보이지 않는 영역까지 머지된 셀에 대해서 데이터 값을 자동으로 바꾸게 할 수 있습니다. <!-- 해당 기능은 자동 머지([DataMerge](/docs/props/cfg/data-merge))를 이용한 머지 영역에서만 동작됩니다. --> ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|자동 머지시 전체 머지 영역의 값 병합| |`1(true)`|자동 머지시 보여지는 셀의 영역까지만 병합 (`default`)| ### Example ```javascript options.Cfg = { MergeVisibleDom: false }; ```",
              "see": [
                {
                  "label": "DataMerge Cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "MergeCellsMatch Cfg",
                  "url": "/docs/props/cfg/merge-cells-match"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.26|기능 추가|"
            },
            "url": "docs/props/cfg/merge-visible-dom.html"
          },
          {
            "cid": 126,
            "sid": "message-width",
            "name": "message-width",
            "label": "MessageWidth",
            "data": {
              "body": "> 시트 메시지 창의 최소 너비(`pixel`) 를 설정합니다. > [showMessage()](/docs/funcs/core/show-message)나 [showMessageTime()](/docs/funcs/core/show-message-time)과 같은 메소드를 통해 `Layer팝업` 형태로 시트 중앙에 표시되는 메세지 창의 너비를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|메세지 창의 최소 너비 (`default: 140`)| ### Example ```javascript options.Cfg = { SuppressMessage: 0, // 시트의 모든 상태 메세지 표시 MessageWidth: 200, // 메세지 창의 너비를 200px 로 설정 ... }; ```",
              "see": [
                {
                  "label": "SuppressMessage cfg",
                  "url": "./suppress-message"
                },
                {
                  "label": "MoveMessage cfg",
                  "url": "./move-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/message-width.html"
          },
          {
            "cid": 127,
            "sid": "mid-width",
            "name": "mid-width",
            "label": "MidWidth",
            "data": {
              "body": "> 중앙 열 섹션의 최대 너비를 설정합니다. > 열 섹션의 열들이 설정된 너비보다 큰 경우 스크롤바가 생성됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|중앙 섹션의 총 너비| ### Example ```javascript options = { Cols:[ { //열 헤더 설정 Header: { Value: \"No\" // 헤더행의 SEQ 열에 해당하는 셀에 표시될 title 값 }, Name: \"SEQ\", // 행의 순서를 보여주는 열으로, 자동으로 순번이 시트에서 생성됩니다. }, { // 열 헤더 설정 Header: { Value: \"회사명3\" // 헤더행의 sCorp 열에 해당하는 셀에 표시될 title 값 }, Name: \"sCorp\", // colName 열이름을 설정 (Data와 Matching) Type: \"Text\" // 열 타입 }, ... ], Cfg :{ MidWidth: 500, // 중앙 열 섹션의 최대 너비 설정 } }; ```",
              "see": [
                {
                  "label": "LeftWidth cfg",
                  "url": "./left-width"
                },
                {
                  "label": "RightWidth cfg",
                  "url": "./right-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/mid-width.html"
          },
          {
            "cid": 128,
            "sid": "move-deselect-mode",
            "name": "move-deselect-mode",
            "label": "MoveDeselectMode",
            "data": {
              "body": "> 해당 옵션 설정 후 **방향키, 페이지 업다운 키, 홈 엔드 키** 입력시 현재 선택된 영역이 해제됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|방향키, 페이지 업다운 키, 홈 엔드 키 입력시에도 현재 선택된 영역이 해제되지 않음. (`default`)| |`1(true)`|방향키, 페이지 업다운 키, 홈 엔드 키 입력시 현재 선택된 영역 해제| ### Example ```javascript options.Cfg = { MoveDeselectMode: true }; ```",
              "see": [
                {
                  "label": "CanSelect cfg",
                  "url": "./can-select"
                },
                {
                  "label": "SelectingCells cfg",
                  "url": "./selecting-cells"
                },
                {
                  "label": "Selected row",
                  "url": "/docs/props/row/selected"
                },
                {
                  "label": "Selected col",
                  "url": "/docs/props/col/selected"
                },
                {
                  "label": "Selected cell",
                  "url": "/docs/props/cell/selected"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/props/cfg/move-deselect-mode.html"
          },
          {
            "cid": 129,
            "sid": "move-message",
            "name": "move-message",
            "label": "MoveMessage",
            "data": {
              "body": "> 시트 메시지 창의 드래그 여부를 설정합니다. > `1(true)`로 설정시 사용자가 메세지 장을 드래그를 통해 옮길 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|메세지 창의 드래그 불가능 (`default`)| |`1(true)`|메세지 창의 드래그 가능| ### Example ```javascript options.Cfg = { MoveMessage: 0, // 메세지 창 드래깅 가능 ... }; ```",
              "see": [
                {
                  "label": "SuppressMessage cfg",
                  "url": "./suppress-message"
                },
                {
                  "label": "MessageWidth cfg",
                  "url": "./message-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/move-message.html"
          },
          {
            "cid": 130,
            "sid": "msg-locale",
            "name": "msg-locale",
            "label": "MsgLocale",
            "data": {
              "body": "> 시트에서 사용할 언어(메세지 파일) Language Prefix를 설정합니다. > > 제품과 함께 배포되는 메세지 파일(ko.js,en.js등)안에 메세지 구조는 다음과 같습니다. ```js IBSMSG.[Language Prefix] = { \"Lang\": { // ... 중략 ... } } ``` > 한국어 외에 다른 나라 언어(메세지)를 사용하고자 하실 때는 해당 메세지 파일(js)를 import 하고, 그에 대한 Language Prefix값을 이 속성으로 설정하시면 됩니다. > <mark>**만약 이 속성을 설정하지 않은 경우에는 사용자 브라우저의 언어(navigator.language)을 확인하여 해당 값을 Language Prefix로 사용하게 됩니다.**<mark/> ### Type `string` ### Options |Value|Description| |-----|-----| |`Ko`|한국어 메세지| |`En`|영어 메세지| |`Jp`|일본어 메세지| |`Cn`|중국어 메세지| |`Etc`|직접 만든 다른 메세지 Prefix 사용 가능| ### Example ```html <!-- 영문 메세지 import --> <script src=\"./common/ibsheet/locale/en.js\"></script> ``` ```javascript options.Cfg = { \"MsgLocale\":\"En\" //영문 메세지 사용 }; ```",
              "see": [
                {
                  "label": "getLocale method",
                  "url": "/docs/funcs/core/get-locale"
                },
                {
                  "label": "setLocale method",
                  "url": "/docs/funcs/core/set-locale"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/msg-locale.html"
          },
          {
            "cid": 131,
            "sid": "multi-record-shape",
            "name": "multi-record-shape",
            "label": "MultiRecordShape",
            "data": {
              "body": "> 멀티레코드([MultiRecord](/docs/props/cfg/multi-record)) 기능을 사용하는 시트에서 엑셀 파일 다운로드를 보여지는 그대로 나타나게 하는 설정입니다. > 서버 모듈 다운로드([down2Excel](/docs/funcs/excel/down-to-excel))에 대해서만 지원됩니다. 클라이언트 모듈 다운로드([exportData](/docs/funcs/core/export-data))는 지원하지 않습니다. > 다이얼로그를 이용한 다운로드 하는 [showDownloadDialog](/docs/funcs/dialog/show-download-dialog)에서는 지원되지 않습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|열을 일렬로 표시해서 다운로드 (`default`)| |`1`|열을 시트에서 보이는대로 표시해서 다운로드| ### Example ```javascript options.Cfg = { MultiRecord: 1, // 멀티레코드 전용 시트로 설정 MultiRecordShape: 1, // 멀티레코드 시트의 모양대로 엑셀 파일 다운로드 ... }; // API 사용 sheet.down2Excel({ sheetDesign: 1, merge: 1 }); // 엑셀 다운로드 실행 ```",
              "see": [
                {
                  "label": "MultiRecord cfg",
                  "url": "/docs/props/cfg/multi-record"
                },
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||excel|0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/multi-record-shape.html"
          },
          {
            "cid": 132,
            "sid": "multi-record",
            "name": "multi-record",
            "label": "MultiRecord",
            "data": {
              "body": "> 시트에서 하나의 데이터를 여러 줄로 표시하는 기능입니다. > 일반적인 시트는 헤더가 여러 개이더라도 데이터는 조회된 데이터(레코드)마다 하나의 행으로 표현되는데 이를 여러 행으로 표시되도록 하는 기능입니다. > 따라서, 기능 제약이 있고 그 기능 제약은 다음과 같습니다. (이외의 기능은 기본 시트의 동작과 동일합니다.) > * `소계 사용 불가` > * `그룹 사용 불가` > * `트리 사용 불가` > * `자동 병합 기능 사용 불가(생성할 때 RecordRowSpan 및 RecordColSpan으로만 병합기능 사용가능)` > * `동적으로 영역 병합 기능 사용 불가(생성할 때 RecordRowSpan 및 RecordColSpan으로만 병합기능 사용가능)` > * `열이동 불가` > * `생성할 때 Visible 속성 사용시 주의(생성할 때 가장 마지막 열에 생성하도록 권장)` > * `hideCol/showCol 불가(동적으로 컬럼 보임 여부 컨트롤 불가)` > * `동적으로 열 추가/삭제 불가(시트 생성할 때 정의된 Cols만 사용가능)` > * `셀/열 단위 선택 불가(행 단위 선택만 가능)` > * `셀/열 단위 복사/붙여넣기 불가(행 단위 복사/붙여넣기 가능)` > * `SelectionSummary 기능 사용 불가` > * `엑셀 다운로드/업로드 및 행 복사/붙여넣기는 모든 열이 일렬로 처리됨(모양이 유지되진 않음)` > * `doPrint 프린트 시 모든 열이 일렬로 처리됨(모양이 유지되진 않음)` > * `down2Pdf 다운로드 모든 열이 일렬로 처리됨(모양이 유지되진 않음)` > * `여러 헤더행 중에 최상단 행의 너비 기준으로 Width가 적용됨, 최상단 행을 제외한 Width 속성은 동작하지 않음` > * `RecordColSpan이 설정된 더미컬럼은 RelWidth 기능이 동작하지 않으며 동적으로 Width가 변하지 않음` > * `Def.Header.SortIcons: 1(모든 정렬 아이콘 표시기능)은 사용 불가` > * `LeftCols/RightCols 와 Type:\"Lines\"는 함께 사용 불가` ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|멀티레코드 기능 비활성화 (`default`)| |`1(true)`|멀티레코드 기능 활성화| ### Example ```javascript options.Cfg = { MultiRecord: true // 멀티레코드 전용 시트로 설정 ... }; // 멀티레코드 기능 사용시 열설정(1차원 배열 -> 2차원 배열) options.Cols = [ //첫번째 단위데이터행(DataRow) [ {Header: \"A\", Name: \"colA\", Type:\"Text\", Width: 100}, {Header: \"B\", Name: \"colB\", Type:\"Image\", Width: 100, RecordRowSpan: 3}, {Header: \"C\", Name: \"colC\", Type:\"Int\", Width: 100}, {Header: \"D\", Name: \"colD\", Type:\"Float\", Width: 100} ], //두번째 단위데이터행(DataRow) [ {Header: \"E\", Name: \"colE\", Type:\"Text\", Width: 100}, {Header: \"B\"}, {Header: \"F\", Name: \"colF\", Type:\"Enum\", Width: 100}, {Header: \"G\", Name: \"colG\", Type:\"Date\", Width: 100} ], //세번째 단위데이터행(DataRow) [ {Header: \"H\", Name: \"colH\", Type:\"Text\", Width: 100}, {Header: \"B\"}, {Header: \"I\", Name: \"colI\", Type:\"Text\", Width: 100, RecordColSpan: 2}, {Header: \"I\", Width: 120} // 더미컬럼 ] ]; // 멀티레코드 사용시 데이터(기존과 같음) data = [ {colA: \"data1_A\", colB: \"data1_B\", colC: 0, colD: 0.0, colE: \"data1_E\", colF: \"code1\" ,colG: \"20191017\", colH: \"data1_H\", colI: \"data1_I\"}, {colA: \"data2_A\", colB: \"data2_B\", colC: 1, colD: 1.0, colE: \"data2_E\", colF: \"code2\" ,colG: \"20191101\", colH: \"data2_H\", colI: \"data2_I\"}, ]; ```",
              "see": [
                {
                  "label": "RecordRowSpan col",
                  "url": "/docs/props/col/record-row-span"
                },
                {
                  "label": "RecordColSpan col",
                  "url": "/docs/props/col/record-col-span"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.4|엑셀 업로드/다운로드 다이얼로그 대응|"
            },
            "url": "docs/props/cfg/multi-record.html"
          },
          {
            "cid": 133,
            "sid": "no-data-message",
            "name": "no-data-message",
            "label": "NoDataMessage",
            "data": {
              "body": "> 빈 데이터로 시트 생성(IBSheet.create의 data인자), 조회 함수를 이용한 조회시 **\"조회된 데이터가 없습니다.\"** 라는 메세지 표시여부를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|시트 생성, 조회 시 메세지 표시 안함.| |`1`|시트 생성 시에만 메세지 표시| |`2`|조회 시에만 메세지 표시 (`default`)| |`3`|시트 생성, 조회 시 메세지 표시| ### Example ```javascript options.Cfg = { NoDataMessage: 2, // 조회 함수를 이용한 조회 시에만 메세지 표시 ... }; ``` ### Try it - [Set to 3](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/NoDataMessage/)",
              "see": [
                {
                  "label": "create static",
                  "url": "/docs/static/create"
                },
                {
                  "label": "loadSearch method",
                  "url": "/docs/funcs/core/load-search-data"
                },
                {
                  "label": "doSearch method",
                  "url": "/docs/funcs/core/do-search"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "/docs/funcs/core/do-search-paging"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.6|기능 추가|"
            },
            "url": "docs/props/cfg/no-data-message.html"
          },
          {
            "cid": 134,
            "sid": "no-data-middle",
            "name": "no-data-middle",
            "label": "NoDataMiddle",
            "data": {
              "body": "> 조회 된 데이터가 없는 경우 표시되는 NoData행을 화면 가운데에 표시합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|NoData행을 상단에 표시 (`default`)| |`1(true)`|NoData행을 화면 가운데에 표시| NoDataMiddle : 0 (`default`) ![NoDataMiddle:0](/assets/imgs/NoDataMiddle0.png \"NoDataMiddle:0\") NoDataMiddle : 1 ![NoDataMiddle:1](/assets/imgs/NoDataMiddle.png \"NoDataMiddle:1\") ### Example ```javascript options.Cfg = { NoDataMiddle: 1, // 조회된 데이터가 없는 경우 화면 가운데에 표시 ... }; ``` ### Try it - [True](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/NoDataMessage/)",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.36|기능 추가|"
            },
            "url": "docs/props/cfg/no-data-middle.html"
          },
          {
            "cid": 135,
            "sid": "no-format-escape",
            "name": "no-format-escape",
            "label": "NoFormatEscape",
            "data": {
              "body": "> 열 ([Col](/docs/props/col/format), [Cell](/docs/props/cell/format)) [Format](/docs/appx/format) 에 Html 태그로 사용되는 &, < 문자를 그대로 출력할지 여부를 설정합니다. > 해당 속성을 설정하지 않는 경우 text 열은 `0(false)`를, lines / number / date 타입은 `1(true)`를 기본값으로 가지게 됩니다. > `0(false)`를 설정시 &, < 문자는 그대로 출력되고, `1(true)`를 설정시 열 `(Col, Cell) Format` 에 HTML 태그를 넣어 사용할 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|**&, <** 문자가 그대로 출력 (`default: text 열`)| |`1(true)`|`HTML 태그`를 사용 (`default: lines, number, date 열`)| ### Example ```javascript options.Cfg = { NoFormatEscape: true, // (cell, col)Format 에 html 태그를 넣어 사용 ... }; ```",
              "see": [
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                },
                {
                  "label": "Format col",
                  "url": "/docs/props/col/format"
                },
                {
                  "label": "Format cell",
                  "url": "/docs/props/cell/format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/no-format-escape.html"
          },
          {
            "cid": 136,
            "sid": "no-h-scroll",
            "name": "no-h-scroll",
            "label": "NoHScroll",
            "data": {
              "body": "> 시트에 가로스크롤바를 표시하지 않는 기능으로 시트 컬럼의 개수 만큼 너비가 결정됩니다. > 해당 기능은 `SearchMode: 0 (FastLoad)`에서는 사용할 수 없습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|시트내 가로 스크롤 사용 (`default`)| |`1(true)`|가로 스크롤 사용안함| ### Example ```javascript options = { Cfg:{ NoHScroll: true, //시트 내에 가로스크롤을 표시하지 않고, 너비를 조절함 }, }; ```",
              "see": [
                {
                  "label": "NoVScroll cfg",
                  "url": "./no-v-scroll"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/no-h-scroll.html"
          },
          {
            "cid": 137,
            "sid": "no-pivot-sort",
            "name": "no-pivot-sort",
            "label": "NoPivotSort",
            "data": {
              "body": "> 피벗 시트 생성시 원본 시트 데이터 정렬을 사용할지 여부를 결정합니다. > 정렬을 사용하는 경우 계산 대상의 행 정보 순서대로 정렬됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|피벗 시트 생성을 위한 원본 데이터 정렬 사용 (`default`)| |`1(true)`|피벗 시트 생성을 위한 원본 데이터 정렬 사용 안함| ### Example ```javascript options = { \"Cfg\":{ \"NoPivotSort\": 1, // 원본 시트 정렬 안함 } }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "makePivotTable method",
                  "url": "/docs/funcs/core/make-pivot-table"
                },
                {
                  "label": "switchPivotSheet method",
                  "url": "/docs/funcs/core/switch-pivot-sheet"
                },
                {
                  "label": "clearFilter method",
                  "url": "/docs/funcs/core/clear-filter"
                },
                {
                  "label": "setFilter method",
                  "url": "/docs/funcs/core/set-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.12|기능 추가|"
            },
            "url": "docs/props/cfg/no-pivot-sort.html"
          },
          {
            "cid": 138,
            "sid": "no-render-hidden",
            "name": "no-render-hidden",
            "label": "NoRenderHidden",
            "data": {
              "body": "> 시트 생성후 최초 조회할 때 보이지 않는 컬럼은 Dom에 생성하지 않도록 합니다. > 해당 기능을 사용하면 보이지 않는 컬럼 (Visible: 0) 은 화면에 랜더링되지 않아 많은 컬럼이 있는 경우 보다 빠르게 랜더링 될 수 있습니다. > `주의` 단, 해당 옵션 사용 후 `showCol, hideCol` 을 이용하여 컬럼을 보이거나 숨기게 할 경우에는 반드시 `render` 인자를 `0` 으로 사용 후 마지막에 `rerender` 함수를 호출해야 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|보이지 않는 컬럼(Visible:0) 을 Dom에 미리 생성함 (`default`)| |`1(true)`|보이지 않는 컬럼(Visible:0) 을 Dom에 미리 생성하지 않음| ### Example ```javascript options = { \"Cfg\":{ \"NoRenderHidden\": 1, // 보이지 않는 컬럼을 Dom 에 미리 생성하지 않도록 설정 } }; ```",
              "see": [
                {
                  "label": "showCol",
                  "url": "/docs/funcs/core/show-col"
                },
                {
                  "label": "hideCol",
                  "url": "/docs/funcs/core/hide-col"
                },
                {
                  "label": "rerender",
                  "url": "/docs/funcs/core/rerender"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.21|기능 추가|"
            },
            "url": "docs/props/cfg/no-render-hidden.html"
          },
          {
            "cid": 139,
            "sid": "no-tree-lines",
            "name": "no-tree-lines",
            "label": "NoTreeLines",
            "data": {
              "body": "> 트리를 사용하는 시트 생성시 노드와 노드 사이의 연결선을 표시할 지 여부를 설정합니다. > 1 로 설정시 단순한 접기/펼침 버튼 형태로 트리의 노드가 표현됩니다. ### ![NoTreeLines](/assets/imgs/noTreeLines.png \"NoTreeLines 사용\") [NoTreeLines: true] ![일반트리](/assets/imgs/tree.png \"일반 트리\") [일반트리] ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|노드 연결 선을 표시 (`default`)| |`1(true)`|노드 연결 선을 표시하지 않음| ### Example ```javascript options.Cfg = { NoTreeLines: true, //노드 연결선을 표시하지 않음. ... }; ```",
              "see": [
                {
                  "label": "MainCol cfg",
                  "url": "./main-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/no-tree-lines.html"
          },
          {
            "cid": 140,
            "sid": "no-v-scroll",
            "name": "no-v-scroll",
            "label": "NoVScroll",
            "data": {
              "body": "> 시트에 세로스크롤바를 표시하지 않는 기능으로 조회된 데이터의 갯수만큼 시트의 높이가 동적으로 변경됩니다. > `SearchMode: 1`이나 `SearchMode: 4,5`를 이용한 페이징 조회시에는, 전체 데이터에서 `PageLength`에 설정한 크기만큼 높이가 변경됩니다. > 해당 기능은 `SearchMode: 0`에서는 사용할 수 없습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|시트내 세로 스크롤 사용 (`default`)| |`1(true)`|세로 스크롤 사용안함| ### Example ```javascript options = { Cfg:{ NoVScroll: true //시트에 세로스크롤바를 표시하지 않고 전체 데이터 양에 따라 높이 자동 조절 } }; ```",
              "see": [
                {
                  "label": "NoHScroll cfg",
                  "url": "./no-h-scroll"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/no-v-scroll.html"
          },
          {
            "cid": 141,
            "sid": "page-length",
            "name": "page-length",
            "label": "PageLength",
            "data": {
              "body": "> 한 페이지(`Page`)에 표시할 행(`Row`) 의 개수를 설정합니다. > `SearchMode: 1 (클라이언트 페이징)`로 조회시 한 페이지에 표시되는 데이터 행수로 처리됩니다. > `SearchMode: 2 (LazyLoad)` 조회시 한 번에 조회되는 데이터는 `PageLength` 와 `MaxPages`(default 1) 로 계산된 데이터만큼 조회됩니다. > `SearchMode: 1,2,4,5`로 조회시 PageLength의 값이 너무 크면 성능이 떨어집니다. 20~100개 설정 권장합니다. > **<mark>주의</mark> : 서버페이징(SearchMode: 3,4,5) 사용 시 PageLength 값과 서버에서 받아오는 데이터의 갯수를 반드시 맞춰주셔야 합니다.(PageLength 설정하지 않았을 경우 기본값은 20 입니다)** ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|한 페이지 단위의 행수 (`default: 20`)| ### Example ```javascript options = { Cfg :{ PageLength: 30, // 한페이지당 표시할 행수 MaxPages: 5 // 렌더링될 페이지 수를 설정 } }; ```",
              "see": [
                {
                  "label": "MaxPages cfg",
                  "url": "/docs/props/cfg/max-pages"
                },
                {
                  "label": "goToPage method",
                  "url": "/docs/funcs/core/go-to-page"
                },
                {
                  "label": "updateClientPaging method",
                  "url": "/docs/funcs/core/update-client-paging"
                },
                {
                  "label": "updatePageLength method",
                  "url": "/docs/funcs/core/update-page-length"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/page-length.html"
          },
          {
            "cid": 142,
            "sid": "paste-cols",
            "name": "paste-cols",
            "label": "PasteCols",
            "data": {
              "body": "> `ctrl+v` 를 통해 클립보드의 내용을 시트에 붙여넣을 때, 어떤 열을 기준으로 데이터가 붙여넣어질지 설정합니다. > 맨 앞에 열 부터 붙여넣을 지, 포커스가 있는 위치 우측으로 붙여넣을 지 등을 설정할 수 있습니다. > [(col)CanCopyPaste](/docs/props/col/can-copy-paste)속성에 따라 붙여넣기 가능/불가능 여부가 결정됩니다. > 시트 내에서 드래그를 통한 선택은 [(cfg)SelectingCells](./selecting-cells)를 통해 설정가능합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|포커스가 된 열에만 붙여넣기가 됨.(포커스 된 셀을 기준으로 아래로 덮어씌움)| |`1`|포커스 위치와 무관하게 맨 왼쪽 열을 기준으로 보여지는 열에 붙여넣기가 됨.( `SelectingCells:0` 인 경우에 해당 값이 `default`)| |`2`|1번과 유사하게 왼쪽부터 붙여넣기가 되는데 히든된 열까지 포함해서 붙여넣기 함.| |`3`|포커스된 셀을 기준으로 우측, 아래로 붙여넣기 함.(`defaut`)| ### Example ```javascript options = { Cfg :{ PasteCols: 1 // 맨 왼쪽부터 보여지는 열에 붙여넣기 한다. } }; ```",
              "see": [
                {
                  "label": "CanCopyPaste col",
                  "url": "/docs/props/col/can-copy-paste"
                },
                {
                  "label": "SelectingCells cfg",
                  "url": "./selecting-cells"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/paste-cols.html"
          },
          {
            "cid": 143,
            "sid": "paste-focused",
            "name": "paste-focused",
            "label": "PasteFocused",
            "data": {
              "body": "> 시트에서 `ctrl+c` 로 복사한 데이터를 `ctrl+v` 로 붙여넣을때 데이터가 붙여질 방식을 설정합니다. > 붙여넣기를 할때는 반드시 해당 시트에 포커스된 행 또는 셀이 있어야 합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|포커스된 행에는 붙여넣기를 안함.| |`3`|포커스된 행과 그 하위 레벨의 행들만 붙여넣기 함. 만약 복사한 범위가 선택된 영역의 행 크기와 다를 경우 일치하지 않는 영역은 무시됨 (`default`)| |`6`|포커스된 행 상단에 신규행을 추가하여 붙여넣기 함.| |`9`|포커스된 행 하단으로 붙여넣기 하다가 더 이상 덮어씌울 행이 없는 경우에는 행을 추가하여 붙여넣기 함.| ### Example ```javascript options = { Cfg :{ PasteFocused: 6, // ctrl+v 시 신규행을 추가 } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/paste-focused.html"
          },
          {
            "cid": 144,
            "sid": "paste-strict-mode",
            "name": "paste-strict-mode",
            "label": "PasteStrictMode",
            "data": {
              "body": "> `ctrl+v` 를 통해 클립보드의 내용을 시트에 붙여넣을 때, 타입에 맞는 데이터만 붙여넣기 하는 것을 허용할 지 여부를 설정합니다. > `Int`, `Float` 타입의 컬럼에 대해서 붙여넣기 할때, 숫자인지 엄격하게 검사합니다. > 천단위 구분 쉼표는 허용합니다. > `ibsheet-common.js (1.0.14-20241219-14)` 사용하실 경우 기본 값은 `1(true)` 로 설정 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|숫자 데이터에 대해 정밀 검사하지 않음 (`default`)| |`1(true)`|숫자 데이터가 아닐 경우 붙여넣기 Skip.| ### Example ```javascript options.Cfg = { PasteStrictMode: 1 }; ```",
              "see": [
                {
                  "label": "event](/docs/events/on-after-paste)"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.13|기능 추가|"
            },
            "url": "docs/props/cfg/paste-strict-mode.html"
          },
          {
            "cid": 145,
            "sid": "pivot-format",
            "name": "pivot-format",
            "label": "PivotFormat",
            "data": {
              "body": "> 피벗 시트에 있는 셀들에 적용될 포맷을 설정합니다. ### Type `string` ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 PivotFormat: \"#,### 원\" // 시트 내 셀들의 포맷 }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/pivot-format.html"
          },
          {
            "cid": 146,
            "sid": "pivot-func",
            "name": "pivot-func",
            "label": "PivotFunc",
            "data": {
              "body": "> 피벗 시트의 데이터 값을 도출할 때 사용할 함수를 설정합니다. > [AcceptPivotData cfg](./accept-pivot-data) 를 통해 여러 개의 데이터 컬럼을 설정한다면 `PivotFunc` 도 동일한 개수로 맞춰주어야 합니다. 구분자는 `,(쉼표)` 를 이용합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |Sum|원본 데이터행 셀 값들을 합하여 피벗 시트의 셀 값을 설정합니다. (`default`)| |Count|원본 데이터행 셀 개수를 카운팅하여 피벗 시트의 셀 값을 설정합니다.| |Max|원본 데이터행 셀 값들 중 최대값으로 피벗 시트의 셀 값을 설정합니다.| |Min|원본 데이터행 셀 값들 중 최소값으로 시트의 셀 값을 설정합니다.| ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 PivotFunc: \"Count,Sum\" // PivotDataCol이 2개인 경우 각각 설정할 DataType. 구분자는 ,(쉼표) }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "PivotFormat cfg",
                  "url": "./pivot-format"
                },
                {
                  "label": "AcceptPivotRows cfg",
                  "url": "./accept-pivot-rows"
                },
                {
                  "label": "AcceptPivotCols cfg",
                  "url": "./accept-pivot-cols"
                },
                {
                  "label": "AcceptPivotData cfg",
                  "url": "./accept-pivot-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.46|`Max`, `Min` 기능 추가||core|8.2.0.15|`PivotFunc` 각 데이터 별 적용되도록 기능 개선|"
            },
            "url": "docs/props/cfg/pivot-func.html"
          },
          {
            "cid": 147,
            "sid": "pivot-sum-position",
            "name": "pivot-sum-position",
            "label": "PivotSumPosition",
            "data": {
              "body": "> 피벗 시 합계행의 위치를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|하단 - 푸터 영역 (`default`)| |`1(true)`|상단 - 헤더 영역| ### Example ```javascript options.Cfg = { UsePivot: true, // 피벗 사용 여부 PivotSumPosition: true }; ```",
              "see": [
                {
                  "label": "UsePivot cfg",
                  "url": "./use-pivot"
                },
                {
                  "label": "AcceptPivotRows cfg",
                  "url": "./accept-pivot-rows"
                },
                {
                  "label": "AcceptPivotData cfg",
                  "url": "./accept-pivot-data"
                },
                {
                  "label": "AcceptPivotCols cfg",
                  "url": "./accept-pivot-cols"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/props/cfg/pivot-sum-position.html"
          },
          {
            "cid": 148,
            "sid": "preserve-null",
            "name": "preserve-null",
            "label": "PreserveNull",
            "data": {
              "body": "> 사용자가 데이터를 null로 기입한 경우 시트 객체에 null 값 그대로 바인딩하고, `getSaveJson`으로 데이터 추출시 데이터를 \"\"이 아닌 null 값 그대로 추출합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| | `0` | 사용자가 데이터를 null로 기입해도 `getSaveJson`으로 데이터 추출할 때는 데이터가 \"\"으로 추출됨 (`default`)| | `1` | 사용자가 데이터를 null로 기입한 경우 `getSaveJson`으로 데이터 추출할 때 데이터가 null 값 그대로 추출됨 | ### Example ```javascript options = { Cfg :{ PreserveNull: 1, // 사용자가 데이터를 null로 기입한 경우 getSaveJson으로 데이터를 추출할 때 데이터가 null 값 그대로 추출됨 ... } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.34|기능 추가|"
            },
            "url": "docs/props/cfg/preserve-null.html"
          },
          {
            "cid": 149,
            "sid": "prev-column-merge-mode",
            "name": "prev-column-merge-mode",
            "label": "PrevColumnMergeMode",
            "data": {
              "body": "> [SearchMode:2](/docs/props/cfg/search-mode)에서 셀을 머지하는 기준을 설정하는 옵션입니다. > [SearchMode:2](/docs/props/cfg/search-mode)는 머지된 모든 `Row`가 한 Table안에 그려지기 때문에 머지된 셀이 많은 경우 성능 문제가 발생할 수 있습니다. > `PrevColumnMergeMode:1`설정 시 [PageLength](/docs/props/cfg/page-length) 만큼 페이지 단위로 나누어 그려지기 때문에 시트 성능이 향상됩니다. ### **`PrevColumnMergeMode:0(default)`** ![prevColumnMergeMode:0](/assets/imgs/prevColumnMergemode0.png) **`PrevColumnMergeMode:1, PageLength:10`** ![prevColumnMergeMode:1](/assets/imgs/prevColumnMergemode1.png) ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`| 같은 값을 가지는 모든 셀을 머지함 (`default`)| |`1(true)`| 페이지 단위로 나누어 셀을 머지함 | ### Example ```javascript options = { Cfg: { PrevColumnMergeMode: 1, // 페이지 단위로 나누어 셀을 머지합니다. ... } }; ```",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "setAutoMerge method",
                  "url": "/docs/funcs/core/set-auto-merge"
                },
                {
                  "label": "PageLength cfg",
                  "url": "/docs/props/cfg/page-length"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.11|기능 추가||core|8.0.0.12|default 변경 (1 -> 0)|"
            },
            "url": "docs/props/cfg/prev-column-merge-mode.html"
          },
          {
            "cid": 150,
            "sid": "prev-column-merge",
            "name": "prev-column-merge",
            "label": "PrevColumnMerge",
            "data": {
              "body": "> 행 병합(위아래로 병합)시 각 열의 좌측 열의 병합 된 범위를 기준으로 병합하는 기능입니다. > (cfg)[DataMerge](/docs/props/cfg/data-merge)와 (cfg)[HeaderMerge](/docs/props/cfg/header-merge) 옵션이 설정되어 있어야 정상적으로 동작합니다. > 시트 생성 후 [setAutoMerge](/docs/funcs/core/set-auto-merge)메소드를 이용하여 병합을 동적으로 변경할 수 있습니다. > **<mark>주의</mark> : 소계([makeSubTotal (method)](/docs/funcs/core/make-sub-total))사용 시 해당 옵션에 설정한 값은 무시되고 `PrevColumnMerge : 1` 로 동작합니다.** ### ![prevColumnMerge](/assets/imgs/prevColumnMerge_base.png \"prevColumnMerge\") (col)[ColMerge](/docs/props/col/col-merge)값이 0인 컬럼은 탐색범위에서 제외됩니다.(좌측 컬럼이 ColMerge:0인 경우, 해당컬럼을 건너뛰고 좌측 컬럼을 기준으로 병합합니다) ![prevColumnMerge](/assets/imgs/prevColumnMerge_colMerge.png \"prevColumnMerge\") ### Type `number` ### Options |Value|Description| |-----|-----| |`0`| 전체영역에 앞컬럼 머지기능을 사용안함 (`default`)| |`1`| 데이터 영역에만 앞컬럼머지기능을 사용| |`2`| 헤더 영역에서만 앞컬럼머지기능을 사용| |`3`| 데이터 및 헤더 영역에서 앞컬럼머지 기능 사용| ### Example ```javascript options = { Cfg: { PrevColumnMerge: 1, // 시트 생성 시 앞 열 기준으로 셀 병합할지 여부를 설정합니다. ... } }; ``` ### Try it - [0 by default with setAutoMerge](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/Merge/)",
              "see": [
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/header-merge"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "ColMerge col",
                  "url": "/docs/props/col/col-merge"
                },
                {
                  "label": "setAutoMerge method",
                  "url": "/docs/funcs/core/set-auto-merge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/prev-column-merge.html"
          },
          {
            "cid": 151,
            "sid": "range-enum-icon-left",
            "name": "range-enum-icon-left",
            "label": "RangeEnumIconLeft",
            "data": {
              "body": "> `Enum` 타입에 [Range](/docs/props/col/range) 속성 사용시 메뉴의 체크 박스 아이콘을 왼쪽에 위치시킬지 여부를 설정합니다 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`| `Enum` 타입의 체크 박스를 오른쪽에 위치 (`default`)| |`1(true)`| `Enum` 타입의 체크 박스를 왼쪽에 위치| ### Example ```javascript options.Cfg = { RangeEnumIconLeft : true }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.8|기능 추가|"
            },
            "url": "docs/props/cfg/range-enum-icon-left.html"
          },
          {
            "cid": 152,
            "sid": "remove-custom-format-delimiter",
            "name": "remove-custom-format-delimiter",
            "label": "RemoveCustomFormatDelimiter",
            "data": {
              "body": "> 데이터 로드시 설정된 CustomFormat 과 동일한 포멧일시 구분자를 제거하는 기능을 추가합니다. > 동일한 CustomFormat 이 제대로 적용되도록 하기 위해 원본데이터를 구분자를 제거한 데이터로 치환합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|구분자를 제거하지 않음 (`default`)| |`1(true)`|설정된 CustomFormat 과 동일한 포멧일시 구분자를 제거| ### Example ```javascript options.Cfg = { RemoveCustomFormatDelimiter: true // 웹 접근성 모드 사용 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.24|기능 추가|"
            },
            "url": "docs/props/cfg/remove-custom-format-delimiter.html"
          },
          {
            "cid": 153,
            "sid": "remove-sep-req-value",
            "name": "remove-sep-req-value",
            "label": "RemoveSepReqValue",
            "data": {
              "body": "> `getSaveJson, getSaveString, doSave` 와 같은 서버로 데이터를 보내는 경우, 데이터와 `CustomFormat` 의 형태가 일치할시 `CustomFormat` 의 구분자를 제거해서 서버로 보내는 기능입니다. > 해당 기능의 경우, 사용자가 직접 커스터마이징한 포멧은 사용할 수 없고 시트에서 제공하는 6가지 포멧의 형태만 지원합니다. `[\"IdNo\", \"IdNoMask\", \"PostNo\", \"SaupNo\", \"CardNo\", \"PhoneNo\"]` ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|원본 데이터 그대로 보냄. (`default`)| |`1(true)`|데이터와 `CustomFormat` 의 형태가 일치할시, 데이터의 구분자를 제거하여 서버로 보냄.| ### Example ```javascript options.Cfg = { \"RemoveSepReqValue\": true }; ``` ```javascript Cols = [ { ... CustomFormat: \"IdNo\" Name: \"idnoformat\" ... }, { ... CustomFormat: \"######-#######\", Name: \"userformat\" ... } ]; data = [ { idnoformat: \"123456-1234567\", userformat: \"123456-1234567\" } ]; var saveStr = sheet.getSaveJson(0); console.log(saveStr); /* idnoformat: \"1234561234567\", // IdNo 형식에 맞아 해당 구분자를 제거하고 데이터를 보냄. userformat: \"123456-1234567\" // 유저가 직접 만든 포멧은 적용되지 않고 원본 데이터를 그대로 보냄. */ ```",
              "see": [
                {
                  "label": "CustomFormat col",
                  "url": "/docs/props/col/custom-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.19|기능 추가|"
            },
            "url": "docs/props/cfg/remove-sep-req-value.html"
          },
          {
            "cid": 154,
            "sid": "req-status-name",
            "name": "req-status-name",
            "label": "ReqStatusName",
            "data": {
              "body": "> 저장 함수([doSave](/docs/funcs/core/do-save), [getSaveString](/docs/funcs/core/get-save-string), [getSaveJson](/docs/funcs/core/get-save-json)) 호출시 각 행의 상태(`Added`, `Changed`, `Deleted`)에 대해서 전달하는 변수 명을 설정합니다. > 별도의 설정이 없는 경우에는 `\"STATUS\"`로 전달 됩니다. > 서버로 전달할 상태값은 `local/언어.js` 파일 안에 문자열(`\"ReqStatusAdded\": \"Added\"`\\(I\\), `\"ReqStatusChanged\": \"Changed\"`\\(U\\), `\"ReqStatusDeleted\": \"Deleted\"`\\(D\\), `\"ReqStatusEmpty\": \"\"`\\(R\\))을 수정하면 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|서버로 전송될 상태 명 (`default: STATUS`)| ### Example ```javascript options.Cfg = { \"ReqStatusName\": \"mySheet_st\" }; ``` //실제 서버로 전송시 다음과 같이 전달 됩니다. ```javascript var saveStr = sheet.getSaveString(); //saveStr //mySheet_st=Changed&ColName1=chris&ColName2=43 ... ```",
              "see": [
                {
                  "label": "doSave method",
                  "url": "/docs/funcs/core/do-save"
                },
                {
                  "label": "getSaveString method",
                  "url": "/docs/funcs/core/get-save-string"
                },
                {
                  "label": "getSaveJson method",
                  "url": "/docs/funcs/core/get-save-json"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/req-status-name.html"
          },
          {
            "cid": 155,
            "sid": "required-image",
            "name": "required-image",
            "label": "RequiredImage",
            "data": {
              "body": "> 필수 입력 항목 이미지를 기본 이미지와 다르게 바꾸고 싶은 경우, 필수 입력 항목에 대한 표시 이미지 경로를 설정 합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|필수 입력 항목 이미지 경로| ### Example ```javascript options = { Cfg:{ RequiredImage: \"./required.png\", // 필수 입력 항목 이미지 경로를 설정 }, }; ```",
              "see": [
                {
                  "label": "Required col",
                  "url": "/docs/props/col/required"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.23|기능 추가|"
            },
            "url": "docs/props/cfg/required-image.html"
          },
          {
            "cid": 156,
            "sid": "required-position",
            "name": "required-position",
            "label": "RequiredPosition",
            "data": {
              "body": "> [Required](/docs/props/col/required)가 보여질 위치를 설정합니다. ### Type String ### Options |Value|Description| |-----|-----| |`Left`|헤더의 왼쪽에 `Required` 표시를 합니다. (`default`) ![option1](/assets/imgs/required1.png \"option1\")| |`Right`|헤더의 오른쪽에 `Required` 표시를 합니다 ![option2](/assets/imgs/required2.png \"option2\")| |`None`|헤더에 `Required` 마크를 표시하지 않습니다 | ### Example ```javascript options = { Cfg:{ RequiredPosition: \"Right\", // 헤더의 오른쪽에 Required를 설정 }, Cols : [ {Type: \"Text\", Name: \"sName\", Required: 1 ...}, {Type: \"Int\", Name: \"ssalary\",Width: 70 ...}, ... ]; }; ```",
              "see": [
                {
                  "label": "Required col",
                  "url": "/docs/props/col/required"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.2.0.13|`None` 옵션 추가|"
            },
            "url": "docs/props/cfg/required-position.html"
          },
          {
            "cid": 157,
            "sid": "right-width",
            "name": "right-width",
            "label": "RightWidth",
            "data": {
              "body": "> 오른쪽 고정 열 섹션의 최대 너비를 설정합니다. > 오른쪽 열 섹션의 열들이 설정된 너비보다 큰 경우 스크롤바가 생성됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|오른쪽 섹션의 총 너비| ### Example ```javascript options = { RightCols:[ { //열 헤더 설정 Header: { Value: \"No\" // 헤더행의 SEQ 열에 해당하는 셀에 표시될 title 값 }, Name: \"SEQ\", // 행의 순서를 보여주는 열으로, 자동으로 순번이 시트에서 생성됩니다. }, { // 열 헤더 설정 Header: { Value: \"회사명3\" // 헤더행의 sCorp 열에 해당하는 셀에 표시될 title 값 }, Name: \"sCorp\", // colName 열이름을 설정 (Data와 Matching) Type: \"Text\" // 열 타입 } ], Cfg :{ RightWidth:200, // 오른쪽 열 섹션의 최대 너비 설정 } }; ```",
              "see": [
                {
                  "label": "MidWidth cfg",
                  "url": "./mid-width"
                },
                {
                  "label": "LeftWidth cfg",
                  "url": "./left-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/right-width.html"
          },
          {
            "cid": 158,
            "sid": "row-index",
            "name": "row-index",
            "label": "RowIndex",
            "data": {
              "body": "> `SEQ`의 기능을 대신할 컬럼명을 변경할 수 있습니다. 해당 기능에 컬럼명을 넣어주면, `SEQ`기능을 해당 컬럼에서 대신 사용할 수 있습니다. ### Type `string` ### Example ```javascript options.Cfg = { RowIndex: \"AAA\" // SEQ의 기능을 대신할 컬럼명 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.10|기능 추가|"
            },
            "url": "docs/props/cfg/row-index.html"
          },
          {
            "cid": 159,
            "sid": "save-html-char",
            "name": "save-html-char",
            "label": "SaveHTMLChar",
            "data": {
              "body": "> `doSave (queryMode: 0)` 저장시 `<, >, &`가 `NameCode`로 변환되지 않고 그대로 저장됩니다. > **해당 옵션 사용시 xss (Cross-Site Scripting) 문제가 발생할 수 있으므로 사용에 주의 바랍니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| | `0(false)` | `<, >, &`가 각각 `&lt;`, `&gt;`, `&amp;`로 변환되어 전송 됨 (`default`)| | `1(true)` | `<, >, &` 문자 그대로 전송됨| ### Example ```javascript options.Cfg = { SaveHTMLChar: 1 // <, >, & 그대로 서버 전송 }; sheet.doSave({url}) ```",
              "see": [
                {
                  "label": "doSave method",
                  "url": "/docs/funcs/core/do-save"
                },
                {
                  "label": "UnescapeHTML col",
                  "url": "/docs/props/col/unescape-html"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.22|기능 추가|"
            },
            "url": "docs/props/cfg/save-html-char.html"
          },
          {
            "cid": 160,
            "sid": "scale",
            "name": "scale",
            "label": "Scale",
            "data": {
              "body": "> 주어진 배율(zoom factor)에 따라 시트 전체를 확대하거나 축소합니다. > 1.0보다 작은 값은 시트를 축소합니다. (0.1 미만으로 사용하실 수 없습니다.) > 1.0보다 큰 값은 시트를 확대합니다. > **<mark>주의</mark> : 해당 속성은 `Menu`, `Dialog`, `Message`에는 영향을 주지 않습니다.** > **<mark>주의</mark> : 시트 div의 너비나 높이를 100%와 같이 비율로 설정하여 사용하시는 경우 `NoVScroll`이나 `NoHScroll`을 같이 사용하실 때, 설정하신 배율에 따라 시트의 영역 전체가 확대/축소 될 수 있습니다.** ### Type `number` ### Options |Value|Description| |-----|-----| |number|시트의 배율 설정 (`default: 1.0`)| ### Example ```javascript options.Cfg = { Scale: 0.5 // 시트를 0.5배로 출력합니다다. }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.11|기능 추가|"
            },
            "url": "docs/props/cfg/scale.html"
          },
          {
            "cid": 161,
            "sid": "scroll-left",
            "name": "scroll-left",
            "label": "ScrollLeft",
            "data": {
              "body": "> 중앙 열 섹션 (일반적인 Cols 영역) 의 가로 스크롤이 생성되는 시트에서 > 가로 스크롤의 스크롤바 위치를 좌측 기준으로 얼마만큼 이동하여 보여줄지를 설정합니다. (`단위: pixel`) > 스크롤 위치값을 0 이상으로 설정하는 경우 가로 스크롤 바가 이동하여 해당 위치의 데이터가 보여집니다. ### Type `number` ### Options |Value|Description| |-----|-----| |number|세로 스크롤의 위치 (`단위: pixel`) (`default: 0`)| ### Example ```javascript options.Cfg = { ScrollLeft: 50 // 세로 스크롤의 시작점에서 스크롤바가 50px 이동하여 해당 위치의 데이터를 보여줌. }; ```",
              "see": [
                {
                  "label": "ScrollTop cfg",
                  "url": "./scroll-top"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/scroll-left.html"
          },
          {
            "cid": 162,
            "sid": "scroll-over-sheet",
            "name": "scroll-over-sheet",
            "label": "ScrollOverSheet",
            "data": {
              "body": "> 시트와 브라우저에서 세로 스크롤이 있을 때 시트에서 스크롤이 끝난 후, 상위 부모의 스크롤이 동작하도록 하는 기능 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|세로 스크롤이 끝난 후, 상위 부모의 스크롤이 동작합니다.| ### Example ```javascript // 시트의 스크롤이 끝난 후, 부모의 스크롤이 동작하도록 기능 사용 options.Cfg = { ScrollOverSheet: true }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.18|기능 추가|"
            },
            "url": "docs/props/cfg/scroll-over-sheet.html"
          },
          {
            "cid": 163,
            "sid": "scroll-paging-server-sort",
            "name": "scroll-paging-server-sort",
            "label": "ScrollPagingServerSort",
            "data": {
              "body": "> 스크롤 페이징 사용 시([SearchMode](./search-mode): 3)을 사용하며 서버 소팅을 사용하고 싶은 경우 설정하는 옵션입니다. 설정시, 소팅할 때 소팅 정보를 서버에 보내고, 결과를 조회합니다. ### Type `boolean` ### Options |Value|Description| |---|---| |`0(false)`|Sort 정보를 서버에 보내지 않고, 현재 보여지는 페이지에 대해서만 정렬합니다. (`default`)| |`1(true)`|Sort 정보를 서버에 보내고, 결과를 조회합니다.| ### Example ```javascript options.Cfg = { ScrollPagingServerSort: true // 소팅시 소팅 정보를 서버에 보내고, 결과를 조회합니다. }; ```",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "./search-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.6|기능 추가|"
            },
            "url": "docs/props/cfg/scroll-paging-server-sort.html"
          },
          {
            "cid": 164,
            "sid": "scroll-top",
            "name": "scroll-top",
            "label": "ScrollTop",
            "data": {
              "body": "> 시트의 세로 스크롤바 위치를 설정합니다. (단위: `pixel`) > 스크롤바의 위치값을 0 이상으로 설정하는 경우 이동된 스크롤 바 위치의 데이터가 보여집니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|세로 스크롤바의 위치 (`단위: pixel`) (`default: 0`)| ### Example ```javascript options.Cfg = { ScrollTop: 100 // 상단 스크롤의 스크롤바 시작점에서 100px 이동하여 해당 위치의 데이터를 보여줌. }; ```",
              "see": [
                {
                  "label": "ScrollLeft cfg",
                  "url": "./scroll-left"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/scroll-top.html"
          },
          {
            "cid": 165,
            "sid": "search-case-sensitive",
            "name": "search-case-sensitive",
            "label": "SearchCaseSensitive",
            "data": {
              "body": "> 검색어가 영문(혹은 대/소문자를 구분하는 언어)에서 대/소문자를 구분해서 검색하도록 설정할 수 있습니다. > 기본값은 `0(false)`입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|검색 시 대/소문자를 구분하지 않습니다.(`defalut`)| |`1(true)`|검색 시 대/소문자를 구분합니다.| ### Example ```javascript options.Cfg = { SearchCaseSensitive: true // 검색 기능 사용시 영문의 대/소문자 구분해서 검색 }; ```",
              "see": [
                {
                  "label": "SearchCount cfg",
                  "url": "./search-count"
                },
                {
                  "label": "SearchExpression cfg",
                  "url": "./search-expression"
                },
                {
                  "label": "findRows method",
                  "url": "/docs/funcs/core/find-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/search-case-sensitive.html"
          },
          {
            "cid": 166,
            "sid": "search-cells",
            "name": "search-cells",
            "label": "SearchCells",
            "data": {
              "body": "> 찾기 행 사용 시 행 단위로 검색할지 셀 단위로 검색할지 여부를 선택할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|행 단위로 검색 (`default`) ex) 찾기 행에 \"가방 영국\" 입력 시 행 내 셀들 중 \"가방\"과 \"영국\"을 포함하는 셀이 하나 이상 있는 경우(한 셀이 \"가방\", 다른 한 셀이 \"영국\"을 가지는 경우도 포함) 해당 행이 검색됨| |`1`|셀 단위로 검색 ex) 찾기 행에 \"가방 영국\" 입력 시 \"가방\"과 \"영국\" 두 개의 단어를 모두 포함하는 셀만 검색됨| ### Example ```javascript options.Cfg = { SearchCells: 0, }; ```",
              "see": [
                {
                  "label": "Solid appendix",
                  "url": "/docs/appx/solid"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/search-cells.html"
          },
          {
            "cid": 167,
            "sid": "search-count",
            "name": "search-count",
            "label": "SearchCount",
            "data": {
              "body": "> `Search` 행 사용시 제공되는 읽기 전용 옵션으로, `선택(Select), 마킹(Mark)` 동작에 의해 표시된 행들의 개수를 반환합니다. > `Search` 행에서 `Filter/Find/FindPrev` 동작을 실행하는 경우 `SearchCount` 옵션은 빈 값으로 변경됩니다. ### Type `number` ### Example ```javascript // Search행 설정할 때 사용 시 options.Solid = [{ Kind: \"Search\", // Kind : 커스텀 행의 Kind를 지정합니다.{가능한 행 종류 : Header, Filter, Search, Group, Space, Data} Space: 1, // Space : 커스텀 Row가 위치할 곳을 설정합니다 {-1: 테이블 상단 영역, 0: Head 영역, 1: Body와 Head 사이, 2: Body와 Foot 사이 빈공간, 3: Foot 바로 위, 4: Foot 아래 툴바위치, 5:하단 테이블 밖} Cells: \"Expression,Sep1,Counts,Filter,Select,Mark,FindPrev,Find,Clear,Sep2\", // 커스텀 행 내에 Cell들을 생성하고 id를 부여함. Defs, Case, Type, Cols, List, Search, Actions, Expression, Filter, Select, Mark, Find, FindPrev, Clear, Help는 내장 설정 예약어 Expression: { // 검색하기 위한 expression 설정 Action: \"Last\", // expression 셀 내용이 변경되었을때 취할 동작에 대한 설정, Last로 설정시 사용자가 직전에 했던 동작을 실행합니다(필터를 이전에 사용했다면 필터를 사용). NoColor: 0, // 셀이 css style의 컬러(Color, Background)를 가질지 여부 CanFocus: 1, Left: \"5\", // 셀 좌측에 지정한 px 만큼의 빈 공간 생성 MinWidth: \"90\", // 최소 너비 px 단위 EmptyValue: \"<s>검색어를 입력해 주세요</s>\" // input의 placeholder 속성과 동일한 기능으로 Value가 없을 경우 지정된 값을 노출합니다 }, Sep1: { Width: \"10\", Type: \"Html\" }, Counts: { Width: \"50\", CanFocus:0, Type: \"html\", Formula: \"(Sheet.SearchCount ? Sheet.SearchCount : (Sheet.FilterCount ? Sheet.FilterCount : count(7))) +'개'\" }, // filter, select 등의 버튼 클릭시 화면에 보이는 행의 개수를 세어 셀 값으로 사용. Filter: { ButtonText: \"필터\" }, Select: { ButtonText: \"선택\" }, Mark: { ButtonText: \"마킹\" }, FindPrev:{ ButtonText: \"(위로)찾기\", Width: \"70\" }, Find: { ButtonText: \"(아래로)찾기\", Width: \"70\" }, Clear: { ButtonText: \"클리어\", Width: \"50\" }, Sep2: { Width: \"5\", Type: \"Html\" } }] ```",
              "see": [
                {
                  "label": "FilterCount cfg",
                  "url": "./filter-count"
                },
                {
                  "label": "SearchCaseSensitive cfg",
                  "url": "./search-case-sensitive"
                },
                {
                  "label": "SearchExpression cfg",
                  "url": "./search-expression"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/search-count.html"
          },
          {
            "cid": 168,
            "sid": "search-expression",
            "name": "search-expression",
            "label": "SearchExpression",
            "data": {
              "body": "> 시트에서 검색할 문자열을 설정합니다. > 구글에서 검색하듯이 일반적인 문자열 및 검색 조건을 사용할 수 있습니다. ### Type `string` ### 검색 조건 |Name| Description | |----------|----| |`'-서울'`| `서울`을 제외하고 검색 | |`'서울 OR 경기'`| `서울`과 `경기`를 검색 | |`'#'`| 셀값이 하나라도 비어있는 데이터 행을 검색 | ### Example ```javascript // 대/소문자를 구분해서 시트에 'Seoul'을 포함한 데이터 행을 검색 sheet.SearchCaseSensitive = true; sheet.SearchExpression = \"Seoul\"; sheet.findRows('Find'); ```",
              "see": [
                {
                  "label": "SearchCount cfg",
                  "url": "./search-count"
                },
                {
                  "label": "SearchCaseSensitive cfg",
                  "url": "./search-case-sensitive"
                },
                {
                  "label": "findRows method",
                  "url": "/docs/funcs/core/find-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/search-expression.html"
          },
          {
            "cid": 169,
            "sid": "search-mode",
            "name": "search-mode",
            "label": "SearchMode",
            "data": {
              "body": "> 시트의 데이터 조회 모드를 설정합니다. ### Type `number` ### Options |Value|Mode|Description| |-----|-----|------| |`0`|**FastLoad 모드 (가상스크롤 처리 방식)**|`IBSheet8`의 FastLoad 모드(SearchMode: 0)는 가상 스크롤 기반으로, 사용자가 세로 스크롤시 보이는 영역의 데이터만 즉시 갱신합니다. 이로 인해 사용자는 스크롤과 동시에 화면의 끊김 없이 행의 데이터를 바로 확인할 수 있습니다. 해당 기능을 사용시 각 행의 높이는 모두 동일해야 하며, [(Appendix)기능에 제약사항](/docs/appx/fastload-constraints)이 있습니다. 데이터행의 높이가 일정하지 않다면 [(Cfg)AutoRowHeight](./auto-row-height)를 설정하시기 바랍니다.| |`1`|**ClientPaging** |전체 데이터를 조회하고 [(Cfg)PageLength](./page-length)속성 설정값만큼 페이징 처리 후 페이지 네비게이션을 통해 보여주는 기능입니다. [(Method)updateClientPaging](/docs/funcs/core/update-client-paging) 함수를 이용해서 동적으로 페이지의 개수를 변경하고 재계산할 수 있습니다. 페이지 네비게이션은 [InfoRowConfig](/docs/props/cfg/info-row-config)에서 사용할 수 있습니다. **<mark>주의</mark> : `(Method) makeSubTotal` 지원하지 않습니다.**| |`2`|**LazyLoad (default)**|전체 데이터를 조회 하고 [(Cfg)PageLength](./page-length)속성 설정값 단위로 스크롤 위치에 따라 데이터를 화면에 표시하는 기능입니다.| |`3`|**ScrollAppend**|[(Cfg)PageLength](./page-length)에 지정된 개수만큼 한 페이지씩 조회하여 화면에 표시하는 기능입니다. 조회는 반드시 [(Method)doSearchPaging](/docs/funcs/core/do-search-paging)함수를 통해 수행해야 합니다. 사용자가 세로 스크롤을 하단까지 내릴 경우, [(Method)doSearchPaging](/docs/funcs/core/do-search-paging)에서 호출한 URL을 다시 요청하여 다음 페이지 데이터를 기존 데이터 아래 추가(Append) 합니다. 서버는 시트로 부터 넘어오는 페이지 정보(ibpage=2,3,4...)에 따라 페이징 쿼리를 구성하여 각 페이지별 데이터를 리턴해야 합니다. 조회 데이터에 **Total**(전체 record 수) 속성이 포함되어 있어야 합니다. **Total**값과 누적 데이터 수가 같아지면 더 이상 서버 호출은 발생하지 않습니다. 한번 조회한 페이지는 재요청없이 재사용 됩니다. `Sort`, `Filter`, `엑셀 다운로드` 등은 조회한 데이터 안에서만 동작 합니다. **<mark>주의</mark>** : `Type:Lines, Img`나 `Wrap:1` 과 같이 데이터 행의 높이가 일정하지 않은 속성은 사용할 수 없습니다. `(Col) FormulaRow` 사용 할 수 없습니다. `(Method) makeSubTotal` 지원하지 않습니다. PageLength 값과 서버에서 받아오는 데이터의 갯수를 반드시 동일하게 설정해야 합니다.**| |`4`|**ServerPaging**|[(Cfg)PageLength](./page-length)에 지정된 개수만큼 한 페이지씩 조회하여 화면에 표시하는 기능입니다. 조회는 반드시 [(Method)doSearchPaging](/docs/funcs/core/do-search-paging)함수를 통해 수행해야 합니다. [InfoRowConfig](/docs/props/cfg/info-row-config)를 사용해 페이지 네비게이션 UI를 표시할 수 있습니다. 페이지 번호 변경시 [(Method)doSearchPaging](/docs/funcs/core/do-search-paging)이 호출한 URL을 다시 요청하여 해당 페이지 데이터를 표시합니다. 서버는 시트로 부터 넘어오는 페이지 정보(ibpage=2,3,4...)에 따라 페이징 쿼리를 구성하여 각 페이지별 데이터를 리턴해야 합니다. 조회 데이터에 **Total**(전체 record 수) 속성이 포함되어 있어야 합니다. 한번 조회한 페이지는 서버를 다시 호출하지 않습니다. `Filter`, `엑셀 다운로드` 등은 조회한 데이터 안에서만 동작 합니다. `Sort`는 [SortCurrentPage](./sort-current-page)에 의해서 동작합니다. **<mark>주의</mark> : `(Col) FormulaRow` 사용 할 수 없습니다. `(Method) makeSubTotal` 지원하지 않습니다. PageLength 값과 서버에서 받아오는 데이터의 갯수를 반드시 동일하게 설정해야 합니다.** |`5`|**ServerPaging2**| 동작 방식은 `ServerPaging`과 동일하지만, 페이지 이동시 항상 서버를 호출하여 데이터를 조회하는 기능입니다. `Filter`, `엑셀 다운로드` 등은 PageLength 만큼 동작 합니다. `Sort`는 [SortCurrentPage](./sort-current-page)에 의해서 동작합니다. [(Method)updatePageLength](/docs/funcs/core/update-page-length) 를 통해 동적으로 페이지 행의 개수를 변경하실 수 있습니다. **<mark>주의</mark> : `(Col) FormulaRow` 사용 할 수 없습니다. `(Method) makeSubTotal` 지원하지 않습니다. PageLength 값과 서버에서 받아오는 데이터의 갯수를 반드시 동일하게 설정해야 합니다.**|</br> ### Example ```javascript options.Cfg = {SearchMode: 0, ...}; ```",
              "see": [
                {
                  "label": "AutoRowHeight cfg",
                  "url": "./auto-row-height"
                },
                {
                  "label": "InfoRowConfig cfg",
                  "url": "./info-row-config"
                },
                {
                  "label": "PageLength cfg",
                  "url": "./page-length"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "/docs/funcs/core/do-search-paging"
                },
                {
                  "label": "updateClientPaging method",
                  "url": "/docs/funcs/core/update-client-paging"
                },
                {
                  "label": "updatePageLength method",
                  "url": "/docs/funcs/core/update-page-length"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.54|`ServerPaging2` 추가|"
            },
            "url": "docs/props/cfg/search-mode.html"
          },
          {
            "cid": 170,
            "sid": "search-progress",
            "name": "search-progress",
            "label": "SearchProgress",
            "data": {
              "body": "> 데이터 조회(`doSearch, loadSearchData`) 사용시 내부에서 일어나는 작업 과정 (`\"API 호출 및 응답대기\", \"데이터 파싱\", \"렌더링 시작\", \"렌더링 완료\"`)을 순차적으로, 프로그래스바 형태로 보여줍니다. > 프로그레스바가 비동기형태로 동작하기 때문에 실제 시트에 로딩되는 속도와는 약간 차이가 있을 수 있습니다. > 조회시에 `SuppressMessage`를 낮추어 다른 조회 메세지를 사용시에는 해당 프로그레스바와 충돌이 일어날 수 있음으로, `SuppressMessage`를 3, 4 사용을 권장합니다. > 조회 중에 오류 발생시, 해당 프로그래스바에서 어떤 과정에서 오류가 났는지 확인할 수 있습니다. ### 프로그레스바 구조 ![프로그래스바](../../../assets/imgs/showProgress.png) 프로그래스바에 표시되는 Text는 메세지 파일(ko.js 등)의 `SearchProgressMessage`, `DataSearchingMessage` 값입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|데이터 조회 시 프로그래스바 미사용 (`defalut`)| |`1(true)`|데이터 조회 시 프로그래스바 사용| ### Example ```javascript options.Cfg = { SearchProgress: true }; ```",
              "see": [
                {
                  "label": "SuppressMessage cfg",
                  "url": "./suppress-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.14|기능 추가|"
            },
            "url": "docs/props/cfg/search-progress.html"
          },
          {
            "cid": 171,
            "sid": "section-can-resize",
            "name": "section-can-resize",
            "label": "SectionCanResize",
            "data": {
              "body": "> 사용자가 섹션 사이를 드래그하여 섹션 너비를 조정할 수 있게 할 것인지 여부를 설정합니다. > 해당 옵션을 설정하면 섹션과 섹션 사이에 Splitter 영역이 생성됩니다.<br /> > 왼쪽 고정 열 섹션(`LeftCols`) 과 오른쪽 고정 열 섹션(`RightCols`) 이 설정되어 있고, 각 섹션 별로 가로 스크롤이 생기는 경우에 각 섹션 너비 조절 기능이 동작합니다. > 섹션 너비 조절이 가능해지면 Splitter 영역에 마우스 호버시 마우스 포인터 모양이 변경되며, 너비 변경 시 Cfg에서 설정한 [LeftWidth](./left-width)와 [MidWidth](./mid-width), [RightWidth](./right-width)는 자동 조절됩니다. ### ![너비조정](/assets/imgs/section3.png) ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|너비 조정 안됨 (`default`)| |`1`|왼쪽, 중앙, 오른쪽 중 섹션에 스크롤바가 있는 경우 항상 조절 가능| ### Example ```javascript options = { Cfg :{ SectionCanResize: 1 // 왼쪽, 중앙, 오른쪽 섹션 너비 조정 허용 }, LeftCols:[ { //열 헤더 설정 Header: { Value: \"No\" // 헤더행의 SEQ 열에 해당하는 셀에 표시될 title 값 }, Name: \"SEQ\", // 행의 순서를 보여주는 열으로, 자동으로 순번이 시트에서 생성됩니다. } ], Cols:[ { Header: { Value: \"금년매출\" }, Name: \"sYear\", Type: \"Int\", Format: \"#,##0\" }, ... ], RightCols:[ { Header: { Value: \"회사명\" }, Name: \"sCompany\", Type: \"Text\", }, ... ] }; ```",
              "see": [
                {
                  "label": "LeftWidth cfg",
                  "url": "./left-width"
                },
                {
                  "label": "MidWidth cfg",
                  "url": "./mid-width"
                },
                {
                  "label": "RightWidth cfg",
                  "url": "./right-width"
                },
                {
                  "label": "setFixedCols method",
                  "url": "/docs/funcs/core/set-fixed-cols"
                },
                {
                  "label": "setFixedLeft method",
                  "url": "/docs/funcs/core/set-fixed-left"
                },
                {
                  "label": "setFixedRight method",
                  "url": "/docs/funcs/core/set-fixed-right"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/section-can-resize.html"
          },
          {
            "cid": 172,
            "sid": "sel-focus-color",
            "name": "sel-focus-color",
            "label": "SelFocusColor",
            "data": {
              "body": "> 시트 포커스 혹은 영역 선택시 헤더행과 SEQ 컬럼행의 배경색이 변경됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|기능 사용 안함 (`default`)| |`1`|헤더행과 SEQ 컬럼행의 배경색 변경 적용| ### Example ```javascript options.Cfg = { SelFocusColor : 1 // 헤더행과 SEQ 컬럼행의 배경색이 변경 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.92|기능 추가|"
            },
            "url": "docs/props/cfg/sel-focus-color.html"
          },
          {
            "cid": 173,
            "sid": "select-mode",
            "name": "select-mode",
            "label": "SelectMode",
            "data": {
              "body": "> 마우스 조작으로 셀 또는 행을 선택 시 동작을 변경합니다. > `SelectMode: 1, 2`에서 shift + 드래그 시 기존에 선택된 영역들은 선택이 해제됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`| ctrl + 클릭, 마우스드래그 선택으로 포커스가 변경되지 않습니다. (default) 새로운 선택 영역 중 이미 선택된 셀이 포함된 경우 기존에 선택된 셀과 새로운 영역의 선택이 해제됩니다. | |`1`| ctrl + 클릭, 마우스 드래그 선택으로 포커스가 변경됩니다. shift + 클릭으로 선택 시 기존의 선택을 취소하고 새롭게 선택된 영역을 유지합니다.| |`2`| ctrl + 클릭, 마우스 드래그 선택으로 포커스가 변경됩니다. shift + 클릭으로 선택 시 기존의 선택과 새롭게 선택된 영역을 유지합니다.| ### Example ```javascript options.Cfg = { SelectMode: 1 }; ``` ### Since |product|version|desc| |---|---|---| |core|8.3.0.28|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|8.3.0.28|기능 추가|"
            },
            "url": "docs/props/cfg/select-mode.html"
          },
          {
            "cid": 174,
            "sid": "selecting-cells",
            "name": "selecting-cells",
            "label": "SelectingCells",
            "data": {
              "body": "> 개별적인 셀 선택 혹은 셀 범위 선택이 가능한지 여부와 셀 선택시 행와 열 선택에 주는 영향에 대해 설정 합니다. > 옵션을 `1` 이상으로 설정하는 경우 **Row, Col, Cell** 별 `Selected` 속성값의 영향을 받습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|개별 셀 선택 불가. 행 단위로만 선택만 가능| |`1`|셀,행/열단위로 선택 가능 (`default`) Row 내의 선택된 셀이 없을때, Row의 `Selected = 0` 를 가짐 Row 내의 모든 셀이 선택된 경우, Row의 `Selected = 1` 를 가짐 Row 내의 일부 셀만 선택된 경우, Row 의 `Selected = 2` 를 가짐. 단, 개별 셀의 `Selected = 1` 로 설정해야 함 | |`2`|개별 셀만 선택 가능. Row 내의 모든 셀이 선택된 경우, Row의 `Selected = 1` 를 가지지 않음. Row 내의 선택된 셀이 없을때, Row의 `Selected = 0` 를 가짐 Row 내의 일부 셀만 선택된 경우, Row 의 `Selected = 2` 를 가짐. 단, 개별 셀의 `Selected = 1` 로 설정해야 함 | |`3`|개별 셀과 행/열선택이 상관 없이 독립적으로 선택 가능 Row 내 선택 셀이 없고, Row 도 선택 안된 경우. Row 의 `Selected = 0` Row 내 선택 셀이 없고, Row가 선택된 경우. Row 의 `Selected = 1` Row 내 일부 셀이 선택되고, Row가 선택 안된 경우. Row 의 `Selected = 2`. 단, 개별 셀의 `Selected = 1` 로 설정해야 함 Row 내 일부 셀이나 전체 셀이 선택되고, Row가 선택된 경우. Row 의 `Selected = 3`| |`4`|`SEQ` 컬럼을 선택할 경우에는 `SelectingCells:0`으로 동작. 그 외 컬럼을 선택할 경우에는 `SelectingCells:1`로 동작.| ### Example ```javascript options.Cfg = { SelectingCells: 0, // 개별 셀 선택 불가능 ... }; ```",
              "see": [
                {
                  "label": "CanSelect cfg",
                  "url": "./can-select"
                },
                {
                  "label": "Selected row",
                  "url": "/docs/props/row/selected"
                },
                {
                  "label": "Selected col",
                  "url": "/docs/props/col/selected"
                },
                {
                  "label": "Selected cell",
                  "url": "/docs/props/cell/selected"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/selecting-cells.html"
          },
          {
            "cid": 175,
            "sid": "selection-summary",
            "name": "selection-summary",
            "label": "SelectionSummary",
            "data": {
              "body": "> 드레그(혹은 키보드)를 통해 선택한 영역의 셀 개수 및 합계/평균 값을 보여주는 기준을 설정합니다. > 합계 정보가 표시될 위치는 [InfoRowConfig](/docs/props/cfg/info-row-config) 속성에 `Layout:[\"SummaryLabel\"]`를 설정하셔야 합니다. > **<mark>주의</mark> : 해당 기능은 MultiRecord 구조 시트에서는 사용할 수 없습니다.** > `EmptyCell`을 설정하지 않으면 해당 셀에 **값이 없는 경우** 선택 셀의 개수나 평균 계산에서 무시됩니다. > 단 주의하실 점은 여기서 **값이 없다**는 의미는 조회시 해당 셀에 대한 데이터가 없는 것을 의미, 조회된 데이터를 지우거나 0을 입력시에는 모두 계산에 포함됩니다. ### Type `object` ### Options |Value|Type|Description| |----------|-----|---| |`Mode`|`string`|빈 셀을 계산에 포함할지 여부(`EmptyCell`), 삭제행을 계산에 포함할지 여부(`DelRow`), 인접하지 않은 모든 선택 영역을 계산할지 여부(`AllRange`)를 구분자 \"\\|\"로 연결하여 설정 (ex: \"Mode\":\"EmptyCell\\|DelRow\\|AllRange\") 기본값은 `\"\"`(다 포함하지 않음)| |`Align`|`string`|합계 정보 정렬 (`Left, Center, Right` 중에 하나 설정, 기본값 `Left`)| |`Width`|`number`|합계 정보 영역의 크기 (pixcel단위 숫자, 기본값 `350`)| |`SumFormat`|`string`|합계 값 표현 포맷 설정 (`default: \"#,##0.00\"`)| |`AvgFormat`|`string`|평균 값 표현 포맷 설정 (`default: \"#,##0.00\"`)| ![selectionSummary](/assets/imgs/selectionSummary.png \"selectionSummary\") ### Example ```javascript options.Cfg = { InfoRowConfig: { //합계나 건수정보 Row 표시 \"Visible\": true, \"Layout\": [\"Count\", \"SummaryLabel\"], }, SelectionSummary:{ \"Mode\": \"DelRow\", \"Width\": 500, \"SumFormat\": \"#,##0\", \"AvgFormat\": \"#,##0.##\" } }; ```",
              "see": [
                {
                  "label": "InfoRowConfig cfg",
                  "url": "/docs/props/cfg/info-row-config"
                },
                {
                  "label": "setInfoRow method",
                  "url": "/docs/funcs/core/set-info-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.13|Mode `AllRange` 기능 추가||core|8.0.0.26|`SumFormat`, `AvgFormat` 기능 추가|"
            },
            "url": "docs/props/cfg/selection-summary.html"
          },
          {
            "cid": 176,
            "sid": "sheet-paste",
            "name": "sheet-paste",
            "label": "SheetPaste",
            "data": {
              "body": "> `IE` 전용 기능입니다. 설정시 복사기능 이용시 권한프롬프트가 나오지 않습니다. > 기본값은 `0(false)`이고 IE에서는 복사기능 사용시 `execCommand('copy')` 기능을 사용하고 있습니다. > `1(true)` 값을 사용할시 시트내부복사 기능을 사용합니다. > 단, `execCommand('copy')` 를 사용하면서 권한프롬프트를 끄고 싶다면 인터넷 옵션에서 보안에 들어가 권한을 허용하시면 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|execCommand('copy') 를 사용합니다. (권한 프롬프트) (`default`)| |`1(true)`|시트 내부 복사 기능을 이용합니다. (권한 프롬프트x)| ### Example ``` options.Cfg = { SheetPaste: true // 시트 내부복사 기능을 사용합니다. }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/props/cfg/sheet-paste.html"
          },
          {
            "cid": 177,
            "sid": "shift-hint",
            "name": "shift-hint",
            "label": "ShiftHint",
            "data": {
              "body": "> 셀 크기보다 셀 내용이 많을 때 마우스 호버시 셀 데이터를 `Hint` 로 보여줍니다. > 최우측 열의 셀들이 `Hint`로 나타날 때, `Hint` 위치를 왼쪽으로 이동하여 셀 데이터를 모두 표시하게 됩니다. > 이 때, `Hint` 위치를 왼쪽으로 이동시키지 않도록 설정 할 수 있으며, `false` 으로 설정시 `Hint` 로 보여질 데이터의 일부가 잘려서 노출되지 않을 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|`Hint` 생성 기준점에서 공간이 부족하더라도 현재위치에서 표시| |`1(true)`|`Hint` 생성 기준점에서 공간이 부족할 때 왼쪽으로 이동시켜 표시 (`default`)| ### Example ```javascript options.Cfg = { ShiftHint: false, // Hint 공간이 부족하더라도 셀 위에 표시 ... }; ```",
              "see": [
                {
                  "label": "ShowHint row",
                  "url": "/docs/props/row/show-hint"
                },
                {
                  "label": "ShowHint col",
                  "url": "/docs/props/col/show-hint"
                },
                {
                  "label": "ShowHint cell",
                  "url": "/docs/props/cell/show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/shift-hint.html"
          },
          {
            "cid": 178,
            "sid": "show-filter",
            "name": "show-filter",
            "label": "ShowFilter",
            "data": {
              "body": "> 시트 생성시 상단 고정행으로 필터행을 추가할지 여부를 설정합니다 > 필터행을 추가하는 경우 열별 데이터에 대한 필터링 기능을 사용할 수 있습니다. > `(0)false` 으로 설정시 필터행은 생성되지 않으며, 시트 생성 이후에 [showFilterRow](/docs/funcs/core/show-filter-row) 함수를 통해 동적으로 필터행을 생성시킬 수 있습니다. > 아래는 `ShowFilter:true` 를 이용하여 생성한 필터행의 사용 예시 입니다. > 문자열 컬럼에서는 `','(and검색)` 나 `';'(or검색)` 을 사용하실 수 있습니다. > - ex1. `사과;복숭아` ==> 사과나 복숭아 글자를 포함한 행만 남기고 감춤 > - ex2. `사과,복숭아` ==> 사과 복숭아가 함께 있는 행만 남기고 감춤 > 숫자나 날짜 컬럼에 대해서는 `'~'` 를 통해 범위를 설정 할 수 있습니다. 필터행의 기호(연산자) 1(같음), 2(같지않음) 에서만 사용 할 수 있고 다른 기호 에서는 사용 할 수 없습니다. > - ex1. `20170101~20181231` ==> 2017년 1월 1일 부터 2018년 12월 31일 까지만 남기고 모두 감춤 > - ex2. `20241022~20241025;20241031` ==> 2024년 10월 22일 부터 2024년 10월 25일 까지의 데이터와 2024년 10월 31일의 데이터만 남기고 모두 감춤 > - ex3. `199000~488000` ==> 199000 부터 488000 사이의 데이터만 남기고 모두 감춤 > - ex4. ` 99000;199000~488000` ==> 99000의 데이터와 199000 부터 488000 사이의 데이터만 남기고 모두 감춤 > 구분자는 메세지 파일에서 변경 가능합니다. > \"`ValueSeparator`\": \"`;`\" //or 구분자 > \"`ValueSeparatorHtml`\": \"`;`\" //or 구분자 > \"`ValueAndSeparator`\": \"`,`\" //and 구분자 > \"`RangeSeparator`\": \"`~`\" //범위 연산자 > \"`RangeSeparatorHtml`\": \"`~`\" //범위 연산자 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|필터행을 추가하지 않는다. (`default`)| |`1(true)`|필터행을 추가한다.| ### Example ```javascript options = { Cfg :{ ShowFilter: true, // 시트 생성시 필터행도 추가해서 같이 생성한다. } }; ``` ### Try it - [True](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/ShowFilter-true/)",
              "see": [
                {
                  "label": "showFilterRow method",
                  "url": "/docs/funcs/core/show-filter-row"
                },
                {
                  "label": "hideFilterRow method",
                  "url": "/docs/funcs/core/hide-filter-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/show-filter.html"
          },
          {
            "cid": 179,
            "sid": "showImage",
            "name": "showImage",
            "label": "ShowImage",
            "data": {
              "body": "> 편집이 가능한 `Enum`컬럼에서 focus시 아이콘 이미지를 표시하는 기능입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0`|항상 아이콘을 표시 합니다. (`default`)| |`1`|focus시 `Enum` 컬럼의 아이콘을 표시 합니다.| ### Example ```javascript options.Cfg = { ShowImage: 1 // Enum 컬럼의 아이콘을 focus시에만 표시 }; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "/docs/props/col/enum"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.87|기능 추가|"
            },
            "url": "docs/props/cfg/showImage.html"
          },
          {
            "cid": 180,
            "sid": "size",
            "name": "size",
            "label": "Size",
            "data": {
              "body": "> 각 행의 최소 높이 및 아이콘 크기를 설정합니다. > 시트 생성시 기본적인 행의 높이는 `30px` 이며 이보다 줄이려면 `Size` 속성으로 통해 더 작은 디자인을 설정해야 합니다. > 아래의 행 높이는 최소 높이일 뿐 이보다 늘리는 것은 가능합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`Tiny`|최소 행 높이 `20px`| |`Small`|최소 행 높이 `22px`| |`Low`|최소 행 높이 `27px`| |`Normal`|최소 행 높이 `30px` (`default`)| |`High`|최소 행 높이 `42px`| |`Big`|최소 행 높이 `52px`| ### Example ```javascript options = { Cfg:{ Size: \"Small\", //기본보다 작게 설정 }, Def:{ Row:{ Height: 25 //원래 설정(22px)보다 약간 늘림 } } }; ``` ### Try it - [\"Normal\" by default with setSize](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Cfg/Size/)",
              "see": [
                {
                  "label": "Height row",
                  "url": "/docs/props/row/height"
                },
                {
                  "label": "setSize",
                  "url": "/docs/funcs/core/set-size"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.1|기능 추가|"
            },
            "url": "docs/props/cfg/size.html"
          },
          {
            "cid": 181,
            "sid": "sort-current-page",
            "name": "sort-current-page",
            "label": "SortCurrentPage",
            "data": {
              "body": "> 서버 페이징 사용 시([SearchMode](./search-mode): 4, 5) 현재 보여지는 페이지에 대해서만 정렬할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |---|---| |`0(false)`|Sort 정보를 서버에 보내고, 결과를 조회합니다. (`default`)| |`1(true)`|Sort 정보를 서버에 보내지 않고, 현재 보여지는 페이지에 대해서만 정렬합니다.| ### Example ```javascript options.Cfg = { SortCurrentPage: true }; ```",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "./search-mode"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "/docs/funcs/core/do-search-paging"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/sort-current-page.html"
          },
          {
            "cid": 182,
            "sid": "sort-icons-num",
            "name": "sort-icons-num",
            "label": "SortIconsNum",
            "data": {
              "body": "> 다중 컬럼 소팅시 소팅 적용 순위를 소팅 아이콘 우측에 숫자로 표시합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|다중 컬럼 소팅시 소팅 적용 순위를 숫자로 표시하지 않습니다. (`default`)| |`1(true)`|다중 컬럼 소팅시 소팅 적용 순위를 숫자로 표시합니다.| ### Example ```javascript //다중 컬럼 소팅시 소팅 우선순위를 숫자로 표시합니다. options.Cfg = { SortIconsNum: true }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.102|기능 추가|"
            },
            "url": "docs/props/cfg/sort-icons-num.html"
          },
          {
            "cid": 183,
            "sid": "sort-icons",
            "name": "sort-icons",
            "label": "SortIcons",
            "data": {
              "body": "> 정렬 아이콘의 화면에 표시여부 와 정렬 기능 동작 위치를 설정합니다. > 아이콘에 대한 추가 설정 및 정렬 가능 여부는 [SortIcons(Header)](/docs/props/row/sort-icons) 에서 설정할 수 있습니다. > 단, 아이콘 클릭으로 정렬 할 수 있는 옵션 2 또는 3은 `Header.SortIcons:1` 을 설정하여 모든 정렬 아이콘 표시해야 사용할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|sort 아이콘 숨김, 셀 클릭시 오름차순 -> 내림차순 정렬| |`1`|sort 아이콘 표시, 셀 클릭시 오름차순 -> 내림차순 정렬 (`default`)| |`2`|sort 아이콘의 위쪽 클릭시 오름차순, 아래 클릭시 내림차순 정렬| |`3`|셀(sort 아이콘 포함) 위쪽 클릭시 오름차순, 셀 아래쪽 클릭시 내림차순 정렬| ### Example ```javascript options.Cfg = { CanSort: 1, // 정렬 기능 사용 SortIcons: 0 // 정렬 아이콘 표시 안함(셀 클릭으로 정렬 동작) }; ``` **또는** ```javascript options.Cfg = { CanSort: 1, // 정렬 기능 사용 SortIcons: 2 // sort 아이콘 클릭으로만 정렬 동작 }; options.Header = { SortIcons: 0, // 아이콘이 모두 숨겨지고 정렬 불가 SortIcons: 1, // 모든 정렬 아이콘 표시(정렬되기 전에는 .IBSort0Right 이미지가 표시) SortIcons: 2 // 정렬한 열에만 아이콘이 표시됨. }; ```",
              "see": [
                {
                  "label": "CanSort cfg",
                  "url": "./can-sort"
                },
                {
                  "label": "SortIcons row",
                  "url": "/docs/props/row/sort-icons"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/sort-icons.html"
          },
          {
            "cid": 184,
            "sid": "space-for-default-value",
            "name": "space-for-default-value",
            "label": "SpaceForDefaultValue",
            "data": {
              "body": "> 빈문자(\"\")인 데이터도 [DefaultValue](/docs/props/col/default-value)로 표시되도록 설정합니다. > 해당 속성이 `false`인 경우 [DefaultValue](/docs/props/col/default-value)는 셀에 값이 없는 경우(null, undefined,데이터 없음) 에만 적용됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|`null`, `undefined`, `데이터 없음`인 데이터만 [DefaultValue](/docs/props/col/default-value)로 설정한 값으로 출력 (`default`)| |`1(true)`|빈문자(\"\")인 데이터도 [DefaultValue](/docs/props/col/default-value)로 설정한 값으로 출력| ### Example ```javascript options.Cfg = { SpaceForDefaultValue: true, // 공백(\"\")인 데이터도 \"확인\"으로 표시 }; options.Cols = [ {Header: \"상세정보\", Type: \"Button\", Name: \"DetailBnt\", Button: \"Button\", DefalutValue: \"확인\"}, ... ]; ```",
              "see": [
                {
                  "label": "DefaultValue col",
                  "url": "/docs/props/col/default-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.8|기능 추가|"
            },
            "url": "docs/props/cfg/space-for-default-value.html"
          },
          {
            "cid": 185,
            "sid": "standard-filter",
            "name": "standard-filter",
            "label": "StandardFilter",
            "data": {
              "body": "> 트리에서 필터 기능 사용시 하위 노드에 대한 보임 감춤 여부를 설정합니다.. ### Type `number` ### Options |Value|Description| |-----|-----| |0|부모 행부터 자식행 순으로 검색하여 필터링합니다. (찾고자 하는 값을 자식행만 갖고 있는 경우에는 표시되지 않습니다.)| |1|사용금지 (depreated)| |2|찾고자 하는 값이 자식행에 있는 경우, 해당 행과, 부모 행을 모두 표시 합니다. (`default`)| |3|찾고자 하는 값이 자식행에 있는 경우, 해당 행의 부모 행과 자식을 모두 표시 합니다.| ### Example ```javascript options = { Cfg:{ StandardFilter: 3 // 트리에서 필터기능 사용시 찾은 행의 자식행까지 표시 }, Cols: [...] }; ```",
              "see": [
                {
                  "label": "showFilter method",
                  "url": "/docs/props/cfg/show-filter"
                },
                {
                  "label": "showFilterRow method",
                  "url": "/docs/funcs/core/show-filter-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.47|기능 추가|"
            },
            "url": "docs/props/cfg/standard-filter.html"
          },
          {
            "cid": 186,
            "sid": "standard-tip",
            "name": "standard-tip",
            "label": "StandardTip",
            "data": {
              "body": "> 툴팁을 시트 내장 다이얼로그로 보여줄지, 브라우저의 툴팁으로 보여줄지 설정합니다. > 시트 내장 다이얼로그로 설정한 경우 [TipPosition](/docs/props/col/tip-position), [TipClass](/docs/props/col/tip-class) 들을 적용할 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|시트 내장 다이얼로그로 툴팁 표시 (`default`)| |`1(true)`|표준 브라우저 툴팁으로 표시| ### Example ```javascript options.Cfg = { StandardTip: true }; ```",
              "see": [
                {
                  "label": "TipPosition col",
                  "url": "/docs/props/col/tip-position"
                },
                {
                  "label": "TipClass col",
                  "url": "/docs/props/col/tip-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/standard-tip.html"
          },
          {
            "cid": 187,
            "sid": "static-cursor",
            "name": "static-cursor",
            "label": "StaticCursor",
            "data": {
              "body": "> 시트 이외의 요소를 클릭했을 때 포커스 커서의 유지여부를 설정합니다. > 만약 다른 시트나 시트 이외의 요소를 클릭할 때 현재시트의 선택 색상 및 윤곽선을 없애고자 하는 경우 `0(false)` 으로 설정하면 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|시트 이외의 요소를 클릭할 때 선택된 시트 행 또는 셀의 색상 및 윤곽선 제거. 다른 시트 클릭시 해당 시트로 선택 처리| |`1(true)`|시트 이외의 요소를 클릭하더라도 선택된 시트 행 또는 셀의 색상 및 윤곽선 유지 (`default`) ### Example ```javascript options.Cfg = { StaticCursor: 0 // 포커스를 잃을 때 선택 색상도 제거. }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/static-cursor.html"
          },
          {
            "cid": 188,
            "sid": "storage-compress-mode",
            "name": "storage-compress-mode",
            "label": "StorageCompressMode",
            "data": {
              "body": "> 로컬 스토리지 혹은 세션 스토리지에 현재 시트의 정보가 저장되는 값의 내용을 압축하는 방식에 대한 옵션입니다. > [StorageSession](./storage-session) 값이 없으면 동작하지 않습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|UTF16 압축, 압축률 상| |`1`|Base64 압축, 압축률 중 (`default`)| |`2`|Uint8Array 압축, 압축률 하| ### Example ```javascript options.Cfg = { StorageSession: 1, // 로컬 스토리지에 현재 시트 정보를 저장할 수 있고 가져올 수 있도록 설정 StorageCompressMode: 0 // UTF16 압축으로 로컬 스토리지에 저장 }; sheet.saveCurrentInfo(); // 로컬 스토리지에 현재 시트 정보를 저장 ```",
              "see": [
                {
                  "label": "StorageSession cfg",
                  "url": "./storage-session"
                },
                {
                  "label": "StorageKeyPrefix cfg",
                  "url": "./storage-key-prefix"
                },
                {
                  "label": "saveCurrentInfo method",
                  "url": "/docs/funcs/core/save-current-info"
                },
                {
                  "label": "clearCurrentInfo method",
                  "url": "/docs/funcs/core/clear-current-info"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/storage-compress-mode.html"
          },
          {
            "cid": 189,
            "sid": "storage-key-id",
            "name": "storage-key-id",
            "label": "StorageKeyId",
            "data": {
              "body": "> 로컬 스토리지 혹은 세션 스토리지에 현재 시트의 정보가 저장될 때 시트의 Id를 대신해 Key 값의 `postFix`로 설정할 커스텀 Id를 설정하는 옵션입니다. > 해당 옵션을 설정하시면 Key값이 `StorageKeyPrefix+\"^시트id\"`와 같이 설정되지 않으며, 그 대신 `StorageKeyPrefix+\"^설정값\"`으로 설정됩니다. > [StorageSession](./storage-session) 값이 없으면 동작하지 않습니다. ### Type `string` ### Example ```javascript options.Cfg = { StorageSession: 1, // 로컬 스토리지에 현재 시트 정보를 저장할 수 있고 가져올 수 있도록 설정 StorageKeyId: \"customId\", // `StorageKeyPrefix+\"^customId\"`를 키 값으로 하여 로컬 스토리지에 현재 시트 정보를 저장합니다. }; sheet.saveCurrentInfo(); // 로컬 스토리지에 현재 시트 정보를 저장 sheet.clearCurrentInfo(); // 로컬 스토리지에 현재 시트 정보를 제거 ```",
              "see": [
                {
                  "label": "StorageSession cfg",
                  "url": "./storage-session"
                },
                {
                  "label": "StorageCompressMode cfg",
                  "url": "./storage-compress-mode"
                },
                {
                  "label": "saveCurrentInfo method",
                  "url": "/docs/funcs/core/save-current-info"
                },
                {
                  "label": "clearCurrentInfo method",
                  "url": "/docs/funcs/core/clear-current-info"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.7|기능 추가|"
            },
            "url": "docs/props/cfg/storage-key-id.html"
          },
          {
            "cid": 190,
            "sid": "storage-key-prefix",
            "name": "storage-key-prefix",
            "label": "StorageKeyPrefix",
            "data": {
              "body": "> 로컬 스토리지 혹은 세션 스토리지에 현재 시트의 정보가 저장될 때 사용되는 Key값의 `prefix`를 설정하는 옵션입니다. > 기본적으로 Key값은 `StorageKeyPrefix+\"^시트id\"` 로 설정되고 `StorageKeyPrefix` 옵션에 값이 없을 때 는 현재 페이지의 경로를 `StorageKeyPrefix`의 기본값으로 설정합니다. > [StorageSession](./storage-session) 값이 없으면 동작하지 않습니다. ### Type `string` ### Example ```javascript options.Cfg = { StorageSession: 1, // 로컬 스토리지에 현재 시트 정보를 저장할 수 있고 가져올 수 있도록 설정 StorageKeyPrefix: \"IBSheet/product/intro\" // 스토리지에 저장할 내용의 Key 값의 prefix를 설정 IBSheet/product/intro^sheet 로 설정됨 }; sheet.saveCurrentInfo(); // 로컬 스토리지에 현재 시트 정보를 저장 sheet.clearCurrentInfo(); // 로컬 스토리지에 현재 시트 정보를 제거 ```",
              "see": [
                {
                  "label": "StorageSession cfg",
                  "url": "./storage-session"
                },
                {
                  "label": "StorageCompressMode cfg",
                  "url": "./storage-compress-mode"
                },
                {
                  "label": "saveCurrentInfo method",
                  "url": "/docs/funcs/core/save-current-info"
                },
                {
                  "label": "clearCurrentInfo method",
                  "url": "/docs/funcs/core/clear-current-info"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/storage-key-prefix.html"
          },
          {
            "cid": 191,
            "sid": "storage-session",
            "name": "storage-session",
            "label": "StorageSession",
            "data": {
              "body": "> 시트의 정보를 로컬 스토리지 혹은 세션 스토리지에 저장 시킬 수 있도록 설정하는 옵션입니다. 로컬 스토리지 혹은 세션 스토리지에 저장이 되어 있으면 시트가 로드되는 시점에서 정보를 가져와서 시트에 반영합니다. > **`주의`** : 시트 초기화 시점 컬럼 정보와 저장된 시트 컬럼 정보가 다를 경우 로컬 스토리지 혹은 세션 스토리지에 저장된 정보가 지워집니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|사용안함 (`default`)| |`1`|로컬 스토리지에 저장| |`2`|세션 스토리지에 저장| ### Example ```javascript options.Cfg = { StorageSession: 1 // 로컬 스토리지에 현재 시트 정보를 저장할 수 있고 가져올 수 있도록 설정 }; sheet.saveCurrentInfo(); // 로컬 스토리지에 현재 시트 정보를 저장 sheet.clearCurrentInfo(); // 로컬 스토리지에 현재 시트 정보를 제거 ```",
              "see": [
                {
                  "label": "StorageKeyPrefix Cfg",
                  "url": "./storage-key-prefix"
                },
                {
                  "label": "StorageCompressMode Cfg",
                  "url": "./storage-compress-mode"
                },
                {
                  "label": "saveCurrentInfo method",
                  "url": "/docs/funcs/core/save-current-info"
                },
                {
                  "label": "clearCurrentInfo method",
                  "url": "/docs/funcs/core/clear-current-info"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/storage-session.html"
          },
          {
            "cid": 192,
            "sid": "strict-parse",
            "name": "strict-parse",
            "label": "StrictParse",
            "data": {
              "body": "> 조회 함수에서 JSON 데이터를 파싱할 때 파서를 선택합니다. > 설정을 안하거나 false로 설정시 유연한 파서를 통해 파싱되고, true로 설정시 브라우져가 제공하는 JSON.parse()를 통해 파싱됩니다. 유연한 파서란 일반적인 JSON.parse()를 통해 파싱하는 경우 허용하지 않는 몇가지를 허용합니다. 1. 여분의 콤마 허용 2. 프로퍼티 이름의 쌍따옴표가 없어도 됨. 참고 - [MDN:bad parsing](https://developer.mozilla.org/ko/docs/Web/JavaScript/Reference/Errors/JSON_bad_parse) - JSON.parse()가 유연한 파서보다 성능이 우수(약 5배)하지만 데이터 로딩과정에서 파싱이 차지하는 시간이 크지 않아 5만건 이내에서는 사용자가 느끼기 어려운 수준임. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|유연한 파서 사용 (`default`)| |`1(true)`|브라우저에서 제공하는 JSON.parse() 내장함수 사용| ### Example ```javascript options.Cfg = { StrictParse: 1, // 조회 함수를 JSON.parse()를 통해 데이터 파싱 }; ```",
              "see": [
                {
                  "label": "doSearch method",
                  "url": "/docs/funcs/core/do-search"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "/docs/funcs/core/do-search-paging"
                },
                {
                  "label": "loadSearchData method",
                  "url": "/docs/funcs/core/load-search-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/props/cfg/strict-parse.html"
          },
          {
            "cid": 193,
            "sid": "style-row-config",
            "name": "style-row-config",
            "label": "StyleRowConfig",
            "data": {
              "body": "> 시트 상단 혹은 하단에 별도의 행을 통해 시트의 스타일을 설정 할 수 있습니다. > `StorageType`을 통해 스타일 정보를 저장할 방법을 설정할 수 있습니다. ### Type `object` ### Options |Value|Type|Description| |----------|-----|---| |Visible|`boolean`| 화면 표시 여부 `true`: 표시 `false`: 표시하지 않음 | |StorageType|`number`|스타일 정보를 저장, 사용할 저장소 유형 `0`: 저장 기능 사용하지 않음(`default`) `1`: 로컬 스토리지 ([StorageSession](/docs/props/cfg/storage-session)을 설정해야 동작합니다.) `2`: 스타일 정보를 `ServerUrl`인자로 지정한 주소로 전송| |ServerUrl|`string`|`StorageType`: 2인 경우 스타일 정보를 통신할 주소 스타일을 불러올때는 GET, 스타일 저장할 때는 POST 방식으로 전송됩니다.| |AutoLoad|`boolean`|시트 생성 시 저장된 스타일을 불러올 지 여부 (`default`: true)| |Themes|`object`|스타일 행에 표시할 테마 목록 시트의 기본 테마 css 파일을 불러온 경우 자동적으로 포함됩니다.| |Extend|`boolean`| 처음 랜더링 시 '헤더행', '데이터행' 버튼의 펼쳐짐 여부 (`default`: true)| |Layout|`Array`|스타일 행에 버튼의 순서와 종류를 설정합니다. default: `[\"Init\", \"Save\", \"Load\", \"ApplyAll\"]` `Init`: 시트에 적용된 스타일을 초기화하고, 시트의 id에 해당하는 스타일 정보를 삭제합니다. `Save`: 시트의 id로 스타일 정보를 저장합니다. `Load`: 시트의 id에 해당하는 스타일 정보를 불러옵니다. `ApplyAll`: 동일한 `StorageType`으로 설정된 시트에 스타일을 적용 후 \"IB_Style\"의 id로 정보를 저장합니다. `InitAll`: 동일한 `StorageType`으로 설정된 시트의 스타일을 초기화 후 \"IB_Style\"에 해당하는 정보를 삭제합니다.| ![StyleRowConfig](/assets/imgs/styleRow.png \"StyleRowConfig\") ### Example ```javascript options.Cfg = { StyleRowConfig: { Visible: true, StorageType: 2, ServerUrl: \"./ibsheet/styleInfo.jsp\", AutoLoad: true, Themes: { Mono: \"./assets/ibsheet/css/mono/main.css\", // css 파일 내의 클래스를 key와 일치되도록 수정 필요 IBGY: \"./assets/ibsheet/css/gray/main.css\" } } }; ``` #### 서버 통신 데이터 구조 예시 > 서버와 저장/불러오기 시 주고받는 스타일 정보는 아래와 같은 JSON 구조입니다. ```js { \"AlternateColor\": \"#cfd3d1\", // 데이터 행의 교차 배경색 \"HeaderColor\": \"#b4e0e4\", // 헤더 배경색 \"HeaderTextColor\": \"#000000\", // 헤더 텍스트 색상 \"HeaderTextSize\": \"20\", // 헤더 텍스트 크기(px) \"RowTextSize\": \"14\", // 데이터 행 텍스트 크기(px) \"Theme\": \"IBMT\", // 적용 테마명 \"id\": \"sheet2\" // 시트 고유 ID } ```",
              "see": [
                {
                  "label": "StorageSession cfg",
                  "url": "/docs/props/cfg/storage-session"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.15|기능 추가||core|8.3.0.33|`Layout` 옵션 추가|"
            },
            "url": "docs/props/cfg/style-row-config.html"
          },
          {
            "cid": 194,
            "sid": "style",
            "name": "style",
            "label": "Style",
            "data": {
              "body": "> `기본 테마(/css/default/main.css)`외에 다른 테마를 적용하고자 할때, 사용할 테마에 정의한 `Prefix` 값을 설정합니다. > 해당 기능을 사용하기 위해서는 사용하고자 하는 css 파일이 화면에 `include` 되어 있어야 합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|사용하는 css 파일에 정의한 `Prefix 명`| **기본으로 제공하는 테마** |value|Prefix|Description| |---|---|---| |`default` 폴더|`IB`(`default`)|시트에서 사용하는 이미지를 svg 제공| |`default_img` 폴더|`IB`|시트에서 사용하는 이미지를 png, gif 제공| |`grace` 폴더|`IBGR`|시트에서 사용하는 이미지를 svg 제공| |`gray` 폴더|`IBGY`|시트에서 사용하는 이미지를 svg 제공| |`material` 폴더|`IBMR`|시트에서 사용하는 이미지를 svg 제공| |`mint` 폴더|`IBMT`|시트에서 사용하는 이미지를 svg 제공| |`simple` 폴더|`IBSP`|시트에서 사용하는 이미지를 svg 제공| ### Example ```javascript options = { Cfg: { //사용할 테마 prefix명 Style: \"IBMT\", ... } }; ```",
              "see": [
                {
                  "label": "setTheme method",
                  "url": "/docs/funcs/core/set-theme"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/style.html"
          },
          {
            "cid": 195,
            "sid": "suppress-export-message",
            "name": "suppress-export-message",
            "label": "SuppressExportMessage",
            "data": {
              "body": "> 서버 모듈, 클라이언트 모듈을 이용해 파일을 다운로드하거나 업로드할 때 대기 메시지를 띄울지 여부를 결정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|파일 다운로드, 업로드시 대기 이미지 띄움 (`default`)| |`1`|파일 다운로드, 업로드시 대기 이미지 띄우지 않음| ### Example ```javascript options.Cfg = { SuppressExportMessage : 1 // 서버 모듈, 클라이언트 모듈 파일 다운로드, 업로드시 대기 이미지 띄우지 않도록 설정 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.95|기능 추가||excel|1.1.4|기능 추가|"
            },
            "url": "docs/props/cfg/suppress-export-message.html"
          },
          {
            "cid": 196,
            "sid": "suppress-message",
            "name": "suppress-message",
            "label": "SuppressMessage",
            "data": {
              "body": "> 시트에서 제공하는 상태 메시지들 중 표시하지 않을 메시지 종류에 대해 설정 합니다. > **<mark>주의</mark> : 시트 수가 많을 경우, `SuppressMessage: 0` 설정으로 인해 렌더링이 지연될 수 있습니다.** ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|시트 내에서 발생하는 모든 메세지 표시| |`1`|시트 로딩 및 업데이트시 생성되는 메시지 표시 안함. 렌더링 메세지는 표시됨.| |`2`|1번 옵션 + 정렬과 같이 시트 내부 계산에 대한 정보 메세지 표시 안함 | |`3`|2번 옵션 + 페이지 로딩 및 렌더링, 조회, 저장 메세지 표시 안함 (`default`)| |`4`|3번 옵션 + 시트가 정상적으로 보여지지 않을 때의 에러 메세지 표시 안함 | ### Example ```javascript options.Cfg = { SuppressMessage: 0, // 시트 내에서 발생하는 모든 메세지 표시 ... }; ```",
              "see": [
                {
                  "label": "showMessage method",
                  "url": "/docs/funcs/core/show-message"
                },
                {
                  "label": "showMessageTime method",
                  "url": "/docs/funcs/core/show-message-time"
                },
                {
                  "label": "showProgress method",
                  "url": "/docs/funcs/core/show-progress"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/suppress-message.html"
          },
          {
            "cid": 197,
            "sid": "sync",
            "name": "sync",
            "label": "Sync",
            "data": {
              "body": "> 시트의 스크롤을 동기화 하는 기능입니다. > 화면에 여러개의 시트가 존재하는 경우 `Sync` 설정 시 동시에 스크롤이 동작합니다. > > `제약사항` 다음의 경우에 정상적으로 동작하지 않습니다: > 1. 시트 간 `SearchMode`가 다른 경우 > 2. 시트 간 `AutoRowHeight` 설정 여부가 다른 경우 ### Type `string` ### Options |Value|Description| |-----|-----| | `Cols` | 컬럼 리사이즈 동기화 기능 설정 | | `Vert` | 세로 스크롤 동기화 기능 설정 | | `Horz` | 가로 스크롤 동기화 기능 설정 | ### Example ```javascript options.Cfg = { Sync: 'Vert,Horz' }; ``` ### Since |product|version|desc| |---|---|---| |core|8.3.0.16|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|8.3.0.16|기능 추가|"
            },
            "url": "docs/props/cfg/sync.html"
          },
          {
            "cid": 198,
            "sid": "tab-index",
            "name": "tab-index",
            "label": "TabIndex",
            "data": {
              "body": "> `TabStop` 이 설정된 경우 시트의 탭 순서의 위치를 명시하기 위해 `Tabindex`를 설정할 수 있습니다. > ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|`TabIndex` 설정한 값| ### Example ```javascript options.Cfg = { TabIndex: 5, // 시트가 5번째 tabindex 를 갖도록 설정 }; ```",
              "see": [
                {
                  "label": "TabStop cfg",
                  "url": "./tab-stop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/tab-index.html"
          },
          {
            "cid": 199,
            "sid": "tab-stop",
            "name": "tab-stop",
            "label": "TabStop",
            "data": {
              "body": "> 페이지 안의 요소들을 탭 키로 이동하는 순서에 시트를 포함할지 여부를 설정합니다. > 시트를 포함하는 경우 `TabIndex` 로 `Tab` 순서를 설정 할 수 있습니다. > ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|페이지 내에서 `Tab` 키로 시트 접근 안됨 | |`1`|페이지 내에서 `Tab` 키로 시트 접근 가능 (`default`)| ### Example ```javascript options.Cfg = { TabStop: 0, // 탭키로 시트 접근 허용 안함 ... }; ```",
              "see": [
                {
                  "label": "TabIndex cfg",
                  "url": "./tab-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/tab-stop.html"
          },
          {
            "cid": 200,
            "sid": "tabletmode",
            "name": "tabletmode",
            "label": "TabletMode",
            "data": {
              "body": "> 시트를 모바일 터치 모드로 동작하도록 설정합니다. ### Type `boolean` ### Example ```javascript options.Cfg = { // 모바일 터치 모드로 동작 TabletMode: 1 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.2.0.26|기능 추가|"
            },
            "url": "docs/props/cfg/tabletmode.html"
          },
          {
            "cid": 201,
            "sid": "timeout",
            "name": "timeout",
            "label": "Timeout",
            "data": {
              "body": "> 시트에서 사용되는 서버통신의 최대 대기 시간 값을 설정합니다. > 입력 값은 `초(second)` 단위입니다. 기본값은 `60초` 입니다. > **[ajax (method)](./../../funcs/core/ajax), [doSave (method)](./../../funcs/core/do-save), [doSearch (method)](./../../funcs/core/do-search), [doSearchPaging (method)](./../../funcs/core/do-search-paging) 호출 시 timeout 인자가 설정되지 않았을 경우에 적용되며 API의 timeout 인자가 우선 적용됩니다.** ### Type `number` ### Example ```javascript options = { Cfg :{ Timeout: 20, // doSave, doSearch, doSearchPaging, ajax를 실행할때 최대 대기 시간을 20초로 설정 ... } }; ```",
              "see": [
                {
                  "label": "ajax method",
                  "url": "/docs/funcs/core/ajax"
                },
                {
                  "label": "doSave method",
                  "url": "/docs/funcs/core/do-save"
                },
                {
                  "label": "doSearch method",
                  "url": "/docs/funcs/core/do-search"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "/docs/funcs/core/do-search-paging"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/props/cfg/timeout.html"
          },
          {
            "cid": 202,
            "sid": "tip-max-width",
            "name": "tip-max-width",
            "label": "TipMaxWidth",
            "data": {
              "body": "> 팁의 최대 너비(`MaxWidth`)을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|팁의 최대 너비| ### Example ```javascript options.Cfg = { TipMaxWidth: 500 // 팁의 최대 너비를 500으로 설정 }; ```",
              "see": [
                {
                  "label": "Tip col",
                  "url": "/docs/props/col/tip"
                },
                {
                  "label": "Tip cell",
                  "url": "/docs/props/cell/tip"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.47|기능 추가|"
            },
            "url": "docs/props/cfg/tip-max-width.html"
          },
          {
            "cid": 203,
            "sid": "tip-start",
            "name": "tip-start",
            "label": "TipStart",
            "data": {
              "body": "> `Tip`기능을 이용하여 풍선도움말을 기능 사용시, 마우스 커서가 멈춘 후 부터 풍선도움말이 보여지기까지 시간을 설정합니다.. > 단위는 `ms` 이며, 설정하지 않으면 500ms 후에 풍선도움말이 표시됩니다. > `0`으로 설정시 풍선도움말이 표시되지 않으며, `1`로 설정시 즉시 보여지게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`value`|커서가 멈춘 후, 풍선도움말이 표시될때까지 대기시간(ms단위) (`default: 500`)| ### Example ```javascript options = { Cfg:{ TipStart: 300 //0.3초 후에 풍선도움말이 표시됩니다. }, Def:{ Row:{ Tip: 1 // 데이터 모든 행에서 풍선도움말 표시 } } }; ```",
              "see": [
                {
                  "label": "Tip row",
                  "url": "/docs/props/row/tip"
                },
                {
                  "label": "Tip col",
                  "url": "/docs/props/col/tip"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/props/cfg/tip-start.html"
          },
          {
            "cid": 204,
            "sid": "touch-scroll-count",
            "name": "touch-scroll-count",
            "label": "TouchScrollCount",
            "data": {
              "body": "> `SearchMode: 0` 에서 모바일 터치 스크롤 시 이동할 행의 개수를 설정하는 기능 입니다. > 설정 하지 않으면 한번 스크롤 움직임 시 3개의 행만큼 움직입니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|모바일 터치 스크롤 시 이동할 행의 개수| ### Example ```javascript options.Cfg = { TouchScrollCount: 1 // 터치 스크롤 시 행의 개수가 1개씩 움직입니다. }; ```",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.52|기능 추가|"
            },
            "url": "docs/props/cfg/touch-scroll-count.html"
          },
          {
            "cid": 205,
            "sid": "touch-scroll",
            "name": "touch-scroll",
            "label": "TouchScroll",
            "data": {
              "body": "> 태블릿이나 모바일 기기에서 시트 내 스크롤바의 모양을 설정합니다. > 시트 섹션별 생성되는 가로 스크롤이나 전체 시트에 생성되는 가로/세로 스크롤바에 해당합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|스크롤바 영역만 있을 뿐 실제 스크롤바를 통한 이동은 불가 (`SearchMode: 0`에서는 동작하지 않습니다.)| |`1`|평범한 스타일의 스크롤바 사용 | |`2`|큰 스타일의 스크롤바 사용 (`default`)| |`3`|작은 스타일의 스크롤바 사용| |`4`|스크롤 바를 숨김처리| **`0`이나 `4` 설정시 마우스 휠 스크롤이나 바디(데이터)영역의 터치를 통해서만 이동 가능** ### Example ```javascript options.Cfg = { TouchScroll: 4 // 스크롤바 숨김 처리, 터치로만 이동함. }; ```",
              "see": [
                {
                  "label": "CustomScroll cfg",
                  "url": "./custom-scroll"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/touch-scroll.html"
          },
          {
            "cid": 206,
            "sid": "touch-scrolling",
            "name": "touch-scrolling",
            "label": "TouchScrolling",
            "data": {
              "body": "> 모바일 환경에서 시트 바디 영역 터치 스크롤이 동작할지 여부를 결정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| | `0` | 모바일 환경에서 시트 바디 영역 터치 스크롤이 동작하지 않습니다.| | `1` | 모바일 환경에서 시트 바디 영역 터치 스크롤이 동작합니다. (`default`)| ### Example ```javascript options = { Cfg :{ TouchScrolling: 0, // 모바일 환경에서 시트 바디 영역 터치 스크롤을 막습니다. ... } }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.38|기능 추가|"
            },
            "url": "docs/props/cfg/touch-scrolling.html"
          },
          {
            "cid": 207,
            "sid": "tree-check-sync",
            "name": "tree-check-sync",
            "label": "TreeCheckSync",
            "data": {
              "body": "> [MainCol](/docs/props/cfg/main-col)을 통해 트리기능을 사용하는 시트에서 `Icon: \"Check\"` 사용 시 부모자식 간의 관계에 따라 부모를 체크시 자동으로 자식노드도 체크 되게 할지 여부를 설정합니다. > 트리를 사용하는 경우, `Icon: \"Check\"` 가 설정된 모든 컬럼에서 유효하게 동작합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|일반모드(부모/자식 관계와 무관하게 체크)| |`1`|관계모드(부모/자식 관계에 따라 자동으로 체크/언체크, 자식이 일부분만 체크된 경우 부모의 체크 박스가 '?'로 체크됨) (`default`)| |`2`|관계모드(부모/자식 관계에 따라 자동으로 체크/언체크, 자식이 일부분만 체크된 경우 부모의 체크 박스가 'v'로 체크됨) | ### Example ```javascript options.Cfg = { \"TreeCheckSync\": 0 }; ```",
              "see": [
                {
                  "label": "MainCol cfg",
                  "url": "/docs/props/cfg/main-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.4|기능 추가||core|8.2.0.2|2 mode 추가|"
            },
            "url": "docs/props/cfg/tree-check-sync.html"
          },
          {
            "cid": 208,
            "sid": "undo",
            "name": "undo",
            "label": "Undo",
            "data": {
              "body": "> 사용자가 수정한 값이나 [setValue](/docs/funcs/core/set-value)를 통해 수정된 값을 `ctrl+z`를 통해 실행 취소하거나, `ctrl+y`를 통해 다시 실행하는 기능 허용 여부를 설정합니다. > 셀의 값을 수정하거나, 상태를 삭제로 변경하거나, 신규로 추가한 행에 대해서 취소 처리하는 등의 작업을 수행합니다. > 컬럼의 이동이나 소팅, 행의 완전삭제([removeRow](/docs/funcs/core/remove-row))등에 대해서는 취소기능을 지원하지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|Undo 기능을 사용하지 않습니다. (`default`)| |`1(true)`|Undo 기능을 사용합니다.| ### Example ```javascript options.Cfg = { Undo: 1, // Undo기능 사용여부 ... }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/undo.html"
          },
          {
            "cid": 209,
            "sid": "unicode-byte-mode",
            "name": "unicode-byte-mode",
            "label": "UnicodeByteMode",
            "data": {
              "body": "> 한글 1자리의 바이트 수를 설정합니다. > 자바스크립트에서는 모든 글자를 1바이트로 인식합니다. 그러나 한글은 DB의 언어 설정에 따라 2바이트 이상으로 인식되어야 하는 경우가 있습니다. 이런 경우 이 속성을 사용하여 한글의 바이트 수를 설정할 수 있습니다. > `utf-8` 형식에서는 문자에 따라서 바이트 수가 달라지게 되는데 이런 경우 설정 인자를 `\"utf-8\"`로 설정하면 `utf-8` 형식에 맞게 처리 합니다. ### Type `number|string` ### Options |Value|Description| |-----|-----| |`number`|한글 1자리의 바이트 수 설정 (`default: 1`)| |`string`|`\"utf-8\"`로 설정, `utf-8` 형식에 맞게 바이트 수 계산 | ### Example ```javascript options.Cfg = { ... UnicodeByteMode: \"utf-8\" // 한글의 바이트 수를 utf-8 형식에 맞춰 처리 ... }; ``` ```js options.Cfg = { ... UnicodeByteMode: 3, // 한글 1자리의 바이트 사이즈를 3으로 설정 ... }; ```",
              "see": [
                {
                  "label": "Size col",
                  "url": "/docs/props/col/size"
                },
                {
                  "label": "Size cell",
                  "url": "/docs/props/cell/size"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.10|기능 추가|"
            },
            "url": "docs/props/cfg/unicode-byte-mode.html"
          },
          {
            "cid": 210,
            "sid": "use-button",
            "name": "use-button",
            "label": "UseButton",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Button`이고, [Button](/docs/props/col/button)의 속성값이 `Button`인 경우, 셀 안에 버튼이 생성됩니다. > 그런데 이 생성되는 버튼은 \\<u\\>태그를 이용하게 되는데 이를 \\<button\\>를 사용할지 여부를 선택합니다. ### ![u태그 버튼](/assets/imgs/useButton0.png \"u태그\") [`u태그`를 사용한 버튼] ![button태그 버튼](/assets/imgs/useButton1.png \"button태그\") [`button태그`를 사용한 버튼] ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|\\<u\\>태그를 통해 버튼 생성 (`default`)| |`1`|\\<button\\>태그를 통해 버튼 생성| ### Example ```javascript options.Cfg = { \"UseButton\": 1 // <button>태그를 사용하여 버튼 생성 }; ```",
              "see": [
                {
                  "label": "Button col",
                  "url": "/docs/props/col/button"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/use-button.html"
          },
          {
            "cid": 211,
            "sid": "use-cache",
            "name": "use-cache",
            "label": "UseCache",
            "data": {
              "body": "> `img` 파일의 브라우저 캐쉬 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|브라우저 캐쉬 사용 안함 (`default`)| |`1(true)`|브라우저 캐쉬 사용함| ### Example ```javascript options.Cfg = { UseCache: 1 // 브라우저 캐쉬 사용 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.19|기능 추가|"
            },
            "url": "docs/props/cfg/use-cache.html"
          },
          {
            "cid": 212,
            "sid": "use-extra-object-data",
            "name": "use-extra-object-data",
            "label": "UseExtraObjectData",
            "data": {
              "body": "> 조회 된 데이터에 시트에 설정한 열이 아닌 추가적인 `object` 형태의 정보가 있을 때 행 객체에 `object` 형태 그대로 저장합니다. > **object의 `key`가 시트의 설정된 열의 [Name](../col/name)과 동일한 경우에는 적용되지 않습니다.** > **따라서 시트에 표시하고자 하는 데이터에서는 적용되지 않습니다.** <!-- **[JsonDataSep](./json-data-sep)과 동시에 사용하실 수 없습니다. (`UseExtraObjectData`가 먼저 적용됩니다.)** --> ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|`object` 형태의 데이터가 열이름+속성명 형태로 행객체에 저장됩니다. (`default`)| |`1(true)`|`object` 형태의 데이터가 형태를 유지한 채 행객체에 저장합니다.| ### Example ```javascript options = { Cfg: { UseExtraObjectData: true, // ... }, Cols: [ { Header: '문자열(Text)', Type: 'Text', Name: 'TextData', Width: 100, Align: 'Center', CanEdit: 1 }, { Header: '줄넘김문자열(Lines)', Type: 'Lines', Name: 'LinesData', MinWidth: 250, Align: 'Center', CanEdit: 1, RelWidth: 1 } ] } // 조회 데이터 var data = [{ TextData: '장순연', LinesData: '전국이 대체로 흐리거나 구름많은 가운데 대기불안정으로 중부내륙은 아침과 오후 한때, 남부내륙은 오후 한때 소나기가 오는 곳이 있겠습니다.', ExtraInfo: { // 시트의 열로 설정되지 않은 추가적인 데이터 AddedDate: '2022-01-24', ChagedDate: '2024-06-17' } }]; var row = sheet.getFirstRow(); var info = sheet.getRowValue({row: row, saveExtraAttr: 1}).ExtraInfo; // {AddedDate: '2022-01-24', ChagedDate: '2024-06-17'} var newInfo = { DeletedDate: '2024-09-13' }; sheet.setValue(row, 'ExtraInfo', newInfo); sheet.getValue(row, 'ExtraInfo'); // {DeletedDate: '2024-09-13'} ```",
              "see": [
                {
                  "label": "getRowValue method",
                  "url": "/docs/funcs/core/get-row-value"
                },
                {
                  "label": "getValue method",
                  "url": "/docs/funcs/core/get-value"
                },
                {
                  "label": "setValue method",
                  "url": "/docs/funcs/core/set-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/use-extra-object-data.html"
          },
          {
            "cid": 213,
            "sid": "use-filter-dialog",
            "name": "use-filter-dialog",
            "label": "UseFilterDialog",
            "data": {
              "body": "> 필터 다이얼로그를 사용할지 여부를 결정합니다. > 설정시 헤더행에 필터 다이얼로그를 띄우는 아이콘이 생성되며, 버튼 클릭시 나오는 필터 다이얼로그를 이용해 필터링을 진행할 수 있습니다. > 더불어 필터 다이얼로그 사용시 필터행은 사용하실 수 없습니다. > **제약사항1: 필터 다이얼로그는 멀티레코드 시트에서는 사용하실 수 없습니다.** > **제약사항2: 필터 다이얼로그는 컬럼, 셀의 Icon 옵션 및 HeaderCheck 옵션과 함께 사용하실 수 없습니다.** > **제약사항3: 필터 다이얼로그는 피벗 다이얼로그와 함께 사용하실 수 없습니다.** ### ![UseFilterDialog](/assets/imgs/filterDialog.png \"FilterDialog\") [필터 다이얼로그 이미지] ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|헤더행에 필터 다이얼로그를 띄우는 필터 다이얼로그 아이콘을 생성합니다.| |`object`|헤더행에 필터 다이얼로그를 띄우는 필터 다이얼로그 아이콘을 생성합니다. json 형태로 옵션을 설정하여 필터 다이얼로그를 바꿀 수 있습니다.| `UseFilterDialog`를 `object`를 설정할 때, 사용자가 설정할 수 있는 옵션으로는 아래와 같은 것들이 있습니다. ### UseFilterDialog Options |Value|Description| |-----|-----| |`HideInputFilter`| ![UseFilterDialogInputFilterArea](/assets/imgs/filterDialogInputfilterArea.png \"FilterDialogInputFilterArea\") 데이터 필터 다이얼로그 최상단의 입력 필터를 숨길지 여부를 설정합니다. `true`: 데이터 필터 다이얼로그를 오픈할 때, 다이얼로그 최상단에 입력 필터를 숨깁니다. `false`: 데이터 필터 다이얼로그를 오픈할 때, 다이얼로그 최상단에 입력 필터를 포함합니다. (default: `false`)| |`Height`| ![UseFilterDialogItemArea](/assets/imgs/filterDialogItemArea.png \"FilterDialogItemArea\") 데이터 필터 다이얼로그 아이템 영역의 높이를 조정합니다. (default: `180`)| |`ZIndex`|시트의 `(Cfg) ZIndex`와 무관하게 필터 다이얼로그의 `Zindex`를 조정합니다.| |`Mode`| 데이터 필터 목록에 포함될 데이터를 결정합니다. (`default: 1`) `1`: 현재 보여지는 데이터를 포함하여 목록을 표시합니다. `2`: 현재 적용된 필터에 해당하는 데이터를 포함하여 목록을 표시합니다. ### Example ```javascript //헤더행에 필터 다이얼로그를 띄우는 필터 다이얼로그 아이콘을 생성합니다. options.Cfg = { UseFilterDialog: true }; options.Cfg = { // 필터 다이얼로그를 띄울 때, 어떻게 띄울지 변경합니다. UseFilterDialog: { HideInputFilter: true, // 데이터 필터 다이얼로그를 띄울 때, 다이얼로 최상단의 입력 필터를 띄우지 않습니다. Height: 150, // 데이터 필터 다이얼로그를 띄울 때, 아이템 영역의 높이를 150px로 조정합니다. ZIndex: 1000, // 필터 다이얼로그의 `ZIndex`를 1000으로 설정합니다. }, }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.94|UseFilterDialog:1 옵션 추가||core|8.3.0.35|object 형태로 UseFilterDialog를 설정하는 옵션 추가. <br> UseFilterDialog.HideInputFilter, UseFilterDialog.Height, UseFilterDialog.ZIndex 옵션 추가.||core|8.3.0.40|Mode 옵션 추가|"
            },
            "url": "docs/props/cfg/use-filter-dialog.html"
          },
          {
            "cid": 214,
            "sid": "use-group-sub-total",
            "name": "use-group-sub-total",
            "label": "UseGroupSubTotal",
            "data": {
              "body": "> 시트를 그룹핑하여 사용하고 있을 경우, 각 그룹별 소계행을 시트에 추가합니다. > 해당 옵션 설정 시 그룹 기능을 사용하고 있어야 하고, 컬럼 속성의 [GroupSubTotal](/docs/props/col/group-sub-total) 옵션이 설정되어 있어야 사용 가능합니다. ### Type `Int` ### Options |Value|Description| |-----|-----| |`0`|그룹 소계 기능 사용하지 않습니다. (`default`)| |`1`|그룹 소계 기능을 사용하며, 소계행을 신규행으로 추가합니다.| |`2`|그룹 소계 기능을 사용하며, 소계를 그룹행에 표시합니다.| ### Example ```javascript options.Cfg = { UseGroupSubTotal: 1 // 그룹 소계 기능 사용 여부 }; ```",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "./group"
                },
                {
                  "label": "GroupSubTotal col",
                  "url": "/docs/props/col/group-sub-total"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.8|기능 추가||core|8.3.0.42|`UseGroupSubTotal: 2` 기능 추가|"
            },
            "url": "docs/props/cfg/use-group-sub-total.html"
          },
          {
            "cid": 215,
            "sid": "use-header-context-menu",
            "name": "use-header-context-menu",
            "label": "UseHeaderContextMenu",
            "data": {
              "body": "> 헤더 컨텍스트 메뉴의 표시/비표시를 제어할 수 있는 기능입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|헤더 컨텍스트 메뉴 표시 안함| |`1(true)`|헤더 컨텍스트 메뉴 표시 (`default`)| ### Example ```javascript options.Cfg = { UseHeaderContextMenu: false // 헤더 컨텍스트 메뉴 표시 안하도록 설정 ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.2.0.1|기능 추가|"
            },
            "url": "docs/props/cfg/use-header-context-menu.html"
          },
          {
            "cid": 216,
            "sid": "use-header-sort-cancel",
            "name": "use-header-sort-cancel",
            "label": "UseHeaderSortCancel",
            "data": {
              "body": "> 일반적으로 헤더 셀을 클릭하여 소팅하는 경우 오름차순, 내림차순이 번갈아가며 정렬되는데, > `UseHeaderSortCancel`을 `1(true)`로 설정하면, 오름차순, 내림차순 후 **정렬취소** 순서로 변경됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| | `0(false)` | 헤더클릭 정렬 순서가 오름차순, 내림차순 순서로 정렬 (`default`) | | `1(true)` | 헤더클릭 정렬 순서가 오름차순, 내림차순, 정렬취소 순서로 정렬 | ### Example ```javascript options = { Cfg :{ UseHeaderSortCancel: true, ... } }; ```",
              "see": [
                {
                  "label": "HeaderSortMode cfg",
                  "url": "/docs/props/cfg/header-sort-mode"
                },
                {
                  "label": "MaxSort cfg",
                  "url": "/docs/props/cfg/max-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/props/cfg/use-header-sort-cancel.html"
          },
          {
            "cid": 217,
            "sid": "use-pivot",
            "name": "use-pivot",
            "label": "UsePivot",
            "data": {
              "body": "> 현재 시트를 피벗 시트의 데이터 시트로 사용할지 여부를 설정합니다. > 해당 옵션 설정 시 피벗 시트의 행, 열, 데이터로 사용될 열 들을 설정 할 수 있는 행과 피벗 생성 / 삭제등의 컨트롤을 담당하는 행이 [Solid](/docs/appx/solid)영역에 추가됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|피벗 사용 안함 (`default`)| |`1(true)`|피벗 사용| ### Example ```javascript options.Cfg = { UsePivot: true // 피벗 사용 여부 }; ```",
              "see": [
                {
                  "label": "PivotFormat cfg",
                  "url": "./pivot-format"
                },
                {
                  "label": "PivotFunc cfg",
                  "url": "./pivot-func"
                },
                {
                  "label": "AcceptPivotRows cfg",
                  "url": "./accept-pivot-rows"
                },
                {
                  "label": "AcceptPivotCols cfg",
                  "url": "./accept-pivot-cols"
                },
                {
                  "label": "AcceptPivotData cfg",
                  "url": "./accept-pivot-data"
                },
                {
                  "label": "Solid appendix",
                  "url": "/docs/appx/solid"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/use-pivot.html"
          },
          {
            "cid": 218,
            "sid": "use-random-id",
            "name": "use-random-id",
            "label": "UseRandomId",
            "data": {
              "body": "> 시트 생성시 임의의 id로 생성하고, 글로벌 객체를 생성하지 않습니다. > IBSheet.create()를 통해 생성시 부여한 id의 유/무 무관하게 임의의 값으로 id가 생성됩니다. > 생성된 시트의 id는 create()함수 호출 후 리턴되는 객체를 받아서 확인 하실 수 있습니다. ### Type `boolean` or `string` ### Options |Value|Description| |-----|-----| |`0(false)`|IBSheet.create()에서 정의한 id값 사용 (`default`)| |`1(true)`|\"sheet\" + 6자리 숫자 형식으로 생성 (ex: sheet847314)| |`string`|\"입력값\" + 6자리 숫자 형식으로 생성 (ex: grid125263 (값을 \"grid\"로 입력시))| ### Example ```javascript options = { Cfg:{ UseRandomId: \"myGrid\" }, Cols: [...] }; grid = IBSheet.create({ // 시트 생성시 id를 넣지 않음 \"el\": \"grid_DIV\", \"options\": options }); console.log(grid.id); //myGrid123456 식으로 id가 생성됨. //함수에 접근 할때 grid.getValue(grid.getFocusedRow(),grid.getFocusedCol()); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.47|기능 추가|"
            },
            "url": "docs/props/cfg/use-random-id.html"
          },
          {
            "cid": 219,
            "sid": "use_class-style",
            "name": "use_class-style",
            "label": "UseClassStyle",
            "data": {
              "body": "> 시트에 class 속성이 설정되어 있는 경우, 해당 class에 지정된 CSS에서 height와 width 값을 읽어 시트 생성 시 너비와 높이에 적용합니다. > 너비와 높이가 적용되는 우선순위는 style속성 > class속성 > 기본 값 순으로 적용됩니다. > 각 항목에 설정된 값이 없을 경우, 다음 순서로 우선순위가 넘어갑니다. > <mark>*너비는 **100%**, 높이는 **800px**를 기본값으로 갖습니다.</mark>* > **<mark>주의</mark> : 이 기능은 `단일 Class` 정보만을 대상으로 동작합니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|시트 div에 선언된 class 정보를 확인하여, 시트의 너비와 높이에 적용| ### Example ```javascript options.Cfg = { UseClassStyle: true, // 시트 div에 style 정보가 없을 경우, class에 선언된 css 클래스들을 확인하여 width와 height를 시트 너비와 높이에 적용 }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.37|기능 추가|"
            },
            "url": "docs/props/cfg/use_class-style.html"
          },
          {
            "cid": 220,
            "sid": "v-scroll-pad-mode",
            "name": "v-scroll-pad-mode",
            "label": "VScrollPadMode",
            "data": {
              "body": "> 세로 스크롤의 상단에 여백을 설정하는 옵션입니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|아무 여백도 설정하지 않음 (`default`)| |`1`|[Kind](/docs/appx/kind)가 `Header`인 Head 행만큼 여백을 설정| ### Example ```javascript options.Cfg = { VScrollPadMode: 1 }; ```",
              "see": [
                {
                  "label": "Kind appendix",
                  "url": "/docs/appx/kind"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/v-scroll-pad-mode.html"
          },
          {
            "cid": 221,
            "sid": "valid-check",
            "name": "valid-check",
            "label": "ValidCheck",
            "data": {
              "body": "> 저장 함수(doSave, getSaveString, getSaveJson) 호출시 유효성 검사를 수행하고, 유효성 검사 실패한 셀을 마킹합니다. > 유효성 검사에 실패한 첫 셀에 focus가 위치 하며, 편집 상태를 만듭니다. > 유효성 검사 항목은 다음과 같습니다. > - `EditMask` 유효성 검사 > - `ResultMask` 유효성 검사 > - `Required` 유효성 검사 > - `Size` 유효성 검사 ### Type `mixed`( `boolean` \\| `object` ) ### Options |Value|Description| |-----|-----| |`0(false)`|저장 함수(doSave, getSaveString, getSaveJson) 호출시 Required 유효성 검사만 수행합니다. (`default`)| |`1(true)` |저장 함수(doSave, getSaveString, getSaveJson) 호출시 유효성 검사를 수행합니다. | |`object` |유효성 검사에 실패한 첫셀에 `Focus`(`default :1`), `Edit`(`default :1`) 유무 설정 | ### Example ```javascript // 저장 함수(doSave, getSaveString, getSaveJson) 호출시 유효성 검사를 수행합니다. // 유효성 검사 실패한 제일 첫번째 셀에 Focus 이동, 셀을 편집 상태로 설정 합니다. options.Cfg = { ValidCheck: true }; // 저장 함수(doSave, getSaveString, getSaveJson) 호출시 유효성 검사를 수행합니다. // 유효성 검사 실패한 제일 첫번째 셀에 Focus 이동합니다. options.Cfg = { ValidCheck: { Focus : 1, Edit : 0 }, }; ```",
              "see": [
                {
                  "label": "ValidateMessage cfg",
                  "url": "/docs/props/cfg/validate-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.3|기능 추가||core|8.2.0.15|`object` 기능 추가|"
            },
            "url": "docs/props/cfg/valid-check.html"
          },
          {
            "cid": 222,
            "sid": "validate-message",
            "name": "validate-message",
            "label": "ValidateMessage",
            "data": {
              "body": "> `ValidCheck`를 설정했을 때, 유효성 검사 실패시 띄울 메시지를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`ValidCheck`를 설정했을 때, 유효성 검사 실패시 띄울 메시지를 설정합니다. | ### Example ```javascript options.Cfg = { ValidateMessage: \"유효성 검사에 실패했습니다.\", // 유효성 검사 실패시 띄울 메시지를 설정합니다. }; ```",
              "see": [
                {
                  "label": "ValidCheck cfg",
                  "url": "/docs/props/cfg/valid-check"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.3|기능 추가|"
            },
            "url": "docs/props/cfg/validate-message.html"
          },
          {
            "cid": 223,
            "sid": "weeks",
            "name": "weeks",
            "label": "Weeks",
            "data": {
              "body": "> 달력의 주차 표현 여부를 설정합니다. > 사용자가 직접 [showCalendar](/docs/static/show-calendar)를 호출하는 경우엔 적용되지 않습니다. (직접 호출하는 경우 메소드 인자에 따로 설정해야합니다). ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|주차 표현 안함 (`default`) ![\"기본값\"](/assets/imgs/weeks_0.png \"기본값\")| |`1`|주차 표현 ![\"주차 표현\"](/assets/imgs/weeks_1.png \"주차 표현\")| ### Example ```javascript options.Cfg = { \"Weeks\": 1 // 주차 표현 }; ```",
              "see": [
                {
                  "label": "showCalendar static",
                  "url": "/docs/static/show-calendar"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/weeks.html"
          },
          {
            "cid": 224,
            "sid": "wheel-scroll-count",
            "name": "wheel-scroll-count",
            "label": "WheelScrollCount",
            "data": {
              "body": "> `SearchMode` 와 상관없이, 휠 스크롤 시 이동할 행의 개수를 설정하는 기능 입니다. > 설정 하지 않으면, `SearchMode: 0` 은 3개, `SearchMode: 2` 은 `window.wheel.event` 의 `deltaY` 만큼 움직입니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|휠 스크롤 시 이동할 행의 개수| ### Example ```javascript options.Cfg = { WheelScrollCount: 1 // 스크롤 시 행의 개수가 1개씩 움직입니다. }; ```",
              "see": [
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.20|기능 추가|"
            },
            "url": "docs/props/cfg/wheel-scroll-count.html"
          },
          {
            "cid": 225,
            "sid": "with-credentials",
            "name": "with-credentials",
            "label": "WithCredentials",
            "data": {
              "body": "> [doSearch](/docs/funcs/core/do-search), [doSearchPaging](/docs/funcs/core/do-search-paging), [doSave](/docs/funcs/core/do-save) 사용시 내부 Ajax 통신 모듈 동작에 대해서 [withCredentials](https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/withCredentials) 옵션을 설정합니다. > `SearchMode: 4` 서버페이징 기능 사용시에도 해당 옵션이 설정됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|내부 Ajax 통신 모듈 사용시 withCredentials 옵션 사용 안함 (`default`)| |`1(true)`|내부 Ajax 통신 모듈 사용시 withCredentials 옵션 사용| ### Example ```javascript options.Cfg = { WithCredentials: true // 내부 Ajax 통신 모듈 사용시 `withCredentials` 옵션을 true로 설정. }; ```",
              "see": [
                {
                  "label": "doSearch method",
                  "url": "/docs/funcs/core/do-search"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "/docs/funcs/core/do-search-paging"
                },
                {
                  "label": "doSave method",
                  "url": "/docs/funcs/core/do-save"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.28|기능 추가|"
            },
            "url": "docs/props/cfg/with-credentials.html"
          },
          {
            "cid": 226,
            "sid": "xls-import-mode",
            "name": "xls-import-mode",
            "label": "XlsImportMode",
            "data": {
              "body": "> importData() 함수를 사용할 때, 파일선택창에서 xls 파일 선택시 서버모듈로 전환할지 여부를 결정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|클라이언트 모듈을 사용합니다. (`default`)| |`1(true)`|서버 모듈을 사용합니다.| ### Example ```javascript options.Cfg = { XlsImportMode: 1 }; // 파일 선택창에서 xls 파일 선택시 자동으로 서버모듈로 전환합니다. sheet.importData(); ```",
              "see": [
                {
                  "label": "importData method",
                  "url": "/docs/funcs/core/import-data"
                },
                {
                  "label": "loadExcel method",
                  "url": "/docs/funcs/excel/load-excel"
                }
              ],
              "since": "|product|version|desc||---|---|---||excel|8.2.0.16|기능 추가|"
            },
            "url": "docs/props/cfg/xls-import-mode.html"
          },
          {
            "cid": 227,
            "sid": "z-index",
            "name": "z-index",
            "label": "ZIndex",
            "data": {
              "body": "> 시트와 시트의 팝업 다이얼로그, 메세지, 커서들에 대한 `css z-index` 기준 값을 설정합니다. > 기준 값 설정 시 시트에 속한 객체들은 `Zindex ~ Zindex+20` 까지의 `css z-index` 를 가지게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|`ZIndex`로 가질 기준 값을 설정한다. | ### Example ```javascript options.Cfg = { // 시트와 시트 내부 객체들의 z-index 기준값을 300 으로 설정 // 내부 객체들은 최대 320 까지의 z-index 를 가짐 ZIndex: 300, ... }; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cfg/z-index.html"
          }
        ]
      },
      {
        "gid": 2,
        "name": "props-row",
        "label": "Row",
        "children": [
          {
            "cid": 228,
            "sid": "added",
            "name": "added",
            "label": "Added",
            "data": {
              "body": "> [addRow](/docs/funcs/core/add-row) 함수를 통해 추가된 행은 내부적으로 해당 속성 값을 1로 갖게 됩니다. > 별도로 [NoColor](./no-color) 속성을 설정하지 않으면, 신규로 추가된 행의 배경색상은 css/default(테마)/main.css파일에 `.IBColorAdded`로 설정한 색상 (`기본값:#eee6fa` 연한파랑색)으로 변경됩니다. > 이 속성은 직접값을 수정하기 보다는 신규행 여부를 확인하는 용도로 사용하실 것을 권합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`1(true)`|신규행| ### Example ```javascript //삭제 버튼 function delete(sheet){ var frow = sheet.getFocusedRow(); //신규행은 즉시 삭제하고, 그외에는 상태만 삭제로 바꾼다. if (frow.Added) { sheet.removeRow(frow); } else { sheet.deleteRow(frow, 1); } } ```",
              "see": [
                {
                  "label": "Changed row",
                  "url": "./changed"
                },
                {
                  "label": "Deleted row",
                  "url": "./deleted"
                },
                {
                  "label": "addRow method",
                  "url": "/docs/funcs/core/add-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/added.html"
          },
          {
            "cid": 229,
            "sid": "align",
            "name": "align",
            "label": "Align",
            "data": {
              "body": "> 행 전체의 문자열 정렬을 설정합니다. > 트리 또는 그룹에서 사용할 때는 기준으로 지정된 컬럼(**트리의 접힘/펼침 아이콘이 보이는 컬럼**)의 데이터영역은 `Align`이 먹지 않습니다. > 일반적으로 데이터 행보다는 헤더 행에서 사용됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`Left`|문자열 왼쪽 정렬 (Left, LEFT, left 허용)| |`Center`|문자열 가운데 정렬 (Center, CENTER, center 허용)| |`Right`|문자열 오른쪽 정렬 (Right, RIGHT, right 허용) ### Example ```javascript // 특정 행의 문자열을 가운데 정렬 var row = sheet.getFirstVisibleRow(); row[\"Align\"] = \"Center\"; sheet.refreshRow(row); // 전체 헤더 행에 대해 문자열을 가운데 정렬. options.Def.Header = {\"Align\": \"CENTER\"}; ```",
              "see": [
                {
                  "label": "Align col",
                  "url": "/docs/props/col/align"
                },
                {
                  "label": "Align cell",
                  "url": "/docs/props/cell/align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/align.html"
          },
          {
            "cid": 230,
            "sid": "alternate-class",
            "name": "alternate-class",
            "label": "AlternateClass",
            "data": {
              "body": "> 가독성을 높이기 위해서 홀수행, 짝수행 행의 배경색상을 다르게 설정할 때, 짝수행에 적용될 `css 클래스명`을 설정합니다. > 이 속성은 [Alternate](/docs/props/cfg/alternate)에 영향을 받습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|css 클래스 명| ### Example ```css <style> .alternateRow{background-color:#EDEDED;color:#666666;} </style> ``` ```javascript //데이터 영역의 짝수행의 클래스를 지정한다. options.Def.Row = {\"AlternateClass\": \"alternateRow\"}; ```",
              "see": [
                {
                  "label": "Alternate cfg",
                  "url": "/docs/props/cfg/alternate"
                },
                {
                  "label": "AlternateColor row",
                  "url": "./alternate-color"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/alternate-class.html"
          },
          {
            "cid": 231,
            "sid": "alternate-color",
            "name": "alternate-color",
            "label": "AlternateColor",
            "data": {
              "body": "> 가독성을 높이기 위해서 홀수행, 짝수행 행의 배경색상을 다르게 설정할 때, 짝수행에 보여질 색상을 설정합니다. > 이 속성은 [Alternate](/docs/props/cfg/alternate)속성에 영향을 받습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|HEX형식 (ex: #FF00F0) rgb형식 (ex: rgb(244,200,40)| ### Example ```javascript //데이터 영역의 짝수행 배경색을 회색으로 지정한다. options.Def.Row = {\"AlternateColor\": \"#DEDEDE\"}; ```",
              "see": [
                {
                  "label": "Alternate cfg",
                  "url": "/docs/props/cfg/alternate"
                },
                {
                  "label": "AlternateClass row",
                  "url": "./alternate-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/alternate-color.html"
          },
          {
            "cid": 232,
            "sid": "attribute-formula",
            "name": "attribute-formula",
            "label": "attribute+Formula",
            "data": {
              "body": "> 행의 각종 속성(`CanEdit, TextColor 등`)을 `Formula`를 통해 설정할 수 있습니다. > 가령 `CanEdit나 Color` 등과 같은 속성을 `Formula`로 지정하여 설정한다는 것은 다음과 같이 선언될 수 있습니다. >```javascript > options.Def.Row = [ > { > \"CanFormula\": true, //formula를 쓰려면 항상 들어감. > \"CalcOrder\": \"Color\", //Color formula를 사용함. > \"ColorFormula\": function (param) { > //부서명이 \"총무\"이면 행 전체 배경색으로 노랑으로 표시한다. > if (param.Row[\"DeptNm\"] == \"총무\") { > return \"#FFFFDD\"; > } > } > } > ]; > ``` > `※**매우중요**` > 1. 모든 포뮬러 기능을 사용시에는 [**CanFormula** row](/docs/props/row/can-formula)가 1로 설정되어야 동작합니다. > 2. `attribute+Formula(row)` 사용시에는 반드시 [**CalcOrder** row](/docs/props/row/calc-order)에 `속성명`을 계산 순서대로 설정 해야 합니다. > 가령 `CanEdit`속성 포뮬러와 `Color`속성 포뮬러를 설정했다면, `CalcOrder`에는 `\"CanEdit,Color\"`로 명시하면 됩니다. > 3. **`CalcOrder` 설정시 이름들은 반드시 띄어쓰기 없이 서로 붙여 작성해주셔야 됩니다. 이름들 간에 띄어쓰기가 되어 있는 경우 Formula 동작이 정상적으로 이뤄지지 않습니다.** ### Type `function` ### Options |Value|Description| |-----|-----| |`Sheet`|해당 시트 객체| |`Row`|`formula`가 동작할 행 객체| |`Attr`|`formula`를 적용할 속성(`Color`, `CanEdit` 등)| ### Example ```javascript //formula 사용시 CanFormula:1이 설정 되어야 하고, attribute+Formula 사용시에는 CalcOrder도 설정되어야 함 options.Def.Row = { CanFormula: 1, //formula를 사용하려면 반드시 설정되어야 함. // CalcOrder 설정시 속성 이름 간에 띄어쓰지 말고 전부 붙여 쓰셔야 합니다. CalcOrder: \"Color,CanEdit\", //적용할 속성을 순서대로 설정 CanEditFormula: function (param) { //결산여부가 체크된 행에 대해서는 편집 불가 if (param.Row[\"FinishedYN\"]) { return 0; } }, ColorFormula:function(param) { //부서가 회계인 경우 배경색을 \"#FFFFDD\"로 설정 if(param.Row[\"DeptCd\"] == \"1B\"){ return \"#FFFFDD\"; } } }; options.Cols = [ ... {Header:\"결산완료 여부\", Type:\"Bool\", Name:\"FinishedYN\"}, {Header:\"부서\", Type:\"Enum\", Name:\"DeptCd\", Enum:\"|총무|회계|인사|영업|개발\", EnumKeys:\"|2A|1B|C9|B4|D0\"}, ... ]; ```",
              "see": [
                {
                  "label": "CanFormula row",
                  "url": "/docs/props/row/can-formula"
                },
                {
                  "label": "CalcOrder row",
                  "url": "/docs/props/row/calc-order"
                },
                {
                  "label": "attrbute+formula col",
                  "url": "/docs/props/col/attribute-formula"
                },
                {
                  "label": "Formula appendix",
                  "url": "/docs/appx/formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/attribute-formula.html"
          },
          {
            "cid": 233,
            "sid": "button-width",
            "name": "button-width",
            "label": "ButtonWidth",
            "data": {
              "body": "> [Type col](/docs/props/col/type)이 [Button col](/docs/props/col/button)이고, [Button row](./button)속성의 값이 `Button`인 경우, 셀에 생성되는 버튼 객체의 너비를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|버튼 태그의 너비(pixel단위)| ### Example ```javascript //특정행의 들여쓰기 정도를 2로 설정 var rows = sheet.getDataRows(); rows[3][\"ButtonWidth\"] = \"16px\"; sheet.refreshRow(rows[3]); ```",
              "see": [
                {
                  "label": "Type col",
                  "url": "/docs/props/col/type"
                },
                {
                  "label": "Button col",
                  "url": "/docs/props/col/button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/button-width.html"
          },
          {
            "cid": 234,
            "sid": "calc-order",
            "name": "calc-order",
            "label": "CalcOrder",
            "data": {
              "body": "> 포뮬러(`일반 혹은 attribute+Formula`)가 설정된 열들에 대해서 계산 순서를 구분자 \",\"로 연결한 문자열로 정의합니다. > > 열에 [attribute + Formula](/docs/props/col/attribute-formula)를 설정시에는 반드시 **CalcOrder** 에 `열이름+attribute명`(ex: \"SalaryCanEdit\") 로 설정해야 하며, 수식계산만 하는 열의 경우 열이름만 넣으면 됩니다. > > `**※매우중요**` > 1. 일반 Formula(수식계산)만 사용하는 시트에서는 **CalcOrder**를 사용하지 않아도 `Formula`가 동작하지만 [attribute + Formula](/docs/props/col/attribute-formula)를 일반 `Formula`와 같이 사용하는 경우엔, 일반 `Formula`도 반드시 **CalcOrder**에 정의(열이름을 명시)를 해야만 동작합니다. > 2. **`CalcOrder` 설정시 이름들은 반드시 띄어쓰기 없이 서로 붙여 작성해주셔야 됩니다. 이름들 간에 띄어쓰기가 되어 있는 경우 Formula 동작이 정상적으로 이뤄지지 않습니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|계산 순서에 맞게 열이름(또는 열이름+속성명)을 \",\"를 구분자로 연결한 문자열| ### Example ```javascript //SubTotal, Total에 대해 Formula가 동작하고, SubTotal의 ColorFormula와 Total에 TextColorFormula가 다음으로 동작됨. options.Def.Row = { CalcOrder: \"SubTotal,Total,SubTotalColor,TotalTextColor\" }; options.Cols = [ {Type:\"Int\", Name:\"QT1\"}, {Type:\"Int\", Name:\"QT2\"}, {Type:\"Int\", Name:\"SubTotal\", Formula:QT12SUM, ColorFormula:STColur}, {Type:\"Int\", Name:\"QT3\"}, {Type:\"Int\", Name:\"QT4\"}, {Type:\"Int\", Name:\"Total\", Formula:TOTSUM, TextColorFormula:TOTTextColur}, ]; function QT12SUM(fr){ return fr.Row[\"QT1\"] + fr.Row[\"QT2\"]; } function TOTSUM(fr){ return fr.Row[\"QT1\"] + fr.Row[\"QT2\"] + fr.Row[\"QT3\"] + fr.Row[\"QT4\"]; } function STColur(fr){ return fr.Value > 500 ? \"#FF0000\" : \"#333333\"; } function TOTTextColur(fr){ if (fr.Value > 1000) { return '#FF0000'; } else { return '#333333'; } } ```",
              "see": [
                {
                  "label": "CanFormula row",
                  "url": "./can-formula"
                },
                {
                  "label": "Formula col",
                  "url": "/docs/props/col/formula"
                },
                {
                  "label": "attribute+Formula col",
                  "url": "/docs/props/col/attribute-formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/calc-order.html"
          },
          {
            "cid": 235,
            "sid": "can-drag-2",
            "name": "can-drag",
            "label": "CanDrag",
            "data": {
              "body": "> 행의 Drag 가능여부를 설정합니다. > [CanDrag cfg](/docs/props/cfg/can-drag) 속성이 `1(true)`인 경우 사용 가능합니다 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|드래그 불가| |`1(true)`|드래그 가능| ### Example ```javascript //특정 행에 대해서 드래그를 막는다. var row = sheet.getRowById(\"AR55\"); row[\"CanDrag\"] = 0; ```",
              "see": [
                {
                  "label": "CanDrag cfg",
                  "url": "/docs/props/cfg/can-drag"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-drag.html"
          },
          {
            "cid": 236,
            "sid": "can-edit-2",
            "name": "can-edit",
            "label": "CanEdit",
            "data": {
              "body": "> 행에 대한 편집 가능 여부를 설정합니다. > 이 속성은 기본값은 `1`인데, `0` 설정시 `Cell, Row, Col`순으로 우선 순위를 갖습니다. > 가령 `Cell`에서 `0`으로 설정시 `Row`나 `Col`에서 `1`을 설정해도 해당 셀은 편집이 불가능해 집니다. > `CanEdit: 4`를 제외하고는 편집불가 모드 사용시 `Enum` 컬럼의 아이콘과 `Date` 타입 컬럼의 달력 아이콘을 표현하지 않습니다. > `Cfg`를 이용하여 편집불가 사용시에는 우선순위가 가장 높아짐으로, `Cell, Row, Col`에 `CanEdit: 0`은 먹히지 않습니다. > `Button` 타입의 버튼 클릭 시 동작, `File` 타입의 아이콘 표시 여부에 대해서는 해당 속성의 영향을 **`받지 않습니다`**. ([Disabled col](/docs/props/col/disabled) 통하여 제어 가능.) ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|행을 편집 불가(읽기 전용)으로 설정합니다. ![CanEdit](/assets/imgs/canEdit0.png \"CanEdit\")| |`1`|행을 편집 가능으로 설정합니다. ![CanEdit](/assets/imgs/canEdit1.png \"CanEdit\")| |`2`|행의 내용은 편집 불가하지만, 편집 미리보기를 제공하여 셀의 모든 내용을 확인할 수 있습니다. ![CanEdit](/assets/imgs/canEdit2.png \"CanEdit\")| |`3`|행 편집 불가능(편집 가능 불가능에 대한 배경색을 표시하지 않음) [ColorState (cfg)](/docs/props/cfg/color-state)와 관계없이 배경색을 표현하지 않음.| |`4`|행 편집 불가능 + 배경색 표현안함 + 아이콘표시| ### Example ```javascript //특정 행의 Edit를 막는다. var row = sheet.getRowById(\"AR55\"); row[\"CanEdit\"] = 0; sheet.refreshRow(row); //조회 데이터에서 특정행에 편집을 막는다. {\"data\":[ {\"CanEdit\":0,\"ColName1\":\"Value1\",\"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "CanEdit col",
                  "url": "/docs/props/col/can-edit"
                },
                {
                  "label": "CanEdit cell",
                  "url": "/docs/props/cell/can-edit"
                },
                {
                  "label": "getCanEdit method",
                  "url": "/docs/funcs/core/get-can-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.12|`CanEdit: 3, 4` 추가|"
            },
            "url": "docs/props/row/can-edit.html"
          },
          {
            "cid": 237,
            "sid": "can-filter",
            "name": "can-filter",
            "label": "CanFilter",
            "data": {
              "body": "> 특정행에 대한 필터 적용 여부를 설정합니다. > `0(false)`로 설정시 해당 행은 필터설정과 무관한게 보여지게 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|필터 적용 제외| |`1(true)`|필터 적용| ### Example ```javascript // 특정행들은 필터와 무관하게 항상 보여지게 한다 {\"data\":[ ... {\"CanFilter\":0,\"ColName1\":\"Value1\",\"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "showFilterRow method",
                  "url": "/docs/funcs/core/show-filter-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-filter.html"
          },
          {
            "cid": 238,
            "sid": "can-focus",
            "name": "can-focus",
            "label": "CanFocus",
            "data": {
              "body": "> 행에 대한 포커스 가능 여부를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|포커스가 불가능해 집니다| |`1`|포커스가 가능합니다| |`2`|마우스 클릭으로만 포커스가 가능해 집니다.| ### Example ```javascript //특정 행의 포커스를 막는다. var row = sheet.getRowById(\"AR55\"); row[\"CanFocus\"] = 0; ```",
              "see": [
                {
                  "label": "CanFocus col",
                  "url": "/docs/props/col/can-focus"
                },
                {
                  "label": "CanFocus cell",
                  "url": "/docs/props/cell/can-focus"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-focus.html"
          },
          {
            "cid": 239,
            "sid": "can-formula",
            "name": "can-formula",
            "label": "CanFormula",
            "data": {
              "body": "> 행에 `Formula` 동작 여부를 설정합니다. > `0(false)`으로 설정하면 `Formula` 설정된 셀 값에 변경이 있어도 계산이 이루어지지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|`Formula` 동작 안함| |`1(true)`|`Formula` 동작 가능| ### Example ```javascript //전체 데이터행에 대해서 Formula를 수행하지 않는다. //(특정 행에 대해서 따로 CanFormula를 작성한 뒤, (method)calculate()함수를 통해 필요할때만 Formula를 수행할 수도 있음.) options.Def.Row = {CanFormula: 0}; or //전체 데이터행에 대해서 Formula을 허용한다. options.Def.Row = {CanFormula: 1}; ... 시트 생성 ... //조회 이후 특정 시점에서 특정 행에만 Formula동작 sheet.getRowById(\"AR3\")[\"CanFormula\"] = 1; sheet.getRowById(\"AR5\")[\"CanFormula\"] = 1; //formula를 계산한다. sheet.calculate(1, 1); ```",
              "see": [
                {
                  "label": "CalcOrder row",
                  "url": "./calc-order"
                },
                {
                  "label": "calculate method",
                  "url": "/docs/funcs/core/calculate"
                },
                {
                  "label": "Formula appendix",
                  "url": "/docs/appx/formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-formula.html"
          },
          {
            "cid": 240,
            "sid": "can-group",
            "name": "can-group",
            "label": "CanGroup",
            "data": {
              "body": "> 특정행에 대한 그룹핑 허용 여부를 설정합니다. > `0(false)`로 설정시 해당 행은 그룹에 포함되지 않고 독립적으로 위치하게 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|그룹핑 불가| |`1(true)`|그룹핑 가능| ### Example ```javascript //특정행들은 그룹에서 제외 시킨다. {\"data\":[ ... {\"CanGroup\":0,\"ColName1\":\"Value1\",\"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "/docs/props/cfg/group"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-group.html"
          },
          {
            "cid": 241,
            "sid": "can-print",
            "name": "can-print",
            "label": "CanPrint",
            "data": {
              "body": "> 행의 프린트 가능 여부. > [doPrint](/docs/funcs/core/do-print) 또는 [down2Pdf](/docs/funcs/excel/down-to-pdf)를 이용하여 프린트 할 경우 해당 행을 프린트 할지 여부를 설정할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|프린트 불가| |`1`|프린트 가능 (`default`)| ### Example ```javascript //특정 행에 대해서 프린트를 막는다. var row = sheet.getRowById(\"AR55\"); sheet.setAttribute(row, null, 'CanPrint', 0); ```",
              "see": [
                {
                  "label": "doPrint method",
                  "url": "/docs/funcs/core/do-print"
                },
                {
                  "label": "down2Pdf method",
                  "url": "/docs/funcs/excel/down-to-pdf"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-print.html"
          },
          {
            "cid": 242,
            "sid": "can-select-2",
            "name": "can-select",
            "label": "CanSelect",
            "data": {
              "body": "> 행의 선택 가능여부를 설정합니다.(드래그를 통한 영역선택) > 속성이 `0(false)`인 경우, 특정 행에 대해 선택(selecting)을 막을 수 있습니다. > 드래그를 통한 선택시 `CanSelect: 0`인 행은 건너 뛰고 선택됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|선택 불가| |`1(true)`|선택 가능| ### Example ```javascript //특정 행에 대해서 드래그를 막는다. var row = sheet.getRowById(\"AR55\"); row[\"CanSelect\"] = 0; ```",
              "see": [
                {
                  "label": "CanSelect cfg",
                  "url": "/docs/props/cfg/can-select"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-select.html"
          },
          {
            "cid": 243,
            "sid": "can-sort-2",
            "name": "can-sort",
            "label": "CanSort",
            "data": {
              "body": "> 트리사용시 자식행들에 대한 소팅 가능 불가능 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|소팅 불가| |`1(true)`|소팅 가능| ### Example ```javascript //특정행의 자식행에 대해 소팅을 허용한다. var row = sheet.getNextSiblingRow(true); row[\"CanSort\"] = 1; ```",
              "see": [
                {
                  "label": "SortPos row",
                  "url": "/docs/props/row/sort-pos"
                },
                {
                  "label": "CanSort col",
                  "url": "/docs/props/col/can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/can-sort.html"
          },
          {
            "cid": 244,
            "sid": "changed",
            "name": "changed",
            "label": "Changed",
            "data": {
              "body": "> 행의 변경 여부를 나타냅니다. > 행의 값을 수정시 자동으로 `1(true)`로 수정되고, 값을 원래 값으로 복원하면 자동으로 속성이 제거됩니다. > 별도로 [NoColor](./no-color) 속성을 설정하지 않으면, 수정시 배경색상은 css/default(테마)/main.css파일에 `.IBColorChanged`로 설정한 색상 (`기본값:#FFFFD6` 연한노란색)으로 변경됩니다. > 이 속성은 직접 값을 변경하기 보다는 수정 여부를 확인하는 용도로 사용할 것을 권합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`1(true)`|수정됨| ### Example ```javascript // 전체 데이터 중에 수정된 행의 개수를 확인 // 아래 예제는 Changed 속성을 확인해보기 위해 작성되었으며, // 실제 수정된 행의 개수를 확인하려면 getRowsByStatus()함수를 사용하시면 됩니다. var rows = sheet.getDataRows(); var cnt = 0; for (var i = 0; i < rows.length; i++) { if (rows[i][\"Changed\"]) cnt++; } alert(cnt+\"개의 수정된 행이 존재합니다.\"); ```",
              "see": [
                {
                  "label": "Added row",
                  "url": "./added"
                },
                {
                  "label": "Deleted row",
                  "url": "./deleted"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/changed.html"
          },
          {
            "cid": 245,
            "sid": "class",
            "name": "class",
            "label": "Class",
            "data": {
              "body": "> 행에 포함된 각 셀에 `커스텀 css 클래스`를 설정합니다. > **<mark>주의</mark> : Class로 적용한 css는 엑셀 다운로드시 디자인 반영되지 않습니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|css에 지정한 클래스 명| ### Example ```css <style> .rowAlert {font-weight:700;animation:blinkingText 1s infinite;} @keyframes blinkingText{ 0%{ color: #FF0000; } 50%{ color: #FF0000; } 80%{ color:transparent; } 100%{ color: #FF0000; } } .subTitle{color:#EDEDED;background-color:#666666;} </style> ``` ```javascript // 특정행의 글자를 붉은색에 깜빡이게 변경한다. var row = sheet.getRowById(\"AR11\") row[\"Class\"] = \"rowAlert\"; sheet.refreshRow(row); // 헤더행의 타이틀과 배경 색상을 변경한다. options.Def.Header = {\"Class\": \"subTitle\"}; ```",
              "see": [
                {
                  "label": "AlternateClass row",
                  "url": "./alternate-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/class.html"
          },
          {
            "cid": 246,
            "sid": "color",
            "name": "color",
            "label": "Color",
            "data": {
              "body": "> 행의 배경색상을 설정합니다. > 행의 색상은 상태에 따른 배경색상의 영향을 받습니다. > rgb(255,255,255)는 투명색이 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|HEX형식 (ex:#FF00F0) rgb형식 (ex:rgb(244,200,40)| ### Example ```javascript //특정행의 배경색상을 회색으로 설정한다. var row = sheet.getRowById(\"AR11\"); row[\"Color\"] = \"#ADADAD\"; sheet.refreshRow(row); //조회 데이터 중에 특정행의 배경색을 노란색으로 설정한다. {\"data\":[ ... {\"Color\":\"#FFFF00\",\"ColName1\":\"Value1\",\"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "AlternateColor row",
                  "url": "./alternate-color"
                },
                {
                  "label": "TextColor row",
                  "url": "./text-color"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/color.html"
          },
          {
            "cid": 247,
            "sid": "deleted",
            "name": "deleted",
            "label": "Deleted",
            "data": {
              "body": "> [DeleteRow](/docs/funcs/core/delete-row) 함수 호출시 해당 행에 속성값이 `1(true)`로 설정됩니다. > `Deleted` 값을 `1(true)`로 설정되면 향후 삭제할 행의 의미로 배경색상이 .`IBColorDeleted 클래스`에서 정의한 색상으로 변경됩니다. > 해당 속성은 직접 설정하기 보다는 설정값을 확인하는 용도로 사용하실 것을 권합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`1(true)`|삭제예정| ### Example ```javascript //전체 데이터 중에 삭제예정인 행의 개수를 확인 //아래 예제는 Deleted 속성을 확인해보기 위해 작성되었으며, //실제 삭제예정인 행의 개수를 확인하려면 getRowsByStatus()함수를 사용하시면 됩니다. var rows = sheet.getDataRows(); var cnt = 0; for(var i = 0; i < rows.length; i++){ if (rows[i][\"Deleted\"]) cnt++; } alert(cnt+\"개의 삭제예정인 행이 존재합니다.\"); ```",
              "see": [
                {
                  "label": "Added row",
                  "url": "./added"
                },
                {
                  "label": "Changed row",
                  "url": "./changed"
                },
                {
                  "label": "DeleteRow method",
                  "url": "/docs/funcs/core/delete-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/deleted.html"
          },
          {
            "cid": 248,
            "sid": "expanded",
            "name": "expanded",
            "label": "Expanded",
            "data": {
              "body": "> 트리 기능 사용시 행의 접힘/펼침 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|접힘| |`1(true)`|펼침| ### Example ```javascript //특정행의 접힘여부 확인 var ep = sheet.getAttribute(sheet.getFocusedRow(), null, \"Expanded\"); //특정행을 펼칩니다. setExpandRow api 사용 sheet.setExpandRow(sheet.getRowByIndex(4), null, 1); ```",
              "see": [
                {
                  "label": "showTreeLevel method",
                  "url": "/docs/funcs/core/show-tree-level"
                },
                {
                  "label": "setExpandRow method",
                  "url": "/docs/funcs/core/set-expand-row"
                },
                {
                  "label": "onBeforeExpand event",
                  "url": "/docs/events/on-before-expand"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/expanded.html"
          },
          {
            "cid": 249,
            "sid": "focus-row",
            "name": "focus-row",
            "label": "FocusRow",
            "data": {
              "body": "> 데이터 셀을 클릭시 보여지는 \"커서 포커스 행\"은 Table 객체 위에 DIV 객체가 떠있는 형태로 구성됩니다. > 특정 행에 포커스가 있을 때 보여질 \"커서 포커스 행\"의 디자인을 설정합니다. > 예약된 문자를 구분자 \",\" 연결하여 설정합니다. > 기본적으로는 \"Border, Background\"로 구성됩니다. ### ![FocusRow](/assets/imgs/focusRow1.png \"FocusRow default\") [**일반 FocusRow**] ![FocusRow](/assets/imgs/focusRow2.png \"FocusRow default\") [**border없이 Background로 설정시**] ### Type `string` ### Options |Value|Description| |-----|-----| |`Border`|커서 포커스 DIV의 테두리 사용 (.IBFocusRowBorder)| |`Background`|커서 포커스 DIV의 배경색 사용 (.IBFocusRowBackground) | |`Color`|커서 포커스 DIV를 사용하지 않고 Table 객체에 background-color를 부여 (성능이 저하될 수 있음, 포커스 셀은 제외) (.IBColorFocused) | |`Class`|css/default(테마)/main.css 파일에 .IBClassFocused 클래스에 정의한 디자인을 따릅니다. (포커스 셀은 제외)| ### Example ```javascript //특정 행에 대해서 포커스 행의 디자인을 border없이 배경색만 보이는 형태로 수정 var row = sheet.getRowById(\"AR55\"); row[\"FocusRow\"] = \"Background\"; //전체 행에 대해서 포커스 행의 디자인을 .IBClassFocused 클래스에 정의한 디자인으로 보이도록 수정 options.Def = { Row : { FocusRow: \"Class\" } }; ```",
              "see": [
                {
                  "label": "FocusRow col",
                  "url": "/docs/props/col/focus-row"
                },
                {
                  "label": "FocusRow cell",
                  "url": "/docs/props/cell/focus-row"
                },
                {
                  "label": "FocusCell col",
                  "url": "/docs/props/col/focus-cell"
                },
                {
                  "label": "FocusCell cell",
                  "url": "/docs/props/cell/focus-cell"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/focus-row.html"
          },
          {
            "cid": 250,
            "sid": "have-child",
            "name": "have-child",
            "label": "HaveChild",
            "data": {
              "body": "> 동적 로드를 할 행에 설정시 `MainCol` 이 있는 컬럼에 트리 아이콘을 추가합니다. > 해당 기능의 경우, 자식이 없어야 동작하고 `true` 로 설정시 접혀있는 아이콘이 생기게 됩니다. > `loadSearchData, doSearch` 에 `parent` 인자(데이터를 조회할 부모행 지정)를 이용해서 동적트리조회를 하면 됩니다. > `setAttribute` 를 사용해서 동적으로 제어할 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|트리아이콘 생성하지 않음.| |`1(true)`|접힌 트리아이콘 생성| ### Example ```javascript Items: [ { Cls: '콩류', HaveChild: true // 자식 없음으로 접힌 트리 아이콘 생성. }, ... ] // --------------------- sheet.setAttribute(row, null, 'HaveChild', true); ```",
              "see": [
                {
                  "label": "doSearch method",
                  "url": "/docs/funcs/core/do-search"
                },
                {
                  "label": "loadSearchData method",
                  "url": "/docs/funcs/core/load-search-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.25|기능 추가|"
            },
            "url": "docs/props/row/have-child.html"
          },
          {
            "cid": 251,
            "sid": "height",
            "name": "height",
            "label": "Height",
            "data": {
              "body": "> 행의 높이를 설정합니다. > `Height` 속성에 설정된 값보다 셀 높이가 커져야하는 경우(셀의 내용이 많아서) 셀 내용에 맞춰 행의 높이가 설정됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|행의 높이 (pixel 단위)| ### Example ```javascript options.Def.Row = { \"Height\": 50, } ```",
              "see": [
                {
                  "label": "Size cfg",
                  "url": "/docs/props/cfg/size"
                },
                {
                  "label": "MaxHeight row",
                  "url": "./max-height"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/height.html"
          },
          {
            "cid": 252,
            "sid": "hint-value",
            "name": "hint-value",
            "label": "HintValue",
            "data": {
              "body": "> 힌트는 열의 너비보다 셀의 내용이 많은 경우, 마우스 커서가 해당 셀 위에 오버시 해당 셀의 너비를 늘려 가려진 내용을 보여주는 기능입니다. > 이 기능은 행단위로 힌트 기능 활성화시 보여질 내용을 변경/설정합니다. ### ![HintValue](/assets/imgs/hintValue.png \"마우스 커서가 셀에 오버시 설정한 글자가 보여짐\") ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|힌트 활성화시 보여질 내용| ### Example ```javascript //10번 행에 대해서는 Hint기능 사용시 원래 내용과 다른 내용이 보여지게 끔 한다. var row = sheet.getRowById(\"AR10\"); row[\"HintValue\"] = \"해당 건은 결제가 완료되었습니다.\"; //조회 데이터에서 일부 행에 대해 원래 셀의 내용과 다른 내용이 보여지게 끔 한다. {\"data\":[ {\"HintValue\":\"의심거래항목입니다.\", \"ColName1\":\"Value1\", \"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "ShowHint row",
                  "url": "./show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/hint-value.html"
          },
          {
            "cid": 253,
            "sid": "html-postfix",
            "name": "html-postfix",
            "label": "HtmlPostfix",
            "data": {
              "body": "> 행 전체 각 셀의 문자열 뒤에 원하는 HTML 태그를 삽입합니다. > 이 속성은 행에서 사용되는 일은 거의 드물며, 보통 `Col`이나 `Cell`단위로 사용한다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 Html태그| ### Example ```javascript //헤더행의 각 셀 타이틀 끝에 특정 Icon을 추가한다 options.Def.Header = {\"HtmlPostfix\": '<i class=\"fas fa-apple-alt\"></i>'}; ```",
              "see": [
                {
                  "label": "HtmlPrefix row",
                  "url": "./html-prefix"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/html-postfix.html"
          },
          {
            "cid": 254,
            "sid": "html-prefix",
            "name": "html-prefix",
            "label": "HtmlPrefix",
            "data": {
              "body": "> 행 전체 각 셀의 문자열 앞에 원하는 HTML 태그를 삽입합니다. > 이 속성은 행에서 사용되는 일은 거의 드물며, 보통 `Col`이나 `Cell`단위로 사용한다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 Html태그| ### Example ```javascript //헤더행의 각 셀에 특정 Icon을 추가한다 options.Def.Header = {\"HtmlPrefix\": '<i class=\"far fa-angry\"></i>'}; ```",
              "see": [
                {
                  "label": "HtmlPostfix row",
                  "url": "./html-postfix"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/html-prefix.html"
          },
          {
            "cid": 255,
            "sid": "indent",
            "name": "indent",
            "label": "Indent",
            "data": {
              "body": "> 행 전체의 문자열 들여쓰기를 설정합니다. > 좌측정렬을 하는 셀은 좌측 끝부터, 우측정렬을 하는 셀은 우측 끝부터 들여쓰기가 적용됩니다. > 들여쓰기 1칸은 `10px` 입니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|들여쓰기 정도 (10px 단위)| ### Example ```javascript //특정행의 들여쓰기 정도를 2로 설정 var row = sheet.getRowById(\"AR11\"); row[\"Indent\"] = 2; sheet.refreshRow(row); //전체 데이터 행의 들여쓰기를 1로 설정 options.Def.Row = {\"Indent\": 1}; ```",
              "see": [
                {
                  "label": "Align row",
                  "url": "./align"
                },
                {
                  "label": "Align col",
                  "url": "/docs/props/col/align"
                },
                {
                  "label": "Align cell",
                  "url": "/docs/props/cell/align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/indent.html"
          },
          {
            "cid": 256,
            "sid": "kind",
            "name": "kind",
            "label": "Kind",
            "data": {
              "body": "> 각 행이 갖고 있는 기능을 의미합니다. > 행 마다의 기능(헤더, 데이터, 필터, 그룹 등)을 확인할 때 사용됩니다. > 이 속성의 값은 동적으로 수정할 수 없으며, 확인용도로만 사용하실 것을 권합니다. > `Kind`의 자세한 종류는 **Appendix**에 [Kind attribute](/docs/appx/kind) 를 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|행의 기능| ### Example ```javascript //행의 Kind를 확인한다. var row = sheet.getRowById(\"CustRow\"); alert(row[\"Kind\"]); ```",
              "see": [
                {
                  "label": "Kind appendix",
                  "url": "/docs/appx/kind"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/kind.html"
          },
          {
            "cid": 257,
            "sid": "max-height",
            "name": "max-height",
            "label": "MaxHeight",
            "data": {
              "body": "> 행의 최대 높이를 설정합니다. > Wrap 설정시 데이터의 양에 따라 행의 높이가 늘어나게 되는데, 이때 최대 증가할 수 있는 높이를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|행의 최대 높이 (pixel 단위)| ### Example ```javascript options.Def.Row = { \"MaxHeight\": 50, } ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/max-height.html"
          },
          {
            "cid": 258,
            "sid": "menu-2",
            "name": "menu",
            "label": "Menu",
            "data": {
              "body": "> 마우스 우측 버튼 클릭시 보여질 컨텍스트 메뉴를 설정합니다. ### Type mixed( `object` \\| `string` ) ### Options |Value|Description| |-----|-----| |`string`|첫글자를 구분자로 한 컨텍스트 메뉴스트링 지정 (ex: @저장@임시저장@취소 or *상신*취소) | |`object`|[Menu Object 설정 링크 참고](/docs/appx/menu) ### Example ```javascript //헤더행에서 마우스 우측 버튼 클릭시 엑셀 다운로드에 대한 설정 활성화. var rows = sheet.getHeaderRows(); for(var i = 0; i < rows.length; i++){ rows[i][\"Menu\"] = \"|엑셀다운로드|텍스트다운로드|PDF다운로드\"; } //조회 데이터에서 특정행에 컨텍스트 메뉴 기능 적용하기. {\"data\":[ {\"Menu\":\"|상신하기|보류하기\",\"ColName1\":\"Value1\",\"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/menu.html"
          },
          {
            "cid": 259,
            "sid": "no-calculate",
            "name": "no-calculate",
            "label": "NoCalculate",
            "data": {
              "body": "> 특정행에 대한 소계 또는 합계 계산 포함 여부를 설정합니다. > `1(true)`로 설정시 해당 행은 소계 또는 합계 계산에 포함되지 않습니다. > 동적으로 속성을 추가한 후 셀 값을 변경할 경우 `NoCalculate: 1(true)` 행을 제외하고 소계가 재계산됩니다 > **<mark>주의</mark> : 소계행을 [refreshRow](/docs/funcs/core/refresh-row) 하는 것으로는 소계 재계산이 이루어지지 않습니다** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|소계/합계 계산 포함 (`default`)| |`1(true)`|소계/합계 계산 제외| ### Example ```javascript // 특정행들은 소계/합계 계산에 포함되지 않는다 {\"data\":[ ... {\"NoCalculate\":1,\"ColName1\":\"Value1\",\"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "makeSubTotal method",
                  "url": "/docs/funcs/core/make-sub-total"
                },
                {
                  "label": "setFormulaRow method",
                  "url": "/docs/funcs/core/set-formula-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/props/row/no-calculate.html"
          },
          {
            "cid": 260,
            "sid": "no-color",
            "name": "no-color",
            "label": "NoColor",
            "data": {
              "body": "> 행의 기본 적용된 배경색이 무시됩니다. > 홀수, 짝수행에 대한 배경색상([AlternateColor](./alternate-color))나 상태(입력, 수정, 삭제) 및 선택에 대한 색상이 무시되고, `Color` 속성으로 통한 배경색도 적용되지 않게 할 수 있습니다. > [FormulaRow](/docs/props/col/formula-row)에 `NoColor`를 설정하여 해당 행의 배경색을 무시할 수 있습니다. > `NoColor`가 적용되는 우선 순위는 셀 \\> 열 \\> 행입니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|기능 사용 안함(`defualt`)| |`1`|모든 배경색 무시(단 Class속성을 통해 설정한 배경색을 적용)| |`2`|상태 및 선택에 대한 색상만 무시 |`3`|`Color` 설정 시 상태, `AlternateColor`에 대한 색상을 무시하고 `Color` 색상 적용 ### Example ```javascript //특정행의 배경색 변경을 막는다. var row = sheet.getRowById(\"AR11\") row[\"NoColor\"] = 1; sheet.refreshRow(row); //FomulaRow의 배경색 변경 기능을 제한한다. sheet.FormulaRow.NoColor = 2; sheet.refreshRow(sheet.FormulaRow); //다음과 같이 선언할 수도 있습니다. options.Def.FormulaRow = {NoColor: 2}; //데이터 행에 대해서 상태에 따른 배경색 변경 기능을 제한한다. options.Def.Header = {\"NoColor\":2}; ```",
              "see": [
                {
                  "label": "Alternate cfg",
                  "url": "/docs/props/cfg/alternate"
                },
                {
                  "label": "Color row",
                  "url": "./color"
                },
                {
                  "label": "AlternateColor row",
                  "url": "./alternate-color"
                },
                {
                  "label": "FormulaRow col",
                  "url": "/docs/props/col/formula-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.2.0.14|`NoColor: 3` 동작 추가|"
            },
            "url": "docs/props/row/no-color.html"
          },
          {
            "cid": 261,
            "sid": "no-upload",
            "name": "no-upload",
            "label": "NoUpload",
            "data": {
              "body": "> 지정한 행의 저장 여부를 설정합니다. > `1(true)`로 설정한 행의 경우 저장 함수([doSave](/docs/funcs/core/do-save), [getSaveString](/docs/funcs/core/get-save-string) 등) 호출시 상태와 무관하게 무시됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|서버로 전송 (데이터행 `default: 0(false)`)| |`1(true)`|서버로 전송 제외(필터나 합계행 `default: 1(true)`)| ### Example ```javascript function save(){ //특정행은 저장시 서버로 전송 제외하기 var rows = sheet.getDataRows(); for(var i = 0; i < rows.length; i++){ if (rows[i][\"CHK\"] == 0 && rows[i][\"UpYEAR\"] < 2018) { rows[i][\"NoUpload\"] = 1; } } //저장함수 호출 sheet.doSave(url); } ```",
              "see": [
                {
                  "label": "doSave method",
                  "url": "/docs/funcs/core/do-save"
                },
                {
                  "label": "getSaveString method",
                  "url": "/docs/funcs/core/get-save-string"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/no-upload.html"
          },
          {
            "cid": 262,
            "sid": "row-merge",
            "name": "row-merge",
            "label": "RowMerge",
            "data": {
              "body": "> 데이터 영역/헤더 영역에서 값 기준 병합 실행([DataMerge](/docs/props/cfg/data-merge), [HeaderMerge](/docs/props/cfg/header-merge))시 해당 행에 대해서 `병합할지 여부`를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|해당 행을 병합 대상에 포함하지 않습니다.| |`1(true)`|해당 행을 병합 대상에 포함합니다. (`default`)| ### Example ```javascript //특정행을 병합하지 않음. var row = sheet.getFirstVisibleRow(); row[\"RowMerge\"] = false; sheet.setAutoMerge( {dataMerge: 1, headerMerge: 0, prevColumnMerge: 0} ); // 첫번 째 헤더행을 병합하지 않음. var header = sheet.getHeaderRows()[0]; header[\"RowMerge\"] = false; ```",
              "see": [
                {
                  "label": "ColMerge col",
                  "url": "/docs/props/col/col-merge"
                },
                {
                  "label": "ColMerge cell",
                  "url": "/docs/props/cell/col-merge"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/header-merge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/row-merge.html"
          },
          {
            "cid": 263,
            "sid": "selected",
            "name": "selected",
            "label": "Selected",
            "data": {
              "body": "> 행을 선택합니다. > 속성을 `1(true)`로 설정하면 [getSelectedRows()](/docs/funcs/core/get-selected-rows)를 통해 선택한 행을 얻을 수 있습니다. > [SelectingCells cfg](/docs/props/cfg/selecting-cells) 속성에 따라 선택한 행을 표시하거나 무시할 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|선택 해제| |`1(true)`|<span class='optional'>선택</span>| ### Example ```javascript //특정 행을 선택한다. var row = sheet.getRowById(\"AR55\"); row[\"Selected\"] = 1; ```",
              "see": [
                {
                  "label": "SelectingCells cfg",
                  "url": "/docs/props/cfg/selecting-cells"
                },
                {
                  "label": "getSelectedRows method",
                  "url": "/docs/funcs/core/get-selected-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/selected.html"
          },
          {
            "cid": 264,
            "sid": "show-hint",
            "name": "show-hint",
            "label": "ShowHint",
            "data": {
              "body": "> 힌트는 열의 너비보다 셀의 내용이 많은 경우, 마우스 커서가 해당 셀 위에 오버시 해당 셀의 너비를 늘려 내용을 보여주는 기능입니다. > 행 단위로 힌트기능을 활성화 할지 여부를 설정하며, 체크박스나 라디오 형태의 열에서는 작동하지 않습니다. ### ![힌트활성화](/assets/imgs/hint1.png \"마우스 커서가 셀에 올라갔을때 힌트를 통해 감춰진 부분이 보여짐\") ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|힌트 기능을 사용안함| |`1`|셀의 크기가 작아 셀의 내용의 일부만 보여질때 동작 (`default`)| |`2`|1번 옵션과 더불어 스크롤이 있는 시트에서 셀이 하단에 있어 내용의 아래부분이 안보여질때 힌트 동작| |`3`|일반적으로는 힌트 기능이 동작하지 않고 [onShowHint](/docs/events/on-show-hint) 이벤트를 통해서만 동작(이벤트를 통해 힌트에 어떤 내용이 보여지게 할지 설정 가능)| ### Example ```javascript //10번 행에 대해서는 Hint 기능 제거. var row = sheet.getRowById(\"AR10\"); row[\"ShowHint\"] = 0; sheet.refreshRow(row); //조회 데이터에서 일부 행에 대해 Hint 기능 제거 {\"data\":[ {\"ShowHint\": 0, \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "onShowHint event",
                  "url": "/docs/events/on-show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/show-hint.html"
          },
          {
            "cid": 265,
            "sid": "sort-icons-2",
            "name": "sort-icons",
            "label": "SortIcons",
            "data": {
              "body": "> 정렬 아이콘의 화면 표시여부와 동작을 설정합니다. > 해당 기능과 [SortIcons cfg](/docs/props/cfg/sort-icons)를 같이 사용하는 경우 옵션 `0`은 해당 옵션이 적용되고, 옵션 `1, 2`는[SortIcons cfg](/docs/props/cfg/sort-icons)이 적용됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`| 아이콘이 모두 숨겨지고 정렬 불가 | |`1`| 모든 정렬 아이콘 표시(정렬되기 전에는 .IBSort0Right 이미지가 표시) , `MultiRecord`에서는 사용 불가 | |`2`| 정렬한 열에만 아이콘이 표시됨 (`default`) | ### Example ```javascript options.Def.Header = { SortIcons: 1 // 모든 정렬 아이콘 표시 }; ```",
              "see": [
                {
                  "label": "SortIcons cfg",
                  "url": "/docs/props/cfg/sort-icons"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/sort-icons.html"
          },
          {
            "cid": 266,
            "sid": "sort-pos",
            "name": "sort-pos",
            "label": "SortPos",
            "data": {
              "body": "> 소팅시 지정한 행의 위치를 고정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`양수`|위에서부터 순서대로 원하는 `SortPos`가 지정된 행들 가운데 지정한 순번에 위치하게 됩니다. 가령 `2`로 설정하면 헤더 아래 `SortPos`가 설정된 행들 중에 두번째 행에 고정됩니다. 만약 `SortPos`를 지정한 행이 하나밖에 없다면 첫번째 행에 위치하게 됩니다.| |`음수`|아래에서부터 순서대로 원하는 인덱스에 위치하게 됩니다. 가령 `1`로 설정하면 맨 아래 행에 고정됩니다.| ### Example ```javascript //지정한 행들을 소팅시 최상단에 위치시킨다. var row = sheet.getFocusedRow(); row[\"SortPos\"] = 1; ```",
              "see": [
                {
                  "label": "CanSort col",
                  "url": "/docs/props/col/can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/sort-pos.html"
          },
          {
            "cid": 267,
            "sid": "spanned",
            "name": "spanned",
            "label": "Spanned",
            "data": {
              "body": "> 행 내에서 좌우 열간에 병합을 허용할지 여부를 설정합니다.(좌우로 머지) > `Def.Row` 나 `Def.Header`에서 설정하시면 헤더 영역이나 데이터 영역에서 Span 속성을 통해 좌우의 셀을 병합하실 수 있습니다. > 셀머지 기능 사용시 자동머지 기능과는 별도로 움직임으로 자동머지 기능을 꺼주셔야합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|Span(좌우병합) 허용하지 않음 (`default`)| |`1(true)`|Span(좌우병합) 허용| ### Example ![Spanned](/assets/imgs/headerMerge.png \"Spanned\") ```javascript //헤더 행에 대해 좌우로 병합 options.Def.Header = {Spanned:true}; opiotns.Cfg = { HeaderMerge: 0 // 자동머지 끔 }; options.Cols = [ {Header:[{Value:\"(행사)매출실적\",Span:4,Align:\"Center\"},{Value:\"1월\"}],Name:\"Col1\"}, {Header:[{},{Value:\"2월\"}],Name:\"Col2\"}, {Header:[{},{Value:\"3월\"}],Name:\"Col3\"}, {Header:[{},{Value:\"4월\"}],Name:\"Col4\"}, ]; ```",
              "see": [
                {
                  "label": "Spanned col",
                  "url": "/docs/props/col/spanned"
                },
                {
                  "label": "Span cell",
                  "url": "/docs/props/cell/span"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/spanned.html"
          },
          {
            "cid": 268,
            "sid": "text-color",
            "name": "text-color",
            "label": "TextColor",
            "data": {
              "body": "> 지정한 행의 글자색을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|HEX형식 (ex:#FF00F0) rgb형식 (ex:rgb(244,200,40)| ### Example ```javascript //특정행의 글자를 붉은색으로 지정합니다.. var row = sheet.getRowById(\"AR33\"); row[\"TextColor\"] = \"#FF0000\"; sheet.refreshRow(row); //조회 데이터에서 특정행에 대해 글자를 파란색으로 표시한다. {\"data\":[ ... {\"TextColor\": \"#0000FF\", \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "TextStyle row",
                  "url": "./text-style"
                },
                {
                  "label": "TextSize row",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont row",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/text-color.html"
          },
          {
            "cid": 269,
            "sid": "text-font",
            "name": "text-font",
            "label": "TextFont",
            "data": {
              "body": "> 특정행의 `font-family`를 설정합니다. > 여러개 폰트를 지정하거나 폰트에 띄어씌기가 들어가는 경우에는 `single(')/double quotation(\"\")`으로 지정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|글자체| ### Example ```javascript //특정행의 글자체를 수정합니다. var row = sheet.getRowById(\"AR33\"); row[\"TextFont\"] = '\"Times New Roman\", \"Gungsuh\", \"Helvetica\"'; sheet.refreshRow(row); //조회 데이터에서 특정행에 대해 글자체를 변경합니다. {\"data\":[ ... {\"TextFont\": \"Gulim\", \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "TextStyle row",
                  "url": "./text-style"
                },
                {
                  "label": "TextColor row",
                  "url": "./text-color"
                },
                {
                  "label": "TextSize row",
                  "url": "./text-size"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/text-font.html"
          },
          {
            "cid": 270,
            "sid": "text-size",
            "name": "text-size",
            "label": "TextSize",
            "data": {
              "body": "> 지정한 행의 글자 크기를 설정합니다. > `px, pt, em` 단위를 사용할 수 있으며, 단위를 지정하지 않으면 px기준으로 설정됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|크기숫자와 단위로 이루어진 문자열(ex: 25px)| ### Example ```javascript //특정행의 글자를 1.2em 지정합니다. var row = sheet.getRowById(\"AR33\"); row[\"TextSize\"] = \"1.2em\"; sheet.refreshRow(row); //조회 데이터에서 특정행에 대해 글자를 27px로 지정합니다. {\"data\":[ ... {\"TextSize\": \"27px\", \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "TextStyle row",
                  "url": "./text-style"
                },
                {
                  "label": "TextColor row",
                  "url": "./text-color"
                },
                {
                  "label": "TextFont row",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/text-size.html"
          },
          {
            "cid": 271,
            "sid": "text-style",
            "name": "text-style",
            "label": "TextStyle",
            "data": {
              "body": "> 지정한 행의 글자에 대한 `font-weight, font-style, font-variant, text-decoration`를 숫자로 설정합니다. > 숫자를 서로 더해서 여러 속성을 동시에 적용하 실 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`1`| 굵게 Bold| |`2`| 기울임 Italic| |`4`| 밑줄 Underline| |`8`| 취소선 Strike| |`16`| 윗줄 Overline| |`32`| 작은 대문자 Small Caps| ### Example ```javascript //특정행의 글자를 굵고 취소선이 들어가게 수정한다. var row = sheet.getRowById(\"AR33\"); row[\"TextStyle\"] = 9; sheet.refreshRow(row); //조회 데이터에서 특정행에 대해 기울임이면서 밑줄을 표시한다. {\"data\":[ {\"TextStyle\": 6, \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "TextColor row",
                  "url": "./text-color"
                },
                {
                  "label": "TextSize row",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont row",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/text-style.html"
          },
          {
            "cid": 272,
            "sid": "tip-class",
            "name": "tip-class",
            "label": "TipClass",
            "data": {
              "body": "> 풍선도움말 객체에 원하는 `css클래스`를 적용하여 디자인을 설정 합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|풍선도움말 객체에 적용할 css클래스 명| ### Example ```css <style> .RedBold{color:red;font-weight:700;} .deepblue{color:#020079;} </style> ``` ```javascript //특정 행에 풍선도움말 표시시 사용될 클레스를 설정. var row = sheet.getRowById(\"AR55\"); row[\"TipClass\"] = \"RedBold\"; //조회 데이터에서 일부 행에 대해 풍선도움말 클레스를 설정. {\"data\":[ {\"TipClass\":\"deepblue\",\"ColName1\":\"Value1\",\"ColName2\":\"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "Tip row",
                  "url": "./tip"
                },
                {
                  "label": "TipPosition row",
                  "url": "./tip-position"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/tip-class.html"
          },
          {
            "cid": 273,
            "sid": "tip-position",
            "name": "tip-position",
            "label": "TipPosition",
            "data": {
              "body": "> 풍선도움말 객체의 위치나 크기, 정렬을 설정합니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`X`|풍선도움말의 X축 가감 위치| |`Y`|풍선도움말의 Y축 가감 위치| ### Example ```javascript //마지막 행에 풍선도움말 위치 변경 var row = sheet.getLastVisibleRow(); row[\"TipPosition\"] = {Y:-100}; ```",
              "see": [
                {
                  "label": "Tip row",
                  "url": "./tip"
                },
                {
                  "label": "TipClass row",
                  "url": "./tip-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/tip-position.html"
          },
          {
            "cid": 274,
            "sid": "tip",
            "name": "tip",
            "label": "Tip",
            "data": {
              "body": "> 행 위에 마우스 커서 오버시 풍선도움말을 표시합니다. > 설정을 통해 풍선도움말 사용 여부와 풍선도움말에서 표시될 내용까지 설정할 수 있습니다. ### ![Tip](/assets/imgs/tip.png \"Tip 사용\") ### Type `mixed`( `boolean` \\| `string`) ### Options |Value|Description| |-----|-----| |`0(false)`|풍선도움말 사용 안함| |`1(true)`|풍선도움말 사용| |`string`|풍선도움말에서 표시 될 내용 설정| ### Example ```javascript //55번 행에 마우스 커서 오버시 풍선 도움말에 표시될 내용을 변경. var row = sheet.getRowById(\"AR55\"); row[\"Tip\"] = \"해당 건은 결제가 완료되었습니다.\"; //조회 데이터에서 일부 행에 대해 풍선도움말 기능을 제거. {\"data\":[ {\"Tip\": 0, \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "TipClass row",
                  "url": "./tip-class"
                },
                {
                  "label": "TipPosition row",
                  "url": "./tip-position"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/tip.html"
          },
          {
            "cid": 275,
            "sid": "v-align",
            "name": "v-align",
            "label": "VAlign",
            "data": {
              "body": "> 행 전체의 문자열 상하 정렬을 설정합니다. > 좌우 정렬과 관련해서는 [Align](./align)속성을 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`Top`|문자열 상단 정렬 (Top, TOP, top 허용)| |`Middle`|문자열 중단 정렬 (Middle, MIDDLE, middle 허용)| |`Bottom`|문자열 하단 정렬 (Bottom, BOTTOM, bottom 허용) ### Example ```javascript //특정행의 문자열을 상단 정렬 var row = sheet.getFirstVisibleRow(); row[\"VAlign\"] = \"Top\"; sheet.refreshRow(row); //합계 행의 문자열을 하단 정렬. options.Def.Footer = {\"VAlign\": \"Bottom\"}; ```",
              "see": [
                {
                  "label": "Align row",
                  "url": "./align"
                },
                {
                  "label": "VAlign col",
                  "url": "/docs/props/col/v-align"
                },
                {
                  "label": "VAlign cell",
                  "url": "/docs/props/cell/v-align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/v-align.html"
          },
          {
            "cid": 276,
            "sid": "visible",
            "name": "visible",
            "label": "Visible",
            "data": {
              "body": "> 행의 보임/감춤 여부를 설정합니다. > 필터를 통해 감춰지는 행은 자동으로 `Visible: (0)false` 속성이 설정됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|감춰짐| |`1(true)`|보임| ### Example ```javascript //Chk열의 값이 1인 행들을 감춘다. var rows = sheet.getDataRows(); for(var i = 0; i < rows.length; i++){ if (rows[i][\"Chk\"] == 1) { //속성 값을 바꾼다고 즉시 행이 감춰지는 것은(렌더링이 일어나는 것은) 아님. rows[i][\"Visible\"] = 0; } } sheet.renderBody(); //감춘 행을 화면에 반영(렌더링) //조회 데이터에서 특정행을 감춘다. {\"data\":[ ... {\"Visible\": 0, \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "Hidden row",
                  "url": "./hidden"
                },
                {
                  "label": "hideRow method",
                  "url": "/docs/funcs/core/hide-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/visible.html"
          },
          {
            "cid": 277,
            "sid": "wrap",
            "name": "wrap",
            "label": "Wrap",
            "data": {
              "body": "> 셀의 내용이 열의 너비보다 많은 경우 줄넘김을 통해 표현할지 여부를 설정합니다.(css의 white-space속성) > 줄넘김이 발생할때 행의 높이가 자동으로 조절됩니다. > 일반적으로 `Text` 타입에서 사용하며, `Radio` 타입에서도 사용하실 수 있습니다. > [Lines 타입](/docs/appx/type) 컬럼에서는 `default: 1(true)`로 설정됩니다. ### ![Wrap:0(false)](/assets/imgs/wrap0.png \"Wrap:0(false) 설정시\") [`Wrap:0(false)` 설정시] ![Wrap:1(true)](/assets/imgs/wrap1.png \"Wrap:1(true) 설정시\") [`Wrap:1(true)` 설정시] ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|줄넘김 사용 안함 (`white-space:nowrap`)| |`1(true)`|줄넘김 사용 (`white-space:normal`)| ### Example ```javascript //특정행에 Wrap를 허용 var row = sheet.getRowById(\"AR33\"); row[\"Wrap\"] = 1; sheet.refreshRow(row); //전체 데이터 행에 대해 줄넘김 허용. options.Def.Row = {\"Wrap\": 1}; ```",
              "see": [
                {
                  "label": "TextStyle row",
                  "url": "./text-style"
                },
                {
                  "label": "TextColor row",
                  "url": "./text-color"
                },
                {
                  "label": "TextFont row",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/row/wrap.html"
          }
        ]
      },
      {
        "gid": 3,
        "name": "props-col",
        "label": "Col",
        "children": [
          {
            "cid": 278,
            "sid": "accept-enters",
            "name": "accept-enters",
            "label": "AcceptEnters",
            "data": {
              "body": "> `Lines` 타입에서 편집중 `Enter키` 입력시 동작에 대해 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|값 변경 마치고, 편집모드 종료 (`default`)| |`1`|줄넘김문자가 삽입되고 편집모드 유지 `Ctrl or Shift or Alt + Enter`를 입력하거나 `tab키`를 입력 시 편집 종료| |`2`|값 변경을 마치고, 편집모드 종료 `Ctrl or Shift or Alt + Enter`를 입력하여 줄넘김 가능| |`3`|`Ctrl or Shift or Alt + Enter` 나 그냥 `Enter`나 모두 줄넘김문자가 삽입됨 `tab키`를 누르거나 마우스로 `다른 셀을 클릭` 시 편집 종료| ### Example ```javascript //편집중 Enter키 입력시 줄넘김으로 동작 options.Cols = [ ... {Type: \"Lines\", AcceptEnters: 1, Name: \"CarName\", Width: 120, ...}, ... ]; ```",
              "see": [
                {
                  "label": "EnterMode cfg",
                  "url": "/docs/props/cfg/enter-mode"
                },
                {
                  "label": "AcceptEnters cell",
                  "url": "/docs/props/cell/accept-enters"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/accept-enters.html"
          },
          {
            "cid": 279,
            "sid": "accept",
            "name": "accept",
            "label": "Accept",
            "data": {
              "body": "> [File Type](/docs/appx/file-type-upload) 컬럼에 업로드를 허용할 파일 형식을 지정하는 속성입니다. > `input type=\"file\"` 의 accept 속성과 동일하게 동작합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|[File Type](/docs/appx/file-type-upload) 컬럼에 업로드를 허용할 파일 형식을 지정| ### Example ```javascript // Type: File인 컬럼에 이미지 파일만 업로드 하도록 설정 options.Cols = [ ... {Type: \"File\", Name: \"CarName\", Width: 120, Accept: 'image/*' ...}, ... ]; ```",
              "see": [
                {
                  "label": "File Type 업로드",
                  "url": "/docs/appx/file-type-upload"
                },
                {
                  "label": "Accept Cell",
                  "url": "/docs/props/cell/accept"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/accept.html"
          },
          {
            "cid": 280,
            "sid": "add-edit",
            "name": "add-edit",
            "label": "AddEdit",
            "data": {
              "body": "> 행의 상태가 추가([Added](/docs/props/row/added))인 행의 컬럼의 편집([CanEdit](/docs/props/row/can-edit)) 가능 여부를 설정합니다. > 조회시에는 편집 불가, 행 추가 후 데이터 편집 가능, 저장 후 편집 불가를 설정하고 싶다면 [ChangeEdit](/docs/props/col/change-edit) 를 함께 설정해주어야 합니다. > `주의` 해당 속성을 설정하게 되면, `(Cell,Row,Col)CanEdit` 설정 속성은 무시됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|행의 상태가 Added(추가) 일 경우 해당 컬럼 편집 불가| |`1(true)`|행의 상태가 Added(추가) 일 경우 해당 컬럼 편집 가능| ### Example ```javascript //addRow 를 통하여 추가된 행에 대해서는 AMT 컬럼의 편집을 막음 options.Cols = [ ... {Type: \"Int\", AddEdit: 0, Name: \"AMT\", Width: 120 ...}, ... ]; // 데이터 조회시 AMT 컬럼의 편집을 막고, addRow 를 통하여 추가한 경우에는 편집 가능, 저장 후 편집 불가로 설정 options.Cols = [ ... {Type: \"Int\", AddEdit: 1, ChangeEdit:0, Name: \"AMT\", Width: 120 ...}, ... ]; ``` ### Try it - [Demo of AddEdit](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/AddEdit/)",
              "see": [
                {
                  "label": "CanEdit col",
                  "url": "/docs/props/col/can-edit"
                },
                {
                  "label": "CanEdit row",
                  "url": "/docs/props/row/can-edit"
                },
                {
                  "label": "ChangeEdit col",
                  "url": "/docs/props/col/change-edit"
                },
                {
                  "label": "Added row",
                  "url": "/docs/props/row/added"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.87|기능 추가|"
            },
            "url": "docs/props/col/add-edit.html"
          },
          {
            "cid": 281,
            "sid": "align-2",
            "name": "align",
            "label": "Align",
            "data": {
              "body": "> 문자열 좌우 정렬을 설정합니다. > 트리 또는 그룹에서 사용할 때는 기준으로 지정된 컬럼(**트리의 접힘/펼침 아이콘이 보이는 컬럼**)의 데이터영역은 `Align`이 먹지 않습니다. > 상하 정렬과 관련해서는 [VAlign](./v-align)속성을 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`Left`|문자열 좌측 정렬| |`Center`|문자열 가운데 정렬| |`Right`|문자열 우측 정렬| ### Example ```javascript //특정 열의 문자열을 가운데 정렬로 설정 options.Cols = [ {Type: \"Int\", Name: \"Seq\", Align: \"Center\", Width: 70, ...}, {Type: \"Date\", Name: \"enterDate\", Align: \"Center\", Width: 120, ...}, {Type: \"Text\", Name: \"sa_Nm\", Align: \"Center\", Width: 100, ...}, ... ]; ```",
              "see": [
                {
                  "label": "VAlign col",
                  "url": "./v-align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/align.html"
          },
          {
            "cid": 282,
            "sid": "all-check-ignore-event",
            "name": "all-check-ignore-event",
            "label": "AllCheckIgnoreEvent",
            "data": {
              "body": "> Type: \"Bool\" 헤더 전체 체크/언체크 시에 `onAfterChange` 이벤트를 호출할지 말지 설정하는 옵션입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|`onAfterChange` 이벤트가 발생합니다. (`default`)| |`1(true)`|`onAfterChange` 이벤트가 발생하지 않습니다.| ### Example ```javascript options.Cols = [ ... //헤더의 전체 체크박스를 클릭할시 onAfterChange이벤트가 발생하지 않습니다. {Header: {Value: \"주관부서\", HeaderCheck: 1}, Type: \"Bool\", Width: 80, Align: \"Center\", Name:\"ORG_NM\", AllCheckIgnoreEvent:1} ... ]; ```",
              "see": [
                {
                  "label": "setAllCheck method",
                  "url": "/docs/funcs/core/set-all-check"
                },
                {
                  "label": "onAfterChange event",
                  "url": "/docs/events/on-after-change"
                },
                {
                  "label": "onCheckAllFinish event",
                  "url": "/docs/events/on-check-all-finish"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.15|기능 추가|"
            },
            "url": "docs/props/col/all-check-ignore-event.html"
          },
          {
            "cid": 283,
            "sid": "attribute-formula-2",
            "name": "attribute-formula",
            "label": "attribute+Formula",
            "data": {
              "body": "> 열의 각종 속성(`CanEdit, TextColor` 등)을 `Formula`를 통해 설정할 수 있습니다. > 가령 `CanEdit, Color` 등과 같은 속성을 `Formula`로 지정하여 설정한다는 것은 다음과 같이 선언될 수 있습니다. > ```js > options.Cols = [ > {Type:\"Text\", Name:\"Total\", > CanEditFormula:\"CHK==1&&AMT>10?1:0\", > ColorFormula:\"Value>10000 ? '#FF0000':'#FFFF00'\", > FormatFormula:function(param){ > if(param.Row[\"SaupJuminNo\"].length == 10){ > return \"###-##-#####\"; > }else{ > return \"######-#######\"; > } > } > } > ]; > ``` > `※**매우중요**` > 1. 모든 포뮬러 기능을 사용시에는 (row)[**CanFormula**](/docs/props/row/can-formula)가 1로 설정되어야 동작합니다. > 2. `attribute+Formula` 사용시에는 반드시 (row)[**CalcOrder**](/docs/props/row/calc-order)에 `열이름+기능명` 형식으로 포뮬러별 계산 순서가 정의되어야 합니다. >가령 \"A\"열에 대해 `CanEdit`속성 포뮬러를 설정하고 \"B\"열에 대해 `Color`속성 포뮬러를 설정했다면, [**CalcOrder**](/docs/props/row/calc-order)에는 \"ACanEdit,BColor\"로 명시하면 됩니다. > 3. **`CalcOrder` 설정시 이름들은 반드시 띄어쓰기 없이 서로 붙여 작성해주셔야 됩니다. 이름들 간에 띄어쓰기가 되어 있는 경우 Formula 동작이 정상적으로 이뤄지지 않습니다.** ### Type mixed( `function` \\| `string` ) ### Options |Value|Description| |-----|-----| |`string`|열이름을 기준으로 한 계산 로직 (ex: `\"sCount \\* sPrice - ( Discount \\* Rate ) \\* 1.24\"`)| |`function`|별도 함수를 통해 계산 가능(함수 내에서는 `Sheet`,`Row`,`Col`,`Attr` 예약어를 통해 접근 가능)| ### Example ```javascript // formula 사용시 CanFormula:1이 설정 되어야 하고, attribute+Formula사용시에는 CalcOrder도 설정되어야 함 options.Def.Row = { CanFormula: 1, CalcOrder: \"yearSumColor,rateCanEdit\" // 열이름 간에 띄어쓰지말고 전부 붙여쓰셔야 합니다. }; options.Cols = [ ... {Type: \"Bool\" Name: \"CHK\"}, // 해당 열의 값이 100보다 큰 경우 붉은색 그렇지 않은 경우 옅은노란색으로 배경색이 자동 변경 {Type: \"Int\", Name: \"yearSum\", ColorFormula:function(fr){ return fr.Value>100?'#FF0000':'#FFFFAA'; } }, // CHK 열이 체크되어있고, yearSum열의 값이 150보다 큰 경우에만 편집이 가능 {Type: \"Float\", Name: \"rate\", CanEditFormula:function(fr) { if (fr.Row[\"CHK\"] == 1 && fr.Row[\"yearSum\"] > 150) return true; else return false; } }, ... ]; ``` ### Try it - [Demo of attribute+Formula](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/attributeFormula/)",
              "see": [
                {
                  "label": "CanFormula row",
                  "url": "/docs/props/row/can-formula"
                },
                {
                  "label": "CalcOrder row",
                  "url": "/docs/props/row/calc-order"
                },
                {
                  "label": "attribute+formula row",
                  "url": "/docs/props/row/attribute-formula"
                },
                {
                  "label": "Formula appendix",
                  "url": "/docs/appx/formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/attribute-formula.html"
          },
          {
            "cid": 284,
            "sid": "auto-calendar-2",
            "name": "auto-calendar",
            "label": "AutoCalendar",
            "data": {
              "body": "> [Type](/docs/appx/type)이 Date인 셀에 대해 사용자가 편집모드로 들어갈때 달력을 띄울지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|편집시 달력을 띄움| ### Example ```javascript //AutoCalendar적용 options.Cols = [ ... {Type: \"Date\", Name: \"sa_enterDate\", Format: 'MM-dd-yyyy HH:mm', AutoCalendar: 1, ...}, ... ]; ```",
              "see": [
                {
                  "label": "AutoCalendar cfg",
                  "url": "/docs/props/cfg/auto-calendar"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/auto-calendar.html"
          },
          {
            "cid": 285,
            "sid": "bool-group",
            "name": "bool-group",
            "label": "BoolGroup",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool`인 열 내에서 동일 그룹으로 묶을지 여부를 설정합니다. > 입력하는 숫자가 그룹에 인덱스가 되어 같은 값을 갖고있는 셀 간에는 하나만 체크가 됩니다.(마치 라디오처럼 체크될때 따른 셀은 자동으로 언체크 됩니다.) > 따라서 컬럼에 `BoolGroup`을 설정할 경우 컬럼 전체가 같은 `BoolGroup` 값을 가지게 되면서 컬럼 전체 중 하나의 셀만 체크됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|라디오처럼 하나로 묶을 그룹 인덱스| ### Example ```javascript //열 내에서 단일 셀만 체크 가능하게 합니다. options.Cols = [ ... {Type: \"Bool\", Name: \"st1\", BoolGroup: 1, ...}, ... ]; ```",
              "see": [
                {
                  "label": "BoolGroup cell",
                  "url": "/docs/props/cell/bool-group"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/bool-group.html"
          },
          {
            "cid": 286,
            "sid": "bool-icon",
            "name": "bool-icon",
            "label": "BoolIcon",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool`인 열에서 체크/언체크 아이콘을 다른 이미지나 Html 객체로 설정합니다. > 임의의 이미지를 체크박스 아이콘으로 사용하고자 하는 경우에는, 언체크 이미지와 체크 이미지를 첫글자를 구분자로 하여 연결된 문자열로 설정하시면 됩니다. (ex:\"|Off.gif|On.gif\") > > 임의의 이미지를 체크박스 아이콘으로 사용할 때, 해당 열내의 셀이 편집불가([CanEdit](./can-edit))인 경우가 있다면 편집 불가일때의 이미지까지해서 총 4개의 이미지를 설정하시면 됩니다. (ex:\"|Off.gif|On.gif|OffReadOnly.gif|OnReadOnly.gif\") > > 여러개의 라디오 아이콘을 사용하고자 하는 경우에는 언체크 이미지와 체크이미지를 이어서 설정하시면 됩니다. (ex:\"|Off1.gif|On1.gif|Off2.gif|On2.gif|Off3.gif|On3.gif\") > > 그 외에 일반적인 숫자형식으로 아래 `Options`에서와 같이 기능을 설정하실 수 있습니다. ### Type mixed( `string` \\| `number`) ### Options |Value|Description| |-----|-----| |`0`|기본적인 내장 체크박스 이미지를 사용 (`default`) |`1`|내장 라디오 이미지를 사용| |`2`|무조건 middle 정렬되는 체크박스 이미지를 사용(**성능이 0번 옵션보다 느림**)| |`3`|무조건 middle 정렬되는 라디오 이미지를 사용(**성능이 1번 옵션보다 느림**)| |`4`|\\<input type=\"checkbox\">객체를 사용(**IE에서 성능이 좋음**)| |`5`|\\<input type=\"radio\">객체를 사용(**IE에서 성능이 좋음**)| |`6`|div객체를 이용하여 체크박스를 구현(**IE 호환성 보기에서 성능이 좋음**)| ### Example ```javascript //html객체로 체크박스 표현 options.Cols = [ ... {Type: \"bool\", Name: \"accept\", BoolIcon: 4 ...}, ... ]; ```",
              "see": [
                {
                  "label": "BoolIconWidth col",
                  "url": "./bool-icon-width"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/bool-icon.html"
          },
          {
            "cid": 287,
            "sid": "break-point",
            "name": "break-point",
            "label": "BreakPoint",
            "data": {
              "body": "> 언어팩에 있는 `BreakPoints` 수치 기준보다 더 작을시 hide 할지 말지 정하는 기능입니다. > 설정한 `BreakPoint` 와 시트 태그 사이즈를 비교하여 태그 사이즈 보다 작을시 `hide`, 클시 `show` 되는 기능입니다. > 해당 기능 설정시 설정되는 `Visible` 속성은 무시됩니다. 사이즈 변경이 필요할시에는 언어팩에 수치를 직접 변경하시면 됩니다. **아래는 언어팩에서 제공하는 BreakPoints 에 기본 수치입니다.** ```js \"BreakPoints\": { \"xs\": 0, \"sm\": 576, \"md\": 768, \"lg\": 992, \"xl\": 1200, \"xxl\": 1400 } ``` ### Type `string` ### Options |Value|Description| |-----|-----| |`xs`|태그 사이즈가 `xs` 수치보다 작으면 `hide`, 크면 `show`| |`sm`|태그 사이즈가 `sm` 수치보다 작으면 `hide`, 크면 `show`| |`md`|태그 사이즈가 `md` 수치보다 작으면 `hide`, 크면 `show`| |`lg`|태그 사이즈가 `lg` 수치보다 작으면 `hide`, 크면 `show`| |`xl`|태그 사이즈가 `xl` 수치보다 작으면 `hide`, 크면 `show`| |`xxl`|태그 사이즈가 `xxl` 수치보다 작으면 `hide`, 크면 `show`| ### Example ```javascript //html객체로 체크박스 표현 options.Cols = [ ... {Type: \"Text\", Name: \"BreakColA\", BreakPoint: \"md\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "HideMobile col",
                  "url": "/docs/props/col/hide-mobile"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.24|기능 추가|"
            },
            "url": "docs/props/col/break-point.html"
          },
          {
            "cid": 288,
            "sid": "button-text",
            "name": "button-text",
            "label": "ButtonText",
            "data": {
              "body": "> [Button](./button)속성의 값이 `Button`이거나 `Html`인 경우, 셀 버튼에 표시할 문자를 설정합니다. > [Button](./button)속성의 값이 `Button`인 경우에는 설정한 문자가 \\<u>나 \\<button>태그로 표시되며, `Html`인 경우에는 <span>입력</span>식의 Html 문자가 해석되어 셀에 표시됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|버튼에 들어갈 문자열| ### Example ```javascript options.Cols = [ ... //셀 우측에 \"확인\"버튼을 표시한다. {Type: \"Text\", Button: \"Button\", ButtonText: \"확인\", Name: \"conf_btn\", Width: 120, ... }, ... //버튼 타입에 \"BTN\"버튼을 표시한다. { Type: \"Button\", ButtonText: \"BTN\", Name: \"type_btn\", Width: 120, ... }, ]; ```",
              "see": [
                {
                  "label": "Button col",
                  "url": "./button"
                },
                {
                  "label": "UseButton cfg",
                  "url": "/docs/props/cfg/use-button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/button-text.html"
          },
          {
            "cid": 289,
            "sid": "button-width-2",
            "name": "button-width",
            "label": "ButtonWidth",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Button`이고, [Button](./button)속성의 값이 `Button`인 경우, 셀에 생성되는 버튼 객체의 너비를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|버튼 객체의 너비| ### Example ```javascript //버튼의 너비를 80px로 설정 options.Cols = [ ... {Type: \"Button\", Button: \"Button\", Name: \"btn1\", ButtonWidth: 80 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Button col",
                  "url": "./button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/button-width.html"
          },
          {
            "cid": 290,
            "sid": "button",
            "name": "button",
            "label": "Button",
            "data": {
              "body": "> 셀의 우측에 원하는 아이콘 이미지,체크박스 혹은 버튼을 표시하는 기능입니다. > 열의 [Type](/docs/appx/type)이 `Date`거나 `Enum`인 경우에는 설정과 상관없이 달력이나 드롭다운 모양의 버튼이 표시됩니다. > 열의 타입이 `Button`인 경우에는 셀 버튼에 대한 기능으로 동작하게 됩니다. > *셀의 좌측에 버튼을 설정하고자 할때는 [Icon](./icon)속성을 확인하세요.* ### ![Button속성](/assets/imgs/button1.png \"Button속성\") [그림1] ![Button속성](/assets/imgs/button2.png \"Button속성\") [그림2] ![Button속성](/assets/imgs/button3.png \"Button속성\") [그림3] ![Button속성](/assets/imgs/buttonDefaults.png \"Button속성\") [그림4] ### Type `string` ### Options **열의 Type이 Button이 아닌 경우** |Value|Description| |-----|-----| |`Button`|[ButtonText](./button-text) 속성을 통해 설정한 문자를 \\<u>태그를 통해 보여줍니다.| |`Clear`|셀 우측에 셀 내용을 지우기위한 버튼이 표시됩니다. [그림1] 참고| |`Check`|셀 우측에 체크박스를 표시합니다. [그림2] 참고| |`Html`|[ButtonText](./button-text) 속성으로 원하는 HTML태그를 넣으면 셀 우측에 표시됩니다.| |`공백`|원래 보여져야 하는 버튼 이미지를 감춥니다. 가령 `Date` 타입 열은 기본적으로 달력버튼이 표시되는데 이 속성을 이용하여 버튼을 감출수 있습니다.| |`기타`|이미지 파일에 대한 url을 넣으면 버튼 셀의 배경으로 이미지가 표시됩니다. [그림3] 참고 (이미지는 gif, png, jpg만 가능 / 클릭시 onButtonClick이벤트가 호출)| |`Defaults`|셀 우측에 [Defaults](./defaults) 버튼을 표시합니다. [그림4] 참고| ***Html이나 이미지 버튼을 사용시 버튼의 너비는 [WidthPad](./width-pad)속성을 통해 설정할수 있습니다.*** **열의 Type이 Button인 경우** |value|desc| |---|---| |`Button`|일반적인 버튼 형태로 보여줍니다. [UseButton](/docs/props/cfg/use-button)속성의 값에 따라 셀의 값을 \\<u>태그 또는 \\<button>태그로 만들어 줍니다.| |`Html`|속성을 `Html`로 설정하고 셀의 값을 `Html` 형태로 사용하실 수 있습니다. (ex: <div class=\"button>버튼\\</div>)| ### Example ```javascript options.Cols = [ ... //셀의 우측에 체크박스를 표시 {Type: \"Text\", Name: \"product_name\", Button: \"Check\", Width: 120 ...}, //셀의 우측에 이미지로 버튼을 추가합니다. {Type: \"Text\", Name: \"brnSaleAmt\", Button: \"/pcd/img/popIcon.png\", Width: 120 ...}, ... //타입에 버튼을 설정 {Type: \"Button\", Name: \"btn_type\", ButtonText: \"Btn\", Width: 120, \"WidthPad\": 50 ...}, ... ]; ``` ### Try it - [Demo of Button](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/Button/)",
              "see": [
                {
                  "label": "WidthPad col",
                  "url": "./width-pad"
                },
                {
                  "label": "ButtonText col",
                  "url": "./button-text"
                },
                {
                  "label": "Defaults col",
                  "url": "./defaults"
                },
                {
                  "label": "UseButton cfg",
                  "url": "/docs/props/cfg/use-button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/button.html"
          },
          {
            "cid": 291,
            "sid": "calendar-buttons",
            "name": "calendar-buttons",
            "label": "CalendarButtons",
            "data": {
              "body": "> 달력이 표시될때 달력 하단에 보여질 버튼을 설정합니다. > 설정값의 합을 통해 여러 개 버튼을 표시할 수도 있습니다. > 년월 달력의 경우 [AutoSelectYm](/docs/props/cfg/auto-select-Ym) 값에 따라 `\"확인\"` 버튼 보여짐 여부가 달라집니다. ### 1. 년월일 달력 ![CalendarButtons](/assets/imgs/calendarButtons.png \"CalendarButtons\") 2. 년월 달력 ![MonthCalendarButtons](/assets/imgs/monthCalendar.png \"MonthCalendarButtons\") ### Type `number` ### Options * 년월일 달력 (`default: 0`) |Value|Description| |-----|-----| |`1`|\"오늘\" 버튼| |`2`|\"취소\" 버튼| |`4`|\"확인\" 버튼| |`8`|\"어제\" 버튼| * 년월 달력 (`default: 4`) |Value|Description| |-----|-----| |`1`|\"이번달\" 버튼| |`2`|\"취소\" 버튼| |`4`|\"확인\" 버튼| * 년 달력 (`default: 4`) |Value|Description| |-----|-----| |`2`|\"취소\" 버튼| |`4`|\"확인\" 버튼| ### Example ```javascript options.Cols = [ ... // 년월일 달력에 어제, 오늘 버튼을 표시한다. {Type: \"Date\", Name: \"sa_enterDate\", CalendarButtons: 9 ...}, ... // 년월 달력에 이번달, 취소, 확인 버튼을 표시한다. {Type: \"Date\", Name: \"sa_monthDate\", CalendarButtons: 7, Format: \"yyyy/MM\" ...} ]; ```",
              "see": [
                {
                  "label": "AutoSelectYm cfg",
                  "url": "/docs/props/cfg/auto-select-Ym"
                },
                {
                  "label": "AutoCalendar col",
                  "url": "./auto-calendar"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/calendar-buttons.html"
          },
          {
            "cid": 292,
            "sid": "can-copy-paste",
            "name": "can-copy-paste",
            "label": "CanCopyPaste",
            "data": {
              "body": "> 열에 대한 `ctrl+c`, `ctrl+x`를 통한 복사와 `ctrl+v`를 통한 붙여넣기를 제한합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|복사/붙여넣기 불가 `CanCopyPaste: 0` 이 설정된 열에서는 `ctrl+c`, `ctrl+x` 를 하는 경우 빈셀이 복사되고 `ctrl+v`는 무시됩니다. 시트 내에서 드래그를 통해 영역을 복사/붙여넣기 할때는 `CanCopyPaste: 0` 이 설정된 열은 ,마치 없는거 처럼 건너뛰고 클립보드에 복사됩니다. | |`1(true)`|복사/붙여넣기 가능 (`default`)| ### Example ```javascript //특정 열의 데이터는 복사 불가 options.Cols = [ ... {Type: \"Int\", Name: \"Rank_Sales\", CanCopyPaste: false ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanEdit col",
                  "url": "./can-edit"
                },
                {
                  "label": "CanMove col",
                  "url": "./can-move"
                },
                {
                  "label": "CanResize col",
                  "url": "./can-resize"
                },
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-copy-paste.html"
          },
          {
            "cid": 293,
            "sid": "can-drag-3",
            "name": "can-drag",
            "label": "CanDrag",
            "data": {
              "body": "> 열의 Drag 가능여부를 설정합니다. > [CanDrag cfg](/docs/props/cfg/can-drag) 속성이 `1(true)`인 경우 사용 가능합니다 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|드래그 불가| |`1(true)`|드래그 가능 (`default`)| ### Example ```javascript //특정 열에 대해서 드래그를 막습니다. options.Cols = [ ... {Type: \"Text\", Name: \"sName\", CanDrag: 0 ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanDrag cfg",
                  "url": "/docs/props/cfg/can-drag"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-drag.html"
          },
          {
            "cid": 294,
            "sid": "can-edit-3",
            "name": "can-edit",
            "label": "CanEdit",
            "data": {
              "body": "> 열에 대한 편집 가능 여부를 설정합니다. > 이 속성은 기본값은 `1`인데, `0`설정시 `Cell, Row, Col`순으로 우선 순위를 갖습니다. > 가령 `Cell`에서 `0`으로 설정시 `Row`나 `Col`에서 `1`을 설정해도 해당 셀은 편집이 불가능해 집니다. > `CanEdit: 4`를 제외하고는 편집불가 모드 사용시 `Enum` 컬럼의 아이콘과 `Date` 타입 컬럼의 달력 아이콘을 표현하지 않습니다. > `Cfg`를 이용하여 편집불가 사용시에는 우선순위가 가장 높아짐으로, `Cell, Row, Col`에 `CanEdit: 0`은 먹히지 않습니다. > `Button` 타입의 버튼 클릭 시 동작, `File` 타입의 아이콘 표시 여부에 대해서는 해당 속성의 영향을 **`받지 않습니다`**. ([Disabled col](/docs/props/col/disabled) 통하여 제어 가능.) ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|열을 편집 불가(읽기 전용)으로 설정합니다. ![CanEdit](/assets/imgs/canEdit0.png \"CanEdit\")| |`1`|열을 편집 가능으로 설정합니다. ![CanEdit](/assets/imgs/canEdit1.png \"CanEdit\")| |`2`|열의 내용은 편집 불가하지만, 편집 미리보기를 제공하여 셀의 모든 내용을 확인할 수 있습니다. ![CanEdit](/assets/imgs/canEdit2.png \"CanEdit\")| |`3`|열 편집 불가능(편집 가능 불가능에 대한 배경색을 표시하지 않음) [ColorState (cfg)](/docs/props/cfg/color-state)와 관계없이 배경색을 표현하지 않음. |`4`|열 편집 불가능 + 배경색 표현안함 + 아이콘표시| ### Example ```javascript //AMT 열에 대해 편집불가로 설정 options.Cols = [ ... {Type: \"Int\", CanEdit: 0, Name: \"AMT\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanEdit row",
                  "url": "/docs/props/row/can-edit"
                },
                {
                  "label": "CanEdit cell",
                  "url": "/docs/props/cell/can-edit"
                },
                {
                  "label": "getCanEdit method",
                  "url": "/docs/funcs/core/get-can-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.12|`CanEdit: 3, 4` 추가|"
            },
            "url": "docs/props/col/can-edit.html"
          },
          {
            "cid": 295,
            "sid": "can-empty",
            "name": "can-empty",
            "label": "CanEmpty",
            "data": {
              "body": "> `Int`, `Float`, `Bool`, `Date` 타입에서 데이터의 값이 없을 경우, 빈값으로 표시될 수 있도록 하는 설정입니다. `CanEmpty: 0`으로 설정된 열에 대해서는 값을 지우거나 빈 값으로 설정할 수 없습니다. > 해당 속성에 영향을 받는 데이터는 아래와 같습니다. ```javascript {Type: \"Int\", Name: \"sInt\", CanEmpty: 1} data: [ {\"sInt\": null}, //null 데이터 {\"sInt\": undefined}, //undefined 데이터 {} //데이터 없음 ] ``` <!-- `Bool` 타입의 경우 1번부터 4번까지 값 사이클은 다음과 같습니다. 1 인 경우 `[\"\" => 1 => 0 ...]` , 2 인 경우 `[\"\" => 0 => 1 ...]`, 3 인 경우 `\"\" => [1 => 0 => 1 => 0 ...]`, 4 인 경우 `\"\" => [0 => 1 => 0 => 1 ...]` 형태로 `Bool` 타입의 값이 싸이클을 돕니다. --> ### 빈데이터 기본값 표시 | | Bool| Int| Float| Date| |-- | -- | -- |-- |-- | |CanEmpty : 0| 0(unCheck) | 0 |0 |19700101| |CanEmpty : 1| \"\" | \"\" |\"\" |\"\"| **CanEmpty : 0** ![CanEmpty0](/assets/imgs/CanEmpty0.gif \"CanEmpty0\") **CanEmpty : 1** ![CanEmpty1](/assets/imgs/CanEmpty1.gif \"CanEmpty1\") <!-- **CanEmpty : 2** ![CanEmpty2](/assets/imgs/CanEmpty2.gif \"CanEmpty2\") **CanEmpty : 3** ![CanEmpty3](/assets/imgs/CanEmpty3.gif \"CanEmpty3\") **CanEmpty : 4** ![CanEmpty4](/assets/imgs/CanEmpty4.gif \"CanEmpty4\") --> ### ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|빈 값 설정 불가 (default: `Int`, `Float`, `Bool`)| |`1`|빈 값 설정 가능 (default: `Date`)| ### Example ```javascript // 특정 열에 대해 빈 값이 설정되도록 수정 options.Cols = [ {Type: \"Int\", Name: \"sPoint\", CanEmpty: 1 ...}, {Type: \"Bool\", Name: \"sBool1\", CanEmpty: 1 ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanEdit col",
                  "url": "./can-edit"
                },
                {
                  "label": "CanMove col",
                  "url": "./can-move"
                },
                {
                  "label": "CanResize col",
                  "url": "./can-resize"
                },
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                },
                {
                  "label": "EmptyValue col",
                  "url": "./empty-value"
                },
                {
                  "label": "Type col",
                  "url": "/docs/props/col/type"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-empty.html"
          },
          {
            "cid": 296,
            "sid": "can-export",
            "name": "can-export",
            "label": "CanExport",
            "data": {
              "body": "> 열의 다운로드 가능 여부. > 사용자가 엑셀/텍스트 다운로드 시 해당 열을 다운로드 할지 여부를 설정할 수 있습니다. > Export API([down2Excel](/docs/funcs/excel/down-to-excel), [exportData](/docs/funcs/core/export-data) 등) 호출 시 사용하는 `downCols`와 같이 사용하는 경우 `downCols`의 우선순위가 더 높게 적용됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|다운로드 불가| |`1(true)`|다운로드 가능 (`default`)| ### Example ```javascript //특정 열에 대해 다운로드를 막음 options.Cols = [ ... { Type: \"Int\", Name: \"Rank_Sales\", CanExport: 0 ... }, ... ]; ```",
              "see": [
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                },
                {
                  "label": "exportData method",
                  "url": "/docs/funcs/core/export-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-export.html"
          },
          {
            "cid": 297,
            "sid": "can-filter-2",
            "name": "can-filter",
            "label": "CanFilter",
            "data": {
              "body": "> 특정 열에 대해 필터기능을 사용하지 못하게 설정합니다. > 이 속성을 사용하면 해당 열은 필터셀이 입력불가가 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|필터 사용 불가| |`1`|필터 사용 가능 (`default`)| |`2`|트리에서 사용시 하위 노트가 모두 감춰지면 부모도 감춥니다.| ### Example ```javascript //특정 열에 필터링 하지 못하게 막음 options.Cols = [ ... {Type: \"Int\", Name: \"Rank_Sales\", CanFilter: 0 ...}, ... ]; ```",
              "see": [
                {
                  "label": "showFilter cfg",
                  "url": "/docs/props/cfg/show-filter"
                },
                {
                  "label": "CanMove col",
                  "url": "./can-move"
                },
                {
                  "label": "CanResize col",
                  "url": "./can-resize"
                },
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-filter.html"
          },
          {
            "cid": 298,
            "sid": "can-focus-2",
            "name": "can-focus",
            "label": "CanFocus",
            "data": {
              "body": "> 열에 클릭이나 키보드를 통한 이동시 포커스 가능 여부를 설정합니다. > `CanFocus: 0`으로 설정된 열에 대해서는 클릭을 통한 포커스 진입이 불가능하고, 키보드의 Tab 키를 이용한 이동시 열을 건너뛰게 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|포커스 진입 불가| |`1(true)`|포커스 집입 가능 (`default`)| ### Example ```javascript //특정 열에 대해 포커스가 이루어지지 않게끔 설정 options.Cols = [ ... {Type: \"Text\", Name: \"EM_DC\", CanFocus: 0 ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanEdit col",
                  "url": "./can-edit"
                },
                {
                  "label": "CanMove col",
                  "url": "./can-move"
                },
                {
                  "label": "CanResize col",
                  "url": "./can-resize"
                },
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-focus.html"
          },
          {
            "cid": 299,
            "sid": "can-group-2",
            "name": "can-group",
            "label": "CanGroup",
            "data": {
              "body": "> 열의 그룹핑 가능여부를 설정합니다. > 사용자가 헤더 셀을 드래그 하여 동적으로 구성하는 그룹핑 기능에 대해서 특정 열은 그룹핑이 불가능하게끔 설정하실 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|그룹핑 불가| |`1(true)`|그룹핑 가능 (`default`)| ### Example ```javascript //특정 열에 대해 그룹핑 불허 options.Cols = [ ... {Type: \"Text\", Name: \"SA_DEPTID\", CanGroup: 0, ...}, ... ]; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "GroupDef col",
                  "url": "./group-def"
                },
                {
                  "label": "GroupWidth col",
                  "url": "./group-width"
                },
                {
                  "label": "GroupEmpty col",
                  "url": "./group-empty"
                },
                {
                  "label": "GroupSole col",
                  "url": "./group-sole"
                },
                {
                  "label": "GroupSingle col",
                  "url": "./group-single"
                },
                {
                  "label": "GroupDeleted col",
                  "url": "./group-deleted"
                },
                {
                  "label": "GroupChar col",
                  "url": "./group-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-group.html"
          },
          {
            "cid": 300,
            "sid": "can-move",
            "name": "can-move",
            "label": "CanMove",
            "data": {
              "body": "> 사용자의 열 이동 가능 여부를 설정합니다. > 사용자가 헤더 셀을 드래그하여 열의 위치를 변경하는 기능을 허용할지 여부를 설정합니다.. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|사용자 열 이동 불가| |`1(true)`|사용자 열 이동 가능 (`default`)| ### Example ```javascript //모든 열의 사용자 위치 변경을 불허 options.Def.Col = {CanMove: 0}; ```",
              "see": [
                {
                  "label": "CanColMove cfg",
                  "url": "/docs/props/cfg/can-col-move"
                },
                {
                  "label": "moveCol method",
                  "url": "/docs/funcs/core/move-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-move.html"
          },
          {
            "cid": 301,
            "sid": "can-print-2",
            "name": "can-print",
            "label": "CanPrint",
            "data": {
              "body": "> 열의 프린트 가능 여부. > [doPrint](/docs/funcs/core/do-print) 또는 [down2Pdf](/docs/funcs/excel/down-to-pdf)를 이용하여 프린트 할 경우 해당 열을 프린트 할지 여부를 설정할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|프린트 불가| |`1`|프린트 가능 (`default`)| ### Example ```javascript //특정 열에 대해 프린트를 막음 options.Cols = [ ... { Type: \"Int\", Name: \"Rank_Sales\", CanPrint: 0 ... }, ... ]; ```",
              "see": [
                {
                  "label": "doPrint method",
                  "url": "/docs/funcs/core/do-print"
                },
                {
                  "label": "down2Pdf method",
                  "url": "/docs/funcs/excel/down-to-pdf"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-print.html"
          },
          {
            "cid": 302,
            "sid": "can-resize",
            "name": "can-resize",
            "label": "CanResize",
            "data": {
              "body": "> 열의 너비 변경 가능여부를 설정합니다. > 사용자가 헤더 영역에서 열과 열 사이를 드래그 하여 열의 너비를 변경할 수 있는데, 이 기능에 대한 허용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|사용자 열 너비 변경 불가| |`1(true)`|사용자 열 너비 변경 가능 (`default`)| ### Example ```javascript //특정 열에 대한 너비 조정 불허 options.Cols = [ ... {Type: \"Date\", Name: \"kDate\", Width: 110, CanResize: 0 ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanMove col",
                  "url": "./can-move"
                },
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-resize.html"
          },
          {
            "cid": 303,
            "sid": "can-search",
            "name": "can-search",
            "label": "CanSearch",
            "data": {
              "body": "> findRows, 찾기 다이얼로그 등을 통해 검색할 때 해당 컬럼을 검색 대상에 포함시킬지 여부를 결정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|검색 대상 미포함| |`1(true)`|검색 대상 포함 (`default`)| ### Example ```javascript //해당 컬럼을 검색 대상에서 제외합니다. options.Cols = [ ... {Type: \"Text\", Name: \"sName\", CanSearch: 0 ...}, ... ]; ```",
              "see": [
                {
                  "label": "SearchCount cfg",
                  "url": "/docs/props/cfg/search-count"
                },
                {
                  "label": "SearchCaseSensitive cfg",
                  "url": "/docs/props/cfg/search-case-sensitive"
                },
                {
                  "label": "findRows method",
                  "url": "/docs/funcs/core/find-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-search.html"
          },
          {
            "cid": 304,
            "sid": "can-select-3",
            "name": "can-select",
            "label": "CanSelect",
            "data": {
              "body": "> 사용자가 마우스 드래그를 통해 데이터 영역의 일부데이터를 선택할때, 열에 대한 선택 가능 여부를 설정합니다. > `CanSelect: 0`으로 설정된 열은 드래그시 건너뛰어 선택됩니다. ### ![canSelect](/assets/imgs/canSelect.png \"드래그하여 선택시 선택 가능여부\") 위와 같이 선택시 `ctrl+c`를 하면 2, 3, 5월 열의 데이터만 클립보드로 복사됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열 선택 불가| |`1(true)`|열 선택 가능 (`default`)| ### Example ```javascript //AMT 열에 대해 선택 불가하게 설정 options.Cols = [ ... {Type: \"Int\", CanEdit: 0, Name: \"AMT\", CanSelect: 0, Width: 120, ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanFocus col",
                  "url": "./can-focus"
                },
                {
                  "label": "CanCopyPaste col",
                  "url": "./can-copy-paste"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-select.html"
          },
          {
            "cid": 305,
            "sid": "can-sort-3",
            "name": "can-sort",
            "label": "CanSort",
            "data": {
              "body": "> 열의 소팅 가능 여부를 설정합니다. > 사용자가 헤더 영역의 셀을 클릭시 소팅이 이루어지는데, 이를 허용할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|사용자 소팅 불가| |`1(true)`|사용자 소팅 가능 (`default`)| ### Example ```javascript //특정 열에 대해 소팅하지 못하게 막음 options.Cols = [ ... {Type: \"Int\", Name: \"Rank_Sales\", CanSort: 0 ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanMove col",
                  "url": "./can-move"
                },
                {
                  "label": "CanResize col",
                  "url": "./can-resize"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/can-sort.html"
          },
          {
            "cid": 306,
            "sid": "case-sensitive",
            "name": "case-sensitive",
            "label": "CaseSensitive",
            "data": {
              "body": "> 열 소팅시(혹은 필터 사용시) 대소문자 구분 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|대소문자 구분 안함| |`1(true)`|대소문자 구분 사용 (`default`)| ### Example ```javascript //특정 열 소팅시 대소문자를 구분. options.Cols = [ ... {Type: \"Text\", Name: \"SA_DEPTID\", CaseSensitive: 1, ...}, ... ]; ```",
              "see": [
                {
                  "label": "RawSort col",
                  "url": "./raw-sort"
                },
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                },
                {
                  "label": "NumberSort col",
                  "url": "./number-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/case-sensitive.html"
          },
          {
            "cid": 307,
            "sid": "change-edit",
            "name": "change-edit",
            "label": "ChangeEdit",
            "data": {
              "body": "> 행의 상태가 수정([Changed](/docs/props/row/changed)) 또는 조회인 상태인 행의 컬럼의 편집([CanEdit](/docs/props/row/can-edit)) 가능 여부를 설정합니다. > 조회시에는 편집 불가, 행 추가 후 데이터 편집 가능, 저장 후 편집 불가를 설정하고 싶다면 [AddEdit](/docs/props/col/add-edit) 를 함께 설정해주어야 합니다. > `주의` 해당 속성을 설정하게 되면, `(Cell,Row,Col)CanEdit` 설정 속성은 무시됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|행의 상태가 Changed(수정) / 조회 일 경우 해당 컬럼 편집 불가| |`1(true)`|행의 상태가 Changed(수정) / 조회 일 경우 해당 컬럼 편집 가능| ### Example ```javascript //Changed(수정) 또는 조회 행에 대해서는 AMT 컬럼의 편집을 막음 options.Cols = [ ... {Type: \"Int\", ChangeEdit: 0, Name: \"AMT\", Width: 120 ...}, ... ]; // 조회시 AMT 컬럼의 편집을 막고, addRow 를 통하여 추가한 경우에는 편집 가능, 저장 후 편집 불가로 설정 options.Cols = [ ... {Type: \"Int\", AddEdit: 1, ChangeEdit:0, Name: \"AMT\", Width: 120 ...}, ... ]; ``` ### Try it - [Demo of ChangeEdit](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/ChangeEdit/)",
              "see": [
                {
                  "label": "CanEdit col",
                  "url": "/docs/props/col/can-edit"
                },
                {
                  "label": "CanEdit row",
                  "url": "/docs/props/row/can-edit"
                },
                {
                  "label": "AddEdit col",
                  "url": "/docs/props/col/add-edit"
                },
                {
                  "label": "Changed row",
                  "url": "/docs/props/row/changed"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.87|기능 추가|"
            },
            "url": "docs/props/col/change-edit.html"
          },
          {
            "cid": 308,
            "sid": "class-2",
            "name": "class",
            "label": "Class",
            "data": {
              "body": "> 열에 적용할 커스텀 `css class명`을 설정합니다. > **<mark>주의</mark> : Class로 적용한 css는 엑셀 다운로드시 디자인 반영되지 않습니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열에 적용할 css class 명| ### Example ```css <style> .RedBold{color:#FF0000;font-weight:700} </style> ``` ```javascript //특정 열에 \"RedBold\" 클래스를 적용 options.Cols = [ ... {Type: \"Text\", Name: \"Dept\", Class: \"RedBold\", Width: 100 ...}, ... ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/class.html"
          },
          {
            "cid": 309,
            "sid": "clear",
            "name": "clear",
            "label": "Clear",
            "data": {
              "body": "> 열간에 관계형 콤보를 사용할때, 상위 콤보에 값이 바뀌었을때 클리어 되어야 하는 하위 열을 정의 합니다. > 관계형 콤보 구성과 관련해서는 [Related](./related) 속성을 참고해 주세요. > [CanEmpty](./can-empty) 속성에 영향을 받아 `CanEmpty: 0` 일 경우에는 Enum의 첫 번째 값으로 설정이 됩니다. > `CanEmpty: 1` 일 경우에는 빈 문자열로 설정 됩니다. > `참고` : 관계형 콤보의 `(Col)Clear, (Col)CanEmpty` 는 사용자의 action(change 이벤트가 발생하는) 에 의해서만 동작합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자신의 하위관계 열이름 (여러개인 경우 \",\"구분자로 지정)| ### Example ```javascript options.Cols = [ ... //열의 값이 변경될때 cls2,cls3 열의 값이 클리어 됨 {Type: \"Enum\", Clear: \"cls2, cls3\", Name: \"cls1\", Enum: \"|A회사|B회사\",EnumKeys: \"|AA|BB\" ... }, //열의 값이 변경될때 cls3 열의 값이 클리어 됨 {Type: \"Enum\", Clear: \"cls3\", Name: \"cls2\", Related: \"cls1\", EnumAA: \"|해외사업부|국내사업부|영업지원부\", EnumKeysAA: \"|A0|A1|A2\", EnumBB: \"|개발부|기술지원부\", EnumKeysBB: \"|B0|B1\" ... }, //소분류 {Type: \"Enum\", Name: \"cls3\", Related: \"cls2\", EnumAA_A0: \"|미주사업|동남아사업팀|유럽사업팀\", EnumKeysAA_A0: \"|AB0|AB1|AB2\", EnumAA_A1: \"|경부|전라|수도권\", EnumKeysAA_A1: \"|K0|K1|K2\", EnumAA_A2: \"|지원1팀|지원2팀\", EnumKeysAA_A2: \"|SE0|SE1\", EnumBB_B0: \"|개발1팀|개발2팀|개발3팀\", EnumKeysBB_B0: \"|DEV0|DEV1|DEV2\", EnumBB_B1: \"|지원1팀|지원2팀|지원3팀\", EnumKeysBB_B1: \"|SU0|SU1|SU3\", ... }, ... ]; ```",
              "see": [
                {
                  "label": "Related col",
                  "url": "./related"
                },
                {
                  "label": "Enum col",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "./enum-keys"
                },
                {
                  "label": "CanEmpty",
                  "url": "./can-empty"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/clear.html"
          },
          {
            "cid": 310,
            "sid": "col-merge",
            "name": "col-merge",
            "label": "ColMerge",
            "data": {
              "body": "> 데이터 영역에서 값 기준 병합 실행([DataMerge](/docs/props/cfg/data-merge), [HeaderMerge](/docs/props/cfg/header-merge))시 열을 포함할지 여부를 설정합니다. > 해당 속성은 지정한 컬럼 내에 `병합할지 여부`를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|해당 컬럼을 병합하지 않습니다. | |`1(true)`|해당 컬럼을 병합 대상에 포함합니다. (`default`)| ### Example ```javascript options.Cols = [ ... {Type: \"Text\", Name: \"Dept\", ColMerge: false, Width: 100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "RowMerge row",
                  "url": "/docs/props/row/row-merge"
                },
                {
                  "label": "ColMerge cell",
                  "url": "/docs/props/cell/col-merge"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/header-merge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/col-merge.html"
          },
          {
            "cid": 311,
            "sid": "color-2",
            "name": "color",
            "label": "Color",
            "data": {
              "body": "> 열의 배경색상을 설정합니다. > 열의 색상은 상태에 따른 배경 색상의 영향을 받습니다. > rgb(255,255,255)는 투명색이 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|HEX형식 (ex:#FF00F0) rgb형식 (ex:rgb(244,200,40)| ### Example ```javascript //특정 열에 배경색을 \"#ADADAD\"로 설정 options.Cols = [ ... {Type: \"Text\", Name: \"Dept\", Color: \"#ADADAD\", Width: 100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "TextColor col",
                  "url": "./text-color"
                },
                {
                  "label": "TextStyle col",
                  "url": "./text-style"
                },
                {
                  "label": "TextSize col",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont col",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/color.html"
          },
          {
            "cid": 312,
            "sid": "cursor",
            "name": "cursor",
            "label": "Cursor",
            "data": {
              "body": "> 열 위에 마우스 커서가 호버시 커서의 모양을 설정합니다. > 설정가능한 커서의 모양은 css를 따릅니다. > ex) auto, crosshair, default, pointer, move, e-resize, ne-resize, nw-resize, n-resize, se-resize, sw-resize, w-resize, text, wait, help ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 커서 모양| ### Example ```javascript //열에 커서가 들어갔을때 커서 모양을 클릭가능한 손가락 모양으로 변경. options.Cols = [ ... {Type: \"Text\", Name: \"sa_nm\", Cursor: 'pointer', TextStyle: 4}, ... ]; ```",
              "see": [
                {
                  "label": "TextStyle col",
                  "url": "./text-style"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/cursor.html"
          },
          {
            "cid": 313,
            "sid": "custom-format",
            "name": "custom-format",
            "label": "CustomFormat",
            "data": {
              "body": "> 원본 데이터에 대한 마스킹을 정의합니다. > <mark>Type이 Text또는 Lines인 경우</mark> 사용 가능한 사용자 정의 포맷으로, 사용자가 선언한 커스텀 포맷 함수도 지정가능합니다. > `|`구분자로 여러개 포맷 지정 가능 합니다. > `CustomFormat`에서 사용 가능한 예약어는 다음과 같습니다. > |Value|Description| > |-----|-----| > |`#`|그대로 보여지는 글자| > |`*`| *(별표)로 처리되는 글자| > |`PostNo`| 우편번호 | > |`IdNoMask`| 주민등록번호(뒤 6자리 *(별표)로 처리) | > |`IdNo`| 주민등록번호(full text) | > |`SaupNo`| 사업자 등록번호 | > |`CardNo`| 카드번호 | > |`PhoneNo`| 전화번호(휴대폰번호) | ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열의 Type에 따른 다양한 포맷설정 문자열| ### Example ```javascript options.Cols = [ ... //전화번호 포맷을 정의합니다. {Type: \"Text\", Name: \"sPhone\", CustomFormat: 'PhoneNo' ...}, //0226212288 입력시 02-2621-2288로 표시, 01073213834 입력시 010-7321-3834 로 표시 //임의의 포멧을 정의합니다. {Type: \"Text\", Name: \"sawonNo\", CustomFormat: '###-#####' ...}, //12345678 입력시 123-45678로 표시 //주민번호에 뒷자리를 감추는 형식 {Type: \"Text\", Name: \"cNo\", CustomFormat: 'IdNoMask' ...}, //8501242384211 입력시 850124-2******로 표시 //데이터의 자릿수에 따라 지정 {Type: \"Text\", Name: \"cNo\", CustomFormat: 'IdNoMask|SaupNo' ...}, //8501242384211(주민번호) 입력시 850124-2******로 표시, 6258412458(사업자번호) 입력시 625-84-12458로 표시 //임의의 함수로 처리 {Type: \"Text\", Name: \"ISDNS\", CustomFormat: function(v, sheet, col){ //값의 글자수에 따라 다른 포멧으로 보여지게 끔 표시 if (v.length > 10) { //######-####### return v.substr(0,6) + \"-\" + v.substr(6); } else { //#####-##### return v.substr(0,5) + \"-\" + v.subst(5); } }}, ... ]; ```",
              "see": [
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                },
                {
                  "label": "Format col",
                  "url": "./format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.87|function 사용시 시트객체, 컬럼명 인자 추가|"
            },
            "url": "docs/props/col/custom-format.html"
          },
          {
            "cid": 314,
            "sid": "data-format",
            "name": "data-format",
            "label": "DataFormat",
            "data": {
              "body": "> 날짜 타입의 열에서 로딩할 데이터의 포멧을 설정합니다. > 가령 조회 데이터의 날짜가 \"25012017\" 와 같다면 DataFormat에는 \"ddMMyyyy\" 로, > 데이터가 \"20171225\" 와 같다면 DataFormat에는 \"yyyyMMdd\" 로 설정되어야 합니다. > 해당 열에 데이터가 서버로 전송되기 위해 추출 될 때, ([doSave](/docs/funcs/core/do-save), [getSaveString](/docs/funcs/core/get-save-string))도 지정한 포멧으로 전송됩니다. **날짜 예약어** |표시|의미| |---|---| |`yyyy`|년도(4자리)| |`MM`|월(2자리)| |`dd`|일(2자리)| |`HH`|시간(2자리)| |`mm`|분(2자리)| |`ss`|초(2자리)| ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|yyyyMMdd 등 정해진 문자열| ### Example ```javascript //특정 열에서 년월일 데이터 구조를 설정합니다. options.Cols = [ ... {Type: \"Date\", Format: \"yyyy.MM.dd HH:ss\", DataFormat: \"yyyyMMddHHmmss\", Name: \"enterDate\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Format col",
                  "url": "/docs/props/col/format"
                },
                {
                  "label": "EditFormat col",
                  "url": "/docs/props/col/edit-format"
                },
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/data-format.html"
          },
          {
            "cid": 315,
            "sid": "date-strict-mode-2",
            "name": "date-strict-mode",
            "label": "DateStrictMode",
            "data": {
              "body": "> 조회시 날짜 타입의 열에서 `DataFormat`이 설정된 경우 설정된 포맷과 길이가 일치하지 않거나 잘못된 날짜가 조회되는 경우 공백으로 처리합니다. > `DataFormat`을 \"yyyyMMdd\" 로 설정한 후 \"88\" 이라는 값이 조회되는 경우 해당 셀 값은 공백으로 처리됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|정밀검사하지 않음 (`default`)| |`1(true)`|`DataFormat`에 설정된 포맷에 대한 정밀 검사| ### Example ```javascript //특정 열에서 잘못된 날짜 데이터 조회시 공백처리 합니다. options.Cols = [ ... {Type: \"Date\", DateStrictMode: 1 Format: \"yyyy.MM.dd\", DataFormat: \"yyyyMMdd\", Name: \"enterDate\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "DataFormat col",
                  "url": "/docs/props/col/data-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.12|기능 추가|"
            },
            "url": "docs/props/col/date-strict-mode.html"
          },
          {
            "cid": 316,
            "sid": "decimal-adjust-2",
            "name": "decimal-adjust",
            "label": "DecimalAdjust",
            "data": {
              "body": "> Int, Float 타입 컬럼 데이터의 근사값 처리방식을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`round`|근사값을 반올림으로 처리합니다. (`default`)| |`floor`|근사값을 내림으로 처리합니다.| |`ceil`|근사값을 올림으로 처리합니다.| ### Example ```javascript options.Cfg = { DecimalAdjust: \"floor\" // Int, Float 타입 컬럼의 근사값 처리방식을 내림으로 설정 }; ``` ### Since |product|version|desc| |---|---|---| |core|8.0.0.11|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|8.0.0.11|기능 추가|"
            },
            "url": "docs/props/col/decimal-adjust.html"
          },
          {
            "cid": 317,
            "sid": "default-image",
            "name": "default-image",
            "label": "DefaultImage",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Img` 인 컬럼에서 이미지를 로드할때 서버에 이미지가 없는 경우 대체할 이미지를 설정합니다. > **<mark>주의</mark> : Img 데이터에 Left, Top이 설정된 경우엔 DefaultImage가 적용되지 않습니다** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|이미지 로드 실패시 대체할 이미지의 url| ### Example ```javascript options.Cols = [ ... // 대체 이미지 경로를 설정한다. { Header: \"이미지\", Type: \"Img\", Name: \"sImgData\", Width: 120, DefaultImage: \"./image/defaultImage.png\", ... }, ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.18|기능 추가|"
            },
            "url": "docs/props/col/default-image.html"
          },
          {
            "cid": 318,
            "sid": "default-value",
            "name": "default-value",
            "label": "DefaultValue",
            "data": {
              "body": "> 컬럼에 기본 값을 설정합니다. > 신규행을 추가하거나 조회데이터 안에 해당 열에 대한 데이터가 없는 경우, 지정한 값이 자동으로 표시됩니다. > 특히 `Button` 타입 사용시 버튼에 기본적으로 표시될 내용을 설정하면, 별도로 버튼 컬럼에 대한 조회가 없어도 해당 값이 표시됩니다. > 값을 읽거나(getValue) 저장하거나 엑셀로 다운로드할 때는 DefaultValue 값으로 처리됩니다. > `EmptyValue` 속성과 같이 설정 하였을 경우 DefaultValue가 우선 순위가 높습니다. > 해당 속성에 영향을 받는 데이터는 아래와 같습니다. ```javascript {Type: \"Text\", Name: \"sText\", DefaultValue : \"홍길동\"} data: [ {\"e\": null}, //null 데이터 {\"e\": undefined}, //undefined 데이터 {} //데이터 없음 ] ``` ### Type `mixed` ### Options |Value|Description| |-----|-----| |`mixed`|신규 행이나 조회시 값이 없을때 기본값으로 표시할 내용| ### Example ```javascript //버튼 컬럼에 기본 타이틀 지정 options.Cols = [ {Header: \"상세정보\", Type: \"Button\", Name: \"DetailBnt\", Button: \"Button\", DefaultValue: \"확인\"}, ... ]; ``` ![Default](/assets/imgs/button5.png) 상세보기 컬럼에 조회 데이터가 없어도 \"확인\"이 표시됩니다.",
              "see": [
                {
                  "label": "EmptyValue col",
                  "url": "./empty-value"
                },
                {
                  "label": "SpaceForDefaultValue cfg",
                  "url": "/docs/props/cfg/space-for-default-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/default-value.html"
          },
          {
            "cid": 319,
            "sid": "defaults",
            "name": "defaults",
            "label": "Defaults",
            "data": {
              "body": "> 사용자가 설정할 수 있는 값을 첫글자를 구분자로 연결한 문자열 형식으로 정의하여 입력 편의를 돕습니다. > 열에 [Button](./button) 속성이나 [Icon](./icon) 속성값이 `Defaults`인 경우에만 사용하실 수 있습니다. > `*`문자로 시작하는 몇가지 예약어를 통해 특수한 기능을 추가적으로 사용하실 수 있습니다. > `Text` 타입에서 사용시 [Format](./format), [EditFormat](./edit-format) 속성을 같이 사용하여 `Html`의 \\<select\\>처럼 보여지는 값과 서버로 전송되는 값을 다르게 사용하실 수도 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫글자를 구분자로 하는 입력 가능한 값 문자열 ex) `Defaults: \"\\|딸기\\|바나나\\|오렌지\\|포도\\|파인애플\\|*All\\|*None\"` ![Defaults](/assets/imgs/defaults1.png)| ### 특수 기능 (예약어) |예약문자|기능| |---|---| |`*Date`|\"일자선택 ...\"이라는 문구가 리스트 아이템에 표시되고 선택시 달력이 오픈됩니다.| |`*Button`|\"선택 ...\"이라는 문구가 리스트 아이템에 표시되고 선택시 [onButtonClick](/docs/events/on-button-click)이벤트를 발생시킵니다.| |`*FilterOff`|필터행에서만 \"전체\"라는 문구가 리스트에 표시되고 선택시 필터셀의 값을 지웁니다.| |`*All`|[Range](./range) 속성을 `1`로 설정한 경우 리스트의 각 아이템 우측에 체크박스가 표시되어 여러개 아이템을 선택할 수 있습니다. 이때 이 값을 갖은 아이템에는 \"모두 선택\"이라는 문구가 표시되고 선택시 모든 아이템이 체크됩니다.| |`*None`|[Range](./range) 속성을 `1`로 설정한 경우 리스트의 각 아이템 우측에 체크박스가 표시되어 여러개 아이템을 선택할 수 있습니다. 이때 이 값을 갖은 아이템에는 \"모두 지우기\"이라는 문구가 표시되고 선택시 모든 아이템이 체크해제 됩니다.| |`*Rows`|값이 포함되면 별도의 아이템이 생기는게 아니라 해당 열에 모든 값이 리스트에 추가됩니다. 보여지는 행만 리스트에 추가하고 싶으면 `*Rows` 뒤에 `Visible` 키워드를 붙여주시면 됩니다. (`*RowsVisible`)| ### Example ```javascript // Default를 이용한 드롭 다운 리스트 (복수개 선택가능) options.Cols = [ { Header: \"여행지\", Type: \"Text\", Name: \"Nation\", Range: 1, Button: \"Defaults\", // 시트 우측 영역에 Default 버튼 생성 Defaults: \"|LOC|USA|EST|CHN|JPN|*None\", Format: \"{'LOC':'국내','USA':'미국','EST':'동남아','CHN':'중국','JPN':'일본'}\", EditFormat: \"{'LOC':'국내','USA':'미국','EST':'동남아','CHN':'중국','JPN':'일본'}\", }, ... ]; ``` ![Default](/assets/imgs/defaults2.png) Example과 같이 설정시 보여지는 리스트 (저장시 서버로는 **\"LOC;EST\"** 전송됨)",
              "see": [
                {
                  "label": "Button col",
                  "url": "./button"
                },
                {
                  "label": "Icon col",
                  "url": "./icon"
                },
                {
                  "label": "Range col",
                  "url": "./range"
                },
                {
                  "label": "Format col",
                  "url": "./format"
                },
                {
                  "label": "EditFormat col",
                  "url": "./edit-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.25|`Visible` 키워드 추가|"
            },
            "url": "docs/props/col/defaults.html"
          },
          {
            "cid": 320,
            "sid": "disabled",
            "name": "disabled",
            "label": "Disabled",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Button`, `File`인 컬럼에 대해 버튼 사용 가능 여부를 설정합니다. > `Type:\"Button\", Disabled:1` : 버튼 컬럼이 비활성화 색으로 변경되며, click 이벤트 발생하지 않는다 > `Type:\"File\", Disabled:1` : 파일 추가, 제거 버튼이 표시되지 않는다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|버튼 기능 사용 가능 (`default`)| |`1(true)`|버튼 기능 사용 불가| ### Example ```javascript //특정 열의 버튼을 사용불가로 설정 options.Cols = [ ... {Type: \"Button\", Button: \"Button\", Disabled: 1, Name: \"btn1\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/disabled.html"
          },
          {
            "cid": 321,
            "sid": "edit-enum",
            "name": "edit-enum",
            "label": "EditEnum",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Enum`인 열에서 드랍리스트가 펼쳐졌을때 보여지는 아이템의 `Text`를 [Enum](./enum)에서 설정한 값과 다르게 하고자 할때 사용합니다. > '\\t'구분자를 이용하여 아이템을 여러개의 컬럼으로 표현할 수 있습니다. ### **1. 일반적인 EditEnum 사용** ![EditEnum](/assets/imgs/editEnum.png \"EditEnum\") **2. '\\t' 구분자를 사용한 EditEnum 사용** ![EditEnum2](/assets/imgs/editEnum2.png \"EditEnum2\") ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#사장#부사장#전무#상무#이사#부서장#차장#과장#대리#주임#사원\")| ### Example ```javascript //Enum 열에 item을 설정한다. options.Cols = [ ... { Type: \"Enum\", Name: \"relation1\", Enum: \"|시흥현장|안산현장|화성현장\", EditEnum: \"|경기도 시흥시 은행로216번길 26|경기도 안산시 단원구 안산천남로 245|경기도 화성시 동탄반석로 96\", ... }, { Type: \"Enum\", Name: \"relation2\", Enum: \"|시흥현장|안산현장|화성현장\", EditEnum: \"|경기도\\t시흥시\\t은행로216번길 26|경기도\\t안산시 단원구\\t안산천남로 245|경기도\\t화성시\\t동탄반석로 96\", ... }, ... ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "./enum-keys"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/edit-enum.html"
          },
          {
            "cid": 322,
            "sid": "edit-format",
            "name": "edit-format",
            "label": "EditFormat",
            "data": {
              "body": "> 사용자가 셀을 더블클릭하여 편집모드로 들어갔을때 보여 줄 포맷을 설정합니다 > 각 열의 [Type](/docs/appx/type)에 따라 설정 방법이나 동작이 달라집니다. > 가장 쉽게 이해하자면 날짜 유형 포맷을 사용하는 열에서 \"EditFormat\":\"ddMMyyyy\"로 설정하면, 셀에 보여질때는 \"2019-12-31\"형식으로 보여지다가, 사용자가 셀의 데이터를 편집하려 할때는 \"31122019\"로 나타나게 됩니다. > 포맷에 대한 자세한 내용은 [Format appendix](/docs/appx/format)을 참고해 주세요. > `Int`나 `Float` 타입에선 %는 `EditFormat`에서 사용할 수 없습니다. ### Type mixed( `string` \\| `object`) ### Options |타입|유형|사용방법 | |---|---|---| |`Text, Lines`|`object`|셀에서 더블클릭을 통해 편집모드로 들어갈때 원래의 값을 어떤 형식으로 보여줄지 설정합니다. ex) \"EditFormat\":{\"KOR\":\"대한민국\", \"JPN\":\"일본\", \"USA\":\"미국\"} 셀의 값이 KOR일때 편집모드로 들어가면 대한민국으로 보여줌 ![EditFormat Text](/assets/imgs/editFormatText.png)| |`Date`|`string`|편집시 보여질 년,월,일의 순서 ex) \"EditFormat\":\"ddMMyyyy\" ![EditFormat Date](/assets/imgs/editFormatDate.png)| ### Example ```javascript //특정 열에서 편집시 일월년 순으로 보여지게끔 설정 options.Cols = [ ... {Type: \"Date\", Format: \"yyyy-MM-dd\", EditFormat: \"ddMMyyyy\", Name: \"enterDate\",Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Format col",
                  "url": "./format"
                },
                {
                  "label": "DataFormat col",
                  "url": "./data-format"
                },
                {
                  "label": "EditFormat cell",
                  "url": "/docs/props/cell/edit-format"
                },
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/edit-format.html"
          },
          {
            "cid": 323,
            "sid": "edit-mask",
            "name": "edit-mask",
            "label": "EditMask",
            "data": {
              "body": "> 셀에 입력가능한 문자를 자바스크립트 정규식을 이용하여 설정합니다. > 여기서 입력한 글자는 정규식의 `search()함수`를 사용하여 입력허용 여부가 결정됩니다. > > \"입력값\".search(EditMask)>=0 > `true` 인 경우 입력 허용 > `false` 인 경우 입력 제한 > > 띄어쓰기를 제외한 모든 글자만 입력허용 : \"^\\\\\\\\S\\*\\$\" > 숫자만 입력 가능 : \"^\\\\\\\\d\\*\\$\" > 알파벳 만 가능 : \"^\\\\\\\\w\\*\\$\" > 열개 숫자만 가능 : \"^\\\\\\\\d{0,10}$\" > > 정규식에 맞지 않은 글자는 입력되지 않습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자바스크립트 정규식 문자| ### Example ```javascript //띄어쓰기를 제외한 모든 글자 입력 가능 options.Cols = [ ... {Type: \"Text\", EditMask: \"^\\\\S*$\", Name: \"CN_Code\", Width: 120, ...}, ... ]; ```",
              "see": [
                {
                  "label": "ResultMask col",
                  "url": "./result-mask"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/edit-mask.html"
          },
          {
            "cid": 324,
            "sid": "empty-value",
            "name": "empty-value",
            "label": "EmptyValue",
            "data": {
              "body": "> 셀에 값이 없을때 보여질 글자를 설정합니다. > `Html` input 객체의 `placeholder`속성과 비슷한 기능으로, 값을 읽거나(getValue) 저장하거나 엑셀로 다운로드할 때는 값이 없는 상태로 처리됩니다. > 해당 속성에 영향을 받는 데이터는 아래와 같습니다. ```javascript {Type: \"Text\", Name: \"sText\", EmptyValue : \"값이 없습니다.\"} data: [ {\"e\": null}, //null 데이터 {\"e\": undefined}, //undefined 데이터 {\"e\": \"\"}, //빈문자 데이터 {} //데이터 없음 ] ``` ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|신규 행이나 조회시 값이 없을때 보여질 내용| ### Example ```javascript //필수 입력에 대한 안내를 설정 options.Cols = [ ... {Type: \"Text\", Name: \"sa_point\", EmptyValue: \"필수 입력항목 입니다.\", ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanEmpty col",
                  "url": "./can-empty"
                },
                {
                  "label": "DefaultValue col",
                  "url": "./default-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/empty-value.html"
          },
          {
            "cid": 325,
            "sid": "enum-disabled",
            "name": "enum-disabled",
            "label": "EnumDisabled",
            "data": {
              "body": "> [Enum](./enum) 속성을 통해 설정한 아이템들의 선택 불가능 여부를 설정합니다. > 첫번째 글자를 구분자로 설정하게 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#1#0\")| ### Example ```javascript //Enum 열에 item의 선택 불가능 여부를 설정한다. options.Cols = [ { \"Header\": \"대분류\", \"Type\": \"Enum\", \"Name\": \"Category1\", \"Enum\": \"|가정/살림|경제 경영|국어 외국어 사전|만화/라이트노벨|소설/시/희곡|어린이|역사|예술|인문|자기계발|자연과학\", \"EnumKeys\": \"|A0|A1|A2|A3|A4|A5|A7|A8|A9|A10|A11\", \"EnumDisabled\": \"|1|0|0|0|0|1|0|1|1|0|0\" } ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "./enum-keys"
                },
                {
                  "label": "EnumMenu col",
                  "url": "./enum-menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.16|기능 추가|"
            },
            "url": "docs/props/col/enum-disabled.html"
          },
          {
            "cid": 326,
            "sid": "enum-filter",
            "name": "enum-filter",
            "label": "EnumFilter",
            "data": {
              "body": "> [Enum](/docs/appx/type.md) 타입 셀을 편집 시, 드롭다운 리스트를 필터링 할 수 있는 입력란을 표시합니다. > 해당 칸에 입력된 문자열을 포함하는 [Enum](/enum.md)들만 드롭다운 리스트로 표시됩니다. > 이 기능은 [CaseSensitive](./case-sensitive) 설정에 따라 대소문자를 구분합니다. > [EnumMenu](./enum-menu) 속성과 함께 사용할 수 없습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`boolean`| 드롭다운 리스트의 필터 항목 표시 여부 | ### Example ```javascript options.Cols = [ { Type: \"Enum\", Name: \"relation\", Enum: \"|직계존속|직계비속|배우자|자녀\", EnumKeys: \"|A0|A1|B0|C0\", EnumFilter: true }, ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "./enum-keys"
                },
                {
                  "label": "EnumMenu col",
                  "url": "./enum-menu"
                },
                {
                  "label": "CaseSensitive col",
                  "url": "./case-sensitive"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.48|기능 추가|"
            },
            "url": "docs/props/col/enum-filter.html"
          },
          {
            "cid": 327,
            "sid": "enum-format",
            "name": "enum-format",
            "label": "EnumFormat",
            "data": {
              "body": "> Enum 컬럼 데이터에 대한 마스킹을 정의합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`function`|return 값을 기준으로 Enum 컬럼 데이터에 관한 마스킹 표시| ### Example ```javascript options.Cols = [ ... //임의의 함수로 처리 {Type: \"Enum\", Name: \"EnumData\", Enum: \"|토마토|감자|옥수수\", Range: 1, EnumFormat: function (param, sheet, col) { if (param.indexOf(\";\") == -1 || param == \"&#160;\") return param; var valArr = param.split(\";\"); var length = valArr.length - 1 + \"\"; // '토마토;감자'로 val 값이 들어올 경우, '토마토 외 1건'과 같은 형식으로 표시한다. return valArr[0] + \" 외 \" + length + \"건\"; }}, ... ]; ```",
              "see": [
                {
                  "label": "Enum",
                  "url": "./enum"
                },
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                },
                {
                  "label": "Format col",
                  "url": "./format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.9|기능 추가|"
            },
            "url": "docs/props/col/enum-format.html"
          },
          {
            "cid": 328,
            "sid": "enum-keys",
            "name": "enum-keys",
            "label": "EnumKeys",
            "data": {
              "body": "> [Enum](./enum) 속성을 통해 설정한 아이템 들의 값을 설정합니다. > 첫번째 글자를 구분자로 설정하게 됩니다. > 이 속성을 설정하면, 실제 조회나 저장시 `EnumKey`로 설정한 값이 서버로 전송됩니다. > **<mark>주의</mark> : EnumKeys는 [Enum](./enum) 당 유일한 하나의 Key로 동일한 값을 중복해서 사용하면 안됩니다.** > **<mark>주의</mark> : [Type](/docs/appx/type)이 `Radio`인 컬럼에서는 [Enum](./enum)과 `EnumKeys`의 길이를 동일하게 사용해야 체크 동작이 정상적으로 이뤄집니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#01#02#03#04\")| ### Example ```javascript //Enum 열에 item을 설정한다. options.Cols = [ ... {Type: \"Enum\", Name: \"relation\", Enum: \"|직계존속|직계비속|배우자|자녀\",EnumKeys: \"|A0|A1|B0|C0\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "./enum"
                },
                {
                  "label": "MenuHSeparator cfg",
                  "url": "/docs/props/cfg/menu-h-separator"
                },
                {
                  "label": "Related col",
                  "url": "./related"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/enum-keys.html"
          },
          {
            "cid": 329,
            "sid": "enum-menu",
            "name": "enum-menu",
            "label": "EnumMenu",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Enum`인 열에서 드랍리스트 대신 메뉴가 보여지게 끔 설정하고자 할때 사용합니다. > `Menu`에 대한 자세한 내용은 [Menu appendix](/docs/appx/menu)속성을 참고해 주세요. ### ![EnumMenu](/assets/imgs/enumMenu.png \"EnumMenu\") ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|메뉴를 구성하는 json 객체| ### Example ```javascript //Enum 열에 item을 설정한다. options.Cols = [ ... {Type: \"Enum\", Name: \"relation\", Enum: \"|안산1|안산2|화성1|화성2|화성3|일산1|일산2\", EnumMenu : { Items: [ { Menu: 1, Name: \"안산현장\", Items: [ {Name: \"[안산1] 경기도 안산시 단원구 광덕3로 201\",Value: \"안산1\"}, {Name: \"[안산2] 경기도 안산시 단원구 신길동 1509\",Value: \"안산2\"} ] }, { Menu: 1, Name: \"화성현장\", Items: [ {Name: \"[화성1] 경기도 화성시 반송동\", Value: \"화성1\"}, {Name: \"[화성2] 경기도 화성시 동탄대로22길 30\", Value: \"화성2\"}, {Name: \"[화성3] 경기도 화성시 산척동 283\", Value: \"화성3\"}, ] }, { Menu: 1, Name: \"일산현장\", Items: [ {Name: \"[일산1] 경기도 고양시 일산동구 정발산로82번길 10\", Value: \"일산1\"}, {Name: \"[일산2] 경기도 고양시 일산동구 장항동 1761\", Value: \"일산2\"}, ] } ] } ... }, ... ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "/docs/props/col/enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "/docs/props/col/enum-keys"
                },
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/enum-menu.html"
          },
          {
            "cid": 330,
            "sid": "enum-no-match-text",
            "name": "enum-no-match-text",
            "label": "EnumNoMatchText",
            "data": {
              "body": "> `EnumStrictMode` 를 1 로 설정했을 때 셀에 적용할 대체 텍스트를 설정합니다. > 해당 옵션은 `EnumStrictMode` : 1 에서만 사용할 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`EnumStrictMode`: 1 을 사용할 때 셀에 표시할 대체 텍스트 설정| ### Example ```javascript options.Cols = [ // EnumStrictMode 설정 { \"Header\": \"Enum1\", \"Type\": \"Enum\", \"MinWidth\": 80, \"Name\": \"sEnum\", \"ColMerge\": 0, \"Align\": \"Center\", \"Enum\": \"|한국|중국|일본\", \"EnumKeys\": \"|KOR|CHA|JAP\", \"EnumStrictMode\" : 1, \"EnumNoMatchText\" : \"대체 텍스트\", \"RelWidth\": 1 } ]; var data = [ // Enum, EnumKeys 에 아래 데이터가 없으므로 셀에는 \"대체 텍스트\" 라는 문구가 표시 됩니다. {sEnum: \"USA\"}, ... ]; ```",
              "see": [
                {
                  "label": "EnumStrictMode",
                  "url": "/docs/props/col/enum-strict-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.26|기능 추가|"
            },
            "url": "docs/props/col/enum-no-match-text.html"
          },
          {
            "cid": 331,
            "sid": "enum-strict-mode",
            "name": "enum-strict-mode",
            "label": "EnumStrictMode",
            "data": {
              "body": "> `Enum, EnumKeys`에 설정되지 않은 값은 조회 시 무시되고 `EnumStrictMode`를 `1`로 설정하게 되면 > 설정되지 않은 값을 셀에 적용 할 수 있습니다. ### ![EnumStrictMode](/assets/imgs/EnumStrictModes.png \"EnumStrictMode\") ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|`Enum, EnumKeys` 에 설정되지 않은 값을 셀에 적용하지않음. (`default`)| |`1`|`Enum, EnumKeys` 에 설정되지 않은 값을 셀에 적용.| |`2`|`Enum, EnumKeys` 에 설정되지 않은 값을 셀에 적용하고, Enum의 List에 해당 값을 추가합니다.| ### Example ```javascript options.Cols = [ ... // EnumStrictMode 설정 { \"Header\": \"Enum1\", \"Type\": \"Enum\", \"MinWidth\": 80, \"Name\": \"sEnum\", \"ColMerge\": 0, \"Align\": \"Center\", \"Enum\": \"|한국|중국|일본\", \"EnumKeys\": \"|KOR|CHA|JAP\", \"EnumStrictMode\" : 1, \"RelWidth\": 1 }, // EnumStrictMode 미설정 { \"Header\": \"Enum2\", \"Type\": \"Enum\", \"MinWidth\": 80, \"Name\": \"aEnum\", \"ColMerge\": 0, \"Align\": \"Center\", \"Enum\": \"|한국|중국|일본\", \"EnumKeys\": \"|KOR|CHA|JAP\", \"RelWidth\": 1 }, ... ]; var data = [ {sEnum: \"USA\", aEnum: \"USA\"}, ... ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "/docs/props/col/enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "/docs/props/col/enum-keys"
                },
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.3|기능 추가||core|8.2.0.26|`EnumStrictMode : 2` 추가|"
            },
            "url": "docs/props/col/enum-strict-mode.html"
          },
          {
            "cid": 332,
            "sid": "enum",
            "name": "enum",
            "label": "Enum",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Enum`이나 `Radio`일 때 보여질 item을 설정합니다. > 첫번째 글자를 구분자로 설정하게 됩니다. > [EnumKeys](./enum-keys) 속성을 통해 item의 실제값을 설정할 수 있습니다. ### ![Enum타입](/assets/imgs/enum1.png \"Enum\") [그림1] ![Radio타입](/assets/imgs/radioEnum.png \"Radio\") [그림2] ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#사장#부사장#전무#상무#이사#부서장#차장#과장#대리#주임#사원\")| ### Example ```javascript //Enum 열에 item을 설정한다. options.Cols = [ ... {Type: \"Enum\", Name: \"relation\", Enum: \"|직계존속|직계비속|배우자|자녀\" ...}, 또는 {Type: \"Enum\", Name: \"relation\", Enum: \"#직계존속#직계비속#배우자#자녀\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "EnumKeys col",
                  "url": "./enum-keys"
                },
                {
                  "label": "IconAlign col",
                  "url": "./icon-align"
                },
                {
                  "label": "MenuHSeparator cfg",
                  "url": "/docs/props/cfg/menu-h-separator"
                },
                {
                  "label": "Related col",
                  "url": "./related"
                },
                {
                  "label": "ShowImage cfg",
                  "url": "/docs/props/cfg/showImage"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/enum.html"
          },
          {
            "cid": 333,
            "sid": "exclude-empty",
            "name": "exclude-empty",
            "label": "ExcludeEmpty",
            "data": {
              "body": "> [FormulaRow](/docs/props/col/formula-row) 및 소계 / 누계행의 평균 또는 건수 등의 계산시 0 또는 빈 값을 포함 할지 여부를 설정합니다. ### > **적용되는 기능** > [makeSubTotal](/docs/funcs/core/make-sub-total) 소계/누계 평균/카운트 > [FormulaRow](/docs/props/col/formula-row) 평균/카운트/최소 > [GroupSubTotal](/docs/props/col/group-sub-total) 평균/카운트/최소 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|0 또는 빈 값 포함 (`default`)| |`1(true)`|0 또는 빈 값 포함 안 함| ### Example ```javascript options.Cols = [ ... {Type: \"Int\", Name: \"Pvt_TSum\", ExcludeEmpty: 1, ...}, ... ]; ```",
              "see": [
                {
                  "label": "makeSubTotal method",
                  "url": "/docs/funcs/core/make-sub-total"
                },
                {
                  "label": "FormulaRow col",
                  "url": "/docs/props/col/formula-row"
                },
                {
                  "label": "UseGroupSubTotal cfg",
                  "url": "/docs/props/cfg/use-group-sub-total"
                },
                {
                  "label": "GroupSubTotal col",
                  "url": "/docs/props/col/group-sub-total"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.45|기능 추가||core|8.1.0.46|빈 값 포함 추가||core|8.1.0.49|누계 계산 버그 수정 **(해당 버전부터 사용해주세요.)**|"
            },
            "url": "docs/props/col/exclude-empty.html"
          },
          {
            "cid": 334,
            "sid": "extend",
            "name": "extend",
            "label": "Extend",
            "data": {
              "body": "> 시트 생성시 Cols에 들어가는 열 설정([Type (col)](/docs/props/col/type), [Format (col)](/docs/props/col/format) 등)을 다른 변수로부터 가져와 적용합니다. > > 가령 프로젝트에서 달러를 표시하는 열에 대한 공통 규격을 아래와 같이 정했다고 가정합니다. > > 1. 숫자 앞에 \"$\"기호를 표시. > 2. 3자리 숫자 마다 \",\"가 보여지고, 소숫점 이하 1번째 자리까지만 표현. > 3. 열의 너비는 120px 이고 열의 너비는 사용자가 조절하지 못하게 끔 할 것. > 4. 배경색을 \"#FFFF88\"으로 표현. > > 이 경우 모든 프로젝트의 개발자가 위 내용을 숙지하여 달러가 표현되야 하는 모든 열에 대해서 [Type (col)](/docs/props/col/type), [Format (col)](/docs/props/col/format), [Width (col)](/docs/props/col/width) 등을 설정하는 것보다, 이러한 설정 정보를 미리 변수에 담아두고 해당 열을 만들때 변수의 내용을 적용하게 끔 한다면 훨신 쉽게 동일한 형태의 열을 만들 수 있습니다. > > 이렇게 `Extend` 속성은 공통 변수에 담긴 열 설정 정보를, 해당열에 적용시키는 기능을 합니다. > `Extend` 속성은 시트 생성시(create)에만 설정 가능하며, 이미 생성된 시트에는 적용되지 않습니다. > **<mark>주의</mark> : `Extend`을 통해 설정하는 속성과 동일한 속성을 시트 생성시 설정했을 경우에는, 어느 속성을 앞에 설정하느냐에 따라 우선순위가 결정됩니다(헤더 설정은 제외됩니다. 헤더의 경우 Cols 속성이 우선 순위가 더 높습니다).** ```javascript var defaultWidth = {Width: 100, MinWidth: 70}; var options = { Cols:[ {Width: 300, Extend: defaultWidth}, //너비가 100px로 설정됨 {Extend: defaultWidth, Width: 300} //너비가 300px로 설정됨 ] } ``` ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|[LeftCols, Cols, RightCols](/docs/appx/init-structure)에 들어가는 설정값 들| ### Example ```javascript //프로젝트 공통으로 사용할 열 설정 정보를 변수에 정의해 둡니다.(ibsheet-common.js파일 참고) var IB_Preset = { USD:{Type: \"Float\", Format: \"$ #,##0.#\", Width: 120, CanResize: 0,Color: \"#FFFF88\"}, //미화 표시 YMD:{Type: \"Date\", Format: \"yyyy-MM-dd\", EditFormat: \"yyyyMMdd\", Width: 110}, //년월일 기본 표시 REGD:{Type: \"Date\", Format: \"yyyy-MM-dd HH:mm\", DataFormat: \"yyyyMMddHHmm\",CanEdit: 0, Width: 150}, //작성일시 ... 여러가지 열 형식을 미리 정의해 둔다 ... }; //시트 생성시 Extend를 이용하여 열 생성 //(Name속성만 설정하고 나머지 설정은 Extend로 반영받는다.) options.Cols = [ //Type,Format 등이 모두 한꺼번에 적용된다. {Name: \"exportIncom\", Extend: IB_Preset.USD}, {Name: \"birthDate\", Extend: IB_Preset.YMD, CanEdit: 1}, {Name: \"ModiDate\", Extend: IB_Preset.REGD}, ... ]; ``` ### Try it - [Demo of Extend](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/Extend/)",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/extend.html"
          },
          {
            "cid": 335,
            "sid": "false-value",
            "name": "false-value",
            "label": "FalseValue",
            "data": {
              "body": "> `Bool타입` 열에는 기본적으로 `1(true)/0(false)`값만 입력이 가능합니다. > 하지만 디비에 저장된 값이 `1(true)/0(false)`가 아닌 별도의 값인 경우를 대비하여 `0(false)`값에 해당하는 값을 해당 속성을 통해 설정합니다. > 해당 속성을 통해 설정된 값은 데이터를 조회([doSearch](/docs/funcs/core/do-search),[loadSearchData](/docs/funcs/core/load-search-data)등)하거나 저장([doSave](/docs/funcs/core/do-save),[getSaveJson](/docs/funcs/core/get-save-json)등)할때 사용됩니다. > 이 속성 값은 단지 서버와 데이터를 주고 받을때만 사용될 뿐, 해당 셀의 값을 [getValue](/docs/funcs/core/get-value)함수를 통해 확인시에는 `1(true)/0(false)`로 리턴됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`Bool타입`의 열에 대해 `0(false)`(언체크)에 해당하는 값| ### Example ```javascript //Bool Type 열에 대해서 서버에서 주고 받는 값을 Y/N으로 설정 options.Cols = [ ... { Type: \"Bool\", Name: \"ConfirmYN\", Align: \"Center\", Width: 70, TrueValue: \"Y\", FalseValue: \"N\" }, ... ]; ``` ### Try it - [Set to \"N\" With Set to \"Y\" by TrueValue](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/TrueValue-FalseValue/)",
              "see": [
                {
                  "label": "TrueValue col",
                  "url": "./true-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/false-value.html"
          },
          {
            "cid": 336,
            "sid": "focus-cell",
            "name": "focus-cell",
            "label": "FocusCell",
            "data": {
              "body": "> 특정 열에 포커스가 들어갔을때 \"포커스 셀\"의 디자인을 정의 합니다. > 예약된 문자를 구분자 \",\"연결하여 설정합니다. > 기본적으로는 `\"Border,Class\"`로 구성됩니다. ### ```css .IBColorFocusedCell{background-color:#FFFFDD;} .IBClassFocusedCell{background-color:#DDDDDD;} ``` 위와 같이 클레스가 정의 되었을 경우 보여지는 모습은 다음과 같습니다. |설정값|보여지는 모습| |---|---| |Default 설정 (Border,Class)|![FocusCell](/assets/imgs/FocusCell3.png \"포커스된 셀의 모양\")| |Class 만 설정|![FocusCell](/assets/imgs/FocusCell2.png \"포커스된 셀의 모양\")| |Border,Color 로 설정|![FocusCell](/assets/imgs/FocusCell1.png \"포커스된 셀의 모양\")| ### Type `string` ### Options |Value|Description| |-----|-----| |`Border`|포커스된 셀의 테두리를 적용| |`Color`|포커스된 셀의 td 태그에 배경색으로 css/default(테마)/main.css 파일에 IBColorFocusedCell 클레스에서 정의한 색상이 적용(성능 저하가 있을 수 있음)| |`Class`|css/default(테마)/main.css 파일에 IBClassFocusedCell 클레스에 정의한 디자인을 따릅니다.| ### Example ```javascript //열에 포커스가 들어갔을때 셀의 테두리만 보여줌. options.Cols = [ ... {Type: \"Text\", Name: \"EM_DC\", FocusRow: \"\", FocusCell: \"Border\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "FocusCell cell",
                  "url": "/docs/props/cell/focus-cell"
                },
                {
                  "label": "FocusRow row",
                  "url": "/docs/props/row/focus-row"
                },
                {
                  "label": "FocusRow col",
                  "url": "./focus-row"
                },
                {
                  "label": "FocusRow cell",
                  "url": "/docs/props/cell/focus-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/focus-cell.html"
          },
          {
            "cid": 337,
            "sid": "focus-row-2",
            "name": "focus-row",
            "label": "FocusRow",
            "data": {
              "body": "> 셀을 클릭시 보여지는 \"커서 포커스 행\"은 Table 객체 위에 DIV 객체가 떠있는 형태로 구성됩니다. > 특정 셀에 포커스가 있을때 보여질 \"커서 포커스 행\"의 디자인을 설정합니다. > 예약된 문자를 구분자 \",\"연결하여 설정합니다. > 기본적으로는 \"Border, Background\"로 구성됩니다. ### ![FocusRow](/assets/imgs/focusRow1.png \"FocusRow default\") [일반 `FocusRow`] ![FocusRow](/assets/imgs/focusRow2.png \"FocusRow default\") [`border`없이 `Background`로 설정시] ### Type `string` ### Options |Value|Description| |-----|-----| |`Border`|커서 포커스 DIV의 테두리 사용 (.IBFocusRowBorder)| |`Background`|커서 포커스 DIV의 배경색 사용 (.IBFocusRowBackground) | |`Color`|커서 포커스 DIV를 사용하지 않고 Table 객체에 background-color를 부여 (성능이 저하될수 있음,포커스 셀은 제외) (.IBColorFocused) | |`Class`|css/default(테마)/main.css 파일에 .IBClassFocused 클레스에 정의한 디자인을 따릅니다. (포커스 셀은 제외)| ### Example ```javascript //열에 포커스가 들어갔을때 포커스행에 대해 테두리만 보여주고 배경색을 사용 안함. options.Cols = [ ... {Type: \"Text\", Name: \"EM_DC\", FocusRow: \"Border\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "FocusRow row",
                  "url": "/docs/props/row/focus-row"
                },
                {
                  "label": "FocusRow cell",
                  "url": "/docs/props/cell/focus-row"
                },
                {
                  "label": "FocusCell col",
                  "url": "./focus-cell"
                },
                {
                  "label": "FocusCell cell",
                  "url": "/docs/props/cell/focus-cell"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/focus-row.html"
          },
          {
            "cid": 338,
            "sid": "format-fix",
            "name": "format-fix",
            "label": "FormatFix",
            "data": {
              "body": "> 저장 함수([getSaveJson](/docs/funcs/core/get-save-json), [getSaveString](/docs/funcs/core/get-save-string), [doSave](/docs/funcs/core/do-save)) 호출시 `Format` 적용된 문자열로 추출하는 기능. > [getString](/docs/funcs/core/get-string)으로 출력하는 값과 동일함. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|본래 저장 함수 호출시 데이터 출력 (`default`)| |`1(true)`|`Format`이 적용된 데이터 출력 (`getString과 동일`)| ### Example ```javascript // 해당 Money Col은 getString 과 동일한 데이터가 출력되도록 한다. options.Cols = [ {Type: \"Int\", Name: \"Money\", Align: \"Center\", Format: \"#,### 만원\", FormatFix: true}, {Type: \"Float\", Name: \"Grow\", Align: \"Center\", Format: \"#,##0.##%\"} ... ]; ```",
              "see": [
                {
                  "label": "doSave method",
                  "url": "/docs/funcs/core/do-save"
                },
                {
                  "label": "getSaveJson method",
                  "url": "/docs/funcs/core/get-save-json"
                },
                {
                  "label": "getSaveString method",
                  "url": "/docs/funcs/core/get-save-string"
                },
                {
                  "label": "getString method",
                  "url": "/docs/funcs/core/get-string"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/props/col/format-fix.html"
          },
          {
            "cid": 339,
            "sid": "format",
            "name": "format",
            "label": "Format",
            "data": {
              "body": "> 원본 데이터에 대한 마스킹된 데이터를 정의합니다. > 원본 데이터와 무관하게 사용자에게 마스크를 적용한 데이터를 보여줍니다. > `Format`은 열의 [Type](./type)에 따라 다양하게 정의될 수 있습니다. > **자세한 내용은 7장 appendix의 [Format](/docs/appx/format)을 참고해 주세요.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열의 `Type`에 따른 다양한 포맷설정 문자열| ### Example ```javascript //날짜 포맷을 정의합니다. options.Cols = [ ... {Type: \"Date\", Name: \"sa_enterDate\", Format: 'MM-dd-yyyy' ...}, ... ]; ```",
              "see": [
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                },
                {
                  "label": "EditFormat col",
                  "url": "./edit-format"
                },
                {
                  "label": "DataFormat col",
                  "url": "./data-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/format.html"
          },
          {
            "cid": 340,
            "sid": "formula-row",
            "name": "formula-row",
            "label": "FormulaRow",
            "data": {
              "body": "> `Foot` 영역에 고정된 행을 생성하여 열의 합계나 평균값을 보여줍니다. > `id`는 `FormulaRow`로 생성되며, `NoColor:2` 속성이 기본으로 들어갑니다. > `SearchMode:3, 4, 5` 일 경우에는 사용 할 수 없습니다. > 숫자형 컬럼(`Int`, `Float`)를 제외한 다른 컬럼은 `\"Count\"`만 사용 가능합니다. ### ![FormulaRow](/assets/imgs/formulaRow.png) ![FormulaRow](/assets/imgs/formulaRow1.png) ### Type `mixed`( `string` \\| `function` ) ### Options |Value|Description| |-----|-----| |`'Sum'` 또는 `'합계 {Sum} 원'`|열의 합계값| |`'Avg'` 또는 `'평균 {Avg}'`|열의 평균값| |`'Max'` 또는 `'최대값 {Max}'`|열의 최대값| |`'Min'` 또는 `'최소값 {Min}'`|열의 최소값| |`'Count'` 또는 `'{Count} 건'`|행의 개수| |`function`|사용자 정의 함수| ### Example ```javascript options.Cols = [ // ... { Type: \"Int\", Name: \"qt\", FormulaRow: \"Sum\", Width: 120, // ... }, { Type: \"Int\", Name: \"rate\", FormulaRow: \"Avg\", Width: 120, // ... }, { Type: \"Int\", Name: \"brnSaleAmt\", FormulaRow: \"최대값 {Max}\", //FormulaRow 행에 text+값 형태로 표현 Width: 120, // ... }, { //사용자 정의 함수(글자색이 \"#FF0000\"인 행의 수 리턴) Type: \"Text\", Name: \"user\", FormulaRow: function(fr){ var rows = fr.Sheet.getDataRows(); var count = 0; for(var i = 0; i < rows.length; i++){ //row의 TextColor 색상이 빨간색만 count if( rows[i].TextColor == \"#FF0000\"){ count++; } } return \"경고 :\" + count + \"건\"; }, Width: 120, // ... }, // ... ]; // 객체 직접 접근하여 FormulaRow 행의 sDetail셀 값 교체 sheet.getRowById(\"FormulaRow\")[\"sDetailVisible\"] = 1; // 셀의 Visible 속성변경. sheet.getRowById(\"FormulaRow\")[\"sDetail\"] = \"가나다\"; sheet.refreshRow(sheet.getRowById(\"FormulaRow\")); //setValue로 값 교체 sheet.setValue(sheet.getRowById(\"FormulaRow\"),\"sDetail\",\"가나다\"); ```",
              "see": [
                {
                  "label": "NoCalculate row",
                  "url": "/docs/props/row/no-calculate"
                },
                {
                  "label": "NoColor row",
                  "url": "/docs/props/row/no-color"
                },
                {
                  "label": "Formula appendix",
                  "url": "/docs/appx/formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.2.0.3|{Sum, Avg, Max, Min, Count} 기능 추가|"
            },
            "url": "docs/props/col/formula-row.html"
          },
          {
            "cid": 341,
            "sid": "formula",
            "name": "formula",
            "label": "Formula",
            "data": {
              "body": "> 열 간에 계산 로직을 문자열이나 함수를 통해 설정합니다. > 함수 형태로 `Formula`를 설정시에는 반드시 `return값`이 있어야 반영됩니다. > > ※**매우중요** > 1. 모든 포뮬러 기능을 사용시에는 (row)[**CanFormula**](/docs/props/row/can-formula)가 1로 설정되어야 동작합니다. > 2. 열 간의 계산의 순서를 정하기 위해 반드시 (row)[**CalcOrder**](/docs/props/row/calc-order)를 정의해야 합니다. > > `Formula`로 설정한 기능은 조회되거나, 연관된 열의 값이 사용자의 편집에 의해 변경될 때 자동으로 계산,적용됩니다. > 특히 Formula를 통해 값이 변경되는 것도 Formula를 일으키므로 자신의 컬럼값을 Formula를 통해 수정하는 것은 권장하지 않습니다.(Formula에 의해 수정되면서 다시 Formula가 발생하여 무한루프에 빠질수 있음) > 자세한 내용은 7장 [Formula appendix](/docs/appx/formula)를 참고하세요. ### Type `mixed`( `function` \\| `string` ) ### Options |Value|Description| |-----|-----| |`string`|열이름을 기준으로 한 계산 로직 (ex: \"sCount \\* sPrice - ( Discount \\* Rate ) \\* 1.24\")| |`function`|별도 함수를 통해 계산 가능(함수 내에서는 `Sheet, Row, Col` 예약어를 통해 접근 가능)| ### Example ```javascript // yearSum열이 먼저 계산되고 total열이 계산됨. options.Def.Row = {CanFormula: 1, CalcOrder: \"yearSum,total\"}; options.Cols = [ ... {Type: \"Int\", Name: \"qt1\", Width: 120 ...}, {Type: \"Int\", Name: \"qt2\", Width: 120 ...}, {Type: \"Int\", Name: \"qt3\", Width: 120 ...}, {Type: \"Int\", Name: \"qt4\", Width: 120 ...}, {Type: \"Int\", Name: \"yearSum\", Formula:function(fr){ return fr.Row[\"qt1\"] + fr.Row[\"qt2\"] + fr.Row[\"qt3\"] + fr.Row[\"qt4\"]; } }, {Type: \"Float\", Name: \"rate\"}, {Type: \"Float\", Name: \"total\", Formula:function(fr){ return fr.Row[\"yearSum\"] * fr.Row[\"rate\"]; } }, ... ]; ``` ### Try it - [Demo of Formula](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/Formula/)",
              "see": [
                {
                  "label": "CanFormula row",
                  "url": "/docs/props/row/can-formula"
                },
                {
                  "label": "CalcOrder row",
                  "url": "/docs/props/row/calc-order"
                },
                {
                  "label": "attribute+Formula appendix",
                  "url": "/docs/props/col/attribute-formula"
                },
                {
                  "label": "Formula appendix",
                  "url": "/docs/appx/formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/formula.html"
          },
          {
            "cid": 342,
            "sid": "gmt",
            "name": "gmt",
            "label": "GMT",
            "data": {
              "body": "> 열의 [Type](/docs/appx/type)이 `Date`일 때 기준 시간대를 설정합니다. > 조회된 시간을 기준으로 UTC시간으로 변경하여 보여줍니다. > 이는 시트에 보여지는 값일뿐 실제 값과는 무관합니다. 가령 조회데이터가 \"2017-05-25 14:30\" 인 경우, 이 속성의 값을 1로 설정하면 실제 시트상에는 \"2017-05-25 05:30\"으로 표시됩니다.(한국은 GMT +9 이기 때문) > 하지만 값을 \"2017-05-25 06:30\"으로 수정하여 저장하면, 실제로 전송되는 데이터는 \"2017-05-25 15:30\"이 전송됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|사용자 피시의 시간대 (`default`)| |`1(true)`|GMT/UTC 시간대| ### Example ```javascript //UTC로 보기 options.Cols = [ ... {Type: \"Date\", Name: \"sa_enterDate\", Format: 'MM-dd-yyyy HH:mm',DataFormat: \"yyyyMMddHHmmss\", GMT: 1 ...}, ... ]; ``` ### Try it - [Set to 1](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/GMT-1/)",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/gmt.html"
          },
          {
            "cid": 343,
            "sid": "group-char",
            "name": "group-char",
            "label": "GroupChar",
            "data": {
              "body": "> 그룹 기준 열 내에서 특정 문자를 기준으로 Split하여 하위 노드로 만들어주는 기능입니다. > 가령 열에 \"ABCD-EF12\",\"ABCD-EF22\"와 같은 값이 있고, `GroupChar: \"-\"` 로 선언하면 실제 값은 다음과 같이 보여지게 됩니다. ### ![GroupChar](/assets/imgs/groupChar.png \"내용 내에서 특정 문자를 기준으로 다시 그룹핑한다.\") ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|그룹 데이터 내에서 나눌 기준 문자| ### Example ```javascript //특정문자를 기준으로 그룹핑을 나눈다 options.Cols = [ ... {Type: \"Text\", Name: \"Product_Name\", Width: 100, GroupChar: \"-\", ...}, ... ]; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "MaxChars col",
                  "url": "./max-chars"
                },
                {
                  "label": "CanGroup col",
                  "url": "./can-group"
                },
                {
                  "label": "GroupDef col",
                  "url": "./group-def"
                },
                {
                  "label": "GroupWidth col",
                  "url": "./group-width"
                },
                {
                  "label": "GroupEmpty col",
                  "url": "./group-empty"
                },
                {
                  "label": "GroupSole col",
                  "url": "./group-sole"
                },
                {
                  "label": "GroupSingle col",
                  "url": "./group-single"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/group-char.html"
          },
          {
            "cid": 344,
            "sid": "group-def",
            "name": "group-def",
            "label": "GroupDef",
            "data": {
              "body": "> 열이 그룹핑될때, 그룹행에 적용될 공통 설정을 지정합니다. > 시트 초기화시 `Def` 영역에 커스텀하게 기능을 설정해 두고, 해당 열에서 `Def`에 정의된 ID를 지정해 설정하실 수 있습니다. > `Def` 영역에 커스텀하게 기능을 설정할 때 `Def` 속성에 <b>반드시 `Group`을 설정</b>해야 정상적으로 동작합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|Def에 설정한 커스텀 기능 ID| ### Example ```javascript options.Def = { //커스텀 그룹행 설정 \"myGroupRow\": {Def: \"Group\", Color: \"#FFADAD\", CanEdit: 0, CanFocus: 0} }; //특정 열에 대해 그룹핑 불허 options.Cols = [ ... {Type: \"Text\", Name: \"SA_DEPTID\", GroupDef: \"myGroupRow\", ...}, ... ]; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "CanGroup col",
                  "url": "./can-group"
                },
                {
                  "label": "GroupWidth col",
                  "url": "./group-width"
                },
                {
                  "label": "GroupEmpty col",
                  "url": "./group-empty"
                },
                {
                  "label": "GroupSole col",
                  "url": "./group-sole"
                },
                {
                  "label": "GroupSingle col",
                  "url": "./group-single"
                },
                {
                  "label": "GroupDeleted col",
                  "url": "./group-deleted"
                },
                {
                  "label": "GroupChar col",
                  "url": "./group-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/group-def.html"
          },
          {
            "cid": 345,
            "sid": "group-deleted",
            "name": "group-deleted",
            "label": "GroupDeleted",
            "data": {
              "body": "> 삭제예정인 행([Deleted](/docs/props/row/deleted))을 그룹핑에 포함시킬지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|삭제 예정인 행은 그룹핑 제외| |`1(true)`|삭제 예정인 행도 그룹핑에 포함 (`default`)| ### Example ```javascript //삭제 예정 행에 대해 그룹핑에서 제외합니다. options.Def.Col = {GroupDeleted: 0}; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "CanGroup col",
                  "url": "./can-group"
                },
                {
                  "label": "GroupDef col",
                  "url": "./group-def"
                },
                {
                  "label": "GroupWidth col",
                  "url": "./group-width"
                },
                {
                  "label": "GroupEmpty col",
                  "url": "./group-empty"
                },
                {
                  "label": "GroupSole col",
                  "url": "./group-sole"
                },
                {
                  "label": "GroupSingle col",
                  "url": "./group-single"
                },
                {
                  "label": "GroupChar col",
                  "url": "./group-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/group-deleted.html"
          },
          {
            "cid": 346,
            "sid": "group-empty",
            "name": "group-empty",
            "label": "GroupEmpty",
            "data": {
              "body": "> `0` 또는 `\"\"(공백)` 에 대해서 그룹핑을 할지 여부를 설정합니다. > 그룹핑 제외된 행은 상단에 위치하게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|0이나 \"\"(공백) 모두 그룹핑 불가| |`1`|0은 그룹핑 가능하나 \"\"(공백)은 그룹핑 불가| |`2`|0이나 \"\"(공백) 모두 그룹핑 가능 (`default`)| ### Example ```javascript //\"\"(공백) 행을 그룹에서 제외시킨다. options.Cols = [ ... {Type: \"Text\", Name: \"Product_Name\", Width: 100, GroupEmpty: 0, ...}, ... ]; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "CanGroup col",
                  "url": "./can-group"
                },
                {
                  "label": "GroupDef col",
                  "url": "./group-def"
                },
                {
                  "label": "GroupWidth col",
                  "url": "./group-width"
                },
                {
                  "label": "GroupSole col",
                  "url": "./group-sole"
                },
                {
                  "label": "GroupSingle col",
                  "url": "./group-single"
                },
                {
                  "label": "GroupDeleted col",
                  "url": "./group-deleted"
                },
                {
                  "label": "GroupChar col",
                  "url": "./group-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/group-empty.html"
          },
          {
            "cid": 347,
            "sid": "group-single",
            "name": "group-single",
            "label": "GroupSingle",
            "data": {
              "body": "> 해당 열을 기준으로 그룹행 생성시, 하위노드의 값이 모두 동일한 경우(그룹 기준이 되는 열의 모든 값이 동일한 경우) 그룹열을 생성할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열의 모든 내용이 같은 경우 그룹 열을 생성하지 않음| |`1(true)`|열의 모든 내용이 동일해도 그룹 열 생성 (`default`)| ### Example ```javascript //열 내에 모든 값이 같은 경우 그룹열 생성 안함 options.Cols = [ ... {Type: \"Text\", Name: \"SA_DEPTID\", GroupSingle: 0, ...}, ... ]; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "CanGroup col",
                  "url": "./can-group"
                },
                {
                  "label": "GroupDef col",
                  "url": "./group-def"
                },
                {
                  "label": "GroupWidth col",
                  "url": "./group-width"
                },
                {
                  "label": "GroupEmpty col",
                  "url": "./group-empty"
                },
                {
                  "label": "GroupSole col",
                  "url": "./group-sole"
                },
                {
                  "label": "GroupDeleted col",
                  "url": "./group-deleted"
                },
                {
                  "label": "GroupChar col",
                  "url": "./group-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/group-single.html"
          },
          {
            "cid": 348,
            "sid": "group-sole",
            "name": "group-sole",
            "label": "GroupSole",
            "data": {
              "body": "> 해당 열을 기준으로 그룹행 생성시, 하위 노드가 한행인 경우 그룹에서 제외 시킬지 여부를 설정합니다. . ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|자식행이 단일행인 경우 그룹핑을 하지 않음| |`1(true)`|자식행 개수와 무관하게 그룹핑 (`default`)| ### Example ```javascript //단일 자식행에 대해서는 그룹핑을 하지 않는다. options.Cols = [ ... {Type: \"Text\", Name: \"SA_DEPTID\", GroupSole: 0, ...}, ... ]; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "CanGroup col",
                  "url": "./can-group"
                },
                {
                  "label": "GroupDef col",
                  "url": "./group-def"
                },
                {
                  "label": "GroupWidth col",
                  "url": "./group-width"
                },
                {
                  "label": "GroupEmpty col",
                  "url": "./group-empty"
                },
                {
                  "label": "GroupSingle col",
                  "url": "./group-single"
                },
                {
                  "label": "GroupDeleted col",
                  "url": "./group-deleted"
                },
                {
                  "label": "GroupChar col",
                  "url": "./group-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/group-sole.html"
          },
          {
            "cid": 349,
            "sid": "group-sub-total",
            "name": "group-sub-total",
            "label": "GroupSubTotal",
            "data": {
              "body": "> [UseGroupSubTotal cfg](/docs/props/cfg/use-group-sub-total) 그룹 소계 기능 사용시, 그룹 소계행에 적용될 옵션을 설정합니다. > 소계 계산을 표현할 열에 `Type`, `Color`, `Format`을 설정할 수 있습니다. > 반드시 [UseGroupSubTotal cfg](/docs/props/cfg/use-group-sub-total) 을 설정</b>해야 정상적으로 동작합니다. ### Type `object` ### Options |Name|Type|Required|Description| |----------|-----|---|----| |`Type`|`string`|<span class='required'>필수</span>|계산 타입 `\"Sum\"`: 합계 `\"Avg\"`: 평균 `\"Count\"`: 갯수 `\"Max\"`: 최대값 `\"Min\"`: 최소값| |`Color`|`string`|<span class='optional'>선택</span>|소계행의 배경색 \"#FFFFEF\" (`default`)| |`Format`|`string`|<span class='optional'>선택</span>|소계 계산에 적용할 포맷 열에 적용된 \"Format\" (`default`)| ### Example ```javascript options.cfg = { \"Group\": \"SA_DEPTID\", //그룹 소계 기능 사용 설정 \"UseGroupSubTotal\": 1 }; //그룹 소계행 설정 options.Cols = [ ... {Type: \"Int\", Name: \"SA_DEPTID\", GroupSubTotal: { Type: \"Sum\", Color: \"#FFDDAA\" ,\"Format\": \"#,###\"}, ...}, ... ]; ```",
              "see": [
                {
                  "label": "UseGroupSubTotal cfg",
                  "url": "/docs/props/cfg/use-group-sub-total"
                },
                {
                  "label": "Group cfg",
                  "url": "./docs/props/cfg/group"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.8|기능 추가|"
            },
            "url": "docs/props/col/group-sub-total.html"
          },
          {
            "cid": 350,
            "sid": "group-width",
            "name": "group-width",
            "label": "GroupWidth",
            "data": {
              "body": "> 열이 그룹핑 될 때, 그룹 트리가 생성될 열(`GroupMain` 옵션에 지정된 열. `GroupMain` 옵션이 없을 시 `SEQ`를 제외한 첫 번째 열)의 너비를 지정한 크기로 조정합니다. 값을 1로 설정 시 열의 데이터 양에 따라 자동으로 조절됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|그룹핑 될때 열의 너비(pixel단위)| ### Example ```javascript //열이 그룹핑될 때 그룹 트리가 위치될 열의 너비를 210px로 수정 options.Cols = [ ... {Type: \"Text\", Name: \"SA_Name\", Width: 100, GroupWidth: 210, ...}, ... ]; ```",
              "see": [
                {
                  "label": "GroupFormat cfg",
                  "url": "/docs/props/cfg/group-format"
                },
                {
                  "label": "CanGroup col",
                  "url": "./can-group"
                },
                {
                  "label": "GroupDef col",
                  "url": "./group-def"
                },
                {
                  "label": "GroupEmpty col",
                  "url": "./group-empty"
                },
                {
                  "label": "GroupSole col",
                  "url": "./group-sole"
                },
                {
                  "label": "GroupSingle col",
                  "url": "./group-single"
                },
                {
                  "label": "GroupDeleted col",
                  "url": "./group-deleted"
                },
                {
                  "label": "GroupChar col",
                  "url": "./group-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/group-width.html"
          },
          {
            "cid": 351,
            "sid": "h-radio",
            "name": "h-radio",
            "label": "HRadio",
            "data": {
              "body": "> `Type`이 `Radio` 열(혹은 열들)에 대해서 단일 선택 여부를 설정합니다. > `0(false)`으로 설정시 해당 컬럼 내에서 단일 셀만 선택 가능하게 합니다. > `1(true)`으로 설정시 해당 행 내에서 단일 셀만 선택 가능하게 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|한 열안에서 하나만 선택| |`1(true)`|한 행안에서 하나만 선택| ### Example ```javascript //st1 컬럼 내에서 단일 셀만 선택가능하게 함. //st2, st3 열 중에 한개 셀만 선택 가능 options.Cols = [ ... {Type: \"Radio\", Name: \"st1\", HRadio: 0 ...}, {Type: \"Radio\", Name: \"st2\", HRadio: 1 ...}, {Type: \"Radio\", Name: \"st3\", HRadio: 1 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Radio col",
                  "url": "./radio"
                },
                {
                  "label": "Range col",
                  "url": "./range"
                },
                {
                  "label": "RadioIcon col",
                  "url": "./radio-icon"
                },
                {
                  "label": "RadioIconWidth col",
                  "url": "./radio-icon-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/h-radio.html"
          },
          {
            "cid": 352,
            "sid": "header-check-2",
            "name": "header-check",
            "label": "HeaderCheck",
            "data": {
              "body": "> 타입이 `Bool`인 열의 헤더에 체크 박스를 생성하며, 체크 박스를 클릭 시 해당 열에 있는 모든 셀의 체크박스를 **체크** 또는 **체크해제**합니다. > 모든 `Bool`타입 열에 대해 헤더 체크박스를 적용 하고자 하실 때는 [(Cfg)HeaderCheck](/docs/props/cfg/header-check)를 참고하세요. > [(Cfg)HeaderCheck](/docs/props/cfg/header-check) 속성과 같이 사용시에는 이 속성이 적용 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| | `0` | 체크 박스 생성 안함| | `1` | 체크 박스 생성| ### Example ```javascript options.Cols = [ ... { Header:{ Value: \"체크박스\", HeaderCheck: 1 }, Type: \"Bool\", Name: \"sCheckBox\", Width: 100, ... }, ... ]; ```",
              "see": [
                {
                  "label": "HeaderCheck cfg",
                  "url": "/docs/props/cfg/header-check"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/header-check.html"
          },
          {
            "cid": 353,
            "sid": "header",
            "name": "header",
            "label": "Header",
            "data": {
              "body": "> 열의 헤더 셀을 정의합니다. > 단순히 헤더셀에 들어가야 할 문자열을 설정 할 수도 있고, 셀의 색상이나 정렬 등의 기능을 같이 정의하거나 여러 개의 헤더행을 만들기 위해 배열로 설정 할 수도 있습니다. > **여러 개의 헤더 행을 만드는 경우 컬럼별 헤더 배열의 길이는 같아야 합니다.** > **<mark>주의</mark> : 헤더에 빈값을 셋팅하려면 공백데이터를 포함해야 합니다. Header:\"<mark> </mark>\"** ### Type `mixed`( `string` \\| `object` \\| `array[string|object]` ) ### Options |Value|Description| |-----|-----| |`string`|헤더셀에 들어갈 타이틀(`\\n` 줄바꿈 기호를 통해 문자열을 줄바꿈 할 수 있습니다.)| |`object`|헤더셀에 들어갈 타이틀과 문자열 정렬, 배경색 등을 설정| |`array`\\[`string`\\|`object`\\]|여러개의 헤더 행을 만드는 경우 설정| ### Example 한줄 헤더행 예) ```javascript options.Cols = [ { //string 형태로 사원명 지정 Header: \"사원명\", // Header: \"사원\\n명\" 을 하면 줄바꿈 되어 표시 됩니다. Type: \"Text\", MinWidth: 120, Name: \"sa_name\" }, { //object 형태의 사원명 지정 Header: {Value: \"부서\", Color: \"#EDEDED\", TextColor: \"#FF0000\", Align: \"Left\"}, Type: \"Text\", MinWidth: 120, Name: \"deptCd\" } ]; ``` ![\"한줄헤더\"](/assets/imgs/headerSingleRow.png) 두줄 해더행 예) ```javascript options.Cfg = {HeaderMerge: 3}; //헤더 영역 머지모드 options.Cols = [ // String 형태로 간단하게 설정 { Header: [\"사원정보\", \"이름\"], Type: \"Text\", MinWidth: 120, Name: \"sa_name\" }, { Header: [\"사원정보\",\"사번\"], Type: \"Text\", MinWidth: 80, Name: \"sa_no\" } ] //or options.Cfg = {HeaderMerge: 3}; //헤더 영역 머지모드 options.Cols = [ // Object 형태로 배경이나 글자색,정렬등을 같이 설정하는 방법 { Header:[ {Value: \"사원정보\", Align: \"Center\"}, {Value: \"이름\", Color: \"#315C81\", TextColor: \"#FFEEFF\", Align: \"Left\"} ], Type: \"Text\", MinWidth: 120, Name: \"sa_name\" }, { Header:[ {Value: \"사원정보\"}, {Value: \"사번\", Color: \"#315C81\", TextColor: \"#ED6655\", Align: \"Left\"} ], Type: \"Text\", MinWidth: 80, Name: \"sa_no\" }, ]; ``` ![\"두줄헤더\"](/assets/imgs/headerDoubleRow.png)",
              "see": [
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/header-merge"
                },
                {
                  "label": "Span cell",
                  "url": "/docs/props/cell/span"
                },
                {
                  "label": "RowSpan cell",
                  "url": "/docs/props/cell/row-span"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/header.html"
          },
          {
            "cid": 354,
            "sid": "hide-mobile",
            "name": "hide-mobile",
            "label": "HideMobile",
            "data": {
              "body": "> 모바일 환경에서 열의 보임 감춤/여부를 설정합니다. > **※ iPad Pro나 Surface Pro는 모바일로 분류되지 않습니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열 보임 (`default`)| |`1(true)`|열 감춤| ### Example ```javascript // 특정 열을 모바일에서 감춤 options.Cols = [ ... {Type: \"Int\", Name: \"Product_Sales\", HideMobile: true, ...}, ... ]; ```",
              "see": [
                {
                  "label": "BreakPoint col",
                  "url": "/docs/props/col/break-point"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/hide-mobile.html"
          },
          {
            "cid": 355,
            "sid": "hint-value-2",
            "name": "hint-value",
            "label": "HintValue",
            "data": {
              "body": "> 힌트는 열의 너비가 좁아 셀의 내용의 일부가 안보일 때, 마우스 커서가 올라간 셀에 한해 일시적으로 셀의 너비를 늘려 안보이던 뒷 내용을 보여주는 기능입니다. > 힌트기능 사용시 원래 셀의 내용 대신에 설정한 내용이 보여지게끔 설정합니다. ### ![힌트활성화](/assets/imgs/hint1.png \"마우스 커서가 셀에 올라갔을때 힌트를 통해 감춰진 부분이 보여짐\") [**힌트기능 사용 예**] ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|힌트기능 활성화시(마우스커서가 셀 위에 Over시) 보여질 문자| ### Example ```javascript //특정 열에 힌트기능을 사용합니다. options.Cols = [ ... {Type: \"Text\", HintValue: \"이번 분기는 마감되었습니다.\", ShowHint: 2, Name: \"DESC\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "ShowHint col",
                  "url": "./show-hint"
                },
                {
                  "label": "ShowHint row",
                  "url": "/docs/props/row/show-hint"
                },
                {
                  "label": "onShowHint event",
                  "url": "/docs/events/on-show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/hint-value.html"
          },
          {
            "cid": 356,
            "sid": "html-postfix-2",
            "name": "html-postfix",
            "label": "HtmlPostfix",
            "data": {
              "body": "> 열의 각 셀의 문자열 뒤에 원하는 `HTML 태그`를 삽입합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 `HTML태그`| ### Example ```javascript //열의 뒤에 icon 이미지를 추가한다 options.Cols = [ ... {Type: \"Text\", Name: \"sa_nm\", HtmlPostfix: '<i class=\"fas fa-apple-alt\"></i>'}, ... ]; ```",
              "see": [
                {
                  "label": "HtmlPrefix col",
                  "url": "./html-prefix"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/html-postfix.html"
          },
          {
            "cid": 357,
            "sid": "html-prefix-2",
            "name": "html-prefix",
            "label": "HtmlPrefix",
            "data": {
              "body": "> 열의 각 셀의 문자열 앞에 원하는 `HTML 태그`를 삽입합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 `HTML태그`| ### Example ```javascript //열의 앞에 icon 이미지를 추가한다 options.Cols = [ ... {Type: \"Text\", Name: \"sa_nm\", HtmlPrefix:' <i class=\"fas fa-apple-alt\"></i>'}, ... ]; ```",
              "see": [
                {
                  "label": "HtmlPostfix col",
                  "url": "./html-postfix"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/html-prefix.html"
          },
          {
            "cid": 358,
            "sid": "icon-align",
            "name": "icon-align",
            "label": "IconAlign",
            "data": {
              "body": "> 셀 좌측에 버튼(혹은 체크박스)을 표시하는 [Icon](./icon)속성 사용시, 버튼의 위치를 설정합니다. > 기본적으로 셀의 좌측에 표시되면 오른쪽에 표시 할 수도 있습니다.. ### Type `string` ### Options |Value|Description| |-----|-----| |`Left`|셀 좌측에 `Icon` 표시 (`default`)| |`Right`|셀 우측에 `Icon` 표시| ### Example ```javascript options.Cols = [ ... //Enum 버튼을 셀 우측에 표시한다. {Type: \"Enum\", Name: \"brnSaleAmt\", IconAlign: \"Right\", Enum: \"|사장|부장|차장|과장\", EnumKeys: \"|AA|BB|CC|DD\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "Icon col",
                  "url": "./icon"
                },
                {
                  "label": "IconWidth cell",
                  "url": "../cell/icon-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.4|기능 추가|"
            },
            "url": "docs/props/col/icon-align.html"
          },
          {
            "cid": 359,
            "sid": "icon-width",
            "name": "icon-width",
            "label": "IconWidth",
            "data": {
              "body": "> 셀 좌측에 버튼을 표시하는 [Icon](./icon) 속성 사용 시, 커스텀 이미지를 사용하는 경우 버튼의 영역 너비를 설정합니다. > 너비는 pixel 단위로 설정됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|셀 좌측 버튼의 너비.| ### Example ```javascript options.Cols = [ ... //셀의 좌측에 이미지로 버튼을 추가합니다. {Type: \"Text\", Name: \"brnSaleAmt\", Icon: \"Icon\", IconSrc: \"/pcd/img/popIcon.png\", IconWidth: 15, Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Icon col",
                  "url": "./icon"
                },
                {
                  "label": "IconSrc col",
                  "url": "./icon-src"
                },
                {
                  "label": "IconWidth cell",
                  "url": "../cell/icon-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/icon-width.html"
          },
          {
            "cid": 360,
            "sid": "icon",
            "name": "icon",
            "label": "Icon",
            "data": {
              "body": "> 셀의 좌측에 원하는 아이콘 이미지, 체크박스 혹은 버튼을 표시하는 기능입니다. > 셀의 우측에 버튼을 표시하는 [Button](/docs/props/col/button) 속성과 유사한 기능입니다. > 열의 타입이 `Button`인 경우에는 사용하실 수 없습니다. ### ![Icon속성](/assets/imgs/Icon2.png \"Icon속성\") [그림1] ![Icon속성](/assets/imgs/Icon1.png \"Icon속성\") [그림2] ![Icon속성](/assets/imgs/iconDefaults.png \"Icon속성\") [그림3] ### Type `string` ### Options |Value|Description| |-----|-----| |`Clear`|셀 좌측에 셀 내용을 지우기위한 버튼이 표시됩니다.| |`Date`|셀 좌측에 달력 아이콘을 보여줍니다. 열의 타입이 `Date`인 경우에만 클릭시 달력이 표시됩니다.[그림1] 참고| |`Check`|셀 좌측에 체크박스를 표시합니다.| |`공백`|원래 보여져야 하는 `Icon` 이미지를 감춥니다.| |`기타`|이미지 파일에 대한 url을 넣으면 아이콘의 배경으로 이미지가 표시됩니다. [그림2] 참고 (이미지는 `gif, png, jpg`만 가능)| |`Defaults`|셀 좌측에 [Defaults](./defaults) 버튼을 표시합니다. [그림3] 참고| *[IconWidth](/docs/props/col/icon-width) 속성을 통해 아이콘 영역의 넓이를 설정할 수 있습니다. 아이콘을 클릭시 [onIconClick](/docs/events/on-icon-click)이벤트가 호출됩니다. `\"Clear\"`나 `\"Check\"`로 설정하면 [OnClickSide](/docs/props/event/on-click-side) 이벤트만 호출합니다.* ### Example ```javascript options.Cols = [ ... //셀의 좌측에 체크박스를 표시 {Type: \"Text\", Name: \"product_name\", Icon: \"Check\", Width: 120 ...}, //셀의 좌측에 이미지로 버튼을 추가합니다. {Type: \"Text\", Name: \"brnSaleAmt\", Icon: \"/pcd/img/popIcon.png\", IconWidth: 15, Width: 120 ...}, ... ]; //4. Icon:\"Check\"를 사용할때, 조회 데이터 내에서 체크시 (열이름 : CLS) { \"data\": [ {... , \"CLSChecked\": 1 , ...} ] } ```",
              "see": [
                {
                  "label": "IconWidth col",
                  "url": "/docs/props/col/icon-width"
                },
                {
                  "label": "Button col",
                  "url": "/docs/props/col/button"
                },
                {
                  "label": "Defaults col",
                  "url": "./defaults"
                },
                {
                  "label": "Checked cell",
                  "url": "/docs/props/cell/checked"
                },
                {
                  "label": "Icon cell",
                  "url": "/docs/props/cell/icon"
                },
                {
                  "label": "IconWidth cell",
                  "url": "/docs/props/cell/icon-width"
                },
                {
                  "label": "setIconCheck method",
                  "url": "/docs/funcs/core/set-icon-check"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/icon.html"
          },
          {
            "cid": 361,
            "sid": "indent-2",
            "name": "indent",
            "label": "Indent",
            "data": {
              "body": "> 문자열 정렬([Align](./align))에 따라 셀 좌측 또는 우측에 들여쓰기를 설정합니다. > 숫자로 입력시 입력값 * 10 px로 padding이 생성됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|패딩 정도 (입력값 * 10px)| ### Example ```javascript //특정 열의 좌측에 20px 정도 패딩을 생성 options.Cols = [ ... {Type: \"Text\", Name: \"Description\", Align: \"Left\", Indent: 2, Width: 100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Align col",
                  "url": "./align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/indent.html"
          },
          {
            "cid": 362,
            "sid": "interval",
            "name": "interval",
            "label": "Interval",
            "data": {
              "body": "> `Date` 타입 컬럼의 달력 호출시 시간의 분 / 초 조절 버튼 클릭 시, [`TimePicker`](/docs/props/col/time-picker) 의 시간 조절 분 / 초의 버튼 클릭 시 증감 단위를 설정합니다. > `Minute`, `Second` 를 통하여 분 / 초 를 각각 설정할 수 있습니다. > 셀에 값이 있는 상태에서 분 / 초를 조절 시 `Interval` 설정한 값의 가까운 배수의 값으로 조절 됩니다. > `Init`을 `1(true)`로 설정하는 경우 빈 값의 셀에서 현재 시각을 보여줄 때 `Interval` 설정한 값으로 조절하여 보여줍니다. ### Type `object` ### Options |Name|Type|Required|Description| |----------|-----|---|----| |`Minute`|`number`|<span class='optional'>선택</span>|분의 증감 단위 설정. (입력값의 배수의 분으로 조절됨)| |`Second`|`number`|<span class='optional'>선택</span>|초의 증감 단위 설정. (입력값의 배수의 초로 조절됨)| |`Init`|`boolean`|<span class='optional'>선택</span>|셀이 빈 값인 경우 현재 시각을 `Interval` 설정 값으로 보여주는 기능 (`default: 0(false)`)| ### Example ```javascript options.Cols = [ ... {Type: \"Date\", Width: 120, Name: \"sDate_Hms\", Format: \"HH:mm:ss\", EditFormat: \"HHmmss\", DataFormat: \"HHmmss\", \"TimePicker\": 1, Interval: { Minute: 30, // 분의 증감을 30의 배수 단위로 설정. Second: 10, // 초의 증감을 10의 배수 단위로 설정. Init: true } }, {Type: \"Date\", Width: 120, Name: \"sDate_YmdHms\", \"Format\": \"yyyy/MM/dd HH:mm:ss\",\"Width\": 150,\"EditFormat\": \"yyyyMMddHHmmss\",\"DataFormat\": \"yyyyMMddHHmmss\", Interval: { Minute: 20, // 분의 증감을 20의 배수 단위로 설정. Second: 5, // 초의 증감을 5의 배수 단위로 설정. Init: true } }, ... ]; ```",
              "see": [
                {
                  "label": "TimePicker col",
                  "url": "/docs/props/col/time-picker"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.6|기능 추가||core|8.1.0.13|`Init` 기능 추가|"
            },
            "url": "docs/props/col/interval.html"
          },
          {
            "cid": 363,
            "sid": "link-base",
            "name": "link-base",
            "label": "LinkBase",
            "data": {
              "body": "> 셀에 [Link](/docs/props/col/link)속성이 있는 경우, Base 경로를 설정합니다. > 현재 페이지가 **/abc/test.html**이라고 가정했을때, `LinkBase` 설정에 따른 연결 `URL`은 다음과 같습니다. > |Link|LinkBase|실제연결URL| > |---|---|---| > |/xyz/test2.html||/xyz/test2.html| > |./xyz/test2.html||/abc/xyz/test2.html| > |/xyz/test2.html|/kor|/kor/xyz/test2.html| > |./xyz/test2.html|/kor|/kor/xyz/test2.html| ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|[Link](/docs/props/col/link)에서 설정한 `URL`의 Base 경로| ### Example ```javascript //열을 클릭시 특정 URL로 이동한다. options.Cols = [ ... //클릭시 /koef/tMIS/dcp/ConfProc.do 로 연결 {Type: \"Text\", Link: \"/tMIS/dcp/ConfProc.do\", LinkBase: \"/koef\", CanEdit: 0, Name: \"sa_cfprc\", Width: 100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Link col",
                  "url": "/docs/props/col/link"
                },
                {
                  "label": "LinkTarget col",
                  "url": "/docs/props/col/link-target"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/link-base.html"
          },
          {
            "cid": 364,
            "sid": "link-target",
            "name": "link-target",
            "label": "LinkTarget",
            "data": {
              "body": "> 셀에 [Link](/docs/props/col/link)속성이 있는 경우, 클릭시 이동할 target Window를 설정합니다.. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|클릭시 이동할 Target Window(_blank ,_parent ,_self ,_top, 특정 window명)| ### Example ```javascript //열을 클릭시 특정 URL로 이동한다. options.Cols = [ ... //클릭시 새창으로 열기 {Type: \"Text\", Link: \"/tMIS/dcp/ConfProc.do\", LinkTarget: \"_blank\", CanEdit: 0 , Name: \"sa_cfprc\", Width: 100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Link col",
                  "url": "/docs/props/col/link"
                },
                {
                  "label": "LinkBase col",
                  "url": "/docs/props/col/link-base"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/link-target.html"
          },
          {
            "cid": 365,
            "sid": "link",
            "name": "link",
            "label": "Link",
            "data": {
              "body": "> 셀에 데이터를 \\<a> 태그로 감싸고 href 속성에 들어갈 URL을 설정합니다. > `LinkBase`와 `LinkTarget` 속성을 같이 사용하여 상대경로나 클릭시에 target window를 설정할 수 있습니다. > **이 옵션은 반드시 CanEdit가 0으로 설정되어야 동작합니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|클릭시 이동할 url| ### Example ```javascript //열을 클릭시 특정 URL로 이동한다. options.Cols = [ ... {Type: \"Text\", Link: \"/tMIS/dcp/ConfProc.do\", LinkTarget: \"_self\", CanEdit: 0, Name: \"sa_cfprc\", Width: 100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "LinkBase col",
                  "url": "/docs/props/col/link-base"
                },
                {
                  "label": "LinkTarget col",
                  "url": "/docs/props/col/link-target"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/link.html"
          },
          {
            "cid": 366,
            "sid": "max-width",
            "name": "max-width",
            "label": "MaxWidth",
            "data": {
              "body": "> 사용자가 마우스 드래그를 이용하여 열의 너비를 조정할 때, 늘릴수 있는 최대 열의 너비를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|열의 최대 너비(pixel단위)| ### Example ```javascript //특정 열의 최대 너비를 120px로 설정합니다. options.Cols = [ ... {Type: \"Date\", Name: \"em_date\", MaxWidth: 120, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Width col",
                  "url": "./width"
                },
                {
                  "label": "MinWidth col",
                  "url": "./min-width"
                },
                {
                  "label": "RelWidth col",
                  "url": "./rel-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/max-width.html"
          },
          {
            "cid": 367,
            "sid": "menu-3",
            "name": "menu",
            "label": "Menu",
            "data": {
              "body": "> 마우스 우측 버튼 클릭시 보여질 컨텍스트 메뉴를 설정합니다. ### Type mixed( `object` \\| `string` ) ### Options |Value|Description| |-----|-----| |`string`|첫글자를 구분자로 한 컨텍스트 메뉴스트링 지정 (ex: @저장@임시저장@취소 or *상신*취소) | |`object`|[Menu Object 설정 링크 참고](/docs/appx/menu) ### Example ```javascript //procs 열에서 마우스 우측버튼 클릭시 보여질 메뉴 설정 options.Cols = [ ... {Type: \"Text\", Menu: \"|진행|반려|전결|보류\", Name: \"procs\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                },
                {
                  "label": "MenuHSeparator cfg",
                  "url": "/docs/props/cfg/menu-h-separator"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/menu.html"
          },
          {
            "cid": 368,
            "sid": "min-width",
            "name": "min-width",
            "label": "MinWidth",
            "data": {
              "body": "> 열의 최소 너비를 pixel단위로 설정합니다. > 사용자가 드래그를 통해 열의 너비를 조정할 때, 지정한 크기 이하로 작아지지 않게 합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|열의 최소 너비(pixel단위)| ### Example ```javascript //특정 열의 최소 너비를 110px로 설정합니다. options.Cols = [ ... {Type: \"Enum\", Name: \"DeptNm\", MinWidth: 110, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Width col",
                  "url": "./width"
                },
                {
                  "label": "MaxWidth col",
                  "url": "./max-width"
                },
                {
                  "label": "RelWidth col",
                  "url": "./rel-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/min-width.html"
          },
          {
            "cid": 369,
            "sid": "name",
            "name": "name",
            "label": "Name",
            "data": {
              "body": "> 열에 이름을 부여합니다. > 여기서 부여한 데이터 조회시 `json` 데이터와 매핑하거나, 저장시 서버로 전송됩니다. > `Name`을 `\"SEQ\"`로 설정하면 해당 열은 서버에서 조회해 온 데이터와 무관하게 자동으로 1,2,3,4.. 숫자가 보여지는 열로 동작합니다.(편집불가) > `SEQ`로 생성된 열은 `Sort`, `Filter`, `hideRow`, `removeRow` 등 행의 변화가 있을 때에도 무조건 1부터 숫자를 다시 설정 합니다. > **<mark>주의</mark> : 대소문자를 구분합니다. > 반드시 필수로 설정해야 하며, 중복을 허용하지 않습니다. > 문자(az, AZ), 밑줄 '_', 숫자(0-9)만 포함할 수 있습니다. > 단, 이름은 숫자나 밑줄로 시작할 수 없습니다.** > 아래와 같은 이름은 사용할 수 없습니다: > 1. 행의 속성명: Def, Kind, Deleted, Attribute(TextColor 등) > 2. 시트에서 사용하는 예약어: SEQ, id, Status, Level, ColorPos, GroupPos, Hasch, LevelImg, OrgIndex, SUMType > 3. 이미 존재하는 속성 이름의 일부: Color, NoColor (예: 컬럼 이름을 'No'로 사용할 경우 'NoColor'로 저장되어 충돌 발생) ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|각 열에 부여하는 고유한 이름| ### Example ```javascript //열 생성시 고유한 이름을 선언 options.Cols = [ {Type: \"Int\", Name: \"SEQ\", Width: 60 ...}, //Seq 열 {Type: \"Text\", Name: \"empNm\", Width: 120 ...}, {Type: \"Int\", Name: \"age\", Width: 70 ...}, ... ]; //조회 데이터 var DATA = [ {\"empNm\": \"이몽룡\", \"age\": 19, ...}, {\"empNm\": \"성춘향\", \"age\": 17, ...}, ... ]; ```",
              "see": [
                {
                  "label": "RowIndex cfg",
                  "url": "/docs/props/cfg/row-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/name.html"
          },
          {
            "cid": 370,
            "sid": "no-button-in-filter",
            "name": "no-button-in-filter",
            "label": "NoButtonInFilter",
            "data": {
              "body": "> 해당 열의 필터행에 [Button](./button), [TimePicker](./time-picker) 을 통해 생성되는 `Button` 혹은 `TimePicker` 가 생성되지 않도록 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|필터행에 `Button` 혹은 `TimePicker` 생성됨 (`default`)| |`1(true)`|필터행에 `Button` 혹은 `TimePicker` 생성되지 않음| ### Example ```javascript // 특정 열의 필터행에 버튼이 생성되지 않도록 설정 options.Cols = [ {Type: \"Text\", Button: \"Button\", ButtonText: \"TestButton\", Name: \"sNumber\", NoButtonInFilter: 1, Width: 70 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Button",
                  "url": "./button"
                },
                {
                  "label": "TimePicker",
                  "url": "./time-picker"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.76|기능 추가|"
            },
            "url": "docs/props/col/no-button-in-filter.html"
          },
          {
            "cid": 371,
            "sid": "no-changed",
            "name": "no-changed",
            "label": "NoChanged",
            "data": {
              "body": "> 열의 값이 변경되었을때 수정 상태를 변경 하지 않도록 설정합니다. > 값이 `1(true)`로 설정되어 있다면 열의 값이 변경되어도 수정 상태를 변경하지 않습니다. > 수정 상태를 변경(`Changed`)하지 않지만 수정 관련된 이벤트는 발생합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열 값을 수정하면 수정 상태를 변경 (`default`)| |`1(true)`|열 값을 수정해도 수정 상태를 변경하지 않음| ### Example ```javascript // 특정 열의 값이 수정될때 수정 상태가 변경되지 않도록 설정 options.Cols = [ {Type: \"Int\", Name: \"sNumber\", NoChanged: true, Width: 70 ...}, ... ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/no-changed.html"
          },
          {
            "cid": 372,
            "sid": "no-color-2",
            "name": "no-color",
            "label": "NoColor",
            "data": {
              "body": "> 열의 기본 적용된 배경색이 무시됩니다. > 홀수, 짝수행에 대한 배경색상([AlternateColor](/docs/props/row/alternate-color))나 상태(입력, 수정, 삭제)및 선택에 대한 색상이 무시되고, [Color](./color) 속성으로 통한 배경색도 적용되지 않게 할수 있습니다. > `NoColor`가 적용되는 우선 순위는 셀 \\> 열 \\> 행입니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|기능 사용 안함 (`default`)| |`1`|모든 배경색 무시(단 Class속성을 통해 설정한 배경색을 적용)| |`2`|상태 및 선택에 대한 색상만 무시 |`3`|`Color` 설정 시 상태, `AlternateColor`에 대한 색상을 무시하고 `Color` 색상 적용 ### Example ```javascript //특정 열은 모든 배경색을 무시하게 설정 options.Cols = [ ... {Type: \"Text\", Name: \"Dept\", NoColor: 1, Width: 100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Alternate cfg",
                  "url": "/docs/props/cfg/alternate"
                },
                {
                  "label": "Color col",
                  "url": "./color"
                },
                {
                  "label": "AlternateColor row",
                  "url": "/docs/props/row/alternate-color"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.2.0.14|`NoColor: 3` 동작 추가|"
            },
            "url": "docs/props/col/no-color.html"
          },
          {
            "cid": 373,
            "sid": "no-upload-2",
            "name": "no-upload",
            "label": "NoUpload",
            "data": {
              "body": "> 지정한 열의 저장 여부를 설정합니다. > `1(true)` 로 설정한 열의 경우 저장 함수(`doSave, getSaveString 등`) 호출시 상태와 무관한게 서버로 전송되지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|서버로 전송 (`default`)| |`1(true)`|서버로 전송 제외(지정한 컬럼은 서버로 전송하지 않습니다.)| ### Example ```javascript //특정 열은 저장시 서버로 전송 제외하기 sheetOption.Cols = [ ... {Header: \"상세 내용\", Type: \"Text\", Name: \"Description\", Width: 200, NoUpload: 1}, ... ]; ```",
              "see": [
                {
                  "label": "doSave method",
                  "url": "/docs/funcs/core/do-save"
                },
                {
                  "label": "getSaveString method",
                  "url": "/docs/funcs/core/get-save-string"
                },
                {
                  "label": "getSaveJson method",
                  "url": "/docs/funcs/core/get-save-json"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/no-upload.html"
          },
          {
            "cid": 374,
            "sid": "number-sort",
            "name": "number-sort",
            "label": "NumberSort",
            "data": {
              "body": "> 열의 데이터를 숫자형식으로 소팅할지 여부를 설정합니다. > 일반적으로 `Int, Float, Date` [Type](/docs/appx/type)은 숫자형식으로, 그 외의 [Type](/docs/appx/type)은 문자형식으로 소팅이 이루어집니다. > 여기서 값을 `0(false)`으로 설정하면, [Type](/docs/appx/type)과 무관하게 문자형식으로 소팅되고, `1(true)`로 설정시 숫자형식으로 소팅이 이루어집니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|문자형식의 소팅 (`default`)| |`1(true)`|숫자형식의 소팅| ### Example ```javascript //특정 열에 대해 숫자형식으로 소팅 options.Cols = [ ... {Type: \"Text\", Name: \"SA_ID\", NumberSort: 1 ...}, ... ]; ``` ### Try it - [True](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/NumberSort-true/)",
              "see": [
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                },
                {
                  "label": "RawSort col",
                  "url": "./raw-sort"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/number-sort.html"
          },
          {
            "cid": 375,
            "sid": "number-strict-mode",
            "name": "number-strict-mode",
            "label": "NumberStrictMode",
            "data": {
              "body": "> 0(false)으로 설정 시 조회 시 숫자 타입(Int, Float)에 빈 값이나 숫자 형태가 아닌 경우 0으로 처리합니다. > 천단위 구분자 \",\"가 포함된 문자열 형태의 숫자를 입력하는 경우 숫자로 표시됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|숫자가 아닌 데이터에 대해 엄격하게 검사하지 않음. 숫자가 아닌 경우 NaN 대신 0으로 표시| |`1(true)`|숫자 타입 열에서 데이터의 타입에 대해 엄격하게 검사. 숫자형태가 아닌 경우 NaN으로 표시 (`default`)| ### Example ```javascript options.Cols = [ ... { Header: '정수(Int)', Type: 'Int', Name: 'IntData', Width: 80, Align: 'Right', NumberStrictMode: 0 // 숫자가 아닌 데이터에 대해 엄격하게 검사하지 않음. }, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.17|기능 추가|"
            },
            "url": "docs/props/col/number-strict-mode.html"
          },
          {
            "cid": 376,
            "sid": "orig-search-data",
            "name": "orig-search-data",
            "label": "OrigSearchData",
            "data": {
              "body": "> 조회시 숫자, 문자 등의 데이터 형식을 변경하지 않고 그대로 `Row`객체에 저장합니다. > `getValue`, `getString`에는 영향을 주지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|조회시 숫자, 문자 타입의 데이터를 각각의 타입에 맞는 형식으로 변형하여 저장 (`default`)| |`1(true)`|조회시 숫자, 문자 타입의 데이터를 변형하지 않고 그대로 유지| ### Example ```javascript // 조회 데이터의 형식을 변형하지 않고 그대로 Row 객체에 저장 options.Cols = [ ... {Type: \"Text\", OrigSearchData: 1, Name: \"CarName\", Width: 120, ...}, ... ]; //조회 데이터 [ {\"CarName\":\"1234\"} ] //OrigSearchData 설정 전 getDataRows 함수로 CarName 리턴값 CarName: 1234 , 숫자형으로 리턴 //OrigSearchData 설정 후 getDataRows 함수로 CarName 리턴값 CarName: \"1234\" , 문자형으로 리턴 ```",
              "see": [
                {
                  "label": "시트 객체 구조",
                  "url": "/docs/appx/init-structure"
                },
                {
                  "label": "loadSearData method",
                  "url": "/docs/funcs/core/load-search-data"
                },
                {
                  "label": "doSearch method",
                  "url": "/docs/funcs/core/do-search"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.17|기능 추가|"
            },
            "url": "docs/props/col/orig-search-data.html"
          },
          {
            "cid": 377,
            "sid": "pos",
            "name": "pos",
            "label": "Pos",
            "data": {
              "body": "> 섹션 내에서 열의 인덱스를 확인합니다. > 시트의 열 생성시, `LeftCols` 배열에 추가한 열은 틀고정을 기준으로 좌측 섹션으로 들어가고, `Cols` 배열에 넣은 열은 가운데, `RightCols` 섹션에 넣은 열은 우측 섹션으로 추가됩니다. > 이 속성은 자신의 섹션 내에서 왼쪽을 기준으로 몇번째로 열이 위치하고 있는지를 확인합니다. (`Readonly`) ### ![섹션](/assets/imgs/section.png \"섹션\") ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|섹션 내에 순번(좌측 기준 0부터 시작) `LeftCols`에는 제품 내부적으로 사용하는 숨겨진 열이 있어 1부터 시작합니다. 또한 `SEQ` 열을 별도로 지정하지 않는 경우, 자동으로 `LeftCols`에 `SEQ` 열이 감춰진 상태로 생성됩니다.| ### Example ```javascript //열의 순번을 확인 var pos = sheet.getAttribute({col: \"RENTFEE\", attr: \"Pos\"}) ```",
              "see": [
                {
                  "label": "Section col",
                  "url": "./section"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/pos.html"
          },
          {
            "cid": 378,
            "sid": "radio-icon",
            "name": "radio-icon",
            "label": "RadioIcon",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Radio`인 열에서 `Radio` 아이콘을 다른 이미지나 `Html` 객체로 설정합니다. > 임의의 이미지를 라디오 아이콘으로 사용하고자 하는 경우에는, 언체크 이미지와 체크 이미지를 첫글자를 구분자로 하여 연결된 문자열로 설정하시면 됩니다. (ex:\"|OFF.gif|ON.gif\") > > 임의의 이미지를 체크박스 아이콘으로 사용할 때, 해당 열내의 셀이 편집불가([CanEdit](./can-edit))인 경우가 있다면 편집 불가일때의 이미지까지해서 총 4개의 이미지를 설정하시면 됩니다. (ex:\"|Off.gif|On.gif|OffReadOnly.gif|OnReadOnly.gif\") > > 여러개의 라디오 아이콘을 사용하고자 하는 경우에는 언체크 이미지와 체크이미지를 이어서 설정하시면 됩니다. (ex:\"|Off1.gif|On1.gif|Off2.gif|On2.gif|Off3.gif|On3.gif\") > > 그 외에 일반적인 숫자형식으로 아래 `Options`에서와 같이 기능을 설정하실 수 있습니다. ### Type `mixed`( `string` \\| `number` ) ### Options **숫자형식을 사용하는 경우** |Value|Description| |-----|-----| |`0`|기본적인 내장 라디오아이콘 이미지를 사용/ [Range](./range)속성을 사용하는 경우 내장 체크박스아이콘 이미지를 사용 (`default`) |`1`|내장 라디오 아이콘 이미지를 사용| |`2`|내장 체크박스 아이콘 이미지를 사용| |`3`|\\<input type=\"radio\">객체를 사용 / [Range](./range)속성을 사용하는 경우 \\<input type=\"checkbox\">객체를 사용| |`4`|\\<input type=\"radio\">객체를 사용| |`5`|\\<input type=\"checkbox\">객체를 사용| |`6`|아이콘을 표시하지 않음| ***input 객체를 사용하는 경우 그렇지 않은 경우보다 성능이 느릴 수 있습니다.*** ### Example ```javascript //라디오 아이콘 대신 체크박스 아이콘을 사용 options.Cols = [ ... {Type: \"Radio\", Name: \"relation\", RadioIcon: 2 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Range col",
                  "url": "./range"
                },
                {
                  "label": "HRadio col",
                  "url": "./h-radio"
                },
                {
                  "label": "RadioIconWidth col",
                  "url": "./radio-icon-width"
                },
                {
                  "label": "RadioUncheck col",
                  "url": "./radio-uncheck"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/radio-icon.html"
          },
          {
            "cid": 379,
            "sid": "radio-uncheck",
            "name": "radio-uncheck",
            "label": "RadioUncheck",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Radio`인 열에서, 한 번 클릭하여 선택한 아이템을 다시 클릭하여 체크해제 하게끔 허용할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|체크해제를 허용하지 않음 (`default`) |`1(true)`|체크해제를 허용| ### Example ```javascript //체크 해제를 허용 options.Cols = [ ... {Type: \"Radio\", Name: \"relation\", RadioUncheck: 1 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Range col",
                  "url": "./range"
                },
                {
                  "label": "HRadio col",
                  "url": "./h-radio"
                },
                {
                  "label": "RadioIcon col",
                  "url": "./radio-icon"
                },
                {
                  "label": "RadioIconWidth col",
                  "url": "./radio-icon-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/radio-uncheck.html"
          },
          {
            "cid": 380,
            "sid": "radio",
            "name": "radio",
            "label": "Radio",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool` 혹은 `Radio` 인 열들 간에 같은 값을 부여한 값을 갖고 있는 셀들을 하나의 그룹으로 묶여서 한 행에서 같은 그룹 내에 한 셀만 체크 가능하게 합니다. ### ![Radio](/assets/imgs/radio.png \"같은 행에서 하나만 선택 가능\") ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|라디오처럼 하나로 묶을 그룹 인덱스| ### Example ```javascript //행안에서 좌우로 비교하여 그룹내에서 하나의 셀만 체크 가능하게 설정 options.Cols = [ //1번 그룹 {Type:\"Bool\", Name:\"st1\", HRadio:1, Radio:1, ...}, {Type:\"Bool\", Name:\"st2\", HRadio:1, Radio:1, ...}, {Type:\"Bool\", Name:\"st3\", HRadio:1, Radio:1, ...}, {Type:\"Bool\", Name:\"st4\", HRadio:1, Radio:1, ...}, {Type:\"Bool\", Name:\"st5\", HRadio:1, Radio:1, ...}, //2번 그룹 {Type:\"Bool\", Name:\"att1\", HRadio:1, Radio:2, ...}, {Type:\"Bool\", Name:\"att2\", HRadio:1, Radio:2, ...}, {Type:\"Bool\", Name:\"att3\", HRadio:1, Radio:2, ...}, {Type:\"Bool\", Name:\"att4\", HRadio:1, Radio:2, ...}, {Type:\"Bool\", Name:\"att5\", HRadio:1, Radio:2, ...}, ... ]; ```",
              "see": [
                {
                  "label": "BoolGroup col",
                  "url": "./bool-group"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/radio.html"
          },
          {
            "cid": 381,
            "sid": "radion-icon-width",
            "name": "radion-icon-width",
            "label": "RadioIconWidth",
            "data": {
              "body": "> [RadioIcon](./radio-icon)속성을 통해서 라디오 아이콘을 커스텀 이미지로 설정하는 경우 이미지의 너비를 pixel단위로 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|라디오 아이콘 이미지의 너비 (pixel단위)| ### Example ```javascript //라디오 아이콘 이미지의 너비를 22px로 정의 options.Cols = [ ... {Type: \"Radio\", Name: \"st1\", RadioIconWidth: 22, RadioIcon: \"|Off.gif|On.gif\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "RadioIcon col",
                  "url": "./radio-icon"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/radion-icon-width.html"
          },
          {
            "cid": 382,
            "sid": "range",
            "name": "range",
            "label": "Range",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Enum`, `Radio`, `File`, `Date`인 열에서 복수개를 선택하게 할지 여부를 설정합니다. > [Type](/docs/appx/type)이 `Enum`인 경우, 드랍리스트 내에 체크박스가 생성되어 여러개 선택이 가능하게 합니다. > [Type](/docs/appx/type)이 `Radio`인 경우, 체크박스가 생성되어 여러개 아이템을 선택하실 수 있습니다. > [Type](/docs/appx/type)이 `File`인 경우, 여러개 파일을 선택하실 수 있습니다. > [Type](/docs/appx/type)이 `Date`인 경우, 드래그를 통해 달력내에 여러 일자를 선택할 수 있습니다. > 복수로 선택한 아이템은 `locale/*.js` 파일에 `ValueSeparator`, `ValueSeparatorHtml`로 설정한 문자를 구분자로 하여 연결된 문자로 리턴됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|단일 선택만 허용 (`default`)| |`1(true)`|복수 선택 허용| ### Example ```javascript //Enum에서 여러개 선택 허용 options.Cols = [ ... {Header: \"명절선물\", Type: \"Enum\", Name: \"gift\", Range : 1, Enum: \"|갈비세트|조기세트|사과배|스팸3호\" ...}, ... ]; //File에서 여러개 선택 허용 options.Cols = [ ... {Header: \"파일선택\", Type: \"File\", Name: \"lblist\", Range: 1}, ... ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "/docs/props/col/enum"
                },
                {
                  "label": "Radio col",
                  "url": "/docs/props/col/radio"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/range.html"
          },
          {
            "cid": 383,
            "sid": "raw-sort",
            "name": "raw-sort",
            "label": "RawSort",
            "data": {
              "body": "> 열 소팅시 Format 적용 여부를 설정합니다. > [CustomFormat](./custom-format) 에는 적용되지 않습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|열의 [Type](/docs/appx/type) 과 `Format`을 적용한 소팅(`default`)| |`1`|`Format`을 적용하지 않은 순수데이터를 기준으로 한 소팅 [Enum](./enum)형식인 경우 `Key`를 기준으로 소팅| |`2`|[Enum](./enum)타입에서 [Enum](./enum)과 [EnumKeys](./enum-keys)의 입력순서(배열순서)로 정렬| ### Example ```javascript //특정 Enum 열에서 Key를 기준으로 소팅 options.Cols = [ ... {Type: \"Enum\", Name: \"Position\", RawSort: 1, Enum: \"|사장|부장|과장|대리|사원\", EnumKeys: \"|AA|BB|CC|DD|EE\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "CanSort col",
                  "url": "./can-sort"
                },
                {
                  "label": "CustomFormat col",
                  "url": "./custom-format"
                },
                {
                  "label": "Enum col",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "./enum-keys"
                },
                {
                  "label": "NumberSort col",
                  "url": "./number-sort"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/raw-sort.html"
          },
          {
            "cid": 384,
            "sid": "record-col-span",
            "name": "record-col-span",
            "label": "RecordColSpan",
            "data": {
              "body": "> 멀티레코드([MultiRecord](/docs/props/cfg/multi-record)) 기능을 사용하는 시트에서 특정 컬럼을 기준으로 오른쪽으로 합쳐질 열의 개수를 설정합니다. > `row`에 [Spanned](/docs/props/row/spanned): `1` 이 설정되어 있어야 사용할 수 있습니다. > Html Table객체에 `ColSpan`과 유사합니다. > **<mark>주의</mark> : `RecordColSpan` 설정으로 인해 머지되어 보이지 않는 컬럼은 `Name`설정을 하게 될 경우 정상동작 되지 않습니다.** ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|행 내에서 오른쪽으로 합쳐질 열 개수| ### Example ```javascript options.Cfg = { MultiRecord: true // 멀티레코드 전용 시트로 설정 ... }; // 멀티레코드 기능 사용시 열설정(1차원 배열 -> 2차원 배열) options.Cols = [ //첫번째 단위데이터행(DataRow) [ {Header: \"A\", Name: \"colA\", Type: \"Text\", Width: 100}, {Header: \"B\", Name: \"colB\", Type: \"Image\", Width: 100}, {Header: \"C\", Name: \"colC\", Type: \"Int\", Width: 100}, {Header: \"D\", Name: \"colD\", Type: \"Float\", Width: 100} ], //두번째 단위데이터행(DataRow) [ {Header: \"E\", Name: \"colE\", Type: \"Text\", Width: 100}, {Header: \"F\", Name: \"colF\", Type: \"Text\", Width: 100}, {Header: \"G\", Name: \"colG\", Type: \"Enum\", Width: 100}, {Header: \"H\", Name: \"colH\", Type: \"Date\", Width: 100} ], //세번째 단위데이터행(DataRow) [ {Header: \"I\", Name: \"colI\", Type: \"Text\", Width: 100}, {Header: \"J\", Name: \"colJ\", Type: \"Text\", Width: 100, RecordColSpan: 3}, {Header: \"J\", Width: 50}, {Header: \"J\", Width: 120} ] ]; ```",
              "see": [
                {
                  "label": "RowSpan cell",
                  "url": "./row-span"
                },
                {
                  "label": "Spanned row",
                  "url": "/docs/props/row/spanned"
                },
                {
                  "label": "RecordRowSpan col",
                  "url": "/docs/props/col/record-row-span"
                },
                {
                  "label": "MultiRecord cfg",
                  "url": "/docs/props/cfg/multi-record"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/record-col-span.html"
          },
          {
            "cid": 385,
            "sid": "record-h-col-span",
            "name": "record-h-col-span",
            "label": "RecordHColSpan",
            "data": {
              "body": "> 멀티레코드([MultiRecord](/docs/props/cfg/multi-record)) 기능을 사용하는 시트에서 [RecordRowSpan](/docs/props/col/record-row-span)이 2이상 설정되어있고 [RecordColSpan](/docs/props/col/record-col-span)이 설정되어있지 않을때 헤더의 특정 열을 기준으로 오른쪽으로 합쳐질 열의 개수를 설정합니다. > 이 때, 하나의 헤더를 나누어 사용하기 때문에 데이터는 하나의 셀로 표시됩니다. (즉, 헤더만 나눠서 보이도록 하는 기능) > `row`에 [Spanned](/docs/props/row/spanned):`1` 이 설정되어 있어야 사용할 수 있습니다. > Html Table객체에 `ColSpan`과 유사합니다. > **<mark>주의</mark> : 시트 전체 초기 설정에서 `Header.RecordRowSpan`, `Header.RecordColSpan` 등을 이용한 멀티레코드 헤더 머지 기능과 해당 기능은 절대 같이 사용할 수 없습니다** ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|헤더 행 내에서 오른쪽으로 합쳐질 열 개수| ### Example ```javascript options.Cfg = { MultiRecord: true // 멀티레코드 전용 시트로 설정 ... }; // 멀티레코드 기능 사용시 열설정(1차원 배열 -> 2차원 배열) Cols: [ //첫번째 단위데이터행(DataRow) [ { \"Header\": \"본사\", Name: \"HeadOffice\", \"Width\": 60, RecordRowSpan: 3, RecordHColSpan: 5, RecordHColTitle: \"기관\" }, { \"Header\": \"연구소\", Name: \"Laboratory\", \"Width\": 60, RecordRowSpan: 3 }, { \"Header\": \"지사1\", Name: \"BranchOffice1\", \"Width\": 60, RecordRowSpan: 3 }, { \"Header\": \"지사2\", Name: \"BranchOffice2\", \"Width\": 60, RecordRowSpan: 3 }, { \"Header\": \"기타\", Name: \"sEtc\", \"Width\": 60, RecordRowSpan: 3 } ], //두번째 단위데이터행(DataRow) [ { \"Header\": \"본사\", RecordHColSpan: 2, RecordHColTitle: \"계열1\" }, { \"Header\": \"연구소\" }, { \"Header\": \"지사1\", RecordHColSpan: 2, RecordHColTitle: \"계열2\" }, { \"Header\": \"지사2\" }, { \"Header\": \"기타\" } ], //세번째 단위데이터행(DataRow) [ { \"Header\": \"본사\" }, { \"Header\": \"연구소\" }, { \"Header\": \"지사1\" }, { \"Header\": \"지사2\" }, { \"Header\": \"기타\" } ] ]; ```",
              "see": [
                {
                  "label": "RowSpan cell",
                  "url": "/docs/props/cell/row-span"
                },
                {
                  "label": "Spanned row",
                  "url": "/docs/props/row/spanned"
                },
                {
                  "label": "RecordRowSpan col",
                  "url": "/docs/props/col/record-row-span"
                },
                {
                  "label": "RecordColSpan col",
                  "url": "/docs/props/col/record-col-span"
                },
                {
                  "label": "RecordHColTitle col",
                  "url": "/docs/props/col/record-h-col-title"
                },
                {
                  "label": "MultiRecord cfg",
                  "url": "/docs/props/cfg/multi-record"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/record-h-col-span.html"
          },
          {
            "cid": 386,
            "sid": "record-h-col-title",
            "name": "record-h-col-title",
            "label": "RecordHColTitle",
            "data": {
              "body": "> 멀티레코드([MultiRecord](/docs/props/cfg/multi-record)) 기능을 사용하는 시트에서 [RecordHColSpan](/docs/props/col/record-h-col-span)이 설정 되어 있는 헤더의 열의 제목을 설정합니다. > **데이터와 상관없이 동작하며 서버로 전송되지 않습니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|[RecordHColSpan](/docs/props/col/record-h-col-span)이 설정 되어 있는 헤더의 열의 제목| ### Example ```javascript options.Cfg = { MultiRecord: true // 멀티레코드 전용 시트로 설정 ... }; // 멀티레코드 기능 사용시 열설정(1차원 배열 -> 2차원 배열) Cols: [ //첫번째 단위데이터행(DataRow) [ { \"Header\": \"본사\", Name: \"HeadOffice\", \"Width\": 60, RecordRowSpan: 3, RecordHColSpan: 5, RecordHColTitle: \"기관\" }, { \"Header\": \"연구소\", Name: \"Laboratory\", \"Width\": 60, RecordRowSpan: 3 }, { \"Header\": \"지사1\", Name: \"BranchOffice1\", \"Width\": 60, RecordRowSpan: 3 }, { \"Header\": \"지사2\", Name: \"BranchOffice2\", \"Width\": 60, RecordRowSpan: 3 }, { \"Header\": \"기타\", Name: \"sEtc\", \"Width\": 60, RecordRowSpan: 3 } ], //두번째 단위데이터행(DataRow) [ { \"Header\": \"본사\", RecordHColSpan: 2, RecordHColTitle: \"계열1\" }, { \"Header\": \"연구소\" }, { \"Header\": \"지사1\", RecordHColSpan: 2, RecordHColTitle: \"계열2\" }, { \"Header\": \"지사2\" }, { \"Header\": \"기타\" } ], //세번째 단위데이터행(DataRow) [ { \"Header\": \"본사\" }, { \"Header\": \"연구소\" }, { \"Header\": \"지사1\" }, { \"Header\": \"지사2\" }, { \"Header\": \"기타\" } ] ]; ```",
              "see": [
                {
                  "label": "RowSpan cell",
                  "url": "./row-span"
                },
                {
                  "label": "Spanned row",
                  "url": "/docs/props/row/spanned"
                },
                {
                  "label": "RecordRowSpan col",
                  "url": "/docs/props/col/record-row-span"
                },
                {
                  "label": "RecordColSpan col",
                  "url": "/docs/props/col/record-col-span"
                },
                {
                  "label": "RecordHColSpan col",
                  "url": "/docs/props/col/record-h-col-span"
                },
                {
                  "label": "MultiRecord cfg",
                  "url": "/docs/props/cfg/multi-record"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/record-h-col-title.html"
          },
          {
            "cid": 387,
            "sid": "record-row-span",
            "name": "record-row-span",
            "label": "RecordRowSpan",
            "data": {
              "body": "> 멀티레코드([MultiRecord](/docs/props/cfg/multi-record)) 기능을 사용하는 시트에서 특정 행을 기준으로 아래쪽으로 합쳐질 행의 개수를 설정합니다. > col에 [Spanned](/docs/props/col/spanned):`1` 이 설정되어 있어야 사용할 수 있습니다. > Html Table객체에 `RowSpan`과 유사합니다. > **<mark>주의</mark> : `RecordRowSpan` 설정으로 인해 머지되어 보이지 않는 컬럼은 `Name`설정을 하게 될 경우 정상동작 되지 않습니다.** ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|열 내에서 아래로 병합할 행의 개수| ### Example ```javascript options.Cfg = { MultiRecord: true // 멀티레코드 전용 시트로 설정 ... }; // 멀티레코드 기능 사용시 열설정(1차원 배열 -> 2차원 배열) options.Cols = [ //첫번째 단위데이터행(DataRow) [ {Header: \"A\", Name: \"colA\", Type: \"Text\", Width: 100}, {Header: \"B\", Name: \"colB\", Type: \"Image\", Width: 100, RecordRowSpan: 3}, {Header: \"C\", Name: \"colC\", Type: \"Int\", Width: 100}, {Header: \"D\", Name: \"colD\", Type: \"Float\", Width: 100} ], //두번째 단위데이터행(DataRow) [ {Header: \"E\", Name: \"colE\", Type: \"Text\", Width: 100}, {Header: \"B\"}, {Header: \"F\", Name: \"colF\", Type: \"Enum\", Width: 100}, {Header: \"G\", Name: \"colG\", Type: \"Date\", Width: 100} ], //세번째 단위데이터행(DataRow) [ {Header: \"H\", Name: \"colH\", Type: \"Text\", Width: 100}, {Header: \"B\"}, {Header: \"I\", Name: \"colI\", Type: \"Text\", Width: 100}, {Header: \"J\", Name: \"colJ\", Type: \"Text\", Width: 100}, ] ]; ```",
              "see": [
                {
                  "label": "Span cell",
                  "url": "/docs/props/cell/span"
                },
                {
                  "label": "Spanned col",
                  "url": "/docs/props/col/spanned"
                },
                {
                  "label": "RecordColSpan col",
                  "url": "/docs/props/col/record-col-span"
                },
                {
                  "label": "MultiRecord cfg",
                  "url": "/docs/props/cfg/multi-record"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/record-row-span.html"
          },
          {
            "cid": 388,
            "sid": "rel-width",
            "name": "rel-width",
            "label": "RelWidth",
            "data": {
              "body": "> 열의 상대적 너비를 설정합니다. > 열의 너비를 퍼센트로 설정하는 것과 유사하게 열간의 상대적인 너비를 설정합니다. > 가령 시트의 크기가 1000px이고, 각 열의 너비가 100px 으로 설정한 열이 5개 있다고 가정할때 이중 한 열이 `RelWidth: 1`을 갖으면 해당 열의 너비는 600px를 갖게 됩니다. > 만약 두개 열이 `RelWidth: 1`을 갖으면 두개 열은 각각 300px를 갖게 됩니다. > 만약 두개 열이 `RelWidth` 속성이 설정되어있는데, 하나는 `RelWidth: 1`이고 다른 하나는 `RelWidth: 2` 로 설정되어 있다면 `RelWidth: 1` 인 열의 너비는 200px, `RelWidth: 2`인 열의 너비는 400px가 됩니다. > **주의 : 상대적 너비를 설정하다 보니, 시트 전체 너비보다 설정된 컬럼들의 너비가 더 큰 경우, `RelWidth` 가 설정된 컬럼의 너비가 작아지거나 0 이 되는 경우가 있기 때문에, 반드시 `minWidth` 를 사용하여 최소 너비를 지정해주는 것이 좋습니다.** ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|남는 너비에 대한 상대적인 비율| ### Example ```javascript //특정 열이 나머지 영역을 모두 차지하게 설정 options.Cols = [ ... {Type: \"Date\", Name: \"em_date\", RelWidth: 1, MinWidth: 100, ...}, ... ]; ``` ### Try it - [Set to 1](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/RelWidth-1/)",
              "see": [
                {
                  "label": "Width col",
                  "url": "./width"
                },
                {
                  "label": "MinWidth col",
                  "url": "./min-width"
                },
                {
                  "label": "MaxWidth col",
                  "url": "./max-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/rel-width.html"
          },
          {
            "cid": 389,
            "sid": "related",
            "name": "related",
            "label": "Related",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Enum`이나 `Radio` 인 열들 간에 연관성을 통해, 대분류/중분류/소분류와 같은 **관계형 콤보**를 설정합니다. > 대분류(혹은 최상위)에 해당하는 열은 `Related`를 설정할 필요가 없고, 중분류 열에서 대분류 열이름을, 소분류 열에서 중분류 열이름을 설정합니다. > 중분류 열에서는 [**\"Enum\"+\"상위분류 EnumKey\"**] 속성으로 아이템을 설정합니다. > 소분류와 같이 자신의 상위 관계가 2단계 이상 있는 열에서는 [**\"Enum\"+\"1단계 분류 EnumKey\"+\"_\"+\"2단계 분류 EnumKey\"**] 속성으로 아이템을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자신의 상위 관계 열이름| ### Example ```javascript //Related 속성을 통해 대분류/중분류/소분류에 해당하는 콤보를 구성 options.Cols = [ ... //대분류 {Type: \"Enum\", Name: \"cls1\", Enum: \"|A회사|B회사\", EnumKeys: \"|AA|BB\" ... }, //중분류 {Type: \"Enum\", Name: \"cls2\", Related: \"cls1\", EnumAA: \"|해외사업부|국내사업부|영업지원부\", EnumKeysAA: \"|A0|A1|A2\", EnumBB: \"|개발부|기술지원부\", EnumKeysBB: \"|B0|B1\" ... }, //소분류 Related 속성에 중분류와 대분류까지 바라보게 설정. //상위 관계가 2단계 이상인 경우 Related 속성에 해당하는 Name 모두 설정 {Type: \"Enum\", Name: \"cls3\", Related: \"cls1,cls2\", EnumAA_A0: \"|미주사업|동남아사업팀|유럽사업팀\", EnumKeysAA_A0: \"|AB0|AB1|AB2\", EnumAA_A1: \"|경부|전라|수도권\", EnumKeysAA_A1: \"|K0|K1|K2\", EnumAA_A2: \"|지원1팀|지원2팀\", EnumKeysAA_A2: \"|SE0|SE1\", EnumBB_B0: \"|개발1팀|개발2팀|개발3팀\", EnumKeysBB_B0: \"|DEV0|DEV1|DEV2\", EnumBB_B1: \"|지원1팀|지원2팀|지원3팀\", EnumKeysBB_B1: \"|SU0|SU1|SU3\", ... }, ... ]; //상위 분류만 체크하여 대분류/중분류/소분류 콤보를 구성하는 방법. options.Cols = [ ... //대분류 {Type: \"Enum\", Name: \"cls1\", Enum: \"|인문|소설/시\", EnumKeys: \"|AA|BB\" ... }, //중분류 {Type: \"Enum\", Name: \"cls2\", Related: \"cls1\", EnumAA: \"|철학/사상|인문일반\", EnumKeysAA: \"|A0|A1\", EnumBB: \"|한국소설|시/희곡\", EnumKeysBB: \"|B0|B1\" ... }, //소분류 Related 속성에 중분류 Name을 바라보게 설정. {Type: \"Enum\", Name: \"cls3\", Related: \"cls2\", EnumA0: \"|과학철학|언어철학|실용주의\", EnumKeysA0: \"|AA0|AA1|AA2\", EnumA1: \"|인문학 이론|인문/교양 일반\", EnumKeysA1: \"|AB0|AB1\", EnumB0: \"|단편소설|장편소설\", EnumKeysB0: \"|BA0|BA1\", EnumB1: \"|세계의 시|희곡/시나리오\", EnumKeysB1: \"|BB0|BB1\", ... }, ... ]; ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "/docs/props/col/enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "/docs/props/col/enum-keys"
                },
                {
                  "label": "Clear col",
                  "url": "/docs/props/col/clear"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/related.html"
          },
          {
            "cid": 390,
            "sid": "required",
            "name": "required",
            "label": "Required",
            "data": {
              "body": "> 데이터의 필수 입력 항목 여부를 설정합니다. > `1`인 경우 저장 함수 호출 시 셀에 데이터가 없는 경우 경고 메시지를 표시하고, 편집하도록 유도합니다. > [RequiredPosition](/docs/props/cfg/required-position) 옵션으로 헤더 내용의 왼쪽/오른쪽에 설정 가능합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|필수 입력 항목을 지정하지 않습니다. (`default`) | |`1`|필수 입력 항목을 지정합니다. ![option1](/assets/imgs/required1.png \"option1\")| ### Example ```javascript //열 생성시 고유한 이름을 선언 options.Cols = [ {Type: \"Text\", Name: \"sName\", Required: 1 ...}, {Type: \"Int\", Name: \"ssalary\",Width: 70 ...}, ... ]; ```",
              "see": [
                {
                  "label": "RequiredPosition cfg",
                  "url": "/docs/props/cfg/required-position"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/required.html"
          },
          {
            "cid": 391,
            "sid": "result-mask",
            "name": "result-mask",
            "label": "ResultMask",
            "data": {
              "body": "> 셀 편집 종료시 입력된 글자를 검사할 자바스크립트 정규식을 설정합니다. > 정규식 검사에 대한 로직은 [EditMask](./edit-mask)와 동일합니다. > > 정규식에 맞지 않은 글자가 입력되었을 시에는 [ResultMessage](./result-message)속성으로 설정한 메세지가 화면에 보여집니다. > [onResultMask](/docs/events/on-result-mask)이벤트의 리턴값을 통해 잘못된 값이 입력되었을때 후속 처리에 대한 부분을 설정하실 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자바스크립트 정규식 문자| ### Example ```javascript //이메일 주소 확인 options.Cols = [ ... {Type: \"Text\", ResultMask: \"^[\\\\w\\\\.\\\\+%-]+@[A-Za-z0-9\\\\.-]+\\\\.[A-Za-z]{2,6}$\", ResultText: \"이메일 주소를 확인해 주세요.\", Name: \"sa_email\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "ResultText col",
                  "url": "./result-text"
                },
                {
                  "label": "ResultMessage col",
                  "url": "./result-message"
                },
                {
                  "label": "EditMask col",
                  "url": "./edit-mask"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/result-mask.html"
          },
          {
            "cid": 392,
            "sid": "result-message-time",
            "name": "result-message-time",
            "label": "ResultMessageTime",
            "data": {
              "body": "> [ResultMessage](./result-message)가 보여질 시간을 설정합니다.(ms단위) > 설정한 시간만큼 메세지가 보여지고 자동으로 사라집니다. > 이 속성을 설정하지 않으면 \"확인\" 버튼을 누를 때까지 메세지가 보여지게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|메세지가 보여질 시간(ms단위)| ### Example ```javascript //이메일 주소 확인 options.Cols = [ ... { Type: \"Text\", ResultMask: \"^[\\\\w\\\\.\\\\+%-]+@[A-Za-z0-9\\\\.-]+\\\\.[A-Za-z]{2,6}$\", ResultMessage: \"이메일 주소를 확인해 주세요.\", ResultMessageTime: 800, Name: \"sa_email\", Width: 120, ... }, ... ]; ```",
              "see": [
                {
                  "label": "ResultText col",
                  "url": "./result-text"
                },
                {
                  "label": "ResultMessage col",
                  "url": "./result-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/result-message-time.html"
          },
          {
            "cid": 393,
            "sid": "result-message",
            "name": "result-message",
            "label": "ResultMessage",
            "data": {
              "body": "> [ResultMask](./result-mask)에 위배되는 내용이 입력시 DIV 레이어 팝업으로 보여질 내용을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|잘못된 내용이 입력시 보여질 경고문 내용| ### Example ```javascript //이메일 주소 확인 options.Cols = [ ... {Type: \"Text\", ResultMask: \"^[\\\\w\\\\.\\\\+%-]+@[A-Za-z0-9\\\\.-]+\\\\.[A-Za-z]{2,6}$\", ResultMessage: \"이메일 주소를 확인해 주세요.\", ResultMessageTime: 800, Name:\"sa_email\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "ResultText col",
                  "url": "./result-text"
                },
                {
                  "label": "ResultMessageTime col",
                  "url": "./result-message-time"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/result-message.html"
          },
          {
            "cid": 394,
            "sid": "result-text",
            "name": "result-text",
            "label": "ResultText",
            "data": {
              "body": "> [ResultMask](./result-mask)에 위배되는 내용이 입력시 `alert`으로 보여줄 내용을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|잘못된 내용이 입력시 보여질 경고문 내용| ### Example ```javascript //이메일 주소 확인 options.Cols = [ ... {Type: \"Text\", ResultMask: \"^[\\\\w\\\\.\\\\+%-]+@[A-Za-z0-9\\\\.-]+\\\\.[A-Za-z]{2,6}$\", ResultText: \"이메일 주소를 확인해 주세요.\", Name: \"sa_email\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "ResultMask col",
                  "url": "./result-mask"
                },
                {
                  "label": "ResultMessage col",
                  "url": "./result-message"
                },
                {
                  "label": "EditMask col",
                  "url": "./edit-mask"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/result-text.html"
          },
          {
            "cid": 395,
            "sid": "section",
            "name": "section",
            "label": "Section",
            "data": {
              "body": "> 열의 섹션을 확인합니다. > 시트의 열 생성시, `LeftCols` 배열에 추가한 열은 틀고정을 기준으로 좌측 섹션으로 들어가고, `Cols` 배열에 넣은 열은 가운데, `RightCols` 섹션에 넣은 열은 우측 섹션으로 추가됩니다. > 이 속성은 특정 열이 어느 섹션에 위치하고 있는지를 확인하는 용도로 사용됩니다.(`Readonly`) ### ![섹션](/assets/imgs/section.png \"섹션\") ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|좌측 섹션| |`1`|가운데 섹션| |`2`|우측 섹션| ### Example ```javascript //열의 섹션을 확인 var section = sheet.getAttribute({col: \"RENTFEE\", attr: \"Section\"}) ```",
              "see": [
                {
                  "label": "Pos col",
                  "url": "./pos"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/section.html"
          },
          {
            "cid": 396,
            "sid": "select-check",
            "name": "select-check",
            "label": "SelectCheck",
            "data": {
              "body": "> Bool 타입 컬럼을 드래그하여 선택시, 선택한 셀들을 체크하거나 언체크 합니다. > > 제약사항1: 머지가 이뤄진 컬럼에서는 해당 옵션을 사용하실 수 없습니다. > 제약사항2: 여러개 컬럼들 드래그 시에는 동작하지 않습니다.. > 제약사항3: (Cfg)SearchMode:2에서는 해당 옵션을 사용하실 수 없습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|SelectCheck 기능을 사용하지 않음| |`1(true)`|Bool 타입 컬럼을 드래그하여 선택시, 선택한 셀들을 체크/언체크합니다. (`default`)| ### Example ```javascript var opt = { Cols:[ ..., // 단일 Bool 타입 컬럼 드래그시 선택할 셀들을 체크합니다. { Header: { Value: \"체크박스(Bool)\", HeaderCheck: 1 }, Type: \"Bool\", Name: \"CheckData\", Width: 80, Align: \"Center\", CanEdit: 1, SelectCheck: 1, } ] } ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.2.0.26|기능 추가|"
            },
            "url": "docs/props/col/select-check.html"
          },
          {
            "cid": 397,
            "sid": "selected-2",
            "name": "selected",
            "label": "Selected",
            "data": {
              "body": "> 열을 선택하거나 선택여부를 확인 합니다. > [SelectingCells](/docs/props/cfg/selecting-cells)의 속성값이 0인 경우 사용하실 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열 선택 해제 (`default`)| |`1(true)`|열 선택| ### Example ```javascript //XMT 열 전체를 선택 sheet.setAttribute({col: \"XMT\", attr: \"Selected\", val: 1, render: 1}); ```",
              "see": [
                {
                  "label": "SelectingCells cfg",
                  "url": "/docs/props/cfg/selecting-cells"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/selected.html"
          },
          {
            "cid": 398,
            "sid": "show-hint-2",
            "name": "show-hint",
            "label": "ShowHint",
            "data": {
              "body": "> 해당 열에서 힌트기능을 사용할지 여부를 설정합니다. > 힌트는 열의 너비가 좁아 셀의 내용의 일부가 안보일때, 마우스 커서가 올라간 셀에 한해 일시적으로 셀의 너비를 늘려 안보이던 뒷 내용을 보여주는 기능입니다. > 이 기능은 체크박스나 라디오 형태의 열에서는 작동하지 않습니다. ### ![힌트활성화](/assets/imgs/hint1.png \"마우스 커서가 셀에 올라갔을때 힌트를 통해 감춰진 부분이 보여짐\") ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|힌트 기능을 사용안함| |`1`|셀의 크기가 작아 셀의 내용의 일부만 보여질때 동작 (`default`)| |`2`|1번 옵션과 더불어 스크롤이 있는 시트에서 셀이 하단에 있어 내용의 아래부분이 안보여질때 힌트 동작| |`3`|일반적으로는 힌트 기능이 동작하지 않고 [onShowHint](/docs/events/on-show-hint) 이벤트를 통해서만 동작(이벤트를 통해 힌트에 어떤 내용이 보여지게 할지 설정 가능)| ### Example ```javascript //특정 열에 힌트기능을 사용합니다. options.Cols = [ ... {Type: \"Text\", ShowHint: 2, Name: \"DESC\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "HintValue col",
                  "url": "./hint-value"
                },
                {
                  "label": "ShowHint row",
                  "url": "/docs/props/row/show-hint"
                },
                {
                  "label": "onShowHint event",
                  "url": "/docs/events/on-show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/show-hint.html"
          },
          {
            "cid": 399,
            "sid": "sign-font-style",
            "name": "sign-font-style",
            "label": "SignFontStyle",
            "data": {
              "body": "> 숫자형 컬럼 (Int, Float 타입)에서 7장 appendix의 [Format](/docs/appx/format)의 내용과 같이 양수, 음수, 0 일때의 Text속성들을 설정하여 적용하실 수 있습니다. > Col의 Text속성 ([TextColor](./text-color), [TextFont](./text-font), [TextSize](./text-size), [TextStyle](./text-style)) 보다 우선 적용 됩니다. > 양수, 음수, 0의 구분자는 `locale/*.js` 파일에 `ValueSeparator`로 설정된 문자열을 사용합니다. > **<mark>주의</mark> : SignFontStyle은 데이터에 따라 속성이 적용되기 때문에 Cell에 해당 Text속성들이 적용됩니다.** > **<mark>주의</mark> : 빈 값이나 '', null로 값 설정 시, 이전에 적용된 속성 값이 유지 됩니다.** ### Type `object` ### Options |Name|Type|Required|Description| |-----|-----|-----|-----| |`TextColor`|`string`|<span class='optional'>선택</span>|숫자형의 지정한 열에서 데이터에 따라 양수, 음수, 0일 때 적용하고자 하는 글자색([TextColor](./text-color))을 설정합니다. ex) \"SignFontStyle\": {\"TextColor\": \"red;blue;orange\", ...}| |`TextFont`|`string`|<span class='optional'>선택</span>|숫자형의 지정한 열에서 데이터에 따라 양수, 음수, 0일 때 적용하고자 하는 글자 폰트([TextFont](./text-font))를 설정합니다. ex) \"SignFontStyle\": {TextFont: \"Gulim, Helvetica;Malgun Gothic;Times New Roman\", ...}| |`TextSize`|`string`|<span class='optional'>선택</span>|숫자형의 지정한 열에서 데이터에 따라 양수, 음수, 0일 때 적용하고자 하는 글자 크기([TextSize](./text-size))를 설정합니다. ex) \"SignFontStyle\": {TextSize: \"12px;15px;5px\", ...}| |`TextStyle`|`string`|<span class='optional'>선택</span>|숫자형의 지정한 열에서 데이터에 따라 양수, 음수, 0일 때 적용하고자 하는 글자 스타일([TextStyle](./text-style))를 숫자로 설정합니다. ex) \"SignFontStyle\": {TextStyle: \"5;2;8\", ...}| ### Example ```javascript options.Cols = [ ... // 숫자형 컬럼인 컬럼명이 intData인 열에서 양수, 음수, 0일 때의 Text속성 적용 {Type: \"Int\", Name: \"IntData\", SignFontStyle: {TextColor: \"red;blue;yellow\", TextFont: \"Gulim;Malgun Gothic;Helvetica\", TextSize: \"15px;10em;11pt\", TextStyle: \"1,2,4\"} ...}, ... ]; // IntData 열에 SignFontStyle 속성 적용, 양수, 음수 일때는 기존의 TextColor 유지(생성 시 설정된 정보와 같이 양수일 때는 red, 음수일 때는 blue로 유지), 0일 때는 aqua로 글자색 적용 sheet.setAttribute(\"\", \"IntData\", \"SignFontStyle\", {TextColor: \";;aqua\"}); ```",
              "see": [
                {
                  "label": "TextColor col",
                  "url": "./text-color"
                },
                {
                  "label": "TextFont col",
                  "url": "./text-font"
                },
                {
                  "label": "TextSize col",
                  "url": "./text-size"
                },
                {
                  "label": "TextStyle col",
                  "url": "./text-style"
                },
                {
                  "label": "SignFontStyle cell",
                  "url": "/docs/props/cell/sign-font-style"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.19|기능 추가|"
            },
            "url": "docs/props/col/sign-font-style.html"
          },
          {
            "cid": 400,
            "sid": "size-ignore-decimal-sep",
            "name": "size-ignore-decimal-sep",
            "label": "SizeIgnoreDecimalSep",
            "data": {
              "body": "> 입력된 문자열이 숫자형인 경우, 설정된 열에 입력 가능한 글자 수에서 자릿수 구분자와 소수점 구분자의 값들을 글자 수에서 제외하는 기능입니다. > Locale메세지 파일(ko.js,en.js등)에서 자릿수 구분자는 `Format.GroupSeparator`, 소수점 구분자는 `Format.DecimalSeparator`로 설정되어 있습니다. > **<mark>주의</mark> : Col 혹은 Cell에 `Size` 속성이 설정되어 있어야 해당 기능이 동작합니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`boolean`|입력된 데이터에서 자릿수 구분자와 소수점 구분자를 이용하여 숫자형인지 판단하고, 숫자형 데이터일 경우 구분자 문자들을 입력가능한 글자수에서 제외 여부 (`Int`, `Float` type: `default:1(true)`, 그 외의 type: `default:0(false)`) 전 세계에서 사용되는 자릿수 구분자(`Format.GroupSeparator`) 문자: `,`, `.`, ` `, `'` 전 세계에서 사용되는 소수점 구분자(`Format.DecimalSeparator`) 문자: `,`, `.`| ### Example ```javascript //FloatData열에 최대 10글자까지 입력가능, 데이터가 숫자형인 경우 구분자를 입력제한 글자수에서 제외 options.Cols = [ ... {Type: \"Text\", Size: 10, SizeIgnoreDecimalSep: true, Name: \"FloatData\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Size col",
                  "url": "/docs/props/col/size"
                },
                {
                  "label": "UnicodeByteMode cfg",
                  "url": "/docs/props/cfg/unicode-byte-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.15|기능 추가|"
            },
            "url": "docs/props/col/size-ignore-decimal-sep.html"
          },
          {
            "cid": 401,
            "sid": "size-2",
            "name": "size",
            "label": "Size",
            "data": {
              "body": "> 열에 입력가능한 글자수를 설정합니다. > [cfg.UnicodeByteMode](/docs/props/cfg/unicode-byte-mode)를 설정할 경우 한글의 바이트 수를 계산하여 입력을 제한합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|입력가능한 글자수| ### Example ```javascript //CarName열에 최대 10글자까지 입력가능 options.Cols = [ ... {Type: \"Text\", Size: 10, Name: \"CarName\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Size cell",
                  "url": "/docs/props/cell/size"
                },
                {
                  "label": "SizeIgnoreDecimalSep col",
                  "url": "/docs/props/col/size-ignore-decimal-sep"
                },
                {
                  "label": "UnicodeByteMode cfg",
                  "url": "/docs/props/cfg/unicode-byte-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/size.html"
          },
          {
            "cid": 402,
            "sid": "spanned-2",
            "name": "spanned",
            "label": "Spanned",
            "data": {
              "body": "> 특정 열에 속한 셀들에 대해서 위/아래로 병합할 지 여부를 설정합니다. > 실제 병합은 [RowSpan](/docs/props/cell/row-span) 속성을 사용하게 됩니다. > 셀머지 기능 사용시 자동머지 기능과는 별도로 움직임으로 자동머지 기능을 꺼주셔야합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|병합 불가 (`default`)| |`1(true)`|병합 가능| ### Example ```javascript //전체 열들에 대해서 상/하 병합을 허용 options.Def.Col = {Spanned: true}; opiotns.Cfg = { HeaderMerge: 0 // 자동머지 끔 }; //헤더행을 위아래로 병합 options.Cols = [ {Header:[{Value: \"매장명\", RowSpan: 2, Align: \"Center\"},{}], Type: \"Text\", Name: \"사원명\"}, ... ]; ```",
              "see": [
                {
                  "label": "RowSpan cell",
                  "url": "/docs/props/cell/row-span"
                },
                {
                  "label": "Span cell",
                  "url": "/docs/props/cell/span"
                },
                {
                  "label": "Spanned row",
                  "url": "/docs/props/row/spanned"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/spanned.html"
          },
          {
            "cid": 403,
            "sid": "spinner-max",
            "name": "spinner-max",
            "label": "SpinnerMax",
            "data": {
              "body": "> [SpinnerVisible](./spinner-visible)을 사용하는 열에서 화살표를 통한 입력 시 최댓값을 설정할 수 있습니다. > > 추가적으로 [SpinnerStep](./spinner-step), [SpinnerMin](./spinner-min)을 통해 input의 step, min를 설정 할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|편집 시 입력 값의 최댓값| ### Example ```javascript options.Cols = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: true, SpinnerMax: 100000, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerVisible",
                  "url": "./spinner-visible"
                },
                {
                  "label": "SpinnerStep",
                  "url": "./spinner-step"
                },
                {
                  "label": "SpinnerMin",
                  "url": "./spinner-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.88|기능 추가|"
            },
            "url": "docs/props/col/spinner-max.html"
          },
          {
            "cid": 404,
            "sid": "spinner-min",
            "name": "spinner-min",
            "label": "SpinnerMin",
            "data": {
              "body": "> [SpinnerVisible](./spinner-visible)을 사용하는 열에서 화살표를 통한 입력 시 최솟값을 설정할 수 있습니다. > > 추가적으로 [SpinnerStep](./spinner-step), [SpinnerMax](./spinner-Max)을 통해 input의 step, max를 설정 할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|편집 시 입력 값의 최솟값| ### Example ```javascript options.Cols = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: true, SpinnerMin: -1, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerVisible",
                  "url": "./spinner-visible"
                },
                {
                  "label": "SpinnerStep",
                  "url": "./spinner-step"
                },
                {
                  "label": "SpinnerMax",
                  "url": "./spinner-max"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.88|기능 추가|"
            },
            "url": "docs/props/col/spinner-min.html"
          },
          {
            "cid": 405,
            "sid": "spinner-step",
            "name": "spinner-step",
            "label": "SpinnerStep",
            "data": {
              "body": "> [SpinnerVisible](./spinner-visible)을 사용하는 열에서 입력 값의 증감 간격을 설정할 수 있습니다. > > 추가적으로 [SpinnerMax](./spinner-max), [SpinnerMax](./spinner-min)을 통해 input의 min, max를 설정 할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|편집 시 입력 값의 증감 간격| ### Example ```javascript options.Cols = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: true, SpinnerStep: 10, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerVisible",
                  "url": "./spinner-visible"
                },
                {
                  "label": "SpinnerMax",
                  "url": "./spinner-max"
                },
                {
                  "label": "SpinnerMin",
                  "url": "./spinner-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.88|기능 추가|"
            },
            "url": "docs/props/col/spinner-step.html"
          },
          {
            "cid": 406,
            "sid": "spinner-visible",
            "name": "spinner-visible",
            "label": "SpinnerVisible",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Int`, `Float`인 열에서 편집 시 화살표를 표시합니다. > 설정 시 input의 type이 number로 생성됩니다. > > 추가적으로 [SpinnerStep](./spinner-step), [SpinnerMax](./spinner-max), [SpinnerMax](./spinner-min)을 통해 input의 step, min, max를 설정 할 수 있습니다. > `제약사항` [EditMaskFunc](../cfg/edit-mask-func)가 적용된 열에서는 동작하지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|편집 시 화살표를 표시하지 않음 (`default`)| |`1(true)`|편집 시 화살표를 표시| ### Example ```javascript options.Cols = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: true...}, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerStep",
                  "url": "./spinner-step"
                },
                {
                  "label": "SpinnerMax",
                  "url": "./spinner-max"
                },
                {
                  "label": "SpinnerMin",
                  "url": "./spinner-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.88|기능 추가|"
            },
            "url": "docs/props/col/spinner-visible.html"
          },
          {
            "cid": 407,
            "sid": "stack-col",
            "name": "stack-col",
            "label": "Stack",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool` 인 열에서 체크를 통해 화면의 상/하단에 행을 고정시키는 기능 입니다. > 해당 속성을 설정하면 클릭을 통해 행을 고정 / 고정 해제 할 수 있습니다. > 데이터 행의 높이가 같아야 하며, 동적으로 스크롤 행의 개수를 변경시키는 동작 (`정렬, 행추가/제거, 필터`) 에 대해 `제약 사항` 이 있습니다. <br /> ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|고정 기능 사용하지 않음 (`default`)| |`1(true)`|고정 기능 사용| ### Example ```javascript // 체크된 행을 고정하는 컬럼 설정 options.Cfg = { SearchMode: 0, CanSort: 0 }; options.Cols = [ ... { Type: \"Bool\", Header: \"고정행\", Name: \"StackColumn\", Stack: 1... }, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "(Appendix)대용량 모드 제약사항",
                  "url": "/docs/appx/fastload-constraints"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.31|기능 추가|"
            },
            "url": "docs/props/col/stack-col.html"
          },
          {
            "cid": 408,
            "sid": "suggest-delay",
            "name": "suggest-delay",
            "label": "SuggestDelay",
            "data": {
              "body": "> `Suggest`가 설정된 컬럼에서 글자를 입력시 `Suggest`가 나타나기 전까지 딜레이를 ms 단위로 설정합니다. > `debounce`와 유사한 개념으로 딜레이를 설정한 시간 중에 다른 키가 입력되는 경우, 다시 설정한 시간만큼을 기다린 후 `Suggest`를 표시합니다. > 가령 입력하는 글자를 기준으로 `onSuggest()`이벤트에서 디비 조회를 하는 경우, 너무 빈번하게 서버를 호출하는 것을 방지할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|입력 대기 시간 (`default: 0`)| ### Example ```javascript options.Cols = [ ... { Type: \"Text\", Suggest: \"\", //Suggest가 설정된 컬럼에 입력시 300ms 기다린 후 Suggest를 발생시킨다. SuggestDelay: 300, Name: \"CarName\", Width: 120 }, ... ]; ```",
              "see": [
                {
                  "label": "SuggestMin col",
                  "url": "./suggest-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/suggest-delay.html"
          },
          {
            "cid": 409,
            "sid": "suggest-min",
            "name": "suggest-min",
            "label": "SuggestMin",
            "data": {
              "body": "> `Suggest`속성을 통해 설정한 메뉴를 보여주기 위한 최소 글자수를 입력합니다. > 설정을 하지 않으면 한글자라도 입력시 바로 `Suggest목록`이 보여지게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|최소 입력 글자수 (`default: 1`)| ### Example ```javascript //Suggest기능 사용 options.Cols = [ ... { Type: \"Text\", Suggest: \"|싼타페 현대|포터2 현대|그랜저 현대|카니발 기아...\", SuggestMin: 3, //세글자 이상 입력시 Suggest 기능 활성화 Name: \"CarName\", Width: 120 } ... ]; ```",
              "see": [
                {
                  "label": "Suggest col",
                  "url": "./suggest"
                },
                {
                  "label": "SuggestType col",
                  "url": "./suggest-type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/suggest-min.html"
          },
          {
            "cid": 410,
            "sid": "suggest-type",
            "name": "suggest-type",
            "label": "SuggestType",
            "data": {
              "body": "> [Suggest](./suggest)속성 사용과 관련한 다양한 추가기능을 설정합니다. > 여러 기능을 `\",\"` 를 구분자로 하여 설정하실 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`Replace`|`Suggest` 메뉴가 보여질때, 키보드 방향키를 이용하여 커서를 메뉴로 이동하면 셀값이 변경됩니다.| |`Start`|편집모드로 들어갈때 셀의 내용을 기준으로 `Suggest`메뉴를 보여줍니다.| |`StartAll`|편집모드로 들어갈때 셀의 내용과 무관하게 빈 값(\"\")에 대한 `Suggest`메뉴를 보여줍니다. 해당 기능을 사용하면 `Start`는 사용할 수 없습니다.| |`Empty`|셀 값이 비어있을때 모든 `Suggest`메뉴를 보여줍니다.| |`All`|항상 모든 `Suggest`메뉴를 보여줍니다.| |`Case`|대소문자를 구분하여 `Suggest`메뉴를 보여줍니다.| |`Begin`|입력한 글자를 기준으로 `Suggest`메뉴의 아이템을 필터링할때,입력한 글자로 시작하는 아이템만 보여지게 됩니다.| |`Search`|입력한 글자를 포함하는 모든 아이템을 보여줍니다.| |`Complete`|`Suggest`메뉴의 리스트가 한개인 경우 자동으로 입력처리 합니다.| |`IgnoreSpace`|`Suggest`메뉴의 리스트에서 `Space`로 값이 선택되지 않도록 합니다.| |`Validate`|편집모드 종료 또는 셀 붙여넣기 시 셀의 값이 `Suggest`에 설정한 값과 일치하지 않으면 빈값으로 변경됩니다.| ### Example ```javascript //Suggest기능 사용 options.Cols = [ ... { Type: \"Text\", Suggest: \"|싼타페 현대|포터2 현대|그랜저 현대|카니발 기아...\", SuggestType: \"Empty,Begin\", Name: \"CarName\", Width: 120 }, ... ]; ```",
              "see": [
                {
                  "label": "Suggest col",
                  "url": "./suggest"
                },
                {
                  "label": "SuggestMin col",
                  "url": "./suggest-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.27|`IgnoreSpace` 기능 추가||core|8.3.0.1|`Validate` 기능 추가|"
            },
            "url": "docs/props/col/suggest-type.html"
          },
          {
            "cid": 411,
            "sid": "suggest",
            "name": "suggest",
            "label": "Suggest",
            "data": {
              "body": "> 포탈 사이트 검색창의 자동완성과 마찬가지로 셀 안에 들어갈 내용 리스트를 정의해 두면, 입력시 리스트 중에 시작글자가 동일한 값이 필터링되어 보여집니다. > 첫번째 글자를 구분자로 하는 문자열로 설정합니다. ### ![Suggest](/assets/imgs/suggest.gif \"Suggest\") ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫글자를 구분자로 하는 문자열 ( ex: \"\\|우럭\\|광어\\|참돔\\|볼락\\|도다리\\|부시리\") ### Example ```javascript // CarName 열에 추천어를 미리 등록 options.Cols = [ ... { Type: \"Text\", Suggest: \"|싼타페 현대|포터2 현대|그랜저 현대|카니발 기아...\", Name: \"CarName\", Width: 120, ... }, ... ]; ``` ### Try it - [Demo of Suggest](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/Suggest/)",
              "see": [
                {
                  "label": "SuggestType col",
                  "url": "./suggest-type"
                },
                {
                  "label": "SuggestMin col",
                  "url": "./suggest-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/suggest.html"
          },
          {
            "cid": 412,
            "sid": "text-color-2",
            "name": "text-color",
            "label": "TextColor",
            "data": {
              "body": "> 지정한 열에 글자색을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|HEX형식 (ex:#FF00F0) rgb형식 (ex:rgb(244,200,40)| ### Example ```javascript //특정 열의 글자를 파란색으로 표시한다. options.Cols = [ ... {TextColor: \"#0000FF\", Header: \"부서\", Type: \"Text\", Name: \"Dept\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "TextStyle col",
                  "url": "./text-style"
                },
                {
                  "label": "TextSize col",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont col",
                  "url": "./text-font"
                },
                {
                  "label": "Color col",
                  "url": "./color"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/text-color.html"
          },
          {
            "cid": 413,
            "sid": "text-font-2",
            "name": "text-font",
            "label": "TextFont",
            "data": {
              "body": "> 특정 열의 `font-family`를 설정합니다. > 여러개 폰트를 지정하거나 폰트에 띄어씌기가 들어가는 경우에는 `single(')/double quotation(\")`으로 지정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|글자체| ### Example ```javascript //특정열의 글자체를 수정합니다. options.Cols = [ ... { TextFont: \"Dotum\", Header: \"부서\", Type: \"Text\", Name: \"Dept\" }, ... ]; ```",
              "see": [
                {
                  "label": "TextStyle col",
                  "url": "./text-style"
                },
                {
                  "label": "TextColor col",
                  "url": "./text-color"
                },
                {
                  "label": "TextSize col",
                  "url": "./text-size"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/text-font.html"
          },
          {
            "cid": 414,
            "sid": "text-size-2",
            "name": "text-size",
            "label": "TextSize",
            "data": {
              "body": "> 지정한 열의 글자 크기를 설정합니다. > `px, pt, em` 단위를 사용할 수 있으며, 단위를 지정하지 않으면 px기준으로 설정됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|크기숫자와 단위로 이루어진 문자열(ex: 25px)| ### Example ```javascript //특정 열의 글자를 1.2em 지정합니다. options.Cols = [ ... {TextSize: \"1.2em\", Header: \"부서\", Type: \"Text\", Name: \"Dept\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "TextStyle col",
                  "url": "./text-style"
                },
                {
                  "label": "TextColor col",
                  "url": "./text-color"
                },
                {
                  "label": "TextFont col",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/text-size.html"
          },
          {
            "cid": 415,
            "sid": "text-style-2",
            "name": "text-style",
            "label": "TextStyle",
            "data": {
              "body": "> 지정한 열의 글자에 대한 `font-weight, font-style, font-variant, text-decoration`를 숫자로 설정합니다. > 숫자를 서로 더해서 여러 속성을 동시에 적용하 실 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`1`| 굵게 Bold| |`2`| 기울임 Italic| |`4`| 밑줄 Underline| |`8`| 취소선 Strike| |`16`| 윗줄 Overline| |`32`| 작은 대문자 Small Caps| ### Example ```javascript //특정 열의 글자를 기울임이면서 밑줄로 표시한다. options.Cols = [ ... {TextStyle: 6, Header: \"부서\", Type: \"Text\", Name: \"Dept\" ...}, ... ]; ```",
              "see": [
                {
                  "label": "TextColor col",
                  "url": "./text-color"
                },
                {
                  "label": "TextSize col",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont col",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/text-style.html"
          },
          {
            "cid": 416,
            "sid": "time-picker",
            "name": "time-picker",
            "label": "TimePicker",
            "data": {
              "body": "> 시분초 컬럼에 아이콘이 생성됩니다. 아이콘 클릭시, 달력이 아닌 시분초 다이얼로그를 사용합니다. ### 아이콘 표시 조건 > `Type: Date` > `EditFormat`, `Format`, `DataFormat` 3가지의 포맷 중 하나에 날짜 포맷이 없고 시간과 관련된 포맷값만 있을 경우 표시. > ex) `HH:mm` or `HH:mm:ss` > `EditFormat` -> `Format` -> `DataFormat` 우선순위를 따릅니다. > ex) `EditFormat: yyyy-MM-dd`, `DataFormat: HH:mm` 일 경우 TimePicker 아이콘이 표시 되지 않음. ### ![TimePicker](/assets/imgs/timepicker.png) ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|시분초 아이콘 생성하지 않음 (`default`)| |`1(true)`|시분초 아이콘 생성, 다이얼로그 사용| ### Example ```javascript //시분초 컬럼에 TimePicker 설정. options.Cols = [ ... {Type:\"Date\", Name: \"Data_Hms\", Format: 'HH:mm:ss', TimePicker: true} ... ]; ```",
              "see": [
                {
                  "label": "Interval col",
                  "url": "./interval"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.26|기능 추가|"
            },
            "url": "docs/props/col/time-picker.html"
          },
          {
            "cid": 417,
            "sid": "tip-class-2",
            "name": "tip-class",
            "label": "TipClass",
            "data": {
              "body": "> 풍선도움말 객체에 원하는 css클래스를 적용하여 디자인을 설정 합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|풍선도움말 객체에 적용할 클래스 명| ### Example ```css <style> .RedBold{color:red;font-weight:700;} .deepblue{color:#020079;} </style> ``` ```javascript //특정 열에 풍선도움말 표시시 사용될 클레스를 설정. options.Cols = [ ... {Type:\"Text\", Tip: 1, TipClass: \"deepblue\", Name: \"procs\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Tip col",
                  "url": "./tip"
                },
                {
                  "label": "Tip+Value col",
                  "url": "./tip-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/tip-class.html"
          },
          {
            "cid": 418,
            "sid": "tip-position-2",
            "name": "tip-position",
            "label": "TipPosition",
            "data": {
              "body": "> 풍선도움말 객체의 위치나 크기, 정렬을 설정합니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`X`|풍선도움말의 X축 가감 위치| |`Y`|풍선도움말의 Y축 가감 위치| ### Example ```javascript //풍선도움말의 위치조정 options.Cols = [ ... {Type: \"Bool\", Tip: 1, TipPosition: {X: 20, Y: -10}, Name: \"procs\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Tip col",
                  "url": "./tip"
                },
                {
                  "label": "TipClass col",
                  "url": "./tip-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/tip-position.html"
          },
          {
            "cid": 419,
            "sid": "tip-value",
            "name": "tip-value",
            "label": "Tip+Value",
            "data": {
              "body": "> 열의 내용이 특정값일때 풍선도움말로 보여줄 문자를 설정합니다. > 가령 TipY:\"선택하셨습니다\", TipN:\"취소하셨습니다.\" 식으로 `Tip` 과 뒤에 `Value`를 결합한 속성명으로 보여질 문자를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|풍선도움말에 보여질 문자열| ### Example ```javascript //특정 열에 값이 Re인 경우 풍선도움말에 \"반려되었습니다\"가 표시됨 options.Cols = [ ... {Type: \"Text\", Tip: 1, TipRe: \"반려되었습니다\", Name: \"procs\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Tip col",
                  "url": "./tip-value"
                },
                {
                  "label": "TipClass col",
                  "url": "./tip-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/tip-value.html"
          },
          {
            "cid": 420,
            "sid": "tip-2",
            "name": "tip",
            "label": "Tip",
            "data": {
              "body": "> 열 위에 마우스 커서 오버시 풍선도움말을 표시합니다. > 설정을 통해 풍선도움말 사용 여부와 풍선도움말에서 표시될 내용까지 설정할 수 있습니다. ### Type mixed( `boolean` \\| `string` ) ### Options |Value|Description| |-----|-----| |`0(false)`|풍선도움말 사용 안함 (`default`)| |`1(true)`|풍선도움말 사용| |`string`|풍선도움말에서 표시 될 내용 설정| ### Example ```javascript //특정 열에 풍선도움말 기능을 활성화 합니다. options.Cols = [ ... {Type: \"Text\", Tip: 1, Name: \"DESC\", Width: 120 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Tip+Value col",
                  "url": "./tip-value"
                },
                {
                  "label": "TipClass col",
                  "url": "./tip-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/tip.html"
          },
          {
            "cid": 421,
            "sid": "true-value",
            "name": "true-value",
            "label": "TrueValue",
            "data": {
              "body": "> `Bool타입` 열에는 기본적으로 `1(true)/0(falue)`값만 입력이 가능합니다. > 하지만 디비에 저장된 값이 `1(true)/0(false)`가 아닌 별도의 값인 경우를 대비하여 `1(true)`값에 해당하는 값을 해당 속성을 통해 설정합니다. > 해당 속성을 통해 설정된 값은 데이터를 조회([doSearch](/docs/funcs/core/do-search),[loadSearchData](/docs/funcs/core/load-search-data)등)하거나 저장([doSave](/docs/funcs/core/do-save),[getSaveJson](/docs/funcs/core/get-save-json)등)할때 사용됩니다. > 이 속성 값은 단지 서버와 데이터를 주고 받을때만 사용될 뿐, 해당 셀의 값을 `getValue()`를 통해 확인시에는 `1(true)/0(false)`로 리턴됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`Bool타입`의 열에 대해 `1(true)`(체크)에 해당하는 값| ### Example ```javascript //Bool Type 열에 대해서 서버에서 주고 받는 값을 Y/N으로 설정 options.Cols = [ { Type: \"Bool\", Name: \"ConfirmYN\", Align: \"Center\", Width: 70, TrueValue: \"Y\", FalseValue: \"N\" }, ... ]; ``` ### Try it - [Set to \"Y\" With Set to \"N\" by FalseValue](https://jsfiddle.net/gh/get/library/pure/ibsheet/ibsheet8-manual-sample/tree/master/samples/properties/Col/TrueValue-FalseValue/)",
              "see": [
                {
                  "label": "FalseValue col",
                  "url": "./false-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/true-value.html"
          },
          {
            "cid": 422,
            "sid": "type",
            "name": "type",
            "label": "Type",
            "data": {
              "body": "> 셀이 갖고있는 데이터 유형을 의미합니다. > 열을 생성시에는 반드시 선언되어야 합니다. > 일반적인 텍스트나 숫자(정수, 실수) 체크박스, 드랍다운리스트 와 같은 타입이 존재합니다. > 자세한 내용은 [Type appendix](/docs/appx/type)를 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`Text, Int, Float, Date, Bool, Enum` 등 정해진 문자열| ### Example ```javascript //특정 열의 타입을 설정합니다. options.Cols = [ {Type: \"Int\", Name: \"Seq\", Width: 70, ...}, {Type: \"Date\", Name: \"enterDate\", Width: 120, ...}, {Type: \"Text\", Name: \"sa_Nm\", Width: 100, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "Type cell",
                  "url": "/docs/props/cell/type"
                },
                {
                  "label": "getType method",
                  "url": "/docs/funcs/core/get-type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/type.html"
          },
          {
            "cid": 423,
            "sid": "uncheck",
            "name": "uncheck",
            "label": "Uncheck",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool` 인 열이 여러개 있을때, 한 행 내에서 하나의 셀만 체크 가능하게([Radio속성](./radio))하거나, 한 열 내에서 하나의 셀만 체크하게([BoolGroup속성](./bool-group))하는 기능이 있는데, 이러한 기능을 사용시 체크된 상태에서 다시 클릭시 체크 해제를 허용할지 여부를 설정합니다. ### ![Radio](/assets/imgs/radio.png \"같은 행에서 하나만 선택 가능\") ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|체크 해제를 허용 안함| |`1(true)`|체크 해제를 허용 (`default`)| ### Example ```javascript //한번 체크하고 나면 그룹내에서 체크 해제가 불가능하게 설정 options.Cols = [ ... {Type: \"Bool\", Name: \"st1\", Radio: 1, Uncheck: 0 ...}, {Type: \"Bool\", Name: \"st2\", Radio: 1, Uncheck: 0 ...}, {Type: \"Bool\", Name: \"st3\", Radio: 1, Uncheck: 0 ...}, {Type: \"Bool\", Name: \"st4\", Radio: 1, Uncheck: 0 ...}, {Type: \"Bool\", Name: \"st5\", Radio: 1, Uncheck: 0 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Radio col",
                  "url": "./radio"
                },
                {
                  "label": "BoolGroup col",
                  "url": "./bool-group"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/uncheck.html"
          },
          {
            "cid": 424,
            "sid": "unescape-html",
            "name": "unescape-html",
            "label": "UnescapeHTML",
            "data": {
              "body": "> `Text`, `Lines` 타입 컬럼 데이터 조회에서 `&gt;`, `&amp;`, `&lt;` 등의 문자를 unescape 처리하여 `<`, `&`, `>` 문자로 변경하는 기능 ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|문자 그대로 조회 (`default`)| |`1(true)`|문자 unescape 처리하여 조회| ### Example ```javascript // 조회에 들어오는 문자 HTML unescape 처리 options.Cols = [ ... { Type: \"Text\", Name: \"TextData\", Width: 110, UnescapeHTML: 1 ... }, ... ]; ```",
              "see": [
                {
                  "label": "SaveHTMLChar cfg",
                  "url": "/docs/props/cfg/save-html-char"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.24|기능 추가|"
            },
            "url": "docs/props/col/unescape-html.html"
          },
          {
            "cid": 425,
            "sid": "v-align-2",
            "name": "v-align",
            "label": "VAlign",
            "data": {
              "body": "> 셀 안에 문자열 상하 정렬을 설정합니다. > 좌우 정렬과 관련해서는 [Align](./align)속성을 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`Top`|문자열 상단 정렬| |`Middle`|문자열 가운데 정렬| |`Bottom`|문자열 하단 정렬| ### Example ```javascript //특정 열의 문자열을 상단 정렬로 설정 options.Cols = [ ... {Type: \"Text\", Name: \"Description\", VAlign: \"Top\", Width: 100, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Align col",
                  "url": "./align"
                },
                {
                  "label": "VAlign row",
                  "url": "/docs/props/row/v-align"
                },
                {
                  "label": "VAlign cell",
                  "url": "/docs/props/cell/v-align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/v-align.html"
          },
          {
            "cid": 426,
            "sid": "visible-2",
            "name": "visible",
            "label": "Visible",
            "data": {
              "body": "> 열의 보임 감춤/여부를 설정합니다. > 시트 생성시 `Visible:0`으로 설정 후, 나중에 컬럼에 보여주고자 할때는 `setAttribute()`를 통해 속성값을 변경하기 보다는, [showCol()](/docs/funcs/core/show-col)함수를 사용하시기 바랍니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열 감춤| |`1(true)`|열 보임 (`default`)| ### Example ```javascript //특정 열를 감춤 options.Cols = [ ... {Type: \"Int\", Name: \"Pvt_TSum\", Visible: 0, ...}, ... ]; ```",
              "see": [
                {
                  "label": "showCol method",
                  "url": "/docs/funcs/core/show-col"
                },
                {
                  "label": "hideCol method",
                  "url": "/docs/funcs/core/hide-col"
                },
                {
                  "label": "onShowColumn event",
                  "url": "/docs/events/on-show-column"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/visible.html"
          },
          {
            "cid": 427,
            "sid": "width-pad",
            "name": "width-pad",
            "label": "WidthPad",
            "data": {
              "body": "> [Button](./button)속성을 이용하여 셀 우측에 작은 버튼을 표시할때 버튼의 너비를 설정합니다. > 너비는 pixel단위로 설정됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|우측 버튼의 너비| ### Example ```javascript options.Cols = [ ... //셀 우측에 \"확인\"버튼을 표시한다. {Type: \"Text\", Button: \"Button\", ButtonText: \"확인\", WidthPad: 25, Name: \"conf_btn\", Width: 120, ...}, ... ]; ```",
              "see": [
                {
                  "label": "Button col",
                  "url": "./button"
                },
                {
                  "label": "UseButton cfg",
                  "url": "/docs/props/cfg/use-button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/width-pad.html"
          },
          {
            "cid": 428,
            "sid": "width",
            "name": "width",
            "label": "Width",
            "data": {
              "body": "> 열의 너비를 pixel단위로 설정합니다. > 시트객체의 최초 생성시 열의 너비를 의미합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|열의 너비(pixel단위)| ### Example ```javascript //특정 열의 너비를 85px로 설정합니다. options.Cols = [ ... {Type: \"Text\", Name: \"EMPID\", Width: 85, ...}, ... ]; ```",
              "see": [
                {
                  "label": "MaxWidth col",
                  "url": "./max-width"
                },
                {
                  "label": "MinWidth col",
                  "url": "./min-width"
                },
                {
                  "label": "RelWidth col",
                  "url": "./rel-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/width.html"
          },
          {
            "cid": 429,
            "sid": "wrap-2",
            "name": "wrap",
            "label": "Wrap",
            "data": {
              "body": "> 셀에 내용이 많아 뒷부분이 안보여질 때, 줄넘김 기능 사용 여부를 설정합니다. > 줄넘김이 이루어지는 경우 행의 높이가 증가하게 됩니다. > 일반적으로 `Text` 타입에서 사용하며, `Radio` 타입에서도 사용하실 수 있습니다. > [Lines 타입](/docs/appx/type) 컬럼에서는 `default: 1(true)`로 설정됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|줄넘김 사용 안함 (`default`)| |`1(true)`|줄넘김 사용 (`컬럼의 Type이 Lines인 경우 default: 1(true)`)| ### Example ```javascript //특정 열의 줄넘김 허용 options.Cols = [ ... {Header: \"의견\", Type: \"Text\", Wrap: 1, Name: \"DESC\", ...}, ... ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/col/wrap.html"
          }
        ]
      },
      {
        "gid": 4,
        "name": "props-cell",
        "label": "Cell",
        "children": [
          {
            "cid": 430,
            "sid": "Alias",
            "name": "Alias",
            "label": "Alias",
            "data": {
              "body": "> 열의 [Type](/docs/props/cell/type)이 `File`인 경우 실제 파일명 대신 보여질 셀 값을 설정합니다. > 지정하지 않을 경우 실제 파일명이 셀 값에 보여지게 됩니다. > > 구분자를 포함하여 해당 셀의 파일들의 가명을 개별 설정할 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`File`컬럼 셀에 파일명 대신 보여질 문자열| ### Example ```javascript //1. 메소드를 통해 속성 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Alias\", \"myFile\" ); //2. 객체에 직접 접근해서 속성 설정(열이름이 CLS 로 가정) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSAlias\"] = \"myFile\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성설정(열이름이 CLS 로 가정) { data:[ {... , \"CLSAlias\":\"myFile\" , ...} ] } //4. 개별 설정을 하는 경우 { data: [ { \"CLS\": \"testFile.xlsx;testFile2.xlsx\", \"CLSAlias\": \"file1;file2\" } ] } ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "File Type 업로드 appendix",
                  "url": "/docs/appx/file-type-upload"
                },
                {
                  "label": "Path cell",
                  "url": "/docs/props/cell/path"
                },
                {
                  "label": "[Format]"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가||core|8.3.0.21|개별 설정 동작 개선|"
            },
            "url": "docs/props/cell/Alias.html"
          },
          {
            "cid": 431,
            "sid": "accept-enters-2",
            "name": "accept-enters",
            "label": "AcceptEnters",
            "data": {
              "body": "> 타입이 `Lines`인 셀에서 편집중 `Enter키` 입력시 동작에 대해 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|값 변경을 마치고, 편집모드를 종료합니다.| |`1`|줄넘김문자가 삽입되고 계속 편집이 진행됩니다. 편집을 종료하려면 `Ctrl or Shift or Alt + Enter`를 입력하거나 `tab키`를 입력해야 합니다.| |`2`|값 변경을 마치고, 편집모드를 종료합니다. `Ctrl or Shift or Alt + Enter`를 입력하여 줄넘김을 할 수 있습니다.| |`3`|`Ctrl or Shift or Alt + Enter`, `Enter` 모두 줄넘김문자가 삽입됩니다. 편집을 종료하려면 `tab키`를 누르거나 마우스로 다른 셀을 클릭하여야 합니다.| ### Example ```javascript //Lines 셀에서 편집중 Enter키 입력시 줄넘김으로 동작 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"DESC\", \"AcceptEnters\", 1); ```",
              "see": [
                {
                  "label": "EnterMode cfg",
                  "url": "/docs/props/cfg/enter-mode"
                },
                {
                  "label": "AcceptEnters col",
                  "url": "/docs/props/col/accept-enters"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/accept-enters.html"
          },
          {
            "cid": 432,
            "sid": "accept-2",
            "name": "accept",
            "label": "Accept",
            "data": {
              "body": "> [File Type](/docs/appx/file-type-upload) 셀에 업로드를 허용할 파일 형식을 지정하는 속성입니다. > `input type=\"file\"` 의 accept 속성과 동일하게 동작합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|[File Type](/docs/appx/file-type-upload) 셀에 업로드를 허용할 파일 형식을 지정| ### Example ```javascript // Type: File인 셀에 이미지 파일만 업로드 하도록 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"FileUpload\", \"Accept\", 'image/*'); ```",
              "see": [
                {
                  "label": "File Type 업로드",
                  "url": "/docs/appx/file-type-upload"
                },
                {
                  "label": "Accept Col",
                  "url": "/docs/props/col/accept"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/accept.html"
          },
          {
            "cid": 433,
            "sid": "add-class",
            "name": "add-class",
            "label": "AddClass",
            "data": {
              "body": "> 열의 [Type](./type)이 `Button`이고 **[Button](./button)속성의 값이 \"Button\"인 경우**, 셀 버튼에 적용할 css class 명을 설정합니다. > 가령 AddClass에 \"MYBTN\"으로 값을 설정하면 실제 열에는 \"MYBTN\"의 css class 가 추가 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열에 부여할 css class 명| ### Example ```javascript //1. 메소드를 통해 속성 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"EDate\", \"AddClass\", \"MYBTN\"); //2. 객체에 직접 접근해서 속성 설정(열이름이 CLS 로 가정) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSAddClass\"] = \"BTN\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성설정(열이름이 CLS 로 가정) { data:[ {... , \"CLSAddClass\":\"MYBTN\" , ...} ] } ```",
              "see": [
                {
                  "label": "ButtonClass cell",
                  "url": "./button-class"
                },
                {
                  "label": "Button col",
                  "url": "/docs/props/col/button"
                },
                {
                  "label": "ButtonText col",
                  "url": "/docs/props/col/button-text"
                },
                {
                  "label": "UseButton cfg",
                  "url": "/docs/props/cfg/use-button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/add-class.html"
          },
          {
            "cid": 434,
            "sid": "align-3",
            "name": "align",
            "label": "Align",
            "data": {
              "body": "> 문자열 좌우 정렬을 설정합니다. > 트리 또는 그룹에서 사용할 때는 기준으로 지정된 컬럼(**트리의 접힘/펼침 아이콘이 보이는 컬럼**)의 데이터영역은 `Align`이 먹지 않습니다. > 상하 정렬과 관련해서는 [VAlign](./v-align)속성을 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`Left`|문자열 좌측 정렬| |`Center`|문자열 가운데 정렬| |`Right`|문자열 우측 정렬| ### Example ```javascript //특정 셀의 문자열을 오른쪽 정렬로 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Align\", \"Right\"); ```",
              "see": [
                {
                  "label": "VAlign cell",
                  "url": "./v-align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/align.html"
          },
          {
            "cid": 435,
            "sid": "attribute-formula-3",
            "name": "attribute-formula",
            "label": "attribute+Formula",
            "data": {
              "body": "> 셀에 설정 가능한 여러가지 속성(`CanEdit, Color 등`)을 Formula문자열과 결합하여 계산에 따라 속성 값이 적용되게 끔 할수 있습니다. > 자세한 내용은 `col` 설정에서 [attribute + Formula](/docs/props/col/attribute-formula)을 참고해 주세요. > > `※**매우중요**` > 1. 모든 포뮬러 기능을 사용시에는 (row)[**CanFormula**](/docs/props/row/can-formula)가 `1`로 설정되어야 동작합니다. > 2. `attribute + Formula` 사용시에는 반드시 (row)[**CalcOrder**](/docs/props/row/calc-order)에 `열이름+기능명` 형식으로 포뮬러별 계산 순서가 정의되어야 합니다. >가령 \"A\"열에 대해 `CanEdit`속성 포뮬러를 설정하고 \"B\"열에 대해 `Color`속성 포뮬러를 설정했다면, `CalcOrder`에는 \"ACanEdit,BColor\"로 명시하면 됩니다. > 3. **`CalcOrder` 설정시 이름들은 반드시 띄어쓰기 없이 서로 붙여 작성해주셔야 됩니다. 이름들 간에 띄어쓰기가 되어 있는 경우 Formula 동작이 정상적으로 이뤄지지 않습니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|각 속성에 들어갈 값을 계산하는 계산식| ### Example ```javascript // 생성시 CalcOrder 정의 options.Def.Row = { // 열이름 간에 띄어쓰지말고 전부 붙여쓰셔야 합니다. CalcOrder: \"CLSCanEdit,CLSColor\" }; // 조회 데이터 내에서 속성 적용 // CHK열의 값이 false 이면 CLS 열은 편집 불가 // AMT열의 값이 4000 보다 크면 CLS 열에 핑크색 배경색 적용 { data:[ {..., \"CLSCanEditFormula\": \"CHK?1:0\", \"CLSColorFormula\": \"AMT>4000?'#FFDDDD':''\", ...} ] } ```",
              "see": [
                {
                  "label": "CanFormula row",
                  "url": "/docs/props/row/can-formula"
                },
                {
                  "label": "CalcOrder row",
                  "url": "/docs/props/row/calc-order"
                },
                {
                  "label": "Formula appendix",
                  "url": "/docs/appx/formula"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/attribute-formula.html"
          },
          {
            "cid": 436,
            "sid": "auto-calendar-3",
            "name": "auto-calendar",
            "label": "AutoCalendar",
            "data": {
              "body": "> [Type](/docs/appx/type)이 Date인 셀에 대해 사용자가 편집모드로 들어갈때 달력을 띄울지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|기능 사용 안함 (`default`)| |`1(true)`|편집시 달력을 띄움| ### Example ```javascript //메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"AutoCalendar\", 1); ```",
              "see": [
                {
                  "label": "AutoCalendar col",
                  "url": "/docs/props/col/auto-calendar"
                },
                {
                  "label": "AutoCalendar cfg",
                  "url": "/docs/props/cfg/auto-calendar"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/auto-calendar.html"
          },
          {
            "cid": 437,
            "sid": "bool-group-2",
            "name": "bool-group",
            "label": "BoolGroup",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool`인 셀 내에서 동일 그룹으로 묶을지 여부를 설정합니다. > 입력하는 숫자가 그룹에 인덱스가 되어 같은 값을 갖고있는 셀간에는 하나만 체크가 됩니다. > (마치 라디오처럼 체크될때 따른 셀은 자동으로 언체크 됩니다.) ### ![BoolGroup](/assets/imgs/boolGroup.png \"그룹으로 묶인 행에서 하나만 선택 가능\") ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|라디오처럼 하나로 묶을 그룹 인덱스| ### Example ```javascript //열 내에서 1,2,3번행 그룹과 4,5,6번 행 그룹 내에서 단일 셀만 체크 가능하게 합니다. sheet.setAttribute( sheet.getRowById(\"AR1\"), \"CLS\", \"BoolGroup\", \"1\" ); sheet.setAttribute( sheet.getRowById(\"AR2\"), \"CLS\", \"BoolGroup\", \"1\" ); sheet.setAttribute( sheet.getRowById(\"AR3\"), \"CLS\", \"BoolGroup\", \"1\" ); sheet.setAttribute( sheet.getRowById(\"AR4\"), \"CLS\", \"BoolGroup\", \"2\" ); sheet.setAttribute( sheet.getRowById(\"AR5\"), \"CLS\", \"BoolGroup\", \"2\" ); sheet.setAttribute( sheet.getRowById(\"AR6\"), \"CLS\", \"BoolGroup\", \"2\" ); ```",
              "see": [
                {
                  "label": "Radio cell",
                  "url": "/docs/props/cell/radio"
                },
                {
                  "label": "BoolIcon cell",
                  "url": "/docs/props/cell/bool-icon"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/bool-group.html"
          },
          {
            "cid": 438,
            "sid": "bool-icon-2",
            "name": "bool-icon",
            "label": "BoolIcon",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool`인 셀에서 체크/언체크 아이콘을 다른 이미지나 Html 객체로 설정합니다. > 임의의 이미지를 체크박스 아이콘으로 사용하고자 하는 경우에는, 언체크 이미지와 체크 이미지를 첫글자를 구분자로 하여 연결된 문자열로 설정하시면 됩니다. (ex:\"|Off.gif|On.gif\") > > 임의의 이미지를 체크박스 아이콘으로 사용할 때, 해당 열내의 셀이 편집불가([CanEdit](/docs/props/cell/can-edit))인 경우가 있다면 편집 불가일 때의 이미지까지해서 총 4개의 이미지를 설정하시면 됩니다. (ex:\"|Off.gif|On.gif|OffReadOnly.gif|OnReadOnly.gif\") > > 여러개의 라디오 아이콘을 사용하고자 하는 경우에는 언체크 이미지와 체크이미지를 이어서 설정하시면 됩니다. (ex:\"|Off1.gif|On1.gif|Off2.gif|On2.gif|Off3.gif|On3.gif\") > > 그 외에 일반적인 숫자형식으로 아래 Options에서와 같이 기능을 설정하실 수 있습니다. ### Type `mixed`( `string` \\| `number` ) ### Options |Value|Description| |-----|-----| |`0`|기본적인 내장 체크박스 이미지를 사용 (`default`) |`1`|내장 라디오 이미지를 사용| |`2`|무조건 middle 정렬되는 체크박스 이미지를 사용(`성능이 0번 옵션보다 느림`)| |`3`|무조건 middle 정렬되는 라디오 이미지를 사용(`성능이 1번 옵션보다 느림`)| |`4`|\\<input type=\"checkbox\">객체를 사용(`IE에서 성능이 좋음`)| |`5`|\\<input type=\"radio\">객체를 사용(`IE에서 성능이 좋음`)| |`6`|div객체를 이용하여 체크박스를 구현(`IE 호환성 보기에서 성능이 좋음`)| ### Example ```javascript //html객체로 체크박스 표현 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"BoolIcon\", 4); ```",
              "see": [
                {
                  "label": "BoolIconWidth cell",
                  "url": "/docs/props/cell/bool-icon-width"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/bool-icon.html"
          },
          {
            "cid": 439,
            "sid": "button-text-2",
            "name": "button-text",
            "label": "ButtonText",
            "data": {
              "body": "> [Button](/docs/props/cell/button)속성의 값이 `Button`이거나 `Html`인 경우, 셀 버튼에 표시할 문자를 설정합니다. > > `Button속성`의 값이 `Button`인 경우에는 설정한 문자가 \\<u>나 \\<button>태그로 표시되며, `Html`인 경우에는 <span>입력</span>식의 Html 문자가 해석되어 셀에 표시됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|버튼에 들어갈 문자열| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ButtonText\", \"확인\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSButtonText\"] = \"<span class='spBtn'>완료</spn>\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS) { data:[ {..., \"CLSButtonText\":\"보류\" , ...} ] } ```",
              "see": [
                {
                  "label": "Button cell",
                  "url": "/docs/props/cell/button"
                },
                {
                  "label": "UseButton cfg",
                  "url": "/docs/props/cfg/use-button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/button-text.html"
          },
          {
            "cid": 440,
            "sid": "button-width-3",
            "name": "button-width",
            "label": "ButtonWidth",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Button`이고, [Button](/docs/props/cell/button)속성의 값이 `Button`인 경우, 셀에 생성되는 버튼 객체의 너비를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|버튼 객체의 너비| ### Example ```javascript //버튼의 너비를 80px로 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ButtonWidth\", 80); ```",
              "see": [
                {
                  "label": "Button cell",
                  "url": "/docs/props/cell/button"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/button-width.html"
          },
          {
            "cid": 441,
            "sid": "button-2",
            "name": "button",
            "label": "Button",
            "data": {
              "body": "> 셀의 우측에 원하는 아이콘이미지, 체크박스 혹은 버튼을 표시하는 기능입니다. > 열의 [Type](/docs/appx/type)이 `Date`거나 `Enum`인 경우에는 설정과 상관없이 달력이나 드롭다운 모양의 버튼이 표시됩니다. > > 열의 타입이 `Button`인 경우에는 셀 버튼에 대한 기능으로 동작하게 됩니다. > *셀의 좌측에 버튼을 설정하고자 할때는 [Icon](/docs/props/cell/icon)속성을 확인하세요.* ### ![Button속성](/assets/imgs/button1.png \"Button속성\") [그림1] ![Button속성](/assets/imgs/button2.png \"Button속성\") [그림2] ![Button속성](/assets/imgs/button3.png \"Button속성\") [그림3] ### Type `string` ### Options **열의 Type이 Button이 아닌 경우** |Value|Description| |-----|-----| |`Clear`|셀 우측에 셀 내용을 지우기위한 버튼이 표시됩니다. [그림1] 참고| |`Check`|셀 우측에 체크박스를 표시합니다. [그림2] 참고| |`Html`|[ButtonText](/docs/props/cell/button-text) 속성으로 원하는 HTML태그를 넣으면 셀 우측에 표시됩니다.| |`공백`|원래 보여져야 하는 버튼 이미지를 감춥니다. 가령 Date 타입 열은 기본적으로 달력버튼이 표시되는데 이 속성을 이용하여 버튼을 감출수 있습니다. |`기타`|이미지 파일에 대한 url을 넣으면 버튼의 배경으로 이미지가 표시됩니다. [그림3] 참고 (이미지는 gif, png, jpg만 가능 / 클릭시 `onButtonClick이벤트`가 호출)| **열의 Type이 Button인 경우** |value|desc| |---|---| |`Button`|일반적인 버튼 형태로 보여줍니다. [UseButton](/docs/props/cfg/use-button)속성의 값에 따라 셀의 값을 \\<u>태그 또는 \\<button>태그로 만들어 줍니다.| |`Html`|속성을 `Html`로 설정하고 셀의 값을 `Html` 형태로 사용하실 수 있습니다. (ex: <div class=\"button>버튼\\</div>)| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Button\", \"Clear\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSButton\"] = \"/images/alBtn.gif\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS) { data:[ {..., \"CLSButton\":\"Check\", ...} ] } ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "ButtonText cell",
                  "url": "/docs/props/cell/button-text"
                },
                {
                  "label": "UseButton cfg",
                  "url": "/docs/props/cfg/use-button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/button.html"
          },
          {
            "cid": 442,
            "sid": "can-edit-4",
            "name": "can-edit",
            "label": "CanEdit",
            "data": {
              "body": "> 셀에 대한 편집 가능 여부를 설정합니다. > 이 속성은 기본값은 `1`인데, `0`설정시 `Cell, Row, Col`순으로 우선 순위를 갖습니다. > 가령 `Cell`에서 `0`으로 설정시 `Row`나 `Col`에서 `1`을 설정해도 해당 셀은 편집이 불가능해 집니다. > `CanEdit: 4`를 제외하고는 편집불가 모드 사용시 `Enum` 컬럼의 아이콘과 `Date` 타입 컬럼의 달력 아이콘을 표현하지 않습니다. > `Cfg`를 이용하여 편집불가 사용시에는 우선순위가 가장 높아짐으로, `Cell, Row, Col`에 `CanEdit: 0`은 먹히지 않습니다. > `Button` 타입의 버튼 클릭 시 동작, `File` 타입의 아이콘 표시 여부에 대해서는 해당 속성의 영향을 **`받지 않습니다`**. ([Disabled col](/docs/props/cell/disabled) 통하여 제어 가능.) ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|셀을 편집 불가(읽기 전용)으로 설정합니다. ![CanEdit](/assets/imgs/canEdit0.png \"CanEdit\")| |`1`|셀을 편집 가능으로 설정합니다. ![CanEdit](/assets/imgs/canEdit1.png \"CanEdit\")| |`2`|셀의 내용은 편집 불가하지만, 편집 미리보기를 제공하여 셀의 모든 내용을 확인할 수 있습니다. ![CanEdit](/assets/imgs/canEdit2.png \"CanEdit\")| |`3`|셀 편집 불가능(편집 가능 불가능에 대한 배경색을 표시하지 않음) [ColorState (cfg)](/docs/props/cfg/color-state)와 관계없이 배경색을 표현하지 않음.| |`4`|셀 편집 불가능 + 배경색 표현안함 + 아이콘표시| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"CanEdit\", 0); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSCanEdit\"] = 1; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {..., \"CLSCanEdit\":0, ...} ] } ```",
              "see": [
                {
                  "label": "CanEdit row",
                  "url": "/docs/props/row/can-edit"
                },
                {
                  "label": "CanEdit col",
                  "url": "/docs/props/col/can-edit"
                },
                {
                  "label": "getCanEdit method",
                  "url": "/docs/funcs/core/get-can-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.12|`CanEdit:3, 4` 추가|"
            },
            "url": "docs/props/cell/can-edit.html"
          },
          {
            "cid": 443,
            "sid": "can-focus-3",
            "name": "can-focus",
            "label": "CanFocus",
            "data": {
              "body": "> 셀에 클릭이나 키보드를 통한 이동시 포커스 가능 여부를 설정합니다. > `CanFocus:0(false)`으로 설정된 셀에 대해서는 클릭을 통한 포커스 진입이 불가능하고, 키보드의 Tab 키를 이용한 이동시 열을 건너뛰게 됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|포커스 진입 불가| |`1(true)`|포커스 집입 가능 (`default`)| ### Example ```javascript //특정 셀에 대해서 포커스가 들어가지 않게 한다. var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSCanFocus\"] = 0; ```",
              "see": [
                {
                  "label": "CanFocus row",
                  "url": "/docs/props/row/can-focus"
                },
                {
                  "label": "CanFocus col",
                  "url": "/docs/props/col/can-focus"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/can-focus.html"
          },
          {
            "cid": 444,
            "sid": "can-paste",
            "name": "can-paste",
            "label": "CanPaste",
            "data": {
              "body": "> 행에서 특정 열에 대한 붙여넣기를 제한합니다. > `ctrl+c` 를 통해 복사시 클립보드에 저장되지만 `ctrl+v` 를 통해 붙여넣기는 되지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|붙여넣기 불가| |`1(true)`|붙여넣기 가능 (`default`)| ### Example ```javascript // 적용 방법 1. var ROW = sheet.getRowById(\"AR1\"); ROW[\"sMoneyCanPaste\"] = 0; // 적용 방법 2. var OPT = { \"Def\": { \"Row\": { \"컬럼이름\": { CanPaste: 0 } // or \"컬럼이름CanPaste\": 0 } } } ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.2.0.0|기능 추가|<!-- |`[비공개]` core|8.2.0.0|기능 공개| -->"
            },
            "url": "docs/props/cell/can-paste.html"
          },
          {
            "cid": 445,
            "sid": "case-sensitive-2",
            "name": "case-sensitive",
            "label": "CaseSensitive",
            "data": {
              "body": "> 소팅시(혹은 필터 기능 사용시) 대소문자 구분 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|대소문자 구분 안함| |`1(true)`|대소문자 구분 사용 (`default`)| ### Example ```javascript //특정 셀 데이터에 대해서 소팅시 대소문자 구분 안함. //조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSCaseSensitive\":\"0\" , ...} ] } ```",
              "see": [
                {
                  "label": "RawSort cell",
                  "url": "./raw-sort"
                },
                {
                  "label": "NumberSort cell",
                  "url": "./number-sort"
                },
                {
                  "label": "SortValue cell",
                  "url": "./sort-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/case-sensitive.html"
          },
          {
            "cid": 446,
            "sid": "changed-2",
            "name": "changed",
            "label": "Changed",
            "data": {
              "body": "> 셀의 변경 여부를 나타냅니다. > 셀의 값을 수정시 자동으로 `1(true)`로 수정되고, 값을 원래 값으로 복원하면 자동으로 속성이 제거됩니다. > 별도로 [NoColor](./no-color) 속성을 설정하지 않으면, 수정시 셀의 배경색상은 css/default(테마)/main.css파일에 .IBColorChangedCell 로 설정한 색상 (기본값:#EEE 연한 회색)으로 변경됩니다. > 이 속성은 직접 값을 변경하기 보다는 수정 여부를 확인하는 용도로 사용할 것을 권합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`1(true)`|수정됨| ### Example ```javascript //셀값의 수정여부를 확인합니다. (열이름이 CLS 라고 가정) var row = sheet.getRowById(\"AR10\"); if (row[\"CLSChanged\"]) { //셀값이 수정되었습니다... } ```",
              "see": [
                {
                  "label": "Changed row",
                  "url": "/docs/props/row/changed"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/changed.html"
          },
          {
            "cid": 447,
            "sid": "checked",
            "name": "checked",
            "label": "Checked",
            "data": {
              "body": "> [Icon](/docs/props/col/icon)속성이나 [Button](/docs/props/col/button)속성의 값을 \"Check\" 로 설정하여 셀 안에 체크박스가 생성되었을때, 체크 여부를 확인하거나 수정합니다. ### ![ICON Check](/assets/imgs/iconCheck.png \"Icon:Check 사용한 경우\") [**Icon:\"Check\"사용 예**] ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|체크 해제됨| |`1`|체크됨| |`2`|알 수 없음(체크 박스 안에 \"?\"문자가 표시됨)| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Checked\", 1); //2. 객체에 직접 접근해서 속성 확인 (열이름 :CLS) var ROW = sheet.getRowById(\"AR10\"); var cellchk = ROW[\"CLSChecked\"]; //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS) { \"data\":[ {... , \"CLSChecked\":1 , ...} ] } ```",
              "see": [
                {
                  "label": "Icon col",
                  "url": "/docs/props/col/icon"
                },
                {
                  "label": "Button col",
                  "url": "/docs/props/col/button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/checked.html"
          },
          {
            "cid": 448,
            "sid": "class-3",
            "name": "class",
            "label": "Class",
            "data": {
              "body": "> 셀에 적용할 커스텀 css class명을 설정합니다. > **<mark>주의</mark> : Class로 적용한 css는 엑셀 다운로드시 디자인 반영되지 않습니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열에 적용할 css class 명| ### Example ```css <style> .RedBold{color:#FF0000;font-weight:700} </style> ``` ```javascript //특정 셀에 \"RedBold\" 클래스를 적용 var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSClass\"] = \"RedBold\"; //변경내용 반영 sheet.refreshCell({row:ROW, col:\"CLS\"}); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/class.html"
          },
          {
            "cid": 449,
            "sid": "clear-2",
            "name": "clear",
            "label": "Clear",
            "data": {
              "body": "> 열 간에 관계형 콤보를 사용할 때, 상위 콤보에 값이 바뀌었을 때 클리어 되어야 하는 하위 열을 정의 합니다. > 관계형 콤보 구성과 관련해서는 (col) [Related](/docs/props/col/related) 속성을 참고해 주세요. > [CanEmpty](./can-empty) 속성에 영향을 받아 `CanEmpty: 0` 일 경우에는 Enum의 첫 번째 값으로 설정이 됩니다. > `CanEmpty: 1` 일 경우에는 빈 문자열로 설정 됩니다. > `참고` : 관계형 콤보의 `(cell)Clear, (cell)CanEmpty` 는 사용자의 action(change 이벤트가 발생하는) 에 의해서만 동작합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자신의 하위관계 열이름 (여러개인 경우 \",\"구분자로 지정)| ### Example ```javascript sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS1\", \"Clear\", \"CLS2,CLS3\"); ```",
              "see": [
                {
                  "label": "Related cell",
                  "url": "/docs/props/cell/related"
                },
                {
                  "label": "Enum cell",
                  "url": "/docs/props/cell/enum"
                },
                {
                  "label": "EnumKeys cell",
                  "url": "/docs/props/cell/enum-keys"
                },
                {
                  "label": "CanEmpty cell",
                  "url": "/docs/props/col/can-empty"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/clear.html"
          },
          {
            "cid": 450,
            "sid": "col-merge-2",
            "name": "col-merge",
            "label": "ColMerge",
            "data": {
              "body": "> 헤더 영역에서 값 기준 병합 실행([DataMerge](/docs/props/cfg/DataMerge), [HeaderMerge](/docs/props/cfg/HeaderMerge))시 열을 포함할지 여부를 설정합니다. > 병합 대상에서 제외/포함할 열에 해당하는 헤더 영역의 <b>모든 셀</b>에 설정해야 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|병합 할 때 열을 포함하지 않습니다. | |`1(true)`|병합 할 때 열을 포함합니다. | ### Example ```javascript options.Cfg = { IgnoreHeaderColMerge: false, // ColMerge 속성을 헤더 영역에도 적용합니다. }; options.Cols = [ ... { Header: [{ Value: \"부서1\", ColMerge:0 }, { Value: \"부서2\", ColMerge:0 }, { Value: \"부서3\", ColMerge:0 },{ Value: \"부서4\", ColMerge:0 }], Type:\"Text\", Name:\"Dept\", ColMerge:false, Width:100 ...}, ... ]; ```",
              "see": [
                {
                  "label": "RowMerge row",
                  "url": "/docs/props/row/RowMerge"
                },
                {
                  "label": "ColMerge col",
                  "url": "/docs/props/col/ColMerge"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/DataMerge"
                },
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/HeaderMerge"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/col-merge.html"
          },
          {
            "cid": 451,
            "sid": "color-3",
            "name": "color",
            "label": "Color",
            "data": {
              "body": "> 셀의 배경 색상을 설정합니다. > 색상은 상태에 따른 배경 색상의 영향을 받습니다. > rgb(255,255,255)는 투명색이 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|HEX형식 (ex:#FF00F0) rgb형식 (ex:rgb(244,200,40)| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSColor\":\"#ADADAD\" , ...} ] } ```",
              "see": [
                {
                  "label": "TextColor cell",
                  "url": "./text-color"
                },
                {
                  "label": "TextStyle cell",
                  "url": "./text-style"
                },
                {
                  "label": "TextSize cell",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont cell",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/color.html"
          },
          {
            "cid": 452,
            "sid": "copy-value",
            "name": "copy-value",
            "label": "CopyValue",
            "data": {
              "body": "> 셀의 원래 값 대신 `Ctrl+C(혹은 Ctrl+X)`시 클립보드로 복사될 값을 설정합니다. > 특히 타입이 Html이나 버튼 같이 편집이 불가능한 셀에 유용하게 사용하실 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|복사시 클립보드로 들어갈 문자| ### Example ```javascript //특정 열에 대해서 복사시 원래 데이터가 아닌 다른 문자가 복사되게 끔 합니다. sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"CopyValue\", \"복사불가필드\"); ```",
              "see": [
                {
                  "label": "SortValue cell",
                  "url": "./sort-value"
                },
                {
                  "label": "FilterValue cell",
                  "url": "./filter-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/copy-value.html"
          },
          {
            "cid": 453,
            "sid": "cursor-2",
            "name": "cursor",
            "label": "Cursor",
            "data": {
              "body": "> 셀 위에 마우스 커서가 호버시 커서의 모양을 설정합니다. > 설정가능한 커서의 모양은 css를 따릅니다. > ex) auto, crosshair, default, pointer, move, e-resize, ne-resize, nw-resize, n-resize, se-resize, sw-resize, w-resize, text, wait, help ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 커서 모양| ### Example ```javascript //셀에 커서가 들어갔을때 커서 모양을 클릭가능한 손가락 모양으로 변경. { data:[ {... , \"CLSCursor\":\"pointer\" , ...} ] } ```",
              "see": [
                {
                  "label": "Cursor col",
                  "url": "/docs/props/col/cursor"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/cursor.html"
          },
          {
            "cid": 454,
            "sid": "custom-format-2",
            "name": "custom-format",
            "label": "CustomFormat",
            "data": {
              "body": "> 원본 데이터에 대한 마스킹을 정의합니다. > <mark>[Type](/docs/appx/type)이 `Text`또는 `Lines`인 경우</mark>에 사용가능한 사용자 정의 포맷으로, 사용자가 선언한 커스텀 포맷 함수도 지정가능합니다. > `CustomFormat`에서 사용 가능한 예약어는 다음과 같습니다. > |Value|Description| > |-----|-----| > |`#`|그대로 보여지는 글자(숫자)| > |`*`| *(별표)로 처리되는 글자(숫자)| > |`PostNo` | 우편번호 | > |`IdNo` | 주민등록번호(뒤 6자리 *(별표)로 처리) | > |`IdNoMask` | 주민등록번호(full text) | > |`SaupNo` | 사업자 등록번호 | > |`CardNo` | 카드번호 | > |`PhoneNo` | 전화번호 | ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열의 Type에 따른 다양한 포맷설정 문자열| ### Example ```javascript //주민등록번호 포맷을 정의합니다. { data:[ {... , \"CLSCustomFormat\":\"IdNoMask\" , ...} ] } //사업자 번호와 주민등록번호 마스킹 적용 { data:[ {... , \"CLSCustomFormat\":\"SaupNo|IdNo\" , ...} ] } ```",
              "see": [
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                },
                {
                  "label": "Format cell",
                  "url": "./format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/custom-format.html"
          },
          {
            "cid": 455,
            "sid": "data-format-2",
            "name": "data-format",
            "label": "DataFormat",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Date`인 셀에 로딩할 데이터의 포매팅을 설정합니다. > 다시 말해 서버에서 가져오거나 서버로 내보낼 데이터의 포맷을 설정합니다. > 가령 조회 데이터의 날짜가 \"25012017\"와 같다면 `DataFormat`에는 \"ddMMyyyy\"로, 데이터가 \"20171225\"와 같다면 \"yyyyMMdd\"로 설정되어야 합니다. > 시트에서 수정한 내용이 서버로 전달 될때에도 이 속성을 통해 변경한 포맷으로 서버에 문자열이 전달됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|yyyyMMdd 등 정해진 문자열| ### Example ```javascript //1. 메소드를 통해 특정 셀의 DataFormat을 변경 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"EDate\", \"DataFormat\", \"yyyyMMdd\"); //변경내용 확인(수정한 포맷으로 데이터 추출됨) var json = sheet.getSaveJson(); //2. 객체에 직접 접근해서 DataFormat 변경 (CLS열의 DataFormat을 \"yyyyMMddHHmm\"로 변경) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSDataFormat\"] = \"yyyyMMddHHmm\"; //변경내용 확인(수정한 포맷으로 데이터 추출됨) var json = sheet.getSaveJson(); //3. 조회 데이터 내에서 DataFormat 변경 { data:[ {... ,\"CLS\":\"12312018\" \"CLSFormat\":\"MMddyyyy\" , ...} ] } ```",
              "see": [
                {
                  "label": "Format cell",
                  "url": "./format"
                },
                {
                  "label": "EditFormat cell",
                  "url": "./edit-format"
                },
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/data-format.html"
          },
          {
            "cid": 456,
            "sid": "date-strict-mode-3",
            "name": "date-strict-mode",
            "label": "DateStrictMode",
            "data": {
              "body": "> 조회시 [Type](/docs/appx/type)이 `Date`인 셀에서 `DataFormat`이 설정된 경우 설정된 포맷과 길이가 일치하지 않거나 잘못된 날짜가 조회되는 경우 공백으로 처리합니다. > `DataFormat`을 \"yyyyMMdd\" 로 설정한 후 \"88\" 이라는 값이 조회되는 경우 해당 셀 값은 공백으로 처리됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|정밀검사하지 않음 (`default`)| |`1(true)`|`DataFormat`에 설정된 포맷에 대한 정밀 검사| ### Example ```javascript // 해당 컬럼에 DataFormat이 설정되어있다면 options.Cols = [ ... // DateStrictMode를 사용하기 위해선 DataFormat이 설정되어야 합니다. {Type: \"Date\", Format: \"yyyy.MM.dd\", DataFormat: \"yyyyMMdd\", Name: \"CLS\", Width: 120 ...}, ... ]; //특정 셀에서 잘못된 날짜 데이터 조회시 공백처리 합니다. { data:[ {... ,\"CLS\":\"12312018\" \"CLSDateStrictMode\":\"1\" , ...} ] } ```",
              "see": [
                {
                  "label": "DataFormat col",
                  "url": "/docs/props/col/data-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.12|기능 추가|"
            },
            "url": "docs/props/cell/date-strict-mode.html"
          },
          {
            "cid": 457,
            "sid": "decimal-adjust-3",
            "name": "decimal-adjust",
            "label": "DecimalAdjust",
            "data": {
              "body": "> Int, Float 타입 컬럼 데이터의 근사값 처리방식을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`round`|근사값을 반올림으로 처리합니다. (`default`)| |`floor`|근사값을 내림으로 처리합니다.| |`ceil`|근사값을 올림으로 처리합니다.| ```javascript //조회 데이터 내에서 속성 적용 (열이름 :FloatData ) { data:[ {... , \"FloatData\": 15.1, \"FloatDataDecimalAdjust\": \"floor\", ...} // 해당 셀의 근사값 처리 방식을 내림으로 설정 ] } ``` ### Since |product|version|desc| |---|---|---| |core|8.0.0.11|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|8.0.0.11|기능 추가|"
            },
            "url": "docs/props/cell/decimal-adjust.html"
          },
          {
            "cid": 458,
            "sid": "disabled-2",
            "name": "disabled",
            "label": "Disabled",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Button`, `File`인 셀에 대해 버튼 사용 가능 여부를 설정합니다. > `Type:\"Button\", Disabled:1` : 버튼 셀이 비활성화 색으로 변경되며, click 이벤트 발생하지 않는다 > `Type:\"File\", Disabled:1` : 파일 추가, 제거 버튼이 표시되지 않는다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|버튼 기능 사용 가능 (`default`)| |`1(true)`|버튼 기능 사용 불가| ### Example ```javascript //특정 셀의 버튼을 사용불가로 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Disabled\", 1); ```",
              "see": [
                {
                  "label": "Button cell",
                  "url": "./button"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/disabled.html"
          },
          {
            "cid": 459,
            "sid": "edit-enum-2",
            "name": "edit-enum",
            "label": "EditEnum",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Enum`인 셀에서 드랍리스트가 펼쳐졌을때 보여지는 아이템의 Text를 [Enum](./enum)에서 설정한 값과 다르게 하고자 할때 사용합니다. > '\\\\t'구분자를 이용하여 아이템을 여러개의 컬럼으로 표현할 수 있습니다. ### **1. 일반적인 EditEnum 사용** ![EditEnum](/assets/imgs/editEnum.png \"EditEnum\") **2. '\\t' 구분자를 사용한 EditEnum 사용** ![EditEnum2](/assets/imgs/editEnum2.png \"EditEnum2\") ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#사장#부사장#전무#상무#이사#부서장#차장#과장#대리#주임#사원\")| ### Example ```javascript //Enum 열에 item을 설정한다. { \"data\":[ ... { ..., CLSEnum: \"|시흥현장|안산현장|화성현장\", CLSEditEnum: \"|경기도 시흥시 은행로216번길 26|경기도 안산시 단원구 안산천남로 245|경기도 화성시 동탄반석로 96\" }, { ..., CLSEnum: \"|시흥현장|안산현장|화성현장\", CLSEditEnum: \"|경기도\\t시흥시\\t은행로216번길 26|경기도\\t안산시 단원구\\t안산천남로 245|경기도\\t화성시\\t동탄반석로 96\" } ... ] } ```",
              "see": [
                {
                  "label": "Enum cell",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys cell",
                  "url": "./enum-keys"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/edit-enum.html"
          },
          {
            "cid": 460,
            "sid": "edit-format-2",
            "name": "edit-format",
            "label": "EditFormat",
            "data": {
              "body": "> 사용자가 셀을 더블클릭하여 편집모드로 들어갔을때 보여 줄 포맷을 설정합니다 > 각 열의 [Type](/docs/appx/type)에 따라 설정 방법이나 동작이 달라집니다. > 가장 쉽게 이해하자면 날짜 유형 포맷을 사용하는 열에서 \"EditFormat\":\"ddMMyyyy\"로 설정하면, 셀에 보여질때는 \"2019-12-31\"형식으로 보여지다가, 사용자가 셀의 데이터를 편집하려 할때는 \"31122019\"로 나타나게 됩니다. > 포맷에 대한 자세한 내용은 appendix의 [Format](/docs/appx/format)을 참고해 주세요. ### Type mixed( `string` \\| `object` ) ### Options | Column Type | Type | Description | |---|---|---| |Text, Lines|`object`|셀에서 더블클릭을 통해 편집모드로 들어갈때 원래의 값을 어떤 형식으로 보여줄지 설정합니다. ex) \"EditFormat\":{\"KOR\":\"대한민국\", \"JPN\":\"일본\", \"USA\":\"미국\"} 셀의 값이 KOR일때 편집모드로 들어가면 대한민국으로 보여줌 ![EditFormat Text](/assets/imgs/editFormatText.png)| |Date|`string`|편집시 보여질 년,월,일의 순서 ex) \"EditFormat\":\"ddMMyyyy\" ![EditFormat Date](/assets/imgs/editFormatDate.png)| ### Example ```javascript //1. 메소드를 통해 특정 셀의 포맷을 변경 sheet.setAttribute( sheet.getRowById(\"AR99\") , \"EDate\" , \"EditFormat\" ,\"MMddyyyy\"); //2. 객체에 직접 접근해서 타입변경 (CLS열의 포맷을 \"dd-MM-yyyy\"로 변경) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSEditFormat\"] = \"ddMMyyyy\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 포맷 변경 { data:[ {... , \"CLSEditFormat\":\"yyyyMMdd\" , ...} ] } ```",
              "see": [
                {
                  "label": "Format cell",
                  "url": "./format"
                },
                {
                  "label": "DataFormat cell",
                  "url": "./data-format"
                },
                {
                  "label": "EditFormat col",
                  "url": "/docs/props/col/edit-format"
                },
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/edit-format.html"
          },
          {
            "cid": 461,
            "sid": "edit-mask-2",
            "name": "edit-mask",
            "label": "EditMask",
            "data": {
              "body": "> 셀에 입력가능한 문자를 자바스크립트 정규식을 이용하여 설정합니다. > 여기서 입력한 글자는 정규식의 `search()`를 사용하여 입력허용 여부가 결정됩니다. > > \"입력값\".search(EditMask)>=0 > `true` 인 경우 입력 허용 > `false` 인 경우 입력 제한 > > 띄어쓰기를 제외한 모든 글자만 입력허용 : \"^\\\\\\\\S\\*\\$\" > 숫자만 입력 가능 : \"^\\\\\\\\d\\*\\$\" > 알파벳 만 가능 : \"^\\\\\\\\w\\*\\$\" > 열개 숫자만 가능 : \"^\\\\\\\\d{0,10}$\" > > 정규식에 맞지 않은 글자는 입력되지 않습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자바스크립트 정규식 문자| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"EditMask\", \"^\\\\S*$\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSEditMask\"] = \"^\\\\w*$\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSEditMask\":\"^\\\\d{0,10}$\" , ...} ] } ```",
              "see": [
                {
                  "label": "EditMask col",
                  "url": "/docs/props/col/edit-mask"
                },
                {
                  "label": "ResultMask cell",
                  "url": "./result-mask"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/edit-mask.html"
          },
          {
            "cid": 462,
            "sid": "empty-value-2",
            "name": "empty-value",
            "label": "EmptyValue",
            "data": {
              "body": "> 셀에 값이 없을때 보여질 글자를 설정합니다. > `Html` input 객체의 `placeholder`속성과 비슷한 기능으로, 값을 읽거나(getValue) 저장하거나 엑셀로 다운로드할 때는 값이 없는 상태로 처리됩니다. > 해당 속성에 영향을 받는 데이터는 아래와 같습니다. ```javascript {Type: \"Text\", Name: \"sText\", EmptyValue : \"값이 없습니다.\"} data: [ {\"e\": null}, //null 데이터 {\"e\": undefined}, //undefined 데이터 {\"e\": \"\"}, //빈문자 데이터 {} //데이터 없음 ] ``` ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|신규 행이나 조회시 값이 없을때 보여질 내용| ### Example ```javascript //필수 입력에 대한 안내를 설정 { data:[ {... , \"CLSEmptyValue\":\"필수 입력 사항입니다.\" , ...} ] } ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/empty-value.html"
          },
          {
            "cid": 463,
            "sid": "enum-disabled-2",
            "name": "enum-disabled",
            "label": "EnumDisabled",
            "data": {
              "body": "> [Enum](./enum) 속성을 통해 설정한 아이템들의 선택 불가능 여부를 설정합니다. > 첫번째 글자를 구분자로 설정하게 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#1#0\")| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"EnumDisabled\", \"|1|0|0|0|0|1|0|1|1|0|0\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSEnumDisabled\"] = \"|1|0|0|0\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {..., \"CLSEnumDisabled\":\"|1|0\", ...} ] } ```",
              "see": [
                {
                  "label": "Enum cell",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys cell",
                  "url": "./enum-keys"
                },
                {
                  "label": "EnumMenu cell",
                  "url": "./enum-menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.16|기능 추가|"
            },
            "url": "docs/props/cell/enum-disabled.html"
          },
          {
            "cid": 464,
            "sid": "enum-filter-2",
            "name": "enum-filter",
            "label": "EnumFilter",
            "data": {
              "body": "> [Enum](/docs/appx/type.md) 타입 셀을 편집 시, 드롭다운 리스트를 필터링 할 수 있는 입력란을 표시합니다. > 해당 칸에 입력된 문자열을 포함하는 [Enum](/enum.md)들만 드롭다운 리스트로 표시됩니다. > 이 기능은 [CaseSensitive](./case-sensitive) 설정에 따라 대소문자를 구분합니다. > [EnumMenu](./enum-menu) 속성과 함께 사용할 수 없습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`boolean`| 드롭다운 리스트의 필터 항목 표시 여부 | ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"EnumFilter\", true); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSEnumFilter\"] = true; //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data: [ { \"CLS\": \"A0\" \"CLSEnumFilter\": true } ] } ```",
              "see": [
                {
                  "label": "Enum cell",
                  "url": "./enum"
                },
                {
                  "label": "EnumKeys cell",
                  "url": "./enum-keys"
                },
                {
                  "label": "EnumMenu cell",
                  "url": "./enum-menu"
                },
                {
                  "label": "CaseSensitive cell",
                  "url": "./case-sensitive"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.48|기능 추가|"
            },
            "url": "docs/props/cell/enum-filter.html"
          },
          {
            "cid": 465,
            "sid": "enum-keys-2",
            "name": "enum-keys",
            "label": "EnumKeys",
            "data": {
              "body": "> [Enum](./enum) 속성을 통해 설정한 아이템들의 값을 설정합니다. > 첫번째 글자를 구분자로 설정하게 됩니다. > 이 속성을 설정하면, 실제 조회나 저장시 `EnumKey`로 설정한 값이 서버로 전송됩니다. > **<mark>주의</mark> : EnumKeys는 [Enum](./enum) 당 유일한 하나의 Key로 동일한 값을 중복해서 사용하면 안됩니다.** > **<mark>주의</mark> : [Type](/docs/appx/type)이 `Radio`인 컬럼에서는 [Enum](./enum)과 `EnumKeys`의 길이를 동일하게 사용해야 체크 동작이 정상적으로 이뤄집니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#01#02#03#04\")| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute( sheet.getRowById(\"AR99\") , \"CLS\" , \"EnumKeys\" ,\"|01|02|03|04\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSEnumKeys\"] = \"@A1@B0@B1@C1\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSEnumKeys\":\"#AA#ED#K9\" , ...} ] } ```",
              "see": [
                {
                  "label": "Enum cell",
                  "url": "./enum"
                },
                {
                  "label": "Related cell",
                  "url": "./related"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/enum-keys.html"
          },
          {
            "cid": 466,
            "sid": "enum-menu-2",
            "name": "enum-menu",
            "label": "EnumMenu",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Enum`인 셀에서 드랍리스트 대신 메뉴가 보여지게 끔 설정하고자 할때 사용합니다. > `Menu`에 대한 자세한 내용은 appendix의 [Menu](/docs/appx/menu)속성을 참고해 주세요. ### ![EnumMenu](/assets/imgs/enumMenu.png \"EnumMenu\") ### Type `object` ### Options |Value|Description| |-----|-----| |`object`|메뉴를 구성하는 json 객체| ### Example ```javascript //Enum 열에 item을 설정한다. { \"data\":[ ... {... CLSEnum: \"|안산1|안산2|화성1|화성2|화성3|일산1|일산2\", CLSEnumMenu : { Items: [ { Menu: 1, Name: \"안산현장\", Items: [ {Name: \"[안산1] 경기도 안산시 단원구 광덕3로 201\",Value: \"안산1\"}, {Name: \"[안산2] 경기도 안산시 단원구 신길동 1509\",Value: \"안산2\"} ] }, { Menu: 1, Name: \"화성현장\", Items: [ {Name: \"[화성1] 경기도 화성시 반송동\", Value: \"화성1\"}, {Name: \"[화성2] 경기도 화성시 동탄대로22길 30\", Value: \"화성2\"}, {Name: \"[화성3] 경기도 화성시 산척동 283\", Value: \"화성3\"}, ] }, { Menu: 1, Name: \"일산현장\", Items: [ {Name: \"[일산1] 경기도 고양시 일산동구 정발산로82번길 10\", Value: \"일산1\"}, {Name: \"[일산2] 경기도 고양시 일산동구 장항동 1761\", Value: \"일산2\"}, ] } ] } }, ... ] } ```",
              "see": [
                {
                  "label": "Enum col",
                  "url": "/docs/props/cell/enum"
                },
                {
                  "label": "EnumKeys col",
                  "url": "/docs/props/cell/enum-keys"
                },
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/enum-menu.html"
          },
          {
            "cid": 467,
            "sid": "enum-2",
            "name": "enum",
            "label": "Enum",
            "data": {
              "body": "> 셀의 [Type](/docs/appx/type)이 `Enum`이나 `Radio`일 때 보여질 item을 설정합니다. > 첫번째 글자를 구분자로 설정하게 됩니다. > [EnumKeys](./enum-keys) 속성을 통해 `item`의 실제값을 설정할 수 있습니다. ### ![Enum타입](/assets/imgs/enum1.png \"Enum\") [그림1] ![Radio타입](/assets/imgs/radioEnum.png \"Radio\") [그림2] ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫번째 글자를 구분자로 하는 문자열 (ex:\"#사장#부사장#전무#상무#이사#부서장#차장#과장#대리#주임#사원\")| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Enum\", \"|사장|부장|차장|과장|대리|사원\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSEnum\"] = \"|성인|청소년|아동|유가\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {..., \"CLSEnum\":\"|남성|여성\", ...} ] } ```",
              "see": [
                {
                  "label": "EnumKeys cell",
                  "url": "./enum-keys"
                },
                {
                  "label": "Related cell",
                  "url": "./related"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/enum.html"
          },
          {
            "cid": 468,
            "sid": "error",
            "name": "error",
            "label": "Error",
            "data": {
              "body": "> 셀에 수정값이 [ResultMask](./result-mask)에 선언한 유효성 검사에 위배되는 경우 속성값이 `1(true)`로 세팅됩니다. > 이 속성은 직접 값을 변경하기 보다는, 수정 여부를 확인하는 용도로 사용할 것을 권합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`1(true)`|`Validation` 위배됨| ### Example ```javascript //셀값의 오류여부를 확인. (열이름이 CLS 라고 가정) var error = sheet.getAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Error\"); if (error) { //잘못 입력된 내용이 있습니다. } ```",
              "see": [
                {
                  "label": "ResultMask cell",
                  "url": "./result-mask"
                },
                {
                  "label": "ResultText cell",
                  "url": "./result-text"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/error.html"
          },
          {
            "cid": 469,
            "sid": "export-value",
            "name": "export-value",
            "label": "ExportValue",
            "data": {
              "body": "> 엑셀 다운로드 시 보여질 글자를 설정합니다. > `Link`, `Img` 타입에서는 데이터 포맷을 맞춰줘야 정상적으로 셀 값이 보여집니다. > 예시) Link 타입: \"||ExportValue 설정 값|\" > 예시) Img 타입: \"|../image.jpg|50|50|0|0|||\" > 그외에 타입에서는 설정한 string값 대로 다운로드 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|엑셀 다운로드 시 보여질 문자| ### Example ```javascript // 1. 메소드를 통해 특정 셀에 속성 적용 (열이름 : CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ExportValue\", \"먼저 '실적대차' 열의 내용을 확인해 주세요.\"); // 2. 객체에 직접 접근해서 속성 적용 (열이름 : CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSExportValue\"] = \"마감되었습니다.\"; // 변경내용 확인 sheet.refreshCell({ row:ROW, col:\"CLS\" }); // 3. 조회 데이터 내에서 속성 적용 (열이름 : CLS ) { data:[ {... , \"CLSExportValue\": \"공사 시작일을 먼저 입력해 주세요.\" , ...} ] } ```",
              "see": [
                {
                  "label": "exportData method",
                  "url": "/docs/funcs/core/export-data"
                },
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.19|기능 추가||excel|1.0.6|기능 추가|"
            },
            "url": "docs/props/cell/export-value.html"
          },
          {
            "cid": 470,
            "sid": "filter-enum-keys",
            "name": "filter-enum-keys",
            "label": "FilterEnumKeys",
            "data": {
              "body": "> Enum 타입의 컬럼에서 필터링시 Enum(문자열)이 아닌 EnumKeys(코드값)를 기준으로 필터링 하게 합니다. > 이 속성은 시트 생성 시점에서 Def.Filter를 통해 설정하실 수 있습니다. > 동일한 Enum 값이 있는 경우, 이 속성을 1로 설정해야 EnumKeys를 기준으로 구분지어 필터링 할 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|Enum(문자열) 기준으로 필터 (`default`)| |`1(true)`|EnumKeys(코드값) 기준으로 필터| ### Example ```javascript //Enum 타입 컬럼명을 \"Nation\" 이라고 가정합니다 var option = { Def: { Filter: { Nation: { FilterEnumKeys: 1 //Enum컬럼을 Key값을 기준으로 필터링 } } } } ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/filter-enum-keys.html"
          },
          {
            "cid": 471,
            "sid": "filter-value",
            "name": "filter-value",
            "label": "FilterValue",
            "data": {
              "body": "> 셀의 원래 값 대신 필터링시 사용할 값을 설정합니다. > 특히 타입이 `Html`이나 `버튼` 같이 편집이 불가능한 셀에 유용하게 사용하실 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|필터링이 이루어질때 사용될 기준 문자| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름 :CLS ) //원래 셀의 값 대신 \"00가0000\"로 필터링 되게 끔 설정 { data:[ {... , \"CARNOFilterValue\":\"00가0000\" , ...} ] } ``` ![FilterValue](/assets/imgs/filterValue.png \"실제 값 대신 00가0000로 필터링\")",
              "see": [
                {
                  "label": "SortValue cell",
                  "url": "./sort-value"
                },
                {
                  "label": "CopyValue cell",
                  "url": "./copy-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/filter-value.html"
          },
          {
            "cid": 472,
            "sid": "focus-cell-2",
            "name": "focus-cell",
            "label": "FocusCell",
            "data": {
              "body": "> 특정 셀에 포커스가 들어갔을때 포커스 셀의 디자인을 정의 합니다. > 예약된 문자를 구분자 \",\"연결하여 설정합니다. > 기본적으로는 \"Border, Color\"로 구성됩니다. ### ```css .IBColorFocusedCell{background-color:#FFFFDD;} .IBClassFocusedCell{background-color:#DDDDDD;} ``` 위와 같이 클레스가 정의 되었을 경우 보여지는 모습은 다음과 같습니다. |설정값|보여지는 모습| |---|---| |Default 설정 (Border,Color)|![FocusCell](/assets/imgs/FocusCell1.png \"포커스된 셀의 모양\")| |Class 만 설정|![FocusCell](/assets/imgs/FocusCell2.png \"포커스된 셀의 모양\")| |Border,Class 로 설정|![FocusCell](/assets/imgs/FocusCell3.png \"포커스된 셀의 모양\")| ### Type `string` ### Options |Value|Description| |-----|-----| |`Border`|포커스된 셀의 테두리를 적용| |`Color`|포커스된 셀의 td 태그에 배경색으로 css/default(테마)/main.css 파일에 IBColorFocusedCell 클레스에서 정의한 색상이 적용(성능 저하가 있을 수 있음)| |`Class`|css/default(테마)/main.css 파일에 IBClassFocusedCell 클레스에 정의한 디자인을 따릅니다.| ### Example ```javascript //포커스가 들어갔을때 셀의 배경색만 보여줌. sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"FocusCell\", \"Class\"); ```",
              "see": [
                {
                  "label": "FocusCell col",
                  "url": "/docs/props/col/focus-cell"
                },
                {
                  "label": "FocusRow cell",
                  "url": "./focus-row"
                },
                {
                  "label": "FocusRow row",
                  "url": "/docs/props/row/focus-row"
                },
                {
                  "label": "FocusRow col",
                  "url": "/docs/props/col/focus-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/focus-cell.html"
          },
          {
            "cid": 473,
            "sid": "focus-row-3",
            "name": "focus-row",
            "label": "FocusRow",
            "data": {
              "body": "> 셀을 클릭시 보여지는 \"커서 포커스 행\"은 Table 객체 위에 DIV 객체가 떠있는 형태로 구성됩니다. > 특정 셀에 포커스가 있을때 보여질 \"커서 포커스 행\"의 디자인을 설정합니다. > 예약된 문자를 구분자 \",\"연결하여 설정합니다. > 기본적으로는 \"Border, Background\"로 구성됩니다. ### ![FocusRow](/assets/imgs/focusRow1.png \"FocusRow default\") [일반 FocusRow] ![FocusRow](/assets/imgs/focusRow2.png \"FocusRow default\") [border없이 Background로 설정시] ### Type `string` ### Options |Value|Description| |-----|-----| |`Border`|커서 포커스 DIV의 테두리 사용 (.IBFocusRowBorder)| |`Background`|커서 포커스 DIV의 배경색 사용 (.IBFocusRowBackground) | |`Color`|커서 포커스 DIV를 사용하지 않고 Table 객체에 background-color를 부여 (성능이 저하될수 있음,포커스 셀은 제외) (.IBColorFocused) | |`Class`|css/default(테마)/main.css 파일에 .IBClassFocused 클레스에 정의한 디자인을 따릅니다. (포커스 셀은 제외)| ### Example ```javascript //셀에 포커스가 들어갔을때 포커스행에 대해 배경색만 사용함 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"FocusRow\", \"Background\"); ```",
              "see": [
                {
                  "label": "FocusRow row",
                  "url": "/docs/props/row/focus-row"
                },
                {
                  "label": "FocusRow col",
                  "url": "/docs/props/col/focus-row"
                },
                {
                  "label": "FocusCell col",
                  "url": "/docs/props/col/focus-cell"
                },
                {
                  "label": "FocusCell cell",
                  "url": "./focus-cell"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/focus-row.html"
          },
          {
            "cid": 474,
            "sid": "format-2",
            "name": "format",
            "label": "Format",
            "data": {
              "body": "> 원본 데이터에 대한 마스킹된 데이터를 정의합니다. > 원본 데이터와 무관하게 사용자에게 마스크를 적용한 데이터를 보여줍니다. > [Format](/docs/appx/format)은 열의 Type에 따라 다양하게 정의될 수 있습니다. 자세한 내용은 7장 appendix의 [Format](/docs/appx/format)을 참고해 주세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열의 Type에 따른 다양한 포맷설정 문자열| ### Example ```javascript //날짜 포맷을 정의합니다. { data:[ {... , \"CLSFormat\":\"dd.MM.yyyy\" , ...} ] } ```",
              "see": [
                {
                  "label": "Format appendix",
                  "url": "/docs/appx/format"
                },
                {
                  "label": "EditFormat cell",
                  "url": "./edit-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/format.html"
          },
          {
            "cid": 475,
            "sid": "gmt-2",
            "name": "gmt",
            "label": "GMT",
            "data": {
              "body": "> 셀의 [Type](/docs/appx/type)이 `Date` 일 때 기준 시간대를 설정합니다. > 조회된 시간을 기준으로 UTC시간으로 변경하여 보여줍니다. > 이는 시트에 보여지는 값일뿐 실제 값과는 무관합니다. 가령 조회데이터가 \"2017-05-25 14:30\" 인 경우, 이 속성의 값을 `1(true)`로 설정하면 실제 시트상에는 \"2017-05-25 05:30\"으로 표시됩니다.(한국은 GMT +9 이기 때문) > 하지만 값을 \"2017-05-25 06:30\"으로 수정하여 저장하면, 실제로 전송되는 데이터는 \"2017-05-25 15:30\"이 전송됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|사용자 PC의 시간대 (`default`)| |`1(true)`|GMT/UTC 시간대| ### Example ```javascript //UTC로 보기 { \"data\":[ ... {CLS: \"20190103134521\", CLSFormat: 'MM-dd-yyyy HH:mm', CLSDataFormat: \"yyyyMMddHHmmss\", GMT: 1 ...}, ... ]; ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/gmt.html"
          },
          {
            "cid": 476,
            "sid": "hint-value-3",
            "name": "hint-value",
            "label": "HintValue",
            "data": {
              "body": "> 힌트는 열의 너비가 좁아 셀의 내용의 일부가 안보일 때, 마우스 커서가 올라간 셀에 한해 일시적으로 셀의 너비를 늘려 안보이던 뒷 내용을 보여주는 기능입니다. > 힌트기능 사용시 원래 셀의 내용 대신에 설정한 내용이 보여지게끔 설정합니다. ### ![힌트활성화](/assets/imgs/hint1.png \"마우스 커서가 셀에 올라갔을때 힌트를 통해 감춰진 부분이 보여짐\") [힌트기능 사용 예] ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|힌트기능 활성화시(마우스커서가 셀 위에 Over시) 보여질 문자| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"HintValue\", \"먼저 '실적대차' 열의 내용을 확인해 주세요.\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSHintValue\"] = \"마감되었습니다.\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSHintValue\":\"공사 시작일을 먼저 입력해 주세요.\" , ...} ] } ```",
              "see": [
                {
                  "label": "ShowHint cell",
                  "url": "./show-hint"
                },
                {
                  "label": "ShowHint col",
                  "url": "/docs/props/col/show-hint"
                },
                {
                  "label": "ShowHint row",
                  "url": "/docs/props/row/show-hint"
                },
                {
                  "label": "onShowHint event",
                  "url": "/docs/events/on-show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/hint-value.html"
          },
          {
            "cid": 477,
            "sid": "html-postfix-3",
            "name": "html-postfix",
            "label": "HtmlPostfix",
            "data": {
              "body": "> 셀의 문자열 뒤에 원하는 HTML 태그를 삽입합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 HTML태그| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"HtmlPostfix\", \"<i class='fas fa-apple-alt'></i>\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSHtmlPostfix\"] = \"<span>약어</span>\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSHtmlPostfix\":\"<div class='btn'>time</div>\" , ...} ] } ```",
              "see": [
                {
                  "label": "HtmlPrefix cell",
                  "url": "./html-prefix"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/html-postfix.html"
          },
          {
            "cid": 478,
            "sid": "html-prefix-3",
            "name": "html-prefix",
            "label": "HtmlPrefix",
            "data": {
              "body": "> 셀의 문자열 앞에 원하는 HTML 태그를 삽입합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|원하는 HTML태그| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"HtmlPrefix\", \"<i class='fas fa-apple-alt'></i>\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSHtmlPrefix\"] = \"<span>약어</span>\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSHtmlPrefix\":\"<div class='btn'>time</div>\" , ...} ] } ```",
              "see": [
                {
                  "label": "HtmlPostfix cell",
                  "url": "./html-postfix"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/html-prefix.html"
          },
          {
            "cid": 479,
            "sid": "icon-align-2",
            "name": "icon-align",
            "label": "IconAlign",
            "data": {
              "body": "> 셀 좌측에 버튼(혹은 체크박스)을 표시하는 [Icon](./icon)속성 사용시, 버튼의 위치를 설정합니다. > 다른 설정이 없을시 셀의 좌측에 표시됩니다.. ### Type `string` ### Options |Value|Description| |-----|-----| |`Left`|셀 좌측에 Icon표시 (`default`)| |`Right`|셀 우측에 Icon표시| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름: CLS ) { data:[ {... , \"ClsIconAlign\":\"Right\",\"CLSIcon\":\"/images/popIcon.gif\", ...} ] } ```",
              "see": [
                {
                  "label": "Icon cell",
                  "url": "./icon"
                },
                {
                  "label": "IconWidth col",
                  "url": "../col/icon-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/icon-align.html"
          },
          {
            "cid": 480,
            "sid": "icon-width-2",
            "name": "icon-width",
            "label": "IconWidth",
            "data": {
              "body": "> 셀 좌측에 버튼을 표시하는 [Icon](./icon)속성 사용시, 버튼의 너비를 설정합니다. > 너비는 pixel단위로 설정됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|셀 좌측 버튼의 너비| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름: CLS ) { data:[ {... , \"CLSIcon\":\"/images/popIcon.gif\", \"CLSIconWidth\":22 , ...} ] } ```",
              "see": [
                {
                  "label": "Icon cell",
                  "url": "./icon"
                },
                {
                  "label": "IconWidth col",
                  "url": "../col/icon-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/icon-width.html"
          },
          {
            "cid": 481,
            "sid": "icon-2",
            "name": "icon",
            "label": "Icon",
            "data": {
              "body": "> 셀의 좌측에 원하는 아이콘 이미지,체크박스 혹은 버튼을 표시하는 기능입니다. > 셀의 우측에 버튼을 표시하는 [Button](./button) 속성과 유사한 기능입니다. > 열의 타입이 `Button`인 경우에는 사용하실 수 없습니다. ### ![Icon속성](/assets/imgs/Icon1.png \"Icon속성\") [그림1] ![Icon속성](/assets/imgs/Icon2.png \"Icon속성\") [그림2] ### Type `string` ### Options |Value|Description| |-----|-----| |`Clear`|셀 좌측에 셀 내용을 지우기 위한 버튼이 표시됩니다.| |`Date`|셀 좌측에 달력 아이콘을 보여줍니다. 열의 타입이 \"Date\"인 경우에만 클릭시 달력이 표시됩니다.[그림2] 참고| |`Check`|셀 좌측에 체크박스를 표시합니다.| |`공백`|원래 보여져야 하는 Icon 이미지를 감춥니다.| |`기타`|이미지 파일에 대한 url을 넣으면 아이콘의 배경으로 이미지가 표시됩니다. [그림1] 참고 (이미지는 gif,png,jpg만 가능)| *[IconWidth](../col/icon-width) 속성을 통해 아이콘 영역의 넓이를 설정할 수 있습니다. 아이콘을 클릭시 [onIconClick](/docs/events/on-icon-click)이벤트가 호출됩니다. `\"Clear\"`나 `\"Check\"`로 설정하면 [OnClickSide](/docs/props/event/on-click-side) 이벤트만 호출합니다.* ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Icon\", \"Clear\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSIcon\"] = \"Check\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 : CLS) { \"data\":[ {... , \"CLSIcon\":\"/images/popIcon.gif\", ...} ] } //4. 조회 데이터 내에서 속성 적용 (열이름 : CLS) { \"data\":[ {... , \"ClsIcon\":\"Check\", \"CLSChecked\":1, ...} ] } ```",
              "see": [
                {
                  "label": "IconWidth cell",
                  "url": "./icon-width"
                },
                {
                  "label": "Button cell",
                  "url": "./button"
                },
                {
                  "label": "Checked cell",
                  "url": "/docs/props/cell/checked"
                },
                {
                  "label": "Icon col",
                  "url": "../col/icon"
                },
                {
                  "label": "IconWidth col",
                  "url": "../col/icon-width"
                },
                {
                  "label": "setIconCheck method",
                  "url": "/docs/funcs/core/set-icon-check"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/icon.html"
          },
          {
            "cid": 482,
            "sid": "indent-3",
            "name": "indent",
            "label": "Indent",
            "data": {
              "body": "> 문자열 정렬([Align](./align))에 따라 셀 좌측 또는 우측에 들여쓰기를 설정합니다. > 숫자로 입력시 입력값*10px로 padding이 생성됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|패딩 정도 (입력값 * 10px)| ### Example ```javascript //특정 셀에 20px 정도 패딩을 생성 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Indent\", 2); ```",
              "see": [
                {
                  "label": "Align cell",
                  "url": "./align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/indent.html"
          },
          {
            "cid": 483,
            "sid": "link-base-2",
            "name": "link-base",
            "label": "LinkBase",
            "data": {
              "body": "> 셀에 [Link](./link)속성이 있는 경우, Base 경로를 설정합니다. > 현재 페이지가 **/abc/test.html**이라고 가정했을때, `LinkBase` 설정에 따른 연결 URL은 다음과 같습니다. > |Link|LinkBase|실제연결URL| > |---|---|---| > |/xyz/test2.html||/xyz/test2.html| > |./xyz/test2.html||/abc/xyz/test2.html| > |/xyz/test2.html|/kor|/kor/xyz/test2.html| > |./xyz/test2.html|/kor|/kor/xyz/test2.html| ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`Link`에서 설정한 URL의 Base 경로| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"LinkBase\", \"/koem\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSLinkBase\"] = \"/dps\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSLinkBase\":\"/cust\" , ...} ] } ```",
              "see": [
                {
                  "label": "Link cell",
                  "url": "./link"
                },
                {
                  "label": "LinkTarget cell",
                  "url": "./link-target"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/link-base.html"
          },
          {
            "cid": 484,
            "sid": "link-target-2",
            "name": "link-target",
            "label": "LinkTarget",
            "data": {
              "body": "> 셀에 [Link](./link)속성이 있는 경우, 클릭시 이동할 `target Window`를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|클릭시 이동 할 Target Window(_blank ,_parent ,_self ,_top, 특정 window명)| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름 :CLS ) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"LinkTarget\", \"_self\"); //2. 객체에 직접 접근해서 속성 적용 (열이름 :CLS ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSLinkTarget\"] = \"_blank\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름 :CLS ) { data:[ {... , \"CLSLinkTarget\":\"_parent\" , ...} ] } ```",
              "see": [
                {
                  "label": "Link cell",
                  "url": "./link"
                },
                {
                  "label": "LinkBase cell",
                  "url": "./link-base"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/link-target.html"
          },
          {
            "cid": 485,
            "sid": "link-2",
            "name": "link",
            "label": "Link",
            "data": {
              "body": "> 셀에 데이터를 \\<a> 태그로 감싸고 href 속성에 들어갈 URL을 설정합니다. > [LinkBase](./link-base)와 [LinkTarget](./link-target) 속성을 같이 사용하여 상대경로나 클릭시에 target window를 설정할 수 있습니다. > **이 옵션은 반드시 CanEdit가 0으로 설정되어야 동작합니다.** ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|클릭시 이동할 URL| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Link\", \"./cbt/exam02.do\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSLink\"] = \"/cbs/recalcSum.do\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSLink\":\"/abs/endPointJ.do\" , ...} ] } ```",
              "see": [
                {
                  "label": "LinkBase cell",
                  "url": "./link-base"
                },
                {
                  "label": "LinkTarget cell",
                  "url": "./link-target"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/link.html"
          },
          {
            "cid": 486,
            "sid": "menu-items",
            "name": "menu-items",
            "label": "MenuItems",
            "data": {
              "body": "> Filter 셀의 보여질 필터 아이콘 메뉴를 셀 별로 설정 할 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`items`|보여질 아이콘 번호를 \",\" 로 연결한 문자열| **operators 상세설명** |value|type|desc| |---|---|---| |`0`|공통|필터를 사용하지 않음| |`1`|공통|같다| |`2`|공통|같지않다| |`3`|숫자, 날짜|작다| |`4`|숫자, 날짜|작거나 같다| |`5`|숫자, 날짜|크다| |`6`|숫자, 날짜|크거나 같다| |`7`|문자|앞글자 일치| |`8`|문자|앞글자가 일치하지 않음| |`9`|문자|뒷글자 일치| |`10`|문자|뒷글자 일지하지 않음| |`11`|문자|해당 글자 포함| |`12`|문자|해당 글자 포함하지 않음| |`13`|숫자|상위 10| |`14`|공통|값 있음| |`15`|공통|값 없음| ### Example ```javascript // \"RENTDATE\" 컬럼에 보여질 아이콘 설정 options.Filter = [ RENTDATE: { MenuItems: \"0,1,2,3,4,5,6,7,8,9,10,11,12\" }, ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.27|13 기능 추가||core|8.1.0.27|14,15 기능 추가|"
            },
            "url": "docs/props/cell/menu-items.html"
          },
          {
            "cid": 487,
            "sid": "menu-4",
            "name": "menu",
            "label": "Menu",
            "data": {
              "body": "> 특정 셀 위에서 마우스 우측 버튼 클릭시 보여질 컨텍스트 메뉴를 설정합니다. > 7장의 [Menu appendix](/docs/appx/menu)내용을 참고해 주세요. ### Type mixed( `object` \\| `string` ) ### Options |Value|Description| |-----|-----| |`string`|첫글자를 구분자로 한 컨텍스트 메뉴스트링 지정 (ex: @저장@임시저장@취소 or *상신*취소) | |`object`|[Menu Object 설정 링크 참고](/docs/appx/menu) ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Menu\", \"|진행|취소\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSMenu\"] = \"|보류|결제|전결\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSMenu\":\"|국내|해외\" , ...} ] } ```",
              "see": [
                {
                  "label": "Menu appendix",
                  "url": "/docs/appx/menu"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/menu.html"
          },
          {
            "cid": 488,
            "sid": "merge",
            "name": "merge",
            "label": "Merge",
            "data": {
              "body": "> 같은 행 안에 다른 셀들의 값을 한 셀에서 표현하는 기능입니다. > 눈에 보이기만 할뿐 실제 셀의 값은 별도로 관리됩니다. > `row`에 [Spanned](/docs/props/row/spanned) 속성이 `1`로 설정되어야 동작합니다. ### ![Merge속성](/assets/imgs/Merge.png \"Merge속성\") [empinfoMerge:\"empno,empNm,pstnGbn\" 으로 설정] ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|열이름 (\",\"구분자로 여러개 지정 가능)| ### Example ```javascript //Spanned가 설정되어 있어야 함. options.Def.Row = {Spanned: 1}; //empinfo 열에서 empno,empNo,pstnGbn 열의 값을 모두 표시 opyiond.Def.Row[\"empinfo\"] = {\"Merge\": \"empno,empNm,pstnGbn\"} ```",
              "see": [
                {
                  "label": "Span cell",
                  "url": "./span"
                },
                {
                  "label": "Spanned row",
                  "url": "/docs/props/row/spanned"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/merge.html"
          },
          {
            "cid": 489,
            "sid": "no-changed-2",
            "name": "no-changed",
            "label": "NoChanged",
            "data": {
              "body": "> 셀의 값이 변경되었을때 수정 상태를 변경 하지 않도록 설정합니다. > 값이 `1(true)`로 설정되어 있다면 셀의 값이 변경되어도 수정 상태를 변경하지 않습니다. > 수정 상태를 변경(`Changed`)하지 않지만 수정 관련된 이벤트는 발생합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|셀 값을 수정하면 수정 상태를 변경 (`default`)| |`1(true)`|셀 값을 수정해도 수정 상태를 변경하지 않음| ### Example ```javascript // 특정 셀의 값이 변경되어도 수정 상태를 변경하지 않도록 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"NoChanged\", true); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/no-changed.html"
          },
          {
            "cid": 490,
            "sid": "no-color-3",
            "name": "no-color",
            "label": "NoColor",
            "data": {
              "body": "> 셀에 적용된 배경색이 무시됩니다. > 홀수/짝수행에 대한 배경색([AlternateColor](/docs/props/row/alternate-color)), 상태(입력/수정/삭제)및 선택, 편집불가 컬럼에 대한 색상이 무시됩니다. [Color](./color) 속성으로 통한 배경색도 적용되지 않게 할 수 있습니다.<br /> > `NoColor`가 적용되는 우선 순위는 셀 \\> 열 \\> 행입니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|기능 사용 안함 (`default`)| |`1`|모든 배경색 무시(단 Class속성을 통해 설정한 배경색을 적용)| |`2`|상태 및 선택에 대한 색상만 무시| |`3`|`Color` 설정 시 상태, `AlternateColor`, 편집불가에 대한 색상을 무시하고 무조건 `Color` 색상 적용 ### Example ```javascript //특정 셀에 모든 배경색을 무시하게 설정 var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSNoColor\"] = 1; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); ```",
              "see": [
                {
                  "label": "Alternate cfg",
                  "url": "/docs/props/cfg/alternate"
                },
                {
                  "label": "Color cell",
                  "url": "./color"
                },
                {
                  "label": "AlternateColor row",
                  "url": "/docs/props/row/alternate-color"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.2.0.14|`NoColor: 3` 동작 추가|"
            },
            "url": "docs/props/cell/no-color.html"
          },
          {
            "cid": 491,
            "sid": "number-sort-2",
            "name": "number-sort",
            "label": "NumberSort",
            "data": {
              "body": "> 셀의 데이터를 숫자형식으로 소팅할지 여부를 설정합니다. > 일반적으로 `Int, Float, Date Type`은 숫자형식으로, 그 외의 [Type](/docs/appx/type)은 문자형식으로 소팅이 이루어집니다. > 여기서 값을 `0(false)`으로 설정하면, Type과 무관하게 문자형식으로 소팅되고, `1(true)`로 설정시 숫자형식으로 소팅이 이루어집니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|문자형식의 소팅| |`1(true)`|숫자형식의 소팅| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름: CLS) //특정 셀에 대해 숫자형식으로 소팅 { data:[ {... , \"CLSNumberSort\":\"1\" , ...} ] } ```",
              "see": [
                {
                  "label": "RawSort cell",
                  "url": "./raw-sort"
                },
                {
                  "label": "SortValue cell",
                  "url": "./sort-value"
                },
                {
                  "label": "CaseSensitive cell",
                  "url": "./case-sensitive"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/number-sort.html"
          },
          {
            "cid": 492,
            "sid": "number-strict-mode-2",
            "name": "number-strict-mode",
            "label": "NumberStrictMode",
            "data": {
              "body": "> 0(false)으로 설정 시 조회 시 숫자 타입(Int, Float)에 빈 값이나 숫자 형태가 아닌 경우 0으로 처리합니다. > 천단위 구분자 \",\"가 포함된 문자열 형태의 숫자를 입력하는 경우 숫자로 표시됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|숫자가 아닌 데이터에 대해 엄격하게 검사하지 않음. 숫자가 아닌 경우 NaN 대신 0으로 표시| |`1(true)`|숫자 타입 셀에서 데이터의 타입에 대해 엄격하게 검사. 숫자형태가 아닌 경우 NaN으로 표시 (`default`)| ### Example ```javascript // 1. 메소드를 통해 특정 셀에 속성 적용 ( 열이름 : IntData ) sheet.setAttribute( sheet.getRowById(\"AR99\") , \"IntData\" , \"NumberStrictMode\" , false); // 2. 객체에 직접 접근해서 속성 적용 ( 열이름 : IntData ) var ROW = sheet.getRowById(\"AR10\"); ROW[\"IntDataNumberStrictMode\"] = false; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"IntData\"}); // 3. 조회 데이터 내에서 속성 적용 ( 열이름 : IntData ) { data:[ {... , \"IntDataNumberStrictMode\":false , ...} ] } ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.17|기능 추가|"
            },
            "url": "docs/props/cell/number-strict-mode.html"
          },
          {
            "cid": 493,
            "sid": "orig",
            "name": "orig",
            "label": "Orig",
            "data": {
              "body": "> 셀에 최초 로딩된 데이터를 담고 있습니다. > 해당 셀에 대한 최초 조회시 데이터를 알고자 할 때 확인 용도로 사용해 주세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`Orig`|처음 로딩된 데이터| ### Example ```javascript //수정하기 전, 최초 데이터를 확인한다. var orgValue = sheet.getAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Orig\"); ```",
              "see": [
                {
                  "label": "revertCell method",
                  "url": "/docs/funcs/core/revert-cell"
                },
                {
                  "label": "revertRow method",
                  "url": "/docs/funcs/core/revert-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/orig.html"
          },
          {
            "cid": 494,
            "sid": "path",
            "name": "path",
            "label": "Path",
            "data": {
              "body": "> 열의 [Type](/docs/props/cell/type)이 `File`인 경우 파일을 다운받을 경로를 설정합니다. > `File` [Type](/docs/props/cell/type)을 사용하시는 경우 반드시 설정해야 정상적으로 다운로드 됩니다. > 해당 속성 혹은 [FilePath](/docs/props/cfg/export)가 설정된 경우에만 [File](/docs/appx/file-type-upload)타입인 셀에 데이터가 표시됩니다. > > 구분자를 포함하여 해당 셀의 파일들의 경로를 개별 설정할 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`| 파일을 다운받을 경로 | ### Example ```javascript //1. 메소드를 통해 속성 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Path\", \"https://api.ibleaders.com/ibsheet/v8/samples/customer/files/\"); //2. 객체에 직접 접근해서 속성 설정(열이름이 CLS 로 가정) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSPath\"] = \"https://api.ibleaders.com/ibsheet/v8/samples/customer/files/\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성설정(열이름이 CLS 로 가정) { data:[ {... , \"CLS\":\"testFile.xlsx\", \"CLSPath\":\"https://api.ibleaders.com/ibsheet/v8/samples/customer/files/\" , ...} ] } //4. 개별 경로를 설정을 하는 경우 { data: [ { \"CLS\": \"testFile.xlsx;testFile2.xlsx\", \"CLSPath\": \"https://api.ibleaders.com/ibsheet/v8/samples/customer/files/;https://api.ibleaders.com/ibsheet/v8/samples/customer/files2/\" } ] } ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "File Type 업로드 appendix",
                  "url": "/docs/appx/file-type-upload"
                },
                {
                  "label": "Alias cell",
                  "url": "/docs/props/cell/Alias"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가||core|8.3.0.21|개별 설정 동작 개선|"
            },
            "url": "docs/props/cell/path.html"
          },
          {
            "cid": 495,
            "sid": "radio-icon-width",
            "name": "radio-icon-width",
            "label": "RadioIconWidth",
            "data": {
              "body": "> [RadioIcon](/docs/props/cell/radio-icon)속성을 통해서 라디오 아이콘을 커스텀 이미지로 설정하는 경우 이미지의 너비를 pixel단위로 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|라디오 아이콘 이미지의 너비 (pixel단위)| ### Example ```javascript //라디오 아이콘 이미지의 너비를 22px로 정의 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"RadioIcon\", \"|Off.gif|On.gif\" ); sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"RadioIconWidth\", 22); ```",
              "see": [
                {
                  "label": "RadioIcon cell",
                  "url": "/docs/props/cell/radio-icon"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/radio-icon-width.html"
          },
          {
            "cid": 496,
            "sid": "radio-icon-2",
            "name": "radio-icon",
            "label": "RadioIcon",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Radio`인 셀에서 `Radio` 아이콘을 다른 이미지나 Html 객체로 설정합니다. > 임의의 이미지를 라디오 아이콘으로 사용하고자 하는 경우에는, 언체크 이미지와 체크 이미지를 첫글자를 구분자로 하여 연결된 문자열로 설정하시면 됩니다. (ex:\"|OFF.gif|ON.gif\") > > 임의의 이미지를 체크박스 아이콘으로 사용할 때, 해당 열내의 셀이 편집불가([CanEdit](./can-edit))인 경우가 있다면 편집 불가일때의 이미지까지해서 총 4개의 이미지를 설정하시면 됩니다. (ex:\"|Off.gif|On.gif|OffReadOnly.gif|OnReadOnly.gif\") > > 여러개의 라디오 아이콘을 사용하고자 하는 경우에는 언체크 이미지와 체크이미지를 이어서 설정하시면 됩니다. (ex:\"|Off1.gif|On1.gif|Off2.gif|On2.gif|Off3.gif|On3.gif\") > > 그 외에 일반적인 숫자형식으로 아래 Options에서와 같이 기능을 설정하실 수 있습니다. ### Type `mixed`(`string` \\| `number` ) ### Options **숫자형식을 사용하는 경우** |Value|Description| |-----|-----| |`0`|기본적인 내장 라디오아이콘 이미지를 사용/ [Range](/docs/props/col/range)속성을 사용하는 경우 내장 체크박스아이콘 이미지를 사용(`default`) |`1`|내장 라디오 아이콘 이미지를 사용| |`2`|내장 체크박스 아이콘 이미지를 사용| |`3`|\\<input type=\"radio\">객체를 사용 / [Range](/docs/props/col/range)속성을 사용하는 경우 \\<input type=\"checkbox\">객체를 사용| |`4`|\\<input type=\"radio\">객체를 사용| |`5`|\\<input type=\"checkbox\">객체를 사용| |`6`|아이콘을 표시하지 않음| ***input 객체를 사용하는 경우 그렇지 않은 경우보다 성능이 느릴 수 있습니다.*** ### Example ```javascript //라디오 아이콘 대신 체크박스 아이콘을 사용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"RadioIcon\", \"2\"); //객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSRadioIcon\"] = \"2\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSRadioIcon\":\"2\" , ...} ] } ```",
              "see": [
                {
                  "label": "RadioIconWidth cell",
                  "url": "./radio-icon-width"
                },
                {
                  "label": "RadioUncheck cell",
                  "url": "./radio-uncheck"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/radio-icon.html"
          },
          {
            "cid": 497,
            "sid": "radio-uncheck-2",
            "name": "radio-uncheck",
            "label": "RadioUncheck",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Radio`인 셀에서, 한 번 클릭하여 선택한 아이템을 다시 클릭하여 체크해제 하게끔 허용할지 여부를 설정합니다. ### Type `Boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|체크해제를 허용하지 않음 (`default`) |`1(true)`|체크해제를 허용| ### Example ```javascript //체크 해제를 허용 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"RadioUncheck\", 1); ```",
              "see": [
                {
                  "label": "RadioIcon cell",
                  "url": "./radio-icon"
                },
                {
                  "label": "RadioIconWidth cell",
                  "url": "./radio-icon-width"
                },
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/radio-uncheck.html"
          },
          {
            "cid": 498,
            "sid": "radio-2",
            "name": "radio",
            "label": "Radio",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Bool`인 셀들 간에 같은 값을 부여한 값을 갖고 있는 셀들을 하나의 그룹으로 묶여서 한 행에서 같은 그룹 내에 한 셀만 체크 가능하게 합니다. ### ![Radio](/assets/imgs/radio.png \"같은 행에서 하나만 선택 가능\") ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|라디오처럼 하나로 묶을 그룹 인덱스| ### Example ```javascript //조회 데이터 내에서 설정 적용 //CLS1,CLS2,CLS3 열에서 단일 셀만 선택 가능하게 끔 설정 { data:[ {..., \"CLS1Radio\":\"1\", \"CLS2Radio\":\"1\", \"CLS3Radio\":\"1\" ...}, ... ] } ```",
              "see": [
                {
                  "label": "BoolGroup cell",
                  "url": "./bool-group"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/radio.html"
          },
          {
            "cid": 499,
            "sid": "raw-sort-2",
            "name": "raw-sort",
            "label": "RawSort",
            "data": {
              "body": "> 소팅시 [Format](/docs/props/cell/format) 이 적용된 데이터를 기준으로 소팅할지 여부를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|열의 `Type` 과 `Format`을 적용한 소팅 (`default`)| |`1`|`Format`을 적용하지 않은 순수 데이터를 기준으로 한 소팅 `Enum`형식인 경우 `Key`를 기준으로 소팅| |`2`|`Enum`타입에서 `Enum`과 `EnumKey`의 입력순서(배열순서)로 정렬| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름: CLS) //포맷이 적용되지 않은 순수 데이터를 기준으로 소팅 { data:[ {... , \"CLSRawSort\": 1, ...} ] } ```",
              "see": [
                {
                  "label": "NumberSort cell",
                  "url": "./number-sort"
                },
                {
                  "label": "SortValue cell",
                  "url": "./sort-value"
                },
                {
                  "label": "CaseSensitive cell",
                  "url": "./case-sensitive"
                },
                {
                  "label": "Format cell",
                  "url": "/docs/props/cell/format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/raw-sort.html"
          },
          {
            "cid": 500,
            "sid": "related-2",
            "name": "related",
            "label": "Related",
            "data": {
              "body": "> [Type](./type)이 [Enum](/docs/props/cell/enum)이나 [Radio](/docs/props/cell/radio) 인 열들 간에 연관성을 통해, 대분류/중분류/소분류와 같은 **관계형 콤보**를 설정합니다. > 자세한 사용 방법은 col [Related](/docs/props/col/related)속성을 확인해 주세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자신의 상위 관계 열이름| ### Example ```javascript //Related 속성을 통해 대분류/중분류/소분류에 해당하는 콤보를 구성 //메소드를 통해 특정 셀에 속성 적용 (열이름: CLS3) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS3\", \"Related\", \"CLS1,CLS2\"); ```",
              "see": [
                {
                  "label": "Related col",
                  "url": "/docs/props/col/related"
                },
                {
                  "label": "Enum cell",
                  "url": "/docs/props/cell/enum"
                },
                {
                  "label": "EnumKeys cell",
                  "url": "/docs/props/cell/enum-keys"
                },
                {
                  "label": "Clear cell",
                  "url": "/docs/props/cell/clear"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/related.html"
          },
          {
            "cid": 501,
            "sid": "result-mask-2",
            "name": "result-mask",
            "label": "ResultMask",
            "data": {
              "body": "> 셀 편집 종료시 입력된 글자를 검사할 자바스크립트 정규식을 설정합니다. > 정규식 검사에 대한 로직은 [EditMask](/docs/props/cell/edit-mask)와 동일합니다. > > 정규식에 맞지 않은 글자가 입력되었을 시에는 [ResultMessage](/docs/props/cell/result-message)속성으로 설정한 메세지가 화면에 보여집니다. > [onResultMask](/docs/events/on-result-mask)이벤트의 리턴값을 통해 잘못된 값이 입력되었을때 후속 처리에 대한 부분을 설정하실 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|자바스크립트 정규식 문자| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ //이메일 주소만 입력 가능 {... ,CLSResultMask:\"^[\\\\w\\\\.\\\\+%-]+@[A-Za-z0-9\\\\.-]+\\\\.[A-Za-z]{2,6}$\", CLSResultText:\"이메일 주소를 확인해 주세요.\", ...} ] } ```",
              "see": [
                {
                  "label": "ResultText cell",
                  "url": "/docs/props/cell/result-text"
                },
                {
                  "label": "ResultMessage cell",
                  "url": "/docs/props/cell/result-message"
                },
                {
                  "label": "Error cell",
                  "url": "/docs/props/cell/error"
                },
                {
                  "label": "EditMask cell",
                  "url": "/docs/props/cell/edit-mask"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/result-mask.html"
          },
          {
            "cid": 502,
            "sid": "result-message-time-2",
            "name": "result-message-time",
            "label": "ResultMessageTime",
            "data": {
              "body": "> [ResultMessage](./result-message)가 보여질 시간(term)을 설정합니다.(ms단위) > 설정한 시간만큼 메세지가 보여지고 자동으로 사라집니다. > 이 속성을 설정하지 않으면 \"확인\"버튼을 누를 때까지 메세지가 보여지게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|메세지가 보여실 시간(ms단위)| ### Example ```javascript //이메일 주소 확인 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ResultMask\", \"^[\\\\w\\\\.\\\\+%-]+@[A-Za-z0-9\\\\.-]+\\\\.[A-Za-z]{2,6}$\"); sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ResultMessage\", \"이메일 주소를 확인해 주세요.\"); sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ResultMessageTime\", 800); ```",
              "see": [
                {
                  "label": "ResultText cell",
                  "url": "./result-text"
                },
                {
                  "label": "ResultMessage cell",
                  "url": "./result-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/result-message-time.html"
          },
          {
            "cid": 503,
            "sid": "result-message-2",
            "name": "result-message",
            "label": "ResultMessage",
            "data": {
              "body": "> [ResultMask](./result-mask)에 위배되는 내용이 입력시 DIV 레이어 팝업으로 보여질 내용을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|잘못된 내용이 입력시 보여질 경고문 내용| ### Example ```javascript //이메일 주소 확인 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ResultMask\", \"^[\\\\w\\\\.\\\\+%-]+@[A-Za-z0-9\\\\.-]+\\\\.[A-Za-z]{2,6}$\"); sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ResultMessage\", \"이메일 주소를 확인해 주세요.\") sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\",\"ResultMessageTime\", 800) ```",
              "see": [
                {
                  "label": "ResultText cell",
                  "url": "./result-text"
                },
                {
                  "label": "ResultMessageTime cell",
                  "url": "./result-message-time"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/result-message.html"
          },
          {
            "cid": 504,
            "sid": "result-text-2",
            "name": "result-text",
            "label": "ResultText",
            "data": {
              "body": "> [ResultMask](./result-mask)에 위배되는 내용이 입력시 alert으로 보여줄 내용을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|잘못된 내용이 입력시 보여질 경고문 내용| ### Example ```javascript //특정 셀에서 ResultMask 속성 위배시 메세지 설정 var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSResultText\"] = \"숫자만 입력 가능합니다.\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); ```",
              "see": [
                {
                  "label": "ResultMask cell",
                  "url": "./result-mask"
                },
                {
                  "label": "ResultMessage cell",
                  "url": "./result-message"
                },
                {
                  "label": "EditMask cell",
                  "url": "./edit-mask"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/result-text.html"
          },
          {
            "cid": 505,
            "sid": "row-span",
            "name": "row-span",
            "label": "RowSpan",
            "data": {
              "body": "> 특정 셀을 기준으로 아래쪽으로 합쳐질 셀의 개수를 설정합니다. > `col`에 [Spanned](/docs/props/col/spanned):`1` 이 설정되어 있어야 사용할 수 있습니다. > Html Table객체에 RowSpan과 유사합니다. > [DataMerge cfg](/docs/props/cfg/data-merge)과 [HeaderMerge cfg](/docs/props/cfg/header-merge)이 우선 적용 됩니다. > [setMergeRange method](/docs/funcs/core/set-merge-range) 사용시 동적으로 병합할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|열 내에서 아래로 병합할 셀의 개수| ### Example ```javascript //Spanned가 설정되어 있어야 함. options.Def.Col = {Spanned: 1}; //조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ //아래로 3개 셀을 병합함 {... ,CLSRowSpan: 3 ...} ] } ```",
              "see": [
                {
                  "label": "Span cell",
                  "url": "./span"
                },
                {
                  "label": "Spanned col",
                  "url": "/docs/props/col/spanned"
                },
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/header-merge"
                },
                {
                  "label": "setMergeRange method",
                  "url": "/docs/funcs/core/set-merge-range"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/row-span.html"
          },
          {
            "cid": 506,
            "sid": "selected-3",
            "name": "selected",
            "label": "Selected",
            "data": {
              "body": "> 셀을 선택하거나 선택여부를 확인 합니다. > [SelectingCells](/docs/props/cfg/selecting-cells)의 속성값이 `0(false)`이 아닌 경우에 사용하실 수 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|열 선택 해제| |`1(true)`|열 선택| ### Example ```javascript //특정 셀을 선택 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Selected\", 1); ```",
              "see": [
                {
                  "label": "Selected row",
                  "url": "/docs/props/row/selected"
                },
                {
                  "label": "SelectingCells cfg",
                  "url": "/docs/props/cfg/selecting-cells"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/selected.html"
          },
          {
            "cid": 507,
            "sid": "show-hint-3",
            "name": "show-hint",
            "label": "ShowHint",
            "data": {
              "body": "> 해당 셀에서 힌트기능을 사용할지 여부를 설정합니다. > 힌트는 셀의 너비가 좁아 내용의 일부가 안 보일 때, 마우스 커서가 올라간 셀에 한해 일시적으로 셀의 너비를 늘려 안보이던 뒷 내용을 보여주는 기능입니다. > 이 기능은 체크박스나 라디오 형태의 열에서는 작동하지 않습니다. ### ![힌트활성화](/assets/imgs/hint1.png \"마우스 커서가 셀에 올라갔을때 힌트를 통해 감춰진 부분이 보여짐\") ### Type `number` ### Options |Value|Description| |-----|-----| |`0`|힌트 기능을 사용안함| |`1`|셀의 크기가 작아 셀의 내용의 일부만 보여질때 동작 (`default`)| |`2`|1번 옵션과 더불어 스크롤이 있는 시트에서 셀이 하단에 있어 내용의 아래부분이 안보여질때 힌트 동작| |`3`|일반적으로는 힌트 기능이 동작하지 않고 [onShowHint](/docs/events/on-show-hint) 이벤트를 통해서만 동작(이벤트를 통해 힌트에 어떤 내용이 보여지게 할지 설정 가능)| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"ShowHint\", \"0\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSShowHint\"] = 2; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... ,\"CLSShowHint\": \"0\", ...} ] } ```",
              "see": [
                {
                  "label": "HintValue cell",
                  "url": "./hint-value"
                },
                {
                  "label": "ShowHint row",
                  "url": "/docs/props/row/show-hint"
                },
                {
                  "label": "onShowHint event",
                  "url": "/docs/events/on-show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/show-hint.html"
          },
          {
            "cid": 508,
            "sid": "size-ignore-decimal-sep-2",
            "name": "size-ignore-decimal-sep",
            "label": "SizeIgnoreDecimalSep",
            "data": {
              "body": "> 입력된 문자열이 숫자형인 경우, 설정된 열에 입력 가능한 글자 수에서 자릿수 구분자와 소수점 구분자의 값들을 글자 수에서 제외하는 기능입니다. > Locale메세지 파일(ko.js,en.js등)에서 자릿수 구분자는 `Format.GroupSeparator`, 소수점 구분자는 `Format.DecimalSeparator`로 설정되어 있습니다. > **<mark>주의</mark> : Col 혹은 Cell에 `Size` 속성이 설정되어 있어야 해당 기능이 동작합니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`boolean`|입력된 데이터에서 자릿수 구분자와 소수점 구분자를 이용하여 숫자형인지 판단하고, 숫자형 데이터일 경우 구분자 문자들을 입력가능한 글자수에서 제외 여부 (`Int`, `Float` type: `default:1(true)`, 그 외의 type: `default:0(false)`) 전 세계에서 사용되는 자릿수 구분자(`Format.GroupSeparator`) 문자: `,`, `.`, ` `, `'` 전 세계에서 사용되는 소수점 구분자(`Format.DecimalSeparator`) 문자: `,`, `.`| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"SizeIgnoreDecimalSep\", true); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSSizeIgnoreDecimalSep\"] = true; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSSizeIgnoreDecimalSep\": true ...} ] } ```",
              "see": [
                {
                  "label": "Size cell",
                  "url": "/docs/props/cell/size"
                },
                {
                  "label": "UnicodeByteMode cfg",
                  "url": "/docs/props/cfg/unicode-byte-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.15|기능 추가|"
            },
            "url": "docs/props/cell/size-ignore-decimal-sep.html"
          },
          {
            "cid": 509,
            "sid": "size-3",
            "name": "size",
            "label": "Size",
            "data": {
              "body": "> 셀에 입력가능한 글자수를 설정합니다. > [cfg.UnicodeByteMode](/docs/props/cfg/unicode-byte-mode)를 설정할 경우 한글의 바이트 수를 계산하여 입력을 제한합니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|입력가능한 글자수| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Size\", 20); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSSize\"] = 15; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSSize\": 10, ...} ] } ```",
              "see": [
                {
                  "label": "Size col",
                  "url": "/docs/props/col/size"
                },
                {
                  "label": "SizeIgnoreDecimalSep cel",
                  "url": "/docs/props/cell/size-ignore-decimal-sep"
                },
                {
                  "label": "UnicodeByteMode cfg",
                  "url": "/docs/props/cfg/unicode-byte-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/size.html"
          },
          {
            "cid": 510,
            "sid": "sort-value",
            "name": "sort-value",
            "label": "SortValue",
            "data": {
              "body": "> 셀의 원래 값 대신 소팅시 사용할 값을 설정합니다. > 특히 타입이 Html이나 버튼 같이 편집이 불가능한 셀에 유용하게 사용하실 수 있습니다. > 이 속성은 그룹 기능 사용 시 그룹핑 기준으로 사용 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|소팅이 이루어질때 사용될 기준 문자| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름: CLS) //특정 셀은 오름차순 소팅시 최상단에 올라오게 설정 { data:[ {... ,\"CLSSortValue\": \"00000\" , ...} ] } ```",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "/docs/props/cfg/group"
                },
                {
                  "label": "NumberSort cell",
                  "url": "./number-sort"
                },
                {
                  "label": "RawSort cell",
                  "url": "./raw-sort"
                },
                {
                  "label": "CaseSensitive cell",
                  "url": "./case-sensitive"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/sort-value.html"
          },
          {
            "cid": 511,
            "sid": "span",
            "name": "span",
            "label": "Span",
            "data": {
              "body": "> 특정 셀을 기준으로 오른쪽으로 합쳐질 셀의 개수를 설정합니다. > `row`에 [Spanned](/docs/props/row/spanned):`1` 이 설정되어 있어야 사용할 수 있습니다. > Html Table객체에 ColSpan과 유사합니다. > [DataMerge cfg](/docs/props/cfg/data-merge)과 [HeaderMerge cfg](/docs/props/cfg/header-merge)이 우선 적용 됩니다. > [setMergeRange method](/docs/funcs/core/set-merge-range) 사용시 동적으로 병합할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|행 내에서 오른쪽으로 합쳐질 셀 개수| ### Example ```javascript //Spanned가 설정되어 있어야 함. options.Def.Row = {Spanned: 1}; //조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ //오른쪽으로 3개 셀을 병합함 {... ,CLSSpan: 3 ...} ] } ```",
              "see": [
                {
                  "label": "DataMerge cfg",
                  "url": "/docs/props/cfg/data-merge"
                },
                {
                  "label": "HeaderMerge cfg",
                  "url": "/docs/props/cfg/header-merge"
                },
                {
                  "label": "RowSpan cell",
                  "url": "./row-span"
                },
                {
                  "label": "Spanned row",
                  "url": "/docs/props/row/spanned"
                },
                {
                  "label": "setMergeRange method",
                  "url": "/docs/funcs/core/set-merge-range"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/span.html"
          },
          {
            "cid": 512,
            "sid": "spinner-max-2",
            "name": "spinner-max",
            "label": "SpinnerMax",
            "data": {
              "body": "> [SpinnerVisible](./spinner-visible)을 사용하는 셀에서 화살표를 통한 입력 시 최댓값을 설정할 수 있습니다. > > 추가적으로 [SpinnerStep](./spinner-step), [SpinnerMin](./spinner-min)을 통해 input의 step, min를 설정 할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|편집 시 입력 값의 최댓값| ### Example ```javascript options.cells = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: true}, ... ]; var data = [ {Qty: 10, QtySpinnerMax: 100000}, {Qty: 20, QtySpinnerMax: 200000}, ] ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerVisible",
                  "url": "./spinner-visible"
                },
                {
                  "label": "SpinnerStep",
                  "url": "./spinner-step"
                },
                {
                  "label": "SpinnerMin",
                  "url": "./spinner-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.42|기능 추가|"
            },
            "url": "docs/props/cell/spinner-max.html"
          },
          {
            "cid": 513,
            "sid": "spinner-min-2",
            "name": "spinner-min",
            "label": "SpinnerMin",
            "data": {
              "body": "> [SpinnerVisible](./spinner-visible)을 사용하는 셀에서 화살표를 통한 입력 시 최솟값을 설정할 수 있습니다. > > 추가적으로 [SpinnerStep](./spinner-step), [SpinnerMax](./spinner-Max)을 통해 input의 step, max를 설정 할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|편집 시 입력 값의 최솟값| ### Example ```javascript options.cells = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: true}, ... ]; var data = [ {Qty: 10, QtySpinnerMin: 0}, {Qty: 20, QtySpinnerMin: -100}, ] ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerVisible",
                  "url": "./spinner-visible"
                },
                {
                  "label": "SpinnerStep",
                  "url": "./spinner-step"
                },
                {
                  "label": "SpinnerMax",
                  "url": "./spinner-max"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.42|기능 추가|"
            },
            "url": "docs/props/cell/spinner-min.html"
          },
          {
            "cid": 514,
            "sid": "spinner-step-2",
            "name": "spinner-step",
            "label": "SpinnerStep",
            "data": {
              "body": "> [SpinnerVisible](./spinner-visible)을 사용하는 셀에서 입력 값의 증감 간격을 설정할 수 있습니다. > > 추가적으로 [SpinnerMax](./spinner-max), [SpinnerMax](./spinner-min)을 통해 input의 min, max를 설정 할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|편집 시 입력 값의 증감 간격| ### Example ```javascript options.cells = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: true}, ... ]; var data = [ {Qty: 10, QtySpinnerStep: 10}, {Qty: 20, QtySpinnerStep: 20}, ] ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerVisible",
                  "url": "./spinner-visible"
                },
                {
                  "label": "SpinnerMax",
                  "url": "./spinner-max"
                },
                {
                  "label": "SpinnerMin",
                  "url": "./spinner-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.42|기능 추가|"
            },
            "url": "docs/props/cell/spinner-step.html"
          },
          {
            "cid": 515,
            "sid": "spinner-visible-2",
            "name": "spinner-visible",
            "label": "SpinnerVisible",
            "data": {
              "body": "> [Type](/docs/appx/type)이 `Int`, `Float`인 셀에서 편집 시 화살표를 표시합니다. > 설정 시 input의 type이 number로 생성됩니다. > > 추가적으로 [SpinnerStep](./spinner-step), [SpinnerMax](./spinner-max), [SpinnerMax](./spinner-min)을 통해 input의 step, min, max를 설정 할 수 있습니다. > `제약사항` [EditMaskFunc](../cfg/edit-mask-func)가 적용된 셀에서는 동작하지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|편집 시 화살표를 표시하지 않음 (`default`)| |`1(true)`|편집 시 화살표를 표시| ### Example ```javascript options.cells = [ ... {Type: \"Int\", Name: \"Qty\", SpinnerVisible: false}, ... ]; var data = [ {Qty: 10, QtySpinnerVisible: true}, {Qty: 20, QtySpinnerVisible: false}, ] ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "SpinnerStep",
                  "url": "./spinner-step"
                },
                {
                  "label": "SpinnerMax",
                  "url": "./spinner-max"
                },
                {
                  "label": "SpinnerMin",
                  "url": "./spinner-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.42|기능 추가|"
            },
            "url": "docs/props/cell/spinner-visible.html"
          },
          {
            "cid": 516,
            "sid": "suggest-delay-2",
            "name": "suggest-delay",
            "label": "SuggestDelay",
            "data": {
              "body": "> [Suggest](/docs/props/cell/suggest)가 설정된 셀에서 글자를 입력시 [Suggest](/docs/props/cell/suggest)가 나타나기 전까지 딜레이를 ms단위로 설정합니다. > debounce와 유사한 개념으로 딜레이를 설정한 시간 중에 다른 키가 입력되는 경우, 다시 설정한 시간만큼을 기다린 후 [Suggest](/docs/props/cell/suggest)를 표시합니다. > 가령 입력하는 글자를 기준으로 `onSuggest()`이벤트에서 디비 조회를 하는 경우, 너무 빈번하게 서버를 호출하는 것을 방지할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|입력 대기 시간 (`default: 0`)| ### Example ```javascript //3번째 행의 \"SaName\" 컬럼에서 Suggest표시 전에 300ms 대기 시간을 둔다. var row = sheet.getRowByIndex(3); row[\"SaNameSuggetDelay\"] = 300; ```",
              "see": [
                {
                  "label": "Suggest cell",
                  "url": "/docs/props/cell/suggest"
                },
                {
                  "label": "SuggestMin cell",
                  "url": "./suggest-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/suggest-delay.html"
          },
          {
            "cid": 517,
            "sid": "suggest-min-2",
            "name": "suggest-min",
            "label": "SuggestMin",
            "data": {
              "body": "> [Suggest](/docs/props/cell/suggest)을 통해 설정한 메뉴를 보여주기 위한 최소 글자수를 입력합니다. > 설정을 하지 않으면 한글자라도 입력시 바로 `Suggest`목록이 보여지게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|최소 입력 글자수 (`default: 1`)| ### Example ```javascript //Suggest기능 사용 options.Cols = [ ... { Type: \"Text\", Suggest: \"|싼타페 현대|포터2 현대|그랜저 현대|카니발 기아...\", SuggestMin: 3,//세글자 이상 입력시 Suggest 기능 활성화 Name: \"CarName\", Width: 120 ... }, ... ]; ```",
              "see": [
                {
                  "label": "Suggest cell",
                  "url": "./suggest"
                },
                {
                  "label": "SuggestType cell",
                  "url": "./suggest-type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/suggest-min.html"
          },
          {
            "cid": 518,
            "sid": "suggest-type-2",
            "name": "suggest-type",
            "label": "SuggestType",
            "data": {
              "body": "> [Suggest](./suggest)속성 사용과 관련한 다양한 추가기능을 설정합니다. > 여러 기능을 `\",\"` 를 구분자로 하여 설정하실 수 있습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`Replace`|`Suggest` 메뉴가 보여질때, 키보드 방향키를 이용하여 커서를 메뉴로 이동하면 셀값이 변경됩니다.| |`Start`|편집모드로 들어갈때 셀의 내용을 기준으로 `Suggest`메뉴를 보여줍니다.| |`StartAll`|편집모드로 들어갈때 셀의 내용과 무관하게 모든 `Suggest`메뉴를 보여줍니다.| |`Empty`|셀 값이 비어있을때 모든 `Suggest`메뉴를 보여줍니다.| |`All`|항상 모든 `Suggest`메뉴를 보여줍니다.| |`Case`|대소문자를 구분하여 `Suggest`메뉴를 보여줍니다.| |`Begin`|입력한 글자를 기준으로 `Suggest`메뉴의 아이템을 필터링할때,입력한 글자로 시작하는 아이템만 보여지게 됩니다.| |`Search`|입력한 글자를 포한하는 모든 아이템을 보여줍니다.| |`Complete`|`Suggest`메뉴의 리스트가 한개인 경우 자동으로 입력처리 합니다.| |`IgnoreSpace`|`Suggest`메뉴의 리스트에서 `Space`로 값이 선택되지 않도록 합니다.| |`Validate`|편집모드 종료 또는 셀 붙여넣기 시 셀의 값이 `Suggest`에 설정한 값과 일치하지 않으면 빈값으로 변경됩니다.| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"SuggestType\", \"Empty,Complete, Existing\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSSuggestType\"] = \"Empty,Complete,Existing\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSSuggestType\": \"Start,Search\", ...} ] } ```",
              "see": [
                {
                  "label": "Suggest cell",
                  "url": "./suggest"
                },
                {
                  "label": "SuggestMin cell",
                  "url": "./suggest-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.27|`IgnoreSpace` 기능 추가||core|8.3.0.1|`Validate` 기능 추가|"
            },
            "url": "docs/props/cell/suggest-type.html"
          },
          {
            "cid": 519,
            "sid": "suggest-2",
            "name": "suggest",
            "label": "Suggest",
            "data": {
              "body": "> 포탈 사이트 검색창의 자동완성과 마찬가지로 셀 안에 들어갈 내용 리스트를 정의해 두면, 입력시 리스트 중에 시작글자가 동일한 값이 필터링되어 보여집니다. > 첫번째 글자를 구분자로 하는 문자열로 설정합니다. ### ![Suggest](/assets/imgs/suggest.gif \"Suggest\") ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|첫글자를 구분자로 하는 문자열 ( ex: \"\\|우럭\\|광어\\|참돔\\|볼락\\|도다리\\|부시리\") ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Suggest\", \"|싼타페 현대|포터2 현대|그랜저 현대|카니발 기아...\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSSuggest\"] = \"|항공|철도|도로\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSSuggest\":\"|노인우대|장애인|아동|유아\" , ...} ] } ```",
              "see": [
                {
                  "label": "SuggestType cell",
                  "url": "./suggest-type"
                },
                {
                  "label": "SuggestMin cell",
                  "url": "./suggest-min"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/suggest.html"
          },
          {
            "cid": 520,
            "sid": "text-color-3",
            "name": "text-color",
            "label": "TextColor",
            "data": {
              "body": "> 지정한 셀에 글자색을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|HEX형식 (ex:#FF00F0) rgb형식 (ex:rgb(244,200,40)| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TextColor\", \"#FF0000\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSTextColor\"] = \"#AD4499\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSTextColor\": \"#0000FF\", ...} ] } ```",
              "see": [
                {
                  "label": "TextStyle cell",
                  "url": "./text-style"
                },
                {
                  "label": "TextSize cell",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont cell",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/text-color.html"
          },
          {
            "cid": 521,
            "sid": "text-font-3",
            "name": "text-font",
            "label": "TextFont",
            "data": {
              "body": "> 특정 셀의 `font-family`를 설정합니다. > 여러개 폰트를 지정하거나 폰트에 띄어쓰기가 들어가는 경우에는 `single(')/double quotation(\")`으로 지정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|글자체| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TextFont\", \"Dotum\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSTextFont\"] = \"'Nanum Gothic'\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSTextFont\":\"Gulim\" , ...} ] } ```",
              "see": [
                {
                  "label": "TextStyle cell",
                  "url": "/docs/props/cell/text-style"
                },
                {
                  "label": "TextColor cell",
                  "url": "/docs/props/cell/text-color"
                },
                {
                  "label": "TextSize cell",
                  "url": "/docs/props/cell/text-size"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/text-font.html"
          },
          {
            "cid": 522,
            "sid": "text-size-3",
            "name": "text-size",
            "label": "TextSize",
            "data": {
              "body": "> 지정한 셀의 글자 크기를 설정합니다. > `px, pt, em` 단위를 사용할 수 있으며, 단위를 지정하지 않으면 px기준으로 설정됩니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|크기숫자와 단위로 이루어진 문자열(ex: 25px)| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TextSize\", \"12pt\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSTextSize\"] = \"20px\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSTextSize\": \"22px\", ...} ] } ```",
              "see": [
                {
                  "label": "TextStyle cell",
                  "url": "./text-style"
                },
                {
                  "label": "TextColor cell",
                  "url": "./text-color"
                },
                {
                  "label": "TextFont cell",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/text-size.html"
          },
          {
            "cid": 523,
            "sid": "text-style-3",
            "name": "text-style",
            "label": "TextStyle",
            "data": {
              "body": "> 지정한 셀의 글자에 대한 `font-weight, font-style, font-variant, text-decoration`를 숫자로 설정합니다. > 숫자를 서로 더해서 여러 속성을 동시에 적용하 실 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`1`| 굵게 Bold| |`2`| 기울임 Italic| |`4`| 밑줄 Underline| |`8`| 취소선 Strike| |`16`| 윗줄 Overline| |`32`| 작은 대문자 Small Caps| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TextStyle\", 4); //1-1 특정 셀에 여러 속성 적용 (열이름: CLS, 굵게 + 기울임) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TextStyle\", 1 + 2); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSTextStyle\"] = 5; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSTextStyle\":8 , ...} ] } ```",
              "see": [
                {
                  "label": "TextColor cell",
                  "url": "./text-color"
                },
                {
                  "label": "TextSize cell",
                  "url": "./text-size"
                },
                {
                  "label": "TextFont cell",
                  "url": "./text-font"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/text-style.html"
          },
          {
            "cid": 524,
            "sid": "tip-class-3",
            "name": "tip-class",
            "label": "TipClass",
            "data": {
              "body": "> 풍선도움말 객체에 원하는 css클래스를 적용하여 디자인을 설정 합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|풍선도움말 객체에 적용할 클레스 명| ### Example ```css <style> .RedBold{color:red;font-weight:700;} .deepblue{color:#020079;} </style> ``` ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TipClass\", \"RedBold\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSTipClass\"] = \"deepblue\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSTipClass\": \"RedBold\", ...} ] } ```",
              "see": [
                {
                  "label": "Tip cell",
                  "url": "./tip"
                },
                {
                  "label": "Tip+Value cell",
                  "url": "./tip-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/tip-class.html"
          },
          {
            "cid": 525,
            "sid": "tip-position-3",
            "name": "tip-position",
            "label": "TipPosition",
            "data": {
              "body": "> 풍선도움말 객체의 위치나 크기,정렬을 설정합니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`X`|풍선도움말의 X축 가감 위치| |`Y`|풍선도움말의 Y축 가감 위치| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TipPosition\", {X:0, Y:-20}); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSTipPosition\"] = {X:-30}; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSTipPosition\": {Y:210}, ...} ] } ```",
              "see": [
                {
                  "label": "Tip cell",
                  "url": "./tip"
                },
                {
                  "label": "TipClass cell",
                  "url": "./tip-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/tip-position.html"
          },
          {
            "cid": 526,
            "sid": "tip-value-2",
            "name": "tip-value",
            "label": "Tip+Value",
            "data": {
              "body": "> 셀의 내용이 특정값일때 풍선도움말로 보여줄 문자를 설정합니다. > 가령 TipY:\"선택하셨습니다\", TipN:\"취소하셨습니다.\" 식으로 Tip 과 뒤에 Value를 결합한 속성명으로 보여질 문자를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|풍선도움말에 보여질 문자열| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TipAA\", \"심사기준을 확인해 주세요.\"); sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"TipBB\", \"진행율을 확인해 주세요.\"); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSY\"] = \"선택됨\"; ROW[\"CLSN\"] = \"취소됨\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLS0\":\"반려\",\"CLS1\":\"확인중\",\"CLS2\":\"진행중\",\"CLS3\":\"완료됨\", ...} ] } ```",
              "see": [
                {
                  "label": "Tip cell",
                  "url": "./tip-value"
                },
                {
                  "label": "TipPosition cell",
                  "url": "./tip-position"
                },
                {
                  "label": "TipClass cell",
                  "url": "./tip-class"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/tip-value.html"
          },
          {
            "cid": 527,
            "sid": "tip-3",
            "name": "tip",
            "label": "Tip",
            "data": {
              "body": "> 셀 위에 마우스 커서 오버시 풍선도움말을 표시할지 여부와 표시될 내용을 설정 합니다. > 기본적으로 html태그를 사용하여 상세한 내용을 표시할 수 있으나, cfg의 [StandardTip](/docs/props/cfg/standard-tip)의 값이 `1(true)`인 경우에는 브라우저의 내장 툴팁을 사용하게 되어 html태그를 표현할수 없습니다. ### Type `mixed`( `boolean` \\| `string` ) ### Options |Value|Description| |-----|-----| |`0(false)`|풍선도움말 사용 안함| |`1(true)`|풍선도움말 사용| |`string`|풍선도움말에서 표시 될 내용 설정| ### Example ```javascript //1. 메소드를 통해 특정 셀에 속성 적용 (열이름: CLS) sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Tip\", 0); //2. 객체에 직접 접근해서 속성 적용 (열이름: CLS) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSTip\"] = 1; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSTip\":\"작업 시작일과 종료일을 입력해 주세요.\" , ...} ] } ```",
              "see": [
                {
                  "label": "Tip+Value cell",
                  "url": "./tip-value"
                },
                {
                  "label": "TipClass cell",
                  "url": "./tip-class"
                },
                {
                  "label": "StandardTip cfg",
                  "url": "/docs/props/cfg/standard-tip"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/tip.html"
          },
          {
            "cid": 528,
            "sid": "type-2",
            "name": "type",
            "label": "Type",
            "data": {
              "body": "> 셀이 갖고있는 데이터 유형을 의미합니다. > 일반적인 텍스트나 숫자(정수,실수) 체크박스, 드랍다운리스트 와 같은 타입이 존재합니다. > 자세한 내용은 [Type appendix](/docs/appx/type)를 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`string`|`Text,Int,Float,Date,Bool,Enum` 등 정해진 문자열| ### Example ```javascript //1. 메소드를 통해 특정 셀의 타입을 변경 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"AMT\", \"Type\", \"Float\"); //2. 객체에 직접 접근해서 타입변경 (CLS열의 타입을 \"Date\"로 변경) var ROW = sheet.getRowById(\"AR10\"); ROW[\"CLSType\"] = \"Date\"; //변경내용 확인 sheet.refreshCell({row:ROW, col:\"CLS\"}); //3. 조회 데이터 내에서 타입 변경 { data:[ {... \"CLS\":\"20171225\", \"CLSType\": \"Date\", ...} ] } ```",
              "see": [
                {
                  "label": "Type appendix",
                  "url": "/docs/appx/type"
                },
                {
                  "label": "Type col",
                  "url": "/docs/props/col/type"
                },
                {
                  "label": "getType method",
                  "url": "/docs/funcs/core/get-type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/type.html"
          },
          {
            "cid": 529,
            "sid": "uncheck-2",
            "name": "uncheck",
            "label": "Uncheck",
            "data": {
              "body": "> [Type](./type)이 `Bool` 인 셀이 여러 개 있을때, 한 행 내에서 하나의 셀만 체크 가능하게([Radio속성](./radio))하거나, 한 열 내에서 하나의 셀만 체크하게([BoolGroup속성](./bool-group))하는 기능이 있는데, 이러한 기능을 사용시 체크된 상태에서 다시 클릭시 체크 해제를 허용할지 여부를 설정합니다. ### ![Radio](/assets/imgs/radio.png \"같은 행에서 하나만 선택 가능\") ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|체크 해제를 허용 안함| |`1(true)`|체크 해제를 허용 (`default`)| ### Example ```javascript //한번 체크하고 나면 그룹내에서 체크 해제가 불가능하게 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"Uncheck\", 0); ```",
              "see": [
                {
                  "label": "Radio cell",
                  "url": "./radio"
                },
                {
                  "label": "BoolGroup cell",
                  "url": "./bool-group"
                },
                {
                  "label": "Type cell",
                  "url": "./type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/uncheck.html"
          },
          {
            "cid": 530,
            "sid": "v-align-3",
            "name": "v-align",
            "label": "VAlign",
            "data": {
              "body": "> 셀 안에 문자열 상하 정렬을 설정합니다. > 좌우 정렬과 관련해서는 [Align](./align)속성을 참고하세요. ### Type `string` ### Options |Value|Description| |-----|-----| |`Top`|문자열 상단 정렬| |`Middle`|문자열 가운데 정렬| |`Bottom`|문자열 하단 정렬| ### Example ```javascript //특정 셀의 문자열을 상단 정렬로 설정 sheet.setAttribute(sheet.getRowById(\"AR99\"), \"CLS\", \"VAlign\", \"Top\", 1); ```",
              "see": [
                {
                  "label": "Align cell",
                  "url": "./align"
                },
                {
                  "label": "VAlign row",
                  "url": "/docs/props/row/v-align"
                },
                {
                  "label": "VAlign col",
                  "url": "/docs/props/col/v-align"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/v-align.html"
          },
          {
            "cid": 531,
            "sid": "visible-3",
            "name": "visible",
            "label": "Visible",
            "data": {
              "body": "> 셀 데이터의 보임/감춤 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|감춰짐| |`1(true)`|보임| ### Example ```javascript // 첫번째행 \"CLS\" 컬럼에 해당하는 셀의 데이터를 감춘다. sheet.setAttribute(sheet.getRowById(\"AR1\"), \"CLS\", \"Visible\", 0, 1); //조회 데이터에서 특정셀을 감춘다. {\"data\":[ ... {\"ColName1Visible\": 0, \"ColName1\": \"Value1\", \"ColName2\": \"Value2\", ...}, ... ]} ```",
              "see": [
                {
                  "label": "Visible row",
                  "url": "/docs/props/row/visible"
                },
                {
                  "label": "Visible col",
                  "url": "/docs/props/col/visible"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/visible.html"
          },
          {
            "cid": 532,
            "sid": "wrap-3",
            "name": "wrap",
            "label": "Wrap",
            "data": {
              "body": "> 셀에 내용이 많아 뒷부분이 안보여질때, 줄넘김 기능 사용 여부를 설정합니다. > 줄넘김이 이루어지는 경우 행의 높이가 증가하게 됩니다. > 일반적으로 `Text` 타입에서 사용하며, `Radio` 타입에서도 사용하실 수 있습니다. > [Lines 타입](/docs/appx/type) 컬럼에서는 `default: 1(true)`로 설정됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`0(false)`|줄넘김 사용 안함 (`default`)| |`1(true)`|줄넘김 사용 (`컬럼의 Type이 Lines인 경우 default: 1(true)`)| ### Example ```javascript //조회 데이터 내에서 속성 적용 (열이름: CLS) { data:[ {... , \"CLSWrap\": 1, ...} ] } ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/cell/wrap.html"
          }
        ]
      },
      {
        "gid": 5,
        "name": "props-event",
        "label": "Event",
        "children": [
          {
            "cid": 533,
            "sid": "on-change",
            "name": "on-change",
            "label": "OnChange",
            "data": {
              "body": "> 셀 값을 변경했을 때 셀 값과 편집된 셀값이 다를 경우 호출되는 `Json` 이벤트입니다. > `Json` 이벤트는 셀, 행, 열에서 선언될 수 있으며 적용되는 우선 순위는 **셀 > 행 > 열**입니다. > 예를 들어, 셀과 행 둘 다 선언했다면, 우선순위로 인해 행에 선언한 이벤트는 발생하지 않습니다. ### Syntax ```javascript function Handler(evtParam) { ... } // 행에 넣는 경우 var options = { ... Def: { Row: { ... OnChange: Handler, // 함수 호출이 아닌 문자열을 통한 간단한 로직 설정 가능 // ** 아래와 같은 예약어 사용 가능 // sheet(현재 시트 객체), // row(현재 이벤트가 호출된 셀의 데이터 로우 객체), // col(현재 이벤트가 호출된 열이름) ... } } ... }; // 열에 넣는 경우 var options = { ... Cols: [ { ... OnChange: Handler, ... } ... ] ... }; // 특정 셀에 넣는 경우 var data = [ { ... 열이름: \"\", 열이름OnChange: Handler, ... }, ... ]; // 특정 행에 넣는 경우 var data = [ { ... OnChange: Handler, ... }, ... ]; // 위에서 설정한 options 또는 data 객체를 시트 생성자의 인자로 넣습니다. IBSheet.create({ id: \"sheet\", el: \"Main\", options: options, data: data }); ``` ### Parameters | Name | Type | Description | |----------|-----|-------| |sheet|`object`|시트 객체| |row|`object`|값이 변경된 셀의 [데이터 로우 객체](/docs/appx/row-object)| |col|`string`|값이 변경된 셀의 열이름| |event|`object`|이벤트에 대한 정보를 담고 있는 객체| ### Return *boolean* ### Example ```javascript /* 예시 1 열에 OnChange이벤트를 선언하는 경우 */ // 값이 변경된 경우 alert를 띄웁니다. function Handler(evtParam) { alert(\"변경된 값은\" + evtParam.sheet.getValue({row:evtParam.row,col:evtParam.col})+ \"입니다\"); } var options = { Cols: [ { Name: \"sCountry\", Type: \"Text\", OnChange: Handler } ... ] }; /* 예시 2 셀에 OnChange이벤트 선언하는 경우(시트에 사용될 데이터에 선언) */ var data = [ { \"sCountry\": \"한국\", sCountryOnChange: \"alert('변경되었습니다')\", }, ... ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/event/on-change.html"
          },
          {
            "cid": 534,
            "sid": "on-click-side",
            "name": "on-click-side",
            "label": "OnClickSide",
            "data": {
              "body": "> [Button](/docs/props/col/button) 또는 [Icon](/docs/props/col/icon)이 속성을 사용하는 셀에 만들어지는 버튼을 클릭시 호출되는 `Json` 이벤트 입니다. > `Json` 이벤트는 셀, 행, 열에서 선언될 수 있으며 적용되는 우선 순위는 **셀 > 행 > 열**입니다. > 예를 들어, 셀과 행 둘 다 선언했다면, 우선순위로 인해 행에 선언한 이벤트는 발생하지 않습니다. ***Icon이나 Button 속성의 값이 Check 인 경우, 이 이벤트 내에서 값을 얻어보면 변경 전에 값이 추출됩니다. 이는 이 이벤트의 발생 시점이 실제로 체크가 변경되기 보다 앞서있기 때문입니다. 따라서 \"Check\"를 사용하실 때는 얻은 값의 반대 값을 입력해 주어야 합니다.*** ### Syntax ```js function Handler(evtParam) { // ... } // 행에 넣는 경우 var options = { // ... Def: { Row: { // ... // 함수 호출이 아닌 문자열을 통한 간단한 로직 설정 가능 // ** 아래와 같은 예약어 사용 가능 // Sheet(현재 시트 객체), // Row(현재 이벤트가 호출된 셀의 데이터 로우 객체), // Value(현재 이벤트가 호출된 셀의 값), // Col(현재 이벤트가 호출된 열이름), // ex) 'Value && alert(\"Changed\")' OnClickSide: Handler, // ... } } // ... }; // 열에 넣는 경우 var options = { // ... Cols: [{ // ... OnClickSide: Handler, // ... } // ... ] // ... }; // 특정 셀에 넣는 경우 var data = [{ // ... '열이름': '', '열이름OnClickSide': Handler, // ... }, ... ]; // 특정 행에 넣는 경우 var data = [{ // ... OnClickSide: Handler, // ... }, // ... ]; // 위에서 설정한 options 또는 data 객체를 시트 생성자의 인자로 넣습니다. IBSheet.create({ id: 'sheet', el: 'Main', options: options, data: data }); ``` ### Parameters | Name | Type | Description | |----------|-----|-------| |sheet|`object`|시트 객체| |row|`object`|클릭된 버튼/아이콘이 위치한 셀의 [데이터 로우 객체](/docs/appx/row-object)| |col|`string`|클릭된 버튼/아이콘이 위치한 셀의 열이름| |event|`object`|이벤트에 대한 정보를 담고 있는 객체| ### Return boolean ### Example ```js /** * [예시 1] * 열에 OnClickSide이벤트를 선언하는 경우 * */ // 셀 내에 위치한 오른쪽 버튼을 클릭시 http://www.ibsheet.com 페이지를 새창에서 띄웁니다. function Handler(evtParam) { window.open('http://www.ibsheet.com', '_blank'); } var options = { Cols: [{ Name: 'sCompany', Type: 'Text', Button: 'http://ibsheet.com/demo/images/11/s1.jpg', OnClickSide: Handler } // ... ] }; /** * [예시 2] * 셀에 OnClickSide이벤트 선언하는 경우(시트에 사용될 데이터에 선언) * */ var data = [{ sCompany: '시트', sCompanyOnClickSide: 'window.open(\"http://www.ibsheet.com\", \"_blank\")', }, // ... ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/event/on-click-side.html"
          },
          {
            "cid": 535,
            "sid": "on-click",
            "name": "on-click",
            "label": "OnClick",
            "data": {
              "body": "> 셀 클릭시 호출되는 `Json` 이벤트입니다. > `Json` 이벤트는 셀, 행, 열에서 선언될 수 있으며 적용되는 우선 순위는 **셀 > 행 > 열**입니다. > 예를 들어, 셀과 행 둘 다 선언했다면, 우선순위로 인해 행에 선언한 이벤트는 발생하지 않습니다. ### Syntax ```javascript function Handler(evtParam) { ... } // 행에 넣는 경우 var options = { ... Def: { Row: { ... OnClick: Handler, // 함수 호출이 아닌 문자열을 통한 간단한 로직 설정 가능 // ** 아래와 같은 예약어 사용 가능 // Sheet(현재 시트 객체), // Row(현재 이벤트가 호출된 셀의 데이터 로우 객체), // Value(현재 이벤트가 호출된 셀의 값), // Col(현재 이벤트가 호출된 열이름), // ex) \"Value && alert('Changed')\" ... } } ... }; // 열에 넣는 경우 var options = { ... Cols: [ { ... OnClick: Handler, ... } ... ] ... }; // 특정 셀에 넣는 경우 var data = [ { ... 열이름: \"\", 열이름OnClick: Handler, ... }, ... ]; // 특정 행에 넣는 경우 var data = [ { ... OnClick: Handler, ... }, ... ]; // 위에서 설정한 options 또는 data 객체를 시트 생성자의 인자로 넣습니다. IBSheet.create({ id: \"sheet\", el: \"Main\", options: options, data: data }); ``` ### Parameters | Name | Type | Description | |----------|-----|-------| |sheet|`object`|시트 객체| |row|`object`|클릭된 셀의 [데이터 로우 객체](/docs/appx/row-object)| |col|`string`|클릭된 셀의 열이름| |event|`object`|이벤트에 대한 정보를 담고 있는 객체| ### Return boolean ### Example ```javascript /* 예시 1 열에 OnClick이벤트를 선언하는 경우 */ // PCount 열의 셀을 클릭시 해당 셀의 값을 sProduct 열의 셀의 값과 곱하여 그 결과를 sTotal 열의 셀에 설정합니다. function Handler(evtParam) { evtParam.sheet.setValue({row: evtParam.row, col: \"sTotal\", val: evtParam.sheet.getValue({row: evtParam.row,col: evtParam.col}) * evtParam.sheet.getValue({row: evtParam.row,col: \"sProduct\"}), render:1}); } var options = { Cols: [ { Name: \"PCount\", Type: \"Int\", OnClick: Handler } ... ] }; /* 예시 2 셀에 OnClick이벤트 선언하는 경우(시트에 사용될 데이터에 선언) */ var data = [ { \"PCount\": \"5\", PCountOnClick: \"Sheet.setValue({row: Row, col: 'sTotal', val: Sheet.getValue({row: Row, col: Col}) * Sheet.getValue({row: Row, col: 'sProduct'}), render:1})\", }, ... ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/event/on-click.html"
          },
          {
            "cid": 536,
            "sid": "on-same",
            "name": "on-same",
            "label": "OnSame",
            "data": {
              "body": "> 셀 값을 변경했을 때 셀 값과 편집된 셀값이 같을 경우 호출되는 `Json` 이벤트입니다. > `Json` 이벤트는 셀, 행, 열에서 선언될 수 있으며 적용되는 우선 순위는 **셀 > 행 > 열**입니다. > 예를 들어, 셀과 행 둘 다 선언했다면, 우선순위로 인해 행에 선언한 이벤트는 발생하지 않습니다. ### Syntax ```javascript function Handler(evtParam) { ... } // 행에 넣는 경우 var options = { ... Def: { Row: { ... OnSame: Handler, // 함수 호출이 아닌 문자열을 통한 간단한 로직 설정 가능 // ** 아래와 같은 예약어 사용 가능 // Sheet(현재 시트 객체), // Row(현재 이벤트가 호출된 셀의 데이터 로우 객체), // Value(현재 이벤트가 호출된 셀의 값), // Col(현재 이벤트가 호출된 열이름), // ex) \"Value && alert('Same')\" ... } } ... }; // 열에 넣는 경우 var options = { ... Cols: [ { ... OnSame: Handler, ... } ... ] ... }; // 특정 셀에 넣는 경우 var data = [ { ... 열이름: \"\", 열이름OnSame: Handler, ... }, ... ]; // 특정 행에 넣는 경우 var data = [ { ... OnSame: Handler, ... }, ... ]; // 위에서 설정한 options 또는 data 객체를 시트 생성자의 인자로 넣습니다. IBSheet.create({ id: \"sheet\", el: \"Main\", options: options, data: data }); ``` ### Parameters | Name | Type | Description | |----------|-----|-------| |sheet|`object`|시트 객체| |row|`object`|편집 후에도 값이 이전과 같은 셀의 [데이터 로우 객체](/docs/appx/row-object)| |col|`string`|편집 후에도 값이 이전과 같은 셀의 열이름| |event|`object`|이벤트에 대한 정보를 담고 있는 객체| ### Example ```javascript /* 예시 1 열에 OnSame이벤트를 선언하는 경우 */ // 값이 편집전과 같은 경우 alert를 띄우고 셀 배경을 빨간색으로 변경합니다. function Handler(evtParam) { alert(\"기존의 값과 결과가 같습니다.\"); evtParam.sheet.setCellStyle({row: evtParam.row, col: evtParam.col, attr: {Color:'red'}, render:1}); } var options = { Cols: [ { Name: \"sCountry\", Type: \"Text\", OnSame: Handler } ... ] }; /* 예시 2 셀에 OnSame이벤트 선언하는 경우(시트에 사용될 데이터에 선언) */ var data = [ { \"sCountry\": \"한국\", sCountryOnSame:\"alert('기존의 값과 결과가 같습니다.') || Sheet.setCellStyle({row: Row, col: Col, attr: {Color:'red'}, render:1});\", }, ... ]; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/props/event/on-same.html"
          }
        ]
      }
    ]
  },
  {
    "gid": 4,
    "label": "Methods",
    "name": "funcs",
    "children": [
      {
        "cid": 537,
        "sid": "method",
        "name": "method",
        "label": "method 사용법 기초",
        "data": {
          "body": "> 시트가 제공하는 모든 메소드는 각 파라미터를 순서대로 설정하거나 하나의 `object` 형태로 설정할 수 있습니다. ### 파라미터 설정 방법 ```javascript //addRow 행추가 (next: 행위치, visible: 보임여부, focus: 포커스 이동여부, parent: 트리사용시 부모 행객체) //각 파라미터를 순서대로 설정 sheet.addRow(sheet.getFirstRow(), 1); //파라미터를 object 형태로 설정 sheet.addRow({visible: 1, focus: 1}); ```",
          "see": [],
          "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
        },
        "url": "docs/funcs/method.html"
      },
      {
        "gid": 1,
        "name": "funcs-core",
        "label": "Core",
        "children": [
          {
            "cid": 538,
            "sid": "accept-changed-data",
            "name": "accept-changed-data",
            "label": "acceptChangedData",
            "data": {
              "body": "> 시트 내에 변경된 내용(입력, 수정, 삭제)을 적용 합니다. > 행의 상태가 `Added(입력)`, `Changed(수정)`인 행은 상태만 클리어되고, `Deleted(삭제)`인 행은 삭제 됩니다. > 인자로 [데이터 로우 객체](/docs/appx/row-object)를 지정하면 해당 행에 대해서만 적용 합니다. ### Syntax ```javascript void acceptChangedData( row ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***none*** ### Example ```javascript //저장 작업 완료 CallBack 함수 function SaveSuccessCallBack(data){ //수정한 내용을 모두 반영한다. sheet.acceptChangedData(); } ```",
              "see": [
                {
                  "label": "applySaveResult method",
                  "url": "./apply-save-result"
                },
                {
                  "label": "hasChangedData method",
                  "url": "./has-changed-data"
                },
                {
                  "label": "getChangedData method",
                  "url": "./get-changed-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/accept-changed-data.html"
          },
          {
            "cid": 539,
            "sid": "add-col",
            "name": "add-col",
            "label": "addCol",
            "data": {
              "body": "> 이미 생성된 시트에 동적으로 열을 추가합니다. > 여러 컬럼을 `add` 할시 `render` 인자를 `false` 로 하여 작업 후에는 `rerender` 를 무조건 호출하셔야 합니다. `Formula` 계산 반영이 필요한 경우에는 `calculate` 를 호출해주셔야 계산이 반영됩니다. ### Syntax ```javascript object addCol( name, section, pos, param, visible, render ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |name|`string`|<span class='required'>필수</span>|추가할 열이름| |section|`number`|<span class='optional'>선택</span>|추가될 영역 `0`:좌측 영역 `1`:가운데 영역 (`default`) `2`:우측영역| |pos|`number`|<span class='optional'>선택</span>|section 내에 위치 (0부터 시작, -1입력시 우측 끝 열) (`default: 0`)| |param|`object`|<span class='optional'>선택</span>|열의 속성 (ex : `{Type:\"Text\", Header:\"타이틀\", Width:120, CanEdit:0}` ) |visible|`boolean`|<span class='optional'>선택</span>|생성 후 화면에 `Visible` 여부 `0(false)`:감춤 (`default`) `1(true)`:보임| |render|`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 `1(true)`:즉시 반영 (`default`)| ### Return Value ***object*** : 생성된 열 객체(name 인자에 이미 존재하는 열이름을 입력하는 경우 `null` 이 리턴됨) ### Example ```javascript // 가운데 영역 마지막 열으로 \"Name:EXT_SUBSUM\" 열을 추가 sheet.addCol( \"EXT_SUBSUM\", 1, -1, {Type:\"Int\",Header:\"중간합계\",Width:200,CanEdit:1,Color:\"#DADADA\"}, true ); // render 인자 false for (var i = 0; i < 50; i++) { sheet.addCol( \"EXT_SUBSUM\" + i, 1, -1, {Type:\"Int\",Header:\"중간합계\",Width:200,CanEdit:1,Color:\"#DADADA\"}, true, false ); } sheet.rerender(); ```",
              "see": [
                {
                  "label": "addRow method",
                  "url": "./add-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.17|`render` 인자 추가|"
            },
            "url": "docs/funcs/core/add-col.html"
          },
          {
            "cid": 540,
            "sid": "add-formula",
            "name": "add-formula",
            "label": "addFormula",
            "data": {
              "body": "> 특정 행, 열, 셀에 포뮬러를 추가합니다. > `row`와 `col`이 없는 경우 전체 데이터에 포뮬러를 추가합니다. > 해당 기능 사용 시 [CanFormula](/docs/props/row/can-formula)가 자동적으로 true로 설정됩니다. > [CalcOrder](/docs/props/row/calc-order)에 설정한 포뮬러가 순차적으로 추가됩니다. > 자세한 내용은 7장 [Formula appendix](/docs/appx/formula)를 참고하세요. ### Syntax ```javascript boolean addFormula( formula, row, col, attr, render ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |formula|`function` \\| `string`|<span class='required'>필수</span>|추가하고자 하는 포뮬러| |row |`object` \\| `array[object]`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) 또는 [데이터 로우 객체](/docs/appx/row-object) 배열| |col |`string`|<span class='optional'>선택</span>|열 이름| |attr|`string`|<span class='optional'>선택</span>|추가하려는 [attribute + Formula](/docs/props/col/attribute-formula)의 속성명| |render|`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 `1(true)`:즉시 반영 (`default`)| ### Return Value ***boolean*** : 함수 정상 동작 여부. (인자값이 잘못되어 수행되지 못한 경우에는 false 리턴) ### Example ```javascript // 컬럼 추가 후 Formula 도 동적으로 추가 sheet.addCol( \"IntData\", 0, -1, {Type:\"Int\",Header:\"추가Int컬럼\",Width:200,CanEdit:1}, true); var colorFormula = function (param) { if (param.Row && param.Row[\"IntData\"] === 0) { return \"#FFD9FA\" } } // 데이터 행의 배경색을 조건에 따라 변경 sheet.addFormula(colorFormula, \"\", \"\", \"Color\"); //////////////////////////////////////////// var Formula = function (param) { if (param.Row[\"IntData\"] > 100) { return true } else { return false } } // IntData의 값에 따라 체크박스 열의 체크 변경 sheet.addFormula(Formula, \"\", \"CheckData\", \"\", true); //////////////////////////////////////////// // 시트의 첫번째 행의 TextData 열에 값을 IntData 열과 FloatData 열의 합으로 변경 sheet.addFormula(\"IntData + FloatData\", sheet.getFirstRow(), \"TextData\", \"\", true); ```",
              "see": [
                {
                  "label": "Formula appendix",
                  "url": "/docs/appx/formula"
                },
                {
                  "label": "CanFormula Row",
                  "url": "/docs/props/row/can-formula"
                },
                {
                  "label": "CalcOrder Row",
                  "url": "/docs/props/row/calc-order"
                },
                {
                  "label": "attribute+Formula col",
                  "url": "/docs/props/col/attributeformula"
                },
                {
                  "label": "FormulaRow col",
                  "url": "/docs/props/col/formula-row"
                },
                {
                  "label": "Formula col",
                  "url": "/docs/props/col/formula"
                },
                {
                  "label": "attribute+Formula cell",
                  "url": "/docs/props/cell/attribute-formula"
                },
                {
                  "label": "calculate method",
                  "url": "/docs/funcs/core/calculate"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.4|기능 추가|"
            },
            "url": "docs/funcs/core/add-formula.html"
          },
          {
            "cid": 541,
            "sid": "add-row",
            "name": "add-row",
            "label": "addRow",
            "data": {
              "body": "> 신규 행을 추가합니다. > 트리 기능을 사용시에는 `parent`인자를 지정해 줘야 원하는 레벨로 행을 추가할 수 있습니다. > `render:0` 을 사용하여 화면에 바로 반영하지 않고 `rerender` 호출을 통해 화면에 반영할 때, `Formula` 적용 계산이 필요하다면 `calculate` 함수를 호출해 주어야 `Formula`가 반영 됩니다. ### Syntax ```javascript object addRow( next, visible, focus, parent, init, render ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |next|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (지정한 행의 위에 신규 행이 생성됨. 값이 없으면 맨 마지막행에 생성)| |visible|`boolean`|<span class='optional'>선택</span>|생성 즉시 화면에 반영 여부 **생성된 행의 [Visible](/docs/props/row/visible) 값 설정** `0(false)`:감춤 `1(true)`:보임 (`default`)| |focus|`boolean`|<span class='optional'>선택</span>|생성 후 생성된 행으로 포커스 이동 여부 `0(false)`:포커스 이동 안함 `1(true)`:포커스 이동 (`default`)| |parent|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (트리 사용시 부모에 해당하는 행 지정)| |init|`object`|<span class='optional'>선택</span>|신규 행에 값/옵션 설정 객체| |render|`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. **생성된 행의 [Visible](/docs/props/row/visible) 여부와는 관련 없음** `0(false)`:반영 안함 `1(true)`:즉시 반영 (`default`)| ### Return Value ***object*** : 생성된 [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript // 맨 위에 신규 행을 생성합니다. sheet.addRow( {\"next\":sheet.getFirstRow()} ) // 현재 포커스가 위치한 행의 위에 신규 행을 생성합니다. sheet.addRow( {\"next\":sheet.getFocusedRow()} ); // 현재 포커스가 위치한 행의 아래에 신규 행을 생성합니다.(focus 이동) sheet.addRow( {\"next\":sheet.getNextRow(sheet.getFocusedRow())}); // 트리 사용시 현재 포커스가 위치한 행의 아래에 같은 레벨의 신규 행을 생성합니다. var nextRow = sheet.getNextSiblingRow(sheet.getFocusedRow()); var parentRow = sheet.getFocusedRow().parentNode; sheet.addRow( {\"next\":nextRow, \"parent\":parentRow} ); // 현재 포커스가 된 행의 자식 노드로 신규 행을 추가합니다. // next 로 기준 행을 주지 않으면, 자식 노드 맨 마지막에 행이 추가됩니다. sheet.addRow({\"parent\":sheet.getFocusedRow()}); // 현재 포커스가 위치한 행의 위에 신규 행을 생성합니다. // 신규 행의 CONTRACTNO과 CARNO 열에 값을 설정합니다. // 신규 행의 배경 색상을 빨간색으로 설정합니다. sheet.addRow({\"next\":sheet.getFocusedRow(), \"init\":{\"CONTRACTNO\":\"S155\", \"CARNO\":\"1234123\", Color:\"red\"}}); ``` ### Demo - [addRow sample](https://codepen.io/ibsheet/pen/dygddxQ)",
              "see": [
                {
                  "label": "addRows method",
                  "url": "./add-rows"
                },
                {
                  "label": "deleteRow method",
                  "url": "./delete-row"
                },
                {
                  "label": "deleteRows method",
                  "url": "./delete-rows"
                },
                {
                  "label": "removeRow method",
                  "url": "./remove-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.3|`init` 인자 추가||core|8.0.0.20|`render` 인자 추가|"
            },
            "url": "docs/funcs/core/add-row.html"
          },
          {
            "cid": 542,
            "sid": "add-rows",
            "name": "add-rows",
            "label": "addRows",
            "data": {
              "body": "> 신규 행을 여러개 추가합니다. > 트리 기능을 사용시에는 `parent`인자를 지정해 줘야 원하는 레벨로 행을 추가할 수 있습니다. ### Syntax ```javascript object addRows( count, next, focus, parent, valid ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |count|`number`|<span class='required'>필수</span>|추가할 행의 개수| |next|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (지정한 행의 위에 신규행이 생성됨. 값이 없으면 맨 마지막행에 생성)| |focus|`boolean`|<span class='optional'>선택</span>|생성 후 생성된 행으로 포커스 이동 여부 `0(false)`:포커스 이동 안함 `1(true)`:포커스 이동 (`default`)| |parent|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (트리 사용시 부모에 해당하는 행 지정)| |valid|`boolean`|<span class='optional'>선택</span>|행추가 가능여부 확인 (실제로 행이 추가되지 않고, 가능/불가능 여부를 확인해서 리턴) `0(false)`:행추가 가능여부 확인 안함 (`default`) `1(true)`:행추가 가능여부 확인 사용| ### Return Value ***object*** : 추가된 행들 중에 최상단 행의 [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //포커스행 위로 신규행을 3개 추가합니다. var firtAddRow = sheet.addRows( {\"count\":3, \"next\":sheet.getFocusedRow()} ); //선택 행 위치에 신규행을 2개 추가합니다. sheet.addRows({\"count\":2, \"parent\":sheet.getFocusedRow().parentNode, \"next\":sheet.getFocusedRow()}); ```",
              "see": [
                {
                  "label": "addRow method",
                  "url": "./add-row"
                },
                {
                  "label": "deleteRow method",
                  "url": "./delete-row"
                },
                {
                  "label": "deleteRows method",
                  "url": "./delete-rows"
                },
                {
                  "label": "removeRow method",
                  "url": "./remove-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/add-rows.html"
          },
          {
            "cid": 543,
            "sid": "ajax",
            "name": "ajax",
            "label": "ajax",
            "data": {
              "body": "> ajax 통신을 통해 서버로부터 데이터를 받아옵니다. > 서버 통신이 완료되었을때 실행되는 callback 함수를 이용해서 서버로부터 받은 데이터를 사용할 수 있습니다. ### Syntax ```javascript void ajax ( url, param, method, callback, sync, reqHeader, timeout, traditional ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |url|`string`|<span class='required'>필수</span>|ajax를 통해 호출할 url| |param|`string`\\|`object`|<span class='optional'>선택</span>|서버로 전송할 파라미터| |method|`string`|<span class='optional'>선택</span>| 전송방식 `GET / POST` 선택 (`default: 'GET'`)| |callback|`funtion`|<span class='optional'>선택</span>|서버 통신이 완료되었을때 발생하는 콜백 함수 ex) `func(res(결과 코드), data(서버로부터 받은 데이터), responseXML(XMLHttpRequest.responseXML), response(XMLHttpRequest 객체))`| |sync|`boolean`|<span class='optional'>선택</span>|동기식 처리 여부 `0(false)`:비동기 방식 (`default`) `1(true)`:동기 방식| |reqHeader|`object`|<span class='optional'>선택</span>|서버로 전송할 헤더 {key1: value1, key2: value2}| |timeout|`number`|<span class='optional'>선택</span>|서버 통신 최대 대기 시간 (단위: 초(second), `default: 60`)| |traditional|`boolean`|<span class='optional'>선택</span>|서버로 전달될 param 구조 설정 `param: {\"data\": [1, 2]}` 배열 구조 param 전송시 설정 **`0(false)`:[] 을 포함하여 전송** (`default`) ex) `data[]=1&data[]=2` **`1(true)`:[] 없이 전송** ex) `data=1&data=2` | ### Return Value ***none*** ### Example ```javascript // POST 방식으로 데이터 조회 sheet.ajax(\"./insaAppMain.do\", \"dept_cd=031&position_cd=A0\", \"POST\", function (res, data, resXml, response) { if (res >= 0) { sheet.loadSearchData(data); } else { alert(\"데이터 조회에 실패 했습니다!!\"); } }); // GET 방식으로 데이터 조회 sheet.ajax({ url: \"./insaAppMain.do\", param: {\"dept_cd\": 31, \"position_cd\": \"A0\"}, method: \"GET\", reqHeader: {\"Content-Type\":\"application/json\"}, callback: function (res, data, resXml, response) { if (res >= 0) { sheet.loadSearchData(data); } else { alert(\"데이터 조회에 실패 했습니다\"); } } }); ```",
              "see": [
                {
                  "label": "loadSearchData method",
                  "url": "./load-search-data"
                },
                {
                  "label": "Timeout cfg",
                  "url": "/docs/props/cfg/timeout"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.5|`timeout` 인자 추가||core|8.0.0.7|`traditional` 인자 추가||core|8.0.0.17|`params` -> `param` 인자명 변경 (`params` 사용 가능)|"
            },
            "url": "docs/funcs/core/ajax.html"
          },
          {
            "cid": 544,
            "sid": "apply-save-result",
            "name": "apply-save-result",
            "label": "applySaveResult",
            "data": {
              "body": "> 시트의 수정된 내용을 서버로 전송했다가 돌아온 결과 `json`으로 부터 이후에 수행되어야할 작업을 처리합니다. > > 동작하는 내용을 아래와 같습니다. > 1. 첫번째 `result` 인자의 값이 양수(0 이상)이면 [appeptChangedData()](./accept-changed-data)를 통해 수정내용을 반영합니다. > 음수가 리턴되는 경우, 값에 따라 경고 메세지를 표시합니다. > 2. `result` 값과 무관하게 [onAfterSave](/docs/events/on-after-save)이벤트가 발생시킵니다. ### Syntax ```javascript boolean applySaveResult( result, message, response, files ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |result|`number`|<span class='required'>필수</span>|서버 응답 결과([onAfterSave](/docs/events/on-after-save) 이벤트의 `result` 파라미터 값 참고.)| |message|`string`|<span class='optional'>선택</span>|[onAfterSave](/docs/events/on-after-save) 이벤트로 전달할 메세지 문자열| |response|`object`|<span class='optional'>선택</span>|ajax 통신의 response 객체([onAfterSave](/docs/events/on-after-save) 이벤트로 전달)| |files|`array`|<span class='optional'>선택</span>|`file` 타입 저장 시 ajax 통신 후 저장된 파일 데이터를 전달 ([getSaveJson](./get-save-json)의 `formData`인자와 함께 사용)| ### Return Value ***boolean*** : 함수 정상 동작 여부. (인자값이 잘못되어 수행되지 못한 경우에는 `false` 리턴) ### Example ```javascript // 포커스행 위로 신규행을 3개 추가합니다. $.ajax({ url:\"saveDO.do\", data: param, dataType:\"json\", success:function(data){ var result = data.IO.Result; var message = data.IO.Message; // 결과를 시트에 반영한다. sheet.applySaveResult(result, message); } }) ```",
              "see": [
                {
                  "label": "appeptChangedData method",
                  "url": "./accept-changed-data"
                },
                {
                  "label": "onAfterSave event",
                  "url": "/docs/events/on-after-save"
                },
                {
                  "label": "getSaveJson method",
                  "url": "./get-save-json"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.5|files 기능 추가|"
            },
            "url": "docs/funcs/core/apply-save-result.html"
          },
          {
            "cid": 545,
            "sid": "blur",
            "name": "blur",
            "label": "blur",
            "data": {
              "body": "> 시트에 포커스를 해제합니다. > 시트에 버튼을 통해 layer 팝업을 띄우는 경우, 시트 측에 포커스를 해제해야만 layer 팝업 내에서 원활하게 포커스를 이동할 수 있습니다. ### Syntax ```javascript boolean blur( mode ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |mode|`number`|<span class='optional'>선택</span>| 시트 내부 셀에 대한 포커스를 해제할지와 시트에 대한 포커스도 해제할지 여부를 설정합니다. `0`:모두 해제 (`default`) `1`:시트 내부 셀에 대한 포커스만 해제 `2`:시트에 대한 포커스만 해제| ### Return Value ***boolean*** : 정상적으로 포커스가 해제된 경우 `true`, 포커스 해제에 실패한 경우 `false`를 리턴 ### Example ```javascript //layer팝업 오픈 전에 현재 시트의 포커스 해제(셀 포커스는 유지) sheet.blur(2); dialog.dialog( \"open\" ); ```",
              "see": [
                {
                  "label": "focus method",
                  "url": "./focus"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/blur.html"
          },
          {
            "cid": 546,
            "sid": "calculate",
            "name": "calculate",
            "label": "calculate",
            "data": {
              "body": "> 시트에 설정된 `Formula` 계산을 [Row.CalcOrder](/docs/props/row/calc-order) 에 따라 실행합니다. > 경우에 따라서 [CanFormula row](/docs/props/row/can-formula)속성을 통해 계산이 이루어져야 할 행만 `1`로 설정하고 나머지 행은 `0`으로 설정한 뒤, 해당 함수를 통해 계산할 수 있습니다. ### Syntax ```javascript void calculate( render, calconly, fixedonly ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |render |`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 `1(true)`:즉시 반영 (`default`)| |calconly|`boolean`|<span class='optional'>선택</span>|`Row.CanFormula = 1` 인 행만 계산할 지 여부 `0(false)`:전체 행 계산 (`default`) `1(true)`:`Row.CanFormula = 1` 인 행들만 계산| |fixedonly |`boolean`|<span class='optional'>선택</span>|`Fiexd` 행들(`Header, Filter, FormulaRow`)만 계산할 지 여부 `0(false)`:전체 행 계산 (`default`) `1(true)`:`Fiexd` 행들(`Header, Filter, FormulaRow`)만 계산| ### Return Value ***none*** ### Example ```javascript //전체 Formula를 실행하여 결과를 반영한다. sheet.calculate( true, false ); ```",
              "see": [
                {
                  "label": "Formaula appendix",
                  "url": "/docs/appx/formula"
                },
                {
                  "label": "CanFormula row",
                  "url": "/docs/props/row/can-formula"
                },
                {
                  "label": "CalcOrder row",
                  "url": "/docs/props/row/calc-order"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.8|`render` 인자 `default` 값 변경(`false -> true`)||core|8.0.0.11|`fixedonly` 추가|"
            },
            "url": "docs/funcs/core/calculate.html"
          },
          {
            "cid": 547,
            "sid": "clear-current-info",
            "name": "clear-current-info",
            "label": "clearCurrentInfo",
            "data": {
              "body": "> [saveCurrentInfo()](./save-current-info)로 저장된 현재 시트의 정보를 로컬 스토리지 혹은 세션 스토리지에서 제거하는 메소드입니다. > [StorageSession](/docs/props/cfg/storage-session) 값이 0인 경우에는 제거 동작을 하지 않습니다. ### Syntax ```javascript boolean clearCurrentInfo(); ``` ### Return Value ***boolean*** : 함수 정상 동작 여부. (로컬 스토리지 혹은 세션 스트로지에서 시트 정보 제겅 실패했을 때 false 리턴) ### Example ```javascript options.Cfg = { StorageSession: 1 // 로컬 스토리지에 현재 시트 정보를 저장할 수 있고 가져올 수 있도록 설정 }; ... // 현재 시트의 정보를 로컬 스토리지 혹은 세션 스토리지에서 제거한다. sheet.clearCurrentInfo(); ```",
              "see": [
                {
                  "label": "StorageSession cfg",
                  "url": "/docs/props/cfg/storage-session"
                },
                {
                  "label": "StorageKeyPrefix cfg",
                  "url": "/docs/props/cfg/storage-key-prefix"
                },
                {
                  "label": "StorageCompressMode cfg",
                  "url": "/docs/props/cfg/storage-compress-mode"
                },
                {
                  "label": "saveCurrentInfo method",
                  "url": "./save-current-info"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/clear-current-info.html"
          },
          {
            "cid": 548,
            "sid": "clear-current-style",
            "name": "clear-current-style",
            "label": "clearCurrentStyle",
            "data": {
              "body": "> 스타일 행으로 저장된 현재 시트의 스타일 관련 정보를 제거하는 메소드입니다. > [StyleRowConfig](/docs/props/cfg/style-row-config)의 `StorageType`이 1인 경우, 로컬 스토리지에 저장된 스타일 정보를 제거합니다. ([StorageSession](/docs/props/cfg/storage-session) 값이 0인 경우에는 제거 동작을 하지 않습니다.) > `StorageType`이 2인 경우, 스타일 행의 `ServerUrl`의 경로로 저장된 스타일 정보를 제거하는 요청을 전송합니다. ### Syntax ```javascript boolean clearCurrentStyle(); ``` ### Return Value ***boolean*** : 함수 정상 동작 여부 ### Example ```javascript options.Cfg = { StorageSession: 1 // 로컬 스토리지에 현재 시트 정보를 저장할 수 있고 가져올 수 있도록 설정 }; ... // 저장된 스타일 정보를 제거한다. sheet.clearCurrentStyle(); ```",
              "see": [
                {
                  "label": "StorageSession cfg",
                  "url": "/docs/props/cfg/storage-session"
                },
                {
                  "label": "StyleRowConfig cfg",
                  "url": "/docs/props/cfg/style-row-config"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.18|기능 추가||core|8.3.0.33|서버 삭제 요청 기능 개선|"
            },
            "url": "docs/funcs/core/clear-current-style.html"
          },
          {
            "cid": 549,
            "sid": "clear-filter",
            "name": "clear-filter",
            "label": "clearFilter",
            "data": {
              "body": "> 필터행의 내용이 초기화 되고, 이전에 필터링되었던 내용도 모두 보여지게 됩니다. ### Syntax ```javascript void clearFilter(); ``` ### Return Value ***none*** ### Example ```javascript //필터 초기화 sheet.clearFilter(); ```",
              "see": [
                {
                  "label": "showFilterRow method",
                  "url": "./show-filter-row"
                },
                {
                  "label": "setFilter method",
                  "url": "./set-filter"
                },
                {
                  "label": "doFilter method",
                  "url": "./do-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/clear-filter.html"
          },
          {
            "cid": 550,
            "sid": "clear-pivot-filter",
            "name": "clear-pivot-filter",
            "label": "clearPivotFilter",
            "data": {
              "body": "> 피벗 필터가 적용된 경우 필터행의 내용을 초기화한 뒤, 원본 시트에 따라 다시 피벗 시트를 생성합니다. ### Syntax ```javascript void clearPivotFilter(); ``` ### Return Value ***none*** ### Example ```javascript //피벗 필터를 제거하고 다시 피벗 시트를 생성합니다. pivotSheet_sheet.clearPivotFilter(); ```",
              "see": [
                {
                  "label": "doPivotFilter method",
                  "url": "./do-pivot-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.1|기능 추가|"
            },
            "url": "docs/funcs/core/clear-pivot-filter.html"
          },
          {
            "cid": 551,
            "sid": "clear-range",
            "name": "clear-range",
            "label": "clearRange",
            "data": {
              "body": "> 시트 내에 특정 영역의 값을 지웁니다. > `range` 인자에 설정된 row1, col1 셀부터 row2, col2 셀까지 영역의 값을 지웁니다. ### Syntax ```javascript void clearRange( range ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |range|`array`|<span class='required'>필수</span>|시트 내에서 값을 지울 영역을 지정하는 배열 [ row1, col1, row2, col2 ] row1 : 영역의 시작되는 부분에 위치한 셀의 [데이터 로우 객체](/docs/appx/row-object) col1 : 영역의 시작되는 부분에 위치한 셀의 열이름 row2 : 영역의 끝나는 부분에 위치한 셀의 [데이터 로우 객체](/docs/appx/row-object) col2 : 영역의 끝나는 부분에 위치한 셀의 열이름| ### Return Value ***none*** ### Example ```javascript //첫번째 행부터, 포커스된 행까지 CUST_CD 열부터 ORDER_DATE열까지 값을 모두 지웁니다. sheet.clearRange([sheet.getFirstVisibleRow(), \"CUST_CD\", sheet.getFocusedRow(), \"ORDER_DATE\"]) ```",
              "see": [
                {
                  "label": "setValue method",
                  "url": "./set-value"
                },
                {
                  "label": "setString method",
                  "url": "./set-string"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/clear-range.html"
          },
          {
            "cid": 552,
            "sid": "clear-selection",
            "name": "clear-selection",
            "label": "clearSelection",
            "data": {
              "body": "> 드래그나 함수등을 통해 선택한 영역에 대해 선택을 취소한다. ### Syntax ```javascript void clearSelection( ); ``` ### Return Value ***none*** ### Example ```javascript //선택 영역 모두 취소 sheet.clearSelection(); ```",
              "see": [
                {
                  "label": "CanSelect row",
                  "url": "/docs/props/row/can-select"
                },
                {
                  "label": "CanSelect col",
                  "url": "/docs/props/col/can-select"
                },
                {
                  "label": "selectRow method",
                  "url": "./select-row"
                },
                {
                  "label": "selectCol method",
                  "url": "./select-col"
                },
                {
                  "label": "selectRange method",
                  "url": "./select-range"
                },
                {
                  "label": "getSelectedRange method",
                  "url": "./get-selected-range"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/clear-selection.html"
          },
          {
            "cid": 553,
            "sid": "clear-sort",
            "name": "clear-sort",
            "label": "clearSort",
            "data": {
              "body": "> 헤더 소팅을 취소합니다. ### Syntax ```javascript void clearSort( ); ``` ### Return Value ***none*** ### Example ```javascript //헤더 소팅된 내용을 원래 순서로 클리어 sheet.clearSort(); ```",
              "see": [
                {
                  "label": "doSort method",
                  "url": "./do-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/clear-sort.html"
          },
          {
            "cid": 554,
            "sid": "clear-3",
            "name": "clear",
            "label": "clear",
            "data": {
              "body": "> DOM 영역에서 시트 부분을 제거합니다. > 구형 Internet Explorer 브라우저에서 메모리 누수에 대응하기 위한 기능입니다. > 브라우저를 새로고침 하거나, 다른 페이지로 이동시 내부적으로 자동 호출됩니다. > [reload](./reload)()함수를 통해 DOM에서 제거된 시트를 다시 불러올 수 있습니다. ### Syntax ```javascript void clear(); ``` ### Return Value ***none*** ### Example ```javascript //시트 DOM 부분 제거 sheet.clear(); ```",
              "see": [
                {
                  "label": "reload method",
                  "url": "./reload"
                },
                {
                  "label": "dispose mehtod",
                  "url": "./dispose"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/clear.html"
          },
          {
            "cid": 555,
            "sid": "close-dialog",
            "name": "close-dialog",
            "label": "closeDialog",
            "data": {
              "body": "> 시트가 제공하는 다이얼로그나 `Menu`를 닫습니다. ### Syntax ```javascript void closeDialog(); ``` ### Return Value ***none*** ### Example ```javascript //열려있는 메뉴/다이얼로그를 닫습니다. sheet.closeDialog(); ```",
              "see": [
                {
                  "label": "showMenu method",
                  "url": "./show-menu"
                },
                {
                  "label": "showDialog method",
                  "url": "./show-dialog"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/close-dialog.html"
          },
          {
            "cid": 556,
            "sid": "copy-row",
            "name": "copy-row",
            "label": "copyRow",
            "data": {
              "body": "> 지정한 행을 특정 위치로 복사합니다. ### Syntax ```javascript object copyRow( row , next , empty , parent , child, forceVisible ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |next|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (next로 지정한 행의 위에 row행이 복사됨. 값이 없으면 맨 마지막행에 복사)| |empty|`boolean`|<span class='optional'>선택</span>|복사 시 데이터 포함 여부 `1(true)`로 설정하여 사용 시 [onAfterRowCopy](/docs/events/on-after-row-copy) 이벤트 미발생 `0(false)`:데이터 포함 (`default`) `1(true)`:데이터 미포함| |parent|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (트리 사용시 부모에 해당하는 행 지정)| |child|`boolean`|<span class='optional'>선택</span>|트리 사용시 자식행도 복사할 지 여부 `0(false)`:자식행 미포함 (`default`) `1(true)`:자식행 포함| |forceVisible|`boolean`|<span class='optional'>선택</span>|보이지 않는 행을 복사할 때 보이도록 설정 `0(false)`:행을 감춤(Visible:`0(false)`) 상태로 변경 시키고 복사 (`default`) `1(true)`:행을 보임(Visible:`1(true)`) 상태로 변경 시키고 복사| ### Return Value ***object*** : 복사된 [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR5 행을 포커스 행 위로 복사 var row = sheet.copyRow({row:sheet.getRowById(\"AR5\"), next:sheet.getFocusedRow()}); //AR5 행을 포커스 행 아래로 복사 var row = sheet.copyRow({row:sheet.getRowById(\"AR5\"), \"next\":sheet.getNextRow(sheet.getFocusedRow())}); //복사한 행을 감춘다. row[\"Visible\"] = 0; sheet.renderBody(); ```",
              "see": [
                {
                  "label": "addRow method",
                  "url": "./add-row"
                },
                {
                  "label": "moveRow method",
                  "url": "./move-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/copy-row.html"
          },
          {
            "cid": 557,
            "sid": "copy-rows",
            "name": "copy-rows",
            "label": "copyRows",
            "data": {
              "body": "> 지정한 행들을 특정 위치로 복사합니다. > 내부적으로는 여러개 행을 복사 후 추가(ctrl+c, ctrl+v)하는 행위이기 때문에 [onAfterRowCopy](/docs/events/on-after-row-copy) 이벤트와 [onAfterRowAdd](/docs/events/on-after-row-add)이벤트가 발생합니다. ### Syntax ```javascript object copyRows( rows, next, empty, parent, child, forceVisible ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |rows|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object) 배열| |next|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (next로 지정한 행의 위에 rows행들이 복사됨. 값이 없으면 마지막 행에 복사)| |empty|`boolean`|<span class='optional'>선택</span>|복사 시 데이터 포함 여부 `1(true)`로 설정하여 사용 시 [onAfterRowCopy](/docs/events/on-after-row-copy) 이벤트 미발생 `0(false)`:데이터 포함 (`default`) `1(true)`:데이터 미포함| |parent|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (트리 사용시 부모에 해당하는 행 지정)| |child|`boolean`|<span class='optional'>선택</span>|트리 사용시 자식행도 복사할 지 여부 `0(false)`:자식행 미포함 (`default`) `1(true)`:자식행 포함| |forceVisible|`boolean`|<span class='optional'>선택</span>|보이지 않는 행을 복사할 때 보이도록 설정 `0(false)`:행을 감춤(Visible:`0(false)`) 상태로 변경 시키고 복사 (`default`) `1(true)`:행을 보임(Visible:`1(true)`) 상태로 변경 시키고 복사| ### Return Value ***array[row object]*** : 복사된 [데이터 로우 객체](/docs/appx/row-object)들 ### Example ```javascript //AR5,AR6,AR9행을 최상단에 복사 sheet.copyRows({rows:[ sheet.getRowById(\"AR5\"), sheet.getRowById(\"AR6\"), sheet.getRowById(\"AR9\") ], next:sheet.getFirstRow()}); //CHK열에 체크한 행들을 sheet2에 맨 마지막 행으로 복사 function work(){ var chkRows = sheet.getRowsByChecked(\"CHK\"); sheet2.copyRows({rows:chkRows}); } ```",
              "see": [
                {
                  "label": "copyRow method",
                  "url": "./copy-row"
                },
                {
                  "label": "addRow method",
                  "url": "./add-row"
                },
                {
                  "label": "moveRow method",
                  "url": "./move-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/copy-rows.html"
          },
          {
            "cid": 558,
            "sid": "delete-row",
            "name": "delete-row",
            "label": "deleteRow",
            "data": {
              "body": "> 지정한 행의 <mark>상태를 삭제로 변경</mark>합니다. > 지정한 행에는 [Deleted](/docs/props/row/deleted) 속성값이 `1`로 세팅됩니다. > 트리의 경우 행의 상태를 삭제로 변경할 경우 행의 자식 행들도 삭제 상태로 변경됩니다. ### Syntax ```javascript boolean deleteRow( row , del , valid, visible); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |del|`number`|<span class='optional'>선택</span>|삭제 여부 `0`:삭제취소 `1`:삭제 (`default`)| |valid|`boolean`|<span class='optional'>선택</span>|삭제/삭제취소 가능여부 확인 (실제로 삭제/삭제취소 되진 않고 삭제/삭제취소 가능/불가능 여부를 확인해서 리턴) `0(false)`:삭제/삭제취소 가능여부 확인 안함 (`default`) `1(true)`:삭제/삭제취소 가능여부 확인 사용| |visible|`boolean`|<span class='optional'>선택</span>|삭제 행을 화면에 보여줄지 여부 `0(false)`:삭제 행 감춤 `1(true)`:삭제 행 보임 (`default`)| ### Return Value ***boolean*** : 상태 변경여부 (상태가 삭제/삭제취소로 변경이 이루어지면 true, 변화가 없으면 false 리턴) ### Example ```javascript //AR5 행에 대해 상태를 삭제로 변경한다. sheet.deleteRow({row:sheet.getRowById(\"AR5\"), del:1}); ```",
              "see": [
                {
                  "label": "addRow method",
                  "url": "./add-row"
                },
                {
                  "label": "addRows method",
                  "url": "./add-rows"
                },
                {
                  "label": "deleteRows method",
                  "url": "./delete-rows"
                },
                {
                  "label": "removeRow method",
                  "url": "./remove-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.38|visible 기능 추가|"
            },
            "url": "docs/funcs/core/delete-row.html"
          },
          {
            "cid": 559,
            "sid": "delete-rows",
            "name": "delete-rows",
            "label": "deleteRows",
            "data": {
              "body": "> 지정한 행들의 <mark>상태를 삭제로 변경</mark>합니다. > 지정한 행들에는 [Deleted](/docs/props/row/deleted) 속성값이 `1`로 세팅됩니다. ### Syntax ```javascript boolean deleteRows( rows, del ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |rows|`array[object]`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object) 배열| |del|`number`|<span class='optional'>선택</span>|삭제 여부 `0`:삭제취소 `1`:삭제 (`default`) `2`:삭제후 삭제된 행들 숨김(Visible:`0(false)` 처리| ### Return Value ***boolean*** : 상태 변경 여부 (상태가 삭제/삭제취소로 변경이 이루어지면 true, 변화가 없으면 false 리턴) ### Example ```javascript //AR5,AR8 행에 대해 상태를 삭제로 변경한다. sheet.deleteRows({\"rows\":[sheet.getRowById(\"AR5\"), sheet.getRowById(\"AR8\")],\"del\":1}); ```",
              "see": [
                {
                  "label": "addRow method",
                  "url": "./add-row"
                },
                {
                  "label": "addRows method",
                  "url": "./add-rows"
                },
                {
                  "label": "deleteRow method",
                  "url": "./delete-row"
                },
                {
                  "label": "removeRow method",
                  "url": "./remove-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/delete-rows.html"
          },
          {
            "cid": 560,
            "sid": "disable",
            "name": "disable",
            "label": "disable",
            "data": {
              "body": "> 시트를 비활성화 합니다. > 시트 위에 투명한 layer가 덮혀 hover 관련 기능을 차단하고 기타 키보드, 마우스 이벤트가 차단됩니다. > `disable` 영역은 시트 바깥 영역에 있습니다. `fixedInSheet` 를 `true` 로 사용시에 안쪽에 영역을 고정시킵니다. ### Syntax ```javascript void disable( hard, fixedInSheet ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |hard|`boolean`|<span class='optional'>선택</span>|시트위에 50% 반투명 layer가 표시됩니다. `0(false)`:layer 표시 안함 (`default`) `1(true)`:layer 표시| |fixedInSheet|`boolean`|<span class='optional'>선택</span>|시트 영역 안쪽에 `disable` 영역을 만듭니다. `0(false)`:`disable` 영역 생성 안함 (`default`) `1(true)`:`disable` 영역 생성| ### Return Value ***none*** ### Example ```javascript //시트를 비활성화 sheet.disable(true); ```",
              "see": [
                {
                  "label": "enable method",
                  "url": "./enable"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.19|`fixedInSheet` 인자 추가|"
            },
            "url": "docs/funcs/core/disable.html"
          },
          {
            "cid": 561,
            "sid": "dispose",
            "name": "dispose",
            "label": "dispose",
            "data": {
              "body": "> 시트를 DOM과 메모리에서 제거합니다. > `dispose`된 시트는 더 이상 사용할 수 없고, 초기화 과정을 통해 처음부터 다시 생성해야 합니다. > SinglePageApplication 기반의 프로젝트에서는 페이지 이동 전에 이 함수를 통해 시트 객체를 제거해야만 합니다. ### Syntax ```javascript void dispose(); ``` ### Return Value ***none*** ### Example ```javascript //시트객체를 완전히 제거 sheet.dispose(); ```",
              "see": [
                {
                  "label": "clear method",
                  "url": "./clear"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/dispose.html"
          },
          {
            "cid": 562,
            "sid": "do-filter",
            "name": "do-filter",
            "label": "doFilter",
            "data": {
              "body": "> 주어진 값을 필터행에 반영하고 시트를 필터링 합니다. > **해당 함수는 반드시 [ShowFilter](/docs/props/cfg/show-filter)를 통해 필터가 보여지는 경우에만 사용이 가능합니다.** > ;를 통해 필터링 하고 싶은 값들에 대해 or연산을 실행할 수 있습니다(ex |떡볶이;오뎅|...). > ,를 통해 필터링 하고 싶은 값들에 대해 and연산을 실행할 수 있습니다(ex |떡볶이,오뎅|...). ### Syntax ```javascript void doFilter( cols , vals , operators , nofilter , noclear ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |cols|`string`|<span class='required'>필수</span>|필터링을 수행할 열들 첫글자를 구분로 열이름과 열이름을 연결한 문자를 구성(ex:\"\\|DEPTNM\\|POSITION\\|SALARY\" )| |vals|`string`|<span class='required'>필수</span>|필터링 하고 싶은 값 첫글자를 구분로 열이름과 열이름을 연결한 문자를 구성 (ex:\"\\|총무\\|대리\\|3500\" )| |operators|`string`|<span class='required'>필수</span>|필터링 연산자(숫자) 첫글자를 구분로 열이름과 열이름을 연결한 문자를 구성 (ex:\"\\|0\\|1\\|2\" )| |nofilter|`boolean`|<span class='optional'>선택</span>|실제 필터링은 하지않고 필터행에 글자만 입력시킴 여부 `0(false)`:필터링 실행 (`default`) `1(true)`:필터링 미실행, 필터행에 글자만 입력| |noclear|`boolean`|<span class='optional'>선택</span>|필터행에 `cols`에서 지정하지 않은 열의 값을 지울것인지 여부 `0(false)`:`cols`에서 지정하지 않은 열의 값 삭제 (`default`) `1(true)`:`cols`에서 지정하지 않은 열의 값 삭제 안함| **operators 상세설명** |value|type|desc| |---|---|---| |`0`|공통|필터를 사용하지 않음| |`1`|공통|같다| |`2`|공통|같지않다| |`3`|숫자, 날짜|작다| |`4`|숫자, 날짜|작거나 같다| |`5`|숫자, 날짜|크다| |`6`|숫자, 날짜|크거나 같다| |`7`|문자|앞글자 일치| |`8`|문자|앞글자가 일치하지 않음| |`9`|문자|뒷글자 일치| |`10`|문자|뒷글자 일지하지 않음| |`11`|문자|해당 글자 포함| |`12`|문자|해당 글자 포함하지 않음| |`13`|숫자|상위 10| |`14`|공통|값 있음| |`15`|공통|값 없음| ### Return Value ***none*** ### Example ```javascript //deptName 열에 내용중 연구팀으로 끝나는 행과 cardAmt 열의 값이 50000보다 큰 경우의 행만 보여짐 sheet.doFilter(\"|deptName|cardAmt\", \"|연구팀|50000\", \"|9|6\"); ```",
              "see": [
                {
                  "label": "ShowFilter cfg",
                  "url": "/docs/props/cfg/show-filter"
                },
                {
                  "label": "clearFilter method",
                  "url": "./clear-filter"
                },
                {
                  "label": "setFilter method",
                  "url": "./set-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.27|13 기능 추가||core|8.1.0.27|14,15 기능 추가|"
            },
            "url": "docs/funcs/core/do-filter.html"
          },
          {
            "cid": 563,
            "sid": "do-group",
            "name": "do-group",
            "label": "doGroup",
            "data": {
              "body": "> 지정한 열들을 함수를 통해 그룹핑 합니다. ### Syntax ```javascript void doGroup( cols ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |cols|`string`|<span class='required'>필수</span>|그룹할 열이름을 \",\"를 구분자로 순서대로 입력 ### Return Value ***none*** ### Example ```javascript //부서와 팀컬럼을 순서대로 그룹핑 sheet.doGroup(\"dempNm,teamNm\"); ```",
              "see": [
                {
                  "label": "Group cfg",
                  "url": "/docs/props/cfg/group"
                },
                {
                  "label": "onBeforeGroup event",
                  "url": "/docs/events/on-before-group"
                },
                {
                  "label": "onAfterGroup  event",
                  "url": "/docs/events/on-after-group"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.3|groupcols 인자명 변경 -> cols, 다른 API와 통일|"
            },
            "url": "docs/funcs/core/do-group.html"
          },
          {
            "cid": 564,
            "sid": "do-pivot-filter",
            "name": "do-pivot-filter",
            "label": "doPivotFilter",
            "data": {
              "body": "> 주어진 값을 필터행에 반영하여, 원본 시트에서 필터된 데이터 결과에 따라 피벗 시트를 생성합니다. > ;를 통해 필터링 하고 싶은 값들에 대해 or연산을 실행할 수 있습니다(ex |떡볶이;오뎅|...). > ,를 통해 필터링 하고 싶은 값들에 대해 and연산을 실행할 수 있습니다(ex |떡볶이,오뎅|...). ### Syntax ```javascript void doPivotFilter( cols , vals , operators ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |cols|`string`|<span class='required'>필수</span>|필터링을 수행할 열들 첫글자를 구분로 열이름과 열이름을 연결한 문자를 구성(ex:\"\\|DEPTNM\\|POSITION\\|SALARY\" )| |vals|`string`|<span class='required'>필수</span>|필터링 하고 싶은 값 첫글자를 구분로 열이름과 열이름을 연결한 문자를 구성 (ex:\"\\|총무\\|대리\\|3500\" )| |operators|`string`|<span class='required'>필수</span>|필터링 연산자(숫자) 첫글자를 구분로 열이름과 열이름을 연결한 문자를 구성 (ex:\"\\|7\\|7\\|5\" )| **operators 상세설명** |value|type|desc| |---|---|---| |`0`|공통|필터를 사용하지 않음| |`1`|공통|같다| |`2`|공통|같지않다| |`3`|숫자, 날짜|작다| |`4`|숫자, 날짜|작거나 같다| |`5`|숫자, 날짜|크다| |`6`|숫자, 날짜|크거나 같다| |`7`|문자|앞글자 일치| |`8`|문자|앞글자가 일치하지 않음| |`9`|문자|뒷글자 일치| |`10`|문자|뒷글자 일지하지 않음| |`11`|문자|해당 글자 포함| |`12`|문자|해당 글자 포함하지 않음| |`13`|숫자|상위 10| |`14`|공통|값 있음| |`15`|공통|값 없음| ### Return Value ***none*** ### Example ```javascript //deptName 열에 내용중 연구팀으로 끝나는 행과 cardAmt 열의 값이 50000보다 큰 경우의 행을 기반으로 원본 시트를 필터하여, 피벗 시트를 생성합니다. pivotSheet_sheet.doPivotFilter(\"|deptName|cardAmt\", \"|연구팀|50000\", \"|9|6\"); ```",
              "see": [
                {
                  "label": "clearPivotFilter method",
                  "url": "./clear-pivot-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.2.0.1|기능 추가|"
            },
            "url": "docs/funcs/core/do-pivot-filter.html"
          },
          {
            "cid": 565,
            "sid": "do-print",
            "name": "do-print",
            "label": "doPrint",
            "data": {
              "body": "> 시트의 내용을 원하는 규격으로 인쇄합니다. > 용지 규격과 방향은 브라우저의 인쇄 설정과 동일하게 설정해 주어야 합니다. > **<mark>주의</mark> : 인쇄 결과가 브라우저 별로 상이 할 수 있습니다.** > **<mark>주의</mark> : `zoomFit` 속성이 `0`일 경우 `fitPage` 속성은 동작하지 않습니다** > **<mark>주의</mark> : 멀티레코드([MultiRecord](/docs/props/cfg/multi-record)) 기능을 사용하는 시트에서는 제약이 있습니다** ### Syntax ```js void doPrint( prefix, postfix, pagePrefix, pagePostfix, fitPage, zoomFit, menu, pageOrient, firstPrintHead ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |prefix|`string`|<span class='optional'>선택</span>|첫 페이지 상단에 표시될 문자열 (HTML 형식 가능)| |postfix|`string`|<span class='optional'>선택</span>|마지막 페이지 하단에 표시될 문자열 (HTML 형식 가능)| |pagePrefix|`string`|<span class='optional'>선택</span>|각 페이지 상단(머릿말)에 표시될 문자열 (HTML 형식 가능)| |pagePostfix|`string`|<span class='optional'>선택</span>|각 페이지 하단(꼬릿말)에 표시될 문자열 (HTML 형식 가능)| |fitPage|`number`|<span class='optional'>선택</span>|인쇄할 시트의 크기가 페이지보다 클 경우, 페이지에 맞춤 옵션 `0`:없음 `1`:너비에 맞춤 <i>(`default`)</i> `2`:높이에 맞춤 `3`:한 페이지에 맞춤| |zoomFit|`number`|<span class='optional'>선택</span>|시트의 크기가 페이지보다 작을 경우, 페이지에 맞춤 옵션 `0`:없음 `1`:한 페이지에 맞춤 <i>(`default`)</i>| |menu|`number`|<span class='optional'>선택</span>|프린트 다이얼로그 사용 여부 `0`:사용안함 <i>(`default`)</i> `1`:행열 선택 옵션만 보기 `2`:전체 옵션 보기| |pageOrient|`number`|<span class='optional'>선택</span>|인쇄 용지 방향 설정 `0`:세로 <i>(`default`)</i> `1`:가로 **<mark>주의</mark> : 해당 속성은 Chrome 브라우저에서만 동작합니다**| |firstPrintHead|`boolean`|<span class='optional'>선택</span>|인쇄시 용지 첫 페이지만 시트의 헤더가 인쇄 `0(false)`:모든 페이지에서 시트의 헤더 표시 <i>(`default`)</i> `1(true)`:첫 페이지만 시트의 헤더 표시 | #### `pagePrefix`, `pagePostfix`에서의 예약어 사용 * `%1`: 가로 페이지 인덱스 * `%2`: 세로 페이지 인덱스 * `%3`: 페이지 인덱스 * `%4`: 가로 페이지 개수 * `%5`: 세로 페이지 개수 * `%6`: 페이지 개수 ### Return Value ***none*** ### Browser Constraint |Browser|Constraint| |-------|----------| |Chrome|제약 없음| |Edge(Chrominu)|제약 없음| |Firefox|시트 스타일, Html 스타일 적용 안됨 `pageOrient` 사용 불가| |Opera|`pageOrient` 사용 불가| |IE11|시트 스타일, Html 스타일 적용 안됨 `pageOrient` 사용 불가| ### Examples #### 옵션객체만 사용하는 경우 ```js var options = { prefix: \"<div style='background-color:#EDEDED;padding:10px'>사용자 : 홍길동</div>\", pagePostfix: \"<div style='text-align:center;font-size:20px'>[%2 / %5]</div>\", fitPage: 1 }; sheet.doPrint(options); ``` #### CSS와 함께 사용하는 경우 `prefix`, `pagePrefix`, `pagePostfix`, `postfix` 클래스명은 고유하므로 변경 불가, 이외의 클래스명으로 크기와 관련된 속성을 정의할 경우 출력 페이지의 레이아웃에 반영되지 않습니다. ##### HTML ```html <!-- ... --> <head> <!-- ... --> <link href=\"ibsheet-print.css\" rel=\"stylesheet\" type=\"text/css\" /> <!-- ... --> </head> ``` ##### SCSS (ibsheet-print.scss) ```scss BODY[class*=BodyPrint] > DIV[class*=PrintPage] DIV[class*=PaddingWrapper] { > .prefix { font-size: 2rem; font-weight: bold; padding: 1.5rem 0 1rem; text-align: center; } > .pagePrefix { text-align: right; padding: 1rem 0; } > .pagePostfix { font-size: .5rem; text-align: center; } > .postfix { font-size: .8rem; text-align: center; } } ``` ##### CSS (ibsheet-print.css) ```css BODY[class*=BodyPrint] > DIV[class*=PrintPage] DIV[class*=PaddingWrapper] > .prefix { font-size: 2rem; font-weight: bold; padding: 1.5rem 0 1rem; text-align: center; } BODY[class*=BodyPrint] > DIV[class*=PrintPage] DIV[class*=PaddingWrapper] > .pagePrefix { text-align: right; padding: 1rem 0; } BODY[class*=BodyPrint] > DIV[class*=PrintPage] DIV[class*=PaddingWrapper] > .pagePostfix { font-size: .5rem; text-align: center; } BODY[class*=BodyPrint] > DIV[class*=PrintPage] DIV[class*=PaddingWrapper] > .postfix { font-size: .8rem; text-align: center; } ``` ##### JavaScript `prefix`, `pagePrefix`, `pagePostfix`, `postfix` 값의 형식이 HTML이 아닐 경우, DIV 엘리먼트에 해당 속성의 클래스명이 자동으로 추가되어 적용됩니다. ```js var options = { prefix: '문서 제목', pagePrefix: 'IB Leaders', pagePostfix: '[ %3 / %6 ]', postfix: 'Powered by IBSheet8' }; sheet.doPrint(options); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.17|`pageOrient` 기능 추가||core|8.1.0.51|`firstPrintHead` 기능 추가|"
            },
            "url": "docs/funcs/core/do-print.html"
          },
          {
            "cid": 566,
            "sid": "do-save",
            "name": "do-save",
            "label": "doSave",
            "data": {
              "body": "> 시트에서 변경된 내용을 추출하여 서버로 전송하고, 서버에서 응답 JSON 내용에 따라 시트에 반영합니다. > 서버로 전송하기 전에 [onBeforeSave](/docs/events/on-before-save)이벤트가 발생하고, 서버에서 응답이 왔을 때 [onAfterSave](/docs/events/on-after-save) 이벤트가 발생 합니다. > 서버에서 받게 되는 JSON 내용과 관련해서는 7장 appendix에 [dataStructure](/docs/appx/data-structure)를 참고하세요. ### Syntax ```javascript void doSave( url , param , saveMode , col , urlEncode , delim , queryMode , reqHeader , request , sync, validRequired, saveAttr, useLevel ,questCallback, timeout, traditional, saveExtraAttr ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |url|`string`|<span class='required'>필수</span>|ajax를 통해 호출할 url| |param|`string` \\| `object`|<span class='optional'>선택</span>|서버로 전송할 파라미터| |saveMode|`number`|<span class='optional'>선택</span>|상태별 데이터 추출 여부 `0`:전체데이터 `1`:전체데이터 중 `Deleted` 만 제외 `2`:수정된 데이터(`Added,Changed,Deleted`) (`default`) `3`:수정된 데이터(`Added,Changed,Deleted`)+이동한 데이터(`Moved`)| |col|`string`|<span class='optional'>선택</span>|저장 기준 열의 열이름 특정 열을 지정하면 행의 상태(`Added,Changed,Deleted`)를 무시하고 지정한 열의 데이터 유무에 따라 저장됨.| |urlEncode|`boolean`|<span class='optional'>선택</span>|시트의 데이터에 대한 encoding 여부 **`queryMode`별로 `default`가 달라짐** `0(false)`:`queryMode:0 (default)` `1(true)`:`queryMode:1/2 (default)` | |delim|`string`|<span class='optional'>선택</span>|queryMode값이 2인 경우에 데이터 사이 구분자 지정 (`default: \"\\|\"`)| |queryMode|`number`|<span class='optional'>선택</span>|서버로 전달될 데이터 구조 설정 **`0`:json 구조로 전달** ex) Data={ \"data\":[ {\"STATUS\":\"Added\",\"ColName1\":\"홍길동\",\"ColName2\":25}, {\"STATUS\":\"Changed\",\"ColName1\":\"심청\",\"ColName2\":18} ]} *단 **reqHeader**속성에 {\"Content-Type\":\"application/json\"}를 추가시 앞에 \"Data=\"이 제거되고 순수하게 json형식만 서버로 전송* **`1`:QueryString 구조 전달** (`default`) ex) STATUS=Added&ColName1=홍길동&ColName2=25&STATUS=Changed&ColName1=심청&ColName2=18 **`2`:열데이터 기준 QueryString 구조 전달** ex) STATUS=Added\\|Changed&ColName1=홍길동\\|심청&ColName2=25\\|18| |reqHeader|`object`|<span class='optional'>선택</span>|전송시 request header에 추가하고자 하는 내용 (ex) {key1:value1, key2:value2}) [Type](/docs/props/col/type)이 file인 셀의 값이 수정된 경우 reqHeader에 Content-Type:application/json을 설정하여도 form으로 전송됩니다. |quest|`boolean`|<span class='optional'>선택</span>|저장시 confirm 메세지 사용 여부 `0(false)`:confirm 메세지 사용 안함 (`default`) `1(true)`:confirm 메세지 사용 ![경고창](/assets/imgs/quest.png \"경고창\")| |sync|`boolean`|<span class='optional'>선택</span>|저장시 동기 여부 `0(false)`:비동기 방식 (`default`) `1(true)`:동기 방식| |validRequired|`boolean`|<span class='optional'>선택</span>|데이터 필수 입력 항목(Required 설정된 열)에 대한 검사 여부 설정. 검사를 통과하지 못할 시 메세지를 띄우며 편집모드 실행. `0(false)`:필수 입력 항목 검사 안함 `1(true)`:필수 입력 항목 검사 실행 (`default`) ![테이블](/assets/imgs/doSaveRequired1.png \"테이블\") ![경고창](/assets/imgs/doSaveRequired2.png \"경고창\")| |saveAttr|`string`|<span class='optional'>선택</span>|각 셀의 속성값을 같이 추출하고자 하는 경우 Name+속성명 형식으로 설정 여러개 속성을 추출하고자 하는 경우 \",\"를 구분자로 작성 ex) \"sNameColor,sNoCanEdit\"| |useLevel|`boolean`|<span class='optional'>선택</span>|Tree기능 사용시 각 행의 Level(Depth)값을 추출되는 데이터에 포함할지 여부 `0(false)`:Level값 데이터 미포함 `1(true)`:Level값 데이터 포함(`default`) 최 상위 노드를 1부터 시작하여 계산하며, \"tLEVEL\"이라는 이름으로 행 데이터에 추가됩니다. \"tLEVEL\"은 각 메세지 파일(ex: ko.js)에서 \"TreeLevelName\"으로 변경할 수 있습니다. Tree기능을 사용하는 시트에서 해당 속성을 `0(false)`로 설정시 `saveMode:0, queryMode:0`을 통해 추출되는 데이터는 계층구조를 갖게 됩니다. `saveMode`를 이용하여 전체 데이터가 아닌 일부 데이터를 추출 할 경우 데이터는 계층 구조를 가지지 않으며 `\"tLEVEL\"` 값은 모두 1이 됩니다.| |questCallback|`function`|<span class='optional'>선택</span>|confirm 메세지 사용시(`quest:true`) Ok, Cancel에 대한 콜백 함수 Ok(확인) : `{result:1}` Cancel(취소) : `{result:2}` | |timeout|`number`|<span class='optional'>선택</span>|서버 통신 최대 대기 시간 (단위: 초(second), `default: 60`)| |traditional|`boolean`|<span class='optional'>선택</span>|서버로 전달될 param 구조 설정 `param: {\"data\": [1, 2]}` 배열 구조 param 전송시 설정 **`0(false)`:[] 을 포함하여 전송** (`default`) ex) `data[]=1&data[]=2` **`1(true)`:[] 없이 전송** ex) `data=1&data=2` | |saveExtraAttr|`boolean`|<span class='optional'>선택</span>|시트에 (col)[Name](/docs/props/col/name)으로 정의하지 않은 데이터가 [doSearch](/docs/funcs/core/do-search)나 [loadSearchData](/docs/funcs/core/load-search-data)함수를 통해 로드 된 경우, 저장시 해당 데이터를 서버로 전송할 지 여부. 로드 데이터 첫번째 행의 keyset을 기준으로 추출됨. `0(false)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 되지 않은 데이터 서버 전송 시 미포함 (`default`) `1(true)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 되지 않은 데이터 서버 전송 시 포함| |validSize|`boolean`|<span class='optional'>선택</span>|사이즈 설정([Size col](/docs/props/col/size))에 대한 유효성 검사 여부 설정. `0(false)`:사이즈 유효성 검사 안함 (`default`) `1(true)`:사이즈 유효성 검사 실행| |validEditMask|`boolean`|<span class='optional'>선택</span>|EditMask 설정([EditMask col](/docs/props/col/edit-mask))에 대한 유효성 검사 여부 설정. `0(false)`:EditMask 유효성 검사 안함 (`default`) `1(true)`:EditMask 유효성 검사 실행| |validResultMask|`boolean`|<span class='optional'>선택</span>|ResultMask 설정([ResultMask col](/docs/props/col/result-mask))에 대한 유효성 검사 여부 설정. `0(false)`:ResultMask 유효성 검사 안함 (`default`) `1(true)`:ResultMask 유효성 검사 실행| ### Return Value ***none*** ### Example ```javascript // 인자가 많으므로 가급적 json 형식으로 사용이 유리함 sheet.doSave({ url:\"./insaAppMain.do\", param:\"dept_cd=031&position_cd=A0\", request:1, quest:1, questCallback:function (evt) { if (evt.result == 2) { alert(\"취소 되었습니다.\"); } } }); ```",
              "see": [
                {
                  "label": "Required col",
                  "url": "/docs/props/col/required"
                },
                {
                  "label": "dataStructure appendix",
                  "url": "/docs/appx/data-structure"
                },
                {
                  "label": "onBeforeSave event",
                  "url": "/docs/events/on-before-save"
                },
                {
                  "label": "onAfterSave event",
                  "url": "/docs/events/on-after-save"
                },
                {
                  "label": "getSaveJson method",
                  "url": "./get-save-json"
                },
                {
                  "label": "getSaveString method",
                  "url": "./get-save-string"
                },
                {
                  "label": "Timeout cfg",
                  "url": "/docs/props/cfg/timeout"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.4|`saveAttr`, `useLevel` 기능 추가||core|8.0.0.5|`timeout` 기능 추가<br>`reqHeader` 설명 추가(`file` 타입 관련)||core|8.0.0.7|`traditional` 기능 추가||core|8.1.0.32|`saveExtraAttr` 기능 추가||core|8.3.0.24|`validSize`, `validEditMask`, `validResultMask` 기능 추가|"
            },
            "url": "docs/funcs/core/do-save.html"
          },
          {
            "cid": 567,
            "sid": "do-search-paging",
            "name": "do-search-paging",
            "label": "doSearchPaging",
            "data": {
              "body": "> 페이징 조회 (cfg [SearchMode](/docs/props/cfg/search-mode) : 3 or 4 or 5)를 사용하는 시트에서만 사용됩니다. > (cfg)[PageLength](/docs/props/cfg/page-length)에서 설정한 건수 만큼 서버에서 데이터를 만들어 리턴해야 합니다. > 조회데이터 JSON 에 `Total` 속성을 통해 전체 데이터의 건수를 갖고 오면 해당 건수만큼 페이지를 나누어 조회 됩니다. > **<mark>주의</mark> : PageLength 값과 서버에서 받아오는 데이터의 갯수를 반드시 동일하게 설정해야 합니다.(PageLength 설정하지 않았을 경우 기본값은 20 입니다)** ### Syntax ```javascript void doSearchPaging( url, pageParam, param, reqHeader, method, callback, timeout, sync, strictParse, traditional, restapi, cPage, pageLengthParam, beforeSend, orderByParam ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |url|`string`|<span class='required'>필수</span>|ajax를 통해 호출할 url| |pageParam|`string`|<span class='optional'>선택</span>|서버로 전송할 페이지 변수 (`default: 'ibpage'`)| |param|`string`\\|`object`|<span class='optional'>선택</span>|서버로 전송할 조회 조건 파라미터| |reqHeader|`object`|<span class='optional'>선택</span>|서버 전송시 request header에 정의할 내용 ex : `{\"callBy\":\"ibsheetObject\",\"method\":\"doSearchPaging\"}`| |method|`string`|<span class='optional'>선택</span>|GET/POST 선택 (`default: 'GET'`)| |callback|`function`|<span class='optional'>선택</span>|조회 후 호출할 콜백 함수| |timeout|`number`|<span class='optional'>선택</span>|서버 통신 최대 대기 시간 (단위: 초(second), `default: 60`)| |sync|`number`|<span class='optional'>선택</span>|동기 조회 여부. 비동기일 경우 연속으로 호출시 이전 조회가 종료되지 않으면 이후의 조회는 무시됩니다. 연속으로 호출해야 되고, 반드시 모든 조회가 완료되어야 한다면 동기 조회 모드를 사용해야 합니다. `0`:비동기 방식 (`default`) `1`:비동기 순차 처리 방식 `2`:동기 방식| |strictParse|`boolean`|<span class='optional'>선택</span>|json 파서 선택 일반적으로 유연한 파싱으로 구동되고 true 설정시에 브라우져의 JSON.parse()를 통해 파싱 `0(false)`:유연한 파서 사용 (`default`) `1(true)`: 브라우저에서 제공하는 JSON.parse() 내장함수 사용| |traditional|`boolean`|<span class='optional'>선택</span>|서버로 전달될 param 구조 설정 `param: {\"data\": [1, 2]}` 배열 구조 param 전송시 설정 **`0(false)`:[] 을 포함하여 전송** (`default`) ex) `data[]=1&data[]=2` **`1(true)`:[] 없이 전송** ex) `data=1&data=2` | |restapi|`boolean`|<span class='optional'>선택</span>|페이지 URL 주소 형식이 REST API 주소형식에 맞게 변경되도록 하는 설정 `0(false)`:페이지 URL 주소 변경 기능 사용 안함 (`default`) `1(true)`:페이지 URL 주소 REST API 주소형식에 맞게 변경 기능 사용 **<mark>주의</mark> : GET 방식으로 보낼 경우 pageParam을 제외한 다른 파라미터들은 전송되지 않음** ex) `/userInfo/users/2`| |cPage| `number`|<span class='optional'>선택</span>|조회 시 처음 보여질 페이지 번호 (1부터 시작)| |pageLengthParam| `string`|<span class='optional'>선택</span>|서버로 전송할 `pageLength` 변수 (`default: 'ibpagelength'`)| |beforeSend|`function`|<span class='optional'>선택</span>|조회 전 호출할 함수 `1(true)` 값을 리턴 시 조회가 취소| |orderByParam|`string`|<span class='optional'>선택</span>|서버로 전송할 소팅 정보 파라미터 변수 (`default: 'iborderby'`)| ### Return Value ***none*** ### Example ```javascript //SearchMode가 3이거나 4이거나 5인 경우 조회 함수 var opt = { \"url\":\"/cust/getCustInfo.do\", \"param\":\"custId=92123&empId=24342\", \"method\":\"POST\", \"beforeSend\":function (rtn) { console.log(rtn.sheet); // 시트 객체 }, \"callback\":function (rtn) { var rtnData = JSON.parse(rtn.data); alert(\"전체 데이터 건수 :\" + rtnData[\"Total\"]); } }; sheet.doSearchPaging(opt); //조회 데이터 예시 { \"Total\":254141 //전체 데이터 건수 \"Data\":[ {},...,{} //PageLength에서 설정한 건수만큼 조회 ] } ```",
              "see": [
                {
                  "label": "dataStructure appendix",
                  "url": "/docs/appx/data-structure"
                },
                {
                  "label": "SortCurrentPage cfg",
                  "url": "/docs/props/cfg/sort-current-page"
                },
                {
                  "label": "Timeout cfg",
                  "url": "/docs/props/cfg/timeout"
                },
                {
                  "label": "PageLength cfg",
                  "url": "/docs/props/cfg/page-length"
                },
                {
                  "label": "StrictParse cfg",
                  "url": "/docs/props/cfg/strict-parse"
                },
                {
                  "label": "onReceiveData event",
                  "url": "/docs/events/on-receive-data"
                },
                {
                  "label": "onDataLoad event",
                  "url": "/docs/events/on-data-load"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.5|`timeout` 인자 추가||core|8.0.0.6|`sync` 인자 추가||core|8.0.0.7|`strictParse` 인자 추가||core|8.0.0.7|`traditional` 인자 추가||core|8.0.0.7|`restapi` 인자 추가||core|8.0.0.20|`cPage` 인자 추가||core|8.1.0.41|`pageLengthParam` 인자 추가||core|8.1.0.49|`beforeSend` 인자 추가|"
            },
            "url": "docs/funcs/core/do-search-paging.html"
          },
          {
            "cid": 568,
            "sid": "do-search",
            "name": "do-search",
            "label": "doSearch",
            "data": {
              "body": "> ajax 통신을 통해 json형식의 데이터를 가져와 시트에 로드합니다. > 비동기형식으로 동작하므로, 데이터 로드 이후에 대한 처리는 [onSearchFinish](/docs/events/on-search-finish) 이벤트에서 로직을 구성하셔야 합니다. ### Syntax ```javascript void doSearch( url, param, method, append, reqHeader, callback, timeout, sync, next, strictParse, traditional ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |url|`string`|<span class='required'>필수</span>|ajax를 통해 호출할 url| |param|`string`\\|`object`|<span class='optional'>선택</span>|서버로 전송할 파라미터| |method|`string`|<span class='optional'>선택</span>| 전송방식 GET / POST 선택 (`default: 'GET'`)| |append|`boolean`|<span class='optional'>선택</span>|기존 데이터에 `append` 여부 조회 방식의 차이로 인해 `append:1(true)`사용 시 [SearchMode](/docs/props/cfg/search-mode):2인 경우 [onRenderFinish](/docs/events/on-render-finish)이벤트가 발생하지 않습니다. `0(false)`:기존 데이터 제거 후 조회 데이터 로드 (`default`) `1(true)`:기존 데이터에 조회 데이터 추가| |reqHeader|`object`|<span class='optional'>선택</span>|서버 전송시 request header에 정의할 내용 ex : `{\"callBy\":\"ibsheetObject\",\"method\":\"doSearch\"}`| |callback|`function`|<span class='optional'>선택</span>|조회 후 호출할 콜백 함수| |timeout|`number`|<span class='optional'>선택</span>|서버 통신 최대 대기 시간 (단위: 초(second), `default: 60`)| |sync|`number`|<span class='optional'>선택</span>|동기 조회 여부. 비동기일 경우 연속으로 호출시 이전 조회가 종료되지 않으면 이후의 조회는 무시됩니다. 연속으로 호출해야 되고, 반드시 모든 조회가 완료되어야 한다면 동기 조회 모드를 사용해야 합니다. `0`:비동기 방식 (`default`) `1`:비동기 순차 처리 방식 `2`:동기 방식| |next|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) 지정한 행 위에부터 데이터 `append`. (`append:1(true)`일때만 사용 가능)| |strictParse|`boolean`|<span class='optional'>선택</span>|json 파서 선택 일반적으로 유연한 파서를 통해 JSON데이터를 파싱하고, true 설정시에 브라우져의 JSON.parse()를 통해 파싱 `0(false)`:유연한 파서 사용 (`default`) `1(true)`: 브라우저에서 제공하는 JSON.parse() 내장함수 사용| |traditional|`boolean`|<span class='optional'>선택</span>|서버로 전달될 param 구조 설정 `param: {\"data\": [1, 2]}` 배열 구조 param 전송시 설정 **`0(false)`:[] 을 포함하여 전송** (`default`) ex) `data[]=1&data[]=2` **`1(true)`:[] 없이 전송** ex) `data=1&data=2` | |parent|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object) (동적 트리 조회 사용시 부모에 해당하는 행 지정) | 유연한 파서란 일반적인 JSON.parse()를 통해 파싱하는 경우 허용하지 않는 몇가지를 허용합니다. 1. 여분의 콤마 허용 2. 프로퍼티 이름의 쌍따옴표가 없어도 됨. 참고 - [MDN:bad parsing](https://developer.mozilla.org/ko/docs/Web/JavaScript/Reference/Errors/JSON_bad_parse) - JSON.parse()가 유연한 파싱보다 성능이 우수(약 5배)하지만 데이터 로딩과정에서 파싱이 차지하는 시간이 크지 않아 5만건 이내에서는 사용자가 느끼기 어려운 수준임. ### Return Value ***none*** ### Example ```javascript // GET 방식으로 데이터 조회 sheet.doSearch(\"./insaAppMain.do\", \"dept_cd=031&position_cd=A0\", \"GET\"); // POST 방식으로 데이터 조회 var opt = { url: \"./insaAppMain.do\", param: {\"dept_cd\": 031, \"position_cd\": \"A0\"}, method: \"POST\", reqHeader: {\"Content-Type\":\"application/json\"} }; sheet.doSearch(opt); ```",
              "see": [
                {
                  "label": "dataStructure appendix",
                  "url": "/docs/appx/data-structure"
                },
                {
                  "label": "loadSearchData method",
                  "url": "./load-search-data"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "./do-search-paging"
                },
                {
                  "label": "onReceiveData event",
                  "url": "/docs/events/on-receive-data"
                },
                {
                  "label": "onBeforeDataLoad event",
                  "url": "/docs/events/on-before-data-load"
                },
                {
                  "label": "onDataLoad event",
                  "url": "/docs/events/on-data-load"
                },
                {
                  "label": "onSearchFinish event",
                  "url": "/docs/events/on-search-finish"
                },
                {
                  "label": "Timeout cfg",
                  "url": "/docs/props/cfg/timeout"
                },
                {
                  "label": "StrictParse cfg",
                  "url": "/docs/props/cfg/strict-parse"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.4|다른 API와 동일하게 제공하기 위해 `params` 인자명을 `param`으로 변경, 기존의 `params`를 사용할 수 있지만 권장하지 않음.||core|8.0.0.5|`timeout` 인자 추가||core|8.0.0.6|`sync` 인자 추가||core|8.0.0.7|`next` 인자 추가||core|8.0.0.7|`strictParse` 인자 추가||core|8.0.0.7|`traditional` 인자 추가||core|8.0.0.25|`parent` 인자 추가|"
            },
            "url": "docs/funcs/core/do-search.html"
          },
          {
            "cid": 569,
            "sid": "do-sort",
            "name": "do-sort",
            "label": "doSort",
            "data": {
              "body": "> 지정한 열들을 함수를 통해 소팅 합니다. > `doSort`는 비동기로 동작합니다. > 소계에서 `doSort` 사용시 `stdCol`은 소팅되지 않습니다. ### Syntax ```javascript void doSort( sortcols ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |sortcols|`string`|<span class='required'>필수</span>|소팅할 열이름을 `\",\"`를 구분자로 순서대로 입력 (열이름만 쓰면 오름차순, 열이름 앞에 `\"-\"`기호를 붙이면 내림차순이 됨) ### Return Value ***none*** ### Example ```javascript //부서를 내림차순으로 이름을 오름차순으로 정렬 sheet.doSort(\"-dempNm,empNm\"); ```",
              "see": [
                {
                  "label": "clearSort method",
                  "url": "./clear-sort"
                },
                {
                  "label": "onBeforeSort event",
                  "url": "/docs/events/on-before-sort"
                },
                {
                  "label": "onAfterSort event",
                  "url": "/docs/events/on-after-sort"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/do-sort.html"
          },
          {
            "cid": 570,
            "sid": "enable",
            "name": "enable",
            "label": "enable",
            "data": {
              "body": "> 비활성화 된 시트를 다시 활성화 시킵니다. ### Syntax ```javascript void enable( ); ``` ### Return Value ***none*** ### Example ```javascript //시트를 활성화 sheet.enable(); ```",
              "see": [
                {
                  "label": "disable method",
                  "url": "./disable"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/enable.html"
          },
          {
            "cid": 571,
            "sid": "end-edit",
            "name": "end-edit",
            "label": "endEdit",
            "data": {
              "body": "> 셀의 편집을 종료합니다. > 편집 중이던 내용이 메모리에 저장되고 편집 상태가 종료됩니다. > 호출시 [onEndEdit](/docs/events/on-end-edit)이벤트가 발생합니다. ### Syntax ```javascript mixed endEdit(save); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |save|`boolean`|<span class='optional'>선택</span>|편집 종료시 현재 값을 반영할지 여부를 설정합니다. `0(false)`:수정 중인 데이터를 반영하지 않고 편집 상태를 종료 (`default`) `1(true)`:수정 중인 데이터를 반영하며 편집 상태를 종료| ### Return Value ***mixed*** |returnValue|Description| |---|---| |`null`|편집중이지 않은 경우| |`0(false)`|기존과 동일한 값이어서 내용 변경이 없는 경우| |`1(true)`|정상적으로 편집중인 값이 반영됨| |`-1`|수정한 값에 문제가 있어 편집이 종료되지 못한 경우(잘못된 날짜 입력 등)| ### Example ```javascript //편집 종료 sheet.endEdit(1); ```",
              "see": [
                {
                  "label": "onEndEdit event",
                  "url": "/docs/events/on-end-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/end-edit.html"
          },
          {
            "cid": 572,
            "sid": "export-data-buffer",
            "name": "export-data-buffer",
            "label": "exportDataBuffer",
            "data": {
              "body": "> 여러개의 `ibsheet`를 하나의 엑셀파일에 다운로드 하고자 할때 사용됩니다. > `exportDataBuffer(1(true))`로 실행하면 이후 각 시트에서 [exportData](./export-data)를 호출하더라도 다운로드가 이루어지지 않고, `exportDataBuffer(0(false))` 호출하는 순간 각 시트의 내용이 엑셀파일 안에 각기 다른 worksheet에 다운로드 됩니다. > 해당 기능을 이용하여 하나의 시트로 여러개의 워크시트를 갖는 엑셀파일을 만드는 것도 가능합니다. ### Syntax ```javascript void exportDataBuffer( isBuffer ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |isBuffer|`boolean`|<span class='required'>필수</span>|버퍼링 여부 `0(false)`:버퍼링 사용 안함 (`default`) `1(true)`:버퍼링 사용| ### Return Value ***none*** ### Example ```javascript //1. 일반적인 사용 방법 //버퍼링 시작 sheet1.exportDataBuffer(true); //첫번째 시트 데이터 버퍼링 var param1 = { fileName:\"여행경비 내역.xlsx\", sheetName:\"교통비\" //엑셀파일내 워크시트 명 }; sheet1.exportData(param1); //두번째 시트 데이터 버퍼링 var param2 = { sheetName:\"식비\" //엑셀파일내 워크시트 명 }; sheet2.exportData(param2); //세번째 시트 데이터 버퍼링 var param3 = { sheetName:\"숙박비/기타\" //엑셀파일내 워크시트 명 }; sheet3.exportData(param3); //전체 시트 다운로드(실제 다운로드가 시작됨) sheet1.exportDataBuffer(false); //2. 하나의 시트에서 컬럼별로 나누어 엑셀파일을 생성 //버퍼링 시작 sheet.exportDataBuffer(true); //4개 컬럼만 첫번째 워크시트로 다운 var param1 = { sheetName:\"12분기\", downCols:\"1QTCost|1QTProfit|2QTCost|2QTProfit\" }; sheet.exportData(param1); //나머지 컬럼을 두번째 워크시트로 다운 var param2 = { sheetName:\"34분기 및 종합\" downCols:\"3QTCost|3QTProfit|4QTCost|4QTProfit|Total|Summary\" }; sheet.exportData(param2); //버퍼링 종료 (실제 다운로드가 시작됨) sheet.exportDataBuffer(false); ```",
              "see": [
                {
                  "label": "exportData method",
                  "url": "./export-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.24|기능 추가|"
            },
            "url": "docs/funcs/core/export-data-buffer.html"
          },
          {
            "cid": 573,
            "sid": "export-data",
            "name": "export-data",
            "label": "exportData",
            "data": {
              "body": "> 시트의 내용을 엑셀 파일로 다운로드 합니다. > 해당 함수를 사용하시려면 `jszip` 라이브러리가 반드시 필요합니다. > 기본적으로 `jszip` 라이브러리가 있는 경우, 그것을 그대로 사용하게 되고 `jszip` 라이브러리가 없는 경우, `plugins/jszip.min.js` 라이브러리를 가져와 사용합니다. > [down2Excel](/docs/funcs/excel/down-to-excel) 과 동일한 기능(서버에서 처리하는 기능을 제외하고)을 제공합니다. (`xlsx 기준`) > 지원 하는 파일 형식은 **xlsx, txt, csv** 입니다. > > 해당 함수는 [down2Text](/docs/funcs/excel/down-to-text) 에서 사용되는 기능 또한 제공됩니다. (`colDelim, rowDelim, downSum`) ### Syntax ```javascript void exportData( param ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |fileName|`string`|<span class='optional'>선택</span>|생성할 엑셀파일 명 (`default: Excel.xlsx`) **이 속성에서 파일명과 함께 확장자를 xlsx, txt, csv로 붙이느냐에 따라서 생성 파일이 xlsx형식, (txt, csv)형식으로 만들어집니다.** 해당 속성 사용시에는 확장자를 입력해야 적용된 파일이 다운로드 됩니다.| |sheetName|`string`|<span class='optional'>선택</span>|만들어지는 엑셀 파일의 WorkSheet에 부여할 이름 `(xlsx에서만 지원)`| |downRows|`string`|<span class='optional'>선택</span>|지정한 행만 다운로드 합니다. 별도의 설정이 없을시 모든 행이 다운로드 됩니다. 보여지는 행만 다운로드하고 싶을 경우 `\"Visible\"`로 설정하면 됩니다. (ex: \"1\\|3\\|4\\|5\\|9\" 식의 문자열) `downRows`를 사용하면 머지 기능이 동작하지 않습니다.| |downCols|`string`|<span class='optional'>선택</span>|지정한 열만 다운로드 합니다. 별도의 설정이 없을시 모든 열이 다운로드 됩니다. 보여지는 열만 다운로드하고 싶을 경우 `\"Visible\"`로 설정하면 됩니다. (ex: \"Price\\|AMT\\|TOTAL\" 식의 문자열)| |downTreeHide|`boolean`|<span class='optional'>선택</span>|tree를 사용하는 경우, 접혀진 행도 엑셀에 다운로드 할지 여부를 설정합니다. `1(true)`로 설정시 접혀있는 자식노드도 모두 다운로드 됩니다.(`default: 0(false)`)| |downHeader|`boolean`|<span class='optional'>선택</span>|헤더행을 다운로드 할지 여부를 설정합니다.(`default: 1(true)`)| |sheetDesign|`number`|<span class='optional'>선택</span>|시트의 디자인 요소를 엑셀에도 반영할지 여부를 설정합니다. 반영되는 디자인 요소는 다음과 같습니다: 헤더의 배경색,폰트명,폰트크기,데이터 배경색 `0`: 셀 외곽선을 제외한 모든 디자인을 적용하지 않습니다. `1`: 셀 외곽선을 포함해 모든 디자인을 적용합니다. (default) `2`: 셀 외곽선을 제외한 셀 스타일을 적용합니다. `3`: 셀 외곽선 및 스타일을 모두 적용하지 않습니다.`(xlsx에서만 지원)` `4`: 헤더행에만 모든 디자인을 적용합니다. |titleText|`string`|<span class='optional'>선택</span>|엑셀 문서의 상단에 원하는 문자를 추가합니다. 문자는 열구분자(\"\\|\")와 행구분자(`\"\\r\\n\"`)을 통해서 작성하실수 있습니다. 가령 \"A\\|B\\|C\\r\\nD\\|E\\|F\" 와 같이 입력한 경우 첫 행에 3개의 셀에 각각 A, B, C 값이 들어가고 두번째 행의 3개의 셀에 각각 D, E, F 값이 입력됩니다. 값 안에서 엔터를 포함하려면 `\"\\r\"` 이나 `\"\\n\"` 을 삽입하면 됩니다. `\"\\r\\n\"` 이 10개가 포함되면 11줄을 차지하게 되고 12번째 행부터 시트 내용이 출력됩니다. `(xlsx에서만 지원)`| |userMerge|`string`|<span class='optional'>선택</span>|`titleText`와 같이 사용하며, titleText를 원하는 모양으로 머지합니다. 입력방법은 4개의 숫자로 `\"머지시작셀 row index, 머지시작셀 col index, 아래로 병합할 행 개수(1을 설정하면 병합 없음), 우측으로 병합할 개수\"` 로 이루어 집니다. (여러개 병합시에는 띄어쓰기로 구분) 가령 `\"2,2,1,6 3,2,3,3\"`위와 같이 설정하였다면 2,2 셀부터 오른쪽으로 6칸이 병합되고, 3,2 셀부터 아래로 3칸, 오른쪽으로 3칸이 병합 됩니다. `(xlsx에서만 지원)` ![userMerge](/assets/imgs/userMerge.png)| |excelRowHeight|`number`|<span class='optional'>선택</span>|엑셀 문서의 행 높이를 설정합니다. -1 설정시 셀의 내용물 크기에 맞춰 엑셀 문서의 행 높이가 조절됩니다. `(xlsx에서만 지원)`| |excelHeaderRowHeight|`number`|<span class='optional'>선택</span>|엑셀의 헤더행의 높이를 설정합니다. `(xlsx에서만 지원)`| |wordWrap|`boolean`|<span class='optional'>선택</span>|엑셀 문서의 \"텍스트 줄바꿈\" 여부를 설정합니다.(`default: 1(true)`) `(xlsx에서만 지원)`| |comboValidation|`boolean`|<span class='optional'>선택</span>|Enum 타입으로 만들어진 열에 대해 엑셀에서도 데이터 기능을 통해 드롭다운리스트 형태로 표현합니다. `(xlsx에서만 지원)`| |rowDelim|`string`|<span class='optional'>선택</span>|text파일을 만들때 행 구분자(기본은 줄넘김 문자 `\"\\r\\n\"`) `(txt, csv)에서만 지원` |colDelim|`string`|<span class='optional'>선택</span>|txt 다운로드 일 경우(`default: \\t(탭문자)`, csv 다운로드 일 경우(`default: ,(콤마)` 업로드되는 파일에 따라 기본 구분자가 변경됩니다. `(txt, csv)에서만 지원` |hiddenColumn|`boolean`|<span class='optional'>선택</span>|숨은 컬럼들을 엑셀로 다운로드 받은 경우, 해당 컬럼이 눈에 보이지는 않지만 엑셀 메뉴중 \"숨기기 취소\"를 선택한 경우 해당 컬럼이 다시 보일 수 있도록 엑셀 문서에 다운로드 받는다. `hiddenColumn:1` 은 `downCols`와 **절대 같이 사용하시면 안됩니다.** `0(false)`: 엑셀 다운로드 시 감춰진 열도 Visible:1 컬럼과 동일하게 일반 컬럼처럼 표현됨 (`default`) `1(true)`:감춰진 열 다운로드 시 \"열 숨기기\" 형태로 엑셀 다운로드| |merge|`number`|<span class='optional'>선택</span>|시트의 머지 상태를 엑셀에 그대로 반영할지를 설정합니다. `0`: 사용 안 함 (`default`) `1`: 사용함 (셀 병합 시, 부속 셀의 값을 원본으로 유지함) `2`: 사용함 (셀 병합 시, 부속 셀의 값을 비움) `(xlsx에서만 지원)`| |textToGeneral|`boolean`|<span class='optional'>선택</span>|Type:`Text`의 엑셀 서식 형식 `0(false)`: Type:`Text`의 엑셀 서식을 텍스트 서식으로 지정 `1(true)`: Type:`Text`의 엑셀 서식을 일반 서식으로 지정(`default`)| |allTypeToText|`boolean`|<span class='optional'>선택</span>|시트의 `Int`, `Float` 타입을 제외한 모든 컬럼의 엑셀 서식을 `Text` 타입으로 받고자 하는 경우 설정합니다.(`default: 0(false)`) `(xlsx에서만 지원)`| |checkBoxOnValue|`string`|<span class='optional'>선택</span>|체크박스와 라디오 박스에서 체크를 한 경우 `1`값 대신 지정한 값을 사용합니다. `(xlsx에서만 지원)`| |checkBoxOffValue|`string`|<span class='optional'>선택</span>|체크박스와 라디오 박스에서 체크 해제를 한 경우 `0`값 대신 지정한 값을 사용합니다. `(xlsx에서만 지원)`| |downSum|`boolean`|<span class='optional'>선택</span>|합계 행 다운로드 여부를 설정합니다.(`default: 1(true)`)| |excelFontSize|`number`|<span class='optional'>선택</span>|엑셀의 폰트 크기를 설정합니다. `(xlsx에서만 지원)`| |excludeFooterRow|`boolean`|<span class='optional'>선택</span>|푸터 행 제외 여부를 설정합니다.(`default: 0(false)`) `(xlsx에서만 지원)`| |numberTypeToText|`boolean`|<span class='optional'>선택</span>|`Int`, `Float` 타입의 컬럼을 `Text` 타입으로 다운로드 받을지 여부를 설정합니다.(`default: 0(false)`) `(xlsx에서만 지원)`| |excelFontFamily|`string`|<span class='optional'>선택</span>|엑셀의 폰트를 설정합니다. `(xlsx에서만 지원)`| |exHead|`array[object]`|<span class='optional'>선택</span>|시트 상단에 표시하고 싶은 내용을 설정합니다. **titleText 속성과 같이 사용할 수 없으며, 같이 사용시 titleText속성은 무시됩니다.**`(xlsx에서만 지원)`| |exFoot|`array[object]`|<span class='optional'>선택</span>|시트 하단에 표시하고 싶은 내용을 설정합니다.`(xlsx에서만 지원)` |appendPrevSheet|`boolean`|<span class='optional'>선택</span>|[exportDataBuffer](./export-data-buffer) 메소드를 사용하여 2개 이상의 시트를 엑셀로 다운로드 할 때 마지막으로 작성한 워크시트에 해당 옵션이 적용된 시트를 덧붙일지 여부를 설정합니다. `0(false)`: 워크시트를 새로 생성하여 작성합니다.(`default`) `1(true)`: 마지막으로 작성한 워크시트에 시트를 덧붙입니다. `(xlsx에서만 지원)`| |onlyHeaderMerge|`boolean`|<span class='optional'>선택</span>|`1(true)`로 설정 시, 시트의 데이터 영역의 머지를 강제로 제한하고 헤더 영역의 머지만을 엑셀에 반영합니다.(`default: 0(false)`)| |freezePane|`number`|<span class='optional'>선택</span>|상단 행과 왼쪽 열을 틀 고정하여 다운로드하는 옵션입니다. 옵션 설정에 따라 다르게 틀 고정이 적용되어 다운로드되며, 비트 연산으로 동작합니다. `0`: 틀 고정을 적용하지 않음(`default`) `1`: 헤더 틀 고정 적용 (`2`과 함께 적용시 헤드 영역 틀 고정으로 동작) `2`: 헤드 영역 틀 고정 적용 `4`: 왼쪽 고정 열 틀 고정 적용| |numberFormatMode|`number`|<span class='optional'>선택</span>|실수 형태의 데이터 타입에 대한 셀 서식 설정 방식을 설정합니다. `0`:시트의 컬럼 포맷을 따릅니다. (`default`) `1`:셀의 값 기준에 따라 정수 또는 실수 형태로 셀 서식을 설정합니다. `2`:일반 서식으로 설정합니다.| ### exHead,exFoot options |Name|Type|Required|Description| |----------|-----|---|----| |Height|`number`|<span class='optional'>선택</span>|행의 높이| |Cells|`array[object]`|<span class='optional'>선택</span>|행의 각셀에 표시될 내용,속성 설정| |Cells[{Value}]|`string`|<span class='optional'>선택</span>|셀에 표시될 내용| |Cells[{Color}]|`string`|<span class='optional'>선택</span>|셀의 배경색 (ex `#FFDDEE`)| |Cells[{TextColor}]|`string`|<span class='optional'>선택</span>|셀의 글자색 (ex `#446622`)| |Cells[{TextSize}]|`number`|<span class='optional'>선택</span>|셀의 글자 크기| |Cells[{TextStyle}]|`number`|<span class='optional'>선택</span>|셀의 글자 style ([참고](/docs/props/cell/text-style))| |Cells[{TextFont}]|`string`|<span class='optional'>선택</span>|셀의 글자 family ([참고](/docs/props/cell/text-font))| |Cells[{Wrap}]|`boolean`|<span class='optional'>선택</span>|자동 줄바꿈 여부(default: true)| |Cells[{Type}]|`string`|<span class='optional'>선택</span>|셀타입(Image를 사용해야 하는 경우에만 Img로 설정)| |Cells[{ColSpan}]|`number`|<span class='optional'>선택</span>|가로 병합 셀 개수(default: 1)| |Cells[{RowSpan}]|`number`|<span class='optional'>선택</span>|세로 병합 셀 개수(default: 1)| |Cells[{BorderTop}]|`string`|<span class='optional'>선택</span>|`상단 보더` 굵기,스타일,색상을 구분자 \" \"로 연결한 문자열 (ex: \"1 solid #FF0000\")| |Cells[{BorderBottom}]|`string`|<span class='optional'>선택</span>|`하단 보더` 굵기,스타일,색상을 구분자 \" \"로 연결한 문자열 (ex: \"1 solid #FF0000\")| |Cells[{BorderLeft}]|`string`|<span class='optional'>선택</span>|`좌측 보더` 굵기,스타일,색상을 구분자 \" \"로 연결한 문자열 (ex: \"1 solid #FF0000\")| |Cells[{BorderRight}]|`string`|<span class='optional'>선택</span>|`우측 보더` 굵기,스타일,색상을 구분자 \" \"로 연결한 문자열 (ex: \"1 solid #FF0000\")| #### Cells 내에 Border 속성 설정시 주의 사항 1. 굵기는 px단위가 아닌 1은 가늘게 2는 굵게 표시 스타일은 `solid`,`dashed`,`dotted` 제공 색상은 hex code로 설정 (ex `#FF00FF`) 2. 좌우로 붙어있는 셀에 각각 우측보더와 좌측보더를 다르게 설정시 우측셀에 설정한 좌측 보더값이 적용됨 상하로 붙어있는 셀에 각각 하단보더와 상단보더를 다르게 설정시 하단셀에 설정하 상단 보더값이 적용됨 3. RowSpan,ColSpan속성으로 통해 병합 된 셀이라도 각 셀별로 보더 설정이 필요함 ### Return Value ***none*** ### Example ```javascript // xlsx 확장자로 다운로드, 보여지는 행만 다운로드. sheet.exportData({fileName: \"재고리스트.xlsx\",downRows: \"Visible\"}); // txt 확장자로 다운로드, 열 구분자 ',' 로 변경. var param = {fileName: \"exportTEXT.txt\", colDelim: \",\"}; sheet.exportData(param); // csv 확장자로 다운로드, 합계행 다운받지 않음. var param = {fileName: \"exportCSV.csv\", downSum: 0} sheet.exportData(param); ``` ```javascript //exHead 사용 예제 var param = { sheetDesign: 1, merge: 1, fileName: '22년도_근무외수당.xlsx' }; param[\"exHead\"] = [ { // 첫번째 행 Height: 30, Cells:[ { // 첫번째 셀에 이미지 설정 Type:\"Img\", Value:\"|/assets/imgs/logo.png|78|28\" }, {},{},{},{},{},{},{}, //7칸 빈셀 { Type:\"Text\", Value:\"(취급주의)대외비\", TextColor:\"#FF0000\", Wrap: 0, TextSize: 14 } ] }, { // 두번째 행 Height: 40, Cells:[ {}, //첫칸 빈셀 { Type:\"Text\", Align: \"Center\", Value: \"2022년 근무 외 수당 청구 내역\", Color:\"#DEDEDE\", TextSize: 45, TextStyle: 1, BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\", BorderLeft:\"2 dashed #0000FF\", ColSpan: 8 }, { BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\" }, { BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\" }, { BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\" }, { BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\" }, { BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\" }, { BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\" }, { BorderTop:\"2 dashed #0000FF\", BorderBottom:\"2 dashed #0000FF\", BorderRight:\"2 dashed #0000FF\" } ] }, {}, // 3번째 행 (빈행) {// 4번째 행 Cells:[ { Value:\"부서\", Align:\"Right\", Color:\"#DEDEDE\", BorderTop:\"1 solid #222222\", BorderRight:\"1 solid #222222\", BorderBottom:\"1 solid #222222\", BorderLeft:\"1 solid #222222\", },{ ColSpan: 3, Value:\"총무부\", Align:\"Left\", BorderTop:\"1 solid #222222\", BorderRight:\"1 solid #222222\", BorderBottom:\"1 solid #222222\", BorderLeft:\"1 solid #222222\", }, { BorderTop:\"1 solid #222222\", BorderBottom:\"1 solid #222222\" }, { BorderTop:\"1 solid #222222\", BorderBottom:\"1 solid #222222\", BorderRight:\"1 solid #222222\" } ] }, {// 5번째 행 Cells:[ { Value:\"기간\", Align:\"Right\", Color:\"#DEDEDE\", BorderTop:\"1 solid #222222\", BorderRight:\"1 solid #222222\", BorderBottom:\"1 solid #222222\", BorderLeft:\"1 solid #222222\", }, { ColSpan: 3, Value:\"2022/01/01 ~ 2022/12/31\", Align:\"Left\", BorderTop:\"1 solid #222222\", BorderBottom:\"1 solid #222222\", BorderLeft:\"1 solid #222222\", }, { BorderTop:\"1 solid #222222\", BorderBottom:\"1 solid #222222\" }, { BorderTop:\"1 solid #222222\", BorderBottom:\"1 solid #222222\", BorderRight:\"1 solid #222222\" } ] } ]; param[\"exFoot\"] = [ {}, //첫번째 행 (빈행) { Height:30, Cells:[ { Value: \"출력: 2023-06-23 홍길동\", Align: \"Left\", Wrap: 0 } ] } ]; sheet.exportData(param); ``` ![exHead,exFoot](/assets/imgs/exportDataExHeadExFoot.png \"exHead,exFoot\") ### `downCols, downRows` 사용시 `merge` 적용 정리 | downCols |화면과 동일하게 컬럼 설정 | 화면과 다르게 컬럼 설정 | | ------ | ------ | ------ | | downRows 사용| X | X | | downRows 사용 안함 | O | 아래 설명 참고| merge 옵션을 적용해 downCols를 사용하시려면 downCols에 머지가 이뤄진 컬럼을 **순서대로** **모두** 포함하고 있어야만 합니다. **Visible: 0이 설정된 컬럼이 있다면 해당 컬럼도 반드시 downCols에 포함해둬야만 합니다.** 머지가 이뤄진 컬럼 중 특정 컬럼이 빠지거나, 머지가 이뤄진 컬럼을 모두 포함하고 있더라도 다운로드받는 컬럼의 순서가 다르면 엑셀 다운시 머지가 정상적으로 이뤄지지 않습니다. ![downCols사용시 머지](/assets/imgs/downcols_merge.png \"downCols사용시 머지\") 이미지로 예를 들자면, \"머지 컬럼\" 컬럼을 온전히 머지가 적용된 채로 다운로드받고 싶다면 downCols: \"컬럼1|컬럼2|컬럼3|컬럼4\"와 같이 설정하셔야 합니다. downCols: \"컬럼2|컬럼3|컬럼4\"와 같이 특정 컬럼을 제외하거나 downCols: \"컬럼4|컬럼1|컬럼3|컬럼2\"와 같이 컬럼 순서를 바꾸시면 머지가 온전히 적용되지 않습니다. ### 템플릿 파일을 활용한 엑셀 파일 다운로드 `tempFile` 옵션은 미리 서버에 템플릿을 준비해둔 뒤, 해당 템플릿에 시트 데이터만 삽입해 엑셀 파일을 다운로드하고 싶으실 때 사용하는 옵션입니다. 템플릿 기능을 사용하시려면 `Down2Excel.jsp`또는 `Down2Excel.aspx`에 미리 `TempRoot` 설정을 이용해 템플릿 파일 폴더 위치를 지정해주셔야 됩니다. `startRow`, `startCol` 옵션으로 템플릿 파일에서 데이터를 작성하기 시작할 위치를 지정하실 수 있으며, `sheetNo` 옵션으로 템플릿 파일에서 데이터를 작성할 워크시트를 지정하실 수 있습니다. 더불어 `tempFile` 옵션을 이용해 엑셀 파일을 다운로드받는 경우, 디자인은 온전히 템플릿 파일에 설정된 디자인을 따라가게 되며 `excelFontSize`, `excelRowHeight`, `sheetDesign` 등 옵션은 무시됩니다.",
              "see": [
                {
                  "label": "importData method",
                  "url": "./import-data"
                },
                {
                  "label": "AutoExcelMode cfg",
                  "url": "/docs/props/cfg/auto-excel-mode"
                },
                {
                  "label": "LevelMark cfg",
                  "url": "/docs/props/cfg/level-mark"
                },
                {
                  "label": "down2Excel method",
                  "url": "/docs/funcs/excel/down-to-excel"
                },
                {
                  "label": "down2Text method",
                  "url": "/docs/funcs/excel/down-to-text"
                },
                {
                  "label": "onBeforeExport event",
                  "url": "/docs/events/on-before-export"
                },
                {
                  "label": "onExportFinish event",
                  "url": "/docs/events/on-export-finish"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.6|`fileName`, `sheetName`, `downRows`, `downCols`, `downRows`, `downTreeHide`, `downHeader`, `sheetDesign`, `titleText`, `userMerge`, `excelRowHeight`, `excelHeaderRowHeight`, `wordWrap`, `comboValidation`, `rowDelim`, `colDelim`, `downSum` 기능 추가||core|8.0.0.20|파일 형식 내용 추가||core|8.0.0.21|`merge`, `allTypeToText`, `checkBoxOnValue`, `checkBoxOffValue`, `excelFontSize`, `excludeFooterRow`, `numberTypeToText` (xlsx 에서만 지원)||core|8.0.0.29|`excelFontFamily` 기능 추가 (xlsx 에서만 지원)||core|8.1.0.30|`exHead`,`exFoot` 기능 추가 (xlsx 에서만 지원)||core|8.1.0.39|`excelRowHeight : -1` 설정 추가||core|8.1.0.41|`sheetDesign : 4` 설정 추가||core|8.1.0.83|`appendPrevSheet` 설정 추가 (exportDataBuffer 사용시에만 사용 가능)||core|8.2.0.5|`onlyHeaderMerge` 설정 추가||core|8.2.0.11|`hiddenColumn` 설정 추가||core|8.2.0.25|`freezePane` 설정 추가||core|8.3.0.16|`numberFormatMode` 설정 추가|"
            },
            "url": "docs/funcs/core/export-data.html"
          },
          {
            "cid": 574,
            "sid": "extract-data-text",
            "name": "extract-data-text",
            "label": "extractDataText",
            "data": {
              "body": "> 시트의 헤더를 포함한 모든 데이터를 문자열로 반환합니다. > 컬럼과 컬럼 사이는 탭(`\\t`)으로 행과 행사이는 줄바꿈(`\\r\\n`) 문자열로 구분하여 반환 합니다. > **<mark>주의</mark> : 데이터 건수가 많아질수록 성능에 문제가 발생할 수 있습니다.** ### Syntax ```javascript string extractDataText( excludeHideData ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |excludeHideData|`boolean`|<span class='optional'>선택</span>|숨겨진 컬럼, 데이터는 제외하고 반환 여부 `0(false)`:숨겨진 컬럼, 데이터 포함 (`default`) `1(true)`:숨겨진 컬럼, 데이터 제외| ### Return Value ***string*** : 시트의 모든 데이터 (Header, Head, Data, Foot, FormulaRow) ### Example ```javascript // 시트의 모든 데이터를 문자열로 반환 var txt = sheet.extractDataText(); // 숨겨진 컬럼, 데이터는 제외 var txt = sheet.extractDataText( {excludeHideData:1 } ); ``` ### Since |product|version|desc| |---|---|---| |core|8.2.0.6|기능 추가| |core|8.2.0.7|`excludeHideData` 인자 추가|",
              "since": "|product|version|desc||---|---|---||core|8.2.0.6|기능 추가||core|8.2.0.7|`excludeHideData` 인자 추가|"
            },
            "url": "docs/funcs/core/extract-data-text.html"
          },
          {
            "cid": 575,
            "sid": "find-rows",
            "name": "find-rows",
            "label": "findRows",
            "data": {
              "body": "> 시트에서 검색 식([SearchExpression](/docs/props/cfg/search-expression))에 알맞은 데이터를 찾아 선택, 마킹, 포커스 등 처리할 수 있습니다. ### Syntax ```javascript void findRows( action, match, callback ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |action|`string`|<span class='required'>필수</span>| 검색 기능(action)을 설정합니다.| |match|`boolean`|<span class='optional'>선택</span>| 전체 셀 내용이 일치할 경우만 검색 대상에 포함합니다. `0(false)`:데이터에서 찾을 데이터가 포함 된 경우 (`default`) `1(true)`:데이터에서 찾을 데이터가 일치 할 경우| |callback|`function`|<span class='optional'>선택</span>| findRows로 데이터 검색이 완료된 뒤 호출되는 콜백 함수입니다. 콜백 함수의 인자로 두 가지 인자가 주어집니다. 1. `action`: 현재 실행된 검색 기능 2. `result`: findRows로 조회된 데이터 결과값| ### 검색 기능(action) |Name| Description | |----------|----| |`'Find'`| 다음 행 검색 | |`'FindPrev'`| 이전 행 검색 | |`'Mark'`| 검색식에 해당하는 행을 강조 (총 갯수가 `sheet.SearchCount`에 설정됨) | |`'Select'`| 검색식에 해당하는 행을 선택 (총 갯수가 `sheet.SearchCount`에 설정됨) | |`'Filter'`| 검색식에 해당하는 행만 보이도록 필터링 (총 갯수가 `sheet.FilterCount`에 설정됨) | |`'Clear'`| 검색 결과를 초기화 | ### Example ```javascript // 시트에서 '서울'을 포함한 데이터 행을 검색 sheet.SearchExpression = '서울'; sheet.findRows('Find'); ```",
              "see": [
                {
                  "label": "SearchCaseSensitive cfg",
                  "url": "/docs/props/cfg/search-case-sensitive"
                },
                {
                  "label": "SearchCount cfg",
                  "url": "/docs/props/cfg/search-count"
                },
                {
                  "label": "SearchExpression cfg",
                  "url": "/docs/props/cfg/search-expression"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.98|`callback` 기능 공개|"
            },
            "url": "docs/funcs/core/find-rows.html"
          },
          {
            "cid": 576,
            "sid": "find-text",
            "name": "find-text",
            "label": "findText",
            "data": {
              "body": "> 열 내에 특정 문자열을 가지는 첫번 째 [데이터 로우 객체](/docs/appx/row-object)를 반환합니다. ### Syntax ```javascript object findText( col, searchText, startRow, matchMode, caseSensitive, excludeKeys ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |col |`string`|<span class='required'>필수</span>|열 이름| |searchText |`string`|<span class='required'>필수</span>|찾을 문자열| |startRow |`object`|<span class='optional'>선택</span>|검색 시작 행의 [데이터 로우 객체](/docs/appx/row-object) (`default: 시트의 첫번째 행`)| |matchMode|`number`|<span class='optional'>선택</span>|문자열 매칭 모드 `-1`:전체가 동일한 값 (`default`) `0`:앞 부분이 같은 값 `1`:뒷 부분이 같은 값 `2`:일부가 같은 값| |caseSensitive |`boolean`|<span class='optional'>선택</span>|대소문자 구별 여부 `0(false)`:대소문자 구별 안함 (`default`) `1(true)`:대소문자 구별 적용| |excludeKeys |`boolean`|<span class='optional'>선택</span>|[Enum](/docs/props/col/enum) 열 검색 시 [EnumKeys](/docs/props/col/enum-keys)를 검색에 포함 할 지 여부 `0(false)`:[Enum](/docs/props/col/enum) 열 검색 시 [EnumKeys](/docs/props/col/enum-keys)를 검색에 포함 안함 `1(true)`:[Enum](/docs/props/col/enum) 열 검색 시 [EnumKeys](/docs/props/col/enum-keys)를 검색에 포함 (`default`)| ### Return Value ***object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript // sTitle 열의 셀 값에서 Java Project1과 일치하는 첫 번째 데이터 로우 객체를 리턴합니다. var row = sheet.getFirstRow(); var sdata = sheet.findText(\"sTitle\", \"Java project1\", row, -1, 1); ```",
              "see": [
                {
                  "label": "getString method",
                  "url": "./get-string"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.21|`excludeKeys` 기능 추가|"
            },
            "url": "docs/funcs/core/find-text.html"
          },
          {
            "cid": 577,
            "sid": "fit-col-width",
            "name": "fit-col-width",
            "label": "fitColWidth",
            "data": {
              "body": "> 각 컬럼 너비를 인자로 설정한 비율 단위로 설정하거나 시트의 전체 너비에 맞게 비율 기준으로 재 설정 합니다. > `ratio` 인자를 설정하지 않은 경우 모든 컬럼의 너비 합이 시트의 너비에 맞게 현재의 컬럼 너비의 비율에 맞추어 재설정 되며, `ratio` 인자를 설정한 경우 해당 비율로 재설정 됩니다. > **<mark>주의</mark> : [RelWidth](./docs/props/col/rel-width) 사용하는 경우 해당 기능이 정상적으로 지원되지 않습니다.** > `ratio` 설정 시 컬럼의 갯수와 비율 배분(전체 100 기준으로 배분하여 나머지가 남지 않도록)을 반드시 맞춰주어야 정상 동작 됩니다. ### Syntax ```javascript boolean fitColWidth(ratio); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |ratio |`array[number]`|<span class='optional'>선택</span>|컬럼의 너비 비율| ### Return Value ***boolean*** : 적용 여부 (너비의 변경이 이루어지면 true, 변화가 없으면 false 리턴) ### Example ```javascript // 컬럼들의 현재의 너비 비율을 유지하며 시트 너비에 맞게 재설정 처리 sheet.fitColWidth(); // 시트전체 너비를 기준으로 첫번째 컬럼부터 10%, 50%, 30%, 10% 의 너비 비율로 재설정 처리 sheet.fitColWidth([10,50,30,10]); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.1.0.41|기능 추가|"
            },
            "url": "docs/funcs/core/fit-col-width.html"
          },
          {
            "cid": 578,
            "sid": "fit-size",
            "name": "fit-size",
            "label": "fitSize",
            "data": {
              "body": "> 특정 열의 너비를 해당 열에 있는 글자 중 가장 긴 글자에 맞게 조정합니다. (엑셀의 autofit) > 전체 데이터가 아닌 1~100행 사이의 글자열을 기준으로 너비를 조정합니다. > 서버 페이징 조회 사용시 기능 사용이 어려울 수 있습니다. > `rows` 인자를 사용하여 너비를 조정할 때 검사하는 데이터행들을 정할 수 있습니다. > 단, `rows`에 데이터행들이 많아질수록 성능문제가 생길 수 있습니다. ### Syntax ```javascript void fitSize(col, norender, rows); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |col |`string`|<span class='required'>필수</span>|열이름| |norender|`boolean`|<span class='optional'>선택</span><mark>(사용주의)</mark>|즉시 화면에 반영할 것인지 여부 해당 기능을 사용한 뒤, 다른 동작을 실행 할 경우 `renderBody()`를 반드시 먼저 실행 해야 합니다. `0(false)`:즉시 반영 (`default`) `1(true)`:반영 안함 | |rows|`array`|<span class='optional'>선택</span>|특정 열의 너비를 조정할 행들| ### Return Value ***none*** ### Example ```javascript // DESC 열의 너비를 열 내 가장 긴 글자열에 맞게 조정합니다. sheet.fitSize(\"DESC\"); // rows 전체 데이터로우를 검사. 전체 데이터 로우를 검사시 속도에서 문제가 생길 수 있습니다. var totalRows = sheet.getDataRows(); sheet.fitSize(\"DESC\", 0, totalRows); ```",
              "see": [
                {
                  "label": "setColWidth method",
                  "url": "./set-col-width"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/fit-size.html"
          },
          {
            "cid": 579,
            "sid": "focus",
            "name": "focus",
            "label": "focus",
            "data": {
              "body": "> 지정한 특정 셀에 포커스를 줍니다. > 시트 외부에 버튼을 클릭함으로써 포커스를 설정하고자 하는 경우에는 `setTimeout`을 통해 딜레이를 주어야 합니다. ### Syntax ```javascript boolean focus( row, col, pagepos, ignoreEvent, triggerOnFocus ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)|기본값은 포커스된 행이 있으면 포커스된 행, 포커스된 행이 없으면 보이는 행의 첫번째 |col|`string`|<span class='required'>필수</span>|열이름|기본값은 포커스된 열이 있으면 포커스된 열, 포커스된 열이 없으면 보이는 첫번째 열 |pagepos|`number`|<span class='optional'>선택</span>|서버페이징 사용시 페이지 지정 (`default: null`)| |ignoreEvent|`boolean`|<span class='optional'>선택</span>|함수 호출시 `focus Event(onBeforeFocus, onFocus)`를 발생시킬지 유무 `0(false)`:`focus Event` 발생 시킴 (`default`) `1(true)`:`focus Event`를 발생 시키지 않음| |triggerOnFocus|`boolean`|<span class='optional'>선택</span>|이미 선택한 셀을 다시 선택하는 함수 호출시 `focus Event(onBeforeFocus, onFocus)`를 항상 발생시킵니다. `0(false)`:이미 선택된 셀을 함수로 다시 포커스 하였을 때, `focus Event`를 발생 시키지 않음 (`default`) `1(true)`:이미 선택된 셀을 함수로 다시 포커스 하였을 때, `focus Event` 를 발생 시킴| ### Return Value ***boolean*** : 포커스가 지정되면 true, 이미 포커스가 된 셀에 함수 적용시 false, 해당셀이 없는 경우 null 리턴 ### Example ```javascript //버튼 클릭시 특정셀에 포커스 지정 document.getElementById(\"btn_validCheck\").onclick = function(){ setTimeout(function(){ var errRow = sheet.getRowById(\"AR4\"); sheet.focus(errRow, \"CARNO\"); } , 10); } ```",
              "see": [
                {
                  "label": "blur method",
                  "url": "./blur"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.7|`ignoreEvent` 인자 추가||core|8.1.0.94|`triggerOnFocus` 인자 추가|"
            },
            "url": "docs/funcs/core/focus.html"
          },
          {
            "cid": 580,
            "sid": "get-attribute",
            "name": "get-attribute",
            "label": "getAttribute",
            "data": {
              "body": "> 특정 행,열,셀에 설정된 속성값을 확인합니다. > `row`를 `null`로 설정시 열에 설정한 속성값이 리턴됩니다. > `col`을 `null`로 설정시 행에 설정한 속성값이 리턴됩니다. ### Syntax ```javascript mixed getAttribute( row, col, attr); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row |`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='optional'>선택</span>|열이름| |attr|`string`|<span class='optional'>선택</span>|확인하고자 하는 속성명| ### Return Value ***mixed ( `number` \\| `string` )*** : 인자에 따라 행이나 열,셀의 속성 값을 리턴 ### Example ```javascript //특정 열의 타입 확인 if (sheet.getAttribute(null, sheet.getFocusedCol(), \"Type\") == \"Radio\") { alert(\"해당 열에는 적용할 수 없습니다.\"); } //합계 행의 셀의 글자색 확인 var fcolor = sheet.getAttribute( sheet.getRowById(\"FormulaRow\"), sheet.getFocusedCol(), \"TextColor\"); ```",
              "see": [
                {
                  "label": "setAttribute method",
                  "url": "./set-attribute"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-attribute.html"
          },
          {
            "cid": 581,
            "sid": "get-body-height",
            "name": "get-body-height",
            "label": "getBodyHeight",
            "data": {
              "body": "> 시트 데이터 영역의 높이를 리턴합니다. > 헤더나 필터 행의 높이는 포함되지 않습니다. ### Syntax ```javascript number getBodyHeight( ); ``` ### Return Value ***number*** : 데이터 영역의 높이 (pixel 단위) ### Example ```javascript //데이터 영역의 높이를 리턴함. (세로 스크롤과 무관함) var h = sheet.getBodyHeight( ); ```",
              "see": [
                {
                  "label": "getRowTop method",
                  "url": "./get-row-top"
                },
                {
                  "label": "getScrollTop method",
                  "url": "./get-scroll-top"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-body-height.html"
          },
          {
            "cid": 582,
            "sid": "get-body-width",
            "name": "get-body-width",
            "label": "getBodyWidth",
            "data": {
              "body": "> 특정 [Section](/docs/props/col/section)의 너비(틀고정 기준 좌/우측)를 확인합니다. ### Syntax ```javascript number getBodyWidth( section ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |section |`number`|<span class='optional'>선택</span>|너비를 알고 싶은 영역 `0`:왼쪽 `1`:가운데 (`default`) `2`:오른쪽| ### Return Value ***number*** : 섹션의 너비 (pixel 단위) ### Example ```javascript //왼쪽 틀고정 영역의 너비를 확인 var w = sheet.getBodyWidth(0); ```",
              "see": [
                {
                  "label": "getBodyHeight method",
                  "url": "./get-body-height"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-body-width.html"
          },
          {
            "cid": 583,
            "sid": "get-can-edit",
            "name": "get-can-edit",
            "label": "getCanEdit",
            "data": {
              "body": "> 특정 셀의 편집 가능 여부를 확인합니다. ### Syntax ```javascript number getCanEdit( row, col ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col|`string`|<span class='required'>필수</span>|열이름| ### Return Value ***number*** |value|설명| |-----|-----| |`0`|편집 불가(읽기 전용) ![CanEdit](/assets/imgs/canEdit0.png \"CanEdit\")| |`1`|편집 가능 ![CanEdit](/assets/imgs/canEdit1.png \"CanEdit\")| |`2`|행의 내용은 편집 불가하지만, 편집 미리보기를 제공 ![CanEdit](/assets/imgs/canEdit2.png \"CanEdit\")| ### Example ```javascript //특정 셀에 편집 가능 여부를 확인. var edit = sheet.getCanEdit(sheet.getFocusedRow(), \"RES_ENDDATE\"); if (!edit) { alert(\"마감되었습니다\"); } ```",
              "see": [
                {
                  "label": "CanEdit row",
                  "url": "/docs/props/row/can-edit"
                },
                {
                  "label": "CanEdit col",
                  "url": "/docs/props/col/can-edit"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-can-edit.html"
          },
          {
            "cid": 584,
            "sid": "get-can-focus",
            "name": "get-can-focus",
            "label": "getCanFocus",
            "data": {
              "body": "> 특정 행이나 셀이 포커스 될 수 있는지 여부를 확인합니다. ### Syntax ```javascript boolean getCanFocus( row, col ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='optional'>선택</span>|열이름| ### Return Value ***boolean*** : 포커스 가능 여부 (`0(false)`: 포커스 불가, `1(true)`: 포커스 가능) ### Example ```javascript //id가 AR33인 행이 포커스가 들어갈 수 있는지 여부 확인 var cf = sheet.getCanFocus(sheet.getRowById(\"AR33\")); //특정 셀에 포커스가 들어갈 수 있는지 여부 확인 var cf = sheet.getCanFocus(sheet.getRowById(\"AR5\") , \"CA_DSC\"); ```",
              "see": [
                {
                  "label": "focus method",
                  "url": "./focus"
                },
                {
                  "label": "isFocused method",
                  "url": "./is-focused"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-can-focus.html"
          },
          {
            "cid": 585,
            "sid": "get-cell",
            "name": "get-cell",
            "label": "getCell",
            "data": {
              "body": "> 특정 셀의 Html 태그(td)를 가져옵니다. > `javascript`의 `getBoundingClientRect()` 메서드를 이용하여 셀의 크기와 현재 뷰포트에서의 상대적인 위치 정보를 제공하는 `DOMRect` 객체를 반환 받을 수 있습니다. > 태그 내에 style을 수정할 수는 있으나 태그 자체를 수정하는 것을 불가능합니다. > [SearchMode](/docs/props/cfg/search-mode): 0(FastLoad) 에서는 사용하실 수 없습니다. ### Syntax ```javascript object getCell( row, col ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| ### Return Value ***object*** : Html TD 태그 객체 ### Example ```javascript // 특정 셀에 설정된 클레스에 Black_Bold 클레스를 추가한다. var ctd = sheet.getCell( sheet.getRowById(\"AR15\"), \"EMT_XL\" ); ctd.className = ctd.className+\" Black_Bold\"; // 특정 셀의 현재 뷰포트 기준 top 값을 구합니다. var top = ctd.getBoundingClientRect().top; ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-cell.html"
          },
          {
            "cid": 586,
            "sid": "get-changed-data",
            "name": "get-changed-data",
            "label": "getChangedData",
            "data": {
              "body": "> 시트 내에 변경된 내용(입력,수정,삭제)을 json형식의 **문자열**로 추출합니다. > 인자없이 호출시에는 전체 수정한 데이터를 모두 추출하고, row인자에 [데이터 로우 객체](/docs/appx/row-object)를 설정시 해당 행의 수정된 내용이 추출됩니다. > 두번째 인자를 통해 PK가 되는 열들을 지정하면 해당 열은 수정 여부와 관계 없이 같이 추출됩니다. > *이 함수는 행 전체 데이터가 추출되지 않고 수정이 이루어진 셀만 추출됨을 주의해 주세요.* ### Syntax ```javascript string getChangedData(row, attrs, dataonly); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object)| |attrs|`array[string]`|<span class='optional'>선택</span>|열이름을 갖는 배열 (ex:`[\"ColName1\",\"ColName3\"]`)| |dataonly|`boolean`|<span class='optional'>선택</span>|수정 여부 확인을 Sheet전체 영역과 Data영역만 대상으로 지정할 지 여부 `0(false)`:Sheet전체 영역 대상 지정(`default`) `1(true)`:Data영역만 대상 지정| ### Return Value ***json 형식의 string*** ```js '{\"Changes\":[{\"id\":\"AR4\",\"Changed\":1,\"ColName1\":\"1234\",\"ColName5\":\"ABCDE\"},{\"id\":\"AR12\",\"Changed\":1,\"ColName2\":\"23456\"},{\"id\":\"AR15\",\"Deleted\":1},{\"id\":\"0\",\"Added\":1,\"ColName1\":\"2345\",\"ColName2\":\"4567\"...}]}' ``` ### Example ```javascript var chgData = JSON.stringify(sheet.getChangedData({attrs:[\"CONTRACTNO\",\"RETURNDATE\"]}), null, '\\t'); //리턴된 JSON string (2건 수정되고 1건 삭제, 1건 신규) /* \"{ \"IO\": {}, \"Changes\": [{ \"id\": \"AR5\", \"Changed\": 1, \"CONTRACTNO\": \"SS1944111234933\", \"RETURNDATE\": \"1325602800000\", \"CARNO\": \"52허571123\" }, { \"id\": \"AR9\", \"Changed\": 1, \"CONTRACTNO\": \"SS1937111124325\", \"RETURNDATE\": \"1325430000000\", \"CARNO\": \"33\" }, { \"id\": \"AR12\", \"Deleted\": 1, \"CONTRACTNO\": \"SS1140111240995\", \"RETURNDATE\": \"1326034800000\" }, { \"id\": \"AR101\", \"Added\": 1, \"Def\": \"R\", \"Parent\": \"0\", \"Next\": \"AR14\", \"Prev\": \"AR13\", \"CONTRACTNO\": \"\", \"RETURNDATE\": \"\", \"SEQ\": \"14\", \"CHK\": \"0\", \"DELIVERYDEPTNAME\": \"\", \"CARNO\": \"32가1234\", \"CARNAMEMSTNAME\": \"투싼 현대\", \"RENTFEE\": \"\", \"RENTDATE\": \"\", \"PROMOCODE\": \"\", \"NO\": \"\", \"DISCOUNTRATE\": \"0\", \"NETSALEAMT\": \"0\", \"SALEVATAMT\": \"0\", \"SALEAMT\": \"0\", \"OBJCARNO\": \"\", \"DEPTNAME\": \"\", \"CARNAMEMSTNAME2\": \"\", \"UNIT24\": \"0\", \"ACCNO\": \"\", \"ACCPERSONNAME\": \"\", \"ACCDATE\": \"\", \"REPAIRNO\": \"\", \"REPAIRPERSONNAME\": \"\", \"STARTDATE\": \"\", \"ENDDATE\": \"\", \"cls1\": \"\", \"cls2\": \"\" }] }\" */ //수정된 값이 없는 경우에는 아래와 같은 JSON string이 리턴됨 /* { \"IO\": {}, \"Changes\": [] } */ ```",
              "see": [
                {
                  "label": "acceptChangedData method",
                  "url": "./accept-changed-data"
                },
                {
                  "label": "hasChangedData method",
                  "url": "./has-changed-data"
                },
                {
                  "label": "getSaveJson method",
                  "url": "./get-save-json"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.3.0.20|dataonly 인자 추|"
            },
            "url": "docs/funcs/core/get-changed-data.html"
          },
          {
            "cid": 587,
            "sid": "get-child-rows",
            "name": "get-child-rows",
            "label": "getChildRows",
            "data": {
              "body": "> 특정 행의 전체 자식 행(손자 포함) 객체를 배열 형태로 반환합니다. ### Syntax ```javascript array getChildRows( row, maxLevel ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|부모행 [데이터 로우 객체](/docs/appx/row-object)| |maxLevel|`number`|<span class='optional'>선택</span>|확인할 자식행의 제한 레벨 (지정한 레벨 **미만** 리턴)| ### Return Value ***array[row object]*** : [데이터 로우 객체](/docs/appx/row-object) 배열 ### Example ```javascript // 첫번째 행의 자식 행들을 가져옵니다. var childNodes = sheet.getChildRows(sheet.getFirstRow()); ```",
              "see": [
                {
                  "label": "getParentRows method",
                  "url": "./get-parent-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.14|`maxLevel` 기능 추가|"
            },
            "url": "docs/funcs/core/get-child-rows.html"
          },
          {
            "cid": 588,
            "sid": "get-col-by-index",
            "name": "get-col-by-index",
            "label": "getColByIndex",
            "data": {
              "body": "> 좌측부터 열의 `index`를 기준으로 열이름을 확인합니다. > `index`는 `1`부터 시작합니다. > 해당 함수는 기본적으로 보여지는 열을 기준으로 확인합니다. > `includeHideCol` 또는 `Cfg: GetColWithHide` 를 설정하여 `Visible` 관계없이 가져옵니다. > 우선 순위는 `includeHideCol` > `GetColWithHide` 임으로, `GetColWithHide`를 `true`로 설정 하여도 `includeHideCol`을 `false`로 설정시에는 보여지는 열을 기준으로 동작하게 할 수 있습니다 ### Syntax ```javascript string getColByIndex( index, includeHideCol ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |index|`number`|<span class='required'>필수</span>|열의 `index` |includeHideCol|`boolean`|<span class='optional'>선택</span>|`true` 설정시 `Col.Visible` 관계없이 인덱스를 추출함. `0(false)`:숨김 열을 계산 대상으로 포함하지 않음 (`default`) `1(true)`:숨김 열도 계산 대상으로 포함| ### Return Value ***string*** : 지정한 위치에 있는 열이름 ### Example ```javascript //3번째 열(1부터 시작함으로)의 열이름을 확인 var fcol = sheet.getColByIndex(3); ```",
              "see": [
                {
                  "label": "getColIndex method",
                  "url": "./get-col-index"
                },
                {
                  "label": "GetColWithHide cfg",
                  "url": "/docs/props/cfg/get-col-with-hide"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.11|`includeHideCol` 인자 추가|"
            },
            "url": "docs/funcs/core/get-col-by-index.html"
          },
          {
            "cid": 589,
            "sid": "get-col-index",
            "name": "get-col-index",
            "label": "getColIndex",
            "data": {
              "body": "> 열이름에 대한 `index`를 확인합니다. > `index`는 `1`부터 시작합니다. > 해당 함수는 기본적으로 보여지는 열을 기준으로 확인합니다. > `includeHideCol` 또는 `Cfg: GetColWithHide` 를 설정하여 `Visible` 관계없이 가져옵니다. > 우선 순위는 `includeHideCol` > `GetColWithHide` 임으로, `GetColWithHide`를 `true`로 설정 하여도 `includeHideCol`을 `false`로 설정시에는 보여지는 열을 기준으로 동작하게 할 수 있습니다. ### Syntax ```javascript string getColIndex( col, includeHideCol ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|열이름 |includeHideCol|`boolean`|<span class='optional'>선택</span>|`true` 설정시 `Col.Visible` 관계없이 인덱스를 추출함 `0(false)`:숨김 열을 계산 대상으로 포함하지 않음 (`default`) `1(true)`:숨김 열도 계산 대상으로 포함| ### Return Value ***number*** : 열이름이 위치한 index ### Example ```javascript //열이름이 EMP_NM인 열의 index var fcol = sheet.getColIndex(\"EMP_NM\"); ```",
              "see": [
                {
                  "label": "getColByIndex method",
                  "url": "./get-col-by-index"
                },
                {
                  "label": "GetColWithHide cfg",
                  "url": "/docs/props/cfg/get-col-with-hide"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.3|`name` 인자명 변경 -> `col`, 다른 API와 통일||core|8.0.0.11|`includeHideCol` 인자 추가|"
            },
            "url": "docs/funcs/core/get-col-index.html"
          },
          {
            "cid": 590,
            "sid": "get-col-left",
            "name": "get-col-left",
            "label": "getColLeft",
            "data": {
              "body": "> 특정 열의 위치를 각 섹션의 시작을 기준으로 확인합니다. ### Syntax ```javascript number getColLeft( col ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|확인하고자 하는 열이름| ### Return Value ***number*** : 섹션의 최좌측부터 현재 열의 왼쪽 끝부분까지의 거리(px 단위) ### Example ```javascript //AMT 열의 x축 offset 값을 확인 var colOff = sheet.getColLeft(\"AMT\"); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-col-left.html"
          },
          {
            "cid": 591,
            "sid": "get-cols",
            "name": "get-cols",
            "label": "getCols",
            "data": {
              "body": "> 시트가 갖고있는 열을 ['colName1','colName2']와 같은 배열형태로 추출합니다. > 두개의 인자를 통해 특정 속성을 모두 갖고있는 열들을 찾을 수도 있습니다. > 전체 열의 개수를 알고자 할때도 이 함수를 사용하실 수 있습니다. > **<mark>주의</mark> : getCols()를 통해서 찾을수 있는 속성은 반드시 시트 생성시 Cols를 통해 부여한 값만을 찾을 수 있습니다.** > 가령 열의 편집가능여부 기본값이 `1(true)`라고 하더라도, Cols를 통해 열 생성시 `CanEdit:1`을 별도로 부여하지 않았으면 찾을 수 없습니다. > **`SEQ`컬럼을 설정하지도 않았더라도 포함하여 리턴 합니다.** ### Syntax ```javascript array getCols( attr1, attr2, seq ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |attr1|`string`|<span class='optional'>선택</span>|찾고자 하는 속성명 (`attr1` 속성을 선언하지 않으면 모든 열이 추출됨)| |attr2|`string`|<span class='optional'>선택</span>|찾고자 하는 속성명 (`attr1` 과 `attr2` 를 모두 갖고 있는 열이 리턴)| |seq|`boolean`|<span class='optional'>선택</span>|설정하지 않은 SEQ 컬럼 포함 여부 `0(false)`:설정하지 않은 SEQ 컬럼 포함 (`default`) `1(true)`:설정하지 않은 SEQ 컬럼 미포함| ### Return Value ***array[string]*** : 열이름 배열 ### Example ```javascript //현재 보여지는 모든 열을 찾습니다. var vCol = sheet.getCols(\"Visible\"); //현재 보여지면서 편집도 가능한 열을 찾습니다. var veCol = sheet.getCols(\"Visible\",\"CanEdit\"); //return //[\"ColName1\",\"ColName3\" ... ] //설정하지 않은 SEQ는 제외하고 열 추출, 8.1.0.38버전에서 추가된 기능 var veCol = sheet.getCols(\"\",\"\",1); var veCol = sheet.getCols({seq:1}); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.1.0.38|seq 추가|"
            },
            "url": "docs/funcs/core/get-cols.html"
          },
          {
            "cid": 592,
            "sid": "get-count-info-element",
            "name": "get-count-info-element",
            "label": "getCountInfoElement",
            "data": {
              "body": "> [setCountInfoElement](./set-count-info-element) 기능 사용하여 데이터 행수 정보를 시트 외부의 Dom Element 에 표시하고 있을 경우 정보 출력되는 Dom Element 를 반환합니다. ### Syntax ```javascript HTML Element getCountInfoElement (); ``` ### Return Value ***object*** : 데이터 행수 정보가 출력 되는 Dom Element ### Example ```javascript // 데이터 행수 정보가 출력 되는 Dom Element 확인 sheet.getCountInfoElement (); ```",
              "see": [
                {
                  "label": "InfoRowConfig cfg",
                  "url": "/docs/props/cfg/info-row-config"
                },
                {
                  "label": "setCountInfoElement method",
                  "url": "./set-count-info-element"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/funcs/core/get-count-info-element.html"
          },
          {
            "cid": 593,
            "sid": "get-current-info",
            "name": "get-current-info",
            "label": "getCurrentInfo",
            "data": {
              "body": "> 현재 시트의 컬럼 정보를 문자열로 가져오는 메소드입니다. ### Syntax ```javascript string getCurrentInfo(); ``` ### Return Value ***string 현재 컬럼들의 숨김, 너비, 위치 정보 값*** ### Example ```javascript // 현재 시트의 컬럼 정보를 담고 있는 문자열을 반환 sheet.getCurrentInfo(); ```",
              "see": [
                {
                  "label": "setCurrentInfo method",
                  "url": "./set-current-info"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-current-info.html"
          },
          {
            "cid": 594,
            "sid": "get-current-style",
            "name": "get-current-style",
            "label": "getCurrentStyle",
            "data": {
              "body": "> 현재 시트의 Def에 설정된 테마, 배경색, 글자색 및 Alternate 색상, 글자크기 정보를 문자열로 가져오는 메소드입니다. > 테마를 제외한 속성의 default 값은 추가되지 않습니다. ### Syntax ```javascript string getCurrentStyle(); ``` ### Return Value ***string 현재 시트의 Def에 설정된 배경색, 글자색 및 Alternate 색상, 글자크기 정보 값*** ### Example ```javascript // 현재 시트의 컬럼 정보를 담고 있는 문자열을 반환 sheet.getCurrentStyle(); ```",
              "see": [
                {
                  "label": "행(Row) 구조에 대한 이해 getting started",
                  "url": "/docs/start/row"
                },
                {
                  "label": "setCurrentStyle method",
                  "url": "./set-current-style"
                },
                {
                  "label": "AlternateColor row",
                  "url": "/docs/props/row/alternate-color.md"
                },
                {
                  "label": "Color row",
                  "url": "/docs/props/row/color.md"
                },
                {
                  "label": "TextColor row",
                  "url": "/docs/props/row/text-color.md"
                },
                {
                  "label": "TextSize row",
                  "url": "/docs/props/row/text-size.md"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.18|기능 추가|"
            },
            "url": "docs/funcs/core/get-current-style.html"
          },
          {
            "cid": 595,
            "sid": "get-data-rows",
            "name": "get-data-rows",
            "label": "getDataRows",
            "data": {
              "body": "> 시트가 가지고 있는 전체 데이터 행을 리턴합니다. > **<mark>주의</mark> :** **- `Type:\"Text\"` 컬럼에 숫자 데이터를 조회 할 경우 리턴 되는 데이터형은 숫자형입니다.** **문자 형태로 리턴 되길 원하는 경우 (Col)[OrigSearchData](/docs/props/col/orig-search-data)를 설정 하세요.** **- `Type:\"Date\", Format, DataFormat, EditFormat` 컬럼에에서 리턴 되는 데이터형은 숫자형(timestamp)입니다.** **20010101과 같은 형태로 리턴 받길 원할경우 [getValue](./get-value) 또는 [dateToString](/docs/static/date-to-string) 함수를 통하여 데이터를 변환 하세요.** **- row 객체에 직접 접근 하여 값 변경시 상태에(Changed) 영향을 미치지 않습니다.** ### Syntax ```javascript array getDataRows( noSubTotal); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |noSubTotal |`boolean`|<span class='optional'>선택</span>|소계/누계 행을 제외할지 여부 `0(false)`:소계/누계 행 포함 (`default`) `1(true)`:소계/누계 행 제외| ### Return Value ***array[row object]*** : [데이터 로우 객체](/docs/appx/row-object)를 담고있는 배열 ### Example ```javascript // 전체 데이터행을 가져온다. var Rows = sheet.getDataRows(); for(var i=0; i<Rows.length; i++){ // 마감열(saveName:close_data)에 값을 일괄변경하는 경우 , render속성을 꺼야 속도가 빠르다. sheet.setValue({row:Rows[i], col:\"close_data\", val:\"변경\", render:0}); //Rows[i].close_data = \"변경\"; row 객체에 접근하여 값 변경. 상태에 영향을 미치지 않는다. } //변경사항 적용한다. sheet.rerender(1); ```",
              "see": [
                {
                  "label": "getTotalRowCount method",
                  "url": "./get-total-row-count"
                },
                {
                  "label": "OrigSearchData col",
                  "url": "/docs/props/col/orig-search-data"
                },
                {
                  "label": "getShownRows method",
                  "url": "./get-shown-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.4|`noSubTotal` 인자 추가로 소계/누계 행을 제외한 데이터 행만 가져오는 기능 추가|"
            },
            "url": "docs/funcs/core/get-data-rows.html"
          },
          {
            "cid": 596,
            "sid": "get-edit-col",
            "name": "get-edit-col",
            "label": "getEditCol",
            "data": {
              "body": "> 현재 편집 중인 열이름을 반환합니다. ### Syntax ```javascript string getEditCol(); ``` ### Return Value ***String*** : 열이름 ### Example ```javascript var eCol = sheet.getEditCol(); ```",
              "see": [
                {
                  "label": "getEditRow method",
                  "url": "./get-edit-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-edit-col.html"
          },
          {
            "cid": 597,
            "sid": "get-edit-row",
            "name": "get-edit-row",
            "label": "getEditRow",
            "data": {
              "body": "> 현재 편집 중인 행 객체를 반환합니다. ### Syntax ```javascript object getEditRow(); ``` ### Return Value ***row Object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript var eRow = sheet.getEditRow(); ```",
              "see": [
                {
                  "label": "getEditCol method",
                  "url": "./get-edit-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-edit-row.html"
          },
          {
            "cid": 598,
            "sid": "get-edit-text",
            "name": "get-edit-text",
            "label": "getEditText",
            "data": {
              "body": "> 편집 중인 데이터를 반환합니다. ### Syntax ```javascript string getEditText(); ``` ### Return Value ***string*** : 편집 중인 데이터 ### Example ```javascript sheet.getEditText(); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-edit-text.html"
          },
          {
            "cid": 599,
            "sid": "get-filter",
            "name": "get-filter",
            "label": "getFilter",
            "data": {
              "body": "> 필터행에 설정한 내용을 확인합니다. ### Syntax ```javascript object getFilter( spec ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |spec|`boolean`|<span class='optional'>선택</span>|일반필터 와 [setFilter](./set-filter)에 대한 내용 여부 `0(false)`:일반필터 설정 (`default`) `1(true)`:setFilter 설정| ### Return Value ***object*** : 필터 설정 값(이차원 배열) |입력값|유형|리턴 데이터 형식| |---|---|---| |`0`|일반필터|`[[\"colName1\" , \"필터값\" , 연산자 ], [\"colName2\",\"필터값\",연산자] ...]`| |`1`|setFilter|`[[\"필터명\", \"cardAmt>=5000?1:0\"], [\"필터명\", \"deptNm=='자재부서'?1:0\"] ...]`| ### Example ```javascript //필터 초기화 var filterDesc = sheet.getFilter(0); ```",
              "see": [
                {
                  "label": "setFilter method",
                  "url": "./set-filter"
                },
                {
                  "label": "doFilter method",
                  "url": "./do-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-filter.html"
          },
          {
            "cid": 600,
            "sid": "get-first-col",
            "name": "get-first-col",
            "label": "getFirstCol",
            "data": {
              "body": "> 최 좌측 열이름을 확인합니다. > section을 통해 특정 영역의 최 좌측 열을 확인할 수도 있습니다. > 해당 함수는 기본적으로 보여지는 열을 기준으로 확인합니다. > `includeHideCol` 또는 `Cfg: GetColWithHide` 를 설정하여 `Visible` 관계없이 가져옵니다. > 우선 순위는 `includeHideCol` > `GetColWithHide` 임으로, `GetColWithHide`를 `true`로 설정 하여도 `includeHideCol`을 `false`로 설정시에는 보여지는 열을 기준으로 동작하게 할 수 있습니다. ### Syntax ```javascript string getFirstCol( section, includeHideCol ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |section|`number`|<span class='optional'>선택</span>|틀고정 기준 영역 지정 `0`:좌측 (`default`) `1`:가운데 (LeftCols(좌측) 정보가 없을 경우 `default`) `2`:우측 (LeftCols(좌측), Cols(가운데) 정보가 없을 경우 `default`)| |includeHideCol|`boolean`|<span class='optional'>선택</span>|`true` 설정시 `Col.Visible` 관계없이 콜을 추출함 `0(false)`:숨김 열을 계산 대상으로 포함하지 않음 (`default`) `1(true)`:숨김 열도 계산 대상으로 포함| ### Return Value ***string*** : 좌측에 위치한 열이름 ### Example ```javascript //최 좌측의 열이름을 확인한다. var fcol = sheet.getFirstCol(); ```",
              "see": [
                {
                  "label": "getLastCol method",
                  "url": "./get-last-col"
                },
                {
                  "label": "GetColWithHide cfg",
                  "url": "/docs/props/cfg/get-col-with-hide"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.11|`includeHideCol` 인자 추가|"
            },
            "url": "docs/funcs/core/get-first-col.html"
          },
          {
            "cid": 601,
            "sid": "get-first-row",
            "name": "get-first-row",
            "label": "getFirstRow",
            "data": {
              "body": "> 최 상단행을 확인합니다. > 트리 기능 사용시 row 인자를 설정하면 행이 갖고있는 첫번째 자식행이 리턴됩니다. ### Syntax ```javascript object getFirstRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //최 상단행을 얻습니다. var frow = sheet.getFirstRow(); ```",
              "see": [
                {
                  "label": "getFirstVisibleRow method",
                  "url": "./get-first-visisble-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-first-row.html"
          },
          {
            "cid": 602,
            "sid": "get-first-visible-row",
            "name": "get-first-visible-row",
            "label": "getFirstVisibleRow",
            "data": {
              "body": "> `Visible`이 `1`인 최 상단행을 확인합니다. > 트리 기능 사용시 row 인자를 설정하면 행이 갖고있는 자식행 중 보여지는 첫번째 자식행이 리턴됩니다. ### Syntax ```javascript object getFirstVisibleRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR12행의 첫번째 자식행을 리턴합니다. var fchildrow = sheet.getFirstVisibleRow(\"AR12\"); ```",
              "see": [
                {
                  "label": "getFirstRow method",
                  "url": "./get-first-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-first-visible-row.html"
          },
          {
            "cid": 603,
            "sid": "get-focused-col",
            "name": "get-focused-col",
            "label": "getFocusedCol",
            "data": {
              "body": "> 시트 내에 현재 포커스된 셀의 열이름을 반환합니다. ### Syntax ```javascript string getFocusedCol(); ``` ### Return Value ***string*** : 열이름 ### Example ```javascript //현재 포커스된 셀의 열이름을 반환합니다. var row = sheet.getFocusedCol(); ```",
              "see": [
                {
                  "label": "getFocusedRow method",
                  "url": "./get-focused-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-focused-col.html"
          },
          {
            "cid": 604,
            "sid": "get-focused-page",
            "name": "get-focused-page",
            "label": "getFocusedPage",
            "data": {
              "body": "> 현재 포커스가 위치한 데이터 [페이지 객체](/docs/appx/page-object)를 리턴합니다. ### Syntax ```javascript object getFocusedPage(); ``` ### Return Value ***page object*** : [페이지 객체](/docs/appx/page-object) ### Example ```javascript //현재 포커스가 있는 페이지 객체 var pageObj = sheet.getFocusedPage(); ```",
              "see": [
                {
                  "label": "getPageIndex method",
                  "url": "./get-page-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-focused-page.html"
          },
          {
            "cid": 605,
            "sid": "get-focused-row",
            "name": "get-focused-row",
            "label": "getFocusedRow",
            "data": {
              "body": "> 시트 내에 현재 포커스된 셀(또는 행)의 [데이터 로우 객체](/docs/appx/row-object)를 반환합니다. ### Syntax ```javascript object getFocusedRow(); ``` ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //현재 포커스된 셀의 데이터 로우 객체를 반환합니다. var row = sheet.getFocusedRow(); ```",
              "see": [
                {
                  "label": "getFocusedCol method",
                  "url": "./get-focused-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-focused-row.html"
          },
          {
            "cid": 606,
            "sid": "get-format",
            "name": "get-format",
            "label": "getFormat",
            "data": {
              "body": "> 특정 셀의 Format을 확인합니다. ### Syntax ```javascript string getFormat( row, col, edit ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| |edit|`boolean`|<span class='optional'>선택</span>|EditFormat 확인 `0(false)`:`Format` 값을 리턴 (`default`) `1(true)`:`EditFormat` 값을 리턴| ### Return Value ***string*** : 셀에 설정한 Format 문자열 (Format이 설정되지 않은 셀은 공백(\"\")을 리턴) ### Example ```javascript //날짜 셀에서 포맷 확인 var f = sheet.getFormat( sheet.getFocusedRow(), \"EnterDate\" ); var ef = sheet.getFormat( sheet.getFocusedRow(), \"EnterDate\", 1); if(f==\"yyyy/MM/dd\" && ef == \"yyyyMMdd\"){ alert(\"'년/월/일' 순서 포맷입니다. \"); } ```",
              "see": [
                {
                  "label": "getType method",
                  "url": "./get-type"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-format.html"
          },
          {
            "cid": 607,
            "sid": "get-formula-row-position",
            "name": "get-formula-row-position",
            "label": "getFormulaRowPosition",
            "data": {
              "body": "> `FormulaRow`(합계행)의 위치 (하단(기본값), 상단) 값을 얻어 올 수 있습니다. ### Syntax ```javascript number getFormulaRowPosition(); ``` ### Return Value ***number*** : FormulaRow의 위치 값 ### Example ```javascript //합계행의 위치를 가져옵니다. var pos = sheet.getFormulaRowPosition(); ```",
              "see": [
                {
                  "label": "setFormulaRow method",
                  "url": "./set-formula-row"
                },
                {
                  "label": "setFormulaRowPosition method",
                  "url": "./set-formula-row-position"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-formula-row-position.html"
          },
          {
            "cid": 608,
            "sid": "get-group-rows",
            "name": "get-group-rows",
            "label": "getGroupRows",
            "data": {
              "body": "> 그룹으로 생성된 그룹행들을 반환합니다. > 리턴 값은 다음과 같습니다 > {그룹 컬럼명1: [컬럼명1로 생성된 그룹 행들], 그룹 컬럼명2 : [컬럼명2로 생성된 그룹 행들], ...} ### Syntax ```javascript object getGroupRows(); ``` ### Return Value ***object*** ### Example ```javascript //그룹 행을 얻습니다. var groupRows = sheet.getGroupRows(); ```",
              "see": [
                {
                  "label": "GroupMain cfg",
                  "url": "/docs/props/cfg/group-main"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-group-rows.html"
          },
          {
            "cid": 609,
            "sid": "get-header-rows",
            "name": "get-header-rows",
            "label": "getHeaderRows",
            "data": {
              "body": "> 헤더 영역에 있는 [헤더 로우 객체](/docs/appx/row-object)들의 배열을 반환합니다. ### Syntax ```javascript object getHeaderRows( ); ``` ### Return Value ***array[row object]*** : 헤더 영역에 있는 [헤더 로우 객체](/docs/appx/row-object)들의 배열 ### Example ```javascript //행의 유형을 확인 var headers = sheet.getHeaderRows(); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-header-rows.html"
          },
          {
            "cid": 610,
            "sid": "get-last-col",
            "name": "get-last-col",
            "label": "getLastCol",
            "data": {
              "body": "> 최 우측 열이름을 확인합니다. > section을 통해 특정 영역의 최 우측 열을 확인할 수도 있습니다. > 해당 함수는 기본적으로 보여지는 열을 기준으로 확인합니다. > `includeHideCol` 또는 `Cfg: GetColWithHide` 를 설정하여 `Visible` 관계없이 가져옵니다. > 우선 순위는 `includeHideCol` > `GetColWithHide` 임으로, `GetColWithHide`를 `true`로 설정 하여도 `includeHideCol`을 `false`로 설정시에는 보여지는 열을 기준으로 동작하게 할 수 있습니다. ### Syntax ```javascript string getLastCol( section, includeHideCol ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |section|`number`|<span class='optional'>선택</span>|틀고정 기준 영역 지정 `0`:좌측 (RightCols(우측), Cols(가운데) 정보가 없을 경우 `default`) `1`:가운데 (RightCols(우측) 정보가 없을 경우 `default`) `2`:우측 (`default`)| |includeHideCol|`boolean`|<span class='optional'>선택</span>|`true` 설정시 `Col.Visible` 관계없이 콜을 추출함 `0(false)`:숨김 열을 계산 대상으로 포함하지 않음 (`default`) `1(true)`:숨김 열도 계산 대상으로 포함| ### Return Value ***string*** : 우측에 위치한 열이름 ### Example ```javascript //최 우측의 열이름을 확인한다. var lcol = sheet.getLastCol(); ```",
              "see": [
                {
                  "label": "getFirstCol method",
                  "url": "./get-first-col"
                },
                {
                  "label": "GetColWithHide cfg",
                  "url": "/docs/props/cfg/get-col-with-hide"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.11|`includeHideCol` 인자 추가|"
            },
            "url": "docs/funcs/core/get-last-col.html"
          },
          {
            "cid": 611,
            "sid": "get-last-pageindex",
            "name": "get-last-pageindex",
            "label": "getLastPageIndex",
            "data": {
              "body": "> 페이징 조회 방식에서 마지막 페이지의 인덱스를 반환합니다. ### Syntax ```javascript number getLastPageIndex(); ``` ### Return Value ***number*** : 마지막 페이지 인덱스 ### Example ```javascript // 현재 조회된 마지막 페이지의 인덱스를 얻습니다. var lastIndex = sheet.getLastPageIndex(); ``` ### Since |product|version|desc| |---|---|---| |core|8.1.0.78|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|8.1.0.78|기능 추가|"
            },
            "url": "docs/funcs/core/get-last-pageindex.html"
          },
          {
            "cid": 612,
            "sid": "get-last-row",
            "name": "get-last-row",
            "label": "getLastRow",
            "data": {
              "body": "> 최 하단행을 확인합니다. > 트리 기능 사용시 row 인자를 설정하면 행이 갖고있는 마지막 자식행이 리턴됩니다. ### Syntax ```javascript object getLastRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //최 하단행을 얻습니다. var lrow = sheet.getLastRow(); ```",
              "see": [
                {
                  "label": "getLastVisibleRow method",
                  "url": "./get-last-visible-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-last-row.html"
          },
          {
            "cid": 613,
            "sid": "get-last-visible-row",
            "name": "get-last-visible-row",
            "label": "getLastVisibleRow",
            "data": {
              "body": "> 보여지는 최 하단행(`Visible: 1`)인 속성을 확인합니다. > 트리 기능 사용시 row 인자를 설정하면 행이 갖고있는 보여지는 마지막 자식행이 리턴됩니다. ### Syntax ```javascript object getLastVisibleRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='optional'>선택</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //보여지는 최 하단행을 얻습니다. var lrow = sheet.getLastVisibleRow(); ```",
              "see": [
                {
                  "label": "getLastRow method",
                  "url": "./get-last-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-last-visible-row.html"
          },
          {
            "cid": 614,
            "sid": "get-locale",
            "name": "get-locale",
            "label": "getLocale",
            "data": {
              "body": "> 시트에 설정된 언어 코드를 가져오는 메소드입니다. ### Syntax ```javascript void getLocale(); ``` ### Return Value ***string*** : 시트에 설정된 언어 코드 ### Example ```javascript sheet.getLocale(); ```",
              "see": [
                {
                  "label": "setLocale method",
                  "url": "./set-locale"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.2|기능 추가|"
            },
            "url": "docs/funcs/core/get-locale.html"
          },
          {
            "cid": 615,
            "sid": "get-merge-range",
            "name": "get-merge-range",
            "label": "getMergeRange",
            "data": {
              "body": "> 특정 셀을 기준으로 머지된 영역(RowSpan,Span)을 확인합니다. > 지정한 셀을 기준으로 머지 시작셀(좌측 상단 셀)과 종료셀(우측 하단 셀)을 배열로 리턴합니다. ### Syntax ```javascript array getMergeRange( row, col); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|병합기준 [데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|병합기준 열이름| ### Return Value ***object (array[])*** : 머지 시작 행, 머지 시작 열, 머지 종료 행, 머지 종료 열 순차적으로 들어있는 배열 리턴 [시작[데이터 로우 객체](/docs/appx/row-object) , 시작열이름 , 종료[데이터 로우 객체](/docs/appx/row-object) , 종료열이름 ] *머지되지 않은 셀의 경우 파라미터로 입력한 row와 리턴되는 시작 행,종료 행이 동일하고 마찬가지로 파라미터로 입력한 col과 리턴되는 시작 열,종료 열이 동일합니다.* ### Example ```javascript //AR2행, deptCd열이 주변과 병합된 경우 병합영역을 리턴 var mergeArr = sheet.getMergeRange( sheet.getRowById(\"AR2\"), \"deptCd\"); var mergeStartRow = mergeArr[0]; // 머지 시작 행 var mergeStartCol = mergeArr[1]; // 머지 시작 열 var mergeEndRow = mergeArr[2]; // 머지 종료 행 var mergeEndCol = mergeArr[3]; // 머지 종료 열 ```",
              "see": [
                {
                  "label": "setMergeRange method",
                  "url": "./set-merge-range"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/funcs/core/get-merge-range.html"
          },
          {
            "cid": 616,
            "sid": "get-message",
            "name": "get-message",
            "label": "getMessage",
            "data": {
              "body": "> 시트에서 메시지를 가져옵니다. ### Syntax ```javascript string getMessage( key, type ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |key|`string`|<span class='required'>필수</span>|메시지 이름| |type|`string`|<span class='optional'>선택</span>|가져올 메시지 종류 `'Alert'`, `'Text'(default)` 중 선택| ### Return Value ***String*** ### Example ```javascript // msg 파일의 Alert 밑에 있는 CanCancelChanges 메시지 내용을 가져옵니다. var message1 = sheet.getMessage(\"CanCancelChanges\", \"Alert\"); // msg 파일의 Text 밑에 있는 CanCancelChanges 메시지 내용을 가져옵니다. var message2 = sheet.getMessage(\"Render\"); ```",
              "see": [
                {
                  "label": "setMessage method",
                  "url": "./set-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-message.html"
          },
          {
            "cid": 617,
            "sid": "get-mouse-col",
            "name": "get-mouse-col",
            "label": "getMouseCol",
            "data": {
              "body": "> 현재 마우스 아래에 있는 열이름을 반환합니다. ### Syntax ```javascript string getMouseCol(); ``` ### Return Value ***String*** : 열이름 ### Example ```javascript var mCol = sheet.getMouseCol(); ```",
              "see": [
                {
                  "label": "getMouseRow method",
                  "url": "./get-mouse-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-mouse-col.html"
          },
          {
            "cid": 618,
            "sid": "get-mouse-row",
            "name": "get-mouse-row",
            "label": "getMouseRow",
            "data": {
              "body": "> 현재 마우스 아래에 있는 행 객체를 반환합니다. ### Syntax ```javascript object getMouseRow(); ``` ### Return Value ***row Object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript var eRow = sheet.getMouseRow(); ```",
              "see": [
                {
                  "label": "getMouseCol method",
                  "url": "./get-mouse-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-mouse-row.html"
          },
          {
            "cid": 619,
            "sid": "get-next-col",
            "name": "get-next-col",
            "label": "getNextCol",
            "data": {
              "body": "> 지정한 컬럼의 다음 컬럼명을 리턴합니다. > 해당 함수는 기본적으로 보여지는 열을 기준으로 확인합니다. > `includeHideCol` 또는 `Cfg: GetColWithHide` 를 설정하여 `Visible` 관계없이 가져옵니다. > 우선 순위는 `includeHideCol` > `GetColWithHide` 임으로, `GetColWithHide`를 `true`로 설정 하여도 `includeHideCol`을 `false`로 설정시에는 보여지는 열을 기준으로 동작하게 할 수 있습니다. ### Syntax ```javascript string getNextCol( col, includeHideCol ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|열이름 |includeHideCol|`boolean`|<span class='optional'>선택</span>숨김 열을 기준에 포함 여부 `0(false)`:숨김 열을 계산 대상으로 포함하지 않음 (`default`) `1(true)`:숨김 열도 계산 대상으로 포함| ### Return Value ***string*** : 열 이름 ### Example ```javascript //다음 컬럼명을 리턴합니다. var fcol = sheet.getNextCol(sheet.getFocusedCol()); ```",
              "see": [
                {
                  "label": "getPrevCol method",
                  "url": "./get-prev-col"
                },
                {
                  "label": "GetColWithHide cfg",
                  "url": "/docs/props/cfg/get-col-with-hide"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가||core|8.0.0.11|`includeHideCol` 인자 추가|"
            },
            "url": "docs/funcs/core/get-next-col.html"
          },
          {
            "cid": 620,
            "sid": "get-next-row",
            "name": "get-next-row",
            "label": "getNextRow",
            "data": {
              "body": "> 지정한 행의 바로 아래 행을 리턴합니다. > 마지막 행인 경우 `null`이 리턴됩니다. ### Syntax ```javascript object getNextRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR5행의 다음 행을 확인. var row = sheet.getRowById(\"AR55\"); var nrow = sheet.getNextRow(row); ```",
              "see": [
                {
                  "label": "getPrevRow method",
                  "url": "./get-prev-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-next-row.html"
          },
          {
            "cid": 621,
            "sid": "get-next-shift",
            "name": "get-next-shift",
            "label": "getNextShift",
            "data": {
              "body": "> [데이터 로우 객체](/docs/appx/row-object)를 대상으로 사용가능한 탐색 메소드입니다. > 기준이 되는 [데이터 로우 객체](/docs/appx/row-object)에서 2번째 인자의 수만큼 이후에 위치한 [데이터 로우 객체](/docs/appx/row-object)를 탐색해서 리턴합니다. ### Syntax ```javascript object getNextShift(row, cnt); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|검색 기준이 되는 [데이터 로우 객체](/docs/appx/row-object)| |cnt|`number`|<span class='optional'>선택</span>|기준으로부터 탐색하고자 하는 개수| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR55행의 7번째 위에 위치한 행을 확인. var row = sheet.getRowById(\"AR55\"); var nrow = sheet.getNextShift(row, 7); ```",
              "see": [
                {
                  "label": "getPrevShift method",
                  "url": "./get-prev-shift"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-next-shift.html"
          },
          {
            "cid": 622,
            "sid": "get-next-sibling-row",
            "name": "get-next-sibling-row",
            "label": "getNextSiblingRow",
            "data": {
              "body": "> 트리나 그룹사용시 같은 부모를 갖는 동일 레벨의 아래 행을 리턴합니다. > 같은 부모 내에서 더 이상 동일레벨이 없는 경우 `null`이 리턴됩니다. ### Syntax ```javascript object getNextSiblingRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR55행의 아래 자식행들 안에 CHK값이 1인 행을 찾는다. var row = sheet.getRowById(\"AR55\"); var crow = sheet.getFirstRow(row); //첫번째 자식을 얻음 if(crow){ var chkRows = []; do{ if (crow[\"CHK\"] == 1) { chkRows.push(crow); } crow = sheet.getNextSiblingRow(crow); }while(crow); } ```",
              "see": [
                {
                  "label": "getPrevSiblingRow method",
                  "url": "./get-prev-sibling-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-next-sibling-row.html"
          },
          {
            "cid": 623,
            "sid": "get-next-sibling-visible-row",
            "name": "get-next-sibling-visible-row",
            "label": "getNextSiblingVisibleRow",
            "data": {
              "body": "> 트리나 그룹 사용시 같은 부모를 갖는 동일 레벨의 보여지는(`Visible:1`) 아래 행을 리턴합니다. > 같은 부모 내에서 더 이상 보여지는 동일레벨이 없는 경우 `null`이 리턴됩니다. ### Syntax ```javascript object getNextSiblingVisibleRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //선택한 행과 같은 레벨의 보여지는 아래 행을 얻는다. var frow = sheet.getFocusedRow() var crow = sheet.getNextSiblingVisibleRow(frow); ```",
              "see": [
                {
                  "label": "getPrevSiblingVisibleRow method",
                  "url": "./get-prev-sibling-visible-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-next-sibling-visible-row.html"
          },
          {
            "cid": 624,
            "sid": "get-next-visible-row",
            "name": "get-next-visible-row",
            "label": "getNextVisibleRow",
            "data": {
              "body": "> 인자로 받은 행으로부터 아래에 보이는 행을 리턴합니다. ### Syntax ```javascript object getNextVisibleRow(row); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript // 포커스된 행으로부터 바로 아래에에 있는 행을 얻는다. var frow = sheet.getFocusedRow(); var crow = sheet.getNextVisibleRow(frow); ```",
              "see": [
                {
                  "label": "getPrevSiblingVisibleRow method",
                  "url": "./get-prev-sibling-visible-row"
                },
                {
                  "label": "getNextSiblingVisibleRow method",
                  "url": "./get-next-sibling-visible-row"
                },
                {
                  "label": "getPrevVisibleRow method",
                  "url": "./get-prev-visible-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/funcs/core/get-next-visible-row.html"
          },
          {
            "cid": 625,
            "sid": "get-page-by-index",
            "name": "get-page-by-index",
            "label": "getPageByIndex",
            "data": {
              "body": "> 특정 `index`를 갖는 [페이지 객체](/docs/appx/page-object)를 리턴합니다. > `index`는 `0`부터 시작합니다. ### Syntax ```javascript object getPageByIndex( index ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |index|`number`|<span class='required'>필수</span>|얻고자하는 페이지 순서 번호 ### Return Value ***page object*** : 지정한 순서에 해당하는 [페이지 객체](/docs/appx/page-object) ### Example ```javascript //15번 페이지 객체를 얻음 var pageObj = sheet.getPageByIndex(15); ```",
              "see": [
                {
                  "label": "getPageIndex method",
                  "url": "./get-page-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-page-by-index.html"
          },
          {
            "cid": 626,
            "sid": "get-page-by-row",
            "name": "get-page-by-row",
            "label": "getPageByRow",
            "data": {
              "body": "> 특정 [데이터 로우 객체](/docs/appx/row-object)가 위치한 [페이지 객체](/docs/appx/page-object)를 리턴합니다. ### Syntax ```javascript object getPageByRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object) ### Return Value ***page object*** : row를 포함하고 있는 [페이지 객체](/docs/appx/page-object) ### Example ```javascript //마지막 페이지 객체를 얻는다. var lastRow = sheet.getLastRow(); var lastPageObj = sheet.getPageByRow(lastRow); ```",
              "see": [
                {
                  "label": "getPageIndex method",
                  "url": "./get-page-index"
                },
                {
                  "label": "getPageByIndex method",
                  "url": "./get-page-by-index"
                },
                {
                  "label": "getPageIndexByRow method",
                  "url": "./get-page-index-by-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-page-by-row.html"
          },
          {
            "cid": 627,
            "sid": "get-page-index",
            "name": "get-page-index",
            "label": "getPageIndex",
            "data": {
              "body": "> 페이지의 `index`를 확인합니다. > `index`는 `0`부터 시작합니다. ### Syntax ```javascript number getPageIndex( page ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |page|`object`|<span class='required'>필수</span>|페이지 데이터 객체 ### Return Value ***number*** : [페이지 객체](/docs/appx/page-object)의 index 번호 ### Example ```javascript //현재 포커스가 위치한 페이지 var page = sheet.getFocusedPage(); //페이지 인덱스 확인 var pidx = sheet.getPageIndex(page); ```",
              "see": [
                {
                  "label": "getPageByIndex method",
                  "url": "./get-page-by-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-page-index.html"
          },
          {
            "cid": 628,
            "sid": "get-parent-rows",
            "name": "get-parent-rows",
            "label": "getParentRows",
            "data": {
              "body": "> 특정 행의 전체 부모 행 객체를 배열 형태로 반환합니다. ### Syntax ```javascript array getParentRows( row ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***array[row object]*** : [데이터 로우 객체](/docs/appx/row-object) 배열 ### Example ```javascript // 포커스된 행의 부모 행들을 가져옵니다. var childNodes = sheet.getParentRows(sheet.getFocusedRow()); ```",
              "see": [
                {
                  "label": "getChildRows method",
                  "url": "./get-child-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-parent-rows.html"
          },
          {
            "cid": 629,
            "sid": "get-pivot-filter-rows",
            "name": "get-pivot-filter-rows",
            "label": "getPivotFilterRows",
            "data": {
              "body": "> 피벗 시트에서 특정 셀의 데이터를 구성하는 원본 시트의 행을 가져오는 함수입니다. > <mark>**주의!: 해당 API는 원본 시트의 필터링 내용을 제거합니다. API 사용시 원본 시트의 필터링 내용이 변경될 수 있습니다.**</mark> ### Syntax ```javascript object getPivotFilterRows( row, col ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| ### Return Value ***array[row object]*** : 필터된 원본 시트 [데이터 로우 객체](/docs/appx/row-object)들의 배열 ### Example ```js var focusRow = pivotSheet_sheet.getFocusedRow(); var focusCol = pivotSheet_sheet.getFocusedCol(); // 피벗 데이터를 구성하는 행을 가져오기 var datas = pivotSheet_sheet.getPivotFilterRows(focusRow, focusCol); ```",
              "see": [
                {
                  "label": "makePivotTable method",
                  "url": "./make-pivot-table"
                },
                {
                  "label": "switchPivotSheet method",
                  "url": "./switch-pivot-sheet"
                },
                {
                  "label": "ClickPivotFilter",
                  "url": "/docs/props/cfg/click-pivot-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.28|기능 추가|"
            },
            "url": "docs/funcs/core/get-pivot-filter-rows.html"
          },
          {
            "cid": 630,
            "sid": "get-prev-col",
            "name": "get-prev-col",
            "label": "getPrevCol",
            "data": {
              "body": "> 지정한 열의 바로 앞에 위치한 열을 리턴합니다. > 지정한 열이 첫번째 열인 경우 `null`이 리턴됩니다. > 해당 함수는 기본적으로 보여지는 열을 기준으로 확인합니다. > `includeHideCol` 또는 `Cfg: GetColWithHide` 를 설정하여 `Visible` 관계없이 가져옵니다. > 우선 순위는 `includeHideCol` > `GetColWithHide` 임으로, `GetColWithHide`를 `true`로 설정 하여도 `includeHideCol`을 `false`로 설정시에는 보여지는 열을 기준으로 동작하게 할 수 있습니다. ### Syntax ```javascript string getPrevCol( col, includeHideCol ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|열이름 |includeHideCol|`boolean`|<span class='optional'>선택</span>|숨김 열을 기준에 포함 여부 `0(false)`:숨김 열을 계산 대상으로 포함하지 않음 (`default`) `1(true)`:숨김 열도 계산 대상으로 포함| ### Return Value ***string*** : 열 이름 ### Example ```javascript //3번째 index의 열의 앞 열을 확인. var col = sheet.getColByIndex(3); var prevCol = sheet.getPrevCol(col); ```",
              "see": [
                {
                  "label": "getNextCol method",
                  "url": "./get-next-col"
                },
                {
                  "label": "GetColWithHide cfg",
                  "url": "/docs/props/cfg/get-col-with-hide"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가||core|8.0.0.11|`includeHideCol` 인자 추가|"
            },
            "url": "docs/funcs/core/get-prev-col.html"
          },
          {
            "cid": 631,
            "sid": "get-prev-row",
            "name": "get-prev-row",
            "label": "getPrevRow",
            "data": {
              "body": "> 지정한 행의 바로 위에 위치한 행을 리턴합니다. > 지정한 행이 첫번째 행인 경우 `null`이 리턴됩니다. ### Syntax ```javascript object getPrevRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR55행의 위행을 확인. var row = sheet.getRowById(\"AR55\"); var nrow = sheet.getPrevRow(row); ```",
              "see": [
                {
                  "label": "getNextRow method",
                  "url": "./get-next-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-prev-row.html"
          },
          {
            "cid": 632,
            "sid": "get-prev-shift",
            "name": "get-prev-shift",
            "label": "getPrevShift",
            "data": {
              "body": "> [데이터 로우 객체](/docs/appx/row-object)를 대상으로 사용가능한 탐색 메소드입니다. > 기준이 되는 [데이터 로우 객체](/docs/appx/row-object)에서 2번째 인자의 수만큼 이전에 위치한 [데이터 로우 객체](/docs/appx/row-object)를 탐색해서 리턴합니다. ### Syntax ```javascript object getPrevShift( row, cnt ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|검색 기준이 되는 [데이터 로우 객체](/docs/appx/row-object)| |cnt|`number`|<span class='optional'>선택</span>|기준으로부터 탐색하고자 하는 개수| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR55행의 7번째 위에 위치한 행을 확인. var row = sheet.getRowById(\"AR55\"); var nrow = sheet.getPrevShift(row,7); ```",
              "see": [
                {
                  "label": "getNextShift method",
                  "url": "./get-next-shift"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-prev-shift.html"
          },
          {
            "cid": 633,
            "sid": "get-prev-sibling-row",
            "name": "get-prev-sibling-row",
            "label": "getPrevSiblingRow",
            "data": {
              "body": "> 트리나 그룹사용시 같은 부모를 갖는 동일 레벨의 위에 위치한 행을 리턴합니다. > 같은 부모 내에서 더 이상 동일레벨이 없는 경우 `null`이 리턴됩니다. ### Syntax ```javascript object getPrevSiblingRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //현재 선택된 행의 자식 노드 중에 chk열에 값이 1인 행들을 찾아 배경색을 변경한다. function work(){ var row = sheet.getFocusedRow();//현재 선택된 행 var crow = sheet.getLastRow(row); //마지막 자식을 얻음 if(crow){ var chkRows = []; do{ if(crow[\"chk\"] == 1){ //배경색을 회색으로 변경 sheet.setAttribute( {row:crow , attribute:\"Color\" , val:\"#AAAAAA\",render:0} ); } crow = sheet.getPrevSiblingRow(crow); }while(crow); //수정 후 한꺼번에 렌더링 sheet.renderBody(); } } ```",
              "see": [
                {
                  "label": "getNextSiblingRow method",
                  "url": "./get-next-sibling-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-prev-sibling-row.html"
          },
          {
            "cid": 634,
            "sid": "get-prev-sibling-visible-row",
            "name": "get-prev-sibling-visible-row",
            "label": "getPrevSiblingVisibleRow",
            "data": {
              "body": "> 트리나 그룹사용시 같은 부모를 갖는 동일 레벨의 보여지는(`Visible:1`) 위에 위치한 행을 리턴합니다. > 같은 부모 내에서 더 이상 보여지는 동일레벨이 없는 경우 `null`이 리턴됩니다. ### Syntax ```javascript object getPrevSiblingVisibleRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //현재 선택된 행과 같은 레벨을 갖는 위의 행을 리턴 var row = sheet.getFocusedRow(); var crow = sheet.getPrevSiblingVisibleRow(row); ```",
              "see": [
                {
                  "label": "getNextSiblingVisibleRow method",
                  "url": "./get-next-sibling-visible-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-prev-sibling-visible-row.html"
          },
          {
            "cid": 635,
            "sid": "get-prev-visible-row",
            "name": "get-prev-visible-row",
            "label": "getPrevVisibleRow",
            "data": {
              "body": "> 인자로 받은 행으로부터 위에 보이는 행을 리턴합니다. ### Syntax ```javascript object getPrevVisibleRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript // 포커스된 행으로부터 바로 위에 있는 행을 얻는다. var frow = sheet.getFocusedRow(); var crow = sheet.getPrevVisibleRow(frow); ```",
              "see": [
                {
                  "label": "getPrevSiblingVisibleRow method",
                  "url": "./get-prev-sibling-visible-row"
                },
                {
                  "label": "getNextSiblingVisibleRow method",
                  "url": "./get-next-sibling-visible-row"
                },
                {
                  "label": "getNextVisibleRow method",
                  "url": "./get-next-visible-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.5|기능 추가|"
            },
            "url": "docs/funcs/core/get-prev-visible-row.html"
          },
          {
            "cid": 636,
            "sid": "get-row-by-id",
            "name": "get-row-by-id",
            "label": "getRowById",
            "data": {
              "body": "> ID를 기준으로 [데이터 로우 객체](/docs/appx/row-object)를 반환합니다. ### Syntax ```javascript string getRowById( id ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|행의 id| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //AR5 행객체를 얻어 상태를 삭제로 변경한다. var row = sheet.getRowById(\"AR5\"); row[\"Deleted\"] = 1; sheet.renderBody(); ```",
              "see": [
                {
                  "label": "getRowIndex method",
                  "url": "./get-row-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-row-by-id.html"
          },
          {
            "cid": 637,
            "sid": "get-row-by-index",
            "name": "get-row-by-index",
            "label": "getRowByIndex",
            "data": {
              "body": "> 인덱스를 기준으로 [데이터 로우 객체](/docs/appx/row-object)를 확인합니다. > 인덱스는 `1`부터 시작 > 감취진 행은 index계산에서 제외됩니다. ### Syntax ```javascript object getRowByIndex( index ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |index|`number`|<span class='required'>필수</span>|행 인덱스(1부터 시작)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //5번 index행의 데이터 로우 객체를 얻습니다. var rowObj = sheet.getRowByIndex(5); ```",
              "see": [
                {
                  "label": "getRowById method",
                  "url": "./get-row-by-id"
                },
                {
                  "label": "getRowIndex method",
                  "url": "./get-row-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-row-by-index.html"
          },
          {
            "cid": 638,
            "sid": "get-row-height",
            "name": "get-row-height",
            "label": "getRowHeight",
            "data": {
              "body": "> 특정행의 높이를 pixel 단위로 확인합니다. ### Syntax ```javascript number getRowHeight( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***number*** : 행의 높이 (pixel 단위) ### Example ```javascript var r = sheet.getFirstVisibleRow(); //첫번째 행의 높이를 확인 var height = sheet.getRowHeight(r); ```",
              "see": [
                {
                  "label": "getBodyHeight method",
                  "url": "./get-body-height"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-row-height.html"
          },
          {
            "cid": 639,
            "sid": "get-row-index",
            "name": "get-row-index",
            "label": "getRowIndex",
            "data": {
              "body": "> [데이터 로우 객체](/docs/appx/row-object)의 인덱스를 반환합니다. > 인덱스는 `1`부터 시작합니다. > [Visible](/docs/props/row/visible):0 인 Row는 인덱스가 반환되지 않습니다. ### Syntax ```javascript number getRowIndex( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***number*** : 행의 index ### Example ```javascript //AR5 행의 index를 확인합니다. var row = sheet.getRowById(\"AR5\"); var idx = sheet.getRowIndex(row); ```",
              "see": [
                {
                  "label": "getRowById method",
                  "url": "./get-row-by-id"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-row-index.html"
          },
          {
            "cid": 640,
            "sid": "get-row-kind",
            "name": "get-row-kind",
            "label": "getRowKind",
            "data": {
              "body": "> 행의 유형을 확인합니다. > 행이 유형은 `Data(데이터영역), Header(헤더영역), Head(상단고정), Foot(합계행 혹은 하단고정), Filter(필터행), Group(그룹행), Space(건수정보표시행 혹은 솔리드행)` 등이 있습니다. ### Syntax ```javascript string getRowKind( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***string*** : 행의 유형 ### Example ```javascript //행의 유형을 확인 var rowKind = sheet.getRowKind(rowObj); ```",
              "see": [
                {
                  "label": "Kind appedix",
                  "url": "/docs/appx/kind"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-row-kind.html"
          },
          {
            "cid": 641,
            "sid": "get-row-top",
            "name": "get-row-top",
            "label": "getRowTop",
            "data": {
              "body": "> 데이터 행 내에서 y좌표값을 확인합니다. > 최상단 행은 `0`을 리턴합니다. ### Syntax ```javascript number getRowTop( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***number*** : 데이터 영역 최상단을 기준으로 행의 y좌표 (pixel 단위) ### Example ```javascript //선택행의 RowTop 값을 가져온다. var w = sheet.getRowTop( sheet.getFocusedRow() ); ```",
              "see": [
                {
                  "label": "getBodyHeight method",
                  "url": "./get-body-height"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-row-top.html"
          },
          {
            "cid": 642,
            "sid": "get-row-value",
            "name": "get-row-value",
            "label": "getRowValue",
            "data": {
              "body": "> 특정 [데이터 로우 객체](/docs/appx/row-object)에 해당하는 값을 json 형식의 객체로 반환합니다. ### Syntax ```javascript object getRowValue( row, saveExtraAttr, saveAttr ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |saveExtraAttr|`boolean`|<span class='optional'>선택</span>|시트에 (col)[Name](/docs/props/col/name)으로 정의하지 않은 데이터가 [doSearch](/docs/funcs/core/do-search)나 [loadSearchData](/docs/funcs/core/load-search-data)함수를 통해 로드 된 경우, 함수 호출시 해당 데이터를 같이 추출할 지 여부. 로드 데이터 첫번째 행의 keyset을 기준으로 추출됨. `0(false)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 된 데이터만 추출 `(default)` `1(true)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 되지 않은 데이터도 추출| |saveAttr|`string`|<span class='optional'>선택</span>|각 셀의 속성값을 같이 추출하고자 하는 경우 Name+속성명 형식으로 설정 여러개 속성을 추출하고자 하는 경우 \",\"를 구분자로 작성 ex) \"sNameColor,sNoCanEdit\"| ### Return Value ***json 형식의 object*** ```json { \"ColName1\":\"12345\",\"ColName2\":\"ABCDE\" ...} ``` ### Example ```javascript var rowValue = sheet.getRowValue(sheet.getRowById(\"AR5\")); ```",
              "see": [
                {
                  "label": "getValue method",
                  "url": "./get-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가||core|8.1.0.32|`saveExtraAttr` 인자 추가||core|8.2.0.3|`saveAttr` 인자 추가|"
            },
            "url": "docs/funcs/core/get-row-value.html"
          },
          {
            "cid": 643,
            "sid": "get-rows-by-checked",
            "name": "get-rows-by-checked",
            "label": "getRowsByChecked",
            "data": {
              "body": "> 인자 열의 [Type](/docs/appx/type)이 Bool인 경우 해당 열에 체크된 모든 [데이터 로우 객체](/docs/appx/row-object)를 배열로 리턴합니다. ### Syntax ```javascript object getRowsByChecked( col ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|열이름| ### Return Value ***mixed ( `array` \\| `boolean` )*** : 열이 Bool 타입이 아닌 경우 false를 리턴하고, 그 외는 [데이터 로우 객체](/docs/appx/row-object)의 배열을 리턴합니다. ### Example ```javascript // sCheck 열이 체크된 데이터 로우 객체들을 가져옵니다. var rows = sheet.getRowsByChecked( \"sCheck\" ); if (rows && rows.length == 0) { ... } else { ... } ```",
              "see": [
                {
                  "label": "setCheck method",
                  "url": "./set-check"
                },
                {
                  "label": "setAllCheck method",
                  "url": "./set-all-check"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.3|name 인자명 변경 -> col, 다른 API와 통일|"
            },
            "url": "docs/funcs/core/get-rows-by-checked.html"
          },
          {
            "cid": 644,
            "sid": "get-rows-by-dup",
            "name": "get-rows-by-dup",
            "label": "getRowsByDup",
            "data": {
              "body": "> 열 내에 중복된 데이터를 가진 [데이터 로우 객체](/docs/appx/row-object)들을 리턴합니다. > 여러 개의 열이름을 설정 시 열이름에 해당하는 열들의 셀 값이 모두 같은 경우에만 [데이터 로우 객체](/docs/appx/row-object)를 반환합니다. ### Syntax ```javascript object getRowsByDup( cols, firstOnly, emptyVal, subsum, exceptStatus ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |cols|`string`|<span class='required'>필수</span>|비교할 대상이 되는 열이름 \",\"를 구분자로 사용하여 복수 개의 열이름들을 지정 가능| |firstOnly|`boolean`|<span class='optional'>선택</span>|처음으로 중복된 행을 반환할지 여부 설정 시 가장 먼저 중복된 행을 리턴합니다(원래 값을 가지는 [데이터 로우 객체](/docs/appx/row-object), 중복된 [데이터 로우 객체](/docs/appx/row-object)로 이루어진 배열). `0(false)`:처음으로 중복된 행 반환 사용 안함 (`default`) `1(true)`:처음으로 중복된 행 반환 사용| |emptyVal|`boolean`|<span class='optional'>선택</span>|\"\", undefined, null 값을 가지는 행을 비교 대상에 포함할지 여부 `0(false)`:중복된 값 비교 대상에 \"\", undefined, null 값을 가진 행을 포함 안함 (`default`) `1(true)`:중복된 값 비교 대상에 \"\", undefined, null 값을 가진 행을 포함| |subsum|`boolean`|<span class='optional'>선택</span>|중복된 값 비교할 때 소계행을 사용할 지 여부 `0(false)`:중복된 값 비교대상에 소계행 포함 안함 (`default`) `1(true)`:중복된 값 비교대상에 소계행 포함| |exceptStatus|`string`|<span class='optional'>선택</span>|비교대상에서 제외할 행의 상태 \",\"를 구분자로 사용하여 복수 개의 상태값들을 지정 가능| ### Return Value ***array[row object]*** : 중복된 값을 가지는 [데이터 로우 객체](/docs/appx/row-object)들의 배열의 배열(각기 다른 중복된 값 마다 생성된 [데이터 로우 객체](/docs/appx/row-object)들의 배열) ### Example ```javascript // sName, sSalary의 열이 서로 같은 값을 가지는 데이터 로우 객체들의 배열의 배열을 리턴합니다. // ex) [ [r1, r2...] [r5, r9...] ] // r1과 r2는 sName, sSalary의 값이 같습니다. r5과 r9..는 sName, sSalary의 값이 같습니다. // Added, Deleted 상태의 로우 객체는 제외하여 리턴합니다. sheet.getRowsByDup( \"sName,sSalary\" , false, false, false, \"Added,Deleted\" ); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.8|exceptStatus 기능 추가|"
            },
            "url": "docs/funcs/core/get-rows-by-dup.html"
          },
          {
            "cid": 645,
            "sid": "get-rows-by-status",
            "name": "get-rows-by-status",
            "label": "getRowsByStatus",
            "data": {
              "body": "> 특정 상태의 행을 배열로 리턴 합니다. > 행이 상태는 `Added, Changed, Deleted`이 있습니다. > 속성명 앞에 `!`를 붙이면 해당 속성의 값이 참(`true` or `1`)이더라도 건너뛸 수 있습니다. ### Syntax ```javascript array getRowsByStatus( status ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |status|`string`|<span class='required'>필수</span>|상태값(여러개 상태를 동시에 확인하고자 하는 경우에는 \",\"구분자로 연결| ### Return Value ***array[row object]*** : [데이터 로우 객체](/docs/appx/row-object) 배열 ### Example ```javascript // 수정된 행을 모두 얻습니다. var chgRows = sheet.getRowsByStatus(\"Changed\"); // 신규로 추가되거나 수정된 행을 모두 얻습니다. var rows = sheet.getRowsByStatus(\"Added,Changed\"); // Added 속성이 설정되어 있으면서, Deleted 속성이 설정되지 않은 행을 추출 var rows = sheet.getRowsByStatus(\"Added,!Deleted\"); // Changed 속성이 설정되어 있으면서, Added, Deleted 속성이 설정되지 않은 행만 추출 var rows = sheet.getRowsByStatus(\"!Added,Changed,!Deleted\"); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-rows-by-status.html"
          },
          {
            "cid": 646,
            "sid": "get-rows-from-page",
            "name": "get-rows-from-page",
            "label": "getRowsFromPage",
            "data": {
              "body": "> 특정 페이지 내에 위에서부터 pos 번째에 위치한 [데이터 로우 객체](/docs/appx/row-object)를 리턴합니다. > pos값은 보여지는 행을 기준으로 합니다. ### Syntax ```javascript object getRowsFromPage( page , pos ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |page|`object`|<span class='required'>필수</span>|[데이터 페이지 객체](/docs/appx/page-object)| |pos|`number`|<span class='optional'>선택</span>|페이지 내에 위에서부터 순서 (default: `0`)| ### Return Value ***row object*** : [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript //4번 페이지의 10번째 행을 얻습니다. var page = sheet.getPageByIndex(4); var rowObject = sheet.getRowsFromPage(page,10); ```",
              "see": [
                {
                  "label": "getRowByIndex method",
                  "url": "./get-row-by-index"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-rows-from-page.html"
          },
          {
            "cid": 647,
            "sid": "get-save-json",
            "name": "get-save-json",
            "label": "getSaveJson",
            "data": {
              "body": "> 시트 내에 변경된 내용(`입력(Added)`, `수정(Changed)`, `삭제(Deleted)`, `이동(Moved)`)을 json 형식의 객체로 추출합니다. ### Syntax ```javascript object getSaveJson( saveMode, col, validRequired, showAlert, saveAttr, useLevel, formData, saveExtraAttr, rows ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |saveMode|`number`|<span class='optional'>선택</span>|상태별 데이터 추출 여부 `0`:전체데이터 `1`:전체데이터 중 `Deleted` 만 제외 `2`:수정된 데이터(`Added`,`Changed`,`Deleted`) (`default`) `3`:수정된 데이터(`Added`,`Changed`,`Deleted`)+이동한 데이터(`Moved`)| |col|`string`|<span class='optional'>선택</span>|저장 기준 열의 열이름 특정 열을 지정하면 행의 상태(`Added`,`Changed`,`Deleted`)를 무시하고 지정한 열의 데이터 유무에 따라 저장됨.| |validRequired|`boolean`|<span class='optional'>선택</span>|데이터 필수 입력 항목([Required col](/docs/props/col/required) 설정된 열)에 대한 검사 여부 설정. `0(false)`:필수 입력 항목 검사 안함 `1(true)`:필수 입력 항목 검사 실행 (`default`)| |showAlert|`boolean`|<span class='optional'>선택</span>|`validRequired` 검사를 통과하지 못할 시 메세지 표시 여부 `0(false)`:메시지 표시 안함 (`default`) `1(true)`:메세지 표시 ![테이블](/assets/imgs/doSaveRequired1.png \"테이블\") ![경고창](/assets/imgs/doSaveRequired2.png \"경고창\")| |saveAttr|`string`|<span class='optional'>선택</span>|각 셀의 속성값을 같이 추출하고자 하는 경우 Name+속성명 형식으로 설정 여러개 속성을 추출하고자 하는 경우 \",\"를 구분자로 작성 ex) `\"sNameColor,sNoCanEdit\"`| |useLevel|`boolean`|<span class='optional'>선택</span>|Tree기능 사용시 각 행의 Level(Depth)값을 추출되는 데이터에 포함할지 여부 (default: `1(true)`) 최 상위 노드를 1부터 시작하여 계산하며, `\"tLEVEL\"`이라는 이름으로 행 데이터에 추가됩니다. `\"tLEVEL\"`은 각 메세지 파일(ex:`ko.js`)에서 `\"TreeLevelName\"`으로 변경할 수 있습니다. Tree기능을 사용하는 시트에서 해당 속성을 `0(false)`로 설정시 `saveMode:0`을 통해 추출되는 데이터는 계층구조를 갖게 됩니다. `saveMode`를 이용하여 전체 데이터가 아닌 일부 데이터를 추출 할 경우 데이터는 계층 구조를 가지지 않으며 `\"tLEVEL\"` 값은 모두 1이 됩니다.| |formData|`boolean`|<span class='optional'>선택</span>|저장 데이터를 Form Data로 추출 할지 여부 (default: `0(false)`) ***File 타입 저장 시 사용***| |saveExtraAttr|`boolean`|<span class='optional'>선택</span>|시트에 (col)[Name](/docs/props/col/name)으로 정의하지 않은 데이터가 [doSearch](/docs/funcs/core/do-search)나 [loadSearchData](/docs/funcs/core/load-search-data)함수를 통해 로드 된 경우, 함수 호출시 해당 데이터를 같이 추출할 지 여부. 로드 데이터 첫번째 행의 keyset을 기준으로 추출됨. `0(false)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 되지 않은 데이터 서버 전송 시 미포함 (`default`) `1(true)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 되지 않은 데이터 서버 전송 시 포함| |rows|`array[object]`|<span class='optional'>선택</span>| [데이터 로우 객체](/web-service/manuals/ibsheet8/-/wikis/docs/appx/row-object) 배열로 입력한 행에 대한 정보를 추출합니다. (default: `null`)| |validSize|`boolean`|<span class='optional'>선택</span>|사이즈 설정([Size col](/docs/props/col/size))에 대한 유효성 검사 여부 설정. `0(false)`:사이즈 유효성 검사 안함 (`default`) `1(true)`:사이즈 유효성 검사 실행| |validEditMask|`boolean`|<span class='optional'>선택</span>|EditMask 설정([EditMask col](/docs/props/col/edit-mask))에 대한 유효성 검사 여부 설정. `0(false)`:EditMask 유효성 검사 안함 (`default`) `1(true)`:EditMask 유효성 검사 실행| |validResultMask|`boolean`|<span class='optional'>선택</span>|ResultMask 설정([ResultMask col](/docs/props/col/result-mask))에 대한 유효성 검사 여부 설정. `0(false)`:ResultMask 유효성 검사 안함 (`default`) `1(true)`:ResultMask 유효성 검사 실행| Parameter 설정 시 결과에 대응하는 코드는 다음과 같습니다. | Code | Message | Description | |------| --------------- |-------------| | `IBS000` |NoTargetRows | 저장(Added, Changed, Deleted) 대상이 없는 경우 | | `IBS010` |RequiredError| `validRequired` 설정 시 Validation 오류인 경우 | | `IBS020` |InvalidRows | `rows` 설정 시 처리대상이 없는 경우 | | `IBS040` |SizeError | `validSize` 설정 시 Validation 오류인 경우 | | `IBS050` |EditMaskError | `validEditMask` 설정 시 Validation 오류인 경우 | | `IBS060` |ResultMaskError| `validResultMask` 설정 시 Validation 오류인 경우 | ### Return Value **json 형식의 object** ```json // 정상적인 처리시 { \"data\":[ {\"id\":\"AR1\",\"ColName1\":\"12345\",\"ColName2\":\"ABCDE\" ...}, {\"id\":\"AR4\",\"ColName1\":\"76411\",\"ColName2\":\"HIJKL\" ...}, ... ] } ``` ```json // validRequired 오류시 { \"Message\":\"RequiredError\", \"Code\":\"IB010\", \"row\":오류 발생 행 객체, \"col\":오류 발생 열 Name, \"data\":[] } // rows에 입력한 행 객체가 유효하지 않을 경우 { \"Message\":\"InvalidRows\", \"Code\":\"IB020\", \"data\":[] } ``` ### Example ```javascript // 각 컬럼에 수정된 데이터와 DESC 컬럼의 Color 속성값을 추출한다. var saveJson = sheet.getSaveJson({saveMode:2, saveAttr:\"DESCColor\"}); $.ajax({ type: 'post' ,async: true ,dataType: 'json' ,headers: {\"X-Requested-With\":\"XMLHttpRequest\"} ,contentType: \"application/json; charset=utf-8\" ,url: \"/xgs/manage/sys/sawonTelSave.do\" ,data: JSON.stringify(saveJson) , success: function(data) { // 저장 결과 반영 sheet.acceptChangedData(); } , error: function(data, status, err) { alert('서버와의 통신이 실패했습니다.'); } }); ```",
              "see": [
                {
                  "label": "getSaveString method",
                  "url": "./get-save-string"
                },
                {
                  "label": "acceptChangedData method",
                  "url": "./accept-changed-data"
                },
                {
                  "label": "Required col",
                  "url": "/docs/props/col/required"
                },
                {
                  "label": "ValidCheck cfg",
                  "url": "/docs/props/cfg/valid-check"
                },
                {
                  "label": "ValidateMessage cfg",
                  "url": "/docs/props/cfg/validate-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.4|`saveAttr`,`useLevel` 기능 추가||core|8.0.0.5|`formData` 기능 추가||core|8.1.0.32|`saveExtraAttr` 기능 추가||core|8.1.0.43|`rows` 기능 추가||core|8.3.0.24|`validSize`, `validEditMask`, `validResultMask` 기능 추가|"
            },
            "url": "docs/funcs/core/get-save-json.html"
          },
          {
            "cid": 648,
            "sid": "get-save-string",
            "name": "get-save-string",
            "label": "getSaveString",
            "data": {
              "body": "> 시트 내에 변경된 내용(`입력(Added)`, `수정(Changed)`, `삭제(Deleted)`, `이동(Moved)`)을 querystring 형식의 문자열로 추출합니다. ### Syntax ```javascript string getSaveString( saveMode, col, urlEncode, delim, queryMode, validRequired, prefix, showAlert, saveAttr, saveExtraAttr ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |saveMode|`number`|<span class='optional'>선택</span>|상태별 데이터 추출 여부 `0`:전체데이터 `1`:전체데이터 중 `Deleted` 만 제외 `2`:수정된 데이터(`Added`,`Changed`,`Deleted`) (`default`) `3`:수정된 데이터(`Added`,`Changed`,`Deleted`)+이동한 데이터(`Moved`)| |col|`string`|<span class='optional'>선택</span>|저장 기준 열의 열이름 특정 열을 지정하면 행의 상태(`Added`,`Changed`,`Deleted`)를 무시하고 지정한 열의 데이터 유무에 따라 저장됨.| |urlEncode|`boolean`|<span class='optional'>선택</span>|조합되는 문자열의 인코딩 여부(encodeURIComponent로 문자열을 인코딩함 ) **`queryMode`별로 `default`가 달라짐** `0(false)`:`queryMode:0 (default)` `1(true)`:`queryMode:1/2 (default)`| |delim|`string`|<span class='optional'>선택</span>|queryMode값이 2인 경우에 데이터 사이 구분자 지정 (`default : \"\\|\"`)| |queryMode|`number`|<span class='optional'>선택</span>|서버로 전달될 데이터 구조 설정 **`0`:json 구조로 전달** ex) Data={ \"data\":[ {\"STATUS\":\"Added\",\"ColName1\":\"홍길동\",\"ColName2\":25}, {\"STATUS\":\"Changed\",\"ColName1\":\"심청\",\"ColName2\":18} ]} *단 **reqHeader**속성에 {\"Content-Type\":\"application/json\"}를 추가시 앞에 \"Data=\"이 제거되고 순수하게 json형식만 서버로 전송* **`1`:QueryString 구조 전달** (`default`) ex) STATUS=Added&ColName1=홍길동&ColName2=25&STATUS=Changed&ColName1=심청&ColName2=18 **`2`:열데이터 기준 QueryString 구조 전달** ex) STATUS=Added\\|Changed&ColName1=홍길동\\|심청&ColName2=25\\|18| |validRequired|`boolean`|<span class='optional'>선택</span>|데이터 필수 입력 항목([Required col](/docs/props/col/required) 설정된 열)에 대한 검사 여부 `0(false)`:필수 입력 항목 검사 안함 `1(true)`:필수 입력 항목 검사 실행 (`default`) **`Validation`결과가 실패인 경우 규격** 1. Validation 오류인 경우 - Code: `IBS010`, Message: `RequiredError`| |prefix|`string`|<span class='optional'>선택</span>|열의 이름 앞에 설정할 문자열 여러개 시트를 한번에 서버로 보낼때 시트id_colName 형식으로 보낼 수 있음 ex) `sheet_saName=홍길동&sheet_saId=839212` 식으로 queryString이 만들어짐 (`default : \"\"`)| |showAlert|`boolean`|<span class='optional'>선택</span>| `validRequired` 검사를 통과하지 못할 시 메세지 표시 여부 `0(false)`:메시지 표시 안함 (`default`) `1(true)`:메세지 표시 ![테이블](/assets/imgs/doSaveRequired1.png \"테이블\") ![경고창](/assets/imgs/doSaveRequired2.png \"경고창\")| |saveAttr|`string`|<span class='optional'>선택</span>|각 셀의 속성값을 같이 추출하고자 하는 경우 Name+속성명 형식으로 설정 여러개 속성을 추출하고자 하는 경우 \",\"를 구분자로 작성 ex) `\"sNameColor,sNoCanEdit\"`| |saveExtraAttr|`boolean`|<span class='optional'>선택</span>|시트에 (col)[Name](/docs/props/col/name)으로 정의하지 않은 데이터가 [doSearch](/docs/funcs/core/do-search)나 [loadSearchData](/docs/funcs/core/load-search-data)함수를 통해 로드 된 경우, 함수 호출시 해당 데이터를 같이 추출할 지 여부. 로드 데이터 첫번째 행의 keyset을 기준으로 추출됨 `0(false)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 되지 않은 데이터 서버 전송 시 미포함 (`default`) `1(true)`:시트에 (col)[Name](/docs/props/col/name)으로 정의 되지 않은 데이터 서버 전송 시 포함| |validSize|`boolean`|<span class='optional'>선택</span>|사이즈 설정([Size col](/docs/props/col/size))에 대한 유효성 검사 여부 설정. `0(false)`:사이즈 유효성 검사 안함 (`default`) `1(true)`:사이즈 유효성 검사 실행| |validEditMask|`boolean`|<span class='optional'>선택</span>|EditMask 설정([EditMask col](/docs/props/col/edit-mask))에 대한 유효성 검사 여부 설정. `0(false)`:EditMask 유효성 검사 안함 (`default`) `1(true)`:EditMask 유효성 검사 실행| |validResultMask|`boolean`|<span class='optional'>선택</span>|ResultMask 설정([ResultMask col](/docs/props/col/result-mask))에 대한 유효성 검사 여부 설정. `0(false)`:ResultMask 유효성 검사 안함 (`default`) `1(true)`:ResultMask 유효성 검사 실행| ### Return Value | 결과 | Description | |------|-------------| |sa_name=홍길동&sa_id=02712&sa_dept=031&...| 정상 처리일 경우(querystring 형태) | |\"\"| 저장(Added, Changed, Deleted) 대상이 없는 경우 | |RequiredError\\|IBS010\\|오류발생 행 id\\|오류발생 열 Name| `validRequired` 설정 시 Validation 오류인 경우 | ### Example ```javascript // 열이름이 CHK인 열에 체크된 데이터만 추출한다. // 데이터를 추출하면서 AA 컬럼에 Checked 속성도 추출한다. var saveStr = sheet.getSaveString({col:\"CHK\",saveAttr:\"AAChecked\"}); $.ajax({ url:\"sheetSaveWorx.do\", data:saveStr, success:function(data){ // 저장성공시 처리 sheet.acceptChangedData(); } }) ```",
              "see": [
                {
                  "label": "getSaveJson method",
                  "url": "./get-save-json"
                },
                {
                  "label": "acceptChangedData method",
                  "url": "./accept-changed-data"
                },
                {
                  "label": "Required col",
                  "url": "/docs/props/col/required"
                },
                {
                  "label": "ValidCheck cfg",
                  "url": "/docs/props/cfg/valid-check"
                },
                {
                  "label": "ValidateMessage cfg",
                  "url": "/docs/props/cfg/validate-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.4|`saveAttr` 기능 추가||core|8.1.0.32|`saveExtraAttr` 기능 추가||core|8.3.0.24|`validSize`, `validEditMask`, `validResultMask` 기능 추가|"
            },
            "url": "docs/funcs/core/get-save-string.html"
          },
          {
            "cid": 649,
            "sid": "get-saved-current-info",
            "name": "get-saved-current-info",
            "label": "getSavedCurrentInfo",
            "data": {
              "body": "> 현재 로컬 스토리지 혹은 세션 스토리지에 저장되어 있는 시트의 컬럼 정보를 문자열로 가져옵니다. ### Syntax ```javascript string getSavedCurrentInfo(); ``` ### Return Value ***string 현재 로컬 스토리지, 혹은 세션 스토리지에 저장되어 있는 컬럼들의 숨김, 너비, 위치 정보 값*** ### Example ```javascript // 현재 로컬 스토리지 혹은 세션 스토리지에 저장되어 있는 시트의 컬럼 정보를 담고 있는 문자열을 반환 sheet.getSavedCurrentInfo(); ```",
              "see": [
                {
                  "label": "getCurrentInfo method",
                  "url": "./get-current-info"
                },
                {
                  "label": "setCurrentInfo method",
                  "url": "./set-current-info"
                },
                {
                  "label": "saveCurrentInfo method",
                  "url": "./save-current-info"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.28|기능 추가|"
            },
            "url": "docs/funcs/core/get-saved-current-info.html"
          },
          {
            "cid": 650,
            "sid": "get-scale",
            "name": "get-scale",
            "label": "getScale",
            "data": {
              "body": "> 시트의 배율(zoom factor)정보를 확인합니다. ### Syntax ```javascript number getScale(); ``` ### Return Value ***number*** : 시트에 설정된 배율 정보 ### Example ```javascript sheet.getScale(); ```",
              "see": [
                {
                  "label": "[setScale method] (./set-scale)"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.11|기능 추가|"
            },
            "url": "docs/funcs/core/get-scale.html"
          },
          {
            "cid": 651,
            "sid": "get-scroll-left",
            "name": "get-scroll-left",
            "label": "getScrollLeft",
            "data": {
              "body": "> 가로스크롤 바의 위치를 pixel단위로 확인합니다. ### Syntax ```javascript number getScrollLeft( section ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |section|`number`|<span class='optional'>선택</span>|틀고정을 기준으로 한 좌우 영역 `0`:좌측 `1`:가운데 (`default`) `2`:우측| ### Return Value ***number*** : 가로 스크롤바에 대해 x축으로 이동한 거리(pixel단위) ### Example ```javascript //현재 가로스크롤 바의 위치를 얻는다. var offset = sheet.getScrollLeft(1); //다시 렌더링 sheet.rerender(); //원래 위치로 이동시킴 sheet.setScrollLeft(offset , 1 ); ```",
              "see": [
                {
                  "label": "setScrollLeft method",
                  "url": "./set-scroll-left"
                },
                {
                  "label": "getScrollTop method",
                  "url": "./get-scroll-top"
                },
                {
                  "label": "setScrollTop method",
                  "url": "./set-scroll-top"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-scroll-left.html"
          },
          {
            "cid": 652,
            "sid": "get-scroll-top",
            "name": "get-scroll-top",
            "label": "getScrollTop",
            "data": {
              "body": "> 세로스크롤바의 위치를 확인합니다. ### Syntax ```javascript number getScrollTop(); ``` ### Return Value ***number*** : 세로 스크롤바에 대해 y축으로 이동한 거리(pixel단위) ### Example ```javascript //현재 세로스크롤 바의 위치를 얻는다. var offset = sheet.getScrollTop(); //다시 렌더링 sheet.rerender(); //원래 위치로 이동시킴 sheet.setScrollTop(offset); ```",
              "see": [
                {
                  "label": "setScrollTop method",
                  "url": "./set-scroll-top"
                },
                {
                  "label": "getScrollLeft method",
                  "url": "./get-scroll-left"
                },
                {
                  "label": "setScrollLeft method",
                  "url": "./set-scroll-left"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-scroll-top.html"
          },
          {
            "cid": 653,
            "sid": "get-selected-range",
            "name": "get-selected-range",
            "label": "getSelectedRanges",
            "data": {
              "body": "> 현재 선택된 영역을 이중 배열로 리턴합니다. > 가령 다음과 같이 선택 후 `default` 형태로 값을 얻을시 리턴되는 값은 다음과 같습니다. ### ![선택영역얻기](/assets/imgs/getSelectedRanges.png \"선택영역얻기\") ``` [ [row1객체, \"CONTRACTNO\", row2객체, \"CARNO\", 4, 3, 6, 3] ,[row1객체, \"RENTFEE\", row2객체, \"RENTDATE\", 5, 7, 4, 2] ,[row1객체, \"CARNO\", row2객체, \"RENTFEE\", 11, 5, 4, 3] ] ``` ### Syntax ```javascript object getSelectedRanges( rowtype, coltype ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |rowtype|`number`|<span class='optional'>선택</span>|`0`:구분없이 선택영역 모두 추출 (`default`) `1`:트리사용시 접힌 자식은 빼고 추출 `2`:페이지 단위로 구분해서 추출| |coltype|`number`|<span class='optional'>선택</span>|`0`:구분없이 모두 추출 (`default`) `1`:영역(Left/Center/Right)별로 구분해서 추출| ### Return Value ***object (array[array])*** : 선택된 영역들에 대한 이중 배열 [시작[데이터 로우 객체](/docs/appx/row-object) , 시작열이름 , 종료[데이터 로우 객체](/docs/appx/row-object) , 종료열이름 , 시작행인덱스 , 시작열인덱스 , 선택행의개수 , 선택열의 개수] ### Example ```javascript //선택된 셀의 개수를 알아봄 var selectRange = sheet.getSelectedRanges(); var selectCellCnt = 0; for(var i=0;i<selectRange.length;i++){ selectCellCnt += parseInt(selectRange[i][6]) * parseInt(selectRange[i][7]); } alert(\"총 \"+selectCellCnt+\"개 셀을 선택하셨습니다.\"); ```",
              "see": [
                {
                  "label": "selectRange method",
                  "url": "./select-range"
                },
                {
                  "label": "getSelectedRows method",
                  "url": "./get-selected-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-selected-range.html"
          },
          {
            "cid": 654,
            "sid": "get-selected-rows",
            "name": "get-selected-rows",
            "label": "getSelectedRows",
            "data": {
              "body": "> 선택된 행 객체를 리턴한다. > type 인자에 따라 셀단위 선택한 행이나 행전체 선택한 행에 대해 추출할 수 있습니다. > attr 인자를 통해 선택된 행들 중에서도 특정 속성이 있는 행만 추출할 수 있습니다. ### Syntax ```javascript object getSelectedRows( type , attr ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |type|`number`|<span class='optional'>선택</span>|`0`:행이나 셀 중 선택된 것은 모두 추출 (`default`) `1`:행단위 선택만 추출 `2`:셀단위 선택만 추출| |attr|`string`|<span class='optional'>선택</span>|같이 확인하고자 하는 속성명| ### Return Value ***array[row object]*** : 선택된 [데이터 로우 객체](/docs/appx/row-object) (배열형태) ### Example ```javascript //일부 행을 선택 sheet.setAttribute(sheet.getRowById(\"AR5\"), null, \"Selected\", 1, 1); sheet.setAttribute(sheet.getRowById(\"AR10\"), \"RENTFEE\", \"Selected\", 1, 1); //일부 영역을 선택 sheet.selectRange(sheet.getRowById(\"AR6\"),\"CARNO\",sheet.getRowById(\"AR8\"),\"PROMOCODE\"); //행의 Edit 속성을 변경 sheet.setAttribute(sheet.getRowById(\"AR7\"), null, \"CanEdit\", 0, 1); //선택된 행(Selected=1)을 추출 var rows = sheet.getSelectedRows(1); //[\"AR5\" , \"AR10\"] //선택된 셀을 추출 var rows = sheet.getSelectedRows(2); //[\"AR6\" , \"AR7\" , \"AR8\"] //선택된 셀,행 모두 추출 var rows = sheet.getSelectedRows(0); //[\"AR5\" , \"AR6\" , \"AR7\" , \"AR8\" , \"AR10\"] //선택된 셀,행 중에 CanEdit=1 인 데이터 로우 객체 추출 var rows = sheet.getSelectedRows(0, \"CanEdit\"); //[\"AR5\" , \"AR6\" , \"AR8\" , \"AR10\"] ```",
              "see": [
                {
                  "label": "getSelectedRanges method",
                  "url": "./get-selected-ranges"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-selected-rows.html"
          },
          {
            "cid": 655,
            "sid": "get-selection-summary-info-element",
            "name": "get-selection-summary-info-element",
            "label": "getSelectionSummaryInfoElement",
            "data": {
              "body": "> 선택한 영역의 셀 개수 및 합계/평균 값 정보를 시트 외부의 Dom Element 에 표시하고 있을 경우 정보 출력되는 Dom Element 를 반환합니다. ### Syntax ```javascript HTML Element getCountInfoElement (); ``` ### Return Value ***object*** : 선택한 영역의 셀 개수 및 합계/평균 값 정보가 출력 되는 Dom Element ### Example ```javascript // 선택한 영역의 셀 개수 및 합계/평균 값 정보가 출력 되는 Dom Element 확인 sheet.getSelectionSummaryInfoElement (); ```",
              "see": [
                {
                  "label": "InfoRowConfig cfg",
                  "url": "/docs/props/cfg/info-row-config"
                },
                {
                  "label": "SelectionSummary cfg",
                  "url": "/docs/props/cfg/selection-summary"
                },
                {
                  "label": "setSelectionSummaryInfoElement method",
                  "url": "./set-selection-summary-info-element"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.1.0.6|기능 추가|"
            },
            "url": "docs/funcs/core/get-selection-summary-info-element.html"
          },
          {
            "cid": 656,
            "sid": "get-shown-cols",
            "name": "get-shown-cols",
            "label": "getShownCols",
            "data": {
              "body": "> 현재 화면에 보여지는 열 이름을 배열로 리턴합니다. > section인자를 설정하지 않으면 가운데 영역에서 보여지는 열 이름을 배열로 리턴합니다. > 시트의 너비가 넓을수록 더 많은 열 이름이 리턴됩니다. ### Syntax ```javascript object getShownCols(section); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |section|`number`|<span class='optional'>선택</span>|틀고정을 기준으로 한 영역지정 `0`:왼쪽 `1`:가운데 (`default`) `2`:오른쪽| ### Return Value ***array[string]*** : 열 이름 배열 ### Example ```javascript //가운데 영역에 보여지는 열 이름을 확인 var colNameArr = sheet.getShownCols(1); ```",
              "see": [
                {
                  "label": "getShownRows method",
                  "url": "./get-shown-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-shown-cols.html"
          },
          {
            "cid": 657,
            "sid": "get-shown-rows",
            "name": "get-shown-rows",
            "label": "getShownRows",
            "data": {
              "body": "> 현재 화면에 보여지는 [데이터 로우 객체](/docs/appx/row-object)를 리턴합니다. > 시트의 높이가 클수록 더 많은 [데이터 로우 객체](/docs/appx/row-object)가 리턴됩니다. > `current: 0(false)`인 경우 전체 영역에서 보여질 모든 행을 리턴합니다. > 트리 사용시 접혀있는 행들은 리턴되지 않습니다. ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |current|`boolean`|<span class='optional'>선택</span>|현재 보여지는 행을 리턴할 영역 설정 `0(false)`:전체 영역 `1(true)`:현재 화면에 보여지는 영역 (`default`) ### Syntax ```javascript object getShownRows(current); ``` ### Return Value ***array[row object]*** : 배열 형태의 [데이터 로우 객체](/docs/appx/row-object) ### Example ```javascript // 전체 영역 중 보여지는 행의 개수를 확인 var rowArr = sheet.getShownRows(1); var cnt = rowArr.length; ```",
              "see": [
                {
                  "label": "getShownCols method",
                  "url": "./get-shown-cols"
                },
                {
                  "label": "행 객체(Row Object) appendix",
                  "url": "/docs/appx/row-object"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.17|`current` 인자 추가|"
            },
            "url": "docs/funcs/core/get-shown-rows.html"
          },
          {
            "cid": 658,
            "sid": "get-string",
            "name": "get-string",
            "label": "getString",
            "data": {
              "body": "> 포맷이 적용된 문자열로 셀의 값을 가져옵니다. ### Syntax ```javascript string getString( row, col); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| ### Return Value ***string*** : 적용된 포맷형태에 따른 셀값 리턴 ### Example ```javascript var r5 = sheet.getRowById(\"AR5\"); //format yyyy/MM/dd 인경우 '2015/12/31' 형태로 추출 var sdata = sheet.getString(r5, \"StartDate\"); ```",
              "see": [
                {
                  "label": "setString method",
                  "url": "./set-string"
                },
                {
                  "label": "setValue method",
                  "url": "./set-value"
                },
                {
                  "label": "getValue method",
                  "url": "./get-value"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-string.html"
          },
          {
            "cid": 659,
            "sid": "get-sub-total-rows",
            "name": "get-sub-total-rows",
            "label": "getSubTotalRows",
            "data": {
              "body": "> 생성된 소계/누계 행들을 반환합니다. > 리턴 값은 다음과 같습니다 > {subTotal:[[첫번 째 기준 열 관련 소계행들], [두번 째 기준 열 관련 소계행들] ... ], Total:[[첫번 째 기준 열 관련 누계 행들], [두번 째 기준 열 관련 누계 행들] ... ]} ### Syntax ```javascript object getSubTotalRows(); ``` ### Return Value ***object*** ### Example ```javascript //소계 누계 행을 얻습니다. var totalRows = sheet.getSubTotalRows(); ```",
              "see": [
                {
                  "label": "makeSubTotal method",
                  "url": "./make-sub-total"
                },
                {
                  "label": "removeSubTotal method",
                  "url": "./remove-sub-total"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-sub-total-rows.html"
          },
          {
            "cid": 660,
            "sid": "get-total-row-count",
            "name": "get-total-row-count",
            "label": "getTotalRowCount",
            "data": {
              "body": "> 조회모드에 따라 조회된 전체 데이터 건수 또는 DB 에서 가져올 전체 데이터 행수를 리턴합니다. > [(Cfg)SearchMode](/docs/props/cfg/search-mode) 가 0, 1, 2 로 설정된 경우 조회된 전체 데이터 행수를 리턴합니다. > [(Cfg)SearchMode](/docs/props/cfg/search-mode) 가 3, 4, 5 인 경우 조회 데이터의 Total 에 설정된 값을 리턴합니다. 이 때 Total 값은 조회조건에 따라 가져올 DB 의 전체 건수가 설정되어야 합니다. ### Syntax ```javascript number getTotalRowCount(); ``` ### Return Value ***number*** : 조회된 전체 데이터 건수 또는 조회데이터에 포함된 Total 값 ### Example ```javascript //전체 데이터 건수를 얻음 var tRow = sheet.getTotalRowCount(); ```",
              "see": [
                {
                  "label": "getDataRows method",
                  "url": "./get-data-rows"
                },
                {
                  "label": "getShownRows method",
                  "url": "./get-shown-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-total-row-count.html"
          },
          {
            "cid": 661,
            "sid": "get-type",
            "name": "get-type",
            "label": "getType",
            "data": {
              "body": "> 특정 셀의 Type을 확인합니다. ### Syntax ```javascript string getType( row, col ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| ### Return Value ***string*** : 셀의 타입 (Text,Int,Float,Date 등) ### Example ```javascript function cellClick(evt){ if( evt.Col == \"EntDate\" && sheet.getType( evt.Row , evt.Col ) == \"Text\"){ $( \"#entDate-confirm\" ).dialog('open'); } } ```",
              "see": [
                {
                  "label": "getFormat method",
                  "url": "./get-format"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-type.html"
          },
          {
            "cid": 662,
            "sid": "get-user-data",
            "name": "get-user-data",
            "label": "getUserData",
            "data": {
              "body": "> IBSheet.create 함수 호출시 설정한 데이터를 리턴 합니다. > data의 값이 없으면 조회한 데이터를 리턴 합니다. > 수정한 데이터는 반영되어 추출되지 않습니다. ### Syntax ```javascript object getUserData(); ``` ### Return Value ***array*** : 시트 생성시 초기화된 데이터 배열 ### Example ```javascript IBSheet.create({ id: 'sheet', // 생성할 시트의 id el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id options: options, // 생성될 시트의 속성 data: [{ \"ItemNo\": 59993940, \"Title\": \"공부머리 독서법\", \"Price\": 14850, \"Author\": \"최승필\", \"Publisher\": \"책구루\", \"Category1\": \"A0\", \"Category2\": \"AA1\", \"Category3\": \"AAB0\" } ] // 생성될 시트의 정적데이터 }); //시트 초기화시 생성된 데이터를 확인합니다. var data = sheet.getUserData(); //리턴된 data [{ \"ItemNo\": 59993940, \"Title\": \"공부머리 독서법\", \"Price\": 14850, \"Author\": \"최승필\", \"Publisher\": \"책구루\", \"Category1\": \"A0\", \"Category2\": \"AA1\", \"Category3\": \"AAB0\" ] ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-user-data.html"
          },
          {
            "cid": 663,
            "sid": "get-user-options",
            "name": "get-user-options",
            "label": "getUserOptions",
            "data": {
              "body": "> 시트 초기화 설정값을 리턴합니다. > 시트 생성시 [IBSheet.create({options})](/docx/static/create)으로 설정한 내용을 리턴합니다. > [IBSheet.CommonOptions](/docx/static/common-options) 이나 [IBSheet.onBeforeCreate](on-before-create)를 통해 공통으로 적용받은 내용도 같이 리턴되나, 생성 후 추가하거나 수정한 내용은 리턴되지 않습니다. > `mode`에 따라 리턴하는 설정값이 달리짐. ### Syntax ```javascript object getUserOptions( mode ); ``` ### Parameters |Name|Type|Required| Description | |----|----|--------|-------------| |mode|`number`|<span class='optional'>선택</span>|`0`:시트 생성시 설정한 옵션을 리턴 (`default`) `1`:엑셀 다이얼로그전용 옵션 리턴 (`mode: 0` 에서 `Cfg`에 `ZIndex` 변경, `CanSort: 0` 추가) `2`:시트 생성시 설정한 옵션을 리턴하되 컬럼은 현재의 컬럼 정보를 리턴 (`mode: 0` 에서 컬럼은 현재 마지막 컬럼 정보를 가져옴.) `3`:엑셀 다이얼로그 전용 옵션 리턴 (`mode: 2` 에서 `Cfg`에 `ZIndex` 변경, `CanSort: 0` 추가)| ### Return Value ***object*** : 시트 생성시 사용된 초기화(options) 내용 ### Example ```javascript //시트 초기화시 Cfg 설정 값의 일부 내용을 확인합니다. var opts = sheet.getUserOptions( ); alert(opts.Cfg.CanEdit); //시트 현재 컬럼의 정보를 확인합니다. var opts = sheet.getUserOptions( 2 ); alert(opts.Cols); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.7|1,3 추가|"
            },
            "url": "docs/funcs/core/get-user-options.html"
          },
          {
            "cid": 664,
            "sid": "get-value",
            "name": "get-value",
            "label": "getValue",
            "data": {
              "body": "> 특정 셀의 값을 구분자를 제거하고 가져오는 함수입니다. ### Syntax ```javascript mixed getValue( row, col ); ``` ### Parameters |Name|Type|Required| Description | |----|----|--------|-------------| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| ### Return Value ***mixed ( `number` \\| `string` )*** : 셀의 타입에 따른 값을 리턴 ### Example ```javascript var r = sheet.getFirstRow(); //구분자 없이 yyyyMMdd 형태로 추출 var sdate = sheet.getValue( r , \"StartDate\" ); var edate = sheet.getValue({row:r,col:\"EndDate\"}); ```",
              "see": [
                {
                  "label": "getString method",
                  "url": "./get-string"
                },
                {
                  "label": "setString method",
                  "url": "./set-string"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/get-value.html"
          },
          {
            "cid": 665,
            "sid": "go-to-next-page",
            "name": "go-to-next-page",
            "label": "goToNextPage",
            "data": {
              "body": "> 현재 페이지의 다음 페이지로 이동합니다. ### Syntax ```javascript boolean goToNextPage(); ``` ### Return Value ***boolean*** : 페이지 이동 성공여부(이미 마지막 페이지인 경우 false가 리턴) ### Example ```javascript //다음페이지로 이동 function NextPage(){ var rtn = sheet.goToNextPage(); if(!rtn) { alert(\"마지막 페이지 입니다.\"); } } ```",
              "see": [
                {
                  "label": "goToPage method",
                  "url": "./go-to-page"
                },
                {
                  "label": "goToPrevPage method",
                  "url": "./go-to-prev-page"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/go-to-next-page.html"
          },
          {
            "cid": 666,
            "sid": "go-to-page-by-index",
            "name": "go-to-page-by-index",
            "label": "goToPageByIndex",
            "data": {
              "body": "> 특정 페이지로 이동합니다. > 클라이언트/서버 페이징에서 사용 가능합니다. ### Syntax ```javascript void goToPageByIndex(index); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |index|`number`|<span class='required'>필수</span>|조회할 페이지 순서 번호 ### Return Value ***none*** ### Example ```javascript //12번째 페이지로 이동 sheet.goToPageByIndex(12); ```",
              "see": [
                {
                  "label": "goToNextPage method",
                  "url": "./go-to-next-page"
                },
                {
                  "label": "goToPrevPage method",
                  "url": "./go-to-prev-page"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/go-to-page-by-index.html"
          },
          {
            "cid": 667,
            "sid": "go-to-page",
            "name": "go-to-page",
            "label": "goToPage",
            "data": {
              "body": "> 특정 페이지로 이동합니다. ### Syntax ```javascript void goToPage( page ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |page|`object`|<span class='required'>필수</span>|[데이터 페이지 객체](/docs/appx/page-object)| ### Return Value ***none*** ### Example ```javascript //마지막 페이지를 얻음 var page = sheet.getPageByRow(sheet.getLastRow() ); //마지막 페이지로 이동 sheet.goToPage(page); ```",
              "see": [
                {
                  "label": "goToNextPage method",
                  "url": "./go-to-next-page"
                },
                {
                  "label": "goToPrevPage method",
                  "url": "./go-to-prev-page"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/go-to-page.html"
          },
          {
            "cid": 668,
            "sid": "go-to-prev-page",
            "name": "go-to-prev-page",
            "label": "goToPrevPage",
            "data": {
              "body": "> 현재 페이지의 이전 페이지로 이동합니다. ### Syntax ```javascript boolean goToPrevPage(); ``` ### Return Value ***boolean*** : 페이지 이동 성공여부(현재 페이지가 첫페이지인 경우 false가 리턴) ### Example ```javascript //이전페이지로 이동 function PrevPage(){ var rtn = sheet.goToPrevPage(); if (!rtn) { alert(\"첫 페이지 입니다.\"); } } ```",
              "see": [
                {
                  "label": "goToPage method",
                  "url": "./go-to-page"
                },
                {
                  "label": "goToNextPage method",
                  "url": "./go-to-next-page"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/go-to-prev-page.html"
          },
          {
            "cid": 669,
            "sid": "has-changed-data",
            "name": "has-changed-data",
            "label": "hasChangedData",
            "data": {
              "body": "> 시트 내에 변경된 내용(입력, 수정, 삭제)이 있는지 확인합니다. ### Syntax ```javascript number hasChangedData(dataonly); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |dataonly|`boolean`|<span class='optional'>선택</span>|수정 여부 확인을 Sheet전체 영역과 Data영역만 대상으로 지정할 지 여부 `0(false)`:Sheet전체 영역 대상 지정(`default`) `1(true)`:Data영역만 대상 지정| ### Return Value ***number*** : 수정된 내용이 있으면 1, 없으면 0 ### Example ```javascript window.onbeforeunload = function() { if(sheet.hasChangedData()) { return \"시트에 수정된 내용이 있습니다.\\n계속 진행시 수정하신 내용은 잃어버리게 됩니다.\"; } } sheet.hasChangedData(true); //데이터 영역에서 수정된 내용이 있는 경우 1, 없으면 0 ```",
              "see": [
                {
                  "label": "acceptChangedData method",
                  "url": "./accept-changed-data"
                },
                {
                  "label": "getChangedData method",
                  "url": "./get-changed-data"
                },
                {
                  "label": "getSaveJson method",
                  "url": "./get-save-json"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.3.0.20|dataonly 인자 추가|"
            },
            "url": "docs/funcs/core/has-changed-data.html"
          },
          {
            "cid": 670,
            "sid": "has-filter",
            "name": "has-filter",
            "label": "hasFilter",
            "data": {
              "body": "> 필터가 사용됐는지 여부를 리턴합니다. > 필터된 결과와 무관하게 필터를 사용했으면 `true`가 리턴됩니다. ### Syntax ```javascript boolean hasFilter(); ``` ### Return Value ***boolean*** : 필터 적용 여부 ### Example ```javascript //필터를 사용했나? var fuse = sheet.hasFilter(); ```",
              "see": [
                {
                  "label": "clearFilter method",
                  "url": "./clear-filter"
                },
                {
                  "label": "setFilter method",
                  "url": "./set-filter"
                },
                {
                  "label": "doFilter method",
                  "url": "./do-filter"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/has-filter.html"
          },
          {
            "cid": 671,
            "sid": "hide-col",
            "name": "hide-col",
            "label": "hideCol",
            "data": {
              "body": "> 특정 열을 감춥니다. > 여러 컬럼을 `hide` 할시 `render` 인자를 `false` 로 하여 작업 후에는 `rerender` 를 무조건 호출하셔야 합니다. ### Syntax ```javascript void hideCol( col, userHidden, merge, render ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|감추고자 하는 열이름| |userHidden|`boolean`|<span class='optional'>선택</span>|화면 개발자가 아닌 시트 사용자가 감추고자 하는 열 인지 여부 개인화(*사용자가 열의 위치, 너비, 보임여부를 저장했다가 해당페이지 접속시 설정했던 모습으로 보여주는 기능*)기능 구현시 사용 됩니다. 이 속성값을 `1(true)`로 하면 해당 열은 사용자가 감추었다는 의미로 내부적으로 해당 열에 대한 플래그가 생성되고 [saveCurrentInfo()](./save-current-info)함수 호출시 저장되었다가 추후에 페이지에 재 접속시 시트에 반영되어 보여지게 됩니다. `0(false)`:사용자가 감추고자 하는 열이 아님 (`default`) `1(true)`:사용자가 감추고자 하는 열| |merge|`boolean`|<span class='optional'>선택</span>| 열을 숨기면서 자동 머지합니다. <span style='color:red'>많은 데이터가 있는 시트에서 실행 시 느려질 수 있습니다.</span> `0(false)`:병합 실행 안함 (`default`) `1(true)`:병합 실행| |render|`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 `1(true)`:즉시 반영 (`default`)| ### Return Value ***none*** ### Example ```javascript //CPT_NM 열을 감춥니다. sheet.hideCol( \"CPT_NM\" ); //AMT 열을 감추면서 사용자 감춤여부를 설정합니다. sheet.hideCol( \"AMT\" , 1 ); // render 인자를 사용합니다. sheet.hideCol( { col: \"AMT\", render: false } ); sheet.rerender(); ```",
              "see": [
                {
                  "label": "getCurrentInfo method",
                  "url": "./get-current-info"
                },
                {
                  "label": "saveCurrentInfo method",
                  "url": "./save-current-info"
                },
                {
                  "label": "showCol method",
                  "url": "./show-col"
                },
                {
                  "label": "onShowColumn event",
                  "url": "/docs/events/on-show-column"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.6|`merge` 인자 추가||core|8.0.0.17|`render` 인자 추가|"
            },
            "url": "docs/funcs/core/hide-col.html"
          },
          {
            "cid": 672,
            "sid": "hide-filter-dialog",
            "name": "hide-filter-dialog",
            "label": "hideFilterDialog",
            "data": {
              "body": "> 헤더에 필터 다이얼로그 아이콘을 숨깁니다. ### Syntax ```javascript boolean hideFilterDialog(); ``` ### Return Value ***none*** ### Example ```javascript // 헤더행에 필터 다이얼로그 아이콘을 숨깁니다. sheet.hideFilterDialog(); ```",
              "see": [
                {
                  "label": "UseFilterDialog",
                  "url": "/docs/props/cfg/use-filter-dialog"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.3.0.1|기능 추가|"
            },
            "url": "docs/funcs/core/hide-filter-dialog.html"
          },
          {
            "cid": 673,
            "sid": "hide-filter-row",
            "name": "hide-filter-row",
            "label": "hideFilterRow",
            "data": {
              "body": "> 필터 행을 감춥니다. ### Syntax ```javascript boolean hideFilterRow( ); ``` ### Return Value ***boolean*** ### Example ```javascript //필터행을 감춥니다. sheet.hideFilterRow( ); ```",
              "see": [
                {
                  "label": "showFilterRow method",
                  "url": "./show-filter-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/hide-filter-row.html"
          },
          {
            "cid": 674,
            "sid": "hide-group-row",
            "name": "hide-group-row",
            "label": "hideGroupRow",
            "data": {
              "body": "> 그룹행을 제거하거나 숨깁니다. ### Syntax ```javascript void hideGroupRow( del ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |del |`string or object`|<span class='optional'>선택</span>|그룹행을 삭제합니다. (`default: 1`)| ### Return Value ***boolean*** : 설정 완료 여부 ### Example ```javascript // 그룹행을 제거합니다. sheet.hideGroupRow(); // 그룹행을 숨깁니다. sheet.hideGroupRow(0); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.3.0.9|기능 추가|"
            },
            "url": "docs/funcs/core/hide-group-row.html"
          },
          {
            "cid": 675,
            "sid": "hide-hint",
            "name": "hide-hint",
            "label": "hideHint",
            "data": {
              "body": "> 현재 보여지고 있는 힌트를 감춥니다. ### ![힌트활성화](/assets/imgs/hint1.png \"마우스 커서가 셀에 올라갔을때 힌트를 통해 감춰진 부분이 보여짐\") [힌트 예시] ### Syntax ```javascript void hideHint(); ``` ### Return Value ***none*** ### Example ```javascript //현재 보여지는 힌트를 감춤 sheet.hideHint(); ```",
              "see": [
                {
                  "label": "showHint method",
                  "url": "./show-hint"
                },
                {
                  "label": "onShowHint event",
                  "url": "/docs/events/on-show-hint"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/hide-hint.html"
          },
          {
            "cid": 676,
            "sid": "hide-message",
            "name": "hide-message",
            "label": "hideMessage",
            "data": {
              "body": "> [showMessage](./show-message)로 띄운 메세지 다이얼로그를 제거합니다. ### ![hideMessage](/assets/imgs/showMessage.png \"시트 영역 위에 메세지 다이얼로그를 띄움\") ### Syntax ```javascript void hideMessage(); ``` ### Return Value ***none*** ### Example ```javascript function popup(){ sheet.showMessage({message:\"<span style='color:black'>결제기한이 만료되었습니다.</span>\",importance:4,type:1}); setTimeout(function(){sheet.hideMessage()} , 1000); } ```",
              "see": [
                {
                  "label": "showMessage method",
                  "url": "./show-message"
                },
                {
                  "label": "onHideMessage event",
                  "url": "/docs/events/on-hide-message"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/hide-message.html"
          },
          {
            "cid": 677,
            "sid": "hide-row",
            "name": "hide-row",
            "label": "hideRow",
            "data": {
              "body": "> 지정한 행을 감춥니다. > 두번째 `del` 인자의 값이 `1(true)` 일 경우 실제 DOM을 삭제하고 숨겨집니다. ([SearchMode](/docs/props/cfg/search-mode) : 2 일 경우 사용) > 대량으로 행을 감추거나 보이게 끔 하고자 할때는 `norender`값을 `1`로 설정하여 작업하신 후, `render()함수`를 호출하여 한꺼번에 화면에 반영하는 것이 좋습니다. ### Syntax ```javascript void hideRow( row, del, norender, nomerge ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|감출 [데이터 로우 객체](/docs/appx/row-object)| |del |`boolean`|<span class='optional'>선택</span><mark>(사용주의)</mark>|DOM 삭제 여부 해당 기능은 **권장하지 않습니다**. `0(false)`:DOM 삭제 안함 (`default`) `1(true)`:DOM 삭제| |norender|`boolean`|<span class='optional'>선택</span><mark>(사용주의)</mark>|즉시 화면에 반영할 것인지 여부 해당 기능을 사용한 뒤, 다른 동작을 실행 할 경우 `renderBody()`를 반드시 먼저 실행 해야 합니다. `0(false)`: 즉시 반영 (`default`) `1(true)`: 반영 안함 |nomerge|`boolean`|<span class='optional'>선택</span>|[DataMerge cfg](/docs/props/cfg/data-merge) 값이 `0` 외의 값일 때, 머지 계산을 바로 할 것인지 여부 `0(false)`:행 삭제 후, 머지 계산 (`default`) `1(true)`:행 삭제 후, 머지 계산 안함| ### Return Value ***none*** ### Example ```javascript //44번째행을 감춥니다. sheet.hideRow( sheet.getRowByIndex(44) ); //특정 행을 모두 감춥니다. var rows = sheet.getDataRows(); for(var i=0; i<rows.length; i++){ if(rows[i][\"deptNm\"] != \"지원부서\"){ // 행을 감출때 렌더링을 일단 막음 sheet.hideRow( {'row':rows[i],'norender':1}); } } //데이터 영역에 변경된 내용을 한꺼번에 렌더링 한다. sheet.renderBody(); ```",
              "see": [
                {
                  "label": "showRow method",
                  "url": "./show-row"
                },
                {
                  "label": "SearchMode cfg",
                  "url": "/docs/props/cfg/search-mode"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/hide-row.html"
          },
          {
            "cid": 678,
            "sid": "hide-tip",
            "name": "hide-tip",
            "label": "hideTip",
            "data": {
              "body": "> 시트가 띄운 풍선도움말을 감춥니다. ### Syntax ```javascript void hideTip(); ``` ### Return Value ***none*** ### Example ```javascript //풍선도움말을 감춤 sheet.hideTip(); ```",
              "see": [
                {
                  "label": "showTip method",
                  "url": "./show-tip"
                },
                {
                  "label": "onShowTip method",
                  "url": "/docs/events/on-show-tip"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/hide-tip.html"
          },
          {
            "cid": 679,
            "sid": "import-data",
            "name": "import-data",
            "label": "importData",
            "data": {
              "body": "> 엑셀 파일의 내용을 시트 위로 `import` 합니다. > 해당 함수를 사용하시려면 `jszip` 라이브러리가 반드시 필요합니다. > [loadExcel](/docs/funcs/excel/load-excel)과 동일한 이벤트를 사용 할 수 있습니다. > [loadExcel](/docs/funcs/excel/load-excel) 기능 중 (서버에서 처리하는 기능을 제외하고) 제외한 동일한 기능을 제공하고 있습니다. > 해당 함수를 호출시 파일 다이얼로그가 나타나고, 사용자가 엑셀 파일을 선택하면 선택된 파일을 클라이언트 단에서 처리합니다.(서버x) > 지원 하는 파일 형식은 **xlsx, txt, csv** 입니다. ### Syntax ```javascript void importData( param ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |append|`boolean`|<span class='optional'>선택</span>|시트의 기존 데이터를 뒤에 엑셀의 데이터를 추가할지 여부(`default: 0(false)`) 설정을 하지 않으면 기존데이터는 모두 삭제한 후 엑셀의 데이터가 추가됨 `주의` 해당 옵션은 `SearchMode:4,5 (서버페이징)` 모드에서는 사용할 수 없습니다. `0(false)`:기존 데이터 제거 후 엑셀 데이터 추가 (`default`) `1(true)`:기존 데이터에 엑셀 데이터 추가| |fileExt|`string`|<span class='optional'>선택</span>|파일 선택창에서 허용하는 파일 확장자를 구분자(\"\\|\")로 연결하여 설정합니다. (`default: \"xlsx\"`)| |mode|`string`|<span class='optional'>선택</span>| `\"HeaderMatch\"`, `\"NoHeader\"`, `\"HeaderSkip\"` 중에 하나의 문자열을 입력합니다. 각 문자의 의미는 다음과 같습니다. <ul><li>`\"HeaderMatch\"` : 시트의 헤더행의 타이틀과 엑셀의 첫번째 행부터 타이틀을 비교해서 읽습니다. StartRow속성이 지정된 경우 StartRow에서 지정한 행부터 해더행의 개수만큼의 행을 읽어 비교합니다.</li><li>`\"NoHeader\"` : 헤더행이 없다고 가정하고 첫행부터 순서대로 각 열에 대입합니다.</li><li>`\"HeaderSkip\"` : 헤더행은 있지만 열비교를 하지 않고 좌측부터 순서대로 읽습니다. 시트의 헤더행의 2개라면 엑셀의 위에서 두개행을 제외하고 그 아래부터 읽는다고 생각하시면 됩니다.</li></ul>(`default: \"HeaderMatch\"`)| | next | `object` | <span dir=\"\">선택</span> | [데이터 로우 객체](/docs/appx/row-object) 지정한 행 위에부터 데이터 `append`. (`append:1(true)`일때만 사용 가능) | |startRow|`number`|<span class='optional'>선택</span>|엑셀에서 시트가 몇번째 행에서 시작하는지 설정합니다. 설정하지 않으면 엑셀의 첫번째 행부터 (1부터시작) 읽어 들임 (`default: 1`) (`xlsx에서만 지원`)| |startCol|`number`|<span class='optional'>선택</span>|엑셀에서 시트가 몇번째 열에서 시작하는지 설정합니다. 설정하지 않으면 엑셀의 첫번째 열부터 (1부터시작) 읽어 들임 `mode: HeaderMatch`의 경우 (7,12)에 있는 시트를 찾을 때, `startRow: 7` 만 설정해 줘도 그 Row에 헤더길이만큼 텍스트를 보기 때문에 `startCol`을 설정할 필요가 없다. 만약, `startCol`을 사용할 경우, 엑셀에 있는 시트에 첫번째 컬럼부터 `startCol`이 시작하게 된다 (`default: 1`) (`xlsx에서만 지원`)| |workSheetName|`string`|<span class='optional'>선택</span>|읽어들일 엑셀 파일의 워크시트 명을 설정합니다. 일치하는 워크시트 명이 없으면 첫번째 워크시트를 읽습니다.| |workSheetNameStrict|`boolean`|<span class='optional'>선택</span>|workSheetName에 설정한 워크시트가 없는 경우 첫번째 워크시트를 로드하지 않고 -17 에러 코드를 반환합니다. `0(false)`:workSheetName에 설정된 워크시트가 없는 경우 첫번째 워크시트를 로드 (`default`) `1(true)`:workSheetName에 설정된 워크시트가 없는 경우 -17 에러 코드를 반환| |workSheetNo|`number`|<span class='optional'>선택</span>|읽어들일 엑셀 파일의 워크시트 순번을 설정합니다. 설정하지 않으면 첫번째 워크시트를 읽습니다. (`default: 1`)| |columnMapping|`string`|<span class='optional'>선택</span>|엑셀 컬럼 번호를 이용해서 시트의 열 순서에 따라 데이터를 로드하는 옵션입니다. 구분자(\"\\|\")로 연결하여 설정합니다.(1번부터 시작) `mode: HeaderMatch`에서 컬럼매핑을 사용 할 경우 `HeaderMatch`의 기능은 무시되고 `HeaderSkip` 처럼 사용됩니다 (`xlsx에서만 지원`)| |colSeparator|`string`|<span class='optional'>선택</span>|열과 열 사이의 구분자 문자, txt 업로드 일 경우 (`default: \\t(탭문자)`, csv 업로드 일 경우(`default: ,(콤마)`) 업로드되는 파일에 따라 기본 구분자가 변경됩니다. `(txt, csv에서만 지원)`| |encoding|`string`|<span class='optional'>선택</span>|텍스트 파일의 인코딩 형식 지정`(txt, csv에서만 지원)` (`default: \"utf-8\"`)| |endRow|`number`|<span class='optional'>선택</span>|엑셀에서 몇번째 행까지 읽어들일 지 설정합니다. 설정하지 않으면 끝까지 읽어들입니다. 0부터 시작합니다.| |file|`object`|<span class='optional'>선택</span>|file 객체 또는 Blob 객체로 된 엑셀 데이터를 직접 읽어들입니다. (`xlsx에서만 지원`) 해당 인자를 사용하게 되면 파일 다이얼로그가 나타나지 않습니다.| |uploadImage|`boolean`|<span class='optional'>선택</span>| 셀 위에 띄워진 이미지를 업로드할지 여부를 결정합니다. `0(false)`: 셀 위에 띄워진 이미지를 업로드하지 않음 `1(true)`:셀 위에 띄워진 이미지를 업로드함 (`default`) | |skipSEQ|`boolean`|<span class='optional'>선택</span>|mode: `NoHeader`, `HeaderSkip`으로 데이터를 업로드할 때 SEQ 컬럼을 스킵하고 데이터를 업로드합니다. `columnMapping`을 설정한 경우에는 해당 인자가 동작하지 않습니다. (`default: 0`) | ### Return Value ***none*** xlsx에서만 지원 ### Example ```javascript // 워크시트이름이 sheet이고 mode: \"HeaderMatch\" 엑셀에 시트가 3번째 행에 있는 경우 업로드 var param = {startRow:3, mode:\"HeaderMatch\", workSheetName:\"sheet\"}; sheet.importData(param); // mode: \"HeaderSkip\" 엑셀에 시트가 3번째 행과 3번째 열에 있는 경우 업로드 var param = {startRow:3, startCol:3, mode:\"HeaderSkip\"}; sheet.importData(param); // mode: \"NoHeader\", workSheet순서가 4번째인 엑셀에 시트가 7번째 행과 3번째 열에 있는 경우 업로드 var param = {startRow:7, startCol:3, mode:\"NoHeader\", workSheetNo:4}; sheet.importData(param); // 1~5번째 까지 있는 엑셀 컬럼을 시트에 3,4,5,2,1 순서로 업로드 var param = {columnMapping: \"3|4|5|2|1\"} sheet.importData(param); // 파일 확장자를 이용하여 텍스트 업로드 var param = {fileExt:\"csv|txt\"}; sheet.importData(param); ```",
              "see": [
                {
                  "label": "exportData method",
                  "url": "./export-data"
                },
                {
                  "label": "loadExcel method",
                  "url": "/docs/funcs/excel/load-excel"
                },
                {
                  "label": "onSelectFile event",
                  "url": "/docs/events/on-select-file"
                },
                {
                  "label": "onImportFinish event",
                  "url": "/docs/events/on-import-finish"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가||core|8.0.0.20|`endRow` 기능 추가, 파일 형식 내용 추가||core|8.1.0.20|`file` 기능 추가||core|8.1.0.33|`workSheetNameStrict` 기능 추가||core|8.2.0.14|`next` 기능 추가||core|8.3.0.22|`uploadImage` 기능 추가||core|8.3.0.45|`skipSEQ` 기능 추가|"
            },
            "url": "docs/funcs/core/import-data.html"
          },
          {
            "cid": 680,
            "sid": "is-focused",
            "name": "is-focused",
            "label": "isFocused",
            "data": {
              "body": "> 특정 행이나 셀에 포커스가 있는지 확인합니다. ### Syntax ```js boolean isFocused( row, col ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='optional'>선택</span>|열이름| ### Return Value ***boolean*** : 포커스 유무 (0:unfocused, 1:focused) ### Example ```javascript //id가 AR33인 행에 포커스가 있는지 확인한다. var isfo = sheet.isFocused(sheet.getRowById(\"AR33\")); //특정 셀에 포커스가 있는지 확인한다. var isfo = sheet.isFocused(sheet.getRowById(\"AR5\"), \"CA_DSC\" ); ```",
              "see": [
                {
                  "label": "focus method",
                  "url": "./focus"
                },
                {
                  "label": "getCanFocus method",
                  "url": "./get-can-focus"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/is-focused.html"
          },
          {
            "cid": 681,
            "sid": "load-search-data",
            "name": "load-search-data",
            "label": "loadSearchData",
            "data": {
              "body": "> json형식의 데이터를 시트에 로드합니다.\\ > `append` 인자를 설정하지 않으면 기존에 시트의 데이터는 클리어 된 후, 로드 됩니다.\\ > 비동기 형식으로 동작하므로, 데이터 로드 이후에 대한 처리는 [onDataLoad](/docs/events/on-data-load) 이벤트에서 로직을 구성하셔야 합니다. ### Syntax ```javascript void loadSearchData( data, append, callback, sync, next, strictParse, parent, ignoreEvent ); ``` ### Parameters | Name | Type | Required | Description | |------|------|----------|-------------| | data | `object` | <span dir=\"\">필수</span> | json형식의 데이터 | | append | `boolean` | <span dir=\"\">선택</span> | 기존 데이터 하단에 `append` 여부 조회 방식의 차이로 인해 `append:1(true)`사용 시 [SearchMode](/docs/props/cfg/search-mode):2인 경우 [onRenderFinish](/docs/events/on-render-finish)이벤트가 발생하지 않습니다.. `0(false)`:기존 데이터 제거 후 조회 데이터 로드 (`default`) `1(true)`:기존 데이터에 조회 데이터 추가| | callback | `function` | <span dir=\"\">선택</span> | 조회 후 호출할 콜백 함수 ex) `sheet`: 시트 객체, `data`: 조회 데이터, `result(0)`: 조회 성공 | | sync | `boolean` | <span dir=\"\">선택</span> | 동기 조회 여부. `0(false)`: 비동기 방식 (`default`) `1(true)`: 동기 방식 | | next | `object` | <span dir=\"\">선택</span> | [데이터 로우 객체](/docs/appx/row-object) 지정한 행 위에부터 데이터 `append`. (`append:1(true)`일때만 사용 가능) | | strictParse | `boolean` | <span dir=\"\">선택</span> | json 파서 선택 일반적으로 유연한 파싱으로 구동되고 true 설정시에 브라우져의 JSON.parse()를 통해 파싱 `0(false)`:유연한 파서 사용 (`default`) `1(true)`: 브라우저에서 제공하는 JSON.parse() 내장함수 사용| | parent | `object` | <span dir=\"\">선택</span> | [데이터 로우 객체](/docs/appx/row-object) (동적 트리 조회 사용시 부모에 해당하는 행 지정) | | ignoreEvent | `boolean` | 선택 | 조회 관련 이벤트를 발생시키지 않도록 하는 인자 `0(false)`:조회 관련 이벤트를 발생 시킴 (`default`) `1(true)`:조회 관련 이벤트를 발생 시키지 않음 | 유연한 파싱이란 일반적인 JSON.parse()를 통해 파싱하는 경우 허용하지 않는 몇가지를 허용합니다. 1. 여분의 콤마 허용 2. 프로퍼티 이름의 쌍따옴표가 없어도 됨. 참고 - [MDN:bad parsing](https://developer.mozilla.org/ko/docs/Web/JavaScript/Reference/Errors/JSON_bad_parse) - JSON.parse()가 유연한 파싱보다 성능이 우수(약 5배)하지만 데이터 로딩과정에서 파싱이 차지하는 시간이 크지 않아 5만건 이내에서는 사용자가 느끼기 어려운 수준임. ### Return Value **_none_** ### Example ```javascript var DATA = {\"data\":[ {\"EMP_ID\":\"08212\",\"EMP_NM\":\"홍길동\",\"DEPT_CD\":\"031\"}, {\"EMP_ID\":\"07417\",\"EMP_NM\":\"허균\",\"DEPT_CD\":\"120\"}, {\"EMP_ID\":\"02600\",\"EMP_NM\":\"홍판서\",\"DEPT_CD\":\"405\"}, ]}; //기존 데이터 밑에 데이터를 append한다.. sheet.loadSearchData( DATA, 1 ); //지정한 행 위에부터 데이터가 append 된다.. sheet.loadSearchData({ data: DATA.data, append: true, next: sheet.getRowByIndex(3) }) ```",
              "see": [
                {
                  "label": "StrictParse cfg",
                  "url": "/docs/props/cfg/strict-parse"
                },
                {
                  "label": "dataStructure appendix",
                  "url": "/docs/appx/data-structure"
                },
                {
                  "label": "doSearch method",
                  "url": "./do-search"
                },
                {
                  "label": "doSearchPaging method",
                  "url": "./do-search-paging"
                },
                {
                  "label": "onReceiveData event",
                  "url": "/docs/events/on-receive-data"
                },
                {
                  "label": "onDataLoad event",
                  "url": "/docs/events/on-data-load"
                }
              ],
              "since": "| product | version | desc ||---------|---------|------|| core | 8.0.0.0 | 기능 추가 || core | 8.0.0.6 | `sync` 인자 추가 || core | 8.0.0.7 | `next` 인자 추가 || core | 8.0.0.7 | `strictParse` 인자 추가 || core | 8.0.0.25 | `parent` 인자 추가 |"
            },
            "url": "docs/funcs/core/load-search-data.html"
          },
          {
            "cid": 682,
            "sid": "make-pivot-table",
            "name": "make-pivot-table",
            "label": "makePivotTable",
            "data": {
              "body": "> 대상 시트의 모든 데이터를 기준으로 피벗 테이블을 생성합니다. > 만약 피벗 생성 시점에 대상 시트가 필터링 되어 있는 경우 필터가 취소된 후 피벗이 생성됩니다. > 생성된 피벗 테이블의 시트는 원본시트의 `\"pivotSheet_\" + id`로 생성됩니다. 예를 들어 원본 시트의 id가 `\"sheet\"`인 경우 피벗 시트의 id는 `\"pivotSheet_sheet\"`가 됩니다. > 피벗 테이블의 시트에서는 `DataMerge` 기능을 지원하지 않습니다. > **<mark>주의</mark> : `makeSubTotal`로 행 5000개, 열 200개 이상의 피벗 테이블을 만들 경우 브라우저 성능을 보장할 수 없습니다. 해당 개수 미만으로 생성되게 `makeSubTotal` 기준 행,열을 설정하도록 권장합니다.** ### Syntax ```javascript object makePivotTable(criterias, init, format, type, callback, hideTotal); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |criterias|`object`|<span class='optional'>선택</span>|피벗테이블 기준 대상 컬럼명들 설정 row, col에는 일반 컬럼 data에는 숫자형 컬럼(`int, float`) 사용| |init|`object`|<span class='required'>필수</span>|피벗테이블의 열, 행, 계산 대상 설정 row, col에는 일반 컬럼 data에는 숫자형 컬럼(`int, float`) 사용| |format|`string`|<span class='optional'>선택</span>|피벗 테이블에서 보여질 포맷| |type|`string`|<span class='optional'>선택</span>|계산 대상 컬럼별 계산 방법 (`default: \"Sum\"`) `\"Sum\"`, `\"Count\"`, `\"Max\"`, `\"Min\"` 사용 가능 컬럼별 계산 방법을 data 컬럼 개수에 맞게 `,(쉼표)` 로 연결하여 여러 개를 설정할 수 있습니다.| |callback|`function`|<span class='optional'>선택</span>|피벗 시트 생성 후 호출할 콜백 함수. 피벗 시트 생성 후 [onRenderFirstFinish](/docs/events/on-render-first-finish) 시점에 발생합니다.| |hideTotal|`object`|<span class='optional'>선택</span>|피벗 테이블에서 총합계 표시 여부| ### criterias |Name|Type|Required|Description| |----------|-----|---|----| |row|`string`|<span class='required'>필수</span>|행 레이블 필드 기준 컬럼 명을 구분자(\",\")로 연결한 문자열| |col|`string`|<span class='required'>필수</span>|열 레이블 필드 기준 컬럼 명을 구분자(\",\")로 연결한 문자열| |data|`string`|<span class='required'>필수</span>|계산 대상 기준 컬럼 명을 구분자(\",\")로 연결한 문자열| ### init |Name|Type|Required|Description| |----------|-----|---|----| |row|`string`|<span class='required'>필수</span>|행 레이블 필드에 설정할 컬럼 명을 구분자(\",\")로 연결한 문자열| |col|`string`|<span class='required'>필수</span>|열 레이블 필드에 설정할 컬럼 명을 구분자(\",\")로 연결한 문자열| |data|`string`|<span class='required'>필수</span>|계산 대상 컬럼의 컬럼 명을 구분자(\",\")로 연결한 문자열| ### hideTotal |Name|Type|Required|Description| |----------|-----|---|----| |hideTotalRow|`boolean`|<span class='optional'>선택</span>|행 총합계 숨김여부 (`default: false`)| |hideTotalRow|`boolean`|<span class='optional'>선택</span>|열 총합계 숨김여부 (`default: false`)| ### Return Value ***object*** : 생성된 피벗 시트 객체 ### Example ```javascript // 피벗 테이블 생성 var criterias = { row: 'sDept,sTeam,sPosition,sName,sGender,sAgeRange,sAddr', col: 'sDept,sTeam,sPosition,sName,sGender,sAgeRange,sAddr', data: 'sAge,sPeriod,sSalary,sBonus' } var init = { row: 'sDept', col: 'sPosition,sTeam', data: 'sSalary,sAge' } var callback = function (evt) { // callback function ... } var hideTotal = { hideTotalRow: false, hideTotalCol: true } // 초기화 data 컬럼이 sSalary,sAge 두 개이므로 각각 Sum,Avg 타입을 적용하며, 열 총합계를 감춥니다. sheet.makePivotTable(criterias, init, '#,### 만원', 'Sum,Avg', callback, hideTotalCol); ```",
              "see": [
                {
                  "label": "showPivotDialog method",
                  "url": "/docs/funcs/dialog/show-pivot-dialog"
                },
                {
                  "label": "switchPivotSheet method",
                  "url": "./switch-pivot-sheet"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.17|`callback` 기능 추가||core|8.1.0.46|`type` 옵션 `Max`, `Min` 추가||core|8.1.0.94|`criterias` 인자 선택으로 변경||core|8.2.0.15|`pivotType` 관련 기능 개선||core|8.3.0.9|`hideTotal` 인자 기능 추가|"
            },
            "url": "docs/funcs/core/make-pivot-table.html"
          },
          {
            "cid": 683,
            "sid": "make-sub-total",
            "name": "make-sub-total",
            "label": "makeSubTotal",
            "data": {
              "body": "> 기준 열의 데이터에 따른 소계/누계 행을 시트에 추가합니다. > 설정된 기준 열의 왼쪽 열에 소계에 대한 설명(\"소계 : 값\")이 보이며, 첫 번째 열의 경우 해당 열 내에 설명이 보이게됩니다. > > 일반적으로 소계 시 머지`usermerge:0(default)`는 `stdCol` 열 기준으로 머지가 이루어지며 여러 개로 지정한다면 각각의 `stdCol` 기준으로 머지가 이루어집니다. > `stdCol`에 지정된 열에 대해 이전 혹은 다음 행의 값이 같은 경우 행들을 머지하는 `DataMerge:1`과 같이 동작합니다. > **<mark>주의</mark> : `SearchMode`:`0, 2`만 지원** > **<mark>주의</mark> : 조회시 소계를 사용하는 경우, [onDataLoad (event)](/docs/events/on-Data-Load) 이벤트에서 사용할 수 있습니다.** > **<mark>주의</mark> : `usermerge:0(default)`를 사용하면 [DataMerge (cfg)](/docs/props/cfg/data-merge), [PrevColumnMerge (cfg)](/docs/props/cfg/prev-column-merge) 설정이 무시됩니다.** > **<mark>주의</mark> : `captionCol` 사용 방법에 따라 머지에 영향을 받을 수 있습니다.** > **<mark>주의</mark> : `addRow` 의 경우, 소계 그룹 안에서 사용할 수 없습니다. 소계가 된 영역이 아닌, 밖의 영역(맨위, 맨아래)에만 행추가가 가능합니다.** > **<mark>주의</mark> : `excludeSubTotalRowCount` 의 경우, 서버페이지 기능 사용 시에는 동작되지 않습니다.** ### [단일소계] ![단일소계](/assets/imgs/makeSubTotal1.png) [`stdCol`: 정책사업(정책사업 컬럼에 `CaptionCol` 설정), 단위사업(`CaptionCol` 설정 안함)] ![단일소계](/assets/imgs/makeSubTotal2.png) [`stdCol`: 정책사업(정책사업 컬럼에 `CaptionCol` 설정), 단위사업(정책사업 컬럼에 `CaptionCol` 설정)] ![단일소계](/assets/imgs/makeSubTotal3.png) [`stdCol`: 정책사업, `CaptionCol({col: '정책사업', val: '%s: %col'}, {col: '단위사업', val: '%capCol'}, {col: '세부사업', val: '%cnt'})`] ![captionCol](/assets/imgs/makeSubTotal_capCol.png) ### Syntax ```javascript void makeSubTotal( subTotalRows, usermerge, excludeSubTotalRowCount ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |subTotalRows|`array[object]`|<span class='required'>필수</span>|소계 행에 대한 설정입니다. `object` **배열** 이며 하나의 배열에 들어갈 `subTotalRows`의 프로퍼티들은 아래 `subTotalRows` 표와 같습니다.| |usermerge|`boolean`|<span class='optional'>선택</span>|사용자가 설정한 `DataMerge`, `PrevColumnMerge`옵션을 사용하여 머지할지 여부 **`usermerge:1` 설정 후 해당 함수 호출 시 사용자가 설정한 `DataMerge`, `PrevColumnMerge`에 따라 머지가 이루어집니다.** `0(false)`:병합 동작 실행 안함 (`default`) `1(true)`:사용자가 설정한 병합 조건에 따라 병합 동작 실행| |excludeSubTotalRowCount|`boolean`|<span class='optional'>선택</span>|소계, 누계 행을 `SEQ` 컬럼과 `InfoRow ` 행의 개수 카운트에서 제외 여부 `0(false)`:소계, 누계 행을 `SEQ` 컬럼과 `InfoRow ` 행의 개수 카운트에 포함 (`default`) `1(true)`:소계, 누계 행을 `SEQ` 컬럼과 `InfoRow ` 행의 개수 카운트에서 제외| ### subTotalRows |Name|Type|Required|Description| |----------|-----|---|----| |stdCol|`string`|<span class='required'>필수</span>|기준 열| |sumCols|`string`|<span class='optional'>선택</span>|소계가 계산(합)되어야 할 열이름들을 '\\|'로 연결한 문자열| |countCols|`string`|<span class='optional'>선택</span>|소계 행에 데이터 행의 수로 계산되어야 할 열이름들을 '\\|'로 연결한 문자열 (Cfg)`CalcMergeMode` 설정시에는 이 값을 설정해야 한다. | |avgCols|`string`|<span class='optional'>선택</span>|소계가 계산(평균값)되어야 할 열이름들을 '\\|'로 연결한 문자열| |color|`string`|<span class='optional'>선택</span>|소계 행의 배경색| |showCumulate|`boolean`|<span class='optional'>선택</span>|소계에 대한 누계 행 표시 여부 `0(false)`:소계에 대한 누계 행 표시 안함(`default`) `1(true)`:소계에 대한 누계 행 표시| |cumulateColor|`string`|<span class='optional'>선택</span>|누계 행의 배경색| |sort|`string`|<span class='optional'>선택</span>|기준 열의 정렬 처리 방법 `\"\"`:사용안함 (`default`) `\"asc\"`:오름차순 정렬 `\"desc\"`:내림차순정렬| |position|`string`|<span class='optional'>선택</span>|소계행 생성 위치 `\"bottom\"`:그룹 하단 표시 (`default`) `\"top\"`:그룹 상단 표시 `\"bottomAll\"`:최하단 표시 `\"topAll\"`:최상단 표시| |captionCol|`array[object]`|<span class='optional'>선택</span>|캡션에 대한 정보 설정. 캡션이 들어갈 열이름과 캡션 값으로 이루어진 객체의 배열 `\"col\"`:캡션이 설정될 열이름(`sumCols, countCols, avgCols` 와 같이 계산된 값이 들어가는 컬럼에는 적용되지 않음.) `\"val\"`:소계 캡션에 들어갈 값, 함수 형태의 포뮬러 연산 제공(숫자 데이터의 천단위 구분자의 경우, 붙여서 리턴.) `ex) [{col: '정책사업', val: '%s: %col'}, {col: '단위사업', val: function(fr) { return fr.Row['단위사업'] + '%' }}]` `\"cumVal\"`:누계 캡션에 들어갈 값 `\"span\"`: 소계행에서 `captionCol`의 `col` 기준으로 열머지 할 값을 결정 **captionCol 에서 사용 가능한 예약어** `\"%s\"`: '소계(누계)'를 의미하는 예약어 `\"%col\"`:소계 기준값 출력 `\"%cnt\"`:소계(누계)건수를 표시 `\"%capCol\"`:**col**에 설정된 컬럼의 가장 마지막 행의 값을 소계행에 표시 (`default: [ { col : “기준 열”, val:”%s: %col” } ]`)| |mode|`number`|<span class='optional'>선택</span>|소계행 표시 방법을 설정 `0`:모든 대상 그룹에 대한 소계행 표시 (`default`) `1`:대상 그룹이 2개 이상인 그룹에 대해서만 소계행 표시 `2`:대상 그룹이 1개 이상인 그룹에 대해서만 소계행 표시 (소계행이 감춰질 뿐 생성되지 않는 것은 아님.)| |hidden|`boolean`|<span class='optional'>선택</span>|`Visible:0(false)` 인 행에 대한 소계 계산 포함 여부 `0(false)`:`Visible:0(false)` 인 행에 대한 소계 계산 대상 제외 (`default: 0`) `1(true)`:`Visible:0(false)` 인 행에 대한 소계 계산 대상 포함| ### Return Value ***none*** ### Example ```javascript Events: { // 조회 후, 머지를 사용하는 경우 소계행 설정 (onDataLoad 를 사용하세요.) onDataLoad: function (evt) { evt.sheet.makeSubTotal([ { stdCol: \"sPolicy\", avgCols: \"A|D\", countCols: \"E\", showCumulate: 1, sort: \"desc\", captionCol: [ { col: 'sPolicy', val: '%s: %col' } ] }, { stdCol: \"sUnit\", sumCols: \"B|C\", showCumulate: 1, }, . . . ]); } } sheet.makeSubTotal([ { stdCol: 'sPolicy', sumCols: 'A|B|C|D', position: 'bottom', captionCol: [ { // E셀에 포뮬러 연산 동작 col: 'E', val: function (fr) { var val = (fr.Row[\"A\"] + fr.Row[\"B\"]) * 10; return \"E: \" + val + \"퍼센트!\"; // \"E: 80퍼센트!\" } }, { col: 'F', val: function (fr) { return '1,000,000' // 숫자 데이터의 경우, 구분자를 붙여서 리턴해야함. } }, ] } ]); //소계, 누계 행을 `SEQ`에서 제외 sheet.makeSubTotal({ subTotalRows:[ { stdCol: 'sPolicy', sumCols: 'B|C|D', avgCols: 'A', position: 'bottom', captionCol: [ { col: 'sPolicy', val: '%s: %col', cumVal: '%s: %col', span: 3 }, { col: 'E', val: ' ', cumVal: ' ', span: 2 } ], } ], excludeSubTotalRowCount:1 }); ``` ### 소계셀에 Format 적용 (`8.0.0.25` 버전부터 동작) - sumCols, avgCols, countCols에 설정한 컬럼의 Format만 변경 가능 ```js Def: { SubSum: { // Def.SubSum을 이용하면 소계행에만 Def 속성을 적용할 수 있다 AFormat: '합계 : #,##0.##', // 소계행 A셀에 합계 Text와 실수형 포맷 적용 BFormat: '#,##0' // 소계행 B셀에 정수형 포맷 적용 } } sheet.makeSubTotal([ { stdCol: 'sPolicy', sumCols: 'B|C|D', avgCols: 'A', position: 'bottom', captionCol: [ { col: 'sPolicy', val: '%s: %col', cumVal: '%s: %col', span: 3 }, { col: 'E', val: ' ', cumVal: ' ', span: 2 } ], } ]); // sheet.makeSubTotal( { subTotalRows:[ { stdCol: 'sPolicy', sumCols: 'B|C|D', avgCols: 'A', position: 'bottom', captionCol: [ { col: 'sPolicy', val: '%s: %col', cumVal: '%s: %col', span: 3 }, { col: 'E', val: ' ', cumVal: ' ', span: 2 } ], } ], excludeSubTotalRowCount:1 } ); ```",
              "see": [
                {
                  "label": "removeSubTotal method",
                  "url": "./remove-sub-total"
                },
                {
                  "label": "getSubTotalRows method",
                  "url": "./get-sub-total-rows"
                },
                {
                  "label": "NoCalculate row",
                  "url": "/docs/props/row/no-calculate"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.7|`mode` 속성 기능 추가||core|8.0.0.11|`usermerge` 기능 추가||core|8.0.0.11|`%capCol` 예약어 추가||core|8.0.0.18|메뉴얼 내용 수정: 해당함수는 조회된 데이터가 생성된 다음에 호출되어야 합니다. 따라서 [onSearchFinish (event)](/docs/events/on-search-finish) 이벤트나 조회된 이후에 버튼 등, 클릭 이벤트에서 호출하셔야 합니다. => 조회시 소계를 사용하는 경우, [onDataLoad (event)](/docs/events/on-Data-Load) 이벤트에서 사용할 수 있습니다.||core|8.0.0.22|`hideen` 속성 추가||core|8.1.0.78|`excludeSubTotalRowCount` 기능 추가|"
            },
            "url": "docs/funcs/core/make-sub-total.html"
          },
          {
            "cid": 684,
            "sid": "move-col",
            "name": "move-col",
            "label": "moveCol",
            "data": {
              "body": "> 지정한 열의 위치를 이동합니다. > `tocol`을 공백(\"\")으로 설정하는 경우 `right` 인자에 따라 section의 맨 앞이나 맨 뒤로 이동됩니다. ### Syntax ```javascript boolean moveCol( col, tocol, right, norender ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|옮길 열이름| |tocol|`string`|<span class='required'>필수</span>|옮겨질 열이름| |right|`boolean`|<span class='optional'>선택</span>|`toCol`에서 지정한 열에 우측으로 이동할지 여부 `0(false)`:`toCol`에서 지정한 열에 좌측으로 이동 (`default`) `1(true)`:`toCol`에서 지정한 열에 우측으로 이동| |norender|`boolean`|<span class='optional'>선택</span><mark>(사용주의)</mark>|즉시 화면에 반영할 것인지 여부 해당 기능을 사용한 뒤, 다른 동작을 실행 할 경우 `rerender()`를 반드시 먼저 실행 해야 합니다. `0(false)`:즉시 반영 (`default`) `1(true)`:반영 안함 | ### Return Value ***boolean*** : 정상적으로 옮겨졌는지 여부(인자가 잘못되어 이동에 실패한 경우 `undefined` 리턴) ### Example ```javascript //CUSTOMER_NAME 열을 AMOUNT12 열의 오른쪽으로 이동합니다. sheet.moveCol(\"CUSTOMER_NAME\", \"AMOUNT12\", 1, 0); ```",
              "see": [
                {
                  "label": "addCol method",
                  "url": "./add-col"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/move-col.html"
          },
          {
            "cid": 685,
            "sid": "move-row",
            "name": "move-row",
            "label": "moveRow",
            "data": {
              "body": "> 지정한 행을 이동합니다. > `row`로 지정한 행을 `next`로 지정한 행의 위로 이동시킵니다. > 트리의 경우, `row`로 지정한 행을 `parent`에 지정된 행의 하위 노드로 이동시키며, `next`를 통해 하위 노드 내에서 들어갈 위치를 지정할 수 있습니다. > 포커스가 된 행을 `moveRow`시 움직인 위치로 `focus` 동작이 일어납니다. 포커스 동작이 일어나지 않게 할려면, `focus: 0` 을 주셔서 사용하면 됩니다. ### Syntax ```javascript boolean moveRow( row, next, render, parent, spannedMove, focus ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|이동할 [데이터 로우 객체](/docs/appx/row-object)| |next|`object`|<span class='required'>필수</span>|복사할 위치에 있는 [데이터 로우 객체](/docs/appx/row-object) 지정행 위로 이동됩니다.(`next`가 없을시 데이터 마지막 행으로 이동)| |render|`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 `1(true)`:즉시 반영 (`default`)| |parent|`object`|<span class='optional'>선택</span>|트리기능 사용시 이동할 부모 [데이터 로우 객체](/docs/appx/row-object)| |spannedMove|`boolean`|<span class='optional'>선택</span>|인자를 `1(true)`로 주는 경우 머지의 첫번째 행을 이동하면 머지된 행이 모두 이동 여부 `0(false)`:`row`에서 지정한 행만 이동 (`default`) `1(true)`:`row`에서 지정한 행이 병합된 첫번째 행인 경우, 해당 행에 병합된 행 모두 이동| |focus|`boolean`|<span class='optional'>선택</span>|행 이동한 행으로 포커스 이동 여부 `0(false)`:이동한 행으로 포커스 이동 안함 (`default`) `1(true)`:이동한 행으로 포커스 이동| ### Return Value ***boolean*** : 이동이 성공시 `1(true)`, 실패한 경우(이동할 위치가 원본의 위치와 같은 경우등) `0(false)`를 리턴 ### Example ```javascript //AR5 행을 시트 최 상단으로 이동시킵니다. sheet.moveRow({row:sheet.getRowById(\"AR5\"), next:sheet.getFirstRow()}); //AR8 행을 시트의 현재 포커스된 행의 자식 노드 중 마지막 위치로 이동시킵니다. var target = sheet.getRowById(\"AR8\"); sheet.moveRow({row:target, parent:sheet.getFocusedRow()}); ```",
              "see": [
                {
                  "label": "copyRow method",
                  "url": "./copy-row"
                },
                {
                  "label": "copyRows method",
                  "url": "./copy-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.8|`focus` 인자 추가 및 `moveRow`시 `focus`된 행으로 포커스동작이 발생함.|"
            },
            "url": "docs/funcs/core/move-row.html"
          },
          {
            "cid": 686,
            "sid": "refresh-cell",
            "name": "refresh-cell",
            "label": "refreshCell",
            "data": {
              "body": "> 특정 셀의 변경된 내용을 화면에 반영합니다. > `render` 함수와 달리 화면의 깜빡임이 없습니다. > 행 전체의 변경 내용을 반영할 때는 [refreshRow](./refresh-row)함수를 사용하는게 좋습니다. ### Syntax ```javascript void refreshCell( row, col ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| ### Return Value ***none*** ### Example ```javascript //특정 셀에 변경된 내용(값,속성)을 화면에 반영한다. sheet.refreshCell( sheet.getFirstVisibleRow(), \"EMT_DESC\" ); ```",
              "see": [
                {
                  "label": "refreshRow method",
                  "url": "./refresh-row"
                },
                {
                  "label": "renderBody method",
                  "url": "./render-body"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/refresh-cell.html"
          },
          {
            "cid": 687,
            "sid": "refresh-page",
            "name": "refresh-page",
            "label": "refreshPage",
            "data": {
              "body": "> 지정한 페이지를 렌더링 합니다. > [setAttribute](./set-attribute)함수나 데이터에 대해 직접 접근하여 수정한 내용을 한꺼번에 화면에 반영할 때 사용됩니다. ### Syntax ```javascript void refreshPage( page, always ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |page|`object`|<span class='required'>필수</span>|[페이지 객체](/docs/appx/page-object)| |always|`boolean`|<span class='optional'>선택</span>|보여지지 않는 페이지에 대한 렌더링 여부 `0(false)`:보여지지 않는 페이지에 대해 렌더링 하지 않음 (`default`) `1(true)`:보여지지 않는 페이지에 대해 렌더링 실행| ### Return Value ***none*** ### Example ```javascript var fr = sheet.getFocusedRow(); //선택한 행의 AMOUNT01열의 색상을 붉은색으로 변경한다. fr[\"AMOUNT01Color\"] = \"#FF0000\" var nr = sheet.getNextRow(fr); //선택한 행의 아래 행에 AMOUNT05열의 글자색을 파란색으로 변경한다. nr[\"AMOUNT05FontColor\"] = \"#0000FF\"; //해당 페이지에서 수정된 내용을 화면에 반영한다. sheet.refreshPage( {page:sheet.getFocusedPage()} ); ```",
              "see": [
                {
                  "label": "setAttribute method",
                  "url": "./set-attribute"
                },
                {
                  "label": "rerender method",
                  "url": "./rerender"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/refresh-page.html"
          },
          {
            "cid": 688,
            "sid": "refresh-row",
            "name": "refresh-row",
            "label": "refreshRow",
            "data": {
              "body": "> 특정 행의 변경된 내용을 화면에 반영합니다. > 반영이 이루어질 때 화면이 깜빡이지 않습니다. ### Syntax ```javascript void refreshRow( row ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| ### Return Value ***none*** ### Example ```javascript //특정 행에 변경된 내용(값,속성)을 화면에 반영한다. sheet.refreshRow( row ); ```",
              "see": [
                {
                  "label": "refreshCell method",
                  "url": "./refresh-cell"
                },
                {
                  "label": "rerender method",
                  "url": "./rerender"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/refresh-row.html"
          },
          {
            "cid": 689,
            "sid": "reload-data",
            "name": "reload-data",
            "label": "reloadData",
            "data": {
              "body": "> 시트의 데이터를 처음 생성 시점으로 되돌립니다. > 다시 말해 [IBSheet.create()](/docs/static/create)함수를 통해 로드된 데이터로 되돌립니다. > 생성 후 열에 부여한 속성(색상이나 편집가능 여부 등)은 유지되나, 행이나 셀에 부여한 속성은 초기화 됩니다. > 이 함수는 `Head, Foot, Solid` 영역에는 영향을 주지 않습니다. ### Syntax ```javascript void reloadData( func ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |func |`function`|<span class='optional'>선택</span>|리로드 완료 후 콜백 정의| ### Return Value ***none*** ### Example ```javascript if(confirm(\"작업한 내용을 취소하고 처음 조회된 데이터로 되돌리시겠습니까?\")){ sheet.reloadData( function(){ alert(\"데이터가 초기화 되었습니다.\"); } ); } ```",
              "see": [
                {
                  "label": "reload method",
                  "url": "./reload"
                },
                {
                  "label": "create static",
                  "url": "/docs/static/create"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/reload-data.html"
          },
          {
            "cid": 690,
            "sid": "reload",
            "name": "reload",
            "label": "reload",
            "data": {
              "body": "> 시트를 처음 생성했던 상태로 새롭게 생성합니다. > 여기서 처음 상태란 [IBSheet.create()](/docs/static/create)를 통해 생성되는 시점으로, 이후에 수정거나 조회된 내용은 반영되지 않습니다. > **<mark>주의</mark> : 시트를 초기 상태로 돌리는 동작이 아닌, 초기 상태의 시트를 재생성하는 동작입니다.** ### Syntax ```javascript void reload( callback ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |callback|`function`|<span class='optional'>선택</span>|`reload` 후, 호출할 콜백 함수 (`onRenderFirstFinish` 와 동일 시점)| ### Return Value ***none*** ### Example ```javascript // 시트를 처음 생성 상태로 다시 생성합니다. sheet.reload(); ``` ```javascript // 리로드 후, 첫 렌더링 발생 시점 sheet.reload(function (r) { r.sheet.disable(1); }) ```",
              "see": [
                {
                  "label": "reloadData method",
                  "url": "./reload-data"
                },
                {
                  "label": "dispose method",
                  "url": "./dispose"
                },
                {
                  "label": "create static",
                  "url": "/docs/static/create"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.26|`callback` 기능 추가|"
            },
            "url": "docs/funcs/core/reload.html"
          },
          {
            "cid": 691,
            "sid": "remove-Col",
            "name": "remove-Col",
            "label": "removeCol",
            "data": {
              "body": "> 지정한 열의 데이터와 영역을 삭제합니다. > 여러 컬럼을 `remove` 할 시 `render` 인자를 `false` 로 하여 작업 후에는 `rerender` 를 무조건 호출하셔야 합니다. ### Syntax ```javascript void removeCol( col, render ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |col|`string`|<span class='required'>필수</span>|삭제할 열 이름| |render|`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 `1(true)`:즉시 반영 (`default`)| ### Return Value ***none*** ### Example ```javascript // sName 열을 삭제한다. sheet.removeCol(\"sName\"); // render 인자 false for (var i = 0; i < 50; i++) { sheet.removeCol( \"EXT_SUBSUM\" + i, false ); } sheet.rerender(); ```",
              "see": [],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.17|`render` 인자 추가|"
            },
            "url": "docs/funcs/core/remove-Col.html"
          },
          {
            "cid": 692,
            "sid": "remove-all",
            "name": "remove-all",
            "label": "removeAll",
            "data": {
              "body": "> 시트의 전체 데이터를 제거합니다. ### Syntax ```javascript void removeAll(); ``` ### Return Value ***none*** ### Example ```javascript //전체 데이터 제거 sheet.removeAll(); ```",
              "see": [
                {
                  "label": "deleteRow method",
                  "url": "./delete-row"
                },
                {
                  "label": "deleteRows method",
                  "url": "./delete-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/remove-all.html"
          },
          {
            "cid": 693,
            "sid": "remove-memo",
            "name": "remove-memo",
            "label": "removeMemo",
            "data": {
              "body": "> 특정 헤더 셀에 저장된 메모를 삭제합니다. > [메모 기능](/docs/props/cfg/memo-id)을 통하여 설정된 메모를 삭제합니다. ### Syntax ```javascript boolean removeMemo( row , col ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col|`string`|<span class='required'>필수</span>|열이름 ### Return Value ***boolean*** : 메모 삭제 성공여부 (메모가 정상적으로 삭제되었으면 true, 그렇지 않을 경우 false 리턴) ### Example ```javascript // 특정 헤더 셀에 저장된 메모를 삭제한다. sheet.removeMemo(sheet.getHeaderRows()[0], \"sCorp\"); ```",
              "see": [
                {
                  "label": "MemoId cfg",
                  "url": "/docs/props/cfg/memo-id"
                },
                {
                  "label": "showMemoDialog method",
                  "url": "./show-memo-dialog"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.19|기능 추가|"
            },
            "url": "docs/funcs/core/remove-memo.html"
          },
          {
            "cid": 694,
            "sid": "remove-page",
            "name": "remove-page",
            "label": "removePage",
            "data": {
              "body": "> 특정 페이지를 삭제합니다. > 현재 포커스가 위치한 페이지는 삭제하실 수 없습니다. ### Syntax ```javascript boolean removePage( page ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |page|`object`|<span class='required'>필수</span>|페이지 데이터 객체 ### Return Value ***boolean*** : 페이지 삭제 성공/실패 여부 ### Example ```javascript //마지막 페이지를 얻음 var page = sheet.getPageByRow( sheet.getLastRow() ); //마지막 페이지를 삭제 sheet.removePage(page); ```",
              "see": [
                {
                  "label": "goToPage method",
                  "url": "./go-to-page"
                },
                {
                  "label": "goToNextPage method",
                  "url": "./go-to-next-page"
                },
                {
                  "label": "goToPrevPage method",
                  "url": "./go-to-prev-page"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/remove-page.html"
          },
          {
            "cid": 695,
            "sid": "remove-row",
            "name": "remove-row",
            "label": "removeRow",
            "data": {
              "body": "> 지정한 행을 삭제 합니다. > [데이터 로우 객체](/docs/appx/row-object)가 삭제되고, 화면에서도 즉시 반영됩니다. > `removeRow`를 사용해서 여러행을 지우는 경우, `norender`인자를 `1`로 설정 후, 작업을 하신 후, `renderBody()`를 무조건 사용하셔야합니다. 또한 머지된 시트에서 사용시에는 `renderBody()`, `setAutoMerge()`까지 무조건 사용하여야 합니다. 여러행을 지우 실 때는 `removeRows` 를 사용하시면 위의 과정을 할 필요가 없습니다. ### Syntax ```javascript void removeRow( row, nomerge, norender ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row|`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |nomerge|`boolean`|<span class='optional'>선택</span>|[DataMerge cfg](/docs/props/cfg/data-merge) 값이 `0` 외의 값일 때, 머지 계산을 바로 할 것인지 여부 `0(false)`:행 삭제 후, 머지 계산 (`default`) `1(true)`:행 삭제 후, 머지 계산 안함| |norender|`boolean`|<span class='optional'>선택</span><mark>(사용주의)</mark>|즉시 화면에 반영할 것인지 여부 해당 기능을 사용한 뒤, 다른 동작을 실행 할 경우 `renderBody()`를 반드시 먼저 실행 해야 합니다. `0(false)`:즉시 반영 (`default`) `1(true)`:반영 안함 | ### Return Value ***none*** ### Example ```javascript // AR5 행을 제거합니다. sheet.removeRow({row:sheet.getRowById(\"AR5\")}); // 체크된 행들을 제거 합니다. var rows = sheet.getRowsByChecked(\"chk\"); for (var i = 0; i < rows.length; i++) { sheet.removeRow(rows[i], null, 1); } sheet.renderBody(); // 무조건 해주어야 다른 동작이 일어남. var rows = sheet.getRowsByChecked(\"chk\"); for (var i = 0; i < rows.length; i++) { sheet.removeRow(rows[i], null, 1); } sheet.renderBody(); // 무조건 해주어야 다른 동작이 일어남. sheet.setAutoMerge(3,3,1); // 머지된 시트의 경우 머지 동작까지 다시 해줘야합니다. ```",
              "see": [
                {
                  "label": "deleteRow method",
                  "url": "./delete-row"
                },
                {
                  "label": "deleteRows method",
                  "url": "./delete-rows"
                },
                {
                  "label": "removeRows method",
                  "url": "./remove-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가||core|8.0.0.7|`norender` 추가|"
            },
            "url": "docs/funcs/core/remove-row.html"
          },
          {
            "cid": 696,
            "sid": "remove-rows",
            "name": "remove-rows",
            "label": "removeRows",
            "data": {
              "body": "> 지정한 여러행들을 삭제 합니다. > 여러 행들을 삭제하고 싶은 경우, `removeRow` 보다는 `removeRows`를 사용하는 것이 좋습니다. ### Syntax ```javascript void removeRow( rows ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |rows|`array[object]`|<span class='required'>필수</span>|삭제하고자 하는 행들| ### Return Value ***none*** ### Example ```javascript // 체크된 행들을 제거 합니다. var rows = sheet.getRowsByChecked(\"chk\"); sheet.removeRows(rows); ```",
              "see": [
                {
                  "label": "removeRow method",
                  "url": "./remove-row"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가|"
            },
            "url": "docs/funcs/core/remove-rows.html"
          },
          {
            "cid": 697,
            "sid": "remove-sub-total",
            "name": "remove-sub-total",
            "label": "removeSubTotal",
            "data": {
              "body": "> 시트 내 존재하는 모든 소계/누계 행을 제거합니다. ### Syntax ```javascript void removeSubTotal(); ``` ### Return Value ***none*** ### Example ```javascript // 소계/누계 행 제거 sheet.removeSubTotal(); ```",
              "see": [
                {
                  "label": "makeSubTotal method",
                  "url": "./make-sub-total"
                },
                {
                  "label": "getSubTotalRows method",
                  "url": "./get-sub-total-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/remove-sub-total.html"
          },
          {
            "cid": 698,
            "sid": "render-body",
            "name": "render-body",
            "label": "renderBody",
            "data": {
              "body": "> Body영역(데이터부분)를 다시 렌더링 합니다. > [setAttribute](./set-attribute)함수나 데이터에 대해 직접 접근하여 수정한 내용을 한꺼번에 화면에 반영할 때 사용됩니다. > 함수 호출시 시트영역이 한 번 깜빡이게 되고, 지금까지 수정한 내용이 한꺼번에 화면에 표시됩니다. > `Head`나 `Foot` 영역은 렌더링 되지 않으므로 `Filter` 행이나 `FormulaRow`에 값을 수정시에는 반영되지 않을 수 있습니다. > 해당 함수는 상당한 리소스를 사용하게 됨으로 빈번하게 호출하지 말고, 업무가 종료되는 시점에서 한 번만 호출하는게 좋습니다. ### Syntax ```javascript void renderBody(); ``` ### Return Value ***none*** ### Example ```javascript var fr = sheet.getFocusedRow(); //속성 변경시 render를 0으로 설정하여 화면에 반영하지 않는다. sheet.setAttribute({row:fr, attr:\"Color\", val:\"#DDDDDD\", render:0}); sheet.setAttribute({row:fr, col:\"AMOUNT02\", attr:\"FontColor\", val:\"#FF0000\", render:0}); //최종 수정된 내용을 화면에 반영한다. sheet.renderBody(); ```",
              "see": [
                {
                  "label": "setAttribute method",
                  "url": "./set-attribute"
                },
                {
                  "label": "rerender method",
                  "url": "./rerender"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/render-body.html"
          },
          {
            "cid": 699,
            "sid": "rerender",
            "name": "rerender",
            "label": "rerender",
            "data": {
              "body": "> 시트 전체 영역을 다시 렌더링 합니다. > [setAttribute](./set-attribute)함수나 데이터에 대해 직접 접근하여 수정한 내용을 한꺼번에 화면에 반영할 때 사용됩니다. > 함수 호출시 시트영역이 한 번 깜빡이게 되고, 지금까지 수정한 내용이 한꺼번에 화면에 표시됩니다. > 해당 함수는 상당한 리소스를 사용하게 됨으로 빈번하게 호출하지 말고, 업무가 종료되는 시점에서 한 번만 호출하는게 좋습니다. ### Syntax ```javascript void rerender( scroll , sync ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |scroll|`boolean`|<span class='optional'>선택</span>|스크롤 바의 위치를 렌더링 이전과 동일하게 유지 여부 `0(false)`:스크롤 바의 위치 유지 안함 `1(true)`:스크롤 바의 위치를 렌더링 후에도 유지 (`default`)| |sync|`boolean`|<span class='optional'>선택</span>|렌더링 작업을 동기로 처리 여부 `0(false)`:비동기 방식 (`default`) `1(true)`:동기 방식| ### Return Value ***none*** ### Example ```javascript //일부 열을 감춘다. sheet.Cols[\"AMT\"][\"Visible\"] = 0; sheet.Cols[\"EMP_ID\"][\"Visible\"] = 0; sheet.Cols[\"INDATE\"][\"Visible\"] = 0; //최종 수정된 내용을 화면에 반영한다. sheet.rerender(); ```",
              "see": [
                {
                  "label": "renderBody method",
                  "url": "./render-body"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/rerender.html"
          },
          {
            "cid": 700,
            "sid": "revert-cell",
            "name": "revert-cell",
            "label": "revertCell",
            "data": {
              "body": "> 특정 셀의 변경된 내용을 처음 조회된 값으로 변경합니다. ### Syntax ```javascript void revertCell( row, col, render ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |col |`string`|<span class='required'>필수</span>|열이름| |render |`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 (`default`) `1(true)`:즉시 반영| ### Return Value ***none*** ### Example ```javascript // 특정 셀에 내용(값)을 처음 조회된 값으로 변경한다. sheet.revertCell( sheet.getFirstVisibleRow(), \"EMT_DESC\", true ); ```",
              "see": [
                {
                  "label": "revertRow method",
                  "url": "./revert-row"
                },
                {
                  "label": "refreshRow method",
                  "url": "./refresh-row"
                },
                {
                  "label": "refreshCell method",
                  "url": "./refresh-cell"
                },
                {
                  "label": "renderBody method",
                  "url": "./render-body"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/revert-cell.html"
          },
          {
            "cid": 701,
            "sid": "revert-data",
            "name": "revert-data",
            "label": "revertData",
            "data": {
              "body": "> 시트 전체 데이터를 조회 시점의 값으로 변경합니다 > **<mark>주의</mark> : 시트의 데이터 값만 변경하며 `Added`, `Changed`, `Deleted` 상태값을 제외한 행 속성, 열 속성, 셀 속성 등은 변경하지 않습니다** > [reloadData](./reload-data)와 달리 [doSearch](./do-search), [loadSearchData](./load-search-data) 함수를 통해 조회된 데이터로 변경합니다 ### Syntax ```javascript void revertData( remainAddRow, sync ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |remainAddRow|`boolean`|<span class='optional'>선택</span>|[addRow](./add-row)로 추가된 행을 남길지에 대한 여부 `0(false)`:추가된 행 모두 삭제 (`default`) `1(true)`:추가된 행 유지| |sync|`boolean`|<span class='optional'>선택</span>|렌더링 작업을 동기로 처리 `0(false)`:비동기 방식 (`default`) `1(true)`:동기 방식| ### Return Value ***none*** ### Example ```javascript // 시트 전체 데이터(값,속성)를 처음 조회된 값으로 변경 sheet.revertData(); // 동기로 동작하도록 합니다. sheet.revertData(null, true); ```",
              "see": [
                {
                  "label": "revertRow method",
                  "url": "./revert-row"
                },
                {
                  "label": "revertCell method",
                  "url": "./revert-cell"
                },
                {
                  "label": "reloadData method",
                  "url": "./reload-data"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.7|기능 추가||core|8.0.0.26|`sync` 인자 추가|"
            },
            "url": "docs/funcs/core/revert-data.html"
          },
          {
            "cid": 702,
            "sid": "revert-row",
            "name": "revert-row",
            "label": "revertRow",
            "data": {
              "body": "> 특정 행의 변경된 내용을 처음 조회된 값으로 변경합니다. > `render:0` 을 사용하여 화면에 바로 반영하지 않고 `rerender` 호출하여 화면에 반영시 `Formula` 계산 반영이 필요한 경우에는 `calculate` 함수를 호출해 주어야 반영 됩니다. ### Syntax ```javascript void revertRow( row, render ); ``` ### Parameters |Name|Type|Required| Description | |----------|-----|---|----| |row |`object`|<span class='required'>필수</span>|[데이터 로우 객체](/docs/appx/row-object)| |render |`boolean`|<span class='optional'>선택</span>|즉시 화면 반영 여부 해당 기능을 `0(false)`로 사용했을 경우, 작업 마무리 시에 `rerender()`를 실행해야 화면에 반영 됩니다. `0(false)`:반영 안함 (`default`) `1(true)`:즉시 반영| ### Return Value ***none*** ### Example ```javascript // 특정 행에 모든 셀 내용(값)을 처음 조회된 값으로 변경한다. sheet.revertRow( row, true ); ```",
              "see": [
                {
                  "label": "revertCell method",
                  "url": "./revert-cell"
                },
                {
                  "label": "refreshCell method",
                  "url": "./refresh-cell"
                },
                {
                  "label": "renderBody method",
                  "url": "./render-body"
                },
                {
                  "label": "rerender method",
                  "url": "./rerender"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|8.0.0.0|기능 추가|"
            },
            "url": "docs/funcs/core/revert-row.html"
          },
          {
            "cid": 703,
            "sid": "save-current-info",
            "name": "save-current-info",
            "label": "saveCurrentInfo",
            "data": {
              "body": "> 현재 시트의 정보를 로컬 스토리지 혹은 세션 스토리지에 저장하는 메소드입니다. > 기본적으로 Key값은 [StorageKeyPrefix](/docs/props/cfg/storage-key-prefix)+\"^시트id\" 로 설정됩니다. > 저장되는 값은 [StorageCompressMode](/docs/props/cfg/storage-compress-mode)에 따라 압축되어서 저장됩니다. > [StorageSession](/docs/props/cfg/storage-session) 값이 없으면 동작하지 않습니다. > **`주의`** : 시트 초기화 시점 컬럼 정보와 저장하는 시트 컬럼 정보가 다를 경우 로컬 스토리지 혹은 세션 스토리지에 저장된 정보가 지워집니다. ### Syntax ```javascript boolean saveCurrentInfo(); ``` ### Return Value ***boolean*** ```javascript options.Cfg = { StorageSession: 1 // 로컬 스토리지에 현재 시트 정보를 저장할 수 있고 가져올 수 있도록 설정 }; ``` ### Example ```javascript // 현재 시트의 정보를 로컬 스토리지 혹은 세션 스토리지에 저장한다. if (sheet.saveCurrentInfo()) { alert(\"현재 시트 정보를 저장했습니다.\"); } else { alert(\"현재 시트 정보를 저장하는데 실패했습니다.\"); } ```",
              "see": [
                {
                  "label": "StorageSession cfg",
                  "url": "/docs/props/cfg/storage-session"
                },
                {
                  "label": "StorageKeyPrefix cfg",
                  "url": "/docs/props/cfg/storage-key-prefix"
                },
                {
                  "label": "StorageCompressMode cfg",
                  "url": "/docs/props/cfg/storage-compress-mode"
                },
                {
                  "label": "clearCurrentInfo method",
                  "url": "./cle