/* eslint-disable */
var MARKDOWN_TOC_DATA = [
  {
    "gid": 1,
    "name": "intro",
    "label": "Introduction",
    "children": [
      {
        "cid": 1,
        "sid": "feature",
        "name": "feature",
        "label": "제품의 특징",
        "data": {
          "body": "`IBSheet7`은 javascript 기반의 **데이터 그리드 컨트롤 컴포넌트** 입니다. 10년 이상 쌓아온 전문화된 노하우를 바탕으로 그리드, 차트, 업로드 등 다양한 UI 요소를 표현하기 위한 최고의 컴포넌트 기반 솔루션을 제공합니다. ## 주요한 제품의 기능 ### *Data 조회 기능* Ajax 통신을 통하여 서버로부터 데이터를 조회합니다. 시트 위에 표현되어야 할 데이터를 `XML` 또는 `JSON` 형태로 가져와 로딩함으로써 기존에 페이지를 리로딩하는 것보다 효율적으로 데이터를 가져올 수 있습니다. ### *Data Column Sorting* IBSheet7에 조회되거나 작성된 데이터는 헤더를 클릭하는 동작만으로 서버를 거치지 않고 오름차순/내림차순으로 정렬할 수 있습니다. [ColumnSort](/docs/funcs/col/ColumnSort) 를 사용하여 하나의 컬럼이 아닌 다수의 컬럼을 DB Query의 order by와 같이 동시에 소팅하는 작업도 가능합니다. ![s](/assets/imgs/ibsheet7_sorting.png) [**컬럼 소팅 예시**] ### *Multi-Record Transaction* IBSheet7의 변경된 데이터는 시트 내부적으로 관리됩니다. 따라서 IBSheet7은 최초 조회시 데이터와 변경된 데이터를 동시에 갖고 있다가 저장 메소드 호출되었을 때, 전체 데이터 중에 변경된 데이터를 포함하고 있는 행(Row)을 묶어서 서버로 전달합니다. ![s](/assets/imgs/ibsheet7_multiRecord.png) [**멀티라인 레코드 예시**] ### *Tree Data* IBSheet7의 특정 컬럼을 트리로 지정하고, 조회되는 데이터도 행(Row)단위로 Level(depth)을 지정해 주면 트리기능을 사용할 수 있습니다. 트리 기능을 사용하는 시트의 경우 행단위로 `Level`값을 갖게되고 이를 통하여 특정 Level까지 자동으로 접거나 펼치는 기능들을 사용할 수 있습니다. `제약사항` 트리 기능 사용시 소트 기능은 지원되지 않습니다. ![s](/assets/imgs/ibsheet7_tree.png) [**트리 일반 설정 예시**] ### *Data Column 자동 연산 처리* IBSheet7에서는 Column 간의 연산식을 등록하게 되면 Data가 조회됨과 동시에 등록된 연산식을 통하여 자동으로 연산된 값을 출력합니다. 또한 사용자가 데이터를 변경시에도 연산식 적용이 가능합니다. ![s](/assets/imgs/ibsheet7_subsum.png) [**숫자 데이터 소계 사용 예시**] ### *Column Freezing & Sizing* 컬럼의 너비와 개수가 많아서 수평 스크롤바로 이동하며 데이터를 조회하는 경우 틀고정 컬럼의 위치를 사용자가 마우스로 이동하며 데이터를 표현할 수 있습니다.(`Column Freezing`) 컬럼의 너비가 작아서 데이터가 잘려서 표시되는 경우 해당 헤더와 좌측 헤더 사이의 선을 마우스를 이용하여 너비를 사용자가 조정할수 있습니다.(`Column Sizing`) 그리고, 컬럼의 위치를 마우스를 이용하여 움직여서 사용자가 우선으로 생각하는 데이터 컬럼을 앞으로 옮겨와서 보다 편한 UI를 EndUser가 생성할 수 있도록 합니다. ![s](/assets/imgs/ibsheet7_colmove.gif) [**컬럼 이동 예시**] ### *Type* 각 컬럼의 기능이라 할 수 있는 Type을 제공합니다. 일반적인 `Text` 외에 `CheckBox`, `Combo`, `Popup`, `Image` 등이 제공됩니다. 각각 컬럼에 적용하는 타입에 따라 사용할 수 있는 다양한 기능의 메소드가 제공됩니다. ![s](/assets/imgs/ibsheet7_type.png) [**다양한 기타 타입 예시**] ## 주요 적용 대상 업무 `※` 리스트를 조회하고, 정렬순서를 변경하여 다시 조회하고자 하는 경우가 많은 업무 `※` 리스트 조회 시 조회조건에 따라 화면 Reload가 많고 데이터 양이 많은 업무 `※` 업무적으로 한번에 반드시 여러 건을 입력 / 수정 / 삭제해야 하는 업무 `※` 컬럼간 계산 로직이 많은 업무 `※` 기존 C/S환경과 비슷한 구조로 웹 환경으로 변경하고자 하는 업무"
        },
        "url": "docs/intro/feature.html"
      },
      {
        "cid": 2,
        "sid": "files",
        "name": "files",
        "label": "파일 구성",
        "data": {
          "body": "## IBSheet7 제품은 다음과 같은 파일, 폴더로 구성되어 있습니다. ``` ─ sheet 최상위 폴더 ├─ ibleaders.js // 라이선스 파일 ├─ ibsheet.js // IBSheet7 core 파일 ├─ ibsheetinfo.js // 시트 초기화시 필요한 함수 js 파일 ├─ ibmsg // IBSheet7에서 사용하는 시스템 메시지 파일 ├─ ibsheet.cfg // 모든 시트에 공통으로 적용하는 기능 설정 파일 ├─ ibexcel.js // 클라이언트 기반 import/export 관련 파일 ├─ Down2Excel.jsp // 서버사이드 기반 Java 기반 환경 jsp 파일들 (ibsheet.cfg에서 경로 설정) ├─ LoadExcel.jsp ├─ DirectLoadExcel.jsp ├─ DirectDown2Excel.jsp ├─ Down2Hml.jsp ├─ Down2Pdf.jsp ├─ Down2Text.jsp ├─ LoadText.jsp ├─ Down2Excel.aspx // .Net 기반 환경 aspx 파일들 (ibsheet.cfg에서 경로 설정) ├─ LoadExcel.aspx ├─ Down2Text.aspx ├─ LoadText.aspx ├─ Down2Pdf.aspx ├─ DirectDown2Excel.aspx ├─ DirectLoadExcel.aspx └─ Main // 기본 테마 정보를 담고 있는 폴더 └─ ibsheet.css // IBSheet7 테마 css 파일 ``` ## 각 파일의 기능은 아래와 같습니다. ### *ibleaders.js* `제품 라이선스` 정보를 담고 있는 파일 (IBSheet7 제품군 공통 js 파일) ### *ibsheet.js* IBSheet7 엔진 js 파일 ### *ibsheetinfo.js* 시트 초기화시 필요한 함수 및 개발시 유용하게 사용할 수 있는 js함수를 담아둔 파일 ### *ibmsg* IBSheet7에서 사용하는 시스템 메시지 파일 ### *ibsheet.cfg* 모든 시트에 공통으로 설정할 기능 설정 파일 (설정할 수 있는 내용은 Cfg - PropertyList 참조) <hr> 이 외에도 파일 업로드/다운로드 관련 기능을 사용하시려면 파일 업로드/다운로드 관련 모듈을 임포트 해주셔야 합니다. 파일 업로드/다운로드 모듈 관련해서는 [파일 다운로드/업로드] Appendix를 참고해주세요. - [파일 업로드/다운로드](/docs/appx/import-export)"
        },
        "url": "docs/intro/files.html"
      }
    ]
  },
  {
    "gid": 2,
    "name": "start",
    "label": "Getting Started",
    "children": [
      {
        "cid": 4,
        "sid": "quick-start",
        "name": "quick-start",
        "label": "Quick Start",
        "data": {
          "body": "## 1. ibsheet7 설치 `IBSheet7` 를 사용하기 위해 다음 js 파일들을 import 합니다. (`ibsheet.css 파일은 ibsheet.js 파일에서 자동 참조함으로 별도 링크를 넣지 않습니다`) ```html <!-- 라이선스 파일 --> <script language=\"javascript\" src=\"/Sheet/ibleaders.js\"></script> <!-- 제품 파일 --> <script language=\"javascript\" src=\"/Sheet/ibsheetinfo.js\"></script> <script language=\"javascript\" src=\"/Sheet/ibsheet.js\"></script> <!-- client import/export 기능 파일 --> <script language=\"javascript\" src=\"/Sheet/ibexcel.js\"></script> ``` 위 파일들의 자세한 용도와 기능은 [파일 구성](/docs/intro/files) 참고 ## 2. IBSheet7 객체 생성 ### body 태그 안에서 함수 호출 js파일을 추가한 뒤에 IBSheet 객체를 화면에 추가합니다. `ibsheetinfo.js` 에 있는 `createIBSheet('sheetid', 'width', 'height', 'lang')` 함수를 이용하여 추가합니다. ```html <body> <table class='sheet_table'> <tr> <td> <script language=\"javascript\"> //IBSheet 객체 생성 ( 객체 id , 너비 , 높이 ) createIBSheet(\"mySheet\", \"750px\", \"400px\"); // 아래와 같이 lang 인자를 사용하는 경우에는 인자를 확장자로 하는 ibmsg 파일이 반드시 존재해야 합니다. createIBSheet(\"mySheet\", \"750px\", \"400px\", \"en\"); </script> </td> </tr> </table> </body> ``` ## 3. 초기항목 설정 객체가 생성된 후 페이지가 onload 될 때 시트의 초기 항목을 설정합니다. 아래와 같이 body 태그의 onload 이벤트에서 IBSheet7에 대한 초기 항목을 설정할 함수를 정의 합니다. ```html <body onload=\"기본 속성을 설정할 함수\"> ``` body 태그의 onload 이벤트에서 정의하는 것은 페이지의 로드가 완료 되는 시점에 IBSheet7의 객체도 생성이 완료되므로 그 때 IBSheet7의 제공 기능들을 사용할 수 있기 때문에 `객체 생성 전에 IBSheet 기능을 사용하려고 한다면 자바스크립트 오류가 발생 할 수 있습니다.` ### 시트 기본 설정 ```javascript IBSheet객체.SetConfig(cfg); //Example var cfg= { FrozenCol:3 , MergeSheet:msPrevColumnMerge + msHeaderOnly }; IBSheet객체.SetConfig(cfg); ``` 시트 전반적인 기능 설정 (조회방식, 머지유형, 소팅 개수, 합계행위치 등)을 합니다. 전달되는 인자의 형식은 `JSON` 타입으로 설정 하고자 하는 정보를 `JSON` 형태로 구성하여 전달합니다. 세부 정보는 [SetConfig method](/docs/funcs/init/SetConfig) 설명 참조 ### 헤더 정보 설정 ```javascript IBSheet객체.InitHeaders(headers, info); //Example var headers = [ {Text:\"사원정보|사원정보|사원정보\", Align:\" Center\"}, {Text:\"사원명|사원번호|입사일\", Align:\" Center\"} ]; var info = {Sort:1, ColMove:1, ColResize:0, HeaderCheck:0}; IBSheet객체.InitHeaders(headers, info); ``` 헤더행의 타이틀과 해더의 기능(소팅,이동,크기조정 등) 사용여부를 설정합니다. 세부 정보는 [InitHeaders method](/docs/funcs/init/InitHeaders) 설명 참조 ### 컬럼 정보 설정 ```javascript IBSheet객체.InitColumns(cols); //Example var cols = [ {Type:\"Text\", Width:100 ,SaveName:\"sText\", Align:\"Left\"}, {Type:\"Int\", Width:80 ,SaveName:\"sNumber\", Format:\"NullInteger\"} ]; IBSheet객체.InitColumns(cols); ``` 컬럼에 대한 기본 속성(타입, 포멧, 너비, 정렬 등) 을 설정합니다. 자세한 속성은 [InitColumns method](/docs/funcs/init/InitColumns) 설명 참조 ### 시트 초기화 단순화 시트 초기화시 헤더에 타이틀과 각 컬럼의 속성이 각각 `InitHeader`와 `InitColumns` 메서드를 통해 설정되어 컬럼이 많아지는 경우 타이틀에 해당하는 컬럼을 찾기가 어려운 점이 있습니다. IBSheet7에서는 위 방법 외에 하나의 함수를 통해 초기화 하는 방법도 제공합니다. Header의 경우 `|` 구분자 뿐만 아니라, String 배열 형태로도 구현이 가능하고,`HeaderHtml` 속성을 이용하여 Html 타입의 헤더를 구현 할 수 있습니다. ```javascript //배열 선언 var initdata = {}; //SetConfig initdata.Cfg = {SearchMode:smLazyLoad,Page:50,MergeSheet:msHeaderOnly}; //InitHeaders의 두번째 인자 initdata.HeaderMode = {Sort:1,ColMove:1,ColResize:1,HeaderCheck:0}; //InitColumns + Header Title initdata.Cols = [ {Header:\"결재여부|결재여부\",Type:\"CheckBox\",Width:80,SaveName:\"A\",ColMerge:0}, {Header:\"신청인|신청인\",Type:\"Text\",Width:80,ColMerge:1}, {Header:\"신청일자|신청일자\",Type:\"Date\",Width:100,Format:\"Ymd\"}, {Header:\"신청금액|신청금액\",Type:\"AutoSum\",Width:85,SaveName:\"B\",Format:\"Integer\"}, {Header:\"기간|시작일\",Type:\"Date\",Width:100,SaveName:\"C\",Format:\"Ymd\",ColMerge:0}, {Header:\"기간|종료일\",Type:\"Date\",Width:100,SaveName:\"D\",Format:\"Ymd\",ColMerge:0}, {Header:\"시간|시작\",Type:\"Date\",Width:100,Format:\"Hm\",ColMerge:1,Align:\"Center\"}, {Header:[\"시간\", \"종료\"],Type:\"Date\",Width:100,Format:\"Hm\",ColMerge:1,Align:\"Center\"} ]; //초기화 IBS_InitSheet(mySheet, initdata); ``` ## 4. 기능 구현하기 ### 조회 ``` javascript IBSheet객체.DoSearch(PageUrl, CondParam); ``` [DoSearch](/docs/funcs/search/DoRowSearch) 함수를 이용하여 데이터를 조회 할 수 있습니다. ### 입력 ```javascript IBSheet객체.DataInsert(Row,Level); ``` [DataInsert](/docs/funcs/row/DataInsert) 함수를 이용하여 신규 데이터 행을 생성 할 수 있습니다. ### 수정 데이터를 수정하면 Type이 `Status`인 컬럼에 `\"수정\"` 이라고 표시하고 내부적으로 `\"U\"` 라는 코드 값을 갖습니다. 기존 상태가 \"입력\" 이라면 기존 상태 그대로 유지 하며, 기존 상태가 \"삭제\" 인 경우 모든 데이터는 수정할 수 없습니다. `주의` 수정 상태를 기록하기 위해서는 반드시 Type이 `Status`인 컬럼이 존재해야 합니다. ### 삭제 Type이 `DelCheck` 인 컬럼을 CheckBox를 Check 할때 Status인 컬럼에 `\"삭제\"` 라고 표시하고 내부적으로 `\"D\"` 라는 코드값을 갖습니다. 기존 상태가 \"입력\" 인 행을 Check하면 DB에 없는 데이터이므로 바로 행을 제거합니다. Type이 Status인 컬럼과 DelCheck 인 컬럼이 존재 할 경우 처리 가능합니다. ### 저장 ```javascript IBSheet객체.DoSave(PageUrl, SubParam, Col); ``` [DoSave](/docs/funcs/save/DoSave) 함수를 이용하여 데이터를 저장할 수 있습니다. 데이터의 트랜잭션 상태 또는 특정 컬럼 데이터에 따라 저장 처리합니다. ### 소계 ``` javascript IBSheet객체.ShowSubSum(info); ``` [ShowSubSum](/docs/funcs/sum/ShowSubSum) 함수를 이용하여 특정 컬럼을 기준으로 조회 데이터 사이에 소계 행을 삽입 할 수 있습니다. ### 엑셀다운로드 ```javascript IBSheet객체.Down2Excel(params); ``` [Down2Excel](/docs/funcs/export/Down2Excel) 함수를 이용하여 시트의 내용을 엑셀 파일로 다운로드 할 수 있습니다. 이 함수의 동작 방식은 `ibsheet.cfg` 파일에 `ExportMode` 설정 값을 따릅니다. ### 이벤트 사용 ```javascript function IBSheet객체_이벤트명(params) {} // Example // IBSheet 객체명이 \"mySheet이고 OnChange 이벤트를 사용 function mySheet_OnChange(row, col, value) { if(mySheet.ColSaveName(col) == \"DT_price\" && value> 5000) { alert(\"가격 제한 범위를 넘어셨습니다.\"); mySheet.ReturnCellData(row, col); } } ``` I IBSheet7의 이벤트는 사용하는 `IBSheet객체명_이벤트이름()`의 형태로 스크립트 함수를 만들고, 이벤트 발생시 행해야 하는 로직을 함수 안에 기술하여 사용합니다. ## 5. 조회 XML 구현하기 조회 함수를 호출하면 인자로 넘긴 URL로 페이지에 연결합니다. XML 형태로 구성된 페이지의 내용을 읽어 들여 데이터로 표현합니다. ![s](/assets/imgs/ibsheet7_xml.png) [**조회된 내역이 있는 경우**] `XML 생성시 주의사항` - XML의 인코딩 타입은 반드시 `UTF-8`로 해야하며, 그렇지 않으면 한글등을 데이터로 사용할 때 글자가 깨지게 됩니다. - XML의 내용 중 HTML 관련 태그 (html, body, input 등)나 Script 관련 태그(JavaScript, alert 등)는 사용 불가능하며 만약 사용 시 XML오류가 발생합니다. - 다음과 같은 특수 문자는 사용 불가능 하므로 변환 문자로 변환하여 XML을 생성합니다. `& -> &amp;, < -> &lt;, > -> &gt;` ## 6. 저장 XML 구현하기 저장 함수를 호출하면 인자로 넘긴 URL로 페이지에 연결합니다. 저장은 `<XML>` 형식을 사용하지 않고 기존 param 형식을 사용합니다. 저장 처리 후 처리 결과는 XML 형태로 구성되며 페이지의 내용을 읽어 들여 결과를 표현합니다. ![s](/assets/imgs/ibsheet7_savexml.png) [**저장 처리 결과 표시 형태**] ## 7. 조회 JSON 구현하기 조회 함수를 호출하면 인자로 넘긴 URL로 페이지에 연결합니다. JSON 형태로 구성된 페이지의 내용을 읽어 들여 데이터로 표현합니다. ```json // savename을 사용하는 예 { Etc : {\"USER\":\"황상구\",\"CRTDATE\":\"20130120\"}, Message:\"조회가 정상 처리되었습니다.\", Data: [ {SANO: 070712, SANM:'홍길동', CLSCD:'5',DEPTCD:'054'}, { SANO: 020457, SANM:'김대한', CLSCD:'4',DEPTCD:'040'} ] } ``` `주의` 조회 JSON을 구현할 때에는 `대소문자 구분`을 정확하게 해야 합니다. ## 8. 저장 JSON 구현하기 저장 함수를 호출하면 인자로 넘긴 URL로 페이지에 연결합니다. 저장은 JSON 형식을 사용하지 않고 기존 `param형식`을 사용합니다. 저장 처리 후 처리 결과는 JSON 형태로 구성되며 페이지의 내용을 읽어 들여 결과를 표현한다. ```json { Result : {Code:0, Message:'저장되었습니다.'} } ```"
        },
        "url": "docs/start/quick-start.html"
      },
      {
        "cid": 3,
        "sid": "dev-example",
        "name": "dev-example",
        "label": "개발 실습",
        "data": {
          "body": "Oracle DB를 기본적으로 가지고 있는 EMP 테이블을 기준으로 화면을 구성하는 실습 예제입니다. ## 1. IBSheet7 객체 생성 및 기본 속성 설정하기 `ibsheetinfo.js` 내의 `createIBSheet` 함수를 사용하여 IBSheet 객체를 생성하고 body의 OnLoad 이벤트에서 생성된 객체에 대한 기본 속성을 설정합니다. ```html <body onload=\"LoadPage()\"> <script type=\"text/javascript\"> createIBSheet(\"mySheet\", \"100%\", \"100%\"); </script> </body> ``` [**객체 생성하기**] ```html <script type=\"text/javascript\" src=\"/js/ibsheet/ibsheet.js\"></script> <script type=\"text/javascript\" src=\"/js/ibsheet/ibsheetinfo.js\"></script> <script type=\"text/javascript\"> function LoadPage() { var cfg = {FrozenCol:3,MergeSheet:msHeaderOnly }; mySheet.SetConfig(cfg); var header = [ {Text:\"상태|삭제|직책|부서코드|ID|이름|입사일|책임자|급여|COMM\",Align:\"Center\"} ]; var info = {Sort:0,ColMove:1,ColResize:1}; mySheet.InitHeaders(header,info); var cols = [ {Type:\"Status\",Width:60,SaveName:\"sStatus\",Align:\"Center\"}, {Type:\"DelCheck\",Width:60,SaveName:\"sDelete\",Align:\"Center\"}, {Type:\"Text\",Width:100,SaveName:\"JOB\",Align:\"Center\"}, {Type:\"Text\",Width:100,SaveName:\"DEPTNO\",Align:\"Center\"}, {Type:\"Text\",Width:60,SaveName:\"EMPNO\",Align:\"Center\"}, {Type:\"Text\",Width:150,SaveName:\"ENAME\",Align:\"\"}, {Type:\"Date\",Width:120,SaveName:\"HIREDATE\",Format:\"Ymd\",Align:\"Center\",EditLen:8}, {Type:\"Text\",Width:120,SaveName:\"MGR\",Align:\"Center\"}, {Type:\"Int\",Width:120,SaveName:\"SAL\",Align:\"Right\",Format:\"NullInteger\"}, {Type:\"Int\",Width:60,SaveName:\"COMM\",Align:\"Right\",Format:\"Integer\"} ]; mySheet.InitColumns(cols); } </script> ``` [**기본 속성 설정하기**] 위와 같이 소스를 생성하고 실행하면 아래와 같은 모습의 오브젝트가 생성됩니다. ![s](/assets/imgs/ibsheet7_ex1.png) ## 2. 각종 기능 구현하기 트랜잭션과 관련된 각종 기능 버튼을 생성하고 기능버튼이 처리해야할 작업을 자바스크립트 함수로 구현합니다. 입력과 행 복사 기능을 다음과 같이 구현합니다. ```javascript function doAction(sAction) { switch(sAction) { case \"Insert\": //입력 mySheet.DataInsert(); break; case \"Copy\"://행 복사 mySheet.DataCopy(); break; } } // 입력, 행 복사 버튼 <input type=\"button\" value=\"입력\" onClick=\"doAction('Insert')\"> <input type=\"button\" value=\"행복사\" onClick=\"doAction('Copy')\"> <table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" width=\"100%\"> <tr> <td bgcolor=\"#FFFFFF\">Employee Name</td> <td bgcolor=\"#FFFFFF\"> <input type=\"text\" name=\"sa_name\"> </td> <td bgcolor=\"#FFFFFF\">Salary</td> <td bgcolor=\"#FFFFFF\"> <input type=\"text\" class=\"on_curr1\" name=\"sal\" value=\"0\"> </td> <td bgcolor=\"#FFFFFF\">HireDate</td> <td bgcolor=\"#FFFFFF\"> <input type=\"text\" class=\"on_date\" name=\"hdate\" > </td> </tr> </table> ``` ## 3. 조회하기 IBSheet7에서는 조회 기능을 처리 하기 위해서는 다음의 4가지 과정을 처리합니다. - 조회 함수 사용하기 `(필수)` - 다음 페이지 조회 이벤트 처리하기 <span style=\"color:blue;\">(선택)</span> - 조회 XML or JSON 생성하기 `(필수)` - 조회 완료 이벤트 처리하기 <span style=\"color:blue;\">(선택)</span> * 조회 함수 사용하기 `(필수)` ```javascript function doSearch() { //조회조건 var param = \"sa_name=\"+document.frm.sa_name.value+\"&sal=\" + document.frm.sal.value+\"&hdate=\" + document.frm.hdate.value; //조회하기 (페이지명, 조회조건); mySheet.DoSearch(\"dataList.jsp\",param); } ``` 조회 조건 인자는 여러 개 조회 조건을 조건명과 조건값을 `\"=\"`로 연결하고, 여러 개 조건이 사용될 경우 `\"&\"`로 연결하여 다음과 같이 구성합니다. **조건1=값1&조건2=값2&조건3=값3** * 조회 XML 생성하기 `(필수)` 조회 함수에서 설정한 조회 XML 페이지를 구성합니다. 아래는 datalist.jsp를 구현한 샘플 페이지 입니다. ```jsp <%@ page language=\"java\" contentType=\"text/html; charset=UTF-8\" pageEncoding=\"UTF-8\" import=\"java.sql.*,java.util.*,com.fasterxml.jackson.databind.ObjectMapper,com.fasterxml.jackson.databind.ObjectWriter \"%> <% Connection conn = null; PreparedStatement pstmt = null; ResultSet rs = null; Map data = new HashMap(); String url = \"jdbc:oracle:thin:@localhost:1521:xe\"; String id = \"scott\"; String pwd = \"tiger\"; String driver = \"oracle.jdbc.driver.OracleDriver\"; String query = + \"SELECT \" + \"EMPNO,ENAME,JOB,MGR \" + \",HIREDATE,SAL,COMM,DEPTNO \" + \",CASE \" + \" WHEN SAL>4500 THEN '#FF0000' \" + \" ELSE '#0000FF' \" + \" END AS \\\"sal#FontColor\\\" \" + \",CASE \" + \" WHEN MGR IS NULL THEN '0' \" + \" ELSE '1' \" + \" END AS \\\"Edit\\\" \" + \" FROM EMP WHERE 1 = 1 \" + \" AND ENAME like '%'||?\"; try { Class.forName(driver); conn = DriverManager.getConnection(url,id,pwd); pstmt = conn.prepareStatement(query); pstmt.setString(1, request.getParameter(\"sa_name\")); rs = pstmt.executeQuery(); List li = Result2List(rs); //ResultSet을 List<Map>으로 치환 data.put(\"Data\",li); //List내용을 JSON string으로 치환. String rtnJSON = new ObjectMapper().writer().writeValueAsString(data); out.println(rtnJSON); } catch(Exception ex) { Map rtnMap = new HashMap(); Map result = new HashMap(); //오류 발생 result.put(\"Code\",-1); result.put(\"Message\",\"오류가 발생하였습니다.\"); rtnMap.put(\"Result\" , result ); String rtnJSON = new ObjectMapper().writer().writeValueAsString(rtnMap); out.println(rtnJSON); } finally { rs.close(); pstmt.close(); conn.close(); } %> <%! public List Result2List(ResultSet rs) throws Exception { List list = new ArrayList(); ResultSetMetaData rsmd = rs.getMetaData(); while(rs.next()) { int numColumns = rsmd.getColumnCount(); Map obj = new HashMap(); for( int i=1; i<numColumns+1; i++) { String column_name = rsmd.getColumnName(i); switch( rsmd.getColumnType( i ) ) { case java.sql.Types.ARRAY: obj.put(column_name, rs.getArray(column_name)); break; case java.sql.Types.BIGINT: obj.put(column_name, rs.getInt(column_name)); break; case java.sql.Types.BOOLEAN: obj.put(column_name, rs.getBoolean(column_name)); break; case java.sql.Types.BLOB: obj.put(column_name, rs.getBlob(column_name)); break; case java.sql.Types.DOUBLE: obj.put(column_name, rs.getDouble(column_name)); break; case java.sql.Types.FLOAT: obj.put(column_name, rs.getFloat(column_name)); break; case java.sql.Types.INTEGER: obj.put(column_name, rs.getInt(column_name)); break; case java.sql.Types.NVARCHAR: obj.put(column_name, rs.getNString(column_name)); break; case java.sql.Types.VARCHAR: obj.put(column_name, rs.getString(column_name)); break; case java.sql.Types.TINYINT: obj.put(column_name, rs.getInt(column_name)); break; case java.sql.Types.SMALLINT: obj.put(column_name, rs.getInt(column_name)); break; case java.sql.Types.DATE: obj.put(column_name, \"\"+rs.getDate(column_name)); break; case java.sql.Types.TIMESTAMP: obj.put(column_name, rs.getTimestamp(column_name)); break; default: obj.put(column_name, rs.getObject(column_name)); break; } } list.add(obj); } return list; } %> ``` 위와 같이 작성된 페이지는 웹서버에서 컴파일이 완료되어 아래와 같은 형태로 나타나게 됩니다. ```xml <!--조회된 내역이 없는 경우 --> {\"Data\":[]} <!--조회된 내역이 있는 경우 --> { \"Data\": [ {\"EMPNO\":7499,\"ENAME\":\"ALLEN\",\"JOB\":\"CLERK\",\"MGR\":7698,\"HIREDATE\":1371567600000,\"SAL\":1600,\"COMM\":300,\"DEPTNO\":70,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7521,\"ENAME\":\"JAMES\",\"JOB\":\"SALESMAN\",\"MGR\":7698,\"HIREDATE\":351615600000,\"SAL\":1250,\"COMM\":500,\"DEPTNO\":30,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7566,\"ENAME\":\"SUDAN\",\"JOB\":\"SALESMAN\",\"MGR\":7839,\"HIREDATE\":354985200000,\"SAL\":2975,\"COMM\":0,\"DEPTNO\":40,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7654,\"ENAME\":\"MARTIN\",\"JOB\":\"SALESMAN\",\"MGR\":7698,\"HIREDATE\":370450800000,\"SAL\":1250,\"COMM\":1400,\"DEPTNO\":30,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7698,\"ENAME\":\"MIKE\",\"JOB\":\"MANAGER\",\"MGR\":7839,\"HIREDATE\":357490800000,\"SAL\":2850,\"COMM\":0,\"DEPTNO\":40,\"Sal#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7782,\"ENAME\":\"clack\",\"JOB\":\"MANAGER\",\"MGR\":7839,\"HIREDATE\":360860400000,\"SAL\":2450,\"COMM\":0,\"DEPTNO\":40,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7788,\"ENAME\":\"SCOTT1\",\"JOB\":\"ANALYST\",\"MGR\":7566,\"HIREDATE\":552492000000,\"SAL\":99999,\"COMM\":0,\"DEPTNO\":30,\"SAL#FontColor\":\"#FF0000\",\"Edit\":\"1\"}, {\"EMPNO\":7839,\"ENAME\":\"king\",\"JOB\":\"PRESIDENT\",\"HIREDATE\":374770800000,\"SAL\":5000,\"COMM\":0,\"DEPTNO\":10,\"SAL#FONTCOlor\":\"#FF0000\",\"Edit\":\"0\"}, {\"EMPNO\":7844,\"ENAME\":\"TURNER\",\"JOB\":\"SALESMAN\",\"MGR\":7698,\"HIREDATE\":368722800000,\"SAL\":1500,\"COMM\":0,\"DEPTNO\":30,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7902,\"ENAME\":\"FORD\",\"JOB\":\"ANALYST\",\"MGR\":7566,\"HIREDATE\":376153200000,\"SAL\":3000,\"COMM\":100,\"DEPTNO\":20,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"}, {\"EMPNO\":7934,\"ENAME\":\"MILLER\",\"JOB\":\"CLERK\",\"MGR\":7782,\"HIREDATE\":380559600000,\"SAL\":1300,\"COMM\":200,\"DEPTNO\":20,\"SAL#FontColor\":\"#0000FF\",\"Edit\":\"1\"} ] } ``` * 조회 완료 이벤트 처리하기 <span style=\"color:blue;\">(선택)</span> 조회가 완료되고 그 뒤에 어떤 로직 처리가 필요한 경우 완료 이벤트에 대한 처리를 구현합니다. ```javascript function mySheet_OnSearchEnd(code, msg) { if(msg!=\"\"){ alert(msg); } } ``` 위와 같이 조회 기능을 완료하여 처리하면 아래와 같은 화면이 생성됩니다. ![s](/assets/imgs/ibsheet7-searchresult.png) ## 4. 저장하기 저장 기능을 처리 하기 위해서는 다음의 4가지 과정을 처리한다. - 저장 함수 호출하기 `(필수)` - Validation 확인하기 <span style=\"color:blue;\">(선택)</span> - 저장 JSON 생성하기 `(필수)` - 저장 완료 이벤트 처리하기 <span style=\"color:blue;\">(선택)</span> * 저장 함수 호출하기 `(필수)` ```javascript function doSave(){ //저장하기 (페이지명, 저장추가정보); var param = FormQueryStringEnc(document.frm); mySheet.DoSave(\"save.jsp\",param); } ``` 저장 처리할 페이지명을 설정하고 추가 저장할 정보를 설정하여 조회 함수를 호출하면 내부적으로 트랜잭션 상태가 \"조회\"가 아닌 행의 값을 해당 데이터의 SaveName 으로 조합하여 저장 페이지로 넘깁니다. (SaveName은 `InitColumns` 함수를 통해서 설정) * Validation 확인하기 <span style=\"color:blue;\">(선택)</span> 저장 함수를 이용하여 저장 하기 전에 각 데이터에 대한 Validation 확인을 OnValidation 이벤트에 정의합니다. 업무에 따라 발생할 수 있는 각종 Validation은 이 이벤트에 구현합니다. ```javascript function mySheet_OnValidation(Row, Col, Value) { switch(Col) { case 8: if (Value > 1000 ) { alert(\"1000 이상을 설정할 수 없습니다.\"); mySheet.ValidateFail(1); mySheet.SetSelectCell(Row, 8); } break; } } ``` * 저장 JSON 생성하기 `(필수)` 저장할 데이터가 유효하다면 다음과 같이 저장 처리 페이지를 구성합니다. 결과 컬럼에 저장 처리 결과를 설정하는 방식의 저장 XML을 다음과 같이 구성합니다. ```jsp <%@ page language=\"java\" contentType=\"text/html; charset=UTF-8\" pageEncoding=\"UTF-8\" import=\"java.sql.*\" %> <% //디비 접속 관련 Connection conn = null; PreparedStatement pstmt = null; ResultSet rs = null; String url = \"jdbc:oracle:thin:@localhost:1521:xe\"; String id = \"scott\"; String pwd = \"tiger\"; String driver = \"oracle.jdbc.driver.OracleDriver\"; //쿼리들 String insertQ = \"insert into emp(job,deptno,empno,ename,hiredate,mgr,sal,comm) values (?,?,?,?,to_date(?,'YYYYMMDD'),?,?,?)\"; String updateQ = \"update emp set hiredate = to_date(?,'YYYYMMDD'),sal=?,comm=? where empno = ?\"; String deleteQ = \"delete from emp where empno = ?\"; //시트로부터 넘어온 내용들 String[] sStatus = request.getParameterValues(\"sStatus\"); String[] JOB = request.getParameterValues(\"JOB\"); String[] DEPTNO = request.getParameterValues(\"DEPTNO\"); String[] EMPNO = request.getParameterValues(\"EMPNO\"); String[] ENAME = request.getParameterValues(\"ENAME\"); String[] HIREDATE = request.getParameterValues(\"HIREDATE\"); String[] MGR = request.getParameterValues(\"MGR\"); String[] SAL = request.getParameterValues(\"SAL\"); String[] COMM = request.getParameterValues(\"COMM\"); try{ Class.forName(driver); conn = DriverManager.getConnection(url,id,pwd); conn.setAutoCommit(false); //상태 컬럼의 값은 \"I\" ,\"U\" ,\"D\" 로 넘어온다. for(int row=0;row<sStatus.length;row++){ if(\"I\".equals(sStatus[row])){ pstmt = conn.prepareStatement(insertQ); pstmt.setString(1, JOB[row]); pstmt.setString(2, DEPTNO[row]); pstmt.setString(3, EMPNO[row]); pstmt.setString(4, ENAME[row]); pstmt.setString(5, HIREDATE[row]); pstmt.setString(6, MGR[row]); pstmt.setString(7, SAL[row]); pstmt.setString(8, COMM[row]); }else if(\"U\".equals(sStatus[row])){ pstmt = conn.prepareStatement(updateQ); pstmt.setString(1, HIREDATE[row]); pstmt.setString(2, SAL[row]); pstmt.setString(3, COMM[row]); pstmt.setString(4, EMPNO[row]); }else{ pstmt = conn.prepareStatement(deleteQ); pstmt.setString(1, EMPNO[row]); } pstmt.executeUpdate(); pstmt.clearParameters(); } conn.commit(); %> { \"Result\" : {\"Code\":0, \"Message\":\"저장 되었습니다.\"} } <% }catch(Exception ex){ String msg = ex.getMessage(); %> { \"Result\" : {\"Code\":-1, \"Message\":\"오류가 발생하였습니다.\" } } <% }finally{ pstmt.close(); conn.close(); } %> ``` 데이터에 대해 저장 처리가 완료되면 다음과 같이 최종적으로 생성됩니다. ``` json // 저장 성공시 { \"Result\" : {\"Code\":0, \"Message\":\"저장 되었습니다.\"} } // 저장 오류시 { \"Result\" : {\"Code\":-1, \"Message\":\"오류가 발생하였습니다.\"} } ``` * 저장 완료 이벤트 처리하기 <span style=\"color:blue;\">(선택)</span> 저장 처리가 완료되면 [OnSaveEnd](/docs/event/OnSaveEnd) 이벤트가 발생합니다. 이 이벤트는 저장이 성공하든 실패하든 저장처리가 끝나면 발생하는 이벤트로 에러 메시지가 있는 경우 인자로 설정되어 이벤트가 발생합니다. ```javascript function mySheet_OnSaveEnd(code,msg) { if (code < 0) { alert(msg); } } ```"
        },
        "url": "docs/start/dev-example.html"
      },
      {
        "cid": 5,
        "sid": "sheetstructure",
        "name": "sheetstructure",
        "label": "시트의 구조",
        "data": {
          "body": "## 1. Client Running 구조 * Load 과정 ![시트의 구조](/assets/imgs/ibsheet7_sheetstructure.png) IBSheet7가 포함된 페이지를 PC에서 열 경우 별도의 프로그램 또는 컨테이너 없이 Sheet가 `동적 HTML`로 구성되어 Load 됩니다. ## 2. 데이터 조회 / 저장 과정 ① `Data Request` : IBSheet7의 조회/저장 함수를 이용하여 데이터를 요청합니다. ② `DB Data Request` : 요청을 받은 서버는 FrameWork를 통해 SQL QueryString을 구성하여 DBMS에 데이터를 요청합니다. ③ DBMS는 QueryString을 해석하여 DataSet객체를 FrameWork에 반환합니다. ④ FrameWork는 받은 DataSet을 정적인 Collection객체(List,Map등)로 변환하여 `XML` 또는 `JSON` 형태를 생성해주는 Page(혹은 servlet이나 dll)로 전달합니다. ⑤ XML 또는 JSON 형태로 데이터 생성이 완료되면 IBSheet7으로 반환합니다. ⑥ IBSheet7는 받은 XML 또는 JSON 데이터를 파싱하여 화면에 표시합니다."
        },
        "url": "docs/start/sheetstructure.html"
      }
    ]
  },
  {
    "gid": 3,
    "name": "props",
    "label": "Properties",
    "children": [
      {
        "cid": 6,
        "sid": "Config",
        "name": "Config",
        "label": "Config 속성이란",
        "data": {
          "body": "> 모든 IBSheet7에 공통으로 다양한 속성을 설정하고자 할 때 정의 합니다. > `ibsheet.cfg` 파일에서 xml 또는 json 형태로 설정 가능 합니다. > ```javascript // 엑셀 다운로드 URL 설정 예시 (ibsheet.cfg) // Json 형태의 포맷 { \"Cfg\": { \"Down2Excel_Url\" : \"../jsp/Down2Excel.jsp\" } } // Xml 형태의 포맷 <SHEET> <Cfg Down2Excel_Url=\"../jsp/Down2Excel.jsp\"/> </SHEET> ``` ### ReadMore * [기본 속성 설정하기](/docs/start/dev-example)"
        },
        "url": "docs/props/Config.html"
      },
      {
        "gid": 1,
        "name": "props-PropertyList",
        "label": "Cfg",
        "children": [
          {
            "cid": 7,
            "sid": "Alternate",
            "name": "Alternate",
            "label": "Alternate",
            "data": {
              "body": "> `DataAlternateBackColor(짝수번째 데이터 행의 기본 배경색)` 사용여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용안함| |1|사용함 (`Default`)| ### See also * [GetDataAlternateBackColor method](/docs/funcs/core/GetDataAlternateBackColor) * [SetDataAlternateBackColor method](/docs/funcs/core/SetDataAlternateBackColor) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/Alternate.html"
          },
          {
            "cid": 8,
            "sid": "AutoClearHeaderCheck",
            "name": "AutoClearHeaderCheck",
            "label": "AutoClearHeaderCheck",
            "data": {
              "body": "> `RemoveAll` 메소드 호출시 또는 조회시 전체체크를 자동 초기화 시킬지 여부를 설정하는 속성입니다. ### Type `boolean` ### Options |Value|Description| |-----|----| |0|사용안함 (`Default`)| |1|사용함| ### See also * [RemoveAll method](/docs/funcs/core/RemoveAll) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/AutoClearHeaderCheck.html"
          },
          {
            "cid": 9,
            "sid": "AutoCloseDialog",
            "name": "AutoCloseDialog",
            "label": "AutoCloseDialog",
            "data": {
              "body": "> 콤보목록, 달력팝업, 액션메뉴 팝업의 자동닫기 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/AutoCloseDialog.html"
          },
          {
            "cid": 10,
            "sid": "AutoCloseDialogTimeout",
            "name": "AutoCloseDialogTimeout",
            "label": "AutoCloseDialogTimeout",
            "data": {
              "body": "> 콤보목록, 달력팝업, 액션메뉴 팝업의 자동닫기 지연 시간을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|지연 시간`(ms)` (`Default:300`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/AutoCloseDialogTimeout.html"
          },
          {
            "cid": 11,
            "sid": "AutoFitColWidth",
            "name": "AutoFitColWidth",
            "label": "AutoFitColWidth",
            "data": {
              "body": "> 특정 시점에서 컬럼의 너비를 자동으로 조정하는 `FitColWidth()` 함수를 호출합니다. > 적용하고자 하는 시점을 구분자 `\"|\"` 로 연결하여 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |search|조회 및 로드 시점| |resize|시트 resize 되는 시점| |init|초기화 및 removeall 시점| |colhidden|컬럼 숨김/보임 시점| |rowtransaction|로우 추가/삭제/숨김/보임 이후 시점| |colresize|넓이가 변경된 컬럼을 제외한 나머지 컬럼의 FitColWidth| ### See also * [FitColWidth method](/docs/funcs/col/FitColWidth) ### Since |version|desc| |---|---| |7.0.8.0|AutoFitColWidth, MouseHoverMode 속성 추가|",
              "since": "|version|desc||---|---||7.0.8.0|AutoFitColWidth, MouseHoverMode 속성 추가|"
            },
            "url": "docs/props/PropertyList/AutoFitColWidth.html"
          },
          {
            "cid": 12,
            "sid": "AutoRowHeight",
            "name": "AutoRowHeight",
            "label": "AutoRowHeight",
            "data": {
              "body": "> 조회된 데이터에 따라 각 행의 높이를 자동으로 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용안함| |1|사용함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/AutoRowHeight.html"
          },
          {
            "cid": 13,
            "sid": "AutoSumCalcMode",
            "name": "AutoSumCalcMode",
            "label": "AutoSumCalcMode",
            "data": {
              "body": "> 병합된 셀에 대한 합계 계산 처리 방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|모든 셀에 대한 합계 계산(`Default`)| |1|병합된 셀의 부속셀은 제외하고 계산| ### See also ### Since |version|desc| |---|---| |7.0.13.22|AutoSumCalcMode 속성 추가|",
              "since": "|version|desc||---|---||7.0.13.22|AutoSumCalcMode 속성 추가|"
            },
            "url": "docs/props/PropertyList/AutoSumCalcMode.html"
          },
          {
            "cid": 14,
            "sid": "CachePageCount",
            "name": "CachePageCount",
            "label": "CachePageCount",
            "data": {
              "body": "> 페이지 캐싱 개수를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|페이지 캐싱 개수| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CachePageCount.html"
          },
          {
            "cid": 15,
            "sid": "CalButtonAlign",
            "name": "CalButtonAlign",
            "label": "CalButtonAlign",
            "data": {
              "body": "> 달력팝업에서 버튼을 사용하는 경우 정렬 방법을 설정합니다. > 이 설정은 시트내의 달력팝업에만 적용됩니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |Left|왼쪽정렬| |Center|가운데정렬 (`Default`)| |Right|오른쪽정렬| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CalButtonAlign.html"
          },
          {
            "cid": 16,
            "sid": "CalButtons",
            "name": "CalButtons",
            "label": "CalButtons",
            "data": {
              "body": "> 달력팝업의 사용할 버튼을 설정합니다. > 사용하고자 하는 버튼을 `\"|\"` 로 연결하여 설정합니다. > 이 속성은 시트내의 달력팝업에만 적용됩니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |Close|취소 버튼| |Today|오늘일자 입력 버튼| |Yesterday|어제일자 입력 버튼| |InputEmpty|빈값 입력 버튼| |Ok|선택 버튼| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CalButtons.html"
          },
          {
            "cid": 17,
            "sid": "CalWeekNumber",
            "name": "CalWeekNumber",
            "label": "CalWeekNumber",
            "data": {
              "body": "> 달력팝업에 주차(week) 표시 설정입니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|주차를 표시하지 않음| |1|연내 주차 표시 (`Default`)| |2|월내 주차 표시| ### See also ### Since |version|desc| |---|---| |7.0.4.6|CalWeekNumber 속성 추가|",
              "since": "|version|desc||---|---||7.0.4.6|CalWeekNumber 속성 추가|"
            },
            "url": "docs/props/PropertyList/CalWeekNumber.html"
          },
          {
            "cid": 18,
            "sid": "CellItemsKeyValueSeparator",
            "name": "CellItemsKeyValueSeparator",
            "label": "CellItemsKeyValueSeparator",
            "data": {
              "body": "> 멀티 아이템에 대한 Key-Value 간 구분자를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |separator|아이템간 구분자 (`Default:` `\"|\"`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CellItemsKeyValueSeparator.html"
          },
          {
            "cid": 19,
            "sid": "CellItemsSeparator",
            "name": "CellItemsSeparator",
            "label": "CellItemsSeparator",
            "data": {
              "body": "> 멀티 아이템에 대한 아이템간 구분자를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |separator|아이템간 구분자 (`Default:` `\"|\"`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CellItemsSeparator.html"
          },
          {
            "cid": 20,
            "sid": "CheckActionKey",
            "name": "CheckActionKey",
            "label": "CheckActionKey",
            "data": {
              "body": "> 체크박스, 라디오 타입 컬럼에서 Space 또는 Enter키를 이용하여 체크 동작을 하도록 설정하는 옵션입니다. > 사용자가 설정한 키 입력 시 선택/해제가 토글로 동작하게 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |\"\"|Space, Enter 동작 안함 (`Default`)| |Space|Space 키 사용| |Enter|Enter키 사용| |`Space|Enter`|Space, Enter 키 사용| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CheckActionKey.html"
          },
          {
            "cid": 21,
            "sid": "CheckActionMode",
            "name": "CheckActionMode",
            "label": "CheckActionMode",
            "data": {
              "body": "> 체크박스 타입 컬럼의 체크/언체크 동작 발생 시점을 설정하는 속성입니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|OnClick 이벤트 발생 이전에 동작 수행 (`Default`)| |1|OnClick 이벤트 발생 이후에 동작 수행| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CheckActionMode.html"
          },
          {
            "cid": 22,
            "sid": "ClipPasteMode",
            "name": "ClipPasteMode",
            "label": "ClipPasteMode",
            "data": {
              "body": "> 클립보드 붙여넣기 방법을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |-1|사용 안함| |0|선택 셀| |1|선택 셀 기준 구분자 처리| |2|선택 셀 기준 구분자 (부족한 경우 행추가)| |3|신규 행| |4|선택 영역의 크기와 무관| ### See also * [GetClipPasteMode method](/docs/funcs/core/GetClipPasteMode) * [SetClipPasteMode method](/docs/funcs/core/SetClipPasteMode) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ClipPasteMode.html"
          },
          {
            "cid": 23,
            "sid": "ComboEditIcon",
            "name": "ComboEditIcon",
            "label": "ComboEditIcon",
            "data": {
              "body": "> 컬럼 타입이 `ComboEdit` 인 경우 콤보 드롭다운 아이콘을 출력합니다. > `참고` ComboEditIcon:1 설정시 ComboFilter 속성은 0으로 처리됩니다. (콤보 드롭다운 리스트가 필터되지 않음) ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|콤보 드롭다운 아이콘 출력 안함 (`Default`)| |1|콤보 드롭다운 아이콘 출력| ### See also ### Since |version|desc| |---|---| |7.0.1.0|ComboEditIcon 속성 추가|",
              "since": "|version|desc||---|---||7.0.1.0|ComboEditIcon 속성 추가|"
            },
            "url": "docs/props/PropertyList/ComboEditIcon.html"
          },
          {
            "cid": 24,
            "sid": "ComboEditValidation",
            "name": "ComboEditValidation",
            "label": "ComboEditValidation",
            "data": {
              "body": "> 콤보에디트에서 직접 입력한 값에 대한 유효성 검사를 사용할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|유효성 검사 안함 (`Default`)| |1|유효성 검사 함| ### See also ### Since |version|desc| |---|---| |7.0.1.0|ComboEditValidation 속성 추가|",
              "since": "|version|desc||---|---||7.0.1.0|ComboEditValidation 속성 추가|"
            },
            "url": "docs/props/PropertyList/ComboEditValidation.html"
          },
          {
            "cid": 25,
            "sid": "ComboMaxHeight",
            "name": "ComboMaxHeight",
            "label": "ComboMaxHeight",
            "data": {
              "body": "> 콤보 리스트의 최대 높이를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|콤보 리스트 높이| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ComboMaxHeight.html"
          },
          {
            "cid": 26,
            "sid": "ComboOpenMode",
            "name": "ComboOpenMode",
            "label": "ComboOpenMode",
            "data": {
              "body": "> 포커스 이동 간에 콤보목록 열기 방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|콤보 리스트 목록을 표시하지 않음 (`Default`)| |1|포커스시 콤보 리스트 표시 처리| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ComboOpenMode.html"
          },
          {
            "cid": 27,
            "sid": "ComboSettingMode",
            "name": "ComboSettingMode",
            "label": "ComboSettingMode",
            "data": {
              "body": "> 콤보아이템을 Trim 할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|Trim 처리 안함 (`Default`)| |1|Trim 처리 함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ComboSettingMode.html"
          },
          {
            "cid": 28,
            "sid": "Convert2ByteChar",
            "name": "Convert2ByteChar",
            "label": "Convert2ByteChar",
            "data": {
              "body": "> 전각문자 입력시 반각으로 치환하는 기능을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|반각 치환 안함 (`Default`)| |1|반각 치환 함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/Convert2ByteChar.html"
          },
          {
            "cid": 29,
            "sid": "CopyEdit",
            "name": "CopyEdit",
            "label": "CopyEdit",
            "data": {
              "body": "> 포맷을 포함하여 복사할지 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|포맷|포함하여 복사| |1|포맷|미포함하여 복사 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.13.160|CopyEdit 속성 추가|",
              "since": "|version|desc||---|---||7.0.13.160|CopyEdit 속성 추가|"
            },
            "url": "docs/props/PropertyList/CopyEdit.html"
          },
          {
            "cid": 30,
            "sid": "CountFormat",
            "name": "CountFormat",
            "label": "CountFormat",
            "data": {
              "body": "> 보여지는 건수 정보의 포맷을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|건수 정보의 포맷| ### See also * [SetCountFormat method](/docs/funcs/core/SetCountFormat) * [GetCountFormat method](/docs/funcs/core/GetCountFormat) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CountFormat.html"
          },
          {
            "cid": 31,
            "sid": "CountPosition",
            "name": "CountPosition",
            "label": "CountPosition",
            "data": {
              "body": "> 건수정보 표시 여부 및 건수정보 위치를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|표시 하지 않음 (`Default`)| |1|좌측 상단| |2|우측 상단| |3|좌측 하단| |4|우측 하단| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CountPosition.html"
          },
          {
            "cid": 32,
            "sid": "CssImageUrl",
            "name": "CssImageUrl",
            "label": "CssImageUrl",
            "data": {
              "body": "> 이미지 파일에 대한 경로를 설정합니다. (테마명인 Main은 생략) ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|이미지 파일 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CssImageUrl.html"
          },
          {
            "cid": 33,
            "sid": "CssUrl",
            "name": "CssUrl",
            "label": "CssUrl",
            "data": {
              "body": "> css 파일에 대한 경로 설정합니다. (테마명인 Main은 생략) ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|css 파일 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CssUrl.html"
          },
          {
            "cid": 34,
            "sid": "CustomScroll",
            "name": "CustomScroll",
            "label": "CustomScroll",
            "data": {
              "body": "> 가로/세로 스크롤바에 대한 디자인을 설정합니다. > 스크롤바의 디자인 처리와 이미지 스크롤바 기능을 제공합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|18px 크기의 div 스크롤바 디자인 (`Default`)| |1|18px 크기의 이미지 스크롤바 디자인| |2|10px 크기의 이미지 스크롤바 디자인| |3|9px 크기의 이미지 스크롤바 디자인| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/CustomScroll.html"
          },
          {
            "cid": 35,
            "sid": "DataRowHeight",
            "name": "DataRowHeight",
            "label": "DataRowHeight",
            "data": {
              "body": "> 데이터 행의 기본 높이 값을 설정합니다. > `주의` 행의 높이는 css가 아닌 `DataRowHeight` 속성으로 처리해야 합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|데이터 행의 높이 값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DataRowHeight.html"
          },
          {
            "cid": 36,
            "sid": "DeferredHScroll",
            "name": "DeferredHScroll",
            "label": "DeferredHScroll",
            "data": {
              "body": "> 가로 스크롤에 대한 지연 처리 모드를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용 함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DeferredHScroll.html"
          },
          {
            "cid": 37,
            "sid": "DeferredScrollTime",
            "name": "DeferredScrollTime",
            "label": "DeferredScrollTime",
            "data": {
              "body": "> 스크롤 지연 모드 사용시 지연 처리 시간을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|지연 처리 시간`(ms)` (`Default: 200`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DeferredScrollTime.html"
          },
          {
            "cid": 38,
            "sid": "DeferredVScroll",
            "name": "DeferredVScroll",
            "label": "DeferredVScroll",
            "data": {
              "body": "> 세로 스크롤에 대한 지연 처리 모드를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용 함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DeferredVScroll.html"
          },
          {
            "cid": 39,
            "sid": "DirectDownMode",
            "name": "DirectDownMode",
            "label": "DirectDownMode",
            "data": {
              "body": "> `ExportMode 2 또는 3` 에서 DirectDown2Excel을 서버 모듈로 사용할 지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용 함| ### See also * [ExportMode Cfg](/docs/props/PropertyList/ExportMode) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DirectDownMode.html"
          },
          {
            "cid": 40,
            "sid": "DirectLoadExcel_Url",
            "name": "DirectLoadExcel_Url",
            "label": "DirectLoadExcel_Url",
            "data": {
              "body": "> (서버로 직접) 엑셀 업로드 처리를 담당하는 jsp 파일의 경로를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|jsp 파일 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DirectLoadExcel_Url.html"
          },
          {
            "cid": 41,
            "sid": "DocIODelimMode",
            "name": "DocIODelimMode",
            "label": "DocIODelimMode",
            "data": {
              "body": "> 문서 연동시 서버로 전달되는 전문의 구분자 방식을 설정합니다. > `※ 신규 방식 모드` 로 설정하는 경우 각 문서연동 처리를 하는 서버 파일에서도 동일한 값으로 설정 하여야 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|기존 방식 (`Default`)| |1|신규 방식| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DocIODelimMode.html"
          },
          {
            "cid": 42,
            "sid": "Down2Excel_Url",
            "name": "Down2Excel_Url",
            "label": "Down2Excel_Url",
            "data": {
              "body": "> 엑셀 다운로드 처리를 담당하는 jsp 파일의 경로를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|jsp 파일 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/Down2Excel_Url.html"
          },
          {
            "cid": 43,
            "sid": "Down2Pdf_Url",
            "name": "Down2Pdf_Url",
            "label": "Down2Pdf_Url",
            "data": {
              "body": "> PDF 다운로드 처리를 담당하는 jsp 파일의 경로를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|jsp 파일 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/Down2Pdf_Url.html"
          },
          {
            "cid": 44,
            "sid": "DownWaitImageVisible",
            "name": "DownWaitImageVisible",
            "label": "DownWaitImageVisible",
            "data": {
              "body": "> 파일 다운 중 대기 이미지 출력여부를 설정합니다. > 출력 안함으로 설정 시 OnDownFinish 이벤트도 발생하지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|대기이미지, 이벤트 출력 안함| |1|대기이미지, 이벤트 출력 함 (`Default`)| ### See also * [onDownFinish Event](/docs/event/onDownFinish) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DownWaitImageVisible.html"
          },
          {
            "cid": 45,
            "sid": "DownloadImage",
            "name": "DownloadImage",
            "label": "DownloadImage",
            "data": {
              "body": "> 파일 다운로드 중 이미지 경로를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|이미지 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DownloadImage.html"
          },
          {
            "cid": 46,
            "sid": "DragCell",
            "name": "DragCell",
            "label": "DragCell",
            "data": {
              "body": "> 드래그시 셀 단위 드래그 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|행 단위 드래깅 (`Default`)| |1|셀 단위 드래깅| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DragCell.html"
          },
          {
            "cid": 47,
            "sid": "DragMode",
            "name": "DragMode",
            "label": "DragMode",
            "data": {
              "body": "> 드래그 처리 방법을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |-1|드래그 사용 안함| |0|일반 : 셀 또는 행 범위 셀렉션<span style=\"color:blue;\"> Ctrl 키 이용 : 행 드래깅 (`Default`)</span>| |1|일반 : 행 드래깅<span style=\"color:blue;\"> Ctrl 키 이용 : 셀 또는 행 범위 셀렉션</span>| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DragMode.html"
          },
          {
            "cid": 48,
            "sid": "DragRowSelection",
            "name": "DragRowSelection",
            "label": "DragRowSelection",
            "data": {
              "body": "> 드래그 대상 단위를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|셀 단위 (`Default`)| |1|행 단위| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/DragRowSelection.html"
          },
          {
            "cid": 49,
            "sid": "EditArrowBehavior",
            "name": "EditArrowBehavior",
            "label": "EditArrowBehavior",
            "data": {
              "body": "> 편집중 방향키 입력에 대한 동작을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|좌,우,상,하 모두 셀 이동 하지 않음| |1|상,하만 셀 이동 처리(`Default`)| |2|좌,우만 셀 이동 처리| |3|좌,우,상,하 모두 셀 이동 처리| |4|커서가 데이터의 좌우측 끝에 위치할때 편집 가능한 셀로 편집을 유지하면서 이동 상,하 이동 처리| |5|커서가 데이터의 좌우측 끝에 위치할때 편집 가능한 셀로 편집을 유지하면서 이동 상,하 이동 처리 없음| |6|커서가 데이터의 좌우측 끝에 위치할때 편집유무와 관계없이 편집을 종료하면서 이동 상,하 이동 처리| |7|커서가 데이터의 좌우측 끝에 위치할때 편집유무와 관계없이 편집을 종료하면서 이동 상,하 이동 없음| ### See also ### Since |version|desc| |---|---| |7.0.13.76|EditArrowBehavior 속성 추가| |7.0.13.229|EditArrowBehavior 4,5속성 추가| |7.0.13.233|EditArrowBehavior 6,7속성 추가|",
              "since": "|version|desc||---|---||7.0.13.76|EditArrowBehavior 속성 추가||7.0.13.229|EditArrowBehavior 4,5속성 추가||7.0.13.233|EditArrowBehavior 6,7속성 추가|"
            },
            "url": "docs/props/PropertyList/EditArrowBehavior.html"
          },
          {
            "cid": 50,
            "sid": "EditEnterBehavior",
            "name": "EditEnterBehavior",
            "label": "EditEnterBehavior",
            "data": {
              "body": "> 편집중 엔터키 입력에 대한 동작을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |tab|편집 완료 후 오른쪽 셀로 포커스 이동 (`Default`)| |down|편집 완료 후 아래 셀로 포커스 이동| |newline|줄바꿈되어 개행 처리 됨| |none|편집 완료 후 포커스 유지| |editTab|편집 완료 후 다음 편집 가능한 셀로 이동| ### See also ### Since |version|desc| |---|---| |7.0.13.16|EditEnterBehavior 속성의 \"editTab\" 모드 추가|",
              "since": "|version|desc||---|---||7.0.13.16|EditEnterBehavior 속성의 \"editTab\" 모드 추가|"
            },
            "url": "docs/props/PropertyList/EditEnterBehavior.html"
          },
          {
            "cid": 51,
            "sid": "EditLenMode",
            "name": "EditLenMode",
            "label": "EditLenMode",
            "data": {
              "body": "> 입력문자열 길이 체크 방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|편집모드, 메소드에서 체크함 (`Default`)| |1|편집모드에서 직접 입력시에만 체크| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/EditLenMode.html"
          },
          {
            "cid": 52,
            "sid": "EditTabBehavior",
            "name": "EditTabBehavior",
            "label": "EditTabBehavior",
            "data": {
              "body": "> 편집중 탭키 입력에 대한 동작을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|편집 가능한 다음 셀로 이동 (`Default`)| |1|편집여부와 상관없이 다음 셀로 이동 (다음셀이 편집 가능한 경우면 편집상태 유지)| |2|편집여부와 상관없이 다음 셀로 이동 (다음셀의 편집 가능여부와 무관하게 편집상태 종료)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/EditTabBehavior.html"
          },
          {
            "cid": 53,
            "sid": "EditTabInsert",
            "name": "EditTabInsert",
            "label": "EditTabInsert",
            "data": {
              "body": "> `MultiLineText` 셀에 Tab키 입력 활성화 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/EditTabInsert.html"
          },
          {
            "cid": 54,
            "sid": "EditableColorDiff",
            "name": "EditableColorDiff",
            "label": "EditableColorDiff",
            "data": {
              "body": "> 편집이 불가능한 셀을 색상으로 구분하여 표시할지 여부를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|편집불가능한 셀을 구분없이 표시합니다.| |1|편집불가능한 셀을 css에서 설정한 색상으로 표시합니다.| |2|편집불가능한 셀을 css의 설정값과 기본배경색의 조합으로 표시합니다.| ### See also ### Since |version|desc| |---|---| |7.0.0.0|EditColorDiff 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|EditColorDiff 속성 추가|"
            },
            "url": "docs/props/PropertyList/EditableColorDiff.html"
          },
          {
            "cid": 55,
            "sid": "EnhancedFloatSum",
            "name": "EnhancedFloatSum",
            "label": "EnhancedFloatSum",
            "data": {
              "body": "> `AutoSum` 타입에서의 부동 소수점 보정 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.13.109|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.109|속성 추가|"
            },
            "url": "docs/props/PropertyList/EnhancedFloatSum.html"
          },
          {
            "cid": 56,
            "sid": "ExcelTreeMode",
            "name": "ExcelTreeMode",
            "label": "ExcelTreeMode",
            "data": {
              "body": "> 엑셀 다운로드시 트리의 접혀진 행을 다운 받을지 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|트리의 접혀진 행을 다운 안함 (`Default`)| |1|트리의 접혀진 행도 모두 다운 `(SetRowHidden 으로 숨긴 로우도 모두 다운)`| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ExcelTreeMode.html"
          },
          {
            "cid": 57,
            "sid": "ExportMode",
            "name": "ExportMode",
            "label": "ExportMode",
            "data": {
              "body": "> 엑셀 Import/Export에 사용할 모듈을 설정합니다. > 클라이언트 모듈의 경우 `ibexcel.js` 가 include 되어야 합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |1|서버모듈 (`Default`)| |2|클라이언트 `IE10 이상 지원`| |3|서버모듈,클라이언트모듈 (ibexcel.js가 없으면 서버모듈로 동작)| ### See also * [Down2Excel method](/docs/funcs/export/Down2Excel) ### Since |version|desc| |---|---| |7.0.13.63|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.63|속성 추가|"
            },
            "url": "docs/props/PropertyList/ExportMode.html"
          },
          {
            "cid": 58,
            "sid": "ExtendLastCol",
            "name": "ExtendLastCol",
            "label": "ExtendLastCol",
            "data": {
              "body": "> 마지막 컬럼을 확장할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ExtendLastCol.html"
          },
          {
            "cid": 59,
            "sid": "FalseValue",
            "name": "FalseValue",
            "label": "FalseValue",
            "data": {
              "body": "> CheckBox 형태 컬럼타입에 0을 대체할 False 값을 설정합니다. > Ex) \"F\" 으로 지정한 경우 0 대신 \"F\"을 False 값으로 사용 ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|대체할 false 값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FalseValue.html"
          },
          {
            "cid": 60,
            "sid": "FilterCaseSensitive",
            "name": "FilterCaseSensitive",
            "label": "FilterCaseSensitive",
            "data": {
              "body": "> 필터 사용시 영문 대소문자 구분 사용여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함| |1|사용함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FilterCaseSensitive.html"
          },
          {
            "cid": 61,
            "sid": "FilterComboSort",
            "name": "FilterComboSort",
            "label": "FilterComboSort",
            "data": {
              "body": "> 필터 사용시 콤보 타입의 목록 정렬 방식을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |\"\" |사용 안함 (`Default`)| |ASC|오름차순 정렬| |DESC|내림차순 정렬| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FilterComboSort.html"
          },
          {
            "cid": 62,
            "sid": "FilterDateType",
            "name": "FilterDateType",
            "label": "FilterDateType",
            "data": {
              "body": "> 날짜 형식 필터에 달력팝업 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|달력팝업 사용안함 (`Default`)| |1|달력팝업 사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FilterDateType.html"
          },
          {
            "cid": 63,
            "sid": "FilteredCountFormat",
            "name": "FilteredCountFormat",
            "label": "FilteredCountFormat",
            "data": {
              "body": "> 필터링 상태에서 보여지는 건수 정보의 포맷을 설정합니다. (설정방법은 `CountFormat` 과 동일합니다.) ### Type `boolean` ### Options [CountFormat Cfg](/docs/props/PropertyList/CountFormat) 과 동일 ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FilteredCountFormat.html"
          },
          {
            "cid": 64,
            "sid": "FitSizeColMode",
            "name": "FitSizeColMode",
            "label": "FitSizeColMode",
            "data": {
              "body": "> 헤더의 컬럼 사이를 더블클릭시 처리되는 FitSize 처리 모드를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|화면에 보여지는 행 범위 내에서 처리 (`Default`)| |1|전체 행 범위에서 처리| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FitSizeColMode.html"
          },
          {
            "cid": 65,
            "sid": "FocusAfterProcess",
            "name": "FocusAfterProcess",
            "label": "FocusAfterProcess",
            "data": {
              "body": "> 조회 후 포커스 처리방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|포커스 처리 안함| |1|포커스 처리함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FocusAfterProcess.html"
          },
          {
            "cid": 66,
            "sid": "FocusAfterRowTransaction",
            "name": "FocusAfterRowTransaction",
            "label": "FocusAfterRowTransaction",
            "data": {
              "body": "> 행 추가/삭제/이동/복사 후 포커스 처리방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|포커스 이동 안함| |1|포커스 이동함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FocusAfterRowTransaction.html"
          },
          {
            "cid": 67,
            "sid": "FocusEditMode",
            "name": "FocusEditMode",
            "label": "FocusEditMode",
            "data": {
              "body": "> 포커스시 편집 여부를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|(`Default`)| |1|포커스시 편집 모드| |2|포커스시 편집 모드 (Combo, ComboEdit 타입 제외)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/FocusEditMode.html"
          },
          {
            "cid": 68,
            "sid": "FocusSumRow",
            "name": "FocusSumRow",
            "label": "FocusSumRow",
            "data": {
              "body": "> 합계행의 셀에 대한 Focus 허용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|포커스 허용 안함 (`Default)| |1|포커스 허용| ### See also ### Since |version|desc| |---|---| |7.0.13.51|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.51|속성 추가|"
            },
            "url": "docs/props/PropertyList/FocusSumRow.html"
          },
          {
            "cid": 69,
            "sid": "GroupSort",
            "name": "GroupSort",
            "label": "GroupSort",
            "data": {
              "body": "> 그룹핑시 기준컬럼에 대한 Sort 처리여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|Sort 처리 없이 현재 상태로 그룹핑| |1|Sort 처리 후 그룹핑 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.13.26|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.26|속성 추가|"
            },
            "url": "docs/props/PropertyList/GroupSort.html"
          },
          {
            "cid": 70,
            "sid": "HeaderCheckMode",
            "name": "HeaderCheckMode",
            "label": "HeaderCheckMode",
            "data": {
              "body": "> 전체체크 선택시 필터링된 행만 체크하도록 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|모든행에 대한 처리 (`Default`)| |1|필터링된 행에 대한 처리| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/HeaderCheckMode.html"
          },
          {
            "cid": 71,
            "sid": "HeaderCheckSync",
            "name": "HeaderCheckSync",
            "label": "HeaderCheckSync",
            "data": {
              "body": "> 헤더의 전체체크박스에 대해 자동 설정/해제 기능을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.13.111|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.111|속성 추가|"
            },
            "url": "docs/props/PropertyList/HeaderCheckSync.html"
          },
          {
            "cid": 72,
            "sid": "HeaderEventMode",
            "name": "HeaderEventMode",
            "label": "HeaderEventMode",
            "data": {
              "body": "> 헤더의 이벤트 발생종류를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|모든 마우스 이벤트 발생 안함| |1|모든 마우스 이벤트 발생함 (`Default`)| |2|MouseDown, MouseMove 이벤트만 발생 함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/HeaderEventMode.html"
          },
          {
            "cid": 73,
            "sid": "HeaderMergeMode",
            "name": "HeaderMergeMode",
            "label": "HeaderMergeMode",
            "data": {
              "body": "> 헤더의 머지 방식을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|ColMerge 속성 설정값에 상관없이 머지 처리 (`Default`)| |1|ColMerge 속성에 따라 머지 처리| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/HeaderMergeMode.html"
          },
          {
            "cid": 74,
            "sid": "HeaderRowHeight",
            "name": "HeaderRowHeight",
            "label": "HeaderRowHeight",
            "data": {
              "body": "> 헤더행의 높이를 설정합니다. > `주의` 헤더 행의 높이는 css 가 아닌 이 속성을 통해 설정해야 합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|헤더행의 높이| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/HeaderRowHeight.html"
          },
          {
            "cid": 75,
            "sid": "HeaderSort",
            "name": "HeaderSort",
            "label": "HeaderSort",
            "data": {
              "body": "> 헤더 클릭을 통한 컬럼 Sort 처리 방법을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|사용 안함| |1|Sort 기능 사용(`Default`)| |2|Sort 아이콘만 표시| |3|colSpan 아닌 헤더 셀만 Sort 기능 사용| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/HeaderSort.html"
          },
          {
            "cid": 76,
            "sid": "HeaderSortActionMode",
            "name": "HeaderSortActionMode",
            "label": "HeaderSortActionMode",
            "data": {
              "body": "> 단일 컬럼 정렬, 다중 컬럼 정렬을 위한 헤더의 사용자 입력 방식 모드를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|입력방식 : Click, 다중 컬럼 정렬 (`Default`)| |0|입력방식 : Ctrl + Click, 단일 컬럼 정렬| |1|입력방식 : Click, 단일 컬럼 정렬| |1|입력방식 : Ctrl + Click, 다중 컬럼 정렬| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/HeaderSortActionMode.html"
          },
          {
            "cid": 77,
            "sid": "Holiday",
            "name": "Holiday",
            "label": "Holiday",
            "data": {
              "body": "> 달력에 표시할 사용자 정의 휴일을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|사용자가 정의할 휴일 문자열| ### Example ```html 대상 일자를 구분자 '|'로 연결한 문자열로 설정 하며 설정 값의 포맷은 'yyyyMMdd' 를 사용합니다. 매년, 매월에 대한 와일드카드로 * 을 사용합니다. (예시) \"Holiday\": \"20120725|*0703|2012*27|**17\" - *0703 : 매년 7월 3일 - 2012*27 : 2012년 매월 27일 - **17 : 매년, 매월 17일 ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/Holiday.html"
          },
          {
            "cid": 78,
            "sid": "ImageStatus",
            "name": "ImageStatus",
            "label": "ImageStatus",
            "data": {
              "body": "> 상태값 표현을 이미지로 할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|입력, 수정, 삭제 Text로 표시 (`Default`)| |1|입력, 수정, 삭제 이미지로 표시| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ImageStatus.html"
          },
          {
            "cid": 79,
            "sid": "InitRender",
            "name": "InitRender",
            "label": "InitRender",
            "data": {
              "body": "> 시트 초기화 시 랜더링 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|초기화 시 랜더링 안함 (`Default`)| |1|초기화 시 랜더링 함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/InitRender.html"
          },
          {
            "cid": 80,
            "sid": "InvalidArgsReturnValue",
            "name": "InvalidArgsReturnValue",
            "label": "InvalidArgsReturnValue",
            "data": {
              "body": "> 메소드 인자가 잘못 설정된 경우 반환값을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|메소드 인자가 잘못 설정되었을 때 반환값 (`Default : \"-1\"`)| ### See also ### Since |version|desc| |---|---| |7.0.4.4|속성 추가|",
              "since": "|version|desc||---|---||7.0.4.4|속성 추가|"
            },
            "url": "docs/props/PropertyList/InvalidArgsReturnValue.html"
          },
          {
            "cid": 81,
            "sid": "InvalidInputBehavior",
            "name": "InvalidInputBehavior",
            "label": "InvalidInputBehavior",
            "data": {
              "body": "> 편집 완료시점에 입력값이 invalid 인 경우에 대한 처리 방법을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|alert 메시지 후 해당 셀 편집상태 유지 (`Default`)| |1|alert 메시지 후 해당 셀 편집종료 (입력값 취소 처리)| |2|alert 메시지 후 해당 셀 편집상태 유지 (입력값 취소 처리)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/InvalidInputBehavior.html"
          },
          {
            "cid": 82,
            "sid": "InvalidPasteMsgMode",
            "name": "InvalidPasteMsgMode",
            "label": "InvalidPasteMsgMode",
            "data": {
              "body": "> 클립 보드 붙여넣기시 Invalid 메시지 출력 모드를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |1|메시지 출력 함 (`Default`)| |2|메시지 출력 안함| ### See also ### Since |version|desc| |---|---| |7.0.13.60|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.60|속성 추가|"
            },
            "url": "docs/props/PropertyList/InvalidPasteMsgMode.html"
          },
          {
            "cid": 83,
            "sid": "JsonAttributeDelimiter",
            "name": "JsonAttributeDelimiter",
            "label": "JsonAttributeDelimiter",
            "data": {
              "body": "> Json 조회시 속성 구분자 변경을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|Json 조회시 속성 구분자 (`Default : \"#\"`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/JsonAttributeDelimiter.html"
          },
          {
            "cid": 84,
            "sid": "JustCheck",
            "name": "JustCheck",
            "label": "JustCheck",
            "data": {
              "body": "> 체크박스 타입에서 셀 클릭이 아닌 체크박스 클릭에 대해서만 선택/취소가 가능하도록 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|셀 클릭시 체크 (`Default`)| |1|체크박스 클릭시 체크| ### See also ### Since |version|desc| |---|---| |7.0.13.112|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.112|속성 추가|"
            },
            "url": "docs/props/PropertyList/JustCheck.html"
          },
          {
            "cid": 85,
            "sid": "JustCheckSize",
            "name": "JustCheckSize",
            "label": "JustCheckSize",
            "data": {
              "body": "> JustCheck가 `true`인 경우 셀 내에서 체크박스로 간주될 크기를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|크기값 (`Default : 20`)| ### See also * [JustCheck Cfg](/docs/props/PropertyList/JustCheck) ### Since |version|desc| |---|---| |7.0.13.112|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.112|속성 추가|"
            },
            "url": "docs/props/PropertyList/JustCheckSize.html"
          },
          {
            "cid": 86,
            "sid": "KeyFieldPosition",
            "name": "KeyFieldPosition",
            "label": "KeyFieldPosition",
            "data": {
              "body": "> 필수 표시가 입력되는 위치를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |Left|왼쪽에 표기 (`Default`)| |Right|오른쪽에 표기| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/KeyFieldPosition.html"
          },
          {
            "cid": 87,
            "sid": "LoadExcel_Url",
            "name": "LoadExcel_Url",
            "label": "LoadExcel_Url",
            "data": {
              "body": "> 엑셀 업로드 처리를 담당하는 jsp 파일의 경로를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|업로드 처리를 담당하는 jsp 파일의 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/LoadExcel_Url.html"
          },
          {
            "cid": 88,
            "sid": "MarkupTagDelimiter",
            "name": "MarkupTagDelimiter",
            "label": "MarkupTagDelimiter",
            "data": {
              "body": "> 서버모듈 연동시 전송되는 전문의 마크업 태그의 구분문자를 설정합니다. > 설정값은 해당 구분문자를 구분자 \",\"로 연결한 4개의 문자(또는 문자열)로 설정합니다. > 기본값과 다르게 설정한 경우 서버단 수행로직에서도 동일한 값 으로 각각 설정해 주어야 합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|마크업 태그의 구분문자 (`Default : <,>,</,>`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/MarkupTagDelimiter.html"
          },
          {
            "cid": 89,
            "sid": "MaxSort",
            "name": "MaxSort",
            "label": "MaxSort",
            "data": {
              "body": "> 헤더클릭을 이용한 연계 소팅 최대 개수를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|연계 소팅 최대 개수 (`Default : 3`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/MaxSort.html"
          },
          {
            "cid": 90,
            "sid": "MessageShowLevel",
            "name": "MessageShowLevel",
            "label": "MessageShowLevel",
            "data": {
              "body": "> Alert 또는 Confirm 메시지의 출력 레벨을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |U|사용자 노출용 메시지만 출력 (`Default`)| |D|사용자용 메시지와 개발자용 메시지를 모두 출력| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/MessageShowLevel.html"
          },
          {
            "cid": 91,
            "sid": "MouseHoverMode",
            "name": "MouseHoverMode",
            "label": "MouseHoverMode",
            "data": {
              "body": "> 시트 내의 행 또는 셀의 MouseOver에 대한 Hover 방식을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|셀단위 Hover| |2|행단위 Hover| ### See also ### Since |version|desc| |---|---| |7.0.8.0|속성 추가|",
              "since": "|version|desc||---|---||7.0.8.0|속성 추가|"
            },
            "url": "docs/props/PropertyList/MouseHoverMode.html"
          },
          {
            "cid": 92,
            "sid": "MultiCheckValue",
            "name": "MultiCheckValue",
            "label": "MultiCheckValue",
            "data": {
              "body": "> MultiCheck의 셀 값 처리 방식을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|기존 동일 (`Default`)| |1|선택된 값만 가져오는 방식| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/MultiCheckValue.html"
          },
          {
            "cid": 93,
            "sid": "NewRowDeleteMode",
            "name": "NewRowDeleteMode",
            "label": "NewRowDeleteMode",
            "data": {
              "body": "> `입력` 상태인 행의 삭제 컬럼 체크시 confirm 메시지 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/NewRowDeleteMode.html"
          },
          {
            "cid": 94,
            "sid": "NextPageCall",
            "name": "NextPageCall",
            "label": "NextPageCall",
            "data": {
              "body": "> 조회 모드가 `서버페이징`, `LazyLoad` 방식인 경우 다음 페이지를 호출하는 시점을 설정합니다. > %에 해당하는 숫자값으로 `60 ~ 90` 의 값만 설정이 가능합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|다음 페이지 호출하는 시점 (`60 ~ 90`)| ### See also * [SearchMode Cfg](/docs/props/PropertyList/SearchMode) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/NextPageCall.html"
          },
          {
            "cid": 95,
            "sid": "NoImageUrl",
            "name": "NoImageUrl",
            "label": "NoImageUrl",
            "data": {
              "body": "> 이미지 경로가 잘못된 경우 대체할 이미지의 경로를 설정합니다. > 설정시 기본경로는 `ibsheet.js` 파일위치를 기준으로 합니다. > `주의` 해당 속성의 이미지 경로가 잘못된 경우, 성능 문제가 발생할 수 있기 때문에 정확하게 설정해 주어야 합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|대체할 이미지 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/NoImageUrl.html"
          },
          {
            "cid": 96,
            "sid": "NullLastOnAscOrder",
            "name": "NullLastOnAscOrder",
            "label": "NullLastOnAscOrder",
            "data": {
              "body": "> 오름차순 기준으로 소트시 공백 문자의 위치 설정입니다. (내림차순의 경우 반대로 정렬) ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|맨 앞에 정렬 (`Default`)| |1|맨 뒤에 정렬| ### See also ### Since |version|desc| |---|---| |7.0.13.107|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.107|속성 추가|"
            },
            "url": "docs/props/PropertyList/NullLastOnAscOrder.html"
          },
          {
            "cid": 97,
            "sid": "PagingPosition",
            "name": "PagingPosition",
            "label": "PagingPosition",
            "data": {
              "body": "> 페이지 네비게이션 표시 여부 및 위치를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|표시 하지 않음 (`Default`)| |1|좌측| |2|우측| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/PagingPosition.html"
          },
          {
            "cid": 98,
            "sid": "PasteToNumberFormat",
            "name": "PasteToNumberFormat",
            "label": "PasteToNumberFormat",
            "data": {
              "body": "> 숫자 형태 데이터 타입의 셀 범위 선택 영역에 붙여넣기시 Format에 맞게 데이터 가공 처리 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|입력값 그대로 사용 (`Default`)| |1|Format, PointCount 기준 절삭 처리| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/PasteToNumberFormat.html"
          },
          {
            "cid": 99,
            "sid": "PopupCheckEditMode",
            "name": "PopupCheckEditMode",
            "label": "PopupCheckEditMode",
            "data": {
              "body": "> 컬럼 팝업메뉴를 통한 값 설정시 편집 가능여부에 따른 처리 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|편집가능여부와 무관하게 처리| |1|편집가능한 경우에만 처리 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.11.0|PopupCheckEditMode, EventCacheMode, SparklineColor, SparklineNegativeColor 속성 추가 CalButtons 속성의 “InputEmpty” 값 추가|",
              "since": "|version|desc||---|---||7.0.11.0|PopupCheckEditMode, EventCacheMode, SparklineColor, SparklineNegativeColor 속성 추가 <br> CalButtons 속성의 “InputEmpty” 값 추가|"
            },
            "url": "docs/props/PropertyList/PopupCheckEditMode.html"
          },
          {
            "cid": 100,
            "sid": "RefreshHeaderMode",
            "name": "RefreshHeaderMode",
            "label": "RefreshHeaderMode",
            "data": {
              "body": "> 헤더 갱신모드를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|헤더 리프래쉬 안함| |1|컬럼이동시 헤더 리프래쉬함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/RefreshHeaderMode.html"
          },
          {
            "cid": 101,
            "sid": "ReverseSortOrder",
            "name": "ReverseSortOrder",
            "label": "ReverseSortOrder",
            "data": {
              "body": "> 헤더 클릭시 소트 처리 방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|마지막 선택 컬럼 우선 정렬 (`Default`)| |1|이전 선택 컬럼 우선 정렬| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ReverseSortOrder.html"
          },
          {
            "cid": 102,
            "sid": "RowHeightMax",
            "name": "RowHeightMax",
            "label": "RowHeightMax",
            "data": {
              "body": "> 행의 최대 높이를 설정합니다. > 데이터에 줄넘김 글자가 많아 여기서 설정한 높이 보다 커지는 경우 편집시 스크롤 바가 생기게 됩니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|행의 최대 높이 (`Default : 1`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/RowHeightMax.html"
          },
          {
            "cid": 103,
            "sid": "SaveImage",
            "name": "SaveImage",
            "label": "SaveImage",
            "data": {
              "body": "> 저장시 나타나는 대기 이미지를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|저장시 나타나는 대기 이미지의 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SaveImage.html"
          },
          {
            "cid": 104,
            "sid": "SaveValidationMode",
            "name": "SaveValidationMode",
            "label": "SaveValidationMode",
            "data": {
              "body": "> 저장시 숨김 컬럼에 대한 필수입력, 전체입력에 대한 체크 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|모든 컬럼에 대한 체크 (`Default`)| |1|Visible 컬럼에 대한 체크| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SaveValidationMode.html"
          },
          {
            "cid": 105,
            "sid": "ScrollOverSheet",
            "name": "ScrollOverSheet",
            "label": "ScrollOverSheet",
            "data": {
              "body": "> 시트 내의 마우스 휠을 이용한 스크롤 이벤트를 부모 element로 전달할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|시트에서만 스크롤 이동 (`Default`)| |1|시트 내에서 마우스 휠로 스크롤 이벤트가 발생할 때 양 끝에서 부모 element로 스크롤 이벤트 전달| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ScrollOverSheet.html"
          },
          {
            "cid": 106,
            "sid": "SearchImage",
            "name": "SearchImage",
            "label": "SearchImage",
            "data": {
              "body": "> 조회시 나타나는 대기 이미지를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|조회시 나타나는 대기 이미지의 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SearchImage.html"
          },
          {
            "cid": 107,
            "sid": "SearchMode",
            "name": "SearchMode",
            "label": "SearchMode",
            "data": {
              "body": "> 조회 모드(방식)를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|smGeneral – 일반 조회 모드| |1|smClientPaging – 페이징 모드| |2|smLazyLoad – Lazy Load 모드 (`Default`)| |3|smServerPaging – 실시간 서버 처리 모드 (스크롤링 방식)| |4|smServerPaging2 – 실시간 서버 처리 모드 (페이지 인덱스 방식)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SearchMode.html"
          },
          {
            "cid": 108,
            "sid": "SearchSync",
            "name": "SearchSync",
            "label": "SearchSync",
            "data": {
              "body": "> 조회 메소드 전체의 동기조회 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|동기조회 사용 안함 (`Default`)| |1|동기조회 사용| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SearchSync.html"
          },
          {
            "cid": 109,
            "sid": "SearchXMLbyColOrder",
            "name": "SearchXMLbyColOrder",
            "label": "SearchXMLbyColOrder",
            "data": {
              "body": "> XML 로딩시 데이터 로드하는 순서를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|컬럼 생성시의 순서대로 로드 (`Default`)| |1|현재 보이는 컬럼의 위치를 기준으로 로드| ### See also ### Since |version|desc| |---|---| |7.0.13.114|SearchXMLbyColOrder 속성 추가|",
              "since": "|version|desc||---|---||7.0.13.114|SearchXMLbyColOrder 속성 추가|"
            },
            "url": "docs/props/PropertyList/SearchXMLbyColOrder.html"
          },
          {
            "cid": 110,
            "sid": "SelectCellEventMode",
            "name": "SelectCellEventMode",
            "label": "SelectCellEventMode",
            "data": {
              "body": "> 조회된 데이터가 없는 경우에도 `OnSelectCell` 이벤트를 발생시킬지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|OnSelectCell 이벤트 발생 안함 (`Default`)| |1|OnSelectCell 이벤트 발생| ### See also * [OnSelectCell Event](/docs/event/OnSelectCell) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SelectCellEventMode.html"
          },
          {
            "cid": 111,
            "sid": "SelectionRowsMode",
            "name": "SelectionRowsMode",
            "label": "SelectionRowsMode",
            "data": {
              "body": "> `GetSelectionRows` 시 포커스행 포함 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|포커스행 포함함 (`Default`)| |1|포커스행 포함하지 않음| ### See also * [GetSelectionRows method](/docs/funcs/core/GetSelectionRows) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SelectionRowsMode.html"
          },
          {
            "cid": 112,
            "sid": "SelectionSummary",
            "name": "SelectionSummary",
            "label": "SelectionSummary",
            "data": {
              "body": "> 선택영역의 요약 정보 표시를 설정합니다. (`Default : \"\"`) > 아래의 옵션을 `\"|\"` 로 연결하여 설정합니다. > `CountPosition` 속성이 설정된 경우 사용됩니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |EmptyCell|빈값의 셀을 포함| |NotEmptyCell|빈값의 셀을 포함하지 않음| |DelRow|삭제상태의 행을 포함| |NotDelRow|삭제상태의 행을 포함하지 않음| ### See also * [CountPosition cfg](/docs/props/PropertyList/CountPosition) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SelectionSummary.html"
          },
          {
            "cid": 113,
            "sid": "SkipDefaultTheme",
            "name": "SkipDefaultTheme",
            "label": "SkipDefaultTheme",
            "data": {
              "body": "> 시트 생성시 기본테마 적용 생략 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|기본테마 적용함 (`Default`)| |1|기본테마 적용 생략 함 `주의` 시트 초기화 시점에 반드시 `SetTheme()`을 호출해야 합니다.| ### See also * [SetTheme method](/docs/funcs/SetTheme) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SkipDefaultTheme.html"
          },
          {
            "cid": 114,
            "sid": "SmartResize",
            "name": "SmartResize",
            "label": "SmartResize",
            "data": {
              "body": "> `OnResize` 이벤트를 `OnSmartResize` 이벤트 동작처럼 변환시키는 설정입니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함 (이 값 설정시 OnSmartResize이벤트는 발생하지 않고 `OnResize이벤트가 OnSmartResize이벤트처럼` 0.3초단위로 동작합니다.)| ### See also * [OnResize Event](/docs/event/OnResize) * [OnSmartResize Event](/docs/event/OnSmartResize) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SmartResize.html"
          },
          {
            "cid": 115,
            "sid": "SortCaseSensitive",
            "name": "SortCaseSensitive",
            "label": "SortCaseSensitive",
            "data": {
              "body": "> 컬럼 Sort 처리시 문자열에 대한 대소구분 처리 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함| |1|사용함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SortCaseSensitive.html"
          },
          {
            "cid": 116,
            "sid": "SortEventMode",
            "name": "SortEventMode",
            "label": "SortEventMode",
            "data": {
              "body": "> `OnSort` 이벤트 발생시 정렬된 모든 컬럼의 정보를 반환 할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|마지막 정렬 컬럼만 반환 (`Default`)| |1|정렬된 모든 컬럼 반환| ### See also * [OnSort Event](/docs/event/OnSort) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SortEventMode.html"
          },
          {
            "cid": 117,
            "sid": "SparklineColor",
            "name": "SparklineColor",
            "label": "SparklineColor",
            "data": {
              "body": "> 스파크라인 차트의 양수 값(영역)에 대한 색상 값을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|색상 값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SparklineColor.html"
          },
          {
            "cid": 118,
            "sid": "SparklineNegativeColor",
            "name": "SparklineNegativeColor",
            "label": "SparklineNegativeColor",
            "data": {
              "body": "> 스파크라인 차트의 음수 값(영역)에 대한 색상 값을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|색상 값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SparklineNegativeColor.html"
          },
          {
            "cid": 119,
            "sid": "SubSumMode",
            "name": "SubSumMode",
            "label": "SubSumMode",
            "data": {
              "body": "> 소계행 표시 방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|모든 대상 그룹에 대한 소계행 표시 (`Default`)| |1|대상 그룹이 2개 이상인 그룹에 대해서만 소계행 표시| ### See also ### Since |version|desc| |---|---| |7.0.13.51|SubSumMode, FocusSumRow 속성 추가|",
              "since": "|version|desc||---|---||7.0.13.51|SubSumMode, FocusSumRow 속성 추가|"
            },
            "url": "docs/props/PropertyList/SubSumMode.html"
          },
          {
            "cid": 120,
            "sid": "SumBackColor",
            "name": "SumBackColor",
            "label": "SumBackColor",
            "data": {
              "body": "> 합계행의 배경 색상을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|색상 값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SumBackColor.html"
          },
          {
            "cid": 121,
            "sid": "SumFontBold",
            "name": "SumFontBold",
            "label": "SumFontBold",
            "data": {
              "body": "> 합계행 Font의 Bold 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|Bold 적용 안함| |1|Bold 적용| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SumFontBold.html"
          },
          {
            "cid": 122,
            "sid": "SumFontColor",
            "name": "SumFontColor",
            "label": "SumFontColor",
            "data": {
              "body": "> 합계행의 Font 색상을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|색상 값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SumFontColor.html"
          },
          {
            "cid": 123,
            "sid": "SumZeroValue",
            "name": "SumZeroValue",
            "label": "SumZeroValue",
            "data": {
              "body": "> 합계 행의 합계값이 0 인경우 0 표시 대신 사용할 치환값을 설정합니다. > 해당 속성에 `\"\"` 사용시 합계값이 0인 경우 0이 표시되지 않고 공백으로 보여지게 됩니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|합계값이 0인 경우 0 대신 사용할 치환값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SumZeroValue.html"
          },
          {
            "cid": 124,
            "sid": "SyncPaste",
            "name": "SyncPaste",
            "label": "SyncPaste",
            "data": {
              "body": "> 클립보드 붙여넣기를 동기방식으로 처리할지 여부를 설정합니다. > 붙여넣기하는 데이터의 양이 대량일 경우 브라우저 대기시간이 너무 길어질 때, 대기 이미지를 띄우는 등 기타 처리를 위해 사용됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|비동기 방식 처리| |1|동기 방식 처리 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/SyncPaste.html"
          },
          {
            "cid": 125,
            "sid": "TapHoldTreshold",
            "name": "TapHoldTreshold",
            "label": "TapHoldTreshold",
            "data": {
              "body": "> 모바일에서 TapHold 인지 시간을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|TapHold 인지 시간`(ms)` (`Default : 800`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/TapHoldTreshold.html"
          },
          {
            "cid": 126,
            "sid": "ThemeVersion",
            "name": "ThemeVersion",
            "label": "ThemeVersion",
            "data": {
              "body": "> 사용할 테마 버전을 설정합니다. > `주의` 이 속성 설정값과 테마의 버전이 다른 경우 화면깨짐현상이 발생할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |1|일반 테마 버전 (`Default`)| |2|IE10 이상 모던 테마 버전 (모던 테마 : ModernWhite, ModernBlue)| ### See also ### Since |version|desc| |---|---| |7.0.13.50|ThemeVersion 속성 추가|",
              "since": "|version|desc||---|---||7.0.13.50|ThemeVersion 속성 추가|"
            },
            "url": "docs/props/PropertyList/ThemeVersion.html"
          },
          {
            "cid": 127,
            "sid": "Timestamp",
            "name": "Timestamp",
            "label": "Timestamp",
            "data": {
              "body": "> 날짜 타입에 대한 timestamp 형식의 데이터 사용여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용함 (`Default`)| |1|사용 안함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/Timestamp.html"
          },
          {
            "cid": 128,
            "sid": "ToolTipMode",
            "name": "ToolTipMode",
            "label": "ToolTipMode",
            "data": {
              "body": "> 툴팁 표시 모드를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|div 레이어를 이용한 표현 (`Default`)| |1|element 의 title 속성을 이용한 표현| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ToolTipMode.html"
          },
          {
            "cid": 129,
            "sid": "TouchScroll",
            "name": "TouchScroll",
            "label": "TouchScroll",
            "data": {
              "body": "> 모바일 기기에서 가로/세로 스크롤바에 대한 디자인을 설정합니다. > 스크롤바의 디자인 처리와 모바일 출력을 위해 이미지 스크롤바 기능을 제공합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|스크롤바 영역만 있을 뿐 실제 스크롤바를 통한 이동은 불가| |1|18px 크기의 이미지 스크롤바 디자인| |2|10px 크기의 이미지 스크롤바 디자인 (`Default`)| |3|9px 크기의 이미지 스크롤바 디자인| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/TouchScroll.html"
          },
          {
            "cid": 130,
            "sid": "TouchScrolling",
            "name": "TouchScrolling",
            "label": "TouchScrolling",
            "data": {
              "body": "> 터치스크롤 방식을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|일반 사용| |2|지연 이동| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/TouchScrolling.html"
          },
          {
            "cid": 131,
            "sid": "TreeDragIconMode",
            "name": "TreeDragIconMode",
            "label": "TreeDragIconMode",
            "data": {
              "body": "> 설명트리 구조에서 드래그시 드래그 위치 아이콘 표시모드를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|이동이 가능한 위치에 맞게 아이콘 표시 (`Default`)| |1|이동 위치와 상관없이 모든 아이콘 표시| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/TreeDragIconMode.html"
          },
          {
            "cid": 132,
            "sid": "TreeNodeIcon",
            "name": "TreeNodeIcon",
            "label": "TreeNodeIcon",
            "data": {
              "body": "> 트리 구조에서 트리 노드 아이콘 표시를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|아이콘 표시 하지 않음 (`Default`)| |1|아이콘 표시| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/TreeNodeIcon.html"
          },
          {
            "cid": 133,
            "sid": "TreeNodeToggleMode",
            "name": "TreeNodeToggleMode",
            "label": "TreeNodeToggleMode",
            "data": {
              "body": "> 마우스 입력을 통한 Tree 노드 토글시 처리 방법을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|토글후 해당 셀에 포커스 이동(`Default`)| |1|셀의 포커스 이동 없이 토글 처리| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/TreeNodeToggleMode.html"
          },
          {
            "cid": 134,
            "sid": "TrueValue",
            "name": "TrueValue",
            "label": "TrueValue",
            "data": {
              "body": "> 1 이외의 CheckBox형태 컬럼의 True 값을 지정합니다. > <span style=\"color:blue;\">Ex)</span> \"M\" 으로 지정한 경우 1 대신 \"M\"을 True 값으로 사용 가능합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|CheckBox에서 true(1) 값 대신 사용할 문자| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/TrueValue.html"
          },
          {
            "cid": 135,
            "sid": "UnicodeByte",
            "name": "UnicodeByte",
            "label": "UnicodeByte",
            "data": {
              "body": "> UnicodeByte 값을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|UnicodeByte 값| ### See also * [SetUnicodeByte method](/docs/funcs/core/SetUnicodeByte) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UnicodeByte.html"
          },
          {
            "cid": 136,
            "sid": "UpdateMergeCells",
            "name": "UpdateMergeCells",
            "label": "UpdateMergeCells",
            "data": {
              "body": "> 머지된 데이터를 수정시 전체 머지 영역의 데이터수정 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UpdateMergeCells.html"
          },
          {
            "cid": 137,
            "sid": "UploadImage",
            "name": "UploadImage",
            "label": "UploadImage",
            "data": {
              "body": "> 파일 업로드중 이미지 경로를 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|이미지 경로| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UploadImage.html"
          },
          {
            "cid": 138,
            "sid": "UseCache",
            "name": "UseCache",
            "label": "UseCache",
            "data": {
              "body": "> css, msg 파일의 브라우저 캐쉬 사용여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|브라우저 캐쉬 사용안함 (`Default`)| |1|브라우저 캐쉬 사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseCache.html"
          },
          {
            "cid": 139,
            "sid": "UseDefaultSortImage",
            "name": "UseDefaultSortImage",
            "label": "UseDefaultSortImage",
            "data": {
              "body": "> 소트 기능 헤더에 기본 소트 이미지 표시 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseDefaultSortImage.html"
          },
          {
            "cid": 140,
            "sid": "UseDefaultTime",
            "name": "UseDefaultTime",
            "label": "UseDefaultTime",
            "data": {
              "body": "> 편집시 현재시간 표시 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|표시 안함| |1|표시함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseDefaultTime.html"
          },
          {
            "cid": 141,
            "sid": "UseEditMask",
            "name": "UseEditMask",
            "label": "UseEditMask",
            "data": {
              "body": "> 편집시 사용자포맷, 날짜에 대한 IBMaskEdit 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함 (`Default`)| |1|사용함| ### See also * [SetConfig method](/docs/funcs/init/SetConfig) ### Since |version|desc| |---|---| |7.0.13.33|UseEditMask 속성 추가|",
              "since": "|version|desc||---|---||7.0.13.33|UseEditMask 속성 추가|"
            },
            "url": "docs/props/PropertyList/UseEditMask.html"
          },
          {
            "cid": 142,
            "sid": "UseEmptyMerge",
            "name": "UseEmptyMerge",
            "label": "UseEmptyMerge",
            "data": {
              "body": "> 공백데이터 머지여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|공백머지안함| |1|빈값머지 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseEmptyMerge.html"
          },
          {
            "cid": 143,
            "sid": "UseFilterHtmlType",
            "name": "UseFilterHtmlType",
            "label": "UseFilterHtmlType",
            "data": {
              "body": "> `Html` 컬럼에서 필터 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|필터 사용 안함 (`Default`)| |1|필터 사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseFilterHtmlType.html"
          },
          {
            "cid": 144,
            "sid": "UseFindDialog",
            "name": "UseFindDialog",
            "label": "UseFindDialog",
            "data": {
              "body": "> 찾기 팝업 다이얼로그 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함| |1|사용함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.13.34|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.34|속성 추가|"
            },
            "url": "docs/props/PropertyList/UseFindDialog.html"
          },
          {
            "cid": 145,
            "sid": "UseGroupActionMenu",
            "name": "UseGroupActionMenu",
            "label": "UseGroupActionMenu",
            "data": {
              "body": "> 그룹행에서 컨텍스트 메뉴 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|속성 사용 안함 (`Default`)| |1|속성 사용함| ### See also * [GetGroupActionMenu method](/docs/funcs/group/GetGroupActionMenu) * [SetGroupActionMenu method](/docs/funcs/group/SetGroupActionMenu) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseGroupActionMenu.html"
          },
          {
            "cid": 146,
            "sid": "UseHeaderActionMenu",
            "name": "UseHeaderActionMenu",
            "label": "UseHeaderActionMenu",
            "data": {
              "body": "> 헤더 컨텍스트 메뉴 사용여부를 설정합니다. > 헤더메뉴를 사용함으로 설정하고 헤더메뉴를 설정하지 않는경우 자동으로 기본 메뉴가 출력됩니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|속성 사용 안함 `(Default`)| |1|속성 사용함| ### See also * [GetHeaderActionMenu method](/docs/funcs/core/GetHeaderActionMenu) * [SetHeaderActionMenu method](/docs/funcs/core/SetHeaderActionMenu) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseHeaderActionMenu.html"
          },
          {
            "cid": 147,
            "sid": "UseHeaderSortCancel",
            "name": "UseHeaderSortCancel",
            "label": "UseHeaderSortCancel",
            "data": {
              "body": "> 헤더 클릭을 통한 컬럼 Sort 처리시 취소 모드 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|속성 사용 안함 (`Default`) 헤더 클릭시 Asc / Desc 순으로 처리| |1|속성 사용함 헤더 클릭시 Asc / Desc / 취소 순으로 처리| ### See also ### Since |version|desc| |---|---| |7.0.13.48|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.48|속성 추가|"
            },
            "url": "docs/props/PropertyList/UseHeaderSortCancel.html"
          },
          {
            "cid": 148,
            "sid": "UseHiddenFilter",
            "name": "UseHiddenFilter",
            "label": "UseHiddenFilter",
            "data": {
              "body": "> 필터 행 없이 필터링 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|속성 사용 안함 (`Default`)| |1|속성 사용함 필터행이 보이지 않아도 `SetFilterValue`를 사용 할 수 있게 설정| ### See also * [SetFilterValue method](/docs/funcs/filter/SetFilterValue) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseHiddenFilter.html"
          },
          {
            "cid": 149,
            "sid": "UseJsonAttribute",
            "name": "UseJsonAttribute",
            "label": "UseJsonAttribute",
            "data": {
              "body": "> Json 형식의 데이터 구조에서 Attribute 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|속성 사용 안함 (`Default`)| |1|속성 사용함| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseJsonAttribute.html"
          },
          {
            "cid": 150,
            "sid": "UseJsonTreeLevel",
            "name": "UseJsonTreeLevel",
            "label": "UseJsonTreeLevel",
            "data": {
              "body": "> Json 형식의 데이터 구조에서 트리 형식 구성시 `Level`속성을 이용하여 구성할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|Level 속성 사용 안함 (`Default`)| |1|Level 속성을 사용함| ### See also * [ShowTreeLevel method](/docs/funcs/tree/ShowTreeLevel) * [GetRowLevel method](/docs/funcs/tree/GetRowLevel) * [SetRowLevel method](/docs/funcs/tree/SetRowLevel) ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseJsonTreeLevel.html"
          },
          {
            "cid": 151,
            "sid": "UseNoDataRow",
            "name": "UseNoDataRow",
            "label": "UseNoDataRow",
            "data": {
              "body": "> 조회된 데이터가 없는 경우, `조회된 데이터가 없습니다` 문구 표시 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|문구 사용 안함| |1|문구 사용함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseNoDataRow.html"
          },
          {
            "cid": 152,
            "sid": "UsePivotDialog",
            "name": "UsePivotDialog",
            "label": "UsePivotDialog",
            "data": {
              "body": "> 피벗 설정 팝업 다이얼로그 사용 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|사용 안함| |1|사용함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.13.34|속성 추가|",
              "since": "|version|desc||---|---||7.0.13.34|속성 추가|"
            },
            "url": "docs/props/PropertyList/UsePivotDialog.html"
          },
          {
            "cid": 153,
            "sid": "UseTableSuffix",
            "name": "UseTableSuffix",
            "label": "UseTableSuffix",
            "data": {
              "body": "> MainTable id에 ‘-table’ Suffix 적용여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|Suffix 적용 안함| |1|Suffix 적용 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UseTableSuffix.html"
          },
          {
            "cid": 154,
            "sid": "UserAgent",
            "name": "UserAgent",
            "label": "UserAgent",
            "data": {
              "body": "> UserAgent 값을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|userAgent값| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/UserAgent.html"
          },
          {
            "cid": 155,
            "sid": "WaitImageVisible",
            "name": "WaitImageVisible",
            "label": "WaitImageVisible",
            "data": {
              "body": "> 각종 처리 중 대기 이미지 표시 여부를 설정 합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----------| |0|표시안함| |1|표시함 (`Default`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/WaitImageVisible.html"
          },
          {
            "cid": 156,
            "sid": "WaitTimeOut",
            "name": "WaitTimeOut",
            "label": "WaitTimeOut",
            "data": {
              "body": "> 응답 대기시간을 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|응답 대기시간`(초)` (`Default : 1`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/WaitTimeOut.html"
          },
          {
            "cid": 157,
            "sid": "WheelScrollSize",
            "name": "WheelScrollSize",
            "label": "WheelScrollSize",
            "data": {
              "body": "> 휠 스크롤시 이동할 행의 개수를 설정합니다. ### Type `number` ### Options |Value|Description| |-----|-----------| |`number`|휠 스크롤시 이동할 행의 개수 (`Default : 1`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/WheelScrollSize.html"
          },
          {
            "cid": 158,
            "sid": "ibEditTitle",
            "name": "ibEditTitle",
            "label": "ibEditTitle",
            "data": {
              "body": "> 셀의 타이틀 값을 설정합니다. ### Type `string` ### Options |Value|Description| |-----|-----------| |`string`|셀의 타이틀 문자열 (`Default: \"ibEdit\"`)| ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/props/PropertyList/ibEditTitle.html"
          }
        ]
      }
    ]
  },
  {
    "gid": 4,
    "name": "funcs",
    "label": "Methods",
    "children": [
      {
        "cid": 159,
        "sid": "amethod",
        "name": "amethod",
        "label": "메소드 사용하기",
        "data": {
          "body": "> IBSheet7에서 제공하는 Method를 사용하기 위해서는 아래와 같은 Syntax를 통해 사용할 수 있습니다. ### Syntax ```javascript 오브젝트ID.메소드명(); ``` * Method의 인자 중 선택 인자는 설정하지 않고 호출할 경우 Default 값 적용을 받아 메소드가 처리됩니다. ## Example * 트랜잭션과 관련된 각종 기능 버튼을 생성하고 기능버튼이 처리해야할 작업을 자바스크립트 함수로 구현합니다. 입력, 행 복사 기능을 아래 같이 구현할 수 있습니다. (예시) ```javascript function doAction(sAction) { switch(sAction) { case \"Insert\"://입력 mySheet.DataInsert(); break; case \"Copy\"://행복사 mySheet.DataCopy(); break; } } <html> <input type=\"button\" value=\"입력\" onClick=\"doAction('Insert')\"> // <input type=\"button\" value=\"행 복사\" onClick=\"doAction('Copy')\"> <table cellpadding=\"0\" cellspacing=\"1\" border=\"0\" width=\"100%\"> <tr> <td bgcolor=\"#FFFFFF\">Employee Name</td> <td bgcolor=\"#FFFFFF\"> <input type=\"text\" name=\"sa_name\"> </td> <td bgcolor=\"#FFFFFF\">Salary</td> <td bgcolor=\"#FFFFFF\"> <input type=\"text\" class=\"on_curr1\" name=\"sal\" value=\"0\"> </td> <td bgcolor=\"#FFFFFF\">HireDate</td> <td bgcolor=\"#FFFFFF\"> <input type=\"text\" class=\"on_date\" name=\"hdate\" > </td> </tr> </table> </html> ```"
        },
        "url": "docs/funcs/amethod.html"
      },
      {
        "gid": 1,
        "name": "funcs-globalModule",
        "label": "globalModule",
        "children": [
          {
            "cid": 160,
            "sid": "Close",
            "name": "Close",
            "label": "Close",
            "data": {
              "body": "> 외부의 컨트롤에서 사용한 달력팝업을 닫도록 설정합니다. ### Syntax ```javascript IBCalendar.Close(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 달력 팝업을 띄웁니다. IBCalendar.Show(\"20121116\", {Format :\"yyyy/MM/dd\", X :300, Y :600}) ; // 띄운 달력 팝업 Dialog를 닫습니다. IBCalendar. Close(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/globalModule/Close.html"
          },
          {
            "cid": 161,
            "sid": "SetTheme",
            "name": "SetTheme",
            "label": "SetTheme",
            "data": {
              "body": "> 외부 컨트롤에서 사용할 달력팝업의 테마 디자인을 설정합니다. > 설정하기 위해서는 사전에 테마 디자인을 작업해야 합니다. [Appendix - Theme 만들기 참조](/docs/appx/Theme) ### Syntax ```javascript IBCalendar.SetTheme(prefix, folder); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |prefix|`String`|<span class=\"required\">필수</span>|테마의 Prefix 값| |folder|`String`|<span class=\"required\">필수</span>|테마의 폴더명| ### Returns ***none*** ### Example ```javascript //Orange 테마를 적용 IBCalendar.SetTheme(\"OR\", \"Orange\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/globalModule/SetTheme.html"
          },
          {
            "cid": 162,
            "sid": "Show",
            "name": "Show",
            "label": "Show",
            "data": {
              "body": "> 달력 팝업을 외부의 컨트롤에서 사용하도록 설정합니다. > 일반적으로 CallBack 함수를 지정하는 경우 첫번째 인자로 선택한 날짜 문자열이 전달되며, 그 외 CallBack 함수로 전달하고자 하는 인자가 있는 경우 `CallBackParam` 을 설정합니다. > CallBackParam으로 설정된 객체는 CallBack 함수의 두번째 인자로 전달됩니다. ### Syntax ```javascript IBCalendar.Show(val, obj); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |val|`String`|<span class=\"required\">필수</span>|날짜 데이터값 (Default: 현재날짜)| |obj|`Object`|<span class=\"optional\">선택</span>|기능을 json 형태로 설정| ### Enum * 컬럼별로 설정할 수 있는 속성 |Name|Type|Description| |----|----|-----------| |CalButtonAlign|`String`|달력팝업에서 버튼을 사용하는 경우 정렬방법을 설정 - `Left` : 왼쪽정렬 - `Center` : 가운데정렬 (Default) - `Right` : 오른쪽정렬| |CalButtons|`String`|달력팝업의 사용할 버튼 설정 (사용하고자 하는 버튼을 `|` 로 연결하여 설정) - `Close` : 취소 버튼 - `Today` : 오늘일자 입력 버튼 - `Yesterday` : 어제일자 입력 버튼 - `InputEmpty` : 빈값 입력 버튼 - `Ok` : 선택 버튼| |CallBack|`String or Function`|callBack 함수명 또는 함수 객체| |CallBackParam|`Object`|CallBack 함수에서 받을 인자 객체| |Format|`String`|날짜포맷 패턴 (Default: \"yyyy/MM/dd\")| |Holiday|`String`|달력에 표시할 사용자 정의 휴일 설정 (파이프 연산자로 설정값을 연결한 문자열로 설정 할 수 있으며 포맷은 `yyyyMMdd` 만 허용)| |Result|`Object`|선택 결과를 설정할 객체 (input 객체)| |ShowYM|`Boolean`|년월 선택화면 우선 표시 여부| |Target|`String or Object`|\"Mouse\" (마지막 마우스 위치 사용시, Default) 또는 달력 버튼 Object (달력 버튼 위치 사용시)| |X|`Number`|(좌표값 사용시) X 축 좌표값| |Y|`Number`|(좌표값 사용시) Y 축 좌표값| ### Returns ***String, 달력 팝업 Dialog에서 선택한 날짜값*** ### Example ```javascript // 날짜데이터값 입력 var val = document.getElementById(\"DateText\").value; // 달력 팝업 Dialog 위치 : X, Y 좌표값 사용시 var obj = { Format:\"yyyy/MM/dd\", X:300, Y:600, CallBack:\"Test\" }; // 달력 팝업 Dialog 위치 : 마우스 마지막 위치 사용시 var obj = { Format:\"yyyy/MM/dd\", Target:\"Mouse\", CallBack: \"Test\" }; // 달력 팝업 Dialog 위치 : 달력 버튼 위치 사용시 var obj = { Target:document.getElementById(\"DateBtn\"), CallBack: \"Test\" }; // CalButtons 속성 : 달력 닫기 버튼 옵션 설정 사용시 var obj = { Format:\"Ymd\", Target:document.getElementById(\"DateBtn\"), CallBack: \"Test\" , CalButtons : \"Close\"}; // 달력 닫기 버튼 옵션 설정 사용시 정렬 설정: 왼쪽 정렬 var obj = { Format:\"Ymd\", Target:document.getElementById(\"DateBtn\"), CallBack: \"Test\", CalButtons : \"Close\", CalButtonAlign : \"Left\" }; // 사용자 정의 휴일 설정 var obj = { Format:\"Ymd\", Target:document.getElementById(\"DateBtn\"), CallBack: \"Test\", Holiday: \" 20101215|*1203\"}; // 달력 출력 IBCalendar.Show(\"20140415\", obj); // fnName : 함수명으로 function 생성 function Test (date){ // 달력 팝업 Dialog서 날짜 선택시 리턴값 document.getElementById(\"DateText\").value = date; } ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.11.0|CalButtons 속성의 \"InputEmpty\" 값 추가| |7.0.13.10|CalButtons 속성의 \"Ok\" 값 추가| |7.0.13.16|ShowYM 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.11.0|CalButtons 속성의 \"InputEmpty\" 값 추가||7.0.13.10|CalButtons 속성의 \"Ok\" 값 추가||7.0.13.16|ShowYM 속성 추가|"
            },
            "url": "docs/funcs/globalModule/Show.html"
          },
          {
            "cid": 163,
            "sid": "aglobalModule",
            "name": "aglobalModule",
            "label": "IBSheet7 Global Module",
            "data": {
              "body": "### IBSheet7에서 제공하는 Global Module을 사용하기 위해서는 ibsheet.js 파일을 해당 페이지 내에 include 해야만 사용 할 수 있습니다. 제공하는 모듈은 아래와 같습니다. 1. IBCalendar"
            },
            "url": "docs/funcs/globalModule/aglobalModule.html"
          }
        ]
      },
      {
        "gid": 2,
        "name": "funcs-cell",
        "label": "cell",
        "children": [
          {
            "cid": 164,
            "sid": "CellComboItem",
            "name": "CellComboItem",
            "label": "CellComboItem",
            "data": {
              "body": "> 특정 셀의 Combo 항목만 다른 경우 Combo항목을 개별 설정합니다. > 컬럼 전체의 콤보 항목은 `InitColumns` 함수를 이용하여 설정하고, 특정 셀만 항목이 다른 경우 이 함수를 이용합니다. > 2개행 이상의 단위데이터행 구조에서 Col 인자에 Index를 설정할 경우 첫번째 행의 해당 인덱스 셀에 대해서 처리를 하고 > SaveName으로 설정할 경우 설정한 행의 단위데이터행 내 해당 SaveName 셀에 대해서 처리합니다. ### Syntax ```javascript ObjId.CellComboItem(Row, Col,info); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|특정 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 셀의 Column Index 또는 SaveName| |info|`Object`|<span class=\"required\">필수</span>|변경할 Combo item 내용을 구분자 `\"|\"`로 연결된 문자열을 만들어 ComboCode와 ComboText로 값을 설정 ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 콤보 항목 설정 mySheet.CellComboItem(2, 3, { \"ComboCode\": \"A001|A002|A003|A004\", \"ComboText\": \"부장|과장|대리|사원\" }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/CellComboItem.html"
          },
          {
            "cid": 165,
            "sid": "CellSaveName",
            "name": "CellSaveName",
            "label": "CellSaveName",
            "data": {
              "body": "> Row, Col 인자의 데이터 셀에 대한 SaveName을 확인 합니다. ### Syntax ```javascript ObjId.CellSaveName(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long`|<span class=\"required\">필수</span>|해당 셀의 Column Index| ### Returns ***String, 해당 셀의 SaveName*** ### Example ```javascript function mySheet_OnClick(Row, Col, Value, CellX, CellY, CellW, CellH) { // 클릭한 셀의 SaveName을 확인 var saveName = mySheet.CellSaveName(Row, Col); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/CellSaveName.html"
          },
          {
            "cid": 166,
            "sid": "CellSearchValue",
            "name": "CellSearchValue",
            "label": "CellSearchValue",
            "data": {
              "body": "> 셀이 조회되었던 당시의 값을 확인합니다. > 2개행 이상의 단위데이터행 구조에서 Col 인자에 Index를 설정할 경우 첫번째 행의 해당인덱스 셀에 대해서 처리를 하고 > SaveName으로 설정할 경우 설정한 행의 단위데이터행 내 해당 SaveName 셀에 대해서 처리합니다. > 해당 행이 입력된 행이거나 다음과 같은 Type일때, 값은 공백이 됩니다. `Status, DelCheck, Seq, Image` ### Syntax ```javascript ObjId.CellSearchValue(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 조회당시 셀 값*** ### Example ```javascript // 조회되었던 셀 값을 확인하고, 해당 셀 값을 원래 값으로 되돌린다. var OrgValue = mySheet.CellSearchValue(Row, Col); if(OrgValue != mySheet.GetCellValue(Row, Col)) { mySheet.SetCellValue(Row, Col, OrgValue); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/CellSearchValue.html"
          },
          {
            "cid": 167,
            "sid": "GetCellAlign",
            "name": "GetCellAlign",
            "label": "GetCellAlign",
            "data": {
              "body": "> 대상 셀의 좌우 정렬값을 확인 합니다. > 해당 셀의 컬럼 또는 셀에 대해서 설정값이 없는 경우는 빈값으로 반환 합니다. ### Syntax ```javascript ObjId.GetCellAlign(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 셀의 좌우 정렬값*** ### Example ```javascript // (2, 3)셀의 좌우 정렬값 확인 console.log(\"cellAlign:\", mySheet.GetCellAlign(2, 3)); // (2, 'sDeptName')셀의 좌우 정렬값 확인 console.log(\"cellAlign:\", mySheet.GetCellAlign(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellAlign.html"
          },
          {
            "cid": 168,
            "sid": "GetCellBackColor",
            "name": "GetCellBackColor",
            "label": "GetCellBackColor",
            "data": {
              "body": "> 대상 셀의 배경색을 확인 합니다. ### Syntax ```javascript ObjId.GetCellBackColor(Row, Col) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 대상 셀의 배경색*** ### Example ```javascript // (2, 3)셀의 배경색 확인 console.log(\"backColor:\", mySheet.GetCellBackColor(2, 3)); // (2, 'sDeptName')셀의 배경색 확인 console.log(\"backColor:\", mySheet.GetCellBackColor(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellBackColor.html"
          },
          {
            "cid": 169,
            "sid": "GetCellCursor",
            "name": "GetCellCursor",
            "label": "GetCellCursor",
            "data": {
              "body": "> 대상 셀의 마우스 오버시 커서 모양을 확인합니다. ### Syntax ```javascript ObjId.GetCellCursor(Row, Col) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String*** ### Example ```javascript // (2, 3) 셀의 마우스 커서포인터를 확인 mySheet.GetCellCursor(2, 3); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellCursor.html"
          },
          {
            "cid": 170,
            "sid": "GetCellEditable",
            "name": "GetCellEditable",
            "label": "GetCellEditable",
            "data": {
              "body": "> 대상 셀의 편집 가능 여부 속성값을 확인 합니다. > 행 또는 컬럼의 인자가 올바르지 않은 경우에는 별도 처리 없이 InvalidValue 설정 값을 반환 합니다. ### Syntax ```javascript ObjId.GetCellEditable(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***boolean*** ### Example ```javascript // (2, 3)셀의 편집가능 여부 확인 console.log(\"editable:\", mySheet.GetCellEditable(2, 3)); // (2, 'sDeptName')셀의 편집가능 여부 확인 console.log(\"editable:\", mySheet.GetCellEditable(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellEditable.html"
          },
          {
            "cid": 171,
            "sid": "GetCellFont",
            "name": "GetCellFont",
            "label": "GetCellFont",
            "data": {
              "body": "> 대상 셀의 폰트에 적용된 스타일을 확인 합니다. ### Syntax ```javascript ObjId.GetCellFont(style, startRow, startCol, endRow, endCol); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |style|`String`|<span class=\"required\">필수</span>|폰트 속성| |startRow|`Long`|<span class=\"required\">필수</span>|영역 시작 셀의 Row Index| |startCol|`Long or String`|<span class=\"required\">필수</span>|영역 시작 셀의 Column Index 또는 SaveName| |endRow|`Long`|<span class=\"required\">필수</span>|영역 마지막 셀의 Row Index| |endCol|`Long or String`|<span class=\"required\">필수</span>|영역 마지막 셀의 Column Index 또는 SaveName| ### Enum * style |Name|Description| |----|-----------| |FontName|글꼴| |FontSize|글자크기| |FontColor|글자색상| |FontBold|글자 볼드 여부| |FontItalic|글자 기울임 여부| |FontUnderline|글자 밑줄 표시 여부| |FontStrike|글자 취소선 표시 여부| ### Returns ***Boolan/String , 설정한 속성 값*** ### Example ```javascript // (2, 3)셀의 폰트 사이즈 확인 console.log(\"fontSize:\", mySheet.GetCellFont('FontSize', 2, 3)); // (2, 3)셀의 폰트에 bold 적용 여부 확인 console.log(\"fontBold:\", mySheet.GetCellFont('FontBold', 2, 3)); //글자크기가 10보다 큰 경우 9사이즈로 변경한다. if (mySheet.GetCellFont(\"FontSize\", 2,1,2,1) >= 10) { mySheet.SetCellFont(\"FontSize\", 2,1,2,1,9)); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFont.html"
          },
          {
            "cid": 172,
            "sid": "GetCellFontBold",
            "name": "GetCellFontBold",
            "label": "GetCellFontBold",
            "data": {
              "body": "> 대상 셀의 폰트에 bold 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetCellFontBold(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***Boolean, 설정 값*** ### Example ```javascript // (2, 3)셀의 폰트에 bold 적용 여부 확인 console.log(\"fondBold:\", mySheet.GetCellFontBold(2, 3)); // (2, 'sDeptName')셀의 폰트에 bold 적용 여부 확인 console.log(\"fondBold:\", mySheet.GetCellFontBold(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFontBold.html"
          },
          {
            "cid": 173,
            "sid": "GetCellFontColor",
            "name": "GetCellFontColor",
            "label": "GetCellFontColor",
            "data": {
              "body": "> 대상 셀의 폰트 색상을 확인 합니다. > 대상 셀에 폰트 색상 설정이 없는 경우 ''으로 반환 합니다. ### Syntax ```javascript ObjId.GetCellFontColor(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 설정된 색상값*** ### Example ```javascript // (2, 3)셀의 폰트색상 확인 console.log(\"fontColor:\", mySheet.GetCellFontColor(2, 3)); // (2, 'sDeptName')셀의 배경색 확인 console.log(\"fontColor:\", mySheet.GetCellFontColor(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFontColor.html"
          },
          {
            "cid": 174,
            "sid": "GetCellFontItalic",
            "name": "GetCellFontItalic",
            "label": "GetCellFontItalic",
            "data": {
              "body": "> 대상 셀의 폰트에 italic 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetCellFontItalic(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***Boolean, 설정 값*** ### Example ```javascript // (2, 3)셀의 폰트에 italic 적용 여부 확인 console.log(\"fontItalic:\", mySheet.GetCellFontItalic(2, 3)); // (2, 'sDeptName')셀의 폰트에 italic 적용 여부 확인 console.log(\"fontItalic:\", mySheet.GetCellFontItalic(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFontItalic.html"
          },
          {
            "cid": 175,
            "sid": "GetCellFontName",
            "name": "GetCellFontName",
            "label": "GetCellFontName",
            "data": {
              "body": "> 대상 셀의 폰트 글꼴을 확인 합니다. ### Syntax ```javascript ObjId.GetCellFontName(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 설정 값*** ### Example ```javascript // (2, 3)셀의 폰트 글꼴 확인 console.log(\"fontName:\", mySheet.GetCellFontName(2, 3)); // (2, 'sDeptName')셀의 폰트 글꼴 확인 console.log(\"fontName:\", mySheet.GetCellFontName(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFontName.html"
          },
          {
            "cid": 176,
            "sid": "GetCellFontSize",
            "name": "GetCellFontSize",
            "label": "GetCellFontSize",
            "data": {
              "body": "> 대상 셀의 폰트 사이즈를 확인 합니다. ### Syntax ```javascript ObjId.GetCellFontSize(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***Integer, 설정 값*** ### Example ```javascript // (2, 3)셀의 폰트 사이즈 확인 console.log(\"fontSize:\", mySheet.GetCellFontSize(2, 3)); // (2, 'sDeptName')셀의 폰트 사이즈 확인 console.log(\"fontSize:\", mySheet.GetCellFontSize(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFontSize.html"
          },
          {
            "cid": 177,
            "sid": "GetCellFontStrike",
            "name": "GetCellFontStrike",
            "label": "GetCellFontStrike",
            "data": {
              "body": "> 대상 셀의 폰트에 strike 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetCellFontStrike(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***none*** ### Example ```javascript // (2, 3)셀의 폰트에 strike 적용 여부 확인 console.log(\"fontStrike:\", mySheet.GetCellFontStrike(2, 3)); // (2, 'sDeptName')셀의 폰트에 strike 적용 여부 확인 console.log(\"fontStrike:\", mySheet.GetCellFontStrike(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFontStrike.html"
          },
          {
            "cid": 178,
            "sid": "GetCellFontUnderline",
            "name": "GetCellFontUnderline",
            "label": "GetCellFontUnderline",
            "data": {
              "body": "> 대상 셀의 폰트에 underline 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetCellFontUnderline(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***Boolean, 현재 설정 값*** ### Example ```javascript // (2, 3)셀의 폰트에 underline 적용 여부 확인 console.log(\"fontUnderline:\", mySheet.GetCellFontUnderline(2, 3)); // (2, 'sDeptName')셀의 폰트에 underline 적용 여부 확인 console.log(\"fontUnderline:\", mySheet.GetCellFontUnderline(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellFontUnderline.html"
          },
          {
            "cid": 179,
            "sid": "GetCellImage",
            "name": "GetCellImage",
            "label": "GetCellImage",
            "data": {
              "body": "> 대상 셀에 설정되어 있는 이미지 경로를 확인 합니다. ### Syntax ```javascript ObjId.GetCellImage(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 설정된 이미지 경로*** ### Example ```javascript // (2, 3)셀에 설정되어있는 이미지 경로 확인 console.log(\"imgPath:\", mySheet.GetCellImage(2, 3)); // (2, 'sDeptName')셀의 편집가능 여부 확인 console.log(\"imgPath:\", mySheet.GetCellImage(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellImage.html"
          },
          {
            "cid": 180,
            "sid": "GetCellProperty",
            "name": "GetCellProperty",
            "label": "GetCellProperty",
            "data": {
              "body": "> 대상 셀의 속성 설정 값을 확인 합니다. > 대상 셀이 헤더 내의 셀인 경우 컬럼에 대한 속성 설정 값을 반환합니다. ### Syntax ```javascript ObjId.GetCellProperty(Row, Col, PropName); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |PropName|`String`|<span class=\"required\">필수</span>|확인하고자 하는 속성명| ### Returns ***String/ Boolean/ Integer, 설정한 컬럼의 속성값*** ### Example ```javascript // (2, 3)셀의 Format 속성 설정값 확인 console.log(\"cellFormat:\", mySheet.GetCellProperty(2, 3, 'Format')); // Index가 3인 컬럼의 Format 속성 설정값 확인 console.log(\"colFormat:\", mySheet.GetCellProperty(0, 3, 'Format')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellProperty.html"
          },
          {
            "cid": 181,
            "sid": "GetCellText",
            "name": "GetCellText",
            "label": "GetCellText",
            "data": {
              "body": "> 대상 셀의 Format이 적용된 값을 확인 합니다. ### Syntax ```javascript ObjId.GetCellText(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 셀에 설정된 값*** ### Example ```javascript // (2, 3) 셀의 value 확인 console.log(\"cellText:\", mySheet.GetCellText(2, 3)); // (2, 'sDeptName')셀의 value 확인 console.log(\"cellText:\", mySheet.GetCellText(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellText.html"
          },
          {
            "cid": 182,
            "sid": "GetCellVAlign",
            "name": "GetCellVAlign",
            "label": "GetCellVAlign",
            "data": {
              "body": "> 대상 셀의 상하 정렬값을 확인 합니다. > 해당 셀의 컬럼 또는 셀에 대해서 설정값이 없는 경우는 빈값으로 반환 합니다. ### Syntax ```javascript ObjId.GetCellVAlign(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 세로 정렬 설정값*** ### Example ```javascript // (2, 3)셀의 상하 정렬값 확인 console.log(\"cellVerticalAlign:\", mySheet.GetCellAlign(2, 3)); // (2, 'sDeptName')셀의 상하 정렬값 확인 console.log(\"cellVerticalAlign:\", mySheet.GetCellAlign(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellVAlign.html"
          },
          {
            "cid": 183,
            "sid": "GetCellValue",
            "name": "GetCellValue",
            "label": "GetCellValue",
            "data": {
              "body": "> 대상 셀의 값을 확인 합니다. > 반환되는 값은 설정한 Format이 적용되지 않은 value 값 입니다. ### Syntax ```javascript ObjId.GetCellValue(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 셀에 설정된 값*** ### Example ```javascript // (2, 3) 셀의 value 확인 console.log(\"cellValue:\", mySheet.GetCellValue(2, 3)); // (2, 'sDeptName')셀의 value 확인 console.log(\"cellValue:\", mySheet.GetCellValue(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetCellValue.html"
          },
          {
            "cid": 184,
            "sid": "GetComboInfo",
            "name": "GetComboInfo",
            "label": "GetComboInfo",
            "data": {
              "body": "> 대상 셀에 대한 콤보 정보를 확인 합니다. ### Syntax ```javascript ObjId.GetComboInfo(Row,Col,Flag); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Enum * Flag 속성값 |Name|Description| |----|-----------| |Text|콤보텍스트| |Code|콤보코드| |Color|콤보컬러| |Disabled|콤보 선택 불가항목| |SelectedIndex|선택된 콤보의Item Index| ### Returns ***String, 콤보 텍스트 또는 코드*** ### Example ```javascript // (2, 3) 셀의 ComboText 설정값 확인 console.log('comboText: ', mySheet.GetComboInfo(2, 3, 'text')); // (2, 3) 셀의 ComboCode 설정값 확인 console.log('comboCode: ', mySheet.GetComboInfo(2, 3, 'code')); // (2, 3) 셀의 ComboColor 설정값 확인 console.log('comboColor: ', mySheet.GetComboInfo(2, 3, 'color')); // (2, 3) 셀의 SelectedIndex 확인 console.log('selectedIndex: ', mySheet.GetComboInfo(2, 3, 'selectedIndex')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetComboInfo.html"
          },
          {
            "cid": 185,
            "sid": "GetHtmlHeaderValue",
            "name": "GetHtmlHeaderValue",
            "label": "GetHtmlHeaderValue",
            "data": {
              "body": "> 헤더가 HTML 타입일때, 설정된 태그값을 가져옵니다. ### Syntax ```javascript ObjId. GetHtmlHeaderValue(Row,Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 설정된 태그값*** ### Example ```javascript // (0, 0) Html 타입의 헤더셀의 값을 가져온다. mySheet.GetHtmlHeaderValue(0, 0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetHtmlHeaderValue.html"
          },
          {
            "cid": 186,
            "sid": "GetMaximumValue",
            "name": "GetMaximumValue",
            "label": "GetMaximumValue",
            "data": {
              "body": "> 대상 셀의 입력 최대 값을 확인 합니다. ### Syntax ```javascript ObjId.GetMaximumValue(Row, Col) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***Long, 설정된 최대값*** ### Example ```javascript // (2, 3)셀의 입력 최대 값 확인 console.log(\"inputMax:\", mySheet.GetMaximumValue(2, 3)); // (2, 'sDeptName')셀의 입력 최대 값 확인 console.log(\"inputMax:\", mySheet.GetMaximumValue(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetMaximumValue.html"
          },
          {
            "cid": 187,
            "sid": "GetMinimumValue",
            "name": "GetMinimumValue",
            "label": "GetMinimumValue",
            "data": {
              "body": "> 대상 셀의 입력 최소 값을 확인 합니다. ### Syntax ```javascript ObjId.GetMinimumValue(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***Long, 설정된 최소값*** ### Example ```javascript // (2, 3)셀의 입력 최소 값 확인 console.log(\"inputMax:\", mySheet.GetMinimumValue(2, 3)); // (2, 'sDeptName')셀의 입력 최소 값 확인 console.log(\"inputMax:\", mySheet.GetMinimumValue(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetMinimumValue.html"
          },
          {
            "cid": 188,
            "sid": "GetToolTipText",
            "name": "GetToolTipText",
            "label": "GetToolTipText",
            "data": {
              "body": "> 대상 셀에 설정한 툴팁 문자열을 확인 합니다. ### Syntax ```javascript ObjId.GetToolTipText(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***String, 현재 설정된 값*** ### Example ```javascript // (2, 3)셀의 툴팁 문자열 확인 console.log(\"toolTip:\", mySheet.GetToolTipText(2, 3)); // (2, 'sDeptName')셀의 툴팁 문자열 확인 console.log(\"backColor:\", mySheet.GetToolTipText(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/GetToolTipText.html"
          },
          {
            "cid": 189,
            "sid": "InitCellProperty",
            "name": "InitCellProperty",
            "label": "InitCellProperty",
            "data": {
              "body": "> 대상 셀에 대한 타입 및 속성을 설정 합니다. > 해당 컬럼의 타입과 다른 타입을 대상 셀에 설정하고자 하는 경우에 이 기능을 사용 합니다. > `주의` 타입 설정시 데이터영역 기준으로 처리되는 `Seq, Status, DelCheck, AutoSum`과 같은 데이터 타입은 지원되지 않습니다. > `주의` info 인자의 `type`을 필수로 설정해야 합니다. ### Syntax ```javascript ObjId.InitCellProperty(Row, Col, info); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |info|`Object`|<span class=\"required\">필수</span>|셀의 속성 정의 객체| ### Enum * 설정 가능한 컬럼 Type |Type|Description| |----|------------| |Button|버튼 형태를 표현하는 데이터 타입| |CheckBox|CheckBox 형태 데이터| |Combo|Edit 불가능 Combo 데이터| |ComboEdit|자동완성형태의 Combo 데이터| |Date|날짜형 타입| |DummyCheck|이벤트를 발생하지 않는 체크박스 데이터타입| |Float|실수형 타입| |Html|Html 태그형태를 표현하는 데이터| |Image|Edit 불가능한 단순 이미지 표현 형태 데이터| |Int|정수형 타입| |Popup|팝업을 사용한 데이터| |Text|기본 문자열 데이터| * 설정 가능한 속성(info) |Props|Type|Description| |-----|----|-----------| |Type|`String`|컬럼의 데이터 타입 `(필수)`| |AcceptKeys|`String`|입력허용키 설정 - `N` : 숫자만 허용 - `E` : 영문만 허용 - `N\\|E` : 숫자, 영문만 허용 - `N\\|E\\|[사용자정의문자]` : 숫자, 영문과 사용자정의문자로 설정한 문자 허용| |Align|`String`|데이터의 정렬| |ApproximateType|`Number`|근사값처리방식 (1: 반올림, 2: 내림, 3: 올림)| |ComboCode|`String`|콤보 리스트의 코드 집합| |ComboDisabled|`String`|콤보의 선택 불가능 항목| |ComboText|`String`|콤보 리스트의 문자열 집합| |Cursor|`String`|마우스 모양 설정| |CustomDate|`Number`|사용자 정의 날짜 사용여부| |Edit|`Boolean`|편집가능 여부| |EditLen|`Number`|데이터의 입력가능한 글자수| |EmptyToReplaceChar|`String`|빈값인 경우 대체하여 보여줄 문자 설정| |ExceptKeys|`String`|입력제외키 설정 - `N` : 숫자 입력 불가 - `E` : 영문 입력 불가 - `N\\|E` : 숫자, 영문 입력 불가 - `N\\|E\\|[사용자정의문자]` : 숫자, 영문과 사용자정의문자로 설정한 문자 입력 불가| |Format|`String`|데이터의 Mask 적용 형태| |FormatFix|`Boolean`|GetCellValue 시 GetCellText 값을 반환 할지 여부 (`Default : 0`) <span style=\"color:blue;\">1(true)</span> 로 설정시 저장할 때 Format 이 설정된 상태로 저장됩니다.| |HoverUnderline|`Boolean`|마우스오버시 언더라인 여부| |Image|`String`|이미지의 경로| |ImgAlign|`String`|이미지 표시 위치 | |ImgHeight|`Number`|이미지 높이| |ImgWidth|`Number`|이미지 너비| |InputCaseSensitive|`Number`|입력시 영문에 대한 대소구문 자동 치환 처리에 대한 설정 0 : 별도 처리 하지 않음 (`Default`) - 1 : 대문자로 치환 - 2 : 소문자로 치환| |ItemCode|`String`|멀티체크 아이템의 코드를 구분자 `\"|\"`로 연결한 문자열| |ItemText|`String`|멀티체크 아이템의 텍스트를 구분자 `\"|\"`로 연결한 문자열| |MaxCheck|`Number`|멀티체크의 최대 선택 개수 설정| |MaximumValue|`Number`|숫자포맷일 때 편집시 입력할 수 있는 최대값| |MinimumValue|`Number`|숫자포맷일 때 편집시 입력할 수 있는 최소값| |MultiLineText|`Boolean`|다중라인 입력여부| |PointCount|`Number`|컬럼타입이 Float 인 경우 소수점 이하의 자리수| |PopupButton|`Boolean`|팝업버튼 표시 여부| |PopupCode|`String`|팝업메뉴의 코드 집합| |PopupText|`String`|팝업메뉴의 문자열 집합| |RadioIcon|`Number`|데이터 셀내의 체크박스 계열의 이미지 모양 설정| |ZeroToReplaceChar|`String`|값이 0인 경우 대체하여 보여줄 문자 설정| - 각 속성의 상세 설명은 [InitColumns method](/docs/funcs/init/InitColumns) 를 참고 ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 컬럼 타입을 'Text'로 변경하고 입력 허용키를 숫자와 'abc' 만 허용하도록 설정 mySheet.InitCellProperty(2, 3, { 'Type': 'Text',// 필수로 설정해야 하는 속성 'AcceptKeys': 'N|[abc]' }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/InitCellProperty.html"
          },
          {
            "cid": 190,
            "sid": "IsCellModified",
            "name": "IsCellModified",
            "label": "IsCellModified",
            "data": {
              "body": "> 대상 셀의 값 변경 여부를 확인 합니다. ### Syntax ```javascript ObjId.IsCellModified(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***Boolean, 셀 값 변경여부*** ### Example ```javascript // (2, 3)셀의 값 변경 여부 확인 console.log(\"isModified:\", mySheet.IsCellModified(2, 3)); // (2, 'sDeptName')셀의 값 변경 여부 확인 console.log(\"isModified:\", mySheet.IsCellModified(2, 'sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/IsCellModified.html"
          },
          {
            "cid": 191,
            "sid": "PopupButtonImage",
            "name": "PopupButtonImage",
            "label": "PopupButtonImage",
            "data": {
              "body": "> 대상 셀의 팝업 버튼 이미지를 설정 합니다. ### Syntax ```javascript ObjId.PopupButtonImage(Row, Col, Image); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Image|`Long or String`|<span class=\"required\">필수</span>|설정할 이미지 Url 또는 이미지인덱스| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 팝업 버튼을 달력 이미지로 설정 mySheet.PopupButtonImage(2, 3, 'calendar.gif'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/PopupButtonImage.html"
          },
          {
            "cid": 192,
            "sid": "ReturnCellData",
            "name": "ReturnCellData",
            "label": "ReturnCellData",
            "data": {
              "body": "> 대상 셀의 값을 조회 당시의 값으로 되돌리는 메소드입니다. ### Syntax ```javascript ObjId.ReturnCellData(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| ### Returns ***none*** ### Example ```javascript // (2, 3)셀의 값을 최초 조회 값으로 변경 mySheet.ReturnCellData(2, 3); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/ReturnCellData.html"
          },
          {
            "cid": 193,
            "sid": "SetCellAlign",
            "name": "SetCellAlign",
            "label": "SetCellAlign",
            "data": {
              "body": "> 대상 셀의 좌우 정렬값을 설정 합니다. > 셀에 대한 설정은 컬럼에 대한 설정보다 우선적으로 적용됩니다. ### Syntax ```javascript ObjId.SetCellAlign(Row, Col, Align); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Align|`String`|<span class=\"required\">필수</span>|정렬 값| ### Enum * Align |Name|Description| |----|-----------| |Left|좌측 정렬| |Center|중앙 정렬| |Right|우측 정렬| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀을 우측 정렬 설정 처리 mySheet.SetCellAlign(2, 3, 'Right'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellAlign.html"
          },
          {
            "cid": 194,
            "sid": "SetCellBackColor",
            "name": "SetCellBackColor",
            "label": "SetCellBackColor",
            "data": {
              "body": "> 대상 셀에 배경색을 설정 합니다. ### Syntax ```javascript ObjId.SetCellBackColor(Row, Col, Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Color|`String`|<span class=\"required\">필수</span>|색상 값| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 배경색을 'red'로 설정 mySheet.SetCellBackColor(2, 3, 'red'); mySheet.SetCellBackColor(2, 3, '#ff0000'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellBackColor.html"
          },
          {
            "cid": 195,
            "sid": "SetCellCursor",
            "name": "SetCellCursor",
            "label": "SetCellCursor",
            "data": {
              "body": "> 대상 셀의 마우스 오버시 커서 모양을 설정합니다. ### Syntax ```javascript ObjId.SetCellCursor(Row, Col, Cursor); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Cursor|`String`|<span class=\"required\">필수</span>|마우스 모양 설정| ### Enum * Cursor |Name|Description| |----|-----------| |default|기본 모양| |pointer|포인터 모양 ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 마우스 커서포인터를 손가락 모양으로 변경한다. mySheet.SetCellCursor(2, 3, 'Pointer'); ``` ### Since |version|desc| |---|---| |7.0.13.60||",
              "since": "|version|desc||---|---||7.0.13.60||"
            },
            "url": "docs/funcs/cell/SetCellCursor.html"
          },
          {
            "cid": 196,
            "sid": "SetCellEditable",
            "name": "SetCellEditable",
            "label": "SetCellEditable",
            "data": {
              "body": "> 대상 셀의 편집 가능 여부 속성을 설정합니다. > 행 또는 컬럼의 인자가 올바르지 않은 경우에는 별도 처리 없이 InvalidValue를 반환 합니다. > 편집 가능으로 설정해도 Column, Row, Cell의 편집 가능 여부 설정에 따라 편집 가능 여부가 결정 됩니다. ### Syntax ```javascript ObjId.SetCellEditable(Row, Col, Edit); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Edit|`Boolean`|<span class=\"required\">필수</span>|편집 가능 여부| ### Enum * 편집 가능으로 변경할 수 없는 경우는 아래와 같습니다. `(무조건 편집 불가)` - 컬럼타입이 `Seq`, `Image`, `Status`, `Result` 인 경우 - 상태컬럼이 `삭제`인 경우 `DelCheck` 를 제외한 모든 컬럼 - `계산식(CalcLogic)` 속성이 설정되어 있는 경우 - `Editable(0)` 이 설정되어 있는 경우 - 필터행의 Pass 컬럼 타입 셀 ### Returns ***none*** ### Example ```javascript // (2, 3) 셀에 대한 편집불가 설정 mySheet.SetCellEditable(2, 3, 0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellEditable.html"
          },
          {
            "cid": 197,
            "sid": "SetCellFont",
            "name": "SetCellFont",
            "label": "SetCellFont",
            "data": {
              "body": "> 대상 셀에 폰트 스타일을 설정 합니다. ### Syntax ```javascript ObjId.SetCellFont(style, startRow, startCol, endRow, endCol, Value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |style|`String`|<span class=\"required\">필수</span>|폰트 속성 [(style 참고)](/docs/funcs/cell/GetCellFont) |startRow|`Long`|<span class=\"required\">필수</span>|영역 시작 셀의 Row Index| |startCol|`Long or String`|<span class=\"required\">필수</span>|영역 시작 셀의 Column Index 또는 SaveName| |endRow|`Long`|<span class=\"required\">필수</span>|영역 마지막 셀의 Row Index| |endCol|`Long or String`|<span class=\"required\">필수</span>|영역 마지막 셀의 Column Index 또는 SaveName| |Value|`Boolean or String`|<span class=\"required\">필수</span>|폰트속성에 설정 여부 또는 설정값| ### Returns ***none*** ### Example ```javascript // (2, 1) ~ (4, 2) 범위의 셀에 폰트 bold 적용 mySheet.SetCellFont('FontBold', 2, 1, 4, 2, 1); // (2, 1) ~ (4, 2) 범위의 셀의 폰트 사이즈를 15px로 설정 mySheet.SetCellFont('FontSize', 2, 1, 4, 2, 15); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFont.html"
          },
          {
            "cid": 198,
            "sid": "SetCellFontBold",
            "name": "SetCellFontBold",
            "label": "SetCellFontBold",
            "data": {
              "body": "> 대상 셀의 폰트에 bold 적용 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetCellFontBold(Row, Col, Bold); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Bold|`Boolean`|<span class=\"required\">필수</span>|Bold 여부| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 폰트에 bold 적용 mySheet.SetCellFontBold(2, 3, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFontBold.html"
          },
          {
            "cid": 199,
            "sid": "SetCellFontColor",
            "name": "SetCellFontColor",
            "label": "SetCellFontColor",
            "data": {
              "body": "> 대상 셀에 폰트 색상을 설정 합니다. ### Syntax ```javascript ObjId.SetCellFontColor(Row, Col, Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Color|`String`|<span class=\"required\">필수</span>|색상 값| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 폰트 색상을 'red'로 설정 mySheet.SetCellFontColor(2, 3, 'red'); mySheet.SetCellFontColor(2, 3, '#ff0000'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFontColor.html"
          },
          {
            "cid": 200,
            "sid": "SetCellFontItalic",
            "name": "SetCellFontItalic",
            "label": "SetCellFontItalic",
            "data": {
              "body": "> 대상 셀의 폰트에 italic 적용 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetCellFontItalic(Row, Col, Italic); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Italic|`Boolean`|<span class=\"required\">필수</span>|이탤릭 여부| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 폰트에 italic 적용 mySheet.SetCellFontItalic(2, 3, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFontItalic.html"
          },
          {
            "cid": 201,
            "sid": "SetCellFontName",
            "name": "SetCellFontName",
            "label": "SetCellFontName",
            "data": {
              "body": "> 대상 셀의 폰트 글꼴을 설정 합니다. ### Syntax ```javascript ObjId.SetCellFontName(Row, Col, FontName); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |FontName|`String`|<span class=\"required\">필수</span>|글자체| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 폰트 글꼴을 굴림으로 설정 mySheet.SetCellFontName(2, 3, 'Gulim'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFontName.html"
          },
          {
            "cid": 202,
            "sid": "SetCellFontSize",
            "name": "SetCellFontSize",
            "label": "SetCellFontSize",
            "data": {
              "body": "> 대상 셀의 폰트 사이즈를 설정 합니다. ### Syntax ```javascript ObjId.SetCellFontSize(Row, Col, FontSize); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |FontSize|`Integer`|<span class=\"required\">필수</span>|설정하고자 하는 글자크기`(px)`| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 폰트 사이즈를 15px로 설정 mySheet.SetCellFontSize(2, 3, 15); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFontSize.html"
          },
          {
            "cid": 203,
            "sid": "SetCellFontStrike",
            "name": "SetCellFontStrike",
            "label": "SetCellFontStrike",
            "data": {
              "body": "> 대상 셀의 폰트에 strike 적용 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetCellFontStrike(Row, Col, FontStrike); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |FontStrike|`Boolean`|<span class=\"required\">필수</span>|취소선 설정 여부| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 폰트에 strike 적용 mySheet.SetCellFontStrike(2, 3, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFontStrike.html"
          },
          {
            "cid": 204,
            "sid": "SetCellFontUnderline",
            "name": "SetCellFontUnderline",
            "label": "SetCellFontUnderline",
            "data": {
              "body": "> 대상 셀의 폰트에 underline 적용 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetCellFontUnderline(Row, Col, Underline); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Underline|`Boolean`||<span class=\"required\">필수</span>|밑줄 여부| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 폰트에 underline 적용 mySheet.SetCellFontUnderline(2, 3, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellFontUnderline.html"
          },
          {
            "cid": 205,
            "sid": "SetCellImage",
            "name": "SetCellImage",
            "label": "SetCellImage",
            "data": {
              "body": "> 대상 셀에 이미지를 설정 합니다. ### Syntax ```javascript ObjId.SetCellImage(Row, Col, Image) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Image|`String`|<span class=\"required\">필수</span>|실제 이미지 Index 또는 경로| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀에 이미지 경로 설정 mySheet.SetCellImage(2, 3, './img/dept.gif'); // (2, 3) 셀에 Index가 2인 이미지 설정 mySheet.SetCellImage(2, 3, 2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellImage.html"
          },
          {
            "cid": 206,
            "sid": "SetCellImageStyle",
            "name": "SetCellImageStyle",
            "label": "SetCellImageStyle",
            "data": {
              "body": "> 대상 셀에 좌측 또는 우측에 이미지를 설정 합니다. > 데이터 타입이 `Text, Int, Float, AutoSum` 인 경우에만 설정이 가능 합니다. ### Syntax ```javascript ObjId.SetCellImageStyle(Row, Col, Style); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Style|`Object`|<span class=\"required\">필수</span>|셀의 이미지관련 속성 객체| ### Enum * Style 객체 |Name|Type|Description| |----|-----|-----------| |Image|`String or Long`|이미지의 경로 또는 Index| |ImgAlign|`String`|이미지의 표시 위치| |ImgWidth|`Integer`|이미지의 너비| |ImgHeight|`Integer`|이미지의 높이| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 우측에 이미지 설정 mySheet.SetCellImageStyle(2, 3, { 'Image': 'test.gif', 'ImgAlign': 'Right' }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellImageStyle.html"
          },
          {
            "cid": 207,
            "sid": "SetCellText",
            "name": "SetCellText",
            "label": "SetCellText",
            "data": {
              "body": "> 대상 셀에 값을 설정 합니다. > SetCellValue와 달리 포맷이 적용된 형태의 문자열을 설정 할 수 있습니다. ### Syntax ```javascript ObjId.SetCellText(Row, Col, Text); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Text|`String`|<span class=\"required\">필수</span>|셀에 설정할 값| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀에 'ibleaders' 문자열 설정 mySheet.SetCellText(2, 3, 'ibleaders'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellText.html"
          },
          {
            "cid": 208,
            "sid": "SetCellVAlign",
            "name": "SetCellVAlign",
            "label": "SetCellVAlign",
            "data": {
              "body": "> 대상 셀의 상하 정렬값을 설정 합니다. > 셀에 대한 설정은 컬럼에 대한 설정보다 우선적으로 적용됩니다. ### Syntax ```javascript ObjId.SetCellVAlign (Row, Col, valign); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |valign|`String`|<span class=\"required\">필수</span>|셀 세로 정렬 설정값| ### Enum * valign |Name|Description| |----|----------| |Top|상단 정렬| |Middle|중앙 정렬| |Bottom|하단 정렬| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀을 상단 정렬 설정 처리 mySheet.SetCellVAlign(2, 3, 'Top'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetCellVAlign.html"
          },
          {
            "cid": 209,
            "sid": "SetCellValue",
            "name": "SetCellValue",
            "label": "SetCellValue",
            "data": {
              "body": "> 대상 셀에 값을 설정 합니다. ### Syntax ```javascript ObjId.SetCellValue(Row, Col, Value, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Value|`String`|<span class=\"required\">필수</span>|셀에 설정할 값| |Opt|`Object`|<span class=\"optional\">선택</span>|설정하고자 하는 속성 정보 객체| |Opt.event|`Boolean`|<span class=\"optional\">선택</span>|OnChange 이벤트 발생 여부 (Default: 1)| |Opt.endEdit|`Boolean`|<span class=\"optional\">선택</span>|편집 종료 여부 (Default: 1)| |Opt.nocalc|`Boolean`|<span class=\"optional\">선택</span>|소계/누계/합계 재계산 여부 (Default: 0)| ### Returns ***none*** ### Example ```javascript //상태 셀을 \"삭제\" 상태로 설정 mySheet.SetCellValue(1, 0, \"D\"); //CheckBox에 체크되도록 설정 mySheet.SetCellValue(1, 1, 1); //숫자 셀에 값 설정, 표시되는 값은 12,345임 mySheet.SetCellValue(1, 2, 12345); //콤보 셀에 값 설정, 표시되는 값은 콤보 텍스트 임 mySheet.SetCellValue(1, 3, \"01\"); //날짜 셀에 값 설정, 표시되는 값은 \"2011/07/15\" 임 mySheet.SetCellValue(1, 4, \"2011/07/15\"); //소수점 숫자 셀에 값 설정, 소수점 3자리이면 표시되는 값은 123.450 임 // OnChange 이벤트 발생 mySheet.SetCellValue(1,5, 123.450); // OnChange 이벤트 발생하지 않음 mySheet.SetCellValue(1,5, 123.450, 0); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.102|Opt 인자 구조 변경. event, endEdit, nocalc 인자 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.102|Opt 인자 구조 변경. event, endEdit, nocalc 인자 속성 추가|"
            },
            "url": "docs/funcs/cell/SetCellValue.html"
          },
          {
            "cid": 210,
            "sid": "SetHtmlHeaderValue",
            "name": "SetHtmlHeaderValue",
            "label": "SetHtmlHeaderValue",
            "data": {
              "body": "> 헤더의 HTML 타입을 적용합니다. > 해당 셋팅값은 GetCellValue 시에 확인할수 없으며, 기존 HeaderText 값이 반환됩니다. > 설정된 태그값을 확인하기 위해서는 [GetHtmlHeaderValue](/docs/funcs/cell/GetHtmlHeaderValue) 메소드를 통해 확인해야 합니다. > `주의` HTML 태그가 설정된 헤더셀은 헤더 소트가 적용되지 않습니다. ### Syntax ```javascript ObjId. SetHtmlHeaderValue(Row, Col, Value, HeaderType); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Value|`String`|<span class=\"required\">필수</span>|셀의 값| |HeaderType|`boolean`|<span class=\"optional\">선택</span>|0 : Html 타입 (`Default`), 1 : 기존 Text| ### Returns ***none*** ### Example ```javascript // (0, 0) 셀의 타입을 HTML로 바꾸며 값을 checkbox로 변경한다. mySheet.SetHtmlHeaderValue(0, 0, '< input type=checkbox >'); ``` ### Since |version|desc| |---|---| |7.0.13.68|기능 추가|",
              "since": "|version|desc||---|---||7.0.13.68|기능 추가|"
            },
            "url": "docs/funcs/cell/SetHtmlHeaderValue.html"
          },
          {
            "cid": 211,
            "sid": "SetMaximumValue",
            "name": "SetMaximumValue",
            "label": "SetMaximumValue",
            "data": {
              "body": "> 대상 셀의 입력 최대 값을 설정 합니다. > 데이터 타입이 `Int, Float, AutoSum` 인 경우에만 설정이 가능 합니다. ### Syntax ```javascript ObjId.SetMaximumValue(Row, Col, Value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Value|`Long`|<span class=\"required\">필수</span>|설정할 최대값| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 입력 최대 값을 1000 으로 설정 mySheet.SetMaximumValue(2, 3, 1000); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetMaximumValue.html"
          },
          {
            "cid": 212,
            "sid": "SetMinimumValue",
            "name": "SetMinimumValue",
            "label": "SetMinimumValue",
            "data": {
              "body": "> 대상 셀의 입력 최소 값을 설정 합니다. > 데이터 타입이 `Int, Float, AutoSum` 인 경우에만 설정이 가능 합니다. ### Syntax ```javascript ObjId.SetMinimumValue(Row, Col, Value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |Value|`Long`|<span class=\"required\">필수</span>|설정할 최소값| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀의 입력 최소 값을 10 으로 설정 mySheet.SetMinimumValue(2, 3, 10); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetMinimumValue.html"
          },
          {
            "cid": 213,
            "sid": "SetToolTipText",
            "name": "SetToolTipText",
            "label": "SetToolTipText",
            "data": {
              "body": "> 대상 셀에 툴팁 문자열을 설정 합니다. ### Syntax ```javascript ObjId.SetToolTipText(Row, Col, ToolTip); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|해당 셀의 Column Index 또는 SaveName| |ToolTip|`String`|<span class=\"required\">필수</span>|풍선 도움말 설정 값| ### Returns ***none*** ### Example ```javascript // (2, 3)셀에 툴팁을 'my tooltip' 문자열로 설정 mySheet.SetToolTipText(2, 3, 'my tooltip'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/SetToolTipText.html"
          },
          {
            "cid": 214,
            "sid": "_isFocusedCell",
            "name": "_isFocusedCell",
            "label": "_isFocusedCell",
            "data": {
              "body": "> 대상 셀이 현재 포커스되어 있는지 여부를 반환합니다. ### Syntax ```javascript ObjId._isFocusedCell(row, col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |row|`object`|<span class=\"required\">필수</span>|행 객체| |col|`string`|<span class=\"required\">필수</span>|컬럼명| ### Returns ***boolean, 포커스 여부*** ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/cell/_isFocusedCell.html"
          }
        ]
      },
      {
        "gid": 3,
        "name": "funcs-col",
        "label": "col",
        "children": [
          {
            "cid": 215,
            "sid": "CheckAll",
            "name": "CheckAll",
            "label": "CheckAll",
            "data": {
              "body": "> `DelCheck, CheckBox, DummyCheck` 타입의 컬럼에 대한 전체 체크 설정 또는 해제 처리를 합니다. > 처리를 완료 하면 각 데이터 행 단위로 [OnChange](/docs/event/OnChange)이벤트가 발생합니다. ### Syntax ```javascript ObjId.CheckAll(Col, Value, [OnChangeEvent]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Value|`Integer`|<span class=\"required\">필수</span>|- `0` : 전체체크 해제 - `1` : 전체체크 - `그외` : 이전값 반대| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |OnChangeEvent|`Boolean`|<span class=\"optional\">선택</span>|OnChange 이벤트 발생 여부 (Default :1)| ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼에 대한 전체 체크 처리 mySheet.CheckAll(3, 1); // Index가 3인 컬럼에 대한 현재 값 토글 처리 mySheet.CheckAll(3, 2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/CheckAll.html"
          },
          {
            "cid": 216,
            "sid": "CheckReverse",
            "name": "CheckReverse",
            "label": "CheckReverse",
            "data": {
              "body": "> 대상 컬럼의 체크 값을 토글 처리 합니다. ### Syntax ```javascript ObjId.CheckReverse(Col, [Editable], [Event]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |Editable|`Boolean`|<span class=\"optional\">선택</span>|편집가능 불가능을 확인하여 편집가능일때만 변경. (Default :0)| |Event|`Boolean`|<span class=\"optional\">선택</span>|체크가 바뀔때 OnChange 이벤트를 발생할것인가 여부. (Default :0)| ### Returns ***none*** ### Example ```javascript // 1컬럼의 체크를 반전한다. mySheet.CheckReverse(1); // Edit를 체크하고, Event를 발생시킨다. mySheet.CheckReverse(1, 1, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/CheckReverse.html"
          },
          {
            "cid": 217,
            "sid": "CheckedRows",
            "name": "CheckedRows",
            "label": "CheckedRows",
            "data": {
              "body": "> 대상 컬럼에 체크되어있는 행의 개수를 확인 합니다. > `주의` opt 의 RowLevel, ParentRow 속성을 동시에 설정 할 수 없습니다. 두 속성 모두 설정된 경우 `ParentRow` 설정을 우선적으로 처리 합니다. ### Syntax ```javascript ObjId.CheckedRows(Col, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |Opt|`Object`|<span class=\"optional\">선택</span>|처리 옵션| |Opt.RowLevel|`Number`|<span class=\"optional\">선택</span>|처리 대상 트리 레벨 (Default :0)| |Opt.ParentRow|`Number`|<span class=\"optional\">선택</span>|처리 대상 부모 행의 Index| |Opt.Recursive|`Boolean`|<span class=\"optional\">선택</span>|하위 노드에 대한 재귀 처리 여부 (Default :1)| ### Returns ***Long, 특정 컬럼에 체크된 행의 개수*** ### Example ```javascript var cnt1 = mySheet.CheckedRows(1); console.log(\"체크된 행의 개수는 \", cnt1, \"개 입니다.\"); var cnt2 = mySheet.CheckedRows(\"chkData\"); console.log(\"체크된 행의 개수는 \", cnt2, \"개 입니다.\"); // 트리기준 컬럼의 체크박스에 대한 사용 // 트리 레벨이 2인 행 가운데 체크된 개수 확인 var res = mySheet.CheckedRows(1, {RowLevel:2, Recursive:0}); // Index가 5인 행의 자식행 가운데 체크된 개수 확인 var arRes = mySheet.CheckedRows (1, {ParentRow:5, Recursive:1}); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.9.0|트리 구조의 트리체크에 대한 처리 지원 (RowLevel, ParaenRow 속성 인자 추가)|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.9.0|트리 구조의 트리체크에 대한 처리 지원 (RowLevel, ParaenRow 속성 인자 추가)|"
            },
            "url": "docs/funcs/col/CheckedRows.html"
          },
          {
            "cid": 218,
            "sid": "ColDelete",
            "name": "ColDelete",
            "label": "ColDelete",
            "data": {
              "body": "> 컬럼을 동적으로 삭제 합니다. > col 인자를 설정하지 않은 경우 가장 마지막에 위치한 컬럼을 삭제 합니다. > 다음의 조건에 해당 하는 컬럼인 경우에는 삭제가 불가능합니다. - 컬럼의 데이터 타입이 Seq, Status, DelCheck 인 경우 - 다른 컬럼의 계산식(CalcLogic)에 사용되는 컬럼인 경우 - 트리 기준 컬럼(TreeCol 속성 설정이 있는 컬럼)인 경우 - 단위데이터행 구조의 FixedMerge에 포함된 컬럼인 경우 ### Syntax ```javascript ObjId.ColDelete(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"optional\">선택</span>|대상 컬럼의 Index 또는 SaveName (Default: 마지막 컬럼 Index)| ### Returns ***none*** ### Example ```javascript // Index값이 3인 컬럼을 삭제 한다. mySheet.ColDelete(3); // 마지막 컬럼을 삭제 한다. mySheet.ColDelete(); // SaveName이 \"sText\"인 컬럼을 삭제 한다. mySheet.ColDelete(\"sText\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/ColDelete.html"
          },
          {
            "cid": 219,
            "sid": "ColInsert",
            "name": "ColInsert",
            "label": "ColInsert",
            "data": {
              "body": "> 컬럼을 동적으로 생성 합니다. > Pos 속성을 설정하지 않은 경우 가장 마지막에 컬럼이 생성 됩니다. > 컬럼타입이 `Seq, Status, DelCheck`인 컬럼은 생성이 불가능 하며 컬럼생성시 `CalcLogic` 속성은 사용이 불가능합니다. > 생성할 컬럼의 설정 속성 집합 객체는 [InitColumns](/docs/funcs/init/InitColumns) Method의 내용을 참조 > 컬럼의 설정 속성을 설정하지 않은 경우 `Text` 타입의 컬럼으로 생성 됩니다. ### Syntax ```javascript ObjId.ColInsert([Info]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Info.Pos|`Number or String`|<span class=\"optional\">선택</span>|생성할 위치의 컬럼 Index 또는 SaveName(Default: 마지막 컬럼)| |Info.Header.<bi>Text|`String`|<span class=\"optional\">선택</span>|헤더에 설정할 문자열 (헤더가 2줄이상인 경우 구분자 `\"|\"`로 연결한 문자열로 설정) (Default: \"\")| |Info.Header.<bi>Align|`String`|<span class=\"optional\">선택</span>|헤더 문자열의 정렬값 (Default: \"Center\")| |Info.Col|`Object`|<span class=\"optional\">선택</span>|생성할 컬럼의 설정 속성 집합 객체| ### Returns ***none*** ### Example ```javascript // 마지막 위치에 기본(\"Text\" 컬럼타입) 컬럼을 생성. var info = { Header : {Text : \"기본타입\"} }; mySheet.ColInsert(info); // Index 3의 위치에 \"CheckBox\" 타입의 컬럼을 생성. var info = { Pos:3, Header:{Text: \"체크박스\",Align: \"Left\"}, Col:[{ Type: \"CheckBox\", Width:60, SaveName: \"sCheckBox\" }] }; mySheet.ColInsert(info); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/ColInsert.html"
          },
          {
            "cid": 220,
            "sid": "ColLeft",
            "name": "ColLeft",
            "label": "ColLeft",
            "data": {
              "body": "> 컬럼의 왼쪽 위치를 확인합니다. ### Syntax ```javascript ObjId.ColLeft(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Long, 특정컬럼 왼쪽 위치 값*** ### Example ```javascript //컬럼의 왼쪽 위치를 파악 var iLeft = mySheet.ColLeft(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/ColLeft.html"
          },
          {
            "cid": 221,
            "sid": "ColSaveName",
            "name": "ColSaveName",
            "label": "ColSaveName",
            "data": {
              "body": "> 특정 컬럼 Index에 해당하는 [InitColumns](/docs/funcs/init/InitColumns) 함수에서 설정한 SaveName을 확인합니다. ### Syntax ```javascript ObjId.ColSaveName(DataRow, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DataRow|`Number`|<span class=\"required\">필수</span>|단위 데이터행의 Index| |Col|`Long`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index| ### Returns ***none*** ### Example ```javascript //컬럼의 SaveName을 가져옴 var sSaveName = mySheet.ColSaveName(0, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/ColSaveName.html"
          },
          {
            "cid": 222,
            "sid": "ColValueDup",
            "name": "ColValueDup",
            "label": "ColValueDup",
            "data": {
              "body": "> 단일 또는 다중 컬럼에 대한 중복 데이터 존재 여부를 확인 합니다. > 중복된 데이터가 없는 경우는 -1를 반환 하고, 중복된 데이터가 있는 경우 첫번째 중복 데이터 행의 Index를 반환 합니다. ### Syntax ```javascript ObjId.ColValueDup(Cols, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Cols|`Long or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |Opt|`Object`|<span class=\"optional\">선택</span>|옵션 정보| |Opt.CaseSensitive|`Boolean`|<span class=\"optional\">선택</span>|대/소문자 구분 비교 여부 (Default: 1)| |Opt.IncludeDelRow|`Boolean`|<span class=\"optional\">선택</span>|트랜잭션 상태가 삭제인 행을 포함 여부 (Default: 1)| |Opt.IncludeSumRow|`Boolean`|<span class=\"optional\">선택</span>|합계/소계/누계 행 포함 여부 (Default: 1)| |Opt.IncludeEmpty|`Boolean`|<span class=\"optional\">선택</span>|빈값 포함 여부 (Default: 1)| ### Returns ***Number, 중복 행의 Index*** ### Example ```javascript //1컬럼에 중복된 값이 존재하는 행의 Index 확인 var Row = mySheet.ColValueDup(\"1\"); //2,3,7 컬럼에 중복된 값이 존재하는 행의 Index 확인 var Row = mySheet.ColValueDup(\"2|3|7\"); //삭제된 행과 빈값을 제외하고 중복 체크하기 var Row = mySheet.ColValueDup(\"2|3|7\",{ \"IncludeDelRow\" : 0, \"IncludeEmpty\" : 0 }); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.12.3|인자 구조 변경, IncludeEmpty 인자 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.12.3|인자 구조 변경, IncludeEmpty 인자 속성 추가|"
            },
            "url": "docs/funcs/col/ColValueDup.html"
          },
          {
            "cid": 223,
            "sid": "ColumnSort",
            "name": "ColumnSort",
            "label": "ColumnSort",
            "data": {
              "body": "> 단일 또는 다중 컬럼에 대한 데이터 정렬을 처리 합니다. > `col` 인자에 2개 이상의 컬럼을 구분자로 연결한 문자열로 구성한 경우 다중컬럼에 대한 정렬 처리를 합니다. > `colSortOrder` 인자 설정시 컬럼 순서와 매칭되어 설정 해야 합니다. > 특정 컬럼에 매칭 되는 문자열이 빈 값인 경우 `sortOrder` 인자에 설정한 기본 정렬방식으로 처리 합니다. > `keepColOrder` 를 설정하지 않거나 0으로 설정한 경우 col 인자 설정 순서와 상관없이 설정한 컬럼의 Index 순으로 처리하게 되며, true로 설정시 col 인자 순서에 준하여 처리 됩니다. > `col` 인자를 빈값으로 설정하는 경우 기존 처리된 컬럼 정렬을 모두 초기화 합니다. > `주의` 소계행이 존재할 때, 단일 컬럼에 대해 사용 가능하며 다중 컬럼 소트는 지원하지 않습니다. ### Syntax ```javascript ObjId.ColumnSort(Col, Sort, ColSort, KeepColOrder); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|소트할 컬럼의 Column Index 또는 SaveName을 `|`로 조합한 문자열| |Sort|`String`|<span class=\"optional\">선택</span>|\"ASC\" 또는 \"DESC\" (Default: \"ASC\")| |ColSort|`String`|<span class=\"optional\">선택</span>|각 컬럼의 소트 방향을 `|`로 연결한 문자열 (Default: \"\")| |KeepColOrder|`Boolean`|<span class=\"optional\">선택</span>|Cols파라미터에서 지정된 순서대로 소트할 것인지 선택 (Default: 0)| ### Returns ***none*** ### Example ```javascript //기존에 설정된 ColumnSort 초기화 mySheet.ColumnSort(\"\"); //6컬럼만 내림차순으로 정렬 mySheet.ColumnSort(\"6\", \"DESC\") //4컬럼을 중심으로 먼저 오름차순 정렬하고, 그 안에서 5컬럼 오름차순 정렬 mySheet.ColumnSort(\"4|5\") //2,3,4컬럼 순서로 정렬하고, 내림차순으로 정렬 mySheet.ColumnSort(\"2|3|4\", \"DESC\"); //3,2,4컬럼을 2,3,4컬럼인덱스 순서대로 내림차순, 오름차순, 오름차순으로 정렬 mySheet.ColumnSort(\"3|2|4\", \"DESC\",\"ASC|DESC|ASC\"); //3,2,4컬럼을 3,2,4컬럼 지정된 순서대로 오름차순, 내림차순, 오름차순으로 정렬 mySheet.ColumnSort(\"3|2|4\", \" DESC \",\"ASC|DESC|ASC\", 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/ColumnSort.html"
          },
          {
            "cid": 224,
            "sid": "FitColWidth",
            "name": "FitColWidth",
            "label": "FitColWidth",
            "data": {
              "body": "> 각 컬럼 너비를 인자로 설정한 비율 단위로 설정하거나 시트의 전체 너비에 맞게 비율 기준으로 재 설정 합니다. > ratio 인자를 설정하지 않은 경우 모든 컬럼의 너비 합이 시트의 너비에 맞게 현재의 비율로 재설정 되며, ratio 인자를 설정한 경우 해당 비율로 재설정 됩니다. ### Syntax ```javascript ObjId.FitColWidth(ratio); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |ratio|`String`|<span class=\"optional\">선택</span>|컬럼별 너비 비율을 구분자 `|`로 연결한 문자열| ### Returns ***none*** ### Example ```javascript // 컬럼들의 현재의 너비 비율을 유지하며 시트 너비에 맞게 재설정 처리 mySheet.FitColWidth(); // 시트전체 너비를 기준으로 첫번째 컬럼부터 10%, 20%, 10%, 30% 의 너비 비율로 재설정 처리 mySheet.FitColWidth('10|20|10|30'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/FitColWidth.html"
          },
          {
            "cid": 225,
            "sid": "FitSizeCol",
            "name": "FitSizeCol",
            "label": "FitSizeCol",
            "data": {
              "body": "> 대상 컬럼의 너비를 컬럼 내의 가장 넓은 글자의 너비에 맞게 재조정 합니다. > 재조정의 범위는 전역속성 [FitSizeColMode](/docs/props/PropertyList/FitSizeColMode) 설정을 따릅니다. ### Syntax ```javascript ObjId.FitSizeCol(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|대상 컬럼의 Index 또는 SaveName| ### Returns ***none*** ### Example ```javascript //SaveName 이 \"sTarget\"인 컬럼에 대한 처리 mySheet.FitSizeCol(\"sTarget\"); ``` ### Since |version|desc| |---|---| |7.0.4.0||",
              "since": "|version|desc||---|---||7.0.4.0||"
            },
            "url": "docs/funcs/col/FitSizeCol.html"
          },
          {
            "cid": 226,
            "sid": "GetColBackColor",
            "name": "GetColBackColor",
            "label": "GetColBackColor",
            "data": {
              "body": "> 대상 컬럼의 배경색을 확인 합니다. > 대상 컬럼에 배경색 설정이 없는 경우 ''으로 반환 하고, 설정이 있는 경우 WebColor 16진수 표기법 문자열로 반환 합니다. ### Syntax ```javascript ObjId.GetColBackColor(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***none*** ### Example ```javascript // 2컬럼 배경색을 확인한다. mySheet.GetColBackColor(2); //SaveName이 sa_Name 인 컬럼의 배경색을 확인한다. mySheet.GetColBackColor(\"sa_Name\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColBackColor.html"
          },
          {
            "cid": 227,
            "sid": "GetColCondProperty",
            "name": "GetColCondProperty",
            "label": "GetColCondProperty",
            "data": {
              "body": "> 대상 컬럼의 조건에 따른 스타일 설정에 대한 조건 값을 확인 합니다. ### Syntax ```javascript ObjId.GetColCondProperty(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***String, 설정한 조건*** ### Example ```javascript // Index가 3인 컬럼의 조건 값 확인 console.log(\"cond:\", mySheet.GetColCondProperty(3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColCondProperty.html"
          },
          {
            "cid": 228,
            "sid": "GetColEditable",
            "name": "GetColEditable",
            "label": "GetColEditable",
            "data": {
              "body": "> 대상 컬럼의 편집 가능 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetColEditable(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Boolean, Edit 가능 여부*** ### Example ```javascript //Index가 5인 컬럼의 Edit 가능 여부를 확인 mySheet. GetColEditable (5); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColEditable.html"
          },
          {
            "cid": 229,
            "sid": "GetColFontBold",
            "name": "GetColFontBold",
            "label": "GetColFontBold",
            "data": {
              "body": "> 대상 컬럼의 폰트에 bold 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetColFontBold(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Boolean, Bold 설정 값*** ### Example ```javascript //인덱스가 1인 컬럼에 Bold 설정여부를 확인 console.log(mySheet.GetColFontBold(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColFontBold.html"
          },
          {
            "cid": 230,
            "sid": "GetColFontColor",
            "name": "GetColFontColor",
            "label": "GetColFontColor",
            "data": {
              "body": "> 대상 컬럼의 폰트 색상을 확인 합니다. > 대상 컬럼에 폰트 색상 설정이 없는 경우 ''으로 반환 하고, 설정이 있는 경우 WebColor 16진수 표기법 문자열로 반환 합니다. ### Syntax ```javascript ObjId.GetColFontColor(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***String, 설정된 색상값*** ### Example ```javascript // index가 2인 컬럼의 글자색을 확인 console.log(mySheet.GetColFontColor(2)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColFontColor.html"
          },
          {
            "cid": 231,
            "sid": "GetColFontUnderline",
            "name": "GetColFontUnderline",
            "label": "GetColFontUnderline",
            "data": {
              "body": "> 대상 컬럼의 폰트에 underline 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetColFontUnderline(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Boolean, underline 적용 여부*** ### Example ```javascript //컬럼 전체 글자에 언더라인 설정여부를 확인 console.log(mySheet.GetColFontUnderline(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColFontUnderline.html"
          },
          {
            "cid": 232,
            "sid": "GetColHidden",
            "name": "GetColHidden",
            "label": "GetColHidden",
            "data": {
              "body": "> 대상 컬럼의 숨김 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetColHidden(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Boolean, 컬럼의 숨김여부*** ### Example ```javascript //해당 컬럼이 숨겨졌는지 확인 var isHide = mySheet.GetColHidden(12); var isHide2 = mySheet.GetColHidden(\"sa_Personal_Id\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColHidden.html"
          },
          {
            "cid": 233,
            "sid": "GetColMaxValue",
            "name": "GetColMaxValue",
            "label": "GetColMaxValue",
            "data": {
              "body": "> 해당 컬럼의 최대값을 가져옵니다. > `주의` 숫자타입(Int, Float, AutoSum)의 컬럼만 지원합니다. ### Syntax ```javascript ObjId.GetColMaxValue(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Number, 해당 컬럼의 최대값*** ### Example ```javascript // Index가 3인 컬럼의 최대값을 가져온다. mySheet.GetColMaxValue(3); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColMaxValue.html"
          },
          {
            "cid": 234,
            "sid": "GetColMinValue",
            "name": "GetColMinValue",
            "label": "GetColMinValue",
            "data": {
              "body": "> 해당 컬럼의 최소값을 가져옵니다. > `주의` 숫자타입(Int, Float, AutoSum)의 컬럼만 지원합니다. ### Syntax ```javascript ObjId.GetColMinValue(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Number, 해당 컬럼의 최소값*** ### Example ```javascript // Index가 1인 컬럼의 최소값을 가져온다. mySheet.GetColMinValue(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColMinValue.html"
          },
          {
            "cid": 235,
            "sid": "GetColSortInfo",
            "name": "GetColSortInfo",
            "label": "GetColSortInfo",
            "data": {
              "body": "> 컬럼의 Sort 정보를 반환 합니다. ### Syntax ```javascript ObjId.GetColSortInfo(); ``` ### Returns Info |Parameter|Type|Description| |---------|----|-----------| |result|`Array<Object>`|Sort 정보 객체의 배열 집합| |result[ ].Col|`Long or String`|컬럼의 Index(단위데이터행 구조인 경우 SaveName)| |result[ ].SortOrder|`String`|Sort 처리 방법 (asc : 오름 차순 정렬, desc : 내림 차순 정렬)| ### Returns ***Object[ ], 컬럼별 Sort 정보 객체의 배열 집합*** ### Example ```javascript // 현재의 Sort 정보 확인 console.log('sortInfo: ', mySheet.GetColSortInfo()); ``` ### Since |version|desc| |---|---| |7.0.13.22||",
              "since": "|version|desc||---|---||7.0.13.22||"
            },
            "url": "docs/funcs/col/GetColSortInfo.html"
          },
          {
            "cid": 236,
            "sid": "GetColWidth",
            "name": "GetColWidth",
            "label": "GetColWidth",
            "data": {
              "body": "> 대상 컬럼의 너비를 확인 합니다. > 픽셀 단위의 너비를 설정할 수 있고, 값을 0으로 설정하면 해당 컬럼 내의 Text 중 가장 긴 값에 맞게 너비를 자동 조정합니다. > 컬럼이 존재하지 않는 경우 에러메시지는 표시하지 않지만 처리는 취소 됩니다. ### Syntax ```javascript ObjId.GetColWidth(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***Integer, 특정컬럼의 너비 픽셀 값*** ### Example ```javascript // Index가 3인 컬럼의 너비 확인 console.log(\"colWidth:\", mySheet.GetColWidth(3)); // SaveName이 'sDeptName'인 컬럼의 너비 확인 console.log(\"colWidth:\", mySheet.GetColWidth('sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetColWidth.html"
          },
          {
            "cid": 237,
            "sid": "GetCurrentColInfo",
            "name": "GetCurrentColInfo",
            "label": "GetCurrentColInfo",
            "data": {
              "body": "> 현재 컬럼들의 위치, 숨김, 너비 정보를 확인합니다. > 반환되는 값은 헤더 메뉴에 있는 localStorage 에 저장되는 정보와 동일합니다. > localStorage 에 저장하지 않고 그 외의 저장소에 저장하여 관리 하는 경우에 사용합니다. ### Syntax ```javascript ObjId.GetCurrentColInfo(); ``` ### Info ***none*** ### Returns ***String 현재 컬럼들의 숨김, 너비, 위치 정보 값*** ### Example ```javascript // 현재 컬럼들의 정보를 확인 한다. console.log(\"colInfo:\", mySheet.GetCurrentColInfo()); ``` ### Since |version|desc| |---|---| |7.0.13.30||",
              "since": "|version|desc||---|---||7.0.13.30||"
            },
            "url": "docs/funcs/col/GetCurrentColInfo.html"
          },
          {
            "cid": 238,
            "sid": "GetExtendLastCol",
            "name": "GetExtendLastCol",
            "label": "GetExtendLastCol",
            "data": {
              "body": "> 마지막 컬럼의 너비를 전체 너비에 맞게 자동으로 맞출것인지 여부를 확인합니다. ### Syntax ```javascript ObjId.GetExtendLastCol(); ``` ### Info ***none*** ### Returns ***Boolean, 확장 설정 여부 값*** ### Example ```javascript // ExtendLastCol 적용 값 확인 console.log(\"extendLastCol:\", mySheet.GetExtendLastCol()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetExtendLastCol.html"
          },
          {
            "cid": 239,
            "sid": "GetFrozenCol",
            "name": "GetFrozenCol",
            "label": "GetFrozenCol",
            "data": {
              "body": "> 좌측 고정컬럼 개수를 확인 합니다. ### Syntax ```javascript ObjId.GetFrozenCol(); ``` ### Info ***none*** ### Returns ***Integer, 좌측 고정컬럼 개수*** ### Example ```javascript // 좌측 고정컬럼 개수 확인 console.log(\"forzenCols:\", mySheet.GetFrozenCol()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetFrozenCol.html"
          },
          {
            "cid": 240,
            "sid": "GetLeftCol",
            "name": "GetLeftCol",
            "label": "GetLeftCol",
            "data": {
              "body": "> 시트의 가장 좌측에 위치하고 있는 컬럼의 Index를 확인 합니다. > 고정 컬럼 설정이 있는 경우 고정 컬럼 영역 이후의 컬럼의 Index를 반환 합니다. ### Syntax ```javascript ObjId.GetLeftCol(); ``` ### Info ***none*** ### Returns ***Number, 컬럼의 Index*** ### Example ```javascript // 시트의 좌측에 위치한 컬럼의 Index 확인 console.log(\"leftCol:\", mySheet.GetLeftCol()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/GetLeftCol.html"
          },
          {
            "cid": 241,
            "sid": "LastCol",
            "name": "LastCol",
            "label": "LastCol",
            "data": {
              "body": "> 마지막 컬럼의 index를 반환합니다. ### Syntax ```javascript ObjId.LastCol(); ``` ### Info ***none*** ### Returns ***Number, 마지막 컬럼의 Index*** ### Example ```javascript // 마지막 컬럼의 Index 확인 console.log(\"lastColIndex:\", mySheet.LastCol()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/LastCol.html"
          },
          {
            "cid": 242,
            "sid": "MouseCol",
            "name": "MouseCol",
            "label": "MouseCol",
            "data": {
              "body": "> 마우스가 위치한 셀의 컬럼 Index를 확인합니다. > 데이터 영역이 아닌 경우는 –1을 반환합니다. ### Syntax ```javascript ObjId.MouseCol(); ``` ### Info ***none*** ### Returns ***Number, 마우스가 위치한 컬럼의 Index*** ### Example ```javascript // 마우스 이동시 해당 위치의 컬럼 Index 확인 function mySheet_OnMouseMove(button, shift, x, y) { console.log(\"MouseColIndex:\", mySheet.MouseCol()); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/MouseCol.html"
          },
          {
            "cid": 243,
            "sid": "MoveColumnFail",
            "name": "MoveColumnFail",
            "label": "MoveColumnFail",
            "data": {
              "body": "> 컬럼 이동 처리에 대한 취소 처리 여부를 설정합니다. > `참고` [OnBeforeColumnMove](/docs/event/OnBeforeColumnMove) 이벤트 내애서만 설정이 가능 하며, 실패 설정시 컬럼 이동은 처리 되지 않습니다. ### Syntax ```javascript ObjId.MoveColumnFail(Flag); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Flag|`Boolean`|<span class=\"required\">필수</span>|컬럼 이동 실패 여부| ### Returns ***none*** ### Example ```javascript // Index가 0인 컬럼을 Index가 3 이후의 위치로 이동시 취소 처리 function mySheet_OnBeforeColumnMove(col, newPos) { if (col == 0 && newPos > 3) { mySheet.MoveColumnFail(1); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/MoveColumnFail.html"
          },
          {
            "cid": 244,
            "sid": "MoveColumnPos",
            "name": "MoveColumnPos",
            "label": "MoveColumnPos",
            "data": {
              "body": "> 특정 컬럼을 새로운 컬럼 위치로 이동 시킵니다. > Event 인자를 1로 설정한 경우 [OnBeforeColumnMove](/docs/event/OnBeforeColumnMove) Event와 [OnAfterColumnMove](/docs/event/OnAfterColumnMove) Event가 발생하여 OnBeforeColumnMove Event 에서 처리할수 있는 컬럼 이동 취소 기능을 처리 할 수 있습니다. > 0으로 설정할 경우 이벤트 없이 컬럼을 이동시킵니다. 다중 컬럼의 경우 `|` 문자를 구분자로 이어서 인자를 생성합니다. ### Syntax ```javascript ObjId.MoveColumnPos(Col, NewPos, [Event]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|이동할 컬럼의 Index 또는 SaveName| |NewPos|`Long or String`|<span class=\"required\">필수</span>|이동될 위치의 컬럼 Index 또는 SaveName| Event|`Boolean`|<span class=\"optional\">선택</span>|이동되면서 발생하는 이벤트인 OnBeforeColumnMove Event와 OnAfterColumn Event를 발생시킬지 여부 (Default :1)| ### Returns ***Boolean, 이동 처리 성공 여부*** ### Example ```javascript // Index가 3인 컬럼을 Index가 6인 컬럼의 위치로 이동 처리 mySheet.MoveColumnPos(3, 6); // Index가 1,2인 컬럼들을 Index가 7인 컬럼의 위치로 이동 처리 mySheet.MoveColumnPos(\"1|2\", \"7|7\"); //각 컬럼의 SaveName으로 설정한 경우 mySheet.MoveColumnPos(\"stockNm\", \"payAmt\"); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.117|다중 컬럼 이동 지원|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.117|다중 컬럼 이동 지원|"
            },
            "url": "docs/funcs/col/MoveColumnPos.html"
          },
          {
            "cid": 245,
            "sid": "ReturnColumnPos",
            "name": "ReturnColumnPos",
            "label": "ReturnColumnPos",
            "data": {
              "body": "> 이동된 컬럼의 위치를 처음 위치로 되돌립니다. ### Syntax ```javascript ObjId.ReturnColumnPos(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript //컬럼의 위치 초기화 처리 mySheet.ReturnColumnPos(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/ReturnColumnPos.html"
          },
          {
            "cid": 246,
            "sid": "SaveNameCol",
            "name": "SaveNameCol",
            "label": "SaveNameCol",
            "data": {
              "body": "> [InitColumns](/docs/funcs/init/InitColumns)에서 설정된 SaveName을 이용하여 해당하는 컬럼 번호를 확인합니다. > SaveName에 해당하는 컬럼이 존재하지 않는 경우 –1을 반환합니다. ### Syntax ```javascript ObjId.SaveNameCol(SaveName); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |SaveName|`String`|<span class=\"required\">필수</span>|저장 변수명| ### Returns ***Number, 컬럼의 Index*** ### Example ```javascript // SaveName이 'sDeptName'인 컬럼의 Index 확인 console.log(\"colIndex:\", mySheet.SaveNameCol('sDeptName')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SaveNameCol.html"
          },
          {
            "cid": 247,
            "sid": "SetColBackColor",
            "name": "SetColBackColor",
            "label": "SetColBackColor",
            "data": {
              "body": "> 대상 컬럼의 배격색을 설정 합니다. > 적용 범위는 헤더, 합계, 소계, 누계행을 제외한 데이터행 영역에 대하여 처리 합니다. > color 인자 값이 빈값인 경우 이전 설정을 초기화 합니다. > 2개행 이상의 단위데이터행 구조인 경우 Col 인자에 Index를 설정할 경우 모든행에 대해서 처리를 하고, SaveName으로 설정할 경우 해당 SaveName인 행에 대해서만 처리 합니다. ### Syntax ```javascript ObjId.SetColBackColor(Col, Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |Color|`String`|<span class=\"required\">필수</span>|WebColor 색상 값| ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼의 배경색을 red 로 설정 mySheet.SetColBackColor(3, 'red'); // WebColor 표준명 mySheet.SetColBackColor(3, '#ff0000'); // WebColor 16진수 표기법 mySheet.SetColBackColor(3, '#f00'); // WebColor 16진수 약식 표기법 mySheet.SetColBackColor(3, 'rgb(255, 0, 0)'); // WebColor RGB 표기법 //SaveName이 \"sa_DistQty\"인컬럼 배경색을 설정 mySheet.SetColBackColor(\"sa_DistQty\",\"#FFDDDD\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetColBackColor.html"
          },
          {
            "cid": 248,
            "sid": "SetColCondProperty",
            "name": "SetColCondProperty",
            "label": "SetColCondProperty",
            "data": {
              "body": "> 대상 컬럼의 조건에 따른 스타일을 설정 합니다. > `주의` Int, Float, AutoSum 과 같이 Number 형태의 데이터 타입인 경우에만 설정이 가능 합니다. > cond 인자 설정은 결과가 boolean형태로 반환되로록 설정하여야 하며 비교값은 `%d`를 사용합니다. ### Syntax ```javascript ObjId.SetColCondProperty(Col, Cond, Prop); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |Cond|`String`|<span class=\"required\">필수</span>|설정할 조건 (예: \"%d > 1000\")| |Prop|`Object`|<span class=\"optional\">선택</span>|설정할 컬럼 속성| ### Enum * Prop |Name|Type|Required|Description| |----|----|-----|--------------| |BackColorT|`String`|<span class=\"optional\">선택</span>|조건 결과가 true 인 경우의 배경색| |BackColorF|`String`|<span class=\"optional\">선택</span>|조건 결과가 false 인 경우의 배경색| |FontColorT|`String`|<span class=\"optional\">선택</span>|조건 결과가 true 인 경우의 폰트 색상| |FontColorF|`String`|<span class=\"optional\">선택</span>|결과가 false 인 경우의 폰트 색상| |EditT|`String`|<span class=\"optional\">선택</span>|조건 결과가 true 인 경우의 편집 가능 여부| |EditF|`String`|<span class=\"optional\">선택</span>|조건 결과가 false 인 경우의 편집 가능 여부| |CursorT|`String`|<span class=\"optional\">선택</span>|조건 결과가 true 인 경우의 커서 모양 default 기본 모양 pointer 포인터 모양| |CursorF|`String`|<span class=\"optional\">선택</span>|조건 결과가 false 인 경우의 커서 모양 default 기본 모양 pointer 포인터 모양| ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼의 셀 값이 100 보다 작으면 blue, 그렇지 않은 경우 red 폰트 색상 적용 mySheet.SetColCondProperty(3, '%d < 100', { 'BackColorT': 'blue', 'BackColorF': 'red' }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetColCondProperty.html"
          },
          {
            "cid": 249,
            "sid": "SetColEditable",
            "name": "SetColEditable",
            "label": "SetColEditable",
            "data": {
              "body": "> 대상 컬럼의 편집 가능 여부 속성을 설정합니다. > 설정에 대한 적용 범위는 헤더, 합계, 소계, 누계행을 제외한 데이터행 영역에 대하여 처리 합니다. > `주의` 컬럼의 데이터 타입이 Seq, Status, Result, Popup, Image 인 경우는 설정과 무관하게 편집 불가 입니다. ### Syntax ```javascript ObjId.SetColEditable(Col, Editable); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |Editable|`Boolean`|<span class=\"required\">필수</span>|특정 컬럼의 Edit 가능 여부| ### Returns ***none*** ### Example ```javascript //index가 5컬럼의 Edit 가능 여부를 불가로 설정한다. mySheet.SetColEditable(5,0); //index가 5컬럼의 Edit 가능 여부를 가능으로 설정한다. mySheet. SetColEditable (5,1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetColEditable.html"
          },
          {
            "cid": 250,
            "sid": "SetColFontUnderline",
            "name": "SetColFontUnderline",
            "label": "SetColFontUnderline",
            "data": {
              "body": "> 대상 컬럼의 폰트에 underline 적용 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetColFontUnderline(Col, Underline); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |Underline|`Boolean`|<span class=\"required\">필수</span>|밑줄 여부| ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼의 폰트에 underline 적용 mySheet.SetColFontUnderline(3, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetColFontUnderline.html"
          },
          {
            "cid": 251,
            "sid": "SetColHidden",
            "name": "SetColHidden",
            "label": "SetColHidden",
            "data": {
              "body": "> 대상 컬럼의 숨김 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetColHidden([info], [opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |info|`Object`|<span class=\"required\">필수</span>|대상 컬럼 처리 정보 객체 배열 집합| |info.Col|`Long or String`|<span class=\"required\">필수</span>|대상 컬럼의 Index 또는 SaveName| |info.Hidden|`Boolean`|<span class=\"required\">필수</span>|숨김 여부| |opt|`Object`|<span class=\"optional\">선택</span>|옵션 설정 객체| |opt.ValidCol|`Boolean`|<span class=\"optional\">선택</span>|컬럼에 대한 유효성 체크 여부 (Default :1)| ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼 숨김 처리 mySheet.SetColHidden(3, 1); // Index가 3, 6, 7 컬럼에 대한 숨김 처리 mySheet.SetColHidden([ {Col: 3, Hidden:1}, {Col: 6, Hidden:1}, {Col: 7, Hidden:1} ]); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.61|SetColHidden 메소드의 인자 구조 변경 (기존 방식 처리도 지속적으로 지원)|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.61|SetColHidden 메소드의 인자 구조 변경 (기존 방식 처리도 지속적으로 지원)|"
            },
            "url": "docs/funcs/col/SetColHidden.html"
          },
          {
            "cid": 252,
            "sid": "SetColProperty",
            "name": "SetColProperty",
            "label": "SetColProperty",
            "data": {
              "body": "> 대상 컬럼의 속성을 설정 합니다. > [InitColumns](/docs/funcs/init/InitColums) 에서 정의한 컬럼의 속성을 동적으로 변경하여 사용 하고자 하는 경우에 이 메소드를 사용 합니다. > 동적으로 변경된 속성은 데이터 재조회시 적용되므로 데이터 조회 이전에 변경해야 합니다. ### Syntax ```javascript ObjId.SetColProperty(DataRow, Col, Prop); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DataRow|`Number`|<span class=\"required\">필수</span>|단위데이터행 Index| |Col|`Long or String`|<span class=\"required\">필수</span>|대상 컬럼의 Index 또는 SaveName| |Prop|`Object`|<span class=\"required\">필수</span>|컬럼의 속성 정의 객체| ### Enum * Prop |Name|Type|Required|Description| |----|----|-----|--------------| |AcceptKeys|`String`|<span class=\"optional\">선택</span>|입력허용키 설정 - `N` : 숫자만 허용 - `E` : 영문만 허용 - `K` : 한글만 허용 - `N\\|E` : 숫자, 영문만 허용 - `N\\|E\\|[사용자정의문자]` : 숫자, 영문과 사용자정의문자로 설정한 문자 허용 `주의` 사용자 정의 문자열은 꼭 대괄호로 묶어서 설정 `참고` AcceptKeys 와 ExceptKeys를 둘다 설정하고 설정키 내에 동일 문자가 있는 경우 해당 문자는 입력불가 처리됩니다.| |ActionMenu|`Object[]`|<span class=\"optional\">선택</span>|컨텍스트 메뉴 | |Align|`String`|<span class=\"optional\">선택</span>|데이터의 정렬 - Left: 좌측정렬 (`Default`) - Center: 중앙정렬 - Right: 오른쪽정렬| |AllowNull|`Boolean`|<span class=\"optional\">선택</span>|숫자계열 컬럼에 빈값 허용 여부 설정 (`Default: 0`)| |ApproximateType|`Number`|<span class=\"optional\">선택</span>|근사값처리방식 - 0 : 사용 안함 - 1 : 반올림 (`Default`) - 2 : 내림 - 3 : 올림| |ButtonUrl|`String orNumber`|<span class=\"optional\">선택</span>|팝업 버튼의 이미지 경로 또는 이미지리스트의 Index| |CalcLogic|`String or Object`|<span class=\"optional\">선택</span>|컬럼별 계산식 문자열 또는 설정 객체 - TriggerCols(`string`) : 함수 호출 대상 컬럼의 Index 또는 SaveName을 구분자 '#&124;'로 연결한 문자열 - Function(`function`) : 계산식 처리 callback 함수| |Chart|`Object`|<span class=\"optional\">선택</span>|스파크라인 차트 타입에 대한 세부 속성 설정| |ComboCode|`String`|<span class=\"optional\">선택</span>|콤보 리스트의 코드 집합| |ComboDisabled|`String`|<span class=\"optional\">선택</span>|콤보 리스트의 선택 불가능한 item 설정| |ComboText|`String`|<span class=\"optional\">선택</span>|콤보 리스트의 문자열 집합| |CustomDate|`Number`|<span class=\"optional\">선택</span>|사용자 정의 날짜 사용여부 (`Default: 0`)| |DefaultValue|`String`|<span class=\"optional\">선택</span>|신규입력시 기본값 설정| |Edit|`Boolean`|<span class=\"optional\">선택</span>|편집가능 여부| |EditLen|`Number`|<span class=\"optional\">선택</span>|데이터의 입력가능한 글자수| |EmptyToReplaceChar|`String`|<span class=\"optional\">선택</span>|빈값인 경우 대체하여 보여줄 문자 설정| |EnterMode|`Boolean`|<span class=\"optional\">선택</span>|다중라인 입력모드(MultiLineText)에서 Enter 키 입력에 대한 개행 처리 여부 (`Default :0`)| |ExceptKeys|`String`|<span class=\"optional\">선택</span>|입력제외키 설정 - `N`: 숫자 입력 불가 , - `E`: 영문 입력 불가 - `N\\|E`: 숫자, 영문 입력 불가 , - `N\\|E\\|[사용자정의문자]`: 숫자, 영문과 사용자정의문자로 설정한 문자 입력 불가 `주의` 사용자 정의 문자열은 꼭 대괄호로 묶어서 설정 `참고` AcceptKeys 와 ExceptKeys를 둘다 설정하고 설정키 내에 동일 문자가 있는 경우 해당 문자는 입력불가 처리| |FalseValue|`String`|<span class=\"optional\">선택</span>|0 이외의 CheckBox 형태 컬럼의 False값 지정. \"F\" 으로 지정한 경우 0 대신 \"F\"을 True 값으로 사용 가능| |FitColWidth|`Boolean`|<span class=\"optional\">선택</span>|FitColWidth 메소드 호출시 비율에 의한 너비 재조정 허용 여부| |Focus|`Boolean`|<span class=\"optional\">선택</span>|포커스 허용 여부 (`Default: 1`)| |Format|`String`|<span class=\"optional\">선택</span>|데이터의 Mask 적용 형태| |FormatFix|`Boolean`|<span class=\"optional\">선택</span>|GetCellValue 시 GetCellText 값을 반환 할지 여부. 특히 True 로 설정시 저장할 때 Format 이 설정된 상태로 저장합니다.| |HoverUnderline|`Boolean`|<span class=\"optional\">선택</span>|마우스오버시 언더라인 여부 (`Default: 0`)| |Image|`String`|<span class=\"optional\">선택</span>|이미지 표현시 Url| |ImgAlign|`String`|<span class=\"optional\">선택</span>|이미지 위치 - Left: 좌측 (`Default`) - Right: 우측| |ImgHeight|`Number`|<span class=\"optional\">선택</span>|이미지 높이| |ImgWidth|`Number`|<span class=\"optional\">선택</span>|이미지 너비| |InputCaseSensitive|`Number`|<span class=\"optional\">선택</span>|입력시 영문에 대한 대소구문 자동 치환 처리에 대한 설정 0 : 별도 처리 하지 않음 (`Default`) 1 : 대문자로 치환 2 : 소문자로 치환| |ItemCode|`String`|<span class=\"optional\">선택</span>|멀티체크 아이템의 코드를 구분자 `\"|\"`로 연결한 문자열| |ItemText|`String`|<span class=\"optional\">선택</span>|멀티체크 아이템의 텍스트를 구분자 `\"|\"`로 연결한 문자열| |KeyField|`Boolean`|<span class=\"optional\">선택</span>|필수 입력 항목| |MinWidth|`Number`|<span class=\"optional\">선택</span>|컬럼 최소 가로크기 (`Default: 1`)| |MaxCheck|`Number`|<span class=\"optional\">선택</span>|멀티체크의 최대 선택 개수 설정| |MultiLineText|`Boolean`|<span class=\"optional\">선택</span>|다중라인 입력여부| |NumberSort|`Boolean`|<span class=\"optional\">선택</span>|숫자형 Sort 처리 사용 여부| |PointCount|`Number`|<span class=\"optional\">선택</span>|컬럼포맷이 Float 인 경우 소수점 이하의 자리수 (`Default: 6`)| |PopupCode|`String`|<span class=\"optional\">선택</span>|팝업메뉴의 코드 집합| |PopupText|`String`|<span class=\"optional\">선택</span>|팝업메뉴의 문자열 집합| |RadioIcon|`Boolean`|<span class=\"optional\">선택</span>|데이터 셀내의 체크박스 계열의 이미지 모양 설정| |ShowCol|`Number`|<span class=\"optional\">선택</span>|멀티콤보 설정 시 컬럼 값으로 출력할 컬럼 설정| |ToolTip|`Boolean or String`|<span class=\"optional\">선택</span>|셀의 풍선도움말 표시 여부 또는 설정할 문자열| |Transaction|`Boolean`|<span class=\"optional\">선택</span>|트랜잭션 허용 여부 (`Default :1`)| |TreeCol|`Boolean`|<span class=\"optional\">선택</span>|트리 기준컬럼 설정여부| |TrueValue|`String`|<span class=\"optional\">선택</span>|1 이외의 CheckBox 형태 컬럼의 True 값 지정. \"M\" 으로 지정한 경우 1 대신 \"M\"을 True 값으로 사용 가능| |Width|`Number`|<span class=\"optional\">선택</span>|컬럼의 너비| |ZeroToReplaceChar|`String`|<span class=\"optional\">선택</span>|값이 0인 경우 대체하여 보여줄 문자 설정| |StaticPassword|`Boolean`|<span class=\"optional\">선택</span>|값이 0인 경우 데이터 길이만큼 `*` 의 수를 표현| - 각 속성의 상세 설명은 [InitColumns method](/docs/funcs/init/InitColumns)를 참조 ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼의 콤보 목록 변경 mySheet.SetColProperty(0, 3, { 'ComboText': '신규|진행중|완료', 'ComboCode': '01|02|03', }); // 단위데이터행 1번째, 3번째 컬럼의 콤보 목록을 변경 var info = {ComboText: \"신규|진행중|완료 \", ComboCode: \" 01|02|03\" }; mySheet.SetColProperty(1, 3, info); // 4번째 컬럼에 허용키, 제외키 설정 var info = {AcceptKeys:\"N|E|[!$%]\",ExceptKeys:\"[123ab]\"}; mySheet.SetColProperty(0, 4 ,info); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetColProperty.html"
          },
          {
            "cid": 253,
            "sid": "SetColWidth",
            "name": "SetColWidth",
            "label": "SetColWidth",
            "data": {
              "body": "> 대상 컬럼의 너비를 설정 합니다. > width인자의 설정 값은 0이상의 정수 값으로 설정하여야 하며, 0으로 설정한 경우 컬럼의 가장 긴 문자열에 맞게 FitSize 처리를 합니다. ### Syntax ```javascript ObjId.SetColWidth(Col, Width); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| |Width|`Integer`|<span class=\"required\">필수</span>|너비 픽셀 값| ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼의 너비를 120px로 설정 mySheet.SetColWidth(3, 120); // Index가 3인 컬럼의 너비에 대한 FitSize 처리 mySheet.SetColWidth(3, 0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetColWidth.html"
          },
          {
            "cid": 254,
            "sid": "SetCurrentColInfo",
            "name": "SetCurrentColInfo",
            "label": "SetCurrentColInfo",
            "data": {
              "body": "> 컬럼들의 위치, 숨김, 너비 정보를 설정 합니다. > `주의` 인자로 설정되는 값은 반드시 [GetCurrentColInfo](/docs/funcs/col/GetCurrentColInfo)의 반환 값이어야 합니다. ### Syntax ```javascript ObjId.SetCurrentColInfo(Info); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Info|`String`|<span class=\"required\">필수</span>|설정할 컬럼 정보 문자열| ### Returns ***none*** ### Example ```javascript // 이전 컬럼 정보를 설정 한다. var prevColInfo = 저장된 이전 컬럼 정보(GetCurrentColInfo) mySheet.SetCurrentColInfo(prevColInfo); ``` ### Since |version|desc| |---|---| |7.0.13.30||",
              "since": "|version|desc||---|---||7.0.13.30||"
            },
            "url": "docs/funcs/col/SetCurrentColInfo.html"
          },
          {
            "cid": 255,
            "sid": "SetExtendLastCol",
            "name": "SetExtendLastCol",
            "label": "SetExtendLastCol",
            "data": {
              "body": "> 마지막 컬럼의 너비를 전체 너비에 맞게 자동으로 맞출것인지 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetExtendLastCol(Extend); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Extend|`Boolean`|<span class=\"required\">필수</span>|마지막 컬럼 너비 확장 여부 (Default: 0)| ### Returns ***none*** ### Example ```javascript // 마지막 컬럼을 전체 너비에 맞추도록 설정 mySheet.SetExtendLastCol(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetExtendLastCol.html"
          },
          {
            "cid": 256,
            "sid": "SetFrozenCol",
            "name": "SetFrozenCol",
            "label": "SetFrozenCol",
            "data": {
              "body": "> 좌측 고정컬럼 개수를 설정 합니다. ### Syntax ```javascript ObjId.SetFrozenCol(Count); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Rows|`Integer`|<span class=\"required\">필수</span>|설정할 고정컬럼 개수 (Default: 0)| ### Returns ***none*** ### Example ```javascript // 좌측 고정컬럼 개수를 3개로 설정 mySheet.SetFrozenCol(3); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetFrozenCol.html"
          },
          {
            "cid": 257,
            "sid": "SetLeftCol",
            "name": "SetLeftCol",
            "label": "SetLeftCol",
            "data": {
              "body": "> 시트의 가장 좌측에 위치할 컬럼을 설정 합니다. > 컬럼의 위치 이동이 아닌 가로 스크롤의 이동으로 처리 됩니다. > 고정 컬럼 설정이 있는 경우 고정 컬럼 영역 이후의 첫번째에 설정 됩니다. 대상 컬럼을 가장 좌측에 위치할 수 없는 경우 가능한 범위 내에서 가장 좌측으로 설정 됩니다. ### Syntax ```javascript ObjId.SetLeftCol(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Column Index 또는 SaveName| ### Returns ***none*** ### Example ```javascript //고정컬럼이 설정되어 있을경우 //4컬럼을 수평스크롤 가장 좌측에 보이는 컬럼으로 설정 mySheet.SetLeftCol(4); //고정컬럼이 설정되어 있지 않을경우 //6컬럼을 수평스크롤 가장 좌측에 보이는 컬럼으로 설정 mySheet.SetLeftCol(6); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/col/SetLeftCol.html"
          }
        ]
      },
      {
        "gid": 4,
        "name": "funcs-core",
        "label": "core",
        "children": [
          {
            "cid": 258,
            "sid": "AllowEvent4CheckAll",
            "name": "AllowEvent4CheckAll",
            "label": "AllowEvent4CheckAll",
            "data": {
              "body": "> 데이터 타입이 `CheckBox` 인 컬럼에 대한 전체선택 기능을 사용할 때 OnChange 이벤트를 발생 할지 여부를 설정 합니다. > 일반적으로 OnChange를 사용하지 않는 대량 데이터에 대한 처리 성능을 향상 시키고자 할때 사용 합니다. ### Syntax ```javascript ObjId.AllowEvent4CheckAll(event); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |event|`Boolean`|<span class=\"required\">필수</span>|`OnChange` Event 발생여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 전체 선택시 OnChange 이벤트 발생하지 않도록 설정 mySheet.AllowEvent4CheckAll(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/AllowEvent4CheckAll.html"
          },
          {
            "cid": 259,
            "sid": "ClearHeaderCheck",
            "name": "ClearHeaderCheck",
            "label": "ClearHeaderCheck",
            "data": {
              "body": "> 헤더의 체크박스 값을 모두 클리어 합니다. > 전체체크의 기능 처리는 하지 않고 단순 언체크 처리만 합니다. ### Syntax ```javascript ObjId.ClearHeaderCheck(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 헤더의 전체 체크박스를 모드 클리어 처리 mySheet.ClearHeaderCheck(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ClearHeaderCheck.html"
          },
          {
            "cid": 260,
            "sid": "ClearSelection",
            "name": "ClearSelection",
            "label": "ClearSelection",
            "data": {
              "body": "> 마우스 드래그를 이용한 선택 영역을 초기화 합니다. ### Syntax ```javascript ObjId.ClearSelection(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 선택 영역을 초기화 mySheet.ClearSelection() ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ClearSelection.html"
          },
          {
            "cid": 261,
            "sid": "ClearUnload",
            "name": "ClearUnload",
            "label": "ClearUnload",
            "data": {
              "body": "> 페이지에 있는 모든 IBSheet를 삭제 하고, 사용하던 메모리를 강제로 해제 합니다. > 모든 IBSheet 에 대한 처리를 수행 하므로, 사용중인 하나의 IBSheet 를 통해 1회만 호출해야 합니다. > 이 기능은 body 태그의 `onunload` 이벤트에서 사용해야 합니다. ### Syntax ```javascript ObjId.ClearUnload(removeEvent); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |removeEvent|`Boolean`|<span class=\"optional\">선택</span>|시트의 이벤트 리스너 삭제 여부 선택| ### Returns ***none*** ### Example ```javascript // 시트 객체 삭제 및 메모리 강제 해제 처리 function clearSheet() { mySheet.ClearUnload(); } <body onunload='clearSheet();'></body> // jQuery 에서의 사용 $( window ).unload(function() { mySheet.ClearUnload(); }); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.40|removeEvent 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.40|removeEvent 추가|"
            },
            "url": "docs/funcs/core/ClearUnload.html"
          },
          {
            "cid": 262,
            "sid": "ColValueDupRows",
            "name": "ColValueDupRows",
            "label": "ColValueDupRows",
            "data": {
              "body": "> 단일 또는 다중 컬럼에 대한 동일한 데이터의 모든 행 Index를 확인합니다. > `Cols` 인자에 2개 이상의 컬럼을 구분자로 연결한 문자열로 구성한 경우 다중컬럼에 대해서 처리를 합니다. > - 동일한 데이터가 존재하는 경우 : 첫번째 중복 행을 제외한 중복 행의 Index를 \",\" 구분자로 연결한 문자열 조합으로 반환 > - 동일한 데이터가 존재하지 않은 경우 : 빈값을 반환 > `IncludeDelRow` 속성을 설정하지 않거나 true로 설정한 경우 트랜잭션 상태가 삭제인 행을 포함하여 처리합니다. > `IncludeFirstRow` 속성를 true로 설정하는 경우 첫번째 중복행의 Index를 `,` 구분자로 연결한 문자열 조합과 결과 문자열을 `|` 구분자로 연결한 문자열 조합으로 반환합니다. ### Syntax ```javascript ObjId.ColValueDupRows(Cols, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Cols|`Number or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |Opt|`Object`|<span class=\"optional\">선택</span>|옵션 객체| |Opt.CaseSensitive|`Boolean`|<span class=\"optional\">선택</span>|대/소문자 구분 비교 여부 (Default: 1)| |Opt.IncludeDelRow|`Boolean`|<span class=\"optional\">선택</span>|트랜잭션 상태가 삭제인 행을 포함 여부 (Default: 1)| |Opt.IncludeSumRow|`Boolean`|<span class=\"optional\">선택</span>|합계/소계/누계 행 포함 여부 (Default: 1)| |Opt.IncludeEmpty|`Boolean`|<span class=\"optional\">선택</span>|빈값 포함 여부 (Default: 1)| |Opt.IncludeFirstRow|`Boolean`|<span class=\"optional\">선택</span>|중복된 행의 최초의 행을 포함할지 여부 (Default: 0)| |Opt.StartRow|`Number`|<span class=\"optional\">선택</span>|중복 검사를 수행 하고자 하는 부분의 첫행의 Index (Default: \"첫 행\")| |Opt.EndRow|`Number`|<span class=\"optional\">선택</span>|중복 검사를 수행 하고자 하는 부분의 마지막행 Index (Default: \"마지막 행\")| ### Returns ***String, 중복된 모든 행을 \",\"로 조합한 문자열*** ### Example ```javascript // 4컬럼,5컬럼에 대해 첫번째 행부터 50번째 행까지의 중복검사(삭제행제외, 최초행포함, 1행~50행) var duprows = mySheet.ColValueDupRows(\"4|5\",{ \"IncludeDelRow\" : 0, \"IncludeFirstRow\" : 1, \"StartRow\" : 1, \"EndRow\" : 50 }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ColValueDupRows.html"
          },
          {
            "cid": 263,
            "sid": "ConfirmOK",
            "name": "ConfirmOK",
            "label": "ConfirmOK",
            "data": {
              "body": "> OnMessage 이벤트에서 Confirm 확인 값을 시트에 전달 합니다. > 이 메소드는 `SetShowMsgMode` 설정이 `0`인 경우 `OnMessage` 이벤트 내에서만 사용이 가능합니다. ### Syntax ```javascript ObjId.ConfirmOK(Val); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Val|`Long`|<span class=\"required\">필수</span>|확인창 선택 결과값| ### Returns ***none*** ### Example ```javascript // 시스템 팝업을 사용하지 않고 메시지를 이벤트로 전달하도록 설정 mySheet.SetShowMsgMode(0); ... // OnMessage 이벤트 function mySheet_OnMessage(msg, level, isConfirm) { // 사용자 시스템 팝업 호출 var res = ... if (isConfirm) { // 결과값 전달 mySheet.ConfirmOK(res); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ConfirmOK.html"
          },
          {
            "cid": 264,
            "sid": "CreateUniteTable",
            "name": "CreateUniteTable",
            "label": "CreateUniteTable",
            "data": {
              "body": "> UseChildGrid 사용시에 부모 그리드와 자식 그리드가 컬럼정보가 합쳐진 그리드를 생성합니다. > 단, 두 그리드의 초기화 정보의 SaveName은 중복되지 않아야 하고 헤더의 줄수가 동일해야 합니다. > 기타 전체 속성 부분 및 일부 공통 속성은 그리드 초기값으로 생성됩니다. ### Syntax ```javascript ObjId.CreateUniteTable(sheetId); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |sheetId|`String`|<span class=\"required\">필수</span>|생성할 시트의 Id| ### Returns ***none*** ### Example ```javascript // mySheet2에 mySheet와 ChildGrid의 정보를 취합하여 그리드를 생성한다. mySheet.CreateUniteTable(mySheet2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/CreateUniteTable.html"
          },
          {
            "cid": 265,
            "sid": "Data2Clipboard",
            "name": "Data2Clipboard",
            "label": "Data2Clipboard",
            "data": {
              "body": "> IBSheet의 헤더를 포함한 모든 데이터를 클립보드에 복사 합니다. > `제약사항` 이 기능은 브라우저 보안정책상의 이유로 `IE 브라우저`만 지원합니다. ### Syntax ```javascript ObjId.Data2Clipboard(); ``` ### Info ***none*** ### Returns ***String, 클립보드에 복사된 문자열*** ### Example ```javascript // 모든 데이터를 클립보드에 복사 mySheet.Data2Clipboard(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/Data2Clipboard.html"
          },
          {
            "cid": 266,
            "sid": "DisposeSheet",
            "name": "DisposeSheet",
            "label": "DisposeSheet",
            "data": {
              "body": "> IBSheet 객체를 삭제 한다. 삭제시 사용하던 메모리도 강제로 해제 처리 한다. ### Syntax ```javascript ObjId.DisposeSheet(removeEvent); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |removeEvent|`Boolean`|<span class=\"optional\">선택</span>|시트의 이벤트 리스너 삭제 여부 선택 - 0 : 메모리를 해제합니다. (Default) - 1 : 메모리 해제 및 이벤트를 해제합니다.| ### Returns ***none*** ### Example ```javascript // IBSheet 생성시 이전에 생성한 객체가 있으면 삭제 후 생성 처리 if (typeof mySheet !== \"undefined\" && typeof mySheet.Index !== \"undefined\") { mySheet.DisposeSheet(); } createIBSheet2(container, 'mySheet', '100%', '500px'); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.40|removeEvent 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.40|removeEvent 추가|"
            },
            "url": "docs/funcs/core/DisposeSheet.html"
          },
          {
            "cid": 267,
            "sid": "DoPrint",
            "name": "DoPrint",
            "label": "DoPrint",
            "data": {
              "body": "> 보여지고 있는 모든 데이터를 인쇄합니다. > 인쇄 처리는 브라우저의 인쇄 기능을 따르며 배경색 및 이미지를 인쇄 하기 위해서는 브라우저의 인쇄설정을 변경해야 합니다. ### Syntax ```javascript ObjId.DoPrint(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 인쇄 하기 mySheet.DoPrint(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/DoPrint.html"
          },
          {
            "cid": 268,
            "sid": "EtcDataString",
            "name": "EtcDataString",
            "label": "EtcDataString",
            "data": {
              "body": "> EtcData에 설정된 키와 값을 QueryString 형태로 반환 합니다. ### Syntax ```javascript ObjId.EtcDataString(UrlEncode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |UrlEncode|`Boolean`|<span class=\"optional\">선택</span>|UrlEncode 처리 여부 (Default: 0)| ### Returns ***String, EtcData에 설정된 키와 값에 대한 QueryString 문자열*** ### Example ```javascript // 저장시 EtcData를 param으로 전달 var param = mySheet.EtcDataString(1); mySheet.DoSave(\"save.jsp\", { \"Param\": param }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/EtcDataString.html"
          },
          {
            "cid": 269,
            "sid": "ExportData",
            "name": "ExportData",
            "label": "ExportData",
            "data": {
              "body": "> 시트의 데이터를 인자의 형식으로 추출 합니다. > 대상 컬럼을 설정하지 않은 경우는 모든 컬럼을 대상으로 합니다. ### Syntax ```javascript ObjId.ExportData([info]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |info|`Object`|<span class=\"required\">필수</span>|옵션 정보| |info.Type|`String`|<span class=\"required\">필수</span>|json,xml,csv 중에 하나 선택| |info.Cols|`String`|<span class=\"optional\">선택</span>|추출할 컬럼 (Default: 모든컬럼)| |info.ColDelim|`String`|<span class=\"optional\">선택</span>|출력 대상의 컬럼 구분자 (`csv` 형식인 경우에만 사용) (Default: ',')| |info.FormattedText|`Boolean`|<span class=\"optional\">선택</span>|포멧이 적용된 문자열형식으로 추출할지 여부 (Default: 0)| |info.Mode|`Number`|<span class=\"optional\">선택</span>|처리 모드 (`csv` 형식인 경우에만 사용) - 0 : 일반 처리 모드 - 1 : 추출 대상 컬럼이 빈값인 컬럼은 빈값으로 추출 처리 모드| |info.NewLine|`String`|<span class=\"optional\">선택</span>|출력 대상의 개행 구분자 (`csv` 형식인 경우에만 사용) (Default: `\\r\\n`)| |info.RowDelim|`String`|<span class=\"optional\">선택</span>|출력 대상의 행 구분자 (`csv` 형식인 경우에만 사용) (Default: `\\r\\n`)| |info.StyleProperty|`Boolean`|<span class=\"optional\">선택</span>|행과 셀에 대한 스타일 관련 속성값 포함 여부 (`json` 형식인 경우에만 사용가능)| ### Enum * StyleProperty |Target|ProPerty|Description| |------|--------|-----------| |`Row`|Edit BackColor FontColor|대상 행의 편집 허용 여부 대상 행의 배경색 대상 행의 폰트 색상| |Cell|Edit BackColor FontColor FontBold FontItalic FontStrike FontUnderline|대상 셀의 편집 허용 여부 대상 셀의 배경색 대상 셀의 폰트 색상 대상 셀의 폰트 Bold 여부 대상 셀의 폰트 Italic 여부 대상 셀의 폰트 Strike 여부 대상 셀의 폰트 Underline 여부| ### Returns ***Type으로 지정한 형식의 데이터*** ### Example ```javascript // 시트의 모든 데이터를 json 객체로 추출 var jsonData = mySheet.ExportData({ \"Type\": \"json\" }); console.log('data: ', jsonData); // Index가 2, 5, 10 컬럼의 데이터만 추출 var jsonData = mySheet.ExportData({ \"Type\": \"json\", \"Cols\": \"2|5|10\" }); console.log('data: ', jsonData); ``` ### Since |version|desc| |---|---| |7.0.13.21|| |7.0.13.44|FormattedText , StyleProperty 추가|",
              "since": "|version|desc||---|---||7.0.13.21|||7.0.13.44|FormattedText , StyleProperty 추가|"
            },
            "url": "docs/funcs/core/ExportData.html"
          },
          {
            "cid": 270,
            "sid": "FitSize",
            "name": "FitSize",
            "label": "FitSize",
            "data": {
              "body": "> 모든 행의 높이와 컬럼의 너비를 재조정합니다. > `rowHeight` 인자가 1인 경우 모든 행의 높이를 데이터의 높이에 맞게 재조정하고, `colWidth` 인자가 1인 경우 모든 컬럼의 너비를 컬럼 내의 가장 넓은 글자의 너비에 맞게 재조정합니다. ### Syntax ```javascript ObjId.FitSize(RowHeight, ColumnWidth); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |RowHeight|`Boolean`|<span class=\"required\">필수</span>|행 높이 변경 여부| |ColumnWidth|`Boolean`|<span class=\"required\">필수</span>|컬럼 너비 변경 여부| ### Returns ***none*** ### Example ```javascript // 데이터에 맞게 행의 높이와 컬럼너비 재조정 mySheet.FitSize(1, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/FitSize.html"
          },
          {
            "cid": 271,
            "sid": "GetActionMenu",
            "name": "GetActionMenu",
            "label": "GetActionMenu",
            "data": {
              "body": "> 데이터 영역에 설정 되어있는 컨텍스트 메뉴를 확인 합니다. ### Syntax ```javascript ObjId.GetActionMenu(); ``` ### Info ***none*** ### Returns ***String(Object), 설정된 팝업메뉴*** ### Example ```javascript // 데이터 영역에 설정 되어있는 컨텍스트 메뉴 확인 console.log('contextMenu: ', mySheet.GetActionMenu()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetActionMenu.html"
          },
          {
            "cid": 272,
            "sid": "GetAllowCheck",
            "name": "GetAllowCheck",
            "label": "GetAllowCheck",
            "data": {
              "body": "> 사용자가 체크박스의 값 변경시, 값의 변경을 수용할 지의 여부를 확인합니다. ### Syntax ```javascript ObjId.GetAllowCheck(); ``` ### Info ***none*** ### Returns ***Boolean, 설정된 값*** ### Example ```javascript // 체크박스의 값 변경 허용여부 확인 console.log(\"allowCheck:\", mySheet.GetAllowCheck()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetAllowCheck.html"
          },
          {
            "cid": 273,
            "sid": "GetAutoRowHeight",
            "name": "GetAutoRowHeight",
            "label": "GetAutoRowHeight",
            "data": {
              "body": "> 데이터 행의 높이를 데이터에 맞게 자동으로 조정할지 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetAutoRowHeight(); ``` ### Info ***none*** ### Returns ***Boolean, 설정 값*** ### Example ```javascript // AutoRowHeight 설정값 확인 console.log(\"autoRowHeight:\", mySheet.GetAutoRowHeight()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetAutoRowHeight.html"
          },
          {
            "cid": 274,
            "sid": "GetBasicImeMode",
            "name": "GetBasicImeMode",
            "label": "GetBasicImeMode",
            "data": {
              "body": "> 편집 가능한 셀에 포커스 시 IME 처리 방법을 확인한다. `IE브라우저만 지원` ### Syntax ```javascript ObjId.GetBasicImeMode(); ``` ### Info ***none*** ### Returns ***Integer, 설정값*** ### Example ```javascript // IME 처리 방법 확인 console.log(\"imeMode:\", mySheet.GetBasicImeMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetBasicImeMode.html"
          },
          {
            "cid": 275,
            "sid": "GetClipCopyMode",
            "name": "GetClipCopyMode",
            "label": "GetClipCopyMode",
            "data": {
              "body": "> IBSheet에서 `Ctrl + C`를 이용하여 데이터를 클립보드에 복사 할때의 처리 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetClipCopyMode(); ``` ### Info ***none*** ### Returns ***Number, 클립보드 복사 처리 방법*** ### Example ```javascript // 클립보드 복사 처리 방법 확인 console.log('copyMode: ', mySheet.GetClipCopyMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetClipCopyMode.html"
          },
          {
            "cid": 276,
            "sid": "GetClipCutDisable",
            "name": "GetClipCutDisable",
            "label": "GetClipCutDisable",
            "data": {
              "body": "> IBSheet에서 `Ctrl + X`를 이용하여 데이터를 클립보드에 잘라내기 할때의 처리 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetClipCutDisable(); ``` ### Info ***none*** ### Returns ***Number, 클립보드 잘라내기 가능 여부 방법*** ### Example ```javascript // 클립보드 복사 처리 방법 확인 console.log('cutMode: ', mySheet.GetClipCutDisable()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetClipCutDisable.html"
          },
          {
            "cid": 277,
            "sid": "GetClipPasteMode",
            "name": "GetClipPasteMode",
            "label": "GetClipPasteMode",
            "data": {
              "body": "> 클립보드에 있는 내용을 시트에 붙여넣기 할때의 처리 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetClipPasteMode(); ``` ### Info ***none*** ### Returns ***Number, 붙여넣기 처리 방법*** ### Example ```javascript // 클립보드 붙여넣기 처리 방법 확인 console.log('pasteMode: ', mySheet.GetClipPasteMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetClipPasteMode.html"
          },
          {
            "cid": 278,
            "sid": "GetComboOpenMode",
            "name": "GetComboOpenMode",
            "label": "GetComboOpenMode",
            "data": {
              "body": "> `Combo`, `ComboEdit` 타입의 셀 선택 시점의 처리방법을 확인 합니다. ### Syntax ```javascript ObjId.GetComboOpenMode(); ``` ### Info ***none*** ### Returns ***Boolean, 현재 설정 값*** ### Example ```javascript // \"Combo\", \"ComboEdit\" 타입의 셀 선택시점의 처리방법 확인 console.log(\"comboOpenMode:\", mySheet.GetComboOpenMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetComboOpenMode.html"
          },
          {
            "cid": 279,
            "sid": "GetCountFormat",
            "name": "GetCountFormat",
            "label": "GetCountFormat",
            "data": {
              "body": "> 건수 정보의 출력 포맷을 확인 합니다. ### Syntax ```javascript ObjId.GetCountFormat(); ``` ### Info ***none*** ### Returns ***Sring, 설정된 출력 포맷*** ### Example ```javascript // 건수 정보 출력 포맷 확인 console.log('format: ', mySheet.GetCountFormat()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetCountFormat.html"
          },
          {
            "cid": 280,
            "sid": "GetCountInfoElement",
            "name": "GetCountInfoElement",
            "label": "GetCountInfoElement",
            "data": {
              "body": "> 건수 정보 출력 대상 Dom Element를 확인 합니다. ### Syntax ```javascript ObjId.GetCountInfoElement(); ``` ### Info ***none*** ### Returns ***Object,건수 정보 출력 대상 Dom Element*** ### Example ```javascript // 건수 정보가 출력 되는 Dom Element 확인 console.log('element: ', mySheet.GetCountInfoElement()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetCountInfoElement.html"
          },
          {
            "cid": 281,
            "sid": "GetCountPosition",
            "name": "GetCountPosition",
            "label": "GetCountPosition",
            "data": {
              "body": "> 건수 정보가 출력 되는 위치를 확인합니다. ### Syntax ```javascript ObjId.GetCountPosition(); ``` ### Info ***none*** ### Returns ***Number, 건수 정보 출력 위치*** ### Example ```javascript // 건수 정보 출력 위치 확인 console.log('countPosition: ', mySheet.GetCountPosition()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetCountPosition.html"
          },
          {
            "cid": 282,
            "sid": "GetCurrentPage",
            "name": "GetCurrentPage",
            "label": "GetCurrentPage",
            "data": {
              "body": "> 현재의 페이지 Index를 확인 합니다. > 이 기능을 사용하기 위해 서는 `SetConfig` 메소드에서 `SearchMode` 속성을 이용하여 `페이징 모드`로 설정해야 합니다. ### Syntax ```javascript ObjId.GetCurrentPage(); ``` ### Info ***none*** ### Returns ***Number, 현재의 페이지 Index*** ### Example ```javascript // 페이징 모드 설정 mySheet.SetConfig({ \"SearchMode\": 1, \"Page\": 30 }); // 현재의 페이지 Index 확인 console.log('pageIndex: ', mySheet.GetCurrentPage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetCurrentPage.html"
          },
          {
            "cid": 283,
            "sid": "GetDataAlternateBackColor",
            "name": "GetDataAlternateBackColor",
            "label": "GetDataAlternateBackColor",
            "data": {
              "body": "> 데이터 영역의 짝수번째 행의 기본 배경색을 확인 합니다. ### Syntax ```javascript ObjId.GetDataAlternateBackColor(); ``` ### Info ***none*** ### Returns ***String, 설정되어 있는 색상 값*** ### Example ```javascript // Alternate 배경색 확인 console.log(\"alternateBackColor:\", mySheet.GetDataAlternateBackColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDataAlternateBackColor.html"
          },
          {
            "cid": 284,
            "sid": "GetDataAutoTrim",
            "name": "GetDataAutoTrim",
            "label": "GetDataAutoTrim",
            "data": {
              "body": "> 데이터에 대한 자동 trim 처리 여부를 확인 합니다. > 설정하지 않은 경우 기본값인 `1`을 리턴 합니다. ### Syntax ```javascript ObjId.GetDataAutoTrim(); ``` ### Info ***none*** ### Returns ***Boolean, trim 처리 여부*** ### Example ```javascript // 자동 trim 여부 확인 console.log(\"autoTrim:\", mySheet.GetDataAutoTrim()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDataAutoTrim.html"
          },
          {
            "cid": 285,
            "sid": "GetDataBackColor",
            "name": "GetDataBackColor",
            "label": "GetDataBackColor",
            "data": {
              "body": "> 데이터 영역 행의 기본 배경색을 확인 합니다. ### Syntax ```javascript ObjId.GetDataBackColor(); ``` ### Info ***none*** ### Returns ***String, 설정되어 있는 색상 값*** ### Example ```javascript // 배경색 확인 console.log(\"backColor:\", mySheet.GetDataBackColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.108|HIDDENROWS, EXCEPTHIDE, ROWVIEWCOUNT FILTEREDVIEWCOUNT 예약어 추가| |7.0.13.126|BOTTOMDATA2, TOTALROWS2 예약어 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.108|HIDDENROWS, EXCEPTHIDE, ROWVIEWCOUNT FILTEREDVIEWCOUNT 예약어 추가||7.0.13.126|BOTTOMDATA2, TOTALROWS2 예약어 추가|"
            },
            "url": "docs/funcs/core/GetDataBackColor.html"
          },
          {
            "cid": 286,
            "sid": "GetDataFontColor",
            "name": "GetDataFontColor",
            "label": "GetDataFontColor",
            "data": {
              "body": "> 데이터 행의 기본 폰트 색상을 확인 합니다. ### Syntax ```javascript ObjId.GetDataFontColor(); ``` ### Info ***none*** ### Returns ***String, 설정된 색상 값*** ### Example ```javascript // 행의 기본 폰트 색상 확인 console.log(\"fontColor:\", mySheet.GetDataFontColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDataFontColor.html"
          },
          {
            "cid": 287,
            "sid": "GetDataLinkMouse",
            "name": "GetDataLinkMouse",
            "label": "GetDataLinkMouse",
            "data": {
              "body": "> 특정 컬럼에 대한 마우스 링크 여부를 확인합니다. ### Syntax ```javascript ObjId.GetDataLinkMouse(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Number or String`|<span class=\"required\">필수</span>|특정 컬럼의 Index 또는 SaveName| ### Returns ***Boolean, 설정된 링크 값*** ### Example ```javascript // Index가 5인 컬럼에 대한 확인 console.log(\"dataLineMouse:\", mySheet.GetDataLinkMouse()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDataLinkMouse.html"
          },
          {
            "cid": 288,
            "sid": "GetDataRowHeight",
            "name": "GetDataRowHeight",
            "label": "GetDataRowHeight",
            "data": {
              "body": "> 데이터 행의 기본 행 높이를 확인 합니다. ### Syntax ```javascript ObjId.GetDataRowHeight(); ``` ### Info ***none*** ### Returns ***Number, 데이터 행 높이 (단위:px)*** ### Example ```javascript // 행의 기본 높이 확인 console.log(\"rowHeight:\", mySheet.GetDataRowHeight()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDataRowHeight.html"
          },
          {
            "cid": 289,
            "sid": "GetDataRows",
            "name": "GetDataRows",
            "label": "GetDataRows",
            "data": {
              "body": "> 단위데이터행 설정 개수를 확인 합니다. ### Syntax ```javascript ObjId.GetDataRows(); ``` ### Info ***none*** ### Returns ***Number, 설정 되어 있는 단위 데이터 행의 개수*** ### Example ```javascript // 단위데이터행의 수 확인 console.log(\"dataRows:\", mySheet.GetDataRows()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDataRows.html"
          },
          {
            "cid": 290,
            "sid": "GetDownloadingImage",
            "name": "GetDownloadingImage",
            "label": "GetDownloadingImage",
            "data": {
              "body": "> 다운로드중 대기 이미지의 url을 확인 합니다. ### Syntax ```javascript ObjId.GetDownloadingImage(); ``` ### Info ***none*** ### Returns ***String, 다운로드중 대기 이미지 url*** ### Example ```javascript // 다운로드중 대기 이미지 url 확인 console.log('downloadWaitImage: ', mySheet.GetDownloadingImage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDownloadingImage.html"
          },
          {
            "cid": 291,
            "sid": "GetDragMode",
            "name": "GetDragMode",
            "label": "GetDragMode",
            "data": {
              "body": "> IBSheet 내에서의 drag 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetDragMode(); ``` ### Info ***none*** ### Returns ***Number, 처리 모드*** ### Example ```javascript // DragMode 확인 console.log(\"dragMode:\", mySheet.GetDragMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetDragMode.html"
          },
          {
            "cid": 292,
            "sid": "GetEditArrowBehavior",
            "name": "GetEditArrowBehavior",
            "label": "GetEditArrowBehavior",
            "data": {
              "body": "> 편집모드 상태에서 방향 키 입력에 대한 동작 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetEditArrowBehavior(); ``` ### Info ***none*** ### Returns ***String, 방향 키 입력에 대한 동작 방법*** ### Example ```javascript // 편집모드시 방향 키 동작 방법 확인 console.log(\"arrowBehavior:\", mySheet.GetEditArrowBehavior()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEditArrowBehavior.html"
          },
          {
            "cid": 293,
            "sid": "GetEditEnterBehavior",
            "name": "GetEditEnterBehavior",
            "label": "GetEditEnterBehavior",
            "data": {
              "body": "> 편집모드 상태에서 Enter 키 입력에 대한 동작 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetEditEnterBehavior(); ``` ### Info ***String, Enter키 입력에 대한 동작 방법*** ### Returns ***none*** ### Example ```javascript // 편집모드시 Enter키 동작 방법 확인 console.log(\"enterBehavior:\", mySheet.GetEditEnterBehavior()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEditEnterBehavior.html"
          },
          {
            "cid": 294,
            "sid": "GetEditTabBehavior",
            "name": "GetEditTabBehavior",
            "label": "GetEditTabBehavior",
            "data": {
              "body": "> 편집모드 상태에서 tab 키 입력에 대한 동작 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetEditTabBehavior(); ``` ### Info ***none*** ### Returns ***String, TAB키 입력에 대한 동작 방법*** ### Example ```javascript // 편집모드시 tab 키 동작 방법 확인 console.log(\"tabBehavior:\", mySheet.GetEditTabBehavior()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEditTabBehavior.html"
          },
          {
            "cid": 295,
            "sid": "GetEditText",
            "name": "GetEditText",
            "label": "GetEditText",
            "data": {
              "body": "> 편집 중인 글자를 확인합니다. ### Syntax ```javascript ObjId.GetEditText(); ``` ### Info ***none*** ### Returns ***string, 편집 중인 값*** ### Example ```javascript function mySheet_OnKeyUp(row, col, keyCode, shift) { console.log(\"editingValue:\", mySheet.GetEditText()); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEditText.html"
          },
          {
            "cid": 296,
            "sid": "GetEditable",
            "name": "GetEditable",
            "label": "GetEditable",
            "data": {
              "body": "> 모든 데이터영역에 대한 편집 가능 여부를 확인합니다. ### Syntax ```javascript ObjId.GetEditable(); ``` ### Info ***none*** ### Returns ***Boolean, 편집 가능 여부*** ### Example ```javascript // 편집 가능 여부를 확인 console.log(\"editable:\", mySheet.GetEditable()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEditable.html"
          },
          {
            "cid": 297,
            "sid": "GetEditableColorDiff",
            "name": "GetEditableColorDiff",
            "label": "GetEditableColorDiff",
            "data": {
              "body": "> 편집가능 여부에 따른 셀의 배경색을 구분하여 표시할지 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetEditableColorDiff(); ``` ### Info ***none*** ### Returns ***Integer, 설정 값*** |Enum|Description| |----|-----------| |0|편집불가능한 셀을 구분없이 표시| |1|편집불가능한 셀을 css에서 설정한 색상으로 표시| |2|편집불가능한 셀을 css의 설정값과 기본배경색의 조합으로 표시| ### Example ```javascript // 편집가능 여부에 따른 셀의 배경색을 구분여부 확인 console.log(\"editableColorDiff:\", mySheet.GetEditableColorDiff()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEditableColorDiff.html"
          },
          {
            "cid": 298,
            "sid": "GetEllipsis",
            "name": "GetEllipsis",
            "label": "GetEllipsis",
            "data": {
              "body": "> 모든 셀의 데이터에 대한 ellipsis 설정 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetEllipsis(); ``` ### Info ***none*** ### Returns ***Boolean, ellipsis 설정 여부*** ### Example ```javascript // ellipsis 설정 여부 확인 console.log(\"ellipsisMode:\", mySheet.GetEllipsis()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEllipsis.html"
          },
          {
            "cid": 299,
            "sid": "GetEnable",
            "name": "GetEnable",
            "label": "GetEnable",
            "data": {
              "body": "> 마우스나 키보드를 사용한 User Interface 사용가능 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetEnable(); ``` ### Info ***none*** ### Returns ***Boolean, 활성화 여부*** ### Example ```javascript console.log(\"enable:\", mySheet.GetEnable()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEnable.html"
          },
          {
            "cid": 300,
            "sid": "GetEnterBehavior",
            "name": "GetEnterBehavior",
            "label": "GetEnterBehavior",
            "data": {
              "body": "> 포커스 상태에서 Enter 키 입력에 대한 동작 방법을 확인합니다. ### Syntax ```javascript ObjId.GetEnterBehavior(); ``` ### Info ***none*** ### Returns ***String, Enter키 입력에 대한 동작 방법*** ### Example ```javascript // 포커스시 Enter키 동작 방법 확인 console.log(\"enterBehavior:\", mySheet.GetEnterBehavior()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEnterBehavior.html"
          },
          {
            "cid": 301,
            "sid": "GetEtcData",
            "name": "GetEtcData",
            "label": "GetEtcData",
            "data": {
              "body": "> 조회, 저장의 데이터 또는 SetEtcData에서 설정한 EtcData를 확인 합니다. ### Syntax ```javascript ObjId.GetEtcData(KeyName); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |KeyName|`String`|<span class=\"required\">필수</span>|기타정보 키 이름| ### Returns ***String, 키에 설정된 값*** ### Example ```javascript // \"etcName\" 키값 확인 console.log(\"etcName:\", mySheet.GetEtcData(\"etcName\")); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetEtcData.html"
          },
          {
            "cid": 302,
            "sid": "GetFocusEditMode",
            "name": "GetFocusEditMode",
            "label": "GetFocusEditMode",
            "data": {
              "body": "> 편집 가능한 셀이 선택상태가 되었을때 바로 편집모드로 변경할지 여부를 확인합니다. ### Syntax ```javascript ObjId.GetFocusEditMode(); ``` ### Info ***none*** ### Returns ***Number, 편집모드 변경 여부*** ### Example ```javascript // 포커스시 편집모드 변경 여부 모드 확인 console.log(\"focusEditMode:\", mySheet.GetFocusEditMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetFocusEditMode.html"
          },
          {
            "cid": 303,
            "sid": "GetHeaderActionMenu",
            "name": "GetHeaderActionMenu",
            "label": "GetHeaderActionMenu",
            "data": {
              "body": "> 헤더 영역에서 설정된 컨텍스트 메뉴를 확인 한다. > `UseHeaderActionMenu` 속성이 0으로 설정된 경우 `-1`을 반환합니다. [UseHeaderActionMenu 참고](/docs/props/PropertyList/UseHeaderActionMenu) ### Syntax ```javascript ObjId.GetHeaderActionMenu(); ``` ### Info ***none*** ### Returns ***Object, MenuText/MenuCode로 이루어진 객체*** * Returns Info |Name|Type|Description| |----|----|-----------| |menu|`Number or String`|컨텍스트 메뉴 정보 객체 - MenuText : 메뉴명을 구분자 `|`로 연결한 문자열 - MenuCode : 메뉴코드를 구분자 `|`로 연결한 문자열| ### Example ```javascript // 헤더의 컨텍스트 메뉴 확인 console.log(\"headerMenu:\", mySheet.GetHeaderActionMenu()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderActionMenu.html"
          },
          {
            "cid": 304,
            "sid": "GetHeaderBackColor",
            "name": "GetHeaderBackColor",
            "label": "GetHeaderBackColor",
            "data": {
              "body": "> 헤더행의 배경색을 확인합니다. ### Syntax ```javascript ObjId.GetHeaderBackColor(); ``` ### Info ***none*** ### Returns ***String, 설정되어있는 색상 값*** ### Example ```javascript // 헤더행의 배경색 확인. console.log(\"backColor:\", mySheet.GetHeaderBackColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderBackColor.html"
          },
          {
            "cid": 305,
            "sid": "GetHeaderCheck",
            "name": "GetHeaderCheck",
            "label": "GetHeaderCheck",
            "data": {
              "body": "> 헤더의 전체 체크박스 설정 값을 확인합니다. ### Syntax ```javascript ObjId.GetHeaderCheck(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |Col|`Long or String`|<span class=\"required\">필수</span>|대상 컬럼의 Index 또는 SaveName| ### Returns ***Boolean, 현재 설정 값*** ### Example ```javascript // (0, 3) 헤더 셀의 체크박스 설정값 확인 console.log(\"checkedValue:\", mySheet.GetHeaderCheck(0, 3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderCheck.html"
          },
          {
            "cid": 306,
            "sid": "GetHeaderCheckValue",
            "name": "GetHeaderCheckValue",
            "label": "GetHeaderCheckValue",
            "data": {
              "body": "> 특정 컬럼에 대한 헤더 행의 전체 체크 값을 확인 합니다. ### Syntax ```javascript ObjId.GetHeaderCheckValue(col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |col|`Long`|<span class=\"required\">필수</span>|특정 컬럼의 Index| ### Returns ***String, 전체 체크 설정 값*** ### Example ```javascript // Index가 3인 CheckBox 컬럼 타입에 대한 헤더의 전체체크 값 확인 console.log(\"checkValue:\", mySheet.GetHeaderCheckValue(3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderCheckValue.html"
          },
          {
            "cid": 307,
            "sid": "GetHeaderCursor",
            "name": "GetHeaderCursor",
            "label": "GetHeaderCursor",
            "data": {
              "body": "> 헤더 행의 마우스 오버시 커서 모양을 확인합니다. ### Syntax ```javascript ObjId.GetHeaderCursor(); ``` ### Info ***none*** ### Returns ***String*** ### Example ```javascript // 헤더의 마우스 커서포인터를 확인한다. mySheet.GetHeaderCursor(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderCursor.html"
          },
          {
            "cid": 308,
            "sid": "GetHeaderEventMode",
            "name": "GetHeaderEventMode",
            "label": "GetHeaderEventMode",
            "data": {
              "body": "> 헤더 행에 대한 이벤트 발생 모드를 확인 합니다. ### Syntax ```javascript ObjId.GetHeaderEventMode(); ``` ### Info ***none*** ### Returns ***Number, 이벤트 발생 모드*** ### Example ```javascript // 헤더 행에 대한 마우스 이벤트 발생 모드 확인 console.log(\"eventMode:\", mySheet.GetHeaderEventMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderEventMode.html"
          },
          {
            "cid": 309,
            "sid": "GetHeaderFontBold",
            "name": "GetHeaderFontBold",
            "label": "GetHeaderFontBold",
            "data": {
              "body": "> 헤더 행의 폰트 bold 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetHeaderFontBold(); ``` ### Info ***none*** ### Returns ***Boolean, bold 적용 여부*** ### Example ```javascript // 헤더행의 Bold 적용 여부 확인. console.log(\"fontBold:\", mySheet.GetHeaderFontBold()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderFontBold.html"
          },
          {
            "cid": 310,
            "sid": "GetHeaderFontColor",
            "name": "GetHeaderFontColor",
            "label": "GetHeaderFontColor",
            "data": {
              "body": "> 헤더행의 폰트 색상을 확인 합니다. ### Syntax ```javascript ObjId.GetHeaderFontColor(); ``` ### Info ***none*** ### Returns ***String, 폰트 색상 값*** ### Example ```javascript // 헤더행의 폰트 색상 확인. console.log(\"fontColor:\", mySheet.GetHeaderFontColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderFontColor.html"
          },
          {
            "cid": 311,
            "sid": "GetHeaderRowHeight",
            "name": "GetHeaderRowHeight",
            "label": "GetHeaderRowHeight",
            "data": {
              "body": "> 헤더행의 높이를 확인합니다. ### Syntax ```javascript ObjId.GetHeaderRowHeight(); ``` ### Info ***none*** ### Returns ***Number, 높이 값 (단위:px)*** ### Example ```javascript // 헤더행의 높이 확인. console.log(\"rowHeight:\", mySheet.GetHeaderRowHeight()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHeaderRowHeight.html"
          },
          {
            "cid": 312,
            "sid": "GetHighlightAfterSort",
            "name": "GetHighlightAfterSort",
            "label": "GetHighlightAfterSort",
            "data": {
              "body": "> sort 처리 후 이전 포커스 유지 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetHighlightAfterSort(); ``` ### Info ***Number, 포커스 유지 여부*** ### Returns ***none*** ### Example ```javascript // sort 처리 후 이전 포커스 유지 여부 확인 console.log(\"highlightAfterSort:\", mySheet.GetHighlightAfterSort()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetHighlightAfterSort.html"
          },
          {
            "cid": 313,
            "sid": "GetImageList",
            "name": "GetImageList",
            "label": "GetImageList",
            "data": {
              "body": "> Index에 해당 하는 이미지 경로를 확인 합니다. ### Syntax ```javascript ObjId.GetImageList(index); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |index|`Number`|<span class=\"required\">필수</span>|이미지의 Index| ### Returns ***String,해당 인덱스의 이미지 경로*** ### Example ```javascript // Index 가 1인 이미지 경로 확인 console.log(\"imgPath:\", mySheet.GetImageList(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetImageList.html"
          },
          {
            "cid": 314,
            "sid": "GetKeyFieldImage",
            "name": "GetKeyFieldImage",
            "label": "GetKeyFieldImage",
            "data": {
              "body": "> 필수 입력 항목에 대한 표시 이미지 경로를 확인 합니다. ### Syntax ```javascript ObjId.GetKeyFieldImage(); ``` ### Info ***none*** ### Returns ***String, 이미지 경로*** ### Example ```javascript // 필수 입력 항목에 대한 표시 이미지 경로 확인 console.log(\"imagePath:\", mySheet.GetKeyFieldImage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetKeyFieldImage.html"
          },
          {
            "cid": 315,
            "sid": "GetMouseHoverMode",
            "name": "GetMouseHoverMode",
            "label": "GetMouseHoverMode",
            "data": {
              "body": "> 현재 설정 되어있는 마우스 Hover 모드를 확인합니다. ### Syntax ```javascript ObjId.GetMouseHoverMode(); ``` ### Info ***none*** ### Returns ***Number, 설정된 모드*** ### Example ```javascript // Hover 모드 확인 console.log(\"hoverMode:\", mySheet.GetMouseHoverMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetMouseHoverMode.html"
          },
          {
            "cid": 316,
            "sid": "GetMousePointer",
            "name": "GetMousePointer",
            "label": "GetMousePointer",
            "data": {
              "body": "> 시트 내에서의 마우스 커서 모양을 확인 합니다. ### Syntax ```javascript ObjId.GetMousePointer(); ``` ### Info ***none*** ### Returns ***String, 마우스의 모양*** ### Example ```javascript // 마우스 커서 확인 console.log(\"mouseCursor:\", mySheet.GetMousePointer()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetMousePointer.html"
          },
          {
            "cid": 317,
            "sid": "GetMouseToolTipText",
            "name": "GetMouseToolTipText",
            "label": "GetMouseToolTipText",
            "data": {
              "body": "> 마우스 커서의 위치에 설정한 툴팁 문자열을 확인 합니다. ### Syntax ```javascript ObjId.GetMouseToolTipText(); ``` ### Info ***none*** ### Returns ***String, 설정한 툴팁 문자열*** ### Example ```javascript // 설정한 툴팁 문자열 확인 console.log(\"toolTip:\", mySheet.GetMouseToolTipText()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetMouseToolTipText.html"
          },
          {
            "cid": 318,
            "sid": "GetPageCount",
            "name": "GetPageCount",
            "label": "GetPageCount",
            "data": {
              "body": "> `SearchMode`에서 사용되는 Page 개수를 확인 합니다. ### Syntax ```javascript ObjId.GetPageCount(); ``` ### Info ***none*** ### Returns ***Number, Page 개수*** ### Example ```javascript // Page 개수 확인 console.log(\"page:\", mySheet.GetPageCount()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetPageCount.html"
          },
          {
            "cid": 319,
            "sid": "GetPagingPosition",
            "name": "GetPagingPosition",
            "label": "GetPagingPosition",
            "data": {
              "body": "> 페이지 내비게이션이 출력 되는 위치를 확인 합니다. ### Syntax ```javascript ObjId.GetPagingPosition(); ``` ### Info ***none*** ### Returns ***Number, 페이지 내비게이션 출력 위치*** ### Example ```javascript // 건수 정보 출력 위치 확인 console.log('pagingPosition: ', mySheet.GetPagingPosition()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetPagingPosition.html"
          },
          {
            "cid": 320,
            "sid": "GetRangeText",
            "name": "GetRangeText",
            "label": "GetRangeText",
            "data": {
              "body": "> 인자로 설정한 범위 영역에 대한 CellText 값을 구분자로 연결한 문자열로 반환합니다. ### Syntax ```javascript ObjId.GetRangeText(startRow, startCol, endRow, endCol, ColSeparator, RowSeparator); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |startRow|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Row Index| |startCol|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Column Index| |endRow|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Row Index| |endCol|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Column Index| |ColSeparator|`String`|<span class=\"optional\">선택</span>|컬럼과 컬럼 사이를 구분하는 구분자 (Default: `|`)| |RowSeparator|`String`|<span class=\"optional\">선택</span>|행과 행 사이를 구분하는 구분자 (Default: \"^\")| ### Returns ***String, 현재 문자열값*** ### Example ```javascript // (2, 1) ~ (4, 5) 범위의 CellText 값 확인 var value = mySheet.GetRangeText(2, 1, 4, 5), rows = [], cols = []; rows = value.split(\"^\"); for (var i = 0, maxRow = rows.length; i < maxRow; i++) { cols = rows[i].split(\"|\"); for (var j = 0, maxCol = cols.length; j < maxCol; j++) { console.log(\"cell[\" + i + \",\" + j + \"]\", cols[j]); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetRangeText.html"
          },
          {
            "cid": 321,
            "sid": "GetRangeValue",
            "name": "GetRangeValue",
            "label": "GetRangeValue",
            "data": {
              "body": "> 인자로 설정한 범위 영역에 대한 CellValue 값을 구분자로 연결한 문자열로 반환합니다. ### Syntax ```javascript ObjId.GetRangeValue(startRow, startCol, endRow, endCol, ColSeparator, RowSeparator); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |startRow|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Row Index| |startCol|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Column Index| |endRow|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Row Index| |endCol|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Column Index| |ColSeparator|`String`|<span class=\"optional\">선택</span>|컬럼과 컬럼 사이를 구분하는 구분자 (Default: `|`)| |RowSeparator|`String`|<span class=\"optional\">선택</span>|행과 행 사이를 구분하는 구분자 (Default: `^`)| ### Returns ***String, 현재 문자열값*** ### Example ```javascript // (2, 1) ~ (4, 5) 범위의 CellText 값 확인 var value = mySheet.GetRangeValue(2, 1, 4, 5), rows = [], cols = []; rows = value.split(\"^\"); for (var i = 0, maxRow = rows.length; i < maxRow; i++) { cols = rows[i].split(\"|\"); for (var j = 0, maxCol = cols.length; j < maxCol; j++) { console.log(\"cell[\" + i + \",\" + j + \"]\", cols[j]); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetRangeValue.html"
          },
          {
            "cid": 322,
            "sid": "GetSavingImage",
            "name": "GetSavingImage",
            "label": "GetSavingImage",
            "data": {
              "body": "> 저장중 대기 이미지의 url을 확인합니다. ### Syntax ```javascript ObjId.GetSavingImage(); ``` ### Info ***none*** ### Returns ***String, 저장중 대기 이미지 url*** ### Example ```javascript // 저장중 대기 이미지 url 확인 console.log('saveWaitImage: ', mySheet.GetSavingImage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSavingImage.html"
          },
          {
            "cid": 323,
            "sid": "GetScrollInfoFormat",
            "name": "GetScrollInfoFormat",
            "label": "GetScrollInfoFormat",
            "data": {
              "body": "> 세로스크롤에 대한 지연 처리 방법 사용시 지연 처리 시간 동안 출력되는 메시지 포맷을 확인 합니다. ### Syntax ```javascript ObjId.GetScrollInfoFormat(); ``` ### Info ***none*** ### Returns ***String, 설정 되어있는 스크롤 정보 메시지 포맷 문자열*** ### Example ```javascript // 설정 메시지 포맷 확인 console.log('format: ', mySheet.GetScrollInfoFormat()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetScrollInfoFormat.html"
          },
          {
            "cid": 324,
            "sid": "GetScrollInfoPosition",
            "name": "GetScrollInfoPosition",
            "label": "GetScrollInfoPosition",
            "data": {
              "body": "> 세로스크롤에 대한 지연 처리 방법 사용시 지연 처리 시간 동안 출력되는 메시지 출력 위치를 확인 합니다. ### Syntax ```javascript ObjId.GetScrollInfoPosition(); ``` ### Info ***none*** ### Returns ***String, 메시지 출력 위치*** ### Example ```javascript // 메시지 출력 위치 확인 console.log('msgPos: ', mySheet.GetScrollInfoPosition()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetScrollInfoPosition.html"
          },
          {
            "cid": 325,
            "sid": "GetSearchingImage",
            "name": "GetSearchingImage",
            "label": "GetSearchingImage",
            "data": {
              "body": "> 조회중 대기 이미지의 url을 확인 합니다. ### Syntax ```javascript ObjId.GetSearchingImage(); ``` ### Info ***none*** ### Returns ***String, 조회중 대기 이미지 url*** ### Example ```javascript // 조회중 대기 이미지 url 확인 console.log('searchWaitImage: ', mySheet.GetSearchingImage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSearchingImage.html"
          },
          {
            "cid": 326,
            "sid": "GetSelectCol",
            "name": "GetSelectCol",
            "label": "GetSelectCol",
            "data": {
              "body": "> 현재 선택된 셀의 컬럼 Index를 확인 합니다. ### Syntax ```javascript ObjId.GetSelectCol(); ``` ### Info ***none*** ### Returns ***Number, 선택된 셀의 컬럼 Index*** ### Example ```javascript // 선택된 셀의 컬럼 Index 확인. console.log(\"columnIndex:\", mySheet.GetSelectCol()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSelectCol.html"
          },
          {
            "cid": 327,
            "sid": "GetSelectRow",
            "name": "GetSelectRow",
            "label": "GetSelectRow",
            "data": {
              "body": "> 현재 선택된 셀의 행 Index를 확인 합니다. ### Syntax ```javascript ObjId.GetSelectRow(); ``` ### Info ***none*** ### Returns ***Number, 선택된 셀의 행 Index*** ### Example ```javascript // 선택된 셀의 행 Index 확인. console.log(\"rowIndex:\", mySheet.GetSelectRow()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSelectRow.html"
          },
          {
            "cid": 328,
            "sid": "GetSelectionCols",
            "name": "GetSelectionCols",
            "label": "GetSelectionCols",
            "data": {
              "body": "> 현재 선택 되어있는 컬럼의 Index를 인자로 설정한 구분자로 조합한 문자열을 반환 합니다. ### Syntax ```javascript ObjId.GetSelectionCols(DeliChar); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DeliChar|`String`|<span class=\"optional\">선택</span>|컬럼 구분자 (Default: `|`)| ### Returns ***String, 선택 되어있는 컬럼의 Index 조합 문자열*** ### Example ```javascript // 핸재 선택되어있는 컬럼의 Index 확인 var cols = mySheet.GetSelectionCols(); if (cols.length > 0) { cols = cols.split(\"|\"); for (var i = 0, len = cols.length; i < len; i++) { var col = cols[i]; console.log(\"selectedCol \" + (i + 1) + \":\", col); } } else { console.log(\"selectedCol is none\"); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSelectionCols.html"
          },
          {
            "cid": 329,
            "sid": "GetSelectionMode",
            "name": "GetSelectionMode",
            "label": "GetSelectionMode",
            "data": {
              "body": "> 포커스 선택 모드를 확인합니다. ### Syntax ```javascript ObjId.GetSelectionMode(); ``` ### Info ***none*** ### Returns ***Number, 설정 되어 있는 선택 모드 값*** ### Example ```javascript // 선택모드 확인 console.log(\"selectionMode:\", mySheet.GetSelectionMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSelectionMode.html"
          },
          {
            "cid": 330,
            "sid": "GetSelectionRows",
            "name": "GetSelectionRows",
            "label": "GetSelectionRows",
            "data": {
              "body": "> 사용자가 드레그를 통해 선택한 영역의 행을 구분자로 구분하여 반환합니다. > 구분자를 설정하지 않으면 기본적으로 `|`로 묶어서 반환합니다. ### Syntax ```javascript ObjId.GetSelectionRows(DeliChar); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DeliChar|`String`|<span class=\"optional\">선택</span>|컬럼 구분자 (Default: `|`)| ### Returns ***String, 선택 되어있는 행의 Index 조합 문자열*** ### Example ```javascript // 핸재 선택되어있는 행의 Index 확인 var rows = mySheet.GetSelectionRows(); if (rows.length > 0) { rows = rows.split(\"|\"); for (var i = 0, len = rows.length; i < len; i++) { var row = rows[i]; console.log(\"selectedRow \" + (i + 1) + \":\", row); } } else { console.log(\"selectedRow is none\"); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSelectionRows.html"
          },
          {
            "cid": 331,
            "sid": "GetSelectionSummaryInfoElement",
            "name": "GetSelectionSummaryInfoElement",
            "label": "GetSelectionSummaryInfoElement",
            "data": {
              "body": "> 선택 요약 정보 출력 대상 Dom Element를 확인 합니다. ### Syntax ```javascript ObjId.GetSelectionSummaryInfoElement(); ``` ### Info ***none*** ### Returns ***Object, 선택 요약 정보 출력 대상 Dom Element*** ### Example ```javascript // 선택 요약 정보가 출력 되는 Dom Element 확인 console.log('element: ', mySheet.GetSelectionSummaryInfoElement()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSelectionSummaryInfoElement.html"
          },
          {
            "cid": 332,
            "sid": "GetSendComboData",
            "name": "GetSendComboData",
            "label": "GetSendComboData",
            "data": {
              "body": "> `Combo`, `ComboEdit` 타입의 데이터에 대한 저장시 전송될 데이터 타입을 확인 합니다. ### Syntax ```javascript ObjId.GetSendComboData(DataRow, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DataRow|`Number`|<span class=\"required\">필수</span>|단위 데이터 행 Index| |Col|`Long or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName| ### Returns ***String, 데이터 타입 설정 값*** ### Example ```javascript // Index가 5인 컬럼에 대한 전송 데이터 타입 확인 console.log(\"sendType:\", mySheet.GetSendComboData(0, 5)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSendComboData.html"
          },
          {
            "cid": 333,
            "sid": "GetSheetHeight",
            "name": "GetSheetHeight",
            "label": "GetSheetHeight",
            "data": {
              "body": "> 전체 높이를 확인 합니다. ### Syntax ```javascript ObjId.GetSheetHeight(); ``` ### Info ***none*** ### Returns ***Number, 전체 높이 (단위:px)*** ### Example ```javascript // 시트의 전체 높이 확인 console.log(\"sheetHeight:\", mySheet.GetSheetHeight()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSheetHeight.html"
          },
          {
            "cid": 334,
            "sid": "GetSheetHtml",
            "name": "GetSheetHtml",
            "label": "GetSheetHtml",
            "data": {
              "body": "> 현재 화면에 보여지는 시트에 대한 html 코드를 반환 합니다. ### Syntax ```javascript ObjId.GetSheetHtml(); ``` ### Info ***none*** ### Returns ***Object (style, body로 이루어진 객체)*** * Returns Object Info |Name|Type|Description| |----|----|-----------| |result|`Object`|옵션 객체 - `style` : 테마의 css 문자열 - `body` : html 태그 문자열| ### Example ```javascript // 시트의 html tag 정보 확인 console.log(\"htmlInfo:\", mySheet.GetSheetHtml()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSheetHtml.html"
          },
          {
            "cid": 335,
            "sid": "GetSheetWidth",
            "name": "GetSheetWidth",
            "label": "GetSheetWidth",
            "data": {
              "body": "> 전체 너비를 확인 합니다. ### Syntax ```javascript ObjId.GetSheetWidth(); ``` ### Info ***none*** ### Returns ***Number, 전체 너비 (단위:px)*** ### Example ```javascript // 시트의 전체 너비 확인 console.log(\"sheetWidth:\", mySheet.GetSheetWidth()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetSheetWidth.html"
          },
          {
            "cid": 336,
            "sid": "GetShowButtonImage",
            "name": "GetShowButtonImage",
            "label": "GetShowButtonImage",
            "data": {
              "body": "> `Popup`, `Combo`, `Date` 데이터 타입 등에서의 버튼 이미지에 대한 표시 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetShowButtonImage(); ``` ### Info ***none*** ### Returns ***Number, 버튼 이미지 표시 방법*** ### Example ```javascript // 버튼 이미지 표시 방법 확인 console.log(\"buttonImageMode:\", mySheet.GetShowButtonImage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetShowButtonImage.html"
          },
          {
            "cid": 337,
            "sid": "GetShowMsgMode",
            "name": "GetShowMsgMode",
            "label": "GetShowMsgMode",
            "data": {
              "body": "> 메시지를 시스템 팝업으로 표시할지 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetShowMsgMode(); ``` ### Info ***none*** ### Returns ***Boolean, 시스템 팝업 사용 여부*** ### Example ```javascript // 메시지모드 확인 console.log(\"msgMode:\", mySheet.GetShowMsgMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetShowMsgMode.html"
          },
          {
            "cid": 338,
            "sid": "GetShowSortArrow",
            "name": "GetShowSortArrow",
            "label": "GetShowSortArrow",
            "data": {
              "body": "> 헤더 클릭시 Sort 정보를 나타내는 이미지 표시 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetShowSortArrow(); ``` ### Info ***none*** ### Returns ***Boolean, 이미지 표시 여부*** ### Example ```javascript // Sort 이미지 표시 여부 확인 console.log(\"sortInfo:\", mySheet.GetShowSortArrow()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetShowSortArrow.html"
          },
          {
            "cid": 339,
            "sid": "GetTabBehavior",
            "name": "GetTabBehavior",
            "label": "GetTabBehavior",
            "data": {
              "body": "> 포커스 상태에서 Tab 키 입력에 대한 동작 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetTabBehavior(); ``` ### Info ***none*** ### Returns ***String, Tab 키 입력에 대한 동작 방법*** ### Example ```javascript // 포커스시 Tab 키 동작 방법 확인 console.log(\"enterBehavior:\", mySheet.GetTabBehavior()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetTabBehavior.html"
          },
          {
            "cid": 340,
            "sid": "GetTabIndex",
            "name": "GetTabIndex",
            "label": "GetTabIndex",
            "data": {
              "body": "> 시트의 TabIndex 를 확인합니다. ### Syntax ```javascript ObjId.GetTabIndex(); ``` ### Info ***none*** ### Returns ***Number, tabIndex*** ### Example ```javascript // TabIndex 정보 확인 하기 var tabindex= mySheet.GetTabIndex(); ``` ### Since |version|desc| |---|---| |7.0.13.100||",
              "since": "|version|desc||---|---||7.0.13.100||"
            },
            "url": "docs/funcs/core/GetTabIndex.html"
          },
          {
            "cid": 341,
            "sid": "GetTheme",
            "name": "GetTheme",
            "label": "GetTheme",
            "data": {
              "body": "> 현재 설정되어 있는 테마를 확인 합니다. ### Syntax ```javascript ObjId.GetTheme(); ``` ### Info ***none*** ### Returns ***String, 테마에서 사용하는 class의 prefix 값*** ### Example ```javascript // 테마 확인 console.log(\"theme:\", mySheet.GetTheme()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetTheme.html"
          },
          {
            "cid": 342,
            "sid": "GetTotalRows",
            "name": "GetTotalRows",
            "label": "GetTotalRows",
            "data": {
              "body": "> 조회해야 할 전체 조회 대상 건수를 확인 합니다. ### Syntax ```javascript ObjId.GetTotalRows(); ``` ### Info ***none*** ### Returns ***Number, 전체 조회 대상 건수*** ### Example ```javascript // 전제 조회 대상 건수를 확인 한다. console.log(\"totalRows:\", mySheet.GetTotalRows()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetTotalRows.html"
          },
          {
            "cid": 343,
            "sid": "GetUnicodeByte",
            "name": "GetUnicodeByte",
            "label": "GetUnicodeByte",
            "data": {
              "body": "> 2byte 이상의 문자에 대한 처리할 byte 설정 값을 확인 합니다. ### Syntax ```javascript ObjId.GetUnicodeByte(); ``` ### Info ***none*** ### Returns ***Number or String, 설정 값*** ### Example ```javascript // 2byte 이상의 문자에 대한 처리할 byte 설정 값 확인 console.log(\"unicodeByte:\", mySheet.GetUnicodeByte()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetUnicodeByte.html"
          },
          {
            "cid": 344,
            "sid": "GetUploadingImage",
            "name": "GetUploadingImage",
            "label": "GetUploadingImage",
            "data": {
              "body": "> 업로드중 대기 이미지의 url을 확인 합니다. ### Syntax ```javascript ObjId.GetUploadingImage(); ``` ### Info ***none*** ### Returns ***String, 업로드중 대기 이미지 url*** ### Example ```javascript // 업로드중 대기 이미지 url 확인 console.log('uploadWaitImage: ', mySheet.GetUploadingImage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetUploadingImage.html"
          },
          {
            "cid": 345,
            "sid": "GetUseDefaultTime",
            "name": "GetUseDefaultTime",
            "label": "GetUseDefaultTime",
            "data": {
              "body": "> 셀의 Format 이 `Hm` 또는 `Hms` 이고, 데어터가 빈 값인 경우, 편집 모드 변경시 시스템의 현재 시간을 기본으로 설정할지 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetUseDefaultTime(); ``` ### Info ***none*** ### Returns ***Boolean, 현재 시간 표시 여부*** ### Example ```javascript // 현재 시간 기본으로 설정 여부 확인 console.log(\"useDefaultTime:\", mySheet.GetUseDefaultTime()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetUseDefaultTime.html"
          },
          {
            "cid": 346,
            "sid": "GetUserAgent",
            "name": "GetUserAgent",
            "label": "GetUserAgent",
            "data": {
              "body": "> 조회나 저장시 HTTP 헤더 정보에 포함되어 넘어가는 IBUserAgent의 값을 확인 합니다. ### Syntax ```javascript ObjId.GetUserAgent(); ``` ### Info ***none*** ### Returns ***String, 설정된 UserAgent 값*** ### Example ```javascript // IBUserAgent 설정값 확인 console.log(\"useAgent:\", mySheet.GetUserAgent()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetUserAgent.html"
          },
          {
            "cid": 347,
            "sid": "GetVisible",
            "name": "GetVisible",
            "label": "GetVisible",
            "data": {
              "body": "> 시트 표시 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetVisible(); ``` ### Info ***none*** ### Returns ***Boolean, 시트 표시 여부*** ### Example ```javascript // 시트의 표시 여부를 확인 한다. console.log(\"sheetVisible:\", mySheet.GetVisible()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetVisible.html"
          },
          {
            "cid": 348,
            "sid": "GetWaitImage",
            "name": "GetWaitImage",
            "label": "GetWaitImage",
            "data": {
              "body": "> 처리중 대기 이미지의 url을 확인 합니다. ### Syntax ```javascript ObjId.GetWaitImage(); ``` ### Info ***none*** ### Returns ***String, 처리중 대기 이미지 url*** ### Example ```javascript // 처리중 대기 이미지 url 확인 console.log('waitImage: ', mySheet.GetWaitImage()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetWaitImage.html"
          },
          {
            "cid": 349,
            "sid": "GetWaitImageVisible",
            "name": "GetWaitImageVisible",
            "label": "GetWaitImageVisible",
            "data": {
              "body": "> 조회, 저장, 다운로드 등의 기능이 진행중인 동안 표시되는 대기 이미지에 대한 사용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetWaitImageVisible(); ``` ### Info ***none*** ### Returns ***Boolean, 대기 이미지 사용 여부*** ### Example ```javascript // 대기 이미지 사용 여부 확인 console.log('useWaitImage: ', mySheet.GetWaitImageVisible()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetWaitImageVisible.html"
          },
          {
            "cid": 350,
            "sid": "GetWaitTimeOut",
            "name": "GetWaitTimeOut",
            "label": "GetWaitTimeOut",
            "data": {
              "body": "> 조회, 저장 등 서버의 응답을 받는 경우 대기할 응답 대기 시간을 확인 합니다. ### Syntax ```javascript ObjId.GetWaitTimeOut(); ``` ### Info ***none*** ### Returns ***Number, 서버 응답 대기 시간*** ### Example ```javascript // 서버 응답 대기 시간 확인 console.log('waitTimeout: ', mySheet.GetWaitTimeOut()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GetWaitTimeOut.html"
          },
          {
            "cid": 351,
            "sid": "GoToFirstPage",
            "name": "GoToFirstPage",
            "label": "GoToFirstPage",
            "data": {
              "body": "> 가장 첫번째의 페이지로 이동 합니다. > `주의` 이 기능을 사용하기 위해서는 `SetConfig` 메소드에서 `SearchMode` 속성을 이용하여 `페이징 모드(1)`로 설정 해야 합니다. ### Syntax ```javascript ObjId.GoToFirstPage(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 페이징 모드 설정 mySheet.SetConfig({ \"SearchMode\": 1, \"Page\": 30 }); // 가장 첫번째의 페이지로 이동 mySheet.GoToFirstPage(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GoToFirstPage.html"
          },
          {
            "cid": 352,
            "sid": "GoToLastPage",
            "name": "GoToLastPage",
            "label": "GoToLastPage",
            "data": {
              "body": "> 가장 마지막의 페이지로 이동 합니다. > `주의` 이 기능을 사용하기 위해서는 `SetConfig` 메소드에서 `SearchMode` 속성을 이용하여 `페이징 모드(1)`로 설정 해야 합니다. ### Syntax ```javascript ObjId.GoToLastPage(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 페이징 모드 설정 mySheet.SetConfig({ \"SearchMode\": 1, \"Page\": 30 }); // 가장 마지막의 페이지로 이동 mySheet.GoToLastPage(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GoToLastPage.html"
          },
          {
            "cid": 353,
            "sid": "GoToNextPage",
            "name": "GoToNextPage",
            "label": "GoToNextPage",
            "data": {
              "body": "> 현재 페이지의 다음 페이지로 이동 합니다. > `주의` 이 기능을 사용하기 위해서는 `SetConfig` 메소드에서 `SearchMode` 속성을 이용하여 `페이징 모드(1)`로 설정 해야 합니다. ### Syntax ```javascript ObjId.GoToNextPage(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 페이징 모드 설정 mySheet.SetConfig({ \"SearchMode\": 1, \"Page\": 30 }); // 다음 페이지로 이동 mySheet.GoToNextPage(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GoToNextPage.html"
          },
          {
            "cid": 354,
            "sid": "GoToPageNum",
            "name": "GoToPageNum",
            "label": "GoToPageNum",
            "data": {
              "body": "> `page` 인자로 입력한 번호의 페이지로 이동 합니다. > `주의` 이 기능을 사용하기 위해서는 `SetConfig` 메소드에서 `SearchMode` 속성을 이용하여 `페이징 모드(1)`로 설정 해야 합니다. ### Syntax ```javascript ObjId.GoToPageNum(page); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |page|`Number`|<span class=\"required\">필수</span>|이동할 페이지 Index| ### Returns ***none*** ### Example ```javascript // 페이징 모드 설정 mySheet.SetConfig({ \"SearchMode\": 1, \"Page\": 30 }); // 5번째 페이지로 이동 mySheet.GoToPageNum(5); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GoToPageNum.html"
          },
          {
            "cid": 355,
            "sid": "GoToPrevPage",
            "name": "GoToPrevPage",
            "label": "GoToPrevPage",
            "data": {
              "body": "> 현재 페이지의 이전 페이지로 이동 합니다. > `주의` 이 기능을 사용하기 위해서는 `SetConfig` 메소드에서 `SearchMode` 속성을 이용하여 `페이징 모드(1)`로 설정 해야 합니다. ### Syntax ```javascript ObjId.GoToPrevPage(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 페이징 모드 설정 mySheet.SetConfig({ \"SearchMode\": 1, \"Page\": 30 }); // 이전 페이지로 이동 mySheet.GoToPrevPage(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/GoToPrevPage.html"
          },
          {
            "cid": 356,
            "sid": "HeaderRows",
            "name": "HeaderRows",
            "label": "HeaderRows",
            "data": {
              "body": "> 헤더행의 개수를 확인합니다. ### Syntax ```javascript ObjId.HeaderRows(); ``` ### Info ***none*** ### Returns ***Number, 헤더행의 개수*** ### Example ```javascript // 헤더행의 개수 확인. console.log(\"headerRows:\", mySheet.HeaderRows()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/HeaderRows.html"
          },
          {
            "cid": 357,
            "sid": "HideProcessDlg",
            "name": "HideProcessDlg",
            "label": "HideProcessDlg",
            "data": {
              "body": "> 출력되어 있는 대기중 이미지를 닫습니다. ### Syntax ```javascript ObjId.HideProcessDlg(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 대기중 이미지 닫기 mySheet.HideProcessDlg(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/HideProcessDlg.html"
          },
          {
            "cid": 358,
            "sid": "InitComboNoMatchText",
            "name": "InitComboNoMatchText",
            "label": "InitComboNoMatchText",
            "data": {
              "body": "> 데이터 타입이 `Combo`, `ComboEdit`인 경우 설정한 리스트 항목에 없는 데이터가 설정 되었을때의 처리 방법을 설정 합니다. ### Syntax ```javascript ObjId.InitComboNoMatchText(Show, Text, Insert, Auto); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Show|`Boolean`|<span class=\"required\">필수</span>|항목에 없는 데이터를 보여줄지 여부| |Text|`String`|<span class=\"optional\">선택</span>|항목에 없는 데이터 대신 표시할 문자열| |Insert|`Boolean`|<span class=\"optional\">선택</span>|해당 데이터를 항목에 추가 할지 여부| |Auto|`Boolean`|<span class=\"optional\">선택</span>|해당 데이터를 표시만 하고 항목에는 추가하지 않도록 설정 여부| ### Returns ***none*** ### Example ```javascript // 항목에 없는 데이터인 경우 '항목없음'으로 표시하도록 설정 mySheet.InitComboNoMatchText(1, '항목없음'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/InitComboNoMatchText.html"
          },
          {
            "cid": 359,
            "sid": "IsDataModified",
            "name": "IsDataModified",
            "label": "IsDataModified",
            "data": {
              "body": "> IBSheet의 데이터의 트랜잭션 발생 여부를 확인 합니다. ### Syntax ```javascript ObjId.IsDataModified(); ``` ### Info ***none*** ### Returns ***Boolean, 데이터의 트랜잭션 발생 여부*** ### Example ```javascript // 저장시 데이터 트랜잭션 발생 여부에 따른 분기 처리 if (mySheet.IsDataModified()) { // 저장 처리 mySheet.DoSave('save.jsp'); } else { console.log('저장 대상 데이터가 없습니다.'); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/IsDataModified.html"
          },
          {
            "cid": 360,
            "sid": "IsFocused",
            "name": "IsFocused",
            "label": "IsFocused",
            "data": {
              "body": "> 시트의 Focus 상태 여부를 확인합니다. ### Syntax ```javascript ObjId.IsFocused(); ``` ### Info ***none*** ### Returns ***Boolean, Focus 상태*** ### Example ```javascript // 시트의 Focus 여부 확인 console.log(\"focused\", mySheet.IsFocused()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/IsFocused.html"
          },
          {
            "cid": 361,
            "sid": "RangeBackColor",
            "name": "RangeBackColor",
            "label": "RangeBackColor",
            "data": {
              "body": "> 특정 범위의 셀 영역에 대한 배경색을 설정 합니다. ### Syntax ```javascript ObjId.RangeBackColor(StartRow, StartCol, EndRow, EndCol, Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |StartRow|`Number`|<span class=\"required\">필수</span>|범위 시작 셀의 Row Index| |StartCol|`Number`|<span class=\"required\">필수</span>|범위 시작 셀의 Column Index| |EndRow|`Number`|<span class=\"required\">필수</span>|범위 종료 셀의 Row Index| |EndCol|`Number`|<span class=\"required\">필수</span>|범위 종료 셀의 Column Index| |Color|`String`|<span class=\"required\">필수</span>|WebColor| ### Returns ***none*** ### Example ```javascript // (2, 2) ~ (3, 5) 영역의 셀 배경색을 \"red\"로 설정 mySheet.RangeBackColor(2, 2, 3, 5, \"red\"); mySheet.RangeBackColor(2, 2, 3, 5, \"#ff0000\"); ``` ### Since |version|desc| |---|---| |7.0.13.16||",
              "since": "|version|desc||---|---||7.0.13.16||"
            },
            "url": "docs/funcs/core/RangeBackColor.html"
          },
          {
            "cid": 362,
            "sid": "RangeFontBold",
            "name": "RangeFontBold",
            "label": "RangeFontBold",
            "data": {
              "body": "> 특정 범위의 셀 영역에 bold 적용 여부를 설정 합니다. ### Syntax ```javascript ObjId.RangeFontBold(StartRow, StartCol, EndRow, EndCol, Bold); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |StartRow|`Number`|<span class=\"required\">필수</span>|범위 시작 셀의 Row Index| |StartCol|`Number`|<span class=\"required\">필수</span>|범위 시작 셀의 Column Index| |EndRow|`Number`|<span class=\"required\">필수</span>|범위 종료 셀의 Row Index| |EndCol|`Number`|<span class=\"required\">필수</span>|범위 종료 셀의 Column Index| |Bold|`Boolean`|<span class=\"required\">필수</span>|폰트 볼드 여부| ### Returns ***none*** ### Example ```javascript // (2, 2) ~ (3, 5) 영역의 폰트에 bold 적용 mySheet.RangeFontBold(2, 2, 3, 5, 1); ``` ### Since |version|desc| |---|---| |7.0.13.16||",
              "since": "|version|desc||---|---||7.0.13.16||"
            },
            "url": "docs/funcs/core/RangeFontBold.html"
          },
          {
            "cid": 363,
            "sid": "RangeFontColor",
            "name": "RangeFontColor",
            "label": "RangeFontColor",
            "data": {
              "body": "> 특정 범위의 셀 영역에 대한 폰트 색상을 설정 합니다. ### Syntax ```javascript ObjId.RangeFontColor(StartRow, StartCol, EndRow, EndCol, Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |StartRow|`Number`|<span class=\"required\">필수</span>|범위 시작 셀의 Row Index| |StartCol|`Number`|<span class=\"required\">필수</span>|범위 시작 셀의 Column Index| |EndRow|`Number`|<span class=\"required\">필수</span>|범위 종료 셀의 Row Index| |EndCol|`Number`|<span class=\"required\">필수</span>|범위 종료 셀의 Column Index| |Color|`String`|<span class=\"required\">필수</span>|설정할 색상값| ### Returns ***none*** ### Example ```javascript // (2, 2) ~ (3, 5) 영역의 폰트 색상을 blue로 설정 mySheet.RangeFontColor(2, 2, 3, 5, \"blue\"); mySheet.RangeFontColor(2, 2, 3, 5, \"#0000ff\"); ``` ### Since |version|desc| |---|---| |7.0.13.16||",
              "since": "|version|desc||---|---||7.0.13.16||"
            },
            "url": "docs/funcs/core/RangeFontColor.html"
          },
          {
            "cid": 364,
            "sid": "ReNumberSeq",
            "name": "ReNumberSeq",
            "label": "ReNumberSeq",
            "data": {
              "body": "> Seq 컬럼의 순번을 재설정합니다. ### Syntax ```javascript ObjId.ReNumberSeq([Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.Order|`String`|<span class=\"optional\">선택</span>|넘버링 처리 방식 - `asc` : 오름차순 (Default) - `desc` : 내림차순| |Opt.VisibleRow|`Boolean`|<span class=\"optional\">선택</span>|숨김행 Seq 적용 여부 (Default: 0)| ### Returns ***none*** ### Example ```javascript // 내림 차순으로 재설정 처리 mySheet.ReNumberSeq(\"desc\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ReNumberSeq.html"
          },
          {
            "cid": 365,
            "sid": "RemoveAll",
            "name": "RemoveAll",
            "label": "RemoveAll",
            "data": {
              "body": "> 헤더행을 제외한 모든 데이터 행을 제거 합니다. ### Syntax ```javascript ObjId.RemoveAll([opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |opt|`Object`|<span class=\"optional\">선택</span>|설정하고자 하는 시트 데이터행 삭제 옵션| |opt.SumRow|`Object`|<span class=\"optional\">선택</span>|AutoSum 컬럼만 지우도록 설정| ### Returns ***none*** ### Example ```javascript // 시트의 데이터영역 클리어 처리 mySheet.RemoveAll(); // AutoSum 컬럼만 지우기 var opt = { \"SumRow\" : \"AutoSum\" }; mySheet.RemoveAll(opt); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/RemoveAll.html"
          },
          {
            "cid": 366,
            "sid": "RemoveEtcData",
            "name": "RemoveEtcData",
            "label": "RemoveEtcData",
            "data": {
              "body": "> EtcData에 설정된 객체를 모두 제거합니다. ### Syntax ```javascript ObjId.RemoveEtcData(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // EtcData 클리어 처리 mySheet.RemoveEtcData(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/RemoveEtcData.html"
          },
          {
            "cid": 367,
            "sid": "RenderSheet",
            "name": "RenderSheet",
            "label": "RenderSheet",
            "data": {
              "body": "> 시트의 랜더링 처리 여부 설정 합니다. > `0` 설정 시점 이후 부터 `1` 설정 시점 이전까지 랜더링 처리를 중단하고, `1` 설정 시점에 시트 전체에 대한 랜더링 처리를 합니다. > 댜량의 `ColHidden`, `DataInsert`, `InitCellProperty` 를 처리하는 경우 성능 개선을 위해 이 기능을 사용 합니다. > 설정 값이 `2`인 경우는 강제적으로 시트 전체에 대한 랜더링 처리를 합니다. ### Syntax ```javascript ObjId.RenderSheet(Render); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Render|`Number`|<span class=\"required\">필수</span>|설정값 - `0` : 설정 이후 랜더링을 처리하지 않음 - `1` : 이전 처리에 대한 랜더링 처리함 - `2` : 시트 전체를 강제 랜더링함| ### Returns ***none*** ### Example ```javascript // 다량의 ColHidden 처리 mySheet.RenderSheet(0); for (var i = 0; i < 50; i++) { mySheet.SetColHidden(i, 1); } mySheet.RenderSheet(1); // 강제 랜더링 처리 mySheet.RenderSheet(2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/RenderSheet.html"
          },
          {
            "cid": 368,
            "sid": "Reset",
            "name": "Reset",
            "label": "Reset",
            "data": {
              "body": "> 초기 로드시 설정된 모든 기본 속성을 제거하고 초기 상태로 되돌립니다. ### Syntax ```javascript ObjId.Reset(KeepTheme); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |KeepTheme|`Boolean`|<span class=\"optional\">선택</span>|적용되어 있는 테마 유지 여부 (Default: 0)| ### Returns ***Object, 새로 생성된 시트 객체*** ### Example ```javascript // 이전 설정을 클리어하고 다시 초기화 설정 처리 mySheet.Reset(); IBS_InitSheet(mySheet, info); // 이전 설정했던 테마를 유지하고 클리어 처리 mySheet.Reset(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/Reset.html"
          },
          {
            "cid": 369,
            "sid": "RowCount",
            "name": "RowCount",
            "label": "RowCount",
            "data": {
              "body": "> 전체 데이터 행의 개수를 확인합니다. > Status 값을 인자로 전달하지 않은 경우 조회된 데이터 행 개수와 신규 입력된 행까지 포함한 전체 데이터 행 개수를 확인합니다. > Status 값에 따라 조회 / 입력 / 수정 / 삭제 각 상태의 행 개수를 확인 할 수 있습니다. ### Syntax ```javascript ObjId.RowCount(Status) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Status|`String`|<span class=\"optional\">선택</span>|트랜잭션 코드 - `\"\"` : 모든 행 - `R` : 상태값이 조회인 행 - `I` : 상태값이 입력인 행 - `U` : 상태값이 수정인 행 - `D` : 상태값이 삭제인 행 - `H` : 히든 처리된 행| ### Returns ***Number, 행의 개수*** ### Example ```javascript // 모든 행의 개수 확인 console.log(\"rowCount:\", mySheet.RowCount()); // 상태값이 입력인 행의 개수 확인 console.log(\"rowCount(I):\", mySheet.RowCount(\"I\")); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/RowCount.html"
          },
          {
            "cid": 370,
            "sid": "SearchRows",
            "name": "SearchRows",
            "label": "SearchRows",
            "data": {
              "body": "> 조회된 데이터 건수를 확인 합니다. ### Syntax ```javascript ObjId.SearchRows(); ``` ### Info ***none*** ### Returns ***Number, 행의 개수*** ### Example ```javascript // 조회된 행의 개수 확인 console.log(\"searchRows:\", mySheet.SearchRows()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SearchRows.html"
          },
          {
            "cid": 371,
            "sid": "SelectCell",
            "name": "SelectCell",
            "label": "SelectCell",
            "data": {
              "body": "> 특정 셀에 포커스를 설정 합니다. > Focus 인자 속성값을 `0`으로 설정한 경우 Edit 속성 설정과 무관하게 편집모드 설정이 불가능합니다. ### Syntax ```javascript ObjId.SelectCell(Row, Col, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|선택할 셀의 Row Index| |Col|`Long or String`|<span class=\"required\">필수</span>|선택할 셀의 Column Index 또는 SaveName| |Opt|`Object`|<span class=\"optional\">선택</span>|설정 옵션 객체| |Opt.Edit|`Boolean`|<span class=\"optional\">선택</span>|셀 선택시 편집모드 여부를 설정 (Default: 0)| |Opt.EditText|`String`|<span class=\"optional\">선택</span>|Edit 속성이 1일때 편집상태의 문자열 설정 (Defulat: \"\")| |Opt.SelectEditText|`Boolean`|<span class=\"optional\">선택</span>|편집시 기존 값에 대한 select 처리 여부 (Default: 1)| |Opt.Event|`Boolean`|<span class=\"optional\">선택</span>|OnSelectCell 이벤트 발생 여부 (Default: 1)| |Opt.Focus|`Boolean`|<span class=\"optional\">선택</span>|셀 선택후 포커스 처리 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // (5, 3) 셀로 포커스 이동. mySheet.SelectCell(5, 3); // (5, 3) 셀로 포커스 이동 후 편집모드로 전환. mySheet.SelectCell(5, 3, { \"Edit\" : 1 }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SelectCell.html"
          },
          {
            "cid": 372,
            "sid": "SetActionMenu",
            "name": "SetActionMenu",
            "label": "SetActionMenu",
            "data": {
              "body": "> 데이터 영역에서 사용 할 컨텍스트 메뉴를 설정 합니다. > 컨텍스트 메뉴의 구성에 따라 `object` 형식 또는 `string` 형식으로 설정 할 수 있습니다. (메뉴 사이에 구분선을 넣고자 하는 경우에는 `*-`을 사용) > `menu` 인자를 빈값으로 설정하면 이전에 설정한 컨텍스트 메뉴가 초기화 됩니다. 동적으로 컨텍스트 메뉴를 사용하지 않고자 할때 menu 인자를 빈값으로 설정하여 사용합니다. > 컨텍스트 메뉴의 항목을 선택하면 `OnSelectMenu` 이벤트가 발생하며, 해당 메뉴에 대한 처리를 할 수 있습니다. ### Syntax ```javascript ObjId.SetActionMenu([menu], Code); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |menu|`Array<Object> or String`|<span class=\"required\">필수</span>|컨텍스트 메뉴 객체 또는 설정할 팝업메뉴 문자열 (구분자 `|`로 연결한 문자열)| |menu.Text|`String`|<span class=\"required\">필수</span>|항목의 문자열| |menu.Code|`String`|<span class=\"optional\">선택</span>|항목의 코드| |menu.Icon|`String`|<span class=\"optional\">선택</span>|항목이 좌측에 표시할 아이콘 url| |menu.Items|`Array<object>`|<span class=\"optional\">선택</span>|해당 메뉴 항목의 자식 메뉴 배열 집합| |Code|`String`|<span class=\"optional\">선택</span>|컨텍스트 메뉴 코드 (menu 인자가 string 형태인 경우에만 사용)| ### Returns ***none*** ### Example ```javascript // 컨텍스트 메뉴 설정 (간단한 방법 : 메뉴만 설정) mySheet.SetActionMenu('행입력|행복사|*-|행삭제|*-|엑셀다운로드'); // 컨텍스트 메뉴 설정 (간단한 방법 : 메뉴와 코드 설정) mySheet.SetActionMenu('행입력|행복사|*-|행삭제|*-|엑셀다운로드', 'Insert|Copy||Del||Export'); // 컨텍스트 메뉴 설정 (object 형태 : 일반) mySheet.SetActionMenu([ {\"Text\": \"행입력\", \"Code\": \"Insert\"}, {\"Text\": \"행복사\", \"Code\": \"Copy\"}, {\"Text\": \"*-\"}, {\"Text\": \"행삭제\", \"Code\": \"Del\"}, {\"Text\": \"*-\"}, {\"Text\": \"엑셀다운로드\", \"Code\": \"Export\"} ]); // 컨텍스트 메뉴 설정 (object 형태 : 계층구조) mySheet.SetActionMenu([ {\"Text\": \"행입력\", \"Code\": \"Insert\", \"Items\": [ {\"Text\": \"첫행 입력\", \"Code\": \"InsertFirst\"}, {\"Text\": \"마지막행 입력\", \"Code\": \"InsertLast\"} ]}, {\"Text\": \"행복사\", \"Code\": \"Copy\"}, {\"Text\": \"*-\"}, {\"Text\": \"행삭제\", \"Code\": \"Del\"}, {\"Text\": \"*-\"}, {\"Text\": \"엑셀다운로드\", \"Code\": \"Export\"} ]); // 컨텍스트 메뉴 설정 (object 형태 : 아이콘 사용) mySheet.SetActionMenu([ {\"Text\": \"행입력\", \"Code\": \"Insert\", \"Icon\": \"ico_insert.gif\"}, {\"Text\": \"행복사\", \"Code\": \"Copy\", \"Icon\": \"ico_copy.gif\"}, {\"Text\": \"*-\"}, {\"Text\": \"행삭제\", \"Code\": \"Del\", \"Icon\": \"ico_del.gif\"}, {\"Text\": \"*-\"}, {\"Text\": \"엑셀다운로드\", \"Code\": \"Export\", \"Icon\": \"ico_export.gif\"} ]); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetActionMenu.html"
          },
          {
            "cid": 373,
            "sid": "SetAllowCheck",
            "name": "SetAllowCheck",
            "label": "SetAllowCheck",
            "data": {
              "body": "> 사용자가 체크박스의 값 변경시, 값의 변경을 수용할 지의 여부를 설정합니다. ### Syntax ```javascript ObjId.SetAllowCheck(allow); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |allow|`Boolean`|<span class=\"required\">필수</span>|값의 변경 수용여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 체크박스의 값 변경을 허용하지 않도록 설정 mySheet.SetAllowCheck(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetAllowCheck.html"
          },
          {
            "cid": 374,
            "sid": "SetAutoRowHeight",
            "name": "SetAutoRowHeight",
            "label": "SetAutoRowHeight",
            "data": {
              "body": "> 데이터 행의 높이를 데이터에 맞게 자동으로 조정할지 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetAutoRowHeight(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Boolean`|<span class=\"required\">필수</span>|높이 자동 조정 여부| ### Returns ***none*** ### Example ```javascript // 데이터의 행높이를 25픽셀로 고정 한다. mySheet.SetDataRowHeight(25); mySheet.SetAutoRowHeight(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetAutoRowHeight.html"
          },
          {
            "cid": 375,
            "sid": "SetBasicImeMode",
            "name": "SetBasicImeMode",
            "label": "SetBasicImeMode",
            "data": {
              "body": "> Edit 가능한 모든 데이터 셀에서 포커스 시 한/영 키보드 상태를 설정합니다. `(IE 브라우저만 지원)` ### Syntax ```javascript ObjId.SetBasicImeMode(mode) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|한/영 키보드 상태 - 0 : 마지막 상태 유지 - 1 : 한글 입력 모드 - 2 : 영문 입력 모드| ### Returns ***none*** ### Example ```javascript // 포커스시 항상 한글 입력 모드로 설정 mySheet.SetBasicImeMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetBasicImeMode.html"
          },
          {
            "cid": 376,
            "sid": "SetBlur",
            "name": "SetBlur",
            "label": "SetBlur",
            "data": {
              "body": "> IBSheet7 에 대한 `blur` 처리를 합니다. ### Syntax ```javascript ObjId.SetBlur(clearActive); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |clearActive|`Boolean`|<span class=\"optional\">선택</span>|레이어 팝업창 사용시 마우스 Active된 시트객체를 제거 (wheel 스크롤)| ### Returns ***none*** ### Example ```javascript // IBSheet에 대한 blur 처리 mySheet.SetBlur(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetBlur.html"
          },
          {
            "cid": 377,
            "sid": "SetClickHeaderMapping",
            "name": "SetClickHeaderMapping",
            "label": "SetClickHeaderMapping",
            "data": {
              "body": "> 셀 클릭시 셀에 매핑되는 헤더셀의 색상을 변경하도록 설정합니다. ### Syntax ```javascript ObjId.SetClickHeaderMapping(mapping) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mapping|`Boolean`|<span class=\"required\">필수</span>|색상 변경 여부| ### Returns ***none*** ### Example ```javascript // 셀에 매핑되는 헤더셀의 색상을 변경 mySheet.SetClickHeaderMapping(1); ``` ### Since |version|desc| |---|---| |7.0.13.99||",
              "since": "|version|desc||---|---||7.0.13.99||"
            },
            "url": "docs/funcs/core/SetClickHeaderMapping.html"
          },
          {
            "cid": 378,
            "sid": "SetClickHeaderMappingColor",
            "name": "SetClickHeaderMappingColor",
            "label": "SetClickHeaderMappingColor",
            "data": {
              "body": "> 셀 클릭시 셀에 매핑되는 헤더셀의 색상을 설정합니다. ### Syntax ```javascript ObjId.SetClickHeaderMappingColor(color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |color|`String`|<span class=\"required\">필수</span>|사용할 색상| ### Returns ***none*** ### Example ```javascript // 셀 클릭시 셀에 매핑되는 헤더셀의 색상을 설정 mySheet.SetClickHeaderMappingColor(\"#ffffff\"); ``` ### Since |version|desc| |---|---| |7.0.13.99||",
              "since": "|version|desc||---|---||7.0.13.99||"
            },
            "url": "docs/funcs/core/SetClickHeaderMappingColor.html"
          },
          {
            "cid": 379,
            "sid": "SetClipCopyMode",
            "name": "SetClipCopyMode",
            "label": "SetClipCopyMode",
            "data": {
              "body": "> `Ctrl + C`를 이용하여 데이터를 클립보드에 복사 할때의 처리 방법을 설정 합니다. > 클립보드 복사을 허용한 경우 마우스 드래그로 데이터 영역을 선택한 경우에는 모두 동일하게 해당 영역에 대한 데이터가 복사됩니다. ### Syntax ```javascript ObjId.SetClipCopyMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Integer`|<span class=\"required\">필수</span>|복사 방법에 따른 설정값 - `-1` : 복사 기능 사용 안함 - `0` : Selection 상태가 아닌 Focus 상태인 경우 해당 셀의 데이터만 복사 처리 - `1` : Selection 상태가 아닌 Focus 상태인 경우 해당 행의 데이터 모두 복사 처리 - `2` : Selection 상태가 아닌 Focus 상태인 경우 해당 셀의 데이터만 복사/잘라내기 처리 - `3` : Selection 상태가 아닌 Focus 상태인 경우 해당 행의 데이터 모두 복사/잘라내기 처리| ### Returns ***none*** ### Example ```javascript // 클립보드 복사 제한 설정 mySheet.SetClipCopyMode(-1); // 행단위 복사 방법 설정 mySheet.SetClipCopyMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.2.0|클립보드 복사를 허용하지 않는 모드 추가 (Mode: -1)|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.2.0|클립보드 복사를 허용하지 않는 모드 추가 (Mode: -1)|"
            },
            "url": "docs/funcs/core/SetClipCopyMode.html"
          },
          {
            "cid": 380,
            "sid": "SetClipCutDisable",
            "name": "SetClipCutDisable",
            "label": "SetClipCutDisable",
            "data": {
              "body": "> `Ctrl + X`를 이용하여 데이터를 클립보드에 잘라내기 할때의 처리 방법을 설정합니다. ### Syntax ```javascript ObjId.SetClipCutDisable(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Long`|<span class=\"required\">필수</span>|클립보드 잘라내기 처리 방법 - `0` : 잘라내기 가능 - `1` : 잘라내기 불가능| ### Returns ***none*** ### Example ```javascript // 클립보드 잘라내기 불가능 설정 mySheet.SetClipCutDisable(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetClipCutDisable.html"
          },
          {
            "cid": 381,
            "sid": "SetClipPasteMode",
            "name": "SetClipPasteMode",
            "label": "SetClipPasteMode",
            "data": {
              "body": "> 클립보드에 있는 내용을 시트에 붙여넣기 할때의 처리 방법을 설정합니다. ### Syntax ```javascript ObjId.SetClipPasteMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|붙여넣기 처리 방법 - `-1` : 붙여넣기 기능 사용 안함 - `0` : 선택 되어있는 해당 셀에 붙여넣기 처리 - `1` : 선택 되어있는 셀을 시작점으로 하여 붙여 넣기 처리 (`\\t` : 컬럼 구분자 `\\r\\n` : 행 구분자) - `2` : 1 설정의 방법을 기본으로 하고, 붙여넣을 행이 모자른 경우에 자동으로 행을 추가하며 붙여넣기 처리 - `3`: 행을 추가하면서 붙여넣기 처리 (`\\t` : 컬럼 구분자 `\\r\\n` : 행 구분자) - `4` : 선택 영역의 크기와 관계없이 클립보드 내용 붙여넣기 처리| ### Returns ***none*** ### Example ```javascript // 클립보드 붙여넣기 제한 설정 mySheet.SetClipPasteMode(-1); // 엑셀과 동일한 방식을 붙여넣기 방법 설정 mySheet.SetClipPasteMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetClipPasteMode.html"
          },
          {
            "cid": 382,
            "sid": "SetComboOpenMode",
            "name": "SetComboOpenMode",
            "label": "SetComboOpenMode",
            "data": {
              "body": "> `Combo`, `ComboEdit` 타입의 셀 선택 시점의 처리방법을 설정합니다. > `1`로 설정하는 경우 선택 시점에 편집모드로 변경되고, 콤보리스트를 출력합니다. ### Syntax ```javascript ObjId.SetComboOpenMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Boolean`|<span class=\"required\">필수</span>|선택시 편집모드 변경 여부| ### Returns ***none*** ### Example ```javascript // \"Combo\", \"ComboEdit\" 타입의 셀 선택시 바로 편집모드 변경 모드 설정 mySheet.SetComboOpenMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetComboOpenMode.html"
          },
          {
            "cid": 383,
            "sid": "SetCountFormat",
            "name": "SetCountFormat",
            "label": "SetCountFormat",
            "data": {
              "body": "> 건수 정보의 출력 포맷을 설정 합니다. ### Syntax ```javascript ObjId.SetCountFormat(format); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |format|`String`|<span class=\"required\">필수</span>|예약어를 이용한 출력 포맷 - `BOTTOMDATA` : View 영역의 하단에 위치한 행의 번호 - `BOTTOMDATA2` : View 영역의 하단에 위치한 행의 번호(소계,누계행 제외) - `TOTALROWS` : 서버페이징에서의 전체 조회 대상 데이터 건수(소계,누계 포함) - `TOTALROWS2` : 서버페이징에서의 전체 조회 대상 데이터 건수(소계,누계 제외) - `SEARCHROWS` : 조회된 데이터 건수 (상태값 : \"\") - `INSERTROWS` : 입력 데이터 건수 (상태값 : \"입력\") - `UPDATEROWS` : 수정 데이터 건수 (상태값 : \"수정\") - `DELETEROWS` : 삭제 데이터 건수 (상태값 : \"삭제\") - `ROWCOUNT` : 전체 데이터 건수 - `SELECTDATAROW` : 현재 선택된 행의 번호 - `FILTEREDCOUNT` : 필터링된 데이터 건수 - `FILTEREDCOUNT2` : 필터링된 데이터 건수 (소계,누계 제외) - `HIDDENROWS` : 히든 처리된 행 건수 - `EXCEPTHIDE` : 전체 조회건수에서 히든처리된 행을 뺀 데이터 건수 - `ROWVIEWCOUNT` : ROWCOUNT - HIDDENROWS - `FILTEREDVIEWCOUNT` : 필터 적용하기 전, 히든처리된 행 건수를 제외| ### Returns ***none*** ### Example ```javascript // 입력,수정,삭제 건수 출력 포맷 설정 mySheet.SetCountFormat('입력: INSERTROWS건 / 수정: UPDATEROWS / 삭제: DELETEROWS /'); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.108|HIDDENROWS, EXCEPTHIDE, ROWVIEWCOUNT FILTEREDVIEWCOUNT 예약어 추가| |7.0.13.126|BOTTOMDATA2, TOTALROWS2 예약어 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.108|HIDDENROWS, EXCEPTHIDE, ROWVIEWCOUNT FILTEREDVIEWCOUNT 예약어 추가||7.0.13.126|BOTTOMDATA2, TOTALROWS2 예약어 추가|"
            },
            "url": "docs/funcs/core/SetCountFormat.html"
          },
          {
            "cid": 384,
            "sid": "SetCountInfoElement",
            "name": "SetCountInfoElement",
            "label": "SetCountInfoElement",
            "data": {
              "body": "> 건수 정보 출력 대상 Dom Element를 설정합니다. > 이 기능은 건수 정보 출력을 시트의 외부에 표현하고자 할 때 사용하며, `input`, `div`, `span` 등의 innerText 를 지원 하는 Dom Element만 설정 할 수 있습니다. ### Syntax ```javascript ObjId.SetCountInfoElement(); ``` ### Info ***none*** ### Returns ***Object or String, 건수 정보 출력 대상 Dom Element 또는 해당 id*** ### Example ```javascript // id가 'countElem'인 div 에 건수 정보 출력 설정 mySheet.SetCountInfoElement('countElem'); mySheet.SetCountInfoElement(document.getElementById('countElem')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetCountInfoElement.html"
          },
          {
            "cid": 385,
            "sid": "SetCountPosition",
            "name": "SetCountPosition",
            "label": "SetCountPosition",
            "data": {
              "body": "> 건수 정보가 출력 되는 위치를 설정합니다. > 건수 정보 출력 포맷을 설정 하지 않은 경우 `[BOTTOMDATA / TOTALROWS]` 포맷을 기본으로 사용하며, 포맷을 변경 하고자 하는 경우에는 `SetCountFormat` 메소드를 이용하여 변경합니다. ### Syntax ```javascript ObjId.SetCountPosition(position); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |position|`Number`|<span class=\"required\">필수</span>|건수 정보 출력 위치 - `0` : 사용 안함 - `1` : 좌측 상단 - `2` : 우측 상단 - `3` : 좌측 하단 - `4` : 우측 하단| ### Returns ***none*** ### Example ```javascript // 건수 정보 출력위치를 우측 하단으로 설정 mySheet.SetCountPosition(4); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetCountPosition.html"
          },
          {
            "cid": 386,
            "sid": "SetDataAlternateBackColor",
            "name": "SetDataAlternateBackColor",
            "label": "SetDataAlternateBackColor",
            "data": {
              "body": "> 데이터 영역의 짝수번째 행의 기본 배경색을 설정합니다. > `주의` [Cfg의 Alternate](/docs/props/PropertyList/Alternate) 옵션을 `1`로 설정해야 사용 가능합니다. > 설정하지 않은 경우 CSS의 ColorAlternate 클래스의 설정 값을 기본 값으로 처리합니다. > 데이터 영역에 셀병합이 적용되어 있는 경우 셀병합 적용전의 행을 기준으로 처리를 기본으로 하며, 앞컬럼 기준 셀병합인 경우에는 첫번째 기준컬럼을 기준으로 적용합니다. ### Syntax ```javascript ObjId.SetDataAlternateBackColor(color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |color|`String`|<span class=\"required\">필수</span>|설정할 색상 값| ### Returns ***none*** ### Example ```javascript // Alternate 배경색을 \"red\"로 설정 mySheet.SetDataAlternateBackColor(\"red\"); mySheet.SetDataAlternateBackColor(\"#ff0000\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetDataAlternateBackColor.html"
          },
          {
            "cid": 387,
            "sid": "SetDataAutoTrim",
            "name": "SetDataAutoTrim",
            "label": "SetDataAutoTrim",
            "data": {
              "body": "> 데이터에 대한 자동 trim 처리 여부를 설정 합니다. > 조회, 저장 데이터 및 Cell의 데이터 설정값에 대하여 해당 설정을 적용합니다. ### Syntax ```javascript ObjId.SetDataAutoTrim(trim); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |trim|`Boolean`|<span class=\"required\">필수</span>|trim 처리 여부| ### Returns ***none*** ### Example ```javascript // trim 처리하지 않도록 설정 mySheet.SetDataAutoTrim(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetDataAutoTrim.html"
          },
          {
            "cid": 388,
            "sid": "SetDataFontColor",
            "name": "SetDataFontColor",
            "label": "SetDataFontColor",
            "data": {
              "body": "> 데이터 행의 기본 폰트 색상을 설정합니다. ### Syntax ```javascript ObjId.SetDataFontColor(color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |color|`String`|<span class=\"required\">필수</span>|설정할 색상 값| ### Returns ***none*** ### Example ```javascript // 행의 기본 폰트 색상을 blue로 설정 mySheet.SetDataFontColor(\"blue\"); mySheet.SetDataFontColor(\"#0000ff\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetDataFontColor.html"
          },
          {
            "cid": 389,
            "sid": "SetDataLinkMouse",
            "name": "SetDataLinkMouse",
            "label": "SetDataLinkMouse",
            "data": {
              "body": "> 특정 컬럼에 대한 마우스 링크 여부를 설정합니다. ### Syntax ```javascript ObjId.SetDataLinkMouse(col, link); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |col|`Long or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName| |link|`Boolean`|<span class=\"required\">필수</span>|설정값| ### Returns ***none*** ### Example ```javascript // Index가 5인 컬럼에 대한 링크 설정 mySheet.SetDataLinkMouse(5, 1); // SaveName이 \"sDeptName\"인 컬럼에 대한 링크 설정 mySheet.SetDataLinkMouse(\"sDeptName\", 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetDataLinkMouse.html"
          },
          {
            "cid": 390,
            "sid": "SetDataRowHeight",
            "name": "SetDataRowHeight",
            "label": "SetDataRowHeight",
            "data": {
              "body": "> 데이터 행의 기본 행 높이를 설정 합니다. ### Syntax ```javascript ObjId.SetDataRowHeight(height); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |height|`Number`|<span class=\"required\">필수</span>|설정할 높이 값 (단위:px)| ### Returns ***none*** ### Example ```javascript // 행의 기본 높이를 25픽셀로 설정 mySheet.SetDataRowHeight(25); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetDataRowHeight.html"
          },
          {
            "cid": 391,
            "sid": "SetDownloadingImage",
            "name": "SetDownloadingImage",
            "label": "SetDownloadingImage",
            "data": {
              "body": "> 다운로드중 대기 이미지의 url을 설정 합니다. ### Syntax ```javascript ObjId.SetDownloadingImage(url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |url|`String`|<span class=\"required\">필수</span>|다운로드중 대기 이미지 url| ### Returns ***none*** ### Example ```javascript // 다운로드중 대기 이미지 url 설정 mySheet.SetDownloadingImage('./img/downloadProcess.png'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetDownloadingImage.html"
          },
          {
            "cid": 392,
            "sid": "SetDragMode",
            "name": "SetDragMode",
            "label": "SetDragMode",
            "data": {
              "body": "> IBSheet7 시트의 drag 방법을 설정 합니다. > - 설정값이 1인 경우 : `마우스 drag`에 의해 행 또는 셀에 대한 드래깅 처리 > - 설정값이 0인 경우 : `ctrl + 마우스 drag`에 의해 행 또는 셀에 대한 드래깅 처리 > `참고` 마우스 drag에 의한 셀렉션은 이 설정과 반대로 설정 됩니다. ### Syntax ```javascript ObjId.SetDragMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Boolean`|<span class=\"required\">필수</span>|처리모드 (Default: 0)| ### Returns ***none*** ### Example ```javascript // drag 시 행 또는 셀 drag 모드 설정 mySheet.SetDragMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetDragMode.html"
          },
          {
            "cid": 393,
            "sid": "SetEditArrowBehavior",
            "name": "SetEditArrowBehavior",
            "label": "SetEditArrowBehavior",
            "data": {
              "body": "> 편집모드 상태에서 방향 키 입력에 대한 동작 방법을 설정합니다. ### Syntax ```javascript ObjId.SetEditArrowBehavior(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|동작 방법 설정값 - `0` : 좌,우,상,하 모두 셀 이동 하지 않음 - `1` : 상,하만 셀 이동 처리 (Default) - `2` : 좌,우만 셀 이동 처리 - `3` : 좌,우,상,하 모두 셀 이동 처리 - `4` : 커서가 데이터의 좌우측 끝에 위치할때 편집 가능한 셀로 편집을 유지하면서 이동/상,하 이동 처리 - `5` : 커서가 데이터의 좌우측 끝에 위치할때 편집 가능한 셀로 편집을 유지하면서 이동/상,하 이동 처리 없음 - `6` : 커서가 데이터의 좌우측 끝에 위치할때 편집유무와 관계없이 편집을 종료하면서 이동/상,하 이동 처리 - `7` : 커서가 데이터의 좌우측 끝에 위치할때 편집유무와 관계없이 편집을 종료하면서 이동/상,하 이동 없음 || **mode 값 4,5,6,7번은 Internet Explorer 9 이상에서만 동작합니다.** ### Returns ***none*** ### Example ```javascript // 방향키 입력시 셀이동을 하지 않도록 설정 mySheet.SetEditArrowBehavior(0); ``` ### Since |version|desc| |---|---| |7.0.0.0|기능추가| |7.0.13.229|4,5번 추가| |7.0.13.233|6,7번 추가|",
              "since": "|version|desc||---|---||7.0.0.0|기능추가||7.0.13.229|4,5번 추가||7.0.13.233|6,7번 추가|"
            },
            "url": "docs/funcs/core/SetEditArrowBehavior.html"
          },
          {
            "cid": 394,
            "sid": "SetEditEnterBehavior",
            "name": "SetEditEnterBehavior",
            "label": "SetEditEnterBehavior",
            "data": {
              "body": "> 편집모드 상태에서 Enter 키 입력에 대한 동작 방법을 설정합니다. > 설정 값이 `editTab`인 경우 `SetEditTabBehavior` 설정을 기준으로 합니다. (편집 유지 제외) ### Syntax ```javascript ObjId.SetEditEnterBehavior(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|동작 방법 설정값 - `tab` : 편집 완료 후 오른쪽 셀로 포커스 이동 (Default) - `editTab` : 편집 완료 후 다음 편집 가능한 셀로 이동 - `newLine` : 개행 처리 (가능한 경우) - `down` : 편집 완료 후 아래 셀로 포커스 이동 - `none` : 편집 완료 후 포커스 유지| ### Returns ***none*** ### Example ```javascript // 편집 완료 후 아래 셀로 포커스 이동 설정 mySheet.SetEditEnterBehavior('down'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEditEnterBehavior.html"
          },
          {
            "cid": 395,
            "sid": "SetEditTabBehavior",
            "name": "SetEditTabBehavior",
            "label": "SetEditTabBehavior",
            "data": {
              "body": "> 편집모드 상태에서 tab 키 입력에 대한 동작 방법을 설정합니다. > 설정 값이 `editTab`인 경우 `SetEditTabBehavior` 설정을 기준으로 합니다. (편집 유지 제외) ### Syntax ```javascript ObjId.SetEditTabBehavior(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|동작 방법 설정값 - `0` : 다음 편집 가능한 셀로 이동 한다 (편집상태 유지) - `1` : 편집여부와 무관하게 다음셀로 이동 한다 (다음셀이 편집 가능한 경우면 편집상태 유지) - `2` : 편집여부와 무관하게 다음셀로 이동 한다 (다음셀의 편집 여부와 무관하게 편집상태 종료 처리)| ### Returns ***none*** ### Example ```javascript // tab 키 입력시 편집여부와 무관하게 다음셀로 이동 설정.(다음셀이 편집 가능한 경우면 편집상태 유지) mySheet.SetEditTabBehavior(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEditTabBehavior.html"
          },
          {
            "cid": 396,
            "sid": "SetEditable",
            "name": "SetEditable",
            "label": "SetEditable",
            "data": {
              "body": "> 모든 데이터영역에 대한 편집 가능 여부를 설정합니다. > 전체적으로 Edit가 불가능하면 다른 설정에 관계없이 모든 Edit는 불가능합니다. > - Edit 인자를 설정하지 않는 경우 : 별도처리 없이 -1을 반환 > - Edit 인자의 설정값이 Boolean 범위 외의 값을 설정한 경우 : false 설정과 동일 ### Syntax ```javascript ObjId.SetEditable(edit); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |edit|`Boolean`|<span class=\"required\">필수</span>|편집 가능 여부| ### Returns ***none*** ### Example ```javascript // 시트 전체를 편집 불가로 설정 mySheet.SetEditable(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEditable.html"
          },
          {
            "cid": 397,
            "sid": "SetEditableColorDiff",
            "name": "SetEditableColorDiff",
            "label": "SetEditableColorDiff",
            "data": {
              "body": "> 편집가능 여부에 따른 셀의 배경색을 구분하여 표시할지 여부를 설정합니다. ### Syntax ```javascript ObjId.SetEditableColorDiff(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|배경색 구분 처리 모드 - `0` : 편집불가능한 셀을 구분없이 표시 - `1` : 편집불가능한 셀을 css에서 설정한 색상으로 표시 - `2` : 편집불가능한 셀을 css의 설정값과 기본배경색의 조합으로 표시| ### Returns ***none*** ### Example ```javascript // 편집가능 여부에 따른 셀의 배경색을 구분하지 않도록 설정 mySheet.SetEditableColorDiff(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEditableColorDiff.html"
          },
          {
            "cid": 398,
            "sid": "SetEllipsis",
            "name": "SetEllipsis",
            "label": "SetEllipsis",
            "data": {
              "body": "> 모든 셀의 데이터에 대한 ellipsis 설정 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetEllipsis(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Boolean`|<span class=\"required\">필수</span>|ellipsis 설정 여부| ### Returns ***none*** ### Example ```javascript // 모든 셀의 데이터에 대한 ellipsis 설정 mySheet.SetEllipsis(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEllipsis.html"
          },
          {
            "cid": 399,
            "sid": "SetEnable",
            "name": "SetEnable",
            "label": "SetEnable",
            "data": {
              "body": "> 마우스나 키보드를 사용한 User Interface 사용가능 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetEnable(enable); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |enable|`Boolean`|<span class=\"required\">필수</span>|활성화 여부| ### Returns ***none*** ### Example ```javascript // 대상 Grid를 비활성 상태로 설정 mySheet.SetEnable(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEnable.html"
          },
          {
            "cid": 400,
            "sid": "SetEndEdit",
            "name": "SetEndEdit",
            "label": "SetEndEdit",
            "data": {
              "body": "> 편집중인 셀이 있는 경우 편집을 종료 처리 합니다. > `save`인자에 따라서 편집중인 값에 대한 저장/취소 여부를 설정 할 수 있습니다. ### Syntax ```javascript ObjId.SetEndEdit(save); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |save|`Boolean`|<span class=\"required\">필수</span>|저장 처리 여부| ### Returns ***Boolean, 처리 결과*** ### Example ```javascript // 저장후 편집 종료 처리 mySheet.SetEndEdit(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEndEdit.html"
          },
          {
            "cid": 401,
            "sid": "SetEnterBehavior",
            "name": "SetEnterBehavior",
            "label": "SetEnterBehavior",
            "data": {
              "body": "> 포커스 상태에서 Enter 키 입력에 대한 동작 방법을 설정 합니다. ### Syntax ```javascript ObjId.SetEnterBehavior(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`String`|<span class=\"required\">필수</span>|설정값 - `tab` : 오른쪽 셀로 포커스 이동 - `edit` : 편집모드로 전환 (Default) - `down` : 아래의 셀로 포커스 이동 - `none` : 아무 동작을 하지 않음| ### Returns ***none*** ### Example ```javascript // tab키 입력 동작과 동일하게 설정 mySheet.SetEnterBehavior(\"tab\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEnterBehavior.html"
          },
          {
            "cid": 402,
            "sid": "SetEtcData",
            "name": "SetEtcData",
            "label": "SetEtcData",
            "data": {
              "body": "> EtcData를 설정 합니다. ### Syntax ```javascript ObjId.SetEtcData(name, value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |name|`String`|<span class=\"required\">필수</span>|설정할 데이터의 키 값| |value|`String`|<span class=\"required\">필수</span>|설정할 값| ### Returns ***none*** ### Example ```javascript // \"etcName\" 키로 \"ibleaders\" 값 설정 mySheet.SetEtcData(\"etcName\", \"ibleaders\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetEtcData.html"
          },
          {
            "cid": 403,
            "sid": "SetFindDialog",
            "name": "SetFindDialog",
            "label": "SetFindDialog",
            "data": {
              "body": "> `Ctrl+Shift+F` 를 이용한 찾기 다이얼로그의 기본 정보를 설정 합니다. ### Syntax ```javascript ObjId.SetFindDialog(show, col, fullMatch, firstStart, caseSensitive, keepDialog, findwrap); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |show|`Boolean`|<span class=\"required\">필수</span>|찾기 다이얼로그 사용 여부| |col|`Long or String`|<span class=\"optional\">선택</span>|컬럼의 Index 또는 SaveName (빈값인 경우 전체 컬럼)| |fullMatch|`Number`|<span class=\"optional\">선택</span>|텍스트 일치 종류 설정 - `-1` : 입력값과 모두 일치 - `0` : 입력값과 앞 부분이 일치 - `1` : 입력값과 뒤 부분이 일치 (Default) - `2` : 입력값과 가운데 부분이 일치| |firstStart|`Boolean`|<span class=\"optional\">선택</span>|시작 위치 설정| |caseSensitive|`Boolean`|<span class=\"optional\">선택</span>|대소 구분 설정| |keepDialog|`Boolean`|<span class=\"optional\">선택</span>|찾기 후 창 닫기 여부| |findwrap|`Boolean`|<span class=\"optional\">선택</span>|끝에서 되돌리기 여부| ### Returns ***none*** ### Example ```javascript // 찾기 다이얼로그의 기본값 설정 (대상 컬럼:5, 시작위치:포커스행 다음, 일치종류:가운데일치) mySheet.SetFindDialog(1, 5, 2, 0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetFindDialog.html"
          },
          {
            "cid": 404,
            "sid": "SetFocus",
            "name": "SetFocus",
            "label": "SetFocus",
            "data": {
              "body": "> IBSheet7 에 대한 focus 처리를 합니다. ### Syntax ```javascript ObjId.SetFocus(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 시트에 포커스를 설정 mySheet.SetFocus(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetFocus.html"
          },
          {
            "cid": 405,
            "sid": "SetFocusEditMode",
            "name": "SetFocusEditMode",
            "label": "SetFocusEditMode",
            "data": {
              "body": "> 편집 가능한 셀이 선택상태가 되었을때 편집모드로 변경할지 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetFocusEditMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|설정값 - `0` : 포커스상태 유지 - `1` : 모든 컬럼타입에 대한 편집모드 변경 - `2` : `Combo`, `ComboEdit` 타입 컬럼만 포커스 상태 유지, 그 외 컬럼타입 편집모드 변경| ### Returns ***none*** ### Example ```javascript // 포커스시 편집모드 변경 모드 설정 mySheet.SetFocusEditMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetFocusEditMode.html"
          },
          {
            "cid": 406,
            "sid": "SetHeaderActionMenu",
            "name": "SetHeaderActionMenu",
            "label": "SetHeaderActionMenu",
            "data": {
              "body": "> 헤더 영역에서 사용할 컨텍스트 메뉴를 설정합니다. > `menuCode` 인자 설정시 사전 정의 코드를 사용하는 경우 별도 코드 작성없이 해당 기능이 처리되고, 그렇지 않은 경우에는 `OnSelectMenu` 이벤트에서 처리 할 수 있습니다. > menuText 인자를 설정하지 않는 경우 기본메뉴로 설정처리 됩니다. > 기본으로 제공 되는 사전 정의 코드는 아래 Enum 참조 ### Syntax ```javascript ObjId.SetHeaderActionMenu(menuText, menuCode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |menuText|`String`|<span class=\"required\">필수</span>|메뉴명을 구분자 `|`로 연결한 문자열| |menuCode|`String`|<span class=\"required\">필수</span>|메뉴코드를 구분자 `|`로 연결한 문자열| ### Enum |Code|Description| |----|-----------| |_ibColSortAsc|대상 컬럼 오름 차순 정렬| |_ibColSortDesc|대상 컬럼 내림 차순 정렬| |_ibColHidden|대상 컬럼 숨김| |_ibCancelColHidden|헤더메뉴로 숨긴 컬럼 출력| |_ibSaveColPosition|현재 컬럼정보 저장 (위치, 컬럼 숨김여부, 너비)| |_ibResetColPosition|저장된 컬럼정보 삭제| |_ibRestoreColPosition|컬럼정보 초기화| |_ibShowFilter|필터행 출력| |_ibHideFilter|필터행 숨김| ### Returns ***none*** ### Example ```javascript // 컬럼 정렬 메뉴 구성 mySheet.SetHeaderActionMenu(\"오름차순 정렬|내림차순 정렬\", \"_ibColSortAsc|_ibColSortDesc\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderActionMenu.html"
          },
          {
            "cid": 407,
            "sid": "SetHeaderBackColor",
            "name": "SetHeaderBackColor",
            "label": "SetHeaderBackColor",
            "data": {
              "body": "> 헤더행의 배경색을 설정합니다. ### Syntax ```javascript ObjId.SetHeaderBackColor(color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |color|`String`|<span class=\"required\">필수</span>|설정할 색상 값| ### Returns ***none*** ### Example ```javascript // 헤더행의 배경색을 red로 설정 mySheet.SetHeaderBackColor(\"red\"); mySheet.SetHeaderBackColor(\"#ff0000\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderBackColor.html"
          },
          {
            "cid": 408,
            "sid": "SetHeaderCheck",
            "name": "SetHeaderCheck",
            "label": "SetHeaderCheck",
            "data": {
              "body": "> 헤더의 전체 체크박스 값을 설정합니다. > 설정시 헤더의 설정 값만 변경되고 전체 체크 동작은 처리되지 않습니다. ### Syntax ```javascript ObjId.SetHeaderCheck(row, col, value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |row|`Long`|<span class=\"required\">필수</span>|행의 Index| |col|`Long or String`|<span class=\"optional\">선택</span>|컬럼의 Index 또는 SaveName| |value|`Boolean`|<span class=\"optional\">선택</span>|체크박스에 설정하고자 하는 값| ### Returns ***none*** ### Example ```javascript // 데이터 클리어후 (0, 3) 헤더셀의 전체체크를 체크하도록 설정 mySheet.RemoveAll(); mySheet.SetHeaderCheck(0, 3, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderCheck.html"
          },
          {
            "cid": 409,
            "sid": "SetHeaderCursor",
            "name": "SetHeaderCursor",
            "label": "SetHeaderCursor",
            "data": {
              "body": "> 헤더 행의 마우스 오버시 커서 모양을 설정합니다. ### Syntax ```javascript ObjId.SetHeaderCursor(cursor); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |cursor|`String`|<span class=\"required\">필수</span>|커서 사용 여부 - `default` : 기본모양 - `pointer` : 포인터 모양| ### Returns ***none*** ### Example ```javascript // 헤더의 마우스 커서포인터를 손가락 모양으로 변경한다. mySheet.SetHeaderCursor('Pointer'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderCursor.html"
          },
          {
            "cid": 410,
            "sid": "SetHeaderEventMode",
            "name": "SetHeaderEventMode",
            "label": "SetHeaderEventMode",
            "data": {
              "body": "> 헤더 행에 대한 마우스 이벤트 발생 모드를 설정합니다. ### Syntax ```javascript ObjId.SetHeaderEventMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|이벤트 발생 모드 - `0` : 모든 이벤트 발생 안함 - `1` : 모든 이벤트 발생 함 - `2` : MouseDown, MouseMove 이벤트만 발생 함 (IBSheet(A) 호환 모드) - `3` : 헤더 리사이즈 영역에서 MouseDown 이벤트 발생하지 않음| ### Returns ***none*** ### Example ```javascript // 헤더 행에 대한 마우스 이벤트가 발생하지 않도록 설정 mySheet.SetHeaderEventMode(0); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.254|HeaderEventMode: 3 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.254|HeaderEventMode: 3 추가|"
            },
            "url": "docs/funcs/core/SetHeaderEventMode.html"
          },
          {
            "cid": 411,
            "sid": "SetHeaderFontBold",
            "name": "SetHeaderFontBold",
            "label": "SetHeaderFontBold",
            "data": {
              "body": "> 헤더 행의 폰트에 bold 적용 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetHeaderFontBold(bold); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |bold|`Boolean`|<span class=\"required\">필수</span>|bold 적용 여부| ### Returns ***none*** ### Example ```javascript // 헤더행의 폰트에 bold 적용 mySheet.SetHeaderFontBold(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderFontBold.html"
          },
          {
            "cid": 412,
            "sid": "SetHeaderFontColor",
            "name": "SetHeaderFontColor",
            "label": "SetHeaderFontColor",
            "data": {
              "body": "> 헤더 행의 폰트 색상을 설정합니다. ### Syntax ```javascript ObjId.SetHeaderFontColor(color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |color|`String`|<span class=\"required\">필수</span>|설정할 색상 값| ### Returns ***none*** ### Example ```javascript // 헤더행의 폰트 색상을 blue로 설정 mySheet.SetHeaderFontColor(\"blue\"); mySheet.SetHeaderFontColor(\"#0000ff\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderFontColor.html"
          },
          {
            "cid": 413,
            "sid": "SetHeaderMode",
            "name": "SetHeaderMode",
            "label": "SetHeaderMode",
            "data": {
              "body": "> 헤더의 옵션을 설정 합니다. > `InitHeaders` 메소드에서 설정한 옵션을 초기화 이후 변경하고자 할 때 사용합니다. ### Syntax ```javascript ObjId.SetHeaderMode([opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |opt|`Object`|<span class=\"required\">필수</span>|설정 옵션 객체| |opt.ColMove|`Boolean`|<span class=\"optional\">선택</span>|마우스 드래그를 이용한 컬럼 이동 허용 여부| |opt.ColResize|`Boolean`|<span class=\"optional\">선택</span>|마우스 드래그를 이용한 컬럼 리사이즈 허용 여부| |opt.HeaderCheck|`Boolean`|<span class=\"optional\">선택</span>|헤더의 전체체크 사용 여부| |opt.Sort|`Number`|<span class=\"optional\">선택</span>|헤더 클릭을 통한 컬럼 Sort 옵션 - `0` : Sort 기능 사용 안함 - `1` : Sort 기능 사용 - `2` : Sort 아이콘만 표시 처리 - `3` : colSpan 아닌 헤더 셀만 Sort 기능 사용| ### Returns ***none*** ### Example ```javascript // Sort 처리방법 변경 mySheet.SetHeaderMode({ \"Sort\" : 0 }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderMode.html"
          },
          {
            "cid": 414,
            "sid": "SetHeaderRowHeight",
            "name": "SetHeaderRowHeight",
            "label": "SetHeaderRowHeight",
            "data": {
              "body": "> 헤더 행의 행높이를 설정합니다. ### Syntax ```javascript ObjId.SetHeaderRowHeight(height); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |height|`Number`|<span class=\"required\">필수</span>|설정할 높이 값 (단위:px)| ### Returns ***none*** ### Example ```javascript // 헤더행의 높이를 30픽셀로 설정 한다. mySheet.SetHeaderRowHeight(30); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHeaderRowHeight.html"
          },
          {
            "cid": 415,
            "sid": "SetHighlightAfterSort",
            "name": "SetHighlightAfterSort",
            "label": "SetHighlightAfterSort",
            "data": {
              "body": "> sort 처리 후 이전 포커스 유지 모드를 설정합니다. ### Syntax ```javascript ObjId.SetHighlightAfterSort(focus); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |focus|`Number`|<span class=\"required\">필수</span>|포커스 유지 모드 - `0` : 포커스 클리어 - `1` : 이전 포커스 유지 및 해당 셀의 위치로 이동 - `2` : 이전 포커스 유지 및 scroll 위치 초기화| ### Returns ***none*** ### Example ```javascript // sort 처리 후 포커스 제거 mySheet.GetHighlightAfterSort(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetHighlightAfterSort.html"
          },
          {
            "cid": 416,
            "sid": "SetImageList",
            "name": "SetImageList",
            "label": "SetImageList",
            "data": {
              "body": "> 이미지 경로에 대한 Index를 설정합니다. 중복된 Index 를 설정하는 경우에는 마지막 설정한 값을 유지 합니다. ### Syntax ```javascript ObjId.SetImageList(index, path); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |index|`Number`|<span class=\"required\">필수</span>|이미지 Index| |path|`String`|<span class=\"required\">필수</span>|이미지 경로| ### Returns ***none*** ### Example ```javascript // 이미지 리스트 설정 var images = [\"/img/a.gif\", \"/img/b.gif\", \"/img/c.gif\"]; for (var i = 0, len = images.length; i < len; i++) { mySheet.SetImageList(i, images[i]); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetImageList.html"
          },
          {
            "cid": 417,
            "sid": "SetKeyFieldImage",
            "name": "SetKeyFieldImage",
            "label": "SetKeyFieldImage",
            "data": {
              "body": "> 필수 입력 항목에 대한 표시 이미지 경로를 설정 합니다. ### Syntax ```javascript ObjId.SetKeyFieldImage(path); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |path|`String`|<span class=\"required\">필수</span>|이미지 경로| ### Returns ***none*** ### Example ```javascript // 필수 입력 항목에 대한 표시 이미지 경로 설정 mySheet.SetKeyFieldImage(\"/img/keyfield.gif\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetKeyFieldImage.html"
          },
          {
            "cid": 418,
            "sid": "SetMouseHoverMode",
            "name": "SetMouseHoverMode",
            "label": "SetMouseHoverMode",
            "data": {
              "body": "> 마우스 Hover 모드를 설정 합니다. ### Syntax ```javascript ObjId.SetMouseHoverMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|대상 행 Index - `0` : 사용 안함 (Default) - `1` : 셀 단위 Hover 처리 - `2` : 행 단위 Hover 처리| ### Returns ***none*** ### Example ```javascript // 쎌 단위 Hover 모드 설정 mySheet.SetMouseHoverMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetMouseHoverMode.html"
          },
          {
            "cid": 419,
            "sid": "SetMousePointer",
            "name": "SetMousePointer",
            "label": "SetMousePointer",
            "data": {
              "body": "> 시트 내에서의 마우스 커서 모양을 설정 합니다. ### Syntax ```javascript ObjId.SetMousePointer(cursor); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |cursor|`String`|<span class=\"required\">필수</span>|마우스 커서값 - `default` : 기본 모양 - `hand` : 포인터 모양| ### Returns ***none*** ### Example ```javascript // 마우스 커서를 포인터로 설정 mySheet.SetMousePointer(\"hand\")); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetMousePointer.html"
          },
          {
            "cid": 420,
            "sid": "SetMouseToolTipText",
            "name": "SetMouseToolTipText",
            "label": "SetMouseToolTipText",
            "data": {
              "body": "> 마우스 커서의 위치에 표시할 툴팁 문자열을 설정 합니다. ### Syntax ```javascript ObjId.SetMouseToolTipText(text); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |text|`String`|<span class=\"required\">필수</span>|설정할 문자열| ### Returns ***none*** ### Example ```javascript // 마우스의 좌표를 툴팁으로 설정 function mySheet_OnMouseMove(button, shift, x, y) { var tip = \"pos: \" + x + \",\" + y; mySheet.SetMouseToolTipText(tip); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetMouseToolTipText.html"
          },
          {
            "cid": 421,
            "sid": "SetPageCount",
            "name": "SetPageCount",
            "label": "SetPageCount",
            "data": {
              "body": "> `SearchMode`에서 사용되는 Page 개수를 설정합니다. [SearchMode 참조](/docs/props/PropertyList/SearchMode) > 설정한 Page 값은 설정 이후 다시 조회하는 시점부터 적용 됩니다. ### Syntax ```javascript ObjId.SetPageCount(page, renderPage); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |page|`Number`|<span class=\"required\">필수</span>|Page 개수| |renderPage|`Number`|<span class=\"required\">필수</span>|렌더링 페이지 단위 행의 개수 (`smServerPaging2`에서만 사용)| ### Returns ***none*** ### Example ```javascript // Page 개수를 30으로 설정 mySheet.SetPageCount(30); // smServerPaging2 에서 Page 개수를 1000, renderPage를 50으로 설정 mySheet.SetPageCount(1000, 50); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetPageCount.html"
          },
          {
            "cid": 422,
            "sid": "SetPagingPosition",
            "name": "SetPagingPosition",
            "label": "SetPagingPosition",
            "data": {
              "body": "> 페이지 내비게이션이 출력 되는 위치를 설정 합니다. > 페이지 내비게이션을 출력 하기 위해서는 [SetCountPosition](/docs/funcs/core/SetCountPosition) 메소드를 통한 건수 정보의 출력 설정이 되어 있어야 하며, 상단 및 하단의 위치는 SetCountPosition 메소드의 설정을 따릅니다. ### Syntax ```javascript ObjId.SetPagingPosition(position); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |position|`Number`|<span class=\"required\">필수</span>|페이지 네비게이션 출력 위치 - `0` : 사용 안함 - `1` : 좌측 - `2` : 우측| ### Returns ***none*** ### Example ```javascript // 건수 정보 출력위치를 우측 하단, 페이지 내비게이션을 좌측 하단으로 설정 mySheet.SetCountPosition(4); mySheet.SetPagingPosition(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetPagingPosition.html"
          },
          {
            "cid": 423,
            "sid": "SetRangeText",
            "name": "SetRangeText",
            "label": "SetRangeText",
            "data": {
              "body": "> 특정 영역의 셀값을 Format이 적용된 형태로 화면에 보여지는 값 그대로 설정합니다. ### Syntax ```javascript ObjId.SetRangeText(sData, startRow, startCol, endRow, endCol, colSeparator, rowSeparator); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |sData|`String`|<span class=\"required\">필수</span>|문자열| |startRow|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Row Index| |startCol|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Column Index| |endRow|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Row Index| |endCol|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Column Index| |ColSeparator|`String`|<span class=\"optional\">선택</span>|컬럼과 컬럼 사이를 구분하는 구분자. (Default: `|`)| |RowSeparator|`String`|<span class=\"optional\">선택</span>|행과 행 사이를 구분하는 구분자. (Default: `^`)| ### Returns ***none*** ### Example ```javascript // (2, 1) ~ (4, 2) 범위의 셀 값을 (5, 1) ~ (7, 2) 범위에 복사 var value = mySheet.GetRangeText(2, 1, 4, 2); mySheet.SetRangeText(value, 5, 1, 7, 2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetRangeText.html"
          },
          {
            "cid": 424,
            "sid": "SetRangeValue",
            "name": "SetRangeValue",
            "label": "SetRangeValue",
            "data": {
              "body": "> 특정 영역의 셀값을 Format이 적용되지 않은 실제로 저장 시 사용하는 값으로 설정합니다. ### Syntax ```javascript ObjId.SetRangeValue(sData, startRow, startCol, endRow, endCol, colSeparator, rowSeparator); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |sData|`String`|<span class=\"required\">필수</span>|문자열| |startRow|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Row Index| |startCol|`Long`|<span class=\"required\">필수</span>|범위 시작 셀의 Column Index| |endRow|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Row Index| |endCol|`Long`|<span class=\"required\">필수</span>|범위 종료 셀의 Column Index| |ColSeparator|`String`|<span class=\"optional\">선택</span>|컬럼과 컬럼 사이를 구분하는 구분자. (Default: `|`)| |RowSeparator|`String`|<span class=\"optional\">선택</span>|행과 행 사이를 구분하는 구분자. (Default: `^`)| ### Returns ***none*** ### Example ```javascript // (2, 1) ~ (4, 2) 범위의 셀 값을 (5, 1) ~ (7, 2) 범위에 복사 var value = mySheet.GetRangeValue(2, 1, 4, 2); mySheet.SetRangeValue(value, 5, 1, 7, 2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetRangeValue.html"
          },
          {
            "cid": 425,
            "sid": "SetSavingImage",
            "name": "SetSavingImage",
            "label": "SetSavingImage",
            "data": {
              "body": "> 저장중 대기 이미지의 url을 설정 합니다. ### Syntax ```javascript ObjId.SetSavingImage(url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |url|`String`|<span class=\"required\">필수</span>|저장중 대기 이미지 url| ### Returns ***none*** ### Example ```javascript // 저장중 대기 이미지 url 설정 mySheet.SetSavingImage('./img/saveProcess.png'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSavingImage.html"
          },
          {
            "cid": 426,
            "sid": "SetScrollInfoFormat",
            "name": "SetScrollInfoFormat",
            "label": "SetScrollInfoFormat",
            "data": {
              "body": "> 세로스크롤에 대한 지연 처리 방법 사용시 지연 처리 시간 동안 출력되는 메시지 포맷을 설정 합니다. > 메시지 포맷 구성은 간단한 마크업 태그를 이용하여 구성 할 수 있습니다. `주의` 포맷 구성에 대한 복잡도에 따라 성능에 영향을 미치므로 가급적이면 간단한 형식을 사용하는 것을 권장 합니다. > 별도 설정이 없는 경우 `TOPROW or TOTALROWS`를 기본으로 처리 하고, 세로 스크롤에 대한 지연 처리 방법 사용 여부는 `SetConfig` 메소드의 `DeferredVScroll` 속성을 이용하여 설정 합니다. ### Syntax ```javascript ObjId.SetScrollInfoFormat(format); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |format|`String`|<span class=\"required\">필수</span>|설정할 메시지 포맷 문자열 - `TOTALROWS` : 전체 건수 - `TOPROW` : 스크롤 이동시 상단에 위치할 행의 Index - 컬럼의 `Index` 또는 `SaveName` : 상단에 위치할 행에서 해당 컬럼의 셀 값| ### Returns ***none*** ### Example ```javascript // Index가 3인 컬럼의 셀 정보 표시 설정 mySheet.SetScrollInfoFormat('[TOPROW / TOTALROWS] |3|'); // SaveName이 'sDept'인 컬럼의 셀 정보 표시 설정 mySheet.SetScrollInfoFormat('[TOPROW / TOTALROWS] |sDept|'); // 간단안 마크업 태그를 이용한 설정 (셀 정보에 blue 색상 적용) var format = '[TOPROW / TOTALROWS] <font color=\"blue\">|sName|</font>'; mySheet.SetScrollInfoFormat(format); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetScrollInfoFormat.html"
          },
          {
            "cid": 427,
            "sid": "SetScrollInfoPosition",
            "name": "SetScrollInfoPosition",
            "label": "SetScrollInfoPosition",
            "data": {
              "body": "> 세로 스크롤에 대한 지연 처리 방법 사용시 지연 처리 시간 동안 출력되는 메시지 출력 위치를 설정 합니다. > 세로 스크롤에 대한 지연 처리 방법 사용 여부는 `SetConfig` 메소드의 `DeferredVScroll` 속성을 이용하여 설정 합니다. ### Syntax ```javascript ObjId.SetScrollInfoPosition(pos); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |pos|`String`|<span class=\"required\">필수</span>|메시지 출력 위치 - `none` : 사용 안함 - `center` : 화면 중앙 위치 - `scroll` : 세로 스크롤의 스크롤 위치| ### Returns ***none*** ### Example ```javascript // 세로 스크롤의 스크롤 위치에 표시하도록 설정 mySheet.SetScrollInfoPosition('scroll'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetScrollInfoPosition.html"
          },
          {
            "cid": 428,
            "sid": "SetSearchingImage",
            "name": "SetSearchingImage",
            "label": "SetSearchingImage",
            "data": {
              "body": "> 조회중 대기 이미지의 url을 설정 합니다. ### Syntax ```javascript ObjId.SetSearchingImage(url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |url|`String`|<span class=\"required\">필수</span>|조회중 대기 이미지 url| ### Returns ***none*** ### Example ```javascript // 조회중 대기 이미지 url 설정 mySheet.SetSearchingImage('./img/searchProcess.png'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSearchingImage.html"
          },
          {
            "cid": 429,
            "sid": "SetSelectCol",
            "name": "SetSelectCol",
            "label": "SetSelectCol",
            "data": {
              "body": "> 포커스를 이동할 컬럼을 설정 합니다. > `SetSelectRow` 메소드와 함께 사용하며, 두 속성을 모두 사용한 `SelectCell` 메소드를 이용할 수 있습니다. ### Syntax ```javascript ObjId.SetSelectCol(col, event); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |col|`Long or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName| |event|`Boolean`|<span class=\"optional\">선택</span>|이벤트 발생 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // Index가 5인 컬럼으로 포커스 이동. mySheet.SetSelectCol(5); // SaveName이 sDeptName인 컬럼으로 포커스 이동 mySheet.SetSelectCol(\"sDeptName\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSelectCol.html"
          },
          {
            "cid": 430,
            "sid": "SetSelectRange",
            "name": "SetSelectRange",
            "label": "SetSelectRange",
            "data": {
              "body": "> 인자로 설정한 범위 영역에 대해서 Selection 설정을 합니다. ### Syntax ```javascript ObjId.SetSelectRange(startRow, startCol, endRow, endCol); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |startRow|`Number`|범위 시작 셀의 행 Index| |startCol|`Number or String`|범위 시작 셀의 컬럼 Index 또는 SaveName| |endRow|`Number`|범위 종료 셀의 행 Index| |endCol|`Number or String`|범위 종료 셀의 컬럼 Index 또는 SaveName| ### Returns ***none*** ### Example ```javascript // (2, 1) ~ (4, 2) 범위에 대한 Selection 설정 mySheet.SetSelectRange(2, 1, 4, 2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSelectRange.html"
          },
          {
            "cid": 431,
            "sid": "SetSelectRow",
            "name": "SetSelectRow",
            "label": "SetSelectRow",
            "data": {
              "body": "> 포커스를 이동할 행을 설정 합니다. > `SetSelectCol` 메소드와 함께 사용하며, 두 속성을 모두 사용한 `SelectCell` 메소드를 이용할 수 있습니다. ### Syntax ```javascript ObjId.SetSelectRow(row, event); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |row|`Long`|<span class=\"required\">필수</span>|행의 Index| |event|`Boolean`|<span class=\"optional\">선택</span>|이벤트 처리 여부| ### Returns ***none*** ### Example ```javascript // Index가 5인 행으로 포커스 이동. mySheet.SetSelectRow(5); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSelectRow.html"
          },
          {
            "cid": 432,
            "sid": "SetSelectionMode",
            "name": "SetSelectionMode",
            "label": "SetSelectionMode",
            "data": {
              "body": "> 포커스 선택 모드를 설정합니다. ### Syntax ```javascript ObjId.SetSelectionMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|설정할 포커스 선택 모드 - `0` : 셀단위 선택 - `1` : 행단위 선택 - `3` : 행단위 선택 + crtl 키를 이용한 멀티 선택 - `4` : 행전체 선택, 행 전체에 대한 동일한 색상을 지정할 때 사용 - `5` : 행단위(앞컬럼 머지 영역 기준 또는 단위데이터행 영역 기준)선택 + crtl 키를 이용한 멀티 선택| ### Returns ***none*** ### Example ```javascript // 셀 단위 선택모드 설정 mySheet.SetSelectionMode(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSelectionMode.html"
          },
          {
            "cid": 433,
            "sid": "SetSelectionSummaryInfoElement",
            "name": "SetSelectionSummaryInfoElement",
            "label": "SetSelectionSummaryInfoElement",
            "data": {
              "body": "> 선택 요약 정보 출력 대상 Dom Element를 설정합니다. > 선택 요약 정보 출력을 시트의 외부에 표현하고자 할 때 사용하며, `input`, `div`, `span` 등의 innerText 를 지원 하는 Dom Element만 설정 할 수 있습니다. ### Syntax ```javascript ObjId.SetSelectionSummaryInfoElement(); ``` ### Info ***none*** ### Returns ***Object or String, 선택 요약 정보 출력 대상 Dom Element 또는 해당 id*** ### Example ```javascript // id가 'summaryElem'인 div 에 선택 요약 정보 출력 설정 mySheet.SetSelectionSummaryInfoElement('summaryElem'); mySheet.SetSelectionSummaryInfoElement(document.getElementById('summaryElem')); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSelectionSummaryInfoElement.html"
          },
          {
            "cid": 434,
            "sid": "SetSendComboData",
            "name": "SetSendComboData",
            "label": "SetSendComboData",
            "data": {
              "body": "> `Combo`, `ComboEdit` 타입의 데이터에 대한 저장시 전송될 데이터 타입을 설정 합니다. ### Syntax ```javascript ObjId.SetSendComboData(dataRow, col, type); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |dataRow|`Number`|<span class=\"required\">필수</span>|단위 데이터 행 Index| |col|`Long or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName| |type|`String`|<span class=\"optional\">선택</span>|데이터 타입 설정값 - `code` : 코드 값 - `text` : 텍스트 값 - `code|text` : 코드와 텍스트 값을 구분자 `|`로 연결한 문자열| ### Returns ***none*** ### Example ```javascript // Index가 5인 컬럼에 대한 Text 값 전달 처리 mySheet.SetSendComboData(0, 5, \"text\"); // SaveName이 \"sDept\"인 컬럼에 대한 Code|Text 값 전달 처리 mySheet.SetSendComboData(0, \"sDept\", \"code|text\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSendComboData.html"
          },
          {
            "cid": 435,
            "sid": "SetSheetFontName",
            "name": "SetSheetFontName",
            "label": "SetSheetFontName",
            "data": {
              "body": "> 시트 전체 글꼴을 설정합니다. ### Syntax ```javascript ObjId.SetSheetFontName(name); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |name|`String`|<span class=\"required\">필수</span>|글꼴| ### Returns ***none*** ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSheetFontName.html"
          },
          {
            "cid": 436,
            "sid": "SetSheetHeight",
            "name": "SetSheetHeight",
            "label": "SetSheetHeight",
            "data": {
              "body": "> 시트 전체 높이를 설정합니다. ### Syntax ```javascript ObjId.SetSheetHeight(height, force); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |height|`Number`|<span class=\"required\">필수</span>|설정할 높이 값 (단위:px)| |force|`Boolean`|<span class=\"optional\">선택</span>|유효성 체크 없이 설정할지 여부 (Default: 0)| ### Returns ***none*** ### Example ```javascript // 시트의 전체 높이를 500픽셀로 설정 mySheet.SetSheetHeight(500); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSheetHeight.html"
          },
          {
            "cid": 437,
            "sid": "SetSheetWidth",
            "name": "SetSheetWidth",
            "label": "SetSheetWidth",
            "data": {
              "body": "> 시트 전체 너비를 설정합니다. ### Syntax ```javascript ObjId.SetSheetWidth(width); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |width|`Number`|<span class=\"required\">필수</span>|설정할 너비 값 (단위:px)| ### Returns ***none*** ### Example ```javascript // 시트의 전체 너비를 500픽셀로 설정 mySheet.SetSheetWidth(500); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetSheetWidth.html"
          },
          {
            "cid": 438,
            "sid": "SetShowButtonImage",
            "name": "SetShowButtonImage",
            "label": "SetShowButtonImage",
            "data": {
              "body": "> `Popup`, `Combo`, `Date` 데이터 타입 등에서 버튼 이미지에 대한 표시 방법을 설정 합니다. ### Syntax ```javascript ObjId.SetShowButtonImage(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|버튼 이미지 표시 방법 - `0` : Focus가 있을 때만 콤보, 달력, 팝업 이미지 표시 - `1` : Edit 가능할때 달력, 팝업 이미지 표시 - `2` : 항상 달력, 팝업 이미지 표시 - `3` : Edit 가능할때 콤보, 달력, 팝업 이미지 표시 (Default) - `4` : 항상 콤보, 달력, 팝업 이미지 표시| ### Returns ***none*** ### Example ```javascript // Focus가 있을 때만 콤보, 달력, 팝업 이미지 표시 설정 mySheet.SetShowButtonImage(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetShowButtonImage.html"
          },
          {
            "cid": 439,
            "sid": "SetShowMsgMode",
            "name": "SetShowMsgMode",
            "label": "SetShowMsgMode",
            "data": {
              "body": "> 메시지를 시스템 팝업으로 표시할지 여부를 설정합니다. > 설정값이 0 인 경우는 `OnMessage` 이벤트로 메시지를 전달합니다. ### Syntax ```javascript ObjId.SetShowMsgMode(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Boolean`|<span class=\"required\">필수</span>|시스템 팝업 사용 여부| ### Returns ***none*** ### Example ```javascript // 시스템 팝업을 사용하지 않고 메시지를 OnMessage 이벤트로 전달하도록 설정 mySheet.SetShowMsgMode(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetShowMsgMode.html"
          },
          {
            "cid": 440,
            "sid": "SetShowSortArrow",
            "name": "SetShowSortArrow",
            "label": "SetShowSortArrow",
            "data": {
              "body": "> 헤더 클릭시 Sort 정보를 나타내는 이미지 표시 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetShowSortArrow(show); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |show|`Boolean`|<span class=\"required\">필수</span>|화살표 이미지 표시 여부| ### Returns ***none*** ### Example ```javascript // Sort 이미지 표시 안함 설정 mySheet.SetShowSortArrow(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetShowSortArrow.html"
          },
          {
            "cid": 441,
            "sid": "SetStartEdit",
            "name": "SetStartEdit",
            "label": "SetStartEdit",
            "data": {
              "body": "> 현재 포커스 되어 있는 셀을 편집모드로 변경 합니다. ### Syntax ```javascript ObjId.SetStartEdit(select, text); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |select|`Boolean`|<span class=\"optional\">선택</span>|편집시 기존 값에 대한 select 처리 여부| |text|`String`|<span class=\"optional\">선택</span>|편집모드시 표시할 문자열 (빈값인 경우 이전 셀의 값으로 표시)| ### Returns ***none*** ### Example ```javascript // 현재 포커스 셀을 편집모드로 변경 처리 mySheet.SetStartEdit(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetStartEdit.html"
          },
          {
            "cid": 442,
            "sid": "SetTabBehavior",
            "name": "SetTabBehavior",
            "label": "SetTabBehavior",
            "data": {
              "body": "> 포커스 상태에서 Tab 키 입력에 대한 동작 방법을 설정 합니다. ### Syntax ```javascript ObjId.SetTabBehavior(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Number`|<span class=\"required\">필수</span>|Tab 동작 방법 설정값 - `0` : 편집 가능한 셀에 대해서만 탭 이동 처리 - `1` : 모든 셀에 대해서 탭 이동 처리| ### Returns ***none*** ### Example ```javascript // 편집 가능한 셀에 대해서만 탭 이동 처리 모드 설정 mySheet.SetTabBehavior(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetTabBehavior.html"
          },
          {
            "cid": 443,
            "sid": "SetTabIndex",
            "name": "SetTabIndex",
            "label": "SetTabIndex",
            "data": {
              "body": "> 시트에 TabIndex를 부여하여 tab을 통해 시트 안/밖으로 포커스가 움직일 수 있도록 설정합니다. ### Syntax ```javascript ObjId.SetTabIndex(index); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |index|`Number`|<span class=\"required\">필수</span>|설정할 TabIndex| ### Returns ***none*** ### Example ```javascript // 시트에 tabIndex를 1로 설정 mySheet.SetTabIndex (1); ``` ### Since |version|desc| |---|---| |7.0.13.100||",
              "since": "|version|desc||---|---||7.0.13.100||"
            },
            "url": "docs/funcs/core/SetTabIndex.html"
          },
          {
            "cid": 444,
            "sid": "SetTheme-2",
            "name": "SetTheme",
            "label": "SetTheme",
            "data": {
              "body": "> 시트에 테마를 설정합니다. ### Syntax ```javascript ObjId.SetTheme(prefix, folder); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |prefix|`String`|<span class=\"required\">필수</span>|테마에서 사용하는 class의 prefix 값| |folder|`String`|<span class=\"required\">필수</span>|테마의 폴더 명| ### Returns ***none*** ### Example ```javascript // Blue 테마 설정 mySheet.SetTheme(\"BL\", \"Blue\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetTheme.html"
          },
          {
            "cid": 445,
            "sid": "SetTotalRows",
            "name": "SetTotalRows",
            "label": "SetTotalRows",
            "data": {
              "body": "> 조회해야 할 전체 조회 대상 건수를 설정 합니다. ### Syntax ```javascript ObjId.SetTotalRows(total); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |total|`Number`|<span class=\"required\">필수</span>|조회 대상 건수| ### Returns ***none*** ### Example ```javascript // 전제 조회 대상 건수를 1000건으로 설정 mySheet.SetTotalRows(1000); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetTotalRows.html"
          },
          {
            "cid": 446,
            "sid": "SetUnicodeByte",
            "name": "SetUnicodeByte",
            "label": "SetUnicodeByte",
            "data": {
              "body": "> 2byte 이상의 문자에 대한 처리할 byte 설정 값을 설정 합니다. > 설정 값이 `number` 형태인 경우 해당 `byte 값`으로 계산 처리되고, `utf-8` 인 경우 `utf-8` 형식에 맞게 처리할 수 있습니다. ### Syntax ```javascript ObjId.SetUnicodeByte(); ``` ### Info ***none*** ### Returns ***Number or String, 설정값 또는 설정모드*** ### Example ```javascript // \"utf-8\" 모드로 설정 mySheet.SetUnicodeByte(\"utf-8\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetUnicodeByte.html"
          },
          {
            "cid": 447,
            "sid": "SetUploadingImage",
            "name": "SetUploadingImage",
            "label": "SetUploadingImage",
            "data": {
              "body": "> 업로드중 대기 이미지의 url을 설정 합니다. ### Syntax ```javascript ObjId.SetUploadingImage(url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |url|`String`|<span class=\"required\">필수</span>|업로드중 대기 이미지 url| ### Returns ***none*** ### Example ```javascript // 업로드중 대기 이미지 url 설정 mySheet.SetUploadingImage('./img/uploadProcess.png'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetUploadingImage.html"
          },
          {
            "cid": 448,
            "sid": "SetUseDefaultTime",
            "name": "SetUseDefaultTime",
            "label": "SetUseDefaultTime",
            "data": {
              "body": "> 셀의 Format 이 `Hm` 또는 `Hms` 이고, 셀의 데이터가 빈 값(공백)인 상태에서 편집 모드로 변경시 시스템의 현재 시간을 기본으로 설정할지 여부를 설정 합니다. > `0` 으로 설정하면 시스템 현재 시간을 표시하지 않고 공백상태로 표시합니다. ### Syntax ```javascript ObjId.SetUseDefaultTime(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Boolean`|<span class=\"required\">필수</span>|현재 시간 표시 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 현재 시간을 표시하지 않도록 설정 mySheet.SetUseDefaultTime(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetUseDefaultTime.html"
          },
          {
            "cid": 449,
            "sid": "SetUserAgent",
            "name": "SetUserAgent",
            "label": "SetUserAgent",
            "data": {
              "body": "> 조회나 저장시 HTTP 헤더 정보에 포함되어 넘어가는 IBUserAgent의 값을 설정 합니다. ### Syntax ```javascript ObjId.SetUserAgent(value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |value|`String`|<span class=\"required\">필수</span>|IBUserAgent 설정 값| ### Returns ***none*** ### Example ```javascript // IBUserAgent 설정 mySheet.SetUserAgent(\"IBSheetCall\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetUserAgent.html"
          },
          {
            "cid": 450,
            "sid": "SetVisible",
            "name": "SetVisible",
            "label": "SetVisible",
            "data": {
              "body": "> 시트의 표시 여부를 설정 합니다. > `0`으로 설정하면 건수 정보를 포함한 모든 것이 숨겨져서 보이지 않으며, `1`로 설정하면 모든 정보를 볼 수 있습니다. ### Syntax ```javascript ObjId.SetVisible(visible); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |visible|`Boolean`|<span class=\"required\">필수</span>|시트 표시 여부| ### Returns ***none*** ### Example ```javascript // 시트를 숨김상태로 설정 한다. mySheet.SetVisible(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetVisible.html"
          },
          {
            "cid": 451,
            "sid": "SetWaitImage",
            "name": "SetWaitImage",
            "label": "SetWaitImage",
            "data": {
              "body": "> 처리중 대기 이미지의 url을 설정 합니다. > 기본적으로 제공하는 처리 중 대기 이미지를 사용자가 원하는 이미지로 변경하기 위한 기능으로 조회 중 대기 이미지와 저장 중 대기 이미지를 모두 포함하고 있는 처리 중 대기 이미지입니다. ### Syntax ```javascript ObjId.SetWaitImage(url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |url|`String`|<span class=\"required\">필수</span>|이미지 url| ### Returns ***none*** ### Example ```javascript // 처리중 대기 이미지 url 설정 mySheet.SetWaitImage('./img/process.png'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetWaitImage.html"
          },
          {
            "cid": 452,
            "sid": "SetWaitImageVisible",
            "name": "SetWaitImageVisible",
            "label": "SetWaitImageVisible",
            "data": {
              "body": "> 조회, 저장, 다운로드 등의 기능이 진행중인 동안 표시되는 대기 이미지에 대한 사용 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetWaitImageVisible(use); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |use|`Boolean`|<span class=\"required\">필수</span>|각종 대기 이미지 표시 여부| ### Returns ***none*** ### Example ```javascript // 대기 이미지를 사용 하지 않도록 설정 mySheet.SetWaitImageVisible(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetWaitImageVisible.html"
          },
          {
            "cid": 453,
            "sid": "SetWaitTimeOut",
            "name": "SetWaitTimeOut",
            "label": "SetWaitTimeOut",
            "data": {
              "body": "> 조회, 저장 등 서버의 응답을 받는 경우 대기할 응답 대기 시간을 설정합니다. > 설정한 대기 시간 동안 서버의 응답이 없는 경우 `OnSearchEnd`, `OnSaveEnd` 등의 콜백 이벤트의 결과코드가 `-6`으로 반환 됩니다. ### Syntax ```javascript ObjId.SetWaitTimeOut(time); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |time|`Number`|<span class=\"required\">필수</span>|서버 응답 대기 시간 (단위: 초)| ### Returns ***none*** ### Example ```javascript // 서버 응답 대기 시간을 60초로 설정 mySheet.SetWaitTimeOut(60); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/SetWaitTimeOut.html"
          },
          {
            "cid": 454,
            "sid": "ShowCalendar",
            "name": "ShowCalendar",
            "label": "ShowCalendar",
            "data": {
              "body": "> 현재 선택된 셀에서의 달력 팝업을 출력합니다. > `제약사항` 데이터 타입이 `Text` 이고, `날짜 포맷` 형태를 사용하는 셀에서만 사용이 가능합니다. ### Syntax ```javascript ObjId.ShowCalendar(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 데이터 타입이 `Text` 이고, 날짜 포맷 형태를 사용하는 Index가 3인 컬럼에서 onclick 시 달력 팝업 출력 function mySheet_OnClick(row, col) { if (col === 3) { mySheet.ShowCalendar(); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ShowCalendar.html"
          },
          {
            "cid": 455,
            "sid": "ShowColumnPopup",
            "name": "ShowColumnPopup",
            "label": "ShowColumnPopup",
            "data": {
              "body": "> 대상 셀에 설정되어 있는 컬럼 팝업 메뉴를 출력합니다. > 컬럼 팝업 메뉴는 `InitColumns` 메소드에서 설정합니다. > `mousePos` 인자의 설정이 `0`인 경우 대상 셀의 하단에 메뉴가 출력됩니다. ### Syntax ```javascript ObjId.ShowColumnPopup(row, col, mousePos); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Number`|<span class=\"required\">필수</span>|대상 행의 Index| |col|`Long or String`|<span class=\"required\">필수</span>|대상 컬럼의 Index 또는 SaveName| |mousePos|`Number`|<span class=\"optional\">선택</span>|마우스 위치 출력 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀에서 컬럼 팝업 메뉴 출력 mySheet.ShowColumnPopup(2, 3); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ShowColumnPopup.html"
          },
          {
            "cid": 456,
            "sid": "ShowFindDialog",
            "name": "ShowFindDialog",
            "label": "ShowFindDialog",
            "data": {
              "body": "> 찾기 다이얼로그를 표시합니다. > `ctrl + shift + F` 또는 `ctrl + alt + F` 단축키 입력시에도 찾기 다이얼로그를 표시 할 수 있습니다. ### Syntax ```javascript ObjId.ShowFindDialog(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 찾기 다이얼로그 표시 mySheet.ShowFindDialog(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ShowFindDialog.html"
          },
          {
            "cid": 457,
            "sid": "ShowProcessDlg",
            "name": "ShowProcessDlg",
            "label": "ShowProcessDlg",
            "data": {
              "body": "> 시트 중앙 위치에 대기중 이미지를 표시합니다. > 표시된 대기중 이미지는 `HideProcessDlg` 메소드를 이용하여 닫을 수 있습니다. ### Syntax ```javascript ObjId.ShowProcessDlg(type); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |type|`String`|<span class=\"required\">필수</span>|대기중 이미지 종류 - `Search` : 조회 대기 이미지 (Default) [(SetSearchingImage 참조)](/docs/funcs/core/SetSearchingImage) - `Save` : 저장 대기 이미지 [(SetSavingImage 참조)](/docs/funcs/core/SetSavingImage) - `Download` : 다운로드 대기 이미지 [(SetDownloadingImage 참조)](/docs/funcs/core/SetDownloadingImage) - `Upload` : 업로드 대기 이미지 [(SetUploadingImage 참조)](/docs/funcs/core/SetUploadingImage)| ### Returns ***none*** ### Example ```javascript // 조회중 대기 이미지 출력 mySheet.ShowProcessDlg('Search'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ShowProcessDlg.html"
          },
          {
            "cid": 458,
            "sid": "ShowToolTip",
            "name": "ShowToolTip",
            "label": "ShowToolTip",
            "data": {
              "body": "> 데이터 영역의 모든 셀에 대한 툴립 사용 여부를 설정합니다. ### Syntax ```javascript ObjId.ShowToolTip(use); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |use|`Boolean`|<span class=\"required\">필수</span>|툴팁 사용 여부| ### Returns ***none*** ### Example ```javascript // 데이터 영역의 모든 셀에 대한 툴팁 사용 설정 mySheet.ShowToolTip(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ShowToolTip.html"
          },
          {
            "cid": 459,
            "sid": "ValidateFail",
            "name": "ValidateFail",
            "label": "ValidateFail",
            "data": {
              "body": "> 저장 처 Validation 결과를 성공 또는 실패로 설정합니다. > 이 메소드는 저장 처리시 대상 셀별 발생 하는 `OnValidation` 또는 `OnEditValidation` 이벤트 내에서만 사용이 가능 하며 실패로 설정시 저장 처리는 중단 됩니다. > 유효하지 않은 데이터를 발견하여 저장처리를 중단하고자 할 때 이 속성을 설정하여 처리합니다. ### Syntax ```javascript ObjId.ValidateFail(fail, message); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |fail|`Number`|<span class=\"required\">필수</span>|저장 처리 중단 여부 설정값 - `0` : valid - `1` : invalid (입력값 취소 / 편집 완료) - `2` : invalid (편집상태 유지)| |message|`String`|<span class=\"optional\">선택</span>|fail 인자 설정값이 2인 경우 표시할 메시지| ### Returns ***none*** ### Example ```javascript // OnValidation 이벤트에서의 사용 function mySheet_OnValidation(row, col value) { if (Col == 2 && Value > 100) { alert(\"금액 최대값은 100입니다.\"); mySheet.ValidateFail(1); } } // OnEditValidation 이벤트에서의 사용 function mySheet_OnEditValidation(row, col value) { if (Col == 2 && Value > 100) { // alert 으로 메시지를 표시하고 편집상태를 유지 mySheet.ValidateFail(2, \"금액 최대값은 100입니다.\"); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/ValidateFail.html"
          },
          {
            "cid": 460,
            "sid": "Version",
            "name": "Version",
            "label": "Version",
            "data": {
              "body": "> 현재 로드된 시트에서 `ibsheet.js` 파일의 버전을 확인합니다. ### Syntax ```javascript ObjId.Version(); ``` ### Info ***none*** ### Returns ***String, IBSheet7 버전*** ### Example ```javascript // 현재의 IBSheet 버전 확인 console.log(\"version:\", mySheet.Version()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/core/Version.html"
          }
        ]
      },
      {
        "gid": 5,
        "name": "funcs-export",
        "label": "export",
        "children": [
          {
            "cid": 461,
            "sid": "DirectDown2Excel",
            "name": "DirectDown2Excel",
            "label": "DirectDown2Excel",
            "data": {
              "body": "> 서버에서 데이터를 구성한 후 엑셀을 다운로드 합니다. > 헤더타이틀이나 각 컬럼의 서식(포맷)정보만 서버로 전달하고, 데이터 부분은 별도의 페이지(혹은 서블릿)를 통해 데이터를 java.util.List(java.util.Map) 구조로 생성하여 \"SHEETDATA\"라는 이름으로 request객체에 담아 `DirectDown2Excel.jsp` 파일에 전달하면 헤더 정보와 데이터를 조합하여 엑셀 파일을 다운 받습니다. ### Syntax ```javascript ObjId.DirectDown2Excel([parameters]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |AllTypeToText|`Boolean`|<span class=\"optional\">선택</span>|날짜 데이터를 날짜 서식으로 다운로드 받을지 여부 (Default: 0)| |AppendPrevSheet|`Boolean`|<span class=\"optional\">선택</span>|Buffer 모드 사용시 이전 워크시트에 Append 적용 여부 (Default: 0)| |AutoSizeColumn|`Boolean`|<span class=\"optional\">선택</span>|컬럼 넓이 자동 조절 여부 (Default: 0(컬럼 넓이 자동 조절 안함))| |ComboValidation|`Boolean`|<span class=\"optional\">선택</span>|콤보의 드롭다운 형식 다운로드 여부 (Defualt: 0)| |DownCols|`String`|<span class=\"optional\">선택</span>|다운로드 받을 열들을 `|` 로 연결 (Default: \"\")(사용안함)| |DownCombo|`String`|<span class=\"optional\">선택</span>|콤보의 TEXT/CODE 형태의 다운로드 여부 (Default: \"TEXT\")| |DownHeader|`Boolean`|<span class=\"optional\">선택</span>|헤더의 다운로드 여부 (Default: 1)| |ExcelFontSize|`Number`|<span class=\"optional\">선택</span>|폰트 크기 설정 (Default: 0)| |ExcelHeaderRowHeight|`String`|<span class=\"optional\">선택</span>|헤더 높이 설정 (Default: \"\")(사용안함)| |ExcelRowHeight|`String`|<span class=\"optional\">선택</span>|엑셀의 행높이 설정 (Default: \"\")(사용안함)| |ExtendParam|`String`|<span class=\"optional\">선택</span>|서버로 전달할 추가 파라미터 Get방식의 QueryString으로 연결하여 설정 (Default: \"\")(사용안함)| |ExtendParamMethod|`String`|<span class=\"optional\">선택</span>|ExtendParam인자의 전송 방식 (Default: GET)| |FileName|`String`|<span class=\"optional\">선택</span>|저장할 파일 명 (Default: \"Excel.xls\")| |HiddenColumn|`Boolean`|<span class=\"optional\">선택</span>|열숨김 반영 여부 (Default: 0)| |KeyFieldMark|`Boolean`|<span class=\"optional\">선택</span>|KeyField 마크(*)를 다운 여부 (Default: 1(다운 받음))| |Mode|`Number`|<span class=\"optional\">선택</span>|다운로드 모드 - `-1`: Status, Delcheck, Result 타입 및 Hidden 칼럼을 제외하고 다운로드 - `0` : 모든 컬럼을 다운로드 - `1` : Status, DelCheck 타입을 제외하고 다운로드 - `2` : Hidden컬럼을 제외하고 다운로드| |Merge|`Number`|<span class=\"optional\">선택</span>|헤더의 머지의 다운로드 적용 방식 설정 - `0` : 사용 안함 - `1` : 사용함(셀 병합시 부속셀의 값 설정 함) - `2` : 사용함(셀 병합시 부속셀의 값은 설정하지 않음)| |Multipart|`Boolean`|<span class=\"optional\">선택</span>|다운로드 받을 데이터 전달 방식 (Default: 1)| |NumberFormatMode|`Number`|<span class=\"optional\">선택</span>|실수 형태의 데이터 타입에 대한 셀서식 설정 방식 설정 - `0` : 컬럼 단위 Format 기준 셀서식 설정 (Default) - `1` : 셀의 값 기준에 따라 정수 또는 실수 포맷형태의 셀서식 설정 - `2` : 일반 서식으로 설정 (별도의 셀 서식포맷을 설정하지 않음)| |NumberTypeToText|`Boolean`|<span class=\"optional\">선택</span>|숫자타입 셀 데이터를 문자 타입으로 다운로드 받을지 여부 숫자타입 컬럼의 일부 셀에 포맷을 변경하여 문자열을 삽입하는 경우 사용 (Default: 0)| |ReportXMLURL|`String`|<span class=\"optional\">선택</span>|엑셀파일에 타이틀이나 패턴등을 별도의 xml파일을 통해 설정| |SheetDesign|`Number`|<span class=\"optional\">선택</span>|디자인 다운로드 적용 여부 - `0` : 셀 외곽선을 제외한 모든 디자인 적용 안함 (Default) - `1` : 모든 셀 스타일을 적용 - `2` : 셀 외곽선을 제외한 셀 스타일을 적용 - `3` : 셀 외곽선 및 스타일을 모두 적용 안함| |SheetName|`String`|<span class=\"optional\">선택</span>|엑셀WorkSheet이름 (Default: \"Sheet\")| |TextToGeneral|`Boolean`|<span class=\"optional\">선택</span>|Type:”Text”의 엑셀 서식 형식 (Default: 1(일반))| |TitleAlign|`String`|<span class=\"optional\">선택</span>|타이틀 정렬 설정 (Default: \"center\"(중앙정렬))| |TitleText|`String`|<span class=\"optional\">선택</span>|IBSheet 위쪽에 제목이나 기타 자료들의 문자열 설정 컬럼 구분자 `|`로 연결, 행 구분자 `\\r\\n`로 연결, 해당 셀안에서 줄바꿈처리를 하려면 `\\r` 또는 `\\n`을 설정 (Default: \"\")(사용안함) ![s](/assets/imgs/ibsheet7_titletext.png)| |URL|`String`|<span class=\"optional\">선택</span>|엑셀 데이터를 생성할 페이지 (Default: \"\")(사용안함)| |UserMerge|`String`|<span class=\"optional\">선택</span>|해당 영역에 대한 머지처리 (Default: \"\")(사용안함) ![s](/assets/imgs/ibsheet7-usermerge.png)| |WordWrap|`Boolean`|<span class=\"optional\">선택</span>|줄바꿈 처리 여부(Default: 1)(줄바꿈 허용)| |ReqHeader|`Boolean`|<span class=\"optional\">선택</span>|Request Header에 사용자가 지정한 헤더 정보를 설정합니다. 이 인자를 설정하면 UseXhr을 true로 설정한 것과 동일하게 동작합니다.| |UseXhr|`Boolean`|<span class=\"optional\">선택</span>|iframe를 통한 form submit 방식으로 통신하는 기존 방식과 다르게 엑셀 다운로드시 통신 방식을 xhr로 설정합니다. 프레임웍의 각종 보안처리로 인하여 iframe를 사용할 수 없다거나 Cookie(파일 다운로드 완료 후 화면의 대기이미지 닫을 때 필요)를 읽고 쓸수 없을 때 이 속성을 true로 설정해주세요.| ### Returns ***none*** ### Example ```javascript // DirectDown2Excel 순서 // 1. DirectDown2Excel 메소드 호출 -> 2. DB 조회 -> 3. \"SHEETDATA를 담아 DirectDown2Excel.jsp페이지로 전달\" -> 4. DirectDown2Excel.jsp에서 엑셀 다운 // 시트 화면 페이지 // 1. DirectDown2Excel 메소드 호출 var param = { URL:\"/bussinessList.jsp\", ExtendParam:\"sa_nm=양진열&sa_no=980123\", FileName:\"PersonList.xls\" }; mySheet.DirectDown2Excel(param); // bussinessList.jsp 페이지 // 2. 엑셀로 내려질 데이터를 DB에서 조회 String sa_name = request.getParameter(\"sa_nm\"); String sa_no = request.getParameter(\"sa_no\"); String query = \"SELECT POSTNO, SIDO, SIGUNGU, LEE, ADDRESS FROM POSTNO\"; Class.forName(driver); conn = DriverManager.getConnection(url,id,pwd); pstmt = conn.prepareStatement(query); rs = pstmt.executeQuery(); // 3. 데이터를 List(Map)형태로 전환. // map 데이터 생성시 이름은 반드시 시트의 SaveName과 동일 해야 함. Java.util.List li = new java.util.List(); java.util.Map mp = null; while(rs.next()){ mp = new Java.util.Map(); mp.put(\"POSTNO\",rs.getString(\"POSTNO\")); mp.put(\"SIDO\",rs.getString(\"SIDO\")); .. .. li.add(mp); } // 데이터를 반드시 SHEETDATA라는 이름으로 담는다. request.setAttribute(\"SHEETDATA\", li); // 4. DirectDown2Excel.jsp 페이지로 forwardingm String forwardPath = \"./DirectDown2Excel.jsp\"; if(!\"\".equals(forwardPath)){ RequestDispatcher rd = request.getRequestDispatcher(forwardPath); rd.forward(request,response); } ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.2.0|AllTypeToText 속성 추가| |7.0.13.26|NumberFormatMode 속성 추가| |7.0.13.89|Mode 속성 추가| |7.0.13.230|ReqHeader, UseXhr 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.2.0|AllTypeToText 속성 추가||7.0.13.26|NumberFormatMode 속성 추가||7.0.13.89|Mode 속성 추가||7.0.13.230|ReqHeader, UseXhr 속성 추가|"
            },
            "url": "docs/funcs/export/DirectDown2Excel.html"
          },
          {
            "cid": 462,
            "sid": "Down2Excel",
            "name": "Down2Excel",
            "label": "Down2Excel",
            "data": {
              "body": "> IBSheet7의 내용을 엑셀 파일로 변환하여 다운로드 합니다. ### Syntax ```javascript ObjId.Down2Excel([parameters]); ``` ### Info | Parameter | Type | Required | Description | |-----------|------|----------|-------------| | AllTypeToText | `Boolean` | <span class=\"optional\">선택</span> | (숫자컬럼을 제외한) 모든 컬럼을 Text 타입으로 다운 받을지 여부 (Default: 0) | | AppendPrevSheet | `Boolean` | <span class=\"optional\">선택</span> | Buffer 모드 사용시 이전 워크시트에 Append 적용 여부 (Default: 0) | | AutoSizeColumn | `Boolean` | <span class=\"optional\">선택</span> | Default:0 (컬럼 넓이 자동 조절 안함) | | CheckBoxOffValue | `String` | <span class=\"optional\">선택</span> | 체크박스의 체크 해제시의 값 (Default: 0) | | CheckBoxOnValue | `String` | <span class=\"optional\">선택</span> | 체크박스의 체크시의 값 (Default: 1) | | ComboValidation | `Boolean` | <span class=\"optional\">선택</span> | 콤보의 드롭다운 형식 다운로드 여부 (Defualt: 0) | | DownCols | `String` | <span class=\"optional\">선택</span> | 다운로드 받을 열들을 설정 (ex: \"1\\|3\\|5\" 식의 문자열)` | | DownCombo | `String` | <span class=\"optional\">선택</span> | 콤보의 TEXT/CODE 형태의 다운로드 여부 (Default: \"TEXT\") | | DownHeader | `Boolean` | <span class=\"optional\">선택</span> | 헤더의 다운로드 여부 (Default: 1) | | DownRows | `String` | <span class=\"optional\">선택</span> | 다운로드 받을 행을 설정 - `\"\"` : 모든 행을 다운로드 - `\"5\\|12\\|14\"` : 5,12,14 번 행을 다운로드 | | DownSum | `Boolean` | <span class=\"optional\">선택</span> | 합계행 다운로드 여부 (Default: 1) | | DownTreeHide | `Boolean` | <span class=\"optional\">선택</span> | 트리의 접혀진 행 다운로드 여부 (Default: 0) | | ExcelFontSize | `Number` | <span class=\"optional\">선택</span> | 폰트 크기 설정 (Default: 0) | | ExcelFontFamily | `Number` | <span class=\"optional\">선택</span> | 폰트 설정 (클라이언트 모듈만 지원) | | ExcelHeaderRowHeight | `String` | <span class=\"optional\">선택</span> | 헤더 높이 설정 (Default: \"\")(사용안함) | | ExcelRowHeight | `String` | <span class=\"optional\">선택</span> | (Default: \"\")(사용안함) | | ExcludeSubSum | `Number` | <span class=\"optional\">선택</span> | 소계/누계 행 제외 여부 (Default: 0) | | ExcludeFooterRow | `Number` | <span class=\"optional\">선택</span> | ShowFooterRow 로 생성한 FooterRow 행 제외 여부 (Default :0) - `0` : 소계, 누계 포함 - `1` : 소계 제외 - `2` : 누계 제외 - `3` : 소계, 누계 제외 | | ExtendParam | `String` | <span class=\"optional\">선택</span> | 서버로 전달할 추가 파라미터 (Get방식의 QueryString으로 연결하여 설정) (Default: \"\")(사용안함) | | ExtendParamMethod | `String` | <span class=\"optional\">선택</span> | ExtendParam인자의 전송 방식 (Default: GET) | | FileName | `String` | <span class=\"optional\">선택</span> | 저장할 파일 명 (Default: \"Excel.xls\") | | HiddenColumn | `Boolean` | <span class=\"optional\">선택</span> | 열숨김 반영 여부 (Default: 0) | | KeyFieldMark | `Boolean` | <span class=\"optional\">선택</span> | KeyField 마크(\\*)를 다운 여부 (Default: 1(다운 받음)) | | Mode | `Number` | <span class=\"optional\">선택</span> | 다운로드 모드 - `-1` : Status, Delcheck, Result 타입 및 Hidden 칼럼을 제외하고 다운로드 - `0` : 모든 컬럼을 다운로드 - `1` : Status, DelCheck 타입을 제외하고 다운로드 - `2` : Hidden컬럼을 제외하고 다운로드 | | Merge | `Number` | <span class=\"optional\">선택</span> | 헤더의 머지의 다운로드 적용 방식 설정 (Default: 0) - `0` : 사용 안함 - `1` : 사용함(셀 병합시 부속셀의 값 설정 함) - `2` : 사용함(셀 병합시 부속셀의 값은 설정하지 않음)| | Multipart | `Boolean` | <span class=\"optional\">선택</span> | 다운로드 받을 데이터 전달 방식 (Default: 1) | | NumberExMode | `Number` | <span class=\"optional\">선택</span> | 실수 형태의 데이터 타입에 대한 셀서식 설정 방식 설정 (Default: 0) | | NumberTypeToText | `Boolean` | <span class=\"optional\">선택</span> | 숫자타입 셀 데이터를 문자 타입으로 다운로드 받을지 여부 숫자타입 컬럼의 일부 셀에 포맷을 변경하여 문자열을 삽입하는 경우 사용 (Default: 0) | | NumberFormatMode | `Boolean` | <span class=\"optional\">선택</span> | 시트의 숫자 컬럼 포맷을 숫자 서식으로 내려받을지 여부 설정 - `0` : 컬럼 단위 Format 기준 셀서식 설정 - `1` : 셀의 값 기준에 따라 정수 또는 실수 포맷형태의 셀서식 설정 - `2` : 일반 서식으로 설정 (별도의 셀 서식포맷을 설정하지 않음) | | OnlyHeaderMerge | `Boolean` | <span class=\"optional\">선택</span> | 헤더만 머지할지의 여부 (Deafult: 0) | | PrintSetup | `Object` | <span class=\"optional\">선택</span> | 엑셀파일에 인쇄 설정 셋팅 여부 (자세한 속성은 아래 Enum 참조) | | ReportXMLURL | `String` | <span class=\"optional\">선택</span> | 엑셀파일에 타이틀이나 패턴등을 별도의 xml파일을 통해 설정 | | SheetDesign | `Number` | <span class=\"optional\">선택</span> | 디자인 다운로드 적용 여부 - `0` : 셀 외곽선을 제외한 모든 디자인 적용 안함 (Default) - `1` : 모든 셀 스타일을 적용 - `2` : 셀 외곽선을 제외한 셀 스타일을 적용 - `3` : 셀 외곽선 및 스타일을 모두 적용 안함 | | SheetName | `String` | <span class=\"optional\">선택</span> | 엑셀WorkSheet이름 (Default: \"Sheet\") | | TextToGeneral | `Boolean` | <span class=\"optional\">선택</span> | Type:”Text”의 엑셀 서식 형식 (Default: 1(일반)) | | TitleAlign | `String` | <span class=\"optional\">선택</span> | 타이틀 정렬 설정 (Default: \"center\"(중앙정렬)) | | TitleText | `String` | <span class=\"optional\">선택</span> | IBSheet 위쪽에 제목이나 기타 자료들의 문자열 설정 컬럼 구분자 \\` | | URL | `String` | <span class=\"optional\">선택</span> | 엑셀 데이터를 생성할 페이지 (Default: \"\")(사용안함) | | UserMerge | `String` | <span class=\"optional\">선택</span> | 해당 영역에 대한 머지처리 (Default: \"\")(사용안함) ![s](/assets/imgs/ibsheet7-usermerge.png) | | WordWrap | `Boolean` | <span class=\"optional\">선택</span> | 줄바꿈 처리 여부 (Default: 1(줄바꿈 허용)) | | FreezePane | `Number` | <span class=\"optional\">선택</span> | 틀고정 다운로드 옵션 - `1` : 헤더 고정 - `2` : FrozenCol 고정 - `3` : 헤더 + FrozenCol 고정 - `4` : FrozenRow 고정 - `5` : FrozenRow + FrozenCol 고정 | | ReqHeader | `Boolean` | <span class=\"optional\">선택</span> | Request Header에 사용자가 지정한 헤더 정보를 설정합니다. 이 인자를 설정하면 UseXhr을 true로 설정한 것과 동일하게 동작합니다. | | UseXhr | `Boolean` | <span class=\"optional\">선택</span> | iframe를 통한 form submit 방식으로 통신하는 기존 방식과 다르게 엑셀 다운로드시 통신 방식을 xhr로 설정합니다. 프레임웍의 각종 보안처리로 인하여 iframe를 사용할 수 없다거나 Cookie(파일 다운로드 완료 후 화면의 대기이미지 닫을 때 필요)를 읽고 쓸수 없을 때 이 속성을 true로 설정해주세요. | ### Enum * PrintSetup | Name | Type | Required | Description | |------|------|----------|-------------| | PageSize | `String` | <span class=\"optional\">선택</span> | 용지 사이즈를 설정 | | LandSacpe | `Boolean` | <span class=\"optional\">선택</span> | 용지 방향을 설정, true는 가로, false는 세로 | | AutoBreak | `Boolean` | <span class=\"optional\">선택</span> | 페이지를 나눌 때 셀 잘림 여부 | | FitToPage | `Boolean` | <span class=\"optional\">선택</span> | 용지 내에 페이지를 맞춰서 인쇄할 때 사용 | | FitWidth | `Boolean` | <span class=\"optional\">선택</span> | 페이지 내에 열 맞춤 설정, true로 설정 시 FittoPage(true); 와 FitHeight(false); 를 함께 설정 | | FitHeight | `Boolean` | <span class=\"optional\">선택</span> | 페이지 내에 행 맞춤 설정, true로 설정 시 FittoPage(true); 와 FitWidth(false); 를 함께 설정 | | ColorPrint | `Boolean` | <span class=\"optional\">선택</span> | 컬러 인쇄 여부를 설정, 기본값은 true이고 false로 설정하면 흑백인쇄 모드 | | TopMargin | `Number` | <span class=\"optional\">선택</span> | 위쪽 여백을 cm 단위로 설정 | | BottomMargin | `Number` | <span class=\"optional\">선택</span> | 아래쪽 여백을 cm 단위로 설정 | | HeaderMargin | `Number` | <span class=\"optional\">선택</span> | 머리글 부분의 여백을 cm 단위로 설정 | | FooterMargin | `Number` | <span class=\"optional\">선택</span> | 꼬리글 부분의 여백을 cm 단위로 설정 | | LeftMargin | `Number` | <span class=\"optional\">선택</span> | 왼쪽 여백을 cm 단위로 설정 | | RightMargin | `Number` | <span class=\"optional\">선택</span> | 오른쪽 여백을 cm 단위로 설정 | ### Returns **_none_** ### Example ```javascript // 엑셀로 내려 받기 mySheet.Down2Excel(); // 파일명을 excel2로 하고 워크시트명은 sheet-test 로 정의하여 내려 받기 mySheet.Down2Excel({\"FileName\":\"excel2\", \"SheetName\":\"sheet-test\"}); //시트 색상과 머지를 모두 반영하며, 콤보는 코드로, 체크는 Y/N으로 다운로드 받되, 헤더와 합계는 제외하고 컬럼은 왼쪽에서 3개의 컬럼만 다운로드 한다. mySheet.Down2Excel({ \"SheetDesign\": 1, \"Merge\": 1, \"DownCombo\": \"CODE\", \"CheckBoxOnValue\": \"Y\", \"CheckBoxOffValue\": \"N\", \"DownRows\": \"\", \"DownCols\": \"0|1|2\", \"DownHeader\": 0, \"DownSum\": 0 }); ``` ### Since | version | desc | |---------|------| | 7.0.0.0 | | | 7.0.2.0 | AllTypeToText 속성 추가 | | 7.0.13.11 | AppendPrevSheet 속성 추가 | | 7.0.13.26 | NumberFormatMode 속성 추가 | | 7.0.13.89 | Mode 속성 추가 | | 7.0.13.94 | NumberExMode 속성 추가 | | 7.0.13.110 | ExcelHeaderRowHeight 속성 추가 | | 7.0.13.111 | PrintSetup 속성 추가 | | 7.0.13.121 | ExcludeFooterRow 속성 추가 | | 7.0.13.218 | FreezePane 속성 추가 클라이언트 모듈 : 7.0.0.37-20230511-16 서버모듈 : ibsheet7-2.1.6.jar | | 7.0.13.230 | ReqHeader, UseXhr 속성 추가 | | 7.0.13.245 | ExcelFontFamily 속성 추가 |",
              "since": "| version | desc ||---------|------|| 7.0.0.0 |  || 7.0.2.0 | AllTypeToText 속성 추가 || 7.0.13.11 | AppendPrevSheet 속성 추가 || 7.0.13.26 | NumberFormatMode 속성 추가 || 7.0.13.89 | Mode 속성 추가 || 7.0.13.94 | NumberExMode 속성 추가 || 7.0.13.110 | ExcelHeaderRowHeight 속성 추가 || 7.0.13.111 | PrintSetup 속성 추가 || 7.0.13.121 | ExcludeFooterRow 속성 추가 || 7.0.13.218 | FreezePane 속성 추가<br>클라이언트 모듈 : 7.0.0.37-20230511-16<br>서버모듈 : ibsheet7-2.1.6.jar || 7.0.13.230 | ReqHeader, UseXhr 속성 추가 || 7.0.13.245 | ExcelFontFamily 속성 추가 |"
            },
            "url": "docs/funcs/export/Down2Excel.html"
          },
          {
            "cid": 463,
            "sid": "Down2ExcelBuffer",
            "name": "Down2ExcelBuffer",
            "label": "Down2ExcelBuffer",
            "data": {
              "body": "> 여러 개의 시트로부터 1개의 엑셀 문서로 다운로드 받습니다. > `isBuffer`인자를 true로 설정하면 이후로 실행되는 Down2Excel은 실제로 동작하지 않으며, 내부메모리에 버퍼링 됩니다. > 이후에 isBuffer인자를 false로 설정하는 순간 버퍼링된 모든 시트들이 하나의 엑셀 파일안에 다운로드 됩니다. > 엑셀 파일명칭은 최초에 설정된 파일명 및 엑셀 파일 포맷이 유효하며, 워크시트명이 고유하지 않고 중복될 경우 자동적으로 괄호가 부여되어 다운로드 됩니다. ### Syntax ```javascript ObjId.Down2ExcelBuffer(IsBuffer); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |IsBuffer|`Boolean`|<span class=\"required\">필수</span>|버퍼링 여부| ### Returns ***none*** ### Example ```javascript // 이후로는 버퍼링한다. 아무 동작 안함. firstSheet.Down2ExcelBuffer(true); // 첫번째 워크시트에 담아두기를 예약함. firstSheet.Down2Excel({FileName:\"excel2\",SheetName:\"sheet1\"}); // 두번째 워크시트에 담아두기를 예약함. secondSheet.Down2Excel({FileName:\"excel2\",SheetName:\"sheet2\"}); // 버퍼링된 모든 엑셀 자료를 1개의 엑셀문서에 모두 모아서 즉시 다운로드 한다. firstSheet.Down2ExcelBuffer(false); /* DirectDown2Excel로 여러개의 시트를 다운로드 하는 경우 1. Down2ExcelBuffer를 true로 설정 2. DirectDown2Excel 호출시 URL 인자를 모두 동일 페이지로 설정 3. 데이터 처리 jsp 페이지에서 호출한 순서에 맞게 \"SHEETDATA\" 생성 처음 호출한 시트는 \"SHEETDATA\"로 설정, 이후 호출한 시트는 일련번호를 붙여서 \"SHEETDATA1\", \"SHEETDATA2\" 순으로 설정 4. Down2ExcelBuffer를 false로 설정 */ // 시트에서 Down2ExcelBuffer 통해 DirectDown2Excel 호출 firstSheet.Down2ExcelBuffer(true); firstSheet.DirectDown2Excel({URL:\"../jsp/fp.jsp\",FileName:\"IBLeaders.xls\"}); secondSheet.DirectDown2Excel({URL:\"../jsp/fp.jsp\",FileName:\"IBLeaders.xls\", SheetDesign:1}); firstSheet.Down2ExcelBuffer(false); // 데이터 생성 페이지(fp.jsp) request.setAttribute(\"SHEETDATA\", li); request.setAttribute(\"SHEETDATA1\", li2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/Down2ExcelBuffer.html"
          },
          {
            "cid": 464,
            "sid": "Down2Pdf",
            "name": "Down2Pdf",
            "label": "Down2Pdf",
            "data": {
              "body": "> IBSheet의 내용을 PDF 파일로 변환하여 다운로드 합니다. 동작 방식은 아래와 같습니다. > 1. `Down2Pdf` 메소드를 호출하면 시트의 내용이 Multipart 형태로 서버의 `Down2Pdf.jsp / Down2Pdf.aspx` 파일에 전달 > 2. Down2Pdf.jsp/Down2Pdf.aspx 파일에서는 넘어온 내용을 `iText_2.1.7 라이브러리`를 이용하여 pdf 포멧의 파일로 변경하여 다시 화면쪽으로 다운로드 > 따라서 이 메소드를 이용하기 위해서는 환경에 <span style=\"color:blue;\">준비과정</span>이 필요합니다. * Java 환경 1. Down2Pdf.jsp 파일이 서버에 존재하며, ibsheet.cfg 파일에 jsp파일에 대한 경로가 정확하게 기재 되어 있어야 합니다. 2. 서버에 iText 라이브러리가 올라와 있어야 합니다. 3. 서버에 한글폰트 지원을 위한 ttf 파일이 있어야 하며 jsp 파일에 폰트 폴더에 대한 경로가 정확하게 기재되어 있어야 합니다. 4. Down2Pdf.jsp 파일을 편집기로 열어, 사용하는 서버의 폰트파일 경로와 Encoding을 설정합니다. * .Net 환경 1. Down2Pdf.aspx 파일이 서버에 존재하며, ibsheet.cfg 파일에 aspx파일에 대한 경로가 정확하게 기재 되어 있어야 합니다. 2. .Net모듈의 경우 자바 모듈을 통해 html 파일을 pdf 파일로 변환처리 하여 다운로드 하기 때문에 서버에 JVM, iText 라이브러리 및 자바버전 모듈이 모두 올라와 있어야 합니다. 3. 서버에 한글폰트 지원을 위한 ttf 파일이 있어야 하며 ttf 파일은 자바버전 모듈과 같은 위치에 두고 aspx 파일의 ModulePath 에 해당 위치를 정확히 설정해야 합니다. 4. `Down2Pdf.aspx` 파일을 편집기로 연 후, 사용하는 서버에서 임시 html파일, pdf 파일을 생성하기 위한 TempFolder(쓰기 권한이 있어야 함)와 ttf/jar파일이 위치한 ModulePath, Encoding을 설정해 줍니다. 자바 모듈인 ibsheet7-1.1.4.jar 파일은 버전에 따라 파일명이 변경되므로 서버에 적용한 자바모듈 파일명을 ModuleFile 정확히 설정해야 합니다. ### Syntax ```javascript ObjId.Down2Pdf([parameters]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DownCols|`String`|<span class=\"optional\">선택</span>|다운로드 받을 열들을 `|` 로 연결 (Default: \"\"(모두 받음))| |Dpi|`Integer`|<span class=\"optional\">선택</span>|축소/확대 비율. 값이 작을 수록 크게 출력된다. 50~32840 사이 값으로 설정 가능하다. (Default: 2000)| |ExtendParam|`String`|<span class=\"optional\">선택</span>|서버로 전달해야 하는 내용이 있는 경우 Get 방식의 QueryString으로 연결하여 설정 (Default: \"\")| |ExtendParamMethod|`String`|<span class=\"optional\">선택</span>|ExtendParam인자의 전송 방식 (Default: POST)| |FileName|`String`|<span class=\"optional\">선택</span>|저장할 파일 명 (Default: \"IBSheet.pdf\")| |FontTo|`String`|<span class=\"optional\">선택</span>|PDF 한글 폰트 선택 (Default: \"Gothic\")| |Paper|`String`|<span class=\"optional\">선택</span>|용지 방향 설정 (landscape(Default) 또는 portrait)| |Title|`String`|<span class=\"optional\">선택</span>|PDF 타이틀 텍스트 (Default: \"\")| |TitleStyle|`String`|<span class=\"optional\">선택</span>|PDF 타이틀 스타일 (Default: \"\")| |URL|`String`|<span class=\"optional\">선택</span>|PDF 다운 하기 전에 호출 페이지 (Default:\"\"(사용안함))| |WordWrap|`Boolean`|<span class=\"optional\">선택</span>|셀 텍스트 줄바꿈 여부 (Default :0(사용안함))| |ReqHeader|`Boolean`|<span class=\"optional\">선택</span>|Request Header에 사용자가 지정한 헤더 정보를 설정합니다. 이 인자를 설정하면 UseXhr을 true로 설정한 것과 동일하게 동작합니다.| |UseXhr|`Boolean`|<span class=\"optional\">선택</span>|iframe를 통한 form submit 방식으로 통신하는 기존 방식과 다르게 다운로드시 통신 방식을 xhr로 설정합니다. 프레임웍의 각종 보안처리로 인하여 iframe를 사용할 수 없다거나 Cookie(파일 다운로드 완료 후 화면의 대기이미지 닫을 때 필요)를 읽고 쓸수 없을 때 이 속성을 true로 설정해주세요.| ### Returns ***none*** ### Example ```javascript // PDF 파일로 내려 받기 mySheet.Down2Pdf(); // 다운로드할 파일명을 text로 정의하여 다운 mySheet.Down2Pdf({FileName:\"text\"}); // 다운로드할 컬럼을 지정하여 myPDF.pdf로 다운 mySheet.Down2Pdf({FileName:\"myPDF\", DownCols:\"7|8|9|4|5|6|10\"}); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.230|ReqHeader, UseXhr 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.230|ReqHeader, UseXhr 속성 추가|"
            },
            "url": "docs/funcs/export/Down2Pdf.html"
          },
          {
            "cid": 465,
            "sid": "Down2Text",
            "name": "Down2Text",
            "label": "Down2Text",
            "data": {
              "body": "> IBSheet의 내용을 텍스트 파일로 변환하여 다운로드 합니다. ### Syntax ```javascript ObjId.Down2Text([parameters]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |FileName|`String`|<span class=\"optional\">선택</span>|저장할 파일 명 (Default: \"Test.txt\")| |RowDelim|`String`|<span class=\"optional\">선택</span>|행 자료 사이에 표시될 레코드 구분자 (Default :`\\n` (엔터 형식))| |ColDelim|`String`|<span class=\"optional\">선택</span>|셀 자료 사이에 표시될 컬럼 구분자 (Default: \"\" (공백 형식))| |DownRows|`String`|<span class=\"optional\">선택</span>|다운로드 받을 행들을 | 로 연결 (Default: \"\"(모두 받음))| |DownCols|`String`|<span class=\"optional\">선택</span>|다운로드 받을 열들을 | 로 연결 (Default: \"\"(모두 받음))| |DownHeader|`Boolean`|<span class=\"optional\">선택</span>|헤더의 다운로드 여부 (Default: 1) |DownSum|`Boolean`|<span class=\"optional\">선택</span>|합계의 다운로드 여부 (Default: 1) |DownCombo|`String`|<span class=\"optional\">선택</span>|콤보의 TEXT / CODE 형태의 다운로드 여부 (Default: \"TEXT\") |ExtendParam|`String`|<span class=\"optional\">선택</span>|서버로 전달해야 하는 내용이 있는 경우 Get 방식의 QueryString으로 연결하여 설정 (Default: \"\") |DownTreeHide|`Boolean`|<span class=\"optional\">선택</span>|트리의 접혀진 행 다운 여부 (Default: 0 (다운 안받음)) |ReqHeader|`Boolean`|<span class=\"optional\">선택</span>|Request Header에 사용자가 지정한 헤더 정보를 설정합니다. 이 인자를 설정하면 UseXhr을 true로 설정한 것과 동일하게 동작합니다.| |UseXhr|`Boolean`|<span class=\"optional\">선택</span>|iframe를 통한 form submit 방식으로 통신하는 기존 방식과 다르게 다운로드시 통신 방식을 xhr로 설정합니다. 프레임웍의 각종 보안처리로 인하여 iframe를 사용할 수 없다거나 Cookie(파일 다운로드 완료 후 화면의 대기이미지 닫을 때 필요)를 읽고 쓸수 없을 때 이 속성을 true로 설정해주세요.| ### Returns ***none*** ### Example ```javascript // 텍스트 파일로 내려 받기 mySheet.Down2Text(); // 다운로드할 파일명을 text로 정의하여다운로드 받는다. mySheet.Down2Text({FileName:\"text\" }); // 콤보는 코드로 받고, 헤더와 합계는 제외하고 컬럼은 왼쪽에서 3개의 컬럼만 다운로드 한다. mySheet.Down2Text({DownCombo:\"CODE\", DownRows:\"\", DownCols:\"0|1|2\", DownHeader:0, DownSum:0}); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.230|ReqHeader, UseXhr 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.230|ReqHeader, UseXhr 속성 추가|"
            },
            "url": "docs/funcs/export/Down2Text.html"
          },
          {
            "cid": 466,
            "sid": "GetDown2ExcelConfig",
            "name": "GetDown2ExcelConfig",
            "label": "GetDown2ExcelConfig",
            "data": {
              "body": "> Down2Excel 기본 설정 옵션을 확인 합니다. ### Syntax ```javascript ObjId.GetDown2ExcelConfig(); ``` ### Info ***none*** ### Returns ***Object, Down2Excel Config*** ### Example ```javascript // Down2Excel Config를 확인 console.log(\"getDown2ExcelConfig:\", mySheet.GetDown2ExcelConfig()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/GetDown2ExcelConfig.html"
          },
          {
            "cid": 467,
            "sid": "GetDown2ExcelUrl",
            "name": "GetDown2ExcelUrl",
            "label": "GetDown2ExcelUrl",
            "data": {
              "body": "> 엑셀 다운로드 기능을 처리할 서버 페이지 경로를 확인 합니다. ### Syntax ```javascript ObjId.GetDown2ExcelUrl(); ``` ### Info ***none*** ### Returns ***String, 엑셀 다운로드 URL*** ### Example ```javascript // 엑셀 다운로드 설정 경로를 확인 console.log(\"getDown2ExcelUrl:\", mySheet.GetDown2ExcelUrl()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/GetDown2ExcelUrl.html"
          },
          {
            "cid": 468,
            "sid": "GetDown2PdfUrl",
            "name": "GetDown2PdfUrl",
            "label": "GetDown2PdfUrl",
            "data": {
              "body": "> PDF 다운로드 기능을 처리할 서버 페이지 경로를 확인 합니다. ### Syntax ```javascript ObjId.GetDown2PdfUrl(); ``` ### Info ***none*** ### Returns ***String, PDF 다운로드 URL*** ### Example ```javascript // PDF 다운로드 설정 경로를 확인 console.log(\"getDown2PdfUrl:\", mySheet.GetDown2PdfUrl()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/GetDown2PdfUrl.html"
          },
          {
            "cid": 469,
            "sid": "GetDown2TextConfig",
            "name": "GetDown2TextConfig",
            "label": "GetDown2TextConfig",
            "data": {
              "body": "> `Down2Text` 기본 설정 옵션을 확인 합니다. ### Syntax ```javascript ObjId.GetDown2TextConfig(); ``` ### Info ***none*** ### Returns ***Object, Down2Text Config*** ### Example ```javascript // Down2Text Config를 확인 console.log(\"getDown2TextConfig:\", mySheet.GetDown2TextConfig()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/GetDown2TextConfig.html"
          },
          {
            "cid": 470,
            "sid": "GetDown2TextUrl",
            "name": "GetDown2TextUrl",
            "label": "GetDown2TextUrl",
            "data": {
              "body": "> 텍스트 다운로드 기능을 처리할 서버 페이지 경로를 확인 합니다. ### Syntax ```javascript ObjId.GetDown2TextUrl(); ``` ### Info ***none*** ### Returns ***String, 텍스트 다운로드 URL*** ### Example ```javascript // 텍스트 다운로드 설정 경로를 확인 console.log(\"getDown2TextUrl:\", mySheet.GetDown2TextUrl()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/GetDown2TextUrl.html"
          },
          {
            "cid": 471,
            "sid": "SetDown2ExcelConfig",
            "name": "SetDown2ExcelConfig",
            "label": "SetDown2ExcelConfig",
            "data": {
              "body": "> Down2Excel 메소드의 기본 속성을 정의합니다. > 이 메소드를 통해 정의한 속성은 `Down2Excel` 메소드의 기본값으로 처리 됩니다. ### Syntax ```javascript ObjId.SetDown2ExcelConfig([Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Opt|`Object`|<span class=\"optional\">선택</span>|기본으로 정의할 속성 (객체 세부 사항은 [Down2Excel](/docs/funcs/export/Down2Excel) 메소드 참고)| ### Returns ***none*** ### Example ```javascript // Merge, FileName 속성에 대한 기본값 정의 mySheet.SetDown2ExcelConfig({ \"FileName\": \"excel2\", \"Merge\": 1 }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/SetDown2ExcelConfig.html"
          },
          {
            "cid": 472,
            "sid": "SetDown2ExcelUrl",
            "name": "SetDown2ExcelUrl",
            "label": "SetDown2ExcelUrl",
            "data": {
              "body": "> 엑셀 다운로드 기능을 처리할 서버 페이지 경로를 설정 합니다. ### Syntax ```javascript ObjId.SetDown2ExcelUrl(Url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|설정할 서버 페이지 Url| ### Returns ***none*** ### Example ```javascript // 엑셀 다운로드 경로를 설정 mySheet.SetDown2ExcelUrl(\"/jsp/Down2Excel.jsp\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/SetDown2ExcelUrl.html"
          },
          {
            "cid": 473,
            "sid": "SetDown2PdfUrl",
            "name": "SetDown2PdfUrl",
            "label": "SetDown2PdfUrl",
            "data": {
              "body": "> PDF 다운로드 기능을 처리할 서버 페이지 경로를 설정 합니다. ### Syntax ```javascript ObjId.SetDown2PdfUrl(Url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|설정할 서버 페이지 Url| ### Returns ***none*** ### Example ```javascript // PDF 다운로드 경로를 설정 mySheet.SetDown2PdfUrl(\"/jsp/Down2Pdf.jsp\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/SetDown2PdfUrl.html"
          },
          {
            "cid": 474,
            "sid": "SetDown2TextConfig",
            "name": "SetDown2TextConfig",
            "label": "SetDown2TextConfig",
            "data": {
              "body": "> Down2Text 메소드의 기본 속성을 정의 합니다. > 이 메소드를 통해 정의한 속성은 Down2Text 메소드의 기본값으로 처리 됩니다. ### Syntax ```javascript ObjId.SetDown2TextConfig([Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Opt|`Object`|<span class=\"optional\">선택</span>|기본으로 정의할 속성 (객체 세부 사항은 [Down2Text](/docs/funcs/export/Down2Text) 메소드 참고)| ### Returns ***none*** ### Example ```javascript // DownHeader 속성에 대한 기본값 정의 mySheet.SetDown2TextConfig({ \"DownHeader\": 1 }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/SetDown2TextConfig.html"
          },
          {
            "cid": 475,
            "sid": "SetDown2TextUrl",
            "name": "SetDown2TextUrl",
            "label": "SetDown2TextUrl",
            "data": {
              "body": "> 텍스트 다운로드 기능을 처리할 서버 페이지 경로를 설정 합니다. ### Syntax ```javascript ObjId.SetDown2TextUrl(Url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|설정할 서버 페이지 Url| ### Returns ***none*** ### Example ```javascript // 텍스트 다운로드 경로를 설정 mySheet.SetDown2TextUrl(\"/jsp/Down2Text.jsp\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/export/SetDown2TextUrl.html"
          }
        ]
      },
      {
        "gid": 6,
        "name": "funcs-filter",
        "label": "filter",
        "children": [
          {
            "cid": 476,
            "sid": "ClearFilterRow",
            "name": "ClearFilterRow",
            "label": "ClearFilterRow",
            "data": {
              "body": "> 필터 행을 초기화합니다. 초기화시 필터링이 되어있는 경우 해당 필터링은 모두 초기화 됩니다. ### Syntax ```javascript ObjId.ClearFilterRow(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 필터행 초기화 mySheet.ClearFilterRow(); ``` ### Since |version|desc| |---|---| |7.0.13.96||",
              "since": "|version|desc||---|---||7.0.13.96||"
            },
            "url": "docs/funcs/filter/ClearFilterRow.html"
          },
          {
            "cid": 477,
            "sid": "FilteredRowCount",
            "name": "FilteredRowCount",
            "label": "FilteredRowCount",
            "data": {
              "body": "> 필터행이 있는 경우 필터링 된 행의 개수를 반환합니다. 필터행이 없는 경우 -1을 반환 합니다. `주의 : 행 추가 후 바로 FilteredRowCount 를 사용하면 정확한 결과가 반환되지 않을 수 있습니다.` `행 추가 후 값을 입력 뒤 FilteredRowCount 를 사용하시기를 바랍니다.` ### Syntax ```javascript ObjId.FilteredRowCount(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 필터링 결과 건수 확인 console.log('filteredRows: ', mySheet.FilteredRowCount()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/filter/FilteredRowCount.html"
          },
          {
            "cid": 478,
            "sid": "FilteredRowIndex",
            "name": "FilteredRowIndex",
            "label": "FilteredRowIndex",
            "data": {
              "body": "> 필터링 결과의 행의 인덱스를 확인 합니다. ### Syntax ```javascript ObjId.FilteredRowIndex(); ``` ### Info ***none*** ### Returns ***Number, 필터 행의 Index*** ### Example ```javascript // 필터링 결과 확인 console.log('filteredRows: ', mySheet.FilteredRowIndex()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/filter/FilteredRowIndex.html"
          },
          {
            "cid": 479,
            "sid": "GetFilterParam",
            "name": "GetFilterParam",
            "label": "GetFilterParam",
            "data": {
              "body": "> 필터행의 필터 설정 정보를 Query String 조합 문자열로 반환합니다. > Query String 문자열 조합시 컬럼별 필터 값과 필터 옵션으로 다음과 같이 구성 됩니다. (필터 설정 옵션은 [SetFilterValue](/docs/funcs/filter/SetFilterValue) 메소드 참고) > `AllFilter` 인자를 1로 설정한 경우 필터링을 설정한 컬럼에 대해서만 처리 됩니다. > 이 기능은 필터 설정 정보를 서버에 전달하여 직접 필터링을 처리하고자 하는 경우에 사용 할 수 있습니다. ### Syntax ```javascript ObjId.GetFilterParam(AllFilter, UrlEncode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |AllFilter|`Boolean`|<span class=\"optional\">선택</span>|전체 필터링 여부 (Default: 0)| |UrlEncode|`Boolean`|<span class=\"optional\">선택</span>|UrlEncode 여부 (Default: 1)| ### Returns ***String, 필터 설정 정보 문자열*** ```html // 반환 문자열 예 {SaveName}=value&{SaveName}_opt={필터 옵션} // SaveName이 'sDeptName'이고, 필터 옵션이 11인 경우 sDeptName=인사&sDeptName_opt=11 ``` ### Example ```javascript // 필터링 설정 컬럼에 대해서만 추출 console.log('filter: ', mySheet.GetFilterParam(0)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/filter/GetFilterParam.html"
          },
          {
            "cid": 480,
            "sid": "SetFilterOption",
            "name": "SetFilterOption",
            "label": "SetFilterOption",
            "data": {
              "body": "> 필터행 사용시 컬럼의 필터 옵션값을 설정할 때 사용합니다. ### Syntax ```javascript ObjId.SetFilterOption(Col, Option, [Event]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName| |Option|`Number`|<span class=\"required\">필수</span>|설정 할 Option 값 - `0` : 사용안함 , - `1` : 같음 - `2` : 같지 않음 , - `3` : 작음 - `4` : 같거나 작음 , - `5` : 큼 - `6` : 같거나 큼 , - `7` : 단어로 시작함 - `8` : 단어로 시작하지 않음 , - `9` : 단어로 끝남 - `10` : 단어로 끝나지 않음 , - `11` : 포함함 - `12` : 포함하지 않음 | |Event|`Boolean`|<span class=\"optional\">선택</span>|[OnFilterEnd](/docs/event/OnFilterEnd) 이벤트 발생 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 필터행이 1행일 경우 2컬럼의 필터링 할 값 설정 mySheet.SetCellValue(1, 2, \"포함\"); // 필터행 2컬럼의 필터 설정 – 문자열 ‘포함' 과 같은 단어 필터링. mySheet.SetFilterOption (2, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.54|Event 인자 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.54|Event 인자 추가|"
            },
            "url": "docs/funcs/filter/SetFilterOption.html"
          },
          {
            "cid": 481,
            "sid": "SetFilterValue",
            "name": "SetFilterValue",
            "label": "SetFilterValue",
            "data": {
              "body": "> 필터행 사용시 컬럼의 필터값을 설정할 때 사용 합니다. ### Syntax ```javascript ObjId.SetFilterValue(Col, Value, Option, [Event]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|컬럼의 Index 또는 SaveName| |Value|`String`|<span class=\"required\">필수</span>|필터에 설정할 값| |Option|`Number`|<span class=\"optional\">선택</span>|설정 할 Option 값 - `0` : 사용안함 , - `1` : 같음 - `2` : 같지 않음 , - `3` : 작음 - `4` : 같거나 작음 , - `5` : 큼 - `6` : 같거나 큼 , - `7` : 단어로 시작함 - `8` : 단어로 시작하지 않음 , - `9` : 단어로 끝남 - `10` : 단어로 끝나지 않음 , - `11` : 포함함 - `12` : 포함하지 않음| |Event|`Boolean`|<span class=\"optional\">선택</span>|[OnFilterEnd](/docs/event/OnFilterEnd) 발생 여부 (Default :1)| ### Returns ***none*** ### Example ```javascript // 5컬럼에 \"서울\"이 포함된 문자열 필터링하기 mySheet.SetFilterValue(5, \"서울\", 11); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.54|Event 인자 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.54|Event 인자 추가|"
            },
            "url": "docs/funcs/filter/SetFilterValue.html"
          },
          {
            "cid": 482,
            "sid": "ShowFilterRow",
            "name": "ShowFilterRow",
            "label": "ShowFilterRow",
            "data": {
              "body": "> 데이터 영역의 상단에 고정되는 필터 행을 생성 합니다. > `참고` 함수의 호출 시점은 초기화 이후 조회 처리전에 호출 해야 합니다. ### Syntax ```javascript ObjId.ShowFilterRow(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript //필터행 추가하기 mySheet.ShowFilterRow(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/filter/ShowFilterRow.html"
          }
        ]
      },
      {
        "gid": 7,
        "name": "funcs-group",
        "label": "group",
        "children": [
          {
            "cid": 483,
            "sid": "GetGroupActionMenu",
            "name": "GetGroupActionMenu",
            "label": "GetGroupActionMenu",
            "data": {
              "body": "> 그룹행 영역에 설정된 컨텍스트 메뉴를 확인 합니다. ### Syntax ```javascript ObjId.GetGroupActionMenu(); ``` ### Info ***none*** ### Returns ***Object, MenuText, MenuCode로 이루어진 객체*** ### Example ```javascript // 그룹행의 컨텍스트 메뉴 확인 console.log(\"groupMenu:\", mySheet.GetGroupActionMenu()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/group/GetGroupActionMenu.html"
          },
          {
            "cid": 484,
            "sid": "GetGroupCol",
            "name": "GetGroupCol",
            "label": "GetGroupCol",
            "data": {
              "body": "> 현재 설정되어있는 그룹 기준 컬럼의 SaveName을 확인합니다. > 2개 이상의 컬럼이 설정되어 있는 경우는 `|`를 구분자로 하여 연결된 문자열로 리턴 합니다. ### Syntax ```javascript ObjId.GetGroupCol(); ``` ### Info ***none*** ### Returns ***String, 그룹 기준 컬럼의 SaveName을 구분자 '|'로 연결한 문자열*** ### Example ```javascript // 그룹 기준 컬럼 확인 console.log('groupCols: ', mySheet.GetGroupCol()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/group/GetGroupCol.html"
          },
          {
            "cid": 485,
            "sid": "GetGroupRow",
            "name": "GetGroupRow",
            "label": "GetGroupRow",
            "data": {
              "body": "> 대상 컬럼을 기준으로 생성된 그룹행을 확인 합니다. > 대상 그룹행의 Index를 구분자 `|`로 연결된 문자열로 반환 합니다. ### Syntax ```javascript ObjId.GetGroupRow(Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|대상 컬럼의 Index 또는 SaveName| ### Returns ***none*** ### Example ```javascript // SaveName이 \"sDept\"인 컬럼을 기준으로 생성된 그룹행 확인 console.log(\"GroupRow :\", mySheet.GetGroupRow(\"sDept\")); ``` ### Since |version|desc| |---|---| |7.0.13.22||",
              "since": "|version|desc||---|---||7.0.13.22||"
            },
            "url": "docs/funcs/group/GetGroupRow.html"
          },
          {
            "cid": 486,
            "sid": "HideGroupRow",
            "name": "HideGroupRow",
            "label": "HideGroupRow",
            "data": {
              "body": "> 시트의 그룹행을 삭제하거나 숨김처리 합니다. > 그룹행 삭제시에는 그룹핑 상태인 경우 모두 초기화 되며 숨김시에는 그룹핑 상태가 그대로 유지 됩니다. > 숨김상태인 경우 [ShowGroupRow](/docs/funcs/group/ShowGroupRow) 메소드를 통해 보이도록 처리할 수 있습니다. ### Syntax ```javascript ObjId.HideGroupRow([Del]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Del|`Boolean`|<span class=\"optional\">선택</span>|삭제 여부 (Default :1)| ### Returns ***none*** ### Example ```javascript //그룹행 삭제 mySheet.HideGroupRow(); // 그룹행 숨김 mySheet.HideGroupRow(0) ``` ### Since |version|desc| |---|---| |7.0.10.0||",
              "since": "|version|desc||---|---||7.0.10.0||"
            },
            "url": "docs/funcs/group/HideGroupRow.html"
          },
          {
            "cid": 487,
            "sid": "SetGroupActionMenu",
            "name": "SetGroupActionMenu",
            "label": "SetGroupActionMenu",
            "data": {
              "body": "> 그룹행 영역에 설정된 컨텍스트 메뉴를 설정합니다. > `주의` 이 기능을 사용하려면 초기화 함수[SetConfig](/docs/funcs/init/SetConfig) 설정시 `UseGroupActionMenu:1(true)` 로 설정되어야 합니다. ### Syntax ```javascript ObjId.SetGroupActionMenu(MenuText, MenuCode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |MenuText|`String`|<span class=\"required\">필수</span>|메뉴명을 구분자 `|`로 연결한 문자열| |MenuCode|`String`|<span class=\"required\">필수</span>|메뉴코드를 구분자 `|`로 연결한 문자열| ### Enum * Code - **_ibInitGroupCols** : 그룹 정보 초기화 - **_ibSaveGroupCols** : 그룹 정보 저장 - **_ibResetGroupCols** : 그룹 정보 저장 취소 ### Returns ***none*** ### Example ```javascript // 컬럼 정렬 메뉴 구성 mySheet.SetGroupActionMenu(\"오름차순 정렬|내림차순 정렬\", \"_ibColSortAsc|_ibColSortDesc\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/group/SetGroupActionMenu.html"
          },
          {
            "cid": 488,
            "sid": "ShowGroupRow",
            "name": "ShowGroupRow",
            "label": "ShowGroupRow",
            "data": {
              "body": "> 그룹 행을 생성 또는 보이도록 설정 합니다. > 생성된 그룹 행에 헤더의 컬럼을 `Drag & Drop` 방식으로 이동하면 해당 컬럼을 기준으로 그룹핑 할 수 있습니다. > 그룹핑은 대상 컬럼을 기준으로 트리 구조 형태로 표현 되며 그룹행의 우측 상단의 버튼을 통해 펼치기 / 접기 기능을 사용 할 수 있습니다. ### Syntax ```javascript ObjId.ShowGroupRow(Cols, Format); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Cols|`Long or String`|<span class=\"required\">필수</span>|그룹핑 하고자 하는 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |Format|`String`|<span class=\"optional\">선택</span>|아래의 키를 이용한 그룹기준 컬럼의 데이터 포맷 (Default: \"\") - `{%s}` : 해당 셀의 값 - `{%c}` : 자식노드 개수| ### Returns ***none*** ### Example ```javascript // 그룹행 생성 mySheet.ShowGroupRow(); // Index가 3인 컬럼을 기본 그룹 기준 컬럼으로 설정하여 생성 mySheet.ShowGroupRow('3'); // SaveName이 'sDept', 'sName'인 컬럼을 기본 그룹 기준 컬럼으로 설정하여 생성 mySheet.ShowGroupRow('sDept|sName'); // 그룹 기준 컬럼 포맷 설정 mySheet.ShowGroupRow('', '{%s} ({%c}건)'); // 그룹 기준 컬럼 포맷 일부에 스타일 설정 mySheet.ShowGroupRow('', '{%s} <font color=\"gray\">({%c}건)</font>'); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.10.0|Format 인자 추가| |7.0.12.1|그룹기준 컬럼 및 Format 에 대한 동적 변경 기능 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.10.0|Format 인자 추가||7.0.12.1|그룹기준 컬럼 및 Format 에 대한 동적 변경 기능 추가|"
            },
            "url": "docs/funcs/group/ShowGroupRow.html"
          }
        ]
      },
      {
        "gid": 8,
        "name": "funcs-import",
        "label": "import",
        "children": [
          {
            "cid": 489,
            "sid": "DirectLoadExcel",
            "name": "DirectLoadExcel",
            "label": "DirectLoadExcel",
            "data": {
              "body": "> 엑셀 문서를 읽어 들이는 것은 동일 하지만, 엑셀 문서의 내용을 IBSheet에 담지 않고 서버쪽에서 지정한 페이지로 전달합니다. > 엑셀로 넘어온 데이터를 받아줄 페이지를 별도로 개발하여야 하고, `DirectLoadExcel`의 `ExtendParam` 을 통해 엑셀의 내용을 받아 줄 포워딩 페이지`(FP=/jsp/excelsave.jsp)`경로를 필수로 설정해야 합니다. > 서버쪽 페이지에서 request 객체 안에 `\"SHEETDATA\"` 라는 이름으로 엑셀의 내용을 받아야 하고, SHEETDATA안의 내용은 List(Map)으로 구성되고, Map의 키는 IBSheet 각 컬럼의 SaveName이 됩니다. ### Syntax ```javascript ObjId.DirectLoadExcel([parameters]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |ColumnMapping|`String`|<span class=\"optional\">선택</span>|엑셀 컬럼 번호 (Default :\"\")| |EndRow|`String`|<span class=\"optional\">선택</span>|엑셀 로딩완료 행번호 (Default: 0)| |ExtendParam|`String`|<span class=\"required\">필수</span>|서버로 전달될 파라미터를 QueryString 형태로 넣음 (저장작업을 수행할 `FP`는 필수)| |FileExt|`String`|<span class=\"optional\">선택</span>|업로드 가능한 파일 확장자 (Default :\"\")| |MaxFileSize|`Number`|<span class=\"optional\">선택</span>| 파일의 사이즈를 제한시 사용 설정 단위 MB| |Mode|`String`|<span class=\"optional\">선택</span>|엑셀 로딩 방식 - `HeaderMatch` : 엑셀 타이틀과 시트 헤더 타이틀을 비교하여 매칭되는 컬럼에 데이터를 로딩 (Default) - `NoHeader` : 엑셀 첫행부터 시트 데이터로 간주하여 데이터를 차례대로 시트에 로딩 - `HeaderSkip` : 엑셀 첫행부터 시트의 헤더 행 수 만큼을 헤더데이터로 간주하여 무시하고 그 다음행부터 로딩| |SkipEmptyRow|`Boolean`|<span class=\"optional\">선택</span>|엑셀의 빈 행 제거 (Default: 1)| |StartRow|`String`|<span class=\"optional\">선택</span>|엑셀 로딩 행번호 (Default: 1)| |WorkSheetNo|`String`|<span class=\"optional\">선택</span>|엑셀 WorkSheet 번호 (Default: 1)| |WorkSheetName|`String`|<span class=\"optional\">선택</span>|엑셀 WorkSheet 이름 (Default: \"\")| |ReqHeader|`Boolean`|<span class=\"optional\">선택</span>|Request Header에 사용자가 지정한 헤더 정보를 설정합니다. 이 인자를 설정하면 UseXhr을 true로 설정한 것과 동일하게 동작합니다.| |UseXhr|`Boolean`|<span class=\"optional\">선택</span>|iframe를 통한 form submit 방식으로 통신하는 기존 방식과 다르게 업로드시 통신 방식을 xhr로 설정합니다. 프레임웍의 보안처리로 인하여 iframe를 사용할 수 없을 때 이 속성을 true로 설정해주세요.| ### Returns ***none*** ### Example ```javascript // 시트 화면 페이지 var param = \"FP=/server/excelsave.jsp\"; mySheet.DirectLoadExcel({ExtendParam:param}); // excelsave.jsp 페이지 String PRINT_STR = \"\"; List keys = new ArrayList(); List li = (List)request.getAttribute(\"SHEETDATA\"); for(int i=0;i<li.size();i++){ Map mp = (Map)li.get(i); // 시트 헤더 내용 if(i == 0){ Iterator it = mp.keySet().iterator(); while(it.hasNext()){ String key = (String)it.next(); PRINT_STR += key+\"\\t\"; keys.add(key); } PRINT_STR += \"\\n\"; } // 시트 데이터 내용 for(int c=0;c<keys.size();c++){ PRINT_STR += mp.get(keys.get(c))+\"\\t\"; } PRINT_STR += \"\\n\"; PRINT_STR += li.get(i)+\"\\n\"; } //서버 콘솔에서 확인 System.out.println(PRINT_STR); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.27|MaxFileSize 속성 추가| |7.0.13.114|SkipEmptyRow 속성 추가| |7.0.13.230|ReqHeader, UseXhr 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.27|MaxFileSize 속성 추가||7.0.13.114|SkipEmptyRow 속성 추가||7.0.13.230|ReqHeader, UseXhr 속성 추가|"
            },
            "url": "docs/funcs/import/DirectLoadExcel.html"
          },
          {
            "cid": 490,
            "sid": "GetLoadExcelConfig",
            "name": "GetLoadExcelConfig",
            "label": "GetLoadExcelConfig",
            "data": {
              "body": "> LoadExcel 기본 설정 옵션을 확인 합니다. ### Syntax ```javascript ObjId.GetLoadExcelConfig(); ``` ### Info ***none*** ### Returns ***Object, LoadExcel Config*** ### Example ```javascript // LoadExcel Config를 확인 console.log(\"getLoadExcelConfig:\", mySheet.GetLoadExcelConfig()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/import/GetLoadExcelConfig.html"
          },
          {
            "cid": 491,
            "sid": "GetLoadExcelUrl",
            "name": "GetLoadExcelUrl",
            "label": "GetLoadExcelUrl",
            "data": {
              "body": "> 엑셀 업로드 기능을 처리할 서버 페이지 경로를 설정합니다. ### Syntax ```javascript ObjId.GetLoadExcelUrl(); ``` ### Info ***none*** ### Returns ***String, 엑셀 업로드 URL*** ### Example ```javascript // 엑셀 업로드 설정 경로를 확인 console.log(\"getLoadExcelUrl:\", mySheet.GetLoadExcelUrl()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/import/GetLoadExcelUrl.html"
          },
          {
            "cid": 492,
            "sid": "GetLoadTextConfig",
            "name": "GetLoadTextConfig",
            "label": "GetLoadTextConfig",
            "data": {
              "body": "> LoadText 기본 설정 옵션을 확인 합니다. ### Syntax ```javascript ObjId.GetLoadTextConfig(); ``` ### Info ***none*** ### Returns ***Object, LoadText Config*** ### Example ```javascript // LoadText Config를 확인 console.log(\"getLoadTextConfig:\", mySheet.GetLoadTextConfig()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/import/GetLoadTextConfig.html"
          },
          {
            "cid": 493,
            "sid": "GetLoadTextUrl",
            "name": "GetLoadTextUrl",
            "label": "GetLoadTextUrl",
            "data": {
              "body": "> 텍스트 업로드 기능을 처리할 서버 페이지 경로를 확인합니다. ### Syntax ```javascript ObjId.GetLoadTextUrl(); ``` ### Info ***none*** ### Returns ***String, 텍스트 업로드 URL*** ### Example ```javascript // 텍스트 업로드 설정 경로를 확인 console.log(\"getLoadTextUrl:\", mySheet.GetLoadTextUrl()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/import/GetLoadTextUrl.html"
          },
          {
            "cid": 494,
            "sid": "LoadExcel",
            "name": "LoadExcel",
            "label": "LoadExcel",
            "data": {
              "body": "> 엑셀 파일을 읽어 IBSheet에 로딩합니다. ### Syntax ```javascript ObjId.LoadExcel([Opt]); ``` ### Info |Parameter|Type|Required|Description| |-----|----|--------|-----------| |Append|`Boolean`|<span class=\"optional\">선택</span>|기존 데이터에 추가 여부 (Default: 0)| |ColumnMapping|`String`|<span class=\"optional\">선택</span>|엑셀 컬럼 번호 (Default: \"\")| |EndRow|`String`|<span class=\"optional\">선택</span>|엑셀 로딩완료 행번호 (Default: 0)| |ExtendParam|`String`|<span class=\"optional\">선택</span>|서버로 전달할 추가 파라메터들을 **a=1&b=2** 형태로 넣어줍니다. (Default: \"\")| |FileExt|`String`|<span class=\"optional\">선택</span>|업로드 가능한 파일 확장자 (Default: \"\")| |MaxFileSize|`Number`|<span class=\"optional\">선택</span>|최대 허용 파일 사이즈(단위:MB)| |Mode|`String`|<span class=\"optional\">선택</span>|로딩 방식 - `HeaderMatch` : 엑셀 타이틀과 시트 헤더 타이틀을 비교하여 매칭되는 컬럼에 데이터를 로딩 (Default) - `NoHeader` : 엑셀 첫행부터 시트 데이터로 간주하여 데이터를 차례대로 시트에 로딩 - `HeaderSkip` : 엑셀 첫행부터 시트의 헤더 행 수 만큼을 헤더데이터로 간주하여 무시하고 그 다음행부터 로딩| |SkipEmptyRow|`Boolean`|<span class=\"optional\">선택</span>|엑셀의 빈 행 제거 (Default: 1)| |StartRow|`String`|<span class=\"optional\">선택</span>|엑셀 로딩 행번호 (Default: 1)| |StartCol|`String `|<span class=\"optional\">선택</span>|엑셀 로딩 컬럼번호 (Default: 1)| |UseDOM|`Boolean`|<span class=\"optional\">선택</span>|엑셀 로딩시 DOM 기반 파싱 수행 여부 (Default: 0) `true`인 경우 엑셀 파일에 `DOM 기반 파싱`을 수행하며, `false`인 경우 엑셀 파일 파싱에 `SAX방식`을 사용합니다. LoadExcel 호출시 SAX(default)파싱 방식을 사용하여 대용량처리시 메모리를 적게 사용하고 빠른처리가 되지만 엑셀파일의 데이터 파싱중 서식부분에서 오류가 생길 수 있어서 IBSheet에 로드되는 값이 다르게 표현될 수 있습니다. 이때 `true`를 사용하여 로드를 하는 경우 데이터 값을 그대로 표현 가능하며, 2003, 2007 형식의 엑셀간의 호환성에 유리합니다.| |WorkSheetNo|`String`|<span class=\"optional\">선택</span>|엑셀WorkSheet번호 (Default: 1)| |WorkSheetName|`String`|<span class=\"optional\">선택</span>|엑셀WorkSheet이름 (Default: \"\")| |ReqHeader|`Boolean`|<span class=\"optional\">선택</span>|Request Header에 사용자가 지정한 헤더 정보를 설정합니다. 이 인자를 설정하면 UseXhr을 true로 설정한 것과 동일하게 동작합니다.| |UseXhr|`Boolean`|<span class=\"optional\">선택</span>|iframe를 통한 form submit 방식으로 통신하는 기존 방식과 다르게 업로드시 통신 방식을 xhr로 설정합니다. 프레임웍의 보안처리로 인하여 iframe를 사용할 수 없을 때 이 속성을 true로 설정해주세요.| ### Returns ***none*** ### Example ```javascript // 헤더타이틀을 서로 비교하여 동일한 컬럼끼리 로딩을 하되 7행부터 9 행까지만 읽어서 로딩 mySheet.LoadExcel({Mode:\"HeaderMatch\",StartRow:\"7\",EndRow:\"9\"}); // IBSheet의 첫번째 컬럼에 엑셀의 5번째 컬럼의 값을 로딩하고, IBSheet 의 5번째 컬럼에 엑셀의 1번째 컬럼의 값을 로딩 mySheet.LoadExcel({ColumnMapping:\"5|4|3|2|1\"}); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.27|MaxFileSize 속성 추가| |7.0.13.111|FileExt 기본값 변경| |7.0.13.114|SkipEmptyRow 속성 추가| |7.0.13.230|ReqHeader, UseXhr 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.27|MaxFileSize 속성 추가||7.0.13.111|FileExt 기본값 변경||7.0.13.114|SkipEmptyRow 속성 추가||7.0.13.230|ReqHeader, UseXhr 속성 추가|"
            },
            "url": "docs/funcs/import/LoadExcel.html"
          },
          {
            "cid": 495,
            "sid": "LoadExcelBuffer",
            "name": "LoadExcelBuffer",
            "label": "LoadExcelBuffer",
            "data": {
              "body": "> 1개의 엑셀 문서로부터 여러 개의 IBSheet에 로딩합니다. > `IsBuffer`인자를 `true`로 설정하면 이후로 실행되는 Down2Excel은 실제로 동작하지 않으며, 내부메모리에 버퍼링됩니다. > 이후에 isBuffer인자를 `false`로 설정하는 순간 파일 업로드 창이 나옵니다. ### Syntax ```javascript ObjId.LoadExcelBuffer(IsBuffer); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |IsBuffer|`Boolean`|<span class=\"required\">필수</span>|버퍼링 여부| ### Returns ***none*** ### Example ```javascript //이후로는 버퍼링한다. 아무 동작 안함. mySheet.LoadExcelBuffer(true); //엑셀 파일의 첫번째 워크시트 내용을 mySheet에 로드 한다. mySheet.LoadExcel({Mode:'HeaderMatch',StartRow:'7', WorkSheetNo:1}); // 엑셀 파일의 두번째 워크시트 내용을 mySheet2에 로드 한다. mySheet2.LoadExcel({WorkSheetNo:2}); // 버퍼링된 모든 엑셀 로딩 자료와 파일을 서버로 보내기 위해 파일 업로드창을 띄운다. mySheet.LoadExcelBuffer(false); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/import/LoadExcelBuffer.html"
          },
          {
            "cid": 496,
            "sid": "LoadText",
            "name": "LoadText",
            "label": "LoadText",
            "data": {
              "body": "> 텍스트 파일을 읽어 IBSheet에 로딩합니다. ### Syntax ```javascript ObjId.LoadText([Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Mode|`String`|<span class=\"optional\">선택</span>|로딩 방식 - `HeaderMatch` : 엑셀 타이틀과 시트 헤더 타이틀을 비교하여 매칭되는 컬럼에 데이터를 로딩 (Default) - `NoHeader` : 엑셀 첫행부터 시트 데이터로 간주하여 데이터를 차례대로 시트에 로딩 - `HeaderSkip` : 엑셀 첫행부터 시트의 헤더 행 수 만큼을 헤더데이터로 간주하여 무시하고 그 다음행부터 로딩| |ColSeparator|`String`|<span class=\"optional\">선택</span>|데이터의 컬럼 구분자 (Default: `\"\\t\"`)| |Append|`Boolean`|<span class=\"optional\">선택</span>|기존 데이터에 추가 여부 (Default: 0)| |FileExt|`String`|<span class=\"optional\">선택</span>|업로드 가능한 파일 확장자 (Default: \"\")| |MaxFileSize|`Number`|<span class=\"optional\">선택</span>|최대 허용 파일 사이즈 (단위:MB)| |Encoding|`String`|<span class=\"optional\">선택</span>|텍스트 문서의 인코딩 형식 지정 (Default: \"\")| |ReqHeader|`Boolean`|<span class=\"optional\">선택</span>|Request Header에 사용자가 지정한 헤더 정보를 설정합니다. 이 인자를 설정하면 UseXhr을 true로 설정한 것과 동일하게 동작합니다.| |UseXhr|`Boolean`|<span class=\"optional\">선택</span>|iframe를 통한 form submit 방식으로 통신하는 기존 방식과 다르게 업로드시 통신 방식을 xhr로 설정합니다. 프레임웍의 보안처리로 인하여 iframe를 사용할 수 없을 때 이 속성을 true로 설정해주세요.| ### Returns ***none*** ### Example ```javascript // 텍스트 파일로 로딩 mySheet.LoadText(); // 헤더타이틀을 서로 비교하여 동일한 컬럼끼리 로딩을 하며, 컬럼 구분자는 \"\\t\"로 구분 mySheet.LoadText({Mode:\"HeaderMatch\", ColSeparator:\"\\t\"}); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.27|MaxFileSize 속성 추가 ColSeparator 속성 추가 (Deli 속성 대체)| |7.0.13.64|Encoding 속성 추가| |7.0.13.111|FileExt 기본값 변경| |7.0.13.230|ReqHeader, UseXhr 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.27|MaxFileSize 속성 추가<br>ColSeparator 속성 추가 (Deli 속성 대체)||7.0.13.64|Encoding 속성 추가||7.0.13.111|FileExt 기본값 변경||7.0.13.230|ReqHeader, UseXhr 속성 추가|"
            },
            "url": "docs/funcs/import/LoadText.html"
          },
          {
            "cid": 497,
            "sid": "SetLoadExcelConfig",
            "name": "SetLoadExcelConfig",
            "label": "SetLoadExcelConfig",
            "data": {
              "body": "> LoadExcel 메소드의 기본 속성을 정의 합니다. > 이 메소드를 통해 정의한 속성은 [LoadExcel](/docs/funcs/import/LoadExcel) 메소드의 기본값으로 처리가 됩니다. ### Syntax ```javascript ObjId.SetLoadExcelConfig([Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Opt|`Object`|<span class=\"optional\">선택</span>|기본으로 정의할 속성 객체 ([LoadExcel](/docs/funcs/import/LoadExcel) 참고| ### Returns ***none*** ### Example ```javascript // MaxFileSize, FileExt 속성에 대한 기본값 정의 mySheet.SetLoadExcelConfig({ \"FileExt\": \"xlsx\", \"MaxFileSize\": 10 }); ``` ### Since |version|desc| |---|---| |7.0.13.27||",
              "since": "|version|desc||---|---||7.0.13.27||"
            },
            "url": "docs/funcs/import/SetLoadExcelConfig.html"
          },
          {
            "cid": 498,
            "sid": "SetLoadExcelUrl",
            "name": "SetLoadExcelUrl",
            "label": "SetLoadExcelUrl",
            "data": {
              "body": "> 엑셀 업로드 기능을 처리할 서버 페이지 경로를 설정 합니다. ### Syntax ```javascript ObjId.SetLoadExcelUrl(Url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|설정할 서버 페이지 Url| ### Returns ***none*** ### Example ```javascript // 엑셀 업로드 경로를 설정 mySheet.SetLoadExcelUrl(\"/jsp/LoadExcel.jsp\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/import/SetLoadExcelUrl.html"
          },
          {
            "cid": 499,
            "sid": "SetLoadTextConfig",
            "name": "SetLoadTextConfig",
            "label": "SetLoadTextConfig",
            "data": {
              "body": "> LoadText 메소드의 기본 속성을 정의 합니다. > 이 메소드를 통해 정의한 속성은 [LoadText](/docs/funcs/import/LoadText) 메소드의 기본값으로 처리가 됩니다. ### Syntax ```javascript ObjId.SetLoadTextConfig([Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Opt|`Object`|<span class=\"optional\">선택</span>|기본으로 정의할 속성 객체 ([LoadText](/docs/funcs/import/LoadText) 참고)| ### Returns ***none*** ### Example ```javascript // Mode 속성에 대한 기본값 정의 mySheet.SetLoadTextConfig({ \"Mode\": \"HeaderMatch\" }); ``` ### Since |version|desc| |---|---| |7.0.13.27||",
              "since": "|version|desc||---|---||7.0.13.27||"
            },
            "url": "docs/funcs/import/SetLoadTextConfig.html"
          },
          {
            "cid": 500,
            "sid": "SetLoadTextUrl",
            "name": "SetLoadTextUrl",
            "label": "SetLoadTextUrl",
            "data": {
              "body": "> 텍스트 업로드 기능을 처리할 서버 페이지 경로를 설정 합니다. ### Syntax ```javascript ObjId.SetLoadTextUrl(Url); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|설정할 서버 페이지 Url| ### Returns ***none*** ### Example ```javascript // 엑셀 업로드 경로를 설정 mySheet.SetLoadTextUrl(\"/jsp/LoadText.jsp\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/import/SetLoadTextUrl.html"
          }
        ]
      },
      {
        "gid": 9,
        "name": "funcs-init",
        "label": "init",
        "children": [
          {
            "cid": 501,
            "sid": "InitColumns",
            "name": "InitColumns",
            "label": "InitColumns",
            "data": {
              "body": "> 각 컬럼에 대한 `초기화` 및 `타입`, `포맷` 등의 속성을 설정 합니다. ### Syntax ```javascript ObjId.InitColumns({Cols}, DataRow); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Cols|`Object`|<span class=\"required\">필수</span>|각 컬럼의 기능을 `json` 형태로 설정합니다.| |DataRow|`Number`|<span class=\"optional\">선택</span>|단위데이터행 개수 (`주의 :` 단위데이터행 구조를 사용하는 경우 해당 인자의 값과 Cols 인자의 배열 길이가 동일해야 합니다.)| ### Enum * Cols |Name|Type|Required|Description| |----|----|------|-------------| |Type|`String or Array`|<span class=\"required\">필수</span>|컬럼의 데이터 타입 (아래 Cols.Type 표 참조)| |AcceptKeys|`String`|<span class=\"optional\">선택</span>|입력 허용키 설정 - `N` : 숫자만 허용 - `E` : 영문만 허용 - `N\\|E` : 숫자, 영문만 허용 - `N\\|E\\|[사용자정의문자]` : 숫자, 영문과 사용자정의문자로 설정한 문자 허용 ![s](/assets/imgs/ibsheet7_acceptKeys.png)| |ActionMenu|`Object[]`|<span class=\"optional\">선택</span>|컨텍스트 메뉴 객체 ![s](/assets/imgs/ibsheet7_actionmenu.png) - `Text` : 컨텍스트 메뉴 항목의 텍스트 문자열 - `Code` : 컨텍스트 메뉴 항목의 코드 문자열 - `Icon` : 컨텍스트 메뉴 항목의 아이콘 이미지 경로 또는 Index| |Align|`String`|<span class=\"optional\">선택</span>|데이터의 정렬 방식 `Left` : 좌측정렬, `Center` : 중앙 정렬, `Right` : 우측 정렬| |AllowNull|`Boolean`|<span class=\"optional\">선택</span>|숫자계열 컬럼에 빈값 허용 여부 설정| |ApproximateType|`Number`|<span class=\"optional\">선택</span>|근사값처리방식 (`0` : 사용안함, `1` : 반올림, `2` : 내림, 3:올림)| |AutoSum|`Boolean`|<span class=\"optional\">선택</span>|타입과 무관하게 합계행 사용 가능 여부 (SumType 속성과 함께 사용)| |BackColor|`String`|<span class=\"optional\">선택</span>|배경 색상 | |ButtonUrl|`String or Number`|<span class=\"optional\">선택</span>|팝업 버튼의 이미지 경로 또는 이미지리스트의 Index| |CalcLogic|`String or Object`|<span class=\"optional\">선택</span>|컬럼별 계산식 문자열 또는 설정 객체 ![s](/assets/imgs/ibsheet7_calcLogic.png) - `TrigeerCols` : 계산식 Function함수를 호출할 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열 - `Function` : 계산식 처리 callback 함수, 호출시 인자로 Sheet객체, Row, Col 정보를 전달| |CaseSensitive|`Boolean`|<span class=\"optional\">선택</span>|필터링시 대소구분 처리 여부 (Default: 1)| |Chart|`Object`|<span class=\"optional\">선택</span>|스파크라인 차트 타입에 대한 세부 속성 설정 - `Type` : 스파크라인 차트 타입 (Area, Line, Column, WinLoss) - `Data` : 차트를 구성할 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열 - `Color` : '#4f81bd' 양수 값(영역)에 대한 색상 - `NegativeColor` : '#4f81bd' 음수 값(영역)에 대한 색상| |CheckSaveName|`String`|<span class=\"optional\">선택</span>|트리기준컬럼의 체크박스에 대한 SaveName| |ClassName|`String`|<span class=\"optional\">선택</span>|버튼의 사용자정의 클래스 postfix 명| |ColMerge|`Number`|<span class=\"optional\">선택</span>|컬럼의 셀 병합 처리 방법 (- `0` :셀 병합 사용 안함, - `1` : 셀 병합 사용함, - `2` : 가상 셀 병합 모드 사용)| |ColSpan|`Number`|<span class=\"optional\">선택</span>|ColSpan 범위 값 (`단위데이터행` 구조에서만 사용 가능)| |ComboCode|`String`|<span class=\"optional\">선택</span>|콤보 리스트의 코드 집합(코드 항목을 \\|로 연결하며, ComboText 항목의 개수와 동일해야함)| |ComboDisabled|`String`|<span class=\"optional\">선택</span>|콤보 리스트의 선택 불가능한 item 설정(- `0` :선택 가능, - `1` : 선택 불가) ComboCode 의 개수만큼 \\|을 이용하여 설정해야함| |ComboFilter|`Number`|<span class=\"optional\">선택</span>|ComboEdit 컬럼 타입의 필터링 처리 모드 설정 (- `0` : 사용안함, - `1` : 특정부분 일치 형태, - `2` : 앞문자열 일치 형태)| |ComboText|`String`|<span class=\"optional\">선택</span>|Combo 형태의 데이터 타입의 항목 문자열을 행 구분자 `\"|\"`로 연결, 다중 컬럼 사용시 컬럼 구분자 `\\t`로 연결 ![s](/assets/imgs/ibsheet7_comboText.png)| |CopyPaste|`Boolean or String`|<span class=\"optional\">선택</span>|컬럼의 복사 기능 제어 (Default: 1(복사 허용))| |Cursor|`String`|<span class=\"optional\">선택</span>|마우스 오버 시 모양 설정 (`Default` : 기본모양, `Pointer` : 포인터모양)| |CustomDate|`Boolean`|<span class=\"optional\">선택</span>|사용자 정의 날짜 사용여부| |DefaultValue|`String`|<span class=\"optional\">선택</span>|신규입력시 기본값 설정| |DecimalAdjust|`Number`|<span class=\"optional\">선택</span>|Int 타입 조회시 소수점 처리 방식 (`1` : 반올림처리, `2` : 내림처리 (Default), `3` : 올림처리)| |Edit|`Boolean`<span class=\"optional\">선택</span>||편집가능 여부| |EditLen|`Number`|<span class=\"optional\">선택</span>|편집 시 입력 최대 허용 길이(편집 시에만 유효함)| |EditPointCount|`Number`|<span class=\"optional\">선택</span>|편집시점에서의 소수점 자리수 입력제한 개수 설정| |Ellipsis|`Boolean`|<span class=\"optional\">선택</span>|말줄임 여부 (기본값 : 0)| |EmptyToReplaceChar|`String`|<span class=\"optional\">선택</span>|데이터 타입이 `Int, Float, AutoSum` 일 때 빈 값인 경우 대체하여 보여줄 문자 설정| |EnterMode|`Boolean`|<span class=\"optional\">선택</span>|다중라인 입력모드(`MultiLineText`)에서 Enter 키 입력에 대한 개행 처리 여부 (Default :0)| |ExceptKeys|`String`|<span class=\"optional\">선택</span>|입력제외키 설정 - `N` : 숫자 입력 불가 - `E` : 영문 입력 불가 - `N\\|E` : 숫자, 영문 입력 불가 - `N\\|E\\|[사용자정의문자]` : 숫자, 영문과 사용자정의문자로 설정한 문자 입력 불가 (사용자 정의 문자열은 `대괄호`로 묶어서 설정해야하며 사용자 정의문자와 숫자, 영문 설정 문자의 합집합으로 처리 됨. AcceptKeys 와 ExceptKeys를 둘다 설정하고 설정키 내에 동일 문자가 있는 경우 해당 문자는 `입력불가 처리`된다.| |ExcludeEmpty|`Boolean`|<span class=\"optional\">선택</span>|AutoSum 컬럽타입 및 소계행의 평균 또는 건수 계산시 빈값을 포함 할지 여부 (`Default: 0`)| |FalseValue|`String`|<span class=\"optional\">선택</span>|1 이외의 CheckBox 형태 컬럼의 False 값 지정. \"F\" 으로 지정한 경우 0 대신 \"F\"를 False 값으로 사용 가능| |FitColWidth|`Boolean`|<span class=\"optional\">선택</span>|FitColWidth 메소드 호출시 비율에 의한 너비 재조정 허용 여부 (`Default: 1`)| |Focus|`Boolean`|<span class=\"optional\">선택</span>|포커스 허용 여부| |FontBold|`Boolean`|<span class=\"optional\">선택</span>|폰트 굵기 여부| |FontColor|`String`|<span class=\"optional\">선택</span>|폰트 색상| |FontUnderline|`Boolean`|<span class=\"optional\">선택</span>|폰트 언더라인 여부| |Format|`String or Array`|<span class=\"optional\">선택</span>|데이터의 Mask 적용 형태| |FormatFix|`Boolean`|<span class=\"optional\">선택</span>|`GetCellValue` 시 GetCellText 값을 반환 할지 여부 (Default: 0) `true` 로 설정시 저장할 때 Format 이 설정된 상태로 저장합니다.| |FullInput|`Boolean`|<span class=\"optional\">선택</span>|컬럼타입이 단일행 문자열인 경우 전체길이(EditLen)만큼의 입력 여부| |GroupSumType|`String`|<span class=\"optional\">선택</span>|그룹핑 처리시 부모노드의 셀에 처리할 계산 방식 설정 (Default: \"\") - `Sum` : 합계계산 - `Count` : 건수계산 - `Avg` : 평균계산| |HeaderCheck|`Boolean`|<span class=\"optional\">선택</span>|헤더에 전체 체크 표시 여부 (`Default: 1`)| |Hidden|`Boolean`|<span class=\"optional\">선택</span>|컬럼 숨김 여부| |HoverUnderline|`Boolean`|<span class=\"optional\">선택</span>|마우스오버시 언더라인 여부| |Image|`String`|<span class=\"optional\">선택</span>|이미지 표현시 Url| |ImgAlign|`String `|<span class=\"optional\">선택</span>|미지의 정렬| |ImgHeight|`Number`|<span class=\"optional\">선택</span>|이미지 높이| |ImgWidth|`Number`|<span class=\"optional\">선택</span>|이미지 너비| |InputCaseSensitive|`Number`|<span class=\"optional\">선택</span>|입력시 영문에 대한 대소구문 자동 치환 처리에 대한 설정 `0` : 별도 처리 하지 않음 (`Default`), `1` : 대문자로 치환, `2` : 소문자로 치환| |InsertEdit|`Boolean`|<span class=\"optional\">선택</span>|트랜잭션이 \"입력\"인 상태에서 데이터의 Edit 가능 여부| |ItemCode|`String`|<span class=\"optional\">선택</span>|멀티체크 아이템의 코드를 구분자 `\"|\"`로 연결한 문자열| |ItemText|`String`|<span class=\"optional\">선택</span>|멀티체크 아이템의 텍스트를 구분자 `\"|\"`로 연결한 문자열| |KeyField|`Boolean`|<span class=\"optional\">선택</span>|필수 입력 여부| |LevelSaveName|`String`|<span class=\"optional\">선택</span>|트리구조에서 트리 레벨에 대한 SaveName| |MaxCheck|`Number`|<span class=\"optional\">선택</span>|CheckBox 형태의 데이터 타입에서 2개 이상의 체크박스 표현시 최대 선택 개수 (Default : 0(제한없음))| |MaximumValue|`Number`|<span class=\"optional\">선택</span>|숫자포맷일 때 편집시 입력할 수 있는 최대값| |MenuFilter|`String`|<span class=\"optional\">선택</span>|Filter에서 사용할 옵션 (여러개 선택시 `\"|\"` 구분자로 연결) **(value / description / allow Type)** * 0 / 사용안함 / Text, Number, Date * 1 / 같음 / Text, Number, Date * 2 / 같지 않음 / Text, Number, Date * 3 / 작음 / Number, Date * 4 / 같거나 작음 / Number, Date * 5 / 큼 / Number, Date * 6 / 같거나 큼 / Number, Date * 7 / 단어로 시작함 / Text, Date * 8 / 단어로 시작하지 않음 / Text, Date * 9 / 단어로 끝남 / Text, Date * 10 / 단어로 끝나지 않음 / Text, Date * 11 / 포함함 / Text, Date * 12 / 포함하지 않음 / Text, Date| |MinimumValue|`Number`|<span class=\"optional\">선택</span>|숫자포맷일 때 편집시 입력할수 있는 최소값| |MinWidth|`Number`|<span class=\"optional\">선택</span>|컬럼 최소 가로크기| |MultiLineText|`Boolean`|<span class=\"optional\">선택</span>|데이터타입이 \"Text\"인 경우 다중라인 입력여부(`Default: 0`)| |NumberSort|`Boolean`|<span class=\"optional\">선택</span>|숫자형 Sort 처리 사용 여부| |PhoneMask|`Object`|<span class=\"optional\">선택</span>|Format이 PhoneNo 일 때 전화번호포맷에서 원하는 위치에 마스킹 설정| |PointCount|`Number`|<span class=\"optional\">선택</span>|컬럼타입이 Float 인 경우 소수점 이하의 자리수| |PopupButton|`Boolean`|<span class=\"optional\">선택</span>|팝업버튼 사용 여부| |PopupCheckEdit|`Boolean`|<span class=\"optional\">선택</span>|팝업메뉴 설정시 편집가능 여부| |PopupCode|`String`|<span class=\"optional\">선택</span>|팝업메뉴의 코드 집합| |PopupText|`String`|<span class=\"optional\">선택</span>|팝업메뉴의 문자열 집합| |RadioIcon|`Boolean`|데이터 셀내의 체크박스 계열의 이미지 모양 설정| |RowMerge|`Boolean`|대상 컬럼의 RowMerge 허용 여부 (`Default: 1`)| |RowSpan|`Number`|RowSpan 범위 값 (`단위데이터행` 구조에서만 사용 가능)| |Save|`Boolean`|저장 또는 저장관련 메소드에서 해당 컬럼의 값 포함 여부 (`Default: 1`)| |SaveName|`String`|데이터 저장 또는 조회시 사용하는 변수명| |ShowCol|`Numbe`|<span class=\"optional\">선택</span>|멀티콤보 설정 시 컬럼 값으로 출력할 컬럼 설정| |Sort|`Boolean`|<span class=\"optional\">선택</span>|헤더 클릭시 소트 가능 여부 (`Default: 1`)| |StaticPassword|`Boolean`|<span class=\"optional\">선택</span>|값이 0인 경우 데이터 길이만큼 ‘*’ 의 수를 표현| |SumType|`String`|<span class=\"optional\">선택</span>|합계 계산 방식 설정 - `Sum` : 합계 계산(Default) - `Avg` : 평균 계산 - `Count` : 건수 계산 - `Max` : 최대값 계산 - `Min` : 최소값 계산| |ToolTip|`Boolean or String`|<span class=\"optional\">선택</span>|셀의 풍선도움말 표시 여부 또는 설정할 문자열| |ToolTipText|`String`|<span class=\"optional\">선택</span>|헤더행의 풍선 도움말에 설정할 문자열| |Transaction|`Boolean`|<span class=\"optional\">선택</span>|트랜잭션 허용 여부 (`Default: 1`)| |TreeCheck|`Boolean`|<span class=\"optional\">선택</span>|트리 기준컬럼에서 체크박스 사용여부| |TreeCol|`Boolean`|<span class=\"optional\">선택</span>|트리 기준컬럼| |TrueValue|`String`|<span class=\"optional\">선택</span>|1 이외의 CheckBox 형태 컬럼의 True 값 지정. \"M\" 으로 지정한 경우 1 대신 \"M\"을 True 값으로 사용 가능.| |UpdateEdit|`Boolean`|<span class=\"optional\">선택</span>|트랜잭션이 \"조회\"인 상태에서 데이터의 Edit 가능 여부| |VAlign|`String`|<span class=\"optional\">선택</span>|컬럼 상하 정렬 값 - `Top` : 상단 정렬, - `Middle` : 중앙 정렬, - `Bottom` : 하단 정렬| |Validation|`Boolean`|<span class=\"optional\">선택</span>|ComboEdit 컬럼 유효성 검사 사용여부 설정 (Default: 0)| |Width|`Number`|<span class=\"optional\">선택</span>|컬럼의 너비| |Wrap|`Boolean`|<span class=\"optional\">선택</span>|자동 줄바꿈 여부| |ZeroToReplaceChar|`String`|<span class=\"optional\">선택</span>|Number 형태의 데이터 타입에서 값이 0일때 대체하여 표시할 문자값 설정| * Cols.Type |Type|Description| |---|------------| |**Text**|기본 문자열 데이터 타입| |**Status**|행에 대한 트랜잭션 상태를 표현하는 데이터 타입| |**DelCheck**|행에 대한 삭제여부를 설정하는 CheckBox 형태 데이터 타입| |**CheckBox**|CheckBox 데이터 타입| |**DummyCheck**|이벤트를 발생하지 않는 CheckBox 데이터 타입| |**Radio**|데이터 행 중 하나의 데이터만 선택하는 Radio 데이터 타입| |**Combo**|DropDown 리스트 데이터 타입| |**ComboEdit**|편집 및 필터링이 가능한 DropDown 리스트 데이터 타입 (`주의` 모바일은 지원하지 않습니다. 모바일은 `Combo` 타입으로 대체되어 표현됩니다.)| |**AutoSum**|합계행에 합계를 표현하는 숫자형 데이터 타입 (포맷이 “Integer”, “#,###”, “#,##0” 등의 경우에 한해 소수점 자리를 버림)| |**Image**|이미지 형태의 데이터 타입| |**Int**|정수형 숫자 데이터 타입 (값이 실수인 경우 소수점 자리를 버림)| |**Float**|실수형 숫자 데이터 타입| |**Date**|날짜 데이터 타입| |**Popup**|우측에 팝업 버튼을 갖는 읽기 전용 문자열 데이터 타입| |**Pass**|Password 데이터 타입| |**Seq**|행의 생성 순서값을 표현하는 데이터 타입| |**Html**|Html 태그형태를 표현하는 데이터 타입| |**Result**|저장 처리 결과를 표시하는 데이터 타입| |**Sparkline**|스파크라인 차트를 표현하는 데이터 타입| |**Button**|버튼 형태를 표현하는 데이터 타입| ### Returns ***none*** ### Example ```javascript // 컬럼 초기화 및 속성 설정 var cols = [ {\"Type\": \"Status\", \"Width\": 80, \"SaveName\": \"sStatus\"}, {\"Type\": \"DelCheck\", \"Width\": 60, \"SaveName\": \"sDelCheck\"}, {\"Type\": \"Text\", \"Width\": 100, \"SaveName\": \"sName\"}, {\"Type\": \"Text\", \"Width\": 100, \"SaveName\": \"sId\", \"Format\":\"##-####-###\"}, {\"Type\": \"Date\", \"Width\": 100, \"SaveName\": \"sDate\"} ]; mySheet.InitColumns(cols); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/init/InitColumns.html"
          },
          {
            "cid": 502,
            "sid": "InitHeaders",
            "name": "InitHeaders",
            "label": "InitHeaders",
            "data": {
              "body": "> 헤더에 들어갈 타이틀과 헤더기능을 설정합니다. ### Syntax ```javascript ObjId.InitHeaders(Headers, Info); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Headers|`Object`|<span class=\"required\">필수</span>|헤더의 행별 정보를 설정| |Info|`Object`|<span class=\"optional\">선택</span>|헤더의 공통 정보를 설정| |Headers.Text|`String`|<span class=\"required\">필수</span>|헤더에 표시할 Text를 `|`로 연결한 문자열| |Headers.Align|`String`|<span class=\"optional\">선택</span>|헤더 텍스트의 정렬방법 (`Left` : 좌측정렬, `Center` : 중앙정렬 (Default), `Right` : 우측정렬)| |Headers.RowMerge|`Boolean`|<span class=\"optional\">선택</span>|헤더행의 가로머지 허용 여부 (Default: 1)| |Info.Sort|`Number`|<span class=\"optional\">선택</span>|헤더 클릭을 통한 컬럼 Sort 허용 여부 (`0` : 사용안함, `1` : Sort 사용 (Default), `2` : Sort 아이콘만 표시, `3` : colSpan 설정이 아닌 헤더 셀만 Sort 사용)| |Info.ColMove|`Boolean`|<span class=\"optional\">선택</span>|헤더 컬럼 이동 가능 여부 (Default: 1)| |Info.ColResize|`Boolean`|<span class=\"optional\">선택</span>|컬럼 너비 조정 허용 여부 (Default: 1)| |Info.HeaderCheck|`Boolean`|<span class=\"optional\">선택</span>|헤더에 전체 체크 표시 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 2라인의 헤더 생성 var headers = [ {\"Text\":\"상태|삭제|직원정보|직원정보|직원정보\", \"Align\":\"Center\"}, {\"Text\":\"상태|삭제|직원명|직원번호|입사일\", \"Align\":\"Center\"}, ]; var mode = { \"Sort\": 1, \"ColResize\": 0 }; mySheet.InitHeaders(headers, mode); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.4.3|헤더행 별 RowMerge 속성 추가| |7.0.4.6|Sort 속성 개선 (아이콘만 표시하는 기능 추가)| |7.0.13.24|Sort 속성 개선 (colSpan 에 대한 예외 기능 추가)|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.4.3|헤더행 별 RowMerge 속성 추가||7.0.4.6|Sort 속성 개선 (아이콘만 표시하는 기능 추가)||7.0.13.24|Sort 속성 개선 (colSpan 에 대한 예외 기능 추가)|"
            },
            "url": "docs/funcs/init/InitHeaders.html"
          },
          {
            "cid": 503,
            "sid": "InitHeadersUnitPos",
            "name": "InitHeadersUnitPos",
            "label": "InitHeadersUnitPos",
            "data": {
              "body": "> 다중라인 레코드 형식의 시트에서 헤더에 UnitPos 정보를 삽입합니다. ### Syntax ```javascript ObjId.InitHeadersUnitPos(UnitPos); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |UnitPos|`Array<Object>`|<span class=\"required\">필수</span>|UnitPos 정보를 가지고 있는 배열 집합| ### Returns ***none*** ### Example ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/init/InitHeadersUnitPos.html"
          },
          {
            "cid": 504,
            "sid": "SetConfig",
            "name": "SetConfig",
            "label": "SetConfig",
            "data": {
              "body": "> 시트 초기화시 필요한 속성을 설정합니다. > `ibsheet.cfg` 에서의 설정보다 `우선 처리` 됩니다. > 초기화 이후 재설정이 필요한 경우에는 반드시 `Refresh` 인자를 `1(true)`로 설정하여야 설정한 속성들이 적용되며, 이 경우 해당 시트의 데이터는 모두 초기화 되므로 사용시 반드시 `조회 이전에 호출`해야 합니다. ### Syntax ```javascript ObjId.SetConfig([Cfg], Refresh); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Cfg|`Object`|<span class=\"required\">필수</span>|전달되는 인자의 형식은 `json` 타입으로 설정 하고자 하는 정보를 json 형태로 구성하여 전달합니다. (자세한 사항은 아래 표 참조)| |Refresh|`Boolean`|<span class=\"optional\">선택</span>|설정 후 갱신 처리 여부 (Default: 0)| ### Enum * **Cfg** |Name|Type|Required|Description| |----|----|-----|--------------| |Alternate|`Boolean`|<span class=\"optional\">선택</span>|`DataAlternateBackColor` 사용여부 (Default: 1)| |AutoCloseDialog|`Boolean`|<span class=\"optional\">선택</span>|콤보목록, 달력팝업, 액션메뉴 팝업의 자동닫기 여부 설정 (Default: 0) 자동닫기 설정시 `MouseOut` 시점에 자동으로 닫히게 됩니다.| |AutoFitColWidth|`String or Array`|<span class=\"optional\">선택</span>|FitColWidth에 대한 적용 시점 설정입니다. 적용하고자 하는 설정값을 구분자 `|` 로 연결하여 설정합니다. (Default : \"\") - `search` : 조회 및 로드 시점 - `resize` : 시트 Resize 시점 - `init` : 초기화 및 RemoveAll 호출시점 - `colhidden` : 컬럼 숨김/보임 시점| |AutoSumCalcMode|`Number`|<span class=\"optional\">선택</span>|별합된 셀에 대한 합계 계산 처리 방법 설정 (`0` : 모든 셀에 대한 합계 계산 (Default), `1` : 병합된 셀의 부속셀은 제외하고 계산)| |CachePageCount|`Number`|<span class=\"optional\">선택</span>|페이지 캐싱 개수| |ChildGrid|`Object`|<span class=\"optional\">선택</span>|트리구조에서 하위 그리드생성시 사용할 초기화 정보| |ChildPage|`Number`|<span class=\"optional\">선택</span>|트리구조에서 자식행의 페이지 단위 개수 (Default: 0)| |ClearFilterOff|`Boolean`|<span class=\"optional\">선택</span>|필터행 셀에 값이 있고 사용안함으로 변경했을 때, 필터행의 셀값 삭제 유무| |ClearRowBackColorUID|`Boolean`|<span class=\"optional\">선택</span>|상태값에 따라 행 색상이 변경되었을 때, 저장함수 호출 이후 행 배경색 상태| |ClickHeaderMapping|`Boolean`|<span class=\"optional\">선택</span>|셀 클릭시 매핑되는 헤더를 표시할지 여부 (0: 표시하지 않음(Default), 1: 표시)| |ClickHeaderMappingColor|`String`|<span class=\"optional\">선택</span>|셀 클릭시 매핑되는 헤더 표시 색상 (Default: “#eef0de”)| |ColPage|`Number`|<span class=\"optional\">선택</span>|한번에 표시할 컬럼의 개수 (Default: 사용안함)| |CountFormat|`Number`|<span class=\"optional\">선택</span>|건수 정보의 출력 포맷 (세부 사항은 [SetCountFormat](/docs/funcs/core/SetCountFormat) 메서드 참조)| |CountPosition|`Number`|<span class=\"optional\">선택</span>|건수 정보 출력 위치 (`0` : 사용안함 (Default), `1` : 좌측 상단, `2` : 우측 상단, `3` : 좌측 하단, `4` : 우측 하단)| |ComboMaxHeight|`Number`|<span class=\"optional\">선택</span>|콤보리스트 최대 높이 설정| |Convert2ByteChar|`Number`|<span class=\"optional\">선택</span>|전각문자 입력시 반각으로 치환하는 기능 설정| |CopyEdit|`Boolean`|<span class=\"optional\">선택</span>|값 복사 할때 포맷을 포함할지 여부 설정| |CookieInfoSave|`Boolean`|<span class=\"optional\">선택</span>|컬럼의 위치, 컬럼너비, 컬럼 정렬 등에 대한 정보를 쿠키에 저장하는 기능| |CurrentColInfo|`String`|<span class=\"optional\">선택</span>|설정하고자 하는 컬럼 정보 문자열| |DataRowHeight|`Number`|<span class=\"optional\">선택</span>|데이터 행의 기본 행 높이 (단위:px)| |DataRowMerge|`Boolean`|<span class=\"optional\">선택</span>|전체행의 가로머지 허용여부 (0: 머지 허용하지 않음 (Default), 1: 머지 허용 함)| |DeferredHScroll|`Boolean`|<span class=\"optional\">선택</span>|가로 스크롤에 대한 지연 처리 모드 사용 여부 (`0` : 사용 안함 (Default), `1` : 사용 함)| |DeferredVScroll|`Boolean`|<span class=\"optional\">선택</span>|세로 스크롤에 대한 지연 처리 모드 사용 여부 (`0` : 사용 안함 (Default), `1` : 사용 함)| |DragCell|`Boolean`|<span class=\"optional\">선택</span>|드래그시 셀 단위 드래그 여부 설정 (0: 행 단위 드래깅 (Default), 1: 셀 단위 드래깅)| |DragMode|`Number`|<span class=\"optional\">선택</span>|드래그 처리 방법 * `-1` : 드래그 사용 안함 * `0` : 일반(셀 또는 행 범위 셀렉션), Ctrl 키 이용: 행 드래깅 (Default) * `1` : 일반(행 드래깅), Ctrl 키 이용(셀 또는 행 범위 셀렉션)| |DragRowSection|`Boolean`|<span class=\"optional\">선택</span>|드래그 대상 단위 설정 (`0` : 셀 단위 (Default), `1` : 행 단위)| |EditArrowBehavior|`Number`|<span class=\"optional\">선택</span>|편집모드 상태에서 방향 키 입력에 대한 동작 방법 - `0` : 좌,우,상,하 모두 셀 이동 하지 않음 - `1` : 상,하만 셀 이동 처리 (Default) - `2` : 좌,우만 셀 이동 처리 - `3` : 좌,우,상,하 |모두 셀 이동 처리| |EditEnterBehavior|`String`|<span class=\"optional\">선택</span>|편집모드 상태에서 Enter 키 입력에 대한 동작 방법 - `tab` : 편집 완료 후 오른쪽 셀로 포커스 이동 (Default) - `down` : 편집 완료 후 아래 셀로 포커스 이동 - `newline` : 줄바꿈되어 개행 처리 됨 - `none` : 편집 완료 후 포커스 유지 - `editTab` : 편집 완료 후 다음 편집 가능한 셀로 이동| |EditTabInsert|`Boolean`|<span class=\"optional\">선택</span>|MultiLineText 셀에 Tab키 입력 활성화 여부 (`0` : 사용 안함 (Default), `1` : 사용함)| |EnhancedFloatSum|`Number`|<span class=\"optional\">선택</span>|AutoSum 타입에서의 부동 소수점 보정 사용여부 (`0` : 사용 안함 (Default), `1` : 사용함)| |ExportMode|`Number`|<span class=\"optional\">선택</span>|엑셀 다운로드시 서버모듈, 클라이언트모듈 설정 클라이언트 모듈의 경우 `ibexcel.js` 파일 필요 - `1` : 서버모듈 (Default) - `2` : 클라이언트모듈(`IE10 이상부터 지원`) - `3` : 클라이언트모듈 -> 서버모듈 (ibexcel.js가 없으면 서버모듈로 동작)| |FastRender|`Boolean`|<span class=\"optional\">선택</span>|전체 헤더 체크 할 경우 reRender 시 빠른 조회 사용 여부 (단, 화면 깜빡임이 일어남 , Default : 1)| |FilterDateType|`Boolean`|<span class=\"optional\">선택</span>|날짜 형식 필터에 달력팝업 사용여부 설정 (`0` : 달력팝업 사용안함 (Default), `1` : 달력팝업 사용)| |FilterOperator|`String`|<span class=\"optional\">선택</span>|필터링시 컬럼간 연산자 설정 (`and` : 논리 곱 연산 (Default), `or` : 논리 합 연산)| |FilterRow|`Boolean`|<span class=\"optional\">선택</span>|필터행 사용 여부 (`0` : 사용 안함 (Default), `1` : 사용함)| |FitSizeColHeaderMode|`Boolean`|<span class=\"optional\">선택</span>|컬럼에 대한 FitSize 처리시 컬럼간 셀병합이 되어있는 헤더를 포함하여 처리할지 여부 설정 (`0` : 포함하여 처리 (Default), `1` : 제외하고 처리)| |FitSizeColMode|`Boolean`|<span class=\"optional\">선택</span>|헤더의 컬럼 사이를 더블클릭시 처리되는 FitSize 처리 모드 설정 (`0` : 화면에 보여지는 행 범위 내에서 처리 (Default), `1` : 전체 행 범위에서 처리)| |FocusSumRow|`Boolean`|<span class=\"optional\">선택</span>|합계행의 셀에 대한 Focus 허용 여부 설정 (`0` : 포커스 허용 안함 (Default), `1` : 포커스 허용)| |FrozenCol|`Number`|<span class=\"optional\">선택</span>|좌측 고정컬럼의 수 (Default: 0)| |FrozenColRight|`Number`|<span class=\"optional\">선택</span>|우측 고정컬럼의 수 (Default: 0)| |GroupRow|`Boolean`|<span class=\"optional\">선택</span>|그룹행 사용 여부 (`0` : 그룹행 사용 안함 (Default), `1` : 그룹행 사용함)| |GroupSort|`Boolean`|<span class=\"optional\">선택</span>|그룹핑시 기준컬럼에 대한 Sort 처리여부 설정 (`0` : Sort 처리 없이 현재 상태로 그룹핑, `1` : Sort 처리 후 그룹핑 (Default))| |HeaderCheckMode|`Boolean`|<span class=\"optional\">선택</span>|전체체크 선택시 필터링된 행만 체크합니다 (`0` : 모든행에 대한 처리 (Default), `1` : 필터링된 행에 대한 처리)| |HeaderCheckSync|`Boolean`|<span class=\"optional\">선택</span>|헤더의 전체체크박스에 대한 자동 설정/해제 기능 (0: 사용 안함 (Default), 1: 사용함)| |HeaderMergeMode|`Boolean`|<span class=\"optional\">선택</span>|헤더의 머지 방식 서정 (0: ColMerge 속성 설정값에 상관없이 머지 처리(Default), 1: ColMerge 속성에 따라 머지 처리)| |HeaderRowHeight|`number`|<span class=\"optional\">선택</span>|헤더 행의 높이 (단위:px)| |ibEditTitle|`String`|<span class=\"optional\">선택</span>|셀의 타이틀 값 설정 (default: ”ibEdit”)| |ImageStatus|`Boolean`|<span class=\"optional\">선택</span>|상태값을 이미지로 표시할지 여부여부 (0: 입력, 수정, 삭제 Text로 표시 (Default), 1: 입력, 수정, 삭제 이미지로 표시)| |InvalidInputBehavior|`Number`|<span class=\"optional\">선택</span>|편집 완료시점에 입력값이 invalid 인 경우에 대한 처리 방법 설정 * `0` : alert 메시지 후 해당 셀 편집상태 유지 (Default) * `1` : alert 메시지 후 해당 셀 편집종료(입력값 취소 처리) * `2` : alert 메시지 후 해당 셀 편집상태 유지 (입력값 취소 처리)| |InvalidInputCallBack|`function`|<span class=\"optional\">선택</span>|편집 완료시점에 입력값이 invalid 인 경우에 콜백설정| |JustCheck|`Boolean`|<span class=\"optional\">선택</span>|체크박스 타입에서 셀 클릭이 아닌 체크박스 클릭에 대해서만 선택/취소가 가능하도록 설정 (0: 셀 클릭시 체크 (Default), 1: 체크박스 클릭시 체크)| |JustCheckSize|`Number`|<span class=\"optional\">선택</span>|JustCheck가 true인 경우 셀 내에서 체크 박스로 간주될 크기 설정| |KeyFieldPosition|`String`|<span class=\"optional\">선택</span>|필수 입력 표시 위치 설정 (Left: 왼쪽에 표기 (Default), Right: 오른쪽에 표기)| |MaxSort|`Number`|<span class=\"optional\">선택</span>|헤더클릭을 이용한 연계 소팅 최대 개수를 설정 (Default: 3)| |MergeSheet|`Number`|<span class=\"optional\">선택</span>|머지 종류 (Default: 0) [SetMergeSheet](/docs/funcs/merge/SetMergeSheet) Method 참고| |MouseHoverMode|`Number`|<span class=\"optional\">선택</span>|시트내의 행 또는 셀에 MouseOver에 대한 Hover 방식을 설정 (0: 사용 안함 (Default), 1: 셀단위 Hover, 2: 행단위 Hover)| |NewRowDeleteMode|`Boolean`|<span class=\"optional\">선택</span>|“입력” 상태인 행의 삭제 컬럼 체크시 confirm 메시지 사용 여부 설정 (0: 사용 안함 (Default), 1: 사용함)| |NextPageCall|`Number`|<span class=\"optional\">선택</span>|다음 페이지 호출 시점 백분율| |NoFocusMode|`Boolean`|<span class=\"optional\">선택</span>|포커스 행 표시 사용여부 설정 (0: 포커스 행 표시함(Default), 1: 포커스 행 표시하지 않음)| |NullLastOnAscOrder|`Number`|<span class=\"optional\">선택</span>|오름차순 기준으로 소트시 공백 문자의 위치 설정. 내림차순의 경우 반대로 정렬됩니다 (0: 맨 앞에 정렬 (Default), 1: 맨 뒤에 정렬)| |Page|`Number`|<span class=\"optional\">선택</span>|한번에 표시할 행의 개수 (Default: 20)| |PagingPosition|`Number`|<span class=\"optional\">선택</span>|페이지 내비게이션이 출력 되는 위치 설정 (0: 사용 안함 (Default), 1: 좌측, 2: 우측)| |PopupCheckEditMode|`Boolean`|<span class=\"optional\">선택</span>|컬럽팝업 메뉴를 통한 값 설정시 편집가능여부에 따른 처리 여부 (0: 편집가능여부와 무관하게 처리, 1: 편집가능한 경우에만 처리 (Default))| |PrevColumnMergeMode|`Number`|<span class=\"optional\">선택</span>|LazyLoad 방식인 경우 앞컬럼 머지 방식 설정 (0: 페이지 전체, 1: 페이지내 (Default))| |ScrollOverSheet|`Number`|<span class=\"optional\">선택</span>|시트 내의 마우스 휠을 이용한 스크롤 이벤트를 부모 element로 전달 여부 (Default: 0)| |SelectionRowsMode|`Boolean`|<span class=\"optional\">선택</span>|GetSelectionRows 시 포커스행 포함 여부 (Default: 0)| |SelectionSummary|`String`|<span class=\"optional\">선택</span>|선택영역 요약 정보 표시 설정| |SearchMode|`Number`|<span class=\"optional\">선택</span>|조회 방식 설정 - `0` : **smGeneral** – 일반 조회 모드 - `1` : **smClientPaging** – 페이징 모드 - `2` : **smLazyLoad** – Lazy Load 모드 (Default) - `3` : **smServerPaging** – 실시간 서버 처리 모드 (스크롤링 방식) - `4` : **smServerPaging2** – 실시간 서버 처리 모드 (페이지 인덱스 방식)| |SearchXMLbyColOrder|`Boolean`|<span class=\"optional\">선택</span>|XML 로딩시 데이터 로드하는 순서를 결정 (`0` : 컬럼 생성시의 순서대로 로드 (Default), `1` : 현재 보이는 컬럼의 위치를 기준으로 로드)| |SeqColMerge|`Boolean`|<span class=\"optional\">선택</span>|데이터 행 머지에 Seq 컬럼을 같이 머지할지 여부 (`0` : Seq컬럼 머지 안함 (Default), `1` : Seq 컬럼 머지 사용)| |SizeMode|`Number`|<span class=\"optional\">선택</span>|사이즈 방식 설정 - `0` : 설정된 높이값으로 처리 (Default) - `1` : 스크롤 없이 높이 자동 설정 - `2` : 스크롤 없이 너비 자동 설정 - `3` : 스크롤 없이 높이/너비 자동 설정 - `4` : 설정한 높이 이전까지 스크롤 없이 높이 자동 설정| |SmartResize|`Boolean`|<span class=\"optional\">선택</span>|OnResize를 OnSmartResize 동작처럼 변환 이 값을 `1`로 설정하면 OnSmartResize이벤트는 발생하지 않고 OnResize이벤트가 OnSmartResize 이벤트 처럼 0.3초단위로 동작합니다. `0` : 사용 안함 (Default), `1` : 사용함| |SortEventMode|`Boolean`|<span class=\"optional\">선택</span>|OnSort 이벤트 발생시 정렬된 모든 컬럼의 정보를 반환 할지 여부 (`0` : 마지막 정렬 컬럼만 반환 (Default), `1` : 정렬된 모든 컬럼 반환)| |SPage|`Number`|<span class=\"optional\">선택</span>|서버 요청 페이지 단위 행의 개수| |SumPosition|`Boolean`|<span class=\"optional\">선택</span>|합계행 위치 (`0` : 상단 고정, `1` : 하단 고정(Default))| |TabStop|`Boolean`|<span class=\"optional\">선택</span>|시트가 포함된 페이지에서 Tab키 에 의한 Tab 이동시 시트를 포함할지 여부 (`0` : Tab키를 사용하여 시트로 이동 불가능, `1` : Tab키 사용하여 시트로 이동 가능 (Default))| |TableCaption|`String`|<span class=\"optional\">선택</span>|datatable caption 태그 설정 값| |TableSummary|`String`|<span class=\"optional\">선택</span>|datatable summary 태그 설정 값| |ToolTip|`Boolean`|<span class=\"optional\">선택</span>|셀의 풍선도움말을 표시합니다 (`0` : 풍선 도움말 미표시 (Default), `1` : 풍선도움말 표시)| |ToolTipText|`String`|<span class=\"optional\">선택</span>|헤더 영역에서의 툴팁에 표시할 문자열| |TouchScrolling|`Number`|<span class=\"optional\">선택</span>|터치스크롤 방식 설정 (`0` : 사용안함 (Default), `1` : 일반 사용, `2` : 지연 이동)| |TreeDragIconMode|`Number`|<span class=\"optional\">선택</span>|트리구조에서 드래그시 드래그 위치 아이콘 표시 모드 (`0` : 이동이 가능한 위치에맞게아이콘 표시 (Default), `1` : 이동이 가능한 위치와 상관없이 아이콘 표시)| |TreeNodeIcon|`Boolean`|<span class=\"optional\">선택</span>|트리 노드 아이콘 사용 여부 (`0` : 아이콘 사용하지 않음 (Default), `1` : 아이콘 사용)| |TreeNodeToggleMode|`Number`|<span class=\"optional\">선택</span>|마우스 입력을 통한 Tree 노드 토글시 처리 방법 (`0` : 토글 후 해당 셀에 포커스이동 처리 방법 (Default), `1` : 셀의 포커스 이동 없이 토글 처리 방법)| |UpdateMergeCells|`Boolean`|<span class=\"optional\">선택</span>|머지된 데이터를 수정시 전체 머지 영역의 데이터 수정 여부 (`0` : 사용 안함 (Default), `1` : 사용함)| |UseChildGrid|`Boolean`|<span class=\"optional\">선택</span>|트리구조 사용시 ChildGrid 사용여부 (`0` : 사용 안함 (Default), `1` : 사용함)| |UseDefaultSortImage|`Boolean`|<span class=\"optional\">선택</span>|소트 기능 헤더에 기본 소트 이미지 표시 여부 (`0` : 사용 안함 (Default), `1` : 사용함)| |UseEditMask|`Boolean`|<span class=\"optional\">선택</span>|편집시 사용자포맷, 날짜에 대한 IBMaskEdit 사용 여부 (`0` : 사용 안함 (Default), `1` : 사용함)| |UseFindDialog|`Boolean`|<span class=\"optional\">선택</span>|찾기 팝업 다이얼로그 사용 여부 (`0` : 사용 안함, `1` : 사용함 (Default))| |UseGroupActionMenu|`Boolean`|<span class=\"optional\">선택</span>|그룹행에서 컨텍스트 메뉴 사용 여부 설정 ([SetGroupActionMenu](/docs/funcs/group/SetGroupActionMenu) 참조) `0` : 사용 안함 (Default), `1` : 사용함| |UseHeaderActionMenu|`Boolean`|<span class=\"optional\">선택</span>|헤더 컨텍스트 메뉴 사용 여부 설정 헤더메뉴를 사용함으로 설정하고 헤더메뉴를 설정하지 않는경우 자동으로 기본 메뉴가 출력됩니다. ([SetHeaderActionMenu](/docs/funcs/core/SetHeaderActionMenu) 참조) `0` : 사용 안함 (Default), `1` : 사용함| |UseHeaderSortCancel|`Boolean`|<span class=\"optional\">선택</span>|헤더 클릭을 통한 컬럼 Sort 처리시 취소 모드 사용 여부 - `0` : 사용 안함 (Default) - 헤더 클릭시 Asc / Desc 순으로 처리 - `1` : 사용함 - 헤더 클릭시 Asc / Desc / 취소 순으로 처리| |UseHiddenFilter|`Boolean`|<span class=\"optional\">선택</span>|필터 행 없이 필터링 사용 여부 설정 ([SetFilterValue](/docs/funcs/filter/SetFilterValue) 참조) `0` : 사용 안함 (Default), `1` : 사용함 (필터행이 보이지 않아도 `SetFilterValue`를 사용 할 수 있게 설정)| |UseJsonTreeLevel|`Boolean`|<span class=\"optional\">선택</span>|Json 형식의 데이터 구조에서 트리형식 구성시 Level 속성을 이용하여 구성할지 여부 설정 (`0` : Level 속성 사용 안함 (Default), `1` : Level 속성 사용) |UseNoDataRow|`Number`|<span class=\"optional\">선택</span>|조회된 데이터가 없는 경우, `조회된 데이터가 없습니다` 문구 표시 여부 설정 (`0` : 사용안함, `1` : 사용 (Default)) |UsePivotDialog|`Boolean`|<span class=\"optional\">선택</span>|피벗 설정 팝업 다이얼로그 사용 여부 (`0` : 사용안함, `1` : 사용 (Default)) |VscrollMode|`Number`|<span class=\"optional\">선택</span>|세로스크롤바 표시 설정 (`0` : Auto (Default), `1` : 고정) |OnePageFilter|`Number`|<span class=\"optional\">선택</span>|smServerPaging2 (SearchMode = 4) 조회 모드를 사용할 때 현재 페이지 내에서 Filter 기능을 사용할지 여부를 설정합니다. ### Returns ***none*** ### Example ```javascript // Page 50의 LazyLoad 방식 + 헤더 머지 설정 mySheet.SetConfig({ \"SearchMode\": 2, \"Page\": 50, \"MergeSheet\": 5 }); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.4.2|TabStop 속성 추가| |7.0.8.0|AutoFitColWidth, MouseHoverMode 속성 추가| |7.0.11.0|PopupCheckEditMode 속성 추가| |7.0.12.2|Refresh 인자 추가| |7.0.13.5|FitSizeColHeaderMode, FilterOperator 속성 추가| |7.0.13.6|UseHeaderActionMode 의 오름차순 정렬, 내림차순 정렬 기본 메뉴 추가| |7.0.13.10|InvalidInputBehavior 속성 추가| |7.0.13.11|DeferredHScroll, DeferredVScroll 속성 추가| |7.0.13.14|CachePageCount 속성 추가| |7.0.13.17|ImageStatus 속성 추가| |7.0.13.22|AutoSumCalcMode 속성 추가| |7.0.13.26|GroupSort 속성 추가| |7.0.13.30|CurrentColInfo 속성 추가| |7.0.13.33|UseEditMask 속성 추가| |7.0.13.34|UseFindDialog, UsePivotDialog 속성 추가| |7.0.13.48|UseHeaderSortCancel 속성 추가| |7.0.13.51|FocusSumRow 속성 추가| |7.0.13.52|TreeNodeToggleMode 속성 추가| |7.0.13.54|InvalidInputCallBack 속성 추가| |7.0.13.56|TreeNodeIcon 속성 추가| |7.0.13.59|Spage 속성 추가| |7.0.13.61|TableCaption, TableSummary 속성 추가| |7.0.13.63|ExportMode 속성 추가| |7.0.13.77|Alternate 속성 추가| |7.0.13.107|NullLastOnAscOrder 속성 추가| |7.0.13.108|Convert2ByteChar, ScrollOverSheet 속성 추가| |7.0.13.109|EnhancedFloatSum 속성 추가| |7.0.13.110|EditTabInsert, UpdateMergeCells 속성 추가| |7.0.13.111|HeadercheckSync 속성 추가| |7.0.13.112|JustCheck, JustCheckSize 속성 추가| |7.0.13.147|FastRender 속성 추가| |7.0.13.160|CopyEdit 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.4.2|TabStop 속성 추가||7.0.8.0|AutoFitColWidth, MouseHoverMode 속성 추가||7.0.11.0|PopupCheckEditMode 속성 추가||7.0.12.2|Refresh 인자 추가||7.0.13.5|FitSizeColHeaderMode, FilterOperator 속성 추가||7.0.13.6|UseHeaderActionMode 의 오름차순 정렬, 내림차순 정렬 기본 메뉴 추가||7.0.13.10|InvalidInputBehavior 속성 추가||7.0.13.11|DeferredHScroll, DeferredVScroll 속성 추가||7.0.13.14|CachePageCount 속성 추가||7.0.13.17|ImageStatus 속성 추가||7.0.13.22|AutoSumCalcMode 속성 추가||7.0.13.26|GroupSort 속성 추가||7.0.13.30|CurrentColInfo 속성 추가||7.0.13.33|UseEditMask 속성 추가||7.0.13.34|UseFindDialog, UsePivotDialog 속성 추가||7.0.13.48|UseHeaderSortCancel 속성 추가||7.0.13.51|FocusSumRow 속성 추가||7.0.13.52|TreeNodeToggleMode 속성 추가||7.0.13.54|InvalidInputCallBack 속성 추가||7.0.13.56|TreeNodeIcon 속성 추가||7.0.13.59|Spage 속성 추가||7.0.13.61|TableCaption, TableSummary 속성 추가||7.0.13.63|ExportMode 속성 추가||7.0.13.77|Alternate 속성 추가||7.0.13.107|NullLastOnAscOrder 속성 추가||7.0.13.108|Convert2ByteChar, ScrollOverSheet 속성 추가||7.0.13.109|EnhancedFloatSum 속성 추가||7.0.13.110|EditTabInsert, UpdateMergeCells 속성 추가||7.0.13.111|HeadercheckSync 속성 추가||7.0.13.112|JustCheck, JustCheckSize 속성 추가||7.0.13.147|FastRender 속성 추가||7.0.13.160|CopyEdit 속성 추가|"
            },
            "url": "docs/funcs/init/SetConfig.html"
          }
        ]
      },
      {
        "gid": 10,
        "name": "funcs-merge",
        "label": "merge",
        "children": [
          {
            "cid": 505,
            "sid": "GetDataRowMerge",
            "name": "GetDataRowMerge",
            "label": "GetDataRowMerge",
            "data": {
              "body": "> 데이터 영역의 모든 행에 대한 가로 셀 병합 허용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetDataRowMerge(); ``` ### Info ***none*** ### Returns ***Boolean, 가로 셀 병합 허용 여부*** ### Example ```javascript // 데이터 영역의 모든 행에 대한 가로 셀 병합 허용 여부 확인 console.log('dataRowMerge: ', mySheet.GetDataRowMerge()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/GetDataRowMerge.html"
          },
          {
            "cid": 506,
            "sid": "GetMergeSheet",
            "name": "GetMergeSheet",
            "label": "GetMergeSheet",
            "data": {
              "body": "> 시트의 셀 병합 방법을 확인 합니다. ### Syntax ```javascript ObjId.GetMergeSheet(); ``` ### Info ***none*** ### Returns ***Number, 셀 병합 방법*** ### Example ```javascript // 시트의 셀 병합 방법 확인 console.log('mergeMode: ', mySheet.GetMergeSheet()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/GetMergeSheet.html"
          },
          {
            "cid": 507,
            "sid": "GetMergedEndCell",
            "name": "GetMergedEndCell",
            "label": "GetMergedEndCell",
            "data": {
              "body": "> 대상 셀이 포함된 셀 병합 영역에 대한 마지막 셀의 정보를 확인합니다. > 2개행 이상의 단위데이터행 구조에서 Col 인자에 Index를 설정할 경우 첫번째 행의 해당인덱스 셀에 대해서 처리를 하고 > SaveName으로 설정할 경우 설정한 행의 단위데이터행 내 해당 SaveName 셀에 대해서 처리합니다. ### Syntax ```javascript ObjId.GetMergedEndCell(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |Col|`Long or String`|<span class=\"required\">필수</span>|대상이 되는 컬럼 또는 SaveName| ### Returns ***String 셀의 병합 마지막 셀의 행, 컬럼의 Index를 구분자 ','로 연결한 문자열*** ### Example ```javascript // (2, 3) 셀이 포함된 셀 병합 영역의 셀 병합 시작 셀 확인 console.log('endCell: ', mySheet.GetMergedEndCell(2, 3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/GetMergedEndCell.html"
          },
          {
            "cid": 508,
            "sid": "GetMergedStartCell",
            "name": "GetMergedStartCell",
            "label": "GetMergedStartCell",
            "data": {
              "body": "> 대상 셀이 포함된 셀 병합 영역에 대한 시작 셀의 정보를 확인 합니다. ### Syntax ```javascript ObjId.GetMergedStartCell(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |Col|`Long or String`|<span class=\"required\">필수</span>|대상이 되는 컬럼 또는 SaveName| ### Returns ***none*** ### Example ```javascript var startMergeCell = mySheet.GetMergedStartCell(4,5); // (2, 3) 셀이 포함된 셀 병합 영역의 셀 병합 시작 셀 확인 console.log('startCell: ', mySheet.GetMergedStartCell(2, 3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/GetMergedStartCell.html"
          },
          {
            "cid": 509,
            "sid": "SetDataMerge",
            "name": "SetDataMerge",
            "label": "SetDataMerge",
            "data": {
              "body": "> 데이터 영역에 대해서 셀 병합 처리를 합니다. ### Syntax ```javascript ObjId.SetDataMerge(force); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |force|`Boolean`|<span class=\"optional\">선택</span>|기존 병합 정보를 지울지 여부| ### Returns ***none*** ### Example ```javascript //기존 병합 정보를 유지 mySheet.SetDataMerge(0); ``` ### Since |version|desc| |---|---| |7.0.1.0||",
              "since": "|version|desc||---|---||7.0.1.0||"
            },
            "url": "docs/funcs/merge/SetDataMerge.html"
          },
          {
            "cid": 510,
            "sid": "SetDataRowMerge",
            "name": "SetDataRowMerge",
            "label": "SetDataRowMerge",
            "data": {
              "body": "> 데이터 영역의 모든 행에 대한 가로 셀 병합 허용 여부를 설정합니다. ### Syntax ```javascript ObjId.SetDataRowMerge(Merge); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Merge|`Boolean`|<span class=\"required\">필수</span>|머지 허용 여부 (Default: 0)| |Editable|`Boolean`|<span class=\"optional\">선택</span>|| ### Returns ***none*** ### Example ```javascript //모든 데이터 행의 가로머지를 허용 mySheet.SetDataRowMerge(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/SetDataRowMerge.html"
          },
          {
            "cid": 511,
            "sid": "SetMergeCell",
            "name": "SetMergeCell",
            "label": "SetMergeCell",
            "data": {
              "body": "> 대상 셀 영역에 대한 셀 병합 처리를 합니다. > [SetMergeSheet](/docs/funcs/merge/SetMergeSheet) 메소드 사용의 경우 인접한 셀의 값이 동일한 범위에 대한 자동 셀 병합 처리를 하지만 이 기능을 사용하는 경우 값의 동일성과 무관하게 지정한 셀 범위에 대한 셀 병합 처리를 하게 됩니다. > 셀 병합 처리시 대상 범위의 행에 대한 갱신 처리가 발생하기 때문에, 다량으로 처리하는 경우 성능 저하 문제가 발생할 수 있습니다. 이 경우 셀 영역 설정 범위를 배열 형식으로 설정 하거나, refresh 인자와 [RenderSheet](/docs/funcs/core/RenderSheet) 메소드를 이용하여 성능 저하 문제를 해결 할 수 있습니다. > `주의` 셀 영역에 데이터행이 아닌 행이 포함되는 경우 셀 병합은 처리되지 않습니다. ### Syntax ```javascript ObjId.SetMergeCell(Row, Col, Rows, Cols, Refresh); ObjId.SetMergeCell([[Row, Col, Rows, Cols], …], Refresh); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|강제머지할 셀의 Row Index| |Col|`Long`|<span class=\"required\">필수</span>|강제머지할 셀의 Column Index | |Rows|`Number`|<span class=\"required\">필수</span>|강제머지할 셀의 Row 개수| |Cols|`Number`|<span class=\"required\">필수</span>|강제머지할 셀의 Col 개수| |Refresh|`Number`|<span class=\"optional\">선택</span>|대상영역에 대한 갱신 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // (1,10) 부터 (2,11) 까지의 영역에 대한 셀 병합 mySheet.SetMergeCell(1, 10, 2, 2); // Index가 3, 4, 5인 컬럼에 대한 5행, 6행에 대한 각각의 셀병합 처리 (배열 인자 형식 방법) mySheet.SetMergeCell([ [5, 3, 2, 1], [5, 4, 2, 1], [5, 5, 2, 1] ]); // 다량의 셀병합에 대한 refresh 인자와 RenderSheet 메소드를 이용한 성능 개선 방법 // ---- 각각의 셀 범위 영역에 대한 메소드 호출 mySheet.SetMergeCell(1, 10, 2, 2, 0); mySheet.SetMergeCell(5, 10, 2, 2, 0); mySheet.SetMergeCell(10, 10, 2, 2, 0); ... mySheet.SetMergeCell(30, 10, 2, 2, 0); // ---- 시트 갱신 처리 mySheet.RenderSheet(2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/SetMergeCell.html"
          },
          {
            "cid": 512,
            "sid": "SetMergeSheet",
            "name": "SetMergeSheet",
            "label": "SetMergeSheet",
            "data": {
              "body": "> 시트의 셀 병합 방법을 설정 합니다. > 셀 병합은 Page 영역 내에서만 동일한 값에 대해 자동으로 셀 병합 처리 됩니다. 다만 `msPrevColumnMerge`를 사용하는 경우 [SetConfig](/docs/funcs/init/SetConfig)에서 `PrevColumnMergeMode`속성을 `0`으로 설정하면 전체 데이터를 기준으로 처리 할 수 있습니다. > `주의` 위 방식은 셀 병합 행의 개수가 많아지면 속도가 저하될 수 있습니다. ### Syntax ```javascript ObjId.SetMergeSheet(Merge); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Merge|`Integer`|<span class=\"required\">필수</span>|머지 종류 (아래 Enum 표 참조)| ### Enum * Merge |Enum|Const|Description| |----|----|------------| |0|`msNone`|사용안함| |1|`msAll`|전체영역 자동 셀 병합| |2|`msPrevColumnMerge`|이전 컬럼의 셀 병합 영역 내에서의 셀 병합| |3|`msFixedMerge`|단위 데이터행 구조에서 고정 셀 병합| |4|`msBaseColumnMerge`|기준 컬럼의 셀 병합 영역 내에서의 셀 병합| |5|`msHeaderOnly`|헤더영역 자동 셀 병합| |7|`msHeaderOnly + msPrevColumnMerge`|| |8|`msHeaderOnly + msFixedMerge`|| |9|`msHeaderOnly + msBaseColumnMerge`|| ### Returns ***none*** ### Example ```javascript // 헤더 영역만 셀병합 처리 방법 설정 mySheet.SetMergeSheet(5); mySheet.SetMergeSheet(msHeaderOnly); // 전체 영역에 대한 msHeaderOnly + msPrevColumnMerge 설정 // ---- 초기화시 PrevColumnMergeMode 속성 설정 mySheet.SetConfig({ \"SearchMode\": 2, \"Page\": 50, \"PrevColumnMergeMode\": 0 }); // ---- msHeaderOnly + msPrevColumnMerge 설정 mySheet.SetMergeSheet(7); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/SetMergeSheet.html"
          },
          {
            "cid": 513,
            "sid": "SetSplitMergeCell",
            "name": "SetSplitMergeCell",
            "label": "SetSplitMergeCell",
            "data": {
              "body": "> 대상 셀이 포함된 셀 병합 영역을 취소(분할) 처리 합니다. > 셀 병합 취소(분할) 처리시 각 셀의 값은 `병합 이전의 값` 으로 처리 됩니다. ### Syntax ```javascript ObjId.SetSplitMergeCell(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|강제머지할 셀의 Row Index| |Col|`Long`|<span class=\"required\">필수</span>|강제머지할 셀의 Column Index| ### Returns ***none*** ### Example ```javascript // (2, 3) 셀이 포함된 셀 병합 영역에 대한 병합 취소 처리 mySheet.SetSplitMergeCell(2, 3); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/merge/SetSplitMergeCell.html"
          }
        ]
      },
      {
        "gid": 11,
        "name": "funcs-pivot",
        "label": "pivot",
        "children": [
          {
            "cid": 514,
            "sid": "CreatePivotTable",
            "name": "CreatePivotTable",
            "label": "CreatePivotTable",
            "data": {
              "body": "> 피벗 테이블은 대화형 테이블의 일종으로, 데이터의 나열 형태에 따라서 `합계`나 `카운트` 등의 계산을 하는 기능이 있습니다. > 데이터가 있는 IBSheet의 값이 변경되더라도 피벗 테이블에 자동 반영되지 않으므로 원하는 시점에 이 메소드를 다시 호출 해야 합니다. ### Syntax ```javascript ObjId.CreatePivotTable([Info], DataSheet); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Info|`Object`|<span class=\"required\">필수</span>|피벗 테이블 설정 객체 집합| |Info.Rows|`String`|<span class=\"required\">필수</span>|행 레이블 필드에 설정할 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |Info.Cols|`String`|<span class=\"required\">필수</span>|열 레이블 필드에 설정할 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |Info.Value|`String`|<span class=\"required\">필수</span>|계산 대상 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |Info.ValueType|`String`|<span class=\"required\">필수</span>|계산 대상 컬럼별 계산 방법을 구분자 `|`로 연결한 문자열 (`Sum` : 합계, `Count` : 건수)| |Info.DefaultView|`String`|<span class=\"optional\">선택</span>|계산 결과 값이 없는 경우 표시할 문자열| |Info.SortRow|`Boolean`|<span class=\"optional\">선택</span>|행 레이블에 대한 Sort 처리 여부| |Info.AutoFitColWidth|`String or Array`|<span class=\"optional\">선택</span>|FitColWidth 자동 호출 위치 설정 - `init` : 초기화 및 데이터 클리어 이후 - `search` : 조회 및 엑셀 로드 이후 - `resize` : 시트 Resize 이후 - `colhidden` : 컬럼 숨김/보임 이후 - `rowtransaction` : 로우 추가/삭제/숨김/보임 이후 - `colresize` : 넓이가 변경된 컬럼을 제외한 나머지 컬럼의 FitColWidth| |Info.CalcSumRatio|`Number`|<span class=\"optional\">선택</span>|합계 비율 모드 - `0` : 기본 합계 - `1` : 총 합계 비율 - `2` : 열 합계 비율 - `3` : 행 합계 비율| |DataSheet|`Object`|<span class=\"required\">필수</span>|원본 데이터가 있는 IBSheet의 객체| ### Returns ***none*** ### Example ```javascript // Index가 5,6,7 인 컬럼을 행 레이블 필드로 설정하고, Index가 8,9,10 인 컬럼을 열 레이블의 필드로 설정하여 // Index가 13 인 컬럼에 대한 요약정보(합계)를 표시하는 피벗 테이블 구성 mySheet.CreatePivotTable({ \"Rows\": \"5|6|7\", \"Cols\": \"8|9|10\", \"Value\": \"13\", \"ValueType\": \"Sum\" }, dataSheet); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.0|AutoFitColWidth, CalcSumRatio 인자 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.0|AutoFitColWidth, CalcSumRatio 인자 속성 추가|"
            },
            "url": "docs/funcs/pivot/CreatePivotTable.html"
          },
          {
            "cid": 515,
            "sid": "GoToBaseSheet",
            "name": "GoToBaseSheet",
            "label": "GoToBaseSheet",
            "data": {
              "body": "> 피벗 설정 팝업으로부터 피벗 테이블이 화면에 표시되어 있는 경우 이 기능을 사용하면 해당 피벗 테이블의 원본 시트로 이동 합니다. > 피벗 테이블 설정 팝업의 `원본시트이동` 버튼의 기능과 동일하게 동작 합니다. ### Syntax ```javascript ObjId.GoToBaseSheet(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 원본 데이터 시트 출력 mySheet.GoToBaseSheet(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/pivot/GoToBaseSheet.html"
          },
          {
            "cid": 516,
            "sid": "ShowPivotDialog",
            "name": "ShowPivotDialog",
            "label": "ShowPivotDialog",
            "data": {
              "body": "> 사용자가 시트에서 `ctrl + alt + T` 입력시 표시되는 피벗 테이블 설정 팝업을 호출 합니다. > 피벗 설정 다이얼로그를 통해 생성된 피벗 테이블 시트는 `원본시트명 + \"_Pivot\"`으로 시트명이 설정됩니다. > Ex ) mySheet에서 생성한 피벗테이블 결과 시트 : mySheet_Pivot ### Syntax ```javascript ObjId.ShowPivotDialog(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 피벗 테이블 설정 팝업 다이얼로그 출력 mySheet.ShowPivotDialog(); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.10.0|합계 비율 선택 기능 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.10.0|합계 비율 선택 기능 추가|"
            },
            "url": "docs/funcs/pivot/ShowPivotDialog.html"
          },
          {
            "cid": 517,
            "sid": "ShowPivotSumRatio",
            "name": "ShowPivotSumRatio",
            "label": "ShowPivotSumRatio",
            "data": {
              "body": "> 피벗 테이블에 대한 합계 비율을 적용 합니다. > 이 기능은 피벗 테이블 결과가 적용된 시트에서만 사용이 가능 합니다. ### Syntax ```javascript ObjId.ShowPivotSumRatio(Mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Mode|`Number`|<span class=\"required\">필수</span>|합계 비율 모드 - `0` : 기본 합계 (Default) - `1` : 총 합계 비율 - `2` : 열 합계 비율 - `3` : 행 합계 비율| ### Returns ***none*** ### Example ```javascript // 피벗 테이블 결과 로드 시점에 총 합계 비율 설정 function mySheet_Pivot_OnSearchEnd() { mySheet_Pivot.ShowPivotSumRatio(1); } ``` ### Since |version|desc| |---|---| |7.0.13.0||",
              "since": "|version|desc||---|---||7.0.13.0||"
            },
            "url": "docs/funcs/pivot/ShowPivotSumRatio.html"
          },
          {
            "cid": 518,
            "sid": "ShowPivotTable",
            "name": "ShowPivotTable",
            "label": "ShowPivotTable",
            "data": {
              "body": "> 데이터를 기준으로 피벗 테이블을 생성 합니다. > 생성된 피벗 테이블은 피벗 설정 다이얼로그에서 수행하는것과 동일하게 처리 됩니다. > 생성된 피벗 테이블의 시트는 `원본시트의 id + \"_Pivot\"` 으로 생성 됩니다. Ex) 원본시트 : mySheet / 피벗시트 : mySheet_Pivot ### Syntax ```javascript ObjId.ShowPivotTable([opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |opt|`Object`|<span class=\"required\">필수</span>|설정 옵션| |opt.Cols|`String`|<span class=\"required\">필수</span>|열 레이블 필드에 설정할 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |opt.Rows|`String`|<span class=\"required\">필수</span>|행 레이블 필드에 설정할 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |opt.Value|`String`|<span class=\"required\">필수</span>|계산 대상 컬럼의 Index 또는SaveName을 구분자 `|`로 연결한 문자열| |opt.CalcSumRatio|`Number`|<span class=\"optional\">선택</span>|합계 비율 모드 (`0` : 기본 합계(Default), `1` : 총 합계 비율, `2` : 열 합계 비율, `3` : 행 합계 비율)| |opt.PivotFilter|`Boolean`|<span class=\"optional\">선택</span>|피벗생성시 필터된 행 제외 여부 (`0` : 필터된 행 포함(Default), `1` : 필터된 행 제외)| ### Returns ***none*** ### Example ```javascript // Index가 5,6,7 인 컬럼을 행 레이블 필드로 설정하고, Index가 8,9,10 인 컬럼을 열 레이블의 필드로 설정하여 // Index가 13 인 컬럼에 대한 합계를 표시하는 피벗 테이블 구성 mySheet.ShowPivotTable({ \"Rows\": \"5|6|7\", \"Cols\": \"8|9|10\", \"Value\": \"13\" }); ``` ### Since |version|desc| |---|---| |7.0.13.59|| |7.0.13.186|PivotFilter 추가|",
              "since": "|version|desc||---|---||7.0.13.59|||7.0.13.186|PivotFilter 추가|"
            },
            "url": "docs/funcs/pivot/ShowPivotTable.html"
          }
        ]
      },
      {
        "gid": 12,
        "name": "funcs-row",
        "label": "row",
        "children": [
          {
            "cid": 519,
            "sid": "DataCopy",
            "name": "DataCopy",
            "label": "DataCopy",
            "data": {
              "body": "> 현재 선택행의 데이터를 복사하여 바로 아래에 동일한 데이터의 행을 추가합니다. > 생성된 행의 Index를 반환하며, 선택 행이 없는 경우 -1를 반환합니다. > 트리 구조인 경우 `IncludeChild` 인자 값이 `true` 이면 자식레벨의 행을 모두 포함하여 복사 하며,부모행이 삭제 상태인 경우 InvalidChildNodeCopy 에러 메시지를 표시하고 처리를 중단합니다. > `SetFocusAfterRowTransaction` 이 `false`로 설정되어 있으면 포커스를 새로 생성된 행으로 이동하지 않습니다. ### Syntax ```javascript ObjId.DataCopy([IncludeChild]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |IncludeChild|`Boolean`|<span class=\"optional\">선택</span>|자식 레벨의 행까지 복사하는지 여부 (Default: 0)| ### Returns ***Long, 복사하여 생성된 행의 Row Index*** ### Example ```javascript // 선택행을 복사하여 바로 아래에 신규 입력 행을 생성 mySheet.DataCopy(); // 자식 레벨까지 모두 복사 mySheet.DataCopy(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/DataCopy.html"
          },
          {
            "cid": 520,
            "sid": "DataInsert",
            "name": "DataInsert",
            "label": "DataInsert",
            "data": {
              "body": "> 데이터 행을 신규 생성하고, 생성된 행의 Index를 반환합니다. > `row`인자와 `level`인자의 설정에 따라 아래의 표와 같이 처리 됩니다. ### Syntax ```javascript ObjId.DataInsert(row, level, [opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |row|`Long`|<span class=\"optional\">선택</span>|생성할 위치의 행 Index| |level|`Number`|<span class=\"optional\">선택</span>|트리 레벨| |opt|`Object`|<span class=\"optional\">선택</span>|설정 옵션| |opt.Focus|`Boolean`|<span class=\"optional\">선택</span>|생성된 행으로 포커스 이동할지 여부 (Default: 1)| |opt.CellEvent|`Boolean`|<span class=\"optional\">선택</span>|[OnSelectCell](/docs/event/OnSelectCell) Event 발생 여부| ### Enum * row |Name|Description| |----|---------------| |`설정이 없는 경우`|선택된 행 아래 생성| |`row < 0`|마지막 행에 생성| |`row >= 전체 행`|마지막 행에 생성| |`row < 데이터 첫 행`|첫 행에 생성| |`그 외의 경우`|설정값 위치에 생성| ### Returns ***Number, 생성된 행의 Index*** ### Example ```javascript // 첫 행에 생성 mySheet.DataInsert(0); // 마지막 행에 생성 mySheet.DataInsert(-1); // 현재 선택된 행의 바로 아래에 생성 mySheet.DataInsert(); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.112|opt.Focus 인자 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.112|opt.Focus 인자 추가|"
            },
            "url": "docs/funcs/row/DataInsert.html"
          },
          {
            "cid": 521,
            "sid": "DataMove",
            "name": "DataMove",
            "label": "DataMove",
            "data": {
              "body": "> 특정 데이터 행을 데이터 영역의 다른 위치로 이동 합니다. > 트리구조인 경우 자식레벨의 행을 모두 포함하여 이동 합니다. > `FromRow`인자의 값을 설정하지 않거나 -1로 설정하는 경우 현재 선택되어 있는 행에 대해서 처리 합니다. > `FromRow`, `ToRow` 의 인자값이 올바르지 않은 경우 별도 처리 없이 -1을 반환 합니다. > `RowLevel` 의 인자를 설정한 경우 이동 처리시 동일 레벨상에서의 ToRow 설정과 가장 가까운 위치로 처리합니다. > `FromRow`, `ToRow`의 인자값은 기능 수행전의 상태에서의 행의 Index를 의미합니다. 따라서 설정한 ToRow 인자 값과 처리 후 반환 되는 값이 다를 수 있습니다. ### Syntax ```javascript ObjId.DataMove(ToRow, FromRow, RowLevel); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |ToRow|`Number`|<span class=\"required\">필수</span>|이동할 위치의 행 Index| |FromRow|`Long`|<span class=\"optional\">선택</span>|선택된 데이터의 Row Index (Default: -1)| |RowLevel|`Integer`|<span class=\"optional\">선택</span>|이동 후 선택된 데이터의 트리 레벨 (Default: \"원래 레벨 수준\")| ### Returns ***Long, 이동된 행의 Top Row Index*** ### Example ```javascript // 12행을 10행으로 이동한다. mySheet.DataMove(10, 12); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/DataMove.html"
          },
          {
            "cid": 522,
            "sid": "FindCheckedRow",
            "name": "FindCheckedRow",
            "label": "FindCheckedRow",
            "data": {
              "body": "> 대상 컬럼을 기준으로 체크된 행번호를 구분자 `|`로 연결하여 반환합니다. > `opt.RowLevel`, `opt.ParentRow`, `opt.Recursive` 인자는 트리구조의 시트에서 트리 기준 컬럼에 대한 체크박스 사용 모드에서만 유효한 인자 속성입니다. > `opt.RowLevel`, `opt.ParentRow` 속성은 동시에 같이 사용할 수 없으며, 두 속성 모두 설정이 있는 경우 `opt.ParentRow` 속성을 우선 처리합니다. ### Syntax ```javascript ObjId.FindCheckedRow(Col, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|특정 컬럼의 Index 또는 SaveName| |Opt|`Object`|<span class=\"optional\">선택</span>|설정 옵션 객체| |Opt.RowLevel|`Number`|<span class=\"optional\">선택</span>|처리 대상 트리 레벨 (Default: 0)| |Opt.ParentRow|`Index`|<span class=\"optional\">선택</span>|처리 대상 부모 행의 Index| |Opt.Recursive|`Boolean`|<span class=\"optional\">선택</span>|하위 노드에 대한 재귀 처리 여부 (Default: 1)| |Opt.ReturnArray|`Boolean`|<span class=\"optional\">선택</span>|배열집합 반환 여부 (Default: 0)| ### Returns ***String or Array, 체크된 행번호를 `|`로 연결한 문자열 또는 배열*** ### Example ```javascript // 1컬럼의 체크된 행 번호를 확인 console.log(\"findCheckedRow:\", mySheet.FindCheckedRow(1)); // 트리 기준 컬럼의 체크박스에 대한 사용, 트리 레벨이 2행인 가운데 체크된 목록을 확인 console.log(\"findCheckedRow:\", mySheet.FindCheckedRow(1, {RowLevel:2, Recursive:0})); // 5행의 자식행 가운데 체크된 목록을 배열집합으로 확인 var arRes = mySheet.FindCheckedRow(1,{ ParentRow:5, Recursive:1, ReturnArray:1 }); console.log(\"findCheckedRow:\", arRes); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/FindCheckedRow.html"
          },
          {
            "cid": 523,
            "sid": "FindStatusRow",
            "name": "FindStatusRow",
            "label": "FindStatusRow",
            "data": {
              "body": "> 트랜잭션 상태에 해당하는 행번호를 `;` 로 조합하여 반환합니다. > 트랜잭션 상태는 RIUD의 문자열을 `|`로 연결하여 설정하면 트랜잭션인 행의 번호를 모두 반환합니다. ### Syntax ```javascript ObjId.FindStatusRow(sStatus); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |sStatus|`String`|<span class=\"required\">필수</span>|찾고자 하는 트랜잭션 상태 코드를 `|`로 연결한 문자열| ### Returns ***String, 트랜잭션 상태에 해당하는 행번호를 \";\"로 조합한 문자열 (Default: \"\")*** ### Example ```javascript // 수정 상태인 행을 확인 console.log(\"findStatusRow:\", mySheet.FindStatusRow(\"U|D\")); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/FindStatusRow.html"
          },
          {
            "cid": 524,
            "sid": "FindText",
            "name": "FindText",
            "label": "FindText",
            "data": {
              "body": "> 컬럼내에 특정 텍스트를 찾아서 행번호를 확인 합니다. > `StartRow` 인자가 행의 인덱스 범위를 벗어나는 경우 `-1`을 반환 합니다. ### Syntax ```javascript ObjId.FindText(Col, SearchText, StartRow, FullMatch, CaseSensitive, ExcludeHiddenText, ExcludeCode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Col|`Long or String`|<span class=\"required\">필수</span>|찾고자 하는 컬럼의 Index 또는 SaveName| |SearchText|`String`|<span class=\"required\">필수</span>|찾을 문자열| |StartRow|`Number`|<span class=\"optional\">선택</span>|시작 행의 Index (Default: \"첫행\")| |FullMatch|`Number`|<span class=\"optional\">선택</span>|글자 동일 종류 * `-1` : 전체 동일한 값 (Default) * `0` : 앞 부분이 같은 값 * `1` : 뒷 부분이 같은 값 * `2` : 일부가 같은 값| |CaseSensitive|`Boolean`|<span class=\"optional\">선택</span>|대소문자 구분 여부 (Default: 1)| |ExcludeHiddenText|`Boolean`|<span class=\"optional\">선택</span>|숨김처리된 데이터 제외 여부 (Default: 0)| |ExcludeCode|`Boolean`|<span class=\"optional\">선택</span>|ComboCode 사용시 Code 검색 포함 여부| ### Returns ***Long, 찾아진 행번호 (Default: -1)*** ### Example ```javascript // 2컬럼내에 \"한국\"으로 시작하는 데이터의 행 번호를 확인 console.log(\"findText:\", mySheet.FindText(2, \"한국\", 0, 0, 0)); // 2컬럼내에 전체 글자가 \"한국\"인 데이터의 행 번호를 확인 console.log(\"findText:\", mySheet.FindText(2, \"한국\", 0)); // 글자 중에 \"은\" 이라는 글자가 들어가는 행 번호를 확인 console.log(\"findText:\", mySheet.FindText(2, \"은\", 0, 2)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/FindText.html"
          },
          {
            "cid": 525,
            "sid": "GetDataFirstRow",
            "name": "GetDataFirstRow",
            "label": "GetDataFirstRow",
            "data": {
              "body": "> 데이터 행의 시작 인덱스를 확인합니다. > 헤더, 필터, 합계행은 인덱스에서 제외되며, 데이터행이 존재하지 않는 경우 `-1` 을 반환합니다. ### Syntax ```javascript ObjId.GetDataFirstRow(); ``` ### Info ***none*** ### Returns ***Number, 데이터행의 시작 인덱스 (Default: -1)*** ### Example ```javascript // 시트 시작 인덱스를 확인 console.log(\"getDataFirstRow:\", mySheet.GetDataFirstRow()); ``` ### Since |version|desc| |---|---| |7.0.13.37||",
              "since": "|version|desc||---|---||7.0.13.37||"
            },
            "url": "docs/funcs/row/GetDataFirstRow.html"
          },
          {
            "cid": 526,
            "sid": "GetDataLastRow",
            "name": "GetDataLastRow",
            "label": "GetDataLastRow",
            "data": {
              "body": "> 데이터 행의 마지막 인덱스를 확인한다. > 헤더, 필터, 합계행은 인덱스에서 제외되며, 데이터행이 존재하지 않는 경우 `-1` 을 반환합니다. ### Syntax ```javascript ObjId.GetDataLastRow(); ``` ### Info ***none*** ### Returns ***Number, 데이터행의 마지막 인덱스 (Default: -1)*** ### Example ```javascript // 시트 마지막 인덱스를 확인 console.log(\"getDataLastRow:\", mySheet.GetDataLastRow()); ``` ### Since |version|desc| |---|---| |7.0.13.37||",
              "since": "|version|desc||---|---||7.0.13.37||"
            },
            "url": "docs/funcs/row/GetDataLastRow.html"
          },
          {
            "cid": 527,
            "sid": "GetFocusAfterRowTransaction",
            "name": "GetFocusAfterRowTransaction",
            "label": "GetFocusAfterRowTransaction",
            "data": {
              "body": "> 행 추가 / 삭제 / 이동 / 복사 후 포커스 처리 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetFocusAfterRowTransaction(); ``` ### Info ***none*** ### Returns ***Boolean, 설정 값*** ### Example ```javascript // 포커스를 이동 할지 여부를 확인 console.log(\"getFocusAfterRowTransaction:\", mySheet.GetFocusAfterRowTransaction()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetFocusAfterRowTransaction.html"
          },
          {
            "cid": 528,
            "sid": "GetFrozenRows",
            "name": "GetFrozenRows",
            "label": "GetFrozenRows",
            "data": {
              "body": "> 고정행 설정을 확인 합니다. > 상단에 설정한 개수의 행을 고정행으로 출력합니다. > 조회 전 호출 시 데이터 조회 완료 시점에 해당 개수만큼 조회된 데이터를 고정행으로 출력합니다. ### Syntax ```javascript ObjId.GetFrozenRows(); ``` ### Info ***none*** ### Returns ***Integer, 설정 값*** ### Example ```javascript // 고정행 설정을 확인 console.log(\"getFrozenRows:\", mySheet.GetFrozenRows()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetFrozenRows.html"
          },
          {
            "cid": 529,
            "sid": "GetRowBackColor",
            "name": "GetRowBackColor",
            "label": "GetRowBackColor",
            "data": {
              "body": "> 대상 행의 배경색을 확인 합니다. > 설정이 없는 경우에는 `css에 설정된 기본값`으로 반환 합니다. ### Syntax ```javascript ObjId.GetRowBackColor(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***String, 배경 색상*** ### Example ```javascript // Index가 3인 행의 배경색을 확인 console.log(\"backColor:\", mySheet.GetRowBackColor(3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowBackColor.html"
          },
          {
            "cid": 530,
            "sid": "GetRowBackColorD",
            "name": "GetRowBackColorD",
            "label": "GetRowBackColorD",
            "data": {
              "body": "> 각행의 트렌젝션 상태가 삭제인 행의 배경색을 확인 합니다. ### Syntax ```javascript ObjId.GetRowBackColorD(); ``` ### Info ***none*** ### Returns ***String, 설정색상*** ### Example ```javascript // 트렌젝션상태가 삭제인 행의 배경색을 확인 console.log(\"rowBackColorD:\", mySheet.GetRowBackColorD()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowBackColorD.html"
          },
          {
            "cid": 531,
            "sid": "GetRowBackColorI",
            "name": "GetRowBackColorI",
            "label": "GetRowBackColorI",
            "data": {
              "body": "> 각행의 트렌젝션 상태가 입력인 행의 배경색을 확인 합니다. ### Syntax ```javascript ObjId.GetRowBackColorI(); ``` ### Info ***none*** ### Returns ***String, 설정 색상*** ### Example ```javascript // 트렌젝션상태가 신규인 행의 배경색을 확인 console.log(\"rowBackColorI:\", mySheet.GetRowBackColorI()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowBackColorI.html"
          },
          {
            "cid": 532,
            "sid": "GetRowBackColorU",
            "name": "GetRowBackColorU",
            "label": "GetRowBackColorU",
            "data": {
              "body": "> 각행의 트렌젝션 상태가 수정인 행의 배경색을 확인 합니다. ### Syntax ```javascript ObjId.GetRowBackColorU(); ``` ### Info ***none*** ### Returns ***String, 설정색상*** ### Example ```javascript // 트렌젝션상태가 수정인 행의 배경색을 확인 console.log(\"rowBackColorU:\", mySheet.GetRowBackColorU()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowBackColorU.html"
          },
          {
            "cid": 533,
            "sid": "GetRowData",
            "name": "GetRowData",
            "label": "GetRowData",
            "data": {
              "body": "> 행의 데이터를 Json 객체로 생성하여 반환 합니다. > 2개행 이상의 단위데이터행 구조인 경우 단위데이터행 전체를 반환 합니다. ### Syntax ```javascript ObjId.GetRowData(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***Object, 해당 행의 데이터 객체*** ### Example ```javascript // 1행의 Json 객체를 확인 console.log(\"getRowData:\", mySheet.GetRowData(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowData.html"
          },
          {
            "cid": 534,
            "sid": "GetRowDraggable",
            "name": "GetRowDraggable",
            "label": "GetRowDraggable",
            "data": {
              "body": "> 행의 마우스 드래그 가능 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetRowDraggable(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***Boolean, 설정된 값*** ### Example ```javascript // 3행의 마우스 드래그 가능 여부를 확인 console.log(\"getRowDraggable:\", mySheet.GetRowDraggable(3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowDraggable.html"
          },
          {
            "cid": 535,
            "sid": "GetRowEditable",
            "name": "GetRowEditable",
            "label": "GetRowEditable",
            "data": {
              "body": "> 행의 Edit 가능 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetRowEditable(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***Boolean, Edit 가능 여부*** ### Example ```javascript // 1행의 Edit 가능 여부를 확인 console.log(\"editable:\", mySheet.GetRowEditable(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowEditable.html"
          },
          {
            "cid": 536,
            "sid": "GetRowFontColor",
            "name": "GetRowFontColor",
            "label": "GetRowFontColor",
            "data": {
              "body": "> 행 전체의 글자색을 확인 합니다. ### Syntax ```javascript ObjId.GetRowFontColor(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***String, 설정 색상*** ### Example ```javascript // 3행의 글자색을 확인 console.log(\"rowFontColor:\", mySheet.GetRowFontColor(3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowFontColor.html"
          },
          {
            "cid": 537,
            "sid": "GetRowHeight",
            "name": "GetRowHeight",
            "label": "GetRowHeight",
            "data": {
              "body": "> 대상 행의 높이를 확인 합니다. ### Syntax ```javascript ObjId.GetRowHeight(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***Number, 행의 높이 (단위:px)*** ### Example ```javascript // Index가 3인 행의 높이 확인 console.log(\"rowHeight:\", mySheet.GetRowHeight(3)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowHeight.html"
          },
          {
            "cid": 538,
            "sid": "GetRowHeightMax",
            "name": "GetRowHeightMax",
            "label": "GetRowHeightMax",
            "data": {
              "body": "> 행의 최대 높이 값을 확인 합니다. ### Syntax ```javascript ObjId.GetRowHeightMax(); ``` ### Info ***none*** ### Returns ***Integer, 행의 최대 높이*** ### Example ```javascript // 설정한 최대 높이값을 확인 console.log(\"getRowHeightMax:\", mySheet.GetRowHeightMax()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowHeightMax.html"
          },
          {
            "cid": 539,
            "sid": "GetRowHeightMin",
            "name": "GetRowHeightMin",
            "label": "GetRowHeightMin",
            "data": {
              "body": "> 모든 행의 최소 높이를 확인 합니다. ### Syntax ```javascript ObjId.GetRowHeightMin(); ``` ### Info ***none*** ### Returns ***Integer, 행의 최소 높이*** ### Example ```javascript // 행의 최소 높이를 확인 console.log(\"rowHeithtMin:\", mySheet.GetRowHeightMin()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowHeightMin.html"
          },
          {
            "cid": 540,
            "sid": "GetRowHidden",
            "name": "GetRowHidden",
            "label": "GetRowHidden",
            "data": {
              "body": "> 대상 행의 숨김 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetRowHidden(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long or String`|<span class=\"required\">필수</span>|특정 행의 Row Index 혹은 구분자 `|`로 연결된 문자열| ### Returns ***Boolean, 설정 값*** ### Example ```javascript // 1행의 숨김 여부를 확인 console.log(\"rowhidden:\", mySheet.GetRowHidden(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetRowHidden.html"
          },
          {
            "cid": 541,
            "sid": "GetTopRow",
            "name": "GetTopRow",
            "label": "GetTopRow",
            "data": {
              "body": "> 최상단의 행 번호를 확인 합니다. ### Syntax ```javascript ObjId.GetTopRow(); ``` ### Info ***none*** ### Returns ***Long, 최상단의 행 번호*** ### Example ```javascript // 최상단의 행 번호를 확인 console.log(\"topRow:\", mySheet.GetTopRow()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/GetTopRow.html"
          },
          {
            "cid": 542,
            "sid": "LastRow",
            "name": "LastRow",
            "label": "LastRow",
            "data": {
              "body": "> 시트의 마지막 행 인덱스를 확인 합니다. > 헤더행만 있는 경우 `마지막 헤더행의 인덱스` 를 반환 합니다. > 필터행을 출력하는 경우 `필터행을 포함한 인덱스` 를 반환 합니다. > 마지막 행은 합계 행일 수도 있고, 데이터 행일 수도 있고, 헤더 행일 수도 있습니다. ### Syntax ```javascript ObjId.LastRow(Mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Mode|`Number`|<span class=\"optional\">선택</span>|현재 화면상 Index 반환 여부 (`0` : 마지막행 index (Default), `1` : 현재 화면상의 마지막행 index)| ### Returns ***Long, 마지막행의 Index*** ### Example ```javascript // 마지막 행의 Index를 확인 console.log(\"lastRow:\", mySheet.LastRow()); // 현재 화면에 보여지는 마지막 행의 Index를 확인 console.log(\"lastRow:\", mySheet.LastRow(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/LastRow.html"
          },
          {
            "cid": 543,
            "sid": "MouseRow",
            "name": "MouseRow",
            "label": "MouseRow",
            "data": {
              "body": "> 마우스 포인터가 있는 셀의 행 Index를 확인 합니다. > 시트의 헤더, 데이터 영역이 아닌 경우(`CountRow`, `FillRow`, 시트의 스크롤) 에 `-1` 을 반환 합니다. ### Syntax ```javascript ObjId.MouseRow(); ``` ### Info ***none*** ### Returns ***Long, 마우스 포인터가 있는 셀의 행 Index*** ### Example ```javascript // 마우스가 눌러졌을 때 행 번호를 확인 function mySheet_OnMouseDown(Button, Shift, X, Y){ console.log(\"mouseRow:\", mySheet.MouseRow()); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/MouseRow.html"
          },
          {
            "cid": 544,
            "sid": "RemoveFooterRow",
            "name": "RemoveFooterRow",
            "label": "RemoveFooterRow",
            "data": {
              "body": "> 하단 고정행을 삭제합니다. ### Syntax ```javascript ObjId.RemoveFooterRow(); ``` ### Info ***none*** ### Returns ***none*** ### Example ```javascript // 생성된 하단 고정행을 삭제 mySheet.RemoveFooterRow(); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/RemoveFooterRow.html"
          },
          {
            "cid": 545,
            "sid": "ReturnData",
            "name": "ReturnData",
            "label": "ReturnData",
            "data": {
              "body": "> 특정 행의 데이터를 조회 상태의 문자열로 변경합니다. > - 조회된 데이터로 되돌리지 못하는 경우 > 1. `조회된 데이터가 아닌 경우` (ex - 입력 상태의 데이터) > 2. `상태컬럼이 존재하지 않는 경우` ### Syntax ```javascript ObjId.ReturnData(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***none*** ### Example ```javascript // 2행의 데이터를 초기 상태로 변경 mySheet.ReturnData(2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/ReturnData.html"
          },
          {
            "cid": 546,
            "sid": "RowDelete",
            "name": "RowDelete",
            "label": "RowDelete",
            "data": {
              "body": "> 특정의 단일 또는 다중 데이터 행을 삭제 합니다. > row인자를 설정하지 않은 경우 현재 focus 위치의 행을 삭제 합니다. ### Syntax ```javascript ObjId.RowDelete(Row, Confirm, event); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long or String`|<span class=\"optional\">선택</span>|삭제할 행의 Index 또는 행의 Index를 `|` 구분자로 연결한 문자열 (Default: \"현재 선택 행\")| |Confirm|`Boolean`|<span class=\"optional\">선택</span>|삭제 전 메세지 표시 여부 (Default: 0)| |event|`Boolean`|<span class=\"optional\">선택</span>|`OnRowDelete` Event 발생 여부 (Default: 0)| ### Returns ***none*** ### Example ```javascript // 확인 메시지 없이 1행 삭제 mySheet.RowDelete(1, 0); // 3, 7, 10번 행 삭제 mySheet.RowDelete(\"3|7|10\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/RowDelete.html"
          },
          {
            "cid": 547,
            "sid": "RowTop",
            "name": "RowTop",
            "label": "RowTop",
            "data": {
              "body": "> 특정 행의 상단 시작위치의 offsetTop 값을 확인 합니다. > 시트 table 의 최상단 위치를 기준점 (Default: 0)으로 하여 처리 합니다. > `row` 인자 설정이 잘못된 경우 별도 처리 없이 `-1`을 반환 합니다. ### Syntax ```javascript ObjId.RowTop(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***Long, 행의 상단 위치*** ### Example ```javascript // 1행의 상단 위치를 확인 console.log(\"rowTop:\", mySheet.RowTop(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/RowTop.html"
          },
          {
            "cid": 548,
            "sid": "SetFocusAfterRowTransaction",
            "name": "SetFocusAfterRowTransaction",
            "label": "SetFocusAfterRowTransaction",
            "data": {
              "body": "> 행 추가 / 삭제 / 이동 / 복사 후 포커스 처리 여부를 설정 합니다. > 2개 이상의 행에 대한 연속 처리시 불필요한 포커스 처리를 막을 수 있어서 처리 속도를 개선 할 수 있습니다. ### Syntax ```javascript ObjId.SetFocusAfterRowTransaction(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`Long`|<span class=\"required\">필수</span>|포커스 설정 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 현재 포커스 행 하위로 10개행을 추가 후 맨마지막 추가된 행에 포커스 설정 mySheet.SetFocusAfterRowTransaction(0); var newRow = null; for (var i = 0; i < 10; i++) { newRow = mySheet.DataInsert(); } mySheet.SetSelectRow(newRow); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetFocusAfterRowTransaction.html"
          },
          {
            "cid": 549,
            "sid": "SetFrozenRows",
            "name": "SetFrozenRows",
            "label": "SetFrozenRows",
            "data": {
              "body": "> 고정행을 설정 합니다. > 고정행에 합계행, 필터행은 포함되지 않으며 고정행 생성 시 합계행, 필터행이 있는 경우 합계행, 필터행의 아래에 생성됩니다. > `제약사항` > - 고정행은 마우스를 이용한 행 선택 및 마우스 드래그를 통한 행 이동을 지원하지 않습니다. > - `서버페이지 조회 방식`, `단위데이터행`, `데이터 머지`, `트리` 시트 및 `소계`를 사용하는 경우에도 해당 기능이 지원되지 않습니다. > - 메인 섹션의 행을 모두 고정행으로 설정하는 경우, 시트에서 보여지는 영역내에서 설정한 고정행을 모두 표현할 수 없는 경우 시트가 정상적으로 동작하지 않을 수 있습니다. ### Syntax ```javascript ObjId.SetFrozenRows(Rows); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|설정할 고정행 개수 (Default: 0)| ### Returns ***none*** ### Example ```javascript // 3개의 고정행을 설정 mySheet.SetFrozenRows(3); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetFrozenRows.html"
          },
          {
            "cid": 550,
            "sid": "SetRowBackColor",
            "name": "SetRowBackColor",
            "label": "SetRowBackColor",
            "data": {
              "body": "> 행 전체의 배경색을 설정 합니다. > 색성 설정은 WebColor 값을 이용하여 설정하며, 데이터 영역의 배경색만 처리합니다. > 행이 존재하지 않을 경우 별도처리 없이 `-1` 을 반환 합니다. ### Syntax ```javascript ObjId.SetRowBackColor(Row, BackColor); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| |BackColor|`String`|<span class=\"required\">필수</span>|WebColor 색상 값| ### Returns ***none*** ### Example ```javascript // 1행의 배경색을 회색으로 설정 mySheet.SetRowBackColor(1, \"#C0C0C0\"); // 3행의 배경색을 빨강색으로 설정 mySheet.SetRowBackColor(3, \"#FF0000\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowBackColor.html"
          },
          {
            "cid": 551,
            "sid": "SetRowBackColorD",
            "name": "SetRowBackColorD",
            "label": "SetRowBackColorD",
            "data": {
              "body": "> 각행의 트렌젝션 상태가 삭제인 행의 배경색을 설정합니다. ### Syntax ```javascript ObjId.SetRowBackColorD(BackColor) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |BackColor|`String`|<span class=\"optional\">선택</span>|WebColor 값| ### Returns ***none*** ### Example ```javascript // 트렌젝션상태가 삭제인 행의 배경색을 회색으로 설정 mySheet.SetRowBackColorD(\"#C0C0C0\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowBackColorD.html"
          },
          {
            "cid": 552,
            "sid": "SetRowBackColorI",
            "name": "SetRowBackColorI",
            "label": "SetRowBackColorI",
            "data": {
              "body": "> 각행의 트렌젝션 상태가 신규인 행의 배경색을 설정합니다. ### Syntax ```javascript ObjId.SetRowBackColorI(BackColor) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |BackColor|`String`|<span class=\"optional\">선택</span>|WebColor 값| ### Returns ***none*** ### Example ```javascript // 트렌젝션상태가 신규인 행의 배경색을 회색으로 설정 mySheet.SetRowBackColorI(\"#C0C0C0\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowBackColorI.html"
          },
          {
            "cid": 553,
            "sid": "SetRowBackColorU",
            "name": "SetRowBackColorU",
            "label": "SetRowBackColorU",
            "data": {
              "body": "> 각행의 트렌젝션 상태가 수정인 행의 배경색을 설정합니다. ### Syntax ```javascript ObjId.SetRowBackColorU(BackColor) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |BackColor|`String`|<span class=\"optional\">선택</span>|WebColor 값| ### Returns ***none*** ### Example ```javascript // 트렌젝션 상태가 수정인 행의 배경색을 회색으로 설정 mySheet.SetRowBackColorU(\"#C0C0C0\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowBackColorU.html"
          },
          {
            "cid": 554,
            "sid": "SetRowData",
            "name": "SetRowData",
            "label": "SetRowData",
            "data": {
              "body": "> 행 단위별 데이터를 설정 합니다. > 2개행 이상의 단위데이터행 구조인 경우 단위데이터행 전체를 설정 합니다. ### Syntax ```javascript ObjId.SetRowData(Row, Data, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 또는 추가할 위치의 Row Index| |Data|`Object or String`|<span class=\"required\">필수</span>|Json 형태의 행 데이터 객체 또는 문자열| |Opt|`Object`|<span class=\"optional\">선택</span>|설정 옵션 객체| |Data|`Object or String`|<span class=\"required\">필수</span>|Json 형태의 행 데이터 객체 또는 문자열| |Opt.Add|`Boolean`|<span class=\"optional\">선택</span>|행 추가 여부 (Default: 0)| |Opt.Level|`Number`|<span class=\"optional\">선택</span>|트리구조에서 행 추가인 경우 추가될 행의 트리 레벨 값| |Opt.Event|`Boolean`|<span class=\"optional\">선택</span>|셀값 변경시 OnChange 이벤트 발생 여부 (Default: 1)| |Opt.StatusMode|`Number`|<span class=\"optional\">선택</span>|상태값 처리 모드 - `0` : 대상 행의 상태값을 변경하지 않음 - `1` : 인자의 상태값을 무시하고 대상 행의 데이터 변경에 따른 상태값 처리 - `2` : 인자의 상태값을 그대로 적용| ### Returns ***none*** ### Example ```javascript //1행을 해당 json 객체로 설정 var data = {sName:\"홍길동\", sAge:20}; mySheet.SetRowData(1, data); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowData.html"
          },
          {
            "cid": 555,
            "sid": "SetRowDraggable",
            "name": "SetRowDraggable",
            "label": "SetRowDraggable",
            "data": {
              "body": "> 행의 마우스 드래그 가능 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetRowDraggable(row, drag); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| |drag|`Boolean`|<span class=\"required\">필수</span>|드래그 가능여부 설정 값 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 3행의 Drag 가능여부 설정 (마우스 드래깅시 행 드래깅 가능여부 설정) mySheet.SetRowDraggable(3, 1); // 드래그 가능 mySheet.SetRowDraggable(3, 0); // 드래그 불가 ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowDraggable.html"
          },
          {
            "cid": 556,
            "sid": "SetRowEditable",
            "name": "SetRowEditable",
            "label": "SetRowEditable",
            "data": {
              "body": "> 행의 Edit 가능 여부를 설정 합니다. > 전체 Edit 가능 여부가 가능일 때 변경 가능하며, ColEditable 설정값이 불가인 경우는 RowEditable 설정이 무시됩니다. > Edit 허용 가능으로 설정해도 Column, Row, Cell의 Edit 가능여부 설정에 따라 Edit 가능 여부가 결정됩니다. > `주의` edit 인자 설정과 상관 없이 `Popup`, `Seq`, `Status`, `Img`, `Result` 타입은 편집이 불가능합니다. ### Syntax ```javascript ObjId.SetRowEditable(Row, Editable); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| |Editable|`Boolean`|<span class=\"optional\">선택</span>|행의 Edit 가능 여부| ### Returns ***none*** ### Example ```javascript // 1행의 Edit 가능 여부를 0으로 설정 mySheet.SetRowEditable(1,0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowEditable.html"
          },
          {
            "cid": 557,
            "sid": "SetRowFontColor",
            "name": "SetRowFontColor",
            "label": "SetRowFontColor",
            "data": {
              "body": "> 행 전체의 글자색을 설정 합니다. ### Syntax ```javascript ObjId.SetRowFontColor(Row,Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| |Color|`String`|<span class=\"required\">필수</span>|WebColor 색상 값| ### Returns ***none*** ### Example ```javascript // 1행의 글자색을 회색으로 설정 mySheet.SetRowFontColor(1, \"192,192,192\"); // 3행의 글자색을 빨강색으로 설정 mySheet.SetRowFontColor(3, \"#FF0000\"); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowFontColor.html"
          },
          {
            "cid": 558,
            "sid": "SetRowHeight",
            "name": "SetRowHeight",
            "label": "SetRowHeight",
            "data": {
              "body": "> 대상 행의 높이를 설정 합니다. ### Syntax ```javascript ObjId.SetRowHeight(Row, Height); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|설정할 행 Index| |Height|`Integer`|<span class=\"required\">선택</span>|설정할 행 높이| ### Returns ***none*** ### Example ```javascript // Index가 3인 행의 높이를 25px로 설정 mySheet.SetRowHeight(3, 25); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowHeight.html"
          },
          {
            "cid": 559,
            "sid": "SetRowHeightMax",
            "name": "SetRowHeightMax",
            "label": "SetRowHeightMax",
            "data": {
              "body": "> 행의 최대 높이 값을 설정 합니다. > 데이터 행의 높이를 자동으로 설정한 경우에만 적용이 되며, DataRowHeight 보다 작게 설정한 경우 DataRowHeight의 값으로 설정 됩니다. ### Syntax ```javascript ObjId.SetRowHeightMax(MaxHeight); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |MaxHeight|`Integer`|<span class=\"required\">필수</span>|해당 행에 설정 할 최대 높이값| ### Returns ***none*** ### Example ```javascript // 최대 높이를 50픽셀로 설정 mySheet.SetRowHeightMax(50); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowHeightMax.html"
          },
          {
            "cid": 560,
            "sid": "SetRowHeightMin",
            "name": "SetRowHeightMin",
            "label": "SetRowHeightMin",
            "data": {
              "body": "> 행의 최대 높이 값을 설정 합니다. > 데이터 행의 높이를 자동으로 설정한 경우에만 적용이 되며, DataRowHeight 보다 작게 설정한 경우 DataRowHeight의 값으로 설정 됩니다. ### Syntax ```javascript ObjId.SetRowHeightMin(MinHeight); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |MinHeight|`Integer`|<span class=\"required\">필수</span>|해당 행에 설정 할 최소 높이값| ### Returns ***none*** ### Example ```javascript // 최소 높이를 10픽셀로 설정 mySheet.SetRowHeightMin(10); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowHeightMin.html"
          },
          {
            "cid": 561,
            "sid": "SetRowHidden",
            "name": "SetRowHidden",
            "label": "SetRowHidden",
            "data": {
              "body": "> 단일 또는 다중행에 대한 숨김 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetRowHidden(Row, Hidden); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long or String`|<span class=\"required\">필수</span>|특정 행의 Row Index 혹은 구분자 `|`로 연결된 문자열| |Hidden|`Boolean`|<span class=\"required\">필수</span>|조회 처리 옵션| ### Returns ***none*** ### Example ```javascript // 1행을 숨김 처리 mySheet.SetRowHidden(1, 1); // 2, 3, 7번 행을 숨김 처리 mySheet.SetRowHidden(\"2|3|7\", 1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetRowHidden.html"
          },
          {
            "cid": 562,
            "sid": "SetTopRow",
            "name": "SetTopRow",
            "label": "SetTopRow",
            "data": {
              "body": "> 최상단의 행 번호를 설정 합니다. > 상단 헤더 영역을 제외하고 데이터 영역 안에서 최상단의 행을 설정하며 해당 행이 선택된 상태로 설정되지는 않습니다. ### Syntax ```javascript ObjId.SetTopRow(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| ### Returns ***none*** ### Example ```javascript // 최상단 행 번호를 설정 mySheet.SetTopRow(100); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/SetTopRow.html"
          },
          {
            "cid": 563,
            "sid": "ShowFooterRow",
            "name": "ShowFooterRow",
            "label": "ShowFooterRow",
            "data": {
              "body": "> 그리드 하단에 고정되는 사용자 정의 행을 설정합니다. > data 인자는 JSON 형식의 조회 데이터 구조를 사용합니다. > 형식은 `Key:Value` 형태이며, Key는 컬럼 초기화 구성시 설정한 SaveName, Value는 해당 셀의 값이 됩니다. > 속성은 Key 값을 초기화시 설정된 SaveName과 속성명을 `#` 로 구분하여 구성해서 사용합니다. **Ex ) SaveName#Type** > Type 은 `Text`, `Int`, `Float` 의 데이터타입만 허용되고, 기타 속성에 대한 타입 및 설정은 [InitColumns](/docs/funcs/init/InitColumns) 의 속성 설명을 참고 바랍니다. ### Syntax ```javascript ObjId.ShowFooterRow(Data); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Data|`Object or Array`|<span class=\"required\">필수</span>|Footer 설정 객체| ### Enum * Data |Name|Description| |----|-----------| |**Type**|데이터타입 (Text, Int, Float)| |**Align**|좌우 정렬 값| |**RowSpan**|RowSpan 범위 값| |**ColSpan**|ColSpan 범위 값| |**FontColor**|폰트색상| |**FontBold**|폰트볼드| |**BackColor**|셀 배경색| |**Format**|포멧설정| |**PointCount**|실수 형태의 데이터 타입에서 소수점 자리수| |**MultiLineText**|Text 형태의 데이터 타입에서의 다중 라인 입력 허용 여부| ### Returns ***none*** ### Example ```javascript // 하단 고정행을 2개로 만들며, TEXT_DATA 컬럼의 경우 2행, 2열의 머지를 한 형태로 행을 생성 mySheet.ShowFooterRow([ {\"SEQ\":\"순번\", \"SEQ#Type\":\"Int\", \"TEXT_DATA\":\"홍길동\", \"TEXT_DATA#BackColor\":\"blue\", \"TEXT_DATA#Align\":\"Center\", \"TEXT_DATA#RowSpan\":2, \"TEXT_DATA#ColSpan\":2,\"TEXT_DATA#MultiLineText\":1, \"IMAGE_DATA\":\"이미지\", \"PASS_DATA\":\"비밀번호\", \"RADIO_DATA\":\"라디오\"}, {\"SEQ\":\"순번2\", \"COMBO_DATA\":\"콤보2\",\"COMBOEDIT_DATA\":\"콤보에디트2\", \"DATE_DATA\":\"날짜2\",\"CHECKBOX_DATA\":\"체크박스2\",\"RADIO_DATA\":\"라디오2\"} ]); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/row/ShowFooterRow.html"
          }
        ]
      },
      {
        "gid": 13,
        "name": "funcs-save",
        "label": "save",
        "children": [
          {
            "cid": 564,
            "sid": "DoAllSave",
            "name": "DoAllSave",
            "label": "DoAllSave",
            "data": {
              "body": "> 데이터의 트랜잭션 상태에 관계 없이 모든 데이터를 저장 하도록 페이지를 호출합니다. > 데이터 건수가 한건도 없으면 경고 메시지를 표시하고, 처리는 중단됩니다. > 저장 준비를 위한 저장 데이터를 모으는 과정에서 [OnValidataion](/docs/event/OnValidation) 이벤트가 발생하며 사용자 정의 로직에 따라 OnValidataion에서 실패한 경우 저장 처리는 중단합니다. ### Syntax ```javascript ObjId.DoAllSave(Url, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url| |Opt|`Object`|<span class=\"optional\">선택</span>|저장 처리 옵션| |Opt.CallBack|`Function`|<span class=\"optional\">선택</span>|조회 후 사용자 정의 콜백함수| |Opt.Param|`String`|<span class=\"optional\">선택</span>|저장을 위한 Parameter (Default: \"\")| |Opt.UrlEncode|`Boolean`|<span class=\"optional\">선택</span>|IBSheet 위의 데이터를 인코딩할지 여부를 설정 (Default: 1)| |Opt.Mode|`Number`|<span class=\"optional\">선택</span>|Query String 문자열 조합방법을 설정 (`1` : 셀기준 조합방법 (Default), `2` : 컬럼기준 조합 방법)| |Opt.Delim|`String`|<span class=\"optional\">선택</span>|Mode=2일때, 연결될 구분자 설정 (Default: `|`)| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청헤더 설정 값 객체 (Default: {})| |Opt.ValidKeyField|`Boolean`|<span class=\"optional\">선택</span>|KeyField 체크 여부 (Default: 1)| |Opt.ValidFullInput|`Boolean`|<span class=\"optional\">선택</span>|FullInput 체크 여부 (Default: 1)| |Opt.ValidEditLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 EditLen 속성을 통한 길이 체크 여부| |Opt.ValidMinLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 MinLen 속성을 통한 길이 체크 여부 (Default: 0)| |Opt.Quest|`Boolean`|<span class=\"optional\">선택</span>|저장시 confirm 메시지 사용 여부| |Opt.Sync|`Number`|<span class=\"optional\">선택</span>|저장 처리 방법 (`0` : 비동기방식(Default), `2` : 동기방식)| |Opt.UrlEncode|`Boolean`|<span class=\"optional\">선택</span>|시트의 데이터에 대한 인코딩 여부| ### Returns ***Boolean, 저장 처리여부*** ### Example ```javascript // 일반 저장 mySheet.DoAllSave('save.jsp', { \"Param\": \"p1=aa&p2=bb\" }); // 컬럼기준 조합방식 저장 (구분자:$) mySheet.DoAllSave('save.jsp', { \"Param\": \"p1=aa&p2=bb\", \"Mode\": 2, \"Delim\": \"$\", }); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.1.0|저장 처리 여부에 따른 리턴값 추가| |7.0.12.4|ValidKeyField, ValidFullInput 인자 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.1.0|저장 처리 여부에 따른 리턴값 추가||7.0.12.4|ValidKeyField, ValidFullInput 인자 속성 추가|"
            },
            "url": "docs/funcs/save/DoAllSave.html"
          },
          {
            "cid": 565,
            "sid": "DoSave",
            "name": "DoSave",
            "label": "DoSave",
            "data": {
              "body": "> 데이터의 트랜잭션 상태 또는 특정 컬럼 데이터에 따라 시트의 데이터를 저장 처리 합니다. > 기준 컬럼을 설정하지 않은 경우 `Status` 데이터 타입의 컬럼을 기준컬럼으로 사용합니다. > 서버로 부터 전달 받은 응답 데이터에 따라 성공 실패 처리를 합니다. ### Syntax ```javascript ObjId.DoSave(Url, [Opt]) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url| |Opt|`Object`|<span class=\"optional\">선택</span>|저장 처리 옵션| |Opt.CallBack|`Function`|<span class=\"optional\">선택</span>|저장 후 사용자 정의 콜백함수| |Opt.Col|`Long or String`|<span class=\"optional\">선택</span>|저장 대상이 되는 기준 컬럼의 Index 또는 SaveName| |Opt.Mode|`Number`|<span class=\"optional\">선택</span>|Query String 문자열 조합방법을 설정 (`1` : 셀기준 조합방법 (Default), `2` : 컬럼기준 조합 방법)| |Opt.Delim|`String`|<span class=\"optional\">선택</span>|Mode=2일때, 연결될 구분자 설정 (Default: `|`)| |Opt.Param|`String`|<span class=\"optional\">선택</span>|저장을 위한 Parameter (Default: \"\")| |Opt.Quest|`Boolean`|<span class=\"optional\">선택</span>|저장시 confirm 메시지 사용 여부| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청헤더 설정 값 객체 (Default: {})| |Opt.Sync|`Number`|<span class=\"optional\">선택</span>|저장 처리 방법 (`0` : 비동기방식(Default), `2` : 동기방식)| |Opt.UrlEncode|`Boolean`|<span class=\"optional\">선택</span>|시트의 데이터에 대한 인코딩 여부| |Opt.ValidKeyField|`Boolean`|<span class=\"optional\">선택</span>|KeyField 체크 여부 (Default: 1)| |Opt.ValidFullInput|`Boolean`|<span class=\"optional\">선택</span>|FullInput 체크 여부 (Default: 1)| |Opt.ValidEditLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 EditLen 속성을 통한 길이 체크 여부| |Opt.ValidMinLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 MinLen 속성을 통한 길이 ### Returns ***Boolean, 저장 처리 여부*** ### Example ```javascript // 일반 저장 mySheet.DoSave('save.jsp', { \"Param\": \"p1=aa&p2=bb\" }); // Index가 2인 CheckBox 컬럼의 값이 checked 인 데이터만 저장 mySheet.DoSave('save.jsp', { \"Param\": \"p1=aa&p2=bb\", \"Col\": 2 }); // 컬럼기준 조합방식 저장 (구분자:$) mySheet.DoSave('save.jsp', { \"Param\": \"p1=aa&p2=bb\", \"Mode\": 2, \"Delim\": \"$\", }); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/save/DoSave.html"
          },
          {
            "cid": 566,
            "sid": "GetSaveData",
            "name": "GetSaveData",
            "label": "GetSaveData",
            "data": {
              "body": "> Ajax 통신을 이용하여 시트 저장 데이터를 전달하고, 처리 결과 데이터를 받아서 반환합니다. > 반환된 데이터를 암호화 등의 가공 처리후 [LoadSaveData](/docs/funcs/save/LoadSaveData) 메소드를 통해 처리 결과를 적용 할 수 있습니다. > 이 기능을 사용시 Ajax 통신은 동기 방식으로 처리됩니다. ### Syntax ```javascript ObjId.GetSaveData(PageUrl, SaveString, Param, [Opt]) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url| |SaveString|`String`|<span class=\"optional\">선택</span>|시트의 저장 대상 데이터 문자열 (Default: \"\")| |Param|`String`|<span class=\"optional\">선택</span>|서버 요청시 전달 할 파라메터 값 (Default: \"\")| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청 헤더 설정 객체 (key-value 형태의 포맷)| ### Returns ***String, 서버 응답 결과 문자열*** ### Example ```javascript var saveData = '', result = ''; // 저장 대상 데이터 받기 saveData = mySheet.GetSaveString(); // 저장 데이터가 있는 경우에 저장 처리 if (typeof saveData !== 'undefined' && saveData !== 'KeyFieldError') { // 저장 데이터 전달 및 결과 수신 saveData = mySheet.GetSaveData('data.jsp', 'p1=aa&p2=bb'); // 데이터 가공 saveData = decryptionData(saveData); // 사용자정의 함수 // 저장 결과 적용 mySheet.LoadSaveData(saveData); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/save/GetSaveData.html"
          },
          {
            "cid": 567,
            "sid": "GetSaveJson",
            "name": "GetSaveJson",
            "label": "GetSaveJson",
            "data": {
              "body": "> 저장 할 데이터를 Json 객체로 반환합니다. > Validation 체크 결과가 실패인 경우 아래와 같이 결과 코드 및 메시지를 Json 객체로 반환 합니다. > - IBS000 NoTargetRows 처리 대상 행이 없는 경우 > - IBS010 KeyFieldError 필수 입력 누락인 경우 > - IBS020 InvalidInputError Validation 체크 오류인 경우 > - IBS030 EditLenError 저장 Cell 값이 EditLen보다 긴경우 > - IBS040 MinLenError 저장 Cell 값이 MinLen보다 짧은경우 ### Syntax ```javascript ObjId.GetSaveJson([Option]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Option|`Boolean`|<span class=\"optional\">선택</span>|저장 처리 옵션| |Option.AllSave|`Boolean`|<span class=\"optional\">선택</span>|전체 저장 여부| |Option.StdCol|`Number or String`|<span class=\"optional\">선택</span>|대상이 되는 기준 컬럼의 Index 또는 SaveName| |Option.StdColValue|`String`|<span class=\"optional\">선택</span>|기준 컬럼의 추출 대상 값을 구분자 `|` 로 연결한 문자열| |Option.ValidEditLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 EditLen 속성을 통한 길이 체크 여부| |Option.ValidMinLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 MinLen 속성을 통한 길이 체크 여부| |Option.ValidFullInput|`Boolean`|<span class=\"optional\">선택</span>|FullInput 체크 여부| |Option.ValidKeyField|`Boolean`|<span class=\"optional\">선택</span>|필수입력 체크 여부| |Option.AllTypeToText|`Boolean`|<span class=\"optional\">선택</span>|Json data 텍스트로 구성 여부| ### Returns ***Object, 저장할 데이터의 Json 객체*** ### Example ```javascript // 변경 데이터 가져오기 var saveData = mySheet.GetSaveJson(); console.log('saveData: ', saveData); // 모든 데이터 가져오기 var saveData = mySheet.GetSaveJson({ \"AllSave\": 1 }); console.log('saveData: ', saveData); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/save/GetSaveJson.html"
          },
          {
            "cid": 568,
            "sid": "GetSaveString",
            "name": "GetSaveString",
            "label": "GetSaveString",
            "data": {
              "body": "> 저장 할 데이터를 Query String 조합 문자열로 반환합니다. > Validation 체크 결과가 실패인 경우 기본으로 KeyFieldError 문자열을 반환 하고, ibmsg의 SYS_InvalidGetSaveString에 값이 설정되어 있는 경우 해당 값으로 반환합니다. ### Syntax ```javascript ObjId.GetSaveString([Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Opt|`Object`|<span class=\"optional\">선택</span>|저장 처리 옵션| |Opt.AllSave|`Boolean`|<span class=\"optional\">선택</span>|전체 저장 여부 (Default: 0)| |Opt.UrlEncode|`Boolean`|<span class=\"optional\">선택</span>|UrlEncode 여부 (Default: 1)| |Opt.Col|`Long or String`|<span class=\"optional\">선택</span>|대상이 되는 기준 컬럼 또는 SaveName (Default: 상태 컬럼)| |Opt.Prefix|`String`|<span class=\"optional\">선택</span>|저장시 SaveName 앞에 붙이고자 하는 문자열 (Default: \"\")| |Opt.Mode|`Integer`|<span class=\"optional\">선택</span>|Query String 문자열 조합방법을 설정 (`1` : 셀기준 조합방법 (Default), `2` : 컬럼기준 조합방법)| |Opt.Delim|`String`|<span class=\"optional\">선택</span>|Mode=2일때, 연결될 구분자 설정 (Default: `|`)| |Opt.StdColValue|`String`|<span class=\"optional\">선택</span>|기준컬럼의 추출 대상 값을 구분자 `|` 로 연결한 문자열| |Opt.ValidKeyField|`Boolean`|<span class=\"optional\">선택</span>|KeyField 체크 여부 (Default: 1)| |Opt.ValidFullInput|`Boolean`|<span class=\"optional\">선택</span>|FullInput 체크 여부 (Default: 1)| |Opt.ValidEditLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 EditLen 속성을 통한 길이 체크 여부| |Opt.ValidMinLen|`Boolean`|<span class=\"optional\">선택</span>|저장시 EditLen 속성을 통한 길이 체크 여부| |Opt.NoSelectCellEvent|`Boolean`|<span class=\"optional\">선택</span>|KeyField 체크로 인해 포커스 이동시 OnSelectCell 이벤트 발생여부 (Default: 0(이벤트 발생))| ### Returns ***String, 저장할 Query String*** ### Example ```javascript // 변경 데이터의 저장 문자열 가져오기 (DoSave) var saveData = mySheet.GetSaveString(); console.log('saveData: ', saveData); // 모든 데이터의 저장 문자열 가져오기 (DoAllSave) var saveData = mySheet.GetSaveString({ \"AllSave\": 1 }); console.log('saveData: ', saveData); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/save/GetSaveString.html"
          },
          {
            "cid": 569,
            "sid": "LoadSaveData",
            "name": "LoadSaveData",
            "label": "LoadSaveData",
            "data": {
              "body": "> 저장 데이터를 함수의 인자로 전달 받아 결과를 IBSheet 내부에서 처리하여 저장 결과 데이터를 시트에 적용 합니다. > 이 함수는 보안 모듈이 사용 될 경우 복호화된 저장 데이터을 읽어 들이기 위한 용도로 사용됩니다. > 저장 데이터는 `GetSaveData` 함수를 통해 읽어 들일 수 있고, 이 함수에 인자로 설정하면 처리 결과를 표현하고, `OnSaveEnd` 이벤트가 발생합니다. ### Syntax ```javascript ObjId.LoadSaveData(Content, [Opt]) ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Content|`String`|<span class=\"required\">필수</span>|저장XML 또는 저장JSON 문자열| |Opt|`Object`|<span class=\"optional\">선택</span>|저장 처리 옵션 - sheet : 대상 IBSheet 객체 (object) - code : 결과 코드 (number)| |Opt.CallBack|`function`|<span class=\"optional\">선택</span>|콜백 함수| |Opt.Event|`Object`|<span class=\"optional\">선택</span>|완료 이벤트 발생 여부 (Default :1)| ### Returns ***none*** ### Example ```javascript var saveData = '', result = ''; // 저장 대상 데이터 받기 saveData = mySheet.GetSaveString(); // 저장 데이터가 있는 경우에 저장 처리 if (typeof saveData !== 'undefined' && saveData !== 'KeyFieldError') { // 저장 데이터 전달 및 결과 수신 saveData = mySheet.GetSaveData('data.jsp', 'p1=aa&p2=bb'); // 데이터 가공 saveData = decryptionData(saveData); // 사용자정의 함수 // 저장 결과 적용 mySheet.LoadSaveData(saveData); } ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.43|CallBack, Event 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.43|CallBack, Event 속성 추가|"
            },
            "url": "docs/funcs/save/LoadSaveData.html"
          },
          {
            "cid": 570,
            "sid": "RowSaveStr",
            "name": "RowSaveStr",
            "label": "RowSaveStr",
            "data": {
              "body": "> 행의 데이터를 각 컬럼의 SaveName을 이용하여 저장 시 사용되는 Query String 형태로 조합하여 반환합니다. > Ex ) SaveName1=Value1&SaveName2=Value2&... > 한글은 UrlEncoding 되어 반환됩니다. ### Syntax ```javascript ObjId.RowSaveStr(Row, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|해당 행의 Row Index| |Opt|`Object`|<span class=\"optional\">선택</span>|저장 처리 옵션| |Opt.ValidKeyField|`Boolean`|<span class=\"optional\">선택</span>|KeyField 체크 여부 (Default: 1)| |Opt.ValidFullInput|`Boolean`|<span class=\"optional\">선택</span>|FullInput 체크 여부 (Default: 1)| ### Returns ***String, 행의 데이터*** ### Example ```javascript // Index가 1인 행의 저장 문자열을 가져온다. var saveData = mySheet.RowSaveStr(1); console.log('saveData: ', saveData); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.12.4|ValidKeyField, ValidFullInput 인자 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.12.4|ValidKeyField, ValidFullInput 인자 속성 추가|"
            },
            "url": "docs/funcs/save/RowSaveStr.html"
          }
        ]
      },
      {
        "gid": 14,
        "name": "funcs-search",
        "label": "search",
        "children": [
          {
            "cid": 571,
            "sid": "DoRowSearch",
            "name": "DoRowSearch",
            "label": "DoRowSearch",
            "data": {
              "body": "> 특정 행의 셀 데이터를 조회 합니다. ### Syntax ```javascript ObjId.DoRowSearch(Row, PageUrl, Param, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |PageUrl|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url| |Param|`String`|<span class=\"optional\">선택</span>|조회 조건 Query String (Default: \"\")| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청헤더 설정 값 객체 (Default: {})| |Opt.Sync|`Boolean`|<span class=\"optional\">선택</span>|동기 조회 여부 - `0` : 비동기 방식 (Default) - `1` : 비동기 순차 처리 방식 - `2` : 동기 방식| |Opt.Wait|`Boolean`|<span class=\"optional\">선택</span>|대기 이미지 표시 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript //3컬럼의 데이터가 바뀌었을 때 해당 행의 데이터를 DB에서 읽어옴 function mySheet_OnChange(Row, Col, Value) { if (Col == 3) { var opt = { Wait : 1, Sync : 1 }; mySheet.DoRowSearch(Row, \"grid_rowdata.html\", \"\" , opt); } } // 1. 이미지 미표시, 비동기 조회 var opt = { Wait : 0, Sync : 0 }; mySheet.DoRowSearch(Row, \"grid_rowdata.html\", \"\" , opt); // 2. 이미지 표시, 비동기 순차처리 조회 var opt = { Wait : 1, Sync : 1 }; mySheet.DoRowSearch(Row, \"grid_rowdata.html\", \"\" , opt); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/search/DoRowSearch.html"
          },
          {
            "cid": 572,
            "sid": "DoSearch",
            "name": "DoSearch",
            "label": "DoSearch",
            "data": {
              "body": "> Ajax 통신을 이용하여 규격에 맞는 `xml` 또는 `json` 형식의 데이터를 시트에 로드 합니다. ### Syntax ```javascript ObjId.DoSearch(PageUrl, Param, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |PageUrl|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url (조회 XML 페이지 파일 이름)| |Param|`String`|<span class=\"optional\">선택</span>|조회 조건 Query String or JSON (Default: \"\")| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.Append|`Boolean`|<span class=\"optional\">선택</span>|Append 조회 여부 (Default: 0)| |Opt.AppendRow|`Number`|<span class=\"optional\">선택</span>|Append 조회 시 데이터를 붙여넣을 위치 설정| |Opt.CallBack|`Function`|<span class=\"optional\">선택</span>|조회 후 사용자 정의 콜백함수| |Opt.Fx|`Boolean`|<span class=\"optional\">선택</span>|포맷팅된 데이터 조회 처리 여부 (Default: 0)| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청헤더 설정 값 객체 (Default: {})| |Opt.Sync|`Boolean`|<span class=\"optional\">선택</span>|동기 조회 여부 - `0` : 비동기 방식 (Default) - `1` : 비동기 순차 처리 방식 - `2` : 동기 방식| ### Returns ***none*** ### Example ```javascript // 일반 조회 mySheet.DoSearch('data.jsp', 'p1=aa&p2=bb'); // 동기 방식 조회 mySheet.DoSearch('data.jsp', 'p1=aa&p2=bb', { \"Sync\": 2 }); // Append 조회 mySheet.DoSearch('data.jsp', 'p1=aa&p2=bb', { \"Append\": 1 }); // 요청 헤더 설정 mySheet.DoSearch('data.jsp', 'p1=aa&p2=bb', { \"ReqHeader\": { \"ReqHeaderKey\": \"ReqHeaderValue\" } }); // param JSON 구조 사용 mySheet.DoSearch('data.jsp', {\"p1\":100, \"p2\":\"bb\"}, {\"ReqHeader\":{\"Content-Type\":\"application/json\"}}); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.164|Param JSON 구조 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.164|Param JSON 구조 추가|"
            },
            "url": "docs/funcs/search/DoSearch.html"
          },
          {
            "cid": 573,
            "sid": "DoSearchChild",
            "name": "DoSearchChild",
            "label": "DoSearchChild",
            "data": {
              "body": "> 트리 구조의 시트에서 Ajax 통신을 이용하여 규격에 맞는 xml 또는 Json 형식의 데이터를 대상 행의 자식 데이터로 로드합니다. > 이 기능을 사용하기 위해서는 대상 행의 트리 펼침시 발생하는 [OnTreeChild](/docs/funcs/tree/OnTreeChild) 이벤트 내애서 사용하여야 합니다. ### Syntax ```javascript ObjId.DoSearchChild(Row, PageUrl, [Param], [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|`OnTreeChild` 이벤트에서 받은 행의 Index| |PageUrl|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url| |Param|`String`|<span class=\"optional\">선택</span>|조회 조건 Query String (Default: \"\")| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청헤더 설정 값 객체 (Default: {})| |Opt.Sync|`Boolean`|<span class=\"optional\">선택</span>|동기 조회 여부 - `0` : 비동기 방식 (Default) - `1` : 비동기 순차 처리 방식 - `2` : 동기 방식| |Opt.Wait|`Boolean`|<span class=\"optional\">선택</span>|대기 이미지 표시 여부 (Default: 1)| |Opt.SortCol|`String`|<span class=\"optional\">선택</span>|데이터 로드시 Sort 대상 기준 컬럼의 Index 또는 SaveName을 구분자로 연결한 문자열| |Opt.SortOrder|`String`|<span class=\"optional\">선택</span>|컬럼에 대한 기본 Sort 정렬 방식을 구분자로 연결한 문자열 (asc: 오름차순, desc: 내림차순)| ### Returns ***none*** ### Example ```javascript // OnTreeChild 이벤트에서 자식 데이터 로드 function mySheet_OnTreeChild(row) { var url = '', colData = mySheet.GetCellValue(row, 4); switch(colData) { case 'seoul': url = 'childdata_seoul.jsp'; break; case 'inchon': url = 'childdata_inchon.jsp'; break; } mySheet.DoSearchChild(row, url, '', { Wait: 1 }); } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/search/DoSearchChild.html"
          },
          {
            "cid": 574,
            "sid": "DoSearchPaging",
            "name": "DoSearchPaging",
            "label": "DoSearchPaging",
            "data": {
              "body": "> 서버 페이징 방식과 같이 시트의 세로 스크롤 Position 에 해당하는 데이터에 대한 부분 데이터를 시트에 로드 합니다. > 스크롤의 위치를 변경할 때마다 인자로 설정된 Url이 호출되며 데이터를 해당 위치에 표현합니다. > `NextPageCall` 속성이 설정되어 있는경우 설정된 시점에 설정된 Url이 호출됩니다. [NextPageCall 참고](/docs/props/PropertyList/NextPageCall) > 전체 스크롤 사이즈는 조회 데이터의 `Total` 속성 값을 따르며, 조회된 데이터의 구조에 Total 값이 `반드시 있어야` 합니다. [조회TOTAL요소 참고](/docs/static/JSON/total1) > 해당 기능으로 조회시 Row 및 Cell의 속성, 멀티 트랜잭션 기능 사용에 `제약`이 있습니다. > `참고 ` 이 메소드를 사용하고자 하는 경우 `SetConfig`에서 `SearchMode: 3 혹은 4`로 설정되어 있어야 합니다. ### Syntax ```javascript ObjId.DoSearchPaging(Url, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Url|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.PageParam|`String`|<span class=\"optional\">선택</span>|페이지 인덱스를 받을 변수명 (Default: \"ibpage\")| |Opt.Param|`String`|<span class=\"optional\">선택</span>|조회 조건 Query String or JSON (Default: \"\")| |Opt.OrderbyParam|`String`|<span class=\"optional\">선택</span>|헤더 정렬 정보를 받을 변수명 (Default: \"iborderby\") 값은 \"SIDO|SIGUNGU ^ASC|DESC\" 와 같이 savename 과 정렬 방향이 \"^\"로 구분되며 각 이름은 `|`로 구분| |Opt.UseWaitImage|`Boolean`|<span class=\"optional\">선택</span>|WaitImageVisible 설정이 true 일때 2페이지 이상 조회시 대기 이미지 표시 여부 (Default: 0)| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청헤더 설정 값 객체 (Default: {})| |Opt.Sync|`Boolean`|<span class=\"optional\">선택</span>|동기 조회 여부 - `0` : 비동기 방식 (Default) - `1` : 비동기 순차 처리 방식 - `2` : 동기 방식| |Opt.CPage|`Number`|<span class=\"optional\">선택</span>|특정 페이지를 기준으로 조회| ### Returns ***none*** ### Example ```javascript // SetConfig 에서 SearchMode 설정 mySheet.SetConfig({ \"SearchMode\": 3 }); // 조회 처리 mySheet.DoSearchPaging('data.jsp', 'p1=aa&p2=bb'); // Param JSON 구조로 설정 var param = { \"Param\":{\"p1\":100, \"p2\":\"aa\"} , \"ReqHeader\":{\"Content-Type\":\"application/json\"} }; mySheet.DoSearchPaging('data.jsp', param); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.151|CPage 속성 추가| |7.0.13.157|Param JSON 구조 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.151|CPage 속성 추가||7.0.13.157|Param JSON 구조 추가|"
            },
            "url": "docs/funcs/search/DoSearchPaging.html"
          },
          {
            "cid": 575,
            "sid": "GetFocusAfterProcess",
            "name": "GetFocusAfterProcess",
            "label": "GetFocusAfterProcess",
            "data": {
              "body": "> 데이터 로드 후 포커스를 데이터 영역의 첫번째 셀에 설정 할지 여부를 확인합니다. ### Syntax ```javascript ObjId.GetFocusAfterProcess(); ``` ### Info ***none*** ### Returns ***Boolean, 설정 값*** ### Example ```javascript // 데이터 로드 후 포커스 설정 여부 확인 console.log('focus: ', mySheet.GetFocusAfterProcess()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/search/GetFocusAfterProcess.html"
          },
          {
            "cid": 576,
            "sid": "GetSearchData",
            "name": "GetSearchData",
            "label": "GetSearchData",
            "data": {
              "body": "> Ajax 통신을 이용하여 시트에 로드할 데이터를 받아서 반환합니다. > 반환된 데이터를 복호화 등의 가공 처리후 `LoadSearchData` 메소드를 통해 데이터를 로드 할 수 있습니다. [LoadSearchData](/docs/funcs/search/LoadSearchData) > 이 기능을 사용시 Ajax 통신은 `동기` 방식으로 처리 됩니다. ### Syntax ```javascript ObjId.GetSearchData(PageUrl, Param, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |PageUrl|`String`|<span class=\"required\">필수</span>|서버에 요청할 페이지 url| |Param|`String`|<span class=\"optional\">선택</span>|조회 조건 Query String or JSON (Default: \"\")| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.ReqHeader|`Object`|<span class=\"optional\">선택</span>|요청헤더 설정 값 객체 (Default: {})| ### Returns ***String, 서버 응답 결과 문자열*** ### Example ```javascript // 로드 대상 데이터 받기 var data = mySheet.GetSearchData('data.jsp', 'p1=aa&p2=bb'); // 데이터 가공 data = decryptionData(data); // 사용자정의 함수 // 가공된 데이터 로드 mySheet.LoadSearchData(data); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/search/GetSearchData.html"
          },
          {
            "cid": 577,
            "sid": "LoadSearchData",
            "name": "LoadSearchData",
            "label": "LoadSearchData",
            "data": {
              "body": "> 규격에 맞는 xml 또는 Json 형식의 데이터를 시트에 로드 합니다. > 데이터 형식이 Json 구조인 경우 객체 또는 형태의 문자열 모두 사용 할 수 있습니다. > CallBack 함수를 설정한 경우 `OnSearchEnd` 이벤트 이전에 CallBack 함수가 호출 됩니다. ### Syntax ```javascript ObjId.LoadSearchData(Content, [Opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Content|`String`|<span class=\"required\">필수</span>|규격에 맞는 조회 xml 또는 json 형식의 데이터 객체 또는 문자열| |Opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |Opt.Append|`Boolean`|<span class=\"optional\">선택</span>|Append 조회 여부 (Default: 0)| |Opt.AppendRow|`Number`|<span class=\"optional\">선택</span>|Append 조회 시 데이터를 붙여넣을 위치 설정| |Opt.CallBack|`Function`|<span class=\"optional\">선택</span>|CallBack 함수| |Opt.Event|`Boolean`|<span class=\"optional\">선택</span>|완료 이벤트 발생 여부 (Default: 1)| |Opt.Fx|`Boolean`|<span class=\"optional\">선택</span>|포맷팅된 데이터 조회 처리 여부 (Default: 0)| |Opt.Sync|`Boolean`|<span class=\"optional\">선택</span>|동기 조회 여부 (Default: 0)| |Opt.Wait|`Boolean`|<span class=\"optional\">선택</span>|대기 이미지 표시 여부 (Default: 1) 동기 조회인 경우에는 설정값에 상관없이 대기 이미지를 표시하지 않음| ### Returns ***none*** ### Example ```javascript // 로드 대상 데이터 받기 var data = mySheet.GetSearchData('data.jsp', 'p1=aa&p2=bb'); // 데이터 가공 data = decryptionData(data); // 사용자정의 함수 // 가공된 데이터 로드 mySheet.LoadSearchData(data); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.5.4|Fx:2 옵션 추가| |7.0.6.0|대기이미지 표시여부 속성 추가 (Wait)| |7.0.13.43|CallBack, Event 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.5.4|Fx:2 옵션 추가||7.0.6.0|대기이미지 표시여부 속성 추가 (Wait)||7.0.13.43|CallBack, Event 속성 추가|"
            },
            "url": "docs/funcs/search/LoadSearchData.html"
          },
          {
            "cid": 578,
            "sid": "SetFocusAfterProcess",
            "name": "SetFocusAfterProcess",
            "label": "SetFocusAfterProcess",
            "data": {
              "body": "> 데이터 로드 후 포커스를 데이터 영역의 첫번째 셀에 설정 할지 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetFocusAfterProcess(mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |mode|`String`|<span class=\"required\">필수</span>|포커스 설정 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // 데이터 로드 후 포커스를 설정하지 않도록 설정 mySheet.SetFocusAfterProcess(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/search/SetFocusAfterProcess.html"
          }
        ]
      },
      {
        "gid": 15,
        "name": "funcs-sum",
        "label": "sum",
        "children": [
          {
            "cid": 579,
            "sid": "ComputeSum",
            "name": "ComputeSum",
            "label": "ComputeSum",
            "data": {
              "body": "> 대상 범위 영역의 합계를 계산하여 반환 합니다. > StartRow, EndRow 인자를 설정하지 않은 경우 `모든 데이터 영역`에 대해서 합계를 계산 합니다. ### Syntax ```javascript ObjId.ComputeSum(CalcLogic, FirstRow, LastRow, isFullSum); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |CalcLogic|`String`|<span class=\"required\">필수</span>|계산 공식, 공식에 다른 컬럼값이 사용되는 경우 반드시 `|`로 감싸서 사용| |Col|`String`|<span class=\"required\">필수</span>|대상 컬럼명| |FirstRow|`Long`|<span class=\"optional\">선택</span>|계산 대상행의 시작 index (Default: -1)| |LastRow|`Long`|<span class=\"optional\">선택</span>|계산 대상행의 마지막 index (Default: -1)| |isFullSum|`Boolean`|<span class=\"optional\">선택</span>|해당 계산식을 소계행도 포함할지의 여부 - `1` : 소계행을 계산식에 포함 - `0` : 소계행은 계산식에서 제외| ### Returns ***Double, 계산되어진 특정영역의 합계*** ### Example ```javascript // Index가 3인 컬럼의 합계 계산 console.log('result: ', mySheet.ComputeSum('|3|')); // 1 ~ 10 행 까지의 Index가 3인 컬럼 * Index 가 4인 컬럼 / 100 의 계산 결과의 합계 계산 console.log('result: ', mySheet.ComputeSum('|3| * |4| / 1000', 1, 10)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/ComputeSum.html"
          },
          {
            "cid": 580,
            "sid": "FindFooterRow",
            "name": "FindFooterRow",
            "label": "FindFooterRow",
            "data": {
              "body": "> FooterRow의 인덱스를 반환합니다. ### Syntax ```javascript ObjId.FindFooterRow(); ``` ### Info ***none*** ### Returns ***Integer, 푸터행의 인덱스를 구분자 `|`로 연결한 문자열 (Default: -1)*** ### Example ```javascript // 합계 행의 Index 확인 console.log('FooterRows: ', mySheet.FindFooterRow()); ``` ### Since |version|desc| |---|---| |7.0.13.181||",
              "since": "|version|desc||---|---||7.0.13.181||"
            },
            "url": "docs/funcs/sum/FindFooterRow.html"
          },
          {
            "cid": 581,
            "sid": "FindSubSumRow",
            "name": "FindSubSumRow",
            "label": "FindSubSumRow",
            "data": {
              "body": "> 소계 및 누계 행의 Index를 구분자 `|`로 연결한 문자열로 반환 합니다. > `stdCol` 인자를 설정하지 않거나 빈값으로 설정 한 경우 모든 소계 및 누계 행을 반환 하고, 설정한 경우 해당 기준컬럼에 대한 소계 및 누계 행만 반환 합니다. (다중 소계 표현인 경우) ### Syntax ```javascript ObjId.FindSubSumRow([StdCol]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |StdCol|`Long or String`|<span class=\"optional\">선택</span>|소계를 표시한 기준 컬럼의 Index 또는 SaveName (Default:\"\"(전체컬럼))| ### Returns ***String, 소계의 행 번호를 `|`로 연결한 문자열*** ### Example ```javascript // Index가 1인 컬럼, 2인 컬럼 기준의 다중 소계 표현 mySheet.ShowSubSum([ {\"StdCol\": 1, \"SumCols\": \"3|4|5\"} {\"StdCol\": 2, \"SumCols\": \"3|4|5\", \"CaptionCol\": 2} ]); // 모든 소계행의 Index 확인 console.log('subsumRows: ', mySheet.FindSubSumRow()); // Index가 2인 컬럼 기준 소계행의 Index 확인 console.log('subsumRows: ', mySheet.FindSubSumRow(2)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/FindSubSumRow.html"
          },
          {
            "cid": 582,
            "sid": "FindSumRow",
            "name": "FindSumRow",
            "label": "FindSumRow",
            "data": {
              "body": "> 합계 행의 Index를 확인 합니다. ### Syntax ```javascript ObjId.FindSumRow(); ``` ### Info ***none*** ### Returns ***합계 행의 Index를 구분자 `|`로 연결한 문자열*** ### Example ```javascript // 합계 행의 Index 확인 console.log('sumRows: ', mySheet.FindSumRow()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/FindSumRow.html"
          },
          {
            "cid": 583,
            "sid": "GetAutoSumPosition",
            "name": "GetAutoSumPosition",
            "label": "GetAutoSumPosition",
            "data": {
              "body": "> 합계 행의 표시 위치를 확인 합니다. `0` : 헤더 바로 아래인 최상단, `1` : 화면에 보이는 영역의 최하단 ### Syntax ```javascript ObjId.GetAutoSumPosition(); ``` ### Info ***none*** ### Returns ***Integer, 설정 값*** ### Example ```javascript // 합계행의 표시 위치 확인 console.log('position: ', mySheet.GetAutoSumPosition()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetAutoSumPosition.html"
          },
          {
            "cid": 584,
            "sid": "GetCumulateBackColor",
            "name": "GetCumulateBackColor",
            "label": "GetCumulateBackColor",
            "data": {
              "body": "> 누계 행의 배경 색상을 확인하거나 설정합니다. > 색상 설정은 WebColor 값을 사용하여 설정합니다. ### Syntax ```javascript ObjId.GetCumulateBackColor(); ``` ### Info ***none*** ### Returns ***String, 현재 누계 색상 값*** ### Example ```javascript // 누계 행의 배경색 확인 console.log(\"sumsumBackColor:\", mySheet.GetCumulateBackColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetCumulateBackColor.html"
          },
          {
            "cid": 585,
            "sid": "GetRedrawSum",
            "name": "GetRedrawSum",
            "label": "GetRedrawSum",
            "data": {
              "body": "> 합계 행에 대한 합계 자동 계산 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetRedrawSum(); ``` ### Info ***none*** ### Returns ***Boolean, 설졍 값*** ### Example ```javascript ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetRedrawSum.html"
          },
          {
            "cid": 586,
            "sid": "GetRowSumable",
            "name": "GetRowSumable",
            "label": "GetRowSumable",
            "data": {
              "body": "> 대상 행에 대한 합계 계산시 계산 포함 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetRowSumable(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Boolean, 설정 값*** ### Example ```javascript // Index가 2인 행에 대한 합계 계산 포함 여부 확인 console.log('sumable: ', mySheet.GetRowSumable(2)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetRowSumable.html"
          },
          {
            "cid": 587,
            "sid": "GetSubSumBackColor",
            "name": "GetSubSumBackColor",
            "label": "GetSubSumBackColor",
            "data": {
              "body": "> 소계 행의 배경 색상을 확인하거나 설정합니다. ### Syntax ```javascript ObjId.GetSubSumBackColor(index); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |index|`Number`|<span class=\"optional\">선택</span>|대상 행 index| ### Returns ***String, 현재 설정된 값*** ### Example ```javascript // 소계 행의 배경색 확인 console.log(\"sumsumBackColor:\", mySheet.GetSubSumBackColor()); // Index가 1인 n번째 소계 행의 배경색 확인 console.log(\"sumsumBackColor:\", mySheet.GetSubSumBackColor(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetSubSumBackColor.html"
          },
          {
            "cid": 588,
            "sid": "GetSubSumInfo",
            "name": "GetSubSumInfo",
            "label": "GetSubSumInfo",
            "data": {
              "body": "> 설정한 소계 정보를 확인 합니다. ### Syntax ```javascript ObjId.GetSubSumInfo(SaveName); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |SaveName|`Boolean`|<span class=\"required\">필수</span>|컬럼 정보를 SaveName으로 반환 여부| ### Returns ***Object*** |Name|Type|Description| |----|----|-----------| |result|`Array<object>`|소계정보 객체| |result.StdCol|`Number or String`|소계 기준컬럼| |result.SumCols|`String`|소계 대상 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결할 문자열| |result.AvgCols|`String`|소계 평균 대상 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결할 문자열| |result.Sort|`String`|기준컬럼의 Sort 처리 방식 - \"\" : 사용안함 - asc : 기준 컬럼에 대한 오름차순 정렬 - desc : 기준 컬럼에 대한 내림차순 정렬| |result.ShowCumulate|`Number`|누계 표시 여부| |result.CaptionCol|`Number or String`|소계 대표 글자인 \"소계:\" + 기준값을 설정할 컬럼의 Index 또는 SaveName| |result.CaptionText|`String`|소계 대표 글자 포맷| ### Example ```javascript // Index가 1인 컬럼, 2인 컬럼 기준의 다중 소계 표현 mySheet.ShowSubSum([ {\"StdCol\": 1, \"SumCols\": \"3|4|5\"} {\"StdCol\": 2, \"SumCols\": \"3|4|5\", \"CaptionCol\": 2} ]); // 소계 정보 확인 console.log('subsumInfo: ', mySheet.GetSubSumInfo()); // 소계 정보 확인 (SaveName 사용) console.log('subsumInfo: ', mySheet.GetSubSumInfo(1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetSubSumInfo.html"
          },
          {
            "cid": 589,
            "sid": "GetSumBackColor",
            "name": "GetSumBackColor",
            "label": "GetSumBackColor",
            "data": {
              "body": "> 합계 행의 배경색을 확인 합니다. ### Syntax ```javascript ObjId.GetSumBackColor(); ``` ### Info ***none*** ### Returns ***String, WebColor 값*** ### Example ```javascript // 합계 행의 배경색 확인 console.log(\"sumBackColor:\", mySheet.GetSumBackColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetSumBackColor.html"
          },
          {
            "cid": 590,
            "sid": "GetSumFontBold",
            "name": "GetSumFontBold",
            "label": "GetSumFontBold",
            "data": {
              "body": "> 합계 행의 폰트에 bold 적용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetSumFontBold(); ``` ### Info ***none*** ### Returns ***Boolean, 현재 폰트 굵기 여부*** ### Example ```javascript // 합계 행의 폰트에 bold 적용 여부 확인 console.log(\"fondBold:\", mySheet.GetSumFontBold()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetSumFontBold.html"
          },
          {
            "cid": 591,
            "sid": "GetSumFontColor",
            "name": "GetSumFontColor",
            "label": "GetSumFontColor",
            "data": {
              "body": "> 합계 행의 폰트 색상을 확인 합니다. 폰트 색상 설정이 없는 경우 `\"\"`으로 반환합니다. ### Syntax ```javascript ObjId.GetSumFontColor(); ``` ### Info ***none*** ### Returns ***String, 현재 합계행 글자 색상*** ### Example ```javascript // 합계 행의 폰트색상 확인 console.log(\"fontColor:\", mySheet.GetSumFontColor()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetSumFontColor.html"
          },
          {
            "cid": 592,
            "sid": "GetSumRowHidden",
            "name": "GetSumRowHidden",
            "label": "GetSumRowHidden",
            "data": {
              "body": "> 합계행의 숨김여부를 확인합니다. ### Syntax ```javascript ObjId.GetSumRowHidden(); ``` ### Info ***none*** ### Returns ***Boolean, 숨김 설정 값*** ### Example ```javascript // 합계행의 숨김 여부 확인 console.log('isHidden: ', mySheet.GetSumRowHidden()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetSumRowHidden.html"
          },
          {
            "cid": 593,
            "sid": "GetSumValue",
            "name": "GetSumValue",
            "label": "GetSumValue",
            "data": {
              "body": "> 합계 셀의 값을 Format이 적용되지 않은 형태로 확인 합니다. 합계행이 없는 경우에는 빈값을 반환합니다. ### Syntax ```javascript ObjId.GetSumValue(DataRow, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DataRow|`Number`|<span class=\"required\">필수</span>|단위 데이터행의 Index| |Col|`Long or String`|<span class=\"required\">필수</span>|합계 셀의 Column Index 또는 SaveName| ### Returns ***String, 합계 셀의 Value값*** ### Example ```javascript // 컬럼 index가 2인 합계 행의 셀의 value 확인 console.log(\"sumValue:\", mySheet.GetSumValue(0, 2)); // 컬럼 SaveName이 'sSalary'인 셀의 value 확인 console.log(\"sumValue:\", mySheet.GetSumValue(0, 'sSalary')); // 단위데이터행 Index가 1이고, 컬럼 index가 2인 합계 행의 셀의 value 확인 console.log(\"sumValue:\", mySheet.GetSumValue(1, 2)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/GetSumValue.html"
          },
          {
            "cid": 594,
            "sid": "HideSubSum",
            "name": "HideSubSum",
            "label": "HideSubSum",
            "data": {
              "body": "> 현재 표현되어있는 소계 및 누계행을 삭제 합니다. > stdCol 인자를 설정하지 않거나 빈값으로 설정한 경우 모든 소계 및 누계 행을 삭제 하고, 설정한 경우 해당 기준컬럼에 대한 소계 및 누계 행만 삭제합니다. (다중 소계 표현인 경우) ### Syntax ```javascript ObjId.HideSubSum([StdCol]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |StdCol|`Long or String`|<span class=\"optional\">선택</span>|소계를 표시한 기준 컬럼의 컬럼 Index 또는 SaveName (Default: \"\"(전체컬럼))| ### Returns ***none*** ### Example ```javascript // Index가 1인 컬럼, 2인 컬럼 기준의 다중 소계 표현 mySheet.ShowSubSum([ {\"StdCol\": 1, \"SumCols\": \"3|4|5\"} {\"StdCol\": 2, \"SumCols\": \"3|4|5\", \"CaptionCol\": 2} ]); // 모든 소계행 삭제 mySheet.HideSubSum(); // Index가 2인 컬럼 기준 소계만 삭제 mySheet.HideSubSum(2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/HideSubSum.html"
          },
          {
            "cid": 595,
            "sid": "SetAutoSumPosition",
            "name": "SetAutoSumPosition",
            "label": "SetAutoSumPosition",
            "data": {
              "body": "> 합계 행의 표시 위치를 설정 합니다. ### Syntax ```javascript ObjId.SetAutoSumPosition(Position); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Position|`Integer`|<span class=\"required\">필수</span>|합계행의 위치 값 - 0 : 상단고정 - 1 : 하단고정 (Default)| ### Returns ***none*** ### Example ```javascript // 합계행 상단고정 표시 mySheet.SetAutoSumPosition(0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetAutoSumPosition.html"
          },
          {
            "cid": 596,
            "sid": "SetCumulateBackColor",
            "name": "SetCumulateBackColor",
            "label": "SetCumulateBackColor",
            "data": {
              "body": "> 누계 행의 배경색을 설정 합니다. > 동적인 변경이 불필요한 경우 테마의 GMCumulateCell(메인테마 기준) css 클래스를 이용하여 설정하는 것을 권장 합니다. ### Syntax ```javascript ObjId.SetCumulateBackColor(color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |color|`String`|<span class=\"required\">필수</span>|누계 행의 배경색| ### Returns ***none*** ### Example ```javascript // 누계 행의 배경색을 'red'로 설정 mySheet.SetCumulateBackColor('red'); mySheet.SetCumulateBackColor('#ff0000'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetCumulateBackColor.html"
          },
          {
            "cid": 597,
            "sid": "SetRedrawSum",
            "name": "SetRedrawSum",
            "label": "SetRedrawSum",
            "data": {
              "body": "> 합계 행에 대한 합계 자동 계산 여부를 설정 합니다. > `0` 으로 설정하면 데이터 변경시 합계행에 대한 자동 계산을 하지 않고, 1로 설정 하는 시점에 자동 계산 처리를 합니다. > `SetCellValue` 등의 메소드를 통한 대량 셀 데이터 변경시 이 기능을 사용하여 성능을 향상 시킬 수 있습니다. > `주의` 해당 속성값을 0 으로 설정 후 반드시 1 로 다시 설정해야 합니다. ### Syntax ```javascript ObjId.SetRedrawSum(Redraw); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Redraw|`Object`|<span class=\"required\">필수</span>|합계행 계산 여부| ### Returns ***none*** ### Example ```javascript // 자동계산 false 설정 mySheet.SetRedrawSum(0) ; // 데이터 설정 for (var i = 1; i < 1000; i++) { mySheet.SetCellValue(i, 1, i, 0); } // 자동 계산 처리 mySheet.SetRedrawSum(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetRedrawSum.html"
          },
          {
            "cid": 598,
            "sid": "SetRowSumable",
            "name": "SetRowSumable",
            "label": "SetRowSumable",
            "data": {
              "body": "> 대상 행에 대한 합계 계산시 계산 포함 여부를 설정 합니다. ### Syntax ```javascript ObjId.SetRowSumable(Row, Sum); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행 Index| |Sum|`Boolean`|<span class=\"required\">필수</span>|합계 계산 포함 여부| ### Returns ***none*** ### Example ```javascript // Index가 2인 행에 대한 합계 계산시 제외 하도록 설정 mySheet.SetRowSumable(2, 0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetRowSumable.html"
          },
          {
            "cid": 599,
            "sid": "SetSubSumBackColor",
            "name": "SetSubSumBackColor",
            "label": "SetSubSumBackColor",
            "data": {
              "body": "> 소계 행의 배경색을 설정 합니다. > 동적인 변경이 불필요한 경우 테마의 GMSubSumCell(메인테마 기준) css 클래스를 이용하여 설정하는 것을 권장 합니다. ### Syntax ```javascript ObjId.SetSubSumBackColor(Color, Index); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Color|`String`|<span class=\"required\">필수</span>|설정하고자 하는 WebColor 값| |Index|`Number`|<span class=\"optional\">선택</span>|- 소계행이 여러개인 경우 원하는 n번째 소계행의 배경 색상을 지정 - 인자는 0부터 시작, 인자가 없으면 소계행 전체 적용| ### Returns ***none*** ### Example ```javascript // 소계 행의 배경색을 'red'로 설정 mySheet.SetSubSumBackColor('red'); mySheet.SetSubSumBackColor('#ff0000'); // 첫번째 소계그룹의 소계행 배경색을 'red' , 두번째 소계그룹의 소계행 색상은 노란색 설정 mySheet.SetSubSumBackColor('red',0); mySheet.SetSubSumBackColor('#ffff00',1); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.144|소계행이 여러 개일 때 원하는 위치의 소계행의 색상을 지정해줄 수 있는 Index Parameter 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.144|소계행이 여러 개일 때 원하는 위치의 소계행의 색상을 지정해줄 수 있는 Index Parameter 추가|"
            },
            "url": "docs/funcs/sum/SetSubSumBackColor.html"
          },
          {
            "cid": 600,
            "sid": "SetSumBackColor",
            "name": "SetSumBackColor",
            "label": "SetSumBackColor",
            "data": {
              "body": "> 합계 행의 배경색을 설정 합니다. > 동적인 변경이 불필요한 경우 테마의 GMSumCell(메인테마 기준) css 클래스를 이용하여 설정하는 것을 권장합니다. ### Syntax ```javascript ObjId.SetSumBackColor(Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Color|`String`|<span class=\"required\">필수</span>|합계행의 배경색| ### Returns ***none*** ### Example ```javascript // 합계 행의 배경색을 'red'로 설정 mySheet.SetSumBackColor('red'); mySheet.SetSumBackColor('#ff0000'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetSumBackColor.html"
          },
          {
            "cid": 601,
            "sid": "SetSumFontBold",
            "name": "SetSumFontBold",
            "label": "SetSumFontBold",
            "data": {
              "body": "> 합계 행의 폰트에 bold 적용 여부를 설정합니다. > 동적인 변경이 불필요한 경우 테마의 GMSumCell(메인테마 기준) css 클래스를 이용하여 설정하는 것을 권장합니다. ### Syntax ```javascript ObjId.SetSumFontBold(Bold); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Bold|`Boolean`|<span class=\"required\">필수</span>|폰트 굵기 여부| ### Returns ***none*** ### Example ```javascript // 합계 행의 폰트에 bold 적용 mySheet.SetSumFontBold(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetSumFontBold.html"
          },
          {
            "cid": 602,
            "sid": "SetSumFontColor",
            "name": "SetSumFontColor",
            "label": "SetSumFontColor",
            "data": {
              "body": "> 합계 행의 폰트 색상을 설정합니다. > 동적인 변경이 불필요한 경우 테마의 GMSumCell(메인테마 기준) css 클래스를 이용하여 설정하는 것을 권장합니다. ### Syntax ```javascript ObjId.SetSumFontColor(Color); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Color|`String`|<span class=\"required\">필수</span>|설정할 폰트 색상| ### Returns ***none*** ### Example ```javascript // 합계 행의 폰트 색상을 'red'로 설정 mySheet.SetSumFontColor('red'); mySheet.SetSumFontColor('#ff0000'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetSumFontColor.html"
          },
          {
            "cid": 603,
            "sid": "SetSumRowHidden",
            "name": "SetSumRowHidden",
            "label": "SetSumRowHidden",
            "data": {
              "body": "> 합계 행의 숨김 여부를 설정합니다. ### Syntax ```javascript ObjId.SetSumRowHidden(Hidden); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Hidden|`Boolean`|<span class=\"required\">필수</span>|숨김여부| ### Returns ***none*** ### Example ```javascript // 조회 완료 후 조회 데이터가 없으면 합계행을 숨김 처리 한다. function mySheet_OnSearchEnd() { if (mySheet.RowCount() > 0) { mySheet.SetSumRowHidden(0); } else { mySheet.SetSumRowHidden(1); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetSumRowHidden.html"
          },
          {
            "cid": 604,
            "sid": "SetSumValue",
            "name": "SetSumValue",
            "label": "SetSumValue",
            "data": {
              "body": "> 합계 셀의 값을 설정 합니다. > `참고` 데이터타입이 `AutoSum`인 컬럼의 합계 셀은 자동 산출 대상 셀이기 때문에 설정이 불가능 합니다. ### Syntax ```javascript ObjId.SetSumValue(DataRow, Col, Value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |DataRow|`Number`|<span class=\"required\">필수</span>|단위 데이터행의 Index| |Col|`Long or String`|<span class=\"required\">필수</span>|합계 셀의 Column Index 또는 SaveName| |Value|`Number or String`|<span class=\"required\">필수</span>|포맷 적용 안된 형태의 CellValue 값| ### Returns ***none*** ### Example ```javascript // 합계행의 첫번째 셀에 '합 계 : ' 문자열 설정 mySheet.SetSumValue(0, 0, '합 계 : '); // 합계행의 첫번째 셀에 '합\\n계' 문자열 설정 후 시트 렌더링 mySheet.SetSumValue(0, 0, '합\\n계'); mySheet.RenderSheet(2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/SetSumValue.html"
          },
          {
            "cid": 605,
            "sid": "ShowSubSum",
            "name": "ShowSubSum",
            "label": "ShowSubSum",
            "data": {
              "body": "> 특정 컬럼의 데이터를 기준으로 소계와 누계를 계산하여 표시합니다. > 이 메소드는 데이터를 조회하는 메소드를 호출하기 이전에 호출하여야 하며, 설정을 변경한 경우 다시 데이터를 조회해야 적용 됩니다. > `제약사항` 단위데이터행, 트리구조, 서버페이징 모드에서는 지원하지 않습니다. ### Syntax ```javascript ObjId.ShowSubSum([opt]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |opt|`Object`|<span class=\"required\">필수</span>|설정 옵션| |opt.StdCol|`Number orString` <span class=\"required\">필수</span>|기준 컬럼 Index 또는 SaveName| |opt.SumCols|`String`|<span class=\"required\">필수</span>|소계가 계산되어야 할 컬럼 Index를 `|`로 연결한 문자열| |opt.Sort|`String`|<span class=\"optional\">선택</span>|기준 컬럼의 Sort 처리 방식 - `\"\"` : 사용 안함 - `asc` : 오름차순 정렬 - `desc` : 내림차순 정렬| |opt.ShowCumulate|`Boolean`|<span class=\"optional\">선택</span>|소계에 대한 누계 표시 여부 (Default: 0)| |opt.CaptionCol|`Long`| <span class=\"optional\">선택</span>|소계 대표 글자인 \"소계:\" + 기준값을 설정할 컬럼 (Default: 숨겨지지 않은 첫컬럼)| |opt.CaptionText|`String`|<span class=\"optional\">선택</span>|소계 대표 글자 포맷 소계(누계)를 의미하는 %s 예약어와 기준값을 의미하는 %col 예약을 이용하여 소계 대표 글자 출력 포맷을 설정 - 설정 예제 : [%s] %col - 출력: [소계] 기준컬럼의 값| |opt.AvgCols|`String`|<span class=\"optional\">선택</span>|소계 행에 평균으로 계산되어야 할 컬럼 Index를 `|`로 연결한 문자열 (Defuault: \"\")| |opt.CntCol|`String`|<span class=\"optional\">선택</span>|소계 행에 건수 표현할 컬럼의 Index 혹은 SaveName| |opt.Position|`String`|<span class=\"optional\">선택</span>|소계행 생성 위치 설정 - `bottom` : 그룹 하단 표시 - `top` : 그룹 상단 표시 - `bottomAll` : 최하단 표시 - `topAll` : 최상단 표시| |opt.OtherColText|`String`|<span class=\"optional\">선택</span>|CaptionCol 이외의 컬럼에 설정할 글자를 `;`으로 연결한 문자열 (Default: \"\") |opt.Mode|`Number`|<span class=\"optional\">선택</span>|소계행 표시 방법 - `0` : 모든 대상 그룹에 대한 소계행 표시 - `1` : 대상 그룹이 2개 이상인 그룹에 대해서만 소계행 표시| ### Returns ***none*** ### Example ```javascript // Index가 1인 컬럼을 기준으로 소계 표현 mySheet.ShowSubSum([ {\"StdCol\": 1, \"SumCols\": \"3|4|5\"} ]); // 누계 표시 mySheet.ShowSubSum([ {\"StdCol\": 1, \"SumCols\": \"3|4|5\", \"ShowCumulate\": 1} ]); // Index가 1인 컬럼, 2인 컬럼 기준의 다중 소계 표현 mySheet.ShowSubSum([ {\"StdCol\": 1, \"SumCols\": \"3|4|5\"} {\"StdCol\": 2, \"SumCols\": \"3|4|5\", \"CaptionCol\": 2} ]); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.12|Sort 속성의 타입 변경 및 오름차순 내림차순 설정 지원| |7.0.13.38|Position 속성 추가 소계 후 컬럼 Sort 기능 지원| |7.0.13.40|OtherColText 속성 추가| |7.0.13.51|Mode 속성 추가| |7.0.13.163|CntCol 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.13.12|Sort 속성의 타입 변경 및 오름차순 내림차순 설정 지원||7.0.13.38|Position 속성 추가<br>소계 후 컬럼 Sort 기능 지원||7.0.13.40|OtherColText 속성 추가||7.0.13.51|Mode 속성 추가||7.0.13.163|CntCol 속성 추가|"
            },
            "url": "docs/funcs/sum/ShowSubSum.html"
          },
          {
            "cid": 606,
            "sid": "_isSubSumCalcCell",
            "name": "_isSubSumCalcCell",
            "label": "_isSubSumCalcCell",
            "data": {
              "body": "> 소계, 누계행에서 대상 셀이 자동 계산 셀인지 여부를 반환 합니다. ### Syntax ```javascript ObjId._isSubSumCalcCell(Row, Col); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Object`|<span class=\"required\">필수</span>|대상 행 객체| |Col|`String`|<span class=\"required\">필수</span>|대상 컬럼명| ### Returns ***Boolean, 자동계산 셀 여부*** ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/sum/_isSubSumCalcCell.html"
          }
        ]
      },
      {
        "gid": 16,
        "name": "funcs-tree",
        "label": "tree",
        "children": [
          {
            "cid": 607,
            "sid": "GetAllowExpand",
            "name": "GetAllowExpand",
            "label": "GetAllowExpand",
            "data": {
              "body": "> 트리 노드의 펼치기/닫기에 대한 허용 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetAllowExpand(); ``` ### Info ***none*** ### Returns ***Boolean, 설정 값*** ### Example ```javascript // 펼치기/닫기에 대한 허용 여부 확인 console.log('allowExpand: ', mySheet.GetAllowExpand()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetAllowExpand.html"
          },
          {
            "cid": 608,
            "sid": "GetChildNodeCount",
            "name": "GetChildNodeCount",
            "label": "GetChildNodeCount",
            "data": {
              "body": "> 트리구조에서 대상 행의 바로 다음 레벨의 자식 행의 개수를 확인 합니다. ### Syntax ```javascript ObjId.GetChildNodeCount(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Integer, 하위 노드의 개수*** ### Example ```javascript // Index가 4인 행의 자식 노드 개수 확인 console.log('childRowCount: ', mySheet.GetChildNodeCount(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetChildNodeCount.html"
          },
          {
            "cid": 609,
            "sid": "GetChildRows",
            "name": "GetChildRows",
            "label": "GetChildRows",
            "data": {
              "body": "> 대상 행의 특정 레벨까지의 자식행을 확인 합니다. > MaxLevel 인자를 설정하지 않는 경우 모든 자식 행에 대해서 처리 합니다. ### Syntax ```javascript ObjId.GetChildRows(Row, [MaxLevel]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |MaxLevel|`Integer`|<span class=\"optional\">선택</span>|확인할 자식행의 제한 레벨 (Default: -1) -1인 경우 모든 자식행을 의미| ### Returns ***String, 대상 자식행들의 문자열 조합*** ### Example ```javascript // Index가 4인 행의 모든 자식 행 Index 확인 console.log('childRows: ', mySheet.GetChildRows(4)); // 자기 자신의 레벨 기준 +2 레벨까지 확인 console.log('childRows: ', mySheet.GetChildRows(4, mySheet.GetRowLevel() + 2)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetChildRows.html"
          },
          {
            "cid": 610,
            "sid": "GetFirstChildRow",
            "name": "GetFirstChildRow",
            "label": "GetFirstChildRow",
            "data": {
              "body": "> 대상 행의 첫번째 자식 행을 확인 합니다. ### Syntax ```javascript ObjId.GetFirstChildRow(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Long, 첫번째 자식 행의 Index*** ### Example ```javascript // Index가 4인 행의 첫번째 자식행의 Index 확인 console.log('firstChild: ', mySheet.GetFirstChildRow(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetFirstChildRow.html"
          },
          {
            "cid": 611,
            "sid": "GetLastChildRow",
            "name": "GetLastChildRow",
            "label": "GetLastChildRow",
            "data": {
              "body": "> 대상 행의 마지막 자식 행을 확인 합니다. ### Syntax ```javascript ObjId.GetLastChildRow(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Long, 마지막 자식 행의 Index*** ### Example ```javascript // Index가 4인 행의 마지막 자식행의 Index 확인 console.log('lastChild: ', mySheet.GetLastChildRow(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetLastChildRow.html"
          },
          {
            "cid": 612,
            "sid": "GetNextSiblingRow",
            "name": "GetNextSiblingRow",
            "label": "GetNextSiblingRow",
            "data": {
              "body": "> 대상 행의 동일 부모, 동일 레벨 상에서의 다음 행을 확인 합니다. ### Syntax ```javascript ObjId.GetNextSiblingRow(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Number, 다음 행의 Index*** ### Example ```javascript // Index가 4인 행의 동일 부모, 동일 레벨 상에서의 다음 행 확인 console.log('nextRow: ', mySheet.GetNextSiblingRow(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetNextSiblingRow.html"
          },
          {
            "cid": 613,
            "sid": "GetParentRow",
            "name": "GetParentRow",
            "label": "GetParentRow",
            "data": {
              "body": "> 대상 행의 바로 이전 레벨의 부모 행 Index를 확인 합니다. ### Syntax ```javascript ObjId.GetParentRow(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Long, 부모 행의 Index*** ### Example ```javascript // Index가 4인 행의 부모행 확인 console.log('parentRow: ', mySheet.GetParentRow(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetParentRow.html"
          },
          {
            "cid": 614,
            "sid": "GetPrevSiblingRow",
            "name": "GetPrevSiblingRow",
            "label": "GetPrevSiblingRow",
            "data": {
              "body": "> 대상 행의 동일 부모, 동일 레벨 상에서의 이전 행을 확인 합니다. ### Syntax ```javascript ObjId.GetPrevSiblingRow(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Long, 동일 레벨상 이전 행의 Index*** ### Example ```javascript // 6번째 행의 동일레벨 상의 이전 행을 확인 var previous = mySheet.GetPrevSiblingRow(6); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetPrevSiblingRow.html"
          },
          {
            "cid": 615,
            "sid": "GetRowExpanded",
            "name": "GetRowExpanded",
            "label": "GetRowExpanded",
            "data": {
              "body": "> 대상 행의 자식 노드의 펼침 여부를 확인 합니다. ### Syntax ```javascript ObjId.GetRowExpanded(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Boolean, 행의 자식행들의 펼쳐짐 여부*** ### Example ```javascript // Index가 4인 행의 자식 노드 펼침 여부 확인 console.log('expaned: ', mySheet.GetRowExpanded(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetRowExpanded.html"
          },
          {
            "cid": 616,
            "sid": "GetRowLevel",
            "name": "GetRowLevel",
            "label": "GetRowLevel",
            "data": {
              "body": "> 대상 행의 트리 레벨을 확인 합니다. ### Syntax ```javascript ObjId.GetRowLevel(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Integer, 현재 행의 트리 레벨*** ### Example ```javascript // Index가 4인 행의 트리 레벨 확인 console.log('treeLevel: ', mySheet.GetRowLevel(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetRowLevel.html"
          },
          {
            "cid": 617,
            "sid": "GetTreeActionMode",
            "name": "GetTreeActionMode",
            "label": "GetTreeActionMode",
            "data": {
              "body": "> 트리구조에서 부모-자식 행간 삭제 체크시의 동작 방법을 확인 합니다. > - 0 : 자식이 있으면 삭제 상태로 변경 불가, 부모가 삭제이면 삭제 취소 불가 (Default) > - 1 : 삭제 선택시 자식 행까지 모두 삭제 상태로 변경 ### Syntax ```javascript ObjId.GetTreeActionMode(); ``` ### Info ***none*** ### Returns ***Integer, 설정 값*** ### Example ```javascript // 부모-자식 행간 삭제 체크시의 동작 방법을 확인 console.log(\"treeActionMode:\", mySheet.GetTreeActionMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetTreeActionMode.html"
          },
          {
            "cid": 618,
            "sid": "GetTreeCheckActionMode",
            "name": "GetTreeCheckActionMode",
            "label": "GetTreeCheckActionMode",
            "data": {
              "body": "> 트리 기준 컬럼의 CheckBox에 대한 부모-자식 행간 동작 방법을 확인 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 ### Syntax ```javascript ObjId.GetTreeCheckActionMode(); ``` ### Info ***none*** ### Returns ***Number, 현재 설정 값*** ### Example ```javascript // 트리 기준 컬럼의 CheckBox에 대한 부모-자식 행간 동작 방법 확인 console.log('mode: ', mySheet.GetTreeCheckActionMode()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetTreeCheckActionMode.html"
          },
          {
            "cid": 619,
            "sid": "GetTreeCheckEditable",
            "name": "GetTreeCheckEditable",
            "label": "GetTreeCheckEditable",
            "data": {
              "body": "> 트리 기준 컬럼의 CheckBox에 대한 편집 가능 여부를 확인 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 ### Syntax ```javascript ObjId.GetTreeCheckEditable(); ``` ### Info ***none*** ### Returns ***Boolean, 컬럼단위 체크박스의 편집 가능 여부*** ### Example ```javascript // 트리 기준컬럼의 CheckBox에 대한 편집 가능 여부 확인 console.log('editable: ', mySheet.GetTreeCheckEditable()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetTreeCheckEditable.html"
          },
          {
            "cid": 620,
            "sid": "GetTreeCheckRowEditable",
            "name": "GetTreeCheckRowEditable",
            "label": "GetTreeCheckRowEditable",
            "data": {
              "body": "> 대상 행의 트리 기준 컬럼 CheckBox에 대한 편집 가능 여부를 확인 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 ### Syntax ```javascript ObjId.GetTreeCheckRowEditable(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Boolean, 컬럼단위 체크박스의 편집 가능 여부*** ### Example ```javascript // Index가 4인 트리 기준컬럼 CheckBox에 대한 편집 가능 여부 확인 console.log('editable: ', mySheet.GetTreeCheckRowEditable(4)); ``` ### Since |version|desc| |---|---| |7.0.9.0||",
              "since": "|version|desc||---|---||7.0.9.0||"
            },
            "url": "docs/funcs/tree/GetTreeCheckRowEditable.html"
          },
          {
            "cid": 621,
            "sid": "GetTreeCheckValue",
            "name": "GetTreeCheckValue",
            "label": "GetTreeCheckValue",
            "data": {
              "body": "> 트리 기준 컬럼의 CheckBox 값을 확인 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 ### Syntax ```javascript ObjId.GetTreeCheckValue(Row); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| ### Returns ***Boolean, 해당 체크박스의 값*** ### Example ```javascript // Index가 4인 행의 트리 기준컬럼에 대한 체크값 확인 console.log('checkValue: ', mySheet.GetTreeCheckValue(4)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetTreeCheckValue.html"
          },
          {
            "cid": 622,
            "sid": "GetTreeCol",
            "name": "GetTreeCol",
            "label": "GetTreeCol",
            "data": {
              "body": "> 트리 기준 컬럼을 확인 합니다. ### Syntax ```javascript ObjId.GetTreeCol(); ``` ### Info ***none*** ### Returns ***Number, 트리 기준 컬럼의 Index*** ### Example ```javascript // 트리 기준 컬럼의 Index 확인 console.log('treeCol: ', mySheet.GetTreeCol()); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetTreeCol.html"
          },
          {
            "cid": 623,
            "sid": "GetTreeJson",
            "name": "GetTreeJson",
            "label": "GetTreeJson",
            "data": {
              "body": "> 트리 구조의 시트 데이터를 계층 구조 형태의 Json 객체로 반환 합니다. ### Syntax ```javascript ObjId.GetTreeJson(opt); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |opt|`Object`|<span class=\"optional\">선택</span>|조회 처리 옵션| |opt.ChildPropName|`String`|<span class=\"optional\">선택</span>|자식 노드를 담을 속성명| ### Returns ***Object, 시트의 데이터에 대한 계층 구조형태의 Json 객체*** ### Example ```javascript // 시트의 데이터를 계층 구조 형태의 Json 객체로 반환 var data = mySheet.GetTreeJson(); console.log('data: ', data); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/GetTreeJson.html"
          },
          {
            "cid": 624,
            "sid": "IsHaveChild",
            "name": "IsHaveChild",
            "label": "IsHaveChild",
            "data": {
              "body": "> 대상 행에 자식 행이 존재하는지 여부를 확인 합니다. ### Syntax ```javascript ObjId.IsHaveChild(Row, [IncludeDelRow]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |IncludeDelRow|`Boolean`|<span class=\"optional\">선택</span>|Child 레벨의 행 중 \"삭제\" 상태의 행을 포함할것인가 여부 (Default: 0)| ### Returns ***Boolean, Child행의 존재 여부*** ### Example ```javascript // Index가 4인 행의 자식 행 존재 여부 확인 console.log('haveChild: ', mySheet.IsHaveChild(4)); // 삭제행까지 포함하여 자식 행 존재 여부 확인 console.log('haveChild: ', mySheet.IsHaveChild(4, 1)); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/IsHaveChild.html"
          },
          {
            "cid": 625,
            "sid": "SetAllowExpand",
            "name": "SetAllowExpand",
            "label": "SetAllowExpand",
            "data": {
              "body": "> 트리 노드의 펼치기/닫기에 대한 허용 여부를 설정 합니다. > 이 기능은 설정 값이 지속성을 갖지 않고, 1회성으로 처리 되며, 일반적으로 `OnBeforeExpand` 이벤트에서 특정 조건에 따라 펼치기/닫기에 대한 제한을 두고자 할 때 사용 합니다. ### Syntax ```javascript ObjId.SetAllowExpand(expand); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |expand|`Boolean`|<span class=\"required\">필수</span>|펼치기/닫기에 대한 허용 여부| ### Returns ***none*** ### Example ```javascript function mySheet_OnBeforeExpand(row, expand) { // Index가 1인 행에 대한 접기 제한 처리 if (row === 1 && expand === 2) { mySheet.SetAllowExpand(0); } } ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/SetAllowExpand.html"
          },
          {
            "cid": 626,
            "sid": "SetRowExpanded",
            "name": "SetRowExpanded",
            "label": "SetRowExpanded",
            "data": {
              "body": "> 대상 행의 자식 노드의 펼침 여부를 설정 합니다. > `event` 인자를 `0`으로 설정 하는 경우 펼침 또는 닫힘 처리시 OnBeforeExpaned, OnAfterExpaned 이벤트가 발생하지 않습니다. ### Syntax ```javascript ObjId.SetRowExpanded(Row, Expand, [Event]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |Expand|`Boolean`|<span class=\"required\">필수</span>|자식 행의 펼쳐짐 여부| |Event|`Boolean`|<span class=\"optional\">선택</span>|관련 이벤트 발생 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // Index가 4인 행의 자식 노드를 펼침으로 설정 mySheet.SetRowExpanded(4, 1); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.4.2|Set 메소드의 이벤트 발생여부 인자 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.4.2|Set 메소드의 이벤트 발생여부 인자 추가|"
            },
            "url": "docs/funcs/tree/SetRowExpanded.html"
          },
          {
            "cid": 627,
            "sid": "SetRowHaveChildValue",
            "name": "SetRowHaveChildValue",
            "label": "SetRowHaveChildValue",
            "data": {
              "body": "> 대상 행의 HaveChild 속성을 설정 합니다. > `HaveChild` 속성은 자식 노드에 대한 데이터를 실제 가지고 있지 않고, 자식 노드 펼치기시 동적으로 자식 노드의 데이터를 로드 할때 사용 하는 속성입니다. > 일반적으로 조회시 조회 데이터 속성으로 설정하여 사용하고, 이 후 동적으로 변경이 필요한 경우 이 기능을 사용 합니다. ### Syntax ```javascript ObjId.SetRowHaveChildValue(Row, HaveChild); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |HaveChild|`Boolean`|<span class=\"required\">필수</span>|속성 설정값| ### Returns ***none*** ### Example ```javascript // Index가 4인 행의 HaveChild 속성을 0으로 변경 mySheet.SetRowHaveChildValue(4, 0); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/SetRowHaveChildValue.html"
          },
          {
            "cid": 628,
            "sid": "SetRowLevel",
            "name": "SetRowLevel",
            "label": "SetRowLevel",
            "data": {
              "body": "> 대상 행의 트리 레벨을 설정 합니다. > 이 기능은 자식 행이 없는 경우에만 설정 할 수 있으며, 현재 레벨 기준 +1 또는 -1 레벨로 설정 할 수 있습니다. > +1 레벨로 설정 하는 경우 대상 행은 이전 행의 자식 행으로 포함 되고, -1 레벨로 설정 하는 경우 대상 행은 다음 행의 레벨 보다 작은 경우 다음 행의 부모 행으로 됩니다. ### Syntax ```javascript ObjId.SetRowLevel(Row,Level); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |Level|`Integer`|<span class=\"required\">필수</span>|해당 행의 트리 레벨값| ### Returns ***none*** ### Example ```javascript // Index가 4인 행의 트리 레벨을 2로 설정 mySheet.SetRowLevel(4, 2); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/SetRowLevel.html"
          },
          {
            "cid": 629,
            "sid": "SetTreeActionMode",
            "name": "SetTreeActionMode",
            "label": "SetTreeActionMode",
            "data": {
              "body": "> 트리구조에서 부모-자식 행간 삭제 체크시의 동작 방법을 설정 합니다. ### Syntax ```javascript ObjId.SetTreeActionMode(Value); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Value|`Integer`|<span class=\"required\">필수</span>|TreeActionMode 값 - 0 : 자식 행이 있으면 삭제 상태로 변경 불가, 부모 행이 삭제 상태이면 삭제 취소 불가 - 1 : 삭제 선택시 자식 행까지 모두 삭제 상태로 변경| ### Returns ***none*** ### Example ```javascript // 삭제 선택시 자식행까지 모두 삭제 상태로 변경하도록 설정 mySheet.SetTreeActionMode(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/SetTreeActionMode.html"
          },
          {
            "cid": 630,
            "sid": "SetTreeCheckActionMode",
            "name": "SetTreeCheckActionMode",
            "label": "SetTreeCheckActionMode",
            "data": {
              "body": "> 트리 기준 컬럼의 CheckBox에 대한 부모-자식 행간 동작 방법을 설정 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 ### Syntax ```javascript ObjId.SetTreeCheckActionMode(Mode); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Mode|`Number`|<span class=\"required\">필수</span>|설정 모드 값 - 0 : 별도 처리 없이 독립적으로 사용 (일반) - 1 : 편집가능한 CheckBox에 대해서 아래와 같이 처리 (관계모드) - 2 : 모든 CheckBox에 대해서 아래와 같이 처리 (관계모드 : Force) * CheckBox 값이 변경시 모든 자식행의 CheckBox에 동일한 값으로 변경 처리 * 자식행의 CheckBox 값이 1개 이상 체크된 경우 해당 부모행의 CheckBox 체크 처리 * 모든 자식행의 CheckBox 값이 언체크 인 경우 해당 부모행의 CheckBox 언체크 처리| ### Returns ***none*** ### Example ```javascript // 트리 기준 컬럼의 CheckBox에 대한 부모-자식 행간 동작 방법을 '관계모드'로 설정 mySheet.GetTreeCheckActionMode(1); ``` ### Since |version|desc| |---|---| |7.0.9.0||",
              "since": "|version|desc||---|---||7.0.9.0||"
            },
            "url": "docs/funcs/tree/SetTreeCheckActionMode.html"
          },
          {
            "cid": 631,
            "sid": "SetTreeCheckEditable",
            "name": "SetTreeCheckEditable",
            "label": "SetTreeCheckEditable",
            "data": {
              "body": "> 트리 기준 컬럼의 CheckBox에 대한 편집 가능 여부를 설정 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 ### Syntax ```javascript ObjId.SetTreeCheckEditable(Edit); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Edit|`Boolean`|<span class=\"required\">필수</span>|체크박스의 편집 가능 여부| ### Returns ***none*** ### Example ```javascript // 트리 기준컬럼의 CheckBox에 대한 편집이 가능하도록 설정 mySheet.SetTreeCheckEditable(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/SetTreeCheckEditable.html"
          },
          {
            "cid": 632,
            "sid": "SetTreeCheckRowEditable",
            "name": "SetTreeCheckRowEditable",
            "label": "SetTreeCheckRowEditable",
            "data": {
              "body": "> 대상 행의 트리 기준 컬럼 CheckBox에 대한 편집 가능 여부를 설정 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 ### Syntax ```javascript ObjId.SetTreeCheckRowEditable(Row, Edit); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |Edit|`Boolean`|<span class=\"required\">필수</span>|체크박스의 편집 가능 여부| ### Returns ***none*** ### Example ```javascript // Index가 4인 트리 기준컬럼 CheckBox에 대한 편집이 가능하도록 설정 mySheet.SetTreeCheckRowEditable(4, 1); ``` ### Since |version|desc| |---|---| |7.0.9.0||",
              "since": "|version|desc||---|---||7.0.9.0||"
            },
            "url": "docs/funcs/tree/SetTreeCheckRowEditable.html"
          },
          {
            "cid": 633,
            "sid": "SetTreeCheckValue",
            "name": "SetTreeCheckValue",
            "label": "SetTreeCheckValue",
            "data": {
              "body": "> 트리 기준 컬럼의 CheckBox 값을 설정 합니다. > 트리 기준 컬럼에서 CheckBox를 사용하고자 하는 경우 [InitColumns](/docs/funcs/init/InitColumns) 메소드의 `TreeCheck` 속성을 참고 합니다. ### Syntax ```javascript ObjId.SetTreeCheckValue(Row, Value, Event); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |Value|`Boolean`|<span class=\"required\">필수</span>|체크박스 설정 값| |Event|`Boolean`|<span class=\"optional\">선택</span>|설정시 `OnTreeCheckChange` 이벤트 발생 여부 (Default: 1)| ### Returns ***none*** ### Example ```javascript // Index가 4인 행의 트리 기준컬럼 CheckBox 체크 처리 mySheet.SetTreeCheckValue(4, 1); ``` ### Since |version|desc| |---|---| |7.0.9.0||",
              "since": "|version|desc||---|---||7.0.9.0||"
            },
            "url": "docs/funcs/tree/SetTreeCheckValue.html"
          },
          {
            "cid": 634,
            "sid": "ShowTreeLevel",
            "name": "ShowTreeLevel",
            "label": "ShowTreeLevel",
            "data": {
              "body": "> 트리 구조에서 자식 노드를 펼쳐서 보이게 할 레벨을 설정 합니다. ### Syntax ```javascript ObjId.ShowTreeLevel([Level], [ChildStatus]); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Level|`Integer`|<span class=\"optional\">선택</span>|보여질 트리 레벨 수준 - -1 : 모두 펼치기 (Default) - -0 : 모두 접기 - {number} : 해당 레벨까지 펼치기| |ChildStatus|`Integer`|<span class=\"optional\">선택</span>|보여질 트리 레벨 이하 레벨의 펼침 상태를 설정 - 0 : 이전 상태 유지 - 1 : 모두 접기 - 2 : 모두 펼치기| ### Returns ***none*** ### Example ```javascript // 모든 트리 노드 접기 mySheet.ShowTreeLevel(0, 1); // 모든 트리 노드 펼치기 mySheet.ShowTreeLevel(-1, 2); // 1레벨의 트리 노드 까지 펼치기 mySheet.ShowTreeLevel(1); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/ShowTreeLevel.html"
          },
          {
            "cid": 635,
            "sid": "ShowTreeSubSum",
            "name": "ShowTreeSubSum",
            "label": "ShowTreeSubSum",
            "data": {
              "body": "> 자식 노드의 대한 소계를 계산하여 부모 노드에 계산 결과를 표시 합니다. > 설정을 변경하는 경우 재조회를 해야 해당 계산결과가 정상적으로 적용 됩니다. > 계산 결과를 표시하는 셀에 데이터가 있는 경우 해당 값은 무시되고 계산 결과 값이 표시 됩니다. ### Syntax ```javascript ObjId.ShowTreeSubSum(Info); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |Info|`Object`|<span class=\"required\">필수</span>|설정 옵션| |Info.SumCols|`String`|<span class=\"optional\">선택</span>|합계가 계산되어야 할 컬럼의 Index또는 SaveName을 `|`로 연결한 문자열 (Defuault: \"\")| |Info.AvgCols|`String`|<span class=\"optional\">선택</span>|평균이 계산되어야 할 컬럼의 Index 또는 SaveName을 `|`로 연결한 문자열 (Defuault: \"\")| |Info.CountCols|`String`|<span class=\"optional\">선택</span>|개수가 계산되어야 할 컬럼의 Index 또는 SaveName을 `|`로 연결한 문자열 (Default: \"\")| |Info.MaxCols|`String`|<span class=\"optional\">선택</span>|최대값이 계산되어야 할 컬럼의 Index 또는 SaveName을 `|`로 연결한 문자열 (Default: \"\")| |Info.MinCols|`String`|<span class=\"optional\">선택</span>|최소값이 계산되어야 할 컬럼의 Index 또는 SaveName을 `|`로 연결한 문자열 (Default: \"\")| |Info.SumEx|`Boolean`|<span class=\"optional\">선택</span>|상태값이 \"삭제\"인 행에 대한 계산 포함 여부 (Default: 0)| |Info.ExceptNull|`Boolean`|<span class=\"optional\">선택</span>|평균 컬럼에서 Null 값 포함 계산 여부 (Default: 0)| ### Returns ***none*** ### Example ```javascript // Index가 2 와 3인 컬럼에 대한 소계 표현 mySheet.ShowTreeSubSum({ \"SumCols\": \"2|3\" }); // SaveName이 'sSalary 와 'sWorkDay'인 컬럼에 대한 소계 표현 mySheet.ShowTreeSubSum({ \"SumCols\": \"sSalary|sWorkDay\" }); ``` ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.12.0|MaxCols, MinCols 인자 속성 추가|",
              "since": "|version|desc||---|---||7.0.0.0|||7.0.12.0|MaxCols, MinCols 인자 속성 추가|"
            },
            "url": "docs/funcs/tree/ShowTreeSubSum.html"
          },
          {
            "cid": 636,
            "sid": "TreeChildSort",
            "name": "TreeChildSort",
            "label": "TreeChildSort",
            "data": {
              "body": "> 대상 행의 자식 행들에 대한 Sort 처리를 합니다. ### Syntax ```javascript ObjId.TreeChildSort(row, col, sortOrder); ``` ### Info |Parameter|Type|Required|Description| |---------|----|--------|-----------| |row|`Long`|<span class=\"required\">필수</span>|대상 행의 Index| |col|`Long or String`|<span class=\"required\">필수</span>|Sort 기준 컬럼의 Index 또는 SaveName을 구분자 `|`로 연결한 문자열| |sortOrder|`String`|<span class=\"optional\">선택</span>|Sort 기준 컬럼에 대한 Sort 정렬 방식을 구분자 `|`로 연결한 문자열 - `asc` : 기준 컬럼에 대한 오름차순 정렬 (Default) - `desc` : 기준 컬럼에 대한 내림차순 정렬| ### Returns ***none*** ### Example ```javascript // Index가 4인 행의 자식 행들을 Index가 2인 컬럼을 기준 정렬 처리 mySheet.TreeChildSort(4, 2, 'asc'); // Index가 4인 행의 자식 행들을 Index가 2(asc)와 3(desc)인 컬럼을 기준 정렬 처리 mySheet.TreeChildSort(4, '2|3', 'asc|desc'); ``` ### Since |version|desc| |---|---| |7.0.0.0||",
              "since": "|version|desc||---|---||7.0.0.0||"
            },
            "url": "docs/funcs/tree/TreeChildSort.html"
          }
        ]
      }
    ]
  },
  {
    "gid": 5,
    "name": "static",
    "label": "DataStructure",
    "children": [
      {
        "gid": 1,
        "name": "static-XML",
        "label": "XML",
        "children": [
          {
            "cid": 637,
            "sid": "data1",
            "name": "data1",
            "label": "조회 DATA 요소",
            "data": {
              "body": "> 조회된 데이터 영역을 의미하는 요소로 일반적으로 `<SHEET>` 요소 안에 사용하여 이 요소 안의 데이터를 조회된 데이터로 표현합니다. > 이 요소 안에 사용되는 `<TR>` 요소는 조회된 각 행의 데이터를 의미하며, 하나도 사용되지 않은 경우 조회된 데이터가 없는 것으로 처리됩니다. ## Info |Name|Description| |---|--------| |TOTAL|조회 할 전체 건수 `실시간 서버 페이징 조회시 이 속성을 반드시 설정해야 합니다.`| |COLORDER|컬럼 순서를 SaveName 과 `|`를 연결한 문자열| |COLSEPARATOR|컬럼을 구분하는 문자열| ## Example ```xml <!-- 전체건수가 1000건이고, 조회건수가 100건인경우 --> <?xml version=\"1.0\" ?> <SHEET> <DATA TOTAL=\"1000\"> <TR>(조회된 데이터 중략)</TR> </DATA> </SHEET> <!-- COLORDER 사용 조회 --> <?xml version=\"1.0\" ?> <SHEET> <DATA COLORDER=\" amt | prod_nm | count \"> <TR>(조회된 데이터 중략)</TR> </DATA> </SHEET> <!-- COLSEPARATOR 사용 조회 --> <?xml version=\"1.0\" ?> <SHEET> <DATA COLSEPARATOR=\"|\"> <TR> |001|10000|아이비리더스|1</TR> <TR> |001|10000|아이비리더스|1</TR> </DATA> </SHEET> ```"
            },
            "url": "docs/static/XML/data1.html"
          },
          {
            "cid": 638,
            "sid": "etcData1",
            "name": "etcData1",
            "label": "조회/저장 ETC-DATA 요소",
            "data": {
              "body": "> 조회/저장 데이터 이외의 여분의 기타 데이터를 의미 합니다. > 이 요소는 IB Sheet 내의 데이터 이외의 데이터를 가져와 다른 용도로 사용하는 경우에 설정하여 사용합니다. > 이 요소를 통해 가져온 데이터는 [GetEtcData](/docs/funcs/core/GetEtcData) Method를 통해 확인 할 수 있고 다른 값으로도 변경이 가능합니다. ## Info |Name|Description| |---|--------| |KEY|대표 키 이름| ## Example ```xml <!--조회 시 사용하기--> <?xml version=\"1.0\" ?> <SHEET> <ETC-DATA> <ETC KEY=\"name\">홍길동</ETC> <ETC KEY=\"age\">30</ETC> </ETC-DATA> <DATA> (조회된 데이터 중략) </DATA> </SHEET> <!--저장 시 사용하기--> <?xml version=\"1.0\" ?> <SHEET> <ETC-DATA> <ETC KEY=\"name\">홍길동</ETC> <ETC KEY=\"age\">30</ETC> </ETC-DATA> <RESULT CODE=\"0\" Message=\"결과 메시지\"/> </SHEET> ```"
            },
            "url": "docs/static/XML/etcData1.html"
          },
          {
            "cid": 639,
            "sid": "message1",
            "name": "message1",
            "label": "조회 MESSAGE 요소",
            "data": {
              "body": "> 서버로부터 조회 처리 중 발생하는 메시지를 처리하기 위한 요소입니다. > 이 요소가 설정된 경우 조회 완료 후 발생하는 `OnSearchEnd` 이벤트에서 message 인자에 값이 설정되어 이벤트가 발생합니다. ## Info ***none*** ## Example ```xml <!--조회 시 사용하기--> <?xml version=\"1.0\" ?> <SHEET> <MESSAGE>조회가 완료되었습니다.</MESSAGE> <DATA> (조회된 데이터 중략) </DATA> </SHEET> ```"
            },
            "url": "docs/static/XML/message1.html"
          },
          {
            "cid": 640,
            "sid": "result1",
            "name": "result1",
            "label": "조회 RESULT 요소",
            "data": {
              "body": "> 조회 데이터의 결과를 의미합니다. ## Info |Name|Description| |---|--------| |CODE|처리 결과 코드| |MESSAGE|처리 결과 메시지| ## Example ```xml <!--조회 시 사용하기--> <?xml version=\"1.0\" ?> <SHEET> <DATA> (조회된 데이터 중략) </DATA> <RESULT CODE=\"0\" MESSAGE=\"조회가 완료되었습니다.\"></RESULT> </SHEET> ```"
            },
            "url": "docs/static/XML/result1.html"
          },
          {
            "cid": 641,
            "sid": "result2",
            "name": "result2",
            "label": "저장 RESULT 요소",
            "data": {
              "body": "> 저장 데이터의 결과를 의미합니다. ## Info |Name|Description| |---|--------| |CODE|처리 결과 코드| |MESSAGE|처리 결과 메시지| ## Example ```xml <!--저장 성공의 경우 --> <?xml version=\"1.0\" ?> <SHEET> <RESULT CODE=\"0\" MESSAGE=\"정상적으로 처리되었습니다.\"> </SHEET> <!--저장 실패의 경우 --> <?xml version=\"1.0\" ?> <SHEET> <RESULT CODE=\"-1\" MESSAGE=\"저장에 실패하였습니다.\"> </SHEET> ```"
            },
            "url": "docs/static/XML/result2.html"
          },
          {
            "cid": 642,
            "sid": "searchXML1",
            "name": "searchXML1",
            "label": "조회 XML",
            "data": {
              "body": "> 조회 함수를 통해 읽어들이는 XML 전체 구조는 다음과 같습니다. ## Info |Name|Required|Description| |---|----|--------| |SHEET|<span class=\"required\">필수</span>|조회 데이터의 최상위 요소| |DATA|<span class=\"required\">필수</span>|조회 데이터의 시작 요소| |TR|<span class=\"required\">필수</span>|조회 데이터의 각 행 단위 설정 요소| |TD|<span class=\"required\">필수</span>|조회 데이터의 셀 단위 설정 요소| |ETC-DATA|<span class=\"optional\">선택</span>|기타 데이터 설정 요소| |MESSAGE|<span class=\"optional\">선택</span>|서버 메시지 설정 요소| |RESULT|<span class=\"optional\">선택</span>|서버 처리 결과 설정 요소| ## Example ```xml <?xml version='1.0' ?> <SHEET> <!-- 선택항목. ETC-DATA 요소 --> <ETC-DATA> <ETC KEY=\"key_name\">key_value</ETC> </ETC-DATA> <!-- 선택항목. Message 요소 --> <MESSAGE>메시지</MESSAGE> <!-- 필수항목. DATA 요소 --> <DATA TOTAL=\"50\" COLORDER=\"prod_nm|pay|enter_date|book_chk\" COLSEPARATOR=\"구분자\"> <!-- 필수항목. TR 요소 : 행단위 설정 --> <TR LEVEL=\"\" HAVECHILD=\"\"> <!-- 필수항목. TD 요소 : 데이터단위 설정 --> <TD> 조회된 데이터 </TD> </TR> </DATA> <!-- 필수항목. Result 요소 --> <RESULT CODE=\"\" MESSAGE=\"\"></RESULT> </SHEET> ```"
            },
            "url": "docs/static/XML/searchXML1.html"
          },
          {
            "cid": 643,
            "sid": "searchXML2",
            "name": "searchXML2",
            "label": "저장 XML",
            "data": {
              "body": "> 저장 함수를 통해 읽어들이는 XML 전체 구조는 다음과 같습니다. ## Info |Name|Required|Description| |---|----|--------| |SHEET|<span class=\"required\">필수</span>|저장 데이터의 최상위 요소| |RESULT|<span class=\"required\">필수</span>|저장 데이터의 결과 요소| |ETC-DATA|<span class=\"optional\">선택</span>|기타 데이터 설정 요소| ## Example ```xml <!--전체 처리 결과를 가져오는 경우 --> <?xml version='1.0' ?> <SHEET> <!--선택항목. ETC-DATA 요소 --> <ETC-DATA> <ETC KEY=\"key_name\">key_value</ETC> </ETC-DATA> <!--필수항목. RESULT 요소 --> <RESULT CODE=\"0\" MESSAGE=\"완료 후 메시지\"> </RESULT> </SHEET> <!--각 행단위 트랜잭션 결과의 경우 --> <?xml version='1.0' ?> <SHEET> <!--선택항목. ETC-DATA 요소 --> <ETC-DATA> <ETC KEY=\"key_name\">key_value</ETC> </ETC-DATA> <!--필수항목. RESULT 요소 --> <RESULT> <TR> <TD>OK</TD> <TD>DUP</TD> <TD>MISS</TD> <TD>NO</TD> </TR> </RESULT> </SHEET> ```"
            },
            "url": "docs/static/XML/searchXML2.html"
          },
          {
            "cid": 644,
            "sid": "sheet1",
            "name": "sheet1",
            "label": "조회 SHEET 요소",
            "data": {
              "body": "> 조회된 데이터의 최상위를 의미 합니다. > 이 요소는 조회 XML의 최 상위 요소로 XML 기본 정의 아래 반드시 하나만 사용해야 합니다. 이 요소 안에 사용되는 `<DATA>` 요소는 조회된 데이터를 의미하며 단 하나만 사용해야 합니다. > `<ETC-DATA>` 요소는 조회된 데이터 이외의 기타 데이터를 가져오는 요소로 여러 개 사용할 수 있습니다. ## Info ***none*** ## Example ```xml <!-- 조회된 내역이 없는 경우 --> <?xml version=\"1.0\" ?> <SHEET> <DATA> </DATA> </SHEET> <!—일반 조회의 경우 --> <?xml version=\"1.0\" ?> <SHEET> <DATA> <TR> <TD>R</TD> <TD>1234</TD> <TD>가나다라</TD> </TR> </DATA> </SHEET> ```"
            },
            "url": "docs/static/XML/sheet1.html"
          },
          {
            "cid": 645,
            "sid": "sheet2",
            "name": "sheet2",
            "label": "저장 SHEET 요소",
            "data": {
              "body": "> 저장 데이터의 최상위를 의미 합니다. > 이 요소는 저장 XML의 최 상위 요소로 XML 기본 정의 아래 반드시 하나만 사용해야 합니다. 이 요소 안에 사용되는 `<RESULT>` 요소는 저장 결과 데이터를 의미하며 단 하나만 사용해야 합니다. > `<ETC-DATA>` 요소는 조회된 데이터 이외의 기타 데이터를 가져오는 요소로 여러 개 사용할 수 있습니다. ## Info ***none*** ## Example ```xml <!--저장 성공의 경우 --> <?xml version=\"1.0\" ?> <SHEET> <RESULT CODE=\"0\" MESSAGE=\"정상적으로 처리되었습니다. \"> </SHEET> <!--저장 실패의 경우 --> <?xml version=\"1.0\" ?> <SHEET> <RESULT CODE=\"-1\" MESSAGE=\"저장에 실패하였습니다.\"> </SHEET> ```"
            },
            "url": "docs/static/XML/sheet2.html"
          },
          {
            "cid": 646,
            "sid": "td1",
            "name": "td1",
            "label": "조회 TD 요소",
            "data": {
              "body": "> 해당 행의 각 컬럼별 조회 데이터를 의미 합니다. > 이 요소는 `<TR>` 요소 안에 사용되며 해당 행의 컬럼개수 만큼 반복 사용합니다. ## Info |Name|Description| |---|--------| |Align|정렬 설정| |BackColor|해당 셀의 배경색상| |ComboCode|콤보타입일경우 해당셀의 콤보 코드값을 설정| |ComboText|콤보타입일경우 해당셀의 콤보 텍스트값을 설정| |Edit|해당 셀의 Edit 허용 여부| |FontBold|Bold 설정 여부| |FontColor|해당 셀의 폰트색상| |FontItalic|기울이기 설정 여부| |FontStrike|취소선 설정 여부| |FontUnderline|밑줄 설정 여부| |Image|해당 셀의 이미지 경로 (ImageList 인덱스 사용가능)| |ToolTip|표시할 풍선도움말 문자열| ## Example ```xml <!--조회된 내역--> <?xml version=\"1.0\" ?> <SHEET> <DATA> <TR BackColor=\"#FFFF00\" FontColor=\"#00FF00\" EDIT=\"0\"> <TD BackColor=\"#FF0000\" Edit=\"0\"></TD> <TD FontColor=\"#00FF00\" Edit=\"0\"></TD> <TD Image=\"0\">006</TD> <TD>홍길동</TD> <TD>10000</TD> <TD></TD> <TD>20030201</TD> <TD>200302</TD> <TD>0201</TD> <TD>770101-1234567</TD> <TD>123-45-67890</TD> <TD>1111-2222-3333-4444</TD> <TD>가</TD> <TD>abc</TD> <TD>150-080</TD> <TD>0</TD> <TD>180101</TD> <TD ComboText=\"대기|진행|완료\" ComboCode=\"1|2|3\">0101</TD> <TD></TD> </TR> </DATA> </SHEET> ```"
            },
            "url": "docs/static/XML/td1.html"
          },
          {
            "cid": 647,
            "sid": "td2",
            "name": "td2",
            "label": "저장 TD 요소",
            "data": {
              "body": "> 각 행의 트랜잭션 결과를 의미합니다. > 이 요소는 TR 요소안에 사용되며 각 행의 트랜잭션 결과를 의미합니다. 따라서 트랜잭션 개수가 3개라면 이 요소도 3번 반복 사용해야 합니다. ## Info ***none*** ## Example ```xml <?xml version='1.0' ?> <SHEET> <RESULT> <TR> <TD>OK</TD> <TD>DUP</TD> <TD>MISS</TD> <TD>NO</TD> </TR> </RESULT> </SHEET> ```"
            },
            "url": "docs/static/XML/td2.html"
          },
          {
            "cid": 648,
            "sid": "tr1",
            "name": "tr1",
            "label": "조회 TR 요소",
            "data": {
              "body": "> 조회된 데이터의 각 행 단위 데이터를 의미 합니다. > 이 요소는 `<DATA>` 요소 하위에 사용되며 조회된 행의 개수만큼 반복 사용합니다. > `<DATA>` 요소 안에 이 요소가 없는 경우 조회된 데이터가 없는 것으로 처리됩니다. ## Info |Name|Type|Description| |---|----|--------| |BackColor|`String`|해당 행의 배경색상| |Drag|`Boolean`|해당 행의 Drag 허용 여부 (Default: 1)| |Edit|`Boolean`|해당 행의 Edit 허용 여부| |Expand|`Boolean`|해당 행의 자식 레벨 데이터를 펼칠것인지 여부| |FontColor|`String`|해당 행의 폰트색상| |HaveChild|`Boolean`|트리형태일때 해당행의 Child 데이터가 있으면서 조회하지 않는경우 사용, 나중에 OnTreeChild Event가 발생할 수 있는 행 설정| |Hidden|`Boolean`|해당 행의 숨김 여부| |Level|`Number`|해당 행의 트리 레벨| |Merge|`Boolean`|해당 행의 RowMerge 허용 여부| |Sum|`Boolean`|해당 행의 합계 계산 포함 여부| |TreeCheck|`Boolean`|트리 컬럼의 체크박스 값| ## Example ```xml <!-- 트리 형태의 데이터 조회하기 1--> <?xml version=\"1.0\" ?> <SHEET> <DATA> <TR LEVEL=\"0\">(조회된 데이터 중략)</TR> <TR LEVEL=\"1\">(조회된 데이터 중략)</TR> <TR LEVEL=\"2\">(조회된 데이터 중략)</TR> <TR LEVEL=\"2\">(조회된 데이터 중략)</TR> <TR LEVEL=\"1\">(조회된 데이터 중략)</TR> <TR LEVEL=\"2\">(조회된 데이터 중략)</TR> <TR LEVEL=\"2\">(조회된 데이터 중략)</TR> <TR LEVEL=\"2\">(조회된 데이터 중략)</TR> </DATA> </SHEET> <!-- 트리 형태의 데이터 조회하기 2. Child 데이터 조회하지 않고 나중에 조회하기--> <?xml version=\"1.0\" ?> <SHEET> <DATA> <TR LEVEL=\"0\">(조회된 데이터 중략)</TR> <TR LEVEL=\"1\" HAVECHILD=\"1\">(조회된 데이터 중략)</TR> <TR LEVEL=\"1\" HAVECHILD=\"1\">(조회된 데이터 중략)</TR> </DATA> </SHEET> ```"
            },
            "url": "docs/static/XML/tr1.html"
          },
          {
            "cid": 649,
            "sid": "tr2",
            "name": "tr2",
            "label": "저장 TR 요소",
            "data": {
              "body": "> 저장 완료된 데이터의 트랜잭션 결과를 의미합니다. > 이 요소는 RESULT 요소 안에 사용되며, 각 행단위 트랜잭션 결과를 묶어 놓은 요소로 이 요소 안에 사용되는 TD 요소가 각 행단위의 결과를 의미합니다. ## Info ***none*** ## Example ```xml <?xml version='1.0' ?> <SHEET> <RESULT> <TR> <TD>OK</TD> <TD>DUP</TD> <TD>MISS</TD> <TD>NO</TD> </TR> </RESULT> </SHEET> ```"
            },
            "url": "docs/static/XML/tr2.html"
          }
        ]
      },
      {
        "gid": 2,
        "name": "static-JSON",
        "label": "JSON",
        "children": [
          {
            "cid": 650,
            "sid": "data1-2",
            "name": "data1",
            "label": "조회 DATA 요소",
            "data": {
              "body": "> 조회된 데이터 영역을 의미하는 요소로 이 요소 안의 데이터를 조회된 데이터로 표현합니다. > 이 요소의 Value 값은 배열로 구성되며 하나의 배열 요소가 행 단위 데이터를 의미 합니다. ## Info * 내부적으로 사용하는 키값 |Key|Description| |---|-----------| |BackColor|해당 행의 배경색상| |Drag|해당행의 Drag 허용 여부 (Default: 1)| |Edit|해당 행의 Edit 허용 여부| |Expand|해당 행의 자식 레벨 데이터를 펼칠것인지 여부| |FontColor|해당 행의 폰트색상| |HaveChild|트리 형태일 때 해당 행의 Child 데이터가 있으면서 조회하지 않는 경우 사용, 나중에 OnTreeChild Event가 발생할 수 있는 행 설정| |Hidden|해당 행의 숨김 여부| |Level|트리 형태일 때 행의 트리레벨 설정 (UseJsonTreeLevel 속성을 사용하는 경우)| |Merge|해당 행의 RowMerge 허용 여부| |Sum|해당 행의 합계 계산 허용 여부| * 셀별 속성 |Name|Description| |---|------------| |Align|정렬 설정| |BackColor|해당 셀의 배경색상| |ComboCode|콤보타입일경우 해당셀의 콤보 코드값을 설정| |ComboText|콤보타입일경우 해당셀의 콤보 텍스트값을 설정| |Cursor|마우스 커서 설정 여부| |ClassName|Class 명 설정(Type: \"Button\" 컬럼만 가능)| |Edit|해당 셀의 Edit 허용 여부 | |FontBold|Bold 설정 여부| |FontColor|해당 셀의 폰트색상| |FontItalic|기울이기 설정 여부| |FontStrike|취소선 설정 여부| |FontUnderline|밑줄 설정 여부| |Image|해당 셀의 이미지 경로 (ImageList 인덱스 사용가능)| |ToolTip|표시할 풍선도움말 문자열| |TreeCheck|트리 컬럼의 체크박스 값| ## Example ```json // 일반 순차 조회의 경우 { Data:[ {BackColor:\"#FF0000\", FontColor:\"#FFFF00\", Edit:\"0\", C1: \"\", C2: \"006\", C3: \"홍길동\", C4: \"10000\", C5: \"20030201\"}, {C1:\"\",C2:\"006\",C3:\"홍길동\",\"C3#BackColor\":\"#FF0000\", \"C3#FontColor\":\"#00FF00\", \"C3#Edit\":\"0\", C4: \"10000\", C5: \"20030201\"}, … ] } // SaveName 매핑 조회 { Data:[ { BackColor:\"#FF0000\", FontColor:\"#FFFF00\", Edit:\"0\", \"sStatus\": \"\", \"sCode\": \"006\", \"sName\": \"홍길동\", \"sRank\": \"10000\", \"sDate\": \"20030201\"}, {\"sStatus\": \"\", \"sCode\": \"006\", \"sName\": \"홍길동\", \"sName#BackColor\":\"#FF0000\", \"sName#FontColor\":\"#00FF00\", \"sName#Edit\":\"0\", \"sRank\": \"10000\", \"sDate\": \"20030201\", “sDate#ClassName”:”myClass”}, … ] } ```"
            },
            "url": "docs/static/JSON/data1.html"
          },
          {
            "cid": 651,
            "sid": "etc1",
            "name": "etc1",
            "label": "조회 ETC 요소",
            "data": {
              "body": "> 조회 또는 저장 데이터 이외의 여분의 기타 데이터를 의미 합니다. > 이 요소의 Value 값은 Key:Value 형태의 반복으로 구성되며 IB Sheet 내의 데이터 이외의 데이터를 가져와 다른 용도로 사용하는 경우에 설정하여 사용합니다. > 이 요소를 통해 가져온 데이터는 `EtcData` Method를 통해 확인 할 수 있고 다른 값으로도 변경이 가능 합니다. ## Info ***none*** ## Example ```json // 조회 시 사용하기 { Etc: {\"name\":\"홍길동\", \"age\":\"30\"}, Data:[ (조회된 데이터 중략) ] } // 저장 시 사용하기 { Etc: {\"name\":\"홍길동\", \"age\":\"30\"}, Result : {Code:0, Message:\"결과 메시지.\"} } ```"
            },
            "url": "docs/static/JSON/etc1.html"
          },
          {
            "cid": 652,
            "sid": "message1-2",
            "name": "message1",
            "label": "조회 MESSAGE 요소",
            "data": {
              "body": "> 서버로부터 조회 처리 중 발생하는 메시지를 처리하기 위한 요소입니다. > 이 요소가 설정된 경우 조회 완료 후 발생하는 `OnSearchEnd` 이벤트에서 message 인자에 값이 설정되어 이벤트가 발생합니다. ## Info |Name|Description| |---|--------| |CODE|처리 결과 코드| |MESSAGE|처리 결과 메시지| ## Example ```json // 조회 시 사용하기 { Message: \"조회가 완료되었습니다.\", Data:[ (조회된 데이터 중략) ] } ```"
            },
            "url": "docs/static/JSON/message1.html"
          },
          {
            "cid": 653,
            "sid": "message2",
            "name": "message2",
            "label": "저장 MESSAGE 요소",
            "data": {
              "body": "> 서버로부터 저장 처리 중 발생하는 메시지를 처리하기 위한 요소 입니다. > 이 요소가 설정된 경우 조회 완료 후 발생하는 `OnSearchEnd` 이벤트에서 message 인자에 값이 설정되어 이벤트가 발생합니다. ## Info ***none*** ## Example ```json // 저장시 시 사용하기 { Message: \"저장이 완료되었습니다.\", Data:[ (저장 데이터 중략) ] } ```"
            },
            "url": "docs/static/JSON/message2.html"
          },
          {
            "cid": 654,
            "sid": "result1-2",
            "name": "result1",
            "label": "조회 RESULT 요소",
            "data": {
              "body": "> 조회 데이터의 결과를 의미합니다. ## Info |Name|Required|Description| |---|----|--------| <span class=\"required\">필수</span> <span class=\"optional\">선택</span> ## Example ```json // 조회 시 사용하기 { Data:[ (조회된 데이터 중략) ], Result:{Code:0, Message:\"조회가 완료되었습니다.\"} } ```"
            },
            "url": "docs/static/JSON/result1.html"
          },
          {
            "cid": 655,
            "sid": "result2-2",
            "name": "result2",
            "label": "저장 RESULT 요소",
            "data": {
              "body": "> 저장 데이터의 결과를 의미 합니다. > 이 요소의 Value 값은 Key:Value 형태로 Key 값으로는 Code, Message, Result 를 설정 할 수 있습니다. ## Info ***none*** ## Example ```json // 전체데이터 처리 결과 : 저장 성공의 경우 { Result:{ Code:0, Message: \"정상적으로 처리되었습니다.\" } } // 전제데이터 처리 결과 : 저장 실패의 경우 { Result:{ Code:-1, Message: \"저장에 실패하였습니다.\" } } // 각 행단위 트랜잭션 처리 결과의 경우 { Result:{ Result: \"OK|DUP|MISS|NO\" } } ```"
            },
            "url": "docs/static/JSON/result2.html"
          },
          {
            "cid": 656,
            "sid": "savejson",
            "name": "savejson",
            "label": "저장 JSON",
            "data": {
              "body": "> 저장 함수를 통해 읽어들이는 JSON 전체 구조는 아래와 같습니다. ## Info |Name|Required|Description| |---|----|--------| |RESULT|<span class=\"required\">필수</span>|저장 데이터의 결과 요소| |ETC-DATA|<span class=\"optional\">선택</span>|기타 데이터 설정 요소| ## Example ```json { // 선택항목. ETC 요소 Etc: {\"key_name\":\"key_value\", \"key_name2\":\"key_value2\"}, // 필수항목. DATA 요소 Result:{Code: \"0\", Message: \"완료 후 메시지\", Result: \"행별 트랜잭션 결과\"} } ```"
            },
            "url": "docs/static/JSON/savejson.html"
          },
          {
            "cid": 657,
            "sid": "srchjson1",
            "name": "srchjson1",
            "label": "조회 JSON",
            "data": {
              "body": "> 조회 함수를 통해 읽어들이는 JSON 전체 구조는 아래와 같습니다. > `json 생성시 요소명은 대소문자를 정확하게 구분해야 합니다` ## Info |Name|Required|Description| |---|----|--------| |Data|<span class=\"required\">필수</span>|조회 데이터의 시작 요소| |Total|<span class=\"optional\">선택</span>|전체 데이터 개수 설정 요수| |Etc|<span class=\"optional\">선택</span>|기타 데이터 설정 요소| |Message|<span class=\"optional\">선택</span>|서버 메시지 설정 요소| |Result|<span class=\"optional\">선택</span>|서버 처리 결과 설정 요소| ## Example ```json { // 선택항목. TOTAL 요소 Total:0, // 선택항목. ETC 요소 Etc {\"key_name\":\"key_value\", \"key_name2\":\"key_value2\"}, // 선택항목 MESSAGE 요소 Message : \"메시지\", // 필수항목. DATA 요소 Data:[ // 필수항목. 데이터 단위 설정 {C1:\"데이터1\", C2: \"데이터2\"} ], // 선택항목 RESULT 요소 Result : {Code:0, Message:\"정상적으로 처리되었습니다.\"} } ```"
            },
            "url": "docs/static/JSON/srchjson1.html"
          },
          {
            "cid": 658,
            "sid": "total1",
            "name": "total1",
            "label": "조회 TOTAL 요소",
            "data": {
              "body": "> 실시간 서버 조회 처리시 사용되는 요소로 전체 데이터의 총 개수를 의미 합니다. > 이 요소의 Value 값은 정수값으로 설정하며, 실시간 서버 조회 처리시 이 요소는 반드시 설정 하여야 하며, 설정하지 않거나 0으로 설정한 경우는 조회 데이터가 없는 것으로 처리 됩니다. ## Info ***none*** ## Example ```json // 전체 데이터가 1000건인 실시간 서버 조회의 경우 { Total:1000, Data:[ {C1: \"\", C2: \"006\", C3: \"홍길동\", C4: \"10000\", C5: \"20030201\"}, {C1: \"\", C2: \"006\", C3: \"홍길동\", C4: \"10000\", C5: \"20030201\"}, … ] } ```"
            },
            "url": "docs/static/JSON/total1.html"
          }
        ]
      },
      {
        "gid": 3,
        "name": "static-TreeJSON",
        "label": "Tree 기능 사용시 JSON",
        "children": [
          {
            "cid": 659,
            "sid": "TreeJSON",
            "name": "TreeJSON",
            "label": "Tree 기능 사용시 JSON",
            "data": {
              "body": "> 특정 컬럼을 Tree 형태로 사용시 데이터 JSON의 기본 구조는 다음과 같습니다. ## Example ```json { data:[ {sa_nm:\"김사장\",job:\" PRESIDENT\", Items:[ //0 LEVEL {sa_nm:\"안전무\",job:\"GMANAGER\"}, //1 LEVEL {sa_nm:\"이상무\",job:\"GMANAGER\", Items:[ //1LEVEL {sa_nm:\"박대리\",job:\"ASSISTANT\"} //2LEVEL ] } ] } ] } ``` 단 위와 같은 json 구조를 구성하기 어려울 경우, xml과 같이 Level 프로퍼티를 이용한 방법도 기능으로 제공하고 있습니다. Level 속성을 사용해서 데이터를 받아올 때는 반드시 `(Cfg)UseJsonTreeLevel : 1` 을 설정해야합니다. ## Example ```json { data:[ {sa_nm:\"김사장\",job:\" PRESIDENT\",Level:0}, //0 LEVEL {sa_nm:\"안전무\",job:\"GMANAGER\",Level:1}, //1 LEVEL {sa_nm:\"이상무\",job:\"GMANAGER\",Level:1}, //1LEVEL {sa_nm:\"박대리\",job:\"ASSISTANT\",Level:2} //2LEVEL ] } ```"
            },
            "url": "docs/static/TreeJSON/TreeJSON.html"
          }
        ]
      }
    ]
  },
  {
    "gid": 6,
    "name": "event",
    "label": "Events",
    "children": [
      {
        "cid": 728,
        "sid": "event",
        "name": "event",
        "label": "event 사용법 기초",
        "data": {
          "body": "> 사용자가 원하는 기능을 추가 또는 변경 처리할 수 있도록 다양한 이벤트를 제공합니다. > 이벤트의 사용 방법은 아래와 같습니다. ### Syntax ```javascript function 오브젝트ID_이벤트명(파라미터, …) {} //예를 들어 IBSheet ObjectID를 \"mySheet\"라 하고, OnChange 이벤트에 대해 기능 처리를 해야 한다면 아래와 같이 기술할 수 있습니다. function mySheet_OnChange(Row, Col, Value) { alert(Row + \",\" + Col + \"의 값이 변경되었습니다.\"); } ```"
        },
        "url": "docs/event/event.html"
      },
      {
        "cid": 660,
        "sid": "OnAfterColumnMove",
        "name": "OnAfterColumnMove",
        "label": "OnAfterColumnMove",
        "data": {
          "body": "> 사용자가 마우스 드래그를 이용하여 컬럼을 이동하거나 `MoveColumnPos` 함수를 이용하여 컬럼을 이동하고 > 이동이 성공적으로 완료되었을 때 발생하는 이벤트입니다. ### Syntax ```javascript function 오브젝트ID_OnAfterColumnMove(Col, NewPos) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Col|`Long`|이동한 컬럼의 Index| |NewPos|`Long`|이동된 위치의 컬럼 Index| ### Example ```javascript //컬럼이 이동된 후 이벤트가 발생 function mySheet_OnAfterColumnMove(Col, NewPos) { alert(Col + \" 위치가 \" + NewPos + \" 위치로 이동되었습니다..\"); } ``` ### See also * [OnBeforeColumnMove event](/docs/funcs/event/OnBeforeColumnMove) * [MoveColumnPos](/docs/funcs/col/MoveColumnPos) * [MoveColumnFail](/docs/funcs/col/MoveColumnFail) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnAfterColumnMove.html"
      },
      {
        "cid": 661,
        "sid": "OnAfterEdit",
        "name": "OnAfterEdit",
        "label": "OnAfterEdit",
        "data": {
          "body": "> 셀의 값을 편집한 직후에 발생하는 이벤트입니다. ### Syntax ```javascript function 오브젝트ID_OnAfterEdit(Row, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| ### Example ```javascript //값을 편집한 직후 이벤트가 발생한다. function mySheet_OnAfterEdit(Row, Col) { alert(\"입력을 마칩니다.\"); } ``` ### See also * [OnBeforeEdit event](/docs/event/OnBeforeEdit) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnAfterEdit.html"
      },
      {
        "cid": 662,
        "sid": "OnAfterExpand",
        "name": "OnAfterExpand",
        "label": "OnAfterExpand",
        "data": {
          "body": "> 트리 형태 시트를 사용할 때 + 기호나 – 기호를 클릭하여 트리를 접거나 펼친후에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnAfterExpand(Row, Expand) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Expand|`Long`|7 : 펼치는 경우 2 : 접는경우| ### Example ```javascript function mySheet_OnAfterExpand(Row, Expand) { alert( Row + \"행, \"+ Expand +\"의 상태\"); } ``` ### See also * [OnBeforeExpand event](/docs/event/OnBeforeExpand) * [GetRowExpand method](/docs/funcs/tree/GetRowExpanded) * [SetRowExpand method](/docs/funcs/tree/SetRowExpanded) * [GetRowLevel method](/docs/funcs/tree/GetRowLevel) * [SetRowLevel method](/docs/funcs/tree/SetRowLevel) * [ShowTreeLevel method](/docs/funcs/tree/ShowTreeLevel) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnAfterExpand.html"
      },
      {
        "cid": 663,
        "sid": "OnAfterPaste",
        "name": "OnAfterPaste",
        "label": "OnAfterPaste",
        "data": {
          "body": "> 클립보드 붙여넣기 완료 시점에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnAfterPaste() { } ``` ### Parameters ***none*** ### Example ```javascript function mySheet_OnAfterPaste() { console.log(\"클립보드 붙여넣기 완료\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.3.21||",
          "since": "|version|desc||---|---||7.0.3.21||"
        },
        "url": "docs/event/OnAfterPaste.html"
      },
      {
        "cid": 664,
        "sid": "OnBeforeCheck",
        "name": "OnBeforeCheck",
        "label": "OnBeforeCheck",
        "data": {
          "body": "> 사용자가 체크박스의 값 변경시 (마우스 클릭 또는 Space 키를 누름으로 변경) 편집하기 직전에 이벤트가 발생합니다. > 체크박스의 값 변경을 하기 직전에 이벤트가 발생하므로 체크시점에 조건에 의한 처리가 가능합니다. > 지원되는 데이터타입 : `DelCheck`, `CheckBox`, `Radio`, `DummyCheck` ### Syntax ```javascript function 오브젝트ID_OnBeforeCheck(Row, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| ### Example ```javascript // 체크 되기 직전 이벤트가 발생한다. //체크하려는 행이 입력행이면 경고창 띄우기. function mySheet_OnBeforeCheck(Row, Col) { if(mySheet.GetCellValue(Row,\"sStatus\") == \"I\") { alert(\"상태가 ‘입력'인 행은 선택이 불가능 합니다.\"); mySheet.SetAllowCheck(0);//체크를 막는다. }else{ mySheet.SetAllowCheck(1);//반드시 else인 경우에는 체크를 열어줘야 한다. } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnBeforeCheck.html"
      },
      {
        "cid": 665,
        "sid": "OnBeforeCheckAll",
        "name": "OnBeforeCheckAll",
        "label": "OnBeforeCheckAll",
        "data": {
          "body": "> 사용자의 마우스 클릭을 통한 헤더의 전체체크박스의 값 변경시 전체체크 처리 이전에 이벤트가 발생합니다. > 이벤트의 리턴값을 `false`로 설정하는 경우 전체체크 처리는 취소 됩니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeCheckAll(Row, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| ### Example ```javascript // confirm 을 통한 전체체크 제어 function mySheet_OnBeforeCheckAll(Row, Col) { if (!confirm(\"전체체크를 진행하시겠습니까?\")) { // 진행 취소 처리 return false; } } ``` ### See also ### Since |version|desc| |---|---| |7.0.1.0||",
          "since": "|version|desc||---|---||7.0.1.0||"
        },
        "url": "docs/event/OnBeforeCheckAll.html"
      },
      {
        "cid": 666,
        "sid": "OnBeforeColumnMove",
        "name": "OnBeforeColumnMove",
        "label": "OnBeforeColumnMove",
        "data": {
          "body": "> 사용자가 마우스를 이용하여 컬럼 이동을 시작하거나 `MoveColumnPos` 함수를 이용하여 컬럼 이동을 시작할 때 이벤트가 발생합니다. > `MoveColumnFail(1)` 함수를 이용하여 컬럼이동을 방지할 수 있습니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeColumnMove(Col, NewPos) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Col|`Long`|이동할 컬럼의 Index| |NewPos|`Long`|이동될 위치의 컬럼 Index| ### Example ```javascript //0컬럼이 3컬럼 이후의 위치로 이동하고자 할때 컬럼 이동을 취소 function mySheet_OnBeforeColumnMove(Col, NewPos) { if(Col == 0 && NewPos > 3) { mySheet.MoveColumnFail(1); } } ``` ### See also * [MoveColumnPos method](/docs/funcs/col/MoveColumnPos) * [MoveColumnFail method](/docs/funcs/col/MoveColumnFail) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnBeforeColumnMove.html"
      },
      {
        "cid": 667,
        "sid": "OnBeforeDownload",
        "name": "OnBeforeDownload",
        "label": "OnBeforeDownload",
        "data": {
          "body": "> 엑셀, 텍스트, Pdf 다운전에 데이터가 만들어지고 폼이 서브밋되기 전에 발생합니다. > 해당 이벤트 안에서 폼을 서브밋해야 정상적으로 다운로드가 됩니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeDownload(downloadType, frm) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |downloadType|`String`다운로드 종류 EXCEL : 엑셀 다운로드 TEXT : 텍스트 다운로드 PDF: PDF 다운로드| |frm|`Object`|Html Form 객체| ### Example ```javascript function mySheet_OnBeforeDownload(type, frm) { //서버측으로 전달될 문자열을 확인 var data = frm.Data.value; //다운로드 폼을 서브밋 frm.submit(); } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.43||",
          "since": "|version|desc||---|---||7.0.13.43||"
        },
        "url": "docs/event/OnBeforeDownload.html"
      },
      {
        "cid": 668,
        "sid": "OnBeforeEdit",
        "name": "OnBeforeEdit",
        "label": "OnBeforeEdit",
        "data": {
          "body": "> 셀의 값을 편집하기 직전에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeEdit(Row, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| ### Example ```javascript //셀의 값을 편집하기 직전에 이벤트가 발생 function mySheet_OnBeforeEdit(Row, Col) { alert(\"입력을 시작합니다.\"); // col의 saveName이 sTitle 인 경우에는 편집모드로 진입하지 않도록 처리 if (mySheet.ColSaveName(Col) == \"sTitle\") return true; } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.262|편집모드로 진입하지 않도록 return true 추가|",
          "since": "|version|desc||---|---||7.0.0.0|||7.0.13.262|편집모드로 진입하지 않도록 return true 추가|"
        },
        "url": "docs/event/OnBeforeEdit.html"
      },
      {
        "cid": 669,
        "sid": "OnBeforeExpand",
        "name": "OnBeforeExpand",
        "label": "OnBeforeExpand",
        "data": {
          "body": "> 트리 형태일 때 클릭시 트리가 펼쳐지기 전 또는 접히기 전에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeExpand(Row, Expand) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Expand|`Number`|0 : 펼치는 경우 2 : 접는경우| ### Example ```javascript function mySheet_OnBeforeExpand(Row, Expand) { if(Row == 1 && Expand == 2) { mySheet.SetAllowExpand(0); alert(\"1 행에서는 펼칠 수 있지만 접을 수 없습니다.\"); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnBeforeExpand.html"
      },
      {
        "cid": 670,
        "sid": "OnBeforeMovePage",
        "name": "OnBeforeMovePage",
        "label": "OnBeforeMovePage",
        "data": {
          "body": "> `페이지 인덱스 방식`의 조회모드인 경우 페이지 네비게이션 또는 페이지 이동 메소드를 통해 페이지를 이동하는 경우 이동 전에 이벤트가 발생 합니다. > 해당 이벤트의 반환값을 `false`로 설정한 경우 페이지 이동이 취소 됩니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeMovePage(Current, Move) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Current|`Number`|페이지 이동전의 현재 페이지 번호| |Move|`Number`|이동할 페이지 번호| ### Example ```javascript function mySheet_OnBeforeMovePage(current, move) { // 트랜잭션이 발생한 경우 페이지 이동을 취소 한다. if (mySheet.IsDataModified()) { return false; } } ``` ### See also * [SearchMode Cfg](/docs/props/PropertyList/SearchMode) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnBeforeMovePage.html"
      },
      {
        "cid": 671,
        "sid": "OnBeforePaste",
        "name": "OnBeforePaste",
        "label": "OnBeforePaste",
        "data": {
          "body": "> 시트에 데이터를 붙여넣기 직전에 발생하는 이벤트입니다. > 데이터를 붙여넣기 전에 발생하며 필요에 따라 붙여넣기를 취소하거나 붙여넣을 값을 수정 할 수 있습니다. > `false` 리턴시 붙여넣기는 취소되며, 문자열 리턴시 붙여넣을 텍스트가 대체됩니다. ### Syntax ```javascript function 오브젝트ID_OnBeforePaste(text) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |text|`String`|시트에 붙여넣을 텍스트| ### Example ```javascript function mySheet_OnBeforePaste(text) { if(text == \"not allow text\") { alert(\"붙여넣기가 최소됩니다.\"); return false; } } function mySheet_OnBeforePaste(text) { if(text == \"not allow text\") { return \"allow text\"; } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnBeforePaste.html"
      },
      {
        "cid": 672,
        "sid": "OnBeforeSave",
        "name": "OnBeforeSave",
        "label": "OnBeforeSave",
        "data": {
          "body": "> 저장 메소드 호출 시 Ajax 통신 직전에 발생하는 이벤트입니다. > `DoSave`, `DoAllSave` 메소드 호출 시 Ajax 통신 전에 발생합니다. > 저장 중 이미지 등을 사용자가 원하는 이미지로 변경하고자 할때 사용합니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeSave() { } ``` ### Parameters ***none*** ### Example ```javascript function mySheet_OnBeforeSave() { alert(\"저장중입니다.\"); } ``` ### See also * [DoSave method](/docs/funcs/save/DoSave) * [DoAllSave method](/docs/funcs/save/DoAllSave) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnBeforeSave.html"
      },
      {
        "cid": 673,
        "sid": "OnBeforeSearch",
        "name": "OnBeforeSearch",
        "label": "OnBeforeSearch",
        "data": {
          "body": "> 조회 메소드 호출 시 Ajax 통신 직전에 발생합니다. > `DoSearch`, `DoSearchChild`, `DoSearchPaging`, `DoRowSearch` 메소드 호출 시 Ajax 통신 전에 발생한다. > 조회 중 이미지 등을 사용자가 원하는 이미지로 변경하고자 할때 사용한다. ### Syntax ```javascript function 오브젝트ID_OnBeforeSearch() { } ``` ### Parameters ***none*** ### Example ```javascript function mySheet_OnBeforeSearch() { alert(\"조회중입니다.\"); } ``` ### See also * [DoSearch] * [DoSearchChild] * [DoSearchPaging] * [DoRowSearch] ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnBeforeSearch.html"
      },
      {
        "cid": 674,
        "sid": "OnBeforeSort",
        "name": "OnBeforeSort",
        "label": "OnBeforeSort",
        "data": {
          "body": "> Sort 이벤트가 발생되기 전에 발생하는 이벤트입니다. > 헤더 클릭시 소트이벤트 발생전에 호출됩니다. > 소트 수행 전 대기 이미지 호출 등에 활용됩니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeSort(col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |col|`Int`|Sort 선택한 컬럼 인덱스 확인| ### Example ```javascript function mySheet_OnBeforeSort(col) { console.log(“SortColumn : “ + col); } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.75||",
          "since": "|version|desc||---|---||7.0.13.75||"
        },
        "url": "docs/event/OnBeforeSort.html"
      },
      {
        "cid": 675,
        "sid": "OnBeforeTab",
        "name": "OnBeforeTab",
        "label": "OnBeforeTab",
        "data": {
          "body": "> 시트에서 탭 키를 누르는 경우 탭 이벤트가 발생하기 전에 발생하는 이벤트입니다. > 리턴값이 `false` 또는 `0`인 경우 해당 셀에서 포커스를 이동하지 않습니다. > 편집중인 셀의 경우 편집만 완료합니다. ### Syntax ```javascript function 오브젝트ID_OnBeforeTab(row, col, oldRow, oldCol) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |row|`Long`|행의 Index| |col|`Long`|컬럼의 Index| |oldRow|`Long`|이전 행의 Index| |oldCol|`Long`|이전 컬럼의 Index| ### Example ```javascript function mySheet_OnBeforeTab (row, col, oldRow, oldCol) { console.log(\"[OnBeforeTab] new : \" + row + \",\" + col + \", old : \" + oldRow + \",\" + oldCol); } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.84||",
          "since": "|version|desc||---|---||7.0.13.84||"
        },
        "url": "docs/event/OnBeforeTab.html"
      },
      {
        "cid": 676,
        "sid": "OnButtonClick",
        "name": "OnButtonClick",
        "label": "OnButtonClick",
        "data": {
          "body": "> `Button` 컬럼 타입의 버튼을 클릭할 때 발생하는 이벤트입니다. > 해당 셀의 Editable이 false인 경우에는 이벤트가 발생하지 않습니다. ### Syntax ```javascript function 오브젝트ID_OnButtonClick(Row, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|대상 행의 Index| |Col|`Long`|대상 컬럼의 Index| ### Example ```javascript function mySheet_OnButtonClick(Row, Col) { console.log(\"[\" + Row + \",\" + Col + \"] 셀의 버튼 클릭\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.9||",
          "since": "|version|desc||---|---||7.0.13.9||"
        },
        "url": "docs/event/OnButtonClick.html"
      },
      {
        "cid": 677,
        "sid": "OnCellDropEnd",
        "name": "OnCellDropEnd",
        "label": "OnCellDropEnd",
        "data": {
          "body": "> 셀 단위 Drag 를 시작 후 Drop 시점에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnCellDropEnd(FromSheet, FromRow, FromCol, ToSheet, ToRow, ToCol, X, Y) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |FromSheet|`Object`| Drag 위치 Sheet 객체| |FromRow|`Long`| Drag 위치 Sheet 객체의 Row Index| |FromCol|`Long`| Drag 위치 Sheet 객체의 Column Index| |ToSheet|`Object`| Drop 위치 Sheet 객체| |ToRow|`Long`| Drop 위치 Sheet 객체의 Row Index| |ToCol|`Long`| Drop 위치 Sheet 객체의 Column Index| |X|`Long`| Drop 위치의 X 좌표| |Y|`Long`| Drop 위치의 Y 좌표| ### Example ```javascript // 드래그 셀의 Value를 드랍위치 셀에 설정 function mySheet_OnCellDropEnd(FromSheet, FromRow, FromCol, ToSheet, ToRow, ToCol) { var bValue = ToObj.GetCellValue(ToRow, ToCol); var aValue = Obj.GetCellValue(Row, Col); if (ToRow < 0) { ToRow = ToObj.DataInsert(ToRow); ToCol = ToObj.MouseCol(); } if (ToObj && ToRow > 0 && ToCol >= 0) { ToObj.SetCellValue(ToRow, ToCol, aValue); if (bValue) { Obj.SetCellValue(Row, Col, bValue); } else { Obj.SetCellValue(Row, Col, \"\"); } } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnCellDropEnd.html"
      },
      {
        "cid": 678,
        "sid": "OnChange",
        "name": "OnChange",
        "label": "OnChange",
        "data": {
          "body": "> 셀의 값을 편집 완료하고, 기존 값이 변경되었을 때 이벤트가 발생합니다. > 사용자의 값 변경이외에도 `CellValue` 함수를 이용하거나 헤더 영역의 전체 선택 CheckBox가 변경되었을 때 또는 `CheckAll` 함수를 이용한 경우 > 각 데이터 행 단위로 변경된 CheckBox에 대해서 이벤트가 발생합니다. > CellValue 함수의 `flag` 인자의 값이 `0` 일 경우는 이 이벤트가 발생하지 않습니다. ### Syntax ```javascript function 오브젝트ID_OnChange(Row, Col, Value, OldValue, RaiseFlag) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| |Value|`String`|변경된 값, Format이 적용되지 않은 저장 시 사용되는 값| |OldValue|`String`|변경 이전의 값| |RaiseFlag|`Integer`|이벤트 발생 옵션 (0: 사용자 편집, 1: 메소드, 2: Paste(ctrl+v 붙여넣기))| ### Example ```javascript function mySheet_OnChange(Row, Col, Value, OldValue, RaiseFlag) { if(Col == 3 && mySheet.GetCellValue(Row, 2) == ‘원화' && Value == ‘9') { alert(\"원화 일 때 코드는 10을 선택하여야 합니다.\"); } } ``` ### See also * [GetCellValue method](/docs/funcs/cell/GetCellValue) * [SetCellValue method](/docs/funcs/cell/SetCellValue) * [CheckAll method](/docs/funcs/col/CheckAll) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnChange.html"
      },
      {
        "cid": 679,
        "sid": "OnChangeFilter",
        "name": "OnChangeFilter",
        "label": "OnChangeFilter",
        "data": {
          "body": "> 필터행의 셀의 값을 바꾸거나 옵션이 변경되었을 때 이벤트가 발생합니다. > 사용자의 값 변경외에도, `SetFilterOption` 함수를 이용했을때도 이벤트가 발생하게 됩니다. ### Syntax ```javascript function 오브젝트ID_OnChangeFilter() { } ``` ### Parameters ***none*** ### Example ```javascript //SearchMode:3 일때 필터링 조건이 변경된 경우 조회 function mySheet_OnChangeFilter() { // 필터행 QueryString 문자열로 변환 var fp = mySheet.GetFilterParam(0, 1); var info = {PageParam:\"page\", Param:\"id=ibleaders&seq=1&\"+fp}; mySheet.DoSearchPaging(\"list.jsp\", info); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnChangeFilter.html"
      },
      {
        "cid": 680,
        "sid": "OnChangeSum",
        "name": "OnChangeSum",
        "label": "OnChangeSum",
        "data": {
          "body": "> 합계행에 값이 바뀌었을 때 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnChangeSum(Row,Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|합계행의 상단 Row Index| |Col|`Long`|변경 셀의 Col Index| ### Example ```javascript function mySheet_OnChangeSum(Row, Col) { //합계 행에 값이 바뀌었을 때, 같은 행의 다른셀에 계산 정보 표시 mySheet.SetSumText(0,2, mySheet.GetSumValue(Col) / 100 + \" %\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnChangeSum.html"
      },
      {
        "cid": 681,
        "sid": "OnCheckAllEnd",
        "name": "OnCheckAllEnd",
        "label": "OnCheckAllEnd",
        "data": {
          "body": "> 체크박스 타입 컬럼이 전체체크가 수행된 후 완료시점에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnCheckAllEnd(Col, Value) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Col|`Integer`|해당 컬럼의 Index| |Value|`Boolean`|체크여부| ### Example ```javascript function mySheet_OnCheckAllEnd(Col, Value) { alert(Col + \"번째 컬럼의 전체체크 수행이 완료되었습니다.\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnCheckAllEnd.html"
      },
      {
        "cid": 682,
        "sid": "OnClick",
        "name": "OnClick",
        "label": "OnClick",
        "data": {
          "body": "> 데이터 영역의 셀을 마우스로 클릭했을 때 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnClick(Row, Col, Value, CellX, CellY, CellW, CellH, rowType) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| Row|`Long`|해당 셀의 Row Index| Col|`Long`|해당 셀의 Column Index| Value|`String`|이벤트가 발생한 셀의 값| CellX|`Long`|해당셀의 X좌표| CellY|`Long`|해당셀의 Y좌표| CellW|`Long`|해당셀의 가로 넓이값| CellH|`Long`|해당셀의 세로 높이값| rowType|`String`|해당 Row의 타입(HeaderRow, SubSumRow, SumRow, DataRow, CumulateRow)| ### Example ```javascript //특정 열을 클릭했을 때 다른 페이지로 이동하도록 처리 function mySheet_OnClick(row, col, value, cellX, cellY, cellW, cellH) { if (mySheet.ColSaveName(col) == \"LINK_BUFF\") { location.href = \"link.jsp?key=\" + mySheet.GetCellValue(row,\"KFELD\"); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnClick.html"
      },
      {
        "cid": 683,
        "sid": "OnColumnSort",
        "name": "OnColumnSort",
        "label": "OnColumnSort",
        "data": {
          "body": "> `ColumnSort` 함수를 실행했을 때 콜백 함수로서 호출됩니다. ### Syntax ```javascript function 오브젝트ID_OnColumnSort(Col, Order) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Col|`Long or String`|소트가 처리된 컬럼 인덱스 SortEventMode 가 1인 경우 `\"|\"`로 구분| |Order|`String`|소트 방향 문자열 SortEventMode 가 1인 경우 `\"|\"`로 구분| ### Example ```javascript function mySheet_OnColumnSort(Col, Order) { //ColumnSort 함수를 실행되었을 때 콜백 함수로 호출되어 실행. if(order == \"ASC\") { alert(col + \"번째 컬럼이 오름차순으로 정렬되었습니다.\"); } else { alert(col + \"번째 컬럼이 내림차순으로 정렬되었습니다.\"); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.106||",
          "since": "|version|desc||---|---||7.0.13.106||"
        },
        "url": "docs/event/OnColumnSort.html"
      },
      {
        "cid": 684,
        "sid": "OnDblClick",
        "name": "OnDblClick",
        "label": "OnDblClick",
        "data": {
          "body": "> 데이터 영역의 셀을 마우스로 더블 클릭했을 때 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnDblClick(Row, Col, Value, CellX, CellY, CellW, CellH) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| |Value|`String`|해당 셀의 Value| |CellX|`Long`|해당셀의 X좌표| |CellY|`Long`|해당셀의 Y좌표| |CellW|`Long`|해당셀의 가로 넓이값| |CellH|`Long`|해당셀의 세로 높이값| ### Example ```javascript function mySheet_OnDblClick(Row, Col, Value, CellX, CellY, CellW, CellH) { //더블 클릭했을 때, 선택행의 값을 전달 어미 창으로 전달. var selectRowJson = mySheet.GetRowData(Row); parent.GetData(selectRowJson); self.close(); return false; //창을 닫는 경우에는 false를 리턴해 줘야 함. } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnDblClick.html"
      },
      {
        "cid": 685,
        "sid": "OnDebugMsg",
        "name": "OnDebugMsg",
        "label": "OnDebugMsg",
        "data": {
          "body": "> 모든 기능 처리 과정 중 발생하는 디버깅용 메시지가 있을 때 이벤트가 발생합니다. > `ShowDebugMsg` method의 인자를`0`으로 설정하는 경우 디버깅용 메시지가 이 이벤트를 통해서 호출되고, `-1`로 설정하는 경우 사용자가 볼 수 있도록 메시지 팝업 형태로 표시됩니다. ### Syntax ```javascript function 오브젝트ID_OnDebugMsg(Msg) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Msg|`String`|디버그 메시지| ### Example ```javascript function mySheet_OnDebugMsg(Msg) { txtErr.value = txtErr.value + «\\n>>>> » + Msg ; } //디버그 메시지 표시를 위한 TextArea 생성 <textarea name=\"txtErr\" rows=10 cols=70></textarea> ``` ### See also * [ShowDebugMsg method](/docs/funcs/ShowDebugMsg) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnDebugMsg.html"
      },
      {
        "cid": 686,
        "sid": "OnDecryption",
        "name": "OnDecryption",
        "label": "OnDecryption",
        "data": {
          "body": "> 조회를 하는 과정에서 각 셀에 들어가야 할 데이터를 수정하거나 암호화 모듈과 연동하여 사용하기 위해 각 셀과 EtcData 요소에 대해 발생하는 이벤트입니다. > 데이터를 조회하는 과정에서 값이 A 인 경우, B라고 표시해야 된다거나, 혹은 데이터가 암호화 되어 내려와 이를 표현하기 전에 복호화 해야 하는 경우 이 이벤트를 통해 작업할 수 있습니다. ### Syntax ```javascript function 오브젝트ID_OnDecryption(Row,Col,SaveName,Value){} ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|셀의 Row Index(EtcData에 대해서는 -1)| |Col|`Long`|셀의 Col Index(EtcData에 대해서는 -1)| |SaveName|`String`|컬럼의 SaveName이나 EtcData 의 KEY| |Value|`String`|셀에 들어갈 데이터 나 EtcData의 Value| ### Example ```javascript function mySheet_OnDecryption(Row, Col, SaveName, Value){ /* 값을 매개변수로 복호화를 수행하는 Dec 사용자 함수를 호출하여 리턴한다*/. return Dec(Value); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnDecryption.html"
      },
      {
        "cid": 687,
        "sid": "OnDownFinish",
        "name": "OnDownFinish",
        "label": "OnDownFinish",
        "data": {
          "body": "> 엑셀 및 텍스트 파일이 다운로드 완료 되었을때 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnDownFinish(downloadType, result){} ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |downloadType|`String`|엑셀/텍스트 종류. \"EXCEL\", \"TEXT\"| |result|`Boolean`|다운로드 오류 여부. 성공 : true, 실패 : false| ### Example ```javascript function mySheet_OnDownFinish(downloadType, result) { alert(downloadType + \"다운이 완료되었습니다. 다운로드 결과 :\" + result); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnDownFinish.html"
      },
      {
        "cid": 688,
        "sid": "OnDragStart",
        "name": "OnDragStart",
        "label": "OnDragStart",
        "data": {
          "body": "> 행 또는 셀 단위 Drag를 시작할 때 이벤트가 발생 합니다. ### Syntax ```javascript function 오브젝트ID_OnDragStart(Row, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|Drag 위치의 Row Index| |Col|`Long`|Drag 위치의 Column Index| ### Example ```javascript var dragValue = \"\"; function mySheet_OnDragStart(Row, Col) { // Drag 시작위치의 CellValue를 저장 dragValue = mySheet.GetCellValue(Row, Col) ; } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnDragStart.html"
      },
      {
        "cid": 689,
        "sid": "OnDropEnd",
        "name": "OnDropEnd",
        "label": "OnDropEnd",
        "data": {
          "body": "> 행 단위 Drag를 시작 후 Drop 시점에 이벤트가 발생합니다. > 이벤트 인자중 Type 인자는 트리구조에서 Drop 위치의 상세 값을 전달 합니다. > Type : `1` (Drop 위치 행의 `상단`), `2` (Drop 위치 행의 `중앙`), `3` (Drop 위치 행의 `하단`) ### Syntax ```javascript function 오브젝트ID_OnDropEnd(FromSheet, FromRow, ToSheet, ToRow, X, Y, Type) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |FromSheet|`Object`|Drag 위치 Sheet 객체| |Row|`Long`|Drag 위치 Sheet 객체의 Row Index| |ToSheet|`Object`|Drop 위치 Sheet 객체| |ToRow|`Long`|Drop 위치 Sheet 객체의 Row Index| |X|`Integer`|Drop 위치의 X 좌표| |Y|`Integer`|Drop 위치의 Y 좌표| |Type|`Integer`|트리 구조인 경우 Drop 위치의 타입| ### Example ```javascript // 드래그 행을 드랍위치에 추가하고 드래그 시트에서 삭제 function mySheet_OnDropEnd(FromSheet, FromRow, ToSheet, ToRow, X, Y, Type) { var NewRow = ToObj.DataInsert(ToRow); for (var c = 0; c <= Obj.LastCol(); c++) { ToObj.SetCellValue(NewRow, c, Obj.GetCellValue(Row, c)); } Obj.RowDelete(Row); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnDropEnd.html"
      },
      {
        "cid": 690,
        "sid": "OnEditValidation",
        "name": "OnEditValidation",
        "label": "OnEditValidation",
        "data": {
          "body": "> 셀의 편집완료 시점에 수정된 값에 대해 Validation Check를 할 수 있도록 이벤트가 발생합니다. > Validation에 맞지 않다면 `ValidateFail(1)`로 설정하여 셀 편집 이전의 값으로 되돌립니다. ### Syntax ```javascript function 오브젝트ID_OnEditValidation(Row, Col, Value) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| |Value|`variant`|Format이 적용되지 않은 저장 시 사용되는 값| ### Example ```javascript function mySheet_OnEditValidation(row, col, value) { if (mySheet.colSaveName(col) == \"ITMS_CD\") { if (value.indexOf(\"현행\") > -1) { console.log(\"현행 정보값은 4/4분기 이후에 설정 가능\"); //값을 이전 값으로 되돌림 mySheet.ValidateFail(1); } } } ``` ### See also * [VaildateFail method](/docs/funcs/core/ValidateFail) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnEditValidation.html"
      },
      {
        "cid": 691,
        "sid": "OnEncryption",
        "name": "OnEncryption",
        "label": "OnEncryption",
        "data": {
          "body": "> 시트의 데이터를 저장할 때 변경된 내용들을 QueryString으로 묶게 되는데, 이때 암호화가 필요하거나 값을 변경하여 저장해야 하는 경우 사용하는 이벤트입니다. > 데이터를 저장할때, 유효성의 검증이 필요하다면 `OnValidation` 이벤트를 통해 저장할지 여부를 결정할 수 있습니다. > 하지만 무조건 저장을 한다는 가정하에 만약 특정 값이 들어있으면 값을 바꾸어 저장해야 한다면 이 이벤트를 통하여 기능 구현이 가능합니다. ### Syntax ```javascript function 오브젝트ID_OnEncryption(Row, Col, Value) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|셀의 Row Index| |Col|`Long`|셀의 Col Index| |SaveName|`String`|컬럼의 SaveName| |Value|`String`|셀의 현재 데이터| ### Example ```javascript function mySheet_OnEncryption(Row, Col, SaveName, Value){ /* 저장할 값을 매개변수로 암호화를 수행하는 Enc 사용자 함수를 호출하여 리턴한다*/. return Enc(Value); } ``` ### See also * [OnValidation event](/docs/event/OnValidation) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnEncryption.html"
      },
      {
        "cid": 692,
        "sid": "OnExportEncryption",
        "name": "OnExportEncryption",
        "label": "OnExportEncryption",
        "data": {
          "body": "> 시트의 데이터를 엑셀 또는 텍스트 파일로 변환시 각 셀에 대한 데이터 수집시 발생하는 이벤트입니다. > 해당 셀의 데이터에 대한 암호화 또는 마스킹 처리를 하는 경우 이 이벤트를 이용하여 처리 합니다. > 이 이벤트에서 반환값이 있는 경우 해당 셀의 데이터는 반환한 값으로 치환되어 처리 됩니다. > `주의` 해당 이벤트는 PDF 문서변환은 지원하지 않습니다. ### Syntax ```javascript function 오브젝트ID_OnExportEncryption(Row, Col, SaveName, Value) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|셀의 Row Index| |Col|`Long`|셀의 Col Index| |SaveName|`String`|컬럼의 SaveName| |Value|`String`|셀의 현재 데이터| ### Example ```javascript function mySheet_OnExportEncryption(Row, Col, SaveName, Value){ var val = Value; // SaveName 이 sName 인 경우 마지막 문자열을 *로 치환. if (SaveName == \"sName\") { val = val.substring(0, val.length – 1) + \"*\"; return val; } } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.2||",
          "since": "|version|desc||---|---||7.0.13.2||"
        },
        "url": "docs/event/OnExportEncryption.html"
      },
      {
        "cid": 693,
        "sid": "OnFilterEnd",
        "name": "OnFilterEnd",
        "label": "OnFilterEnd",
        "data": {
          "body": "> 필터링이 완료된 후에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_ OnFilterEnd(RowCnt, FirstRow) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |RowCnt|`Long`|필터링된 이후 행의 개수| |FirstRow|`Long`|필터링된 이후 첫번째 행의 Index| ### Example ```javascript function mySheet_ OnFilterEnd(RowCnt, FirstRow) { // 필터링 완료된 이후 처리할 로직 } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnFilterEnd.html"
      },
      {
        "cid": 694,
        "sid": "OnGroupFinish",
        "name": "OnGroupFinish",
        "label": "OnGroupFinish",
        "data": {
          "body": "> 그룹핑 처리가 완료된 시점에 이 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_ OnGroupFinish(Group) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Group|`String`|그룹 기준 컬럼의 SaveName을 구분자 `\"|\"`로 연결한 문자열| ### Example ```javascript function mySheet_OnGroupFinish(group) { console.log(\"그룹기준 컬럼 : \", group.split(\"|\").join(\", \")); } ``` ### See also ### Since |version|desc| |---|---| |7.0.12.1||",
          "since": "|version|desc||---|---||7.0.12.1||"
        },
        "url": "docs/event/OnGroupFinish.html"
      },
      {
        "cid": 695,
        "sid": "OnGroupStart",
        "name": "OnGroupStart",
        "label": "OnGroupStart",
        "data": {
          "body": "> 그룹핑 처리가 되기전 시점에 이 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_ OnGroupStart(cols) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |cols|`String`|그룹 컬럼 정보| ### Example ```javascript function mySheet_OnGroupStart(cols) { //현재 Group 중인 컬럼 console.log(\"Group : \" + col); } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.83||",
          "since": "|version|desc||---|---||7.0.13.83||"
        },
        "url": "docs/event/OnGroupStart.html"
      },
      {
        "cid": 696,
        "sid": "OnHScroll",
        "name": "OnHScroll",
        "label": "OnHScroll",
        "data": {
          "body": "> 가로스크롤 시 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnHScroll(hpos, oldhpos, isLeft, isRight, section) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |hpos|`Long`|가로 스크롤 값| |oldhpos|`Long`|이전 가로 스크롤 값| |isLeft|`Boolean`|가로 스크롤이 좌측 끝에 위치했는지 여부| |isRight|`Boolean`|가로 스크롤이 우측 끝에 위치했는지 여부| |section|`Int`|스크롤 섹션값 (항상 1이 반환)| ### Example ```javascript function mySheet_OnHScroll(hpos, oldhpos, isLeft, isRight, section) { //가로스크롤시 수행할 로직 } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnHScroll.html"
      },
      {
        "cid": 697,
        "sid": "OnKeyDown",
        "name": "OnKeyDown",
        "label": "OnKeyDown",
        "data": {
          "body": "> 셀의 값을 수정 중이거나 선택된 셀에 키보드를 누른 경우 이벤트가 발생합니다. > KeyCode는 아스키 값이므로 변환하여 사용합니다. ### Syntax ```javascript function 오브젝트ID_OnKeyDown(Row, Col, KeyCode, Shift) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| |KeyCode|`Integer`|키보드의 아스키 값| |Shift|`Integer`|1 : Shift키가 눌린 경우 2 : Ctrl키가 눌린 경우 0 : 그외| ### Example ```javascript function mySheet_OnKeyDown(Row, Col, KeyCode, Shift) { //마지막 컬럼에서 엔터키가 눌린 경우 다음행의 처음에 포커스 두기 if(KeyCode == 13 && Col == mySheet.LastCol()) { mySheet.SelectCell(Row + 1, 2); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnKeyDown.html"
      },
      {
        "cid": 698,
        "sid": "OnKeyUp",
        "name": "OnKeyUp",
        "label": "OnKeyUp",
        "data": {
          "body": "> 셀의 값을 수정 중이거나 선택된 셀에 눌린 키보드가 올라오는 경우 이벤트가 발생합니다. > `OnKeyDown` 이벤트 발생 후에 바로 발생한다. > KeyCode는 아스키 값이므로 변환하여 사용합니다. ### Syntax ```javascript function 오브젝트ID_OnKeyUp(Row, Col, KeyCode, Shift) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| |KeyCode|`Integer`|키보드의 아스키 값| |Shift|`Integer`|1 : Shift키가 눌린 경우 2 : Ctrl키가 눌린 경우 0 : 그외| ### Example ```javascript function mySheet_OnKeyUp(Row,Col,KeyCode,Shift) { //마지막 컬럼에서 엔터키가 눌린 경우 다음 행의 처음에 포커스 두기 if(KeyCode == 13 && Col == mySheet.LastCol() && Row < mySheet.RowCount()) { mySheet.SelectCell(Row + 1, 2); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnKeyUp.html"
      },
      {
        "cid": 699,
        "sid": "OnLoad",
        "name": "OnLoad",
        "label": "OnLoad",
        "data": {
          "body": "> `createIBSheet` 또는 `Reset` 메소드 호출시 시트의 객체가 생성 완료시점에 이 이벤트가 발생합니다. > 이 이벤트는 `body의 onload 이전에 발생`하며 DOM 엘리먼트 생성이전 시점이기 때문에 시트 객체의 메소드 확장 또는 재정의 목적으로 사용하여야 하며 초기화는 이 이벤트내에서 처리 할 수 없습니다. > (body 의 onload 이후 시점에서만 가능) ### Syntax ```javascript function 오브젝트ID_OnLoad() { } ``` ### Parameters ***none*** ### Example ```javascript function mySheet_OnLoad() { // 시트 객체에 CusomMethod 메소드를 추가 mySheet.CustomMethod = function(arg1, arg2) { } } ``` ### See also ### Since |version|desc| |---|---| |7.0.3.0||",
          "since": "|version|desc||---|---||7.0.3.0||"
        },
        "url": "docs/event/OnLoad.html"
      },
      {
        "cid": 700,
        "sid": "OnLoadData",
        "name": "OnLoadData",
        "label": "OnLoadData",
        "data": {
          "body": "> 데이터 조회 관련 메소드 및 저장 메소드 호출시 서버로부터 데이터를 받은후 시트로 로드할때 발생합니다. > 이 이벤트는 서버로부터 데이터를 받은 후 데이터를 수정 하거나 암호화 모듈과 연동하는 경우에 사용합니다. ### Syntax ```javascript function 오브젝트ID_OnLoadData(Data) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Data|`String`|조회 XML 또는 JSON 문자열/객체| ### Example ```javascript function mySheet_OnLoadData(data) { // 복호화 처리 var decrypt_data = fnDecryption(data); // 복호화된 데이터 리턴 return decrypt_data; } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnLoadData.html"
      },
      {
        "cid": 701,
        "sid": "OnLoadExcel",
        "name": "OnLoadExcel",
        "label": "OnLoadExcel",
        "data": {
          "body": "> `LoadExcel` 처리가 완료된 후에 이벤트가 발생합니다. > Code, Msg 인자는 실패의 경우에만 해당 값이 전달 됩니다. ### Syntax ```javascript function 오브젝트ID_OnLoadExcel(result, code, msg) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |result|`Boolean`|로드한 결과. 성공 : true, 실패 : false| |Code|`Number`|결과 코드| |Msg|`String`|결과 메시지| 로드 중 에러 발생시, 각 음수 코드에 대응하는 에러는 다음과 같습니다. | Code | Msg | Description | |----------|----------|------------| |`-1`| Ibmsg 파일의 SYS_OverMaxRow | load.setMaxRow로 설정한 갯수보다 더 많이 행을 로드하려는 경우| |`-2`| Ibmsg 파일의 SYS_OverMaxColumns |load.setStrictHeaderMatch 설정시, 시트 헤더가 엑셀에 하나라도 존재하지 않는 경우| |`-3`| Ibmsg 파일의 SYS_NoMatchedHeader | load.setMaxColumns로 설정한 갯수보다 더 많이 열을 로드하려는 경우 | |`-10`| Ibmsg 파일의 SYS_OverMaxFileSize | load.setMaxFileSize로 설정한 사이즈보다 더 사이즈가 큰 파일을 로드하려는 경우 (서버모듈 2.0에서만 발생합니다.)| |`-500`| Ibmsg 파일의 SYS_LoadExcelError | 엑셀 로드시 오류가 발생한 경우 | |그외| 사용자 메세지 | | ### Example ```javascript function mySheet_OnLoadExcel(result, code, msg) { if(result) { alert(\"엑셀 로딩이 완료되었습니다.\"); } else { //오류일 경우 에러 메세지 표시 alert(msg); } } ``` ### See also * [LoadExcel method](/docs/funcs/import/LoadExcel) ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.13|Code, Msg 인자 추가| |7.0.13.243|모든 에러 Code, Msg OnLoadExcel 로 전달 하도록 수정|",
          "since": "|version|desc||---|---||7.0.0.0|||7.0.13.13|Code, Msg 인자 추가||7.0.13.243|모든 에러 Code, Msg OnLoadExcel 로 전달 하도록 수정|"
        },
        "url": "docs/event/OnLoadExcel.html"
      },
      {
        "cid": 702,
        "sid": "OnLoadFileSelect",
        "name": "OnLoadFileSelect",
        "label": "OnLoadFileSelect",
        "data": {
          "body": "> Excel, Text 로드시 파일을 선택할 때 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnLoadFileSelect(from, fileName) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |From|`String`|엑셀, 텍스트 구분| |FileName|`String`|파일경로 및 파일 명| ### Example ```javascript function mySheet_OnLoadFileSelect(from, fileName) { if(from == \"Excel\") { console.log(from + \"파일이 선택되었습니다. 경로 : \" + filename); } else if (from == \"TEXT\") { console.log(from + \"파일이 선택되었습니다. 경로 : \" + filename); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnLoadFileSelect.html"
      },
      {
        "cid": 703,
        "sid": "OnLoadText",
        "name": "OnLoadText",
        "label": "OnLoadText",
        "data": {
          "body": "> `LoadText` 처리가 완료된 후에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnLoadText(result) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |result|`Boolean`|로드한 결과 (성공 : true, 실패 : false)| ### Example ```javascript function mySheet_OnLoadText(result) { if(result) { alert(‘텍스트 파일 로딩이 완료되었습니다.'); } else { alert(‘텍스트 파일 로딩중 오류가 발생하였습니다.'); } } ``` ### See also * [LoadText method](/docs/funcs/import/LoadText) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnLoadText.html"
      },
      {
        "cid": 704,
        "sid": "OnMessage",
        "name": "OnMessage",
        "label": "OnMessage",
        "data": {
          "body": "> `SetShowMsgMode(0)`인 경우 각종 확인 메시지 또는 경고 메시지가 발생했을 때 시스템 팝업이 표시되는 것이 아니라 이 이벤트가 발생합니다. > 확인 메시지인 경우는 IsConfirm = 1이므로, 반드시 `ConfirmOK` 함수를 이용하여 응답 결과를 Sheet로 되돌려 줍니다. ### Syntax ```javascript function 오브젝트ID_OnMessage(msg, level, isConfirm) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |msg|`String`|메시지| |level|`String`|메시지레벨 - `U` : EndUser를 위한 메시지 - `E` : 개발자를 위한 메시지 - `D` : 서버 연결 함수의 페이지 관련 메시지 - `X` : 조회, 저장 XML의 XML 파서 메시지| |isConfirm|`Boolean`|확인 메시지 여부| ### Example ```javascript //메시지 모드를 설정한다. mySheet.SetShowMsgMode(0); //OnMessage 이벤트를 처리한다. function mySheet_OnMessage(msg, level, isConfirm) { //메시지 표시하기 var win_result = window.showModalDialog( \"sheet_message.jsp?msg=\" + msg + \"&isConfirm=\" + isConfirm, \"modalResult\", \"dialogWidth:200px;dialogHeight:200px;center:yes;help:no;status:no;\"); //Sheet로 메시지 결과를 반환한다. if(IsConfirm) mySheet.ConfirmOK(win_result); } ``` ### See also * [ConfirmOK method](/docs/funcs/core/ConfirmOK) * [SetShowMsgMode method](/docs/funcs/core/SetShowMsgMode) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnMessage.html"
      },
      {
        "cid": 705,
        "sid": "OnMouseDown",
        "name": "OnMouseDown",
        "label": "OnMouseDown",
        "data": {
          "body": "> 마우스가 눌려졌을 때 이벤트가 발생합니다. > 마우스가 눌린 셀의 위치를 알고자 한다면 `MouseRow` 와 `MouseCol` 함수를 이용하면 됩니다. ### Syntax ```javascript function 오브젝트ID_OnMouseDown(Button, Shift, X, Y) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Button|`Integer`|0 : 왼쪽, 2 : 오른쪽 (마우스버튼 방향)| |Shift|`Integer`|1 : Shift키가 눌린 경우 2 : Ctrl키가 눌린 경우 0 : 그외| |X|`Long`|X좌표| |Y|`Long`|Y좌표| ### Example ```javascript function mySheet_OnMouseDown(Button, Shift, X, Y) { //눌린 컬럼 확인 alert(mySheet.MouseRow() + \"행 \" + mySheet.MouseCol() + \"컬럼이 눌림\"); } ``` ### See also * [MouseRow method](/docs/funcs/row/MouseRow) * [MouseCol method](/docs/funcs/col/MouseCol) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnMouseDown.html"
      },
      {
        "cid": 706,
        "sid": "OnMouseMove",
        "name": "OnMouseMove",
        "label": "OnMouseMove",
        "data": {
          "body": "> 마우스가 Sheet 위에서 이동되었을 때 이벤트가 발생합니다. > 마우스가 이동하고있는 셀의 위치를 알고자 한다면 `MouseRow`와 `MouseCol` 함수를 이용하면 됩니다. ### Syntax ```javascript function 오브젝트ID_OnMouseMove(Button, Shift, X, Y) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Button|`Integer`|0 : 왼쪽, 2 : 오른쪽 (마우스버튼 방향)| |Shift|`Integer`|1 : Shift키가 눌린 경우 2 : Ctrl키가 눌린 경우 0 : 그외| |X|`Long`|X좌표| |Y|`Long`|Y좌표| ### Example ```javascript function mySheet_OnMouseMove(Button, Shift, X, Y) { //마우스 위치를 행과 컬럼과 값 가져오기 var Row = mySheet.MouseRow(); var Col = mySheet.MouseCol(); var sText = mySheet.GetCellText(Row, Col); //2컬럼이고 내용이 2011-07-14일때만 div popup을 보여줌 if(Col == 2 && sText == \"2011-07-14\") { $(\"#div_pop_summary\").show(); } else { $(\"#div_pop_summary\").hide(); } } ``` ### See also * [MouseRow method](/docs/funcs/row/MouseRow) * [MouseCol method](/docs/funcs/col/MouseCol) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnMouseMove.html"
      },
      {
        "cid": 707,
        "sid": "OnMouseUp",
        "name": "OnMouseUp",
        "label": "OnMouseUp",
        "data": {
          "body": "> 눌려진 마우스 버튼이 올라올 때 이벤트가 발생합니다. > 버튼이 올라온 셀의 위치를 알고자 한다면 `MouseRow`와 `MouseCol` 함수를 이용하면 됩니다. ### Syntax ```javascript function 오브젝트ID_OnMouseUp(Button, Shift, X, Y) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Button|`Integer`|0 : 왼쪽, 2 : 오른쪽 (마우스버튼 방향)| |Shift|`Integer`|1 : Shift키가 눌린 경우 2 : Ctrl키가 눌린 경우 0 : 그외| |X|`Long`|X좌표| |Y|`Long`|Y좌표| ### Example ```javascript function mySheet_OnMouseUp(Button, Shift, X, Y) { //마우스 버튼이 올라온 컬럼 확인 alert(mySheet.MouseRow() + \"행 \" + mySheet.MouseCol() + \"컬럼이 눌림\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnMouseUp.html"
      },
      {
        "cid": 708,
        "sid": "OnMovePage",
        "name": "OnMovePage",
        "label": "OnMovePage",
        "data": {
          "body": "> `smClientPaging` 모드에서 페이지 네비게이션 또는 페이지 이동 메소드를 통해 페이지를 이동하는 경우 이동 전에 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnMovePage (Current, Move) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Current|`Number`|페이지 이동전의 현재 페이지 번호| |Move|`Number`|이동할 페이지 번호| ### Example ```javascript function mySheet_OnMovePage(current, move) { // 페이지 이동 후 경고창을 띄운다. alert(“페이지 이동 했습니다.”); } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.116||",
          "since": "|version|desc||---|---||7.0.13.116||"
        },
        "url": "docs/event/OnMovePage.html"
      },
      {
        "cid": 709,
        "sid": "OnPageRequest",
        "name": "OnPageRequest",
        "label": "OnPageRequest",
        "data": {
          "body": "> `서버페이징` 조회시 스크롤이 이동하여 해당 페이지를 새로 로딩하기 위하여 서버에 해당 페이지를 요청할때 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnPageRequest(page) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |page|`Integer`|요청할 페이지 번호| ### Example ```javascript function mySheet_OnPageRequest(page) { //서버에 해당 페이지를 요청하기 직전에 경고창을 띄운다. alert(page + \" 페이지를 서버에 요청합니다.\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnPageRequest.html"
      },
      {
        "cid": 710,
        "sid": "OnPopupClick",
        "name": "OnPopupClick",
        "label": "OnPopupClick",
        "data": {
          "body": "> 셀의 Type이 `Popup`이거나 `PopupButton` 을 사용하는 셀인 경우 해당 셀에 포커스가 갔을 때 보이는 팝업 버튼을 마우스로 클릭하거나 Edit하려고 할 때 이벤트가 발생합니다. > 사용자는 이 이벤트에서 팝업 호출 로직을 기재하여 팝업 처리하면 됩니다. ### Syntax ```javascript function 오브젝트ID_OnPopupClick(Row, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| ### Example ```javascript function mySheet_OnPopupClick(Row,Col) { //팝업을 연다. window.open(\"Sheet_Popup.jsp?row=\"+Row+\"&col=\"+Col, \"list\", \"scrollbars=no,fullscreen=no,width=250,height=350\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnPopupClick.html"
      },
      {
        "cid": 711,
        "sid": "OnResize",
        "name": "OnResize",
        "label": "OnResize",
        "data": {
          "body": "> 너비를 %로 설정할 때, IBSheet의 너비 또는 높이가 변경된 경우 이벤트가 발생합니다. > 이 이벤트는 사용자가 드래그를 통해 창의 사이즈를 조절하는 경우 굉장히 빈번하게 발생하여 브라우저에 부담을 줄 수 있습니다. > 따라서 가급적이면 이 이벤트보다는 `OnSmartResize` 이벤트를 사용할 것을 권장합니다. ### Syntax ```javascript function 오브젝트ID_OnResize(Width, Height) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Width|`Integer`|전체 너비| |Height|`Integer`|전체 높이| ### Example ```javascript function mySheet_OnResize(Width, Height) { //변경된 정보에 따라 컬럼들의 너비를 재조정한다. mySheet.FitColWidth(); } ``` ### See also * [OnSmartResize event](/docs/event/OnSmartResize) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnResize.html"
      },
      {
        "cid": 712,
        "sid": "OnRowDelete",
        "name": "OnRowDelete",
        "label": "OnRowDelete",
        "data": {
          "body": "> RowDelete 또는 신규행의 DelCheck 타입 클릭 후 행 삭제 시점에 발생하는 이벤트입니다. ### Syntax ```javascript function 오브젝트ID_OnRowDelete(row, api) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |row|`Long`|대상 행 Index| |api|`boolean`|메소드(RowDelete) 호출에 의한 삭제 여부| ### Example ```javascript function mySheet_OnRowDelete(row, api) { //행 삭제 시 대상 행 및 메소드호출 여부 console.log(\"DeleteRow : \" + row + \"CallApi : \" + api) } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.58||",
          "since": "|version|desc||---|---||7.0.13.58||"
        },
        "url": "docs/event/OnRowDelete.html"
      },
      {
        "cid": 713,
        "sid": "OnRowSearchEnd",
        "name": "OnRowSearchEnd",
        "label": "OnRowSearchEnd",
        "data": {
          "body": "> `DoSearch`나 `LoadSearchData` 메서드를 통해 데이터가 조회되는 과정에서 행단위로 발생합니다. > 특정 행의 데이터를 기준으로 판단하여 Cell에 색상이나 배경색등을 표현하고자 하는 경우 유용하게 쓰일수 있습니다. > `주의` 이 기능은 조회 중에 행단위로 한번씩 발생함으로 이벤트 안에 로직이 복잡하거나 반복문이 들어가는 경우 조회속도가 저하될 수 있습니다. ### Syntax ```javascript function 오브젝트ID_OnRowSearchEnd (row) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |row|`Integer`|행의 인덱스| ### Example ```javascript function mySheet_OnRowSearchEnd(row) { //3번컬럼이 check되어있고, 4번 컬럼의 값이 100보다 클때, 6번 컬럼의 글자 색상을 붉은색으로 변경한다. if( mySheet.GetCellValue(row,3) == 1 && mySheet.GetCellValue(row,4) > 100){ mySheet.SetCellFontColor(row ,6 ,\"#FF0000\"); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnRowSearchEnd.html"
      },
      {
        "cid": 714,
        "sid": "OnSaveEnd",
        "name": "OnSaveEnd",
        "label": "OnSaveEnd",
        "data": {
          "body": "> 저장 함수를 이용하여 저장 처리를 완료하고, 내부적인 처리를 마친 후 이벤트가 발생합니다. > 저장 중 오류 메시지가 발생한 경우 이벤트 인자인 code로 설정되므로, code가 0보다 작은 경우 오류 처리 로직을 작성하여 처리합니다. > `DoSave` 함수 또는 `DoAllSave` 함수를 호출할 때 이 이벤트가 발생합니다. > `Response` 인자는 서버에서 정상적으로 처리 되지 않은 경우에만 전달됩니다. (HTTP 응답코드가 100 보다 작거나 400보다 큰 경우에만 전달) ### Syntax ```javascript function 오브젝트ID_OnSaveEnd(Code, Msg, StCode, StMsg, [Response]) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Code|`Long`|처리결과 코드(0 이상이면 정상, 그외는 오류 처리) <span style=\"color:blue;\">-3</span> : 요청 Url이 잘못된 경우나 네트워크 오류 등으로 결과를 받지 못한 경우 <span style=\"color:blue;\">-4</span> : 정상적인 응답은 받았으나 데이터 파싱처리중 오류가 발생한 경우(대부분 데이터 이상) <span style=\"color:blue;\">-5</span> : 응답 결과가 빈값인 경우 <span style=\"color:blue;\">-6</span> : 서버에 연결하여 응답을 대기하는 시간이 초과된 경우(WaitTimeOut 초과) <span style=\"color:blue;\">그외</span> : 사용자 정의 코드| |Msg|`String`|처리결과 메시지| |StCode|`Integer`|HTTP 응답 코드| |StMsg|`String`|HTTP 응답 메시지| |Response|`String`|서버 응답 결과| ### Example ```javascript function mySheet_OnSaveEnd(code, msg) { if(code >= 0) { alert(msg); // 저장 성공 메시지 mySheet.DoSearch(\"list1.jsp\"); } else { alert(msg); // 저장 실패 메시지 } } <?xml version=‘1.0‘ ?> <SHEET><Result Code=\"-1\" Message= „전표 처리 완료 되어 수정할 수 없습니다.\"/></SHEET> <?xml version='1.0' ?> <SHEET><Result Code = \"0\" Message = \"\" / ></SHEET> ``` ### See also * [DoSave method](/docs/funcs/save/DoSave) * [DoAllSave method](/docs/funcs/save/DoAllSave) ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.30|Response 인자 추가|",
          "since": "|version|desc||---|---||7.0.0.0|||7.0.13.30|Response 인자 추가|"
        },
        "url": "docs/event/OnSaveEnd.html"
      },
      {
        "cid": 715,
        "sid": "OnSearchEnd",
        "name": "OnSearchEnd",
        "label": "OnSearchEnd",
        "data": {
          "body": "> 조회 함수를 이용하여 조회 처리를 완료하고, 내부적인 처리를 마친 후 이벤트가 발생합니다. > 조회 중 오류 메시지가 발생한 경우 이벤트 인자인 code로 설정되므로, code가 0보다 작은 경우 오류 처리 로직을 작성하여 처리합니다. > `Response` 인자는 서버에서 정상적으로 처리 되지 않은 경우에만 전달됩니다. (HTTP 응답코드가 100 보다 작거나 400보다 큰 경우에만 전달) ### Syntax ```javascript function 오브젝트ID_OnSearchEnd(Code, Msg, StCode, StMsg, [Response]) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Code|`Long`|처리결과 코드(0 이상이면 정상, 그외는 오류 처리) <span style=\"color:blue;\">-3</span> : 요청 Url이 잘못된 경우나 네트워크 오류 등으로 결과를 받지 못한 경우 <span style=\"color:blue;\">-4</span> : 정상적인 응답은 받았으나 데이터 파싱처리중 오류가 발생한 경우(대부분 데이터 이상) <span style=\"color:blue;\">-5</span> : 응답 결과가 빈값인 경우 <span style=\"color:blue;\">-6</span> : 서버에 연결하여 응답을 대기하는 시간이 초과된 경우(WaitTimeOut 초과) <span style=\"color:blue;\">그외</span> : 사용자 정의 코드| |Msg|`String`|처리결과 메시지| |StCode|`Integer`|HTTP 응답 코드| |StMsg|`String`|HTTP 응답 메시지| |Response|`String`|서버 응답 결과| ### Example ```javascript function mySheet_OnSearchEnd(code, message) { if(code == 0) { alert(message); //조회 후 작업 수행 } else { alert(\"조회 중에 오류가 발생하였습니다..\"); } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.30|Response 인자 추가|",
          "since": "|version|desc||---|---||7.0.0.0|||7.0.13.30|Response 인자 추가|"
        },
        "url": "docs/event/OnSearchEnd.html"
      },
      {
        "cid": 716,
        "sid": "OnSelectCell",
        "name": "OnSelectCell",
        "label": "OnSelectCell",
        "data": {
          "body": "> 특정 셀이 선택되었을 때 이벤트가 발생합니다. > 기존에 선택되었던 셀 정보와 새로 선택된 셀 정보를 모두 반환하므로 선택된 셀에 대한 처리 로직을 기재할 수 있습니다. ### Syntax ```javascript function 오브젝트ID_OnSelectCell(OldRow, OldCol, NewRow, NewCol,isDelete) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |OldRow|`Long`|이전 선택 셀의 Row Index| |OldCol|`Long`|이전 선택 셀의 Column Index| |NewRow|`Long`|현재 선택 셀의 Row Index| |NewCol|`Long`|현재 선택 셀의 Column Index| |isDelete|`Boolean`|추가된 행을 DelCheck를 통해 삭제하는 경우, 같은 위치를 기준으로 OnSelectCell 이벤트가 발생하는데, 이때 행 삭제됨을 구분해 주기 위한 값| ### Example ```javascript function mySheet_OnSelectCell(OldRow, OldCol, NewRow, NewCol,isDelete) { alert(\"셀(\"+ OldRow + \",\" + OldCol + \")을 선택하였다가 셀(\" + NewRow + \",\" + NewCol +\")을 선택하였습니다.\"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnSelectCell.html"
      },
      {
        "cid": 717,
        "sid": "OnSelectEnd",
        "name": "OnSelectEnd",
        "label": "OnSelectEnd",
        "data": {
          "body": "> 마우스 드래그 또는 키 입력으로 셀 영역 선택 완료 시점에 이벤트가 발생 합니다. ### Syntax ```javascript function 오브젝트ID_OnSelectEnd(Rows, Cols) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Rows|`String`|선택된 행의 Index를 구분자 `\"|\"`로 연결한 문자열| |Cols|`String`|선택된 컬럼의 Index를 구분자 `\"|\"`로 연결한 문자열| ### Example ```javascript function mySheet_OnSelectEnd(Rows, Cols) { console.log(\"SelectedRows:\", Rows, \"SelectedCols\", Cols); } ``` ### See also ### Since |version|desc| |---|---| |7.0.13.26||",
          "since": "|version|desc||---|---||7.0.13.26||"
        },
        "url": "docs/event/OnSelectEnd.html"
      },
      {
        "cid": 718,
        "sid": "OnSelectMenu",
        "name": "OnSelectMenu",
        "label": "OnSelectMenu",
        "data": {
          "body": "> 컬럼 팝업 메뉴가 아닌 ActionMenu에 설정된 메뉴가 표시되고, 사용자가 특정한 메뉴 항목을 선택할 때 이벤트가 발생합니다. > 이벤트에서 반환하는 Text는 메뉴항목에 표시된 글자와 동일하므로 각각 해당하는 기능을 처리합니다. > `Col` 인자는 컬럼의 ActionMenu 선택시에만 사용 할 수 있습니다. ### Syntax ```javascript function 오브젝트ID_OnSelectMenu(Text, Code, Col) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Text|`String`|선택된 메뉴 문자열| |Code|`String`|선택된 메뉴 코드 문자열| |Col|`Long`|대상 컬럼의 Index| ### Example ```javascript // 메뉴설정 mySheet.SetActionMenu(\"입력|행복사|-|행삭제|Clear|엑셀다운로드\"); function mySheet_ OnSelectMenu(Text, Code) { // text 또는 code값으로 Action수행 switch(text) { case \"첫행입력\" : mySheet.DataInsert(0); break; case \"마지막행입력\" : mySheet.DataInsert(-1); break; case \"입력\" : mySheet.DataInsert(); break; case \"행복사\": mySheet.DataCopy(); break; case \"행삭제\": mySheet.RowDelete(); break; case \"Clear\": //RemoveAll mySheet.RemoveAll(); break; case \"엑셀다운로드\": mySheet.Down2Excel(); break; default: break; } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.13.16|Col 인자 추가|",
          "since": "|version|desc||---|---||7.0.0.0|||7.0.13.16|Col 인자 추가|"
        },
        "url": "docs/event/OnSelectMenu.html"
      },
      {
        "cid": 719,
        "sid": "OnSmartResize",
        "name": "OnSmartResize",
        "label": "OnSmartResize",
        "data": {
          "body": "> 시트의 너비 또는 높이가 최초 변경 시점부터 일정간격 (300ms)동안 재발생이 없는 시점에 이 이벤트가 발생합니다. > Resize시점에 FitColWidth 등의 처리를 하는 경우 OnResize 이벤트가 아닌 이 이벤트에서 처리하는 것이 성능 개선에 도움이 됩니다. > 이 이벤트는 전역 또는 `SetConfig` 메소드에서 `SmartResize 속성을 0(false)` 로 설정한 경우에만 발생하며, 1(true)로 설정한 경우에는 발생하지 않고, OnResize 이벤트가 위의 설명처럼 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnSmartResize(Width, Height) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Width|`Integer`|전체 너비| |Height|`Integer`|전체 높이| ### Example ```javascript function mySheet_OnSmartResize(Width, Height) { //변경된 정보에 따라 컬럼들의 너비를 재조정 mySheet.FitColWidth(); } ``` ### See also * [SetConfig method](/docs/funcs/init/SetConfig) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnSmartResize.html"
      },
      {
        "cid": 720,
        "sid": "OnSort",
        "name": "OnSort",
        "label": "OnSort",
        "data": {
          "body": "> 헤더를 마우스로 눌러 데이터가 소트 완료 되었을 때 이벤트가 발생합니다. > Col 인자는 컬럼 Index 번호이고, SortOrder는 소트 방향으로 아래와 같이 표현됩니다. > 전역속성 `SortEventMode` 가 1로 설정되어 있으면 소트되어 있는 모든 컬럼의 정보가 \"|\"로 구분하여 표현됩니다. ### Syntax ```javascript function 오브젝트ID_OnSort(Col, SortOrder) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Col|`Long or String`|소트가 처리된 컬럼 인덱스 SortEventMode 가 1인 경우 `\"|\"`로 구분| |SortOrder|`String`|소트 방향 문자열 SortEventMode 가 1인 경우 `\"|\"`로 구분 ASC(오름차순) / DESC(내림차순)| ### Example ```javascript function mySheet_OnSort(col, order) { if(order ==\"ASC\") alert(col + \"번째 컬럼이 오름차순으로 정렬되었습니다.\"); else alert(col + \"번째 컬럼이 내림차순으로 정렬되었습니다.\"); } ``` ### See also * [SortEventMode Cfg](/docs/props/PropertyList/SortEventMode) ### Since |version|desc| |---|---| |7.0.0.0|| |7.0.6.0|단위데이터행 구조에 대한 지원|",
          "since": "|version|desc||---|---||7.0.0.0|||7.0.6.0|단위데이터행 구조에 대한 지원|"
        },
        "url": "docs/event/OnSort.html"
      },
      {
        "cid": 721,
        "sid": "OnTab",
        "name": "OnTab",
        "label": "OnTab",
        "data": {
          "body": "> 시트에서 탭 키를 누르는 경우 발생하는 이벤트입니다. > `isLast` 인자의 경우 탭으로 이동할 수 있는 마지막 셀인 경우 반환되는 값으로, 첫셀에서 Shift + Tab을 누르는 경우,마지막 셀에서 Tab을 누르는 경우 1을 반환합니다. > `TabBehavior`, `EditTabBehavior`를 설정한 경우 설정 값에 따라서 이동할 수 있는 마지막 셀에서 1값이 반환됩니다. (이전행/컬럼과 현재행/컬럼이 동일한 경우에 1로 반환) ### Syntax ```javascript function 오브젝트ID_OnTab(Row, Col, Old_Row, Old_Col, isShift, isLast) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|선택된 행 인덱스| |Col|`Long`|선택된 컬럼 인덱스| |Old_Row|`Long`|이전 행 인덱스| |Old_Col|`Long`|이전 컬럼 인덱스| |isShift|`Boolean`|Shift 키 입력 여부| |isLast|`Boolean`|마지막 셀 여부| ### Example ```javascript function mySheet_OnTab(Row, Col, Orow, Ocol, isShift, isLast) { alert(\"[OnTab] New : \" + Row + \",\" + Col + \" Old : \" + Orow + \",\" + Ocol + \" Shift : \" + isShift + \" isLast : \" + isLast); } ``` ### See also * [SetEditTabBehavior method](/docs/funcs/core/SetEditTabBehavior) ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnTab.html"
      },
      {
        "cid": 722,
        "sid": "OnTreeCheckChange",
        "name": "OnTreeCheckChange",
        "label": "OnTreeCheckChange",
        "data": {
          "body": "> 트리구조의 시트에서 트리 기준 컬럼에 대한 체크박스 사용 모드인 경우 해당 체크박스의 값이 변경시 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnTreeCheckChange(Row, Col, Value, Level, HasChild) {} ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|대상 행의 Index| |Col|`Long`|대상 컬럼의 Index| |Value|`Boolean`|변경된 체크박스의 값| |Level|`Number`|대상 행의 트리 레벨| |HasChild|`Boolean`|대상 행의 자식노드 존재 여부| ### Example ```javascript // 해당 행의 자식노드가 있는 경우 자식노드에 동일한값 처리 function mySheet_OnTreeCheckChange(row, col, value, level, hasChild) { var childRows = []; // 자식행이 있는 경우 if (hasChild) { // 해당 행의 바로 아래의 자식행 정보 수집 childRows = mySheet. GetChildRows(row, level + 1).split(\"|\"); for (var i = 0, len = childRows.length; i < len; i++) { // 자식행에 동일한 체크값 설정 mySheet.SetTreeCheckValue(childRows[i], value); } } } ``` ### See also ### Since |version|desc| |---|---| |7.0.9.0||",
          "since": "|version|desc||---|---||7.0.9.0||"
        },
        "url": "docs/event/OnTreeCheckChange.html"
      },
      {
        "cid": 723,
        "sid": "OnTreeChild",
        "name": "OnTreeChild",
        "label": "OnTreeChild",
        "data": {
          "body": "> 자식을 조회하지 않은 상태에서 부모 노드에서 트리 확장기능을 선택했을 때 이벤트가 발생 합니다. > 이벤트가 발생하는 자식노드를 `DoSearchChild` 조회 함수로 조회하는 기능을 처리할수 있습니다. > 트리 형태 데이터를 한꺼번에 조회하지 않고, 트리 확장 버튼을 눌렀을 때 자식 레벨의 데이터를 조회하기 위한 용도로 사용됩니다. ### Syntax ```javascript function 오브젝트ID_OnTreeChild(Row) ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|확장할 부모 행의 Index| ### Example ```javascript // 자식데이터 조회하기 function mySheet_OnTreeChild(Row){ var url = \"\"; // 4컬럼 : 트리컬럼 switch(mySheet.GetCellValue(Row, 4)){ case \"서울\" : url = \" type15_dat(1).xml\"; break; case \"인천\": url = \"type15_data(2).xml\"; break; } mySheet.DoSearchChild(Row, url, \"\", 1); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnTreeChild.html"
      },
      {
        "cid": 724,
        "sid": "OnUserResize",
        "name": "OnUserResize",
        "label": "OnUserResize",
        "data": {
          "body": "> End-User가 마우스를 이용하여 상단 헤더의 컬럼 너비를 변경할때 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnUserResize(Col, Width) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Col|`Long`|해당 Column Index| |Width|`Long`|해당 컬럼 너비| ### Example ```javascript function mySheet_OnUserResize(Col, Width) { alert(Col + \"컬럼의 너비가 \" + Width + \"로 변경되었습니다\".) } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnUserResize.html"
      },
      {
        "cid": 725,
        "sid": "OnVScroll",
        "name": "OnVScroll",
        "label": "OnVScroll",
        "data": {
          "body": "> 세로스크롤 시 이벤트가 발생합니다. ### Syntax ```javascript function 오브젝트ID_OnVScroll(vpos, oldvpos, isTop, isBottom) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |vpos|`Long`|세로 스크롤 값| |oldvpos|`Long`|이전 세로 스크롤 값| |isTop|`Boolean`|세로 스크롤이 최상단에 위치했는지 여부| |isBottom|`Boolean`|세로 스크롤이 최하단에 위치했는지 여부| ### Example ```javascript function mySheet_OnVScroll(vpos, oldvpos, isTop, isBottom) { // 세로스크롤시 처리할 로직 } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnVScroll.html"
      },
      {
        "cid": 726,
        "sid": "OnValidation",
        "name": "OnValidation",
        "label": "OnValidation",
        "data": {
          "body": "> 저장함수를 호출하여 저장 처리 하기 전에 사용자들이 저장할 값들에 대해 Validation Check 할수 있도록 이벤트가 발생합니다. > 기본적인 필수입력 항목에 대한 확인이나 전체 입력 여부에 대한 확인은 저장 전에 IBSheet가 내부적으로 확인하지만, 업무 로직에 따라 발생할 수 있는 각종 Validation을 이 이벤트에서 처리합니다. > Validation에 맞지 않다면 `ValidateFail(1)`로 설정하여 저장 처리를 중단합니다. > 이 이벤트는 저장할 데이터 각 셀단위로 발생하므로 여기서 반복문을 사용하면 시간이 오래 걸릴수 있으므로 전체에 대한 확인은 저장 함수 호출 전에 처리하고, 각 셀 단위로 확인할 로직만 기재하도록 합니다. ### Syntax ```javascript function 오브젝트ID_OnValidation(Row, Col, Value) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Row|`Long`|해당 셀의 Row Index| |Col|`Long`|해당 셀의 Column Index| |Value|`variant`|Format이 적용되지 않은 저장 시 사용되는 값| ### Example ```javascript function mySheet_OnValidation(Row, Col, Value) { switch(Col) { case 2: if(Value == \"원화\" && mySheet.GetCellValue(Row,Col+1) >= 10000000) { alert(\"통화가 원화일 때 금액은 천만원 이상일수 없습니다.\"); mySheet.ValidateFail(1); mySheet.SelectCell(Row, Col+1); } else if(Value==\"외화\" && mySheet.GetCellValue(Row,Col+1) < 10000000) { alert(\"통화가 외화일 때 금액은 천만원 이상이여야 합니다.\"); mySheet.ValidateFail(1); mySheet.SelectCell(Row, Col+1); } } } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnValidation.html"
      },
      {
        "cid": 727,
        "sid": "OnWaitTimeOut",
        "name": "OnWaitTimeOut",
        "label": "OnWaitTimeOut",
        "data": {
          "body": "> 서버에 연결하여 처리 중 일정 시간을 초과하여 처리가 중단 된 경우 이벤트가 발생합니다. > IBsheet7는 조회,저장과 같은 ajax 통신시 기본적으로 `60초`간 대기 후 커넥션을 끊으며, 이 시간은 `WaitTimeOut()` 메서드를 통해 조절이 가능합니다. ### Syntax ```javascript function 오브젝트ID_OnWaitTimeOut(Sec) { } ``` ### Parameters |Parameter|Type|Description| |-----|-----|--------------| |Sec|`Long`|타임아웃에 걸린 시간`(초)`| ### Example ```javascript function mySheet_OnWaitTimeOut(Sec) { // 시간 초과가 발생한 경우 alert(\"대기 시간을 초과 하였습니다. \"); } ``` ### See also ### Since |version|desc| |---|---| |7.0.0.0||",
          "since": "|version|desc||---|---||7.0.0.0||"
        },
        "url": "docs/event/OnWaitTimeOut.html"
      }
    ]
  },
  {
    "gid": 7,
    "name": "appx",
    "label": "Appendix",
    "children": [
      {
        "cid": 733,
        "sid": "fx",
        "name": "fx",
        "label": "Fx(Formatted) 조회 모드의 허용 데이터 포맷",
        "data": {
          "body": "## `Dosearch` 또는 `LoadSearchData` 메소드의 `Fx` 옵션 사용시 타입별 허용하는 포맷 값은 아래의 표와 같습니다. |컬럼타입|포맷|허용값|사용가능예|사용불가능예|비고| |:----:|:---:|-----|-------|--------|------| |Text|일반 사용자포맷 날짜|문자열 포맷을제외한 문자열 Date 타입 참고|&nbsp; 7912121022345 &nbsp;|&nbsp; 791212-1022345 &nbsp;|| |Popup|일반 날짜|문자열 Date 타입 참고|||| |Pass||문자열|||| |Date|날짜 시간 날짜+시간|날짜포맷 문자열 날짜포맷 문자열 날짜, 시간포맷 문자열|2012-02-16 13:15:16 2012-02-16 13:15:16|20120216 131516 20120216131516|년월일 구분자는 설정포맷과 틀려도됨 날짜와 시간 사이는 스페이스로 구분| |Int||포맷을 제외한 숫자값|1234567|1,234,567|| |Float||포맷을 제외한 숫자값|123456.789|123,456.789|| |AutoSum|Int Float|포맷을 제외한 숫자값 포맷을 제외한 숫자값|1234567 123456.789|1,234,567 123,456.789| |AutoAvg|Int Float|포맷을 제외한 숫자값 포맷을 제외한 숫자값|1234567 123456.789|1,234,567 123,456.789| |CheckBox||0 또는 1||0, 1을 제외한 문자열|| |DelCheck||0 또는 1||0, 1을 제외한 문자열|| |DummyCheck||0 또는 1||0, 1을 제외한 문자열|| |Radio||0 또는 1||0, 1을 제외한 문자열|| |Combo||설정 ComboCode값|||InitCombo NoMatchText 사용불가| |ComboEdit||설정 ComboCode값|||InitCombo NoMatchText 사용불가| |Image||Image Url|||| |Seq||공백||문자열|| |Status||I, D||공백, I, D를 제외한 문자열|| ### Fx : 1 사용시 `OnRowSearchEnd` 이벤트가 생략됩니다. ### Fx : 2 사용시 아래와 같은 기능의 제한이 생기는 대신 조회 속도를 크게 향상시킵니다. 1. 조회 모드 - `smClientPaging`, `smLazyLoad` 에서만 사용이 가능합니다. 2. 데이터 포멧 - XML 형식의 데이터는 지원하지 않으며 `JSON` 형태만 지원합니다. 그리고 JSON 형식에서 UseJsonAttribute를 통해 행단위,셀단위 서식은 지원하지 않습니다. 조회데이터 배열명인 `Data` 도 대/소문자를 반드시 구분해야 인식합니다. 3. 머지 유형 - 데이터 영역의 머지는 허용되지 않으며 `msNone`, `msHeaderOnly` 형식의 머지만 사용할 수 있습니다. 4. 계산 기능 - `ShowSubSum` 함수를 통한 소계/누계 기능은 지원하지 않고, `InitColumns` 함수의 Calclogic(열간 계산식) 기능도 지원하지 않습니다. 5. 시트 구조 - 트리형식이나 다중라인 레코드 구조의 시트는 지원하지 않습니다. 6. `LoadSearchData`의 `Option` 파라미터 - Wait와 Sync를 제외한 다른 기능은 지원하지 않습니다. 7. 이벤트 - 조회 후 발생하는 OnSearchEnd 이벤트만 지원하며, OnLoadData, OnRownSearchEnd, OnDecryption 과 같은 이벤트는 발생하지 않습니다. 8. 그 외 옵션 - DataAutoTrim, FrozenRows, DefaultValue 설정이 지원되지 않습니다. ## 그 외 각 컬럼의 Type 별 조회 허용 유형 아래 타입/포맷의 경우에는 조회 과정에서 서버로부터 넘어온 데이터를 무시하고 시트에 표시하지 않을 뿐 조회 된 이후에는 동일하게 동작합니다. |컬럼 타입|세부 내용|불허 형식| |--------|---------|----------| |Text,Popup||Date 포멧사용 불가| |CheckBox,DummyCheck|0/1 값만 사용가능|TrueValue/FalseValue값 무시| |Radio,DelCheck||조회 데이터 표시 안함| |Combo|ComboCode값 맵핑|InitComboNoMatchText() 설정 무시| |ComboEdit|ComboText값 맵핑|InitComboNoMatchText() 설정 무시| |Int,Float,AutoSum,AutoAvg|콤마가 제거된 숫자형식만 사용가능|| |Date|Ymd,Ym,Md만 사용 가능하며, 조회시 구분자를 포함하여 데이터를 조회해야 함 ex) 1987-12-26|Hms,Hm,YmdHms 형식 사용 불가| |Status,Result||조회 데이터 표시 안함|"
        },
        "url": "docs/appx/fx.html"
      },
      {
        "cid": 729,
        "sid": "Theme",
        "name": "Theme",
        "label": "Theme 만들기",
        "data": {
          "body": "> ibsheet는 기본적으로 `ibsheet.js` 파일이 위치한 폴더 > `Main`폴더 안에 있는 이미지 파일과 `ibsheet.css` 파일을 이용하여 디자인을 구성합니다. > 만약 다른 디자인을 만들거나 기존의 디자인을 수정하고자 하는 경우에는 아래와 같이 수정하여 사용합니다. 1. Main 폴더를 하나 다른 이름으로 복사합니다. (여기서는 \"DeepBlue\"라는 폴더로 복사했다고 가정) 2. 폴더안에 각종 버튼 이미지를 개발하는 프로젝트 테마에 맞게 변경합니다. 3. 시트의 색상은 `ibsheet.css` 파일을 참고하게 되는데, 이 파일을 열어보면 모든 css class 명이 .GM으로 시작하는 걸 확인할 수 있습니다. 이 이름을 다른 이름으로 교체하여야만 사용이 가능합니다. (여기서는 .GM을 .DB로 변경했다고 가정) 4. 끝으로 시트 초기화 구문에서 다음과 같이 테마를 적용할 수 있습니다. ```javascript mySheet.SetTheme(\"DB\",\"DeepBlue\"); ```"
        },
        "url": "docs/appx/Theme.html"
      },
      {
        "cid": 730,
        "sid": "excelMerge",
        "name": "excelMerge",
        "label": "엑셀 다운시 머지 적용 처리",
        "data": {
          "body": "![s](/assets/imgs/ibsheet7-excelmerge.png) 1. 머지 반영 안하는 경우 - DownRows 를 사용하면 Merge:1 로 설정해도 머지 반영 안함 2. 화면과 동일하게 머지되는 경우 - 화면에 보이는 컬럼 그대로 다운받는 경우 3. 머지 반영 되지만 화면과 동일하지 않을 수 있는 경우 - 화면에 보이는 컬럼과 다운 받는 컬럼이 다른 경우"
        },
        "url": "docs/appx/excelMerge.html"
      },
      {
        "cid": 731,
        "sid": "filter",
        "name": "filter",
        "label": "다중 검색어 및 범위 필터 기능 설정 및 사용법",
        "data": {
          "body": "OR, AND, From~To (이하 Range) 연사자에 대한 키워드를 포함한 문자열 구성합니다. 각 연산자에 대한 키워드는 아래와 같습니다. |연산자|키워드| |---|-----| |OR|`or` 또는 `|`| |AND|`and`, `&` 또는 `공백`| |Range|`~`| 1. **설정 가이드** - 다중 필터를 사용하는 경우 입력 문자열이 길어 질 수 있기 때문에 입력한 검색어를 보기 어려울 수 있습니다. 이러한 경우 전역속성 `FilterInputPopup` 을 `1`로 설정하면 필터 입력시 팝업 다이얼로그를 이용할 수 있습니다. (`ibsheet.cfg` 에서 설정) - 팝업 다이얼로그 사용시 입력 창 하단에 사용 도움말을 표기 할 수 있습니다. ibmsg Text 태그의 SYS_FilterInfoMessage 속성값으로 도움말을 정의 할수 있으며 해당 속성에 정의가 없으면 도움말은 표시되지 않습니다. - ibmsg 작성방법 - i. 라인은 `<li></li>` 태그를 이용하여 구분합니다. - ii. ibmsg 파일은 xml 포맷이기 때문에 `\"<\"`, `\">\"` 등과 같은 특수문자 표기는 다음의 url을 참고하여 표기합니다. (http://www.w3.org/MarkUp/HTMLPlus/htmlplus_13.html) - iii. 작성예시 ```xml SYS_FilterInfoMessage = \"&lt;li&gt;검색어와 연산자는 공백으로 구분 &lt;/li&gt;&lt;li&gt;AND 연산자 : and, 공백, &&lt;br/&gt;ex) 대한 and 민국&lt;/li&gt;&lt;li&gt;OR 연산자 : or, |&lt;br/&gt;ex) 대한 or 민국&lt;/li&gt;&lt;li&gt;범위 연산자 : ~ &lt;br/&gt;ex) 10 ~ 20&lt;/li&gt;&lt;li&gt;검색어에 연산자 또는 공백이 포함되는 경우 &quot;&quot; 사용&lt;br/&gt;ex) &quot;대한 민국&quot;, &quot;You and I&quot;&lt;/li&gt;\" ``` 2. **사용 가이드** - 검색어와 키워드 사이는 공백으로 분리 합니다. - 검색에에 공백 또는 연산자 키워드가 포함된 경우 \" \"를 사용합니다. 예) \"You and I \", \"Dead or Alive\", \"대한 민국\" - 여러개의 연산자 키워드를 사용하는 경우 기본적으로 좌측부터 우측으로 처리되고, 서로 다른 연산자는 Range > AND > OR 의 우선순위를 따릅니다. - i. 1 or 5 ~ 10 : 5 와 10 사이의 값 또는 1 - ii. 1 ~ 5 or 10 : 1 과 5 사이의 값 또는 10 - iii. 가 and 나 or 다 : \"가\", \"나\" 문자를 포함한 문자열 또는 \"다\" 문자를 포함한 문자열 - 날짜 타입에 대한 검색어 입력시 문자열 필터 옵션을 사용하는 경우 날짜 포맷을 직접 입력하여야 하고, 숫자 필터 옵션을 사용하는 경우에는 yyyyMMdd 형식의 포맷 구분자 없이 입력 할 수 있습니다. 예) 문자 필터 옵션 사용 : 2015/04 숫자 필터 옵션 사용 : 0150401 ~ 20150430 또는 2015/04/01 ~ 2015/04/30 - Range 필터를 사용하는 경우에는 문자 필터 옵션을 사용할 수 없습니다. (문자 필터 옵션 사용시 \"같음\" 필터 옵션으로 변경 적용) ![s](/assets/imgs/ibsheet7-appxfilter.png)"
        },
        "url": "docs/appx/filter.html"
      },
      {
        "cid": 732,
        "sid": "frequentmethod",
        "name": "frequentmethod",
        "label": "자주 사용되는 메소드",
        "data": {
          "body": "### 1. Data Read / Write |Return Type|Method Name|Description| |-----|------|----------------------| |String|CellValue ([GetCellValue](/docs/funcs/cell/GetCellValue) / [SetCellValue](/docs/funcs/cell/SetCellValue))|셀 데이터 Read/Write| |String|CellText ([GetCellText](/docs/funcs/cell/GetCellText) / [SetCellText](/docs/funcs/cell/SetCellText))|셀 데이터 Read/Write| |JSON Object|RowData ([GetRowData](/docs/funcs/row/GetRowData) / [SetRowData](/docs/funcs/row/SetRowData))|행 데이터 Read/Write| |Query String|[RowSaveStr](/docs/funcs/save/RowSaveStr) [LoadSearchData](/docs/funcs/search/LoadSearchData) [LoadSaveData](/docs/funcs/save/LoadSaveData)|행 데이터 Read 조회 데이터 XML/JSON Write 저장 데이터 XML/JSON Write| |String|[GetEditText](/docs/funcs/core/GetEditText)|편집중인 셀의 데이터 Read| |String|SumValue ([GetSumValue](/docs/funcs/sum/GetSumValue) / [SetSumValue](/docs/funcs/sum/SetSumValue))|합계행 안에 셀 데이터 Read/Write| |JSON Object|[GetSaveJson](/docs/funcs/save/GetSaveJson)|시트 전체 데이터 Read| |Query String|[GetSaveString](/docs/funcs/save/GetSaveString)|시트 전체 데이터 Read| |Object|[GetSheetHtml](/docs/funcs/core/GetSheetHtml)|시트 전체 데이터를 HTML양식으로 Read| ### 2. 최초 조회된 값 확인 / 변경 |Return Type|Method Name|Description| |-----|------|----------------------| |none|[ReturnData](/docs/funcs/row/ReturnData)|행을 최초 조회했던 값으로 변경| |none|[ReturnCellData](/docs/funcs/cell/ReturnCellData)|셀을 최초 조회했던 값으로 변경| |String|[CellSearchValue](/docs/funcs/cell/CellSearchValue)|셀에 대한 조회 데이터 확인| ## 3. 행 / 열 인덱스 |Return Type|Method Name|Description| |-----|------|----------------------| |Int|[LastRow](/docs/funcs/row/LastRow)|마지막 행의 Index| |Int|[LastCol](/docs/funcs/col/LastCol)|마지막 열의 인덱스| |Int|[HeaderRows](/docs/funcs/core/HeaderRows)|첫번째 데이터 행의 인덱스| |Int|[SearchRows](/docs/funcs/core/SearchRows)|조회한 데이터 행수 (상태가 R인 데이터 행 수)| |Int|TopRow ([GetTopRow](/docs/funcs/row/GetTopRow) / [SetTopRow](/docs/funcs/row/SetTopRow))|현재 화면에 보여지는 행중 최 상단의 행 인덱스| |Int|LeftCol ([GetLeftCol](/docs/funcs/col/GetLeftCol) / [SetLeftCol](/docs/funcs/col/SetLeftCol))|현재 화면에 보여지는 열중에 최 좌측의 열 인덱스| |Int|SelectRow ([GetSelectRow](/docs/funcs/core/GetSelectRow) / [SetSelectRow](/docs/funcs/core/SetSelectRow))|현재 선택된(포커스 된) 행의 인덱스| |Int|SelectCol ([GetSelectCol](/docs/funcs/core/GetSelectCol) / [SetSelectCol](/docs/funcs/core/SetSelectCol))|현재 선택된(포커스 된) 열의 인덱스| |Int|[SelectCell](/docs/funcs/core/SelectCell)|특정 셀로 포커스 이동| |Int or String|[FindSumRow](/docs/funcs/sum/FindSumRow)|합계행의 인덱스| ## 4. 찾기 기능 |Return Type|Method Name|Description| |-----|------|----------------------| |Int|[FindText](/docs/funcs/row/FindText)|열에서 특정 String문자 찾기 |String|[FindSubSumRow](/docs/funcs/sum/FindSubSumRow)|여러개의 소계행 인덱스 찾기| |String|[FindCheckedRow](/docs/funcs/row/FindCheckedRow)|체크박스 컬럼에 체크된 행 찾기| |String|[FindStatusRow](/docs/funcs/row/FindStatusRow)|특정 상태를 갖는 모든 행 찾기| |String|[GetSelectionRows](/docs/funcs/core/GetSelectionRows)|마우스로 드레그 하여 선택한 영역 행 인덱스| |String|[GetSelectionCols](/docs/funcs/core/GetSelectionCols)|마우스로 드레그 하여 선택한 영역 열 인덱스| ## 5. Tree 기능 관련 함수 |Return Type|Method Name|Description| |-----|------|----------------------| |Int|RowLevel ([GetRowLevel](/docs/funcs/tree/GetRowLevel) / [SetRowLevel](/docs/funcs/tree/SetRowLevel))|노드의 Level(depth) Read/Write| |Boolean|[IsHaveChild](/docs/funcs/tree/IsHaveChild)|자식노드 존재 여부 확인| |Int|[GetPrevSiblingRow](/docs/funcs/tree/GetPrevSiblingRow)|자신과 같은 Level의 상위 행 인덱스| |Int|[GetNextSiblingRow](/docs/funcs/tree/GetNextSiblingRow)|자신과 같은 Level의 하위 행 인덱스| |Int|[GetParentRow](/docs/funcs/tree/GetParentRow)|부모 행 인덱스| |String|[GetChildRows](/docs/funcs/tree/GetChildRows)|자식 행 전체 인덱스| |Int|[GetLastChildRow](/docs/funcs/tree/GetLastChildRow)|마지막 자식 행 인덱스| |Int|[GetChildNodeCount](/docs/funcs/tree/GetChildNodeCount)|자식행 개수| |Int|[ShowTreeLevel](/docs/funcs/tree/ShowTreeLevel)|특정 Level까지 접거나 펼침| ## 6. File import / export |Return Type|Method Name|Description| |-----|------|----------------------| |none|[Down2Excel](/docs/funcs/export/Down2Excel)|시트의 데이터를 엑셀파일로 export| |none|[Down2Text](/docs/funcs/export/Down2Text)|시트의 데이터를 text 파일로 export| |none|[Down2Pdf](/docs/funcs/export/Down2Pdf)|시트의 데이터를 PDF파일로 export| |none|[DirectDown2Excel](/docs/funcs/export/DirectDown2Excel)|시트의 헤더정보와 디비의 데이터 정보를 합쳐 엑셀파일로 export| |none|[LoadExcel](/docs/funcs/import/LoadExcel)|엑셀 파일을 시트위로 import| |none|[LoadText](/docs/funcs/import/LoadText)|text 파일을 시트위로 import| |none|[DirectLoadExcel](/docs/funcs/import/DirectLoadExcel)| 엑셀 파일을 디비로 바로 저장| |none|[Down2ExcelBuffer](/docs/funcs/export/Down2ExcelBuffer)|두개 이상의 시트를 하나의 엑셀파일로 export| |none|[SetDown2ExcelConfig](/docs/funcs/export/SetDown2ExcelConfig)|엑셀 export시 공통 설정| |none|[OnDownFinish](/docs/event/OnDownFinish)|다운로드 완료 후 이벤트| |none|[OnBeforeDownload](/docs/event/OnBeforeDownload)|서버로 데이터 전달 직전 이벤트| |none|[OnLoadExcel](/docs/event/OnLoadExcel)|엑셀 파일 업로드 이후 이벤트| ## 7. 건수정보 표시 줄 관련 |Return Type|Method Name|Description| |-----|------|----------------------| |none|CountPosition ([GetCountPosition](/docs/funcs/core/GetCountPosition) / [SetCountPosition](/docs/funcs/core/SetCountPosition))|건수표시 위치 설정| |none|CountFormat ([GetCountFormat](/docs/funcs/core/GetCountFormat) / [SetCountFormat](/docs/funcs/core/SetCountFormat))|건수표시 포멧 설정| |none|CountInfoElement ([GetCountInfoElement](/docs/funcs/core/GetCountInfoElement) / [SetCountInfoElement](/docs/funcs/core/SetCountInfoElement))|건수표시를 외부 객체에 설정/확인| |none|SelectionSummaryInfoElement ([GetSelectionSummaryInfoElement](/docs/funcs/core/GetSelectionSummaryInfoElement) / [SetSelectionSummaryInfoElement](/docs/funcs/core/SetSelectionSummaryInfoElement))|Summary정보를 외부 객체에 설정/확인| |none|SelectionSummary ([SetConfig](/docs/funcs/init/SetConfig) 내 속성)|드레그 영역에 대한 Summary정보 표시| |none|PagingPosition ([GetPagingPosition](/docs/funcs/core/GetPagingPosition) / [SetPagingPosition](/docs/funcs/core/SetPagingPosition))|페이지 네비게이션 버튼 표시| ## 8. Tab, Enter 입력시 동작 결정 |Return Type|Method Name|Description| |-----|------|----------------------| |none|TabBehavior ([GetTabBehavior](/docs/funcs/core/GetTabBehavior) / [SetTabBehavior](/docs/funcs/core/SetTabBehavior))|포커스 상태에서 Tab키 다운시 동작방식 결정| |none|EnterBehavior ([GetEnterBehavior](/docs/funcs/core/GetEnterBehavior) / [SetEnterBehavior](/docs/funcs/core/SetEnterBehavior))|포커스 상태에서 Enter키 다운시 동작방식 결정| |none|EditTabBehavior ([GetEditTabBehavior](/docs/funcs/core/GetEditTabBehavior) / [SetEditTabBehavior](/docs/funcs/core/SetEditTabBehavior))|편집 중 Tab키 다운시 동작방식 결정| |none|EditEnterBehavior ([GetEditEnterBehavior](/docs/funcs/core/GetEditEnterBehavior) / [SetEditEnterBehavior](/docs/funcs/core/SetEditEnterBehavior))|편집 중 Enter키 다운시 동작방식 결정| |none|[OnTab](/docs/event/OnTab)|Tab키를 통해 이동시 발생하는 이벤트| ## 9. 기타 자주 사용되는 메소드 * [RemoveAll](/docs/funcs/core/RemoveAll) : 조회 데이터 전체 삭제 * [Reset](/docs/funcs/core/Reset) : 시트 객체 초기화 * [IsDataModified](/docs/funcs/core/IsDataModified) : 시트의 수정 여부 확인 * [ColSaveName](/docs/funcs/col/ColSaveName) : 열의 인덱스를 기준으로 SaveName을 확인 * [SaveNameCol](/docs/funcs/col/SaveNameCol) : 열의 SaveName을 기준으로 인덱스를 확인 * [SetRowHidden](/docs/funcs/row/SetRowHidden) : 행 보이기/감추기 * [SetColHidden](/docs/funcs/col/SetColHidden) : 열 보이기/감추기"
        },
        "url": "docs/appx/frequentmethod.html"
      },
      {
        "cid": 734,
        "sid": "import-export",
        "name": "import-export",
        "label": "파일업로드/다운로드",
        "data": {
          "body": "> 시트의 내용을 엑셀이나,텍스트 파일로 다운로드 하거나, 반대로 파일의 내용을 읽어 시트에 업로드하는 방법에 대해 알아봅니다. ## 필수 파일 요소 업로드/다운로드 작업을 하시려면 아래 파일들을 구비하고 계셔야 됩니다. 서버모듈 1.0인지 서버모듈 2.0인지, POI3 라이브러리를 사용하시는지, POI4 라이브러리를 사용하시는지에 따라 구비하셔야 하는 파일이 다릅니다. `(cfg) ExportMode: 2`로 설정하시면 서버모듈이 아닌 클라이언트 모듈로 업로드/다운로드 작업을 진행하실 수 있습니다. 이 경우에는 `ibexcel.js` 파일을 정적 파일 소스로 추가해주셔야 합니다. 1. 서버모듈 1.0 |파일명|용도| |---|---| |ibsheet7-1.1.x.jar|서버코어모듈| |poi-3.9-20121203.jar|엑셀 파일 생성/파싱 모듈| |poi-ooxml-3.9-20121203.jar|엑셀 파일 생성/파싱 모듈| |poi-ooxml-schemas-3.9-20121203.jar|엑셀 파일 생성/파싱 모듈| |commons-codec-1.6.jar|엑셀 파일 생성/파싱 모듈| (체크) |commons-collections4-4.4.jar|컬렉션 프레임워크 모듈| |commons-compress-1.19.jar|엑셀 파일 압축 관련 모듈| |commons-logging-1.1.3.jar|로그 모듈| |commons-math3-3.6.1.jar|수적 기능 모듈| |dom4j-1.6.1.jar|자바에서 XML 문서를 다루기 위한 모듈| (체크) |flying-saucer-core-9.0.2.jar|PDF 문서 생성 관련 모듈| (체크) |flying-saucer-pdf-9.0.2.jar|PDF 문서 생성 관련 모듈| (체크) |itext-2.1.7.jar|PDF 문서 생성 관련 모듈| (체크) |json-simple-1.1.1.jar|JSON 처리 모듈| 2. 서버모듈 2.0 (POI3) |파일명|용도| |---|---| |ibsheet7-2.x.x.jar|서버코어모듈| |poi-3.13-all.jar|엑셀 파일 생성/파싱 모듈| |commons-codec-1.6.jar|엑셀 업로드 관련 인코딩 모듈| |commons-logging-1.1.3.jar|로그 모듈| |ib-itext.jar|pdf다운로드 모듈| |batik-all-xml.jar|이미지 처리 관련 모듈| 3. 서버모듈 2.0 (POI4) |파일명|용도| |---|---| |ibsheet7-2.x.x.jar|서버코어모듈| |poi-4.1.2.jar|엑셀 파일 생성/파싱 모듈| |poi-ooxml-4.1.2|엑셀 파일 생성/파싱 모듈| |poi-ooxml-schemas-4.1.2.jar|엑셀 파일 생성/파싱 모듈| |commons-codec-1.13.jar|엑셀 파일 생성/파싱 모듈| |commons-collections4-4.4.jar|컬렉션 프레임워크 모듈| |commons-compress-1.19.jar|엑셀 파일 압축 관련 모듈| |commons-logging-1.1.3.jar|로그 모듈| |commons-math3-3.6.1.jar|수적 기능 모듈| |curvesapi-1.06.jar|SVG 그래픽 처리 관련 모듈| |servlet-api.jar|서블릿 엔진 모듈| |SparseBitSet-1.2.jar|비트 처리 관련 모듈| |xmlbeans-3.1.0.jar|자바에서 XML 문서를 다루기 위한 모듈| ### 서버모듈 확인 방법 서버에서 jar 파일이 정상적으로 로드되었는지 다음 구문을 통해 확인 할 수 있습니다. ```jsp <% System.out.println(com.ibleaders.ibsheet.util.Version.getJarVersion()); %> ``` 위와 같이 jsp파일에 입력시 서버에 콘솔창에 다음과 같은 메세지가 나오면 정상입니다. (각 jar 파일에 버젼 정보를 확인해 주세요.) ```console ******************************************************************************** ### ibsheet8 serverModule version ### # ibsheet8 jar Version : 1.0.X ******************************************************************************** Class Info : org.apache.poi.ss.usermodel.Workbook jar path : /D:/repository/ibsheet8-server-module/.metadata/.plugins/org.eclipse.wst.server.core/tmp0/wtpwebapps/webProject/WEB-INF/lib/poi-3.13-all.jar jar Version : Apache POI 3.13 Required Version : POI 3.8 beta3 or later ******************************************************************************** Class Info : org.apache.poi.POIXMLDocument jar path : /D:/repository/ibsheet8-server-module/.metadata/.plugins/org.eclipse.wst.server.core/tmp0/wtpwebapps/webProject/WEB-INF/lib/poi-3.13-all.jar jar Version : Apache POI 3.13 Required Version : POI 3.8 beta3 or later ******************************************************************************** Class Info : org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbookPr jar path : /D:/repository/ibsheet8-server-module/.metadata/.plugins/org.eclipse.wst.server.core/tmp0/wtpwebapps/webProject/WEB-INF/lib/poi-3.13-all.jar jar Version : Apache POI 3.13 Required Version : POI 3.8 beta3 or later ******************************************************************************** Class Info : org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook jar path : /D:/repository/ibsheet8-server-module/.metadata/.plugins/org.eclipse.wst.server.core/tmp0/wtpwebapps/webProject/WEB-INF/lib/poi-3.13-all.jar jar Version : Apache POI 3.13 Required Version : POI 3.8 beta3 or later ******************************************************************************** Class Info : org.apache.xmlbeans.XmlBeans jar path : /D:/repository/ibsheet8-server-module/.metadata/.plugins/org.eclipse.wst.server.core/tmp0/wtpwebapps/webProject/WEB-INF/lib/poi-3.13-all.jar jar Version : Apache POI 3.13 Required Version : XMLBeans 2.3.0 or later ******************************************************************************** ``` 2. jsp 파일 |파일명|용도| |---|---| |Down2Excel.jsp|엑셀파일 다운로드| |LoadExcel.jsp|엑셀파일 업로드| |Down2Text.jsp|텍스트파일 다운로드| |LoadText.jsp|텍스트파일 업로드| |Down2Pdf.jsp|PDF파일 다운로드| 3. 플러그인 파일 include 파일 시트를 이용하여 다운로드/업로드 작업을 할 모든 페이지에는 `/plugins/ibsheet-excel.js` 파일이 인클루드 되어야 합니다. ## 준비 과정 ### jsp 파일경로 설정 `SetDown2ExcelUrl`, `SetLoadExcelUrl`, `SetDown2TextUrl`, `SetDown2TextUrl` 함수를 이용해 jsp 파일이 위치한 경로를 설정하실 수 있습니다. ```js // 엑셀 다운로드 경로를 설정 mySheet.SetDown2ExcelUrl(\"/jsp/Down2Excel.jsp\"); // 엑셀 업로드 경로를 설정 mySheet.SetLoadExcelUrl(\"/jsp/LoadExcel.jsp\"); ``` ## 기능 구현 [down2Excel](/docs/funcs/export/Down2Excel)이나 [loadExcel](/docs/funcs/import/LoadExcel)함수를 통해 시트의 내용을 다운로드/업로드 하실 수 있습니다. ```javascript mySheet.Down2Excel({\"FileName\":\"boardList.xls\",\"SheetDesign\":1,\"Merge\":1}); ``` 업로드/다운로드 함수에 대한 자세한 기능은 해당 함수에 대한 메뉴얼 파트를 참고해 주세요.",
          "see": [
            {
              "label": "ExportMode",
              "url": "/docs/props/PropertyList/ExportMode"
            },
            {
              "label": "Down2Excel method",
              "url": "/docs/funcs/export/Down2Excel"
            },
            {
              "label": "LoadExcel method",
              "url": "/docs/funcs/import/LoadExcel"
            },
            {
              "label": "Down2Text method",
              "url": "/docs/funcs/export/Down2Text"
            },
            {
              "label": "LoadText method",
              "url": "/docs/funcs/import/LoadText"
            },
            {
              "label": "Down2Pdf method",
              "url": "/docs/funcs/export/Down2Pdf"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|7.0.0.0||"
        },
        "url": "docs/appx/import-export.html"
      },
      {
        "gid": 1,
        "name": "appx-columnType",
        "label": "컬럼 타입별 정의 가능한 속성",
        "children": [
          {
            "cid": 735,
            "sid": "checkbox",
            "name": "checkbox",
            "label": "체크박스 형식 타입",
            "data": {
              "body": "|Name|DelCheck|CheckBox|DummyCheck|Radio| |:---|:------:|:------:|:------:|:------:| |Type|O|O|O|O| |AcceptKeys|X|X|X|X| |Align|X|X|X|X| |ApproximateType|X|X|X|X| |BackColor|O|O|O|O| |ButtonUrl|X|X|X|X| |CalcLogic|X|X|X|X| |CaseSensitive|X|X|X|X| |Chart|X|X|X|X| |CheckSaveName|O|O|O|O| |ClassName|X|X|X|X| |ColMerge|O|O|O|O| |ColSpan|O|O|O|O| |ComboCode|X|X|X|X| |ComboFilter|X|X|X|X| |ComboText|X|X|X|X| |Cursor|X|X|X|X| |DefaultValue|X|O|O|X| |Edit|O|O|O|O| |EditLen|X|X|X|X| |EditPointCount|X|X|X|X| |Ellipsis |O|O|O|O| |EmptyToReplaceChar|X|X|X|X| |ExcludeEmpty|X|X|X|X| |FalseValue|O|O|O|O| |Focus|O|O|O|O| |FontBold|X|X|X|X| |FontColor|X|X|X|X| |FontUnderline|X|X|X|X| |Format|X|X|X|X| |FormatFix|O|O|O|O| |FullInput|X|X|X|X| |GroupSumType|O|O|O|O| |HeaderCheck|O|O|O|X| |Hidden|O|O|O|O| |HoverUnderline|X|X|X|X| |Image|X|X|X|X| |ImgAlign|X|X|X|X| |ImgHeight|X|X|X|X| |ImgWidth|X|X|X|X| |InsertEdit|X|O|O|O| |ItemCode|X|O|O|X| |ItemText|X|O|O|X| |KeyField|O|O|O|O| |LevelSaveName|O|O|O|O| |MaxCheck|X|O|O|X| |MaximumValue|X|X|X|X| |MinimumValue|X|X|X|X| |MultiLineText|X|X|X|X| |PointCount|X|X|X|X| |PopupButton|X|X|X|X| |PopupCheckEdit|O|O|O|O| |PopupCode|O|O|O|O| |PopupText|O|O|O|O| |RadioIcon|O|O|O|O| |RowSpan|O|O|O|O| |SaveName|O|O|O|O| |Sort|O|O|O|O| |SumType|X|X|X|X| |ToolTipText|O|O|O|O| |TreeCheck|O|O|O|O| |TreeCol|O|O|O|O| |TrueValue|O|O|O|O| |UpdateEdit|X|O|O|O| |VAlign|X|X|X|X| |Validation|X|X|X|X| |Width|O|O|O|O| |Wrap|X|X|X|X| |ZeroToReplaceChar|X|X|X|X|"
            },
            "url": "docs/appx/columnType/checkbox.html"
          },
          {
            "cid": 736,
            "sid": "combo",
            "name": "combo",
            "label": "콤보 형식 타입",
            "data": {
              "body": "|Name|Combo|ComboEdit| |:---|:---:|:--------:| |Type|O|O| |AcceptKeys|X|O| |Align|O|O| |ApproximateType|X|X| |BackColor|O|O| |ButtonUrl|X|X| |CalcLogic|X|X| |CaseSensitive|X|O| |Chart|X|X| |CheckSaveName|O|O| |ClassName|X|X| |ColMerge|O|O| |ColSpan|O|O| |ComboCode|O|O| |ComboFilter|X|O| |ComboText|O|O| |Cursor|X|O| |DefaultValue|O|O| |Edit|X|O| |EditLen|X|O| |EditPointCount|X|X| |Ellipsis |O|O| |EmptyToReplaceChar|X|X| |ExcludeEmpty|X|X| |FalseValue|X|X| |Focus|O|O| |FontBold|O|O| |FontColor|O|O| |FontUnderline|O|O| |Format|X|X| |FormatFix|O|O| |FullInput|X|O| |GroupSumType|O|O| |HeaderCheck|X|X| |Hidden|O|O| |HoverUnderline|O|O| |Image|X|X| |ImgAlign|X|X| |ImgHeight|X|X| |ImgWidth|X|X| |InsertEdit|O|O| |ItemCode|X|X| |ItemText|X|X| |KeyField|O|O| |LevelSaveName|O|O| |MaxCheck|X|X| |MaximumValue|X|X| |MinimumValue|X|X| |MultiLineText|X|X| |PointCount|X|X| |PopupButton|X|X| |PopupCheckEdit|O|O| |PopupCode|O|O| |PopupText|O|O| |RadioIcon|X|X| |RowSpan|O|O| |SaveName|O|O| |Sort|O|O| |SumType|X|X| |ToolTipText|O|O| |TreeCheck|O|O| |TreeCol|O|O| |TrueValue|X|X| |UpdateEdit|O|O| |VAlign|O|O| |Validation|X|O| |Width|O|O| |Wrap|X|O| |ZeroToReplaceChar|X|X|"
            },
            "url": "docs/appx/columnType/combo.html"
          },
          {
            "cid": 737,
            "sid": "date",
            "name": "date",
            "label": "날짜 형식 타입",
            "data": {
              "body": "|Name|Date| |----|----| |Type|O| |AcceptKeys|X| |Align|O| |ApproximateType|X| |BackColor|O| |ButtonUrl|X| |CalcLogic|X| |CaseSensitive|X| |Chart|X| |CheckSaveName|O| |ClassName|X| |ColMerge|O| |ColSpan|O| |ComboCode|X| |ComboFilter|X| |ComboText|X| |Cursor|O| |DefaultValue|O| |Edit|O| |EditLen|O| |EditPointCount|X| |Ellipsis|O| |EmptyToReplaceChar|X| |ExcludeEmpty|X| |FalseValue|X| |Focus|O| |FontBold|O| |FontColor|O| |FontUnderline|O| |Format|O| |FormatFix|O| |FullInput|O| |GroupSumType|O| |HeaderCheck|X| |Hidden|O| |HoverUnderline|O| |Image|X| |ImgAlign|X| |ImgHeight|X| |ImgWidth|X| |InsertEdit|O| |ItemCode|X| |ItemText|X| |KeyField|O| |LevelSaveName|O| |MaxCheck|X| |MaximumValue|X| |MinimumValue|X| |MultiLineText|X| |PointCount|X| |PopupCheckEdit|O| |PopupButton|X| |PopupCode|O| |PopupText|O| |RadioIcon|X| |RowSpan|O| |SaveName|O| |Sort|O| |SumType|X| |ToolTipText|O| |TreeCheck|O| |TreeCol|O| |TrueValue|X| |UpdateEdit|O| |VAlign|O| |Validation|X| |Width|O| |Wrap|X| |ZeroToREplaceChar|X|"
            },
            "url": "docs/appx/columnType/date.html"
          },
          {
            "cid": 738,
            "sid": "etc",
            "name": "etc",
            "label": "기타 형식 타입",
            "data": {
              "body": "|Name|Result|Pass|Status|Seq|Sparkline| |:---|:----:|:---:|:---:|:---:|:------:| |Type|O|O|O|O|O| |AcceptKeys|X|X|X|X|X| |Align|O|O|O|O|X| |ApproximateType|X|X|X|X|X| |BackColor|O|O|O|O|X| |ButtonUrl|X|X|X|X|X| |CalcLogic|X|X|X|X|X| |CaseSensitive|O|X|X|X|X| |Chart|X|X|X|X|O| |CheckSaveName|O|O|O|O|X| |ClassName|X|X|X|X|X| |ColMerge|O|O|O|X|X| |ColSpan|O|O|O|O|O| |ComboCode|X|X|X|X|X| |ComboFilter|X|X|X|X|X| |ComboText|X|X|X|X|X| |Cursor|O|O|O|O|X| |DefaultValue|O|X|X|X|X| |Edit|X|O|X|X|X| |EditLen|X|O|X|X|X| |EditPointCount|X|X|X|X|X| |Ellipsis |O|O|O|O|X| |EmptyToReplaceChar|X|X|X|X|X| |ExcludeEmpty|X|X|X|X|X| |FalseValue|X|X|X|X|X| |Focus|O|O|O|O|O| |FontBold|O|O|O|O|X| |FontColor|O|O|O|O|X| |FontUnderline|O|O|O|O|X| |Format|X|X|X|X|X| |FormatFix|O|O|O|O|X| |FullInput|X|O|X|X|X| |GroupSumType|O|O|O|O|X| |HeaderCheck|X|X|X|X|X| |Hidden|O|O|O|O|O| |HoverUnderline|O|O|O|O|X| |Image|X|X|X|X|X| |ImgAlign|X|X|X|X|X| |ImgHeight|X|X|X|X|X| |ImgWidth|X|X|X|X|X| |InsertEdit|O|O|O|O|X| |ItemCode|X|X|X|X|X| |ItemText|X|X|X|X|X| |KeyField|O|O|O|O|O| |LevelSaveName|O|O|O|O|X| |MaxCheck|X|X|X|X|X| |MaximumValue|X|X|X|X|X| |MinimumValue|X|X|X|X|X| |MultiLineText|X|X|X|X|X| |PointCount|X|X|X|X|X| |PopupButton|X|X|X|X|X| |PopupCheckEdit|O|O|O|O|X| |PopupCode|O|O|O|O|X| |PopupText|O|O|O|O|X| |RadioIcon|X|X|X|X|X| |RowSpan|O|O|O|O|O| |SaveName|O|O|O|O|O| |Sort|O|O|O|O|X| |SumType|X|X|X|X|X| |ToolTipText|O|O|O|O|X| |TreeCheck|O|O|O|O|X| |TreeCol|O|O|O|O|X| |TrueValue|X|X|X|X|X| |UpdateEdit|O|O|O|O|X| |VAlign|O|O|O|O|X| |Validation|X|X|X|X|X| |Width|O|O|O|O|O| |Wrap|O|O|O|X|X| |ZeroToReplaceChar|X|X|X|X|X|"
            },
            "url": "docs/appx/columnType/etc.html"
          },
          {
            "cid": 739,
            "sid": "html",
            "name": "html",
            "label": "Html 형식 타입",
            "data": {
              "body": "|Name|Html|Button|Img| |:---|:--:|:---:|:---:| |Type|O|O|O| |AcceptKeys|X|X|X| |Align|X|O|O| |ApproximateType|X|X|X| |BackColor|X|O|O| |ButtonUrl|X|X|X| |CalcLogic|X|X|X| |CaseSensitive|X|X|X| |Chart|X|X|X| |CheckSaveName|X|X|O| |ClassName|X|O|X| |ColMerge|O|O|O| |ColSpan|O|O|O| |ComboCode|X|X|X| |ComboFilter|X|X|X| |ComboText|X|X|X| |Cursor|O|O|O| |DefaultValue|O|O|X| |Edit|X|O|X| |EditLen|X|X|X| |EditPointCount|X|X|X| |Ellipsis |X|X|X| |EmptyToReplaceChar|X|X|X| |ExcludeEmpty|X|X|X| |FalseValue|X|X|X| |Focus|O|O|O| |FontBold|X|X|X| |FontColor|X|X|X| |FontUnderline|X|X|X| |Format|X|X|X| |FormatFix|X|X|O| |FullInput|X|X|X| |GroupSumType|X|X|O| |HeaderCheck|X|X|X| |Hidden|O|O|O| |HoverUnderline|X|X|X| |Image|X|X|X| |ImgAlign|X|X|X| |ImgHeight|X|X|O| |ImgWidth|X|X|O| |InsertEdit|X|X|O| |ItemCode|X|X|X| |ItemText|X|X|X| |KeyField|O|O|O| |LevelSaveName|X|X|O| |MaxCheck|X|X|X| |MaximumValue|X|X|X| |MinimumValue|X|X|X| |MultiLineText|X|X|X| |PointCount|X|X|X| |PopupButton|X|X|X| |PopupCheckEdit|X|X|O| |PopupCode|O|O|O| |PopupText|O|O|O| |RadioIcon|X|X|X| |RowSpan|O|O|O| |SaveName|O|O|O| |Sort|O|O|O| |SumType|X|X|X| |ToolTipText|O|O|O| |TreeCheck|X|X|O| |TreeCol|O|O|O| |TrueValue|X|X|X| |UpdateEdit|X|X|O| |VAlign|X|X|O| |Validation|X|X|X| |Width|O|O|O| |Wrap|X|X|X| |ZeroToReplaceChar|X|X|X|"
            },
            "url": "docs/appx/columnType/html.html"
          },
          {
            "cid": 740,
            "sid": "number",
            "name": "number",
            "label": "숫자 형식 타입",
            "data": {
              "body": "|Name|Int|Float|AutoSum| |:----|:---:|:-----:|:-------:| |Type|O|O|O| |AcceptKeys|O|O|X| |ApproximateType|O|O|O| |Align|O|O|O| |BackColor|O|O|O| |ButtonUrl|X|X|X| |CalcLogic|O|O|O| |CaseSensitive|X|X|X| |Chart|X|X|X| |CheckSaveName|O|O|O| |ClassName|X|X|X| |ColMerge|O|O|O| |ColSpan|O|O|O| |ComboCode|X|X|X| |ComboFilter|X|X|X| |ComboText|X|X|X| |Cursor|O|O|O| |DefaultValue|O|O|O| |Edit|O|O|O| |EditLen|O|O|O| |EditPointCount|X|O|O| |Ellipsis |O|O|O| |EmptyToReplaceChar |O|O|O| |ExceptKeys|O|O|X| |ExcludeEmpty|X|X|X| |FalseValue|X|X|X| |Focus|O|O|O| |FontBold|O|O|O| |FontColor|O|O|O| |FontUnderline|O|O|O| |Format|O|O|O| |FormatFix|O|O|O| |FullInput|O|O|O| |GroupSumType|O|O|O| |HeaderCheck|X|X|X| |Hidden|O|O|O| |HoverUnderline|O|O|O| |Image|O|O|O| |ImgAlign|O|O|O| |ImgHeight|O|O|O| |ImgWidth|O|O|O| |InsertEdit|O|O|O| |ItemCode|X|X|X| |ItemText|X|X|X| |KeyField|O|O|O| |LevelSaveName|O|O|O| |MaxCheck|X|X|X| |MaximumValue|O|O|O| |MinimumValue|O|O|O| |MultiLineText|X|X|X| |PointCount|X|O|O| |PopupButton|O|O|O| |PopupCheckEdit|O|O|O| |PopupCode|O|O|O| |PopupText|O|O|O| |RadioIcon|X|X|X| |RowSpan|O|O|O| |SaveName|O|O|O| |Sort|O|O|O| |SumType|X|X|O| |ToolTipText|O|O|O| |TreeCheck|O|O|O| |TreeCol|O|O|O| |TrueValue|X|X|X| |UpdateEdit|O|O|O| |VAlign|O|O|O| |Validation|X|X|X| |Width|O|O|O| |Wrap|X|X|X| |ZeroToReplaceChar|O|O|O|"
            },
            "url": "docs/appx/columnType/number.html"
          },
          {
            "cid": 741,
            "sid": "text",
            "name": "text",
            "label": "텍스트 형식 타입",
            "data": {
              "body": "|Name|Text|Popup| |----|----|-----| |Type|O|O| |AcceptKeys|O|X| |Align|O|O| |ApproximateType|X|X| |BackColor|O|O| |ButtonUrl|X|O| |CalcLogic|X|X| |CaseSensitive|O|X| |Chart|X|X| |CheckSaveName|O|O| |ClassName|X|X| |ColMerge|O|O| |ColSpan|O|O| |ComboCode|X|X| |ComboFilter|X|X| |ComboText|X|X| |Cursor|O|O| |DefaultValue|O|O| |Edit|O|X| |EditLen|O|X| |EditPointCount|X|X| |Ellipsis|O|O| |EmptyToReplaceChar|X|X| |ExcludeEmpty|X|X| |FalseValue|X|X| |Focus|O|O| |FontBold|O|O| |FontColor|O|O| |FontUnderline|O|O| |Format|O|O| |FormatFix|O|O| |FullInput|O|X| |GroupSumType|O|O| |HeaderCheck|X|X| |Hidden|O|O| |HoverUnderline|O|O| |Image|O|X| |ImgAlign|O|X| |ImgHeight|O|X| |ImgWidth|O|X| |InsertEdit|O|O| |ItemCode|X|X| |ItemText|X|X| |KeyField|O|O| |LevelSaveName|O|O| |MaxCheck|X|X| |MaximumValue|X|X| |MinimumValue|X|X| |MultiLineText|O|X| |PointCount|X|X| |PopupButton|O|X| |PopupCheckEdit|O|O| |PopupCode|O|O| |PopupText|O|O| |RadioIcon|X|X| |RowSpan|O|O| |SaveName|O|O| |Sort|O|O| |SumType|X|X| |ToolTipText|O|O| |TreeCheck|O|O| |TreeCol|O|O| |TrueValue|X|X| |UpdateEdit|O|O| |VAlign|O|O| |Validation|X|X| |Width|O|O| |Wrap|O|O| |ZeroToReplaceChar|X|X|"
            },
            "url": "docs/appx/columnType/text.html"
          }
        ]
      }
    ]
  }
];
