/* eslint-disable */
var MARKDOWN_TOC_DATA = [
  {
    "gid": 1,
    "name": "intro",
    "label": "Introduction",
    "children": [
      {
        "cid": 1,
        "sid": "feature",
        "name": "feature",
        "label": "제품의 특징",
        "data": {
          "body": "`IBCalendar`는 순수 javascript 기반의 **캘린더 컴포넌트**로 사용자 PC에 어떠한 설치 없이 `HTML, javascript, CSS`만을 이용하여 웹에서 쉽고 빠르게 달력을 생성할 수 있습니다. **<mark>주의</mark>: Internet Explorer 에서는 동작되지 않습니다.** ## 주요한 제품의 기능 ### 다양한 달력 보기 기능 월단위 달력, 주단위 달력, 일정 목록 보기 기능 등의 다양한 형태의 달력 보기 기능을 제공합니다. [**월단위 달력**] ![월단위 달력](/assets/imgs/dayGridMonth.png \"월단위 달력\") [**주단위 달력**] ![주단위 달력](/assets/imgs/timeGridWeek.png \"주단위 달력\")"
        },
        "url": "docs/intro/feature.html"
      },
      {
        "cid": 2,
        "sid": "files",
        "name": "files",
        "label": "파일 구성",
        "data": {
          "body": "## ibcalendar 제품은 다음과 같은 파일,폴더로 구성되어 있습니다. ``` ibsheet 최상위 폴더 ├─ dependency.min.js // ibcalendar 3rd party 라이브러리 (기본) ├─ ibcalendar.min.js // ibcalendar 코어파일 (기본) ├─ ibleaders.js // 라이선스 파일 (기본) │ ├─ css // CSS 폴더 │ ├─ ibcalendar.css // 기본 테마 css 파일 │ ├─ dark.css // dark 테마 css 파일 │ ├─ material.css // material 테마 css 파일 │ ├─ classic.css // classic 테마 css 파일 │ │ │ └─ resources // css 테마에 사용되는 이미지가 담겨있는 폴더 │ ├─ classic // classic 테마에 사용되는 이미지 파일이 담긴 폴더 │ ├─ common // 모든 테마에서 공통적으로 사용되는 이미지 파일이 담긴 폴더 │ ├─ dark // dark 테마에 사용되는 이미지 파일이 담긴 폴더 │ └─ plugins // 3rd party 라이브러리에서 사용되는 이미지 파일이 담긴 폴더 │ └─ locale // 다국어 메세지 폴더 ├─ ko.js // 한국어 메세지 파일 (기본) └─ en.js // 영어 메세지 파일 ``` ## 각 파일의 기능은 아래와 같습니다. ### *ibleaders.js* `제품 라이선스`를 담고 있는 파일로 내용은 다음과 같습니다. ```javascript var ibleaders = ibleaders || { ibcalendar: { license: \"\" } }; ibleaders.ibcalendar.license= \"W2FtSztPKCBzbD8emM5ZzV7fAQnTXcJYS4gLHA0bXp0PTx1EGsBbEA6NicldTx+aXx0MG0IbRZ8HD1uL3srbz=\"; ``` ### *dependency.min.js* 제품에서 사용하는 3rd party 라이브러리 파일로 안의 내용은 **절대 수정하시면 안됩니다.** ### *ibcalendar.min.js* 제품의 코어 파일로 안의 내용은 **절대 수정하시면 안됩니다.** ### *css(folder)* 캘린더에서 사용하는 css파일(`/css/ibcalendar.css`)이 해당 폴더에 들어있습니다. ### *css/resources(folder)* 캘린더에서 보여지는 아이콘이나 이미지들이 해당 폴더에 들어있습니다. ### *locale(folder)* 캘린더 내부에서 사용하는 여러가지 상수와 시트 사용자가 보게 되는 메세지가 정의 되어 있습니다. * 한글: `/locale/ko.js` * 영문: `/locale/en.js` ---"
        },
        "url": "docs/intro/files.html"
      }
    ]
  },
  {
    "gid": 2,
    "name": "start",
    "label": "Getting Started",
    "children": [
      {
        "cid": 4,
        "sid": "init-structure",
        "name": "init-structure",
        "label": "달력 객체 구조",
        "data": {
          "body": "***캘린더 객체 초기화(options)*** ## 생성 함수 구조 ``` IBCalendar.create(id, element, options); id // 캘린더를 구분하기 위한 ID element // 캘린더를 생성할 부모 HTML 컨테이너 options // 캘린더 생성 옵션 ``` 캘린더 설정 예) ```javascript let id = \"calendar1\", element = document.getElementById(\"calendar-container\"), options = { headerToolbar: { // 헤더 툴바 표시 정보 left: \"today prev next\", center: \"title\", right: \"dayGridMonth,timeGridWeek,listMonth\" }, height: \"100%\", eventClick: function (info) { info.showEventPopup(); // 클릭한 일정(Event)의 정보를 시각적으로 보여주는 Popup 창 호출 }, eventSources: [ { id: \"IBLeaders\", events: calendarData // 일정(Event) 정보 데이터 } ] }; let calendar1 = IBCalendar.create(id, element, options); // 캘린더 생성 calendar1.render(); // 생성한 캘린더를 실제 DOM 에 렌더링 ``` ## 조회 데이터 구조 ```js events: [ {\"id\": \"IBLeaders-event1\", \"title\": \"All Day Event\", \"allDay\": true, \"start\": \"2020-06-01\", \"end\": \"2020-06-02\", \"memo\": \"memo\", \"toolTip\": \"toolTip\"}, {\"id\": \"IBLeaders-event2\", \"title\": \"Long Event\", \"allDay\": true, \"start\": \"2020-06-07\", \"end\": \"2020-06-10\"}, {\"id\": \"IBLeaders-event3\", \"title\": \"Meeting\", \"allDay\": false, \"start\": \"2020-06-22T10:30:00\", \"end\": \"2020-06-22T12:30:00\"} ] ``` ## 일반 일정(Event) 구조 ```js { \"id\": \"IBLeaders-event1\", // 일정(Event)의 고유한 ID \"title\": \"Meeting\", // 일정(Event)에 보여지는 제목 \"allDay\": false, // 종일 유무 \"start\": \"2023-11-22T10:30:00\", // 일정(Event)의 시작일자 \"end\": \"2023-11-22T12:30:00\", // 일정(Event)의 종료일자 \"memo\": \"고객사 미팅\", // 일정(Event)의 메모 (선택사항) \"toolTip\": \"툴팁 타이틀\" // 일정(Event) 마우스 호버시 보여질 타이틀 (선택사항) } ``` ## 반복 일정(Event) 구조 반복 일정의 `rrule` 값은 [RRULE string](https://jkbrzt.github.io/rrule/) 데이터로 만들어집니다. > **<mark>주의!</mark>** > **반복 일정을 서버에 저장 시 [`getEvents()`](/docs/funcs/calendar/get-events) 를 통하여 뽑인 값을 저장하면 안됩니다.** > **반드시 [`일정(Event) 조회 및 서버 연동`](/docs/start/data-sync)의 서버에 변경 사항 로드 부분의 `eventAdd`, `eventChange`, `eventRemove` 의 `info.eventInputs` 값을 통하여 저장하셔야 됩니다.** ```js { \"id\": \"IBLeaders-event2\", \"title\": \"Recurring Event\", \"allDay\": true, \"duration\": { // 반복 일정(Event) 생성시 각 일정의 길이 \"days\": 0 // milliseconds 설정 시 days 생략 가능 \"milliseconds\": 86400000 }, \"rrule\": \"DTSTART:20231101T000000Z\\nRRULE:INTERVAL=1;FREQ=WEEKLY;BYDAY=MO,WE,FR;UNTIL=20231201T000000Z\" // 반복 일정(Event) 데이터 정보 } ```",
          "see": [],
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가||core|1.6.0.0|`toolTip`추가|"
        },
        "url": "docs/start/init-structure.html"
      },
      {
        "cid": 5,
        "sid": "quick-start",
        "name": "quick-start",
        "label": "Quick Start",
        "data": {
          "body": "## ibcalendar 파일 구성 `IB Calendar`를 사용하기 위해서 다음 4~6가지 파일을 추가합니다. ```html <!----- ibsheet 기본 모듈 -----> <!-- 디자인 css --> <link rel=\"stylesheet\" type=\"text/css\" href=\"ibcalendar/css/ibcalendar.css\"> <!-- 종속 라이브러리 코어 파일 --> <script src=\"ibcalendar/dependency.min.js\"></script> <!-- 캘린더 코어 파일 --> <script src=\"ibcalendar/ibcalendar.min.js\"></script> <!-- 라이선스 파일 --> <script src=\"ibcalendar/ibleaders.js\"></script> <!-- 메세지 파일 ko.js 나 en.js 중 하나 추가 --> <script src=\"ibcalendar/locale/ko.js\"></script> ``` ## 캘린더 생성 이 후 캘린더 객체의 id, 달력이 그려질 DOM element, 생성 옵션과 같은 정보를 설정하고 **[IBSheet.create()](/docs/static/create)** 함수를 통해 객체를 생성합니다. *객체 생성이후 **[calendar.render()](/docs/funcs/calendar/render)** 함수를 실행해 주어야 실제 DOM에 달력이 그려집니다.* [자바스크립트 구문] ```js function initCalendar () { var id = \"calendar1\", el = document.getElementById(\"calendar-container\"), options = { // 캘린더 생성 옵션 headerToolbar: { // 헤더 툴바 표시 정보 left: \"today prev next\", center: \"title\", right: \"dayGridMonth,timeGridWeek,listMonth\" }, height: \"100%\", // 부모 요소의 높이에 맞추어 생성 eventSources: [ { id: \"Softin\", events: eventData // 초기 로딩 데이터 } ] }; IBCalendar.create(id, el, options); // 캘린더 객체 생성 IBCalendar.get(id).render(); // 캘린더 렌더링 } ``` [HTML 구문] ```html <body onload=\"initCalendar()\"> <!-- 캘린더의 부모 요소 --> <div style=\"width:100%; height:600px;\"> <!-- 캘린더가 그려질 DIV 객체 --> <div id=\"calendar-container\"></div> </div> </body> ``` *`options` 와 `evnets` 는 [달력객체구조](docs/start/init-structure)를 참고하세요.* <div class='notice'> ### 주의 `eventSources`에서 데이터 조회시 Ajax 호출은 `async: false` 동기식 형식으로 호출하여 서버의 응답을 기다린 뒤 완료된 이후에 일정정보를 렌더링 할 수 있도록 동작되어야 합니다. ```javascript eventSources: [ // your event source { id: \"IBCalendar1\" events: function(info, successCallback, failureCallback) { // jquery ajax 를 이용한 통신 // 비동기 문제로 인해 반드시 async: false 설정해야 한다. $.ajax({ url: \"/data/ibcalendar/devsample\", method: \"GET\", async: false, dataType: \"json\", data: { start: IBCalendar.DateTime.fromJSDate(info.start).toISO(), end: IBCalendar.DateTime.fromJSDate(info.end).toISO() }, success: function (result) { successCallback(result); // 해당 함수에 일정 정보를 인자로 호출 시켜주어야 달력에 렌더링 됩니다. }, error: function (xhr, status, errorThrown) { failureCallback(status); } }); } } ] ``` </div>"
        },
        "url": "docs/start/quick-start.html"
      },
      {
        "cid": 3,
        "sid": "data-sync",
        "name": "data-sync",
        "label": "일정(Event) 조회 및 서버 연동",
        "data": {
          "body": "> 일정(Event) 데이터를 IB Calendar 에 로딩하는 방법입니다. ## 조회 데이터 구조 ```js [ {\"id\": \"IBLeaders-event1\", \"title\": \"All Day Event\", \"allDay\": true, \"start\": \"2020-06-01\", \"end\": \"2020-06-02\"}, {\"id\": \"IBLeaders-event2\", \"title\": \"Long Event\", \"allDay\": true, \"start\": \"2020-06-07\", \"end\": \"2020-06-10\"}, {\"id\": \"IBLeaders-event3\", \"title\": \"Meeting\", \"allDay\": false, \"start\": \"2020-06-22T10:30:00\", \"end\": \"2020-06-22T12:30:00\"} ] ``` ## 일반 일정(Event) 구조 ```js { \"id\": \"IBLeaders-event1\", // 일정(Event)의 고유한 ID \"title\": \"Meeting\", // 일정(Event)에 보여지는 제목 \"allDay\": false, // 종일 유무 \"start\": \"2023-11-22T10:30:00\", // 일정(Event)의 시작일자 \"end\": \"2023-11-22T12:30:00\", // 일정(Event)의 종료일자 \"memo\": \"고객사 미팅\" // 일정(Event)의 메모 (선택사항) } ``` ## 반복 일정(Event) 구조 반복 일정의 `rrule` 값은 [RRULE string](https://jkbrzt.github.io/rrule/) 데이터로 만들어집니다. > **<mark>주의!</mark>** > **반복 일정을 서버에 저장 시 [`getEvents()`](/docs/funcs/calendar/get-events) 를 통하여 뽑인 값을 저장하면 안됩니다.** > **반드시 [`일정(Event) 조회 및 서버 연동`](/docs/start/data-sync)의 서버에 변경 사항 로드 부분의 `eventAdd`, `eventChange`, `eventRemove` 의 `info.eventInputs` 값을 통하여 저장하셔야 됩니다.** ```js { \"id\": \"IBLeaders-event2\", \"title\": \"Recurring Event\", \"allDay\": true, \"duration\": { // 반복 일정(Event) 생성시 각 일정의 길이 \"days\": 0 // milliseconds 설정 시 days 생략 가능 \"milliseconds\": 86400000 }, \"rrule\": \"DTSTART:20231101T000000Z\\nRRULE:INTERVAL=1;FREQ=WEEKLY;BYDAY=MO,WE,FR;UNTIL=20231201T000000Z\" // 반복 일정(Event) 데이터 정보 } ``` IB Calendar 는 위와 같은 데이터 형태로 된 일정(Event) 정보를 캘린더에 표현할 수 있습니다. [`eventSources`](/docs/props/event-sources/event-sources) 단위로 일정(Event) 이 관리됩니다. (Google Calendar 의 캘린더와 같은 개념) ```js eventSources: [ { id: \"calendar1\", events: [ {\"id\": \"IBLeaders-event1\", \"title\": \"All Day Event\", \"allDay\": true, \"start\": \"2020-06-01\", \"end\": \"2020-06-02\"}, {\"id\": \"IBLeaders-event2\", \"title\": \"Long Event\", \"allDay\": true, \"start\": \"2020-06-07\", \"end\": \"2020-06-10\"} ] }, { id: \"calendar2\", events: [ {\"id\": \"event1\", \"title\": \"종일일정\", \"allDay\": true, \"start\": \"2022-06-01\", \"end\": \"2022-06-02\"}, {\"id\": \"event2\", \"title\": \"출장\", \"allDay\": true, \"start\": \"2022-06-07\", \"end\": \"2022-06-10\"} ] } ] ``` ## 데이터 로드 달력에 일정 정보 데이터를 로드하는 방법으로 3가지의 방법을 제공하고 있습니다. ### JSON > 달력에 표시 될 이벤트 정보를 배열 객체로 정의할 수 있습니다. > JSON 형태의 구조를 가진 데이터를 서버에서 받아온 뒤 [`eventSources`](/docs/props/event-sources/event-sources) 단위로 직접 설정할 수 있습니다. > 각 `eventSources` 객체에서 `events` 속성에 담아주면 됩니다. ```js eventSources: [ { id: \"IBCalendar1\", events: [ { title: \"event1\", start: \"2010-01-01\", end: \"2010-01-02\", allDay: true }, { title: \"event2\", start: \"2010-01-05\", end: \"2010-01-07\", allDay: true } ], backgroundColor: \"red\" // \"IBCalendar1\" 에 속해 있는 모든 이벤트에 대해서 색깔 지정. } ] ``` ### Function > 달력에 표시될 이벤트 정보를 function 을 통해 제어하여 정의할 수 있습니다. ```js eventSources: [ // your event source { id: \"IBCalendar1\" events: function(info, successCallback, failureCallback) { // jquery ajax 를 이용한 통신 // 비동기 문제로 인해 반드시 async: false 설정해야 한다. $.ajax({ url: \"/data/ibcalendar/devsample\", method: \"GET\", async: false, dataType: \"json\", data: { start: IBCalendar.DateTime.fromJSDate(info.start).toISO(), end: IBCalendar.DateTime.fromJSDate(info.end).toISO() }, success: function (result) { successCallback(result); // 해당 함수에 일정 정보를 인자로 호출 시켜주어야 달력에 렌더링 됩니다. }, error: function (xhr, status, errorThrown) { failureCallback(status); } }); } } ] ``` ## 서버에 변경 사항 로드 IB Calendar 는 각 [`eventSources`](/docs/props/event-sources/event-sources) 마다 일정(Event) 추가/수정/삭제 시 발생하는 콜백(callback) 함수를 정의할 수 있습니다. IB Calendar 의 일정을 서버에 추가/수정/삭제는 아래의 함수를 통하여 작업해 주셔야 합니다. ### [eventAdd](/docs/props/event-sources/event-add) > 달력에 일정(Event) 이 새롭게 추가 될때마다 발생되는 callback 함수를 정의합니다. ```javascript eventSources: [ // your event source { id: \"IBCalendar1\" eventAdd: function(info) { // jquery ajax 를 이용한 통신 // 비동기 문제로 인해 반드시 async: false 설정해야 한다. $.ajax({ url: \"/data/ibcalendar/devsample\", method: \"POST\", async: false, contentType: \"application/json\", dataType: \"json\", data: JSON.stringify({ events: info.eventInputs // 추가할 일정(Event)들의 event 객체 배열 }), success: function (result) { }, error: function (xhr, status, errorThrown) { } }); } } ] ``` ### [eventChange](/docs/props/event-sources/event-change) > 달력에 일정(Event) 정보 수정시 발생하는 callback 함수를 정의합니다. ```javascript eventSources: [ // your event source { id: \"IBCalendar1\" eventChange: function(info) { // jquery ajax 를 이용한 통신 // 비동기 문제로 인해 반드시 async: false 설정해야 한다. $.ajax({ url: \"/data/ibcalendar/devsample\", method: \"PUT\", async: false, contentType: \"application/json\", dataType: \"json\", data: JSON.stringify({ events: info.eventInputs // 수정할 일정(Event)들의 event 객체 배열 }), success: function (result) { }, error: function (xhr, status, errorThrown) { } }); } } ] ``` ### [eventRemove](/docs/props/event-sources/event-remove) > 달력에 일정(Event) 삭제시 발생하는 callback 함수를 정의합니다. ```javascript eventSources: [ // your event source { id: \"IBCalendar1\" eventRemove: function(info) { // jquery ajax 를 이용한 통신 // 비동기 문제로 인해 반드시 async: false 설정해야 한다. $.ajax({ url: \"/data/ibcalendar/devsample\", method: \"DELETE\", async: false, contentType: \"application/json\", dataType: \"json\", data: JSON.stringify({ events: info.eventInputs // 삭제할 일정(Event)들의 event 객체 배열 }), success: function (result) { }, error: function (xhr, status, errorThrown) { } }); } } ] ```"
        },
        "url": "docs/start/data-sync.html"
      }
    ]
  },
  {
    "gid": 3,
    "label": "Properties",
    "name": "props",
    "children": [
      {
        "gid": 1,
        "name": "props-options",
        "label": "Options",
        "children": [
          {
            "cid": 6,
            "sid": "all-day-class-names",
            "name": "all-day-class-names",
            "label": "allDayClassNames",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)에서 `종일 일정(allDay Event)들을 표시하는 영역`의 timeSlot 영역의 td 요소에 클래스 이름을 추가합니다.(`timeGrid에만 적용되는 옵션입니다.`) > 배열을 통하여 여러개의 className 을 한번에 추가할 수 도 있습니다. ### Type `array` | `string` ### Example ```javascript options = { allDayClassNames: \"allday-class\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/all-day-class-names.html"
          },
          {
            "cid": 7,
            "sid": "all-day-content",
            "name": "all-day-content",
            "label": "allDayContent",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)에서 `종일 일정(allDay Event)들을 표시하는 영역`의 timeSlot 영역에 표시되는 텍스트를 설정합니다.(`timeGrid에만 적용되는 옵션입니다.`) > innerHTML로 삽입할 HTML 문자열을 { html: ' ' } 형태로 설정할 수 있습니다. > DOM node 형식으로 다루고자 할 경우, { domNodes: arrayOfDomNodes } 형태로 설정하면 사용할 수 있습니다. ### Type `object` | `function` ### Example ```javascript options = { allDayContent: { html: '<i>allday<i>' } }; ``` > `\"allDayContent\"` 옵션으로 콜백(callback) 함수를 정의할 수 있습니다. > 콜백(callback) 함수 정의 시 `\"allDayContentInfo\"` 객체를 parameter로 사용할 수 있으며, > return 을 통하여 allDayContent 영역에 표시할 텍스트 또는 HTML 문자열, DOM node 를 설정할 수 있습니다. |속성명|DataType|설명| |------|------|------------------| |`text`|`string`|기본 표시 텍스트| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { allDayContent: function (allDayContentInfo) { console.log(allDayContentInfo.text); console.log(allDayContentInfo.view); return { html: '<i>allday<i>' } } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/all-day-content.html"
          },
          {
            "cid": 8,
            "sid": "all-day-slot",
            "name": "all-day-slot",
            "label": "allDaySlot",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)에서 상단에 위치한 별도의 영역에 `종일 일정(allDay Event)들을 표시할지 여부`를 설정합니다.(`timeGrid에만 적용되는 옵션입니다.`) ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|종일 일정(allDay Event)들을 표시하지 않습니다| |`true`|종일 일정(allDay Event)들을 표시합니다. (`default`)| ### Example ```javascript options = { allDaySlot: false, initialView: \"timeGridWeek\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/all-day-slot.html"
          },
          {
            "cid": 9,
            "sid": "aspect-ratio",
            "name": "aspect-ratio",
            "label": "aspectRatio",
            "data": {
              "body": "> 달력 UI의 가로 세로 비율을 설정합니다. > IBCalendar는 월단위(dayGridMonth) 뷰(View)에서 표시하는 셀(Cell)들의 집합으로 UI의 크기가 결정됩니다. 이 셀(Cell)의 가로 세로 비율에 따라 캘린더 UI의 크기도 바뀌게 됩니다.(\"aspectRatio\" 옵션의 값이 커질수록 캘린더 UI의 높이가 작아집니다.) > 달력을 생성 후에도 [setOption](/docs/funcs/calendar/set-option) API를 이용하여 동적으로 달력 UI의 가로 세로 비율을 변경할 수 있습니다. ### Type `number` ### Options |Value|Description| |-----|-----| |`number`|default값은 `1.35`로 설정됩니다.| ### Example ```javascript // 너비(width)가 높이(height)의 3배인 IBCalendar 생성 시 options = { aspectRatio: 3 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/aspect-ratio.html"
          },
          {
            "cid": 10,
            "sid": "business-hours",
            "name": "business-hours",
            "label": "businessHours",
            "data": {
              "body": "> 지정한 요일, 시간 범위를 업무시간(Business Hours)으로 설정합니다.(업무 시간 이외의 영역은 다른 배경색이 적용됩니다.) ### Type `boolean` | `object` | `array` ### Options |Value|Description| |-----|-----| |`false`|업무시간(Business Hours)을 설정하지 않습니다.(`default`)| |`true`|월요일 ~ 금요일, 오전 9시 ~ 오후 5시 영역을 업무시간(Business Hours)으로 설정합니다.| |`object`|객체로 요일, 시간 범위를 세부적으로 설정합니다.| |`array`|객체를 여러개의 배열로 나누어 설정합니다.| ### Example ```javascript options = { businessHours: true }; ``` |Value|Description| |-----|-----| |`daysOfWeek`|요일| |`startTime`|업무시작 시간을 설정합니다.| |`endTime`|업무종료 시간을 설정합니다.| ```javascript options = { businessHours: { daysOfWeek: [1, 2, 3, 4, 5], //월요일 ~ 금요일 startTime: \"10:00\", //출근 시간 endTime: \"18:00\" //퇴근 시간 } }; ``` ```javascript options = { businessHours: [ { daysOfWeek: [1, 2, 3], //월요일 ~ 수요일 startTime: \"10:00\", //출근 시간 endTime: \"18:00\" //퇴근 시간 }, { daysOfWeek: [4, 5], //목요일 ~ 금요일 startTime: \"09:00\", //출근 시간 endTime: \"17:00\" //퇴근 시간 } ], }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/business-hours.html"
          },
          {
            "cid": 11,
            "sid": "button-text",
            "name": "button-text",
            "label": "buttonText",
            "data": {
              "body": "> (\"headerToolbar\" or \"footerToolbar\") 속성으로 표시되는 버튼의 텍스트를 변경합니다. > 미설정 시 아래와 같은 값으로 설정되어 있습니다.(locale:\"en\" 기준) |button|값(value)| |------|------------------| |today|\"today\"| |month|\"month\"| |week|\"week\"\"| |day|\"day\"| |list|\"list\"| ### Type `object` ### Example ```javascript options = { buttonText: { month: \"월단위보기\" } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/button-text.html"
          },
          {
            "cid": 12,
            "sid": "content-height",
            "name": "content-height",
            "label": "contentHeight",
            "data": {
              "body": "> 상단(header)/하단(footer) 툴바(Toolbar) 영역을 제외한 캘린더 UI의 높이를 설정합니다. ### Type `number` | `string` ### Options |Value|Description| |-----|-----| |`undefined`|설정하지 않는 경우 [aspectRatio](/docs/props/options/aspect-ratio) 옵션값으로 월단위(dayGridMonth) 뷰(View)에서 표시하는 셀(Cell)의 가로 세로 비율을 계산하여 상단(header)/하단(footer) 툴바(Toolbar) 영역을 제외한 캘린더 UI의 높이를 설정합니다.(`default`)| |`number`|number로 설정 시 설정한 값과 동일하게 상단(header)/하단(footer) 툴바(Toolbar) 영역을 제외한 캘린더 UI의 높이를 설정합니다.| |`\"auto\"`|[aspectRatio](/docs/props/options/aspect-ratio) 옵션값으로 월단위(dayGridMonth) 뷰(View)에서 표시하는 셀(Cell)의 가로 세로 비율을 계산하여 IBCalendar를 높이를 설정하되, 세로 스크롤바가 생기지 않는 높이로 설정됩니다.| ### Example ```javascript options = { contentHeight: \"auto\" }; ```",
              "see": [
                {
                  "label": "height props",
                  "url": "/docs/props/options/height"
                },
                {
                  "label": "aspectRatio props",
                  "url": "/docs/props/options/aspect-ratio"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/content-height.html"
          },
          {
            "cid": 13,
            "sid": "custom-buttons",
            "name": "custom-buttons",
            "label": "customButtons",
            "data": {
              "body": "> 상단(header)/하단(footer) 툴바(Toolbar) 영역에 표시할 사용자 정의 버튼을 설정합니다. > \"text\" 와 \"icon\"을 동시에 설정 할 수 없습니다. ### Type `object` ### Options |Value|Description| |-----|-----| |`\"text\"`|버튼에 보여질 문자| |`\"icon\"`|버튼에 보여질 아이콘| icon 으로 설정할 수 있는 값 |Value|Description| |-----|-----| |`\"chevron-left\"`|\"<\" 모양의 아이콘| |`\"chevron-right\"`|\">\" 모양의 아이콘| |`\"chevrons-left\"`|\"<<\" 모양의 아이콘| |`\"chevrons-right\"`|\">>\" 모양의 아이콘| ### Example ```javascript options = { customButtons: { initialDate: { text: \"초기날짜\" }, myCustomButton: { icon: \"chevron-left\", // \"chevron-right\" || \"chevrons-left\" || \"chevrons-right\" } }, headerToolbar: { left: \"initialDate\", center: \"title\", right: \"myCustomButton\" } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/custom-buttons.html"
          },
          {
            "cid": 14,
            "sid": "day-headers",
            "name": "day-headers",
            "label": "dayHeaders",
            "data": {
              "body": "> \"dayGrid\", \"timeGrid\" 뷰(View)에 요일을 표시하는 `헤더(dayHeader)를 표시할지 여부`를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|요일 헤더를 표시하지 않습니다.| |`true`|요일 헤더를 표시합니다. (`default`)| ### Example ```javascript options = { dayHeaders: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/day-headers.html"
          },
          {
            "cid": 15,
            "sid": "day-max-event-rows",
            "name": "day-max-event-rows",
            "label": "dayMaxEventRows",
            "data": {
              "body": "> 하루에 표시될 수 있는 일정(Event)의 수를 설정합니다. > 일정(Event)이 `\"dayMaxEventRows\"` 옵션으로 설정한 수보다 많은 경우 `\"+2 개\"`와 같은 링크가 표시되며, > 표시되지 않은 나머지 일정(Event)들은 클릭 시 팝오버(Popover)로 표시됩니다. (링크 클릭 시의 동작은 [`moreLinkClick`](/docs/props/options/more-link-click) 옵션으로 설정할 수 있습니다.) ### Type `boolean` | `number` ### Options |Value|Description| |-----|-----| |`false`|모든 일정(Event)들을 표시합니다.(`default`) (셀(cell)의 높이보다 더 많은 일정(Event)을 표시해야 하는 경우 셀(cell)의 높이가 늘어납니다.)| |`true`|셀(cell)의 높이를 초과하지 않는 수의 일정(Event)만 표시되고 `\"+2 개\"`와 같은 링크가 표시됩니다.| ### Example ```javascript options = { dayMaxEventRows: false }; ``` > 하루에 표시될 수 있는 일정(Event)의 수를 `number`타입으로 직접 설정할 수도 있습니다. (`\"+2 개\"`와 같은 링크도 표시되는 갯수에 포함됩니다.) ```javascript options = { dayMaxEventRows: 3 }; ```",
              "see": [
                {
                  "label": "moreLinkClick props",
                  "url": "/docs/props/options/more-link-click"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/day-max-event-rows.html"
          },
          {
            "cid": 16,
            "sid": "day-popover-format",
            "name": "day-popover-format",
            "label": "dayPopoverFormat",
            "data": {
              "body": "> [`dayMaxEventRows`](/docs/props/options/day-max-event-rows) 옵션으로 생성된 일정(Event) 팝오버(Popover)의 타이틀의 날짜 포맷을 설정합니다. > [Luxon](https://github.com/moment/luxon/blob/master/docs/formatting.md)의 포맷 형식을 사용해야 합니다. ### Type `string` ### Example ```javascript options = { dayPopoverFormat: \"ccc, LLLL, dd\", dayMaxEventRows: 2 }; ```",
              "see": [
                {
                  "label": "dayMaxEventRows props",
                  "url": "/docs/props/options/day-max-event-rows"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/day-popover-format.html"
          },
          {
            "cid": 17,
            "sid": "direction",
            "name": "direction",
            "label": "direction",
            "data": {
              "body": "> 달력의 날짜가 렌더링되는 방향을 설정합니다. > (아랍어 및 히브리어와 같이 오른쪽에서 왼쪽으로 읽는 언어 환경에서 유용합니다.) ### Type `string` ### Options |Value|Description| |-----|------------| |`\"ltr\"`|왼쪽에서 오른쪽 (`default`)| |`\"rtl\"`|오른쪽에서 왼쪽| ### Example ```javascript options = { direction: \"rtl\" // 오른쪽에서 왼쪽으로 날짜가 렌더링 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/direction.html"
          },
          {
            "cid": 18,
            "sid": "display-event-end",
            "name": "display-event-end",
            "label": "displayEventEnd",
            "data": {
              "body": "> 일정(Event)의 종료시간을 표시할지 여부를 설정합니다. > default값은 다음과 같이 설정됩니다. |뷰(View)|value| |-----|-----| |`\"dayGridMonth\"`|`false`| |`\"dayGridWeek\"`|`false`| |`\"timeGridWeek\"`|`true`| |`\"timeGridDay\"`|`true`| |`\"dayGridDay\"`|`true`| ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|일정(Event)의 종료시간을 표시하지 않습니다.| |`true`|일정(Event)의 종료시간을 표시합니다.| ### Example ```javascript options = { views: { timeGridWeek: { displayEventEnd: false //주단위(timeGridWeek) 뷰(View)에 표시되는 일정(Event)의 종료시간을 표시안함 } } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/display-event-end.html"
          },
          {
            "cid": 19,
            "sid": "display-event-time",
            "name": "display-event-time",
            "label": "displayEventTime",
            "data": {
              "body": "> 일정(Event)의 날짜/시간 텍스트를 표시할지 여부를 설정합니다. > 종일 일정(allDay Event)은 `\"displayEventTime\"` 옵션과 상관없이 날짜/시간 텍스트를 표시하지 않습니다. > `\"displayEventTime\"` 옵션을 설정하지 않는 경우 모든 \"dayGrid\", \"timeGrid\" 뷰(View)에 표시되는 일정(Event)은 날짜/시간 텍스트를 표시합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|날짜/시간 텍스트를 표시하지 않습니다.| |`true`|날짜/시간 텍스트를 표시합니다.(`default`)| ### Example ```javascript options = { displayEventTime: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/display-event-time.html"
          },
          {
            "cid": 20,
            "sid": "drop-accept",
            "name": "drop-accept",
            "label": "dropAccept",
            "data": {
              "body": "> `IBCalendar로 Drag가 가능하도록 설정된 HTML element들을 필터링`하기 위한 CSS 클래스 이름을 설정합니다. > `\"dropAccept\"` 옵션은 [`droppable`](/docs/props/options/droppable) 옵션이 `true`인 경우에만 사용할 수 있습니다. > `\"dropAccept\"` 옵션의 값을 CSS selector 문자열로 설정하면 IBCalendar로 Drag가 가능하도록 설정된 HTML element들 중에 CSS selector에 해당하는 것들만 Dragging하여 IBCalendar에 Drop할 수 있습니다. ### Type `string` | `function` ### Example ```html <div id=\"calendar-container\"></div> <div id=\"draggable1\" class=\"cool-event\"></div> <div id=\"draggable2\"></div> ``` ```javascript options = { dropAccept: \".cool-event\", droppable: true, drop: function(info) { console.log(info); alert(\"dropped!\"); } }; new IBCalendar.Draggable(draggableEl1); //\"cool-event\" CSS 클래스가 정의되어 있으므로 Dragging하여 IBCalendar에 Drop할 수 있음 new IBCalendar.Draggable(draggableEl2); //\"cool-event\" CSS 클래스가 정의되어 있지 않아 Dragging하여 IBCalendar에 Drop할 수 없음 ```",
              "see": [
                {
                  "label": "droppable props",
                  "url": "/docs/props/options/droppable"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/drop-accept.html"
          },
          {
            "cid": 21,
            "sid": "droppable",
            "name": "droppable",
            "label": "droppable",
            "data": {
              "body": "> IBCalendar로 Drag가 가능하도록 설정한 HTML element나 다른 IBCalendar의 일정(Event)을 Dragging하여 IBCalendar에 Drop할 수 있는지 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|마우스 Drag & Drop 통하여 달력에 일정을 추가 할 수 있도록 허용하지 않습니다.(`default`)| |`true`|마우스 Drag & Drop 통하여 달력에 일정을 추가 할 수 있도록 허용합니다.| ### Example ```javascript options = { droppable: true }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/droppable.html"
          },
          {
            "cid": 22,
            "sid": "editable",
            "name": "editable",
            "label": "editable",
            "data": {
              "body": "> 달력 UI에 표시된 일정(Event)을 `수정할 수 있는지 여부`를 설정합니다. > (일정(Event)의 수정이란 마우스로 일정(Event)을 Dragging, Resizing하여 일정(Event)의 시작(start)과 끝(end) 날짜/시간 정보를 변경하는 것을 의미합니다.) ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|일정(Event)을 수정할 수 없습니다.(`default`)| |`true`|일정(Event)을 수정할 수 있습니다.| ### Example ```javascript options = { editable: true }; ``` > `\"editable\"` 옵션을 달력의 생성 옵션이 아닌 특정 일정(Event)의 옵션으로도 설정할 수 있습니다. ```javascript options = { eventSources: [ { events: [ { title:\"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true, editable:true }, { title:\"event2\", start: \"2020-06-10\", end: \"2020-06-11\", allDay: true }, { title:\"event3\", start: \"2020-06-15\", end: \"2020-06-16\", allDay: true }, ] } ], }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/editable.html"
          },
          {
            "cid": 23,
            "sid": "end-param",
            "name": "end-param",
            "label": "endParam",
            "data": {
              "body": "> 일정(Event) 정보를 가져오는 Fetch 발생 시 가져올 종료 범위의 parameter key 이름을 지정한 값으로 변경합니다. > (Back-End에서 추출할 달력의 날짜 종료 범위의 parameter의 key 이름을 의미합니다.) > (GET 방식의 parameter로 전달되는 querystring의 `\"end\"` key 이름을 설정한 문자열로 변경합니다.) ### Type `string` ### Options |Value|Description| |-----|-----| |`end`|(`default`)| ### Example ```javascript options = { endParam: \"end_param\" }; ```",
              "see": [
                {
                  "label": "startParam props",
                  "url": "/docs/props/options/start-param"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/end-param.html"
          },
          {
            "cid": 24,
            "sid": "event-class-names",
            "name": "event-class-names",
            "label": "eventClassNames",
            "data": {
              "body": "> 달력에 표시되는 모든 일정(Event) 요소에 클래스 이름을 추가합니다. > 배열을 통하여 여러개의 className 을 한번에 추가할 수 도 있습니다. ### Type `array` | `string` ### Example ```javascript options = { eventClassNames: \"event-class\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-class-names.html"
          },
          {
            "cid": 25,
            "sid": "event-constraint",
            "name": "event-constraint",
            "label": "eventConstraint",
            "data": {
              "body": "> 사용자가 일정(Event)을 특정 범위 내에서만 마우스로 Dragging, Resizing 하여 일정(Event)의 시작(start)과 끝(end) 날짜/시간 정보를 변경할 수 있도록 제한합니다. > `\"eventConstraint\"` 옵션을 설정하지 않은 경우 기본 동작으로 변경할 수 있는 영역의 범위를 제한하지 않습니다. > `\"businessHours\"`로 설정 시 [`businessHours`](/docs/props/options/business-hours) 옵션으로 설정한 업무시간(Business Hours)의 요일, 시간 범위 내에서만 일정(Event)의 시작(start)과 끝(end) 날짜/시간 정보 변경이 가능합니다. ### Type `string` | `object` ### Options |Value|Description| |-----|-----| |`\"businessHours\"`|[`businessHours`](/docs/props/options/business-hours) 옵션으로 설정한 업무시간으로 날짜/시간 정보 변경이 제한됩니다.| |`object`|사용자가 원하는 시간으로 날짜/시간 정보 변경을 제한할 수 있습니다.| ### Example ```javascript options = { eventConstraint: \"businessHours\", businessHours: true, editable: true, }; ``` ```javascript options = { eventConstraint: { daysOfWeek: [1, 2, 3, 4, 5], //월요일 ~ 금요일 startTime: \"10:00\", endTime: \"18:00\" }, editable: true, }; ``` > 일정(Event)의 시작(start)과 끝(end) 날짜/시간 정보를 변경할 수 있는 영역의 범위를 `eventSource`의 `\"constraint\"` 옵션을 이용하여 아래와 같이 `이벤트 소스(EventSource)단위`로도 설정할 수 있습니다. ```javascript options = { eventSources: [ { id: \"eventSource1\", events: [ { id: \"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true, title: \"event1\" }, { id: \"event2\", start: \"2020-06-03\", end: \"2020-06-04\", allDay: true, title: \"event2\" } ], constraint: { daysOfWeek: [1, 2, 3, 4, 5], //월요일 ~ 금요일 startTime: \"10:00\", endTime: \"18:00\" } } ] editable: true, }; ``` > 일정(Event)의 시작(start)과 끝(end) 날짜/시간 정보를 변경할 수 있는 영역의 범위를 일정(Event)의 `\"constraint\"` 옵션을 이용하여 아래와 같이 `일정(Event) 단위`로도 설정할 수 있습니다. ```javascript options = { eventSources: [ { id: \"eventSource1\", events: [ { id: \"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true, title: \"event1\", constraint: { daysOfWeek: [1, 2, 3, 4, 5], //월요일 ~ 금요일 startTime: \"10:00\", endTime: \"18:00\" } }, { id: \"event2\", start: \"2020-06-03\", end: \"2020-06-04\", allDay: true, title: \"event2\" } ] } ] editable: true, }; ```",
              "see": [
                {
                  "label": "businessHours props",
                  "url": "/docs/props/options/business-hours"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-constraint.html"
          },
          {
            "cid": 26,
            "sid": "event-content",
            "name": "event-content",
            "label": "eventContent",
            "data": {
              "body": "> 달력에 표시되는 모든 일정(Event) 요소에 표시할 텍스트를 설정합니다. > innerHTML로 삽입할 HTML 문자열을 { html: ' ' } 형태로 설정할 수 있습니다. > DOM node 형식으로 다루고자 할 경우, { domNodes: arrayOfDomNodes } 형태로 설정하면 사용할 수 있습니다. ### Type `object` | `function` ### Example ```javascript options = { eventContent: { html: '<i>일정<i>' } }; ``` > 위와같은 `object` 형식이 아닌 콜백(callback) 함수로도 정의할 수 있습니다. > 콜백(callback) 함수 정의 시 `\"eventContentInfo\"` 객체를 parameter로 사용할 수 있으며, > return 을 통하여 주번호(WeekNumber) 영역에 표시할 텍스트 또는 HTML 문자열, DOM node 를 설정할 수 있습니다. `eventContentInfo` 정보 |parameter|DataType|설명| |------|------|------------------| |`event`|`EventApi`|렌더링 될 일정(Event) UI 정보| |`timeText`|`string`|렌더링 될 일정(Event)이 종일 일정(Event)이 아닐 경우 표시되는 시간 text| |`backgroundColor`|`string`|렌더링 될 일정(Event)의 backgroundColor| |`borderColor`|`string`|렌더링 될 일정(Event)의 borderColor| |`textColor`|`string`|렌더링 될 일정(Event)의 textColor| |`isDraggable`|`boolean`|렌더링 될 일정(Event)의 drag 가능여부| |`isStartResizable`|`boolean`|렌더링 될 일정(Event)이 drag를 통하여 시작시간 수정 가능여부| |`isEndResizable`|`boolean`|렌더링 될 일정(Event)이 drag를 통하여 종료시간 수정 가능여부| |`isMirror`|`boolean`|렌더링 될 일정(Event) UI가 [`selectMirror`](/docs/props/options/select-mirror) 옵션을 true로 설정하여 표시된 Mirror UI인지 여부| |`isStart`|`boolean`|렌더링 될 일정(Event) 정보의 시작 UI 여부| |`isEnd`|`boolean`|렌더링 될 일정(Event) 정보의 종료 UI 여부| |`isPast`|`boolean`|렌더링 될 일정(Event)이 오늘날짜 기준 과거인지 여부| |`isFuture`|`boolean`|렌더링 될 일정(Event)이 오늘날짜 기준 미래인지 여부| |`isToday`|`boolean`|렌더링 될 일정(Event)이 오늘날짜 인지 여부| |`isSelected`|`boolean`|렌더링 될 일정(Event)이 선택된 상태인지 여부| |`isDragging`|`boolean`|렌더링 될 일정(Event)이 현재 drag중인지 여부| |`isResizing`|`boolean`|렌더링 될 일정(Event)이 현재 drag를 통하여 시간을 수정중인지 여부| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { eventContent: function (eventContentInfo){ return eventContentInfo.timeText; } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-content.html"
          },
          {
            "cid": 27,
            "sid": "event-editpopup-24hformat",
            "name": "event-editpopup-24hformat",
            "label": "eventEditPopup24hFormat",
            "data": {
              "body": "> 이벤트 편집창의 시간 표시 형식을 `24H` 형태로 사용할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |0|24H 형식 사용 안함 (`default`) | |1|24H 형식 사용| ### Example ```javascript options = { eventEditPopup24hFormat: 1 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.6.0.1|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.6.0.1|기능 추가|"
            },
            "url": "docs/props/options/event-editpopup-24hformat.html"
          },
          {
            "cid": 28,
            "sid": "event-max-stack",
            "name": "event-max-stack",
            "label": "eventMaxStack",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)에서 시간 일정(Event)이 가로로 겹칠 수 있는 최대 갯수를 설정합니다. > 일정(Event)이 `\"eventMaxStack\"` 옵션으로 설정한 수보다 많이 겹쳐질 경우 `\"+2\"`와 같은 링크가 표시되며, 표시되지 않은 나머지 일정(Event)들은 클릭 시 팝오버(Popover)로 표시됩니다. ### Type `number` ### Example ```javascript options = { eventMaxStack: 2 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-max-stack.html"
          },
          {
            "cid": 29,
            "sid": "event-min-height",
            "name": "event-min-height",
            "label": "eventMinHeight",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)에서 시간 일정(Event)의 범위 간격이 작더라도 UI의 최소 높이(height)를 픽셀값으로 설정합니다. > `\"eventMinHeight\"` 옵션의 default 값은 15 입니다. ### Type `number` ### Example ```javascript options = { eventMinHeight: 50 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-min-height.html"
          },
          {
            "cid": 30,
            "sid": "event-order",
            "name": "event-order",
            "label": "eventOrder",
            "data": {
              "body": "> 같은 날짜에 표시되는 일정(Event)들의 `우선순위`를 설정합니다. > 대부분의 뷰(View)에서는 같은 날짜에 `세로로 표시되는 일정(Event)들의 순서`를 의미하고, \"timeGrid\" 뷰(View)에서는 `가로로 표시되는 일정(Event)들의 순서`를 의미합니다. > defatul값은 `\"start,-duration,allDay,title\"`로 설정되며, `이전 일정(Event)`, `묶여있는 일정(Event)`이 우선순위가 더 높다고 판단합니다. 묶여있는 일정(Event)들끼리는 `title의 알파벳 순서`로 판단합니다. > `\"eventOrder\"` 옵션은 아래와 같은 항목들로 설정할 수 있습니다. - `\"title\"`과 같은 일정(Event) 정보의 옵션명: 오름차순으로 우선순위를 설정합니다. \"-title\"과 같이 `\"-\"` 문자를 붙이면 내림차순으로도 우선순위를 설정할 수 있습니다. - `\",\"`로 구분된 일정(Event) 정보의 옵션명들의 문자열: \"title,propA,-propB\" - `1` 또는 `-1`을 반환하는 함수: javascript 배열의 sort()함수에서 사용하는 compare 함수와 유사합니다. - 일정(Event) 정보의 옵션명 또는 1 또는 -1을 반환하는 함수의 배열: [\"title\", \"-propA\", myFunc] ### Type `string` | `array` ### Example ```javascript options = { eventOrder: \"title\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-order.html"
          },
          {
            "cid": 31,
            "sid": "event-overlap",
            "name": "event-overlap",
            "label": "eventOverlap",
            "data": {
              "body": "> 마우스로 Dragging, Resizing 중인 일정(Event)이 `서로 겹쳐질 수 있는지 여부`를 설정합니다. ### Type `boolean` | `function` ### Options |Value|Description| |-----|-----| |`false`|마우스를 통하여 달력 선택을 허용하지 않습니다.| |`true`|모든 일정(Event)이 겹쳐져 표시됩니다.(`default`)| |`콜백(callback)`|사용자가 일정(Event)을 마우스로 Dragging, Resizing 할 때 다른 일정(Event)과 `겹쳐지는 경우에 호출됩니다.| ### Example ```javascript options = { eventOverlap: false }; ``` > 겹쳐지는 일정(Event) 정보 객체인 `stillEvent`와 마우스로 Dragging, Resizing 중인 일정(Event) 정보 객체인 `movingEvent`를 parameter로 갖고 서로 겹쳐질 수 있는지 여부를 반환하는 `콜백(callback) 함수`로도 설정할 수 있습니다. |parameter|Description| |-----|-----| |`stillEvent`|겹쳐지는 일정(Event) 정보 객체| |`movingEvent`|마우스로 Dragging, Resizing 중인 일정(Event) 정보 객체| ```javascript options = { eventOverlap: function(stillEvent, movingEvent) { return stillEvent.allDay && movingEvent.allDay; //마우스로 Dragging, Resizing중인 일정(Event)과 겹쳐지는 일정(Event) 둘 다 종일 일정(allDay Event)인 경우에만 겹치기를 허용 }, }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-overlap.html"
          },
          {
            "cid": 32,
            "sid": "event-popup-24hformat",
            "name": "event-popup-24hformat",
            "label": "eventPopup24hFormat",
            "data": {
              "body": "> 이벤트 팝업창의 시간 표시 형식을 `24H` 형태로 사용할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |0|24H 형식 사용 안함 (`default`) | |1|24H 형식 사용| ### Example ```javascript options = { eventPopup24hFormat: 1 //Luxon 포맷, \"14:00\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.6.0.1|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.6.0.1|기능 추가|"
            },
            "url": "docs/props/options/event-popup-24hformat.html"
          },
          {
            "cid": 33,
            "sid": "event-text-color",
            "name": "event-text-color",
            "label": "eventTextColor",
            "data": {
              "body": "> 달력 UI의 모든 일정(Event)의 텍스트 색상을 설정합니다. ### Type `string` ### Example > 모든 일정(Event)의 텍스트 색상을 설정합니다. ```javascript options = { eventTextColor: \"#FF0000\" //\"#f00\" or \"#FF0000\" or \"rgb(255,0,0)\" or \"red\" }; ``` > 이벤트 소스(EventSource)의 `textColor` 옵션을 사용하여 아래와 같이 `지정한 이벤트 소스(EventSource)의 모든 일정(Event)의 텍스트 색상`을 설정합니다. ```javascript options = { eventSources: [ { id: \"eventSource1\", textColor: \"#FF0000\", events: [ { id: \"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true, title: \"event1\" }, { id: \"event2\", start: \"2020-06-03\", end: \"2020-06-04\", allDay: true, title: \"event2\" } ] } ] }; ``` > 일정(Event) 정보 객체의 `textColor` 옵션을 사용하여 아래와 같이 `지정한 일정(Event)의 텍스트 색상`을 설정합니다. ```javascript options = { eventSources: [ { id: \"eventSource1\", events: [ { id: \"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true, title: \"event1\" }, { id: \"event2\", start: \"2020-06-03\", end: \"2020-06-04\", allDay: true, title: \"event2\", textColor: \"#FF0000\" } ] } ] }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-text-color.html"
          },
          {
            "cid": 34,
            "sid": "event-time-format",
            "name": "event-time-format",
            "label": "eventTimeFormat",
            "data": {
              "body": "> 일정(Event)에 표시될 `시간 텍스트의 포맷`을 설정합니다. > [Luxon](https://github.com/moment/luxon/blob/master/docs/formatting.md)의 포맷 형식을 사용해야 합니다. > 종일 일정(allDay Event)이 아닌 시간 일정(Event)에만 적용되는 설정입니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`\"hh:mm\"`|(`default`)| ### Example ```javascript options = { eventTimeFormat: \"HH:mm\" //Luxon 포맷, \"14:00\" }; ```",
              "see": [
                {
                  "label": "Luxon formatting",
                  "url": "https://github.com/moment/luxon/blob/master/docs/formatting.md"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/event-time-format.html"
          },
          {
            "cid": 35,
            "sid": "expand-rows",
            "name": "expand-rows",
            "label": "expandRows",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)의 행이 전체 높이를 차지하지 않으면 크기에 맞게 행의 높이를 확장할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|\"timeGrid\" 뷰(View)의 시간축 행이 달력의 전체 높이보다 작더라도 전체 높이에 맞게 확장하지 않습니다. (`default`)| |`true`|\"timeGrid\" 뷰(View)의 시간축 행이 달력의 전체 높이에 맞추어 확장되어 커집니다.| ### Example ```javascript options = { expandRows: true }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/expand-rows.html"
          },
          {
            "cid": 36,
            "sid": "first-day",
            "name": "first-day",
            "label": "firstDay",
            "data": {
              "body": "> 일주일이 시작되는 요일을 설정합니다. > (0:일요일, 1:월요일, 2:화요일, 3:수요일, 4:목요일, 5:금요일, 6:토요일) > default값은 `1`(월요일)로 설정되며, 설정된 locale에 따라 달라질 수 있습니다. > [`weekNumberCalculation`](/docs/props/options/week-number-calculation) 옵션이 설정되어 있으면 \"ISO\"가 default값으로 설정됩니다. ### Type `number` ### Example ```javascript options = { firstDay: 1 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/first-day.html"
          },
          {
            "cid": 37,
            "sid": "fixed-week-count",
            "name": "fixed-week-count",
            "label": "fixedWeekCount",
            "data": {
              "body": "> 월단위(dayGridMonth) 뷰(View) 사용 시 한 달에 표시되는 주의 수를 항상 6주로 고정할 것인지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|현재 표시하는 월이 4주나 5주인 경우 4주나 5주만 표시합니다.| |`true`|항상 6주를 표시합니다.(`default`)| ### Example ```javascript options = { fixedWeekCount: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/fixed-week-count.html"
          },
          {
            "cid": 38,
            "sid": "footer-toolbar",
            "name": "footer-toolbar",
            "label": "footerToolbar",
            "data": {
              "body": "> 달력 하단에 표시할 툴바(Toolbar)를 설정합니다. > left/center/right 로 표시될 위치를 구분합니다. > false로 설정하면 푸터가 표시되지 않습니다. > \"left\", \"center\", \"right\" 속성에는 쉼표(\",\"), 공백(\" \")으로 구분된 값들이 포함된 문자열이 설정됩니다. > 쉼표(\",\")로 구분된 값은 인접한 버튼으로 표시됩니다. 공백(\" \")으로 구분된 값은 버튼들 사이에 간격을 생성합니다. > default 값은 false로 설정됩니다. ### Type `boolean` | `object` ### Options |Value|Description| |-----|-----| |`left`|왼쪽에 표시할 버튼/텍스트| |`center`|가운데에 표시할 버튼/텍스트| |`right`|오른쪽에 표시할 버튼/텍스트| |Value|Description| |-----|-----| |`\"title\"`|현재 월 / 주 / 일을 표시하는 텍스트| |`\"prev\"`|한 달 / 주 / 일을 이전으로 이동 시키는 버튼| |`\"next\"`|한 달 / 주 / 일 다음으로 이동 시키는 버튼| |`\"prevYear\"`|1년 이전으로 이동 시키는 버튼| |`\"nextYear\"`|1년 다음으로 이동 시키는 버튼| |`\"today\"`|현재 월 / 주 / 일로 이동 시키는 버튼| |`뷰(View) 이름`|지정한 뷰(View)로 전환하는 버튼| **뷰(View) 목록** |Value|Description| |-----|-----| |`\"dayGridMonth\"`|월 단위로 보기| |`\"dayGridWeek\"`|주 단위로 보기| |`\"dayGridDay\"`|일 단위로 보기| |`\"timeGridWeek\"`|주 단위로 보기(시간 테이블 포함)| |`\"timeGridDay\"`|일 단위로 보기(시간 테이블 포함)| |`\"listYear\"`|1년 단위로 일정 목록 보기| |`\"listMonth\"`|월 단위로 일정 목록 보기| |`\"listWeek\"`|주 단위로 일정 목록 보기| |`\"listDay\"`|일 단위로 일정 목록 보기| ### Example ```javascript footerToolbar: { left: \"prev,next today\", center: \"title\", right: \"dayGridMonth,timeGridWeek,timeGridDay\" } ```",
              "see": [
                {
                  "label": "headerToolbar props",
                  "url": "/docs/props/options/header-toolbar"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/footer-toolbar.html"
          },
          {
            "cid": 39,
            "sid": "header-toolbar",
            "name": "header-toolbar",
            "label": "headerToolbar",
            "data": {
              "body": "> 달력 상단에 표시할 툴바(Toolbar)를 설정합니다. > left/center/right 로 표시될 위치를 구분합니다. > false로 설정하면 헤더가 표시되지 않습니다. > \"left\", \"center\", \"right\" 속성에는 쉼표(\",\"), 공백(\" \")으로 구분된 값들이 포함된 문자열이 설정됩니다. > 쉼표(\",\")로 구분된 값은 인접한 버튼으로 표시됩니다. 공백(\" \")으로 구분된 값은 버튼들 사이에 간격을 생성합니다. ### Type `boolean` | `object` ### Options |Value|Description| |-----|-----| |`left`|왼쪽에 표시할 버튼/텍스트| |`center`|가운데에 표시할 버튼/텍스트| |`right`|오른쪽에 표시할 버튼/텍스트| |Value|Description| |-----|-----| |`\"title\"`|현재 월 / 주 / 일을 표시하는 텍스트| |`\"prev\"`|한 달 / 주 / 일을 이전으로 이동 시키는 버튼| |`\"next\"`|한 달 / 주 / 일 다음으로 이동 시키는 버튼| |`\"prevYear\"`|1년 이전으로 이동 시키는 버튼| |`\"nextYear\"`|1년 다음으로 이동 시키는 버튼| |`\"today\"`|현재 월 / 주 / 일로 이동 시키는 버튼| |`뷰(View) 이름`|지정한 뷰(View)로 전환하는 버튼| **뷰(View) 목록** |Value|Description| |-----|-----| |`\"dayGridMonth\"`|월 단위로 보기| |`\"dayGridWeek\"`|주 단위로 보기| |`\"dayGridDay\"`|일 단위로 보기| |`\"timeGridWeek\"`|주 단위로 보기(시간 테이블 포함)| |`\"timeGridDay\"`|일 단위로 보기(시간 테이블 포함)| |`\"listYear\"`|1년 단위로 일정 목록 보기| |`\"listMonth\"`|월 단위로 일정 목록 보기| |`\"listWeek\"`|주 단위로 일정 목록 보기| |`\"listDay\"`|일 단위로 일정 목록 보기| ### Example ```javascript headerToolbar: { left: \"prev,next today\", center: \"title\", right: \"dayGridMonth,timeGridWeek,timeGridDay\" } ```",
              "see": [
                {
                  "label": "footerToolbar props",
                  "url": "/docs/props/options/footer-toolbar"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/header-toolbar.html"
          },
          {
            "cid": 40,
            "sid": "height",
            "name": "height",
            "label": "height",
            "data": {
              "body": "> 상단(header)/하단(footer) 툴바(Toolbar) 영역을 포함한 달력의 높이를 설정합니다. ### Type `number` | `string` ### Options |Value|Description| |-----|-----| |`undefined`|설정하지 않는 경우 [aspectRatio](/docs/props/options/aspect-ratio) (`default`)| |`number`|number로 설정 시 설정한 값과 동일하게 IBCalendar의 높이를 설정합니다.| |`\"100%\"`|IBCalendar의 높이를 부모 컨테이너의 높이와 동일하게 설정됩니다.| |`\"auto\"`|[aspectRatio](/docs/props/options/aspect-ratio) 옵션값으로 월단위(dayGridMonth) 뷰(View)에서 표시하는 셀(Cell)의 가로 세로 비율을 계산하여 달력의 높이를 설정하되, 세로 스크롤바가 생기지 않는 높이로 설정됩니다.| ### Example ```javascript options = { height: \"100%\" }; ```",
              "see": [
                {
                  "label": "contentHeight props",
                  "url": "/docs/props/options/content-height"
                },
                {
                  "label": "aspectRatio props",
                  "url": "/docs/props/options/aspect-ratio"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/height.html"
          },
          {
            "cid": 41,
            "sid": "hidden-days",
            "name": "hidden-days",
            "label": "hiddenDays",
            "data": {
              "body": "> 특정 요일이 표시되지 않도록 설정합니다. > 주말(토요일, 일요일)을 표시하고 싶지 않은 경우 `hiddenDays` 옵션 대신 [`weekends`](/docs/props/options/weekends) 옵션을 사용해야 합니다. ### Type `array` ### Options |Value|Description| |-----|-----| |`0`|일요일| |`1`|월요일| |`2`|화요일| |`3`|수요일| |`4`|목요일| |`5`|금요일| |`6`|토요일| ### Example ```javascript options = { hiddenDays: [2, 4] //화요일, 목요일 표시 안함 }; ```",
              "see": [
                {
                  "label": "weekends props",
                  "url": "/docs/props/options/weekends"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/hidden-days.html"
          },
          {
            "cid": 42,
            "sid": "initial-date",
            "name": "initial-date",
            "label": "initialDate",
            "data": {
              "body": "> 달력 UI가 초기화 될 때 초기 날짜를 설정합니다. > `\"initialDate\"` 옵션의 값은 ISO8601 문자열, millisecond 문자열, javascript Date 객체 형태로 설정할 수 있습니다. > `\"initialDate\"` 옵션을 설정하지 않으면 초기날짜를 오늘로 설정합니다. ### Type `Date object` | `string` ### Example ```javascript options = { initialDate: \"2020-06-01\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/initial-date.html"
          },
          {
            "cid": 43,
            "sid": "initial-view",
            "name": "initial-view",
            "label": "initialView",
            "data": {
              "body": "> 달력 UI가 처음 렌더링 될 때 표시할 `뷰(View)의 이름`을 설정합니다. > default값은 \"dayGridMonth\"로 설정됩니다. ### Type `string` ### Example ```javascript options = { initialView: \"dayGridWeek\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/initial-view.html"
          },
          {
            "cid": 44,
            "sid": "lazy-fetching",
            "name": "lazy-fetching",
            "label": "lazyFetching",
            "data": {
              "body": "> 일정(Event) 정보를 가져오는 Fetch 발생 시 가져와야 하는 일정(Event) 정보의 범위가 현재 가지고 있는 일정(Event) 정보의 범위에 포함되어 이미 존재하는 경우에는 Fetch가 발생하지 않도록 할지 여부를 설정합니다. > 예를 들어, 2월을 표시하고 있는 월단위(dayGridMonth) 뷰(View)에서 2월의 첫째주를 표시하는 \"timeGridWeek\" 뷰(View)로 전환 시 이미 2월의 일정(Event) 정보를 모두 가지고 있었기 때문에 IBCalendar는 aJax 호출을 최소화하기 위해 Fetch가 발생하지 않습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|뷰(View)가 전환되거나 이전/다음 버튼을 누를때마다 Fetch가 발생합니다.| |`true`|일정(Event) 정보 조회 시 이미 존재하는 일정의 경우에는 Fetch가 발생하지 않습니다.(`default`)| ### Example ```javascript options = { lazyFetching: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/lazy-fetching.html"
          },
          {
            "cid": 45,
            "sid": "locale",
            "name": "locale",
            "label": "locale",
            "data": {
              "body": "> 달력 UI의 특정 부분을 `특정 국가의 언어`로 표시하도록 설정합니다. > 해당하는 언어팩 파일을 추가해야 사용할 수 있습니다. > `\"locale\"` 옵션을 설정하면 아래와 같은 항목들이 영향을 받습니다. - IBCalendar 상단(header)/하단(footer) 툴바(Toolbar) 영역에 표시된 버튼들의 텍스트 - 월(month) 또는 요일(day-of-week) 문자열을 포함하는 텍스트 - locale에 영향을 받는 [`Luxon`](https://github.com/moment/luxon/blob/master/docs/formatting.md) 날짜/시간 포맷 - [`weekNumberCalculation`](/docs/props/options/week-number-calculation) 옵션 - [`firstDay`](/docs/props/options/first-day) 옵션 ### Type `string` ### Options |Value|Description| |-----|------------| |`\"en\"`|English - United States| |`\"ko\"`|Korean (`default`)| ### Example ```javascript options = { locale: \"en\" //locale을 영어로 설정 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/locale.html"
          },
          {
            "cid": 46,
            "sid": "more-link-click",
            "name": "more-link-click",
            "label": "moreLinkClick",
            "data": {
              "body": "> [`dayMaxEventRows`](/docs/props/options/day-max-event-rows), [`eventMaxStack`](/docs/props/options/event-max-stack) 옵션으로 인해 표시된 `\"+2 개\"`와 같은 링크 클릭 시의 동작을 설정합니다. ### Type `string` | `function` ### Options |Value|Description| |-----------|------------------| |`\"popover\"`|링크 클릭 시 해당 날짜의 모든 일정(Event)들이 팝오버(Popover)로 표시됩니다. (default)| |`\"week\"`|링크 클릭 시 [`headerToolbar`](/docs/props/options/header-toolbar) 또는 [`footerToolbar`](/docs/props/options/footer-toolbar) 옵션에 설정되어 있는 주 단위(timeGridWeek) 뷰(View)로 전환 후 현재 날짜의 일정(Event) 정보들을 표시합니다.| |`\"day\"`|링크 클릭 시 [`headerToolbar`](/docs/props/options/header-toolbar) 또는 [`footerToolbar`](/docs/props/options/footer-toolbar) 옵션에 설정되어 있는 일 단위(timeGridDay) 뷰(View)로 전환 후 현재 날짜의 일정(Event) 정보들을 표시합니다.| |`뷰(View) 이름`|링크 클릭 시 지정한 이름의 뷰(View)로 전환 후 현재 날짜의 일정(Event) 정보들을 표시합니다.| |`event callback`|링크 클릭 시 설정한 콜백(callback) 함수를 호출합니다.| ### Example ```javascript options = { moreLinkClick: \"week\" }; ``` > 콜백(callback) 함수로 설정 시 \"info\" parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|---------|------------------| |`date`|`Date`|클릭한 날짜의 javascript Date 객체| |`allSegs`|`<Segment객체>[]`|해당 날짜의 모든 일정(Event)들의 Segment 객체 배열| |`hiddenSegs`|`<Segment객체>[]`|표시되지 않은 일정(Event)들의 Segment 객체 배열| |`jsEvent`|`MouseEvent`|링크 클릭 시 발생하는 javascript 이벤트 콜백(callback) 함수| > Segment 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`Event`|`EventApi`|일정(Event) 정보| |`start`|`Date`|일정(Event)의 시작 날짜 정보| |`end`|`Date`|일정(Event)의 종료 날짜 정보| |`isStart`|`boolean`|클릭한 날짜에 시작된 일정(Event)인지 여부| |`isEnd`|`boolean`|클릭한 날짜에 끝나는 일정(Event)인지 여부| ```javascript options = { moreLinkClick: function(info){ console.log(info.date); console.log(info.allSegs); console.log(info.hiddenSegs); console.log(info.jsEvent); }, editable: true }; ```",
              "see": [
                {
                  "label": "dayMaxEventRows props",
                  "url": "/docs/props/options/day-max-event-rows"
                },
                {
                  "label": "eventMaxStack props",
                  "url": "/docs/props/options/event-max-stack"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/more-link-click.html"
          },
          {
            "cid": 47,
            "sid": "move-month-scroll-wheel",
            "name": "move-month-scroll-wheel",
            "label": "moveMonthScrollWheel",
            "data": {
              "body": "> 월단위(dayGridMonth) 뷰(View) 보기에서 마우스 휠 동작으로 이전/다음달 이동할 지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|달력 위에서 마우스 휠 동작으로 이전, 다음 월로 이동 되지 않습니다.| |`true`|달력 위에서 마우스 휠 동작으로 이전, 다음 월로 이동 되지 않습니다.(`default`)| ### Example ```javascript options = { moveMonthScrollWheel: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/move-month-scroll-wheel.html"
          },
          {
            "cid": 48,
            "sid": "nav-link-day-click",
            "name": "nav-link-day-click",
            "label": "navLinkDayClick",
            "data": {
              "body": "> 월단위(dayGridMonth) 뷰(View)의 `날짜(Date)를 표시하는 텍스트` 또는 \"timeGrid\" 뷰(View)의 `요일을 표시하는 텍스트`를 마우스로 클릭 시 발생하는 `콜백(callback) 함수를 정의`합니다. > 문자열 값으로 뷰 이름을 사용 시, `해당하는 뷰`로 이동 됩니다. > [`navLinks`](/docs/props/options/nav-links) 옵션을 `true`로 설정한 경우에만 유효한 옵션입니다. > `\"navLinkDayClick\"` 옵션을 설정하게 되면 `날짜(Date)를 표시하는 텍스트` 또는 \"timeGrid\" 뷰(View)의 `요일을 표시하는 텍스트`를 마우스로 클릭 시 `\"timeGridDay\" 뷰(View)`로 이동하지 않습니다. > `\"navLinkDayClick\"` 옵션을 설정하지 않으면 기본 동작으로 `\"timeGridDay\" 뷰(View)`로 이동합니다. > 콜백(callback) 함수로 설정 시 클릭한 날짜의 정보인 \"Date\" 타입의 `date`와 javascript \"click\" 이벤트 객체 `jsEvent`를 parameter로 갖습니다. ### Type `string` | `function` ### Options |Value|Description| |-----|-----| |`뷰(view) name`|`\"dayGridMonth\"`, `\"timeGridWeek\"`, `\"listMonth\"` 등의 뷰(view) 이름| |`콜백(callback)`|마우스 클릭시 동작되는 콜백(callback) 함수| ### Example ```javascript options = { navLinkDayClick: \"timeGridWeek\", // \"timeGridWeek\" 로 이동 navLinks: true }; ``` |parameter|Description| |-----|-----| |`date`|클릭한 날짜의 정보(Date 타입)| |`jsEvent`|javascript \"click\" 이벤트 객체| ```javascript options = { navLinkDayClick: function(date, jsEvent) { console.log(\"날짜:\", date.toString()); console.log(jsEvent.type); }, navLinks: true }; ```",
              "see": [
                {
                  "label": "navLinks props",
                  "url": "/docs/props/options/nav-links"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/nav-link-day-click.html"
          },
          {
            "cid": 49,
            "sid": "nav-link-week-click",
            "name": "nav-link-week-click",
            "label": "navLinkWeekClick",
            "data": {
              "body": "> 월단위(dayGridMonth) 뷰(View)와 \"timeGrid\" 뷰(View)의 `주번호(WeekNumber) 텍스트`를 마우스로 클릭 시 발생하는 `콜백(callback) 함수를 정의`합니다. > 문자열 값으로 뷰 이름을 사용 시, `해당하는 뷰`로 이동 됩니다. > [`navLinks`](/docs/props/options/nav-links) 옵션을 `true`로 설정한 경우에만 유효한 옵션입니다. > `\"navLinkWeekClick\"` 옵션을 설정하게 되면 `주번호(WeekNumber) 텍스트`를 마우스로 클릭 시 `\"timeGridWeek\" 뷰(View)`로 이동하지 않습니다. > `\"navLinkWeekClick\"` 옵션을 설정하지 않으면 기본 동작으로 `\"timeGridWeek\" 뷰(View)`로 이동합니다. > 콜백(callback) 함수로 설정 시 클릭한 주번호(WeekNumber)의 시작일 정보인 \"Date\" 타입의 `weekStart`와 javascript \"click\" 이벤트 객체 `jsEvent`를 parameter로 갖습니다. ### Type `string` | `function` ### Options |Value|Description| |-----|-----| |`뷰(view) name`|`\"dayGridMonth\"`, `\"timeGridWeek\"`, `\"listMonth\"` 등의 뷰(view) 이름| |`콜백(callback)`|마우스 클릭시 동작되는 콜백(callback) 함수| ### Example ```javascript options = { navLinkWeekClick: \"timeGridWeek\" // \"timeGridWeek\" 로 이동 navLinks: true, weekNumbers: true }; ``` |parameter|Description| |-----|-----| |`weekStart`|클릭한 주번호(WeekNumber)의 시작일 날짜의 정보(Date 타입)| |`jsEvent`|javascript \"click\" 이벤트 객체| ```javascript options = { navLinkWeekClick: function(weekStart, jsEvent) { console.log(\"선택한 주번호의 시작일: \", weekStart.toString()); console.log(jsEvent.type); }, navLinks: true, weekNumbers: true }; ```",
              "see": [
                {
                  "label": "navLinks props",
                  "url": "/docs/props/options/nav-links"
                },
                {
                  "label": "weekNumbers props",
                  "url": "/docs/props/options/week-numbers"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/nav-link-week-click.html"
          },
          {
            "cid": 50,
            "sid": "nav-links",
            "name": "nav-links",
            "label": "navLinks",
            "data": {
              "body": "> 월단위(dayGridMonth) 뷰(View)의 `날짜(Date)나 주번호(WeekNumber)를 표시하는 텍스트` 또는 \"timeGrid\" 뷰(View)의 `요일이나 주번호(WeekNumber)를 표시하는 텍스트`를 마우스로 클릭할 수 있도록 활성화 할지 여부를 설정합니다. > 월단위(dayGridMonth) 뷰(View)의 `날짜(Date)를 표시하는 텍스트` 또는 \"timeGrid\" 뷰(View)의 `요일을 표시하는 텍스트`를 마우스로 클릭 시 `\"timeGridDay\" 뷰(View)`로 이동합니다. > [`weekNumbers`](/docs/props/options/week-numbers) 옵션을 true로 설정하여 표시된 주번호(WeekNumber)를 클릭 시 `\"timeGridWeek\" 뷰(View)`로 동합니다. > `\"navLinks\"` 옵션을 `true`로 설정 후 마우스 클릭 시 이동되는 뷰(View)의 타입은 [`headerToolbar`](/docs/props/options/header-toolbar) 옵션으로 설정한 뷰들을 고려하여 자동으로 결정되지만 [`navLinkDayClick`](/docs/props/options/nav-link-day-click), [`navLinkWeekClick`](/docs/props/options/nav-link-week-click) 옵션을 사용하여 명시적으로 정의할 수도 있습니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|날짜, 주번호 마우스 클릭을 허용하지 않습니다. (`default`)| |`true`|날짜, 주번호 마우스 클릭을 허용합니다. | ### Example ```javascript options = { navLinks: true }; ```",
              "see": [
                {
                  "label": "weekNumbers props",
                  "url": "/docs/props/options/week-numbers"
                },
                {
                  "label": "navLinkDayClick props",
                  "url": "/docs/props/options/nav-link-day-click"
                },
                {
                  "label": "navLinkWeekClick props",
                  "url": "/docs/props/options/nav-link-week-click"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/nav-links.html"
          },
          {
            "cid": 51,
            "sid": "no-events-class-names",
            "name": "no-events-class-names",
            "label": "noEventsClassNames",
            "data": {
              "body": "> list 뷰(View)의 지정한 범위 내에 표시할 일정(Event)이 없을 때 list 뷰(View) 중앙에 표시되는 요소에 클래스 이름을 추가합니다.(`list에만 적용되는 옵션입니다.`) > 배열을 통하여 여러개의 className 을 한번에 추가할 수 도 있습니다. > 일정(Event)의 날짜/시간 변경된 경우에만 발생합니다. ### Type `string` | `array` | `function` ### Example ```javascript options = { noEventsClassNames: \"noEvent-class\", initialView: \"listMonth\" }; ``` > 콜백(callback) 함수를 정의할 수 있습니다. > 콜백(callback) 함수 정의 시 `\"noEventsClassNamesInfo\"` 객체를 parameter로 사용할 수 있으며, return 을 통하여 noEvents 영역에 추가할 클래스 이름을 반환하면 클래스 이름이 추가됩니다. > `\"noEventsClassNamesInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`text`|`string`|기본 표시 텍스트| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { noEventsClassNames: function(noEventsClassNamesInfo) { console.log(noEventsClassNamesInfo.text); console.log(noEventsClassNamesInfo.view); return \"noEvent-class\"; } }; ```",
              "see": [
                {
                  "label": "noEventsContent props",
                  "url": "/docs/props/options/no-events-content"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/no-events-class-names.html"
          },
          {
            "cid": 52,
            "sid": "no-events-content",
            "name": "no-events-content",
            "label": "noEventsContent",
            "data": {
              "body": "> list 뷰(View)의 지정한 범위 내에 표시할 일정(Event)이 없을 때 list 뷰(View) 중앙에 표시할 텍스트를 설정합니다.(`list에만 적용되는 옵션입니다.`) > innerHTML로 삽입할 HTML 문자열을 { html: ' ' } 형태로 설정할 수 있습니다. > DOM node 형식으로 다루고자 할 경우, { domNodes: arrayOfDomNodes } 형태로 설정하면 사용할 수 있습니다. ### Type `string` | `array` | `function` ### Example ```javascript options = { noEventsContent: \"- 일정이 없습니다 -\", initialView: \"listMonth\" }; ``` > 콜백(callback) 함수를 정의할 수 있습니다. > 콜백(callback) 함수 정의 시 `\"noEventsContentInfo\"` 객체를 parameter로 사용할 수 있으며, return 을 통하여 noEvents 영역에 표시할 텍스트 또는 HTML 문자열, DOM node 를 설정할 수 있습니다. > `\"noEventsContentInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`text`|`string`|기본 표시 텍스트| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { noEventsContent: function(noEventsContentInfo) { console.log(noEventsContentInfo.text); console.log(noEventsContentInfo.view); return \"- 일정이 없습니다 -\"; }, initialView: \"listMonth\" }; ```",
              "see": [
                {
                  "label": "noEventsClassNames props",
                  "url": "/docs/props/options/no-events-class-names"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/no-events-content.html"
          },
          {
            "cid": 53,
            "sid": "no-selection-event",
            "name": "no-selection-event",
            "label": "noSelectionEvent",
            "data": {
              "body": "> \"dayGridMonth\" 뷰(View)에서 사용자가 날짜를 마우스 Drag and Drop으로 선택 시 `\"placeholder\"` 임시 일정(Event) UI를 표시할지 여부를 설정합니다.(`dayGrid 뷰(View)에만 적용되는 옵션입니다.`) > **<mark>주의!</mark>** > **해당 옵션을 사용할 경우 `eventEditPopup` 옵션을 사용하지 않아도 이벤트 편집 UI 창이 표시되지 않습니다.** ### Type `boolean` ### Options |Value|Description| |-----|-----| |`true`|\"dayGridMonth\" 뷰(View) 에서 마우스 Drag and Drop 시 선택된 영역에 임시 일정을 표시하지 않습니다.| |`false`|마우스 Drag and Drop 시 선택된 영역에 임시 일정을 표시합니다. (`default`)| ### Example ```javascript options = { noSelectionEvent: true }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.7|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.7|기능 추가|"
            },
            "url": "docs/props/options/no-selection-event.html"
          },
          {
            "cid": 54,
            "sid": "progressive-event-rendering",
            "name": "progressive-event-rendering",
            "label": "progressiveEventRendering",
            "data": {
              "body": "> 이벤트 소스([`EventSource`](/docs/props/event-sources/event-sources))들의 렌더링 시점을 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|모든 이벤트 소스([`EventSource`](/docs/props/event-sources/event-sources))들의 수신이 완료된 후 렌더링합니다.(`default`)| |`true`|각 이벤트 소스([`EventSource`](/docs/props/event-sources/event-sources))가 수신될 때마다 렌더링합니다.| ### Example ```javascript options = { progressiveEventRendering: true }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/progressive-event-rendering.html"
          },
          {
            "cid": 55,
            "sid": "scroll-time",
            "name": "scroll-time",
            "label": "scrollTime",
            "data": {
              "body": "> \"timeGrid\" 뷰(View) 초기화 시 `스크롤바가 최초에 위치 할 시간슬롯(Time Slot)의 시간`을 설정합니다. > default값은 `\"00:00:00\"`으로 설정됩니다. ### Type `string` ### Example ```javascript options = { scrollTime: \"06:00:00\", //\"timeGrid\" 뷰(View) 초기화 시 스크롤바의 시간슬롯(Time Slot) 위치를 오전 6시로 설정 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/scroll-time.html"
          },
          {
            "cid": 56,
            "sid": "select-constraint",
            "name": "select-constraint",
            "label": "selectConstraint",
            "data": {
              "body": "> 사용자가 마우스 클릭, Dragging으로 선택할 수 있는 영역을 특정 범위로 제한합니다. > `\"selectConstraint\"` 옵션을 설정하지 않은 경우 기본 동작으로 모든 영역을 선택할 수 있습니다. > `\"businessHours\"`로 설정 시 [`businessHours`](/docs/props/options/business-hours) 옵션으로 설정한 업무시간(Business Hours)의 요일, 시간 범위 내에서만 영역 선택이 가능합니다. ### Type `string` | `object` ### Options |Value|Description| |-----|-----| |`\"businessHours\"`|[`businessHours`](/docs/props/options/business-hours) 옵션으로 설정한 업무시간으로 클릭/선택이 제한됩니다.| |`object`|사용자가 원하는 시간으로 클릭/선택을 제한할 수 있습니다.| ### Example ```javascript options = { selectConstraint: \"businessHours\", businessHours: true, selectable: true, }; ``` ```javascript options = { selectConstraint: { startTime: '10:00', endTime: '18:00', daysOfWeek: [ 1, 2, 3, 4 ] }, selectable: true, }; ```",
              "see": [
                {
                  "label": "businessHours props",
                  "url": "/docs/props/options/business-hours"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/select-constraint.html"
          },
          {
            "cid": 57,
            "sid": "select-mirror",
            "name": "select-mirror",
            "label": "selectMirror",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)의 시간슬롯(Time Slot)을 사용자가 마우스 Drag and Drop으로 선택 시 `\"placeholder\"` 일정(Event) UI를 표시할지 여부를 설정합니다. (`\"placeholder\"` 일정(Event) UI는 일정(Event) 정보가 없는 선택된 영역의 시간 범위만을 보여주는 UI입니다.) > [`selectable`](/docs/props/options/selectable) 옵션이 `true`로 설정 되어야 확인 가능합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|\"timeGrid\" 뷰(View) 에서 마우스 Drag and Drop 시 선택된 영역을 시각적으로 표시하지 않습니다.(`default`)| |`true`|\"timeGrid\" 뷰(View) 에서 마우스 Drag and Drop 시 선택된 영역을 시각적으로 표시합니다.| ### Example ```javascript options = { selectMirror: true, selectable: true }; ```",
              "see": [
                {
                  "label": "selectable props",
                  "url": "/docs/props/options/selectable"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/select-mirror.html"
          },
          {
            "cid": 58,
            "sid": "selectable",
            "name": "selectable",
            "label": "selectable",
            "data": {
              "body": "> 사용자가 마우스 클릭, Dragging으로 월단위(dayGridMonth) 뷰(View)의 여러 날짜를 선택하거나 \"timeGrid\" 뷰(View)의 시간슬롯(Time Slot)을 선택할 수 있도록 할지 여부를 설정합니다. (시간슬롯(Time Slot)이란 \"timeGrid\" 뷰(View)에서 일정(Event)들을 표시하기 위한 축을 의미합니다.) ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|마우스를 통하여 달력 선택을 허용하지 않습니다.(`default`)| |`true`|마우스를 통하여 달력 선택을 허용합니다.| ### Example ```javascript options = { selectable: true }; ```",
              "see": [
                {
                  "label": "select props",
                  "url": "/docs/props/triggered/select"
                },
                {
                  "label": "unselect props",
                  "url": "/docs/props/triggered/unselect"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/selectable.html"
          },
          {
            "cid": 59,
            "sid": "show-non-current-dates",
            "name": "show-non-current-dates",
            "label": "showNonCurrentDates",
            "data": {
              "body": "> 월단위(dayGridMonth) 뷰(View) 보기에서 현재 표시하고 있는 월이 아닌 이전, 다음 월의 일자 & 일정(Event)을 표시할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|이전, 다음 월의 일자 & 일정(Event)을 표시하지 않습니다.| |`true`|이전, 다음 월의 일자 & 일정(Event)을 표시합니다.| ### Example ```javascript options = { showNonCurrentDates: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/show-non-current-dates.html"
          },
          {
            "cid": 60,
            "sid": "slot-duration",
            "name": "slot-duration",
            "label": "slotDuration",
            "data": {
              "body": "> 시간슬롯(Time Slot)의 빈도를 설정합니다. (시간슬롯(Time Slot)이란 \"timeGrid\" 뷰(View)에서 일정(Event)들을 표시하기 위한 축을 의미합니다.) > default값은 `{ minutes:30 }`으로 설정되며, 시간슬롯(Time Slot)의 빈도가 30분 간격으로 표시됩니다. ### Type `object` ### Example ```javascript options = { slotDuration: { hours: 1 //시간슬롯(Time Slot)의 빈도가 1시간 간격으로 표시 } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/slot-duration.html"
          },
          {
            "cid": 61,
            "sid": "slot-label-format",
            "name": "slot-label-format",
            "label": "slotLabelFormat",
            "data": {
              "body": "> 시간슬롯(Time Slot)에 표시되는 `시간 텍스트의 포맷`을 설정합니다.(시간슬롯(Time Slot)이란 \"timeGrid\" 뷰(View)에서 일정(Event)들을 표시하기 위한 축을 의미합니다.) > default값은 `\"hh:mm a\"`로 설정되며 \"06:00 PM\"(locale 설정에 따라 \"PM\"은 설정된 locale에 따라 달라질 수 있습니다.)처럼 표시됩니다. > [Luxon](https://github.com/moment/luxon/blob/master/docs/formatting.md)의 포맷 형식을 사용해야 합니다. ### Type `string` ### Example ```javascript options = { slotLabelFormat: \"HH:mm\" //\"23:00\"와 같이 24시간으로 표시 }; ```",
              "see": [
                {
                  "label": "Luxon formatting",
                  "url": "https://github.com/moment/luxon/blob/master/docs/formatting.md"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/slot-label-format.html"
          },
          {
            "cid": 62,
            "sid": "slot-label-interval",
            "name": "slot-label-interval",
            "label": "slotLabelInterval",
            "data": {
              "body": "> 시간슬롯(Time Slot)에 표시되는 `시간 텍스트의 빈도`를 설정합니다.(시간슬롯(Time Slot)이란 \"timeGrid\" 뷰(View)에서 일정(Event)들을 표시하기 위한 축을 의미합니다.) > `\"slotLabelInterval\"` 옵션을 설정하지 않으면 [`slotDuration`](/docs/props/options/slot-duration) 옵션으로 설정한 시간슬롯(Time Slot)의 빈도를 고려하여 시간 텍스트의 빈도가 자동으로 설정됩니다. ### Type `object` ### Example ```javascript options = { slotLabelInterval: { hours: 4 //\"slotDuration\"옵션으로 설정한 빈도로 시간슬롯(Time Slot)을 표시하되, 시간 텍스트의 빈도는 4시간마다 표시 } }; ```",
              "see": [
                {
                  "label": "slotDuration props",
                  "url": "/docs/props/options/slot-duration"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/slot-label-interval.html"
          },
          {
            "cid": 63,
            "sid": "slot-max-time",
            "name": "slot-max-time",
            "label": "slotMaxTime",
            "data": {
              "body": "> `시간슬롯(Time Slot)의 종료 시간`을 설정합니다. > default값은 `\"24:00:00\"`로 설정되며, 하루가 끝나는 시간(다음날 자정)을 의미합니다. ### Type `string` ### Example ```javascript options = { slotMaxTime: \"20:00:00\", // 시간슬롯이 20시에서 종료됨 }; ```",
              "see": [
                {
                  "label": "slotMinTime props",
                  "url": "/docs/props/options/slot-min-time "
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/slot-max-time.html"
          },
          {
            "cid": 64,
            "sid": "slot-min-time",
            "name": "slot-min-time",
            "label": "slotMinTime",
            "data": {
              "body": "> `시간슬롯(Time Slot)의 시작 시간`을 설정합니다. > default값은 `\"00:00:00\"`로 설정되며, 하루의 시작되는 시간(자정)을 의미합니다. ### Type `string` ### Example ```javascript options = { slotMinTime: \"05:00:00\", // 시간슬롯이 05시 부터 시작됨 }; ```",
              "see": [
                {
                  "label": "slotMaxTime props",
                  "url": "/docs/props/options/slot-max-time "
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/slot-min-time.html"
          },
          {
            "cid": 65,
            "sid": "snap-duration",
            "name": "snap-duration",
            "label": "snapDuration",
            "data": {
              "body": "> \"timeGrid\" 뷰(View)에서 마우스의 drag and drop으로 일정(Event) 이동 시 `시간슬롯(Time Slot)의 이동 단위`를 설정합니다. > default값은 [`slotDuration`](/docs/props/options/slot-duration) 옵션에 관계없이 `{ minutes:30 }`로 설정되며, 일정(Event)을 30분 단위(1, 2, 3, 5, 6, 10, 15, 30 단위로 설정 가능)로 이동시킬 수 있습니다. ### Type `object` ### Example ```javascript options = { snapDuration: { minutes: 10 }, //일정(Event)을 10분 단위로 이동시킬 수 있도록 설정 }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/snap-duration.html"
          },
          {
            "cid": 66,
            "sid": "start-param",
            "name": "start-param",
            "label": "startParam",
            "data": {
              "body": "> 일정(Event) 정보를 가져오는 Fetch 발생 시 가져올 시작 범위의 parameter key 이름을 지정한 값으로 변경합니다. > (Back-End에서 추출할 달력의 날짜 시작 범위의 parameter의 key 이름을 의미합니다.) > (GET 방식의 parameter로 전달되는 querystring의 `\"start\"` key 이름을 설정한 문자열로 변경합니다.) ### Type `string` ### Options |Value|Description| |-----|-----| |`start`|(`default`)| ### Example ```javascript options = { startParam: \"start_param\" }; ```",
              "see": [
                {
                  "label": "endParam props",
                  "url": "/docs/props/options/end-param"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/start-param.html"
          },
          {
            "cid": 67,
            "sid": "sticky-footer-scrollbar",
            "name": "sticky-footer-scrollbar",
            "label": "stickyFooterScrollbar",
            "data": {
              "body": "> \"timeline\", \"dayGrid\", \"timeGrid\" 뷰(View)에서 스크롤 하는 동안 수평 스크롤바를 브라우저 뷰포트 하단에 고정할지 여부를 설정합니다. > 보기에 가로 스크롤바 가 있고 ( dayMinWidth ) 설정이 활성화되어 있고 > 캘린더가 보기 내에 있지만 스크롤바가 화면의 접힌 부분 아래에 있을 때 > \"timeline\" 또는 \"daygrid\" 또는 \"timegrid\" 뷰가 있는 경우에 스크롤바를 하단으로 고정합니다. ### Type `boolean` | `string` ### Options |Value|Description| |-----|-----| |`false`|스크롤 하는 동안 달력 하단의 수평 스크롤바를 브라우저에 고정하지 않습니다.| |`true`|스크롤 하는 동안 달력 하단의 수평 스크롤바를 브라우저에 고정합니다.| |`\"auto\"`|[height](/docs/props/options/height) 옵션을 참고하여 달력의 높이가 높을 경우 `stickyFooterScrollbar` 옵션이 활성화 됩니다. (`default`)| ### Example ```javascript options = { stickyFooterScrollbar: false }; ```",
              "see": [
                {
                  "label": "height props",
                  "url": "/docs/props/options/height"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/sticky-footer-scrollbar.html"
          },
          {
            "cid": 68,
            "sid": "sticky-header-dates",
            "name": "sticky-header-dates",
            "label": "stickyHeaderDates",
            "data": {
              "body": "> 스크롤하는 동안 달력 상단의 날짜 헤더가 사라지지 않고 브라우저 뷰포트에 고정할지 여부를 설정합니다. ### Type `boolean` | `string` ### Options |Value|Description| |-----|-----| |`false`|스크롤 하는 동안 달력 상단의 날짜 헤더를 브라우저에 고정하지 않습니다.| |`true`|스크롤 하는 동안 달력 상단의 날짜 헤더를 브라우저에 고정합니다.| |`\"auto\"`|[height](/docs/props/options/height) 옵션을 참고하여 달력의 높이가 높을 경우 `stickyHeaderDates` 가 활성화 됩니다.(`default`)| ### Example ```javascript options = { stickyHeaderDates: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/sticky-header-dates.html"
          },
          {
            "cid": 69,
            "sid": "time-zone-param",
            "name": "time-zone-param",
            "label": "timeZoneParam",
            "data": {
              "body": "> 각 이벤트 소스(EventSource)의 일정(Event) 정보를 가져오는 Fetch 발생 시 가져올 범위 정보인 start, end와 함께 전달할 시간대(TimeZone) 정보 parameter key 이름을 지정한 값으로 변경합니다. > (Back-End에서 추출할 달력의 날짜 시간대(TimeZone) 정보의 parameter의 key 이름을 의미합니다.) > (GET 방식의 parameter로 전달되는 querystring의 `\"timeZone\"` key 이름을 설정한 문자열로 변경합니다.) > [`timeZone`](/docs/props/options/time-zone) 옵션 설정이 `\"local\"`인 경우에는 시간대(TimeZone) 정보를 parameter로 보내지 않기 때문에 `\"timeZoneParam\"` 옵션을 사용할 수 없습니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`timeZone`|(`default`)| ### Example ```javascript options = { timeZoneParam: \"timeZone_param\", timeZone: \"America/Chicago\" }; ```",
              "see": [
                {
                  "label": "timeZone props",
                  "url": "/docs/props/options/time-zone"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/time-zone-param.html"
          },
          {
            "cid": 70,
            "sid": "time-zone",
            "name": "time-zone",
            "label": "timeZone",
            "data": {
              "body": "> IBCaelendar의 기준이 될 현지시간대(TimeZone)를 설정합니다. > IE11에서는 `\"TimeZone\"` 옵션을 기본값('\"local\"')이 아닌 값으로 설정 시 반복 일정(Recurring Event) 기능을 사용할 수 없습니다. > 현지시간대(TimeZone)를 변경하면 다음과 같은 항목들이 영향을 받습니다. > 1. `일정(Event)의 날짜/시간 텍스트 표시 형식` > 2. `일정(Event)들의 위치` > -> 일정(Event)의 시작 요일/시간 축 > 3. `javascript Date 객체를 사용하는 IBCalendar의 모든 API에서 Date 객체를 파싱하는 방법` > -> EventApi 객체의 start/end, View 객체의 `activeStart`/`activeEnd`, 콜백(callback) 함수에 의해 노출된 `Date 객체 타입`의 parameter들 > 4. `일정(Event) 데이터 요청 시 url이나 function의 반환값으로 전달받은 일정(Event) 정보` > 5. `일정(Event) 데이터를 받았을 때 날짜/시간 정보들을 파싱하는 방법` > -> \"UTC 정보가 없는 <a href=\"https://en.wikipedia.org/wiki/ISO_8601#Week_dates\" target=\"_blank\">ISO8601</a> 문자열\"인 `표준시간대 정보가 없는 문자열`들만 해당됩니다. > -> \"2017-04-20T11:32:00+09:00\" → \"UTC 정보가 있는 <a href=\"https://en.wikipedia.org/wiki/ISO_8601#Week_dates\" target=\"_blank\">ISO8601</a> 문자열\"은 현지시간대(TimeZone)를 변경하여도 영향을 받지 않습니다. > -> \"2017-04-20T11:32:00\" → \"UTC 정보가 없는 <a href=\"https://en.wikipedia.org/wiki/ISO_8601#Week_dates\" target=\"_blank\">ISO8601</a> 문자열\"은 현지시간대(TimeZone)를 변경하면 날짜/시간 정보들의 파싱 결과가 달라집니다. ### Type `string` ### Options |Value|Description| |-----|-----| |`\"local\"`|PC에 설정된 현지 시간대| |`\"UTC\"`|표준시간대 | |`시간대`|명명된 시간대(Named Time Zones)| ### Example > 1. `\"local\"` > -> OS에 설정된 현지시간을 현지시간대(TimeZone)로 설정합니다. > -> 일정(Event)들의 날짜/시간 정보가 \"UTC 정보가 포함된 <a href=\"https://en.wikipedia.org/wiki/ISO_8601#Week_dates\" target=\"_blank\">ISO8601</a> 문자열\"이거나 \"millisecond 시간 문자열\"인 경우 날짜/시간 정보가 사용자의 `현지시간대로 변경하여 표시`합니다. > -> 일정(Event)들의 날짜/시간 정보가 \"UTC 정보가 없는 <a href=\"https://en.wikipedia.org/wiki/ISO_8601#Week_dates\" target=\"_blank\">ISO8601</a> 문자열\"인 경우 날짜/시간 정보를 `현지시간으로 판단하여 그대로 표시`합니다. > -> IBCaelendar의 API를 통해 사용하는 Date 객체의 `getMonth()`, `getHours()`, `toString()`과 같은 API는 `현지시간대로 변경된 값을 반환`합니다. ```javascript calendarData = [ { title:\"timeZoneCalendar-event1\", start: \"2020-06-10T12:30:00Z\", end: \"2020-06-10T13:30:00Z\", allDay: false }, //UTC 정보가 표준시간대(00:00)로 설정되었으므로 사용자의 현지시간대(+09:00)가 적용되어 21:30으로 표시합니다. { title:\"timeZoneCalendar-event2\", start: \"2020-06-10T12:30:00+09:00\", end: \"2020-06-10T13:30:00+09:00\", allDay: false }, //UTC 정보가 포함되어 있으므로 날짜와 시간이 그대로 표시합니다. { title:\"timeZoneCalendar-event3\", start: \"2020-06-10T12:30:00\", end: \"2020-06-10T13:30:00\", allDay: false } //UTC 정보가 포함되어 있지 않으므로 현지시간으로 판단하여 그대로 표시합니다. ]; options = { timeZone: \"local\", eventSources: [ { id: \"devCalendar\", events: calendarData } ] }; ``` > 2. `\"UTC\"` > -> 현지시간대(TimeZone)는 사용자의 브라우저마다 다를 수 있지만, 표준시간대(00:00)는 모든 브라우저에서 동일하며 서머타임(summer time)제도도 적용되지 않습니다. 표준시간대(00:00)는 다른 현지시간대(TimeZone)들을 상대적으로 정의하기 위한 기준이 됩니다. > -> 일정(Event)들의 날짜/시간 정보가 \"UTC 정보가 포함된 <a href=\"https://en.wikipedia.org/wiki/ISO_8601#Week_dates\" target=\"_blank\">ISO8601</a> 문자열\"이거나 \"millisecond 시간 문자열\"인 경우 날짜/시간 정보가 `표준시간대(00:00)로 변경하여 표시`합니다. > -> 일정(Event)들의 날짜/시간 정보가 \"UTC 정보가 없는 <a href=\"https://en.wikipedia.org/wiki/ISO_8601#Week_dates\" target=\"_blank\">ISO8601</a> 문자열\"인 경우 날짜/시간 정보를 `표준시간대(00:00)로 판단하여 그대로 표시`합니다. > -> IBCaelendar의 API를 통해 사용하는 Date 객체의 `getUTCMonth()`, `getUTCHours()`, `toUTCString()`과 같은 API는 `표준시간대(00:00)로 변경된 값을 반환`합니다. > -> `\"timeZone\"` 옵션을 `\"UTC\"`로 설정하면 사용자의 현지시간대(TimeZone)와 상관없이 모든 일정(Event)들이 브라우저에서 일관성있게 표시됩니다. 하지만 표준시간대(00:00)를 활용하여 다른 현지시간대처럼 보여지게 하려면 `\"timeZone\"` 옵션을 `\"UTC\"`로 설정하는 대신 `\"명명된 시간대(Named Time Zones)\"`로 설정하는 것이 더 좋습니다. ```javascript calendarData = [ { title:\"timeZoneCalendar-event1\", start: \"2020-06-10T12:30:00Z\", end: \"2020-06-10T13:30:00Z\", allDay: false }, //UTC 정보가 표준시간대(00:00)로 설정되었으므로 사용자의 현지시간대(+09:00)가 적용되어 21:30으로 표시합니다. { title:\"timeZoneCalendar-event2\", start: \"2020-06-10T12:30:00+09:00\", end: \"2020-06-10T13:30:00+09:00\", allDay: false }, //UTC 정보가 포함되어 있으므로 날짜와 시간이 그대로 표시합니다. { title:\"timeZoneCalendar-event3\", start: \"2020-06-10T12:30:00\", end: \"2020-06-10T13:30:00\", allDay: false } //UTC 정보가 포함되어 있지 않으므로 현지시간으로 판단하여 그대로 표시합니다. ]; options = { timeZone: \"UTC\", eventSources: [ { id: \"devCalendar\", events: calendarData } ] }; ``` > 3. `\"명명된 시간대(Named Time Zones)\"` > -> `명명된 시간대(Named Time Zones)`는 `\"America/New_York\"` or `\"Asia/Seoul\"`같은 문자열로 지정된 특정 지역입니다. UTC 표준시간대(00:00)와 같이 모호성이 없기 때문에 모든 브라우저에서 일관되게 일정(Event)들을 표시할 수 있습니다. > -> 사용할 수 있는 `명명된 시간대(Named Time Zones)` 목록은 ([이곳](/docs/appx/named-time-zones))에서 확인할 수 있습니다. ```javascript calendarData = [ { title:\"timeZoneCalendar-event1\", start: \"2020-06-10T12:30:00Z\", end: \"2020-06-10T13:30:00Z\", allDay: false }, //UTC 정보가 표준시간대(00:00)로 설정되었으므로 사용자의 현지시간대(+09:00)가 적용되어 21:30으로 표시합니다. { title:\"timeZoneCalendar-event2\", start: \"2020-06-10T12:30:00+09:00\", end: \"2020-06-10T13:30:00+09:00\", allDay: false }, //UTC 정보가 포함되어 있으므로 날짜와 시간이 그대로 표시합니다. { title:\"timeZoneCalendar-event3\", start: \"2020-06-10T12:30:00\", end: \"2020-06-10T13:30:00\", allDay: false } //UTC 정보가 포함되어 있지 않으므로 현지시간으로 판단하여 그대로 표시합니다. ]; options = { timeZone: \"Europe/Moscow\", eventSources: [ { id: \"devCalendar\", events: calendarData } ] }; ```",
              "see": [
                {
                  "label": "NamedTimeZones appendix",
                  "url": "/docs/appx/named-time-zones"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/time-zone.html"
          },
          {
            "cid": 71,
            "sid": "title-format",
            "name": "title-format",
            "label": "titleFormat",
            "data": {
              "body": "> 달력 상단(header)/하단(footer) 툴바(Toolbar) 영역에 표시할 타이틀 텍스트의 날짜 포맷을 설정합니다. > [Luxon](https://github.com/moment/luxon/blob/master/docs/formatting.md)의 포맷 형식을 사용해야 합니다. ### Type `object` ### Options > 각 뷰(view)별 기본값은 아래와 같이 설정되어 있습니다. |view|Description| |-----|-----| |`month view`|{ year: 'numeric', month: 'long' }| |`week views`|{ year: 'numeric', month: 'short', day: 'numeric' }| |`day views`|{ year: 'numeric', month: 'long', day: 'numeric' }| ### Example ```javascript options = { titleFormat: { year: 'numeric', month: 'long', day: 'numeric } }; ``` > [views](/docs/props/options/views) 옵션을 이용하여 지정한 뷰(View)별로 `\"titleFormat\"` 옵션을 설정할 수 있습니다. ```javascript options = { views: { timeGridWeek: { titleFormat: \"LLLL L, - LLLL L, yyyy\" } } }; ```",
              "see": [
                {
                  "label": "views props",
                  "url": "/docs/props/options/views"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/title-format.html"
          },
          {
            "cid": 72,
            "sid": "valid-range",
            "name": "valid-range",
            "label": "validRange",
            "data": {
              "body": "> 사용자가 탐색할 수 있는 날짜의 유효 범위를 명시적으로 설정합니다. > 유효 범위를 벗어난 날짜는 disalbed 표시되며, 사용자는 이 영역으로 일정(Event)을 마우스로 이동시키거나 크기를 조정할 수 없습니다. > 달력 상단(header)/하단(footer) 툴바(Toolbar) 영역에 표시된 이전/다음 버튼들은 유효 범위를 벗어난 날짜로 이동하지 못하도록 disabled로 설정됩니다. ### Type `object` ### Options |Attribute|DataType|Description| |------|------|------------------| |`\"start\"`|string|유효 범위의 시작 날짜| |`\"end\"`|string|유효 범위의 끝 날짜| ### Example ```javascript options = { validRange: { start: \"2020-06-01\", end: \"2020-06-31\" } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/valid-range.html"
          },
          {
            "cid": 73,
            "sid": "views",
            "name": "views",
            "label": "views",
            "data": {
              "body": "> 지정한 뷰(View)에만 옵션을 적용할 수 있습니다. > 뷰(View)를 지정 또는 뷰(View) 타입 별로 옵션을 적용 할 수 있습니다. ### Type `object` ### Example > 지정한 뷰(View)의 옵션 설정 시 ```javascript options = { views: { dayGridMonth: { //viewId(뷰(View)의 이름) // \"titleFormat\" 속성을 적용 titleFormat: { year: \"numeric\", month: \"2-digit\", day: \"2-digit\" } } } }; ``` > 뷰(View) 타입 별 옵션 설정 시 ```javascript options = { views: { dayGrid: { //\"dayGridMonth\", \"dayGridWeek\", \"dayGridDay\" 뷰(View)들의 옵션 설정 titleFormat: { year: \"numeric\", month: \"2-digit\", day: \"2-digit\" } }, timeGrid: { //\"timeGridWeek\", \"timeGridDay\" 뷰(View)들의 옵션 설정 titleFormat: \"LLLL L, - LLLL L, yyyy\" }, week: { //\"dayGridWeek\", \"timeGridWeek\" 뷰(View)들의 옵션 설정 titleFormat: { year: \"numeric\", month: \"short\", day: \"numeric\" } }, day: { //\"dayGridDay\", \"timeGridDay\" 뷰(View)들의 옵션 설정 titleFormat: { year: \"numeric\", month: \"long\", day: \"2-digit\" } } } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/views.html"
          },
          {
            "cid": 74,
            "sid": "week-number-calculation",
            "name": "week-number-calculation",
            "label": "weekNumberCalculation",
            "data": {
              "body": "> [`weekNumbers`](/docs/props/options/week-numbers) 옵션으로 설정하는 주번호(WeekNumber)를 계산하는 방법을 설정합니다. > \"Date\" 타입 변수를 parameter로 갖고 주번호(WeekNumber)를 number타입으로 반환하는 콜백(callback) 함수로도 설정할 수 있습니다. ### Type `string` | `function` ### Options |Value|Description| |-----|-----| |`\"local\"`|달력에 설정된 locale에 따라 주번호(WeekNumber)를 계산합니다.(`default`)| |`\"ISO\"`|[`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601#Week_dates)국제 표준을 기준으로 주번호(WeekNumber)를 계산합니다. [`firstDay`](/docs/props/options/first-day)의 default값이 1로 계산됩니다.| |`콜백(callback)`|`weekNumber` 계산을 위한 사용자 정의 콜백(callback) 함수. (return 값은 반드시 number 타입이어야 합니다.)| ### Example ```javascript options = { weekNumberCalculation: function(date){//parameter는 반드시 Date 타입이어야 함 return 1;//반드시 number를 반환해야 함 }, weekNumbers: true }; ```",
              "see": [
                {
                  "label": "weekNumbers props",
                  "url": "/docs/props/options/week-numbers"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/week-number-calculation.html"
          },
          {
            "cid": 75,
            "sid": "week-number-class-names",
            "name": "week-number-class-names",
            "label": "weekNumberClassNames",
            "data": {
              "body": "> 주번호(WeekNumber)의 요소에 클래스 이름을 추가합니다. > 배열을 통하여 여러개의 className 을 한번에 추가할 수 도 있습니다. ### Type `array` | `string` ### Example ```javascript options = { weekNumberClassNames: \"weeknumber-class\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/week-number-class-names.html"
          },
          {
            "cid": 76,
            "sid": "week-number-content",
            "name": "week-number-content",
            "label": "weekNumberContent",
            "data": {
              "body": "> 주번호(WeekNumber)의 요소에 표시할 텍스트를 설정합니다. > innerHTML로 삽입할 HTML 문자열을 { html: ' ' } 형태로 설정할 수 있습니다. > DOM node 형식으로 다루고자 할 경우, { domNodes: arrayOfDomNodes } 형태로 설정하면 사용할 수 있습니다. ### Type `object` | `function` ### Example ```javascript options = { weekNumberContent: { html: '<i>주번호<i>' } }; ``` > `\"weekNumberContent \"` 옵션으로 콜백(callback) 함수를 정의할 수 있습니다. > 콜백(callback) 함수 정의 시 `\"weekNumberContentInfo\"` 객체를 parameter로 사용할 수 있으며, > return 을 통하여 주번호(WeekNumber) 영역에 표시할 텍스트 또는 HTML 문자열, DOM node 를 설정할 수 있습니다. |parameter|DataType|설명| |------|------|------------------| |`num`|`number`|주번호| |`text`|`string`|기본 표시 텍스트| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { weekNumberContent: function (weekNumberContentInfo) { console.log(weekNumberContentInfo.num + \"주차\"); console.log(weekNumberContentInfo.text); console.log(weekNumberContentInfo.view); return { html: '<i>주번호<i>' } }, weekNumbers: true }; ```",
              "see": [
                {
                  "label": "weekNumbers props",
                  "url": "/docs/props/options/week-numbers"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/week-number-content.html"
          },
          {
            "cid": 77,
            "sid": "week-numbers",
            "name": "week-numbers",
            "label": "weekNumbers",
            "data": {
              "body": "> 달력에 주번호(WeekNumber)를 표시할지 여부를 설정합니다. ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|주번호(WeekNumber)를 표시하지 않습니다.(`default`)| |`true`|주번호(WeekNumber)를 표시합니다.| ### Example ```javascript options = { weekNumbers: \"true\" }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/week-numbers.html"
          },
          {
            "cid": 78,
            "sid": "weekends",
            "name": "weekends",
            "label": "weekends",
            "data": {
              "body": "> 주말 표시 여부를 설정합니다.(토요일, 일요일은 표시하고 싶지 않을 때 사용합니다.) ### Type `boolean` ### Options |Value|Description| |-----|-----| |`false`|달력에 주말을 표시하지 않습니다.| |`true`|달력에 주말을 표시합니다. (`default`)| ### Example ```javascript options = { weekends: false }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/options/weekends.html"
          }
        ]
      },
      {
        "gid": 2,
        "name": "props-event-sources",
        "label": "EventSources",
        "children": [
          {
            "cid": 79,
            "sid": "event-add",
            "name": "event-add",
            "label": "eventAdd",
            "data": {
              "body": "> 사용자가 새로운 `일정(Event)을 추가 시 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"eventAddInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"eventAddInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`events`|`array`|새로 추가한 일정(Event) EventApi 객체 정보 배열| |`eventInputs`|`array`|EventApi 객체의 정보들을 파싱한 eventInput 배열(서버에 데이터 저장시 사용)| ```javascript options = { eventSources: [ { id: \"eventSource1\", eventAdd: function(eventAddInfo) { console.log(\"eventInputs 배열 :\", eventAddInfo.eventInputs); $.ajax( { \"url\": \"https://URL\" \"method\": \"POST\", \"async\": false, \"contentType\": \"application/json\", \"dataType\": \"json\", \"data\": JSON.stringify({ events: eventAddInfo.eventInputs, }), \"success\": function (data, status, xhr) { }, \"error\": function (xhr, status, errorThrown) { console.log(status); } } ); } events: function(info, success, failure) { $.ajax( { \"url\": \"https://URL\" \"method\": \"GET\", \"async\": false, \"dataType\": \"json\", \"data\": { start: IBCalendar.DateTime.fromJSDate(info.start).toISO(), end: IBCalendar.DateTime.fromJSDate(info.end).toISO() }, success: function (data, status, xhr) { success(data); }, error: function (xhr, status, errorThrown) { failure(status); } } ); } ], ] }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/event-sources/event-add.html"
          },
          {
            "cid": 80,
            "sid": "event-change",
            "name": "event-change",
            "label": "eventChange",
            "data": {
              "body": "> 사용자가 `일정(Event)을 수정 시 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"eventChangeInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"eventChangeInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`events`|`array`|수정한 일정(Event) EventApi 객체 정보 배열| |`eventInputs`|`array`|EventApi 객체의 정보들을 파싱한 eventInput 배열(서버에 데이터 저장시 사용)| ```javascript options = { eventSources: [ { id: \"eventSource1\", eventChange: function(eventChangeInfo) { console.log(\"eventInputs 배열 :\", eventChangeInfo.eventInputs); $.ajax( { \"url\": \"https://URL\" \"method\": \"PUT\", \"async\": false, \"contentType\": \"application/json\", \"dataType\": \"json\", \"data\": JSON.stringify({ events: eventChangeInfo.eventInputs, }), \"success\": function (data, status, xhr) { }, \"error\": function (xhr, status, errorThrown) { console.log(status); } } ); } events: function(info, success, failure) { $.ajax( { \"url\": \"https://URL\" \"method\": \"GET\", \"async\": false, \"dataType\": \"json\", \"data\": { start: IBCalendar.DateTime.fromJSDate(info.start).toISO(), end: IBCalendar.DateTime.fromJSDate(info.end).toISO() }, \"success\": function (data, status, xhr) { success(data); }, \"error\": function (xhr, status, errorThrown) { failure(status); } } ); } ], ] }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/event-sources/event-change.html"
          },
          {
            "cid": 81,
            "sid": "event-remove",
            "name": "event-remove",
            "label": "eventRemove",
            "data": {
              "body": "> 사용자가 `일정(Event)을 삭제 시 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"eventRemoveInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"eventRemoveInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`events`|`array`|삭제한 일정(Event) EventApi 객체 정보 배열| |`eventInputs`|`array`|EventApi 객체의 정보들을 파싱한 eventInput 배열(서버에 데이터 저장시 사용)| ```javascript options = { eventSources: [ { id: \"eventSource1\", eventRemove: function(eventRemoveInfo) { console.log(\"eventInputs 배열 :\", eventRemoveInfo.eventInputs); $.ajax( { \"url\": \"https://URL\" \"method\": \"DELETE\", \"async\": false, \"contentType\": \"application/json\", \"dataType\": \"json\", \"data\": JSON.stringify({ events: eventRemoveInfo.eventInputs, }), \"success\": function (data, status, xhr) { }, \"error\": function (xhr, status, errorThrown) { console.log(status); } } ); } events: function(info, success, failure) { $.ajax( { \"url\": \"https://URL\" \"method\": \"GET\", \"async\": false, \"dataType\": \"json\", \"data\": { start: IBCalendar.DateTime.fromJSDate(info.start).toISO(), end: IBCalendar.DateTime.fromJSDate(info.end).toISO() }, \"success\": function (data, status, xhr) { success(data); }, \"error\": function (xhr, status, errorThrown) { failure(status); } } ); } ], ] }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/event-sources/event-remove.html"
          },
          {
            "cid": 82,
            "sid": "event-sources",
            "name": "event-sources",
            "label": "eventSources",
            "data": {
              "body": "> 달력 UI에 표시할 일정(Event)들의 집합인 `이벤트 소스(EventSource)`들을 설정합니다. ### Type `array` ### Example > IBCalendar는 달력 UI에 표시할 이벤트 소스(EventSource)의 일정(Event)들의 정보를 아래와 같은 방법으로 설정할 수 있습니다. > 1. JSON Array ```javascript options = { eventSources: [ { id: \"eventSource1\", events: [ { id: \"eventSource1-event1\", title: \"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true }, { id: \"eventSource1-event2\", title: \"event2\", start: \"2020-06-05\", end: \"2020-06-07\", allDay: true }, . . . ], }, { id: \"eventSource2\", events: [ { id: \"eventSource2-event3\", title: \"event3\", start: \"2020-06-09T12:30:00\", end: \"2020-06-09T13:30:00\", allDay: false }, . . . ] } }; ``` > 2. Function ```javascript options = { eventSources: [ { id: \"eventSource1\", events: function(info, success, failure) { $.ajax( { \"url\": \"https://URL\" \"method\": \"GET\", \"async\": false, \"dataType\": \"json\", \"data\": { start: IBCalendar.DateTime.fromJSDate(info.start).toISO(), end: IBCalendar.DateTime.fromJSDate(info.end).toISO() }, success: function (data, status, xhr) { success(data); }, error: function (xhr, status, errorThrown) { failure(status); } } ); } } ] }; ``` **<mark>주의</mark> Ajax 호출시 비동기 문제로 인해 반드시 \"async\": false 해주어야 합니다.** ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/event-sources/event-sources.html"
          },
          {
            "cid": 83,
            "sid": "events",
            "name": "events",
            "label": "events",
            "data": {
              "body": "> 달력 UI에 일정(Event)을 조회하여 표시하는 방법입니다. ### Type `array` | `function` ### Example > 1. JSON Array ```javascript options = { eventSources: [ { id: \"eventSource1\", events: [ { id: \"eventSource1-event1\", title: \"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true }, { id: \"eventSource1-event2\", title: \"event2\", start: \"2020-06-05\", end: \"2020-06-07\", allDay: true }, . . . ], }, { id: \"eventSource2\", events: [ { id: \"eventSource2-event3\", title: \"event3\", start: \"2020-06-09T12:30:00\", end: \"2020-06-09T13:30:00\", allDay: false }, . . . ] } }; ``` > 2. Function ```javascript options = { eventSources: [ { id: \"eventSource1\", events: function(info, success, failure) { $.ajax( { \"url\": \"https://URL\" \"method\": \"GET\", \"async\": false, \"dataType\": \"json\", \"data\": { start: IBCalendar.DateTime.fromJSDate(info.start).toISO(), end: IBCalendar.DateTime.fromJSDate(info.end).toISO() }, success: function (data, status, xhr) { success(data); // 해당 함수에 일정 정보를 인자로 호출 시켜주어야 달력에 렌더링 됩니다. }, error: function (xhr, status, errorThrown) { failure(status); } } ); } } ] }; ``` **<mark>주의</mark> Ajax 호출시 비동기 문제로 인해 반드시 \"async\": false 해주어야 합니다.** ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/event-sources/events.html"
          },
          {
            "cid": 84,
            "sid": "id",
            "name": "id",
            "label": "id",
            "data": {
              "body": "> `eventSource`의 고유한 ID를 설정합니다. ### Type `string` ### Example ```javascript options = { eventSources: [ { id: \"eventSource1\", events: [ { id: \"eventSource1-event1\", title: \"event1\", start: \"2020-06-01\", end: \"2020-06-02\", allDay: true }, { id: \"eventSource1-event2\", title: \"event2\", start: \"2020-06-05\", end: \"2020-06-07\", allDay: true }, . . . ], } ] }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/event-sources/id.html"
          }
        ]
      },
      {
        "gid": 3,
        "name": "props-triggered",
        "label": "Triggered",
        "children": [
          {
            "cid": 85,
            "sid": "date-click",
            "name": "date-click",
            "label": "dateClick",
            "data": {
              "body": "> `사용자가 날짜 또는 시간을 클릭하면 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"dateClickInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"dateClickInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter |DataType|설명| |------|------|------------------| |`date`|`Date`|클릭한 날짜/시간| |`dateStr`|`string`|클릭한 날짜/시간의 [`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601#Week_dates) 문자열| |`allDay`|`boolean`|\"timeGrid\" 뷰(View)의 종일 일정(allDay Event)을 표시하는 영역을 클릭하였는지 여부| |`dayEl`|`HTMLElement`|클릭한 날짜/시간 영역의 HTML Element| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { dateClick: function(dateClickInfo) { console.log(dateClickInfo.view); //현재 뷰(View) 객체 } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/date-click.html"
          },
          {
            "cid": 86,
            "sid": "dates-set",
            "name": "dates-set",
            "label": "datesSet",
            "data": {
              "body": "> `뷰(View)의 날짜를 표시하는 UI 영역이 렌더링된 후 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > 초기 뷰(View) 렌더링 시, 뷰(View) 전환 시 발생합니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"datesSetInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"datesSetInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`start`|`Date`|새로 전환된 뷰(View)의 표시된 시작 날짜 javascript Date 객체| |`end`|`Date`|새로 전환된 뷰(View)의 표시된 종료 날짜 javascript Date 객체| |`startStr`|`string`|새로 전환된 뷰(View)의 표시된 시작 날짜 [`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601#Week_dates) 문자열| |`endStr`|`string`|새로 전환된 뷰(View)의 표시된 종료 날짜 [`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601#Week_dates) 문자열| |`view`|`Object`|새로 전환된 뷰(View) 객체| |`timeZone`|`string`|현재 캘린더에 적용된 `timeZone`값| ```javascript options = { datesSet: function(info) { console.log(info.view); console.log(info.start); } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/dates-set.html"
          },
          {
            "cid": 87,
            "sid": "drop",
            "name": "drop",
            "label": "drop",
            "data": {
              "body": "> IBCalendar로 Drag가 가능하도록 설정한 HTML element나 다른 IBCalendar의 일정(Event)을 Dragging하여 IBCalendar에 Drop되었을 때 발생하는 콜백(callback) 함수를 정의할 수 있습니다. > [`eventReceive`](/docs/props/triggered/event-receive) 옵션으로 설정한 콜백(callback) 함수와 함께 발생합니다. > (Drag된 일정(Event)의 정보가 필요한 경우 [`eventReceive`](/docs/props/triggered/event-receive) 옵션으로 콜백(callback) 함수를 정의해야 합니다.) ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > `\"info\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter |DataType|설명| |------|------|------------------| |`allDay`|`boolean`|종일 일정(allDay Event)에 Drag되었는지 여부| |`date`|`Date`|Drag가 가능하도록 설정한 HTML element나 다른 IBCalendar의 일정(Event)이 Drop된 날짜| |`dateStr`|`string`|Drag가 가능하도록 설정한 HTML element나 다른 IBCalendar의 일정(Event)이 Drop된 날짜의 ISO8601 문자열| |`draggedEl`|`HTMLElement`|Drag되고 있었던 HTML element| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|Drop이 발생한 IBCalendar의 현재 뷰(View) 객체| ```javascript options = { drop: function(info) { console.log(\"IBCalendar에 Drop되어 새로 추가된 일정(Event)이 drop된 날짜 정보: \" + info.dateStr); }, droppable: true, editable: true }; ```",
              "see": [
                {
                  "label": "eventReceive props",
                  "url": "/docs/props/triggered/event-receive"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/drop.html"
          },
          {
            "cid": 88,
            "sid": "event-allow",
            "name": "event-allow",
            "label": "eventAllow",
            "data": {
              "body": "> 마우스로 Dragging, Resizing 중인 일정(Event)이 drop될 수 있는 영역에 위치할 때 호출되는 콜백(callback) 함수를 정의합니다. > [`eventOverlap`](/docs/props/options/event-overlap), [`eventConstraint`](/docs/props/options/event-constraint) 옵션으로 설정한 유효 범위 내에서 마우스로 Dragging, Resizing 중인 일정(Event)이 drop될 수 있다고 판단될 때마다 `\"eventAllow\"` 콜백(callback) 함수 호출이 발생합니다. ### Type `function` ### Example > drop될 수 있는 위치 정보인 `dropInfo` 객체와 마우스로 Dragging, Resizing 중인 일정(Event) 정보 객체인 `draggedEvent`를 parameter로 사용할 수 있습니다. > `dropInfo` 객체에는 다음과 같은 속성을 제공합니다. |parameter|DataType|설명| |------|---------|------------------| |`allDay`|`boolean`|마우스로 Dragging, Resizing중인 일정(Event)이 종일 일정(allDay Event)으로 drop될 수 있는지 여부| |`end`|`Date`|마우스로 Dragging, Resizing중인 일정(Event)이 drop되었을 때의 종료시간 정보| |`endStr`|`string`|`end`의 [`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601) 문자열| |`start`|`Date`|마우스로 Dragging, Resizing중인 일정(Event)이 drop되었을 때의 시작시간 정보| |`startStr`|`string`|`start`의 [`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601) 문자열| ```javascript options = { eventAllow: function (dropInfo, draggedEvent) { console.log(\"eventAllow 콜백(callback) 발생!!\"); return draggedEvent.id !== \"event1\"; //id가 \"event1\"인 일정(Event)은 마우스로 Dragging, Resizing으로 시작(start)과 끝(end) 날짜/시간 정보를 변경할 수 없도록 제한 }, editable: true }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-allow.html"
          },
          {
            "cid": 89,
            "sid": "event-click",
            "name": "event-click",
            "label": "eventClick",
            "data": {
              "body": "> 사용자가 `일정(Event)을 클릭 시 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"eventClickInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"eventClickInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`event`|`EventApi`|클릭한 일정(Event) 정보| |`el`|`HTMLElement`|클릭한 일정(Event)을 표시하는 UI의 HTML Element| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| |`showEventPopup()`|`Function`|클릭한 일정(Event)의 정보를 시각적으로 보여주는 Popup 창 호출| ```javascript options = { eventClick: function(eventClickInfo) { eventClickInfo.showEventPopup(); console.log(\"Event: \" + eventClickInfo.event.title); console.log(\"Coordinates: \" + eventClickInfo.jsEvent.pageX + \",\" + eventClickInfo.jsEvent.pageY); console.log(\"View: \" + eventClickInfo.view.type); } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-click.html"
          },
          {
            "cid": 90,
            "sid": "event-data-transform",
            "name": "event-data-transform",
            "label": "eventDataTransform",
            "data": {
              "body": "> 일정(Event) 데이터를 IBCalendar를 위한 일정(Event) 정보 형태로 변환하기 위한 Hook 콜백(callback) 함수입니다. > 수신된 일정(Event) 데이터의 형태가 IBCalendar의 스펙과 다를 경우 `\"eventDataTransform\"` 옵션으로 콜백(callback) 함수를 정의하면 Back-End에서 완전한 형태의 데이터를 반환하지 않더라도 유연하게 IBCalendar가 허용하는 형태로 변환할 수 있습니다. > `\"eventDataTransform\"` 옵션으로 정의한 콜백(callback) 함수는 모든 일정(Event)당 1회씩 호출이 발생하며 [`addEvent`](/docs/funcs/calendar/add-event) API 호출 시에는 호출이 발생하지 않습니다. > `\"eventDataTransform\"` 옵션으로 정의한 콜백(callback) 함수는 수신된 일정(Event) 데이터를 의미하는 `\"eventData\"` parameter 객체를 사용할 수 있고 IBCalendar가 허용하는 형태의 일정(Event) 정보 객체를 반환해야 합니다. ### Type `function` ### Example ```javascript options = { eventDataTransform: function(eventData) { var mappingInfo = { \"TITLE\": \"title\", \"START_DATE\": \"start\", \"END_DATE\": \"end\", \"ALL_DAY\": \"allDay\" }; return IBCalendar._.mapKeys(eventData, function (value, key) { return IBCalendar._.has(mappingInfo, key) ? mappingInfo[key] : key; }); }, eventSources: [ { id: \"eventSource1\", events: [ { \"TITLE\": \"이벤트\", \"START_DATE\": \"2020-06-01\", \"END_DATE\": \"2020-06-05\", \"ALL_DAY\": true } ] } ] }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-data-transform.html"
          },
          {
            "cid": 91,
            "sid": "event-drag-start",
            "name": "event-drag-start",
            "label": "eventDragStart",
            "data": {
              "body": "> `일정(Event) Dragging이 시작되었을 때 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > [`editable`](/docs/props/options/editable) 옵션이 `true`인 경우에만 사용할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > `\"info\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter |DataType|설명| |------|------|------------------| |`event`|`EventApi`|Dragging이 시작된 일정(Event) 정보| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| |`el`|`HTMLElement`|Dragging이 시작된 일정(Event) UI의 HTML Element| ```javascript options = { eventDragStart: function(info) { console.log(\"Drag된 일정(Event)의 id: \" + info.event.id); }, editable: true }; ```",
              "see": [
                {
                  "label": "eventDragStop props",
                  "url": "/docs/props/options/event-drag-stop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-drag-start.html"
          },
          {
            "cid": 92,
            "sid": "event-drag-stop",
            "name": "event-drag-stop",
            "label": "eventDragStop",
            "data": {
              "body": "> `일정(Event) Dragging이 종료되었을 때 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > [`editable`](/docs/props/options/editable) 옵션이 `true`인 경우에만 사용할 수 있습니다. > `\"eventDragStop\"` 옵션으로 정의한 콜백(callback) 함수는 일정(Event)의 날짜/시간이 변경되었더라도 Dragging을 시작하기 이전의 날짜/시간 정보를 제공합니다. > ([`eventDrop`](/docs/props/triggered/event-drop) 옵션으로 콜백(callback) 함수를 정의하면 일정(Event) Dragging이 중지되었을 때 변경된 날짜/시간 정보를 제공합니다.) ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > `\"info\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter |DataType|설명| |------|------|------------------| |`event`|`EventApi`|Dragging이 종료된 일정(Event) 정보| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| |`el`|`HTMLElement`|Dragging이 종료된 일정(Event) UI의 HTML Element| ```javascript options = { eventDragStop: function(info) { console.log(\"Drag된 일정(Event)의 id: \" + info.event.id); }, editable: true }; ```",
              "see": [
                {
                  "label": "eventDragStart props",
                  "url": "/docs/props/triggered/event-drag-start"
                },
                {
                  "label": "eventDrop props",
                  "url": "/docs/props/triggered/event-drop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-drag-stop.html"
          },
          {
            "cid": 93,
            "sid": "event-drop",
            "name": "event-drop",
            "label": "eventDrop",
            "data": {
              "body": "> `일정(Event) Dragging이 중지되고 일정(Event)이 다른 날짜/시간으로 이동 되었을 때 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > [`editable`](/docs/props/options/editable) 옵션이 `true`인 경우에만 사용할 수 있습니다. > [`eventDragStop`](/docs/props/triggered/event-drag-stop) 옵션으로 정의한 콜백(callback) 함수 발생 이후에 발생합니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"eventDropInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"eventDropInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter |DataType|설명| |------|------|------------------| |`delta`|`Duration`|일정(Event)이 이동된 기간 정보| |`el`|`HTMLElement`|이동된 일정(Event) UI의 HTML Element| |`event`|`EventApi`|이동된 후의 일정(Event) 정보| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`oldEvent`|`EventApi`|이동되기 전의 일정(Event) 정보| |`revert()`|`Function`|Dragging이 시작되기 전의 일정(Event) 정보로 복구하는 함수| |`view`|`Object`|현재 뷰(View) 객체| |`relatedEvents`|`EventApi[]`|대상이 되는 일정(Event)과 관련된 일정(Event)들 (반복이벤트)| ```javascript options = { eventDrop: function(eventDropInfo) { console.log(\"이동 전 일정(Event)의 start: \" + eventDropInfo.oldEvent.start.toString()); console.log(\"이동 후 일정(Event)의 start: \" + eventDropInfo.event.start.toString()); eventDropInfo.revert(); //Dragging이 시작되기 전의 일정(Event) 정보로 복구 }, editable: true }; ```",
              "see": [
                {
                  "label": "eventDragStop props",
                  "url": "/docs/props/triggered/event-drag-stop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-drop.html"
          },
          {
            "cid": 94,
            "sid": "event-leave",
            "name": "event-leave",
            "label": "eventLeave",
            "data": {
              "body": "> 일정(Event)이 다른 IBCalendar에 Drop되었을 때 발생하는 콜백(callback) 함수를 정의할 수 있습니다. > [`editable`](/docs/props/options/editable) 옵션이 `true`인 경우에만 사용할 수 있습니다. > 일정(Event)이 Drop 되면, IBCalendar의 [`drop`](/docs/props/triggered/drop), [`eventReceive`](/docs/props/triggered/event-receive) 옵션으로 정의한 콜백(callback) 함수들이 발생한 후 `\"eventLeave\"` 옵션으로 정의한 콜백(callback) 함수가 발생합니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > `\"info\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`draggedEl`|`HTMLElement`|다른 IBCalendar에 Drop되어 삭제된 일정(Event) UI의 HTML element| |`event`|`EventApi`|다른 IBCalendar에 Drop되어 삭제된 일정(Event) 정보| |`view`|`Object`|IBCalendar의 현재 뷰(View)| |`relatedEvents`|`EventApi[]`|대상이 되는 일정(Event)과 관련된 일정(Event)들 (반복이벤트)| |`revert()`|`Function`|이전의 일정(Event) 정보로 복구하는 함수| ```javascript options = { eventLeave: function(info) { console.log(\"다른 IBCalendar에 Drop되어 삭제된 일정(Event)의 id: \" + info.event.id); }, droppable: true, editable: true }; ```",
              "see": [
                {
                  "label": "eventReceive props",
                  "url": "/docs/props/triggered/event-receive"
                },
                {
                  "label": "drop props",
                  "url": "/docs/props/triggered/drop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-leave.html"
          },
          {
            "cid": 95,
            "sid": "event-mouse-enter",
            "name": "event-mouse-enter",
            "label": "eventMouseEnter",
            "data": {
              "body": "> 사용자가 `일정(Event) UI로 마우스를 가져가면 발생하는 콜백(callback) 함수`를 정의할 수 있습니다. > `\"mouseenter\"` 마우스 이벤트와 유사합니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"mouseEnterInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"mouseEnterInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`event`|`EventApi`|이벤트가 발생한 일정(Event) 정보| |`el`|`HTMLElement`|이벤트가 발생한 일정(Event)을 표시하는 UI의 HTML Element| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { eventClick: function(mouseEnterInfo) { console.log(\"Event: \" + mouseEnterInfo.event.title); console.log(\"Coordinates: \" + mouseEnterInfo.jsEvent.pageX + \",\" + mouseEnterInfo.jsEvent.pageY); console.log(\"View: \" + mouseEnterInfo.view.type); } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-mouse-enter.html"
          },
          {
            "cid": 96,
            "sid": "event-mouse-leave",
            "name": "event-mouse-leave",
            "label": "eventMouseLeave",
            "data": {
              "body": "> 사용자가 `일정(Event) UI 위에 있던 마우스 커서를 다른 곳으로 이동시키면 발생하는 콜백(callback) 함수`를 정의할 수 있습니다. > `\"mouseleave\"` 마우스 이벤트와 유사합니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"mouseLeaveInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"mouseLeaveInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`event`|`EventApi`|이벤트가 발생한 일정(Event) 정보| |`el`|`HTMLElement`|이벤트가 발생한 일정(Event)을 표시하는 UI의 HTML Element| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { eventClick: function(mouseLeaveInfo) { console.log(\"Event: \" + mouseLeaveInfo.event.title); console.log(\"Coordinates: \" + mouseLeaveInfo.jsEvent.pageX + \",\" + mouseLeaveInfo.jsEvent.pageY); console.log(\"View: \" + mouseLeaveInfo.view.type); } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-mouse-leave.html"
          },
          {
            "cid": 97,
            "sid": "event-receive",
            "name": "event-receive",
            "label": "eventReceive",
            "data": {
              "body": "> IBCalendar로 Drag가 가능하도록 설정한 HTML element나 다른 IBCalendar의 일정(Event)을 IBCalendar에 Drop되었을 때 발생하는 콜백(callback) 함수를 정의할 수 있습니다. > [`drop`](/docs/props/triggered/event-receive) 옵션으로 설정한 콜백(callback) 함수와 함께 발생합니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > `\"info\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter |DataType|설명| |------|------|------------------| |`draggedEl`|`HTMLElement`|Drag되고 있었던 HTML element| |`event`|`EventApi`|Drag되어 새로 추가된 일정(Event) 정보| |`view`|`Object`|IBCalendar의 현재 뷰(View)| |`relatedEvents`|`EventApi[]`|대상이 되는 일정(Event)과 관련된 일정(Event)들 (반복이벤트)| |`revert`|`Function`|이전의 일정(Event) 정보로 복구하는 함수| ```javascript options = { eventReceive: function(info) { console.log(\"IBCalendar에 Drop되어 새로 추가된 일정(Event)의 id: \" + info.event.id); }, droppable: true, editable: true }; ```",
              "see": [
                {
                  "label": "drop props",
                  "url": "/docs/props/triggered/drop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-receive.html"
          },
          {
            "cid": 98,
            "sid": "event-resize-start",
            "name": "event-resize-start",
            "label": "eventResizeStart",
            "data": {
              "body": "> `마우스로 일정(Event)의 크기 조절을 시작할 때 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > [`editable`](/docs/props/options/editable) 옵션이 `true`인 경우에만 사용할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > `\"info\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`event`|`EventApi`|크기를 조절하는 일정(Event) 정보| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| |`el`|`HTMLElement`|크기를 조절하는 일정(Event) UI의 HTML Element| ```javascript options = { eventResizeStart: function(info) { console.log(\"크기를 조절하는 일정(Event)의 id: \" + info.event.id); } }; ```",
              "see": [
                {
                  "label": "eventResize props",
                  "url": "/docs/props/triggered/event-resize"
                },
                {
                  "label": "eventResizeStop props",
                  "url": "/docs/props/triggered/event-resize-stop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-resize-start.html"
          },
          {
            "cid": 99,
            "sid": "event-resize-stop",
            "name": "event-resize-stop",
            "label": "eventResizeStop",
            "data": {
              "body": "> `마우스로 일정(Event)의 크기를 조절한 이후에 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > [`editable`](/docs/props/options/editable) 옵션이 `true`인 경우에만 사용할 수 있습니다. > 일정(Event)의 날짜/시간 변경 여부와는 상관없이 발생합니다. > `\"eventResizeStop\"` 옵션으로 정의한 콜백(callback) 함수는 일정(Event)의 날짜/시간이 변경되었더라도 크기를 조절하기 이전의 날짜/시간 정보를 제공합니다. > [`eventResize`](/docs/props/triggered/event-resize) 옵션으로 콜백(callback) 함수를 정의하면 크기를 조절한 이후의 날짜/시간 정보를 제공합니다.) ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > `\"info\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`event`|`EventApi`|크기를 조절하기 이전의 일정(Event) 정보| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| |`el`|`HTMLElement`|크기를 조절하는 일정(Event) UI의 HTML Element| ```javascript options = { eventResizeStop: function(info) { console.log(\"크기를 조절하는 일정(Event)의 id: \" + info.event.id); } }; ```",
              "see": [
                {
                  "label": "eventResize props",
                  "url": "/docs/props/triggered/event-resize"
                },
                {
                  "label": "eventResizeStart props",
                  "url": "/docs/props/triggered/event-resize-start"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-resize-stop.html"
          },
          {
            "cid": 100,
            "sid": "event-resize",
            "name": "event-resize",
            "label": "eventResize",
            "data": {
              "body": "> `마우스로 일정(Event)의 크기를 변경한 후 일정(Event)의 기간이 변경된 후 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > [`editable`](/docs/props/options/editable) 옵션이 `true`인 경우에만 사용할 수 있습니다. > 일정(Event)의 날짜/시간 변경된 경우에만 발생합니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"eventResizeInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"eventResizeInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|------|------------------| |`el`|`HTMLElement`|크기가 변경된 일정(Event) UI의 HTML Element| |`endDelta`|`Duration`|일정(Event)의 크기가 변경된 기간 정보(`end` 기준)| |`event`|`EventApi`|크기가 변경된 후의 일정(Event) 정보| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`oldEvent`|`EventApi`|크기가 변경되기 이전의 일정(Event) 정보| |`revert`|`Function`|크기가 변경되기 이전의 일정(Event) 정보로 복구하는 함수| |`startDelta`|`Duration`|일정(Event)의 크기가 변경된 기간 정보(`start` 기준)| |`view`|`Object`|현재 뷰(View) 객체| |`relatedEvents`|`EventApi[]`|대상이 되는 일정(Event)과 관련된 일정(Event)들 (반복이벤트)| ```javascript options = { eventResize: function(eventResizeInfo) { console.log(\"크기가 변경되기 이전 일정(Event)의 end: \" + eventResizeInfo.oldEvent.end.toString()); console.log(\"크기가 변경된 후 일정(Event)의 end: \" + eventResizeInfo.event.end.toString()); } }; ```",
              "see": [
                {
                  "label": "eventResizeStart props",
                  "url": "/docs/props/triggered/event-resize-start"
                },
                {
                  "label": "eventResizeStop props",
                  "url": "/docs/props/triggered/event-resize-stop"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-resize.html"
          },
          {
            "cid": 101,
            "sid": "event-source-failure",
            "name": "event-source-failure",
            "label": "eventSourceFailure",
            "data": {
              "body": "> [`eventSources`](/docs/props/event-sources/event-sources) 옵션으로 설정한 이벤트 소스(EventSource)들 중 하나라도 Ajax 통신 실패 시 발생하는 콜백(callback) 함수를 정의합니다. > 콜백(callback) 함수 정의 시 `\"err\"` 객체를 parameter로 사용할 수 있습니다. ### Type `function` ### Example ```javascript options = { eventSourceFailure: function(err) { console.log(\"에러 메세지 : \" + err.message); } }; ```",
              "see": [
                {
                  "label": "eventSourceSuccess props",
                  "url": "/docs/props/triggered/event-source-success"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-source-failure.html"
          },
          {
            "cid": 102,
            "sid": "event-source-success",
            "name": "event-source-success",
            "label": "eventSourceSuccess",
            "data": {
              "body": "> 이벤트 소스(EventSource)의 일정(Event) 데이터들을 수신 후 IBCalendar를 위한 일정(Event) 정보 형태로 변환하기 위한 Hook 콜백(callback) 함수입니다. > 수신된 일정(Event) 데이터들의 형태가 IBCalendar의 스펙과 다를 경우 `\"eventSourceSuccess\"` 옵션으로 콜백(callback) 함수를 정의하면 Back-End에서 완전한 형태의 데이터를 반환하지 않더라도 유연하게 IBCalendar가 혀용하는 형태로 변환할 수 있습니다. > `\"eventSourceSuccess\"` 옵션으로 정의한 콜백(callback) 함수는 모든 이벤트 소스(EventSource)당 1회씩 호출이 발생합니다. > `\"eventSourceSuccess\"` 옵션으로 정의한 콜백(callback) 함수는 수신된 일정(Event) 데이터들을 의미하는 `\"data\"` parameter를 사용할 수 있고 IBCalendar가 혀용하는 형태의 일정(Event) 정보 객체들의 배열을 반환해야 합니다. ### Type `function` ### Example ```javascript options = { eventSourceSuccess: function(data, xhr) { console.log(data); return data; } }; ```",
              "see": [
                {
                  "label": "eventDataTransform props",
                  "url": "/docs/props/triggered/event-data-transform"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/event-source-success.html"
          },
          {
            "cid": 103,
            "sid": "loading",
            "name": "loading",
            "label": "loading",
            "data": {
              "body": "> `일정(Event) 정보를 가져오는 Fetch 시작/종료 시 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 Ajax 통신 중인지 여부를 boolean으로 확인할 수 있는 `\"isLoading\"`을 parameter로 사용할 수 있습니다. ```javascript options = { loading: function(isLoading) { console.log(isLoading ? \"Ajax 통신중입니다.\" : \"Ajax 통신이 종료되었습니다.\"); } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/loading.html"
          },
          {
            "cid": 104,
            "sid": "select-allow",
            "name": "select-allow",
            "label": "selectAllow",
            "data": {
              "body": "> 사용자가 마우스 클릭, Dragging으로 영역 선택 시 선택한 영역의 범위가 변경될 때만 발생하는 `콜백(callback) 함수를 정의`할 수 있습니다. > `return true` 시 선택상태가 됩니다.(false면 선택상태가 되지 않습니다) > `return true/false` 필수로 반환해야 합니다. ### Type `function` ### Example > 콜백(callback) 함수의 parameter로 선택한 영역의 시작 날짜로 설정된 `\"start\"` javascript Date객체, 선택한 영역의 종료 날짜로 설정된 `\"end\"` javascript Date객체를 사용할 수 있습니다. |parameter|DataType|설명| |------|------|------------------| |`start`|`javascript Date`|선택한 영역의 시작 날짜| |`end`|`javascript Date`|선택한 영역의 종료 날짜| ```javascript options = { selectAllow: function(selectInfo) { console.log(\"선택한 영역의 시작 날짜: \", selectInfo.start); console.log(\"선택한 영역의 종료 날짜: \", selectInfo.end); return true; }, selectable: true }; ```",
              "see": [
                {
                  "label": "selectable props",
                  "url": "/docs/props/options/selectable"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/select-allow.html"
          },
          {
            "cid": 105,
            "sid": "select",
            "name": "select",
            "label": "select",
            "data": {
              "body": "> 사용자가 마우스로 `날짜 또는 시간을 Drag and Drop으로 선택 시 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"selectionInfo\"` 객체를 parameter로 사용할 수 있습니다. > `\"selectionInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|---------|------------------| |`start`|`Date`|선택한 영역의 시작 날짜 정보| |`end`|`Date`|선택한 영역의 종료 날짜 정보| |`startStr`|`string`|`start`의 [`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601#Week_dates) 문자열, 종일 일정(allDay Event)인 경우에는 `\"2020-09-17\"`처럼 시간정보를 제외한 문자열| |`endStr`|`string`|`end`의 [`ISO8601`](https://en.wikipedia.org/wiki/ISO_8601#Week_dates) 문자열, 종일 일정(allDay Event)인 경우에는 `\"2020-09-17\"`처럼 시간정보를 제외한 문자열| |`allDay`|`boolean`|종일(allDay) 셀(Cell)이 선택되었는지 여부| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { select: function(selectionInfo) { console.log(\"선택한 영역의 start: \" + selectionInfo.startStr); console.log(\"선택한 영역의 end: \" + selectionInfo.endStr); }, selectable: true, }; ```",
              "see": [
                {
                  "label": "unselect props",
                  "url": "/docs/props/triggered/unselect"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/select.html"
          },
          {
            "cid": 106,
            "sid": "unselect",
            "name": "unselect",
            "label": "unselect",
            "data": {
              "body": "> `기존에 선택되어 있던 영역이 해제될 때 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. > 기존에 선택되어 있던 영역은 다음과 같은 이유로 해제될 수 있습니다. > 1. 사용자가 기존에 선택되어 있던 영역이 아닌 곳을 클릭하면 기존에 선택되어 있던 영역이 해제됩니다. > 2. 사용자가 마우스 Drag and Drop으로 새로운 영역을 선택 시 기존에 선택되어 있던 영역이 해제됩니다. > 3. 사용자가 이전,다음 버튼을 누르거나 새로운 뷰(View)로 전환 시 기존에 선택되어 있던 영역이 해제됩니다. > 4. [`unselect`](/docs/funcs/calendar/unselect) API 호출 시 기존에 선택되어 있던 영역이 해제됩니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"unselectInfo\"` 객체를 parameter로 사용할 수 있습니다. >`\"unselectInfo\"` parameter 객체는 다음과 같은 속성들을 포함하고 있습니다. |Parameter|DataType|설명| |------|---------|------------------| |`jsEvent`|`MouseEvent`|javascript 마우스 이벤트 객체| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { unselect: function(unselectInfo) { console.log(unselectInfo.jsEvent); //javascript 마우스 이벤트 객체 console.log(\"기존에 선택되어 있던 영역이 해제된 뷰: \" + unselectInfo.view.type); }, selectable: true }; ```",
              "see": [
                {
                  "label": "select props",
                  "url": "/docs/props/triggered/select"
                },
                {
                  "label": "unselect method",
                  "url": "/docs/funcs/calendar/unselect"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/unselect.html"
          },
          {
            "cid": 107,
            "sid": "window-resize",
            "name": "window-resize",
            "label": "windowResize",
            "data": {
              "body": "> 브라우저 창의 크기가 변경되었을 때 `달력 UI의 크기가 변경된 후 발생`하는 콜백(callback) 함수를 정의할 수 있습니다. ### Type `function` ### Example > 콜백(callback) 함수 정의 시 `\"info\"` 객체를 parameter로 사용할 수 있습니다. > 콜백(callback) 함수 정의 시 `this`는 해당 옵션이 사용된 달력 객체입니다. |Parameter|DataType|Description| |------|------|------------------| |`view`|`Object`|현재 뷰(View) 객체| ```javascript options = { windowResize: function(info) { console.log(this); console.log(info.view.type); } }; ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/props/triggered/window-resize.html"
          }
        ]
      }
    ]
  },
  {
    "gid": 4,
    "label": "Methods",
    "name": "funcs",
    "children": [
      {
        "cid": 108,
        "sid": "method",
        "name": "method",
        "label": "method 사용법 기초",
        "data": {
          "body": "> IBCalendar가 제공하는 메소드는 달력 객체에서 사용하는 방식과 > [getEventSourceById](/docs/funcs/calendar/get-event-source-by-id) 를 통하여 `eventSource` 객체를 가져와 `eventSource` 객체에서 제공하는 메소드를 사용하는 방식이 있습니다. > 메소드별 각 파라미터를 순서대로 설정해야 사용할 수 있습니다. ### 파라미터 설정 방법 ```javascript //addEvent 일정 추가 (추가할 일정(Event)의 정보, 일정이 소속될 eventSource의 ID) //각 파라미터를 순서대로 설정 IBCalendar.get(\"calendar1\").addEvent({ title: \"newEvent\", start: \"2023-05-25\", end: \"2023-05-28\", allDay: true, memo: \"event memo\", toolTip: \"newEvent\" }, \"eventSource1\"); // remove 특정 eventSource 삭제 IBCalendar.get(\"calendar1\").getEventSourceById(\"eventSource1\").remove(); ```",
          "see": [],
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가||core|1.6.0.0|`toolTip` 추가|"
        },
        "url": "docs/funcs/method.html"
      },
      {
        "gid": 1,
        "name": "funcs-calendar",
        "label": "Calendar",
        "children": [
          {
            "cid": 109,
            "sid": "add-event-source",
            "name": "add-event-source",
            "label": "addEventSource",
            "data": {
              "body": "> eventSource를 동적으로 추가합니다. > 입력받은 eventSourceId에 해당하는 eventSource가 존재하지 않으면 입력한 ID로 eventSource를 생성 후 event를 추가합니다. ### Syntax ```javascript object addEventSource( eventSourceInput ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |eventSourceInput|`Object`|<span class='required'>필수</span>|추가 될 eventSource의 object 정보| ### Return Value ***object*** : 이벤트 소스(EventSource) 객체 ### Example > 1. JSON Data를 Event로 사용하는 eventSource 추가 시 ```javascript IBCalendar.get(\"calendar1\").addEventSource({ id: \"eventSource1\", events: [ {\"title\":\"All Day Event\",\"start\":\"2020-04-01\",\"memo\":\"memo\"}, {\"title\":\"Long Event\",\"start\":\"2020-04-07\",\"end\":\"2020-04-10\"} ] }); ``` > 2. url을 Event로 사용하는 eventSource 추가 시 ```javascript IBCalendar.get(\"calendar1\").addEventSource({ id: \"eventSource1\", url: \"http://url\" }); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/add-event-source.html"
          },
          {
            "cid": 110,
            "sid": "add-event",
            "name": "add-event",
            "label": "addEvent",
            "data": {
              "body": "> 지정한 eventSource에 Event를 추가합니다. > 입력받은 eventSourceId에 해당하는 eventSource가 존재하지 않으면 입력한 ID로 eventSource를 생성 후 event를 추가합니다. ### Syntax ```javascript EventApi addEvent( eventInput, eventSourceId, sync ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |eventInput |`object`|<span class='required'>필수</span>|추가할 Event의 정보| |eventSourceId |`string`|<span class='required'>필수</span>|Event를 추가할 eventSource의 ID| |sync |`boolean`|<span class='optional'>선택</span>|\"eventAdd\" 옵션으로 설정된 callback 수행 여부| ### Return Value ***EventApi*** : 일정(Event) 객체 ### Example ```javascript IBCalendar.get(\"calendar1\").addEvent({ title: \"newEvent\", start: \"2020-05-25\", end: \"2020-05-28\", allDay: true, memo: \"event memo\" }, \"eventSource1\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/add-event.html"
          },
          {
            "cid": 111,
            "sid": "batch-rendering",
            "name": "batch-rendering",
            "label": "batchRendering",
            "data": {
              "body": "> rendering을 일으키는 작업을 그룹화 하여 실행합니다. > 여러 rendering 작업을 하게 될 경우, 최종 rendering 상태 한번만 rendering 합니다. ### Syntax ```javascript void batchRendering( func ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |func|`Function`|<span class='required'>필수</span>|rendering 작업 시 동작하게 되는 콜백 함수| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").batchRendering(function () { IBCalendar.get(\"calendar1\").changeView('dayGridMonth'); IBCalendar.get(\"calendar1\").addEvent({ title: 'new event', start: '2018-09-01', end: '2020-06-05' }); }); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/batch-rendering.html"
          },
          {
            "cid": 112,
            "sid": "change-view",
            "name": "change-view",
            "label": "changeView",
            "data": {
              "body": "> 뷰(View)를 전환합니다. ### Syntax ```javascript void changeView( viewName, dateOrRange ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |viewName|`string`|<span class='required'>필수</span>|전환할 뷰(View) 이름| |dateOrRange|`Object`|<span class='optional'>선택</span>|뷰(View) 전환 후 이동할 날짜| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").changeView(\"timeGridDay\", \"2020-06-01\"); IBCalendar.get(\"calendar1\").changeView(\"timeGridWeek\", {start: \"2020-05-31\", end: \"2020-06-07\"}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/change-view.html"
          },
          {
            "cid": 113,
            "sid": "destroy",
            "name": "destroy",
            "label": "destroy",
            "data": {
              "body": "> 해당하는 달력 객체를 삭제합니다. > 현재 DOM에 달력이 그려져 있을 경우 함께 삭제 됩니다. ### Syntax ```javascript void destroy( ); ``` ### Return Value ***none*** ### Example ```javascript // ID \"calendar1\" 에 해당하는 달력 객체 삭제 IBCalendar.get(\"calendar1\").destroy(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/destroy.html"
          },
          {
            "cid": 114,
            "sid": "export-csv",
            "name": "export-csv",
            "label": "exportCSV",
            "data": {
              "body": "> 달력의 모든 event 정보들을 CSV 파일로 저장합니다. ### Syntax ```javascript void exportSheet( fileName ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |fileName|`string`|<span class='optional'>선택</span>|CSV 파일 이름 설정 `(default : \"ibcalendar.csv\")`| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").exportCSV(); IBCalendar.get(\"calendar1\").exportCSV(\"ibcalendar.csv\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/export-csv.html"
          },
          {
            "cid": 115,
            "sid": "export-excel",
            "name": "export-excel",
            "label": "exportExcel",
            "data": {
              "body": "> 달력의 모든 event 정보들을 Excel 파일로 저장합니다. > xls 확장자로만 저장할 수 있습니다. ### Syntax ```javascript void exportExcel( fileName ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |fileName|`string`|<span class='optional'>선택</span>|Excel 파일 이름 설정 `(default : \"ibcalendar.xls\")`| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").exportExcel(); IBCalendar.get(\"calendar1\").exportExcel(\"ibcalendar.xls\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/export-excel.html"
          },
          {
            "cid": 116,
            "sid": "export-json",
            "name": "export-json",
            "label": "exportJSON",
            "data": {
              "body": "> 달력의 모든 event 정보들을 JSON 파일로 저장합니다. ### Syntax ```javascript void exportJSON( fileName, splitEventSource ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |fileName|`string`|<span class='optional'>선택</span>|JSON 파일 이름 설정 `(default : \"ibcalendar.json\")`| |splitEventSource|`boolean`|<span class='optional'>선택</span>|event 정보들을 eventSource 별로 구분하여 저장할지 여부 `(default : false)`| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").exportJSON(); IBCalendar.get(\"calendar1\").exportJSON(\"ibcalendar.json\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/export-json.html"
          },
          {
            "cid": 117,
            "sid": "export-sheet",
            "name": "export-sheet",
            "label": "exportSheet",
            "data": {
              "body": "> 달력의 모든 event 정보들을 스프레드 시트 파일(.xls, .xlsx)로 저장합니다. > [`\"exportExcel()\"`](/docs/funcs/calendar/export-excel)과의 차이점은 `eventSource`를 시트별로 구분되어 저장할지 여부를 선택할 수 있습니다. ### Syntax ```javascript void exportSheet( fileName, splitEventSource); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |fileName|`string`|<span class='optional'>선택</span>|스프레드 시트 파일(.xls, .xlsx) 이름 설정 `(default : \"ibcalendar.json\")`| |splitEventSource|`boolean`|<span class='optional'>선택</span>|event 정보들을 eventSource 별 sheet로 구분되어 저장할지 여부 `(default : true)`| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").exportSheet(); IBCalendar.get(\"calendar1\").exportSheet(\"ibcalendar.xls\"); IBCalendar.get(\"calendar1\").exportSheet(\"ibcalendar.xlsx\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/export-sheet.html"
          },
          {
            "cid": 118,
            "sid": "get-available-locale-codes",
            "name": "get-available-locale-codes",
            "label": "getAvailableLocaleCodes",
            "data": {
              "body": "> IBCalendar에서 제공하는 locale 종류를 배열 형태로 반환합니다. ### Syntax ```javascript array getAvailableLocaleCodes( ); ``` ### Return Value ***array*** : 배열 형태의 locale 목록 ### Example ```javascript var localeCodes = IBCalendar.get(\"calendar1\").getAvailableLocaleCodes(); localeCodes[0]; // \"en\" ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-available-locale-codes.html"
          },
          {
            "cid": 119,
            "sid": "get-date",
            "name": "get-date",
            "label": "getDate",
            "data": {
              "body": "> 달력 UI가 표시되는 기준이 되는 날짜의 Date 객체를 반환합니다. > gotoDate() api 를 사용 했을 경우, 이동된 날짜가 기준일이 됩니다. ### Syntax ```javascript EventApi getDate( ); ``` ### Return Value ***EventApi*** : 일정(Event) 객체 ### Example ```javascript IBCalendar.get(\"calendar1\").gotoDate(\"2020-07-05\"); console.log(IBCalendar.get(\"calendar1\").getDate()); // Sun Jul 05 2020 00:00:00 GMT+0900 (대한민국 표준시) ```",
              "see": [
                {
                  "label": "gotoDate method",
                  "url": "/docs/funcs/goto-date"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-date.html"
          },
          {
            "cid": 120,
            "sid": "get-event-by-id",
            "name": "get-event-by-id",
            "label": "getEventById",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event) 정보 객체를 반환합니다. ### Syntax ```javascript EventApi getEventById( id ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 id| ### Return Value ***EventApi*** : 일정(Event) 객체 ### Example ```javascript var objEvent = IBCalendar.get(\"calendar1\").getEventById(\"event1\"); console.log(objEvent.id); console.log(objEvent.groupId); console.log(objEvent.title); console.log(objEvent.allDay); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-event-by-id.html"
          },
          {
            "cid": 121,
            "sid": "get-event-format-range",
            "name": "get-event-format-range",
            "label": "getEventFormatRange",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 시작, 종료 날짜/시간 정보를 지정한 포멧 문자열로 반환합니다. ### Syntax ```javascript string getEventFormatRange( id, formatInput ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |formatInput |`string`|<span class='required'>필수</span>|포멧 형식([`luxon`](https://github.com/moment/luxon/blob/master/docs/formatting.md))| ### Return Value ***string*** : 시작, 종료 날짜/시간 정보 ### Example ```javascript let str = IBCalendar.get(\"calendar1\").getEventFormatRange(\"event1\", \"yyyy-LL-dd hh:mm\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-event-format-range.html"
          },
          {
            "cid": 122,
            "sid": "get-event-input",
            "name": "get-event-input",
            "label": "getEventInput",
            "data": {
              "body": "> 입력받은 EventApi 객체의 정보를 파싱하여 eventInput 객체 형태로 반환합니다. ### Syntax ```javascript EventInput getEventInput( eventApi ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |eventApi|`string`|<span class='required'>필수</span>|[`getEventById()`](/docs/funcs/calendar/get-event-by-id) API의 반환값인 일정(Event) 객체| ### Return Value ***EventInput*** : 일정(Event) 정보 ### Example ```javascript let eventObj = IBCalendar.get(\"calendar1\").getEventById(\"event1\"); let eventInput = IBCalendar.get(\"calendar1\").getEventInput(eventObj); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-event-input.html"
          },
          {
            "cid": 123,
            "sid": "get-event-inputs",
            "name": "get-event-inputs",
            "label": "getEventInputs",
            "data": {
              "body": "> 입력받은 EventApi 객체의 정보들을 파싱하여 eventInput 객체의 배열을 반환합니다. ### Syntax ```javascript array getEventInputs( eventApis ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |eventApis|`array`|<span class='required'>필수</span>|[`getEventById()`](/docs/funcs/calendar/get-event-by-id) API의 반환값인 일정(Event) 객체들의 배열| ### Return Value ***array[EventInput]*** : 일정(Event) 정보 배열 ### Example ```javascript let eventArray = []; eventArray[0] = IBCalendar.get(\"calendar1\").getEventById(\"event1\"); eventArray[1] = IBCalendar.get(\"calendar1\").getEventById(\"event2\"); let eventInputs = IBCalendar.get(\"calendar1\").getEventInputs(eventArray); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-event-inputs.html"
          },
          {
            "cid": 124,
            "sid": "get-event-source-by-id",
            "name": "get-event-source-by-id",
            "label": "getEventSourceById",
            "data": {
              "body": "> 지정한 ID에 해당하는 `eventSource` 정보를 반환합니다. ### Syntax ```javascript object getEventSourceById( id ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|eventSource의 ID| ### Return Value ***EventSourceApi object*** : 이벤트 소스(EventSource) 객체 ### Example ```javascript var getEventSource = IBCalendar.get(\"calendar1\").getEventSourceById(\"eventSource1\"); console.log(getEventSource.id); //\"eventSource1\" ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-event-source-by-id.html"
          },
          {
            "cid": 125,
            "sid": "get-event-sources",
            "name": "get-event-sources",
            "label": "getEventSources",
            "data": {
              "body": "> 달력의 모든 `eventSource` 정보를 배열로 반환합니다. ### Syntax ```javascript array getEventSources( ); ``` ### Return Value ***array[EventSourceApi]*** : 배열 형태의 이벤트 소스(EventSource) 객체 ### Example ```javascript var allEventSources = IBCalendar.get(\"calendar1\").getEventSources(); allEventSources[2].id; // eventSource 의 id ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-event-sources.html"
          },
          {
            "cid": 126,
            "sid": "get-events-by-source-id",
            "name": "get-events-by-source-id",
            "label": "getEventsBySourceId",
            "data": {
              "body": "> 지정한 ID에 해당하는 `eventSource` 의 모든 Event 정보 객체들을 배열 형태로 반환합니다. ### Syntax ```javascript array getEventsBySourceId( id ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|eventSource의 ID| ### Return Value ***array[EventApi]*** ### Example ```javascript var events = IBCalendar.get(\"calendar1\").getEventsBySourceId(\"eventSource1\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-events-by-source-id.html"
          },
          {
            "cid": 127,
            "sid": "get-events",
            "name": "get-events",
            "label": "getEvents",
            "data": {
              "body": "> 달력의 모든 Event 정보 객체들을 배열 형태로 반환합니다. ### Syntax ```javascript array getEvents( ); ``` ### Return Value ***array[EventApi]*** : 배열 형태의 일정(Event) 객체 ### Example ```javascript var arrEvents = IBCalendar.get(\"calendar1\").getEvents(); console.log(arrEvents[12].id); console.log(arrEvents[12].groupId); console.log(arrEvents[12].title); console.log(arrEvents[12].allDay); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-events.html"
          },
          {
            "cid": 128,
            "sid": "get-option",
            "name": "get-option",
            "label": "getOption",
            "data": {
              "body": "> 지정한 옵션(option)의 값을 반환 합니다. ### Syntax ```javascript any getOption( name ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |name|`string`|<span class='required'>필수</span>|옵션(option) 이름| ### Return Value ***any*** : 옵션의 값 ### Example ```javascript IBCalendar.get(\"calendar1\").getOption(\"height\"); //\"height\" 옵션(option)값 반환 ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-option.html"
          },
          {
            "cid": 129,
            "sid": "get-view-type",
            "name": "get-view-type",
            "label": "getViewType",
            "data": {
              "body": "> 현재 표시하고 있는 뷰(View)의 타입(이름)을 반환합니다. ### Syntax ```javascript string getViewType( ); ``` ### Return Value ***string*** : 뷰(View)의 타입(이름) ### Example ```javascript IBCalendar.get(\"calendar1\").getViewType(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/get-view-type.html"
          },
          {
            "cid": 130,
            "sid": "goto-date",
            "name": "goto-date",
            "label": "gotoDate",
            "data": {
              "body": "> 캘린더 UI를 지정한 날짜로 이동합니다. ### Syntax ```javascript void gotoDate( date ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |date|`Date`|<span class='required'>필수</span>|이동할 날짜| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").gotoDate(\"2020-07-05\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/goto-date.html"
          },
          {
            "cid": 131,
            "sid": "import-csv",
            "name": "import-csv",
            "label": "importCSV",
            "data": {
              "body": "> CSV 파일에 정의되어 있는 event 정보들을 달력으로 불러옵니다. ### Syntax ```javascript void importCSV( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").importCSV(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/import-csv.html"
          },
          {
            "cid": 132,
            "sid": "import-json",
            "name": "import-json",
            "label": "importJSON",
            "data": {
              "body": "> json 파일에 정의되어 있는 event 정보 객체들을 달력으로 불러옵니다. ### Syntax ```javascript void importJSON( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").importJSON(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/import-json.html"
          },
          {
            "cid": 133,
            "sid": "import-sheet",
            "name": "import-sheet",
            "label": "importSheet",
            "data": {
              "body": "> 스프레드 시트 파일(.xls, .xlsx, .csv)에 정의되어 있는 event 정보들을 달력으로 불러옵니다. > .csv 확장자로 import 시에는 `splitEventSource` 인자를 반드시 `false`로 설정해야 합니다. ### Syntax ```javascript void importSheet( splitEventSource ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |splitEventSource|`boolean`|<span class='optional'>선택</span>|event 정보들이 eventSource 별 Sheet로 구분되어 있는지 여부 `(default : false)`| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").importSheet(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/import-sheet.html"
          },
          {
            "cid": 134,
            "sid": "increment-date",
            "name": "increment-date",
            "label": "incrementDate",
            "data": {
              "body": "> 달력 UI에 표시되는 날짜를 지정한 범위 만큼 이동합니다. > 음수를 입력하게 되면 그 이전 만큼으로 이동됩니다. |View|Result| |------|------------------| |년 단위|years| |월 단위|months| |주 단위|weeks| |일 단위|days| ### Syntax ```javascript void incrementDate( date ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |date|`Object`|<span class='required'>필수</span>|이동할 날짜| ### Return Value ***none*** ### Example ```javascript // 7일 후의 날짜들로 표시 IBCalendar.get(\"calendar1\").incrementDate({days: 7}); // 2주일 후의 날짜들로 표시 IBCalendar.get(\"calendar1\").incrementDate({weeks: 2}); // 5년 전의 날짜들로 표시 IBCalendar.get(\"calendar1\").incrementDate({years : -5}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/increment-date.html"
          },
          {
            "cid": 135,
            "sid": "move-event-dates",
            "name": "move-event-dates",
            "label": "moveEventDates",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 시작, 종료 날짜/시간을 지정한 기간만큼 이동합니다. ### Syntax ```javascript void moveEventDates( id, deltaInput ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |endInput|`string`|<span class='required'>필수</span>|일정(Event)의 시작,종료 날짜/시간을 이동할 기간| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").moveEventDates(\"event1\", {days: 1}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/move-event-dates.html"
          },
          {
            "cid": 136,
            "sid": "move-event-end",
            "name": "move-event-end",
            "label": "moveEventEnd",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 종료 날짜/시간을 지정한 기간만큼 이동합니다. ### Syntax ```javascript void moveEventEnd( id, deltaInput ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |endInput|`string`|<span class='required'>필수</span>|일정(Event)의 종료 날짜/시간을 이동할 기간| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").moveEventEnd(\"event1\", {days: 1}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/move-event-end.html"
          },
          {
            "cid": 137,
            "sid": "move-event-start",
            "name": "move-event-start",
            "label": "moveEventStart",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 시작 날짜/시간을 지정한 기간만큼 이동합니다. ### Syntax ```javascript void moveEventStart( id, deltaInput ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |endInput|`string`|<span class='required'>필수</span>|일정(Event)의 시작 날짜/시간을 이동할 기간| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").moveEventStart(\"event1\", {days: -1}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/move-event-start.html"
          },
          {
            "cid": 138,
            "sid": "next-year",
            "name": "next-year",
            "label": "nextYear",
            "data": {
              "body": "> 현재 표시되고 있는 범위를 년 단위 다음 범위로 이동합니다. |View|Result| |------|------------------| |월 단위|내년 해당 월| |주 단위|내년 해당 주| |일 단위|내년 해당 일| ### Syntax ```javascript void nextYear( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").nextYear(); ```",
              "see": [
                {
                  "label": "prevYear method",
                  "url": "/docs/funcs/calendar/prev-year"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/next-year.html"
          },
          {
            "cid": 139,
            "sid": "next",
            "name": "next",
            "label": "next",
            "data": {
              "body": "> 현재 표시되고 있는 범위를 다음 범위로 이동합니다. |View|Result| |------|------------------| |월 단위|다음달| |주 단위|다음주| |일 단위|다음날| ### Syntax ```javascript void next( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").next(); ```",
              "see": [
                {
                  "label": "prev method",
                  "url": "/docs/funcs/calendar/prev"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/next.html"
          },
          {
            "cid": 140,
            "sid": "prev-year",
            "name": "prev-year",
            "label": "prevYear",
            "data": {
              "body": "> 현재 표시되고 있는 범위를 년 단위 이전 범위로 이동합니다. |View|Result| |------|------------------| |월 단위|작년 해당 월| |주 단위|작년 해당 주| |일 단위|작년 해당 일| ### Syntax ```javascript void prevYear( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").prevYear(); ```",
              "see": [
                {
                  "label": "nextYear method",
                  "url": "/docs/funcs/calendar/next-year"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/prev-year.html"
          },
          {
            "cid": 141,
            "sid": "prev",
            "name": "prev",
            "label": "prev",
            "data": {
              "body": "> 현재 표시되고 있는 범위를 이전 범위로 이동합니다. |View|Result| |------|------------------| |월 단위|이전달| |주 단위|전주| |일 단위|전날| ### Syntax ```javascript void prev( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").prev(); ```",
              "see": [
                {
                  "label": "next method",
                  "url": "/docs/funcs/calendar/next"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/prev.html"
          },
          {
            "cid": 142,
            "sid": "remove-event",
            "name": "remove-event",
            "label": "removeEvent",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)을 삭제하고 삭제한 Event 정보 객체를 반환합니다. > ID에 해당하는 일정(Event)이 없을 경우 null을 리턴합니다. ### Syntax ```javascript EventApi removeEvent( id ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| ### Return Value ***EventApi*** : 일정(Event) 객체 ### Example ```javascript let objEvent = IBCalendar.get(\"calendar1\").removeEvent(\"event1\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/remove-event.html"
          },
          {
            "cid": 143,
            "sid": "render",
            "name": "render",
            "label": "render",
            "data": {
              "body": "> 달력 UI를 생성합니다. ### Syntax ```javascript void render( ); ``` ### Return Value ***none*** ### Example ```javascript // ID \"calendar1\" 에 해당하는 달력 객체의 달력 UI 생성 IBCalendar.get(\"calendar1\").render(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/render.html"
          },
          {
            "cid": 144,
            "sid": "scroll-to-time",
            "name": "scroll-to-time",
            "label": "scrollToTime",
            "data": {
              "body": "> \"timeGrid\" 뷰(View) 사용시 스크롤이 있을 경우, 설정한 시간이 스크롤 상단으로 오도록 스크롤을 이동합니다. ### Syntax ```javascript void scrollToTime( timeInput ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |timeInput|`Object`,`string`|<span class='required'>필수</span>|스크롤 이동할 시간| ### Return Value ***none*** ### Example ```javascript // 오전 05:00 시간으로 스크롤이 이동. IBCalendar.get(\"calendar1\").scrollToTime(\"05:00\"); // 오전 01:00 시간으로 스크롤이 이동. IBCalendar.get(\"calendar1\").scrollToTime({milliseconds:3600000}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/scroll-to-time.html"
          },
          {
            "cid": 145,
            "sid": "select-2",
            "name": "select",
            "label": "select",
            "data": {
              "body": "> 특정 범위의 날짜를 선택 상태로 합니다. > `start`, `end` 날짜를 각각의 string 형태로 넣어서 사용 합니다. ### Syntax ```javascript void select( dateOrObj, endDate ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |dateOrObj|`string`,`Object`|<span class='required'>필수</span>|선택 시작 날짜 또는 선택 범위를 설정 할 dateObj| |endDate |`string`,`Object`|<span class='optional'>선택</span>|선택 종료 날짜| ### Return Value ***none*** ### Example ```javascript // string 형태로 사용 IBCalendar.get(\"calendar1\").select(\"2020-06-13\", \"2020-06-23\"); // object 형태로 사용 IBCalendar.get(\"calendar1\").select({start: \"2020-06-13\", end: \"2020-06-23\"}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/select.html"
          },
          {
            "cid": 146,
            "sid": "serialize",
            "name": "serialize",
            "label": "serialize",
            "data": {
              "body": "> 특정 달력 객체의 모든 설정 정보를 string 형태로 반환합니다. ### Syntax ```javascript string serialize( ); ``` ### Return Value ***string*** : 달력 객체의 모든 설정 정보 ### Example ```javascript IBCalendar.get(\"calendar1\").serialize(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/serialize.html"
          },
          {
            "cid": 147,
            "sid": "set-event-all-day",
            "name": "set-event-all-day",
            "label": "setEventAllDay",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 종일 일정(allDay Event) 여부를 설정합니다. > 종일 일정(allDay Event)을 `false`로 설정하면, 시간정보는 \"00:00:00\"으로 설정됩니다. ### Syntax ```javascript void setEventAllDay( id, allDay, options ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |allDay|`boolean`|<span class='required'>필수</span>|종일 일정(allDay Event) 여부| |options|`Object`|<span class='optional'>선택</span>|옵션| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").setEventAllDay(\"event1\", false); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-event-all-day.html"
          },
          {
            "cid": 148,
            "sid": "set-event-dates",
            "name": "set-event-dates",
            "label": "setEventDates",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 시작,종료 날짜/시간 정보와 종일 일정(allDay Event) 여부를 동시에 설정합니다. ### Syntax ```javascript void setEventDates( id, startInput, endInput, options ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |endInput|`string`|<span class='required'>필수</span>|설정할 일정(Event)의 시작 날짜/시간 정보| |endInput|`string`|<span class='optional'>선택</span>|설정할 일정(Event)의 종료 날짜/시간 정보| |options |`Object`|<span class='optional'>선택</span>|옵션| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").setEventDates(\"event1\", \"2020-07-01\", \"2020-07-02\", {allDay:true}); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-event-dates.html"
          },
          {
            "cid": 149,
            "sid": "set-event-end",
            "name": "set-event-end",
            "label": "setEventEnd",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 종료 날짜/시간 정보를 설정합니다. ### Syntax ```javascript void setEventEnd( id, endInput, options ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |endInput|`string`|<span class='required'>필수</span>|설정할 일정(Event)의 종료 날짜/시간 정보| |options |`Object`|<span class='optional'>선택</span>|옵션| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").setEventEnd(\"event1\", \"2020-07-01\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-event-end.html"
          },
          {
            "cid": 150,
            "sid": "set-event-extended-prop",
            "name": "set-event-extended-prop",
            "label": "setEventExtendedProp",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)에서 IBCalendar 에서 지원하는 데이터값이 아닌 `\"extendedProp\"` 값들을 변경합니다. > IBCalendar 에서 제공하는 데이터는 [달력 객체 구조](docs/start/init-structure) 의 `조회 데이터 구조` 부분을 참고하시면 됩니다. > IBCalendar 에서 제공하는 데이터 중 `\"memo\"` 데이터만 유일하게 `\"extendedProp\"` 로 제공하고 있습니다. > 일정(Event)의 `\"extendedProp\"` 데이터 변경 후 동기화를 위해 [`\"eventChange\"`](/docs/props/event-sources/event-change) 옵션으로 정의한 콜백(callback) 함수를 호출합니다. ### Syntax ```javascript void setEventExtendedProp( id, name, val ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|일정(Event)의 ID| |name|`string`|<span class='required'>필수</span>|설정할 `\"extendedProp\"` 데이터명| |val|`any`|<span class='required'>필수</span>|설정할 `\"extendedProp\"` 데이터값| ### Return Value ***none*** ### Example ```javascript // 일정(Event)의 memo 값을 변경 IBCalendar.get(\"calendar1\").setEventExtendedProp(\"event1\", \"memo\", \"sonymaker2\"); console.log(\"변경된 MEMO 값 : \", IBCalendar.get(\"calendar1\").getEventById(\"event1\").extendedProps.memo); ```",
              "see": [
                {
                  "label": "eventChange props",
                  "url": "/docs/props/event-sources/event-change"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-event-extended-prop.html"
          },
          {
            "cid": 151,
            "sid": "set-event-prop",
            "name": "set-event-prop",
            "label": "setEventProp",
            "data": {
              "body": "> 날짜/시간과 관련되지 않은 일정(Event) 데이터를 변경합니다. > 데이터 변경 후 일정(Event)을 다시 렌더링합니다. > 일정(Event)의 데이터를 변경 후 동기화를 위해 [`\"eventChange\"`](/docs/props/event-sources/event-change) 옵션으로 정의한 콜백(callback) 함수를 호출합니다. ### Syntax ```javascript void setEventProp( id, name, val ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|일정(Event)의 ID| |name|`string`|<span class='required'>필수</span>|설정할 데이터명| |val |`string`|<span class='required'>필수</span>|설정할 데이터값| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").setEventProp(\"event1\", \"title\", \"제목 변경\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-event-prop.html"
          },
          {
            "cid": 152,
            "sid": "set-event-source-display-by-id",
            "name": "set-event-source-display-by-id",
            "label": "setEventSourceDisplayById",
            "data": {
              "body": "> 지정한 ID에 해당하는 `eventSource` 의 모든 일정들에 대해 표시할지 여부를 설정합니다. ### Syntax ```javascript void setEventSourceDisplayById( id, display ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|eventSource의 ID| |display|`boolean`|<span class='required'>필수</span>|표시여부| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").setEventSourceDisplayById(\"eventSource1\", false); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-event-source-display-by-id.html"
          },
          {
            "cid": 153,
            "sid": "set-event-start",
            "name": "set-event-start",
            "label": "setEventStart",
            "data": {
              "body": "> 지정한 ID에 해당하는 일정(Event)의 시작 날짜/시간 정보를 설정합니다. ### Syntax ```javascript void setEventStart( id, startInput, options ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|Event의 ID| |startInput|`string`|<span class='required'>필수</span>|설정할 일정(Event)의 시작 날짜/시간 정보| |options|`Object`|<span class='optional'>선택</span>|옵션| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").setEventStart(\"event1\", \"2020-06-20\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-event-start.html"
          },
          {
            "cid": 154,
            "sid": "set-events-display",
            "name": "set-events-display",
            "label": "setEventsDisplay",
            "data": {
              "body": "> 달력의 모든 일정 정보를 표시할지 여부를 설정합니다. ### Syntax ```javascript void setEventsDisplay( display ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |display|`boolean`|<span class='required'>필수</span>|표시여부| ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").setEventsDisplay(false); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-events-display.html"
          },
          {
            "cid": 155,
            "sid": "set-option",
            "name": "set-option",
            "label": "setOption",
            "data": {
              "body": "> 지정한 옵션(option)을 입력 받은 값으로 설정합니다. > [`eventSources`](/docs/props/event-sources/event-sources) 는 동적으로 설정 불가능 합니다. ### Syntax ```javascript void setOption( name ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |name|`string`|<span class='required'>필수</span>|옵션(option) 이름| |val|`any`|<span class='required'>필수</span>|설정할 값| ### Return Value ***none*** : 옵션의 값 ### Example ```javascript IBCalendar.get(\"calendar1\").setOption(\"headerToolbar\", { left: \"title\", center: \"today prev next defaultDate customBtn1\", right: \"dayGridMonth,timeGridWeek,timeGridDay,listMonth\" }); // \"headerToolbar\" 옵션(option)값 변경 ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-option.html"
          },
          {
            "cid": 156,
            "sid": "set-recurrence-event-prop",
            "name": "set-recurrence-event-prop",
            "label": "setRecurrenceEventProp",
            "data": {
              "body": "> 반복 일정(Event)의 반복 일정에 관련된 데이터 값을 변경합니다. > 데이터 변경 후 반복 일정(Event)을 다시 렌더링합니다. > 반복 일정(Event)의 데이터를 변경 후 동기화를 위해 [`\"eventChange\"`](/docs/props/event-sources/event-change) 옵션으로 정의한 콜백(callback) 함수를 호출합니다. > 반복 일정에 관련된 데이터는 현재 아래와 같이 두가지의 데이터만 지원합니다. |Name|Description| |------|------------------| |duration|반복 일정(Event)의 길이| |rrule|[RRULE string](https://jkbrzt.github.io/rrule/) 데이터| ### Syntax ```javascript void setRecurrenceEventProp( id, name, val ); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|일정(Event)의 ID| |name|`string`|<span class='required'>필수</span>|설정할 속성명| |val |`string`|<span class='required'>필수</span>|설정할 속성값| ### Return Value ***none*** ### Example ```javascript // 반복일정 편집 IBCalendar.get(\"calendar1\").setRecurrenceEventProp(\"event1\", \"duration\", {milliseconds: 172800000}); IBCalendar.get(\"calendar1\").setRecurrenceEventProp(\"event1\", \"rrule\", \"DTSTART:20230529T000000Z\\nRRULE:INTERVAL=1;FREQ=WEEKLY;BYDAY=TU;COUNT=30\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.4|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.4|기능 추가|"
            },
            "url": "docs/funcs/calendar/set-recurrence-event-prop.html"
          },
          {
            "cid": 157,
            "sid": "today",
            "name": "today",
            "label": "today",
            "data": {
              "body": "> 달력 UI를 현재의 날짜로 이동합니다. ### Syntax ```javascript void today( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").today(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/today.html"
          },
          {
            "cid": 158,
            "sid": "unselect-2",
            "name": "unselect",
            "label": "unselect",
            "data": {
              "body": "> 모든 선택 상태를 clear 합니다. ### Syntax ```javascript void unselect( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").unselect(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/unselect.html"
          },
          {
            "cid": 159,
            "sid": "update-size",
            "name": "update-size",
            "label": "updateSize",
            "data": {
              "body": "> 달력 UI의 크기를 다시 조정합니다. > 달력 UI 크기에 대한 refresh를 의미합니다. ### Syntax ```javascript void updateSize( ); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.get(\"calendar1\").updateSize(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/calendar/update-size.html"
          }
        ]
      },
      {
        "gid": 2,
        "name": "funcs-event-source",
        "label": "EventSource",
        "children": [
          {
            "cid": 160,
            "sid": "refetch",
            "name": "refetch",
            "label": "refetch",
            "data": {
              "body": "> 해당하는 `eventSource` 객체의 일정(Event) 을 다시 조회합니다. > `eventSource` 의 `events`에 정의된 내용을 다시 호출하는 기능입니다. > 데이터 조회는 [일정(Event) 조회 및 서버 연동](/docs/start/data-sync.md) 을 참고하시기 바랍니다. ### Syntax ```javascript void refetch( ); ``` ### Return Value ***none*** ### Example ```javascript // ID \"eventSource1\" 에 해당하는 eventSource 객체의 일정 정보를 다시 조회. IBCalendar.get(\"calendar1\").getEventSourceById(\"eventSource1\").refetch(); ```",
              "see": [
                {
                  "label": "getEventSourceById method",
                  "url": "/docs/funcs/calendar/get-event-source-by-id"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/event-source/refetch.html"
          },
          {
            "cid": 161,
            "sid": "remove",
            "name": "remove",
            "label": "remove",
            "data": {
              "body": "> 해당하는 `eventSource` 객체를 제거합니다. ### Syntax ```javascript void remove( ); ``` ### Return Value ***none*** ### Example ```javascript // ID \"eventSource1\" 에 해당하는 eventSource 객체를 제거. IBCalendar.get(\"calendar1\").getEventSourceById(\"eventSource1\").remove(); ```",
              "see": [
                {
                  "label": "getEventSourceById method",
                  "url": "/docs/funcs/calendar/get-event-source-by-id"
                }
              ],
              "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
            },
            "url": "docs/funcs/event-source/remove.html"
          }
        ]
      }
    ]
  },
  {
    "gid": 5,
    "name": "static",
    "label": "Static",
    "children": [
      {
        "cid": 170,
        "sid": "static",
        "name": "static",
        "label": "static 객체 란",
        "data": {
          "body": "> `ibcalendar.min.js` 파일을 화면에 추가하면 전역변수로 `IBCalendar`객체가 생성됩니다. > 이 객체를 통해 달력 객체를 가져오고 사용하실 수 있습니다. > > `IBCalendar`객체가 갖고 있는 함수와 속성은 아래와 같습니다. ## 내부 함수/이벤트/속성 |Name|Type|Description| |---|---|---| |[create](/docs/static/create)|`function`|`달력 객체`를 생성하고 반환합니다.| |[clear](/docs/static/clear)|`function`|현재 HTML 문서 내에 생성된 모든 달력 객체들을 삭제합니다.| |[delete](/docs/static/delete)|`function`|지정한 ID의 달력 객체를 삭제합니다.| |[deserialize](/docs/static/deserialize)|`function`|serialized된 문자열을 이용하여 IBCalendar 객체를 생성하고 반환합니다.| |[get](/docs/static/get)|`function`|지정한 ID의 달력 객체를 반환합니다.| |[has](/docs/static/has)|`function`|지정한 ID의 달력 객체 존재여부를 반환합니다.| |[keys](/docs/static/keys)|`function`|현재 HTML 문서 내에 생성된 달력 객체들의 ID를 배열로 반환합니다.| |[size](/docs/static/size)|`function`|현재 HTML 문서 내에 생성된 달력 객체들의 수를 반환합니다.| |[version](/docs/static/version)|`function`|화면에 로드된 제품의 버전을 리턴합니다.| ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/static.html"
      },
      {
        "cid": 162,
        "sid": "clear",
        "name": "clear",
        "label": "clear",
        "data": {
          "body": "> 현재 HTML 문서 내에 생성된 모든 달력 객체들을 삭제합니다. ### Syntax ```javascript void IBCalendar.clear(); ``` ### Return Value ***none*** ### Example ```javascript IBCalendar.clear(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/clear.html"
      },
      {
        "cid": 163,
        "sid": "create",
        "name": "create",
        "label": "create",
        "data": {
          "body": "> 달력 객체를 생성하고 반환합니다. > 생성한 달력 객체를 사용하여 [render()](/docs/funcs/calendar/render) Method를 호출해야 달력이 실제로 DOM에 그려집니다. ### Syntax ```javascript object IBCalendar.create(id, el, options); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|달력 객체의 `id`| |el|`HTMLElement`|<span class='required'>필수</span>|달력을 생성할 부모 html 컨테이너 div객체| |[options](/docs/props/index)|`object`|<span class='required'>필수</span>|달력 생성 정보를 갖고있는 `json 객체`| ### Return Value ***object*** ### Example ```html <body> <div id=\"calendar-container\"/> </body> ``` ```javascript const id = \"calendar1\", parentEl = document.getElementById(\"calendar-container\"), options = { headerToolbar: { left: \"today prev next\", center: \"title\", right: \"dayGridMonth,timeGridWeek,timeGridDay,listMonth\" } }; const objCalendar = IBCalendar.create( id, parentEl, options ); // 실제 달력을 DOM에 그려주는 API objCalendar.render(); ```",
          "see": [
            {
              "label": "Properties",
              "url": "/docs/props/index"
            },
            {
              "label": "render Method",
              "url": "/docs/funcs/calendar/render"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/create.html"
      },
      {
        "cid": 164,
        "sid": "delete",
        "name": "delete",
        "label": "delete",
        "data": {
          "body": "> 지정한 ID의 달력 객체를 삭제합니다. ### Syntax ```javascript void IBCalendar.delete(id); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|달력 객체의 `id`| ### Return Value ***none*** ### Example ```javascript if (IBCalendar.has(\"calendar1\")) { IBCalendar.delete(\"calendar1\"); } ```",
          "see": [
            {
              "label": "Properties",
              "url": "/docs/props/index"
            },
            {
              "label": "IBSheet.has static",
              "url": "/docs/static/has"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/delete.html"
      },
      {
        "cid": 165,
        "sid": "deserialize",
        "name": "deserialize",
        "label": "deserialize",
        "data": {
          "body": "> serialized된 문자열을 이용하여 달력 객체를 생성하고 반환합니다. ### Syntax ```javascript object IBCalendar.deserialize(id, el, optstring); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|달력 객체의 `id`| |el|`HTMLElement`|<span class='required'>필수</span>|달력을 생성할 부모 html 컨테이너 div객체| |[optstring](/docs/funcs/calendar/serialize)|`string`|<span class='required'>필수</span>|serialized된(달력의 serialize() API를 통해 생성된) 문자열| ### Return Value ***object*** ### Example ```html <body> <div id=\"calendar-container\"/> <div id=\"calendar2-container\"/> </body> ``` ```javascript const id = \"calendar1\", parentEl = document.getElementById(\"calendar-container\"), options = { headerToolbar: { left: \"today prev next\", center: \"title\", right: \"dayGridMonth,timeGridWeek,timeGridDay,listMonth\" } }; IBCalendar.create( id, parentEl, options ); const optstring = IBCalendar.get(\"calendar1\").serialize(); IBCalendar.deserialize(\"calendar2\", document.getElementById(\"calendar2-container\"), optstring).render(); ```",
          "see": [
            {
              "label": "Properties",
              "url": "/docs/props/index"
            },
            {
              "label": "serialize Method",
              "url": "/docs/funcs/calendar/serialize"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/deserialize.html"
      },
      {
        "cid": 166,
        "sid": "get",
        "name": "get",
        "label": "get",
        "data": {
          "body": "> 지정한 ID의 달력 객체를 반환합니다. ### Syntax ```javascript object IBCalendar.get(id); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|달력 객체 `id`| ### Return Value ***object*** ### Example ```javascript IBCalendar.get(\"calendar1\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/get.html"
      },
      {
        "cid": 167,
        "sid": "has",
        "name": "has",
        "label": "has",
        "data": {
          "body": "> 지정한 ID의 달력 객체 존재여부를 반환합니다. ### Syntax ```javascript boolean IBCalendar.has(id); ``` ### Parameters |Name|Type|Required|Description| |----------|-----|---|----| |id|`string`|<span class='required'>필수</span>|달력 객체의 `id`| ### Return Value ***boolean*** ### Example ```javascript IBCalendar.has(\"calendar1\"); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/has.html"
      },
      {
        "cid": 168,
        "sid": "keys",
        "name": "keys",
        "label": "keys",
        "data": {
          "body": "> 현재 HTML 문서 내에 생성된 달력 객체들의 ID를 배열로 반환합니다. ### Syntax ```javascript array IBCalendar.keys(); ``` ### Return Value ***array[string]*** ### Example ```javascript IBCalendar.keys(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/keys.html"
      },
      {
        "cid": 169,
        "sid": "size",
        "name": "size",
        "label": "size",
        "data": {
          "body": "> 현재 HTML 문서 내에 생성된 달력 객체들의 수를 반환합니다. ### Syntax ```javascript number IBCalendar.size(); ``` ### Return Value ***number*** ### Example ```javascript IBCalendar.size(); ``` ### Since |product|version|desc| |---|---|---| |core|1.5.0.0|기능 추가|",
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/size.html"
      },
      {
        "cid": 171,
        "sid": "version",
        "name": "version",
        "label": "version",
        "data": {
          "body": "> IBCalendar의 제품 버전을 확인합니다. ### Syntax ```javascript string version(); ``` ### Return Value ***string***: 화면에 로드된 `ibcalendar.min.js` 제품의 버전 문자열 ### Example ```javascript // IBCalendar의 제품 버전 확인 IBCalendar.version(); ```",
          "see": [],
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가|"
        },
        "url": "docs/static/version.html"
      }
    ]
  },
  {
    "gid": 6,
    "name": "appx",
    "label": "Appendix",
    "children": [
      {
        "cid": 172,
        "sid": "basic-course",
        "name": "basic-course",
        "label": "기초 개발자 교육",
        "data": {
          "body": "목차 1. 제품 파일 구성 2. 기본 캘린더 생성 방법 3. 함수와 이벤트 4. 렌더링과 데이터 로드 ## 1. 제품 파일 구성 IB Calendar 기본 파일 구성에 대해 설명합니다.(<a href=\"../../#docs/intro/files\" target=\"_blank\">참고</a>) ## 2. 기본 캘린더 생성 방법 간단하게 javascript를 이용하여 캘린더 객체를 생성하는 방법을 설명합니다.(<a href=\"../../#docs/start/quick-start\" target=\"_blank\">참고</a>) ```javascript let id = \"calendar1\", heParent = document.getElementById(\"calendar-container\"), options = { locale: \"ko\", editable: true, selectable: true }; let objCalendar = IBCalendar.create( id, // 생성하는 캘린더 이름 heParent, // 캘린더가 생성될 div 요소 options // IB Calendar 기본 옵션 설정 ); objCalendar.render(); // 캘린더 렌더링 ``` ## 3. 함수와 이벤트 IB Calendar 함수 와 이벤트에 대한 기본적인 사용법을 설명합니다. - 자주 사용되는 함수 |함수명|기능설명| |---|---| |[getEvents](/docs/funcs/calendar/get-events)|달력의 모든 일정(Event) 정보 객체들을 배열 형태로 반환| |[getEventById](/docs/funcs/calendar/get-event-by-id)|id에 해당하는 일정(Event) 정보 객체를 반환| |[getEventSourceById](/docs/funcs/calendar/get-event-source-by-id)|id에 해당하는 eventSource 정보를 반환| |[addEvent](/docs/funcs/calendar/add-event)|일정(Event)을 추가| |[addEventSource](/docs/funcs/calendar/add-event-source)|eventSource를 추가| |[changeView](/docs/funcs/calendar/change-view)|뷰(View)를 전환| |[destroy](/docs/funcs/calendar/destroy)|달력 객체를 삭제| |[getViewType](/docs/funcs/calendar/get-view-type)|현재 표시하고 있는 뷰(View)의 타입(이름)을 반환| |[gotoDate](/docs/funcs/calendar/goto-date)|달력 UI를 지정한 날짜로 이동| |[setOption](/docs/funcs/calendar/set-option)|지정한 옵션(option)을 입력 받은 값으로 설정| |[getOption](/docs/funcs/calendar/get-option)|지정한 옵션(option)의 값을 반환| |[updateSize](/docs/funcs/calendar/update-size)|달력 UI의 크기를 다시 조정| |[render](/docs/funcs/calendar/render)|달력 UI를 생성| |[removeEvent](/docs/funcs/calendar/remove-event)|id에 해당하는 일정(Event)을 삭제| |[select](/docs/funcs/calendar/select)|특정 범위의 날짜를 선택 상태로 변경| |[today](/docs/funcs/calendar/today)|달력 UI를 현재의 날짜로 이동| |[unselect](/docs/funcs/calendar/unselect)|모든 선택 상태를 clear| - 자주 사용되는 이벤트 |이벤트명|기능설명| |---|---| |[dateClick](/docs/props/triggered/date-click)|사용자가 `날짜 또는 시간을 클릭하면 발생`하는 콜백(callback) 함수| |[eventClick](/docs/props/triggered/event-click)|사용자가 `일정(Event)을 클릭 시 발생`하는 콜백(callback) 함수| |[loading](/docs/props/triggered/loading)|`일정(Event) 정보를 가져오는 Fetch 시작/종료 시 발생`하는 콜백(callback) 함수| |[select](/docs/props/triggered/select)|사용자가 마우스로 `날짜 또는 시간을 Drag and Drop으로 선택 시 발생`하는 콜백(callback) 함수| |[unselect](/docs/props/triggered/unselect)|`기존에 선택되어 있던 영역이 해제될 때 발생`하는 콜백(callback) 함수| |[windowResize](/docs/props/triggered/window-resize)|브라우저 창의 크기가 변경되었을 때 `캘린더 UI의 크기가 변경된 후 발생`하는 콜백(callback) 함수| ## 4. 렌더링과 데이터 로드 1. 일정 추가/삭제/변경 캘린더 내에 일정(Event)을 추가/삭제/변경하는 방법은 두가지가 있습니다. - 함수를 통한 일정(Event) 추가/삭제/변경 ```javascript calendar.addEvent({ id: \"evnet1\" title: \"newEvent\", start: \"2020-05-25\", end: \"2020-05-28\", allDay: true, memo: \"event memo\", toolTip: \"newEvent\" }, \"eventSource1\"); // 일정 추가 calendar.setEventStart(\"event1\", \"2020-05-20\"); // 일정의 시작 날짜 정보를 변경 calendar.removeEvent(\"evnet1\") // 일정 삭제 ``` - UI/UX 를 통한 일정(Event) 추가/삭제/변경 생성 옵션 [editable](/docs/props/options/editable), [selectable](/docs/props/options/selectable) 가 활성화 되어 있어야 합니다. ```javascript options = { editable: true, selectable: true }; ``` 일정을 추가할 달력의 날짜 영역을 클릭 시 임시 일정이 추가되면서 이벤트 편집창이 보여지게 되고, 저장 버튼을 클릭시 일정이 추가됩니다. ![일정 추가](/assets/imgs/addEvent.png \"일정 추가\") 달력의 일정을 클릭 시 이벤트 요약 창이 보여지고 편집 아이콘을 클릭 시 편집창이 보여지며 해당 일정에 대한 정보를 수정할 수 있습니다. ![일정 변경](/assets/imgs/eventEdit1.png \"일정 변경\") ![일정 변경](/assets/imgs/eventEdit2.png \"일정 변경\") 이벤트 요약 창의 삭제 아이콘을 클릭 시 이벤트를 삭제할 수 있습니다. ![일정 삭제](/assets/imgs/removeEvent1.png \"일정 삭제\") ![일정 삭제](/assets/imgs/removeEvent3.png \"일정 삭제\") 일정 편집창에서도 삭제가 가능합니다. ![일정 삭제](/assets/imgs/removeEvent2.png \"일정 삭제\") 2. 조회 [일정(Event) 조회 및 서버 연동](/docs/start/data-sync) 3. 데이터 구조 [달력 객체 구조](/docs/start/init-structure)",
          "see": [
            {
              "label": "파일 구성 introduction",
              "url": "/docs/intro/files"
            },
            {
              "label": "Quick Start getting started",
              "url": "/docs/start/quick-start"
            },
            {
              "label": "달력 객체 구조 getting stated",
              "url": "/docs/start/init-structure"
            },
            {
              "label": "일정(Event) 조회 및 서버 연동",
              "url": "/docs/start/data-sync"
            },
            {
              "label": "Date Parsing appendix",
              "url": "/docs/appx/date-parsing"
            },
            {
              "label": "TimeZone props",
              "url": "/docs/props/options/time-zone"
            }
          ],
          "since": "|product|version|desc||---|---|---||core|1.5.0.0|기능 추가||core|1.6.0.0|`toolTip` 추가|"
        },
        "url": "docs/appx/basic-course.html"
      },
      {
        "cid": 173,
        "sid": "date-parsing",
        "name": "date-parsing",
        "label": "Date Parsing",
        "data": {
          "body": "IBCalendar에서 허용하는 날짜 형식에 대한 설명입니다. ## ISO8601 문자열 [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) 문자열은 날짜를 표현하는 가장 일반적인 방법입니다. 가볍고 읽기 쉬우며 `UTC` 시간대 정보를 지정할 수 있는 기능을 제공합니다. [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) 날짜의 예시는 다음과 같습니다. - `2018-06-01T12:30:00-05:00` — UTC offset-05:00 - `2018-06-01T12:30:00Z` — UTC offsetZ00:00 - `2018-06-01T12:30:00` — UTC 시간대가 지정되지 않았습니다. 날짜 파싱은 [timeZone](/docs/props/options/time-zone) 옵션을 따릅니다. - `2018-06-01` — UTC 시간대가 지정되지 않았습니다. 날짜 파싱은 [timeZone](/docs/props/options/time-zone) 옵션을 따릅니다. ## Millisecond Time `1970년 1월 1일 UTC` 이후 날짜부터 Millisecond Time으로 날짜를 지정할 수 있습니다. ```javascript IBCalendar.create(id, parentEl, { initialDate: 1537302134028 // Tue Sep 18 2018 16:22:14 GMT-0400 }); ``` ## JavaScript Date JavaScript Date 객체로 날짜를 지정할 수 있습니다. Date 객체는 [timeZone](/docs/props/options/time-zone) 옵션의 `local`값으로 지정하여 사용할 수 있습니다. ```javascript IBCalendar.create(id, parentEl, { timeZone: 'local', initialDate: new Date(2018, 8, 1) }); ``` 만일 UTC 시간대를 지정하고자 한다면 다음의 방법을 사용합니다. ```javascript IBCalendar.create(id, parentEl, { timeZone: 'UTC', initialDate: new Date(Date.UTC(2018, 8, 1)) }); ```"
        },
        "url": "docs/appx/date-parsing.html"
      },
      {
        "cid": 174,
        "sid": "named-time-zones",
        "name": "named-time-zones",
        "label": "명명된 시간대",
        "data": {
          "body": "[timeZone](/docs/props/options/time-zone) 옵션에서 사용되는 특정 지역 날짜 목록입니다. ```javascript [ \"Africa/Abidjan\", \"Africa/Accra\", \"Africa/Addis_Ababa\", \"Africa/Algiers\", \"Africa/Asmara\", \"Africa/Bamako\", \"Africa/Bangui\", \"Africa/Banjul\", \"Africa/Bissau\", \"Africa/Blantyre\", \"Africa/Brazzaville\", \"Africa/Bujumbura\", \"Africa/Cairo\", \"Africa/Casablanca\", \"Africa/Ceuta\", \"Africa/Conakry\", \"Africa/Dakar\", \"Africa/Dar_es_Salaam\", \"Africa/Djibouti\", \"Africa/Douala\", \"Africa/El_Aaiun\", \"Africa/Freetown\", \"Africa/Gaborone\", \"Africa/Harare\", \"Africa/Johannesburg\", \"Africa/Juba\", \"Africa/Kampala\", \"Africa/Khartoum\", \"Africa/Kigali\", \"Africa/Kinshasa\", \"Africa/Lagos\", \"Africa/Libreville\", \"Africa/Lome\", \"Africa/Luanda\", \"Africa/Lubumbashi\", \"Africa/Lusaka\", \"Africa/Malabo\", \"Africa/Maputo\", \"Africa/Maseru\", \"Africa/Mbabane\", \"Africa/Mogadishu\", \"Africa/Monrovia\", \"Africa/Nairobi\", \"Africa/Ndjamena\", \"Africa/Niamey\", \"Africa/Nouakchott\", \"Africa/Ouagadougou\", \"Africa/Porto-Novo\", \"Africa/Sao_Tome\", \"Africa/Tripoli\", \"Africa/Tunis\", \"Africa/Windhoek\", \"America/Adak\", \"America/Anchorage\", \"America/Anguilla\", \"America/Antigua\", \"America/Araguaina\", \"America/Argentina/Buenos_Aires\", \"America/Argentina/Catamarca\", \"America/Argentina/Cordoba\", \"America/Argentina/Jujuy\", \"America/Argentina/La_Rioja\", \"America/Argentina/Mendoza\", \"America/Argentina/Rio_Gallegos\", \"America/Argentina/Salta\", \"America/Argentina/San_Juan\", \"America/Argentina/San_Luis\", \"America/Argentina/Tucuman\", \"America/Argentina/Ushuaia\", \"America/Aruba\", \"America/Asuncion\", \"America/Atikokan\", \"America/Bahia\", \"America/Bahia_Banderas\", \"America/Barbados\", \"America/Belem\", \"America/Belize\", \"America/Blanc-Sablon\", \"America/Boa_Vista\", \"America/Bogota\", \"America/Boise\", \"America/Cambridge_Bay\", \"America/Campo_Grande\", \"America/Cancun\", \"America/Caracas\", \"America/Cayenne\", \"America/Cayman\", \"America/Chicago\", \"America/Chihuahua\", \"America/Costa_Rica\", \"America/Creston\", \"America/Cuiaba\", \"America/Curacao\", \"America/Danmarkshavn\", \"America/Dawson\", \"America/Dawson_Creek\", \"America/Denver\", \"America/Detroit\", \"America/Dominica\", \"America/Edmonton\", \"America/Eirunepe\", \"America/El_Salvador\", \"America/Fort_Nelson\", \"America/Fortaleza\", \"America/Glace_Bay\", \"America/Goose_Bay\", \"America/Grand_Turk\", \"America/Grenada\", \"America/Guadeloupe\", \"America/Guatemala\", \"America/Guayaquil\", \"America/Guyana\", \"America/Halifax\", \"America/Havana\", \"America/Hermosillo\", \"America/Indiana/Indianapolis\", \"America/Indiana/Knox\", \"America/Indiana/Marengo\", \"America/Indiana/Petersburg\", \"America/Indiana/Tell_City\", \"America/Indiana/Vevay\", \"America/Indiana/Vincennes\", \"America/Indiana/Winamac\", \"America/Inuvik\", \"America/Iqaluit\", \"America/Jamaica\", \"America/Juneau\", \"America/Kentucky/Louisville\", \"America/Kentucky/Monticello\", \"America/Kralendijk\", \"America/La_Paz\", \"America/Lima\", \"America/Los_Angeles\", \"America/Lower_Princes\", \"America/Maceio\", \"America/Managua\", \"America/Manaus\", \"America/Marigot\", \"America/Martinique\", \"America/Matamoros\", \"America/Mazatlan\", \"America/Menominee\", \"America/Merida\", \"America/Metlakatla\", \"America/Mexico_City\", \"America/Miquelon\", \"America/Moncton\", \"America/Monterrey\", \"America/Montevideo\", \"America/Montserrat\", \"America/Nassau\", \"America/New_York\", \"America/Nipigon\", \"America/Nome\", \"America/Noronha\", \"America/North_Dakota/Beulah\", \"America/North_Dakota/Center\", \"America/North_Dakota/New_Salem\", \"America/Nuuk\", \"America/Ojinaga\", \"America/Panama\", \"America/Pangnirtung\", \"America/Paramaribo\", \"America/Phoenix\", \"America/Port-au-Prince\", \"America/Port_of_Spain\", \"America/Porto_Velho\", \"America/Puerto_Rico\", \"America/Punta_Arenas\", \"America/Rainy_River\", \"America/Rankin_Inlet\", \"America/Recife\", \"America/Regina\", \"America/Resolute\", \"America/Rio_Branco\", \"America/Santarem\", \"America/Santiago\", \"America/Santo_Domingo\", \"America/Sao_Paulo\", \"America/Scoresbysund\", \"America/Sitka\", \"America/St_Barthelemy\", \"America/St_Johns\", \"America/St_Kitts\", \"America/St_Lucia\", \"America/St_Thomas\", \"America/St_Vincent\", \"America/Swift_Current\", \"America/Tegucigalpa\", \"America/Thule\", \"America/Thunder_Bay\", \"America/Tijuana\", \"America/Toronto\", \"America/Tortola\", \"America/Vancouver\", \"America/Whitehorse\", \"America/Winnipeg\", \"America/Yakutat\", \"America/Yellowknife\", \"Antarctica/Casey\", \"Antarctica/Davis\", \"Antarctica/DumontDUrville\", \"Antarctica/Macquarie\", \"Antarctica/Mawson\", \"Antarctica/McMurdo\", \"Antarctica/Palmer\", \"Antarctica/Rothera\", \"Antarctica/Syowa\", \"Antarctica/Troll\", \"Antarctica/Vostok\", \"Arctic/Longyearbyen\", \"Asia/Aden\", \"Asia/Almaty\", \"Asia/Amman\", \"Asia/Anadyr\", \"Asia/Aqtau\", \"Asia/Aqtobe\", \"Asia/Ashgabat\", \"Asia/Atyrau\", \"Asia/Baghdad\", \"Asia/Bahrain\", \"Asia/Baku\", \"Asia/Bangkok\", \"Asia/Barnaul\", \"Asia/Beirut\", \"Asia/Bishkek\", \"Asia/Brunei\", \"Asia/Chita\", \"Asia/Choibalsan\", \"Asia/Colombo\", \"Asia/Damascus\", \"Asia/Dhaka\", \"Asia/Dili\", \"Asia/Dubai\", \"Asia/Dushanbe\", \"Asia/Famagusta\", \"Asia/Gaza\", \"Asia/Hebron\", \"Asia/Ho_Chi_Minh\", \"Asia/Hong_Kong\", \"Asia/Hovd\", \"Asia/Irkutsk\", \"Asia/Jakarta\", \"Asia/Jayapura\", \"Asia/Jerusalem\", \"Asia/Kabul\", \"Asia/Kamchatka\", \"Asia/Karachi\", \"Asia/Kathmandu\", \"Asia/Khandyga\", \"Asia/Kolkata\", \"Asia/Krasnoyarsk\", \"Asia/Kuala_Lumpur\", \"Asia/Kuching\", \"Asia/Kuwait\", \"Asia/Macau\", \"Asia/Magadan\", \"Asia/Makassar\", \"Asia/Manila\", \"Asia/Muscat\", \"Asia/Nicosia\", \"Asia/Novokuznetsk\", \"Asia/Novosibirsk\", \"Asia/Omsk\", \"Asia/Oral\", \"Asia/Phnom_Penh\", \"Asia/Pontianak\", \"Asia/Pyongyang\", \"Asia/Qatar\", \"Asia/Qostanay\", \"Asia/Qyzylorda\", \"Asia/Riyadh\", \"Asia/Sakhalin\", \"Asia/Samarkand\", \"Asia/Seoul\", \"Asia/Shanghai\", \"Asia/Singapore\", \"Asia/Srednekolymsk\", \"Asia/Taipei\", \"Asia/Tashkent\", \"Asia/Tbilisi\", \"Asia/Tehran\", \"Asia/Thimphu\", \"Asia/Tokyo\", \"Asia/Tomsk\", \"Asia/Ulaanbaatar\", \"Asia/Urumqi\", \"Asia/Ust-Nera\", \"Asia/Vientiane\", \"Asia/Vladivostok\", \"Asia/Yakutsk\", \"Asia/Yangon\", \"Asia/Yekaterinburg\", \"Asia/Yerevan\", \"Atlantic/Azores\", \"Atlantic/Bermuda\", \"Atlantic/Canary\", \"Atlantic/Cape_Verde\", \"Atlantic/Faroe\", \"Atlantic/Madeira\", \"Atlantic/Reykjavik\", \"Atlantic/South_Georgia\", \"Atlantic/St_Helena\", \"Atlantic/Stanley\", \"Australia/Adelaide\", \"Australia/Brisbane\", \"Australia/Broken_Hill\", \"Australia/Currie\", \"Australia/Darwin\", \"Australia/Eucla\", \"Australia/Hobart\", \"Australia/Lindeman\", \"Australia/Lord_Howe\", \"Australia/Melbourne\", \"Australia/Perth\", \"Australia/Sydney\", \"Europe/Amsterdam\", \"Europe/Andorra\", \"Europe/Astrakhan\", \"Europe/Athens\", \"Europe/Belgrade\", \"Europe/Berlin\", \"Europe/Bratislava\", \"Europe/Brussels\", \"Europe/Bucharest\", \"Europe/Budapest\", \"Europe/Busingen\", \"Europe/Chisinau\", \"Europe/Copenhagen\", \"Europe/Dublin\", \"Europe/Gibraltar\", \"Europe/Guernsey\", \"Europe/Helsinki\", \"Europe/Isle_of_Man\", \"Europe/Istanbul\", \"Europe/Jersey\", \"Europe/Kaliningrad\", \"Europe/Kiev\", \"Europe/Kirov\", \"Europe/Lisbon\", \"Europe/Ljubljana\", \"Europe/London\", \"Europe/Luxembourg\", \"Europe/Madrid\", \"Europe/Malta\", \"Europe/Mariehamn\", \"Europe/Minsk\", \"Europe/Monaco\", \"Europe/Moscow\", \"Europe/Oslo\", \"Europe/Paris\", \"Europe/Podgorica\", \"Europe/Prague\", \"Europe/Riga\", \"Europe/Rome\", \"Europe/Samara\", \"Europe/San_Marino\", \"Europe/Sarajevo\", \"Europe/Saratov\", \"Europe/Simferopol\", \"Europe/Skopje\", \"Europe/Sofia\", \"Europe/Stockholm\", \"Europe/Tallinn\", \"Europe/Tirane\", \"Europe/Ulyanovsk\", \"Europe/Uzhgorod\", \"Europe/Vaduz\", \"Europe/Vatican\", \"Europe/Vienna\", \"Europe/Vilnius\", \"Europe/Volgograd\", \"Europe/Warsaw\", \"Europe/Zagreb\", \"Europe/Zaporozhye\", \"Europe/Zurich\", \"Indian/Antananarivo\", \"Indian/Chagos\", \"Indian/Christmas\", \"Indian/Cocos\", \"Indian/Comoro\", \"Indian/Kerguelen\", \"Indian/Mahe\", \"Indian/Maldives\", \"Indian/Mauritius\", \"Indian/Mayotte\", \"Indian/Reunion\", \"Pacific/Apia\", \"Pacific/Auckland\", \"Pacific/Bougainville\", \"Pacific/Chatham\", \"Pacific/Chuuk\", \"Pacific/Easter\", \"Pacific/Efate\", \"Pacific/Enderbury\", \"Pacific/Fakaofo\", \"Pacific/Fiji\", \"Pacific/Funafuti\", \"Pacific/Galapagos\", \"Pacific/Gambier\", \"Pacific/Guadalcanal\", \"Pacific/Guam\", \"Pacific/Honolulu\", \"Pacific/Kiritimati\", \"Pacific/Kosrae\", \"Pacific/Kwajalein\", \"Pacific/Majuro\", \"Pacific/Marquesas\", \"Pacific/Midway\", \"Pacific/Nauru\", \"Pacific/Niue\", \"Pacific/Norfolk\", \"Pacific/Noumea\", \"Pacific/Pago_Pago\", \"Pacific/Palau\", \"Pacific/Pitcairn\", \"Pacific/Pohnpei\", \"Pacific/Port_Moresby\", \"Pacific/Rarotonga\", \"Pacific/Saipan\", \"Pacific/Tahiti\", \"Pacific/Tarawa\", \"Pacific/Tongatapu\", \"Pacific/Wake\", \"Pacific/Wallis\" ] ```",
          "see": [
            {
              "label": "timeZones pros",
              "url": "/docs/props/options/time-zone"
            },
            {
              "label": ""
            }
          ]
        },
        "url": "docs/appx/named-time-zones.html"
      }
    ]
  }
];
